// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Reserved resources available to use
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Reservation {
    /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
    pub arn: std::option::Option<std::string::String>,
    /// Number of reserved resources
    pub count: i32,
    /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
    pub currency_code: std::option::Option<std::string::String>,
    /// Lease duration, e.g. '12'
    pub duration: i32,
    /// Units for duration, e.g. 'MONTHS'
    pub duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
    /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
    pub end: std::option::Option<std::string::String>,
    /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
    pub fixed_price: f64,
    /// User specified reservation name
    pub name: std::option::Option<std::string::String>,
    /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
    pub offering_description: std::option::Option<std::string::String>,
    /// Unique offering ID, e.g. '87654321'
    pub offering_id: std::option::Option<std::string::String>,
    /// Offering type, e.g. 'NO_UPFRONT'
    pub offering_type: std::option::Option<crate::model::OfferingType>,
    /// AWS region, e.g. 'us-west-2'
    pub region: std::option::Option<std::string::String>,
    /// Unique reservation ID, e.g. '1234567'
    pub reservation_id: std::option::Option<std::string::String>,
    /// Resource configuration details
    pub resource_specification: std::option::Option<crate::model::ReservationResourceSpecification>,
    /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
    pub start: std::option::Option<std::string::String>,
    /// Current state of reservation, e.g. 'ACTIVE'
    pub state: std::option::Option<crate::model::ReservationState>,
    /// A collection of key-value pairs
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Recurring usage charge for each reserved resource, e.g. '157.0'
    pub usage_price: f64,
}
impl std::fmt::Debug for Reservation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Reservation");
        formatter.field("arn", &self.arn);
        formatter.field("count", &self.count);
        formatter.field("currency_code", &self.currency_code);
        formatter.field("duration", &self.duration);
        formatter.field("duration_units", &self.duration_units);
        formatter.field("end", &self.end);
        formatter.field("fixed_price", &self.fixed_price);
        formatter.field("name", &self.name);
        formatter.field("offering_description", &self.offering_description);
        formatter.field("offering_id", &self.offering_id);
        formatter.field("offering_type", &self.offering_type);
        formatter.field("region", &self.region);
        formatter.field("reservation_id", &self.reservation_id);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("start", &self.start);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("usage_price", &self.usage_price);
        formatter.finish()
    }
}
/// See [`Reservation`](crate::model::Reservation)
pub mod reservation {
    /// A builder for [`Reservation`](crate::model::Reservation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i32>,
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) duration_units: std::option::Option<crate::model::OfferingDurationUnits>,
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) fixed_price: std::option::Option<f64>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) offering_description: std::option::Option<std::string::String>,
        pub(crate) offering_id: std::option::Option<std::string::String>,
        pub(crate) offering_type: std::option::Option<crate::model::OfferingType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) reservation_id: std::option::Option<std::string::String>,
        pub(crate) resource_specification:
            std::option::Option<crate::model::ReservationResourceSpecification>,
        pub(crate) start: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ReservationState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) usage_price: std::option::Option<f64>,
    }
    impl Builder {
        /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// Unique reservation ARN, e.g. 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Number of reserved resources
        pub fn count(mut self, input: i32) -> Self {
            self.count = Some(input);
            self
        }
        /// Number of reserved resources
        pub fn set_count(mut self, input: std::option::Option<i32>) -> Self {
            self.count = input;
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// Lease duration, e.g. '12'
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// Lease duration, e.g. '12'
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn duration_units(mut self, input: crate::model::OfferingDurationUnits) -> Self {
            self.duration_units = Some(input);
            self
        }
        /// Units for duration, e.g. 'MONTHS'
        pub fn set_duration_units(
            mut self,
            input: std::option::Option<crate::model::OfferingDurationUnits>,
        ) -> Self {
            self.duration_units = input;
            self
        }
        /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn fixed_price(mut self, input: f64) -> Self {
            self.fixed_price = Some(input);
            self
        }
        /// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
        pub fn set_fixed_price(mut self, input: std::option::Option<f64>) -> Self {
            self.fixed_price = input;
            self
        }
        /// User specified reservation name
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// User specified reservation name
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn offering_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_description = Some(input.into());
            self
        }
        /// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ in US West (Oregon)'
        pub fn set_offering_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_description = input;
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn offering_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_id = Some(input.into());
            self
        }
        /// Unique offering ID, e.g. '87654321'
        pub fn set_offering_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_id = input;
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn offering_type(mut self, input: crate::model::OfferingType) -> Self {
            self.offering_type = Some(input);
            self
        }
        /// Offering type, e.g. 'NO_UPFRONT'
        pub fn set_offering_type(
            mut self,
            input: std::option::Option<crate::model::OfferingType>,
        ) -> Self {
            self.offering_type = input;
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// AWS region, e.g. 'us-west-2'
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn reservation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_id = Some(input.into());
            self
        }
        /// Unique reservation ID, e.g. '1234567'
        pub fn set_reservation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_id = input;
            self
        }
        /// Resource configuration details
        pub fn resource_specification(
            mut self,
            input: crate::model::ReservationResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// Resource configuration details
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ReservationResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// Reservation UTC start date and time in ISO-8601 format, e.g. '2018-03-01T00:00:00'
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Current state of reservation, e.g. 'ACTIVE'
        pub fn state(mut self, input: crate::model::ReservationState) -> Self {
            self.state = Some(input);
            self
        }
        /// Current state of reservation, e.g. 'ACTIVE'
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::ReservationState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn usage_price(mut self, input: f64) -> Self {
            self.usage_price = Some(input);
            self
        }
        /// Recurring usage charge for each reserved resource, e.g. '157.0'
        pub fn set_usage_price(mut self, input: std::option::Option<f64>) -> Self {
            self.usage_price = input;
            self
        }
        /// Consumes the builder and constructs a [`Reservation`](crate::model::Reservation)
        pub fn build(self) -> crate::model::Reservation {
            crate::model::Reservation {
                arn: self.arn,
                count: self.count.unwrap_or_default(),
                currency_code: self.currency_code,
                duration: self.duration.unwrap_or_default(),
                duration_units: self.duration_units,
                end: self.end,
                fixed_price: self.fixed_price.unwrap_or_default(),
                name: self.name,
                offering_description: self.offering_description,
                offering_id: self.offering_id,
                offering_type: self.offering_type,
                region: self.region,
                reservation_id: self.reservation_id,
                resource_specification: self.resource_specification,
                start: self.start,
                state: self.state,
                tags: self.tags,
                usage_price: self.usage_price.unwrap_or_default(),
            }
        }
    }
}
impl Reservation {
    /// Creates a new builder-style object to manufacture [`Reservation`](crate::model::Reservation)
    pub fn builder() -> crate::model::reservation::Builder {
        crate::model::reservation::Builder::default()
    }
}

/// Current reservation state
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReservationState::Active,
            "CANCELED" => ReservationState::Canceled,
            "DELETED" => ReservationState::Deleted,
            "EXPIRED" => ReservationState::Expired,
            other => ReservationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationState::from(s))
    }
}
impl ReservationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationState::Active => "ACTIVE",
            ReservationState::Canceled => "CANCELED",
            ReservationState::Deleted => "DELETED",
            ReservationState::Expired => "EXPIRED",
            ReservationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CANCELED", "DELETED", "EXPIRED"]
    }
}
impl AsRef<str> for ReservationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Resource configuration (codec, resolution, bitrate, ...)
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationResourceSpecification {
    /// Channel class, e.g. 'STANDARD'
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// Codec, e.g. 'AVC'
    pub codec: std::option::Option<crate::model::ReservationCodec>,
    /// Maximum bitrate, e.g. 'MAX_20_MBPS'
    pub maximum_bitrate: std::option::Option<crate::model::ReservationMaximumBitrate>,
    /// Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
    pub maximum_framerate: std::option::Option<crate::model::ReservationMaximumFramerate>,
    /// Resolution, e.g. 'HD'
    pub resolution: std::option::Option<crate::model::ReservationResolution>,
    /// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
    pub resource_type: std::option::Option<crate::model::ReservationResourceType>,
    /// Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
    pub special_feature: std::option::Option<crate::model::ReservationSpecialFeature>,
    /// Video quality, e.g. 'STANDARD' (Outputs only)
    pub video_quality: std::option::Option<crate::model::ReservationVideoQuality>,
}
impl std::fmt::Debug for ReservationResourceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationResourceSpecification");
        formatter.field("channel_class", &self.channel_class);
        formatter.field("codec", &self.codec);
        formatter.field("maximum_bitrate", &self.maximum_bitrate);
        formatter.field("maximum_framerate", &self.maximum_framerate);
        formatter.field("resolution", &self.resolution);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("special_feature", &self.special_feature);
        formatter.field("video_quality", &self.video_quality);
        formatter.finish()
    }
}
/// See [`ReservationResourceSpecification`](crate::model::ReservationResourceSpecification)
pub mod reservation_resource_specification {
    /// A builder for [`ReservationResourceSpecification`](crate::model::ReservationResourceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) codec: std::option::Option<crate::model::ReservationCodec>,
        pub(crate) maximum_bitrate: std::option::Option<crate::model::ReservationMaximumBitrate>,
        pub(crate) maximum_framerate:
            std::option::Option<crate::model::ReservationMaximumFramerate>,
        pub(crate) resolution: std::option::Option<crate::model::ReservationResolution>,
        pub(crate) resource_type: std::option::Option<crate::model::ReservationResourceType>,
        pub(crate) special_feature: std::option::Option<crate::model::ReservationSpecialFeature>,
        pub(crate) video_quality: std::option::Option<crate::model::ReservationVideoQuality>,
    }
    impl Builder {
        /// Channel class, e.g. 'STANDARD'
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// Channel class, e.g. 'STANDARD'
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Codec, e.g. 'AVC'
        pub fn codec(mut self, input: crate::model::ReservationCodec) -> Self {
            self.codec = Some(input);
            self
        }
        /// Codec, e.g. 'AVC'
        pub fn set_codec(
            mut self,
            input: std::option::Option<crate::model::ReservationCodec>,
        ) -> Self {
            self.codec = input;
            self
        }
        /// Maximum bitrate, e.g. 'MAX_20_MBPS'
        pub fn maximum_bitrate(mut self, input: crate::model::ReservationMaximumBitrate) -> Self {
            self.maximum_bitrate = Some(input);
            self
        }
        /// Maximum bitrate, e.g. 'MAX_20_MBPS'
        pub fn set_maximum_bitrate(
            mut self,
            input: std::option::Option<crate::model::ReservationMaximumBitrate>,
        ) -> Self {
            self.maximum_bitrate = input;
            self
        }
        /// Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
        pub fn maximum_framerate(
            mut self,
            input: crate::model::ReservationMaximumFramerate,
        ) -> Self {
            self.maximum_framerate = Some(input);
            self
        }
        /// Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
        pub fn set_maximum_framerate(
            mut self,
            input: std::option::Option<crate::model::ReservationMaximumFramerate>,
        ) -> Self {
            self.maximum_framerate = input;
            self
        }
        /// Resolution, e.g. 'HD'
        pub fn resolution(mut self, input: crate::model::ReservationResolution) -> Self {
            self.resolution = Some(input);
            self
        }
        /// Resolution, e.g. 'HD'
        pub fn set_resolution(
            mut self,
            input: std::option::Option<crate::model::ReservationResolution>,
        ) -> Self {
            self.resolution = input;
            self
        }
        /// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn resource_type(mut self, input: crate::model::ReservationResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ReservationResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
        pub fn special_feature(mut self, input: crate::model::ReservationSpecialFeature) -> Self {
            self.special_feature = Some(input);
            self
        }
        /// Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
        pub fn set_special_feature(
            mut self,
            input: std::option::Option<crate::model::ReservationSpecialFeature>,
        ) -> Self {
            self.special_feature = input;
            self
        }
        /// Video quality, e.g. 'STANDARD' (Outputs only)
        pub fn video_quality(mut self, input: crate::model::ReservationVideoQuality) -> Self {
            self.video_quality = Some(input);
            self
        }
        /// Video quality, e.g. 'STANDARD' (Outputs only)
        pub fn set_video_quality(
            mut self,
            input: std::option::Option<crate::model::ReservationVideoQuality>,
        ) -> Self {
            self.video_quality = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationResourceSpecification`](crate::model::ReservationResourceSpecification)
        pub fn build(self) -> crate::model::ReservationResourceSpecification {
            crate::model::ReservationResourceSpecification {
                channel_class: self.channel_class,
                codec: self.codec,
                maximum_bitrate: self.maximum_bitrate,
                maximum_framerate: self.maximum_framerate,
                resolution: self.resolution,
                resource_type: self.resource_type,
                special_feature: self.special_feature,
                video_quality: self.video_quality,
            }
        }
    }
}
impl ReservationResourceSpecification {
    /// Creates a new builder-style object to manufacture [`ReservationResourceSpecification`](crate::model::ReservationResourceSpecification)
    pub fn builder() -> crate::model::reservation_resource_specification::Builder {
        crate::model::reservation_resource_specification::Builder::default()
    }
}

/// Video quality, e.g. 'STANDARD' (Outputs only)
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationVideoQuality {
    #[allow(missing_docs)] // documentation missing in model
    Enhanced,
    #[allow(missing_docs)] // documentation missing in model
    Premium,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationVideoQuality {
    fn from(s: &str) -> Self {
        match s {
            "ENHANCED" => ReservationVideoQuality::Enhanced,
            "PREMIUM" => ReservationVideoQuality::Premium,
            "STANDARD" => ReservationVideoQuality::Standard,
            other => ReservationVideoQuality::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationVideoQuality {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationVideoQuality::from(s))
    }
}
impl ReservationVideoQuality {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationVideoQuality::Enhanced => "ENHANCED",
            ReservationVideoQuality::Premium => "PREMIUM",
            ReservationVideoQuality::Standard => "STANDARD",
            ReservationVideoQuality::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENHANCED", "PREMIUM", "STANDARD"]
    }
}
impl AsRef<str> for ReservationVideoQuality {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Special features, 'ADVANCED_AUDIO' 'AUDIO_NORMALIZATION' 'MGHD' or 'MGUHD'
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationSpecialFeature {
    #[allow(missing_docs)] // documentation missing in model
    AdvancedAudio,
    #[allow(missing_docs)] // documentation missing in model
    AudioNormalization,
    #[allow(missing_docs)] // documentation missing in model
    Mghd,
    #[allow(missing_docs)] // documentation missing in model
    Mguhd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationSpecialFeature {
    fn from(s: &str) -> Self {
        match s {
            "ADVANCED_AUDIO" => ReservationSpecialFeature::AdvancedAudio,
            "AUDIO_NORMALIZATION" => ReservationSpecialFeature::AudioNormalization,
            "MGHD" => ReservationSpecialFeature::Mghd,
            "MGUHD" => ReservationSpecialFeature::Mguhd,
            other => ReservationSpecialFeature::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationSpecialFeature {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationSpecialFeature::from(s))
    }
}
impl ReservationSpecialFeature {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationSpecialFeature::AdvancedAudio => "ADVANCED_AUDIO",
            ReservationSpecialFeature::AudioNormalization => "AUDIO_NORMALIZATION",
            ReservationSpecialFeature::Mghd => "MGHD",
            ReservationSpecialFeature::Mguhd => "MGUHD",
            ReservationSpecialFeature::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADVANCED_AUDIO", "AUDIO_NORMALIZATION", "MGHD", "MGUHD"]
    }
}
impl AsRef<str> for ReservationSpecialFeature {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationResourceType {
    #[allow(missing_docs)] // documentation missing in model
    Channel,
    #[allow(missing_docs)] // documentation missing in model
    Input,
    #[allow(missing_docs)] // documentation missing in model
    Multiplex,
    #[allow(missing_docs)] // documentation missing in model
    Output,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationResourceType {
    fn from(s: &str) -> Self {
        match s {
            "CHANNEL" => ReservationResourceType::Channel,
            "INPUT" => ReservationResourceType::Input,
            "MULTIPLEX" => ReservationResourceType::Multiplex,
            "OUTPUT" => ReservationResourceType::Output,
            other => ReservationResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationResourceType::from(s))
    }
}
impl ReservationResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationResourceType::Channel => "CHANNEL",
            ReservationResourceType::Input => "INPUT",
            ReservationResourceType::Multiplex => "MULTIPLEX",
            ReservationResourceType::Output => "OUTPUT",
            ReservationResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CHANNEL", "INPUT", "MULTIPLEX", "OUTPUT"]
    }
}
impl AsRef<str> for ReservationResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Resolution based on lines of vertical resolution; SD is less than 720 lines, HD is 720 to 1080 lines, FHD is 1080 lines, UHD is greater than 1080 lines
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationResolution {
    #[allow(missing_docs)] // documentation missing in model
    Fhd,
    #[allow(missing_docs)] // documentation missing in model
    Hd,
    #[allow(missing_docs)] // documentation missing in model
    Sd,
    #[allow(missing_docs)] // documentation missing in model
    Uhd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationResolution {
    fn from(s: &str) -> Self {
        match s {
            "FHD" => ReservationResolution::Fhd,
            "HD" => ReservationResolution::Hd,
            "SD" => ReservationResolution::Sd,
            "UHD" => ReservationResolution::Uhd,
            other => ReservationResolution::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationResolution {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationResolution::from(s))
    }
}
impl ReservationResolution {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationResolution::Fhd => "FHD",
            ReservationResolution::Hd => "HD",
            ReservationResolution::Sd => "SD",
            ReservationResolution::Uhd => "UHD",
            ReservationResolution::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FHD", "HD", "SD", "UHD"]
    }
}
impl AsRef<str> for ReservationResolution {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Maximum framerate in frames per second (Outputs only)
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationMaximumFramerate {
    #[allow(missing_docs)] // documentation missing in model
    Max30Fps,
    #[allow(missing_docs)] // documentation missing in model
    Max60Fps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationMaximumFramerate {
    fn from(s: &str) -> Self {
        match s {
            "MAX_30_FPS" => ReservationMaximumFramerate::Max30Fps,
            "MAX_60_FPS" => ReservationMaximumFramerate::Max60Fps,
            other => ReservationMaximumFramerate::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationMaximumFramerate {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationMaximumFramerate::from(s))
    }
}
impl ReservationMaximumFramerate {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationMaximumFramerate::Max30Fps => "MAX_30_FPS",
            ReservationMaximumFramerate::Max60Fps => "MAX_60_FPS",
            ReservationMaximumFramerate::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAX_30_FPS", "MAX_60_FPS"]
    }
}
impl AsRef<str> for ReservationMaximumFramerate {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Maximum bitrate in megabits per second
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationMaximumBitrate {
    #[allow(missing_docs)] // documentation missing in model
    Max10Mbps,
    #[allow(missing_docs)] // documentation missing in model
    Max20Mbps,
    #[allow(missing_docs)] // documentation missing in model
    Max50Mbps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationMaximumBitrate {
    fn from(s: &str) -> Self {
        match s {
            "MAX_10_MBPS" => ReservationMaximumBitrate::Max10Mbps,
            "MAX_20_MBPS" => ReservationMaximumBitrate::Max20Mbps,
            "MAX_50_MBPS" => ReservationMaximumBitrate::Max50Mbps,
            other => ReservationMaximumBitrate::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationMaximumBitrate {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationMaximumBitrate::from(s))
    }
}
impl ReservationMaximumBitrate {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationMaximumBitrate::Max10Mbps => "MAX_10_MBPS",
            ReservationMaximumBitrate::Max20Mbps => "MAX_20_MBPS",
            ReservationMaximumBitrate::Max50Mbps => "MAX_50_MBPS",
            ReservationMaximumBitrate::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAX_10_MBPS", "MAX_20_MBPS", "MAX_50_MBPS"]
    }
}
impl AsRef<str> for ReservationMaximumBitrate {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Codec, 'MPEG2', 'AVC', 'HEVC', or 'AUDIO'
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationCodec {
    #[allow(missing_docs)] // documentation missing in model
    Audio,
    #[allow(missing_docs)] // documentation missing in model
    Avc,
    #[allow(missing_docs)] // documentation missing in model
    Hevc,
    #[allow(missing_docs)] // documentation missing in model
    Link,
    #[allow(missing_docs)] // documentation missing in model
    Mpeg2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationCodec {
    fn from(s: &str) -> Self {
        match s {
            "AUDIO" => ReservationCodec::Audio,
            "AVC" => ReservationCodec::Avc,
            "HEVC" => ReservationCodec::Hevc,
            "LINK" => ReservationCodec::Link,
            "MPEG2" => ReservationCodec::Mpeg2,
            other => ReservationCodec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationCodec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationCodec::from(s))
    }
}
impl ReservationCodec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationCodec::Audio => "AUDIO",
            ReservationCodec::Avc => "AVC",
            ReservationCodec::Hevc => "HEVC",
            ReservationCodec::Link => "LINK",
            ReservationCodec::Mpeg2 => "MPEG2",
            ReservationCodec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUDIO", "AVC", "HEVC", "LINK", "MPEG2"]
    }
}
impl AsRef<str> for ReservationCodec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A standard channel has two encoding pipelines and a single pipeline channel only has one.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelClass {
    #[allow(missing_docs)] // documentation missing in model
    SinglePipeline,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelClass {
    fn from(s: &str) -> Self {
        match s {
            "SINGLE_PIPELINE" => ChannelClass::SinglePipeline,
            "STANDARD" => ChannelClass::Standard,
            other => ChannelClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelClass::from(s))
    }
}
impl ChannelClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelClass::SinglePipeline => "SINGLE_PIPELINE",
            ChannelClass::Standard => "STANDARD",
            ChannelClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SINGLE_PIPELINE", "STANDARD"]
    }
}
impl AsRef<str> for ChannelClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Offering type, e.g. 'NO_UPFRONT'
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OfferingType {
    #[allow(missing_docs)] // documentation missing in model
    NoUpfront,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OfferingType {
    fn from(s: &str) -> Self {
        match s {
            "NO_UPFRONT" => OfferingType::NoUpfront,
            other => OfferingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OfferingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OfferingType::from(s))
    }
}
impl OfferingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OfferingType::NoUpfront => "NO_UPFRONT",
            OfferingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_UPFRONT"]
    }
}
impl AsRef<str> for OfferingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Units for duration, e.g. 'MONTHS'
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OfferingDurationUnits {
    #[allow(missing_docs)] // documentation missing in model
    Months,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OfferingDurationUnits {
    fn from(s: &str) -> Self {
        match s {
            "MONTHS" => OfferingDurationUnits::Months,
            other => OfferingDurationUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OfferingDurationUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OfferingDurationUnits::from(s))
    }
}
impl OfferingDurationUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OfferingDurationUnits::Months => "MONTHS",
            OfferingDurationUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MONTHS"]
    }
}
impl AsRef<str> for OfferingDurationUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Placeholder documentation for ValidationError
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationError {
    /// Path to the source of the error.
    pub element_path: std::option::Option<std::string::String>,
    /// The error message.
    pub error_message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationError");
        formatter.field("element_path", &self.element_path);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ValidationError`](crate::model::ValidationError)
pub mod validation_error {
    /// A builder for [`ValidationError`](crate::model::ValidationError)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) element_path: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Path to the source of the error.
        pub fn element_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.element_path = Some(input.into());
            self
        }
        /// Path to the source of the error.
        pub fn set_element_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.element_path = input;
            self
        }
        /// The error message.
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// The error message.
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationError`](crate::model::ValidationError)
        pub fn build(self) -> crate::model::ValidationError {
            crate::model::ValidationError {
                element_path: self.element_path,
                error_message: self.error_message,
            }
        }
    }
}
impl ValidationError {
    /// Creates a new builder-style object to manufacture [`ValidationError`](crate::model::ValidationError)
    pub fn builder() -> crate::model::validation_error::Builder {
        crate::model::validation_error::Builder::default()
    }
}

/// The multiplex program object.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexProgram {
    /// The MediaLive channel associated with the program.
    pub channel_id: std::option::Option<std::string::String>,
    /// The settings for this multiplex program.
    pub multiplex_program_settings: std::option::Option<crate::model::MultiplexProgramSettings>,
    /// The packet identifier map for this multiplex program.
    pub packet_identifiers_map:
        std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
    /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
    pub pipeline_details:
        std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
    /// The name of the multiplex program.
    pub program_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MultiplexProgram {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexProgram");
        formatter.field("channel_id", &self.channel_id);
        formatter.field(
            "multiplex_program_settings",
            &self.multiplex_program_settings,
        );
        formatter.field("packet_identifiers_map", &self.packet_identifiers_map);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("program_name", &self.program_name);
        formatter.finish()
    }
}
/// See [`MultiplexProgram`](crate::model::MultiplexProgram)
pub mod multiplex_program {
    /// A builder for [`MultiplexProgram`](crate::model::MultiplexProgram)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_id: std::option::Option<std::string::String>,
        pub(crate) multiplex_program_settings:
            std::option::Option<crate::model::MultiplexProgramSettings>,
        pub(crate) packet_identifiers_map:
            std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
        pub(crate) program_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The MediaLive channel associated with the program.
        pub fn channel_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_id = Some(input.into());
            self
        }
        /// The MediaLive channel associated with the program.
        pub fn set_channel_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.channel_id = input;
            self
        }
        /// The settings for this multiplex program.
        pub fn multiplex_program_settings(
            mut self,
            input: crate::model::MultiplexProgramSettings,
        ) -> Self {
            self.multiplex_program_settings = Some(input);
            self
        }
        /// The settings for this multiplex program.
        pub fn set_multiplex_program_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramSettings>,
        ) -> Self {
            self.multiplex_program_settings = input;
            self
        }
        /// The packet identifier map for this multiplex program.
        pub fn packet_identifiers_map(
            mut self,
            input: crate::model::MultiplexProgramPacketIdentifiersMap,
        ) -> Self {
            self.packet_identifiers_map = Some(input);
            self
        }
        /// The packet identifier map for this multiplex program.
        pub fn set_packet_identifiers_map(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramPacketIdentifiersMap>,
        ) -> Self {
            self.packet_identifiers_map = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        pub fn pipeline_details(
            mut self,
            input: impl Into<crate::model::MultiplexProgramPipelineDetail>,
        ) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Contains information about the current sources for the specified program in the specified multiplex. Keep in mind that each multiplex pipeline connects to both pipelines in a given source channel (the channel identified by the program). But only one of those channel pipelines is ever active at one time.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexProgramPipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The name of the multiplex program.
        pub fn program_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.program_name = Some(input.into());
            self
        }
        /// The name of the multiplex program.
        pub fn set_program_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.program_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexProgram`](crate::model::MultiplexProgram)
        pub fn build(self) -> crate::model::MultiplexProgram {
            crate::model::MultiplexProgram {
                channel_id: self.channel_id,
                multiplex_program_settings: self.multiplex_program_settings,
                packet_identifiers_map: self.packet_identifiers_map,
                pipeline_details: self.pipeline_details,
                program_name: self.program_name,
            }
        }
    }
}
impl MultiplexProgram {
    /// Creates a new builder-style object to manufacture [`MultiplexProgram`](crate::model::MultiplexProgram)
    pub fn builder() -> crate::model::multiplex_program::Builder {
        crate::model::multiplex_program::Builder::default()
    }
}

/// The current source for one of the pipelines in the multiplex.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexProgramPipelineDetail {
    /// Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
    pub active_channel_pipeline: std::option::Option<std::string::String>,
    /// Identifies a specific pipeline in the multiplex.
    pub pipeline_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MultiplexProgramPipelineDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexProgramPipelineDetail");
        formatter.field("active_channel_pipeline", &self.active_channel_pipeline);
        formatter.field("pipeline_id", &self.pipeline_id);
        formatter.finish()
    }
}
/// See [`MultiplexProgramPipelineDetail`](crate::model::MultiplexProgramPipelineDetail)
pub mod multiplex_program_pipeline_detail {
    /// A builder for [`MultiplexProgramPipelineDetail`](crate::model::MultiplexProgramPipelineDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_channel_pipeline: std::option::Option<std::string::String>,
        pub(crate) pipeline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
        pub fn active_channel_pipeline(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_channel_pipeline = Some(input.into());
            self
        }
        /// Identifies the channel pipeline that is currently active for the pipeline (identified by PipelineId) in the multiplex.
        pub fn set_active_channel_pipeline(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_channel_pipeline = input;
            self
        }
        /// Identifies a specific pipeline in the multiplex.
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_id = Some(input.into());
            self
        }
        /// Identifies a specific pipeline in the multiplex.
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexProgramPipelineDetail`](crate::model::MultiplexProgramPipelineDetail)
        pub fn build(self) -> crate::model::MultiplexProgramPipelineDetail {
            crate::model::MultiplexProgramPipelineDetail {
                active_channel_pipeline: self.active_channel_pipeline,
                pipeline_id: self.pipeline_id,
            }
        }
    }
}
impl MultiplexProgramPipelineDetail {
    /// Creates a new builder-style object to manufacture [`MultiplexProgramPipelineDetail`](crate::model::MultiplexProgramPipelineDetail)
    pub fn builder() -> crate::model::multiplex_program_pipeline_detail::Builder {
        crate::model::multiplex_program_pipeline_detail::Builder::default()
    }
}

/// Packet identifiers map for a given Multiplex program.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexProgramPacketIdentifiersMap {
    /// Placeholder documentation for __listOf__integer
    pub audio_pids: std::option::Option<std::vec::Vec<i32>>,
    /// Placeholder documentation for __listOf__integer
    pub dvb_sub_pids: std::option::Option<std::vec::Vec<i32>>,
    /// Placeholder documentation for __integer
    pub dvb_teletext_pid: i32,
    /// Placeholder documentation for __integer
    pub etv_platform_pid: i32,
    /// Placeholder documentation for __integer
    pub etv_signal_pid: i32,
    /// Placeholder documentation for __listOf__integer
    pub klv_data_pids: std::option::Option<std::vec::Vec<i32>>,
    /// Placeholder documentation for __integer
    pub pcr_pid: i32,
    /// Placeholder documentation for __integer
    pub pmt_pid: i32,
    /// Placeholder documentation for __integer
    pub private_metadata_pid: i32,
    /// Placeholder documentation for __listOf__integer
    pub scte27_pids: std::option::Option<std::vec::Vec<i32>>,
    /// Placeholder documentation for __integer
    pub scte35_pid: i32,
    /// Placeholder documentation for __integer
    pub timed_metadata_pid: i32,
    /// Placeholder documentation for __integer
    pub video_pid: i32,
}
impl std::fmt::Debug for MultiplexProgramPacketIdentifiersMap {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexProgramPacketIdentifiersMap");
        formatter.field("audio_pids", &self.audio_pids);
        formatter.field("dvb_sub_pids", &self.dvb_sub_pids);
        formatter.field("dvb_teletext_pid", &self.dvb_teletext_pid);
        formatter.field("etv_platform_pid", &self.etv_platform_pid);
        formatter.field("etv_signal_pid", &self.etv_signal_pid);
        formatter.field("klv_data_pids", &self.klv_data_pids);
        formatter.field("pcr_pid", &self.pcr_pid);
        formatter.field("pmt_pid", &self.pmt_pid);
        formatter.field("private_metadata_pid", &self.private_metadata_pid);
        formatter.field("scte27_pids", &self.scte27_pids);
        formatter.field("scte35_pid", &self.scte35_pid);
        formatter.field("timed_metadata_pid", &self.timed_metadata_pid);
        formatter.field("video_pid", &self.video_pid);
        formatter.finish()
    }
}
/// See [`MultiplexProgramPacketIdentifiersMap`](crate::model::MultiplexProgramPacketIdentifiersMap)
pub mod multiplex_program_packet_identifiers_map {
    /// A builder for [`MultiplexProgramPacketIdentifiersMap`](crate::model::MultiplexProgramPacketIdentifiersMap)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_pids: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) dvb_sub_pids: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) dvb_teletext_pid: std::option::Option<i32>,
        pub(crate) etv_platform_pid: std::option::Option<i32>,
        pub(crate) etv_signal_pid: std::option::Option<i32>,
        pub(crate) klv_data_pids: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) pcr_pid: std::option::Option<i32>,
        pub(crate) pmt_pid: std::option::Option<i32>,
        pub(crate) private_metadata_pid: std::option::Option<i32>,
        pub(crate) scte27_pids: std::option::Option<std::vec::Vec<i32>>,
        pub(crate) scte35_pid: std::option::Option<i32>,
        pub(crate) timed_metadata_pid: std::option::Option<i32>,
        pub(crate) video_pid: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `audio_pids`.
        ///
        /// To override the contents of this collection use [`set_audio_pids`](Self::set_audio_pids).
        ///
        /// Placeholder documentation for __listOf__integer
        pub fn audio_pids(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.audio_pids.unwrap_or_default();
            v.push(input.into());
            self.audio_pids = Some(v);
            self
        }
        /// Placeholder documentation for __listOf__integer
        pub fn set_audio_pids(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.audio_pids = input;
            self
        }
        /// Appends an item to `dvb_sub_pids`.
        ///
        /// To override the contents of this collection use [`set_dvb_sub_pids`](Self::set_dvb_sub_pids).
        ///
        /// Placeholder documentation for __listOf__integer
        pub fn dvb_sub_pids(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.dvb_sub_pids.unwrap_or_default();
            v.push(input.into());
            self.dvb_sub_pids = Some(v);
            self
        }
        /// Placeholder documentation for __listOf__integer
        pub fn set_dvb_sub_pids(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.dvb_sub_pids = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn dvb_teletext_pid(mut self, input: i32) -> Self {
            self.dvb_teletext_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_dvb_teletext_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.dvb_teletext_pid = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn etv_platform_pid(mut self, input: i32) -> Self {
            self.etv_platform_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_etv_platform_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.etv_platform_pid = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn etv_signal_pid(mut self, input: i32) -> Self {
            self.etv_signal_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_etv_signal_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.etv_signal_pid = input;
            self
        }
        /// Appends an item to `klv_data_pids`.
        ///
        /// To override the contents of this collection use [`set_klv_data_pids`](Self::set_klv_data_pids).
        ///
        /// Placeholder documentation for __listOf__integer
        pub fn klv_data_pids(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.klv_data_pids.unwrap_or_default();
            v.push(input.into());
            self.klv_data_pids = Some(v);
            self
        }
        /// Placeholder documentation for __listOf__integer
        pub fn set_klv_data_pids(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.klv_data_pids = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn pcr_pid(mut self, input: i32) -> Self {
            self.pcr_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_pcr_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.pcr_pid = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn pmt_pid(mut self, input: i32) -> Self {
            self.pmt_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_pmt_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.pmt_pid = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn private_metadata_pid(mut self, input: i32) -> Self {
            self.private_metadata_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_private_metadata_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.private_metadata_pid = input;
            self
        }
        /// Appends an item to `scte27_pids`.
        ///
        /// To override the contents of this collection use [`set_scte27_pids`](Self::set_scte27_pids).
        ///
        /// Placeholder documentation for __listOf__integer
        pub fn scte27_pids(mut self, input: impl Into<i32>) -> Self {
            let mut v = self.scte27_pids.unwrap_or_default();
            v.push(input.into());
            self.scte27_pids = Some(v);
            self
        }
        /// Placeholder documentation for __listOf__integer
        pub fn set_scte27_pids(mut self, input: std::option::Option<std::vec::Vec<i32>>) -> Self {
            self.scte27_pids = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn scte35_pid(mut self, input: i32) -> Self {
            self.scte35_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_scte35_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.scte35_pid = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn timed_metadata_pid(mut self, input: i32) -> Self {
            self.timed_metadata_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_timed_metadata_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.timed_metadata_pid = input;
            self
        }
        /// Placeholder documentation for __integer
        pub fn video_pid(mut self, input: i32) -> Self {
            self.video_pid = Some(input);
            self
        }
        /// Placeholder documentation for __integer
        pub fn set_video_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.video_pid = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexProgramPacketIdentifiersMap`](crate::model::MultiplexProgramPacketIdentifiersMap)
        pub fn build(self) -> crate::model::MultiplexProgramPacketIdentifiersMap {
            crate::model::MultiplexProgramPacketIdentifiersMap {
                audio_pids: self.audio_pids,
                dvb_sub_pids: self.dvb_sub_pids,
                dvb_teletext_pid: self.dvb_teletext_pid.unwrap_or_default(),
                etv_platform_pid: self.etv_platform_pid.unwrap_or_default(),
                etv_signal_pid: self.etv_signal_pid.unwrap_or_default(),
                klv_data_pids: self.klv_data_pids,
                pcr_pid: self.pcr_pid.unwrap_or_default(),
                pmt_pid: self.pmt_pid.unwrap_or_default(),
                private_metadata_pid: self.private_metadata_pid.unwrap_or_default(),
                scte27_pids: self.scte27_pids,
                scte35_pid: self.scte35_pid.unwrap_or_default(),
                timed_metadata_pid: self.timed_metadata_pid.unwrap_or_default(),
                video_pid: self.video_pid.unwrap_or_default(),
            }
        }
    }
}
impl MultiplexProgramPacketIdentifiersMap {
    /// Creates a new builder-style object to manufacture [`MultiplexProgramPacketIdentifiersMap`](crate::model::MultiplexProgramPacketIdentifiersMap)
    pub fn builder() -> crate::model::multiplex_program_packet_identifiers_map::Builder {
        crate::model::multiplex_program_packet_identifiers_map::Builder::default()
    }
}

/// Multiplex Program settings configuration.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexProgramSettings {
    /// Indicates which pipeline is preferred by the multiplex for program ingest.
    pub preferred_channel_pipeline: std::option::Option<crate::model::PreferredChannelPipeline>,
    /// Unique program number.
    pub program_number: i32,
    /// Transport stream service descriptor configuration for the Multiplex program.
    pub service_descriptor: std::option::Option<crate::model::MultiplexProgramServiceDescriptor>,
    /// Program video settings configuration.
    pub video_settings: std::option::Option<crate::model::MultiplexVideoSettings>,
}
impl std::fmt::Debug for MultiplexProgramSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexProgramSettings");
        formatter.field(
            "preferred_channel_pipeline",
            &self.preferred_channel_pipeline,
        );
        formatter.field("program_number", &self.program_number);
        formatter.field("service_descriptor", &self.service_descriptor);
        formatter.field("video_settings", &self.video_settings);
        formatter.finish()
    }
}
/// See [`MultiplexProgramSettings`](crate::model::MultiplexProgramSettings)
pub mod multiplex_program_settings {
    /// A builder for [`MultiplexProgramSettings`](crate::model::MultiplexProgramSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preferred_channel_pipeline:
            std::option::Option<crate::model::PreferredChannelPipeline>,
        pub(crate) program_number: std::option::Option<i32>,
        pub(crate) service_descriptor:
            std::option::Option<crate::model::MultiplexProgramServiceDescriptor>,
        pub(crate) video_settings: std::option::Option<crate::model::MultiplexVideoSettings>,
    }
    impl Builder {
        /// Indicates which pipeline is preferred by the multiplex for program ingest.
        pub fn preferred_channel_pipeline(
            mut self,
            input: crate::model::PreferredChannelPipeline,
        ) -> Self {
            self.preferred_channel_pipeline = Some(input);
            self
        }
        /// Indicates which pipeline is preferred by the multiplex for program ingest.
        pub fn set_preferred_channel_pipeline(
            mut self,
            input: std::option::Option<crate::model::PreferredChannelPipeline>,
        ) -> Self {
            self.preferred_channel_pipeline = input;
            self
        }
        /// Unique program number.
        pub fn program_number(mut self, input: i32) -> Self {
            self.program_number = Some(input);
            self
        }
        /// Unique program number.
        pub fn set_program_number(mut self, input: std::option::Option<i32>) -> Self {
            self.program_number = input;
            self
        }
        /// Transport stream service descriptor configuration for the Multiplex program.
        pub fn service_descriptor(
            mut self,
            input: crate::model::MultiplexProgramServiceDescriptor,
        ) -> Self {
            self.service_descriptor = Some(input);
            self
        }
        /// Transport stream service descriptor configuration for the Multiplex program.
        pub fn set_service_descriptor(
            mut self,
            input: std::option::Option<crate::model::MultiplexProgramServiceDescriptor>,
        ) -> Self {
            self.service_descriptor = input;
            self
        }
        /// Program video settings configuration.
        pub fn video_settings(mut self, input: crate::model::MultiplexVideoSettings) -> Self {
            self.video_settings = Some(input);
            self
        }
        /// Program video settings configuration.
        pub fn set_video_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexVideoSettings>,
        ) -> Self {
            self.video_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexProgramSettings`](crate::model::MultiplexProgramSettings)
        pub fn build(self) -> crate::model::MultiplexProgramSettings {
            crate::model::MultiplexProgramSettings {
                preferred_channel_pipeline: self.preferred_channel_pipeline,
                program_number: self.program_number.unwrap_or_default(),
                service_descriptor: self.service_descriptor,
                video_settings: self.video_settings,
            }
        }
    }
}
impl MultiplexProgramSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexProgramSettings`](crate::model::MultiplexProgramSettings)
    pub fn builder() -> crate::model::multiplex_program_settings::Builder {
        crate::model::multiplex_program_settings::Builder::default()
    }
}

/// The video configuration for each program in a multiplex.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexVideoSettings {
    /// The constant bitrate configuration for the video encode.
    /// When this field is defined, StatmuxSettings must be undefined.
    pub constant_bitrate: i32,
    /// Statmux rate control settings.
    /// When this field is defined, ConstantBitrate must be undefined.
    pub statmux_settings: std::option::Option<crate::model::MultiplexStatmuxVideoSettings>,
}
impl std::fmt::Debug for MultiplexVideoSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexVideoSettings");
        formatter.field("constant_bitrate", &self.constant_bitrate);
        formatter.field("statmux_settings", &self.statmux_settings);
        formatter.finish()
    }
}
/// See [`MultiplexVideoSettings`](crate::model::MultiplexVideoSettings)
pub mod multiplex_video_settings {
    /// A builder for [`MultiplexVideoSettings`](crate::model::MultiplexVideoSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) constant_bitrate: std::option::Option<i32>,
        pub(crate) statmux_settings:
            std::option::Option<crate::model::MultiplexStatmuxVideoSettings>,
    }
    impl Builder {
        /// The constant bitrate configuration for the video encode.
        /// When this field is defined, StatmuxSettings must be undefined.
        pub fn constant_bitrate(mut self, input: i32) -> Self {
            self.constant_bitrate = Some(input);
            self
        }
        /// The constant bitrate configuration for the video encode.
        /// When this field is defined, StatmuxSettings must be undefined.
        pub fn set_constant_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.constant_bitrate = input;
            self
        }
        /// Statmux rate control settings.
        /// When this field is defined, ConstantBitrate must be undefined.
        pub fn statmux_settings(
            mut self,
            input: crate::model::MultiplexStatmuxVideoSettings,
        ) -> Self {
            self.statmux_settings = Some(input);
            self
        }
        /// Statmux rate control settings.
        /// When this field is defined, ConstantBitrate must be undefined.
        pub fn set_statmux_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexStatmuxVideoSettings>,
        ) -> Self {
            self.statmux_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexVideoSettings`](crate::model::MultiplexVideoSettings)
        pub fn build(self) -> crate::model::MultiplexVideoSettings {
            crate::model::MultiplexVideoSettings {
                constant_bitrate: self.constant_bitrate.unwrap_or_default(),
                statmux_settings: self.statmux_settings,
            }
        }
    }
}
impl MultiplexVideoSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexVideoSettings`](crate::model::MultiplexVideoSettings)
    pub fn builder() -> crate::model::multiplex_video_settings::Builder {
        crate::model::multiplex_video_settings::Builder::default()
    }
}

/// Statmux rate control settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexStatmuxVideoSettings {
    /// Maximum statmux bitrate.
    pub maximum_bitrate: i32,
    /// Minimum statmux bitrate.
    pub minimum_bitrate: i32,
    /// The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.  Channels that have a higher priority will\nget higher video quality at the expense of the video quality of\nother channels in the multiplex with lower priority.
    pub priority: i32,
}
impl std::fmt::Debug for MultiplexStatmuxVideoSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexStatmuxVideoSettings");
        formatter.field("maximum_bitrate", &self.maximum_bitrate);
        formatter.field("minimum_bitrate", &self.minimum_bitrate);
        formatter.field("priority", &self.priority);
        formatter.finish()
    }
}
/// See [`MultiplexStatmuxVideoSettings`](crate::model::MultiplexStatmuxVideoSettings)
pub mod multiplex_statmux_video_settings {
    /// A builder for [`MultiplexStatmuxVideoSettings`](crate::model::MultiplexStatmuxVideoSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_bitrate: std::option::Option<i32>,
        pub(crate) minimum_bitrate: std::option::Option<i32>,
        pub(crate) priority: std::option::Option<i32>,
    }
    impl Builder {
        /// Maximum statmux bitrate.
        pub fn maximum_bitrate(mut self, input: i32) -> Self {
            self.maximum_bitrate = Some(input);
            self
        }
        /// Maximum statmux bitrate.
        pub fn set_maximum_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_bitrate = input;
            self
        }
        /// Minimum statmux bitrate.
        pub fn minimum_bitrate(mut self, input: i32) -> Self {
            self.minimum_bitrate = Some(input);
            self
        }
        /// Minimum statmux bitrate.
        pub fn set_minimum_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.minimum_bitrate = input;
            self
        }
        /// The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.  Channels that have a higher priority will\nget higher video quality at the expense of the video quality of\nother channels in the multiplex with lower priority.
        pub fn priority(mut self, input: i32) -> Self {
            self.priority = Some(input);
            self
        }
        /// The purpose of the priority is to use a combination of the\nmultiplex rate control algorithm and the QVBR capability of the\nencoder to prioritize the video quality of some channels in a\nmultiplex over others.  Channels that have a higher priority will\nget higher video quality at the expense of the video quality of\nother channels in the multiplex with lower priority.
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.priority = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexStatmuxVideoSettings`](crate::model::MultiplexStatmuxVideoSettings)
        pub fn build(self) -> crate::model::MultiplexStatmuxVideoSettings {
            crate::model::MultiplexStatmuxVideoSettings {
                maximum_bitrate: self.maximum_bitrate.unwrap_or_default(),
                minimum_bitrate: self.minimum_bitrate.unwrap_or_default(),
                priority: self.priority.unwrap_or_default(),
            }
        }
    }
}
impl MultiplexStatmuxVideoSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexStatmuxVideoSettings`](crate::model::MultiplexStatmuxVideoSettings)
    pub fn builder() -> crate::model::multiplex_statmux_video_settings::Builder {
        crate::model::multiplex_statmux_video_settings::Builder::default()
    }
}

/// Transport stream service descriptor configuration for the Multiplex program.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexProgramServiceDescriptor {
    /// Name of the provider.
    pub provider_name: std::option::Option<std::string::String>,
    /// Name of the service.
    pub service_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MultiplexProgramServiceDescriptor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexProgramServiceDescriptor");
        formatter.field("provider_name", &self.provider_name);
        formatter.field("service_name", &self.service_name);
        formatter.finish()
    }
}
/// See [`MultiplexProgramServiceDescriptor`](crate::model::MultiplexProgramServiceDescriptor)
pub mod multiplex_program_service_descriptor {
    /// A builder for [`MultiplexProgramServiceDescriptor`](crate::model::MultiplexProgramServiceDescriptor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) provider_name: std::option::Option<std::string::String>,
        pub(crate) service_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Name of the provider.
        pub fn provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.provider_name = Some(input.into());
            self
        }
        /// Name of the provider.
        pub fn set_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.provider_name = input;
            self
        }
        /// Name of the service.
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// Name of the service.
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexProgramServiceDescriptor`](crate::model::MultiplexProgramServiceDescriptor)
        pub fn build(self) -> crate::model::MultiplexProgramServiceDescriptor {
            crate::model::MultiplexProgramServiceDescriptor {
                provider_name: self.provider_name,
                service_name: self.service_name,
            }
        }
    }
}
impl MultiplexProgramServiceDescriptor {
    /// Creates a new builder-style object to manufacture [`MultiplexProgramServiceDescriptor`](crate::model::MultiplexProgramServiceDescriptor)
    pub fn builder() -> crate::model::multiplex_program_service_descriptor::Builder {
        crate::model::multiplex_program_service_descriptor::Builder::default()
    }
}

/// Indicates which pipeline is preferred by the multiplex for program ingest.
/// If set to \"PIPELINE_0\" or \"PIPELINE_1\" and an unhealthy ingest causes the multiplex to switch to the non-preferred pipeline,
/// it will switch back once that ingest is healthy again. If set to \"CURRENTLY_ACTIVE\",
/// it will not switch back to the other pipeline based on it recovering to a healthy state,
/// it will only switch if the active pipeline becomes unhealthy.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PreferredChannelPipeline {
    #[allow(missing_docs)] // documentation missing in model
    CurrentlyActive,
    #[allow(missing_docs)] // documentation missing in model
    Pipeline0,
    #[allow(missing_docs)] // documentation missing in model
    Pipeline1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PreferredChannelPipeline {
    fn from(s: &str) -> Self {
        match s {
            "CURRENTLY_ACTIVE" => PreferredChannelPipeline::CurrentlyActive,
            "PIPELINE_0" => PreferredChannelPipeline::Pipeline0,
            "PIPELINE_1" => PreferredChannelPipeline::Pipeline1,
            other => PreferredChannelPipeline::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PreferredChannelPipeline {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PreferredChannelPipeline::from(s))
    }
}
impl PreferredChannelPipeline {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PreferredChannelPipeline::CurrentlyActive => "CURRENTLY_ACTIVE",
            PreferredChannelPipeline::Pipeline0 => "PIPELINE_0",
            PreferredChannelPipeline::Pipeline1 => "PIPELINE_1",
            PreferredChannelPipeline::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CURRENTLY_ACTIVE", "PIPELINE_0", "PIPELINE_1"]
    }
}
impl AsRef<str> for PreferredChannelPipeline {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The multiplex object.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Multiplex {
    /// The unique arn of the multiplex.
    pub arn: std::option::Option<std::string::String>,
    /// A list of availability zones for the multiplex.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the multiplex output destinations.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
    /// The unique id of the multiplex.
    pub id: std::option::Option<std::string::String>,
    /// Configuration for a multiplex event.
    pub multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
    /// The name of the multiplex.
    pub name: std::option::Option<std::string::String>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The number of programs in the multiplex.
    pub program_count: i32,
    /// The current state of the multiplex.
    pub state: std::option::Option<crate::model::MultiplexState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl std::fmt::Debug for Multiplex {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Multiplex");
        formatter.field("arn", &self.arn);
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("multiplex_settings", &self.multiplex_settings);
        formatter.field("name", &self.name);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("program_count", &self.program_count);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`Multiplex`](crate::model::Multiplex)
pub mod multiplex {
    /// A builder for [`Multiplex`](crate::model::Multiplex)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) multiplex_settings: std::option::Option<crate::model::MultiplexSettings>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) program_count: std::option::Option<i32>,
        pub(crate) state: std::option::Option<crate::model::MultiplexState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The unique arn of the multiplex.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the multiplex.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// A list of availability zones for the multiplex.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// A list of availability zones for the multiplex.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the multiplex output destinations.
        pub fn destinations(
            mut self,
            input: impl Into<crate::model::MultiplexOutputDestination>,
        ) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the multiplex output destinations.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MultiplexOutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The unique id of the multiplex.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the multiplex.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Configuration for a multiplex event.
        pub fn multiplex_settings(mut self, input: crate::model::MultiplexSettings) -> Self {
            self.multiplex_settings = Some(input);
            self
        }
        /// Configuration for a multiplex event.
        pub fn set_multiplex_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexSettings>,
        ) -> Self {
            self.multiplex_settings = input;
            self
        }
        /// The name of the multiplex.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the multiplex.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The number of programs in the multiplex.
        pub fn program_count(mut self, input: i32) -> Self {
            self.program_count = Some(input);
            self
        }
        /// The number of programs in the multiplex.
        pub fn set_program_count(mut self, input: std::option::Option<i32>) -> Self {
            self.program_count = input;
            self
        }
        /// The current state of the multiplex.
        pub fn state(mut self, input: crate::model::MultiplexState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the multiplex.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::MultiplexState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`Multiplex`](crate::model::Multiplex)
        pub fn build(self) -> crate::model::Multiplex {
            crate::model::Multiplex {
                arn: self.arn,
                availability_zones: self.availability_zones,
                destinations: self.destinations,
                id: self.id,
                multiplex_settings: self.multiplex_settings,
                name: self.name,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                program_count: self.program_count.unwrap_or_default(),
                state: self.state,
                tags: self.tags,
            }
        }
    }
}
impl Multiplex {
    /// Creates a new builder-style object to manufacture [`Multiplex`](crate::model::Multiplex)
    pub fn builder() -> crate::model::multiplex::Builder {
        crate::model::multiplex::Builder::default()
    }
}

/// The current state of the multiplex.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MultiplexState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    Recovering,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MultiplexState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => MultiplexState::CreateFailed,
            "CREATING" => MultiplexState::Creating,
            "DELETED" => MultiplexState::Deleted,
            "DELETING" => MultiplexState::Deleting,
            "IDLE" => MultiplexState::Idle,
            "RECOVERING" => MultiplexState::Recovering,
            "RUNNING" => MultiplexState::Running,
            "STARTING" => MultiplexState::Starting,
            "STOPPING" => MultiplexState::Stopping,
            other => MultiplexState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MultiplexState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MultiplexState::from(s))
    }
}
impl MultiplexState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MultiplexState::CreateFailed => "CREATE_FAILED",
            MultiplexState::Creating => "CREATING",
            MultiplexState::Deleted => "DELETED",
            MultiplexState::Deleting => "DELETING",
            MultiplexState::Idle => "IDLE",
            MultiplexState::Recovering => "RECOVERING",
            MultiplexState::Running => "RUNNING",
            MultiplexState::Starting => "STARTING",
            MultiplexState::Stopping => "STOPPING",
            MultiplexState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATING",
            "DELETED",
            "DELETING",
            "IDLE",
            "RECOVERING",
            "RUNNING",
            "STARTING",
            "STOPPING",
        ]
    }
}
impl AsRef<str> for MultiplexState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Contains configuration for a Multiplex event
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexSettings {
    /// Maximum video buffer delay in milliseconds.
    pub maximum_video_buffer_delay_milliseconds: i32,
    /// Transport stream bit rate.
    pub transport_stream_bitrate: i32,
    /// Transport stream ID.
    pub transport_stream_id: i32,
    /// Transport stream reserved bit rate.
    pub transport_stream_reserved_bitrate: i32,
}
impl std::fmt::Debug for MultiplexSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexSettings");
        formatter.field(
            "maximum_video_buffer_delay_milliseconds",
            &self.maximum_video_buffer_delay_milliseconds,
        );
        formatter.field("transport_stream_bitrate", &self.transport_stream_bitrate);
        formatter.field("transport_stream_id", &self.transport_stream_id);
        formatter.field(
            "transport_stream_reserved_bitrate",
            &self.transport_stream_reserved_bitrate,
        );
        formatter.finish()
    }
}
/// See [`MultiplexSettings`](crate::model::MultiplexSettings)
pub mod multiplex_settings {
    /// A builder for [`MultiplexSettings`](crate::model::MultiplexSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) maximum_video_buffer_delay_milliseconds: std::option::Option<i32>,
        pub(crate) transport_stream_bitrate: std::option::Option<i32>,
        pub(crate) transport_stream_id: std::option::Option<i32>,
        pub(crate) transport_stream_reserved_bitrate: std::option::Option<i32>,
    }
    impl Builder {
        /// Maximum video buffer delay in milliseconds.
        pub fn maximum_video_buffer_delay_milliseconds(mut self, input: i32) -> Self {
            self.maximum_video_buffer_delay_milliseconds = Some(input);
            self
        }
        /// Maximum video buffer delay in milliseconds.
        pub fn set_maximum_video_buffer_delay_milliseconds(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.maximum_video_buffer_delay_milliseconds = input;
            self
        }
        /// Transport stream bit rate.
        pub fn transport_stream_bitrate(mut self, input: i32) -> Self {
            self.transport_stream_bitrate = Some(input);
            self
        }
        /// Transport stream bit rate.
        pub fn set_transport_stream_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.transport_stream_bitrate = input;
            self
        }
        /// Transport stream ID.
        pub fn transport_stream_id(mut self, input: i32) -> Self {
            self.transport_stream_id = Some(input);
            self
        }
        /// Transport stream ID.
        pub fn set_transport_stream_id(mut self, input: std::option::Option<i32>) -> Self {
            self.transport_stream_id = input;
            self
        }
        /// Transport stream reserved bit rate.
        pub fn transport_stream_reserved_bitrate(mut self, input: i32) -> Self {
            self.transport_stream_reserved_bitrate = Some(input);
            self
        }
        /// Transport stream reserved bit rate.
        pub fn set_transport_stream_reserved_bitrate(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.transport_stream_reserved_bitrate = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexSettings`](crate::model::MultiplexSettings)
        pub fn build(self) -> crate::model::MultiplexSettings {
            crate::model::MultiplexSettings {
                maximum_video_buffer_delay_milliseconds: self
                    .maximum_video_buffer_delay_milliseconds
                    .unwrap_or_default(),
                transport_stream_bitrate: self.transport_stream_bitrate.unwrap_or_default(),
                transport_stream_id: self.transport_stream_id.unwrap_or_default(),
                transport_stream_reserved_bitrate: self
                    .transport_stream_reserved_bitrate
                    .unwrap_or_default(),
            }
        }
    }
}
impl MultiplexSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexSettings`](crate::model::MultiplexSettings)
    pub fn builder() -> crate::model::multiplex_settings::Builder {
        crate::model::multiplex_settings::Builder::default()
    }
}

/// Multiplex output destination settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexOutputDestination {
    /// Multiplex MediaConnect output destination settings.
    pub media_connect_settings:
        std::option::Option<crate::model::MultiplexMediaConnectOutputDestinationSettings>,
}
impl std::fmt::Debug for MultiplexOutputDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexOutputDestination");
        formatter.field("media_connect_settings", &self.media_connect_settings);
        formatter.finish()
    }
}
/// See [`MultiplexOutputDestination`](crate::model::MultiplexOutputDestination)
pub mod multiplex_output_destination {
    /// A builder for [`MultiplexOutputDestination`](crate::model::MultiplexOutputDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) media_connect_settings:
            std::option::Option<crate::model::MultiplexMediaConnectOutputDestinationSettings>,
    }
    impl Builder {
        /// Multiplex MediaConnect output destination settings.
        pub fn media_connect_settings(
            mut self,
            input: crate::model::MultiplexMediaConnectOutputDestinationSettings,
        ) -> Self {
            self.media_connect_settings = Some(input);
            self
        }
        /// Multiplex MediaConnect output destination settings.
        pub fn set_media_connect_settings(
            mut self,
            input: std::option::Option<
                crate::model::MultiplexMediaConnectOutputDestinationSettings,
            >,
        ) -> Self {
            self.media_connect_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexOutputDestination`](crate::model::MultiplexOutputDestination)
        pub fn build(self) -> crate::model::MultiplexOutputDestination {
            crate::model::MultiplexOutputDestination {
                media_connect_settings: self.media_connect_settings,
            }
        }
    }
}
impl MultiplexOutputDestination {
    /// Creates a new builder-style object to manufacture [`MultiplexOutputDestination`](crate::model::MultiplexOutputDestination)
    pub fn builder() -> crate::model::multiplex_output_destination::Builder {
        crate::model::multiplex_output_destination::Builder::default()
    }
}

/// Multiplex MediaConnect output destination settings.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexMediaConnectOutputDestinationSettings {
    /// The MediaConnect entitlement ARN available as a Flow source.
    pub entitlement_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MultiplexMediaConnectOutputDestinationSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexMediaConnectOutputDestinationSettings");
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.finish()
    }
}
/// See [`MultiplexMediaConnectOutputDestinationSettings`](crate::model::MultiplexMediaConnectOutputDestinationSettings)
pub mod multiplex_media_connect_output_destination_settings {
    /// A builder for [`MultiplexMediaConnectOutputDestinationSettings`](crate::model::MultiplexMediaConnectOutputDestinationSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The MediaConnect entitlement ARN available as a Flow source.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The MediaConnect entitlement ARN available as a Flow source.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexMediaConnectOutputDestinationSettings`](crate::model::MultiplexMediaConnectOutputDestinationSettings)
        pub fn build(self) -> crate::model::MultiplexMediaConnectOutputDestinationSettings {
            crate::model::MultiplexMediaConnectOutputDestinationSettings {
                entitlement_arn: self.entitlement_arn,
            }
        }
    }
}
impl MultiplexMediaConnectOutputDestinationSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexMediaConnectOutputDestinationSettings`](crate::model::MultiplexMediaConnectOutputDestinationSettings)
    pub fn builder() -> crate::model::multiplex_media_connect_output_destination_settings::Builder {
        crate::model::multiplex_media_connect_output_destination_settings::Builder::default()
    }
}

/// An Input Security Group
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSecurityGroup {
    /// Unique ARN of Input Security Group
    pub arn: std::option::Option<std::string::String>,
    /// The Id of the Input Security Group
    pub id: std::option::Option<std::string::String>,
    /// The list of inputs currently using this Input Security Group.
    pub inputs: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The current state of the Input Security Group.
    pub state: std::option::Option<crate::model::InputSecurityGroupState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Whitelist rules and their sync status
    pub whitelist_rules: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRule>>,
}
impl std::fmt::Debug for InputSecurityGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSecurityGroup");
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("inputs", &self.inputs);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("whitelist_rules", &self.whitelist_rules);
        formatter.finish()
    }
}
/// See [`InputSecurityGroup`](crate::model::InputSecurityGroup)
pub mod input_security_group {
    /// A builder for [`InputSecurityGroup`](crate::model::InputSecurityGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) inputs: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) state: std::option::Option<crate::model::InputSecurityGroupState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) whitelist_rules:
            std::option::Option<std::vec::Vec<crate::model::InputWhitelistRule>>,
    }
    impl Builder {
        /// Unique ARN of Input Security Group
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// Unique ARN of Input Security Group
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The Id of the Input Security Group
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The Id of the Input Security Group
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `inputs`.
        ///
        /// To override the contents of this collection use [`set_inputs`](Self::set_inputs).
        ///
        /// The list of inputs currently using this Input Security Group.
        pub fn inputs(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.inputs.unwrap_or_default();
            v.push(input.into());
            self.inputs = Some(v);
            self
        }
        /// The list of inputs currently using this Input Security Group.
        pub fn set_inputs(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inputs = input;
            self
        }
        /// The current state of the Input Security Group.
        pub fn state(mut self, input: crate::model::InputSecurityGroupState) -> Self {
            self.state = Some(input);
            self
        }
        /// The current state of the Input Security Group.
        pub fn set_state(
            mut self,
            input: std::option::Option<crate::model::InputSecurityGroupState>,
        ) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Appends an item to `whitelist_rules`.
        ///
        /// To override the contents of this collection use [`set_whitelist_rules`](Self::set_whitelist_rules).
        ///
        /// Whitelist rules and their sync status
        pub fn whitelist_rules(
            mut self,
            input: impl Into<crate::model::InputWhitelistRule>,
        ) -> Self {
            let mut v = self.whitelist_rules.unwrap_or_default();
            v.push(input.into());
            self.whitelist_rules = Some(v);
            self
        }
        /// Whitelist rules and their sync status
        pub fn set_whitelist_rules(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputWhitelistRule>>,
        ) -> Self {
            self.whitelist_rules = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSecurityGroup`](crate::model::InputSecurityGroup)
        pub fn build(self) -> crate::model::InputSecurityGroup {
            crate::model::InputSecurityGroup {
                arn: self.arn,
                id: self.id,
                inputs: self.inputs,
                state: self.state,
                tags: self.tags,
                whitelist_rules: self.whitelist_rules,
            }
        }
    }
}
impl InputSecurityGroup {
    /// Creates a new builder-style object to manufacture [`InputSecurityGroup`](crate::model::InputSecurityGroup)
    pub fn builder() -> crate::model::input_security_group::Builder {
        crate::model::input_security_group::Builder::default()
    }
}

/// Whitelist rule
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputWhitelistRule {
    /// The IPv4 CIDR that's whitelisted.
    pub cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputWhitelistRule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputWhitelistRule");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}
/// See [`InputWhitelistRule`](crate::model::InputWhitelistRule)
pub mod input_whitelist_rule {
    /// A builder for [`InputWhitelistRule`](crate::model::InputWhitelistRule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The IPv4 CIDR that's whitelisted.
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// The IPv4 CIDR that's whitelisted.
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`InputWhitelistRule`](crate::model::InputWhitelistRule)
        pub fn build(self) -> crate::model::InputWhitelistRule {
            crate::model::InputWhitelistRule { cidr: self.cidr }
        }
    }
}
impl InputWhitelistRule {
    /// Creates a new builder-style object to manufacture [`InputWhitelistRule`](crate::model::InputWhitelistRule)
    pub fn builder() -> crate::model::input_whitelist_rule::Builder {
        crate::model::input_whitelist_rule::Builder::default()
    }
}

/// Placeholder documentation for InputSecurityGroupState
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputSecurityGroupState {
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    InUse,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputSecurityGroupState {
    fn from(s: &str) -> Self {
        match s {
            "DELETED" => InputSecurityGroupState::Deleted,
            "IDLE" => InputSecurityGroupState::Idle,
            "IN_USE" => InputSecurityGroupState::InUse,
            "UPDATING" => InputSecurityGroupState::Updating,
            other => InputSecurityGroupState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputSecurityGroupState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputSecurityGroupState::from(s))
    }
}
impl InputSecurityGroupState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputSecurityGroupState::Deleted => "DELETED",
            InputSecurityGroupState::Idle => "IDLE",
            InputSecurityGroupState::InUse => "IN_USE",
            InputSecurityGroupState::Updating => "UPDATING",
            InputSecurityGroupState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DELETED", "IDLE", "IN_USE", "UPDATING"]
    }
}
impl AsRef<str> for InputSecurityGroupState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An IPv4 CIDR to whitelist.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputWhitelistRuleCidr {
    /// The IPv4 CIDR to whitelist.
    pub cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputWhitelistRuleCidr {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputWhitelistRuleCidr");
        formatter.field("cidr", &self.cidr);
        formatter.finish()
    }
}
/// See [`InputWhitelistRuleCidr`](crate::model::InputWhitelistRuleCidr)
pub mod input_whitelist_rule_cidr {
    /// A builder for [`InputWhitelistRuleCidr`](crate::model::InputWhitelistRuleCidr)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The IPv4 CIDR to whitelist.
        pub fn cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.cidr = Some(input.into());
            self
        }
        /// The IPv4 CIDR to whitelist.
        pub fn set_cidr(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`InputWhitelistRuleCidr`](crate::model::InputWhitelistRuleCidr)
        pub fn build(self) -> crate::model::InputWhitelistRuleCidr {
            crate::model::InputWhitelistRuleCidr { cidr: self.cidr }
        }
    }
}
impl InputWhitelistRuleCidr {
    /// Creates a new builder-style object to manufacture [`InputWhitelistRuleCidr`](crate::model::InputWhitelistRuleCidr)
    pub fn builder() -> crate::model::input_whitelist_rule_cidr::Builder {
        crate::model::input_whitelist_rule_cidr::Builder::default()
    }
}

/// Settings that describe the active source from the input device, and the video characteristics of that source.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDeviceUhdSettings {
    /// If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
    pub active_input: std::option::Option<crate::model::InputDeviceActiveInput>,
    /// The source at the input device that is currently active. You can specify this source.
    pub configured_input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
    /// The state of the input device.
    pub device_state: std::option::Option<crate::model::InputDeviceState>,
    /// The frame rate of the video source.
    pub framerate: f64,
    /// The height of the video source, in pixels.
    pub height: i32,
    /// The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
    pub max_bitrate: i32,
    /// The scan type of the video source.
    pub scan_type: std::option::Option<crate::model::InputDeviceScanType>,
    /// The width of the video source, in pixels.
    pub width: i32,
}
impl std::fmt::Debug for InputDeviceUhdSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDeviceUhdSettings");
        formatter.field("active_input", &self.active_input);
        formatter.field("configured_input", &self.configured_input);
        formatter.field("device_state", &self.device_state);
        formatter.field("framerate", &self.framerate);
        formatter.field("height", &self.height);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("width", &self.width);
        formatter.finish()
    }
}
/// See [`InputDeviceUhdSettings`](crate::model::InputDeviceUhdSettings)
pub mod input_device_uhd_settings {
    /// A builder for [`InputDeviceUhdSettings`](crate::model::InputDeviceUhdSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_input: std::option::Option<crate::model::InputDeviceActiveInput>,
        pub(crate) configured_input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
        pub(crate) device_state: std::option::Option<crate::model::InputDeviceState>,
        pub(crate) framerate: std::option::Option<f64>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) scan_type: std::option::Option<crate::model::InputDeviceScanType>,
        pub(crate) width: std::option::Option<i32>,
    }
    impl Builder {
        /// If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
        pub fn active_input(mut self, input: crate::model::InputDeviceActiveInput) -> Self {
            self.active_input = Some(input);
            self
        }
        /// If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
        pub fn set_active_input(
            mut self,
            input: std::option::Option<crate::model::InputDeviceActiveInput>,
        ) -> Self {
            self.active_input = input;
            self
        }
        /// The source at the input device that is currently active. You can specify this source.
        pub fn configured_input(mut self, input: crate::model::InputDeviceConfiguredInput) -> Self {
            self.configured_input = Some(input);
            self
        }
        /// The source at the input device that is currently active. You can specify this source.
        pub fn set_configured_input(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
        ) -> Self {
            self.configured_input = input;
            self
        }
        /// The state of the input device.
        pub fn device_state(mut self, input: crate::model::InputDeviceState) -> Self {
            self.device_state = Some(input);
            self
        }
        /// The state of the input device.
        pub fn set_device_state(
            mut self,
            input: std::option::Option<crate::model::InputDeviceState>,
        ) -> Self {
            self.device_state = input;
            self
        }
        /// The frame rate of the video source.
        pub fn framerate(mut self, input: f64) -> Self {
            self.framerate = Some(input);
            self
        }
        /// The frame rate of the video source.
        pub fn set_framerate(mut self, input: std::option::Option<f64>) -> Self {
            self.framerate = input;
            self
        }
        /// The height of the video source, in pixels.
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// The height of the video source, in pixels.
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// The scan type of the video source.
        pub fn scan_type(mut self, input: crate::model::InputDeviceScanType) -> Self {
            self.scan_type = Some(input);
            self
        }
        /// The scan type of the video source.
        pub fn set_scan_type(
            mut self,
            input: std::option::Option<crate::model::InputDeviceScanType>,
        ) -> Self {
            self.scan_type = input;
            self
        }
        /// The width of the video source, in pixels.
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// The width of the video source, in pixels.
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDeviceUhdSettings`](crate::model::InputDeviceUhdSettings)
        pub fn build(self) -> crate::model::InputDeviceUhdSettings {
            crate::model::InputDeviceUhdSettings {
                active_input: self.active_input,
                configured_input: self.configured_input,
                device_state: self.device_state,
                framerate: self.framerate.unwrap_or_default(),
                height: self.height.unwrap_or_default(),
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                scan_type: self.scan_type,
                width: self.width.unwrap_or_default(),
            }
        }
    }
}
impl InputDeviceUhdSettings {
    /// Creates a new builder-style object to manufacture [`InputDeviceUhdSettings`](crate::model::InputDeviceUhdSettings)
    pub fn builder() -> crate::model::input_device_uhd_settings::Builder {
        crate::model::input_device_uhd_settings::Builder::default()
    }
}

/// The scan type of the video source.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceScanType {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceScanType {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => InputDeviceScanType::Interlaced,
            "PROGRESSIVE" => InputDeviceScanType::Progressive,
            other => InputDeviceScanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceScanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceScanType::from(s))
    }
}
impl InputDeviceScanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceScanType::Interlaced => "INTERLACED",
            InputDeviceScanType::Progressive => "PROGRESSIVE",
            InputDeviceScanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "PROGRESSIVE"]
    }
}
impl AsRef<str> for InputDeviceScanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The state of the input device.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceState {
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    Streaming,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceState {
    fn from(s: &str) -> Self {
        match s {
            "IDLE" => InputDeviceState::Idle,
            "STREAMING" => InputDeviceState::Streaming,
            other => InputDeviceState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceState::from(s))
    }
}
impl InputDeviceState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceState::Idle => "IDLE",
            InputDeviceState::Streaming => "STREAMING",
            InputDeviceState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IDLE", "STREAMING"]
    }
}
impl AsRef<str> for InputDeviceState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The source to activate (use) from the input device.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceConfiguredInput {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Hdmi,
    #[allow(missing_docs)] // documentation missing in model
    Sdi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceConfiguredInput {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => InputDeviceConfiguredInput::Auto,
            "HDMI" => InputDeviceConfiguredInput::Hdmi,
            "SDI" => InputDeviceConfiguredInput::Sdi,
            other => InputDeviceConfiguredInput::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceConfiguredInput {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceConfiguredInput::from(s))
    }
}
impl InputDeviceConfiguredInput {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceConfiguredInput::Auto => "AUTO",
            InputDeviceConfiguredInput::Hdmi => "HDMI",
            InputDeviceConfiguredInput::Sdi => "SDI",
            InputDeviceConfiguredInput::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HDMI", "SDI"]
    }
}
impl AsRef<str> for InputDeviceConfiguredInput {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The source at the input device that is currently active.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceActiveInput {
    #[allow(missing_docs)] // documentation missing in model
    Hdmi,
    #[allow(missing_docs)] // documentation missing in model
    Sdi,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceActiveInput {
    fn from(s: &str) -> Self {
        match s {
            "HDMI" => InputDeviceActiveInput::Hdmi,
            "SDI" => InputDeviceActiveInput::Sdi,
            other => InputDeviceActiveInput::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceActiveInput {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceActiveInput::from(s))
    }
}
impl InputDeviceActiveInput {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceActiveInput::Hdmi => "HDMI",
            InputDeviceActiveInput::Sdi => "SDI",
            InputDeviceActiveInput::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HDMI", "SDI"]
    }
}
impl AsRef<str> for InputDeviceActiveInput {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The type of the input device. For an AWS Elemental Link device that outputs resolutions up to 1080, choose "HD".
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceType {
    #[allow(missing_docs)] // documentation missing in model
    Hd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceType {
    fn from(s: &str) -> Self {
        match s {
            "HD" => InputDeviceType::Hd,
            other => InputDeviceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceType::from(s))
    }
}
impl InputDeviceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceType::Hd => "HD",
            InputDeviceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HD"]
    }
}
impl AsRef<str> for InputDeviceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The network settings for the input device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDeviceNetworkSettings {
    /// The DNS addresses of the input device.
    pub dns_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The network gateway IP address.
    pub gateway: std::option::Option<std::string::String>,
    /// The IP address of the input device.
    pub ip_address: std::option::Option<std::string::String>,
    /// Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP address.
    pub ip_scheme: std::option::Option<crate::model::InputDeviceIpScheme>,
    /// The subnet mask of the input device.
    pub subnet_mask: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputDeviceNetworkSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDeviceNetworkSettings");
        formatter.field("dns_addresses", &self.dns_addresses);
        formatter.field("gateway", &self.gateway);
        formatter.field("ip_address", &self.ip_address);
        formatter.field("ip_scheme", &self.ip_scheme);
        formatter.field("subnet_mask", &self.subnet_mask);
        formatter.finish()
    }
}
/// See [`InputDeviceNetworkSettings`](crate::model::InputDeviceNetworkSettings)
pub mod input_device_network_settings {
    /// A builder for [`InputDeviceNetworkSettings`](crate::model::InputDeviceNetworkSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dns_addresses: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) gateway: std::option::Option<std::string::String>,
        pub(crate) ip_address: std::option::Option<std::string::String>,
        pub(crate) ip_scheme: std::option::Option<crate::model::InputDeviceIpScheme>,
        pub(crate) subnet_mask: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dns_addresses`.
        ///
        /// To override the contents of this collection use [`set_dns_addresses`](Self::set_dns_addresses).
        ///
        /// The DNS addresses of the input device.
        pub fn dns_addresses(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dns_addresses.unwrap_or_default();
            v.push(input.into());
            self.dns_addresses = Some(v);
            self
        }
        /// The DNS addresses of the input device.
        pub fn set_dns_addresses(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dns_addresses = input;
            self
        }
        /// The network gateway IP address.
        pub fn gateway(mut self, input: impl Into<std::string::String>) -> Self {
            self.gateway = Some(input.into());
            self
        }
        /// The network gateway IP address.
        pub fn set_gateway(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gateway = input;
            self
        }
        /// The IP address of the input device.
        pub fn ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address = Some(input.into());
            self
        }
        /// The IP address of the input device.
        pub fn set_ip_address(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip_address = input;
            self
        }
        /// Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP address.
        pub fn ip_scheme(mut self, input: crate::model::InputDeviceIpScheme) -> Self {
            self.ip_scheme = Some(input);
            self
        }
        /// Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP address.
        pub fn set_ip_scheme(
            mut self,
            input: std::option::Option<crate::model::InputDeviceIpScheme>,
        ) -> Self {
            self.ip_scheme = input;
            self
        }
        /// The subnet mask of the input device.
        pub fn subnet_mask(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_mask = Some(input.into());
            self
        }
        /// The subnet mask of the input device.
        pub fn set_subnet_mask(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_mask = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDeviceNetworkSettings`](crate::model::InputDeviceNetworkSettings)
        pub fn build(self) -> crate::model::InputDeviceNetworkSettings {
            crate::model::InputDeviceNetworkSettings {
                dns_addresses: self.dns_addresses,
                gateway: self.gateway,
                ip_address: self.ip_address,
                ip_scheme: self.ip_scheme,
                subnet_mask: self.subnet_mask,
            }
        }
    }
}
impl InputDeviceNetworkSettings {
    /// Creates a new builder-style object to manufacture [`InputDeviceNetworkSettings`](crate::model::InputDeviceNetworkSettings)
    pub fn builder() -> crate::model::input_device_network_settings::Builder {
        crate::model::input_device_network_settings::Builder::default()
    }
}

/// Specifies whether the input device has been configured (outside of MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP address.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceIpScheme {
    #[allow(missing_docs)] // documentation missing in model
    Dhcp,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceIpScheme {
    fn from(s: &str) -> Self {
        match s {
            "DHCP" => InputDeviceIpScheme::Dhcp,
            "STATIC" => InputDeviceIpScheme::Static,
            other => InputDeviceIpScheme::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceIpScheme {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceIpScheme::from(s))
    }
}
impl InputDeviceIpScheme {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceIpScheme::Dhcp => "DHCP",
            InputDeviceIpScheme::Static => "STATIC",
            InputDeviceIpScheme::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DHCP", "STATIC"]
    }
}
impl AsRef<str> for InputDeviceIpScheme {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Settings that describe the active source from the input device, and the video characteristics of that source.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDeviceHdSettings {
    /// If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
    pub active_input: std::option::Option<crate::model::InputDeviceActiveInput>,
    /// The source at the input device that is currently active. You can specify this source.
    pub configured_input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
    /// The state of the input device.
    pub device_state: std::option::Option<crate::model::InputDeviceState>,
    /// The frame rate of the video source.
    pub framerate: f64,
    /// The height of the video source, in pixels.
    pub height: i32,
    /// The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
    pub max_bitrate: i32,
    /// The scan type of the video source.
    pub scan_type: std::option::Option<crate::model::InputDeviceScanType>,
    /// The width of the video source, in pixels.
    pub width: i32,
}
impl std::fmt::Debug for InputDeviceHdSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDeviceHdSettings");
        formatter.field("active_input", &self.active_input);
        formatter.field("configured_input", &self.configured_input);
        formatter.field("device_state", &self.device_state);
        formatter.field("framerate", &self.framerate);
        formatter.field("height", &self.height);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("width", &self.width);
        formatter.finish()
    }
}
/// See [`InputDeviceHdSettings`](crate::model::InputDeviceHdSettings)
pub mod input_device_hd_settings {
    /// A builder for [`InputDeviceHdSettings`](crate::model::InputDeviceHdSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_input: std::option::Option<crate::model::InputDeviceActiveInput>,
        pub(crate) configured_input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
        pub(crate) device_state: std::option::Option<crate::model::InputDeviceState>,
        pub(crate) framerate: std::option::Option<f64>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) scan_type: std::option::Option<crate::model::InputDeviceScanType>,
        pub(crate) width: std::option::Option<i32>,
    }
    impl Builder {
        /// If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
        pub fn active_input(mut self, input: crate::model::InputDeviceActiveInput) -> Self {
            self.active_input = Some(input);
            self
        }
        /// If you specified Auto as the configured input, specifies which of the sources is currently active (SDI or HDMI).
        pub fn set_active_input(
            mut self,
            input: std::option::Option<crate::model::InputDeviceActiveInput>,
        ) -> Self {
            self.active_input = input;
            self
        }
        /// The source at the input device that is currently active. You can specify this source.
        pub fn configured_input(mut self, input: crate::model::InputDeviceConfiguredInput) -> Self {
            self.configured_input = Some(input);
            self
        }
        /// The source at the input device that is currently active. You can specify this source.
        pub fn set_configured_input(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
        ) -> Self {
            self.configured_input = input;
            self
        }
        /// The state of the input device.
        pub fn device_state(mut self, input: crate::model::InputDeviceState) -> Self {
            self.device_state = Some(input);
            self
        }
        /// The state of the input device.
        pub fn set_device_state(
            mut self,
            input: std::option::Option<crate::model::InputDeviceState>,
        ) -> Self {
            self.device_state = input;
            self
        }
        /// The frame rate of the video source.
        pub fn framerate(mut self, input: f64) -> Self {
            self.framerate = Some(input);
            self
        }
        /// The frame rate of the video source.
        pub fn set_framerate(mut self, input: std::option::Option<f64>) -> Self {
            self.framerate = input;
            self
        }
        /// The height of the video source, in pixels.
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// The height of the video source, in pixels.
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// The current maximum bitrate for ingesting this source, in bits per second. You can specify this maximum.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// The scan type of the video source.
        pub fn scan_type(mut self, input: crate::model::InputDeviceScanType) -> Self {
            self.scan_type = Some(input);
            self
        }
        /// The scan type of the video source.
        pub fn set_scan_type(
            mut self,
            input: std::option::Option<crate::model::InputDeviceScanType>,
        ) -> Self {
            self.scan_type = input;
            self
        }
        /// The width of the video source, in pixels.
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// The width of the video source, in pixels.
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDeviceHdSettings`](crate::model::InputDeviceHdSettings)
        pub fn build(self) -> crate::model::InputDeviceHdSettings {
            crate::model::InputDeviceHdSettings {
                active_input: self.active_input,
                configured_input: self.configured_input,
                device_state: self.device_state,
                framerate: self.framerate.unwrap_or_default(),
                height: self.height.unwrap_or_default(),
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                scan_type: self.scan_type,
                width: self.width.unwrap_or_default(),
            }
        }
    }
}
impl InputDeviceHdSettings {
    /// Creates a new builder-style object to manufacture [`InputDeviceHdSettings`](crate::model::InputDeviceHdSettings)
    pub fn builder() -> crate::model::input_device_hd_settings::Builder {
        crate::model::input_device_hd_settings::Builder::default()
    }
}

/// The status of software on the input device.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceUpdateStatus {
    #[allow(missing_docs)] // documentation missing in model
    NotUpToDate,
    #[allow(missing_docs)] // documentation missing in model
    UpToDate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceUpdateStatus {
    fn from(s: &str) -> Self {
        match s {
            "NOT_UP_TO_DATE" => DeviceUpdateStatus::NotUpToDate,
            "UP_TO_DATE" => DeviceUpdateStatus::UpToDate,
            other => DeviceUpdateStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceUpdateStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceUpdateStatus::from(s))
    }
}
impl DeviceUpdateStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceUpdateStatus::NotUpToDate => "NOT_UP_TO_DATE",
            DeviceUpdateStatus::UpToDate => "UP_TO_DATE",
            DeviceUpdateStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_UP_TO_DATE", "UP_TO_DATE"]
    }
}
impl AsRef<str> for DeviceUpdateStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The status of the action to synchronize the device configuration. If you change the configuration of the input device (for example, the maximum bitrate), MediaLive sends the new data to the device. The device might not update itself immediately. SYNCED means the device has updated its configuration. SYNCING means that it has not updated its configuration.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeviceSettingsSyncState {
    #[allow(missing_docs)] // documentation missing in model
    Synced,
    #[allow(missing_docs)] // documentation missing in model
    Syncing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeviceSettingsSyncState {
    fn from(s: &str) -> Self {
        match s {
            "SYNCED" => DeviceSettingsSyncState::Synced,
            "SYNCING" => DeviceSettingsSyncState::Syncing,
            other => DeviceSettingsSyncState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeviceSettingsSyncState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeviceSettingsSyncState::from(s))
    }
}
impl DeviceSettingsSyncState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeviceSettingsSyncState::Synced => "SYNCED",
            DeviceSettingsSyncState::Syncing => "SYNCING",
            DeviceSettingsSyncState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SYNCED", "SYNCING"]
    }
}
impl AsRef<str> for DeviceSettingsSyncState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The state of the connection between the input device and AWS.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeviceConnectionState {
    #[allow(missing_docs)] // documentation missing in model
    Connected,
    #[allow(missing_docs)] // documentation missing in model
    Disconnected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeviceConnectionState {
    fn from(s: &str) -> Self {
        match s {
            "CONNECTED" => InputDeviceConnectionState::Connected,
            "DISCONNECTED" => InputDeviceConnectionState::Disconnected,
            other => InputDeviceConnectionState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeviceConnectionState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeviceConnectionState::from(s))
    }
}
impl InputDeviceConnectionState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeviceConnectionState::Connected => "CONNECTED",
            InputDeviceConnectionState::Disconnected => "DISCONNECTED",
            InputDeviceConnectionState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONNECTED", "DISCONNECTED"]
    }
}
impl AsRef<str> for InputDeviceConnectionState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Configurable settings for the input device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDeviceConfigurableSettings {
    /// The input source that you want to use. If the device has a source connected to only one of its input ports, or if you don't care which source the device sends, specify Auto. If the device has sources connected to both its input ports, and you want to use a specific source, specify the source.
    pub configured_input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
    /// The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
    pub max_bitrate: i32,
}
impl std::fmt::Debug for InputDeviceConfigurableSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDeviceConfigurableSettings");
        formatter.field("configured_input", &self.configured_input);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.finish()
    }
}
/// See [`InputDeviceConfigurableSettings`](crate::model::InputDeviceConfigurableSettings)
pub mod input_device_configurable_settings {
    /// A builder for [`InputDeviceConfigurableSettings`](crate::model::InputDeviceConfigurableSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configured_input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
        pub(crate) max_bitrate: std::option::Option<i32>,
    }
    impl Builder {
        /// The input source that you want to use. If the device has a source connected to only one of its input ports, or if you don't care which source the device sends, specify Auto. If the device has sources connected to both its input ports, and you want to use a specific source, specify the source.
        pub fn configured_input(mut self, input: crate::model::InputDeviceConfiguredInput) -> Self {
            self.configured_input = Some(input);
            self
        }
        /// The input source that you want to use. If the device has a source connected to only one of its input ports, or if you don't care which source the device sends, specify Auto. If the device has sources connected to both its input ports, and you want to use a specific source, specify the source.
        pub fn set_configured_input(
            mut self,
            input: std::option::Option<crate::model::InputDeviceConfiguredInput>,
        ) -> Self {
            self.configured_input = input;
            self
        }
        /// The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// The maximum bitrate in bits per second. Set a value here to throttle the bitrate of the source video.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDeviceConfigurableSettings`](crate::model::InputDeviceConfigurableSettings)
        pub fn build(self) -> crate::model::InputDeviceConfigurableSettings {
            crate::model::InputDeviceConfigurableSettings {
                configured_input: self.configured_input,
                max_bitrate: self.max_bitrate.unwrap_or_default(),
            }
        }
    }
}
impl InputDeviceConfigurableSettings {
    /// Creates a new builder-style object to manufacture [`InputDeviceConfigurableSettings`](crate::model::InputDeviceConfigurableSettings)
    pub fn builder() -> crate::model::input_device_configurable_settings::Builder {
        crate::model::input_device_configurable_settings::Builder::default()
    }
}

/// Placeholder documentation for Input
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Input {
    /// The Unique ARN of the input (generated, immutable).
    pub arn: std::option::Option<std::string::String>,
    /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
    pub attached_channels: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the destinations of the input (PUSH-type).
    pub destinations: std::option::Option<std::vec::Vec<crate::model::InputDestination>>,
    /// The generated ID of the input (unique for user account, immutable).
    pub id: std::option::Option<std::string::String>,
    /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
    /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
    pub input_class: std::option::Option<crate::model::InputClass>,
    /// Settings for the input devices.
    pub input_devices: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
    /// A list of IDs for all Inputs which are partners of this one.
    pub input_partner_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
    /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
    pub input_source_type: std::option::Option<crate::model::InputSourceType>,
    /// A list of MediaConnect Flows for this input.
    pub media_connect_flows: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlow>>,
    /// The user-assigned name (This is a mutable value).
    pub name: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
    pub role_arn: std::option::Option<std::string::String>,
    /// A list of IDs for all the Input Security Groups attached to the input.
    pub security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of the sources of the input (PULL-type).
    pub sources: std::option::Option<std::vec::Vec<crate::model::InputSource>>,
    /// Placeholder documentation for InputState
    pub state: std::option::Option<crate::model::InputState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// The different types of inputs that AWS Elemental MediaLive supports.
    pub r#type: std::option::Option<crate::model::InputType>,
}
impl std::fmt::Debug for Input {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Input");
        formatter.field("arn", &self.arn);
        formatter.field("attached_channels", &self.attached_channels);
        formatter.field("destinations", &self.destinations);
        formatter.field("id", &self.id);
        formatter.field("input_class", &self.input_class);
        formatter.field("input_devices", &self.input_devices);
        formatter.field("input_partner_ids", &self.input_partner_ids);
        formatter.field("input_source_type", &self.input_source_type);
        formatter.field("media_connect_flows", &self.media_connect_flows);
        formatter.field("name", &self.name);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_groups", &self.security_groups);
        formatter.field("sources", &self.sources);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Input`](crate::model::Input)
pub mod input {
    /// A builder for [`Input`](crate::model::Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) attached_channels: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) destinations: std::option::Option<std::vec::Vec<crate::model::InputDestination>>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_class: std::option::Option<crate::model::InputClass>,
        pub(crate) input_devices:
            std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        pub(crate) input_partner_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) input_source_type: std::option::Option<crate::model::InputSourceType>,
        pub(crate) media_connect_flows:
            std::option::Option<std::vec::Vec<crate::model::MediaConnectFlow>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_groups: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::InputSource>>,
        pub(crate) state: std::option::Option<crate::model::InputState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) r#type: std::option::Option<crate::model::InputType>,
    }
    impl Builder {
        /// The Unique ARN of the input (generated, immutable).
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The Unique ARN of the input (generated, immutable).
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Appends an item to `attached_channels`.
        ///
        /// To override the contents of this collection use [`set_attached_channels`](Self::set_attached_channels).
        ///
        /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
        pub fn attached_channels(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.attached_channels.unwrap_or_default();
            v.push(input.into());
            self.attached_channels = Some(v);
            self
        }
        /// A list of channel IDs that that input is attached to (currently an input can only be attached to one channel).
        pub fn set_attached_channels(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.attached_channels = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of the destinations of the input (PUSH-type).
        pub fn destinations(mut self, input: impl Into<crate::model::InputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of the destinations of the input (PUSH-type).
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// The generated ID of the input (unique for user account, immutable).
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The generated ID of the input (unique for user account, immutable).
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
        /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
        pub fn input_class(mut self, input: crate::model::InputClass) -> Self {
            self.input_class = Some(input);
            self
        }
        /// STANDARD - MediaLive expects two sources to be connected to this input. If the channel is also STANDARD, both sources will be ingested. If the channel is SINGLE_PIPELINE, only the first source will be ingested; the second source will always be ignored, even if the first source fails.
        /// SINGLE_PIPELINE - You can connect only one source to this input. If the ChannelClass is also  SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this value is not valid because the channel requires two sources in the input.
        pub fn set_input_class(
            mut self,
            input: std::option::Option<crate::model::InputClass>,
        ) -> Self {
            self.input_class = input;
            self
        }
        /// Appends an item to `input_devices`.
        ///
        /// To override the contents of this collection use [`set_input_devices`](Self::set_input_devices).
        ///
        /// Settings for the input devices.
        pub fn input_devices(
            mut self,
            input: impl Into<crate::model::InputDeviceSettings>,
        ) -> Self {
            let mut v = self.input_devices.unwrap_or_default();
            v.push(input.into());
            self.input_devices = Some(v);
            self
        }
        /// Settings for the input devices.
        pub fn set_input_devices(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputDeviceSettings>>,
        ) -> Self {
            self.input_devices = input;
            self
        }
        /// Appends an item to `input_partner_ids`.
        ///
        /// To override the contents of this collection use [`set_input_partner_ids`](Self::set_input_partner_ids).
        ///
        /// A list of IDs for all Inputs which are partners of this one.
        pub fn input_partner_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.input_partner_ids.unwrap_or_default();
            v.push(input.into());
            self.input_partner_ids = Some(v);
            self
        }
        /// A list of IDs for all Inputs which are partners of this one.
        pub fn set_input_partner_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.input_partner_ids = input;
            self
        }
        /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
        /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
        pub fn input_source_type(mut self, input: crate::model::InputSourceType) -> Self {
            self.input_source_type = Some(input);
            self
        }
        /// Certain pull input sources can be dynamic, meaning that they can have their URL's dynamically changes
        /// during input switch actions. Presently, this functionality only works with MP4_FILE and TS_FILE inputs.
        pub fn set_input_source_type(
            mut self,
            input: std::option::Option<crate::model::InputSourceType>,
        ) -> Self {
            self.input_source_type = input;
            self
        }
        /// Appends an item to `media_connect_flows`.
        ///
        /// To override the contents of this collection use [`set_media_connect_flows`](Self::set_media_connect_flows).
        ///
        /// A list of MediaConnect Flows for this input.
        pub fn media_connect_flows(
            mut self,
            input: impl Into<crate::model::MediaConnectFlow>,
        ) -> Self {
            let mut v = self.media_connect_flows.unwrap_or_default();
            v.push(input.into());
            self.media_connect_flows = Some(v);
            self
        }
        /// A list of MediaConnect Flows for this input.
        pub fn set_media_connect_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaConnectFlow>>,
        ) -> Self {
            self.media_connect_flows = input;
            self
        }
        /// The user-assigned name (This is a mutable value).
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The user-assigned name (This is a mutable value).
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_groups`.
        ///
        /// To override the contents of this collection use [`set_security_groups`](Self::set_security_groups).
        ///
        /// A list of IDs for all the Input Security Groups attached to the input.
        pub fn security_groups(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_groups.unwrap_or_default();
            v.push(input.into());
            self.security_groups = Some(v);
            self
        }
        /// A list of IDs for all the Input Security Groups attached to the input.
        pub fn set_security_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_groups = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// A list of the sources of the input (PULL-type).
        pub fn sources(mut self, input: impl Into<crate::model::InputSource>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// A list of the sources of the input (PULL-type).
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputSource>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Placeholder documentation for InputState
        pub fn state(mut self, input: crate::model::InputState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for InputState
        pub fn set_state(mut self, input: std::option::Option<crate::model::InputState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn r#type(mut self, input: crate::model::InputType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// The different types of inputs that AWS Elemental MediaLive supports.
        pub fn set_type(mut self, input: std::option::Option<crate::model::InputType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Input`](crate::model::Input)
        pub fn build(self) -> crate::model::Input {
            crate::model::Input {
                arn: self.arn,
                attached_channels: self.attached_channels,
                destinations: self.destinations,
                id: self.id,
                input_class: self.input_class,
                input_devices: self.input_devices,
                input_partner_ids: self.input_partner_ids,
                input_source_type: self.input_source_type,
                media_connect_flows: self.media_connect_flows,
                name: self.name,
                role_arn: self.role_arn,
                security_groups: self.security_groups,
                sources: self.sources,
                state: self.state,
                tags: self.tags,
                r#type: self.r#type,
            }
        }
    }
}
impl Input {
    /// Creates a new builder-style object to manufacture [`Input`](crate::model::Input)
    pub fn builder() -> crate::model::input::Builder {
        crate::model::input::Builder::default()
    }
}

/// The different types of inputs that AWS Elemental MediaLive supports.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputType {
    #[allow(missing_docs)] // documentation missing in model
    AwsCdi,
    #[allow(missing_docs)] // documentation missing in model
    InputDevice,
    #[allow(missing_docs)] // documentation missing in model
    Mediaconnect,
    #[allow(missing_docs)] // documentation missing in model
    Mp4File,
    #[allow(missing_docs)] // documentation missing in model
    RtmpPull,
    #[allow(missing_docs)] // documentation missing in model
    RtmpPush,
    #[allow(missing_docs)] // documentation missing in model
    RtpPush,
    #[allow(missing_docs)] // documentation missing in model
    TsFile,
    #[allow(missing_docs)] // documentation missing in model
    UdpPush,
    #[allow(missing_docs)] // documentation missing in model
    UrlPull,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_CDI" => InputType::AwsCdi,
            "INPUT_DEVICE" => InputType::InputDevice,
            "MEDIACONNECT" => InputType::Mediaconnect,
            "MP4_FILE" => InputType::Mp4File,
            "RTMP_PULL" => InputType::RtmpPull,
            "RTMP_PUSH" => InputType::RtmpPush,
            "RTP_PUSH" => InputType::RtpPush,
            "TS_FILE" => InputType::TsFile,
            "UDP_PUSH" => InputType::UdpPush,
            "URL_PULL" => InputType::UrlPull,
            other => InputType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputType::from(s))
    }
}
impl InputType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputType::AwsCdi => "AWS_CDI",
            InputType::InputDevice => "INPUT_DEVICE",
            InputType::Mediaconnect => "MEDIACONNECT",
            InputType::Mp4File => "MP4_FILE",
            InputType::RtmpPull => "RTMP_PULL",
            InputType::RtmpPush => "RTMP_PUSH",
            InputType::RtpPush => "RTP_PUSH",
            InputType::TsFile => "TS_FILE",
            InputType::UdpPush => "UDP_PUSH",
            InputType::UrlPull => "URL_PULL",
            InputType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWS_CDI",
            "INPUT_DEVICE",
            "MEDIACONNECT",
            "MP4_FILE",
            "RTMP_PULL",
            "RTMP_PUSH",
            "RTP_PUSH",
            "TS_FILE",
            "UDP_PUSH",
            "URL_PULL",
        ]
    }
}
impl AsRef<str> for InputType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Placeholder documentation for InputState
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputState {
    #[allow(missing_docs)] // documentation missing in model
    Attached,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Detached,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputState {
    fn from(s: &str) -> Self {
        match s {
            "ATTACHED" => InputState::Attached,
            "CREATING" => InputState::Creating,
            "DELETED" => InputState::Deleted,
            "DELETING" => InputState::Deleting,
            "DETACHED" => InputState::Detached,
            other => InputState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputState::from(s))
    }
}
impl InputState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputState::Attached => "ATTACHED",
            InputState::Creating => "CREATING",
            InputState::Deleted => "DELETED",
            InputState::Deleting => "DELETING",
            InputState::Detached => "DETACHED",
            InputState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ATTACHED", "CREATING", "DELETED", "DELETING", "DETACHED"]
    }
}
impl AsRef<str> for InputState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The settings for a PULL type input.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSource {
    /// The key used to extract the password from EC2 Parameter store.
    pub password_param: std::option::Option<std::string::String>,
    /// This represents the customer's source URL where stream is
    /// pulled from.
    pub url: std::option::Option<std::string::String>,
    /// The username for the input source.
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputSource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSource");
        formatter.field("password_param", &self.password_param);
        formatter.field("url", &self.url);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`InputSource`](crate::model::InputSource)
pub mod input_source {
    /// A builder for [`InputSource`](crate::model::InputSource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) password_param: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The key used to extract the password from EC2 Parameter store.
        pub fn password_param(mut self, input: impl Into<std::string::String>) -> Self {
            self.password_param = Some(input.into());
            self
        }
        /// The key used to extract the password from EC2 Parameter store.
        pub fn set_password_param(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.password_param = input;
            self
        }
        /// This represents the customer's source URL where stream is
        /// pulled from.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// This represents the customer's source URL where stream is
        /// pulled from.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// The username for the input source.
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// The username for the input source.
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSource`](crate::model::InputSource)
        pub fn build(self) -> crate::model::InputSource {
            crate::model::InputSource {
                password_param: self.password_param,
                url: self.url,
                username: self.username,
            }
        }
    }
}
impl InputSource {
    /// Creates a new builder-style object to manufacture [`InputSource`](crate::model::InputSource)
    pub fn builder() -> crate::model::input_source::Builder {
        crate::model::input_source::Builder::default()
    }
}

/// The settings for a MediaConnect Flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaConnectFlow {
    /// The unique ARN of the MediaConnect Flow being used as a source.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaConnectFlow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaConnectFlow");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}
/// See [`MediaConnectFlow`](crate::model::MediaConnectFlow)
pub mod media_connect_flow {
    /// A builder for [`MediaConnectFlow`](crate::model::MediaConnectFlow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ARN of the MediaConnect Flow being used as a source.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The unique ARN of the MediaConnect Flow being used as a source.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaConnectFlow`](crate::model::MediaConnectFlow)
        pub fn build(self) -> crate::model::MediaConnectFlow {
            crate::model::MediaConnectFlow {
                flow_arn: self.flow_arn,
            }
        }
    }
}
impl MediaConnectFlow {
    /// Creates a new builder-style object to manufacture [`MediaConnectFlow`](crate::model::MediaConnectFlow)
    pub fn builder() -> crate::model::media_connect_flow::Builder {
        crate::model::media_connect_flow::Builder::default()
    }
}

/// There are two types of input sources, static and dynamic. If an input source is dynamic you can
/// change the source url of the input dynamically using an input switch action. Currently, two input types
/// support a dynamic url at this time, MP4_FILE and TS_FILE. By default all input sources are static.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputSourceType {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputSourceType {
    fn from(s: &str) -> Self {
        match s {
            "DYNAMIC" => InputSourceType::Dynamic,
            "STATIC" => InputSourceType::Static,
            other => InputSourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputSourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputSourceType::from(s))
    }
}
impl InputSourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputSourceType::Dynamic => "DYNAMIC",
            InputSourceType::Static => "STATIC",
            InputSourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DYNAMIC", "STATIC"]
    }
}
impl AsRef<str> for InputSourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Settings for an input device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDeviceSettings {
    /// The unique ID for the device.
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputDeviceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDeviceSettings");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`InputDeviceSettings`](crate::model::InputDeviceSettings)
pub mod input_device_settings {
    /// A builder for [`InputDeviceSettings`](crate::model::InputDeviceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID for the device.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique ID for the device.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDeviceSettings`](crate::model::InputDeviceSettings)
        pub fn build(self) -> crate::model::InputDeviceSettings {
            crate::model::InputDeviceSettings { id: self.id }
        }
    }
}
impl InputDeviceSettings {
    /// Creates a new builder-style object to manufacture [`InputDeviceSettings`](crate::model::InputDeviceSettings)
    pub fn builder() -> crate::model::input_device_settings::Builder {
        crate::model::input_device_settings::Builder::default()
    }
}

/// A standard input has two sources and a single pipeline input only has one.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputClass {
    #[allow(missing_docs)] // documentation missing in model
    SinglePipeline,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputClass {
    fn from(s: &str) -> Self {
        match s {
            "SINGLE_PIPELINE" => InputClass::SinglePipeline,
            "STANDARD" => InputClass::Standard,
            other => InputClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputClass::from(s))
    }
}
impl InputClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputClass::SinglePipeline => "SINGLE_PIPELINE",
            InputClass::Standard => "STANDARD",
            InputClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SINGLE_PIPELINE", "STANDARD"]
    }
}
impl AsRef<str> for InputClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The settings for a PUSH type input.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDestination {
    /// The system-generated static IP address of endpoint.
    /// It remains fixed for the lifetime of the input.
    pub ip: std::option::Option<std::string::String>,
    /// The port number for the input.
    pub port: std::option::Option<std::string::String>,
    /// This represents the endpoint that the customer stream will be
    /// pushed to.
    pub url: std::option::Option<std::string::String>,
    /// The properties for a VPC type input destination.
    pub vpc: std::option::Option<crate::model::InputDestinationVpc>,
}
impl std::fmt::Debug for InputDestination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDestination");
        formatter.field("ip", &self.ip);
        formatter.field("port", &self.port);
        formatter.field("url", &self.url);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`InputDestination`](crate::model::InputDestination)
pub mod input_destination {
    /// A builder for [`InputDestination`](crate::model::InputDestination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) vpc: std::option::Option<crate::model::InputDestinationVpc>,
    }
    impl Builder {
        /// The system-generated static IP address of endpoint.
        /// It remains fixed for the lifetime of the input.
        pub fn ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip = Some(input.into());
            self
        }
        /// The system-generated static IP address of endpoint.
        /// It remains fixed for the lifetime of the input.
        pub fn set_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ip = input;
            self
        }
        /// The port number for the input.
        pub fn port(mut self, input: impl Into<std::string::String>) -> Self {
            self.port = Some(input.into());
            self
        }
        /// The port number for the input.
        pub fn set_port(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.port = input;
            self
        }
        /// This represents the endpoint that the customer stream will be
        /// pushed to.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// This represents the endpoint that the customer stream will be
        /// pushed to.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// The properties for a VPC type input destination.
        pub fn vpc(mut self, input: crate::model::InputDestinationVpc) -> Self {
            self.vpc = Some(input);
            self
        }
        /// The properties for a VPC type input destination.
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::InputDestinationVpc>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDestination`](crate::model::InputDestination)
        pub fn build(self) -> crate::model::InputDestination {
            crate::model::InputDestination {
                ip: self.ip,
                port: self.port,
                url: self.url,
                vpc: self.vpc,
            }
        }
    }
}
impl InputDestination {
    /// Creates a new builder-style object to manufacture [`InputDestination`](crate::model::InputDestination)
    pub fn builder() -> crate::model::input_destination::Builder {
        crate::model::input_destination::Builder::default()
    }
}

/// The properties for a VPC type input destination.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDestinationVpc {
    /// The availability zone of the Input destination.
    pub availability_zone: std::option::Option<std::string::String>,
    /// The network interface ID of the Input destination in the VPC.
    pub network_interface_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputDestinationVpc {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDestinationVpc");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("network_interface_id", &self.network_interface_id);
        formatter.finish()
    }
}
/// See [`InputDestinationVpc`](crate::model::InputDestinationVpc)
pub mod input_destination_vpc {
    /// A builder for [`InputDestinationVpc`](crate::model::InputDestinationVpc)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) network_interface_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The availability zone of the Input destination.
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// The availability zone of the Input destination.
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// The network interface ID of the Input destination in the VPC.
        pub fn network_interface_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_interface_id = Some(input.into());
            self
        }
        /// The network interface ID of the Input destination in the VPC.
        pub fn set_network_interface_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.network_interface_id = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDestinationVpc`](crate::model::InputDestinationVpc)
        pub fn build(self) -> crate::model::InputDestinationVpc {
            crate::model::InputDestinationVpc {
                availability_zone: self.availability_zone,
                network_interface_id: self.network_interface_id,
            }
        }
    }
}
impl InputDestinationVpc {
    /// Creates a new builder-style object to manufacture [`InputDestinationVpc`](crate::model::InputDestinationVpc)
    pub fn builder() -> crate::model::input_destination_vpc::Builder {
        crate::model::input_destination_vpc::Builder::default()
    }
}

/// Settings for for a PULL type input.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSourceRequest {
    /// The key used to extract the password from EC2 Parameter store.
    pub password_param: std::option::Option<std::string::String>,
    /// This represents the customer's source URL where stream is
    /// pulled from.
    pub url: std::option::Option<std::string::String>,
    /// The username for the input source.
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputSourceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSourceRequest");
        formatter.field("password_param", &self.password_param);
        formatter.field("url", &self.url);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`InputSourceRequest`](crate::model::InputSourceRequest)
pub mod input_source_request {
    /// A builder for [`InputSourceRequest`](crate::model::InputSourceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) password_param: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The key used to extract the password from EC2 Parameter store.
        pub fn password_param(mut self, input: impl Into<std::string::String>) -> Self {
            self.password_param = Some(input.into());
            self
        }
        /// The key used to extract the password from EC2 Parameter store.
        pub fn set_password_param(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.password_param = input;
            self
        }
        /// This represents the customer's source URL where stream is
        /// pulled from.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// This represents the customer's source URL where stream is
        /// pulled from.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// The username for the input source.
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// The username for the input source.
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSourceRequest`](crate::model::InputSourceRequest)
        pub fn build(self) -> crate::model::InputSourceRequest {
            crate::model::InputSourceRequest {
                password_param: self.password_param,
                url: self.url,
                username: self.username,
            }
        }
    }
}
impl InputSourceRequest {
    /// Creates a new builder-style object to manufacture [`InputSourceRequest`](crate::model::InputSourceRequest)
    pub fn builder() -> crate::model::input_source_request::Builder {
        crate::model::input_source_request::Builder::default()
    }
}

/// The settings for a MediaConnect Flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaConnectFlowRequest {
    /// The ARN of the MediaConnect Flow that you want to use as a source.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaConnectFlowRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaConnectFlowRequest");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}
/// See [`MediaConnectFlowRequest`](crate::model::MediaConnectFlowRequest)
pub mod media_connect_flow_request {
    /// A builder for [`MediaConnectFlowRequest`](crate::model::MediaConnectFlowRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the MediaConnect Flow that you want to use as a source.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the MediaConnect Flow that you want to use as a source.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaConnectFlowRequest`](crate::model::MediaConnectFlowRequest)
        pub fn build(self) -> crate::model::MediaConnectFlowRequest {
            crate::model::MediaConnectFlowRequest {
                flow_arn: self.flow_arn,
            }
        }
    }
}
impl MediaConnectFlowRequest {
    /// Creates a new builder-style object to manufacture [`MediaConnectFlowRequest`](crate::model::MediaConnectFlowRequest)
    pub fn builder() -> crate::model::media_connect_flow_request::Builder {
        crate::model::media_connect_flow_request::Builder::default()
    }
}

/// Settings for an input device.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDeviceRequest {
    /// The unique ID for the device.
    pub id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputDeviceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDeviceRequest");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`InputDeviceRequest`](crate::model::InputDeviceRequest)
pub mod input_device_request {
    /// A builder for [`InputDeviceRequest`](crate::model::InputDeviceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The unique ID for the device.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique ID for the device.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDeviceRequest`](crate::model::InputDeviceRequest)
        pub fn build(self) -> crate::model::InputDeviceRequest {
            crate::model::InputDeviceRequest { id: self.id }
        }
    }
}
impl InputDeviceRequest {
    /// Creates a new builder-style object to manufacture [`InputDeviceRequest`](crate::model::InputDeviceRequest)
    pub fn builder() -> crate::model::input_device_request::Builder {
        crate::model::input_device_request::Builder::default()
    }
}

/// Endpoint settings for a PUSH type input.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputDestinationRequest {
    /// A unique name for the location the RTMP stream is being pushed
    /// to.
    pub stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputDestinationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputDestinationRequest");
        formatter.field("stream_name", &self.stream_name);
        formatter.finish()
    }
}
/// See [`InputDestinationRequest`](crate::model::InputDestinationRequest)
pub mod input_destination_request {
    /// A builder for [`InputDestinationRequest`](crate::model::InputDestinationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A unique name for the location the RTMP stream is being pushed
        /// to.
        pub fn stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_name = Some(input.into());
            self
        }
        /// A unique name for the location the RTMP stream is being pushed
        /// to.
        pub fn set_stream_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`InputDestinationRequest`](crate::model::InputDestinationRequest)
        pub fn build(self) -> crate::model::InputDestinationRequest {
            crate::model::InputDestinationRequest {
                stream_name: self.stream_name,
            }
        }
    }
}
impl InputDestinationRequest {
    /// Creates a new builder-style object to manufacture [`InputDestinationRequest`](crate::model::InputDestinationRequest)
    pub fn builder() -> crate::model::input_destination_request::Builder {
        crate::model::input_destination_request::Builder::default()
    }
}

/// Placeholder documentation for Channel
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Channel {
    /// The unique arn of the channel.
    pub arn: std::option::Option<std::string::String>,
    /// Specification of CDI inputs for this channel
    pub cdi_input_specification: std::option::Option<crate::model::CdiInputSpecification>,
    /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
    pub channel_class: std::option::Option<crate::model::ChannelClass>,
    /// A list of destinations of the channel. For UDP outputs, there is one
    /// destination per output. For other types (HLS, for example), there is
    /// one destination per packager.
    pub destinations: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
    /// The endpoints where outgoing connections initiate from
    pub egress_endpoints: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
    /// Encoder Settings
    pub encoder_settings: std::option::Option<crate::model::EncoderSettings>,
    /// The unique id of the channel.
    pub id: std::option::Option<std::string::String>,
    /// List of input attachments for channel.
    pub input_attachments: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
    /// Specification of network and file inputs for this channel
    pub input_specification: std::option::Option<crate::model::InputSpecification>,
    /// The log level being written to CloudWatch Logs.
    pub log_level: std::option::Option<crate::model::LogLevel>,
    /// The name of the channel. (user-mutable)
    pub name: std::option::Option<std::string::String>,
    /// Runtime details for the pipelines of a running channel.
    pub pipeline_details: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
    /// The number of currently healthy pipelines.
    pub pipelines_running_count: i32,
    /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
    pub role_arn: std::option::Option<std::string::String>,
    /// Placeholder documentation for ChannelState
    pub state: std::option::Option<crate::model::ChannelState>,
    /// A collection of key-value pairs.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// Settings for VPC output
    pub vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
}
impl std::fmt::Debug for Channel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Channel");
        formatter.field("arn", &self.arn);
        formatter.field("cdi_input_specification", &self.cdi_input_specification);
        formatter.field("channel_class", &self.channel_class);
        formatter.field("destinations", &self.destinations);
        formatter.field("egress_endpoints", &self.egress_endpoints);
        formatter.field("encoder_settings", &self.encoder_settings);
        formatter.field("id", &self.id);
        formatter.field("input_attachments", &self.input_attachments);
        formatter.field("input_specification", &self.input_specification);
        formatter.field("log_level", &self.log_level);
        formatter.field("name", &self.name);
        formatter.field("pipeline_details", &self.pipeline_details);
        formatter.field("pipelines_running_count", &self.pipelines_running_count);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("state", &self.state);
        formatter.field("tags", &self.tags);
        formatter.field("vpc", &self.vpc);
        formatter.finish()
    }
}
/// See [`Channel`](crate::model::Channel)
pub mod channel {
    /// A builder for [`Channel`](crate::model::Channel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) cdi_input_specification:
            std::option::Option<crate::model::CdiInputSpecification>,
        pub(crate) channel_class: std::option::Option<crate::model::ChannelClass>,
        pub(crate) destinations:
            std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        pub(crate) egress_endpoints:
            std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        pub(crate) encoder_settings: std::option::Option<crate::model::EncoderSettings>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) input_attachments:
            std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        pub(crate) input_specification: std::option::Option<crate::model::InputSpecification>,
        pub(crate) log_level: std::option::Option<crate::model::LogLevel>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pipeline_details:
            std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        pub(crate) pipelines_running_count: std::option::Option<i32>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) state: std::option::Option<crate::model::ChannelState>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) vpc: std::option::Option<crate::model::VpcOutputSettingsDescription>,
    }
    impl Builder {
        /// The unique arn of the channel.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// The unique arn of the channel.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn cdi_input_specification(
            mut self,
            input: crate::model::CdiInputSpecification,
        ) -> Self {
            self.cdi_input_specification = Some(input);
            self
        }
        /// Specification of CDI inputs for this channel
        pub fn set_cdi_input_specification(
            mut self,
            input: std::option::Option<crate::model::CdiInputSpecification>,
        ) -> Self {
            self.cdi_input_specification = input;
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn channel_class(mut self, input: crate::model::ChannelClass) -> Self {
            self.channel_class = Some(input);
            self
        }
        /// The class for this channel. STANDARD for a channel with two pipelines or SINGLE_PIPELINE for a channel with one pipeline.
        pub fn set_channel_class(
            mut self,
            input: std::option::Option<crate::model::ChannelClass>,
        ) -> Self {
            self.channel_class = input;
            self
        }
        /// Appends an item to `destinations`.
        ///
        /// To override the contents of this collection use [`set_destinations`](Self::set_destinations).
        ///
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn destinations(mut self, input: impl Into<crate::model::OutputDestination>) -> Self {
            let mut v = self.destinations.unwrap_or_default();
            v.push(input.into());
            self.destinations = Some(v);
            self
        }
        /// A list of destinations of the channel. For UDP outputs, there is one
        /// destination per output. For other types (HLS, for example), there is
        /// one destination per packager.
        pub fn set_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputDestination>>,
        ) -> Self {
            self.destinations = input;
            self
        }
        /// Appends an item to `egress_endpoints`.
        ///
        /// To override the contents of this collection use [`set_egress_endpoints`](Self::set_egress_endpoints).
        ///
        /// The endpoints where outgoing connections initiate from
        pub fn egress_endpoints(
            mut self,
            input: impl Into<crate::model::ChannelEgressEndpoint>,
        ) -> Self {
            let mut v = self.egress_endpoints.unwrap_or_default();
            v.push(input.into());
            self.egress_endpoints = Some(v);
            self
        }
        /// The endpoints where outgoing connections initiate from
        pub fn set_egress_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ChannelEgressEndpoint>>,
        ) -> Self {
            self.egress_endpoints = input;
            self
        }
        /// Encoder Settings
        pub fn encoder_settings(mut self, input: crate::model::EncoderSettings) -> Self {
            self.encoder_settings = Some(input);
            self
        }
        /// Encoder Settings
        pub fn set_encoder_settings(
            mut self,
            input: std::option::Option<crate::model::EncoderSettings>,
        ) -> Self {
            self.encoder_settings = input;
            self
        }
        /// The unique id of the channel.
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// The unique id of the channel.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Appends an item to `input_attachments`.
        ///
        /// To override the contents of this collection use [`set_input_attachments`](Self::set_input_attachments).
        ///
        /// List of input attachments for channel.
        pub fn input_attachments(
            mut self,
            input: impl Into<crate::model::InputAttachment>,
        ) -> Self {
            let mut v = self.input_attachments.unwrap_or_default();
            v.push(input.into());
            self.input_attachments = Some(v);
            self
        }
        /// List of input attachments for channel.
        pub fn set_input_attachments(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputAttachment>>,
        ) -> Self {
            self.input_attachments = input;
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn input_specification(mut self, input: crate::model::InputSpecification) -> Self {
            self.input_specification = Some(input);
            self
        }
        /// Specification of network and file inputs for this channel
        pub fn set_input_specification(
            mut self,
            input: std::option::Option<crate::model::InputSpecification>,
        ) -> Self {
            self.input_specification = input;
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn log_level(mut self, input: crate::model::LogLevel) -> Self {
            self.log_level = Some(input);
            self
        }
        /// The log level being written to CloudWatch Logs.
        pub fn set_log_level(mut self, input: std::option::Option<crate::model::LogLevel>) -> Self {
            self.log_level = input;
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the channel. (user-mutable)
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `pipeline_details`.
        ///
        /// To override the contents of this collection use [`set_pipeline_details`](Self::set_pipeline_details).
        ///
        /// Runtime details for the pipelines of a running channel.
        pub fn pipeline_details(mut self, input: impl Into<crate::model::PipelineDetail>) -> Self {
            let mut v = self.pipeline_details.unwrap_or_default();
            v.push(input.into());
            self.pipeline_details = Some(v);
            self
        }
        /// Runtime details for the pipelines of a running channel.
        pub fn set_pipeline_details(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::PipelineDetail>>,
        ) -> Self {
            self.pipeline_details = input;
            self
        }
        /// The number of currently healthy pipelines.
        pub fn pipelines_running_count(mut self, input: i32) -> Self {
            self.pipelines_running_count = Some(input);
            self
        }
        /// The number of currently healthy pipelines.
        pub fn set_pipelines_running_count(mut self, input: std::option::Option<i32>) -> Self {
            self.pipelines_running_count = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn state(mut self, input: crate::model::ChannelState) -> Self {
            self.state = Some(input);
            self
        }
        /// Placeholder documentation for ChannelState
        pub fn set_state(mut self, input: std::option::Option<crate::model::ChannelState>) -> Self {
            self.state = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A collection of key-value pairs.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A collection of key-value pairs.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Settings for VPC output
        pub fn vpc(mut self, input: crate::model::VpcOutputSettingsDescription) -> Self {
            self.vpc = Some(input);
            self
        }
        /// Settings for VPC output
        pub fn set_vpc(
            mut self,
            input: std::option::Option<crate::model::VpcOutputSettingsDescription>,
        ) -> Self {
            self.vpc = input;
            self
        }
        /// Consumes the builder and constructs a [`Channel`](crate::model::Channel)
        pub fn build(self) -> crate::model::Channel {
            crate::model::Channel {
                arn: self.arn,
                cdi_input_specification: self.cdi_input_specification,
                channel_class: self.channel_class,
                destinations: self.destinations,
                egress_endpoints: self.egress_endpoints,
                encoder_settings: self.encoder_settings,
                id: self.id,
                input_attachments: self.input_attachments,
                input_specification: self.input_specification,
                log_level: self.log_level,
                name: self.name,
                pipeline_details: self.pipeline_details,
                pipelines_running_count: self.pipelines_running_count.unwrap_or_default(),
                role_arn: self.role_arn,
                state: self.state,
                tags: self.tags,
                vpc: self.vpc,
            }
        }
    }
}
impl Channel {
    /// Creates a new builder-style object to manufacture [`Channel`](crate::model::Channel)
    pub fn builder() -> crate::model::channel::Builder {
        crate::model::channel::Builder::default()
    }
}

/// The properties for a private VPC Output
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcOutputSettingsDescription {
    /// The Availability Zones where the vpc subnets are located.
    /// The first Availability Zone applies to the first subnet in the list of subnets.
    /// The second Availability Zone applies to the second subnet.
    pub availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of Elastic Network Interfaces created by MediaLive in the customer's VPC
    pub network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of up EC2 VPC security group IDs attached to the Output VPC network interfaces.
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A list of VPC subnet IDs from the same VPC.
    /// If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
    pub subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for VpcOutputSettingsDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcOutputSettingsDescription");
        formatter.field("availability_zones", &self.availability_zones);
        formatter.field("network_interface_ids", &self.network_interface_ids);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_ids", &self.subnet_ids);
        formatter.finish()
    }
}
/// See [`VpcOutputSettingsDescription`](crate::model::VpcOutputSettingsDescription)
pub mod vpc_output_settings_description {
    /// A builder for [`VpcOutputSettingsDescription`](crate::model::VpcOutputSettingsDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zones: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `availability_zones`.
        ///
        /// To override the contents of this collection use [`set_availability_zones`](Self::set_availability_zones).
        ///
        /// The Availability Zones where the vpc subnets are located.
        /// The first Availability Zone applies to the first subnet in the list of subnets.
        /// The second Availability Zone applies to the second subnet.
        pub fn availability_zones(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.availability_zones.unwrap_or_default();
            v.push(input.into());
            self.availability_zones = Some(v);
            self
        }
        /// The Availability Zones where the vpc subnets are located.
        /// The first Availability Zone applies to the first subnet in the list of subnets.
        /// The second Availability Zone applies to the second subnet.
        pub fn set_availability_zones(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.availability_zones = input;
            self
        }
        /// Appends an item to `network_interface_ids`.
        ///
        /// To override the contents of this collection use [`set_network_interface_ids`](Self::set_network_interface_ids).
        ///
        /// A list of Elastic Network Interfaces created by MediaLive in the customer's VPC
        pub fn network_interface_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.network_interface_ids.unwrap_or_default();
            v.push(input.into());
            self.network_interface_ids = Some(v);
            self
        }
        /// A list of Elastic Network Interfaces created by MediaLive in the customer's VPC
        pub fn set_network_interface_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.network_interface_ids = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// A list of up EC2 VPC security group IDs attached to the Output VPC network interfaces.
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// A list of up EC2 VPC security group IDs attached to the Output VPC network interfaces.
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Appends an item to `subnet_ids`.
        ///
        /// To override the contents of this collection use [`set_subnet_ids`](Self::set_subnet_ids).
        ///
        /// A list of VPC subnet IDs from the same VPC.
        /// If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
        pub fn subnet_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subnet_ids.unwrap_or_default();
            v.push(input.into());
            self.subnet_ids = Some(v);
            self
        }
        /// A list of VPC subnet IDs from the same VPC.
        /// If STANDARD channel, subnet IDs must be mapped to two unique availability zones (AZ).
        pub fn set_subnet_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subnet_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcOutputSettingsDescription`](crate::model::VpcOutputSettingsDescription)
        pub fn build(self) -> crate::model::VpcOutputSettingsDescription {
            crate::model::VpcOutputSettingsDescription {
                availability_zones: self.availability_zones,
                network_interface_ids: self.network_interface_ids,
                security_group_ids: self.security_group_ids,
                subnet_ids: self.subnet_ids,
            }
        }
    }
}
impl VpcOutputSettingsDescription {
    /// Creates a new builder-style object to manufacture [`VpcOutputSettingsDescription`](crate::model::VpcOutputSettingsDescription)
    pub fn builder() -> crate::model::vpc_output_settings_description::Builder {
        crate::model::vpc_output_settings_description::Builder::default()
    }
}

/// Placeholder documentation for ChannelState
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChannelState {
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    Recovering,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    UpdateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChannelState {
    fn from(s: &str) -> Self {
        match s {
            "CREATE_FAILED" => ChannelState::CreateFailed,
            "CREATING" => ChannelState::Creating,
            "DELETED" => ChannelState::Deleted,
            "DELETING" => ChannelState::Deleting,
            "IDLE" => ChannelState::Idle,
            "RECOVERING" => ChannelState::Recovering,
            "RUNNING" => ChannelState::Running,
            "STARTING" => ChannelState::Starting,
            "STOPPING" => ChannelState::Stopping,
            "UPDATE_FAILED" => ChannelState::UpdateFailed,
            "UPDATING" => ChannelState::Updating,
            other => ChannelState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChannelState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChannelState::from(s))
    }
}
impl ChannelState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChannelState::CreateFailed => "CREATE_FAILED",
            ChannelState::Creating => "CREATING",
            ChannelState::Deleted => "DELETED",
            ChannelState::Deleting => "DELETING",
            ChannelState::Idle => "IDLE",
            ChannelState::Recovering => "RECOVERING",
            ChannelState::Running => "RUNNING",
            ChannelState::Starting => "STARTING",
            ChannelState::Stopping => "STOPPING",
            ChannelState::UpdateFailed => "UPDATE_FAILED",
            ChannelState::Updating => "UPDATING",
            ChannelState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREATE_FAILED",
            "CREATING",
            "DELETED",
            "DELETING",
            "IDLE",
            "RECOVERING",
            "RUNNING",
            "STARTING",
            "STOPPING",
            "UPDATE_FAILED",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for ChannelState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Runtime details of a pipeline when a channel is running.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PipelineDetail {
    /// The name of the active input attachment currently being ingested by this pipeline.
    pub active_input_attachment_name: std::option::Option<std::string::String>,
    /// The name of the input switch schedule action that occurred most recently and that resulted in the switch to the current input attachment for this pipeline.
    pub active_input_switch_action_name: std::option::Option<std::string::String>,
    /// The name of the motion graphics activate action that occurred most recently and that resulted in the current graphics URI for this pipeline.
    pub active_motion_graphics_action_name: std::option::Option<std::string::String>,
    /// The current URI being used for HTML5 motion graphics for this pipeline.
    pub active_motion_graphics_uri: std::option::Option<std::string::String>,
    /// Pipeline ID
    pub pipeline_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PipelineDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PipelineDetail");
        formatter.field(
            "active_input_attachment_name",
            &self.active_input_attachment_name,
        );
        formatter.field(
            "active_input_switch_action_name",
            &self.active_input_switch_action_name,
        );
        formatter.field(
            "active_motion_graphics_action_name",
            &self.active_motion_graphics_action_name,
        );
        formatter.field(
            "active_motion_graphics_uri",
            &self.active_motion_graphics_uri,
        );
        formatter.field("pipeline_id", &self.pipeline_id);
        formatter.finish()
    }
}
/// See [`PipelineDetail`](crate::model::PipelineDetail)
pub mod pipeline_detail {
    /// A builder for [`PipelineDetail`](crate::model::PipelineDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) active_input_attachment_name: std::option::Option<std::string::String>,
        pub(crate) active_input_switch_action_name: std::option::Option<std::string::String>,
        pub(crate) active_motion_graphics_action_name: std::option::Option<std::string::String>,
        pub(crate) active_motion_graphics_uri: std::option::Option<std::string::String>,
        pub(crate) pipeline_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the active input attachment currently being ingested by this pipeline.
        pub fn active_input_attachment_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.active_input_attachment_name = Some(input.into());
            self
        }
        /// The name of the active input attachment currently being ingested by this pipeline.
        pub fn set_active_input_attachment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_input_attachment_name = input;
            self
        }
        /// The name of the input switch schedule action that occurred most recently and that resulted in the switch to the current input attachment for this pipeline.
        pub fn active_input_switch_action_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.active_input_switch_action_name = Some(input.into());
            self
        }
        /// The name of the input switch schedule action that occurred most recently and that resulted in the switch to the current input attachment for this pipeline.
        pub fn set_active_input_switch_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_input_switch_action_name = input;
            self
        }
        /// The name of the motion graphics activate action that occurred most recently and that resulted in the current graphics URI for this pipeline.
        pub fn active_motion_graphics_action_name(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.active_motion_graphics_action_name = Some(input.into());
            self
        }
        /// The name of the motion graphics activate action that occurred most recently and that resulted in the current graphics URI for this pipeline.
        pub fn set_active_motion_graphics_action_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_motion_graphics_action_name = input;
            self
        }
        /// The current URI being used for HTML5 motion graphics for this pipeline.
        pub fn active_motion_graphics_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.active_motion_graphics_uri = Some(input.into());
            self
        }
        /// The current URI being used for HTML5 motion graphics for this pipeline.
        pub fn set_active_motion_graphics_uri(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.active_motion_graphics_uri = input;
            self
        }
        /// Pipeline ID
        pub fn pipeline_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.pipeline_id = Some(input.into());
            self
        }
        /// Pipeline ID
        pub fn set_pipeline_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pipeline_id = input;
            self
        }
        /// Consumes the builder and constructs a [`PipelineDetail`](crate::model::PipelineDetail)
        pub fn build(self) -> crate::model::PipelineDetail {
            crate::model::PipelineDetail {
                active_input_attachment_name: self.active_input_attachment_name,
                active_input_switch_action_name: self.active_input_switch_action_name,
                active_motion_graphics_action_name: self.active_motion_graphics_action_name,
                active_motion_graphics_uri: self.active_motion_graphics_uri,
                pipeline_id: self.pipeline_id,
            }
        }
    }
}
impl PipelineDetail {
    /// Creates a new builder-style object to manufacture [`PipelineDetail`](crate::model::PipelineDetail)
    pub fn builder() -> crate::model::pipeline_detail::Builder {
        crate::model::pipeline_detail::Builder::default()
    }
}

/// The log level the user wants for their channel.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LogLevel {
    #[allow(missing_docs)] // documentation missing in model
    Debug,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Info,
    #[allow(missing_docs)] // documentation missing in model
    Warning,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LogLevel {
    fn from(s: &str) -> Self {
        match s {
            "DEBUG" => LogLevel::Debug,
            "DISABLED" => LogLevel::Disabled,
            "ERROR" => LogLevel::Error,
            "INFO" => LogLevel::Info,
            "WARNING" => LogLevel::Warning,
            other => LogLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LogLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LogLevel::from(s))
    }
}
impl LogLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LogLevel::Debug => "DEBUG",
            LogLevel::Disabled => "DISABLED",
            LogLevel::Error => "ERROR",
            LogLevel::Info => "INFO",
            LogLevel::Warning => "WARNING",
            LogLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEBUG", "DISABLED", "ERROR", "INFO", "WARNING"]
    }
}
impl AsRef<str> for LogLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Placeholder documentation for InputSpecification
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSpecification {
    /// Input codec
    pub codec: std::option::Option<crate::model::InputCodec>,
    /// Maximum input bitrate, categorized coarsely
    pub maximum_bitrate: std::option::Option<crate::model::InputMaximumBitrate>,
    /// Input resolution, categorized coarsely
    pub resolution: std::option::Option<crate::model::InputResolution>,
}
impl std::fmt::Debug for InputSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSpecification");
        formatter.field("codec", &self.codec);
        formatter.field("maximum_bitrate", &self.maximum_bitrate);
        formatter.field("resolution", &self.resolution);
        formatter.finish()
    }
}
/// See [`InputSpecification`](crate::model::InputSpecification)
pub mod input_specification {
    /// A builder for [`InputSpecification`](crate::model::InputSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) codec: std::option::Option<crate::model::InputCodec>,
        pub(crate) maximum_bitrate: std::option::Option<crate::model::InputMaximumBitrate>,
        pub(crate) resolution: std::option::Option<crate::model::InputResolution>,
    }
    impl Builder {
        /// Input codec
        pub fn codec(mut self, input: crate::model::InputCodec) -> Self {
            self.codec = Some(input);
            self
        }
        /// Input codec
        pub fn set_codec(mut self, input: std::option::Option<crate::model::InputCodec>) -> Self {
            self.codec = input;
            self
        }
        /// Maximum input bitrate, categorized coarsely
        pub fn maximum_bitrate(mut self, input: crate::model::InputMaximumBitrate) -> Self {
            self.maximum_bitrate = Some(input);
            self
        }
        /// Maximum input bitrate, categorized coarsely
        pub fn set_maximum_bitrate(
            mut self,
            input: std::option::Option<crate::model::InputMaximumBitrate>,
        ) -> Self {
            self.maximum_bitrate = input;
            self
        }
        /// Input resolution, categorized coarsely
        pub fn resolution(mut self, input: crate::model::InputResolution) -> Self {
            self.resolution = Some(input);
            self
        }
        /// Input resolution, categorized coarsely
        pub fn set_resolution(
            mut self,
            input: std::option::Option<crate::model::InputResolution>,
        ) -> Self {
            self.resolution = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSpecification`](crate::model::InputSpecification)
        pub fn build(self) -> crate::model::InputSpecification {
            crate::model::InputSpecification {
                codec: self.codec,
                maximum_bitrate: self.maximum_bitrate,
                resolution: self.resolution,
            }
        }
    }
}
impl InputSpecification {
    /// Creates a new builder-style object to manufacture [`InputSpecification`](crate::model::InputSpecification)
    pub fn builder() -> crate::model::input_specification::Builder {
        crate::model::input_specification::Builder::default()
    }
}

/// Input resolution based on lines of vertical resolution in the input; SD is less than 720 lines, HD is 720 to 1080 lines, UHD is greater than 1080 lines
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputResolution {
    #[allow(missing_docs)] // documentation missing in model
    Hd,
    #[allow(missing_docs)] // documentation missing in model
    Sd,
    #[allow(missing_docs)] // documentation missing in model
    Uhd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputResolution {
    fn from(s: &str) -> Self {
        match s {
            "HD" => InputResolution::Hd,
            "SD" => InputResolution::Sd,
            "UHD" => InputResolution::Uhd,
            other => InputResolution::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputResolution {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputResolution::from(s))
    }
}
impl InputResolution {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputResolution::Hd => "HD",
            InputResolution::Sd => "SD",
            InputResolution::Uhd => "UHD",
            InputResolution::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HD", "SD", "UHD"]
    }
}
impl AsRef<str> for InputResolution {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Maximum input bitrate in megabits per second. Bitrates up to 50 Mbps are supported currently.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputMaximumBitrate {
    #[allow(missing_docs)] // documentation missing in model
    Max10Mbps,
    #[allow(missing_docs)] // documentation missing in model
    Max20Mbps,
    #[allow(missing_docs)] // documentation missing in model
    Max50Mbps,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputMaximumBitrate {
    fn from(s: &str) -> Self {
        match s {
            "MAX_10_MBPS" => InputMaximumBitrate::Max10Mbps,
            "MAX_20_MBPS" => InputMaximumBitrate::Max20Mbps,
            "MAX_50_MBPS" => InputMaximumBitrate::Max50Mbps,
            other => InputMaximumBitrate::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputMaximumBitrate {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputMaximumBitrate::from(s))
    }
}
impl InputMaximumBitrate {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputMaximumBitrate::Max10Mbps => "MAX_10_MBPS",
            InputMaximumBitrate::Max20Mbps => "MAX_20_MBPS",
            InputMaximumBitrate::Max50Mbps => "MAX_50_MBPS",
            InputMaximumBitrate::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAX_10_MBPS", "MAX_20_MBPS", "MAX_50_MBPS"]
    }
}
impl AsRef<str> for InputMaximumBitrate {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// codec in increasing order of complexity
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputCodec {
    #[allow(missing_docs)] // documentation missing in model
    Avc,
    #[allow(missing_docs)] // documentation missing in model
    Hevc,
    #[allow(missing_docs)] // documentation missing in model
    Mpeg2,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputCodec {
    fn from(s: &str) -> Self {
        match s {
            "AVC" => InputCodec::Avc,
            "HEVC" => InputCodec::Hevc,
            "MPEG2" => InputCodec::Mpeg2,
            other => InputCodec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputCodec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputCodec::from(s))
    }
}
impl InputCodec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputCodec::Avc => "AVC",
            InputCodec::Hevc => "HEVC",
            InputCodec::Mpeg2 => "MPEG2",
            InputCodec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AVC", "HEVC", "MPEG2"]
    }
}
impl AsRef<str> for InputCodec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Placeholder documentation for InputAttachment
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputAttachment {
    /// User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input.
    pub automatic_input_failover_settings:
        std::option::Option<crate::model::AutomaticInputFailoverSettings>,
    /// User-specified name for the attachment. This is required if the user wants to use this input in an input switch action.
    pub input_attachment_name: std::option::Option<std::string::String>,
    /// The ID of the input
    pub input_id: std::option::Option<std::string::String>,
    /// Settings of an input (caption selector, etc.)
    pub input_settings: std::option::Option<crate::model::InputSettings>,
}
impl std::fmt::Debug for InputAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputAttachment");
        formatter.field(
            "automatic_input_failover_settings",
            &self.automatic_input_failover_settings,
        );
        formatter.field("input_attachment_name", &self.input_attachment_name);
        formatter.field("input_id", &self.input_id);
        formatter.field("input_settings", &self.input_settings);
        formatter.finish()
    }
}
/// See [`InputAttachment`](crate::model::InputAttachment)
pub mod input_attachment {
    /// A builder for [`InputAttachment`](crate::model::InputAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) automatic_input_failover_settings:
            std::option::Option<crate::model::AutomaticInputFailoverSettings>,
        pub(crate) input_attachment_name: std::option::Option<std::string::String>,
        pub(crate) input_id: std::option::Option<std::string::String>,
        pub(crate) input_settings: std::option::Option<crate::model::InputSettings>,
    }
    impl Builder {
        /// User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input.
        pub fn automatic_input_failover_settings(
            mut self,
            input: crate::model::AutomaticInputFailoverSettings,
        ) -> Self {
            self.automatic_input_failover_settings = Some(input);
            self
        }
        /// User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input.
        pub fn set_automatic_input_failover_settings(
            mut self,
            input: std::option::Option<crate::model::AutomaticInputFailoverSettings>,
        ) -> Self {
            self.automatic_input_failover_settings = input;
            self
        }
        /// User-specified name for the attachment. This is required if the user wants to use this input in an input switch action.
        pub fn input_attachment_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_attachment_name = Some(input.into());
            self
        }
        /// User-specified name for the attachment. This is required if the user wants to use this input in an input switch action.
        pub fn set_input_attachment_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_attachment_name = input;
            self
        }
        /// The ID of the input
        pub fn input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_id = Some(input.into());
            self
        }
        /// The ID of the input
        pub fn set_input_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_id = input;
            self
        }
        /// Settings of an input (caption selector, etc.)
        pub fn input_settings(mut self, input: crate::model::InputSettings) -> Self {
            self.input_settings = Some(input);
            self
        }
        /// Settings of an input (caption selector, etc.)
        pub fn set_input_settings(
            mut self,
            input: std::option::Option<crate::model::InputSettings>,
        ) -> Self {
            self.input_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`InputAttachment`](crate::model::InputAttachment)
        pub fn build(self) -> crate::model::InputAttachment {
            crate::model::InputAttachment {
                automatic_input_failover_settings: self.automatic_input_failover_settings,
                input_attachment_name: self.input_attachment_name,
                input_id: self.input_id,
                input_settings: self.input_settings,
            }
        }
    }
}
impl InputAttachment {
    /// Creates a new builder-style object to manufacture [`InputAttachment`](crate::model::InputAttachment)
    pub fn builder() -> crate::model::input_attachment::Builder {
        crate::model::input_attachment::Builder::default()
    }
}

/// Live Event input parameters. There can be multiple inputs in a single Live Event.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputSettings {
    /// Used to select the audio stream to decode for inputs that have multiple available.
    pub audio_selectors: std::option::Option<std::vec::Vec<crate::model::AudioSelector>>,
    /// Used to select the caption input to use for inputs that have multiple available.
    pub caption_selectors: std::option::Option<std::vec::Vec<crate::model::CaptionSelector>>,
    /// Enable or disable the deblock filter when filtering.
    pub deblock_filter: std::option::Option<crate::model::InputDeblockFilter>,
    /// Enable or disable the denoise filter when filtering.
    pub denoise_filter: std::option::Option<crate::model::InputDenoiseFilter>,
    /// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
    pub filter_strength: i32,
    /// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default.
    /// 1) auto - filtering will be applied depending on input type/quality
    /// 2) disabled - no filtering will be applied to the input
    /// 3) forced - filtering will be applied regardless of input type
    pub input_filter: std::option::Option<crate::model::InputFilter>,
    /// Input settings.
    pub network_input_settings: std::option::Option<crate::model::NetworkInputSettings>,
    /// Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages.
    /// - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any).
    /// - IGNORE: Never extract any ancillary data from SMPTE-2038.
    pub smpte2038_data_preference: std::option::Option<crate::model::Smpte2038DataPreference>,
    /// Loop input if it is a file. This allows a file input to be streamed indefinitely.
    pub source_end_behavior: std::option::Option<crate::model::InputSourceEndBehavior>,
    /// Informs which video elementary stream to decode for input types that have multiple available.
    pub video_selector: std::option::Option<crate::model::VideoSelector>,
}
impl std::fmt::Debug for InputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputSettings");
        formatter.field("audio_selectors", &self.audio_selectors);
        formatter.field("caption_selectors", &self.caption_selectors);
        formatter.field("deblock_filter", &self.deblock_filter);
        formatter.field("denoise_filter", &self.denoise_filter);
        formatter.field("filter_strength", &self.filter_strength);
        formatter.field("input_filter", &self.input_filter);
        formatter.field("network_input_settings", &self.network_input_settings);
        formatter.field("smpte2038_data_preference", &self.smpte2038_data_preference);
        formatter.field("source_end_behavior", &self.source_end_behavior);
        formatter.field("video_selector", &self.video_selector);
        formatter.finish()
    }
}
/// See [`InputSettings`](crate::model::InputSettings)
pub mod input_settings {
    /// A builder for [`InputSettings`](crate::model::InputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_selectors: std::option::Option<std::vec::Vec<crate::model::AudioSelector>>,
        pub(crate) caption_selectors:
            std::option::Option<std::vec::Vec<crate::model::CaptionSelector>>,
        pub(crate) deblock_filter: std::option::Option<crate::model::InputDeblockFilter>,
        pub(crate) denoise_filter: std::option::Option<crate::model::InputDenoiseFilter>,
        pub(crate) filter_strength: std::option::Option<i32>,
        pub(crate) input_filter: std::option::Option<crate::model::InputFilter>,
        pub(crate) network_input_settings: std::option::Option<crate::model::NetworkInputSettings>,
        pub(crate) smpte2038_data_preference:
            std::option::Option<crate::model::Smpte2038DataPreference>,
        pub(crate) source_end_behavior: std::option::Option<crate::model::InputSourceEndBehavior>,
        pub(crate) video_selector: std::option::Option<crate::model::VideoSelector>,
    }
    impl Builder {
        /// Appends an item to `audio_selectors`.
        ///
        /// To override the contents of this collection use [`set_audio_selectors`](Self::set_audio_selectors).
        ///
        /// Used to select the audio stream to decode for inputs that have multiple available.
        pub fn audio_selectors(mut self, input: impl Into<crate::model::AudioSelector>) -> Self {
            let mut v = self.audio_selectors.unwrap_or_default();
            v.push(input.into());
            self.audio_selectors = Some(v);
            self
        }
        /// Used to select the audio stream to decode for inputs that have multiple available.
        pub fn set_audio_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AudioSelector>>,
        ) -> Self {
            self.audio_selectors = input;
            self
        }
        /// Appends an item to `caption_selectors`.
        ///
        /// To override the contents of this collection use [`set_caption_selectors`](Self::set_caption_selectors).
        ///
        /// Used to select the caption input to use for inputs that have multiple available.
        pub fn caption_selectors(
            mut self,
            input: impl Into<crate::model::CaptionSelector>,
        ) -> Self {
            let mut v = self.caption_selectors.unwrap_or_default();
            v.push(input.into());
            self.caption_selectors = Some(v);
            self
        }
        /// Used to select the caption input to use for inputs that have multiple available.
        pub fn set_caption_selectors(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaptionSelector>>,
        ) -> Self {
            self.caption_selectors = input;
            self
        }
        /// Enable or disable the deblock filter when filtering.
        pub fn deblock_filter(mut self, input: crate::model::InputDeblockFilter) -> Self {
            self.deblock_filter = Some(input);
            self
        }
        /// Enable or disable the deblock filter when filtering.
        pub fn set_deblock_filter(
            mut self,
            input: std::option::Option<crate::model::InputDeblockFilter>,
        ) -> Self {
            self.deblock_filter = input;
            self
        }
        /// Enable or disable the denoise filter when filtering.
        pub fn denoise_filter(mut self, input: crate::model::InputDenoiseFilter) -> Self {
            self.denoise_filter = Some(input);
            self
        }
        /// Enable or disable the denoise filter when filtering.
        pub fn set_denoise_filter(
            mut self,
            input: std::option::Option<crate::model::InputDenoiseFilter>,
        ) -> Self {
            self.denoise_filter = input;
            self
        }
        /// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
        pub fn filter_strength(mut self, input: i32) -> Self {
            self.filter_strength = Some(input);
            self
        }
        /// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
        pub fn set_filter_strength(mut self, input: std::option::Option<i32>) -> Self {
            self.filter_strength = input;
            self
        }
        /// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default.
        /// 1) auto - filtering will be applied depending on input type/quality
        /// 2) disabled - no filtering will be applied to the input
        /// 3) forced - filtering will be applied regardless of input type
        pub fn input_filter(mut self, input: crate::model::InputFilter) -> Self {
            self.input_filter = Some(input);
            self
        }
        /// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter enabled by default.
        /// 1) auto - filtering will be applied depending on input type/quality
        /// 2) disabled - no filtering will be applied to the input
        /// 3) forced - filtering will be applied regardless of input type
        pub fn set_input_filter(
            mut self,
            input: std::option::Option<crate::model::InputFilter>,
        ) -> Self {
            self.input_filter = input;
            self
        }
        /// Input settings.
        pub fn network_input_settings(mut self, input: crate::model::NetworkInputSettings) -> Self {
            self.network_input_settings = Some(input);
            self
        }
        /// Input settings.
        pub fn set_network_input_settings(
            mut self,
            input: std::option::Option<crate::model::NetworkInputSettings>,
        ) -> Self {
            self.network_input_settings = input;
            self
        }
        /// Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages.
        /// - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any).
        /// - IGNORE: Never extract any ancillary data from SMPTE-2038.
        pub fn smpte2038_data_preference(
            mut self,
            input: crate::model::Smpte2038DataPreference,
        ) -> Self {
            self.smpte2038_data_preference = Some(input);
            self
        }
        /// Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in this input. Applicable data types are captions, timecode, AFD, and SCTE-104 messages.
        /// - PREFER: Extract from SMPTE-2038 if present in this input, otherwise extract from another source (if any).
        /// - IGNORE: Never extract any ancillary data from SMPTE-2038.
        pub fn set_smpte2038_data_preference(
            mut self,
            input: std::option::Option<crate::model::Smpte2038DataPreference>,
        ) -> Self {
            self.smpte2038_data_preference = input;
            self
        }
        /// Loop input if it is a file. This allows a file input to be streamed indefinitely.
        pub fn source_end_behavior(mut self, input: crate::model::InputSourceEndBehavior) -> Self {
            self.source_end_behavior = Some(input);
            self
        }
        /// Loop input if it is a file. This allows a file input to be streamed indefinitely.
        pub fn set_source_end_behavior(
            mut self,
            input: std::option::Option<crate::model::InputSourceEndBehavior>,
        ) -> Self {
            self.source_end_behavior = input;
            self
        }
        /// Informs which video elementary stream to decode for input types that have multiple available.
        pub fn video_selector(mut self, input: crate::model::VideoSelector) -> Self {
            self.video_selector = Some(input);
            self
        }
        /// Informs which video elementary stream to decode for input types that have multiple available.
        pub fn set_video_selector(
            mut self,
            input: std::option::Option<crate::model::VideoSelector>,
        ) -> Self {
            self.video_selector = input;
            self
        }
        /// Consumes the builder and constructs a [`InputSettings`](crate::model::InputSettings)
        pub fn build(self) -> crate::model::InputSettings {
            crate::model::InputSettings {
                audio_selectors: self.audio_selectors,
                caption_selectors: self.caption_selectors,
                deblock_filter: self.deblock_filter,
                denoise_filter: self.denoise_filter,
                filter_strength: self.filter_strength.unwrap_or_default(),
                input_filter: self.input_filter,
                network_input_settings: self.network_input_settings,
                smpte2038_data_preference: self.smpte2038_data_preference,
                source_end_behavior: self.source_end_behavior,
                video_selector: self.video_selector,
            }
        }
    }
}
impl InputSettings {
    /// Creates a new builder-style object to manufacture [`InputSettings`](crate::model::InputSettings)
    pub fn builder() -> crate::model::input_settings::Builder {
        crate::model::input_settings::Builder::default()
    }
}

/// Specifies a particular video stream within an input source. An input may have only a single video selector.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoSelector {
    /// Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video description's colorSpaceSettingsChoice to determine if any conversion will be performed.
    pub color_space: std::option::Option<crate::model::VideoSelectorColorSpace>,
    /// Color space settings
    pub color_space_settings: std::option::Option<crate::model::VideoSelectorColorSpaceSettings>,
    /// Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace field will be used. fallback means that when the input does include color space data, that data will be used, but when the input has no color space data, the value in colorSpace will be used. Choose fallback if your input is sometimes missing color space data, but when it does have color space data, that data is correct. force means to always use the value in colorSpace. Choose force if your input usually has no color space data or might have unreliable color space data.
    pub color_space_usage: std::option::Option<crate::model::VideoSelectorColorSpaceUsage>,
    /// The video selector settings.
    pub selector_settings: std::option::Option<crate::model::VideoSelectorSettings>,
}
impl std::fmt::Debug for VideoSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoSelector");
        formatter.field("color_space", &self.color_space);
        formatter.field("color_space_settings", &self.color_space_settings);
        formatter.field("color_space_usage", &self.color_space_usage);
        formatter.field("selector_settings", &self.selector_settings);
        formatter.finish()
    }
}
/// See [`VideoSelector`](crate::model::VideoSelector)
pub mod video_selector {
    /// A builder for [`VideoSelector`](crate::model::VideoSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) color_space: std::option::Option<crate::model::VideoSelectorColorSpace>,
        pub(crate) color_space_settings:
            std::option::Option<crate::model::VideoSelectorColorSpaceSettings>,
        pub(crate) color_space_usage:
            std::option::Option<crate::model::VideoSelectorColorSpaceUsage>,
        pub(crate) selector_settings: std::option::Option<crate::model::VideoSelectorSettings>,
    }
    impl Builder {
        /// Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video description's colorSpaceSettingsChoice to determine if any conversion will be performed.
        pub fn color_space(mut self, input: crate::model::VideoSelectorColorSpace) -> Self {
            self.color_space = Some(input);
            self
        }
        /// Specifies the color space of an input. This setting works in tandem with colorSpaceUsage and a video description's colorSpaceSettingsChoice to determine if any conversion will be performed.
        pub fn set_color_space(
            mut self,
            input: std::option::Option<crate::model::VideoSelectorColorSpace>,
        ) -> Self {
            self.color_space = input;
            self
        }
        /// Color space settings
        pub fn color_space_settings(
            mut self,
            input: crate::model::VideoSelectorColorSpaceSettings,
        ) -> Self {
            self.color_space_settings = Some(input);
            self
        }
        /// Color space settings
        pub fn set_color_space_settings(
            mut self,
            input: std::option::Option<crate::model::VideoSelectorColorSpaceSettings>,
        ) -> Self {
            self.color_space_settings = input;
            self
        }
        /// Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace field will be used. fallback means that when the input does include color space data, that data will be used, but when the input has no color space data, the value in colorSpace will be used. Choose fallback if your input is sometimes missing color space data, but when it does have color space data, that data is correct. force means to always use the value in colorSpace. Choose force if your input usually has no color space data or might have unreliable color space data.
        pub fn color_space_usage(
            mut self,
            input: crate::model::VideoSelectorColorSpaceUsage,
        ) -> Self {
            self.color_space_usage = Some(input);
            self
        }
        /// Applies only if colorSpace is a value other than follow. This field controls how the value in the colorSpace field will be used. fallback means that when the input does include color space data, that data will be used, but when the input has no color space data, the value in colorSpace will be used. Choose fallback if your input is sometimes missing color space data, but when it does have color space data, that data is correct. force means to always use the value in colorSpace. Choose force if your input usually has no color space data or might have unreliable color space data.
        pub fn set_color_space_usage(
            mut self,
            input: std::option::Option<crate::model::VideoSelectorColorSpaceUsage>,
        ) -> Self {
            self.color_space_usage = input;
            self
        }
        /// The video selector settings.
        pub fn selector_settings(mut self, input: crate::model::VideoSelectorSettings) -> Self {
            self.selector_settings = Some(input);
            self
        }
        /// The video selector settings.
        pub fn set_selector_settings(
            mut self,
            input: std::option::Option<crate::model::VideoSelectorSettings>,
        ) -> Self {
            self.selector_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoSelector`](crate::model::VideoSelector)
        pub fn build(self) -> crate::model::VideoSelector {
            crate::model::VideoSelector {
                color_space: self.color_space,
                color_space_settings: self.color_space_settings,
                color_space_usage: self.color_space_usage,
                selector_settings: self.selector_settings,
            }
        }
    }
}
impl VideoSelector {
    /// Creates a new builder-style object to manufacture [`VideoSelector`](crate::model::VideoSelector)
    pub fn builder() -> crate::model::video_selector::Builder {
        crate::model::video_selector::Builder::default()
    }
}

/// Video Selector Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoSelectorSettings {
    /// Video Selector Pid
    pub video_selector_pid: std::option::Option<crate::model::VideoSelectorPid>,
    /// Video Selector Program Id
    pub video_selector_program_id: std::option::Option<crate::model::VideoSelectorProgramId>,
}
impl std::fmt::Debug for VideoSelectorSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoSelectorSettings");
        formatter.field("video_selector_pid", &self.video_selector_pid);
        formatter.field("video_selector_program_id", &self.video_selector_program_id);
        formatter.finish()
    }
}
/// See [`VideoSelectorSettings`](crate::model::VideoSelectorSettings)
pub mod video_selector_settings {
    /// A builder for [`VideoSelectorSettings`](crate::model::VideoSelectorSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) video_selector_pid: std::option::Option<crate::model::VideoSelectorPid>,
        pub(crate) video_selector_program_id:
            std::option::Option<crate::model::VideoSelectorProgramId>,
    }
    impl Builder {
        /// Video Selector Pid
        pub fn video_selector_pid(mut self, input: crate::model::VideoSelectorPid) -> Self {
            self.video_selector_pid = Some(input);
            self
        }
        /// Video Selector Pid
        pub fn set_video_selector_pid(
            mut self,
            input: std::option::Option<crate::model::VideoSelectorPid>,
        ) -> Self {
            self.video_selector_pid = input;
            self
        }
        /// Video Selector Program Id
        pub fn video_selector_program_id(
            mut self,
            input: crate::model::VideoSelectorProgramId,
        ) -> Self {
            self.video_selector_program_id = Some(input);
            self
        }
        /// Video Selector Program Id
        pub fn set_video_selector_program_id(
            mut self,
            input: std::option::Option<crate::model::VideoSelectorProgramId>,
        ) -> Self {
            self.video_selector_program_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoSelectorSettings`](crate::model::VideoSelectorSettings)
        pub fn build(self) -> crate::model::VideoSelectorSettings {
            crate::model::VideoSelectorSettings {
                video_selector_pid: self.video_selector_pid,
                video_selector_program_id: self.video_selector_program_id,
            }
        }
    }
}
impl VideoSelectorSettings {
    /// Creates a new builder-style object to manufacture [`VideoSelectorSettings`](crate::model::VideoSelectorSettings)
    pub fn builder() -> crate::model::video_selector_settings::Builder {
        crate::model::video_selector_settings::Builder::default()
    }
}

/// Video Selector Program Id
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoSelectorProgramId {
    /// Selects a specific program from within a multi-program transport stream. If the program doesn't exist, the first program within the transport stream will be selected by default.
    pub program_id: i32,
}
impl std::fmt::Debug for VideoSelectorProgramId {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoSelectorProgramId");
        formatter.field("program_id", &self.program_id);
        formatter.finish()
    }
}
/// See [`VideoSelectorProgramId`](crate::model::VideoSelectorProgramId)
pub mod video_selector_program_id {
    /// A builder for [`VideoSelectorProgramId`](crate::model::VideoSelectorProgramId)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) program_id: std::option::Option<i32>,
    }
    impl Builder {
        /// Selects a specific program from within a multi-program transport stream. If the program doesn't exist, the first program within the transport stream will be selected by default.
        pub fn program_id(mut self, input: i32) -> Self {
            self.program_id = Some(input);
            self
        }
        /// Selects a specific program from within a multi-program transport stream. If the program doesn't exist, the first program within the transport stream will be selected by default.
        pub fn set_program_id(mut self, input: std::option::Option<i32>) -> Self {
            self.program_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoSelectorProgramId`](crate::model::VideoSelectorProgramId)
        pub fn build(self) -> crate::model::VideoSelectorProgramId {
            crate::model::VideoSelectorProgramId {
                program_id: self.program_id.unwrap_or_default(),
            }
        }
    }
}
impl VideoSelectorProgramId {
    /// Creates a new builder-style object to manufacture [`VideoSelectorProgramId`](crate::model::VideoSelectorProgramId)
    pub fn builder() -> crate::model::video_selector_program_id::Builder {
        crate::model::video_selector_program_id::Builder::default()
    }
}

/// Video Selector Pid
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoSelectorPid {
    /// Selects a specific PID from within a video source.
    pub pid: i32,
}
impl std::fmt::Debug for VideoSelectorPid {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoSelectorPid");
        formatter.field("pid", &self.pid);
        formatter.finish()
    }
}
/// See [`VideoSelectorPid`](crate::model::VideoSelectorPid)
pub mod video_selector_pid {
    /// A builder for [`VideoSelectorPid`](crate::model::VideoSelectorPid)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pid: std::option::Option<i32>,
    }
    impl Builder {
        /// Selects a specific PID from within a video source.
        pub fn pid(mut self, input: i32) -> Self {
            self.pid = Some(input);
            self
        }
        /// Selects a specific PID from within a video source.
        pub fn set_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.pid = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoSelectorPid`](crate::model::VideoSelectorPid)
        pub fn build(self) -> crate::model::VideoSelectorPid {
            crate::model::VideoSelectorPid {
                pid: self.pid.unwrap_or_default(),
            }
        }
    }
}
impl VideoSelectorPid {
    /// Creates a new builder-style object to manufacture [`VideoSelectorPid`](crate::model::VideoSelectorPid)
    pub fn builder() -> crate::model::video_selector_pid::Builder {
        crate::model::video_selector_pid::Builder::default()
    }
}

/// Video Selector Color Space Usage
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoSelectorColorSpaceUsage {
    #[allow(missing_docs)] // documentation missing in model
    Fallback,
    #[allow(missing_docs)] // documentation missing in model
    Force,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoSelectorColorSpaceUsage {
    fn from(s: &str) -> Self {
        match s {
            "FALLBACK" => VideoSelectorColorSpaceUsage::Fallback,
            "FORCE" => VideoSelectorColorSpaceUsage::Force,
            other => VideoSelectorColorSpaceUsage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoSelectorColorSpaceUsage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoSelectorColorSpaceUsage::from(s))
    }
}
impl VideoSelectorColorSpaceUsage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoSelectorColorSpaceUsage::Fallback => "FALLBACK",
            VideoSelectorColorSpaceUsage::Force => "FORCE",
            VideoSelectorColorSpaceUsage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALLBACK", "FORCE"]
    }
}
impl AsRef<str> for VideoSelectorColorSpaceUsage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Video Selector Color Space Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoSelectorColorSpaceSettings {
    /// Hdr10 Settings
    pub hdr10_settings: std::option::Option<crate::model::Hdr10Settings>,
}
impl std::fmt::Debug for VideoSelectorColorSpaceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoSelectorColorSpaceSettings");
        formatter.field("hdr10_settings", &self.hdr10_settings);
        formatter.finish()
    }
}
/// See [`VideoSelectorColorSpaceSettings`](crate::model::VideoSelectorColorSpaceSettings)
pub mod video_selector_color_space_settings {
    /// A builder for [`VideoSelectorColorSpaceSettings`](crate::model::VideoSelectorColorSpaceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hdr10_settings: std::option::Option<crate::model::Hdr10Settings>,
    }
    impl Builder {
        /// Hdr10 Settings
        pub fn hdr10_settings(mut self, input: crate::model::Hdr10Settings) -> Self {
            self.hdr10_settings = Some(input);
            self
        }
        /// Hdr10 Settings
        pub fn set_hdr10_settings(
            mut self,
            input: std::option::Option<crate::model::Hdr10Settings>,
        ) -> Self {
            self.hdr10_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoSelectorColorSpaceSettings`](crate::model::VideoSelectorColorSpaceSettings)
        pub fn build(self) -> crate::model::VideoSelectorColorSpaceSettings {
            crate::model::VideoSelectorColorSpaceSettings {
                hdr10_settings: self.hdr10_settings,
            }
        }
    }
}
impl VideoSelectorColorSpaceSettings {
    /// Creates a new builder-style object to manufacture [`VideoSelectorColorSpaceSettings`](crate::model::VideoSelectorColorSpaceSettings)
    pub fn builder() -> crate::model::video_selector_color_space_settings::Builder {
        crate::model::video_selector_color_space_settings::Builder::default()
    }
}

/// Hdr10 Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hdr10Settings {
    /// Maximum Content Light Level
    /// An integer metadata value defining the maximum light level, in nits,
    /// of any single pixel within an encoded HDR video stream or file.
    pub max_cll: i32,
    /// Maximum Frame Average Light Level
    /// An integer metadata value defining the maximum average light level, in nits,
    /// for any single frame within an encoded HDR video stream or file.
    pub max_fall: i32,
}
impl std::fmt::Debug for Hdr10Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hdr10Settings");
        formatter.field("max_cll", &self.max_cll);
        formatter.field("max_fall", &self.max_fall);
        formatter.finish()
    }
}
/// See [`Hdr10Settings`](crate::model::Hdr10Settings)
pub mod hdr10_settings {
    /// A builder for [`Hdr10Settings`](crate::model::Hdr10Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_cll: std::option::Option<i32>,
        pub(crate) max_fall: std::option::Option<i32>,
    }
    impl Builder {
        /// Maximum Content Light Level
        /// An integer metadata value defining the maximum light level, in nits,
        /// of any single pixel within an encoded HDR video stream or file.
        pub fn max_cll(mut self, input: i32) -> Self {
            self.max_cll = Some(input);
            self
        }
        /// Maximum Content Light Level
        /// An integer metadata value defining the maximum light level, in nits,
        /// of any single pixel within an encoded HDR video stream or file.
        pub fn set_max_cll(mut self, input: std::option::Option<i32>) -> Self {
            self.max_cll = input;
            self
        }
        /// Maximum Frame Average Light Level
        /// An integer metadata value defining the maximum average light level, in nits,
        /// for any single frame within an encoded HDR video stream or file.
        pub fn max_fall(mut self, input: i32) -> Self {
            self.max_fall = Some(input);
            self
        }
        /// Maximum Frame Average Light Level
        /// An integer metadata value defining the maximum average light level, in nits,
        /// for any single frame within an encoded HDR video stream or file.
        pub fn set_max_fall(mut self, input: std::option::Option<i32>) -> Self {
            self.max_fall = input;
            self
        }
        /// Consumes the builder and constructs a [`Hdr10Settings`](crate::model::Hdr10Settings)
        pub fn build(self) -> crate::model::Hdr10Settings {
            crate::model::Hdr10Settings {
                max_cll: self.max_cll.unwrap_or_default(),
                max_fall: self.max_fall.unwrap_or_default(),
            }
        }
    }
}
impl Hdr10Settings {
    /// Creates a new builder-style object to manufacture [`Hdr10Settings`](crate::model::Hdr10Settings)
    pub fn builder() -> crate::model::hdr10_settings::Builder {
        crate::model::hdr10_settings::Builder::default()
    }
}

/// Video Selector Color Space
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoSelectorColorSpace {
    #[allow(missing_docs)] // documentation missing in model
    Follow,
    #[allow(missing_docs)] // documentation missing in model
    Hdr10,
    #[allow(missing_docs)] // documentation missing in model
    Hlg2020,
    #[allow(missing_docs)] // documentation missing in model
    Rec601,
    #[allow(missing_docs)] // documentation missing in model
    Rec709,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoSelectorColorSpace {
    fn from(s: &str) -> Self {
        match s {
            "FOLLOW" => VideoSelectorColorSpace::Follow,
            "HDR10" => VideoSelectorColorSpace::Hdr10,
            "HLG_2020" => VideoSelectorColorSpace::Hlg2020,
            "REC_601" => VideoSelectorColorSpace::Rec601,
            "REC_709" => VideoSelectorColorSpace::Rec709,
            other => VideoSelectorColorSpace::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoSelectorColorSpace {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoSelectorColorSpace::from(s))
    }
}
impl VideoSelectorColorSpace {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoSelectorColorSpace::Follow => "FOLLOW",
            VideoSelectorColorSpace::Hdr10 => "HDR10",
            VideoSelectorColorSpace::Hlg2020 => "HLG_2020",
            VideoSelectorColorSpace::Rec601 => "REC_601",
            VideoSelectorColorSpace::Rec709 => "REC_709",
            VideoSelectorColorSpace::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FOLLOW", "HDR10", "HLG_2020", "REC_601", "REC_709"]
    }
}
impl AsRef<str> for VideoSelectorColorSpace {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Source End Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputSourceEndBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Continue,
    #[allow(missing_docs)] // documentation missing in model
    Loop,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputSourceEndBehavior {
    fn from(s: &str) -> Self {
        match s {
            "CONTINUE" => InputSourceEndBehavior::Continue,
            "LOOP" => InputSourceEndBehavior::Loop,
            other => InputSourceEndBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputSourceEndBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputSourceEndBehavior::from(s))
    }
}
impl InputSourceEndBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputSourceEndBehavior::Continue => "CONTINUE",
            InputSourceEndBehavior::Loop => "LOOP",
            InputSourceEndBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTINUE", "LOOP"]
    }
}
impl AsRef<str> for InputSourceEndBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smpte2038 Data Preference
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Smpte2038DataPreference {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Prefer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Smpte2038DataPreference {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => Smpte2038DataPreference::Ignore,
            "PREFER" => Smpte2038DataPreference::Prefer,
            other => Smpte2038DataPreference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Smpte2038DataPreference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Smpte2038DataPreference::from(s))
    }
}
impl Smpte2038DataPreference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Smpte2038DataPreference::Ignore => "IGNORE",
            Smpte2038DataPreference::Prefer => "PREFER",
            Smpte2038DataPreference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "PREFER"]
    }
}
impl AsRef<str> for Smpte2038DataPreference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Network source to transcode. Must be accessible to the Elemental Live node that is running the live event through a network connection.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkInputSettings {
    /// Specifies HLS input settings when the uri is for a HLS manifest.
    pub hls_input_settings: std::option::Option<crate::model::HlsInputSettings>,
    /// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to error. This setting is ignored for protocols that do not use https.
    pub server_validation: std::option::Option<crate::model::NetworkInputServerValidation>,
}
impl std::fmt::Debug for NetworkInputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkInputSettings");
        formatter.field("hls_input_settings", &self.hls_input_settings);
        formatter.field("server_validation", &self.server_validation);
        formatter.finish()
    }
}
/// See [`NetworkInputSettings`](crate::model::NetworkInputSettings)
pub mod network_input_settings {
    /// A builder for [`NetworkInputSettings`](crate::model::NetworkInputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) hls_input_settings: std::option::Option<crate::model::HlsInputSettings>,
        pub(crate) server_validation:
            std::option::Option<crate::model::NetworkInputServerValidation>,
    }
    impl Builder {
        /// Specifies HLS input settings when the uri is for a HLS manifest.
        pub fn hls_input_settings(mut self, input: crate::model::HlsInputSettings) -> Self {
            self.hls_input_settings = Some(input);
            self
        }
        /// Specifies HLS input settings when the uri is for a HLS manifest.
        pub fn set_hls_input_settings(
            mut self,
            input: std::option::Option<crate::model::HlsInputSettings>,
        ) -> Self {
            self.hls_input_settings = input;
            self
        }
        /// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to error. This setting is ignored for protocols that do not use https.
        pub fn server_validation(
            mut self,
            input: crate::model::NetworkInputServerValidation,
        ) -> Self {
            self.server_validation = Some(input);
            self
        }
        /// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography in the certificate will be checked, but not the server's name. Certain subdomains (notably S3 buckets that use dots in the bucket name) do not strictly match the corresponding certificate's wildcard pattern and would otherwise cause the event to error. This setting is ignored for protocols that do not use https.
        pub fn set_server_validation(
            mut self,
            input: std::option::Option<crate::model::NetworkInputServerValidation>,
        ) -> Self {
            self.server_validation = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkInputSettings`](crate::model::NetworkInputSettings)
        pub fn build(self) -> crate::model::NetworkInputSettings {
            crate::model::NetworkInputSettings {
                hls_input_settings: self.hls_input_settings,
                server_validation: self.server_validation,
            }
        }
    }
}
impl NetworkInputSettings {
    /// Creates a new builder-style object to manufacture [`NetworkInputSettings`](crate::model::NetworkInputSettings)
    pub fn builder() -> crate::model::network_input_settings::Builder {
        crate::model::network_input_settings::Builder::default()
    }
}

/// Network Input Server Validation
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkInputServerValidation {
    #[allow(missing_docs)] // documentation missing in model
    CheckCryptographyAndValidateName,
    #[allow(missing_docs)] // documentation missing in model
    CheckCryptographyOnly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkInputServerValidation {
    fn from(s: &str) -> Self {
        match s {
            "CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME" => {
                NetworkInputServerValidation::CheckCryptographyAndValidateName
            }
            "CHECK_CRYPTOGRAPHY_ONLY" => NetworkInputServerValidation::CheckCryptographyOnly,
            other => NetworkInputServerValidation::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkInputServerValidation {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkInputServerValidation::from(s))
    }
}
impl NetworkInputServerValidation {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkInputServerValidation::CheckCryptographyAndValidateName => {
                "CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME"
            }
            NetworkInputServerValidation::CheckCryptographyOnly => "CHECK_CRYPTOGRAPHY_ONLY",
            NetworkInputServerValidation::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CHECK_CRYPTOGRAPHY_AND_VALIDATE_NAME",
            "CHECK_CRYPTOGRAPHY_ONLY",
        ]
    }
}
impl AsRef<str> for NetworkInputServerValidation {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Hls Input Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsInputSettings {
    /// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen.  The bitrate is specified in bits per second, as in an HLS manifest.
    pub bandwidth: i32,
    /// When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written segment).  When not specified, the HLS input will begin with the first segment specified in the m3u8.
    pub buffer_segments: i32,
    /// The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
    pub retries: i32,
    /// The number of seconds between retries when an attempt to read a manifest or segment fails.
    pub retry_interval: i32,
    /// Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.
    pub scte35_source: std::option::Option<crate::model::HlsScte35SourceType>,
}
impl std::fmt::Debug for HlsInputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsInputSettings");
        formatter.field("bandwidth", &self.bandwidth);
        formatter.field("buffer_segments", &self.buffer_segments);
        formatter.field("retries", &self.retries);
        formatter.field("retry_interval", &self.retry_interval);
        formatter.field("scte35_source", &self.scte35_source);
        formatter.finish()
    }
}
/// See [`HlsInputSettings`](crate::model::HlsInputSettings)
pub mod hls_input_settings {
    /// A builder for [`HlsInputSettings`](crate::model::HlsInputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bandwidth: std::option::Option<i32>,
        pub(crate) buffer_segments: std::option::Option<i32>,
        pub(crate) retries: std::option::Option<i32>,
        pub(crate) retry_interval: std::option::Option<i32>,
        pub(crate) scte35_source: std::option::Option<crate::model::HlsScte35SourceType>,
    }
    impl Builder {
        /// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen.  The bitrate is specified in bits per second, as in an HLS manifest.
        pub fn bandwidth(mut self, input: i32) -> Self {
            self.bandwidth = Some(input);
            self
        }
        /// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches this value will be chosen, otherwise the highest bandwidth stream in the m3u8 will be chosen.  The bitrate is specified in bits per second, as in an HLS manifest.
        pub fn set_bandwidth(mut self, input: std::option::Option<i32>) -> Self {
            self.bandwidth = input;
            self
        }
        /// When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written segment).  When not specified, the HLS input will begin with the first segment specified in the m3u8.
        pub fn buffer_segments(mut self, input: i32) -> Self {
            self.buffer_segments = Some(input);
            self
        }
        /// When specified, reading of the HLS input will begin this many buffer segments from the end (most recently written segment).  When not specified, the HLS input will begin with the first segment specified in the m3u8.
        pub fn set_buffer_segments(mut self, input: std::option::Option<i32>) -> Self {
            self.buffer_segments = input;
            self
        }
        /// The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
        pub fn retries(mut self, input: i32) -> Self {
            self.retries = Some(input);
            self
        }
        /// The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
        pub fn set_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.retries = input;
            self
        }
        /// The number of seconds between retries when an attempt to read a manifest or segment fails.
        pub fn retry_interval(mut self, input: i32) -> Self {
            self.retry_interval = Some(input);
            self
        }
        /// The number of seconds between retries when an attempt to read a manifest or segment fails.
        pub fn set_retry_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_interval = input;
            self
        }
        /// Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.
        pub fn scte35_source(mut self, input: crate::model::HlsScte35SourceType) -> Self {
            self.scte35_source = Some(input);
            self
        }
        /// Identifies the source for the SCTE-35 messages that MediaLive will ingest. Messages can be ingested from the content segments (in the stream) or from tags in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the source that is not selected.
        pub fn set_scte35_source(
            mut self,
            input: std::option::Option<crate::model::HlsScte35SourceType>,
        ) -> Self {
            self.scte35_source = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsInputSettings`](crate::model::HlsInputSettings)
        pub fn build(self) -> crate::model::HlsInputSettings {
            crate::model::HlsInputSettings {
                bandwidth: self.bandwidth.unwrap_or_default(),
                buffer_segments: self.buffer_segments.unwrap_or_default(),
                retries: self.retries.unwrap_or_default(),
                retry_interval: self.retry_interval.unwrap_or_default(),
                scte35_source: self.scte35_source,
            }
        }
    }
}
impl HlsInputSettings {
    /// Creates a new builder-style object to manufacture [`HlsInputSettings`](crate::model::HlsInputSettings)
    pub fn builder() -> crate::model::hls_input_settings::Builder {
        crate::model::hls_input_settings::Builder::default()
    }
}

/// Hls Scte35 Source Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HlsScte35SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Manifest,
    #[allow(missing_docs)] // documentation missing in model
    Segments,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HlsScte35SourceType {
    fn from(s: &str) -> Self {
        match s {
            "MANIFEST" => HlsScte35SourceType::Manifest,
            "SEGMENTS" => HlsScte35SourceType::Segments,
            other => HlsScte35SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HlsScte35SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HlsScte35SourceType::from(s))
    }
}
impl HlsScte35SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HlsScte35SourceType::Manifest => "MANIFEST",
            HlsScte35SourceType::Segments => "SEGMENTS",
            HlsScte35SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MANIFEST", "SEGMENTS"]
    }
}
impl AsRef<str> for HlsScte35SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Filter
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputFilter {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Forced,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputFilter {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => InputFilter::Auto,
            "DISABLED" => InputFilter::Disabled,
            "FORCED" => InputFilter::Forced,
            other => InputFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputFilter::from(s))
    }
}
impl InputFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputFilter::Auto => "AUTO",
            InputFilter::Disabled => "DISABLED",
            InputFilter::Forced => "FORCED",
            InputFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "DISABLED", "FORCED"]
    }
}
impl AsRef<str> for InputFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Denoise Filter
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDenoiseFilter {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDenoiseFilter {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => InputDenoiseFilter::Disabled,
            "ENABLED" => InputDenoiseFilter::Enabled,
            other => InputDenoiseFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDenoiseFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDenoiseFilter::from(s))
    }
}
impl InputDenoiseFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDenoiseFilter::Disabled => "DISABLED",
            InputDenoiseFilter::Enabled => "ENABLED",
            InputDenoiseFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for InputDenoiseFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Deblock Filter
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputDeblockFilter {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputDeblockFilter {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => InputDeblockFilter::Disabled,
            "ENABLED" => InputDeblockFilter::Enabled,
            other => InputDeblockFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputDeblockFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputDeblockFilter::from(s))
    }
}
impl InputDeblockFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputDeblockFilter::Disabled => "DISABLED",
            InputDeblockFilter::Enabled => "ENABLED",
            InputDeblockFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for InputDeblockFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Output groups for this Live Event. Output groups contain information about where streams should be distributed.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaptionSelector {
    /// When specified this field indicates the three letter language code of the caption track to extract from the source.
    pub language_code: std::option::Option<std::string::String>,
    /// Name identifier for a caption selector.  This name is used to associate this caption selector with one or more caption descriptions.  Names must be unique within an event.
    pub name: std::option::Option<std::string::String>,
    /// Caption selector settings.
    pub selector_settings: std::option::Option<crate::model::CaptionSelectorSettings>,
}
impl std::fmt::Debug for CaptionSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaptionSelector");
        formatter.field("language_code", &self.language_code);
        formatter.field("name", &self.name);
        formatter.field("selector_settings", &self.selector_settings);
        formatter.finish()
    }
}
/// See [`CaptionSelector`](crate::model::CaptionSelector)
pub mod caption_selector {
    /// A builder for [`CaptionSelector`](crate::model::CaptionSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) selector_settings: std::option::Option<crate::model::CaptionSelectorSettings>,
    }
    impl Builder {
        /// When specified this field indicates the three letter language code of the caption track to extract from the source.
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// When specified this field indicates the three letter language code of the caption track to extract from the source.
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// Name identifier for a caption selector.  This name is used to associate this caption selector with one or more caption descriptions.  Names must be unique within an event.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Name identifier for a caption selector.  This name is used to associate this caption selector with one or more caption descriptions.  Names must be unique within an event.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Caption selector settings.
        pub fn selector_settings(mut self, input: crate::model::CaptionSelectorSettings) -> Self {
            self.selector_settings = Some(input);
            self
        }
        /// Caption selector settings.
        pub fn set_selector_settings(
            mut self,
            input: std::option::Option<crate::model::CaptionSelectorSettings>,
        ) -> Self {
            self.selector_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CaptionSelector`](crate::model::CaptionSelector)
        pub fn build(self) -> crate::model::CaptionSelector {
            crate::model::CaptionSelector {
                language_code: self.language_code,
                name: self.name,
                selector_settings: self.selector_settings,
            }
        }
    }
}
impl CaptionSelector {
    /// Creates a new builder-style object to manufacture [`CaptionSelector`](crate::model::CaptionSelector)
    pub fn builder() -> crate::model::caption_selector::Builder {
        crate::model::caption_selector::Builder::default()
    }
}

/// Caption Selector Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaptionSelectorSettings {
    /// Ancillary Source Settings
    pub ancillary_source_settings: std::option::Option<crate::model::AncillarySourceSettings>,
    /// Arib Source Settings
    pub arib_source_settings: std::option::Option<crate::model::AribSourceSettings>,
    /// Dvb Sub Source Settings
    pub dvb_sub_source_settings: std::option::Option<crate::model::DvbSubSourceSettings>,
    /// Embedded Source Settings
    pub embedded_source_settings: std::option::Option<crate::model::EmbeddedSourceSettings>,
    /// Scte20 Source Settings
    pub scte20_source_settings: std::option::Option<crate::model::Scte20SourceSettings>,
    /// Scte27 Source Settings
    pub scte27_source_settings: std::option::Option<crate::model::Scte27SourceSettings>,
    /// Teletext Source Settings
    pub teletext_source_settings: std::option::Option<crate::model::TeletextSourceSettings>,
}
impl std::fmt::Debug for CaptionSelectorSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaptionSelectorSettings");
        formatter.field("ancillary_source_settings", &self.ancillary_source_settings);
        formatter.field("arib_source_settings", &self.arib_source_settings);
        formatter.field("dvb_sub_source_settings", &self.dvb_sub_source_settings);
        formatter.field("embedded_source_settings", &self.embedded_source_settings);
        formatter.field("scte20_source_settings", &self.scte20_source_settings);
        formatter.field("scte27_source_settings", &self.scte27_source_settings);
        formatter.field("teletext_source_settings", &self.teletext_source_settings);
        formatter.finish()
    }
}
/// See [`CaptionSelectorSettings`](crate::model::CaptionSelectorSettings)
pub mod caption_selector_settings {
    /// A builder for [`CaptionSelectorSettings`](crate::model::CaptionSelectorSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ancillary_source_settings:
            std::option::Option<crate::model::AncillarySourceSettings>,
        pub(crate) arib_source_settings: std::option::Option<crate::model::AribSourceSettings>,
        pub(crate) dvb_sub_source_settings: std::option::Option<crate::model::DvbSubSourceSettings>,
        pub(crate) embedded_source_settings:
            std::option::Option<crate::model::EmbeddedSourceSettings>,
        pub(crate) scte20_source_settings: std::option::Option<crate::model::Scte20SourceSettings>,
        pub(crate) scte27_source_settings: std::option::Option<crate::model::Scte27SourceSettings>,
        pub(crate) teletext_source_settings:
            std::option::Option<crate::model::TeletextSourceSettings>,
    }
    impl Builder {
        /// Ancillary Source Settings
        pub fn ancillary_source_settings(
            mut self,
            input: crate::model::AncillarySourceSettings,
        ) -> Self {
            self.ancillary_source_settings = Some(input);
            self
        }
        /// Ancillary Source Settings
        pub fn set_ancillary_source_settings(
            mut self,
            input: std::option::Option<crate::model::AncillarySourceSettings>,
        ) -> Self {
            self.ancillary_source_settings = input;
            self
        }
        /// Arib Source Settings
        pub fn arib_source_settings(mut self, input: crate::model::AribSourceSettings) -> Self {
            self.arib_source_settings = Some(input);
            self
        }
        /// Arib Source Settings
        pub fn set_arib_source_settings(
            mut self,
            input: std::option::Option<crate::model::AribSourceSettings>,
        ) -> Self {
            self.arib_source_settings = input;
            self
        }
        /// Dvb Sub Source Settings
        pub fn dvb_sub_source_settings(
            mut self,
            input: crate::model::DvbSubSourceSettings,
        ) -> Self {
            self.dvb_sub_source_settings = Some(input);
            self
        }
        /// Dvb Sub Source Settings
        pub fn set_dvb_sub_source_settings(
            mut self,
            input: std::option::Option<crate::model::DvbSubSourceSettings>,
        ) -> Self {
            self.dvb_sub_source_settings = input;
            self
        }
        /// Embedded Source Settings
        pub fn embedded_source_settings(
            mut self,
            input: crate::model::EmbeddedSourceSettings,
        ) -> Self {
            self.embedded_source_settings = Some(input);
            self
        }
        /// Embedded Source Settings
        pub fn set_embedded_source_settings(
            mut self,
            input: std::option::Option<crate::model::EmbeddedSourceSettings>,
        ) -> Self {
            self.embedded_source_settings = input;
            self
        }
        /// Scte20 Source Settings
        pub fn scte20_source_settings(mut self, input: crate::model::Scte20SourceSettings) -> Self {
            self.scte20_source_settings = Some(input);
            self
        }
        /// Scte20 Source Settings
        pub fn set_scte20_source_settings(
            mut self,
            input: std::option::Option<crate::model::Scte20SourceSettings>,
        ) -> Self {
            self.scte20_source_settings = input;
            self
        }
        /// Scte27 Source Settings
        pub fn scte27_source_settings(mut self, input: crate::model::Scte27SourceSettings) -> Self {
            self.scte27_source_settings = Some(input);
            self
        }
        /// Scte27 Source Settings
        pub fn set_scte27_source_settings(
            mut self,
            input: std::option::Option<crate::model::Scte27SourceSettings>,
        ) -> Self {
            self.scte27_source_settings = input;
            self
        }
        /// Teletext Source Settings
        pub fn teletext_source_settings(
            mut self,
            input: crate::model::TeletextSourceSettings,
        ) -> Self {
            self.teletext_source_settings = Some(input);
            self
        }
        /// Teletext Source Settings
        pub fn set_teletext_source_settings(
            mut self,
            input: std::option::Option<crate::model::TeletextSourceSettings>,
        ) -> Self {
            self.teletext_source_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`CaptionSelectorSettings`](crate::model::CaptionSelectorSettings)
        pub fn build(self) -> crate::model::CaptionSelectorSettings {
            crate::model::CaptionSelectorSettings {
                ancillary_source_settings: self.ancillary_source_settings,
                arib_source_settings: self.arib_source_settings,
                dvb_sub_source_settings: self.dvb_sub_source_settings,
                embedded_source_settings: self.embedded_source_settings,
                scte20_source_settings: self.scte20_source_settings,
                scte27_source_settings: self.scte27_source_settings,
                teletext_source_settings: self.teletext_source_settings,
            }
        }
    }
}
impl CaptionSelectorSettings {
    /// Creates a new builder-style object to manufacture [`CaptionSelectorSettings`](crate::model::CaptionSelectorSettings)
    pub fn builder() -> crate::model::caption_selector_settings::Builder {
        crate::model::caption_selector_settings::Builder::default()
    }
}

/// Teletext Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TeletextSourceSettings {
    /// Optionally defines a region where TTML style captions will be displayed
    pub output_rectangle: std::option::Option<crate::model::CaptionRectangle>,
    /// Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x" prefix.
    pub page_number: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TeletextSourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TeletextSourceSettings");
        formatter.field("output_rectangle", &self.output_rectangle);
        formatter.field("page_number", &self.page_number);
        formatter.finish()
    }
}
/// See [`TeletextSourceSettings`](crate::model::TeletextSourceSettings)
pub mod teletext_source_settings {
    /// A builder for [`TeletextSourceSettings`](crate::model::TeletextSourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_rectangle: std::option::Option<crate::model::CaptionRectangle>,
        pub(crate) page_number: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Optionally defines a region where TTML style captions will be displayed
        pub fn output_rectangle(mut self, input: crate::model::CaptionRectangle) -> Self {
            self.output_rectangle = Some(input);
            self
        }
        /// Optionally defines a region where TTML style captions will be displayed
        pub fn set_output_rectangle(
            mut self,
            input: std::option::Option<crate::model::CaptionRectangle>,
        ) -> Self {
            self.output_rectangle = input;
            self
        }
        /// Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x" prefix.
        pub fn page_number(mut self, input: impl Into<std::string::String>) -> Self {
            self.page_number = Some(input.into());
            self
        }
        /// Specifies the teletext page number within the data stream from which to extract captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should be specified as a hexadecimal string with no "0x" prefix.
        pub fn set_page_number(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.page_number = input;
            self
        }
        /// Consumes the builder and constructs a [`TeletextSourceSettings`](crate::model::TeletextSourceSettings)
        pub fn build(self) -> crate::model::TeletextSourceSettings {
            crate::model::TeletextSourceSettings {
                output_rectangle: self.output_rectangle,
                page_number: self.page_number,
            }
        }
    }
}
impl TeletextSourceSettings {
    /// Creates a new builder-style object to manufacture [`TeletextSourceSettings`](crate::model::TeletextSourceSettings)
    pub fn builder() -> crate::model::teletext_source_settings::Builder {
        crate::model::teletext_source_settings::Builder::default()
    }
}

/// Caption Rectangle
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CaptionRectangle {
    /// See the description in leftOffset.
    /// For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, \"80\" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less.
    /// This field corresponds to tts:extent - Y in the TTML standard.
    pub height: f64,
    /// Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages.
    /// If you specify a value for one of these fields, you must specify a value for all of them.
    /// For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame.
    /// This field corresponds to tts:origin - X in the TTML standard.
    pub left_offset: f64,
    /// See the description in leftOffset.
    /// For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame.
    /// This field corresponds to tts:origin - Y in the TTML standard.
    pub top_offset: f64,
    /// See the description in leftOffset.
    /// For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, \"80\" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less.
    /// This field corresponds to tts:extent - X in the TTML standard.
    pub width: f64,
}
impl std::fmt::Debug for CaptionRectangle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CaptionRectangle");
        formatter.field("height", &self.height);
        formatter.field("left_offset", &self.left_offset);
        formatter.field("top_offset", &self.top_offset);
        formatter.field("width", &self.width);
        formatter.finish()
    }
}
/// See [`CaptionRectangle`](crate::model::CaptionRectangle)
pub mod caption_rectangle {
    /// A builder for [`CaptionRectangle`](crate::model::CaptionRectangle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) height: std::option::Option<f64>,
        pub(crate) left_offset: std::option::Option<f64>,
        pub(crate) top_offset: std::option::Option<f64>,
        pub(crate) width: std::option::Option<f64>,
    }
    impl Builder {
        /// See the description in leftOffset.
        /// For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, \"80\" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less.
        /// This field corresponds to tts:extent - Y in the TTML standard.
        pub fn height(mut self, input: f64) -> Self {
            self.height = Some(input);
            self
        }
        /// See the description in leftOffset.
        /// For height, specify the entire height of the rectangle as a percentage of the underlying frame height. For example, \"80\" means the rectangle height is 80% of the underlying frame height. The topOffset and rectangleHeight must add up to 100% or less.
        /// This field corresponds to tts:extent - Y in the TTML standard.
        pub fn set_height(mut self, input: std::option::Option<f64>) -> Self {
            self.height = input;
            self
        }
        /// Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages.
        /// If you specify a value for one of these fields, you must specify a value for all of them.
        /// For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame.
        /// This field corresponds to tts:origin - X in the TTML standard.
        pub fn left_offset(mut self, input: f64) -> Self {
            self.left_offset = Some(input);
            self
        }
        /// Applies only if you plan to convert these source captions to EBU-TT-D or TTML in an output. (Make sure to leave the default if you don't have either of these formats in the output.) You can define a display rectangle for the captions that is smaller than the underlying video frame. You define the rectangle by specifying the position of the left edge, top edge, bottom edge, and right edge of the rectangle, all within the underlying video frame. The units for the measurements are percentages.
        /// If you specify a value for one of these fields, you must specify a value for all of them.
        /// For leftOffset, specify the position of the left edge of the rectangle, as a percentage of the underlying frame width, and relative to the left edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame width. The rectangle left edge starts at that position from the left edge of the frame.
        /// This field corresponds to tts:origin - X in the TTML standard.
        pub fn set_left_offset(mut self, input: std::option::Option<f64>) -> Self {
            self.left_offset = input;
            self
        }
        /// See the description in leftOffset.
        /// For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame.
        /// This field corresponds to tts:origin - Y in the TTML standard.
        pub fn top_offset(mut self, input: f64) -> Self {
            self.top_offset = Some(input);
            self
        }
        /// See the description in leftOffset.
        /// For topOffset, specify the position of the top edge of the rectangle, as a percentage of the underlying frame height, and relative to the top edge of the frame. For example, \"10\" means the measurement is 10% of the underlying frame height. The rectangle top edge starts at that position from the top edge of the frame.
        /// This field corresponds to tts:origin - Y in the TTML standard.
        pub fn set_top_offset(mut self, input: std::option::Option<f64>) -> Self {
            self.top_offset = input;
            self
        }
        /// See the description in leftOffset.
        /// For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, \"80\" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less.
        /// This field corresponds to tts:extent - X in the TTML standard.
        pub fn width(mut self, input: f64) -> Self {
            self.width = Some(input);
            self
        }
        /// See the description in leftOffset.
        /// For width, specify the entire width of the rectangle as a percentage of the underlying frame width. For example, \"80\" means the rectangle width is 80% of the underlying frame width. The leftOffset and rectangleWidth must add up to 100% or less.
        /// This field corresponds to tts:extent - X in the TTML standard.
        pub fn set_width(mut self, input: std::option::Option<f64>) -> Self {
            self.width = input;
            self
        }
        /// Consumes the builder and constructs a [`CaptionRectangle`](crate::model::CaptionRectangle)
        pub fn build(self) -> crate::model::CaptionRectangle {
            crate::model::CaptionRectangle {
                height: self.height.unwrap_or_default(),
                left_offset: self.left_offset.unwrap_or_default(),
                top_offset: self.top_offset.unwrap_or_default(),
                width: self.width.unwrap_or_default(),
            }
        }
    }
}
impl CaptionRectangle {
    /// Creates a new builder-style object to manufacture [`CaptionRectangle`](crate::model::CaptionRectangle)
    pub fn builder() -> crate::model::caption_rectangle::Builder {
        crate::model::caption_rectangle::Builder::default()
    }
}

/// Scte27 Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scte27SourceSettings {
    /// If you will configure a WebVTT caption description that references this caption selector, use this field to
    /// provide the language to consider when translating the image-based source to text.
    pub ocr_language: std::option::Option<crate::model::Scte27OcrLanguage>,
    /// The pid field is used in conjunction with the caption selector languageCode field as follows:
    /// - Specify PID and Language: Extracts captions from that PID; the language is "informational".
    /// - Specify PID and omit Language: Extracts the specified PID.
    /// - Omit PID and specify Language: Extracts the specified language, whichever PID that happens to be.
    /// - Omit PID and omit Language: Valid only if source is DVB-Sub that is being passed through; all languages will be passed through.
    pub pid: i32,
}
impl std::fmt::Debug for Scte27SourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scte27SourceSettings");
        formatter.field("ocr_language", &self.ocr_language);
        formatter.field("pid", &self.pid);
        formatter.finish()
    }
}
/// See [`Scte27SourceSettings`](crate::model::Scte27SourceSettings)
pub mod scte27_source_settings {
    /// A builder for [`Scte27SourceSettings`](crate::model::Scte27SourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ocr_language: std::option::Option<crate::model::Scte27OcrLanguage>,
        pub(crate) pid: std::option::Option<i32>,
    }
    impl Builder {
        /// If you will configure a WebVTT caption description that references this caption selector, use this field to
        /// provide the language to consider when translating the image-based source to text.
        pub fn ocr_language(mut self, input: crate::model::Scte27OcrLanguage) -> Self {
            self.ocr_language = Some(input);
            self
        }
        /// If you will configure a WebVTT caption description that references this caption selector, use this field to
        /// provide the language to consider when translating the image-based source to text.
        pub fn set_ocr_language(
            mut self,
            input: std::option::Option<crate::model::Scte27OcrLanguage>,
        ) -> Self {
            self.ocr_language = input;
            self
        }
        /// The pid field is used in conjunction with the caption selector languageCode field as follows:
        /// - Specify PID and Language: Extracts captions from that PID; the language is "informational".
        /// - Specify PID and omit Language: Extracts the specified PID.
        /// - Omit PID and specify Language: Extracts the specified language, whichever PID that happens to be.
        /// - Omit PID and omit Language: Valid only if source is DVB-Sub that is being passed through; all languages will be passed through.
        pub fn pid(mut self, input: i32) -> Self {
            self.pid = Some(input);
            self
        }
        /// The pid field is used in conjunction with the caption selector languageCode field as follows:
        /// - Specify PID and Language: Extracts captions from that PID; the language is "informational".
        /// - Specify PID and omit Language: Extracts the specified PID.
        /// - Omit PID and specify Language: Extracts the specified language, whichever PID that happens to be.
        /// - Omit PID and omit Language: Valid only if source is DVB-Sub that is being passed through; all languages will be passed through.
        pub fn set_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.pid = input;
            self
        }
        /// Consumes the builder and constructs a [`Scte27SourceSettings`](crate::model::Scte27SourceSettings)
        pub fn build(self) -> crate::model::Scte27SourceSettings {
            crate::model::Scte27SourceSettings {
                ocr_language: self.ocr_language,
                pid: self.pid.unwrap_or_default(),
            }
        }
    }
}
impl Scte27SourceSettings {
    /// Creates a new builder-style object to manufacture [`Scte27SourceSettings`](crate::model::Scte27SourceSettings)
    pub fn builder() -> crate::model::scte27_source_settings::Builder {
        crate::model::scte27_source_settings::Builder::default()
    }
}

/// Scte27 Ocr Language
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Scte27OcrLanguage {
    #[allow(missing_docs)] // documentation missing in model
    Deu,
    #[allow(missing_docs)] // documentation missing in model
    Eng,
    #[allow(missing_docs)] // documentation missing in model
    Fra,
    #[allow(missing_docs)] // documentation missing in model
    Nld,
    #[allow(missing_docs)] // documentation missing in model
    Por,
    #[allow(missing_docs)] // documentation missing in model
    Spa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Scte27OcrLanguage {
    fn from(s: &str) -> Self {
        match s {
            "DEU" => Scte27OcrLanguage::Deu,
            "ENG" => Scte27OcrLanguage::Eng,
            "FRA" => Scte27OcrLanguage::Fra,
            "NLD" => Scte27OcrLanguage::Nld,
            "POR" => Scte27OcrLanguage::Por,
            "SPA" => Scte27OcrLanguage::Spa,
            other => Scte27OcrLanguage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Scte27OcrLanguage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Scte27OcrLanguage::from(s))
    }
}
impl Scte27OcrLanguage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Scte27OcrLanguage::Deu => "DEU",
            Scte27OcrLanguage::Eng => "ENG",
            Scte27OcrLanguage::Fra => "FRA",
            Scte27OcrLanguage::Nld => "NLD",
            Scte27OcrLanguage::Por => "POR",
            Scte27OcrLanguage::Spa => "SPA",
            Scte27OcrLanguage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEU", "ENG", "FRA", "NLD", "POR", "SPA"]
    }
}
impl AsRef<str> for Scte27OcrLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Scte20 Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scte20SourceSettings {
    /// If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
    pub convert608_to708: std::option::Option<crate::model::Scte20Convert608To708>,
    /// Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
    pub source608_channel_number: i32,
}
impl std::fmt::Debug for Scte20SourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scte20SourceSettings");
        formatter.field("convert608_to708", &self.convert608_to708);
        formatter.field("source608_channel_number", &self.source608_channel_number);
        formatter.finish()
    }
}
/// See [`Scte20SourceSettings`](crate::model::Scte20SourceSettings)
pub mod scte20_source_settings {
    /// A builder for [`Scte20SourceSettings`](crate::model::Scte20SourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) convert608_to708: std::option::Option<crate::model::Scte20Convert608To708>,
        pub(crate) source608_channel_number: std::option::Option<i32>,
    }
    impl Builder {
        /// If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
        pub fn convert608_to708(mut self, input: crate::model::Scte20Convert608To708) -> Self {
            self.convert608_to708 = Some(input);
            self
        }
        /// If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
        pub fn set_convert608_to708(
            mut self,
            input: std::option::Option<crate::model::Scte20Convert608To708>,
        ) -> Self {
            self.convert608_to708 = input;
            self
        }
        /// Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
        pub fn source608_channel_number(mut self, input: i32) -> Self {
            self.source608_channel_number = Some(input);
            self
        }
        /// Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
        pub fn set_source608_channel_number(mut self, input: std::option::Option<i32>) -> Self {
            self.source608_channel_number = input;
            self
        }
        /// Consumes the builder and constructs a [`Scte20SourceSettings`](crate::model::Scte20SourceSettings)
        pub fn build(self) -> crate::model::Scte20SourceSettings {
            crate::model::Scte20SourceSettings {
                convert608_to708: self.convert608_to708,
                source608_channel_number: self.source608_channel_number.unwrap_or_default(),
            }
        }
    }
}
impl Scte20SourceSettings {
    /// Creates a new builder-style object to manufacture [`Scte20SourceSettings`](crate::model::Scte20SourceSettings)
    pub fn builder() -> crate::model::scte20_source_settings::Builder {
        crate::model::scte20_source_settings::Builder::default()
    }
}

/// Scte20 Convert608 To708
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Scte20Convert608To708 {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Upconvert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Scte20Convert608To708 {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Scte20Convert608To708::Disabled,
            "UPCONVERT" => Scte20Convert608To708::Upconvert,
            other => Scte20Convert608To708::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Scte20Convert608To708 {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Scte20Convert608To708::from(s))
    }
}
impl Scte20Convert608To708 {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Scte20Convert608To708::Disabled => "DISABLED",
            Scte20Convert608To708::Upconvert => "UPCONVERT",
            Scte20Convert608To708::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "UPCONVERT"]
    }
}
impl AsRef<str> for Scte20Convert608To708 {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Embedded Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EmbeddedSourceSettings {
    /// If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
    pub convert608_to708: std::option::Option<crate::model::EmbeddedConvert608To708>,
    /// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
    pub scte20_detection: std::option::Option<crate::model::EmbeddedScte20Detection>,
    /// Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
    pub source608_channel_number: i32,
    /// This field is unused and deprecated.
    pub source608_track_number: i32,
}
impl std::fmt::Debug for EmbeddedSourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EmbeddedSourceSettings");
        formatter.field("convert608_to708", &self.convert608_to708);
        formatter.field("scte20_detection", &self.scte20_detection);
        formatter.field("source608_channel_number", &self.source608_channel_number);
        formatter.field("source608_track_number", &self.source608_track_number);
        formatter.finish()
    }
}
/// See [`EmbeddedSourceSettings`](crate::model::EmbeddedSourceSettings)
pub mod embedded_source_settings {
    /// A builder for [`EmbeddedSourceSettings`](crate::model::EmbeddedSourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) convert608_to708: std::option::Option<crate::model::EmbeddedConvert608To708>,
        pub(crate) scte20_detection: std::option::Option<crate::model::EmbeddedScte20Detection>,
        pub(crate) source608_channel_number: std::option::Option<i32>,
        pub(crate) source608_track_number: std::option::Option<i32>,
    }
    impl Builder {
        /// If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
        pub fn convert608_to708(mut self, input: crate::model::EmbeddedConvert608To708) -> Self {
            self.convert608_to708 = Some(input);
            self
        }
        /// If upconvert, 608 data is both passed through via the "608 compatibility bytes" fields of the 708 wrapper as well as translated into 708. 708 data present in the source content will be discarded.
        pub fn set_convert608_to708(
            mut self,
            input: std::option::Option<crate::model::EmbeddedConvert608To708>,
        ) -> Self {
            self.convert608_to708 = input;
            self
        }
        /// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
        pub fn scte20_detection(mut self, input: crate::model::EmbeddedScte20Detection) -> Self {
            self.scte20_detection = Some(input);
            self
        }
        /// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and Embedded captions.
        pub fn set_scte20_detection(
            mut self,
            input: std::option::Option<crate::model::EmbeddedScte20Detection>,
        ) -> Self {
            self.scte20_detection = input;
            self
        }
        /// Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
        pub fn source608_channel_number(mut self, input: i32) -> Self {
            self.source608_channel_number = Some(input);
            self
        }
        /// Specifies the 608/708 channel number within the video track from which to extract captions. Unused for passthrough.
        pub fn set_source608_channel_number(mut self, input: std::option::Option<i32>) -> Self {
            self.source608_channel_number = input;
            self
        }
        /// This field is unused and deprecated.
        pub fn source608_track_number(mut self, input: i32) -> Self {
            self.source608_track_number = Some(input);
            self
        }
        /// This field is unused and deprecated.
        pub fn set_source608_track_number(mut self, input: std::option::Option<i32>) -> Self {
            self.source608_track_number = input;
            self
        }
        /// Consumes the builder and constructs a [`EmbeddedSourceSettings`](crate::model::EmbeddedSourceSettings)
        pub fn build(self) -> crate::model::EmbeddedSourceSettings {
            crate::model::EmbeddedSourceSettings {
                convert608_to708: self.convert608_to708,
                scte20_detection: self.scte20_detection,
                source608_channel_number: self.source608_channel_number.unwrap_or_default(),
                source608_track_number: self.source608_track_number.unwrap_or_default(),
            }
        }
    }
}
impl EmbeddedSourceSettings {
    /// Creates a new builder-style object to manufacture [`EmbeddedSourceSettings`](crate::model::EmbeddedSourceSettings)
    pub fn builder() -> crate::model::embedded_source_settings::Builder {
        crate::model::embedded_source_settings::Builder::default()
    }
}

/// Embedded Scte20 Detection
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EmbeddedScte20Detection {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EmbeddedScte20Detection {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => EmbeddedScte20Detection::Auto,
            "OFF" => EmbeddedScte20Detection::Off,
            other => EmbeddedScte20Detection::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EmbeddedScte20Detection {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EmbeddedScte20Detection::from(s))
    }
}
impl EmbeddedScte20Detection {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EmbeddedScte20Detection::Auto => "AUTO",
            EmbeddedScte20Detection::Off => "OFF",
            EmbeddedScte20Detection::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "OFF"]
    }
}
impl AsRef<str> for EmbeddedScte20Detection {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Embedded Convert608 To708
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EmbeddedConvert608To708 {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Upconvert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EmbeddedConvert608To708 {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => EmbeddedConvert608To708::Disabled,
            "UPCONVERT" => EmbeddedConvert608To708::Upconvert,
            other => EmbeddedConvert608To708::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EmbeddedConvert608To708 {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EmbeddedConvert608To708::from(s))
    }
}
impl EmbeddedConvert608To708 {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EmbeddedConvert608To708::Disabled => "DISABLED",
            EmbeddedConvert608To708::Upconvert => "UPCONVERT",
            EmbeddedConvert608To708::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "UPCONVERT"]
    }
}
impl AsRef<str> for EmbeddedConvert608To708 {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Dvb Sub Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DvbSubSourceSettings {
    /// If you will configure a WebVTT caption description that references this caption selector, use this field to
    /// provide the language to consider when translating the image-based source to text.
    pub ocr_language: std::option::Option<crate::model::DvbSubOcrLanguage>,
    /// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
    pub pid: i32,
}
impl std::fmt::Debug for DvbSubSourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DvbSubSourceSettings");
        formatter.field("ocr_language", &self.ocr_language);
        formatter.field("pid", &self.pid);
        formatter.finish()
    }
}
/// See [`DvbSubSourceSettings`](crate::model::DvbSubSourceSettings)
pub mod dvb_sub_source_settings {
    /// A builder for [`DvbSubSourceSettings`](crate::model::DvbSubSourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ocr_language: std::option::Option<crate::model::DvbSubOcrLanguage>,
        pub(crate) pid: std::option::Option<i32>,
    }
    impl Builder {
        /// If you will configure a WebVTT caption description that references this caption selector, use this field to
        /// provide the language to consider when translating the image-based source to text.
        pub fn ocr_language(mut self, input: crate::model::DvbSubOcrLanguage) -> Self {
            self.ocr_language = Some(input);
            self
        }
        /// If you will configure a WebVTT caption description that references this caption selector, use this field to
        /// provide the language to consider when translating the image-based source to text.
        pub fn set_ocr_language(
            mut self,
            input: std::option::Option<crate::model::DvbSubOcrLanguage>,
        ) -> Self {
            self.ocr_language = input;
            self
        }
        /// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
        pub fn pid(mut self, input: i32) -> Self {
            self.pid = Some(input);
            self
        }
        /// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through, regardless of selectors.
        pub fn set_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.pid = input;
            self
        }
        /// Consumes the builder and constructs a [`DvbSubSourceSettings`](crate::model::DvbSubSourceSettings)
        pub fn build(self) -> crate::model::DvbSubSourceSettings {
            crate::model::DvbSubSourceSettings {
                ocr_language: self.ocr_language,
                pid: self.pid.unwrap_or_default(),
            }
        }
    }
}
impl DvbSubSourceSettings {
    /// Creates a new builder-style object to manufacture [`DvbSubSourceSettings`](crate::model::DvbSubSourceSettings)
    pub fn builder() -> crate::model::dvb_sub_source_settings::Builder {
        crate::model::dvb_sub_source_settings::Builder::default()
    }
}

/// Dvb Sub Ocr Language
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DvbSubOcrLanguage {
    #[allow(missing_docs)] // documentation missing in model
    Deu,
    #[allow(missing_docs)] // documentation missing in model
    Eng,
    #[allow(missing_docs)] // documentation missing in model
    Fra,
    #[allow(missing_docs)] // documentation missing in model
    Nld,
    #[allow(missing_docs)] // documentation missing in model
    Por,
    #[allow(missing_docs)] // documentation missing in model
    Spa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DvbSubOcrLanguage {
    fn from(s: &str) -> Self {
        match s {
            "DEU" => DvbSubOcrLanguage::Deu,
            "ENG" => DvbSubOcrLanguage::Eng,
            "FRA" => DvbSubOcrLanguage::Fra,
            "NLD" => DvbSubOcrLanguage::Nld,
            "POR" => DvbSubOcrLanguage::Por,
            "SPA" => DvbSubOcrLanguage::Spa,
            other => DvbSubOcrLanguage::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DvbSubOcrLanguage {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DvbSubOcrLanguage::from(s))
    }
}
impl DvbSubOcrLanguage {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DvbSubOcrLanguage::Deu => "DEU",
            DvbSubOcrLanguage::Eng => "ENG",
            DvbSubOcrLanguage::Fra => "FRA",
            DvbSubOcrLanguage::Nld => "NLD",
            DvbSubOcrLanguage::Por => "POR",
            DvbSubOcrLanguage::Spa => "SPA",
            DvbSubOcrLanguage::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEU", "ENG", "FRA", "NLD", "POR", "SPA"]
    }
}
impl AsRef<str> for DvbSubOcrLanguage {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Arib Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AribSourceSettings {}
impl std::fmt::Debug for AribSourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AribSourceSettings");
        formatter.finish()
    }
}
/// See [`AribSourceSettings`](crate::model::AribSourceSettings)
pub mod arib_source_settings {
    /// A builder for [`AribSourceSettings`](crate::model::AribSourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AribSourceSettings`](crate::model::AribSourceSettings)
        pub fn build(self) -> crate::model::AribSourceSettings {
            crate::model::AribSourceSettings {}
        }
    }
}
impl AribSourceSettings {
    /// Creates a new builder-style object to manufacture [`AribSourceSettings`](crate::model::AribSourceSettings)
    pub fn builder() -> crate::model::arib_source_settings::Builder {
        crate::model::arib_source_settings::Builder::default()
    }
}

/// Ancillary Source Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AncillarySourceSettings {
    /// Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions. If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
    pub source_ancillary_channel_number: i32,
}
impl std::fmt::Debug for AncillarySourceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AncillarySourceSettings");
        formatter.field(
            "source_ancillary_channel_number",
            &self.source_ancillary_channel_number,
        );
        formatter.finish()
    }
}
/// See [`AncillarySourceSettings`](crate::model::AncillarySourceSettings)
pub mod ancillary_source_settings {
    /// A builder for [`AncillarySourceSettings`](crate::model::AncillarySourceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source_ancillary_channel_number: std::option::Option<i32>,
    }
    impl Builder {
        /// Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions. If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
        pub fn source_ancillary_channel_number(mut self, input: i32) -> Self {
            self.source_ancillary_channel_number = Some(input);
            self
        }
        /// Specifies the number (1 to 4) of the captions channel you want to extract from the ancillary captions. If you plan to convert the ancillary captions to another format, complete this field. If you plan to choose Embedded as the captions destination in the output (to pass through all the channels in the ancillary captions), leave this field blank because MediaLive ignores the field.
        pub fn set_source_ancillary_channel_number(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.source_ancillary_channel_number = input;
            self
        }
        /// Consumes the builder and constructs a [`AncillarySourceSettings`](crate::model::AncillarySourceSettings)
        pub fn build(self) -> crate::model::AncillarySourceSettings {
            crate::model::AncillarySourceSettings {
                source_ancillary_channel_number: self
                    .source_ancillary_channel_number
                    .unwrap_or_default(),
            }
        }
    }
}
impl AncillarySourceSettings {
    /// Creates a new builder-style object to manufacture [`AncillarySourceSettings`](crate::model::AncillarySourceSettings)
    pub fn builder() -> crate::model::ancillary_source_settings::Builder {
        crate::model::ancillary_source_settings::Builder::default()
    }
}

/// Audio Selector
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioSelector {
    /// The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector.  Selector names should be unique per input.
    pub name: std::option::Option<std::string::String>,
    /// The audio selector settings.
    pub selector_settings: std::option::Option<crate::model::AudioSelectorSettings>,
}
impl std::fmt::Debug for AudioSelector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioSelector");
        formatter.field("name", &self.name);
        formatter.field("selector_settings", &self.selector_settings);
        formatter.finish()
    }
}
/// See [`AudioSelector`](crate::model::AudioSelector)
pub mod audio_selector {
    /// A builder for [`AudioSelector`](crate::model::AudioSelector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) selector_settings: std::option::Option<crate::model::AudioSelectorSettings>,
    }
    impl Builder {
        /// The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector.  Selector names should be unique per input.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of this AudioSelector. AudioDescriptions will use this name to uniquely identify this Selector.  Selector names should be unique per input.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The audio selector settings.
        pub fn selector_settings(mut self, input: crate::model::AudioSelectorSettings) -> Self {
            self.selector_settings = Some(input);
            self
        }
        /// The audio selector settings.
        pub fn set_selector_settings(
            mut self,
            input: std::option::Option<crate::model::AudioSelectorSettings>,
        ) -> Self {
            self.selector_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioSelector`](crate::model::AudioSelector)
        pub fn build(self) -> crate::model::AudioSelector {
            crate::model::AudioSelector {
                name: self.name,
                selector_settings: self.selector_settings,
            }
        }
    }
}
impl AudioSelector {
    /// Creates a new builder-style object to manufacture [`AudioSelector`](crate::model::AudioSelector)
    pub fn builder() -> crate::model::audio_selector::Builder {
        crate::model::audio_selector::Builder::default()
    }
}

/// Audio Selector Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioSelectorSettings {
    /// Audio Hls Rendition Selection
    pub audio_hls_rendition_selection:
        std::option::Option<crate::model::AudioHlsRenditionSelection>,
    /// Audio Language Selection
    pub audio_language_selection: std::option::Option<crate::model::AudioLanguageSelection>,
    /// Audio Pid Selection
    pub audio_pid_selection: std::option::Option<crate::model::AudioPidSelection>,
    /// Audio Track Selection
    pub audio_track_selection: std::option::Option<crate::model::AudioTrackSelection>,
}
impl std::fmt::Debug for AudioSelectorSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioSelectorSettings");
        formatter.field(
            "audio_hls_rendition_selection",
            &self.audio_hls_rendition_selection,
        );
        formatter.field("audio_language_selection", &self.audio_language_selection);
        formatter.field("audio_pid_selection", &self.audio_pid_selection);
        formatter.field("audio_track_selection", &self.audio_track_selection);
        formatter.finish()
    }
}
/// See [`AudioSelectorSettings`](crate::model::AudioSelectorSettings)
pub mod audio_selector_settings {
    /// A builder for [`AudioSelectorSettings`](crate::model::AudioSelectorSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_hls_rendition_selection:
            std::option::Option<crate::model::AudioHlsRenditionSelection>,
        pub(crate) audio_language_selection:
            std::option::Option<crate::model::AudioLanguageSelection>,
        pub(crate) audio_pid_selection: std::option::Option<crate::model::AudioPidSelection>,
        pub(crate) audio_track_selection: std::option::Option<crate::model::AudioTrackSelection>,
    }
    impl Builder {
        /// Audio Hls Rendition Selection
        pub fn audio_hls_rendition_selection(
            mut self,
            input: crate::model::AudioHlsRenditionSelection,
        ) -> Self {
            self.audio_hls_rendition_selection = Some(input);
            self
        }
        /// Audio Hls Rendition Selection
        pub fn set_audio_hls_rendition_selection(
            mut self,
            input: std::option::Option<crate::model::AudioHlsRenditionSelection>,
        ) -> Self {
            self.audio_hls_rendition_selection = input;
            self
        }
        /// Audio Language Selection
        pub fn audio_language_selection(
            mut self,
            input: crate::model::AudioLanguageSelection,
        ) -> Self {
            self.audio_language_selection = Some(input);
            self
        }
        /// Audio Language Selection
        pub fn set_audio_language_selection(
            mut self,
            input: std::option::Option<crate::model::AudioLanguageSelection>,
        ) -> Self {
            self.audio_language_selection = input;
            self
        }
        /// Audio Pid Selection
        pub fn audio_pid_selection(mut self, input: crate::model::AudioPidSelection) -> Self {
            self.audio_pid_selection = Some(input);
            self
        }
        /// Audio Pid Selection
        pub fn set_audio_pid_selection(
            mut self,
            input: std::option::Option<crate::model::AudioPidSelection>,
        ) -> Self {
            self.audio_pid_selection = input;
            self
        }
        /// Audio Track Selection
        pub fn audio_track_selection(mut self, input: crate::model::AudioTrackSelection) -> Self {
            self.audio_track_selection = Some(input);
            self
        }
        /// Audio Track Selection
        pub fn set_audio_track_selection(
            mut self,
            input: std::option::Option<crate::model::AudioTrackSelection>,
        ) -> Self {
            self.audio_track_selection = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioSelectorSettings`](crate::model::AudioSelectorSettings)
        pub fn build(self) -> crate::model::AudioSelectorSettings {
            crate::model::AudioSelectorSettings {
                audio_hls_rendition_selection: self.audio_hls_rendition_selection,
                audio_language_selection: self.audio_language_selection,
                audio_pid_selection: self.audio_pid_selection,
                audio_track_selection: self.audio_track_selection,
            }
        }
    }
}
impl AudioSelectorSettings {
    /// Creates a new builder-style object to manufacture [`AudioSelectorSettings`](crate::model::AudioSelectorSettings)
    pub fn builder() -> crate::model::audio_selector_settings::Builder {
        crate::model::audio_selector_settings::Builder::default()
    }
}

/// Audio Track Selection
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioTrackSelection {
    /// Selects one or more unique audio tracks from within a source.
    pub tracks: std::option::Option<std::vec::Vec<crate::model::AudioTrack>>,
}
impl std::fmt::Debug for AudioTrackSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioTrackSelection");
        formatter.field("tracks", &self.tracks);
        formatter.finish()
    }
}
/// See [`AudioTrackSelection`](crate::model::AudioTrackSelection)
pub mod audio_track_selection {
    /// A builder for [`AudioTrackSelection`](crate::model::AudioTrackSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tracks: std::option::Option<std::vec::Vec<crate::model::AudioTrack>>,
    }
    impl Builder {
        /// Appends an item to `tracks`.
        ///
        /// To override the contents of this collection use [`set_tracks`](Self::set_tracks).
        ///
        /// Selects one or more unique audio tracks from within a source.
        pub fn tracks(mut self, input: impl Into<crate::model::AudioTrack>) -> Self {
            let mut v = self.tracks.unwrap_or_default();
            v.push(input.into());
            self.tracks = Some(v);
            self
        }
        /// Selects one or more unique audio tracks from within a source.
        pub fn set_tracks(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AudioTrack>>,
        ) -> Self {
            self.tracks = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioTrackSelection`](crate::model::AudioTrackSelection)
        pub fn build(self) -> crate::model::AudioTrackSelection {
            crate::model::AudioTrackSelection {
                tracks: self.tracks,
            }
        }
    }
}
impl AudioTrackSelection {
    /// Creates a new builder-style object to manufacture [`AudioTrackSelection`](crate::model::AudioTrackSelection)
    pub fn builder() -> crate::model::audio_track_selection::Builder {
        crate::model::audio_track_selection::Builder::default()
    }
}

/// Audio Track
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioTrack {
    /// 1-based integer value that maps to a specific audio track
    pub track: i32,
}
impl std::fmt::Debug for AudioTrack {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioTrack");
        formatter.field("track", &self.track);
        formatter.finish()
    }
}
/// See [`AudioTrack`](crate::model::AudioTrack)
pub mod audio_track {
    /// A builder for [`AudioTrack`](crate::model::AudioTrack)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) track: std::option::Option<i32>,
    }
    impl Builder {
        /// 1-based integer value that maps to a specific audio track
        pub fn track(mut self, input: i32) -> Self {
            self.track = Some(input);
            self
        }
        /// 1-based integer value that maps to a specific audio track
        pub fn set_track(mut self, input: std::option::Option<i32>) -> Self {
            self.track = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioTrack`](crate::model::AudioTrack)
        pub fn build(self) -> crate::model::AudioTrack {
            crate::model::AudioTrack {
                track: self.track.unwrap_or_default(),
            }
        }
    }
}
impl AudioTrack {
    /// Creates a new builder-style object to manufacture [`AudioTrack`](crate::model::AudioTrack)
    pub fn builder() -> crate::model::audio_track::Builder {
        crate::model::audio_track::Builder::default()
    }
}

/// Audio Pid Selection
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioPidSelection {
    /// Selects a specific PID from within a source.
    pub pid: i32,
}
impl std::fmt::Debug for AudioPidSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioPidSelection");
        formatter.field("pid", &self.pid);
        formatter.finish()
    }
}
/// See [`AudioPidSelection`](crate::model::AudioPidSelection)
pub mod audio_pid_selection {
    /// A builder for [`AudioPidSelection`](crate::model::AudioPidSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) pid: std::option::Option<i32>,
    }
    impl Builder {
        /// Selects a specific PID from within a source.
        pub fn pid(mut self, input: i32) -> Self {
            self.pid = Some(input);
            self
        }
        /// Selects a specific PID from within a source.
        pub fn set_pid(mut self, input: std::option::Option<i32>) -> Self {
            self.pid = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioPidSelection`](crate::model::AudioPidSelection)
        pub fn build(self) -> crate::model::AudioPidSelection {
            crate::model::AudioPidSelection {
                pid: self.pid.unwrap_or_default(),
            }
        }
    }
}
impl AudioPidSelection {
    /// Creates a new builder-style object to manufacture [`AudioPidSelection`](crate::model::AudioPidSelection)
    pub fn builder() -> crate::model::audio_pid_selection::Builder {
        crate::model::audio_pid_selection::Builder::default()
    }
}

/// Audio Language Selection
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioLanguageSelection {
    /// Selects a specific three-letter language code from within an audio source.
    pub language_code: std::option::Option<std::string::String>,
    /// When set to "strict", the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If "loose", then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can't find one with the same language.
    pub language_selection_policy: std::option::Option<crate::model::AudioLanguageSelectionPolicy>,
}
impl std::fmt::Debug for AudioLanguageSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioLanguageSelection");
        formatter.field("language_code", &self.language_code);
        formatter.field("language_selection_policy", &self.language_selection_policy);
        formatter.finish()
    }
}
/// See [`AudioLanguageSelection`](crate::model::AudioLanguageSelection)
pub mod audio_language_selection {
    /// A builder for [`AudioLanguageSelection`](crate::model::AudioLanguageSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) language_code: std::option::Option<std::string::String>,
        pub(crate) language_selection_policy:
            std::option::Option<crate::model::AudioLanguageSelectionPolicy>,
    }
    impl Builder {
        /// Selects a specific three-letter language code from within an audio source.
        pub fn language_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.language_code = Some(input.into());
            self
        }
        /// Selects a specific three-letter language code from within an audio source.
        pub fn set_language_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.language_code = input;
            self
        }
        /// When set to "strict", the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If "loose", then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can't find one with the same language.
        pub fn language_selection_policy(
            mut self,
            input: crate::model::AudioLanguageSelectionPolicy,
        ) -> Self {
            self.language_selection_policy = Some(input);
            self
        }
        /// When set to "strict", the transport stream demux strictly identifies audio streams by their language descriptor. If a PMT update occurs such that an audio stream matching the initially selected language is no longer present then mute will be encoded until the language returns. If "loose", then on a PMT update the demux will choose another audio stream in the program with the same stream type if it can't find one with the same language.
        pub fn set_language_selection_policy(
            mut self,
            input: std::option::Option<crate::model::AudioLanguageSelectionPolicy>,
        ) -> Self {
            self.language_selection_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioLanguageSelection`](crate::model::AudioLanguageSelection)
        pub fn build(self) -> crate::model::AudioLanguageSelection {
            crate::model::AudioLanguageSelection {
                language_code: self.language_code,
                language_selection_policy: self.language_selection_policy,
            }
        }
    }
}
impl AudioLanguageSelection {
    /// Creates a new builder-style object to manufacture [`AudioLanguageSelection`](crate::model::AudioLanguageSelection)
    pub fn builder() -> crate::model::audio_language_selection::Builder {
        crate::model::audio_language_selection::Builder::default()
    }
}

/// Audio Language Selection Policy
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AudioLanguageSelectionPolicy {
    #[allow(missing_docs)] // documentation missing in model
    Loose,
    #[allow(missing_docs)] // documentation missing in model
    Strict,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AudioLanguageSelectionPolicy {
    fn from(s: &str) -> Self {
        match s {
            "LOOSE" => AudioLanguageSelectionPolicy::Loose,
            "STRICT" => AudioLanguageSelectionPolicy::Strict,
            other => AudioLanguageSelectionPolicy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AudioLanguageSelectionPolicy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AudioLanguageSelectionPolicy::from(s))
    }
}
impl AudioLanguageSelectionPolicy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AudioLanguageSelectionPolicy::Loose => "LOOSE",
            AudioLanguageSelectionPolicy::Strict => "STRICT",
            AudioLanguageSelectionPolicy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LOOSE", "STRICT"]
    }
}
impl AsRef<str> for AudioLanguageSelectionPolicy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Audio Hls Rendition Selection
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioHlsRenditionSelection {
    /// Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
    pub group_id: std::option::Option<std::string::String>,
    /// Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AudioHlsRenditionSelection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioHlsRenditionSelection");
        formatter.field("group_id", &self.group_id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`AudioHlsRenditionSelection`](crate::model::AudioHlsRenditionSelection)
pub mod audio_hls_rendition_selection {
    /// A builder for [`AudioHlsRenditionSelection`](crate::model::AudioHlsRenditionSelection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) group_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
        pub fn group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_id = Some(input.into());
            self
        }
        /// Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio rendition.
        pub fn set_group_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_id = input;
            self
        }
        /// Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioHlsRenditionSelection`](crate::model::AudioHlsRenditionSelection)
        pub fn build(self) -> crate::model::AudioHlsRenditionSelection {
            crate::model::AudioHlsRenditionSelection {
                group_id: self.group_id,
                name: self.name,
            }
        }
    }
}
impl AudioHlsRenditionSelection {
    /// Creates a new builder-style object to manufacture [`AudioHlsRenditionSelection`](crate::model::AudioHlsRenditionSelection)
    pub fn builder() -> crate::model::audio_hls_rendition_selection::Builder {
        crate::model::audio_hls_rendition_selection::Builder::default()
    }
}

/// The settings for Automatic Input Failover.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AutomaticInputFailoverSettings {
    /// This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
    pub error_clear_time_msec: i32,
    /// A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.
    pub failover_conditions: std::option::Option<std::vec::Vec<crate::model::FailoverCondition>>,
    /// Input preference when deciding which input to make active when a previously failed input has recovered.
    pub input_preference: std::option::Option<crate::model::InputPreference>,
    /// The input ID of the secondary input in the automatic input failover pair.
    pub secondary_input_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AutomaticInputFailoverSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AutomaticInputFailoverSettings");
        formatter.field("error_clear_time_msec", &self.error_clear_time_msec);
        formatter.field("failover_conditions", &self.failover_conditions);
        formatter.field("input_preference", &self.input_preference);
        formatter.field("secondary_input_id", &self.secondary_input_id);
        formatter.finish()
    }
}
/// See [`AutomaticInputFailoverSettings`](crate::model::AutomaticInputFailoverSettings)
pub mod automatic_input_failover_settings {
    /// A builder for [`AutomaticInputFailoverSettings`](crate::model::AutomaticInputFailoverSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_clear_time_msec: std::option::Option<i32>,
        pub(crate) failover_conditions:
            std::option::Option<std::vec::Vec<crate::model::FailoverCondition>>,
        pub(crate) input_preference: std::option::Option<crate::model::InputPreference>,
        pub(crate) secondary_input_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
        pub fn error_clear_time_msec(mut self, input: i32) -> Self {
            self.error_clear_time_msec = Some(input);
            self
        }
        /// This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will switch back to the primary input.
        pub fn set_error_clear_time_msec(mut self, input: std::option::Option<i32>) -> Self {
            self.error_clear_time_msec = input;
            self
        }
        /// Appends an item to `failover_conditions`.
        ///
        /// To override the contents of this collection use [`set_failover_conditions`](Self::set_failover_conditions).
        ///
        /// A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.
        pub fn failover_conditions(
            mut self,
            input: impl Into<crate::model::FailoverCondition>,
        ) -> Self {
            let mut v = self.failover_conditions.unwrap_or_default();
            v.push(input.into());
            self.failover_conditions = Some(v);
            self
        }
        /// A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input.
        pub fn set_failover_conditions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FailoverCondition>>,
        ) -> Self {
            self.failover_conditions = input;
            self
        }
        /// Input preference when deciding which input to make active when a previously failed input has recovered.
        pub fn input_preference(mut self, input: crate::model::InputPreference) -> Self {
            self.input_preference = Some(input);
            self
        }
        /// Input preference when deciding which input to make active when a previously failed input has recovered.
        pub fn set_input_preference(
            mut self,
            input: std::option::Option<crate::model::InputPreference>,
        ) -> Self {
            self.input_preference = input;
            self
        }
        /// The input ID of the secondary input in the automatic input failover pair.
        pub fn secondary_input_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.secondary_input_id = Some(input.into());
            self
        }
        /// The input ID of the secondary input in the automatic input failover pair.
        pub fn set_secondary_input_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.secondary_input_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AutomaticInputFailoverSettings`](crate::model::AutomaticInputFailoverSettings)
        pub fn build(self) -> crate::model::AutomaticInputFailoverSettings {
            crate::model::AutomaticInputFailoverSettings {
                error_clear_time_msec: self.error_clear_time_msec.unwrap_or_default(),
                failover_conditions: self.failover_conditions,
                input_preference: self.input_preference,
                secondary_input_id: self.secondary_input_id,
            }
        }
    }
}
impl AutomaticInputFailoverSettings {
    /// Creates a new builder-style object to manufacture [`AutomaticInputFailoverSettings`](crate::model::AutomaticInputFailoverSettings)
    pub fn builder() -> crate::model::automatic_input_failover_settings::Builder {
        crate::model::automatic_input_failover_settings::Builder::default()
    }
}

/// Input preference when deciding which input to make active when a previously failed input has recovered.
/// If \"EQUAL_INPUT_PREFERENCE\", then the active input will stay active as long as it is healthy.
/// If \"PRIMARY_INPUT_PREFERRED\", then always switch back to the primary input when it is healthy.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputPreference {
    #[allow(missing_docs)] // documentation missing in model
    EqualInputPreference,
    #[allow(missing_docs)] // documentation missing in model
    PrimaryInputPreferred,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputPreference {
    fn from(s: &str) -> Self {
        match s {
            "EQUAL_INPUT_PREFERENCE" => InputPreference::EqualInputPreference,
            "PRIMARY_INPUT_PREFERRED" => InputPreference::PrimaryInputPreferred,
            other => InputPreference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputPreference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputPreference::from(s))
    }
}
impl InputPreference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputPreference::EqualInputPreference => "EQUAL_INPUT_PREFERENCE",
            InputPreference::PrimaryInputPreferred => "PRIMARY_INPUT_PREFERRED",
            InputPreference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQUAL_INPUT_PREFERENCE", "PRIMARY_INPUT_PREFERRED"]
    }
}
impl AsRef<str> for InputPreference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Failover Condition settings. There can be multiple failover conditions inside AutomaticInputFailoverSettings.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverCondition {
    /// Failover condition type-specific settings.
    pub failover_condition_settings: std::option::Option<crate::model::FailoverConditionSettings>,
}
impl std::fmt::Debug for FailoverCondition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverCondition");
        formatter.field(
            "failover_condition_settings",
            &self.failover_condition_settings,
        );
        formatter.finish()
    }
}
/// See [`FailoverCondition`](crate::model::FailoverCondition)
pub mod failover_condition {
    /// A builder for [`FailoverCondition`](crate::model::FailoverCondition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failover_condition_settings:
            std::option::Option<crate::model::FailoverConditionSettings>,
    }
    impl Builder {
        /// Failover condition type-specific settings.
        pub fn failover_condition_settings(
            mut self,
            input: crate::model::FailoverConditionSettings,
        ) -> Self {
            self.failover_condition_settings = Some(input);
            self
        }
        /// Failover condition type-specific settings.
        pub fn set_failover_condition_settings(
            mut self,
            input: std::option::Option<crate::model::FailoverConditionSettings>,
        ) -> Self {
            self.failover_condition_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverCondition`](crate::model::FailoverCondition)
        pub fn build(self) -> crate::model::FailoverCondition {
            crate::model::FailoverCondition {
                failover_condition_settings: self.failover_condition_settings,
            }
        }
    }
}
impl FailoverCondition {
    /// Creates a new builder-style object to manufacture [`FailoverCondition`](crate::model::FailoverCondition)
    pub fn builder() -> crate::model::failover_condition::Builder {
        crate::model::failover_condition::Builder::default()
    }
}

/// Settings for one failover condition.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverConditionSettings {
    /// MediaLive will perform a failover if the specified audio selector is silent for the specified period.
    pub audio_silence_settings: std::option::Option<crate::model::AudioSilenceFailoverSettings>,
    /// MediaLive will perform a failover if content is not detected in this input for the specified period.
    pub input_loss_settings: std::option::Option<crate::model::InputLossFailoverSettings>,
    /// MediaLive will perform a failover if content is considered black for the specified period.
    pub video_black_settings: std::option::Option<crate::model::VideoBlackFailoverSettings>,
}
impl std::fmt::Debug for FailoverConditionSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverConditionSettings");
        formatter.field("audio_silence_settings", &self.audio_silence_settings);
        formatter.field("input_loss_settings", &self.input_loss_settings);
        formatter.field("video_black_settings", &self.video_black_settings);
        formatter.finish()
    }
}
/// See [`FailoverConditionSettings`](crate::model::FailoverConditionSettings)
pub mod failover_condition_settings {
    /// A builder for [`FailoverConditionSettings`](crate::model::FailoverConditionSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_silence_settings:
            std::option::Option<crate::model::AudioSilenceFailoverSettings>,
        pub(crate) input_loss_settings:
            std::option::Option<crate::model::InputLossFailoverSettings>,
        pub(crate) video_black_settings:
            std::option::Option<crate::model::VideoBlackFailoverSettings>,
    }
    impl Builder {
        /// MediaLive will perform a failover if the specified audio selector is silent for the specified period.
        pub fn audio_silence_settings(
            mut self,
            input: crate::model::AudioSilenceFailoverSettings,
        ) -> Self {
            self.audio_silence_settings = Some(input);
            self
        }
        /// MediaLive will perform a failover if the specified audio selector is silent for the specified period.
        pub fn set_audio_silence_settings(
            mut self,
            input: std::option::Option<crate::model::AudioSilenceFailoverSettings>,
        ) -> Self {
            self.audio_silence_settings = input;
            self
        }
        /// MediaLive will perform a failover if content is not detected in this input for the specified period.
        pub fn input_loss_settings(
            mut self,
            input: crate::model::InputLossFailoverSettings,
        ) -> Self {
            self.input_loss_settings = Some(input);
            self
        }
        /// MediaLive will perform a failover if content is not detected in this input for the specified period.
        pub fn set_input_loss_settings(
            mut self,
            input: std::option::Option<crate::model::InputLossFailoverSettings>,
        ) -> Self {
            self.input_loss_settings = input;
            self
        }
        /// MediaLive will perform a failover if content is considered black for the specified period.
        pub fn video_black_settings(
            mut self,
            input: crate::model::VideoBlackFailoverSettings,
        ) -> Self {
            self.video_black_settings = Some(input);
            self
        }
        /// MediaLive will perform a failover if content is considered black for the specified period.
        pub fn set_video_black_settings(
            mut self,
            input: std::option::Option<crate::model::VideoBlackFailoverSettings>,
        ) -> Self {
            self.video_black_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverConditionSettings`](crate::model::FailoverConditionSettings)
        pub fn build(self) -> crate::model::FailoverConditionSettings {
            crate::model::FailoverConditionSettings {
                audio_silence_settings: self.audio_silence_settings,
                input_loss_settings: self.input_loss_settings,
                video_black_settings: self.video_black_settings,
            }
        }
    }
}
impl FailoverConditionSettings {
    /// Creates a new builder-style object to manufacture [`FailoverConditionSettings`](crate::model::FailoverConditionSettings)
    pub fn builder() -> crate::model::failover_condition_settings::Builder {
        crate::model::failover_condition_settings::Builder::default()
    }
}

/// Placeholder documentation for VideoBlackFailoverSettings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoBlackFailoverSettings {
    /// A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For the input to be considered black, every pixel in a frame must be below this threshold. The threshold is calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black). Note how the formula works for any color depth. For example, if you set this field to 0.1 in 10-bit color depth: (1023*0.1=102.3), which means a pixel value of 102 or less is 'black'. If you set this field to .1 in an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is 'black'. The range is 0.0 to 1.0, with any number of decimal places.
    pub black_detect_threshold: f64,
    /// The amount of time (in milliseconds) that the active input must be black before automatic input failover occurs.
    pub video_black_threshold_msec: i32,
}
impl std::fmt::Debug for VideoBlackFailoverSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoBlackFailoverSettings");
        formatter.field("black_detect_threshold", &self.black_detect_threshold);
        formatter.field(
            "video_black_threshold_msec",
            &self.video_black_threshold_msec,
        );
        formatter.finish()
    }
}
/// See [`VideoBlackFailoverSettings`](crate::model::VideoBlackFailoverSettings)
pub mod video_black_failover_settings {
    /// A builder for [`VideoBlackFailoverSettings`](crate::model::VideoBlackFailoverSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) black_detect_threshold: std::option::Option<f64>,
        pub(crate) video_black_threshold_msec: std::option::Option<i32>,
    }
    impl Builder {
        /// A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For the input to be considered black, every pixel in a frame must be below this threshold. The threshold is calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black). Note how the formula works for any color depth. For example, if you set this field to 0.1 in 10-bit color depth: (1023*0.1=102.3), which means a pixel value of 102 or less is 'black'. If you set this field to .1 in an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is 'black'. The range is 0.0 to 1.0, with any number of decimal places.
        pub fn black_detect_threshold(mut self, input: f64) -> Self {
            self.black_detect_threshold = Some(input);
            self
        }
        /// A value used in calculating the threshold below which MediaLive considers a pixel to be 'black'. For the input to be considered black, every pixel in a frame must be below this threshold. The threshold is calculated as a percentage (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black). Note how the formula works for any color depth. For example, if you set this field to 0.1 in 10-bit color depth: (1023*0.1=102.3), which means a pixel value of 102 or less is 'black'. If you set this field to .1 in an 8-bit color depth: (255*0.1=25.5), which means a pixel value of 25 or less is 'black'. The range is 0.0 to 1.0, with any number of decimal places.
        pub fn set_black_detect_threshold(mut self, input: std::option::Option<f64>) -> Self {
            self.black_detect_threshold = input;
            self
        }
        /// The amount of time (in milliseconds) that the active input must be black before automatic input failover occurs.
        pub fn video_black_threshold_msec(mut self, input: i32) -> Self {
            self.video_black_threshold_msec = Some(input);
            self
        }
        /// The amount of time (in milliseconds) that the active input must be black before automatic input failover occurs.
        pub fn set_video_black_threshold_msec(mut self, input: std::option::Option<i32>) -> Self {
            self.video_black_threshold_msec = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoBlackFailoverSettings`](crate::model::VideoBlackFailoverSettings)
        pub fn build(self) -> crate::model::VideoBlackFailoverSettings {
            crate::model::VideoBlackFailoverSettings {
                black_detect_threshold: self.black_detect_threshold.unwrap_or_default(),
                video_black_threshold_msec: self.video_black_threshold_msec.unwrap_or_default(),
            }
        }
    }
}
impl VideoBlackFailoverSettings {
    /// Creates a new builder-style object to manufacture [`VideoBlackFailoverSettings`](crate::model::VideoBlackFailoverSettings)
    pub fn builder() -> crate::model::video_black_failover_settings::Builder {
        crate::model::video_black_failover_settings::Builder::default()
    }
}

/// MediaLive will perform a failover if content is not detected in this input for the specified period.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputLossFailoverSettings {
    /// The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
    pub input_loss_threshold_msec: i32,
}
impl std::fmt::Debug for InputLossFailoverSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputLossFailoverSettings");
        formatter.field("input_loss_threshold_msec", &self.input_loss_threshold_msec);
        formatter.finish()
    }
}
/// See [`InputLossFailoverSettings`](crate::model::InputLossFailoverSettings)
pub mod input_loss_failover_settings {
    /// A builder for [`InputLossFailoverSettings`](crate::model::InputLossFailoverSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_loss_threshold_msec: std::option::Option<i32>,
    }
    impl Builder {
        /// The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
        pub fn input_loss_threshold_msec(mut self, input: i32) -> Self {
            self.input_loss_threshold_msec = Some(input);
            self
        }
        /// The amount of time (in milliseconds) that no input is detected. After that time, an input failover will occur.
        pub fn set_input_loss_threshold_msec(mut self, input: std::option::Option<i32>) -> Self {
            self.input_loss_threshold_msec = input;
            self
        }
        /// Consumes the builder and constructs a [`InputLossFailoverSettings`](crate::model::InputLossFailoverSettings)
        pub fn build(self) -> crate::model::InputLossFailoverSettings {
            crate::model::InputLossFailoverSettings {
                input_loss_threshold_msec: self.input_loss_threshold_msec.unwrap_or_default(),
            }
        }
    }
}
impl InputLossFailoverSettings {
    /// Creates a new builder-style object to manufacture [`InputLossFailoverSettings`](crate::model::InputLossFailoverSettings)
    pub fn builder() -> crate::model::input_loss_failover_settings::Builder {
        crate::model::input_loss_failover_settings::Builder::default()
    }
}

/// Placeholder documentation for AudioSilenceFailoverSettings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioSilenceFailoverSettings {
    /// The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
    pub audio_selector_name: std::option::Option<std::string::String>,
    /// The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
    pub audio_silence_threshold_msec: i32,
}
impl std::fmt::Debug for AudioSilenceFailoverSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioSilenceFailoverSettings");
        formatter.field("audio_selector_name", &self.audio_selector_name);
        formatter.field(
            "audio_silence_threshold_msec",
            &self.audio_silence_threshold_msec,
        );
        formatter.finish()
    }
}
/// See [`AudioSilenceFailoverSettings`](crate::model::AudioSilenceFailoverSettings)
pub mod audio_silence_failover_settings {
    /// A builder for [`AudioSilenceFailoverSettings`](crate::model::AudioSilenceFailoverSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_selector_name: std::option::Option<std::string::String>,
        pub(crate) audio_silence_threshold_msec: std::option::Option<i32>,
    }
    impl Builder {
        /// The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
        pub fn audio_selector_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_selector_name = Some(input.into());
            self
        }
        /// The name of the audio selector in the input that MediaLive should monitor to detect silence. Select your most important rendition. If you didn't create an audio selector in this input, leave blank.
        pub fn set_audio_selector_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_selector_name = input;
            self
        }
        /// The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
        pub fn audio_silence_threshold_msec(mut self, input: i32) -> Self {
            self.audio_silence_threshold_msec = Some(input);
            self
        }
        /// The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
        pub fn set_audio_silence_threshold_msec(mut self, input: std::option::Option<i32>) -> Self {
            self.audio_silence_threshold_msec = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioSilenceFailoverSettings`](crate::model::AudioSilenceFailoverSettings)
        pub fn build(self) -> crate::model::AudioSilenceFailoverSettings {
            crate::model::AudioSilenceFailoverSettings {
                audio_selector_name: self.audio_selector_name,
                audio_silence_threshold_msec: self.audio_silence_threshold_msec.unwrap_or_default(),
            }
        }
    }
}
impl AudioSilenceFailoverSettings {
    /// Creates a new builder-style object to manufacture [`AudioSilenceFailoverSettings`](crate::model::AudioSilenceFailoverSettings)
    pub fn builder() -> crate::model::audio_silence_failover_settings::Builder {
        crate::model::audio_silence_failover_settings::Builder::default()
    }
}

/// Encoder Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncoderSettings {
    /// Placeholder documentation for __listOfAudioDescription
    pub audio_descriptions: std::option::Option<std::vec::Vec<crate::model::AudioDescription>>,
    /// Settings for ad avail blanking.
    pub avail_blanking: std::option::Option<crate::model::AvailBlanking>,
    /// Event-wide configuration settings for ad avail insertion.
    pub avail_configuration: std::option::Option<crate::model::AvailConfiguration>,
    /// Settings for blackout slate.
    pub blackout_slate: std::option::Option<crate::model::BlackoutSlate>,
    /// Settings for caption decriptions
    pub caption_descriptions: std::option::Option<std::vec::Vec<crate::model::CaptionDescription>>,
    /// Feature Activations
    pub feature_activations: std::option::Option<crate::model::FeatureActivations>,
    /// Configuration settings that apply to the event as a whole.
    pub global_configuration: std::option::Option<crate::model::GlobalConfiguration>,
    /// Settings for motion graphics.
    pub motion_graphics_configuration:
        std::option::Option<crate::model::MotionGraphicsConfiguration>,
    /// Nielsen configuration settings.
    pub nielsen_configuration: std::option::Option<crate::model::NielsenConfiguration>,
    /// Placeholder documentation for __listOfOutputGroup
    pub output_groups: std::option::Option<std::vec::Vec<crate::model::OutputGroup>>,
    /// Contains settings used to acquire and adjust timecode information from inputs.
    pub timecode_config: std::option::Option<crate::model::TimecodeConfig>,
    /// Placeholder documentation for __listOfVideoDescription
    pub video_descriptions: std::option::Option<std::vec::Vec<crate::model::VideoDescription>>,
}
impl std::fmt::Debug for EncoderSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncoderSettings");
        formatter.field("audio_descriptions", &self.audio_descriptions);
        formatter.field("avail_blanking", &self.avail_blanking);
        formatter.field("avail_configuration", &self.avail_configuration);
        formatter.field("blackout_slate", &self.blackout_slate);
        formatter.field("caption_descriptions", &self.caption_descriptions);
        formatter.field("feature_activations", &self.feature_activations);
        formatter.field("global_configuration", &self.global_configuration);
        formatter.field(
            "motion_graphics_configuration",
            &self.motion_graphics_configuration,
        );
        formatter.field("nielsen_configuration", &self.nielsen_configuration);
        formatter.field("output_groups", &self.output_groups);
        formatter.field("timecode_config", &self.timecode_config);
        formatter.field("video_descriptions", &self.video_descriptions);
        formatter.finish()
    }
}
/// See [`EncoderSettings`](crate::model::EncoderSettings)
pub mod encoder_settings {
    /// A builder for [`EncoderSettings`](crate::model::EncoderSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_descriptions:
            std::option::Option<std::vec::Vec<crate::model::AudioDescription>>,
        pub(crate) avail_blanking: std::option::Option<crate::model::AvailBlanking>,
        pub(crate) avail_configuration: std::option::Option<crate::model::AvailConfiguration>,
        pub(crate) blackout_slate: std::option::Option<crate::model::BlackoutSlate>,
        pub(crate) caption_descriptions:
            std::option::Option<std::vec::Vec<crate::model::CaptionDescription>>,
        pub(crate) feature_activations: std::option::Option<crate::model::FeatureActivations>,
        pub(crate) global_configuration: std::option::Option<crate::model::GlobalConfiguration>,
        pub(crate) motion_graphics_configuration:
            std::option::Option<crate::model::MotionGraphicsConfiguration>,
        pub(crate) nielsen_configuration: std::option::Option<crate::model::NielsenConfiguration>,
        pub(crate) output_groups: std::option::Option<std::vec::Vec<crate::model::OutputGroup>>,
        pub(crate) timecode_config: std::option::Option<crate::model::TimecodeConfig>,
        pub(crate) video_descriptions:
            std::option::Option<std::vec::Vec<crate::model::VideoDescription>>,
    }
    impl Builder {
        /// Appends an item to `audio_descriptions`.
        ///
        /// To override the contents of this collection use [`set_audio_descriptions`](Self::set_audio_descriptions).
        ///
        /// Placeholder documentation for __listOfAudioDescription
        pub fn audio_descriptions(
            mut self,
            input: impl Into<crate::model::AudioDescription>,
        ) -> Self {
            let mut v = self.audio_descriptions.unwrap_or_default();
            v.push(input.into());
            self.audio_descriptions = Some(v);
            self
        }
        /// Placeholder documentation for __listOfAudioDescription
        pub fn set_audio_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AudioDescription>>,
        ) -> Self {
            self.audio_descriptions = input;
            self
        }
        /// Settings for ad avail blanking.
        pub fn avail_blanking(mut self, input: crate::model::AvailBlanking) -> Self {
            self.avail_blanking = Some(input);
            self
        }
        /// Settings for ad avail blanking.
        pub fn set_avail_blanking(
            mut self,
            input: std::option::Option<crate::model::AvailBlanking>,
        ) -> Self {
            self.avail_blanking = input;
            self
        }
        /// Event-wide configuration settings for ad avail insertion.
        pub fn avail_configuration(mut self, input: crate::model::AvailConfiguration) -> Self {
            self.avail_configuration = Some(input);
            self
        }
        /// Event-wide configuration settings for ad avail insertion.
        pub fn set_avail_configuration(
            mut self,
            input: std::option::Option<crate::model::AvailConfiguration>,
        ) -> Self {
            self.avail_configuration = input;
            self
        }
        /// Settings for blackout slate.
        pub fn blackout_slate(mut self, input: crate::model::BlackoutSlate) -> Self {
            self.blackout_slate = Some(input);
            self
        }
        /// Settings for blackout slate.
        pub fn set_blackout_slate(
            mut self,
            input: std::option::Option<crate::model::BlackoutSlate>,
        ) -> Self {
            self.blackout_slate = input;
            self
        }
        /// Appends an item to `caption_descriptions`.
        ///
        /// To override the contents of this collection use [`set_caption_descriptions`](Self::set_caption_descriptions).
        ///
        /// Settings for caption decriptions
        pub fn caption_descriptions(
            mut self,
            input: impl Into<crate::model::CaptionDescription>,
        ) -> Self {
            let mut v = self.caption_descriptions.unwrap_or_default();
            v.push(input.into());
            self.caption_descriptions = Some(v);
            self
        }
        /// Settings for caption decriptions
        pub fn set_caption_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaptionDescription>>,
        ) -> Self {
            self.caption_descriptions = input;
            self
        }
        /// Feature Activations
        pub fn feature_activations(mut self, input: crate::model::FeatureActivations) -> Self {
            self.feature_activations = Some(input);
            self
        }
        /// Feature Activations
        pub fn set_feature_activations(
            mut self,
            input: std::option::Option<crate::model::FeatureActivations>,
        ) -> Self {
            self.feature_activations = input;
            self
        }
        /// Configuration settings that apply to the event as a whole.
        pub fn global_configuration(mut self, input: crate::model::GlobalConfiguration) -> Self {
            self.global_configuration = Some(input);
            self
        }
        /// Configuration settings that apply to the event as a whole.
        pub fn set_global_configuration(
            mut self,
            input: std::option::Option<crate::model::GlobalConfiguration>,
        ) -> Self {
            self.global_configuration = input;
            self
        }
        /// Settings for motion graphics.
        pub fn motion_graphics_configuration(
            mut self,
            input: crate::model::MotionGraphicsConfiguration,
        ) -> Self {
            self.motion_graphics_configuration = Some(input);
            self
        }
        /// Settings for motion graphics.
        pub fn set_motion_graphics_configuration(
            mut self,
            input: std::option::Option<crate::model::MotionGraphicsConfiguration>,
        ) -> Self {
            self.motion_graphics_configuration = input;
            self
        }
        /// Nielsen configuration settings.
        pub fn nielsen_configuration(mut self, input: crate::model::NielsenConfiguration) -> Self {
            self.nielsen_configuration = Some(input);
            self
        }
        /// Nielsen configuration settings.
        pub fn set_nielsen_configuration(
            mut self,
            input: std::option::Option<crate::model::NielsenConfiguration>,
        ) -> Self {
            self.nielsen_configuration = input;
            self
        }
        /// Appends an item to `output_groups`.
        ///
        /// To override the contents of this collection use [`set_output_groups`](Self::set_output_groups).
        ///
        /// Placeholder documentation for __listOfOutputGroup
        pub fn output_groups(mut self, input: impl Into<crate::model::OutputGroup>) -> Self {
            let mut v = self.output_groups.unwrap_or_default();
            v.push(input.into());
            self.output_groups = Some(v);
            self
        }
        /// Placeholder documentation for __listOfOutputGroup
        pub fn set_output_groups(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::OutputGroup>>,
        ) -> Self {
            self.output_groups = input;
            self
        }
        /// Contains settings used to acquire and adjust timecode information from inputs.
        pub fn timecode_config(mut self, input: crate::model::TimecodeConfig) -> Self {
            self.timecode_config = Some(input);
            self
        }
        /// Contains settings used to acquire and adjust timecode information from inputs.
        pub fn set_timecode_config(
            mut self,
            input: std::option::Option<crate::model::TimecodeConfig>,
        ) -> Self {
            self.timecode_config = input;
            self
        }
        /// Appends an item to `video_descriptions`.
        ///
        /// To override the contents of this collection use [`set_video_descriptions`](Self::set_video_descriptions).
        ///
        /// Placeholder documentation for __listOfVideoDescription
        pub fn video_descriptions(
            mut self,
            input: impl Into<crate::model::VideoDescription>,
        ) -> Self {
            let mut v = self.video_descriptions.unwrap_or_default();
            v.push(input.into());
            self.video_descriptions = Some(v);
            self
        }
        /// Placeholder documentation for __listOfVideoDescription
        pub fn set_video_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VideoDescription>>,
        ) -> Self {
            self.video_descriptions = input;
            self
        }
        /// Consumes the builder and constructs a [`EncoderSettings`](crate::model::EncoderSettings)
        pub fn build(self) -> crate::model::EncoderSettings {
            crate::model::EncoderSettings {
                audio_descriptions: self.audio_descriptions,
                avail_blanking: self.avail_blanking,
                avail_configuration: self.avail_configuration,
                blackout_slate: self.blackout_slate,
                caption_descriptions: self.caption_descriptions,
                feature_activations: self.feature_activations,
                global_configuration: self.global_configuration,
                motion_graphics_configuration: self.motion_graphics_configuration,
                nielsen_configuration: self.nielsen_configuration,
                output_groups: self.output_groups,
                timecode_config: self.timecode_config,
                video_descriptions: self.video_descriptions,
            }
        }
    }
}
impl EncoderSettings {
    /// Creates a new builder-style object to manufacture [`EncoderSettings`](crate::model::EncoderSettings)
    pub fn builder() -> crate::model::encoder_settings::Builder {
        crate::model::encoder_settings::Builder::default()
    }
}

/// Video settings for this stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoDescription {
    /// Video codec settings.
    pub codec_settings: std::option::Option<crate::model::VideoCodecSettings>,
    /// Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
    pub height: i32,
    /// The name of this VideoDescription. Outputs will use this name to uniquely identify this Description.  Description names should be unique within this Live Event.
    pub name: std::option::Option<std::string::String>,
    /// Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH.
    /// RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE.
    /// PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in the output.
    /// NONE: MediaLive does not clip the input video and does not include the AFD values in the output
    pub respond_to_afd: std::option::Option<crate::model::VideoDescriptionRespondToAfd>,
    /// STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
    pub scaling_behavior: std::option::Option<crate::model::VideoDescriptionScalingBehavior>,
    /// Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A setting of 50 is recommended for most content.
    pub sharpness: i32,
    /// Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
    pub width: i32,
}
impl std::fmt::Debug for VideoDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoDescription");
        formatter.field("codec_settings", &self.codec_settings);
        formatter.field("height", &self.height);
        formatter.field("name", &self.name);
        formatter.field("respond_to_afd", &self.respond_to_afd);
        formatter.field("scaling_behavior", &self.scaling_behavior);
        formatter.field("sharpness", &self.sharpness);
        formatter.field("width", &self.width);
        formatter.finish()
    }
}
/// See [`VideoDescription`](crate::model::VideoDescription)
pub mod video_description {
    /// A builder for [`VideoDescription`](crate::model::VideoDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) codec_settings: std::option::Option<crate::model::VideoCodecSettings>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) respond_to_afd: std::option::Option<crate::model::VideoDescriptionRespondToAfd>,
        pub(crate) scaling_behavior:
            std::option::Option<crate::model::VideoDescriptionScalingBehavior>,
        pub(crate) sharpness: std::option::Option<i32>,
        pub(crate) width: std::option::Option<i32>,
    }
    impl Builder {
        /// Video codec settings.
        pub fn codec_settings(mut self, input: crate::model::VideoCodecSettings) -> Self {
            self.codec_settings = Some(input);
            self
        }
        /// Video codec settings.
        pub fn set_codec_settings(
            mut self,
            input: std::option::Option<crate::model::VideoCodecSettings>,
        ) -> Self {
            self.codec_settings = input;
            self
        }
        /// Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// Output video height, in pixels. Must be an even number. For most codecs, you can leave this field and width blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// The name of this VideoDescription. Outputs will use this name to uniquely identify this Description.  Description names should be unique within this Live Event.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of this VideoDescription. Outputs will use this name to uniquely identify this Description.  Description names should be unique within this Live Event.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH.
        /// RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE.
        /// PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in the output.
        /// NONE: MediaLive does not clip the input video and does not include the AFD values in the output
        pub fn respond_to_afd(mut self, input: crate::model::VideoDescriptionRespondToAfd) -> Self {
            self.respond_to_afd = Some(input);
            self
        }
        /// Indicates how MediaLive will respond to the AFD values that might be in the input video. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose PASSTHROUGH.
        /// RESPOND: MediaLive clips the input video using a formula that uses the AFD values (configured in afdSignaling ), the input display aspect ratio, and the output display aspect ratio. MediaLive also includes the AFD values in the output, unless the codec for this encode is FRAME_CAPTURE.
        /// PASSTHROUGH: MediaLive ignores the AFD values and does not clip the video. But MediaLive does include the values in the output.
        /// NONE: MediaLive does not clip the input video and does not include the AFD values in the output
        pub fn set_respond_to_afd(
            mut self,
            input: std::option::Option<crate::model::VideoDescriptionRespondToAfd>,
        ) -> Self {
            self.respond_to_afd = input;
            self
        }
        /// STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
        pub fn scaling_behavior(
            mut self,
            input: crate::model::VideoDescriptionScalingBehavior,
        ) -> Self {
            self.scaling_behavior = Some(input);
            self
        }
        /// STRETCH_TO_OUTPUT configures the output position to stretch the video to the specified output resolution (height and width). This option will override any position value. DEFAULT may insert black boxes (pillar boxes or letter boxes) around the video to provide the specified output resolution.
        pub fn set_scaling_behavior(
            mut self,
            input: std::option::Option<crate::model::VideoDescriptionScalingBehavior>,
        ) -> Self {
            self.scaling_behavior = input;
            self
        }
        /// Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A setting of 50 is recommended for most content.
        pub fn sharpness(mut self, input: i32) -> Self {
            self.sharpness = Some(input);
            self
        }
        /// Changes the strength of the anti-alias filter used for scaling. 0 is the softest setting, 100 is the sharpest. A setting of 50 is recommended for most content.
        pub fn set_sharpness(mut self, input: std::option::Option<i32>) -> Self {
            self.sharpness = input;
            self
        }
        /// Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// Output video width, in pixels. Must be an even number. For most codecs, you can leave this field and height blank in order to use the height and width (resolution) from the source. Note, however, that leaving blank is not recommended. For the Frame Capture codec, height and width are required.
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoDescription`](crate::model::VideoDescription)
        pub fn build(self) -> crate::model::VideoDescription {
            crate::model::VideoDescription {
                codec_settings: self.codec_settings,
                height: self.height.unwrap_or_default(),
                name: self.name,
                respond_to_afd: self.respond_to_afd,
                scaling_behavior: self.scaling_behavior,
                sharpness: self.sharpness.unwrap_or_default(),
                width: self.width.unwrap_or_default(),
            }
        }
    }
}
impl VideoDescription {
    /// Creates a new builder-style object to manufacture [`VideoDescription`](crate::model::VideoDescription)
    pub fn builder() -> crate::model::video_description::Builder {
        crate::model::video_description::Builder::default()
    }
}

/// Video Description Scaling Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoDescriptionScalingBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    StretchToOutput,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoDescriptionScalingBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => VideoDescriptionScalingBehavior::Default,
            "STRETCH_TO_OUTPUT" => VideoDescriptionScalingBehavior::StretchToOutput,
            other => VideoDescriptionScalingBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoDescriptionScalingBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoDescriptionScalingBehavior::from(s))
    }
}
impl VideoDescriptionScalingBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoDescriptionScalingBehavior::Default => "DEFAULT",
            VideoDescriptionScalingBehavior::StretchToOutput => "STRETCH_TO_OUTPUT",
            VideoDescriptionScalingBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "STRETCH_TO_OUTPUT"]
    }
}
impl AsRef<str> for VideoDescriptionScalingBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Video Description Respond To Afd
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoDescriptionRespondToAfd {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    #[allow(missing_docs)] // documentation missing in model
    Respond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoDescriptionRespondToAfd {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => VideoDescriptionRespondToAfd::None,
            "PASSTHROUGH" => VideoDescriptionRespondToAfd::Passthrough,
            "RESPOND" => VideoDescriptionRespondToAfd::Respond,
            other => VideoDescriptionRespondToAfd::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoDescriptionRespondToAfd {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoDescriptionRespondToAfd::from(s))
    }
}
impl VideoDescriptionRespondToAfd {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoDescriptionRespondToAfd::None => "NONE",
            VideoDescriptionRespondToAfd::Passthrough => "PASSTHROUGH",
            VideoDescriptionRespondToAfd::Respond => "RESPOND",
            VideoDescriptionRespondToAfd::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PASSTHROUGH", "RESPOND"]
    }
}
impl AsRef<str> for VideoDescriptionRespondToAfd {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Video Codec Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoCodecSettings {
    /// Frame Capture Settings
    pub frame_capture_settings: std::option::Option<crate::model::FrameCaptureSettings>,
    /// H264 Settings
    pub h264_settings: std::option::Option<crate::model::H264Settings>,
    /// H265 Settings
    pub h265_settings: std::option::Option<crate::model::H265Settings>,
    /// Mpeg2 Settings
    pub mpeg2_settings: std::option::Option<crate::model::Mpeg2Settings>,
}
impl std::fmt::Debug for VideoCodecSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoCodecSettings");
        formatter.field("frame_capture_settings", &self.frame_capture_settings);
        formatter.field("h264_settings", &self.h264_settings);
        formatter.field("h265_settings", &self.h265_settings);
        formatter.field("mpeg2_settings", &self.mpeg2_settings);
        formatter.finish()
    }
}
/// See [`VideoCodecSettings`](crate::model::VideoCodecSettings)
pub mod video_codec_settings {
    /// A builder for [`VideoCodecSettings`](crate::model::VideoCodecSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) frame_capture_settings: std::option::Option<crate::model::FrameCaptureSettings>,
        pub(crate) h264_settings: std::option::Option<crate::model::H264Settings>,
        pub(crate) h265_settings: std::option::Option<crate::model::H265Settings>,
        pub(crate) mpeg2_settings: std::option::Option<crate::model::Mpeg2Settings>,
    }
    impl Builder {
        /// Frame Capture Settings
        pub fn frame_capture_settings(mut self, input: crate::model::FrameCaptureSettings) -> Self {
            self.frame_capture_settings = Some(input);
            self
        }
        /// Frame Capture Settings
        pub fn set_frame_capture_settings(
            mut self,
            input: std::option::Option<crate::model::FrameCaptureSettings>,
        ) -> Self {
            self.frame_capture_settings = input;
            self
        }
        /// H264 Settings
        pub fn h264_settings(mut self, input: crate::model::H264Settings) -> Self {
            self.h264_settings = Some(input);
            self
        }
        /// H264 Settings
        pub fn set_h264_settings(
            mut self,
            input: std::option::Option<crate::model::H264Settings>,
        ) -> Self {
            self.h264_settings = input;
            self
        }
        /// H265 Settings
        pub fn h265_settings(mut self, input: crate::model::H265Settings) -> Self {
            self.h265_settings = Some(input);
            self
        }
        /// H265 Settings
        pub fn set_h265_settings(
            mut self,
            input: std::option::Option<crate::model::H265Settings>,
        ) -> Self {
            self.h265_settings = input;
            self
        }
        /// Mpeg2 Settings
        pub fn mpeg2_settings(mut self, input: crate::model::Mpeg2Settings) -> Self {
            self.mpeg2_settings = Some(input);
            self
        }
        /// Mpeg2 Settings
        pub fn set_mpeg2_settings(
            mut self,
            input: std::option::Option<crate::model::Mpeg2Settings>,
        ) -> Self {
            self.mpeg2_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoCodecSettings`](crate::model::VideoCodecSettings)
        pub fn build(self) -> crate::model::VideoCodecSettings {
            crate::model::VideoCodecSettings {
                frame_capture_settings: self.frame_capture_settings,
                h264_settings: self.h264_settings,
                h265_settings: self.h265_settings,
                mpeg2_settings: self.mpeg2_settings,
            }
        }
    }
}
impl VideoCodecSettings {
    /// Creates a new builder-style object to manufacture [`VideoCodecSettings`](crate::model::VideoCodecSettings)
    pub fn builder() -> crate::model::video_codec_settings::Builder {
        crate::model::video_codec_settings::Builder::default()
    }
}

/// Mpeg2 Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Mpeg2Settings {
    /// Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.
    pub adaptive_quantization: std::option::Option<crate::model::Mpeg2AdaptiveQuantization>,
    /// Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO.
    /// AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid).
    /// FIXED: MediaLive will use the value you specify in fixedAFD.
    pub afd_signaling: std::option::Option<crate::model::AfdSignaling>,
    /// Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.
    pub color_metadata: std::option::Option<crate::model::Mpeg2ColorMetadata>,
    /// Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features - Video - color space\" in the MediaLive User Guide.
    /// PASSTHROUGH: Keep the color space of the input content - do not convert it.
    /// AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
    pub color_space: std::option::Option<crate::model::Mpeg2ColorSpace>,
    /// Sets the pixel aspect ratio for the encode.
    pub display_aspect_ratio: std::option::Option<crate::model::Mpeg2DisplayRatio>,
    /// Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied.
    /// TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean.
    /// When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise.
    /// When the content is reasonably clean, the filter tends to decrease the bitrate.
    pub filter_settings: std::option::Option<crate::model::Mpeg2FilterSettings>,
    /// Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.
    pub fixed_afd: std::option::Option<crate::model::FixedAfd>,
    /// description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
    pub framerate_denominator: i32,
    /// The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
    pub framerate_numerator: i32,
    /// MPEG2: default is open GOP.
    pub gop_closed_cadence: i32,
    /// Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.
    pub gop_num_b_frames: i32,
    /// Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default.
    /// If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1.
    /// If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.
    pub gop_size: f64,
    /// Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.
    pub gop_size_units: std::option::Option<crate::model::Mpeg2GopSizeUnits>,
    /// Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
    pub scan_type: std::option::Option<crate::model::Mpeg2ScanType>,
    /// Relates to the GOP structure. If you do not know what GOP is, use the default.
    /// FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames.
    /// DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.
    pub subgop_length: std::option::Option<crate::model::Mpeg2SubGopLength>,
    /// Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the MediaLive User Guide.
    /// DISABLED: do not include timecodes.
    /// GOP_TIMECODE: Include timecode metadata in the GOP header.
    pub timecode_insertion: std::option::Option<crate::model::Mpeg2TimecodeInsertionBehavior>,
}
impl std::fmt::Debug for Mpeg2Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Mpeg2Settings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field("afd_signaling", &self.afd_signaling);
        formatter.field("color_metadata", &self.color_metadata);
        formatter.field("color_space", &self.color_space);
        formatter.field("display_aspect_ratio", &self.display_aspect_ratio);
        formatter.field("filter_settings", &self.filter_settings);
        formatter.field("fixed_afd", &self.fixed_afd);
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("gop_num_b_frames", &self.gop_num_b_frames);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("gop_size_units", &self.gop_size_units);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("subgop_length", &self.subgop_length);
        formatter.field("timecode_insertion", &self.timecode_insertion);
        formatter.finish()
    }
}
/// See [`Mpeg2Settings`](crate::model::Mpeg2Settings)
pub mod mpeg2_settings {
    /// A builder for [`Mpeg2Settings`](crate::model::Mpeg2Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::Mpeg2AdaptiveQuantization>,
        pub(crate) afd_signaling: std::option::Option<crate::model::AfdSignaling>,
        pub(crate) color_metadata: std::option::Option<crate::model::Mpeg2ColorMetadata>,
        pub(crate) color_space: std::option::Option<crate::model::Mpeg2ColorSpace>,
        pub(crate) display_aspect_ratio: std::option::Option<crate::model::Mpeg2DisplayRatio>,
        pub(crate) filter_settings: std::option::Option<crate::model::Mpeg2FilterSettings>,
        pub(crate) fixed_afd: std::option::Option<crate::model::FixedAfd>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) gop_num_b_frames: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) gop_size_units: std::option::Option<crate::model::Mpeg2GopSizeUnits>,
        pub(crate) scan_type: std::option::Option<crate::model::Mpeg2ScanType>,
        pub(crate) subgop_length: std::option::Option<crate::model::Mpeg2SubGopLength>,
        pub(crate) timecode_insertion:
            std::option::Option<crate::model::Mpeg2TimecodeInsertionBehavior>,
    }
    impl Builder {
        /// Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::Mpeg2AdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Choose Off to disable adaptive quantization. Or choose another value to enable the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium, High. When you enable this field, MediaLive allows intra-frame quantizers to vary, which might improve visual quality.
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::Mpeg2AdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO.
        /// AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid).
        /// FIXED: MediaLive will use the value you specify in fixedAFD.
        pub fn afd_signaling(mut self, input: crate::model::AfdSignaling) -> Self {
            self.afd_signaling = Some(input);
            self
        }
        /// Indicates the AFD values that MediaLive will write into the video encode. If you do not know what AFD signaling is, or if your downstream system has not given you guidance, choose AUTO.
        /// AUTO: MediaLive will try to preserve the input AFD value (in cases where multiple AFD values are valid).
        /// FIXED: MediaLive will use the value you specify in fixedAFD.
        pub fn set_afd_signaling(
            mut self,
            input: std::option::Option<crate::model::AfdSignaling>,
        ) -> Self {
            self.afd_signaling = input;
            self
        }
        /// Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.
        pub fn color_metadata(mut self, input: crate::model::Mpeg2ColorMetadata) -> Self {
            self.color_metadata = Some(input);
            self
        }
        /// Specifies whether to include the color space metadata. The metadata describes the color space that applies to the video (the colorSpace field). We recommend that you insert the metadata.
        pub fn set_color_metadata(
            mut self,
            input: std::option::Option<crate::model::Mpeg2ColorMetadata>,
        ) -> Self {
            self.color_metadata = input;
            self
        }
        /// Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features - Video - color space\" in the MediaLive User Guide.
        /// PASSTHROUGH: Keep the color space of the input content - do not convert it.
        /// AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
        pub fn color_space(mut self, input: crate::model::Mpeg2ColorSpace) -> Self {
            self.color_space = Some(input);
            self
        }
        /// Choose the type of color space conversion to apply to the output. For detailed information on setting up both the input and the output to obtain the desired color space in the output, see the section on \"MediaLive Features - Video - color space\" in the MediaLive User Guide.
        /// PASSTHROUGH: Keep the color space of the input content - do not convert it.
        /// AUTO:Convert all content that is SD to rec 601, and convert all content that is HD to rec 709.
        pub fn set_color_space(
            mut self,
            input: std::option::Option<crate::model::Mpeg2ColorSpace>,
        ) -> Self {
            self.color_space = input;
            self
        }
        /// Sets the pixel aspect ratio for the encode.
        pub fn display_aspect_ratio(mut self, input: crate::model::Mpeg2DisplayRatio) -> Self {
            self.display_aspect_ratio = Some(input);
            self
        }
        /// Sets the pixel aspect ratio for the encode.
        pub fn set_display_aspect_ratio(
            mut self,
            input: std::option::Option<crate::model::Mpeg2DisplayRatio>,
        ) -> Self {
            self.display_aspect_ratio = input;
            self
        }
        /// Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied.
        /// TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean.
        /// When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise.
        /// When the content is reasonably clean, the filter tends to decrease the bitrate.
        pub fn filter_settings(mut self, input: crate::model::Mpeg2FilterSettings) -> Self {
            self.filter_settings = Some(input);
            self
        }
        /// Optionally specify a noise reduction filter, which can improve quality of compressed content. If you do not choose a filter, no filter will be applied.
        /// TEMPORAL: This filter is useful for both source content that is noisy (when it has excessive digital artifacts) and source content that is clean.
        /// When the content is noisy, the filter cleans up the source content before the encoding phase, with these two effects: First, it improves the output video quality because the content has been cleaned up. Secondly, it decreases the bandwidth because MediaLive does not waste bits on encoding noise.
        /// When the content is reasonably clean, the filter tends to decrease the bitrate.
        pub fn set_filter_settings(
            mut self,
            input: std::option::Option<crate::model::Mpeg2FilterSettings>,
        ) -> Self {
            self.filter_settings = input;
            self
        }
        /// Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.
        pub fn fixed_afd(mut self, input: crate::model::FixedAfd) -> Self {
            self.fixed_afd = Some(input);
            self
        }
        /// Complete this field only when afdSignaling is set to FIXED. Enter the AFD value (4 bits) to write on all frames of the video encode.
        pub fn set_fixed_afd(mut self, input: std::option::Option<crate::model::FixedAfd>) -> Self {
            self.fixed_afd = input;
            self
        }
        /// description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// description": "The framerate denominator. For example, 1001. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// The framerate numerator. For example, 24000. The framerate is the numerator divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// MPEG2: default is open GOP.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// MPEG2: default is open GOP.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.
        pub fn gop_num_b_frames(mut self, input: i32) -> Self {
            self.gop_num_b_frames = Some(input);
            self
        }
        /// Relates to the GOP structure. The number of B-frames between reference frames. If you do not know what a B-frame is, use the default.
        pub fn set_gop_num_b_frames(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_num_b_frames = input;
            self
        }
        /// Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default.
        /// If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1.
        /// If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// Relates to the GOP structure. The GOP size (keyframe interval) in the units specified in gopSizeUnits. If you do not know what GOP is, use the default.
        /// If gopSizeUnits is frames, then the gopSize must be an integer and must be greater than or equal to 1.
        /// If gopSizeUnits is seconds, the gopSize must be greater than 0, but does not need to be an integer.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.
        pub fn gop_size_units(mut self, input: crate::model::Mpeg2GopSizeUnits) -> Self {
            self.gop_size_units = Some(input);
            self
        }
        /// Relates to the GOP structure. Specifies whether the gopSize is specified in frames or seconds. If you do not plan to change the default gopSize, leave the default. If you specify SECONDS, MediaLive will internally convert the gop size to a frame count.
        pub fn set_gop_size_units(
            mut self,
            input: std::option::Option<crate::model::Mpeg2GopSizeUnits>,
        ) -> Self {
            self.gop_size_units = input;
            self
        }
        /// Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
        pub fn scan_type(mut self, input: crate::model::Mpeg2ScanType) -> Self {
            self.scan_type = Some(input);
            self
        }
        /// Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
        pub fn set_scan_type(
            mut self,
            input: std::option::Option<crate::model::Mpeg2ScanType>,
        ) -> Self {
            self.scan_type = input;
            self
        }
        /// Relates to the GOP structure. If you do not know what GOP is, use the default.
        /// FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames.
        /// DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.
        pub fn subgop_length(mut self, input: crate::model::Mpeg2SubGopLength) -> Self {
            self.subgop_length = Some(input);
            self
        }
        /// Relates to the GOP structure. If you do not know what GOP is, use the default.
        /// FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames.
        /// DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to improve visual quality.
        pub fn set_subgop_length(
            mut self,
            input: std::option::Option<crate::model::Mpeg2SubGopLength>,
        ) -> Self {
            self.subgop_length = input;
            self
        }
        /// Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the MediaLive User Guide.
        /// DISABLED: do not include timecodes.
        /// GOP_TIMECODE: Include timecode metadata in the GOP header.
        pub fn timecode_insertion(
            mut self,
            input: crate::model::Mpeg2TimecodeInsertionBehavior,
        ) -> Self {
            self.timecode_insertion = Some(input);
            self
        }
        /// Determines how MediaLive inserts timecodes in the output video. For detailed information about setting up the input and the output for a timecode, see the section on \"MediaLive Features - Timecode configuration\" in the MediaLive User Guide.
        /// DISABLED: do not include timecodes.
        /// GOP_TIMECODE: Include timecode metadata in the GOP header.
        pub fn set_timecode_insertion(
            mut self,
            input: std::option::Option<crate::model::Mpeg2TimecodeInsertionBehavior>,
        ) -> Self {
            self.timecode_insertion = input;
            self
        }
        /// Consumes the builder and constructs a [`Mpeg2Settings`](crate::model::Mpeg2Settings)
        pub fn build(self) -> crate::model::Mpeg2Settings {
            crate::model::Mpeg2Settings {
                adaptive_quantization: self.adaptive_quantization,
                afd_signaling: self.afd_signaling,
                color_metadata: self.color_metadata,
                color_space: self.color_space,
                display_aspect_ratio: self.display_aspect_ratio,
                filter_settings: self.filter_settings,
                fixed_afd: self.fixed_afd,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                gop_num_b_frames: self.gop_num_b_frames.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                gop_size_units: self.gop_size_units,
                scan_type: self.scan_type,
                subgop_length: self.subgop_length,
                timecode_insertion: self.timecode_insertion,
            }
        }
    }
}
impl Mpeg2Settings {
    /// Creates a new builder-style object to manufacture [`Mpeg2Settings`](crate::model::Mpeg2Settings)
    pub fn builder() -> crate::model::mpeg2_settings::Builder {
        crate::model::mpeg2_settings::Builder::default()
    }
}

/// Mpeg2 Timecode Insertion Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2TimecodeInsertionBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    GopTimecode,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2TimecodeInsertionBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Mpeg2TimecodeInsertionBehavior::Disabled,
            "GOP_TIMECODE" => Mpeg2TimecodeInsertionBehavior::GopTimecode,
            other => Mpeg2TimecodeInsertionBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2TimecodeInsertionBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2TimecodeInsertionBehavior::from(s))
    }
}
impl Mpeg2TimecodeInsertionBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2TimecodeInsertionBehavior::Disabled => "DISABLED",
            Mpeg2TimecodeInsertionBehavior::GopTimecode => "GOP_TIMECODE",
            Mpeg2TimecodeInsertionBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "GOP_TIMECODE"]
    }
}
impl AsRef<str> for Mpeg2TimecodeInsertionBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Sub Gop Length
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2SubGopLength {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Fixed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2SubGopLength {
    fn from(s: &str) -> Self {
        match s {
            "DYNAMIC" => Mpeg2SubGopLength::Dynamic,
            "FIXED" => Mpeg2SubGopLength::Fixed,
            other => Mpeg2SubGopLength::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2SubGopLength {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2SubGopLength::from(s))
    }
}
impl Mpeg2SubGopLength {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2SubGopLength::Dynamic => "DYNAMIC",
            Mpeg2SubGopLength::Fixed => "FIXED",
            Mpeg2SubGopLength::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DYNAMIC", "FIXED"]
    }
}
impl AsRef<str> for Mpeg2SubGopLength {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Scan Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2ScanType {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2ScanType {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => Mpeg2ScanType::Interlaced,
            "PROGRESSIVE" => Mpeg2ScanType::Progressive,
            other => Mpeg2ScanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2ScanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2ScanType::from(s))
    }
}
impl Mpeg2ScanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2ScanType::Interlaced => "INTERLACED",
            Mpeg2ScanType::Progressive => "PROGRESSIVE",
            Mpeg2ScanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "PROGRESSIVE"]
    }
}
impl AsRef<str> for Mpeg2ScanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Gop Size Units
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2GopSizeUnits {
    #[allow(missing_docs)] // documentation missing in model
    Frames,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2GopSizeUnits {
    fn from(s: &str) -> Self {
        match s {
            "FRAMES" => Mpeg2GopSizeUnits::Frames,
            "SECONDS" => Mpeg2GopSizeUnits::Seconds,
            other => Mpeg2GopSizeUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2GopSizeUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2GopSizeUnits::from(s))
    }
}
impl Mpeg2GopSizeUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2GopSizeUnits::Frames => "FRAMES",
            Mpeg2GopSizeUnits::Seconds => "SECONDS",
            Mpeg2GopSizeUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAMES", "SECONDS"]
    }
}
impl AsRef<str> for Mpeg2GopSizeUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Fixed Afd
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FixedAfd {
    #[allow(missing_docs)] // documentation missing in model
    Afd0000,
    #[allow(missing_docs)] // documentation missing in model
    Afd0010,
    #[allow(missing_docs)] // documentation missing in model
    Afd0011,
    #[allow(missing_docs)] // documentation missing in model
    Afd0100,
    #[allow(missing_docs)] // documentation missing in model
    Afd1000,
    #[allow(missing_docs)] // documentation missing in model
    Afd1001,
    #[allow(missing_docs)] // documentation missing in model
    Afd1010,
    #[allow(missing_docs)] // documentation missing in model
    Afd1011,
    #[allow(missing_docs)] // documentation missing in model
    Afd1101,
    #[allow(missing_docs)] // documentation missing in model
    Afd1110,
    #[allow(missing_docs)] // documentation missing in model
    Afd1111,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FixedAfd {
    fn from(s: &str) -> Self {
        match s {
            "AFD_0000" => FixedAfd::Afd0000,
            "AFD_0010" => FixedAfd::Afd0010,
            "AFD_0011" => FixedAfd::Afd0011,
            "AFD_0100" => FixedAfd::Afd0100,
            "AFD_1000" => FixedAfd::Afd1000,
            "AFD_1001" => FixedAfd::Afd1001,
            "AFD_1010" => FixedAfd::Afd1010,
            "AFD_1011" => FixedAfd::Afd1011,
            "AFD_1101" => FixedAfd::Afd1101,
            "AFD_1110" => FixedAfd::Afd1110,
            "AFD_1111" => FixedAfd::Afd1111,
            other => FixedAfd::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FixedAfd {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FixedAfd::from(s))
    }
}
impl FixedAfd {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FixedAfd::Afd0000 => "AFD_0000",
            FixedAfd::Afd0010 => "AFD_0010",
            FixedAfd::Afd0011 => "AFD_0011",
            FixedAfd::Afd0100 => "AFD_0100",
            FixedAfd::Afd1000 => "AFD_1000",
            FixedAfd::Afd1001 => "AFD_1001",
            FixedAfd::Afd1010 => "AFD_1010",
            FixedAfd::Afd1011 => "AFD_1011",
            FixedAfd::Afd1101 => "AFD_1101",
            FixedAfd::Afd1110 => "AFD_1110",
            FixedAfd::Afd1111 => "AFD_1111",
            FixedAfd::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AFD_0000", "AFD_0010", "AFD_0011", "AFD_0100", "AFD_1000", "AFD_1001", "AFD_1010",
            "AFD_1011", "AFD_1101", "AFD_1110", "AFD_1111",
        ]
    }
}
impl AsRef<str> for FixedAfd {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Filter Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Mpeg2FilterSettings {
    /// Temporal Filter Settings
    pub temporal_filter_settings: std::option::Option<crate::model::TemporalFilterSettings>,
}
impl std::fmt::Debug for Mpeg2FilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Mpeg2FilterSettings");
        formatter.field("temporal_filter_settings", &self.temporal_filter_settings);
        formatter.finish()
    }
}
/// See [`Mpeg2FilterSettings`](crate::model::Mpeg2FilterSettings)
pub mod mpeg2_filter_settings {
    /// A builder for [`Mpeg2FilterSettings`](crate::model::Mpeg2FilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) temporal_filter_settings:
            std::option::Option<crate::model::TemporalFilterSettings>,
    }
    impl Builder {
        /// Temporal Filter Settings
        pub fn temporal_filter_settings(
            mut self,
            input: crate::model::TemporalFilterSettings,
        ) -> Self {
            self.temporal_filter_settings = Some(input);
            self
        }
        /// Temporal Filter Settings
        pub fn set_temporal_filter_settings(
            mut self,
            input: std::option::Option<crate::model::TemporalFilterSettings>,
        ) -> Self {
            self.temporal_filter_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`Mpeg2FilterSettings`](crate::model::Mpeg2FilterSettings)
        pub fn build(self) -> crate::model::Mpeg2FilterSettings {
            crate::model::Mpeg2FilterSettings {
                temporal_filter_settings: self.temporal_filter_settings,
            }
        }
    }
}
impl Mpeg2FilterSettings {
    /// Creates a new builder-style object to manufacture [`Mpeg2FilterSettings`](crate::model::Mpeg2FilterSettings)
    pub fn builder() -> crate::model::mpeg2_filter_settings::Builder {
        crate::model::mpeg2_filter_settings::Builder::default()
    }
}

/// Temporal Filter Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TemporalFilterSettings {
    /// If you enable this filter, the results are the following:
    /// - If the source content is noisy (it contains excessive digital artifacts), the filter cleans up the source.
    /// - If the source content is already clean, the filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
    pub post_filter_sharpening:
        std::option::Option<crate::model::TemporalFilterPostFilterSharpening>,
    /// Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good information, resulting in an image that is overly soft.
    pub strength: std::option::Option<crate::model::TemporalFilterStrength>,
}
impl std::fmt::Debug for TemporalFilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TemporalFilterSettings");
        formatter.field("post_filter_sharpening", &self.post_filter_sharpening);
        formatter.field("strength", &self.strength);
        formatter.finish()
    }
}
/// See [`TemporalFilterSettings`](crate::model::TemporalFilterSettings)
pub mod temporal_filter_settings {
    /// A builder for [`TemporalFilterSettings`](crate::model::TemporalFilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) post_filter_sharpening:
            std::option::Option<crate::model::TemporalFilterPostFilterSharpening>,
        pub(crate) strength: std::option::Option<crate::model::TemporalFilterStrength>,
    }
    impl Builder {
        /// If you enable this filter, the results are the following:
        /// - If the source content is noisy (it contains excessive digital artifacts), the filter cleans up the source.
        /// - If the source content is already clean, the filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
        pub fn post_filter_sharpening(
            mut self,
            input: crate::model::TemporalFilterPostFilterSharpening,
        ) -> Self {
            self.post_filter_sharpening = Some(input);
            self
        }
        /// If you enable this filter, the results are the following:
        /// - If the source content is noisy (it contains excessive digital artifacts), the filter cleans up the source.
        /// - If the source content is already clean, the filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
        pub fn set_post_filter_sharpening(
            mut self,
            input: std::option::Option<crate::model::TemporalFilterPostFilterSharpening>,
        ) -> Self {
            self.post_filter_sharpening = input;
            self
        }
        /// Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good information, resulting in an image that is overly soft.
        pub fn strength(mut self, input: crate::model::TemporalFilterStrength) -> Self {
            self.strength = Some(input);
            self
        }
        /// Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good information, resulting in an image that is overly soft.
        pub fn set_strength(
            mut self,
            input: std::option::Option<crate::model::TemporalFilterStrength>,
        ) -> Self {
            self.strength = input;
            self
        }
        /// Consumes the builder and constructs a [`TemporalFilterSettings`](crate::model::TemporalFilterSettings)
        pub fn build(self) -> crate::model::TemporalFilterSettings {
            crate::model::TemporalFilterSettings {
                post_filter_sharpening: self.post_filter_sharpening,
                strength: self.strength,
            }
        }
    }
}
impl TemporalFilterSettings {
    /// Creates a new builder-style object to manufacture [`TemporalFilterSettings`](crate::model::TemporalFilterSettings)
    pub fn builder() -> crate::model::temporal_filter_settings::Builder {
        crate::model::temporal_filter_settings::Builder::default()
    }
}

/// Temporal Filter Strength
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemporalFilterStrength {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Strength1,
    #[allow(missing_docs)] // documentation missing in model
    Strength10,
    #[allow(missing_docs)] // documentation missing in model
    Strength11,
    #[allow(missing_docs)] // documentation missing in model
    Strength12,
    #[allow(missing_docs)] // documentation missing in model
    Strength13,
    #[allow(missing_docs)] // documentation missing in model
    Strength14,
    #[allow(missing_docs)] // documentation missing in model
    Strength15,
    #[allow(missing_docs)] // documentation missing in model
    Strength16,
    #[allow(missing_docs)] // documentation missing in model
    Strength2,
    #[allow(missing_docs)] // documentation missing in model
    Strength3,
    #[allow(missing_docs)] // documentation missing in model
    Strength4,
    #[allow(missing_docs)] // documentation missing in model
    Strength5,
    #[allow(missing_docs)] // documentation missing in model
    Strength6,
    #[allow(missing_docs)] // documentation missing in model
    Strength7,
    #[allow(missing_docs)] // documentation missing in model
    Strength8,
    #[allow(missing_docs)] // documentation missing in model
    Strength9,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemporalFilterStrength {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => TemporalFilterStrength::Auto,
            "STRENGTH_1" => TemporalFilterStrength::Strength1,
            "STRENGTH_10" => TemporalFilterStrength::Strength10,
            "STRENGTH_11" => TemporalFilterStrength::Strength11,
            "STRENGTH_12" => TemporalFilterStrength::Strength12,
            "STRENGTH_13" => TemporalFilterStrength::Strength13,
            "STRENGTH_14" => TemporalFilterStrength::Strength14,
            "STRENGTH_15" => TemporalFilterStrength::Strength15,
            "STRENGTH_16" => TemporalFilterStrength::Strength16,
            "STRENGTH_2" => TemporalFilterStrength::Strength2,
            "STRENGTH_3" => TemporalFilterStrength::Strength3,
            "STRENGTH_4" => TemporalFilterStrength::Strength4,
            "STRENGTH_5" => TemporalFilterStrength::Strength5,
            "STRENGTH_6" => TemporalFilterStrength::Strength6,
            "STRENGTH_7" => TemporalFilterStrength::Strength7,
            "STRENGTH_8" => TemporalFilterStrength::Strength8,
            "STRENGTH_9" => TemporalFilterStrength::Strength9,
            other => TemporalFilterStrength::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemporalFilterStrength {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemporalFilterStrength::from(s))
    }
}
impl TemporalFilterStrength {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemporalFilterStrength::Auto => "AUTO",
            TemporalFilterStrength::Strength1 => "STRENGTH_1",
            TemporalFilterStrength::Strength10 => "STRENGTH_10",
            TemporalFilterStrength::Strength11 => "STRENGTH_11",
            TemporalFilterStrength::Strength12 => "STRENGTH_12",
            TemporalFilterStrength::Strength13 => "STRENGTH_13",
            TemporalFilterStrength::Strength14 => "STRENGTH_14",
            TemporalFilterStrength::Strength15 => "STRENGTH_15",
            TemporalFilterStrength::Strength16 => "STRENGTH_16",
            TemporalFilterStrength::Strength2 => "STRENGTH_2",
            TemporalFilterStrength::Strength3 => "STRENGTH_3",
            TemporalFilterStrength::Strength4 => "STRENGTH_4",
            TemporalFilterStrength::Strength5 => "STRENGTH_5",
            TemporalFilterStrength::Strength6 => "STRENGTH_6",
            TemporalFilterStrength::Strength7 => "STRENGTH_7",
            TemporalFilterStrength::Strength8 => "STRENGTH_8",
            TemporalFilterStrength::Strength9 => "STRENGTH_9",
            TemporalFilterStrength::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTO",
            "STRENGTH_1",
            "STRENGTH_10",
            "STRENGTH_11",
            "STRENGTH_12",
            "STRENGTH_13",
            "STRENGTH_14",
            "STRENGTH_15",
            "STRENGTH_16",
            "STRENGTH_2",
            "STRENGTH_3",
            "STRENGTH_4",
            "STRENGTH_5",
            "STRENGTH_6",
            "STRENGTH_7",
            "STRENGTH_8",
            "STRENGTH_9",
        ]
    }
}
impl AsRef<str> for TemporalFilterStrength {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Temporal Filter Post Filter Sharpening
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TemporalFilterPostFilterSharpening {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TemporalFilterPostFilterSharpening {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => TemporalFilterPostFilterSharpening::Auto,
            "DISABLED" => TemporalFilterPostFilterSharpening::Disabled,
            "ENABLED" => TemporalFilterPostFilterSharpening::Enabled,
            other => TemporalFilterPostFilterSharpening::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TemporalFilterPostFilterSharpening {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TemporalFilterPostFilterSharpening::from(s))
    }
}
impl TemporalFilterPostFilterSharpening {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TemporalFilterPostFilterSharpening::Auto => "AUTO",
            TemporalFilterPostFilterSharpening::Disabled => "DISABLED",
            TemporalFilterPostFilterSharpening::Enabled => "ENABLED",
            TemporalFilterPostFilterSharpening::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for TemporalFilterPostFilterSharpening {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Display Ratio
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2DisplayRatio {
    #[allow(missing_docs)] // documentation missing in model
    Displayratio16X9,
    #[allow(missing_docs)] // documentation missing in model
    Displayratio4X3,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2DisplayRatio {
    fn from(s: &str) -> Self {
        match s {
            "DISPLAYRATIO16X9" => Mpeg2DisplayRatio::Displayratio16X9,
            "DISPLAYRATIO4X3" => Mpeg2DisplayRatio::Displayratio4X3,
            other => Mpeg2DisplayRatio::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2DisplayRatio {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2DisplayRatio::from(s))
    }
}
impl Mpeg2DisplayRatio {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2DisplayRatio::Displayratio16X9 => "DISPLAYRATIO16X9",
            Mpeg2DisplayRatio::Displayratio4X3 => "DISPLAYRATIO4X3",
            Mpeg2DisplayRatio::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISPLAYRATIO16X9", "DISPLAYRATIO4X3"]
    }
}
impl AsRef<str> for Mpeg2DisplayRatio {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Color Space
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2ColorSpace {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2ColorSpace {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => Mpeg2ColorSpace::Auto,
            "PASSTHROUGH" => Mpeg2ColorSpace::Passthrough,
            other => Mpeg2ColorSpace::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2ColorSpace {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2ColorSpace::from(s))
    }
}
impl Mpeg2ColorSpace {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2ColorSpace::Auto => "AUTO",
            Mpeg2ColorSpace::Passthrough => "PASSTHROUGH",
            Mpeg2ColorSpace::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "PASSTHROUGH"]
    }
}
impl AsRef<str> for Mpeg2ColorSpace {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Color Metadata
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2ColorMetadata {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2ColorMetadata {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => Mpeg2ColorMetadata::Ignore,
            "INSERT" => Mpeg2ColorMetadata::Insert,
            other => Mpeg2ColorMetadata::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2ColorMetadata {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2ColorMetadata::from(s))
    }
}
impl Mpeg2ColorMetadata {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2ColorMetadata::Ignore => "IGNORE",
            Mpeg2ColorMetadata::Insert => "INSERT",
            Mpeg2ColorMetadata::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "INSERT"]
    }
}
impl AsRef<str> for Mpeg2ColorMetadata {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Afd Signaling
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AfdSignaling {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Fixed,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AfdSignaling {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => AfdSignaling::Auto,
            "FIXED" => AfdSignaling::Fixed,
            "NONE" => AfdSignaling::None,
            other => AfdSignaling::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AfdSignaling {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AfdSignaling::from(s))
    }
}
impl AfdSignaling {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AfdSignaling::Auto => "AUTO",
            AfdSignaling::Fixed => "FIXED",
            AfdSignaling::None => "NONE",
            AfdSignaling::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "FIXED", "NONE"]
    }
}
impl AsRef<str> for AfdSignaling {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Mpeg2 Adaptive Quantization
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2AdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2AdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => Mpeg2AdaptiveQuantization::Auto,
            "HIGH" => Mpeg2AdaptiveQuantization::High,
            "LOW" => Mpeg2AdaptiveQuantization::Low,
            "MEDIUM" => Mpeg2AdaptiveQuantization::Medium,
            "OFF" => Mpeg2AdaptiveQuantization::Off,
            other => Mpeg2AdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2AdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2AdaptiveQuantization::from(s))
    }
}
impl Mpeg2AdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2AdaptiveQuantization::Auto => "AUTO",
            Mpeg2AdaptiveQuantization::High => "HIGH",
            Mpeg2AdaptiveQuantization::Low => "LOW",
            Mpeg2AdaptiveQuantization::Medium => "MEDIUM",
            Mpeg2AdaptiveQuantization::Off => "OFF",
            Mpeg2AdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HIGH", "LOW", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for Mpeg2AdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H265Settings {
    /// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
    pub adaptive_quantization: std::option::Option<crate::model::H265AdaptiveQuantization>,
    /// Indicates that AFD values will be written into the output stream.  If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
    pub afd_signaling: std::option::Option<crate::model::AfdSignaling>,
    /// Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility with non-HDR decoders and displays.
    pub alternative_transfer_function:
        std::option::Option<crate::model::H265AlternativeTransferFunction>,
    /// Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
    pub bitrate: i32,
    /// Size of buffer (HRD buffer model) in bits.
    pub buf_size: i32,
    /// Includes colorspace metadata in the output.
    pub color_metadata: std::option::Option<crate::model::H265ColorMetadata>,
    /// Color Space settings
    pub color_space_settings: std::option::Option<crate::model::H265ColorSpaceSettings>,
    /// Optional filters that you can apply to an encode.
    pub filter_settings: std::option::Option<crate::model::H265FilterSettings>,
    /// Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
    pub fixed_afd: std::option::Option<crate::model::FixedAfd>,
    /// If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
    pub flicker_aq: std::option::Option<crate::model::H265FlickerAq>,
    /// Framerate denominator.
    pub framerate_denominator: i32,
    /// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
    pub framerate_numerator: i32,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
    /// If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
    /// If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
    pub gop_size: f64,
    /// Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
    pub gop_size_units: std::option::Option<crate::model::H265GopSizeUnits>,
    /// H.265 Level.
    pub level: std::option::Option<crate::model::H265Level>,
    /// Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
    pub look_ahead_rate_control: std::option::Option<crate::model::H265LookAheadRateControl>,
    /// For QVBR: See the tooltip for Quality level
    pub max_bitrate: i32,
    /// Only meaningful if sceneChangeDetect is set to enabled.  Defaults to 5 if multiplex rate control is used.  Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub min_i_interval: i32,
    /// Pixel Aspect Ratio denominator.
    pub par_denominator: i32,
    /// Pixel Aspect Ratio numerator.
    pub par_numerator: i32,
    /// H.265 Profile.
    pub profile: std::option::Option<crate::model::H265Profile>,
    /// Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are:
    /// - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
    /// - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
    /// - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
    pub qvbr_quality_level: i32,
    /// Rate control mode.
    ///
    /// QVBR: Quality will match the specified quality level except when it is constrained by the
    /// maximum bitrate.  Recommended if you or your viewers pay for bandwidth.
    ///
    /// CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
    /// your assets to devices that cannot handle variable bitrates.
    ///
    /// Multiplex: This rate control mode is only supported (and is required) when the video is being
    /// delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
    /// by the properties within the Multiplex Program.
    pub rate_control_mode: std::option::Option<crate::model::H265RateControlMode>,
    /// Sets the scan type of the output to progressive or top-field-first interlaced.
    pub scan_type: std::option::Option<crate::model::H265ScanType>,
    /// Scene change detection.
    pub scene_change_detect: std::option::Option<crate::model::H265SceneChangeDetect>,
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    /// This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
    pub slices: i32,
    /// H.265 Tier.
    pub tier: std::option::Option<crate::model::H265Tier>,
    /// Determines how timecodes should be inserted into the video elementary stream.
    /// - 'disabled': Do not include timecodes
    /// - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
    pub timecode_insertion: std::option::Option<crate::model::H265TimecodeInsertionBehavior>,
}
impl std::fmt::Debug for H265Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H265Settings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field("afd_signaling", &self.afd_signaling);
        formatter.field(
            "alternative_transfer_function",
            &self.alternative_transfer_function,
        );
        formatter.field("bitrate", &self.bitrate);
        formatter.field("buf_size", &self.buf_size);
        formatter.field("color_metadata", &self.color_metadata);
        formatter.field("color_space_settings", &self.color_space_settings);
        formatter.field("filter_settings", &self.filter_settings);
        formatter.field("fixed_afd", &self.fixed_afd);
        formatter.field("flicker_aq", &self.flicker_aq);
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("gop_size_units", &self.gop_size_units);
        formatter.field("level", &self.level);
        formatter.field("look_ahead_rate_control", &self.look_ahead_rate_control);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("min_i_interval", &self.min_i_interval);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("profile", &self.profile);
        formatter.field("qvbr_quality_level", &self.qvbr_quality_level);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("scene_change_detect", &self.scene_change_detect);
        formatter.field("slices", &self.slices);
        formatter.field("tier", &self.tier);
        formatter.field("timecode_insertion", &self.timecode_insertion);
        formatter.finish()
    }
}
/// See [`H265Settings`](crate::model::H265Settings)
pub mod h265_settings {
    /// A builder for [`H265Settings`](crate::model::H265Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::H265AdaptiveQuantization>,
        pub(crate) afd_signaling: std::option::Option<crate::model::AfdSignaling>,
        pub(crate) alternative_transfer_function:
            std::option::Option<crate::model::H265AlternativeTransferFunction>,
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) buf_size: std::option::Option<i32>,
        pub(crate) color_metadata: std::option::Option<crate::model::H265ColorMetadata>,
        pub(crate) color_space_settings: std::option::Option<crate::model::H265ColorSpaceSettings>,
        pub(crate) filter_settings: std::option::Option<crate::model::H265FilterSettings>,
        pub(crate) fixed_afd: std::option::Option<crate::model::FixedAfd>,
        pub(crate) flicker_aq: std::option::Option<crate::model::H265FlickerAq>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) gop_size_units: std::option::Option<crate::model::H265GopSizeUnits>,
        pub(crate) level: std::option::Option<crate::model::H265Level>,
        pub(crate) look_ahead_rate_control:
            std::option::Option<crate::model::H265LookAheadRateControl>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) min_i_interval: std::option::Option<i32>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) profile: std::option::Option<crate::model::H265Profile>,
        pub(crate) qvbr_quality_level: std::option::Option<i32>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::H265RateControlMode>,
        pub(crate) scan_type: std::option::Option<crate::model::H265ScanType>,
        pub(crate) scene_change_detect: std::option::Option<crate::model::H265SceneChangeDetect>,
        pub(crate) slices: std::option::Option<i32>,
        pub(crate) tier: std::option::Option<crate::model::H265Tier>,
        pub(crate) timecode_insertion:
            std::option::Option<crate::model::H265TimecodeInsertionBehavior>,
    }
    impl Builder {
        /// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::H265AdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual quality.
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H265AdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Indicates that AFD values will be written into the output stream.  If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
        pub fn afd_signaling(mut self, input: crate::model::AfdSignaling) -> Self {
            self.afd_signaling = Some(input);
            self
        }
        /// Indicates that AFD values will be written into the output stream.  If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
        pub fn set_afd_signaling(
            mut self,
            input: std::option::Option<crate::model::AfdSignaling>,
        ) -> Self {
            self.afd_signaling = input;
            self
        }
        /// Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility with non-HDR decoders and displays.
        pub fn alternative_transfer_function(
            mut self,
            input: crate::model::H265AlternativeTransferFunction,
        ) -> Self {
            self.alternative_transfer_function = Some(input);
            self
        }
        /// Whether or not EML should insert an Alternative Transfer Function SEI message to support backwards compatibility with non-HDR decoders and displays.
        pub fn set_alternative_transfer_function(
            mut self,
            input: std::option::Option<crate::model::H265AlternativeTransferFunction>,
        ) -> Self {
            self.alternative_transfer_function = input;
            self
        }
        /// Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// Size of buffer (HRD buffer model) in bits.
        pub fn buf_size(mut self, input: i32) -> Self {
            self.buf_size = Some(input);
            self
        }
        /// Size of buffer (HRD buffer model) in bits.
        pub fn set_buf_size(mut self, input: std::option::Option<i32>) -> Self {
            self.buf_size = input;
            self
        }
        /// Includes colorspace metadata in the output.
        pub fn color_metadata(mut self, input: crate::model::H265ColorMetadata) -> Self {
            self.color_metadata = Some(input);
            self
        }
        /// Includes colorspace metadata in the output.
        pub fn set_color_metadata(
            mut self,
            input: std::option::Option<crate::model::H265ColorMetadata>,
        ) -> Self {
            self.color_metadata = input;
            self
        }
        /// Color Space settings
        pub fn color_space_settings(mut self, input: crate::model::H265ColorSpaceSettings) -> Self {
            self.color_space_settings = Some(input);
            self
        }
        /// Color Space settings
        pub fn set_color_space_settings(
            mut self,
            input: std::option::Option<crate::model::H265ColorSpaceSettings>,
        ) -> Self {
            self.color_space_settings = input;
            self
        }
        /// Optional filters that you can apply to an encode.
        pub fn filter_settings(mut self, input: crate::model::H265FilterSettings) -> Self {
            self.filter_settings = Some(input);
            self
        }
        /// Optional filters that you can apply to an encode.
        pub fn set_filter_settings(
            mut self,
            input: std::option::Option<crate::model::H265FilterSettings>,
        ) -> Self {
            self.filter_settings = input;
            self
        }
        /// Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
        pub fn fixed_afd(mut self, input: crate::model::FixedAfd) -> Self {
            self.fixed_afd = Some(input);
            self
        }
        /// Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
        pub fn set_fixed_afd(mut self, input: std::option::Option<crate::model::FixedAfd>) -> Self {
            self.fixed_afd = input;
            self
        }
        /// If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
        pub fn flicker_aq(mut self, input: crate::model::H265FlickerAq) -> Self {
            self.flicker_aq = Some(input);
            self
        }
        /// If set to enabled, adjust quantization within each frame to reduce flicker or 'pop' on I-frames.
        pub fn set_flicker_aq(
            mut self,
            input: std::option::Option<crate::model::H265FlickerAq>,
        ) -> Self {
            self.flicker_aq = input;
            self
        }
        /// Framerate denominator.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// Framerate denominator.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
        /// If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
        /// If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
        /// If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
        /// If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
        pub fn gop_size_units(mut self, input: crate::model::H265GopSizeUnits) -> Self {
            self.gop_size_units = Some(input);
            self
        }
        /// Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
        pub fn set_gop_size_units(
            mut self,
            input: std::option::Option<crate::model::H265GopSizeUnits>,
        ) -> Self {
            self.gop_size_units = input;
            self
        }
        /// H.265 Level.
        pub fn level(mut self, input: crate::model::H265Level) -> Self {
            self.level = Some(input);
            self
        }
        /// H.265 Level.
        pub fn set_level(mut self, input: std::option::Option<crate::model::H265Level>) -> Self {
            self.level = input;
            self
        }
        /// Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
        pub fn look_ahead_rate_control(
            mut self,
            input: crate::model::H265LookAheadRateControl,
        ) -> Self {
            self.look_ahead_rate_control = Some(input);
            self
        }
        /// Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
        pub fn set_look_ahead_rate_control(
            mut self,
            input: std::option::Option<crate::model::H265LookAheadRateControl>,
        ) -> Self {
            self.look_ahead_rate_control = input;
            self
        }
        /// For QVBR: See the tooltip for Quality level
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// For QVBR: See the tooltip for Quality level
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Only meaningful if sceneChangeDetect is set to enabled.  Defaults to 5 if multiplex rate control is used.  Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn min_i_interval(mut self, input: i32) -> Self {
            self.min_i_interval = Some(input);
            self
        }
        /// Only meaningful if sceneChangeDetect is set to enabled.  Defaults to 5 if multiplex rate control is used.  Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn set_min_i_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.min_i_interval = input;
            self
        }
        /// Pixel Aspect Ratio denominator.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Pixel Aspect Ratio denominator.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Pixel Aspect Ratio numerator.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Pixel Aspect Ratio numerator.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// H.265 Profile.
        pub fn profile(mut self, input: crate::model::H265Profile) -> Self {
            self.profile = Some(input);
            self
        }
        /// H.265 Profile.
        pub fn set_profile(
            mut self,
            input: std::option::Option<crate::model::H265Profile>,
        ) -> Self {
            self.profile = input;
            self
        }
        /// Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are:
        /// - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
        /// - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
        /// - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
        pub fn qvbr_quality_level(mut self, input: i32) -> Self {
            self.qvbr_quality_level = Some(input);
            self
        }
        /// Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. Set values for the QVBR quality level field and Max bitrate field that suit your most important viewing devices. Recommended values are:
        /// - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
        /// - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
        /// - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
        pub fn set_qvbr_quality_level(mut self, input: std::option::Option<i32>) -> Self {
            self.qvbr_quality_level = input;
            self
        }
        /// Rate control mode.
        ///
        /// QVBR: Quality will match the specified quality level except when it is constrained by the
        /// maximum bitrate.  Recommended if you or your viewers pay for bandwidth.
        ///
        /// CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
        /// your assets to devices that cannot handle variable bitrates.
        ///
        /// Multiplex: This rate control mode is only supported (and is required) when the video is being
        /// delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
        /// by the properties within the Multiplex Program.
        pub fn rate_control_mode(mut self, input: crate::model::H265RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// Rate control mode.
        ///
        /// QVBR: Quality will match the specified quality level except when it is constrained by the
        /// maximum bitrate.  Recommended if you or your viewers pay for bandwidth.
        ///
        /// CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
        /// your assets to devices that cannot handle variable bitrates.
        ///
        /// Multiplex: This rate control mode is only supported (and is required) when the video is being
        /// delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
        /// by the properties within the Multiplex Program.
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::H265RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Sets the scan type of the output to progressive or top-field-first interlaced.
        pub fn scan_type(mut self, input: crate::model::H265ScanType) -> Self {
            self.scan_type = Some(input);
            self
        }
        /// Sets the scan type of the output to progressive or top-field-first interlaced.
        pub fn set_scan_type(
            mut self,
            input: std::option::Option<crate::model::H265ScanType>,
        ) -> Self {
            self.scan_type = input;
            self
        }
        /// Scene change detection.
        pub fn scene_change_detect(mut self, input: crate::model::H265SceneChangeDetect) -> Self {
            self.scene_change_detect = Some(input);
            self
        }
        /// Scene change detection.
        pub fn set_scene_change_detect(
            mut self,
            input: std::option::Option<crate::model::H265SceneChangeDetect>,
        ) -> Self {
            self.scene_change_detect = input;
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        /// This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
        pub fn slices(mut self, input: i32) -> Self {
            self.slices = Some(input);
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        /// This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
        pub fn set_slices(mut self, input: std::option::Option<i32>) -> Self {
            self.slices = input;
            self
        }
        /// H.265 Tier.
        pub fn tier(mut self, input: crate::model::H265Tier) -> Self {
            self.tier = Some(input);
            self
        }
        /// H.265 Tier.
        pub fn set_tier(mut self, input: std::option::Option<crate::model::H265Tier>) -> Self {
            self.tier = input;
            self
        }
        /// Determines how timecodes should be inserted into the video elementary stream.
        /// - 'disabled': Do not include timecodes
        /// - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
        pub fn timecode_insertion(
            mut self,
            input: crate::model::H265TimecodeInsertionBehavior,
        ) -> Self {
            self.timecode_insertion = Some(input);
            self
        }
        /// Determines how timecodes should be inserted into the video elementary stream.
        /// - 'disabled': Do not include timecodes
        /// - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
        pub fn set_timecode_insertion(
            mut self,
            input: std::option::Option<crate::model::H265TimecodeInsertionBehavior>,
        ) -> Self {
            self.timecode_insertion = input;
            self
        }
        /// Consumes the builder and constructs a [`H265Settings`](crate::model::H265Settings)
        pub fn build(self) -> crate::model::H265Settings {
            crate::model::H265Settings {
                adaptive_quantization: self.adaptive_quantization,
                afd_signaling: self.afd_signaling,
                alternative_transfer_function: self.alternative_transfer_function,
                bitrate: self.bitrate.unwrap_or_default(),
                buf_size: self.buf_size.unwrap_or_default(),
                color_metadata: self.color_metadata,
                color_space_settings: self.color_space_settings,
                filter_settings: self.filter_settings,
                fixed_afd: self.fixed_afd,
                flicker_aq: self.flicker_aq,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                gop_size_units: self.gop_size_units,
                level: self.level,
                look_ahead_rate_control: self.look_ahead_rate_control,
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                min_i_interval: self.min_i_interval.unwrap_or_default(),
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                profile: self.profile,
                qvbr_quality_level: self.qvbr_quality_level.unwrap_or_default(),
                rate_control_mode: self.rate_control_mode,
                scan_type: self.scan_type,
                scene_change_detect: self.scene_change_detect,
                slices: self.slices.unwrap_or_default(),
                tier: self.tier,
                timecode_insertion: self.timecode_insertion,
            }
        }
    }
}
impl H265Settings {
    /// Creates a new builder-style object to manufacture [`H265Settings`](crate::model::H265Settings)
    pub fn builder() -> crate::model::h265_settings::Builder {
        crate::model::h265_settings::Builder::default()
    }
}

/// H265 Timecode Insertion Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265TimecodeInsertionBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    PicTimingSei,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265TimecodeInsertionBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265TimecodeInsertionBehavior::Disabled,
            "PIC_TIMING_SEI" => H265TimecodeInsertionBehavior::PicTimingSei,
            other => H265TimecodeInsertionBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265TimecodeInsertionBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265TimecodeInsertionBehavior::from(s))
    }
}
impl H265TimecodeInsertionBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265TimecodeInsertionBehavior::Disabled => "DISABLED",
            H265TimecodeInsertionBehavior::PicTimingSei => "PIC_TIMING_SEI",
            H265TimecodeInsertionBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "PIC_TIMING_SEI"]
    }
}
impl AsRef<str> for H265TimecodeInsertionBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Tier
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265Tier {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Main,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265Tier {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => H265Tier::High,
            "MAIN" => H265Tier::Main,
            other => H265Tier::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265Tier {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265Tier::from(s))
    }
}
impl H265Tier {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265Tier::High => "HIGH",
            H265Tier::Main => "MAIN",
            H265Tier::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "MAIN"]
    }
}
impl AsRef<str> for H265Tier {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Scene Change Detect
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265SceneChangeDetect {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265SceneChangeDetect {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265SceneChangeDetect::Disabled,
            "ENABLED" => H265SceneChangeDetect::Enabled,
            other => H265SceneChangeDetect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265SceneChangeDetect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265SceneChangeDetect::from(s))
    }
}
impl H265SceneChangeDetect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265SceneChangeDetect::Disabled => "DISABLED",
            H265SceneChangeDetect::Enabled => "ENABLED",
            H265SceneChangeDetect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265SceneChangeDetect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Scan Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265ScanType {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265ScanType {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => H265ScanType::Interlaced,
            "PROGRESSIVE" => H265ScanType::Progressive,
            other => H265ScanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265ScanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265ScanType::from(s))
    }
}
impl H265ScanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265ScanType::Interlaced => "INTERLACED",
            H265ScanType::Progressive => "PROGRESSIVE",
            H265ScanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "PROGRESSIVE"]
    }
}
impl AsRef<str> for H265ScanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Rate Control Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265RateControlMode {
    #[allow(missing_docs)] // documentation missing in model
    Cbr,
    #[allow(missing_docs)] // documentation missing in model
    Multiplex,
    #[allow(missing_docs)] // documentation missing in model
    Qvbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265RateControlMode {
    fn from(s: &str) -> Self {
        match s {
            "CBR" => H265RateControlMode::Cbr,
            "MULTIPLEX" => H265RateControlMode::Multiplex,
            "QVBR" => H265RateControlMode::Qvbr,
            other => H265RateControlMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265RateControlMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265RateControlMode::from(s))
    }
}
impl H265RateControlMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265RateControlMode::Cbr => "CBR",
            H265RateControlMode::Multiplex => "MULTIPLEX",
            H265RateControlMode::Qvbr => "QVBR",
            H265RateControlMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CBR", "MULTIPLEX", "QVBR"]
    }
}
impl AsRef<str> for H265RateControlMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Profile
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265Profile {
    #[allow(missing_docs)] // documentation missing in model
    Main,
    #[allow(missing_docs)] // documentation missing in model
    Main10Bit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265Profile {
    fn from(s: &str) -> Self {
        match s {
            "MAIN" => H265Profile::Main,
            "MAIN_10BIT" => H265Profile::Main10Bit,
            other => H265Profile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265Profile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265Profile::from(s))
    }
}
impl H265Profile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265Profile::Main => "MAIN",
            H265Profile::Main10Bit => "MAIN_10BIT",
            H265Profile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAIN", "MAIN_10BIT"]
    }
}
impl AsRef<str> for H265Profile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Look Ahead Rate Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265LookAheadRateControl {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265LookAheadRateControl {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => H265LookAheadRateControl::High,
            "LOW" => H265LookAheadRateControl::Low,
            "MEDIUM" => H265LookAheadRateControl::Medium,
            other => H265LookAheadRateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265LookAheadRateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265LookAheadRateControl::from(s))
    }
}
impl H265LookAheadRateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265LookAheadRateControl::High => "HIGH",
            H265LookAheadRateControl::Low => "LOW",
            H265LookAheadRateControl::Medium => "MEDIUM",
            H265LookAheadRateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for H265LookAheadRateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Level
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265Level {
    #[allow(missing_docs)] // documentation missing in model
    H265Level1,
    #[allow(missing_docs)] // documentation missing in model
    H265Level2,
    #[allow(missing_docs)] // documentation missing in model
    H265Level21,
    #[allow(missing_docs)] // documentation missing in model
    H265Level3,
    #[allow(missing_docs)] // documentation missing in model
    H265Level31,
    #[allow(missing_docs)] // documentation missing in model
    H265Level4,
    #[allow(missing_docs)] // documentation missing in model
    H265Level41,
    #[allow(missing_docs)] // documentation missing in model
    H265Level5,
    #[allow(missing_docs)] // documentation missing in model
    H265Level51,
    #[allow(missing_docs)] // documentation missing in model
    H265Level52,
    #[allow(missing_docs)] // documentation missing in model
    H265Level6,
    #[allow(missing_docs)] // documentation missing in model
    H265Level61,
    #[allow(missing_docs)] // documentation missing in model
    H265Level62,
    #[allow(missing_docs)] // documentation missing in model
    H265LevelAuto,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265Level {
    fn from(s: &str) -> Self {
        match s {
            "H265_LEVEL_1" => H265Level::H265Level1,
            "H265_LEVEL_2" => H265Level::H265Level2,
            "H265_LEVEL_2_1" => H265Level::H265Level21,
            "H265_LEVEL_3" => H265Level::H265Level3,
            "H265_LEVEL_3_1" => H265Level::H265Level31,
            "H265_LEVEL_4" => H265Level::H265Level4,
            "H265_LEVEL_4_1" => H265Level::H265Level41,
            "H265_LEVEL_5" => H265Level::H265Level5,
            "H265_LEVEL_5_1" => H265Level::H265Level51,
            "H265_LEVEL_5_2" => H265Level::H265Level52,
            "H265_LEVEL_6" => H265Level::H265Level6,
            "H265_LEVEL_6_1" => H265Level::H265Level61,
            "H265_LEVEL_6_2" => H265Level::H265Level62,
            "H265_LEVEL_AUTO" => H265Level::H265LevelAuto,
            other => H265Level::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265Level {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265Level::from(s))
    }
}
impl H265Level {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265Level::H265Level1 => "H265_LEVEL_1",
            H265Level::H265Level2 => "H265_LEVEL_2",
            H265Level::H265Level21 => "H265_LEVEL_2_1",
            H265Level::H265Level3 => "H265_LEVEL_3",
            H265Level::H265Level31 => "H265_LEVEL_3_1",
            H265Level::H265Level4 => "H265_LEVEL_4",
            H265Level::H265Level41 => "H265_LEVEL_4_1",
            H265Level::H265Level5 => "H265_LEVEL_5",
            H265Level::H265Level51 => "H265_LEVEL_5_1",
            H265Level::H265Level52 => "H265_LEVEL_5_2",
            H265Level::H265Level6 => "H265_LEVEL_6",
            H265Level::H265Level61 => "H265_LEVEL_6_1",
            H265Level::H265Level62 => "H265_LEVEL_6_2",
            H265Level::H265LevelAuto => "H265_LEVEL_AUTO",
            H265Level::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "H265_LEVEL_1",
            "H265_LEVEL_2",
            "H265_LEVEL_2_1",
            "H265_LEVEL_3",
            "H265_LEVEL_3_1",
            "H265_LEVEL_4",
            "H265_LEVEL_4_1",
            "H265_LEVEL_5",
            "H265_LEVEL_5_1",
            "H265_LEVEL_5_2",
            "H265_LEVEL_6",
            "H265_LEVEL_6_1",
            "H265_LEVEL_6_2",
            "H265_LEVEL_AUTO",
        ]
    }
}
impl AsRef<str> for H265Level {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Gop Size Units
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265GopSizeUnits {
    #[allow(missing_docs)] // documentation missing in model
    Frames,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265GopSizeUnits {
    fn from(s: &str) -> Self {
        match s {
            "FRAMES" => H265GopSizeUnits::Frames,
            "SECONDS" => H265GopSizeUnits::Seconds,
            other => H265GopSizeUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265GopSizeUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265GopSizeUnits::from(s))
    }
}
impl H265GopSizeUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265GopSizeUnits::Frames => "FRAMES",
            H265GopSizeUnits::Seconds => "SECONDS",
            H265GopSizeUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAMES", "SECONDS"]
    }
}
impl AsRef<str> for H265GopSizeUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Flicker Aq
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265FlickerAq {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265FlickerAq {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265FlickerAq::Disabled,
            "ENABLED" => H265FlickerAq::Enabled,
            other => H265FlickerAq::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265FlickerAq {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265FlickerAq::from(s))
    }
}
impl H265FlickerAq {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265FlickerAq::Disabled => "DISABLED",
            H265FlickerAq::Enabled => "ENABLED",
            H265FlickerAq::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265FlickerAq {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Filter Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H265FilterSettings {
    /// Temporal Filter Settings
    pub temporal_filter_settings: std::option::Option<crate::model::TemporalFilterSettings>,
}
impl std::fmt::Debug for H265FilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H265FilterSettings");
        formatter.field("temporal_filter_settings", &self.temporal_filter_settings);
        formatter.finish()
    }
}
/// See [`H265FilterSettings`](crate::model::H265FilterSettings)
pub mod h265_filter_settings {
    /// A builder for [`H265FilterSettings`](crate::model::H265FilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) temporal_filter_settings:
            std::option::Option<crate::model::TemporalFilterSettings>,
    }
    impl Builder {
        /// Temporal Filter Settings
        pub fn temporal_filter_settings(
            mut self,
            input: crate::model::TemporalFilterSettings,
        ) -> Self {
            self.temporal_filter_settings = Some(input);
            self
        }
        /// Temporal Filter Settings
        pub fn set_temporal_filter_settings(
            mut self,
            input: std::option::Option<crate::model::TemporalFilterSettings>,
        ) -> Self {
            self.temporal_filter_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`H265FilterSettings`](crate::model::H265FilterSettings)
        pub fn build(self) -> crate::model::H265FilterSettings {
            crate::model::H265FilterSettings {
                temporal_filter_settings: self.temporal_filter_settings,
            }
        }
    }
}
impl H265FilterSettings {
    /// Creates a new builder-style object to manufacture [`H265FilterSettings`](crate::model::H265FilterSettings)
    pub fn builder() -> crate::model::h265_filter_settings::Builder {
        crate::model::h265_filter_settings::Builder::default()
    }
}

/// H265 Color Space Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H265ColorSpaceSettings {
    /// Passthrough applies no color space conversion to the output
    pub color_space_passthrough_settings:
        std::option::Option<crate::model::ColorSpacePassthroughSettings>,
    /// Hdr10 Settings
    pub hdr10_settings: std::option::Option<crate::model::Hdr10Settings>,
    /// Rec601 Settings
    pub rec601_settings: std::option::Option<crate::model::Rec601Settings>,
    /// Rec709 Settings
    pub rec709_settings: std::option::Option<crate::model::Rec709Settings>,
}
impl std::fmt::Debug for H265ColorSpaceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H265ColorSpaceSettings");
        formatter.field(
            "color_space_passthrough_settings",
            &self.color_space_passthrough_settings,
        );
        formatter.field("hdr10_settings", &self.hdr10_settings);
        formatter.field("rec601_settings", &self.rec601_settings);
        formatter.field("rec709_settings", &self.rec709_settings);
        formatter.finish()
    }
}
/// See [`H265ColorSpaceSettings`](crate::model::H265ColorSpaceSettings)
pub mod h265_color_space_settings {
    /// A builder for [`H265ColorSpaceSettings`](crate::model::H265ColorSpaceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) color_space_passthrough_settings:
            std::option::Option<crate::model::ColorSpacePassthroughSettings>,
        pub(crate) hdr10_settings: std::option::Option<crate::model::Hdr10Settings>,
        pub(crate) rec601_settings: std::option::Option<crate::model::Rec601Settings>,
        pub(crate) rec709_settings: std::option::Option<crate::model::Rec709Settings>,
    }
    impl Builder {
        /// Passthrough applies no color space conversion to the output
        pub fn color_space_passthrough_settings(
            mut self,
            input: crate::model::ColorSpacePassthroughSettings,
        ) -> Self {
            self.color_space_passthrough_settings = Some(input);
            self
        }
        /// Passthrough applies no color space conversion to the output
        pub fn set_color_space_passthrough_settings(
            mut self,
            input: std::option::Option<crate::model::ColorSpacePassthroughSettings>,
        ) -> Self {
            self.color_space_passthrough_settings = input;
            self
        }
        /// Hdr10 Settings
        pub fn hdr10_settings(mut self, input: crate::model::Hdr10Settings) -> Self {
            self.hdr10_settings = Some(input);
            self
        }
        /// Hdr10 Settings
        pub fn set_hdr10_settings(
            mut self,
            input: std::option::Option<crate::model::Hdr10Settings>,
        ) -> Self {
            self.hdr10_settings = input;
            self
        }
        /// Rec601 Settings
        pub fn rec601_settings(mut self, input: crate::model::Rec601Settings) -> Self {
            self.rec601_settings = Some(input);
            self
        }
        /// Rec601 Settings
        pub fn set_rec601_settings(
            mut self,
            input: std::option::Option<crate::model::Rec601Settings>,
        ) -> Self {
            self.rec601_settings = input;
            self
        }
        /// Rec709 Settings
        pub fn rec709_settings(mut self, input: crate::model::Rec709Settings) -> Self {
            self.rec709_settings = Some(input);
            self
        }
        /// Rec709 Settings
        pub fn set_rec709_settings(
            mut self,
            input: std::option::Option<crate::model::Rec709Settings>,
        ) -> Self {
            self.rec709_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`H265ColorSpaceSettings`](crate::model::H265ColorSpaceSettings)
        pub fn build(self) -> crate::model::H265ColorSpaceSettings {
            crate::model::H265ColorSpaceSettings {
                color_space_passthrough_settings: self.color_space_passthrough_settings,
                hdr10_settings: self.hdr10_settings,
                rec601_settings: self.rec601_settings,
                rec709_settings: self.rec709_settings,
            }
        }
    }
}
impl H265ColorSpaceSettings {
    /// Creates a new builder-style object to manufacture [`H265ColorSpaceSettings`](crate::model::H265ColorSpaceSettings)
    pub fn builder() -> crate::model::h265_color_space_settings::Builder {
        crate::model::h265_color_space_settings::Builder::default()
    }
}

/// Rec709 Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rec709Settings {}
impl std::fmt::Debug for Rec709Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rec709Settings");
        formatter.finish()
    }
}
/// See [`Rec709Settings`](crate::model::Rec709Settings)
pub mod rec709_settings {
    /// A builder for [`Rec709Settings`](crate::model::Rec709Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Rec709Settings`](crate::model::Rec709Settings)
        pub fn build(self) -> crate::model::Rec709Settings {
            crate::model::Rec709Settings {}
        }
    }
}
impl Rec709Settings {
    /// Creates a new builder-style object to manufacture [`Rec709Settings`](crate::model::Rec709Settings)
    pub fn builder() -> crate::model::rec709_settings::Builder {
        crate::model::rec709_settings::Builder::default()
    }
}

/// Rec601 Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rec601Settings {}
impl std::fmt::Debug for Rec601Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rec601Settings");
        formatter.finish()
    }
}
/// See [`Rec601Settings`](crate::model::Rec601Settings)
pub mod rec601_settings {
    /// A builder for [`Rec601Settings`](crate::model::Rec601Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`Rec601Settings`](crate::model::Rec601Settings)
        pub fn build(self) -> crate::model::Rec601Settings {
            crate::model::Rec601Settings {}
        }
    }
}
impl Rec601Settings {
    /// Creates a new builder-style object to manufacture [`Rec601Settings`](crate::model::Rec601Settings)
    pub fn builder() -> crate::model::rec601_settings::Builder {
        crate::model::rec601_settings::Builder::default()
    }
}

/// Passthrough applies no color space conversion to the output
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColorSpacePassthroughSettings {}
impl std::fmt::Debug for ColorSpacePassthroughSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColorSpacePassthroughSettings");
        formatter.finish()
    }
}
/// See [`ColorSpacePassthroughSettings`](crate::model::ColorSpacePassthroughSettings)
pub mod color_space_passthrough_settings {
    /// A builder for [`ColorSpacePassthroughSettings`](crate::model::ColorSpacePassthroughSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`ColorSpacePassthroughSettings`](crate::model::ColorSpacePassthroughSettings)
        pub fn build(self) -> crate::model::ColorSpacePassthroughSettings {
            crate::model::ColorSpacePassthroughSettings {}
        }
    }
}
impl ColorSpacePassthroughSettings {
    /// Creates a new builder-style object to manufacture [`ColorSpacePassthroughSettings`](crate::model::ColorSpacePassthroughSettings)
    pub fn builder() -> crate::model::color_space_passthrough_settings::Builder {
        crate::model::color_space_passthrough_settings::Builder::default()
    }
}

/// H265 Color Metadata
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265ColorMetadata {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265ColorMetadata {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => H265ColorMetadata::Ignore,
            "INSERT" => H265ColorMetadata::Insert,
            other => H265ColorMetadata::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265ColorMetadata {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265ColorMetadata::from(s))
    }
}
impl H265ColorMetadata {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265ColorMetadata::Ignore => "IGNORE",
            H265ColorMetadata::Insert => "INSERT",
            H265ColorMetadata::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "INSERT"]
    }
}
impl AsRef<str> for H265ColorMetadata {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Alternative Transfer Function
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265AlternativeTransferFunction {
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    #[allow(missing_docs)] // documentation missing in model
    Omit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265AlternativeTransferFunction {
    fn from(s: &str) -> Self {
        match s {
            "INSERT" => H265AlternativeTransferFunction::Insert,
            "OMIT" => H265AlternativeTransferFunction::Omit,
            other => H265AlternativeTransferFunction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265AlternativeTransferFunction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265AlternativeTransferFunction::from(s))
    }
}
impl H265AlternativeTransferFunction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265AlternativeTransferFunction::Insert => "INSERT",
            H265AlternativeTransferFunction::Omit => "OMIT",
            H265AlternativeTransferFunction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INSERT", "OMIT"]
    }
}
impl AsRef<str> for H265AlternativeTransferFunction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H265 Adaptive Quantization
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265AdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Higher,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Max,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265AdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => H265AdaptiveQuantization::Auto,
            "HIGH" => H265AdaptiveQuantization::High,
            "HIGHER" => H265AdaptiveQuantization::Higher,
            "LOW" => H265AdaptiveQuantization::Low,
            "MAX" => H265AdaptiveQuantization::Max,
            "MEDIUM" => H265AdaptiveQuantization::Medium,
            "OFF" => H265AdaptiveQuantization::Off,
            other => H265AdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265AdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265AdaptiveQuantization::from(s))
    }
}
impl H265AdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265AdaptiveQuantization::Auto => "AUTO",
            H265AdaptiveQuantization::High => "HIGH",
            H265AdaptiveQuantization::Higher => "HIGHER",
            H265AdaptiveQuantization::Low => "LOW",
            H265AdaptiveQuantization::Max => "MAX",
            H265AdaptiveQuantization::Medium => "MEDIUM",
            H265AdaptiveQuantization::Off => "OFF",
            H265AdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HIGH", "HIGHER", "LOW", "MAX", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for H265AdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H264Settings {
    /// Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
    pub adaptive_quantization: std::option::Option<crate::model::H264AdaptiveQuantization>,
    /// Indicates that AFD values will be written into the output stream.  If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
    pub afd_signaling: std::option::Option<crate::model::AfdSignaling>,
    /// Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
    pub bitrate: i32,
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub buf_fill_pct: i32,
    /// Size of buffer (HRD buffer model) in bits.
    pub buf_size: i32,
    /// Includes colorspace metadata in the output.
    pub color_metadata: std::option::Option<crate::model::H264ColorMetadata>,
    /// Color Space settings
    pub color_space_settings: std::option::Option<crate::model::H264ColorSpaceSettings>,
    /// Entropy encoding mode.  Use cabac (must be in Main or High profile) or cavlc.
    pub entropy_encoding: std::option::Option<crate::model::H264EntropyEncoding>,
    /// Optional filters that you can apply to an encode.
    pub filter_settings: std::option::Option<crate::model::H264FilterSettings>,
    /// Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
    pub fixed_afd: std::option::Option<crate::model::FixedAfd>,
    /// Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
    pub flicker_aq: std::option::Option<crate::model::H264FlickerAq>,
    /// This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
    /// enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
    /// disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
    pub force_field_pictures: std::option::Option<crate::model::H264ForceFieldPictures>,
    /// This field indicates how the output video frame rate is specified.  If "specified" is selected then the output video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is selected then the output video frame rate will be set equal to the input video frame rate of the first input.
    pub framerate_control: std::option::Option<crate::model::H264FramerateControl>,
    /// Framerate denominator.
    pub framerate_denominator: i32,
    /// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
    pub framerate_numerator: i32,
    /// Documentation update needed
    pub gop_b_reference: std::option::Option<crate::model::H264GopBReference>,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// Number of B-frames between reference frames.
    pub gop_num_b_frames: i32,
    /// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
    /// If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
    /// If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
    pub gop_size: f64,
    /// Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
    pub gop_size_units: std::option::Option<crate::model::H264GopSizeUnits>,
    /// H.264 Level.
    pub level: std::option::Option<crate::model::H264Level>,
    /// Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
    pub look_ahead_rate_control: std::option::Option<crate::model::H264LookAheadRateControl>,
    /// For QVBR: See the tooltip for Quality level
    ///
    /// For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
    pub max_bitrate: i32,
    /// Only meaningful if sceneChangeDetect is set to enabled.  Defaults to 5 if multiplex rate control is used.  Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub min_i_interval: i32,
    /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
    pub num_ref_frames: i32,
    /// This field indicates how the output pixel aspect ratio is specified.  If "specified" is selected then the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
    pub par_control: std::option::Option<crate::model::H264ParControl>,
    /// Pixel Aspect Ratio denominator.
    pub par_denominator: i32,
    /// Pixel Aspect Ratio numerator.
    pub par_numerator: i32,
    /// H.264 Profile.
    pub profile: std::option::Option<crate::model::H264Profile>,
    /// Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel).
    /// - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY.
    /// - STANDARD_QUALITY: Valid for any Rate control mode.
    pub quality_level: std::option::Option<crate::model::H264QualityLevel>,
    /// Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices. Recommended values are:
    /// - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
    /// - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
    /// - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
    /// To let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive user guide
    pub qvbr_quality_level: i32,
    /// Rate control mode.
    ///
    /// QVBR: Quality will match the specified quality level except when it is constrained by the
    /// maximum bitrate.  Recommended if you or your viewers pay for bandwidth.
    ///
    /// VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR
    /// if you want to maintain a specific average bitrate over the duration of the channel.
    ///
    /// CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
    /// your assets to devices that cannot handle variable bitrates.
    ///
    /// Multiplex: This rate control mode is only supported (and is required) when the video is being
    /// delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
    /// by the properties within the Multiplex Program.
    pub rate_control_mode: std::option::Option<crate::model::H264RateControlMode>,
    /// Sets the scan type of the output to progressive or top-field-first interlaced.
    pub scan_type: std::option::Option<crate::model::H264ScanType>,
    /// Scene change detection.
    ///
    /// - On: inserts I-frames when scene change is detected.
    /// - Off: does not force an I-frame when scene change is detected.
    pub scene_change_detect: std::option::Option<crate::model::H264SceneChangeDetect>,
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    /// This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
    pub slices: i32,
    /// Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.  If not set to zero, must be greater than 15.
    pub softness: i32,
    /// Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
    pub spatial_aq: std::option::Option<crate::model::H264SpatialAq>,
    /// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used for each sub-GOP to improve visual quality.
    pub subgop_length: std::option::Option<crate::model::H264SubGopLength>,
    /// Produces a bitstream compliant with SMPTE RP-2027.
    pub syntax: std::option::Option<crate::model::H264Syntax>,
    /// Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
    pub temporal_aq: std::option::Option<crate::model::H264TemporalAq>,
    /// Determines how timecodes should be inserted into the video elementary stream.
    /// - 'disabled': Do not include timecodes
    /// - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
    pub timecode_insertion: std::option::Option<crate::model::H264TimecodeInsertionBehavior>,
}
impl std::fmt::Debug for H264Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H264Settings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field("afd_signaling", &self.afd_signaling);
        formatter.field("bitrate", &self.bitrate);
        formatter.field("buf_fill_pct", &self.buf_fill_pct);
        formatter.field("buf_size", &self.buf_size);
        formatter.field("color_metadata", &self.color_metadata);
        formatter.field("color_space_settings", &self.color_space_settings);
        formatter.field("entropy_encoding", &self.entropy_encoding);
        formatter.field("filter_settings", &self.filter_settings);
        formatter.field("fixed_afd", &self.fixed_afd);
        formatter.field("flicker_aq", &self.flicker_aq);
        formatter.field("force_field_pictures", &self.force_field_pictures);
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_b_reference", &self.gop_b_reference);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("gop_num_b_frames", &self.gop_num_b_frames);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("gop_size_units", &self.gop_size_units);
        formatter.field("level", &self.level);
        formatter.field("look_ahead_rate_control", &self.look_ahead_rate_control);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("min_i_interval", &self.min_i_interval);
        formatter.field("num_ref_frames", &self.num_ref_frames);
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("profile", &self.profile);
        formatter.field("quality_level", &self.quality_level);
        formatter.field("qvbr_quality_level", &self.qvbr_quality_level);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.field("scan_type", &self.scan_type);
        formatter.field("scene_change_detect", &self.scene_change_detect);
        formatter.field("slices", &self.slices);
        formatter.field("softness", &self.softness);
        formatter.field("spatial_aq", &self.spatial_aq);
        formatter.field("subgop_length", &self.subgop_length);
        formatter.field("syntax", &self.syntax);
        formatter.field("temporal_aq", &self.temporal_aq);
        formatter.field("timecode_insertion", &self.timecode_insertion);
        formatter.finish()
    }
}
/// See [`H264Settings`](crate::model::H264Settings)
pub mod h264_settings {
    /// A builder for [`H264Settings`](crate::model::H264Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::H264AdaptiveQuantization>,
        pub(crate) afd_signaling: std::option::Option<crate::model::AfdSignaling>,
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) buf_fill_pct: std::option::Option<i32>,
        pub(crate) buf_size: std::option::Option<i32>,
        pub(crate) color_metadata: std::option::Option<crate::model::H264ColorMetadata>,
        pub(crate) color_space_settings: std::option::Option<crate::model::H264ColorSpaceSettings>,
        pub(crate) entropy_encoding: std::option::Option<crate::model::H264EntropyEncoding>,
        pub(crate) filter_settings: std::option::Option<crate::model::H264FilterSettings>,
        pub(crate) fixed_afd: std::option::Option<crate::model::FixedAfd>,
        pub(crate) flicker_aq: std::option::Option<crate::model::H264FlickerAq>,
        pub(crate) force_field_pictures: std::option::Option<crate::model::H264ForceFieldPictures>,
        pub(crate) framerate_control: std::option::Option<crate::model::H264FramerateControl>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_b_reference: std::option::Option<crate::model::H264GopBReference>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) gop_num_b_frames: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) gop_size_units: std::option::Option<crate::model::H264GopSizeUnits>,
        pub(crate) level: std::option::Option<crate::model::H264Level>,
        pub(crate) look_ahead_rate_control:
            std::option::Option<crate::model::H264LookAheadRateControl>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) min_i_interval: std::option::Option<i32>,
        pub(crate) num_ref_frames: std::option::Option<i32>,
        pub(crate) par_control: std::option::Option<crate::model::H264ParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) profile: std::option::Option<crate::model::H264Profile>,
        pub(crate) quality_level: std::option::Option<crate::model::H264QualityLevel>,
        pub(crate) qvbr_quality_level: std::option::Option<i32>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::H264RateControlMode>,
        pub(crate) scan_type: std::option::Option<crate::model::H264ScanType>,
        pub(crate) scene_change_detect: std::option::Option<crate::model::H264SceneChangeDetect>,
        pub(crate) slices: std::option::Option<i32>,
        pub(crate) softness: std::option::Option<i32>,
        pub(crate) spatial_aq: std::option::Option<crate::model::H264SpatialAq>,
        pub(crate) subgop_length: std::option::Option<crate::model::H264SubGopLength>,
        pub(crate) syntax: std::option::Option<crate::model::H264Syntax>,
        pub(crate) temporal_aq: std::option::Option<crate::model::H264TemporalAq>,
        pub(crate) timecode_insertion:
            std::option::Option<crate::model::H264TimecodeInsertionBehavior>,
    }
    impl Builder {
        /// Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::H264AdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Enables or disables adaptive quantization, which is a technique MediaLive can apply to video on a frame-by-frame basis to produce more compression without losing quality. There are three types of adaptive quantization: flicker, spatial, and temporal. Set the field in one of these ways: Set to Auto. Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and if so, the appropriate strength. Set a strength (a value other than Auto or Disable). This strength will apply to any of the AQ fields that you choose to enable. Set to Disabled to disable all types of adaptive quantization.
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H264AdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Indicates that AFD values will be written into the output stream.  If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
        pub fn afd_signaling(mut self, input: crate::model::AfdSignaling) -> Self {
            self.afd_signaling = Some(input);
            self
        }
        /// Indicates that AFD values will be written into the output stream.  If afdSignaling is "auto", the system will try to preserve the input AFD value (in cases where multiple AFD values are valid). If set to "fixed", the AFD value will be the value configured in the fixedAfd parameter.
        pub fn set_afd_signaling(
            mut self,
            input: std::option::Option<crate::model::AfdSignaling>,
        ) -> Self {
            self.afd_signaling = input;
            self
        }
        /// Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Average bitrate in bits/second. Required when the rate control mode is VBR or CBR. Not used for QVBR. In an MS Smooth output group, each output must have a unique value when its bitrate is rounded down to the nearest multiple of 1000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn buf_fill_pct(mut self, input: i32) -> Self {
            self.buf_fill_pct = Some(input);
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn set_buf_fill_pct(mut self, input: std::option::Option<i32>) -> Self {
            self.buf_fill_pct = input;
            self
        }
        /// Size of buffer (HRD buffer model) in bits.
        pub fn buf_size(mut self, input: i32) -> Self {
            self.buf_size = Some(input);
            self
        }
        /// Size of buffer (HRD buffer model) in bits.
        pub fn set_buf_size(mut self, input: std::option::Option<i32>) -> Self {
            self.buf_size = input;
            self
        }
        /// Includes colorspace metadata in the output.
        pub fn color_metadata(mut self, input: crate::model::H264ColorMetadata) -> Self {
            self.color_metadata = Some(input);
            self
        }
        /// Includes colorspace metadata in the output.
        pub fn set_color_metadata(
            mut self,
            input: std::option::Option<crate::model::H264ColorMetadata>,
        ) -> Self {
            self.color_metadata = input;
            self
        }
        /// Color Space settings
        pub fn color_space_settings(mut self, input: crate::model::H264ColorSpaceSettings) -> Self {
            self.color_space_settings = Some(input);
            self
        }
        /// Color Space settings
        pub fn set_color_space_settings(
            mut self,
            input: std::option::Option<crate::model::H264ColorSpaceSettings>,
        ) -> Self {
            self.color_space_settings = input;
            self
        }
        /// Entropy encoding mode.  Use cabac (must be in Main or High profile) or cavlc.
        pub fn entropy_encoding(mut self, input: crate::model::H264EntropyEncoding) -> Self {
            self.entropy_encoding = Some(input);
            self
        }
        /// Entropy encoding mode.  Use cabac (must be in Main or High profile) or cavlc.
        pub fn set_entropy_encoding(
            mut self,
            input: std::option::Option<crate::model::H264EntropyEncoding>,
        ) -> Self {
            self.entropy_encoding = input;
            self
        }
        /// Optional filters that you can apply to an encode.
        pub fn filter_settings(mut self, input: crate::model::H264FilterSettings) -> Self {
            self.filter_settings = Some(input);
            self
        }
        /// Optional filters that you can apply to an encode.
        pub fn set_filter_settings(
            mut self,
            input: std::option::Option<crate::model::H264FilterSettings>,
        ) -> Self {
            self.filter_settings = input;
            self
        }
        /// Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
        pub fn fixed_afd(mut self, input: crate::model::FixedAfd) -> Self {
            self.fixed_afd = Some(input);
            self
        }
        /// Four bit AFD value to write on all frames of video in the output stream. Only valid when afdSignaling is set to 'Fixed'.
        pub fn set_fixed_afd(mut self, input: std::option::Option<crate::model::FixedAfd>) -> Self {
            self.fixed_afd = input;
            self
        }
        /// Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
        pub fn flicker_aq(mut self, input: crate::model::H264FlickerAq) -> Self {
            self.flicker_aq = Some(input);
            self
        }
        /// Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on I-frames. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if flicker AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength. Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply flicker AQ.
        pub fn set_flicker_aq(
            mut self,
            input: std::option::Option<crate::model::H264FlickerAq>,
        ) -> Self {
            self.flicker_aq = input;
            self
        }
        /// This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
        /// enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
        /// disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
        pub fn force_field_pictures(mut self, input: crate::model::H264ForceFieldPictures) -> Self {
            self.force_field_pictures = Some(input);
            self
        }
        /// This setting applies only when scan type is "interlaced." It controls whether coding is performed on a field basis or on a frame basis. (When the video is progressive, the coding is always performed on a frame basis.)
        /// enabled: Force MediaLive to code on a field basis, so that odd and even sets of fields are coded separately.
        /// disabled: Code the two sets of fields separately (on a field basis) or together (on a frame basis using PAFF), depending on what is most appropriate for the content.
        pub fn set_force_field_pictures(
            mut self,
            input: std::option::Option<crate::model::H264ForceFieldPictures>,
        ) -> Self {
            self.force_field_pictures = input;
            self
        }
        /// This field indicates how the output video frame rate is specified.  If "specified" is selected then the output video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is selected then the output video frame rate will be set equal to the input video frame rate of the first input.
        pub fn framerate_control(mut self, input: crate::model::H264FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// This field indicates how the output video frame rate is specified.  If "specified" is selected then the output video frame rate is determined by framerateNumerator and framerateDenominator, else if "initializeFromSource" is selected then the output video frame rate will be set equal to the input video frame rate of the first input.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::H264FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Framerate denominator.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// Framerate denominator.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// Documentation update needed
        pub fn gop_b_reference(mut self, input: crate::model::H264GopBReference) -> Self {
            self.gop_b_reference = Some(input);
            self
        }
        /// Documentation update needed
        pub fn set_gop_b_reference(
            mut self,
            input: std::option::Option<crate::model::H264GopBReference>,
        ) -> Self {
            self.gop_b_reference = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// Number of B-frames between reference frames.
        pub fn gop_num_b_frames(mut self, input: i32) -> Self {
            self.gop_num_b_frames = Some(input);
            self
        }
        /// Number of B-frames between reference frames.
        pub fn set_gop_num_b_frames(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_num_b_frames = input;
            self
        }
        /// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
        /// If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
        /// If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// GOP size (keyframe interval) in units of either frames or seconds per gopSizeUnits.
        /// If gopSizeUnits is frames, gopSize must be an integer and must be greater than or equal to 1.
        /// If gopSizeUnits is seconds, gopSize must be greater than 0, but need not be an integer.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
        pub fn gop_size_units(mut self, input: crate::model::H264GopSizeUnits) -> Self {
            self.gop_size_units = Some(input);
            self
        }
        /// Indicates if the gopSize is specified in frames or seconds. If seconds the system will convert the gopSize into a frame count at run time.
        pub fn set_gop_size_units(
            mut self,
            input: std::option::Option<crate::model::H264GopSizeUnits>,
        ) -> Self {
            self.gop_size_units = input;
            self
        }
        /// H.264 Level.
        pub fn level(mut self, input: crate::model::H264Level) -> Self {
            self.level = Some(input);
            self
        }
        /// H.264 Level.
        pub fn set_level(mut self, input: std::option::Option<crate::model::H264Level>) -> Self {
            self.level = input;
            self
        }
        /// Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
        pub fn look_ahead_rate_control(
            mut self,
            input: crate::model::H264LookAheadRateControl,
        ) -> Self {
            self.look_ahead_rate_control = Some(input);
            self
        }
        /// Amount of lookahead. A value of low can decrease latency and memory usage, while high can produce better quality for certain content.
        pub fn set_look_ahead_rate_control(
            mut self,
            input: std::option::Option<crate::model::H264LookAheadRateControl>,
        ) -> Self {
            self.look_ahead_rate_control = input;
            self
        }
        /// For QVBR: See the tooltip for Quality level
        ///
        /// For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// For QVBR: See the tooltip for Quality level
        ///
        /// For VBR: Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Only meaningful if sceneChangeDetect is set to enabled.  Defaults to 5 if multiplex rate control is used.  Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn min_i_interval(mut self, input: i32) -> Self {
            self.min_i_interval = Some(input);
            self
        }
        /// Only meaningful if sceneChangeDetect is set to enabled.  Defaults to 5 if multiplex rate control is used.  Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn set_min_i_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.min_i_interval = input;
            self
        }
        /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
        pub fn num_ref_frames(mut self, input: i32) -> Self {
            self.num_ref_frames = Some(input);
            self
        }
        /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
        pub fn set_num_ref_frames(mut self, input: std::option::Option<i32>) -> Self {
            self.num_ref_frames = input;
            self
        }
        /// This field indicates how the output pixel aspect ratio is specified.  If "specified" is selected then the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
        pub fn par_control(mut self, input: crate::model::H264ParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// This field indicates how the output pixel aspect ratio is specified.  If "specified" is selected then the output video pixel aspect ratio is determined by parNumerator and parDenominator, else if "initializeFromSource" is selected then the output pixsel aspect ratio will be set equal to the input video pixel aspect ratio of the first input.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::H264ParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Pixel Aspect Ratio denominator.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Pixel Aspect Ratio denominator.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Pixel Aspect Ratio numerator.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Pixel Aspect Ratio numerator.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// H.264 Profile.
        pub fn profile(mut self, input: crate::model::H264Profile) -> Self {
            self.profile = Some(input);
            self
        }
        /// H.264 Profile.
        pub fn set_profile(
            mut self,
            input: std::option::Option<crate::model::H264Profile>,
        ) -> Self {
            self.profile = input;
            self
        }
        /// Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel).
        /// - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY.
        /// - STANDARD_QUALITY: Valid for any Rate control mode.
        pub fn quality_level(mut self, input: crate::model::H264QualityLevel) -> Self {
            self.quality_level = Some(input);
            self
        }
        /// Leave as STANDARD_QUALITY or choose a different value (which might result in additional costs to run the channel).
        /// - ENHANCED_QUALITY: Produces a slightly better video quality without an increase in the bitrate. Has an effect only when the Rate control mode is QVBR or CBR. If this channel is in a MediaLive multiplex, the value must be ENHANCED_QUALITY.
        /// - STANDARD_QUALITY: Valid for any Rate control mode.
        pub fn set_quality_level(
            mut self,
            input: std::option::Option<crate::model::H264QualityLevel>,
        ) -> Self {
            self.quality_level = input;
            self
        }
        /// Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices. Recommended values are:
        /// - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
        /// - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
        /// - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
        /// To let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive user guide
        pub fn qvbr_quality_level(mut self, input: i32) -> Self {
            self.qvbr_quality_level = Some(input);
            self
        }
        /// Controls the target quality for the video encode. Applies only when the rate control mode is QVBR. You can set a target quality or you can let MediaLive determine the best quality. To set a target quality, enter values in the QVBR quality level field and the Max bitrate field. Enter values that suit your most important viewing devices. Recommended values are:
        /// - Primary screen: Quality level: 8 to 10. Max bitrate: 4M
        /// - PC or tablet: Quality level: 7. Max bitrate: 1.5M to 3M
        /// - Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M
        /// To let MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate enter the maximum rate you want in the video. For more information, see the section called "Video - rate control mode" in the MediaLive user guide
        pub fn set_qvbr_quality_level(mut self, input: std::option::Option<i32>) -> Self {
            self.qvbr_quality_level = input;
            self
        }
        /// Rate control mode.
        ///
        /// QVBR: Quality will match the specified quality level except when it is constrained by the
        /// maximum bitrate.  Recommended if you or your viewers pay for bandwidth.
        ///
        /// VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR
        /// if you want to maintain a specific average bitrate over the duration of the channel.
        ///
        /// CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
        /// your assets to devices that cannot handle variable bitrates.
        ///
        /// Multiplex: This rate control mode is only supported (and is required) when the video is being
        /// delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
        /// by the properties within the Multiplex Program.
        pub fn rate_control_mode(mut self, input: crate::model::H264RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// Rate control mode.
        ///
        /// QVBR: Quality will match the specified quality level except when it is constrained by the
        /// maximum bitrate.  Recommended if you or your viewers pay for bandwidth.
        ///
        /// VBR: Quality and bitrate vary, depending on the video complexity. Recommended instead of QVBR
        /// if you want to maintain a specific average bitrate over the duration of the channel.
        ///
        /// CBR: Quality varies, depending on the video complexity. Recommended only if you distribute
        /// your assets to devices that cannot handle variable bitrates.
        ///
        /// Multiplex: This rate control mode is only supported (and is required) when the video is being
        /// delivered to a MediaLive Multiplex in which case the rate control configuration is controlled
        /// by the properties within the Multiplex Program.
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::H264RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Sets the scan type of the output to progressive or top-field-first interlaced.
        pub fn scan_type(mut self, input: crate::model::H264ScanType) -> Self {
            self.scan_type = Some(input);
            self
        }
        /// Sets the scan type of the output to progressive or top-field-first interlaced.
        pub fn set_scan_type(
            mut self,
            input: std::option::Option<crate::model::H264ScanType>,
        ) -> Self {
            self.scan_type = input;
            self
        }
        /// Scene change detection.
        ///
        /// - On: inserts I-frames when scene change is detected.
        /// - Off: does not force an I-frame when scene change is detected.
        pub fn scene_change_detect(mut self, input: crate::model::H264SceneChangeDetect) -> Self {
            self.scene_change_detect = Some(input);
            self
        }
        /// Scene change detection.
        ///
        /// - On: inserts I-frames when scene change is detected.
        /// - Off: does not force an I-frame when scene change is detected.
        pub fn set_scene_change_detect(
            mut self,
            input: std::option::Option<crate::model::H264SceneChangeDetect>,
        ) -> Self {
            self.scene_change_detect = input;
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        /// This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
        pub fn slices(mut self, input: i32) -> Self {
            self.slices = Some(input);
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        /// This field is optional; when no value is specified the encoder will choose the number of slices based on encode resolution.
        pub fn set_slices(mut self, input: std::option::Option<i32>) -> Self {
            self.slices = input;
            self
        }
        /// Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.  If not set to zero, must be greater than 15.
        pub fn softness(mut self, input: i32) -> Self {
            self.softness = Some(input);
            self
        }
        /// Softness. Selects quantizer matrix, larger values reduce high-frequency content in the encoded image.  If not set to zero, must be greater than 15.
        pub fn set_softness(mut self, input: std::option::Option<i32>) -> Self {
            self.softness = input;
            self
        }
        /// Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
        pub fn spatial_aq(mut self, input: crate::model::H264SpatialAq) -> Self {
            self.spatial_aq = Some(input);
            self
        }
        /// Spatial AQ makes adjustments within each frame based on spatial variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if spatial AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply spatial AQ.
        pub fn set_spatial_aq(
            mut self,
            input: std::option::Option<crate::model::H264SpatialAq>,
        ) -> Self {
            self.spatial_aq = input;
            self
        }
        /// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used for each sub-GOP to improve visual quality.
        pub fn subgop_length(mut self, input: crate::model::H264SubGopLength) -> Self {
            self.subgop_length = Some(input);
            self
        }
        /// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic, optimize the number of B-frames used for each sub-GOP to improve visual quality.
        pub fn set_subgop_length(
            mut self,
            input: std::option::Option<crate::model::H264SubGopLength>,
        ) -> Self {
            self.subgop_length = input;
            self
        }
        /// Produces a bitstream compliant with SMPTE RP-2027.
        pub fn syntax(mut self, input: crate::model::H264Syntax) -> Self {
            self.syntax = Some(input);
            self
        }
        /// Produces a bitstream compliant with SMPTE RP-2027.
        pub fn set_syntax(mut self, input: std::option::Option<crate::model::H264Syntax>) -> Self {
            self.syntax = input;
            self
        }
        /// Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
        pub fn temporal_aq(mut self, input: crate::model::H264TemporalAq) -> Self {
            self.temporal_aq = Some(input);
            self
        }
        /// Temporal makes adjustments within each frame based on temporal variation of content complexity. The value to enter in this field depends on the value in the Adaptive quantization field: If you have set the Adaptive quantization field to Auto, MediaLive ignores any value in this field. MediaLive will determine if temporal AQ is appropriate and will apply the appropriate strength. If you have set the Adaptive quantization field to a strength, you can set this field to Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set the Adaptive quantization to Disabled, MediaLive ignores any value in this field and doesn't apply temporal AQ.
        pub fn set_temporal_aq(
            mut self,
            input: std::option::Option<crate::model::H264TemporalAq>,
        ) -> Self {
            self.temporal_aq = input;
            self
        }
        /// Determines how timecodes should be inserted into the video elementary stream.
        /// - 'disabled': Do not include timecodes
        /// - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
        pub fn timecode_insertion(
            mut self,
            input: crate::model::H264TimecodeInsertionBehavior,
        ) -> Self {
            self.timecode_insertion = Some(input);
            self
        }
        /// Determines how timecodes should be inserted into the video elementary stream.
        /// - 'disabled': Do not include timecodes
        /// - 'picTimingSei': Pass through picture timing SEI messages from the source specified in Timecode Config
        pub fn set_timecode_insertion(
            mut self,
            input: std::option::Option<crate::model::H264TimecodeInsertionBehavior>,
        ) -> Self {
            self.timecode_insertion = input;
            self
        }
        /// Consumes the builder and constructs a [`H264Settings`](crate::model::H264Settings)
        pub fn build(self) -> crate::model::H264Settings {
            crate::model::H264Settings {
                adaptive_quantization: self.adaptive_quantization,
                afd_signaling: self.afd_signaling,
                bitrate: self.bitrate.unwrap_or_default(),
                buf_fill_pct: self.buf_fill_pct.unwrap_or_default(),
                buf_size: self.buf_size.unwrap_or_default(),
                color_metadata: self.color_metadata,
                color_space_settings: self.color_space_settings,
                entropy_encoding: self.entropy_encoding,
                filter_settings: self.filter_settings,
                fixed_afd: self.fixed_afd,
                flicker_aq: self.flicker_aq,
                force_field_pictures: self.force_field_pictures,
                framerate_control: self.framerate_control,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_b_reference: self.gop_b_reference,
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                gop_num_b_frames: self.gop_num_b_frames.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                gop_size_units: self.gop_size_units,
                level: self.level,
                look_ahead_rate_control: self.look_ahead_rate_control,
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                min_i_interval: self.min_i_interval.unwrap_or_default(),
                num_ref_frames: self.num_ref_frames.unwrap_or_default(),
                par_control: self.par_control,
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                profile: self.profile,
                quality_level: self.quality_level,
                qvbr_quality_level: self.qvbr_quality_level.unwrap_or_default(),
                rate_control_mode: self.rate_control_mode,
                scan_type: self.scan_type,
                scene_change_detect: self.scene_change_detect,
                slices: self.slices.unwrap_or_default(),
                softness: self.softness.unwrap_or_default(),
                spatial_aq: self.spatial_aq,
                subgop_length: self.subgop_length,
                syntax: self.syntax,
                temporal_aq: self.temporal_aq,
                timecode_insertion: self.timecode_insertion,
            }
        }
    }
}
impl H264Settings {
    /// Creates a new builder-style object to manufacture [`H264Settings`](crate::model::H264Settings)
    pub fn builder() -> crate::model::h264_settings::Builder {
        crate::model::h264_settings::Builder::default()
    }
}

/// H264 Timecode Insertion Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264TimecodeInsertionBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    PicTimingSei,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264TimecodeInsertionBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264TimecodeInsertionBehavior::Disabled,
            "PIC_TIMING_SEI" => H264TimecodeInsertionBehavior::PicTimingSei,
            other => H264TimecodeInsertionBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264TimecodeInsertionBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264TimecodeInsertionBehavior::from(s))
    }
}
impl H264TimecodeInsertionBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264TimecodeInsertionBehavior::Disabled => "DISABLED",
            H264TimecodeInsertionBehavior::PicTimingSei => "PIC_TIMING_SEI",
            H264TimecodeInsertionBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "PIC_TIMING_SEI"]
    }
}
impl AsRef<str> for H264TimecodeInsertionBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Temporal Aq
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264TemporalAq {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264TemporalAq {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264TemporalAq::Disabled,
            "ENABLED" => H264TemporalAq::Enabled,
            other => H264TemporalAq::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264TemporalAq {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264TemporalAq::from(s))
    }
}
impl H264TemporalAq {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264TemporalAq::Disabled => "DISABLED",
            H264TemporalAq::Enabled => "ENABLED",
            H264TemporalAq::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H264TemporalAq {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Syntax
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264Syntax {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Rp2027,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264Syntax {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => H264Syntax::Default,
            "RP2027" => H264Syntax::Rp2027,
            other => H264Syntax::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264Syntax {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264Syntax::from(s))
    }
}
impl H264Syntax {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264Syntax::Default => "DEFAULT",
            H264Syntax::Rp2027 => "RP2027",
            H264Syntax::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "RP2027"]
    }
}
impl AsRef<str> for H264Syntax {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Sub Gop Length
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264SubGopLength {
    #[allow(missing_docs)] // documentation missing in model
    Dynamic,
    #[allow(missing_docs)] // documentation missing in model
    Fixed,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264SubGopLength {
    fn from(s: &str) -> Self {
        match s {
            "DYNAMIC" => H264SubGopLength::Dynamic,
            "FIXED" => H264SubGopLength::Fixed,
            other => H264SubGopLength::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264SubGopLength {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264SubGopLength::from(s))
    }
}
impl H264SubGopLength {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264SubGopLength::Dynamic => "DYNAMIC",
            H264SubGopLength::Fixed => "FIXED",
            H264SubGopLength::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DYNAMIC", "FIXED"]
    }
}
impl AsRef<str> for H264SubGopLength {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Spatial Aq
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264SpatialAq {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264SpatialAq {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264SpatialAq::Disabled,
            "ENABLED" => H264SpatialAq::Enabled,
            other => H264SpatialAq::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264SpatialAq {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264SpatialAq::from(s))
    }
}
impl H264SpatialAq {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264SpatialAq::Disabled => "DISABLED",
            H264SpatialAq::Enabled => "ENABLED",
            H264SpatialAq::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H264SpatialAq {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Scene Change Detect
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264SceneChangeDetect {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264SceneChangeDetect {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264SceneChangeDetect::Disabled,
            "ENABLED" => H264SceneChangeDetect::Enabled,
            other => H264SceneChangeDetect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264SceneChangeDetect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264SceneChangeDetect::from(s))
    }
}
impl H264SceneChangeDetect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264SceneChangeDetect::Disabled => "DISABLED",
            H264SceneChangeDetect::Enabled => "ENABLED",
            H264SceneChangeDetect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H264SceneChangeDetect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Scan Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264ScanType {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264ScanType {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => H264ScanType::Interlaced,
            "PROGRESSIVE" => H264ScanType::Progressive,
            other => H264ScanType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264ScanType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264ScanType::from(s))
    }
}
impl H264ScanType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264ScanType::Interlaced => "INTERLACED",
            H264ScanType::Progressive => "PROGRESSIVE",
            H264ScanType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "PROGRESSIVE"]
    }
}
impl AsRef<str> for H264ScanType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Rate Control Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264RateControlMode {
    #[allow(missing_docs)] // documentation missing in model
    Cbr,
    #[allow(missing_docs)] // documentation missing in model
    Multiplex,
    #[allow(missing_docs)] // documentation missing in model
    Qvbr,
    #[allow(missing_docs)] // documentation missing in model
    Vbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264RateControlMode {
    fn from(s: &str) -> Self {
        match s {
            "CBR" => H264RateControlMode::Cbr,
            "MULTIPLEX" => H264RateControlMode::Multiplex,
            "QVBR" => H264RateControlMode::Qvbr,
            "VBR" => H264RateControlMode::Vbr,
            other => H264RateControlMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264RateControlMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264RateControlMode::from(s))
    }
}
impl H264RateControlMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264RateControlMode::Cbr => "CBR",
            H264RateControlMode::Multiplex => "MULTIPLEX",
            H264RateControlMode::Qvbr => "QVBR",
            H264RateControlMode::Vbr => "VBR",
            H264RateControlMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CBR", "MULTIPLEX", "QVBR", "VBR"]
    }
}
impl AsRef<str> for H264RateControlMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Quality Level
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264QualityLevel {
    #[allow(missing_docs)] // documentation missing in model
    EnhancedQuality,
    #[allow(missing_docs)] // documentation missing in model
    StandardQuality,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264QualityLevel {
    fn from(s: &str) -> Self {
        match s {
            "ENHANCED_QUALITY" => H264QualityLevel::EnhancedQuality,
            "STANDARD_QUALITY" => H264QualityLevel::StandardQuality,
            other => H264QualityLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264QualityLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264QualityLevel::from(s))
    }
}
impl H264QualityLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264QualityLevel::EnhancedQuality => "ENHANCED_QUALITY",
            H264QualityLevel::StandardQuality => "STANDARD_QUALITY",
            H264QualityLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENHANCED_QUALITY", "STANDARD_QUALITY"]
    }
}
impl AsRef<str> for H264QualityLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Profile
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264Profile {
    #[allow(missing_docs)] // documentation missing in model
    Baseline,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    High10Bit,
    #[allow(missing_docs)] // documentation missing in model
    High422,
    #[allow(missing_docs)] // documentation missing in model
    High42210Bit,
    #[allow(missing_docs)] // documentation missing in model
    Main,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264Profile {
    fn from(s: &str) -> Self {
        match s {
            "BASELINE" => H264Profile::Baseline,
            "HIGH" => H264Profile::High,
            "HIGH_10BIT" => H264Profile::High10Bit,
            "HIGH_422" => H264Profile::High422,
            "HIGH_422_10BIT" => H264Profile::High42210Bit,
            "MAIN" => H264Profile::Main,
            other => H264Profile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264Profile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264Profile::from(s))
    }
}
impl H264Profile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264Profile::Baseline => "BASELINE",
            H264Profile::High => "HIGH",
            H264Profile::High10Bit => "HIGH_10BIT",
            H264Profile::High422 => "HIGH_422",
            H264Profile::High42210Bit => "HIGH_422_10BIT",
            H264Profile::Main => "MAIN",
            H264Profile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BASELINE",
            "HIGH",
            "HIGH_10BIT",
            "HIGH_422",
            "HIGH_422_10BIT",
            "MAIN",
        ]
    }
}
impl AsRef<str> for H264Profile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Par Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264ParControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264ParControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => H264ParControl::InitializeFromSource,
            "SPECIFIED" => H264ParControl::Specified,
            other => H264ParControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264ParControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264ParControl::from(s))
    }
}
impl H264ParControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264ParControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            H264ParControl::Specified => "SPECIFIED",
            H264ParControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for H264ParControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Look Ahead Rate Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264LookAheadRateControl {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264LookAheadRateControl {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => H264LookAheadRateControl::High,
            "LOW" => H264LookAheadRateControl::Low,
            "MEDIUM" => H264LookAheadRateControl::Medium,
            other => H264LookAheadRateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264LookAheadRateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264LookAheadRateControl::from(s))
    }
}
impl H264LookAheadRateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264LookAheadRateControl::High => "HIGH",
            H264LookAheadRateControl::Low => "LOW",
            H264LookAheadRateControl::Medium => "MEDIUM",
            H264LookAheadRateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for H264LookAheadRateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Level
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264Level {
    #[allow(missing_docs)] // documentation missing in model
    H264Level1,
    #[allow(missing_docs)] // documentation missing in model
    H264Level11,
    #[allow(missing_docs)] // documentation missing in model
    H264Level12,
    #[allow(missing_docs)] // documentation missing in model
    H264Level13,
    #[allow(missing_docs)] // documentation missing in model
    H264Level2,
    #[allow(missing_docs)] // documentation missing in model
    H264Level21,
    #[allow(missing_docs)] // documentation missing in model
    H264Level22,
    #[allow(missing_docs)] // documentation missing in model
    H264Level3,
    #[allow(missing_docs)] // documentation missing in model
    H264Level31,
    #[allow(missing_docs)] // documentation missing in model
    H264Level32,
    #[allow(missing_docs)] // documentation missing in model
    H264Level4,
    #[allow(missing_docs)] // documentation missing in model
    H264Level41,
    #[allow(missing_docs)] // documentation missing in model
    H264Level42,
    #[allow(missing_docs)] // documentation missing in model
    H264Level5,
    #[allow(missing_docs)] // documentation missing in model
    H264Level51,
    #[allow(missing_docs)] // documentation missing in model
    H264Level52,
    #[allow(missing_docs)] // documentation missing in model
    H264LevelAuto,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264Level {
    fn from(s: &str) -> Self {
        match s {
            "H264_LEVEL_1" => H264Level::H264Level1,
            "H264_LEVEL_1_1" => H264Level::H264Level11,
            "H264_LEVEL_1_2" => H264Level::H264Level12,
            "H264_LEVEL_1_3" => H264Level::H264Level13,
            "H264_LEVEL_2" => H264Level::H264Level2,
            "H264_LEVEL_2_1" => H264Level::H264Level21,
            "H264_LEVEL_2_2" => H264Level::H264Level22,
            "H264_LEVEL_3" => H264Level::H264Level3,
            "H264_LEVEL_3_1" => H264Level::H264Level31,
            "H264_LEVEL_3_2" => H264Level::H264Level32,
            "H264_LEVEL_4" => H264Level::H264Level4,
            "H264_LEVEL_4_1" => H264Level::H264Level41,
            "H264_LEVEL_4_2" => H264Level::H264Level42,
            "H264_LEVEL_5" => H264Level::H264Level5,
            "H264_LEVEL_5_1" => H264Level::H264Level51,
            "H264_LEVEL_5_2" => H264Level::H264Level52,
            "H264_LEVEL_AUTO" => H264Level::H264LevelAuto,
            other => H264Level::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264Level {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264Level::from(s))
    }
}
impl H264Level {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264Level::H264Level1 => "H264_LEVEL_1",
            H264Level::H264Level11 => "H264_LEVEL_1_1",
            H264Level::H264Level12 => "H264_LEVEL_1_2",
            H264Level::H264Level13 => "H264_LEVEL_1_3",
            H264Level::H264Level2 => "H264_LEVEL_2",
            H264Level::H264Level21 => "H264_LEVEL_2_1",
            H264Level::H264Level22 => "H264_LEVEL_2_2",
            H264Level::H264Level3 => "H264_LEVEL_3",
            H264Level::H264Level31 => "H264_LEVEL_3_1",
            H264Level::H264Level32 => "H264_LEVEL_3_2",
            H264Level::H264Level4 => "H264_LEVEL_4",
            H264Level::H264Level41 => "H264_LEVEL_4_1",
            H264Level::H264Level42 => "H264_LEVEL_4_2",
            H264Level::H264Level5 => "H264_LEVEL_5",
            H264Level::H264Level51 => "H264_LEVEL_5_1",
            H264Level::H264Level52 => "H264_LEVEL_5_2",
            H264Level::H264LevelAuto => "H264_LEVEL_AUTO",
            H264Level::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "H264_LEVEL_1",
            "H264_LEVEL_1_1",
            "H264_LEVEL_1_2",
            "H264_LEVEL_1_3",
            "H264_LEVEL_2",
            "H264_LEVEL_2_1",
            "H264_LEVEL_2_2",
            "H264_LEVEL_3",
            "H264_LEVEL_3_1",
            "H264_LEVEL_3_2",
            "H264_LEVEL_4",
            "H264_LEVEL_4_1",
            "H264_LEVEL_4_2",
            "H264_LEVEL_5",
            "H264_LEVEL_5_1",
            "H264_LEVEL_5_2",
            "H264_LEVEL_AUTO",
        ]
    }
}
impl AsRef<str> for H264Level {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Gop Size Units
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264GopSizeUnits {
    #[allow(missing_docs)] // documentation missing in model
    Frames,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264GopSizeUnits {
    fn from(s: &str) -> Self {
        match s {
            "FRAMES" => H264GopSizeUnits::Frames,
            "SECONDS" => H264GopSizeUnits::Seconds,
            other => H264GopSizeUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264GopSizeUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264GopSizeUnits::from(s))
    }
}
impl H264GopSizeUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264GopSizeUnits::Frames => "FRAMES",
            H264GopSizeUnits::Seconds => "SECONDS",
            H264GopSizeUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAMES", "SECONDS"]
    }
}
impl AsRef<str> for H264GopSizeUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Gop BReference
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264GopBReference {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264GopBReference {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264GopBReference::Disabled,
            "ENABLED" => H264GopBReference::Enabled,
            other => H264GopBReference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264GopBReference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264GopBReference::from(s))
    }
}
impl H264GopBReference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264GopBReference::Disabled => "DISABLED",
            H264GopBReference::Enabled => "ENABLED",
            H264GopBReference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H264GopBReference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Framerate Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264FramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264FramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => H264FramerateControl::InitializeFromSource,
            "SPECIFIED" => H264FramerateControl::Specified,
            other => H264FramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264FramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264FramerateControl::from(s))
    }
}
impl H264FramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264FramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            H264FramerateControl::Specified => "SPECIFIED",
            H264FramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for H264FramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Force Field Pictures
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264ForceFieldPictures {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264ForceFieldPictures {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264ForceFieldPictures::Disabled,
            "ENABLED" => H264ForceFieldPictures::Enabled,
            other => H264ForceFieldPictures::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264ForceFieldPictures {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264ForceFieldPictures::from(s))
    }
}
impl H264ForceFieldPictures {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264ForceFieldPictures::Disabled => "DISABLED",
            H264ForceFieldPictures::Enabled => "ENABLED",
            H264ForceFieldPictures::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H264ForceFieldPictures {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Flicker Aq
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264FlickerAq {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264FlickerAq {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H264FlickerAq::Disabled,
            "ENABLED" => H264FlickerAq::Enabled,
            other => H264FlickerAq::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264FlickerAq {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264FlickerAq::from(s))
    }
}
impl H264FlickerAq {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264FlickerAq::Disabled => "DISABLED",
            H264FlickerAq::Enabled => "ENABLED",
            H264FlickerAq::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H264FlickerAq {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Filter Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H264FilterSettings {
    /// Temporal Filter Settings
    pub temporal_filter_settings: std::option::Option<crate::model::TemporalFilterSettings>,
}
impl std::fmt::Debug for H264FilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H264FilterSettings");
        formatter.field("temporal_filter_settings", &self.temporal_filter_settings);
        formatter.finish()
    }
}
/// See [`H264FilterSettings`](crate::model::H264FilterSettings)
pub mod h264_filter_settings {
    /// A builder for [`H264FilterSettings`](crate::model::H264FilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) temporal_filter_settings:
            std::option::Option<crate::model::TemporalFilterSettings>,
    }
    impl Builder {
        /// Temporal Filter Settings
        pub fn temporal_filter_settings(
            mut self,
            input: crate::model::TemporalFilterSettings,
        ) -> Self {
            self.temporal_filter_settings = Some(input);
            self
        }
        /// Temporal Filter Settings
        pub fn set_temporal_filter_settings(
            mut self,
            input: std::option::Option<crate::model::TemporalFilterSettings>,
        ) -> Self {
            self.temporal_filter_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`H264FilterSettings`](crate::model::H264FilterSettings)
        pub fn build(self) -> crate::model::H264FilterSettings {
            crate::model::H264FilterSettings {
                temporal_filter_settings: self.temporal_filter_settings,
            }
        }
    }
}
impl H264FilterSettings {
    /// Creates a new builder-style object to manufacture [`H264FilterSettings`](crate::model::H264FilterSettings)
    pub fn builder() -> crate::model::h264_filter_settings::Builder {
        crate::model::h264_filter_settings::Builder::default()
    }
}

/// H264 Entropy Encoding
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264EntropyEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Cabac,
    #[allow(missing_docs)] // documentation missing in model
    Cavlc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264EntropyEncoding {
    fn from(s: &str) -> Self {
        match s {
            "CABAC" => H264EntropyEncoding::Cabac,
            "CAVLC" => H264EntropyEncoding::Cavlc,
            other => H264EntropyEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264EntropyEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264EntropyEncoding::from(s))
    }
}
impl H264EntropyEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264EntropyEncoding::Cabac => "CABAC",
            H264EntropyEncoding::Cavlc => "CAVLC",
            H264EntropyEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CABAC", "CAVLC"]
    }
}
impl AsRef<str> for H264EntropyEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Color Space Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H264ColorSpaceSettings {
    /// Passthrough applies no color space conversion to the output
    pub color_space_passthrough_settings:
        std::option::Option<crate::model::ColorSpacePassthroughSettings>,
    /// Rec601 Settings
    pub rec601_settings: std::option::Option<crate::model::Rec601Settings>,
    /// Rec709 Settings
    pub rec709_settings: std::option::Option<crate::model::Rec709Settings>,
}
impl std::fmt::Debug for H264ColorSpaceSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H264ColorSpaceSettings");
        formatter.field(
            "color_space_passthrough_settings",
            &self.color_space_passthrough_settings,
        );
        formatter.field("rec601_settings", &self.rec601_settings);
        formatter.field("rec709_settings", &self.rec709_settings);
        formatter.finish()
    }
}
/// See [`H264ColorSpaceSettings`](crate::model::H264ColorSpaceSettings)
pub mod h264_color_space_settings {
    /// A builder for [`H264ColorSpaceSettings`](crate::model::H264ColorSpaceSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) color_space_passthrough_settings:
            std::option::Option<crate::model::ColorSpacePassthroughSettings>,
        pub(crate) rec601_settings: std::option::Option<crate::model::Rec601Settings>,
        pub(crate) rec709_settings: std::option::Option<crate::model::Rec709Settings>,
    }
    impl Builder {
        /// Passthrough applies no color space conversion to the output
        pub fn color_space_passthrough_settings(
            mut self,
            input: crate::model::ColorSpacePassthroughSettings,
        ) -> Self {
            self.color_space_passthrough_settings = Some(input);
            self
        }
        /// Passthrough applies no color space conversion to the output
        pub fn set_color_space_passthrough_settings(
            mut self,
            input: std::option::Option<crate::model::ColorSpacePassthroughSettings>,
        ) -> Self {
            self.color_space_passthrough_settings = input;
            self
        }
        /// Rec601 Settings
        pub fn rec601_settings(mut self, input: crate::model::Rec601Settings) -> Self {
            self.rec601_settings = Some(input);
            self
        }
        /// Rec601 Settings
        pub fn set_rec601_settings(
            mut self,
            input: std::option::Option<crate::model::Rec601Settings>,
        ) -> Self {
            self.rec601_settings = input;
            self
        }
        /// Rec709 Settings
        pub fn rec709_settings(mut self, input: crate::model::Rec709Settings) -> Self {
            self.rec709_settings = Some(input);
            self
        }
        /// Rec709 Settings
        pub fn set_rec709_settings(
            mut self,
            input: std::option::Option<crate::model::Rec709Settings>,
        ) -> Self {
            self.rec709_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`H264ColorSpaceSettings`](crate::model::H264ColorSpaceSettings)
        pub fn build(self) -> crate::model::H264ColorSpaceSettings {
            crate::model::H264ColorSpaceSettings {
                color_space_passthrough_settings: self.color_space_passthrough_settings,
                rec601_settings: self.rec601_settings,
                rec709_settings: self.rec709_settings,
            }
        }
    }
}
impl H264ColorSpaceSettings {
    /// Creates a new builder-style object to manufacture [`H264ColorSpaceSettings`](crate::model::H264ColorSpaceSettings)
    pub fn builder() -> crate::model::h264_color_space_settings::Builder {
        crate::model::h264_color_space_settings::Builder::default()
    }
}

/// H264 Color Metadata
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264ColorMetadata {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264ColorMetadata {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => H264ColorMetadata::Ignore,
            "INSERT" => H264ColorMetadata::Insert,
            other => H264ColorMetadata::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264ColorMetadata {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264ColorMetadata::from(s))
    }
}
impl H264ColorMetadata {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264ColorMetadata::Ignore => "IGNORE",
            H264ColorMetadata::Insert => "INSERT",
            H264ColorMetadata::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "INSERT"]
    }
}
impl AsRef<str> for H264ColorMetadata {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H264 Adaptive Quantization
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H264AdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Higher,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Max,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H264AdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => H264AdaptiveQuantization::Auto,
            "HIGH" => H264AdaptiveQuantization::High,
            "HIGHER" => H264AdaptiveQuantization::Higher,
            "LOW" => H264AdaptiveQuantization::Low,
            "MAX" => H264AdaptiveQuantization::Max,
            "MEDIUM" => H264AdaptiveQuantization::Medium,
            "OFF" => H264AdaptiveQuantization::Off,
            other => H264AdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H264AdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H264AdaptiveQuantization::from(s))
    }
}
impl H264AdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H264AdaptiveQuantization::Auto => "AUTO",
            H264AdaptiveQuantization::High => "HIGH",
            H264AdaptiveQuantization::Higher => "HIGHER",
            H264AdaptiveQuantization::Low => "LOW",
            H264AdaptiveQuantization::Max => "MAX",
            H264AdaptiveQuantization::Medium => "MEDIUM",
            H264AdaptiveQuantization::Off => "OFF",
            H264AdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HIGH", "HIGHER", "LOW", "MAX", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for H264AdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Frame Capture Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameCaptureSettings {
    /// The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or milliseconds, as specified by captureIntervalUnits.
    pub capture_interval: i32,
    /// Unit for the frame capture interval.
    pub capture_interval_units: std::option::Option<crate::model::FrameCaptureIntervalUnit>,
}
impl std::fmt::Debug for FrameCaptureSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameCaptureSettings");
        formatter.field("capture_interval", &self.capture_interval);
        formatter.field("capture_interval_units", &self.capture_interval_units);
        formatter.finish()
    }
}
/// See [`FrameCaptureSettings`](crate::model::FrameCaptureSettings)
pub mod frame_capture_settings {
    /// A builder for [`FrameCaptureSettings`](crate::model::FrameCaptureSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) capture_interval: std::option::Option<i32>,
        pub(crate) capture_interval_units:
            std::option::Option<crate::model::FrameCaptureIntervalUnit>,
    }
    impl Builder {
        /// The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or milliseconds, as specified by captureIntervalUnits.
        pub fn capture_interval(mut self, input: i32) -> Self {
            self.capture_interval = Some(input);
            self
        }
        /// The frequency at which to capture frames for inclusion in the output. May be specified in either seconds or milliseconds, as specified by captureIntervalUnits.
        pub fn set_capture_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.capture_interval = input;
            self
        }
        /// Unit for the frame capture interval.
        pub fn capture_interval_units(
            mut self,
            input: crate::model::FrameCaptureIntervalUnit,
        ) -> Self {
            self.capture_interval_units = Some(input);
            self
        }
        /// Unit for the frame capture interval.
        pub fn set_capture_interval_units(
            mut self,
            input: std::option::Option<crate::model::FrameCaptureIntervalUnit>,
        ) -> Self {
            self.capture_interval_units = input;
            self
        }
        /// Consumes the builder and constructs a [`FrameCaptureSettings`](crate::model::FrameCaptureSettings)
        pub fn build(self) -> crate::model::FrameCaptureSettings {
            crate::model::FrameCaptureSettings {
                capture_interval: self.capture_interval.unwrap_or_default(),
                capture_interval_units: self.capture_interval_units,
            }
        }
    }
}
impl FrameCaptureSettings {
    /// Creates a new builder-style object to manufacture [`FrameCaptureSettings`](crate::model::FrameCaptureSettings)
    pub fn builder() -> crate::model::frame_capture_settings::Builder {
        crate::model::frame_capture_settings::Builder::default()
    }
}

/// Frame Capture Interval Unit
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FrameCaptureIntervalUnit {
    #[allow(missing_docs)] // documentation missing in model
    Milliseconds,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FrameCaptureIntervalUnit {
    fn from(s: &str) -> Self {
        match s {
            "MILLISECONDS" => FrameCaptureIntervalUnit::Milliseconds,
            "SECONDS" => FrameCaptureIntervalUnit::Seconds,
            other => FrameCaptureIntervalUnit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FrameCaptureIntervalUnit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FrameCaptureIntervalUnit::from(s))
    }
}
impl FrameCaptureIntervalUnit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FrameCaptureIntervalUnit::Milliseconds => "MILLISECONDS",
            FrameCaptureIntervalUnit::Seconds => "SECONDS",
            FrameCaptureIntervalUnit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MILLISECONDS", "SECONDS"]
    }
}
impl AsRef<str> for FrameCaptureIntervalUnit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Timecode Config
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimecodeConfig {
    /// Identifies the source for the timecode that will be associated with the events outputs.
    /// -Embedded (embedded): Initialize the output timecode with timecode from the the source.  If no embedded timecode is detected in the source, the system falls back to using "Start at 0" (zerobased).
    /// -System Clock (systemclock): Use the UTC time.
    /// -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
    pub source: std::option::Option<crate::model::TimecodeConfigSource>,
    /// Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies below this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No timecode sync when this is not specified.
    pub sync_threshold: i32,
}
impl std::fmt::Debug for TimecodeConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimecodeConfig");
        formatter.field("source", &self.source);
        formatter.field("sync_threshold", &self.sync_threshold);
        formatter.finish()
    }
}
/// See [`TimecodeConfig`](crate::model::TimecodeConfig)
pub mod timecode_config {
    /// A builder for [`TimecodeConfig`](crate::model::TimecodeConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) source: std::option::Option<crate::model::TimecodeConfigSource>,
        pub(crate) sync_threshold: std::option::Option<i32>,
    }
    impl Builder {
        /// Identifies the source for the timecode that will be associated with the events outputs.
        /// -Embedded (embedded): Initialize the output timecode with timecode from the the source.  If no embedded timecode is detected in the source, the system falls back to using "Start at 0" (zerobased).
        /// -System Clock (systemclock): Use the UTC time.
        /// -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
        pub fn source(mut self, input: crate::model::TimecodeConfigSource) -> Self {
            self.source = Some(input);
            self
        }
        /// Identifies the source for the timecode that will be associated with the events outputs.
        /// -Embedded (embedded): Initialize the output timecode with timecode from the the source.  If no embedded timecode is detected in the source, the system falls back to using "Start at 0" (zerobased).
        /// -System Clock (systemclock): Use the UTC time.
        /// -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::TimecodeConfigSource>,
        ) -> Self {
            self.source = input;
            self
        }
        /// Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies below this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No timecode sync when this is not specified.
        pub fn sync_threshold(mut self, input: i32) -> Self {
            self.sync_threshold = Some(input);
            self
        }
        /// Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies below this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No timecode sync when this is not specified.
        pub fn set_sync_threshold(mut self, input: std::option::Option<i32>) -> Self {
            self.sync_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`TimecodeConfig`](crate::model::TimecodeConfig)
        pub fn build(self) -> crate::model::TimecodeConfig {
            crate::model::TimecodeConfig {
                source: self.source,
                sync_threshold: self.sync_threshold.unwrap_or_default(),
            }
        }
    }
}
impl TimecodeConfig {
    /// Creates a new builder-style object to manufacture [`TimecodeConfig`](crate::model::TimecodeConfig)
    pub fn builder() -> crate::model::timecode_config::Builder {
        crate::model::timecode_config::Builder::default()
    }
}

/// Timecode Config Source
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimecodeConfigSource {
    #[allow(missing_docs)] // documentation missing in model
    Embedded,
    #[allow(missing_docs)] // documentation missing in model
    Systemclock,
    #[allow(missing_docs)] // documentation missing in model
    Zerobased,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimecodeConfigSource {
    fn from(s: &str) -> Self {
        match s {
            "EMBEDDED" => TimecodeConfigSource::Embedded,
            "SYSTEMCLOCK" => TimecodeConfigSource::Systemclock,
            "ZEROBASED" => TimecodeConfigSource::Zerobased,
            other => TimecodeConfigSource::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimecodeConfigSource {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimecodeConfigSource::from(s))
    }
}
impl TimecodeConfigSource {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimecodeConfigSource::Embedded => "EMBEDDED",
            TimecodeConfigSource::Systemclock => "SYSTEMCLOCK",
            TimecodeConfigSource::Zerobased => "ZEROBASED",
            TimecodeConfigSource::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMBEDDED", "SYSTEMCLOCK", "ZEROBASED"]
    }
}
impl AsRef<str> for TimecodeConfigSource {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Output groups for this Live Event. Output groups contain information about where streams should be distributed.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputGroup {
    /// Custom output group name optionally defined by the user.  Only letters, numbers, and the underscore character allowed; only 32 characters allowed.
    pub name: std::option::Option<std::string::String>,
    /// Settings associated with the output group.
    pub output_group_settings: std::option::Option<crate::model::OutputGroupSettings>,
    /// Placeholder documentation for __listOfOutput
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
}
impl std::fmt::Debug for OutputGroup {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputGroup");
        formatter.field("name", &self.name);
        formatter.field("output_group_settings", &self.output_group_settings);
        formatter.field("outputs", &self.outputs);
        formatter.finish()
    }
}
/// See [`OutputGroup`](crate::model::OutputGroup)
pub mod output_group {
    /// A builder for [`OutputGroup`](crate::model::OutputGroup)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) output_group_settings: std::option::Option<crate::model::OutputGroupSettings>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    }
    impl Builder {
        /// Custom output group name optionally defined by the user.  Only letters, numbers, and the underscore character allowed; only 32 characters allowed.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Custom output group name optionally defined by the user.  Only letters, numbers, and the underscore character allowed; only 32 characters allowed.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Settings associated with the output group.
        pub fn output_group_settings(mut self, input: crate::model::OutputGroupSettings) -> Self {
            self.output_group_settings = Some(input);
            self
        }
        /// Settings associated with the output group.
        pub fn set_output_group_settings(
            mut self,
            input: std::option::Option<crate::model::OutputGroupSettings>,
        ) -> Self {
            self.output_group_settings = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// Placeholder documentation for __listOfOutput
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// Placeholder documentation for __listOfOutput
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputGroup`](crate::model::OutputGroup)
        pub fn build(self) -> crate::model::OutputGroup {
            crate::model::OutputGroup {
                name: self.name,
                output_group_settings: self.output_group_settings,
                outputs: self.outputs,
            }
        }
    }
}
impl OutputGroup {
    /// Creates a new builder-style object to manufacture [`OutputGroup`](crate::model::OutputGroup)
    pub fn builder() -> crate::model::output_group::Builder {
        crate::model::output_group::Builder::default()
    }
}

/// Output settings. There can be multiple outputs within a group.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Output {
    /// The names of the AudioDescriptions used as audio sources for this output.
    pub audio_description_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The names of the CaptionDescriptions used as caption sources for this output.
    pub caption_description_names: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The name used to identify an output.
    pub output_name: std::option::Option<std::string::String>,
    /// Output type-specific settings.
    pub output_settings: std::option::Option<crate::model::OutputSettings>,
    /// The name of the VideoDescription used as the source for this output.
    pub video_description_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Output");
        formatter.field("audio_description_names", &self.audio_description_names);
        formatter.field("caption_description_names", &self.caption_description_names);
        formatter.field("output_name", &self.output_name);
        formatter.field("output_settings", &self.output_settings);
        formatter.field("video_description_name", &self.video_description_name);
        formatter.finish()
    }
}
/// See [`Output`](crate::model::Output)
pub mod output {
    /// A builder for [`Output`](crate::model::Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_description_names: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) caption_description_names:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) output_name: std::option::Option<std::string::String>,
        pub(crate) output_settings: std::option::Option<crate::model::OutputSettings>,
        pub(crate) video_description_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `audio_description_names`.
        ///
        /// To override the contents of this collection use [`set_audio_description_names`](Self::set_audio_description_names).
        ///
        /// The names of the AudioDescriptions used as audio sources for this output.
        pub fn audio_description_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.audio_description_names.unwrap_or_default();
            v.push(input.into());
            self.audio_description_names = Some(v);
            self
        }
        /// The names of the AudioDescriptions used as audio sources for this output.
        pub fn set_audio_description_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.audio_description_names = input;
            self
        }
        /// Appends an item to `caption_description_names`.
        ///
        /// To override the contents of this collection use [`set_caption_description_names`](Self::set_caption_description_names).
        ///
        /// The names of the CaptionDescriptions used as caption sources for this output.
        pub fn caption_description_names(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.caption_description_names.unwrap_or_default();
            v.push(input.into());
            self.caption_description_names = Some(v);
            self
        }
        /// The names of the CaptionDescriptions used as caption sources for this output.
        pub fn set_caption_description_names(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.caption_description_names = input;
            self
        }
        /// The name used to identify an output.
        pub fn output_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_name = Some(input.into());
            self
        }
        /// The name used to identify an output.
        pub fn set_output_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_name = input;
            self
        }
        /// Output type-specific settings.
        pub fn output_settings(mut self, input: crate::model::OutputSettings) -> Self {
            self.output_settings = Some(input);
            self
        }
        /// Output type-specific settings.
        pub fn set_output_settings(
            mut self,
            input: std::option::Option<crate::model::OutputSettings>,
        ) -> Self {
            self.output_settings = input;
            self
        }
        /// The name of the VideoDescription used as the source for this output.
        pub fn video_description_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_description_name = Some(input.into());
            self
        }
        /// The name of the VideoDescription used as the source for this output.
        pub fn set_video_description_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.video_description_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Output`](crate::model::Output)
        pub fn build(self) -> crate::model::Output {
            crate::model::Output {
                audio_description_names: self.audio_description_names,
                caption_description_names: self.caption_description_names,
                output_name: self.output_name,
                output_settings: self.output_settings,
                video_description_name: self.video_description_name,
            }
        }
    }
}
impl Output {
    /// Creates a new builder-style object to manufacture [`Output`](crate::model::Output)
    pub fn builder() -> crate::model::output::Builder {
        crate::model::output::Builder::default()
    }
}

/// Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputSettings {
    /// Archive Output Settings
    pub archive_output_settings: std::option::Option<crate::model::ArchiveOutputSettings>,
    /// Frame Capture Output Settings
    pub frame_capture_output_settings:
        std::option::Option<crate::model::FrameCaptureOutputSettings>,
    /// Hls Output Settings
    pub hls_output_settings: std::option::Option<crate::model::HlsOutputSettings>,
    /// Media Package Output Settings
    pub media_package_output_settings:
        std::option::Option<crate::model::MediaPackageOutputSettings>,
    /// Ms Smooth Output Settings
    pub ms_smooth_output_settings: std::option::Option<crate::model::MsSmoothOutputSettings>,
    /// Multiplex Output Settings
    pub multiplex_output_settings: std::option::Option<crate::model::MultiplexOutputSettings>,
    /// Rtmp Output Settings
    pub rtmp_output_settings: std::option::Option<crate::model::RtmpOutputSettings>,
    /// Udp Output Settings
    pub udp_output_settings: std::option::Option<crate::model::UdpOutputSettings>,
}
impl std::fmt::Debug for OutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputSettings");
        formatter.field("archive_output_settings", &self.archive_output_settings);
        formatter.field(
            "frame_capture_output_settings",
            &self.frame_capture_output_settings,
        );
        formatter.field("hls_output_settings", &self.hls_output_settings);
        formatter.field(
            "media_package_output_settings",
            &self.media_package_output_settings,
        );
        formatter.field("ms_smooth_output_settings", &self.ms_smooth_output_settings);
        formatter.field("multiplex_output_settings", &self.multiplex_output_settings);
        formatter.field("rtmp_output_settings", &self.rtmp_output_settings);
        formatter.field("udp_output_settings", &self.udp_output_settings);
        formatter.finish()
    }
}
/// See [`OutputSettings`](crate::model::OutputSettings)
pub mod output_settings {
    /// A builder for [`OutputSettings`](crate::model::OutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_output_settings:
            std::option::Option<crate::model::ArchiveOutputSettings>,
        pub(crate) frame_capture_output_settings:
            std::option::Option<crate::model::FrameCaptureOutputSettings>,
        pub(crate) hls_output_settings: std::option::Option<crate::model::HlsOutputSettings>,
        pub(crate) media_package_output_settings:
            std::option::Option<crate::model::MediaPackageOutputSettings>,
        pub(crate) ms_smooth_output_settings:
            std::option::Option<crate::model::MsSmoothOutputSettings>,
        pub(crate) multiplex_output_settings:
            std::option::Option<crate::model::MultiplexOutputSettings>,
        pub(crate) rtmp_output_settings: std::option::Option<crate::model::RtmpOutputSettings>,
        pub(crate) udp_output_settings: std::option::Option<crate::model::UdpOutputSettings>,
    }
    impl Builder {
        /// Archive Output Settings
        pub fn archive_output_settings(
            mut self,
            input: crate::model::ArchiveOutputSettings,
        ) -> Self {
            self.archive_output_settings = Some(input);
            self
        }
        /// Archive Output Settings
        pub fn set_archive_output_settings(
            mut self,
            input: std::option::Option<crate::model::ArchiveOutputSettings>,
        ) -> Self {
            self.archive_output_settings = input;
            self
        }
        /// Frame Capture Output Settings
        pub fn frame_capture_output_settings(
            mut self,
            input: crate::model::FrameCaptureOutputSettings,
        ) -> Self {
            self.frame_capture_output_settings = Some(input);
            self
        }
        /// Frame Capture Output Settings
        pub fn set_frame_capture_output_settings(
            mut self,
            input: std::option::Option<crate::model::FrameCaptureOutputSettings>,
        ) -> Self {
            self.frame_capture_output_settings = input;
            self
        }
        /// Hls Output Settings
        pub fn hls_output_settings(mut self, input: crate::model::HlsOutputSettings) -> Self {
            self.hls_output_settings = Some(input);
            self
        }
        /// Hls Output Settings
        pub fn set_hls_output_settings(
            mut self,
            input: std::option::Option<crate::model::HlsOutputSettings>,
        ) -> Self {
            self.hls_output_settings = input;
            self
        }
        /// Media Package Output Settings
        pub fn media_package_output_settings(
            mut self,
            input: crate::model::MediaPackageOutputSettings,
        ) -> Self {
            self.media_package_output_settings = Some(input);
            self
        }
        /// Media Package Output Settings
        pub fn set_media_package_output_settings(
            mut self,
            input: std::option::Option<crate::model::MediaPackageOutputSettings>,
        ) -> Self {
            self.media_package_output_settings = input;
            self
        }
        /// Ms Smooth Output Settings
        pub fn ms_smooth_output_settings(
            mut self,
            input: crate::model::MsSmoothOutputSettings,
        ) -> Self {
            self.ms_smooth_output_settings = Some(input);
            self
        }
        /// Ms Smooth Output Settings
        pub fn set_ms_smooth_output_settings(
            mut self,
            input: std::option::Option<crate::model::MsSmoothOutputSettings>,
        ) -> Self {
            self.ms_smooth_output_settings = input;
            self
        }
        /// Multiplex Output Settings
        pub fn multiplex_output_settings(
            mut self,
            input: crate::model::MultiplexOutputSettings,
        ) -> Self {
            self.multiplex_output_settings = Some(input);
            self
        }
        /// Multiplex Output Settings
        pub fn set_multiplex_output_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexOutputSettings>,
        ) -> Self {
            self.multiplex_output_settings = input;
            self
        }
        /// Rtmp Output Settings
        pub fn rtmp_output_settings(mut self, input: crate::model::RtmpOutputSettings) -> Self {
            self.rtmp_output_settings = Some(input);
            self
        }
        /// Rtmp Output Settings
        pub fn set_rtmp_output_settings(
            mut self,
            input: std::option::Option<crate::model::RtmpOutputSettings>,
        ) -> Self {
            self.rtmp_output_settings = input;
            self
        }
        /// Udp Output Settings
        pub fn udp_output_settings(mut self, input: crate::model::UdpOutputSettings) -> Self {
            self.udp_output_settings = Some(input);
            self
        }
        /// Udp Output Settings
        pub fn set_udp_output_settings(
            mut self,
            input: std::option::Option<crate::model::UdpOutputSettings>,
        ) -> Self {
            self.udp_output_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputSettings`](crate::model::OutputSettings)
        pub fn build(self) -> crate::model::OutputSettings {
            crate::model::OutputSettings {
                archive_output_settings: self.archive_output_settings,
                frame_capture_output_settings: self.frame_capture_output_settings,
                hls_output_settings: self.hls_output_settings,
                media_package_output_settings: self.media_package_output_settings,
                ms_smooth_output_settings: self.ms_smooth_output_settings,
                multiplex_output_settings: self.multiplex_output_settings,
                rtmp_output_settings: self.rtmp_output_settings,
                udp_output_settings: self.udp_output_settings,
            }
        }
    }
}
impl OutputSettings {
    /// Creates a new builder-style object to manufacture [`OutputSettings`](crate::model::OutputSettings)
    pub fn builder() -> crate::model::output_settings::Builder {
        crate::model::output_settings::Builder::default()
    }
}

/// Udp Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UdpOutputSettings {
    /// UDP output buffering in milliseconds. Larger values increase latency through the transcoder but simultaneously assist the transcoder in maintaining a constant, low-jitter UDP/RTP output while accommodating clock recovery, input switching, input disruptions, picture reordering, etc.
    pub buffer_msec: i32,
    /// Udp Container Settings
    pub container_settings: std::option::Option<crate::model::UdpContainerSettings>,
    /// Destination address and port number for RTP or UDP packets. Can be unicast or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
    pub destination: std::option::Option<crate::model::OutputLocationRef>,
    /// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
    pub fec_output_settings: std::option::Option<crate::model::FecOutputSettings>,
}
impl std::fmt::Debug for UdpOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UdpOutputSettings");
        formatter.field("buffer_msec", &self.buffer_msec);
        formatter.field("container_settings", &self.container_settings);
        formatter.field("destination", &self.destination);
        formatter.field("fec_output_settings", &self.fec_output_settings);
        formatter.finish()
    }
}
/// See [`UdpOutputSettings`](crate::model::UdpOutputSettings)
pub mod udp_output_settings {
    /// A builder for [`UdpOutputSettings`](crate::model::UdpOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) buffer_msec: std::option::Option<i32>,
        pub(crate) container_settings: std::option::Option<crate::model::UdpContainerSettings>,
        pub(crate) destination: std::option::Option<crate::model::OutputLocationRef>,
        pub(crate) fec_output_settings: std::option::Option<crate::model::FecOutputSettings>,
    }
    impl Builder {
        /// UDP output buffering in milliseconds. Larger values increase latency through the transcoder but simultaneously assist the transcoder in maintaining a constant, low-jitter UDP/RTP output while accommodating clock recovery, input switching, input disruptions, picture reordering, etc.
        pub fn buffer_msec(mut self, input: i32) -> Self {
            self.buffer_msec = Some(input);
            self
        }
        /// UDP output buffering in milliseconds. Larger values increase latency through the transcoder but simultaneously assist the transcoder in maintaining a constant, low-jitter UDP/RTP output while accommodating clock recovery, input switching, input disruptions, picture reordering, etc.
        pub fn set_buffer_msec(mut self, input: std::option::Option<i32>) -> Self {
            self.buffer_msec = input;
            self
        }
        /// Udp Container Settings
        pub fn container_settings(mut self, input: crate::model::UdpContainerSettings) -> Self {
            self.container_settings = Some(input);
            self
        }
        /// Udp Container Settings
        pub fn set_container_settings(
            mut self,
            input: std::option::Option<crate::model::UdpContainerSettings>,
        ) -> Self {
            self.container_settings = input;
            self
        }
        /// Destination address and port number for RTP or UDP packets. Can be unicast or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
        pub fn destination(mut self, input: crate::model::OutputLocationRef) -> Self {
            self.destination = Some(input);
            self
        }
        /// Destination address and port number for RTP or UDP packets. Can be unicast or multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::OutputLocationRef>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
        pub fn fec_output_settings(mut self, input: crate::model::FecOutputSettings) -> Self {
            self.fec_output_settings = Some(input);
            self
        }
        /// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
        pub fn set_fec_output_settings(
            mut self,
            input: std::option::Option<crate::model::FecOutputSettings>,
        ) -> Self {
            self.fec_output_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UdpOutputSettings`](crate::model::UdpOutputSettings)
        pub fn build(self) -> crate::model::UdpOutputSettings {
            crate::model::UdpOutputSettings {
                buffer_msec: self.buffer_msec.unwrap_or_default(),
                container_settings: self.container_settings,
                destination: self.destination,
                fec_output_settings: self.fec_output_settings,
            }
        }
    }
}
impl UdpOutputSettings {
    /// Creates a new builder-style object to manufacture [`UdpOutputSettings`](crate::model::UdpOutputSettings)
    pub fn builder() -> crate::model::udp_output_settings::Builder {
        crate::model::udp_output_settings::Builder::default()
    }
}

/// Fec Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FecOutputSettings {
    /// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix.  The number of transport stream packets per column error correction packet. Must be between 4 and 20, inclusive.
    pub column_depth: i32,
    /// Enables column only or column and row based FEC
    pub include_fec: std::option::Option<crate::model::FecOutputIncludeFec>,
    /// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix.  Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness.  If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.
    pub row_length: i32,
}
impl std::fmt::Debug for FecOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FecOutputSettings");
        formatter.field("column_depth", &self.column_depth);
        formatter.field("include_fec", &self.include_fec);
        formatter.field("row_length", &self.row_length);
        formatter.finish()
    }
}
/// See [`FecOutputSettings`](crate::model::FecOutputSettings)
pub mod fec_output_settings {
    /// A builder for [`FecOutputSettings`](crate::model::FecOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) column_depth: std::option::Option<i32>,
        pub(crate) include_fec: std::option::Option<crate::model::FecOutputIncludeFec>,
        pub(crate) row_length: std::option::Option<i32>,
    }
    impl Builder {
        /// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix.  The number of transport stream packets per column error correction packet. Must be between 4 and 20, inclusive.
        pub fn column_depth(mut self, input: i32) -> Self {
            self.column_depth = Some(input);
            self
        }
        /// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix.  The number of transport stream packets per column error correction packet. Must be between 4 and 20, inclusive.
        pub fn set_column_depth(mut self, input: std::option::Option<i32>) -> Self {
            self.column_depth = input;
            self
        }
        /// Enables column only or column and row based FEC
        pub fn include_fec(mut self, input: crate::model::FecOutputIncludeFec) -> Self {
            self.include_fec = Some(input);
            self
        }
        /// Enables column only or column and row based FEC
        pub fn set_include_fec(
            mut self,
            input: std::option::Option<crate::model::FecOutputIncludeFec>,
        ) -> Self {
            self.include_fec = input;
            self
        }
        /// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix.  Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness.  If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.
        pub fn row_length(mut self, input: i32) -> Self {
            self.row_length = Some(input);
            self
        }
        /// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix.  Must be between 1 and 20, inclusive. If only Column FEC is used, then larger values increase robustness.  If Row FEC is used, then this is the number of transport stream packets per row error correction packet, and the value must be between 4 and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this value must be 1 to 20, inclusive.
        pub fn set_row_length(mut self, input: std::option::Option<i32>) -> Self {
            self.row_length = input;
            self
        }
        /// Consumes the builder and constructs a [`FecOutputSettings`](crate::model::FecOutputSettings)
        pub fn build(self) -> crate::model::FecOutputSettings {
            crate::model::FecOutputSettings {
                column_depth: self.column_depth.unwrap_or_default(),
                include_fec: self.include_fec,
                row_length: self.row_length.unwrap_or_default(),
            }
        }
    }
}
impl FecOutputSettings {
    /// Creates a new builder-style object to manufacture [`FecOutputSettings`](crate::model::FecOutputSettings)
    pub fn builder() -> crate::model::fec_output_settings::Builder {
        crate::model::fec_output_settings::Builder::default()
    }
}

/// Fec Output Include Fec
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FecOutputIncludeFec {
    #[allow(missing_docs)] // documentation missing in model
    Column,
    #[allow(missing_docs)] // documentation missing in model
    ColumnAndRow,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FecOutputIncludeFec {
    fn from(s: &str) -> Self {
        match s {
            "COLUMN" => FecOutputIncludeFec::Column,
            "COLUMN_AND_ROW" => FecOutputIncludeFec::ColumnAndRow,
            other => FecOutputIncludeFec::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FecOutputIncludeFec {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FecOutputIncludeFec::from(s))
    }
}
impl FecOutputIncludeFec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FecOutputIncludeFec::Column => "COLUMN",
            FecOutputIncludeFec::ColumnAndRow => "COLUMN_AND_ROW",
            FecOutputIncludeFec::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["COLUMN", "COLUMN_AND_ROW"]
    }
}
impl AsRef<str> for FecOutputIncludeFec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Reference to an OutputDestination ID defined in the channel
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputLocationRef {
    /// Placeholder documentation for __string
    pub destination_ref_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for OutputLocationRef {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputLocationRef");
        formatter.field("destination_ref_id", &self.destination_ref_id);
        formatter.finish()
    }
}
/// See [`OutputLocationRef`](crate::model::OutputLocationRef)
pub mod output_location_ref {
    /// A builder for [`OutputLocationRef`](crate::model::OutputLocationRef)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_ref_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Placeholder documentation for __string
        pub fn destination_ref_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_ref_id = Some(input.into());
            self
        }
        /// Placeholder documentation for __string
        pub fn set_destination_ref_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ref_id = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputLocationRef`](crate::model::OutputLocationRef)
        pub fn build(self) -> crate::model::OutputLocationRef {
            crate::model::OutputLocationRef {
                destination_ref_id: self.destination_ref_id,
            }
        }
    }
}
impl OutputLocationRef {
    /// Creates a new builder-style object to manufacture [`OutputLocationRef`](crate::model::OutputLocationRef)
    pub fn builder() -> crate::model::output_location_ref::Builder {
        crate::model::output_location_ref::Builder::default()
    }
}

/// Udp Container Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UdpContainerSettings {
    /// M2ts Settings
    pub m2ts_settings: std::option::Option<crate::model::M2tsSettings>,
}
impl std::fmt::Debug for UdpContainerSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UdpContainerSettings");
        formatter.field("m2ts_settings", &self.m2ts_settings);
        formatter.finish()
    }
}
/// See [`UdpContainerSettings`](crate::model::UdpContainerSettings)
pub mod udp_container_settings {
    /// A builder for [`UdpContainerSettings`](crate::model::UdpContainerSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) m2ts_settings: std::option::Option<crate::model::M2tsSettings>,
    }
    impl Builder {
        /// M2ts Settings
        pub fn m2ts_settings(mut self, input: crate::model::M2tsSettings) -> Self {
            self.m2ts_settings = Some(input);
            self
        }
        /// M2ts Settings
        pub fn set_m2ts_settings(
            mut self,
            input: std::option::Option<crate::model::M2tsSettings>,
        ) -> Self {
            self.m2ts_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`UdpContainerSettings`](crate::model::UdpContainerSettings)
        pub fn build(self) -> crate::model::UdpContainerSettings {
            crate::model::UdpContainerSettings {
                m2ts_settings: self.m2ts_settings,
            }
        }
    }
}
impl UdpContainerSettings {
    /// Creates a new builder-style object to manufacture [`UdpContainerSettings`](crate::model::UdpContainerSettings)
    pub fn builder() -> crate::model::udp_container_settings::Builder {
        crate::model::udp_container_settings::Builder::default()
    }
}

/// M2ts Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct M2tsSettings {
    /// When set to drop, output audio streams will be removed from the program if the selected input audio stream is removed from the input. This allows the output audio configuration to dynamically change based on input configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not connected to an active input stream.
    pub absent_input_audio_behavior:
        std::option::Option<crate::model::M2tsAbsentInputAudioBehavior>,
    /// When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
    pub arib: std::option::Option<crate::model::M2tsArib>,
    /// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub arib_captions_pid: std::option::Option<std::string::String>,
    /// If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids.  If set to useConfigured, ARIB Captions will be on the configured pid number.
    pub arib_captions_pid_control: std::option::Option<crate::model::M2tsAribCaptionsPidControl>,
    /// When set to dvb, uses DVB buffer model for Dolby Digital audio.  When set to atsc, the ATSC model is used.
    pub audio_buffer_model: std::option::Option<crate::model::M2tsAudioBufferModel>,
    /// The number of audio frames to insert for each PES packet.
    pub audio_frames_per_pes: i32,
    /// Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
    pub audio_pids: std::option::Option<std::string::String>,
    /// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream type = 0x06.
    pub audio_stream_type: std::option::Option<crate::model::M2tsAudioStreamType>,
    /// The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate.
    pub bitrate: i32,
    /// Controls the timing accuracy for output network traffic. Leave as MULTIPLEX to ensure accurate network packet timing. Or set to NONE, which might result in lower latency but will result in more variability in output network packet timing. This variability might cause interruptions, jitter, or bursty behavior in your playback or receiving devices.
    pub buffer_model: std::option::Option<crate::model::M2tsBufferModel>,
    /// When set to enabled, generates captionServiceDescriptor in PMT.
    pub cc_descriptor: std::option::Option<crate::model::M2tsCcDescriptor>,
    /// Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
    pub dvb_nit_settings: std::option::Option<crate::model::DvbNitSettings>,
    /// Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
    pub dvb_sdt_settings: std::option::Option<crate::model::DvbSdtSettings>,
    /// Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
    pub dvb_sub_pids: std::option::Option<std::string::String>,
    /// Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
    pub dvb_tdt_settings: std::option::Option<crate::model::DvbTdtSettings>,
    /// Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub dvb_teletext_pid: std::option::Option<std::string::String>,
    /// If set to passthrough, passes any EBIF data from the input source to this output.
    pub ebif: std::option::Option<crate::model::M2tsEbifControl>,
    /// When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. Only available when EBP Cablelabs segmentation markers are selected.  Partitions 1 and 2 will always follow the video interval.
    pub ebp_audio_interval: std::option::Option<crate::model::M2tsAudioInterval>,
    /// When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker.  The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.
    pub ebp_lookahead_ms: i32,
    /// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video PID and all audio PIDs.  If set to videoPid, EBP markers will be placed on only the video PID.
    pub ebp_placement: std::option::Option<crate::model::M2tsEbpPlacement>,
    /// This field is unused and deprecated.
    pub ecm_pid: std::option::Option<std::string::String>,
    /// Include or exclude the ES Rate field in the PES header.
    pub es_rate_in_pes: std::option::Option<crate::model::M2tsEsRateInPes>,
    /// Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub etv_platform_pid: std::option::Option<std::string::String>,
    /// Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub etv_signal_pid: std::option::Option<std::string::String>,
    /// The length in seconds of each fragment. Only used with EBP markers.
    pub fragment_time: f64,
    /// If set to passthrough, passes any KLV data from the input source to this output.
    pub klv: std::option::Option<crate::model::M2tsKlv>,
    /// Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
    pub klv_data_pids: std::option::Option<std::string::String>,
    /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
    pub nielsen_id3_behavior: std::option::Option<crate::model::M2tsNielsenId3Behavior>,
    /// Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.
    pub null_packet_bitrate: f64,
    /// The number of milliseconds between instances of this table in the output transport stream.  Valid values are 0, 10..1000.
    pub pat_interval: i32,
    /// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
    pub pcr_control: std::option::Option<crate::model::M2tsPcrControl>,
    /// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
    pub pcr_period: i32,
    /// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub pcr_pid: std::option::Option<std::string::String>,
    /// The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.
    pub pmt_interval: i32,
    /// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub pmt_pid: std::option::Option<std::string::String>,
    /// The value of the program number field in the Program Map Table.
    pub program_num: i32,
    /// When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
    pub rate_mode: std::option::Option<crate::model::M2tsRateMode>,
    /// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
    pub scte27_pids: std::option::Option<std::string::String>,
    /// Optionally pass SCTE-35 signals from the input source to this output.
    pub scte35_control: std::option::Option<crate::model::M2tsScte35Control>,
    /// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub scte35_pid: std::option::Option<std::string::String>,
    /// Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
    pub segmentation_markers: std::option::Option<crate::model::M2tsSegmentationMarkers>,
    /// The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted.
    ///
    /// When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds.
    ///
    /// When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight exception to this rule.
    pub segmentation_style: std::option::Option<crate::model::M2tsSegmentationStyle>,
    /// The length in seconds of each segment. Required unless markers is set to _none_.
    pub segmentation_time: f64,
    /// When set to passthrough, timed metadata will be passed through from input to output.
    pub timed_metadata_behavior: std::option::Option<crate::model::M2tsTimedMetadataBehavior>,
    /// Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub timed_metadata_pid: std::option::Option<std::string::String>,
    /// The value of the transport stream ID field in the Program Map Table.
    pub transport_stream_id: i32,
    /// Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub video_pid: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for M2tsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("M2tsSettings");
        formatter.field(
            "absent_input_audio_behavior",
            &self.absent_input_audio_behavior,
        );
        formatter.field("arib", &self.arib);
        formatter.field("arib_captions_pid", &self.arib_captions_pid);
        formatter.field("arib_captions_pid_control", &self.arib_captions_pid_control);
        formatter.field("audio_buffer_model", &self.audio_buffer_model);
        formatter.field("audio_frames_per_pes", &self.audio_frames_per_pes);
        formatter.field("audio_pids", &self.audio_pids);
        formatter.field("audio_stream_type", &self.audio_stream_type);
        formatter.field("bitrate", &self.bitrate);
        formatter.field("buffer_model", &self.buffer_model);
        formatter.field("cc_descriptor", &self.cc_descriptor);
        formatter.field("dvb_nit_settings", &self.dvb_nit_settings);
        formatter.field("dvb_sdt_settings", &self.dvb_sdt_settings);
        formatter.field("dvb_sub_pids", &self.dvb_sub_pids);
        formatter.field("dvb_tdt_settings", &self.dvb_tdt_settings);
        formatter.field("dvb_teletext_pid", &self.dvb_teletext_pid);
        formatter.field("ebif", &self.ebif);
        formatter.field("ebp_audio_interval", &self.ebp_audio_interval);
        formatter.field("ebp_lookahead_ms", &self.ebp_lookahead_ms);
        formatter.field("ebp_placement", &self.ebp_placement);
        formatter.field("ecm_pid", &self.ecm_pid);
        formatter.field("es_rate_in_pes", &self.es_rate_in_pes);
        formatter.field("etv_platform_pid", &self.etv_platform_pid);
        formatter.field("etv_signal_pid", &self.etv_signal_pid);
        formatter.field("fragment_time", &self.fragment_time);
        formatter.field("klv", &self.klv);
        formatter.field("klv_data_pids", &self.klv_data_pids);
        formatter.field("nielsen_id3_behavior", &self.nielsen_id3_behavior);
        formatter.field("null_packet_bitrate", &self.null_packet_bitrate);
        formatter.field("pat_interval", &self.pat_interval);
        formatter.field("pcr_control", &self.pcr_control);
        formatter.field("pcr_period", &self.pcr_period);
        formatter.field("pcr_pid", &self.pcr_pid);
        formatter.field("pmt_interval", &self.pmt_interval);
        formatter.field("pmt_pid", &self.pmt_pid);
        formatter.field("program_num", &self.program_num);
        formatter.field("rate_mode", &self.rate_mode);
        formatter.field("scte27_pids", &self.scte27_pids);
        formatter.field("scte35_control", &self.scte35_control);
        formatter.field("scte35_pid", &self.scte35_pid);
        formatter.field("segmentation_markers", &self.segmentation_markers);
        formatter.field("segmentation_style", &self.segmentation_style);
        formatter.field("segmentation_time", &self.segmentation_time);
        formatter.field("timed_metadata_behavior", &self.timed_metadata_behavior);
        formatter.field("timed_metadata_pid", &self.timed_metadata_pid);
        formatter.field("transport_stream_id", &self.transport_stream_id);
        formatter.field("video_pid", &self.video_pid);
        formatter.finish()
    }
}
/// See [`M2tsSettings`](crate::model::M2tsSettings)
pub mod m2ts_settings {
    /// A builder for [`M2tsSettings`](crate::model::M2tsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) absent_input_audio_behavior:
            std::option::Option<crate::model::M2tsAbsentInputAudioBehavior>,
        pub(crate) arib: std::option::Option<crate::model::M2tsArib>,
        pub(crate) arib_captions_pid: std::option::Option<std::string::String>,
        pub(crate) arib_captions_pid_control:
            std::option::Option<crate::model::M2tsAribCaptionsPidControl>,
        pub(crate) audio_buffer_model: std::option::Option<crate::model::M2tsAudioBufferModel>,
        pub(crate) audio_frames_per_pes: std::option::Option<i32>,
        pub(crate) audio_pids: std::option::Option<std::string::String>,
        pub(crate) audio_stream_type: std::option::Option<crate::model::M2tsAudioStreamType>,
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) buffer_model: std::option::Option<crate::model::M2tsBufferModel>,
        pub(crate) cc_descriptor: std::option::Option<crate::model::M2tsCcDescriptor>,
        pub(crate) dvb_nit_settings: std::option::Option<crate::model::DvbNitSettings>,
        pub(crate) dvb_sdt_settings: std::option::Option<crate::model::DvbSdtSettings>,
        pub(crate) dvb_sub_pids: std::option::Option<std::string::String>,
        pub(crate) dvb_tdt_settings: std::option::Option<crate::model::DvbTdtSettings>,
        pub(crate) dvb_teletext_pid: std::option::Option<std::string::String>,
        pub(crate) ebif: std::option::Option<crate::model::M2tsEbifControl>,
        pub(crate) ebp_audio_interval: std::option::Option<crate::model::M2tsAudioInterval>,
        pub(crate) ebp_lookahead_ms: std::option::Option<i32>,
        pub(crate) ebp_placement: std::option::Option<crate::model::M2tsEbpPlacement>,
        pub(crate) ecm_pid: std::option::Option<std::string::String>,
        pub(crate) es_rate_in_pes: std::option::Option<crate::model::M2tsEsRateInPes>,
        pub(crate) etv_platform_pid: std::option::Option<std::string::String>,
        pub(crate) etv_signal_pid: std::option::Option<std::string::String>,
        pub(crate) fragment_time: std::option::Option<f64>,
        pub(crate) klv: std::option::Option<crate::model::M2tsKlv>,
        pub(crate) klv_data_pids: std::option::Option<std::string::String>,
        pub(crate) nielsen_id3_behavior: std::option::Option<crate::model::M2tsNielsenId3Behavior>,
        pub(crate) null_packet_bitrate: std::option::Option<f64>,
        pub(crate) pat_interval: std::option::Option<i32>,
        pub(crate) pcr_control: std::option::Option<crate::model::M2tsPcrControl>,
        pub(crate) pcr_period: std::option::Option<i32>,
        pub(crate) pcr_pid: std::option::Option<std::string::String>,
        pub(crate) pmt_interval: std::option::Option<i32>,
        pub(crate) pmt_pid: std::option::Option<std::string::String>,
        pub(crate) program_num: std::option::Option<i32>,
        pub(crate) rate_mode: std::option::Option<crate::model::M2tsRateMode>,
        pub(crate) scte27_pids: std::option::Option<std::string::String>,
        pub(crate) scte35_control: std::option::Option<crate::model::M2tsScte35Control>,
        pub(crate) scte35_pid: std::option::Option<std::string::String>,
        pub(crate) segmentation_markers: std::option::Option<crate::model::M2tsSegmentationMarkers>,
        pub(crate) segmentation_style: std::option::Option<crate::model::M2tsSegmentationStyle>,
        pub(crate) segmentation_time: std::option::Option<f64>,
        pub(crate) timed_metadata_behavior:
            std::option::Option<crate::model::M2tsTimedMetadataBehavior>,
        pub(crate) timed_metadata_pid: std::option::Option<std::string::String>,
        pub(crate) transport_stream_id: std::option::Option<i32>,
        pub(crate) video_pid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// When set to drop, output audio streams will be removed from the program if the selected input audio stream is removed from the input. This allows the output audio configuration to dynamically change based on input configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not connected to an active input stream.
        pub fn absent_input_audio_behavior(
            mut self,
            input: crate::model::M2tsAbsentInputAudioBehavior,
        ) -> Self {
            self.absent_input_audio_behavior = Some(input);
            self
        }
        /// When set to drop, output audio streams will be removed from the program if the selected input audio stream is removed from the input. This allows the output audio configuration to dynamically change based on input configuration. If this is set to encodeSilence, all output audio streams will output encoded silence when not connected to an active input stream.
        pub fn set_absent_input_audio_behavior(
            mut self,
            input: std::option::Option<crate::model::M2tsAbsentInputAudioBehavior>,
        ) -> Self {
            self.absent_input_audio_behavior = input;
            self
        }
        /// When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
        pub fn arib(mut self, input: crate::model::M2tsArib) -> Self {
            self.arib = Some(input);
            self
        }
        /// When set to enabled, uses ARIB-compliant field muxing and removes video descriptor.
        pub fn set_arib(mut self, input: std::option::Option<crate::model::M2tsArib>) -> Self {
            self.arib = input;
            self
        }
        /// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn arib_captions_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.arib_captions_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_arib_captions_pid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.arib_captions_pid = input;
            self
        }
        /// If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids.  If set to useConfigured, ARIB Captions will be on the configured pid number.
        pub fn arib_captions_pid_control(
            mut self,
            input: crate::model::M2tsAribCaptionsPidControl,
        ) -> Self {
            self.arib_captions_pid_control = Some(input);
            self
        }
        /// If set to auto, pid number used for ARIB Captions will be auto-selected from unused pids.  If set to useConfigured, ARIB Captions will be on the configured pid number.
        pub fn set_arib_captions_pid_control(
            mut self,
            input: std::option::Option<crate::model::M2tsAribCaptionsPidControl>,
        ) -> Self {
            self.arib_captions_pid_control = input;
            self
        }
        /// When set to dvb, uses DVB buffer model for Dolby Digital audio.  When set to atsc, the ATSC model is used.
        pub fn audio_buffer_model(mut self, input: crate::model::M2tsAudioBufferModel) -> Self {
            self.audio_buffer_model = Some(input);
            self
        }
        /// When set to dvb, uses DVB buffer model for Dolby Digital audio.  When set to atsc, the ATSC model is used.
        pub fn set_audio_buffer_model(
            mut self,
            input: std::option::Option<crate::model::M2tsAudioBufferModel>,
        ) -> Self {
            self.audio_buffer_model = input;
            self
        }
        /// The number of audio frames to insert for each PES packet.
        pub fn audio_frames_per_pes(mut self, input: i32) -> Self {
            self.audio_frames_per_pes = Some(input);
            self
        }
        /// The number of audio frames to insert for each PES packet.
        pub fn set_audio_frames_per_pes(mut self, input: std::option::Option<i32>) -> Self {
            self.audio_frames_per_pes = input;
            self
        }
        /// Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn audio_pids(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_pids = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values. Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_audio_pids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.audio_pids = input;
            self
        }
        /// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream type = 0x06.
        pub fn audio_stream_type(mut self, input: crate::model::M2tsAudioStreamType) -> Self {
            self.audio_stream_type = Some(input);
            self
        }
        /// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for EAC3. When set to dvb, uses stream type = 0x06.
        pub fn set_audio_stream_type(
            mut self,
            input: std::option::Option<crate::model::M2tsAudioStreamType>,
        ) -> Self {
            self.audio_stream_type = input;
            self
        }
        /// The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// The output bitrate of the transport stream in bits per second. Setting to 0 lets the muxer automatically determine the appropriate bitrate.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// Controls the timing accuracy for output network traffic. Leave as MULTIPLEX to ensure accurate network packet timing. Or set to NONE, which might result in lower latency but will result in more variability in output network packet timing. This variability might cause interruptions, jitter, or bursty behavior in your playback or receiving devices.
        pub fn buffer_model(mut self, input: crate::model::M2tsBufferModel) -> Self {
            self.buffer_model = Some(input);
            self
        }
        /// Controls the timing accuracy for output network traffic. Leave as MULTIPLEX to ensure accurate network packet timing. Or set to NONE, which might result in lower latency but will result in more variability in output network packet timing. This variability might cause interruptions, jitter, or bursty behavior in your playback or receiving devices.
        pub fn set_buffer_model(
            mut self,
            input: std::option::Option<crate::model::M2tsBufferModel>,
        ) -> Self {
            self.buffer_model = input;
            self
        }
        /// When set to enabled, generates captionServiceDescriptor in PMT.
        pub fn cc_descriptor(mut self, input: crate::model::M2tsCcDescriptor) -> Self {
            self.cc_descriptor = Some(input);
            self
        }
        /// When set to enabled, generates captionServiceDescriptor in PMT.
        pub fn set_cc_descriptor(
            mut self,
            input: std::option::Option<crate::model::M2tsCcDescriptor>,
        ) -> Self {
            self.cc_descriptor = input;
            self
        }
        /// Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
        pub fn dvb_nit_settings(mut self, input: crate::model::DvbNitSettings) -> Self {
            self.dvb_nit_settings = Some(input);
            self
        }
        /// Inserts DVB Network Information Table (NIT) at the specified table repetition interval.
        pub fn set_dvb_nit_settings(
            mut self,
            input: std::option::Option<crate::model::DvbNitSettings>,
        ) -> Self {
            self.dvb_nit_settings = input;
            self
        }
        /// Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
        pub fn dvb_sdt_settings(mut self, input: crate::model::DvbSdtSettings) -> Self {
            self.dvb_sdt_settings = Some(input);
            self
        }
        /// Inserts DVB Service Description Table (SDT) at the specified table repetition interval.
        pub fn set_dvb_sdt_settings(
            mut self,
            input: std::option::Option<crate::model::DvbSdtSettings>,
        ) -> Self {
            self.dvb_sdt_settings = input;
            self
        }
        /// Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn dvb_sub_pids(mut self, input: impl Into<std::string::String>) -> Self {
            self.dvb_sub_pids = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for input source DVB Subtitle data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_dvb_sub_pids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dvb_sub_pids = input;
            self
        }
        /// Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
        pub fn dvb_tdt_settings(mut self, input: crate::model::DvbTdtSettings) -> Self {
            self.dvb_tdt_settings = Some(input);
            self
        }
        /// Inserts DVB Time and Date Table (TDT) at the specified table repetition interval.
        pub fn set_dvb_tdt_settings(
            mut self,
            input: std::option::Option<crate::model::DvbTdtSettings>,
        ) -> Self {
            self.dvb_tdt_settings = input;
            self
        }
        /// Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn dvb_teletext_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.dvb_teletext_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for input source DVB Teletext data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_dvb_teletext_pid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.dvb_teletext_pid = input;
            self
        }
        /// If set to passthrough, passes any EBIF data from the input source to this output.
        pub fn ebif(mut self, input: crate::model::M2tsEbifControl) -> Self {
            self.ebif = Some(input);
            self
        }
        /// If set to passthrough, passes any EBIF data from the input source to this output.
        pub fn set_ebif(
            mut self,
            input: std::option::Option<crate::model::M2tsEbifControl>,
        ) -> Self {
            self.ebif = input;
            self
        }
        /// When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. Only available when EBP Cablelabs segmentation markers are selected.  Partitions 1 and 2 will always follow the video interval.
        pub fn ebp_audio_interval(mut self, input: crate::model::M2tsAudioInterval) -> Self {
            self.ebp_audio_interval = Some(input);
            self
        }
        /// When videoAndFixedIntervals is selected, audio EBP markers will be added to partitions 3 and 4. The interval between these additional markers will be fixed, and will be slightly shorter than the video EBP marker interval. Only available when EBP Cablelabs segmentation markers are selected.  Partitions 1 and 2 will always follow the video interval.
        pub fn set_ebp_audio_interval(
            mut self,
            input: std::option::Option<crate::model::M2tsAudioInterval>,
        ) -> Self {
            self.ebp_audio_interval = input;
            self
        }
        /// When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker.  The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.
        pub fn ebp_lookahead_ms(mut self, input: i32) -> Self {
            self.ebp_lookahead_ms = Some(input);
            self
        }
        /// When set, enforces that Encoder Boundary Points do not come within the specified time interval of each other by looking ahead at input video. If another EBP is going to come in within the specified time interval, the current EBP is not emitted, and the segment is "stretched" to the next marker.  The lookahead value does not add latency to the system. The Live Event must be configured elsewhere to create sufficient latency to make the lookahead accurate.
        pub fn set_ebp_lookahead_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.ebp_lookahead_ms = input;
            self
        }
        /// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video PID and all audio PIDs.  If set to videoPid, EBP markers will be placed on only the video PID.
        pub fn ebp_placement(mut self, input: crate::model::M2tsEbpPlacement) -> Self {
            self.ebp_placement = Some(input);
            self
        }
        /// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP markers will be placed on the video PID and all audio PIDs.  If set to videoPid, EBP markers will be placed on only the video PID.
        pub fn set_ebp_placement(
            mut self,
            input: std::option::Option<crate::model::M2tsEbpPlacement>,
        ) -> Self {
            self.ebp_placement = input;
            self
        }
        /// This field is unused and deprecated.
        pub fn ecm_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecm_pid = Some(input.into());
            self
        }
        /// This field is unused and deprecated.
        pub fn set_ecm_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ecm_pid = input;
            self
        }
        /// Include or exclude the ES Rate field in the PES header.
        pub fn es_rate_in_pes(mut self, input: crate::model::M2tsEsRateInPes) -> Self {
            self.es_rate_in_pes = Some(input);
            self
        }
        /// Include or exclude the ES Rate field in the PES header.
        pub fn set_es_rate_in_pes(
            mut self,
            input: std::option::Option<crate::model::M2tsEsRateInPes>,
        ) -> Self {
            self.es_rate_in_pes = input;
            self
        }
        /// Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn etv_platform_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.etv_platform_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for input source ETV Platform data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_etv_platform_pid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.etv_platform_pid = input;
            self
        }
        /// Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn etv_signal_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.etv_signal_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for input source ETV Signal data to this output. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_etv_signal_pid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.etv_signal_pid = input;
            self
        }
        /// The length in seconds of each fragment. Only used with EBP markers.
        pub fn fragment_time(mut self, input: f64) -> Self {
            self.fragment_time = Some(input);
            self
        }
        /// The length in seconds of each fragment. Only used with EBP markers.
        pub fn set_fragment_time(mut self, input: std::option::Option<f64>) -> Self {
            self.fragment_time = input;
            self
        }
        /// If set to passthrough, passes any KLV data from the input source to this output.
        pub fn klv(mut self, input: crate::model::M2tsKlv) -> Self {
            self.klv = Some(input);
            self
        }
        /// If set to passthrough, passes any KLV data from the input source to this output.
        pub fn set_klv(mut self, input: std::option::Option<crate::model::M2tsKlv>) -> Self {
            self.klv = input;
            self
        }
        /// Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn klv_data_pids(mut self, input: impl Into<std::string::String>) -> Self {
            self.klv_data_pids = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for input source KLV data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_klv_data_pids(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.klv_data_pids = input;
            self
        }
        /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
        pub fn nielsen_id3_behavior(mut self, input: crate::model::M2tsNielsenId3Behavior) -> Self {
            self.nielsen_id3_behavior = Some(input);
            self
        }
        /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
        pub fn set_nielsen_id3_behavior(
            mut self,
            input: std::option::Option<crate::model::M2tsNielsenId3Behavior>,
        ) -> Self {
            self.nielsen_id3_behavior = input;
            self
        }
        /// Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.
        pub fn null_packet_bitrate(mut self, input: f64) -> Self {
            self.null_packet_bitrate = Some(input);
            self
        }
        /// Value in bits per second of extra null packets to insert into the transport stream. This can be used if a downstream encryption system requires periodic null packets.
        pub fn set_null_packet_bitrate(mut self, input: std::option::Option<f64>) -> Self {
            self.null_packet_bitrate = input;
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.  Valid values are 0, 10..1000.
        pub fn pat_interval(mut self, input: i32) -> Self {
            self.pat_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.  Valid values are 0, 10..1000.
        pub fn set_pat_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.pat_interval = input;
            self
        }
        /// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
        pub fn pcr_control(mut self, input: crate::model::M2tsPcrControl) -> Self {
            self.pcr_control = Some(input);
            self
        }
        /// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
        pub fn set_pcr_control(
            mut self,
            input: std::option::Option<crate::model::M2tsPcrControl>,
        ) -> Self {
            self.pcr_control = input;
            self
        }
        /// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
        pub fn pcr_period(mut self, input: i32) -> Self {
            self.pcr_period = Some(input);
            self
        }
        /// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted into the transport stream.
        pub fn set_pcr_period(mut self, input: std::option::Option<i32>) -> Self {
            self.pcr_period = input;
            self
        }
        /// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn pcr_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.pcr_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_pcr_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pcr_pid = input;
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.
        pub fn pmt_interval(mut self, input: i32) -> Self {
            self.pmt_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream. Valid values are 0, 10..1000.
        pub fn set_pmt_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.pmt_interval = input;
            self
        }
        /// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn pmt_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.pmt_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_pmt_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pmt_pid = input;
            self
        }
        /// The value of the program number field in the Program Map Table.
        pub fn program_num(mut self, input: i32) -> Self {
            self.program_num = Some(input);
            self
        }
        /// The value of the program number field in the Program Map Table.
        pub fn set_program_num(mut self, input: std::option::Option<i32>) -> Self {
            self.program_num = input;
            self
        }
        /// When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
        pub fn rate_mode(mut self, input: crate::model::M2tsRateMode) -> Self {
            self.rate_mode = Some(input);
            self
        }
        /// When vbr, does not insert null packets into transport stream to fill specified bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
        pub fn set_rate_mode(
            mut self,
            input: std::option::Option<crate::model::M2tsRateMode>,
        ) -> Self {
            self.rate_mode = input;
            self
        }
        /// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn scte27_pids(mut self, input: impl Into<std::string::String>) -> Self {
            self.scte27_pids = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.  Each PID specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_scte27_pids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scte27_pids = input;
            self
        }
        /// Optionally pass SCTE-35 signals from the input source to this output.
        pub fn scte35_control(mut self, input: crate::model::M2tsScte35Control) -> Self {
            self.scte35_control = Some(input);
            self
        }
        /// Optionally pass SCTE-35 signals from the input source to this output.
        pub fn set_scte35_control(
            mut self,
            input: std::option::Option<crate::model::M2tsScte35Control>,
        ) -> Self {
            self.scte35_control = input;
            self
        }
        /// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn scte35_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.scte35_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_scte35_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scte35_pid = input;
            self
        }
        /// Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
        pub fn segmentation_markers(
            mut self,
            input: crate::model::M2tsSegmentationMarkers,
        ) -> Self {
            self.segmentation_markers = Some(input);
            self
        }
        /// Inserts segmentation markers at each segmentationTime period. raiSegstart sets the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI bit and adds the current timecode in the private data bytes. psiSegstart inserts PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point information to the adaptation field as per OpenCable specification OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the adaptation field using a legacy proprietary format.
        pub fn set_segmentation_markers(
            mut self,
            input: std::option::Option<crate::model::M2tsSegmentationMarkers>,
        ) -> Self {
            self.segmentation_markers = input;
            self
        }
        /// The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted.
        ///
        /// When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds.
        ///
        /// When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight exception to this rule.
        pub fn segmentation_style(mut self, input: crate::model::M2tsSegmentationStyle) -> Self {
            self.segmentation_style = Some(input);
            self
        }
        /// The segmentation style parameter controls how segmentation markers are inserted into the transport stream. With avails, it is possible that segments may be truncated, which can influence where future segmentation markers are inserted.
        ///
        /// When a segmentation style of "resetCadence" is selected and a segment is truncated due to an avail, we will reset the segmentation cadence. This means the subsequent segment will have a duration of $segmentationTime seconds.
        ///
        /// When a segmentation style of "maintainCadence" is selected and a segment is truncated due to an avail, we will not reset the segmentation cadence. This means the subsequent segment will likely be truncated as well. However, all segments after that will have a duration of $segmentationTime seconds. Note that EBP lookahead is a slight exception to this rule.
        pub fn set_segmentation_style(
            mut self,
            input: std::option::Option<crate::model::M2tsSegmentationStyle>,
        ) -> Self {
            self.segmentation_style = input;
            self
        }
        /// The length in seconds of each segment. Required unless markers is set to _none_.
        pub fn segmentation_time(mut self, input: f64) -> Self {
            self.segmentation_time = Some(input);
            self
        }
        /// The length in seconds of each segment. Required unless markers is set to _none_.
        pub fn set_segmentation_time(mut self, input: std::option::Option<f64>) -> Self {
            self.segmentation_time = input;
            self
        }
        /// When set to passthrough, timed metadata will be passed through from input to output.
        pub fn timed_metadata_behavior(
            mut self,
            input: crate::model::M2tsTimedMetadataBehavior,
        ) -> Self {
            self.timed_metadata_behavior = Some(input);
            self
        }
        /// When set to passthrough, timed metadata will be passed through from input to output.
        pub fn set_timed_metadata_behavior(
            mut self,
            input: std::option::Option<crate::model::M2tsTimedMetadataBehavior>,
        ) -> Self {
            self.timed_metadata_behavior = input;
            self
        }
        /// Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn timed_metadata_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.timed_metadata_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_timed_metadata_pid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timed_metadata_pid = input;
            self
        }
        /// The value of the transport stream ID field in the Program Map Table.
        pub fn transport_stream_id(mut self, input: i32) -> Self {
            self.transport_stream_id = Some(input);
            self
        }
        /// The value of the transport stream ID field in the Program Map Table.
        pub fn set_transport_stream_id(mut self, input: std::option::Option<i32>) -> Self {
            self.transport_stream_id = input;
            self
        }
        /// Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn video_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_video_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.video_pid = input;
            self
        }
        /// Consumes the builder and constructs a [`M2tsSettings`](crate::model::M2tsSettings)
        pub fn build(self) -> crate::model::M2tsSettings {
            crate::model::M2tsSettings {
                absent_input_audio_behavior: self.absent_input_audio_behavior,
                arib: self.arib,
                arib_captions_pid: self.arib_captions_pid,
                arib_captions_pid_control: self.arib_captions_pid_control,
                audio_buffer_model: self.audio_buffer_model,
                audio_frames_per_pes: self.audio_frames_per_pes.unwrap_or_default(),
                audio_pids: self.audio_pids,
                audio_stream_type: self.audio_stream_type,
                bitrate: self.bitrate.unwrap_or_default(),
                buffer_model: self.buffer_model,
                cc_descriptor: self.cc_descriptor,
                dvb_nit_settings: self.dvb_nit_settings,
                dvb_sdt_settings: self.dvb_sdt_settings,
                dvb_sub_pids: self.dvb_sub_pids,
                dvb_tdt_settings: self.dvb_tdt_settings,
                dvb_teletext_pid: self.dvb_teletext_pid,
                ebif: self.ebif,
                ebp_audio_interval: self.ebp_audio_interval,
                ebp_lookahead_ms: self.ebp_lookahead_ms.unwrap_or_default(),
                ebp_placement: self.ebp_placement,
                ecm_pid: self.ecm_pid,
                es_rate_in_pes: self.es_rate_in_pes,
                etv_platform_pid: self.etv_platform_pid,
                etv_signal_pid: self.etv_signal_pid,
                fragment_time: self.fragment_time.unwrap_or_default(),
                klv: self.klv,
                klv_data_pids: self.klv_data_pids,
                nielsen_id3_behavior: self.nielsen_id3_behavior,
                null_packet_bitrate: self.null_packet_bitrate.unwrap_or_default(),
                pat_interval: self.pat_interval.unwrap_or_default(),
                pcr_control: self.pcr_control,
                pcr_period: self.pcr_period.unwrap_or_default(),
                pcr_pid: self.pcr_pid,
                pmt_interval: self.pmt_interval.unwrap_or_default(),
                pmt_pid: self.pmt_pid,
                program_num: self.program_num.unwrap_or_default(),
                rate_mode: self.rate_mode,
                scte27_pids: self.scte27_pids,
                scte35_control: self.scte35_control,
                scte35_pid: self.scte35_pid,
                segmentation_markers: self.segmentation_markers,
                segmentation_style: self.segmentation_style,
                segmentation_time: self.segmentation_time.unwrap_or_default(),
                timed_metadata_behavior: self.timed_metadata_behavior,
                timed_metadata_pid: self.timed_metadata_pid,
                transport_stream_id: self.transport_stream_id.unwrap_or_default(),
                video_pid: self.video_pid,
            }
        }
    }
}
impl M2tsSettings {
    /// Creates a new builder-style object to manufacture [`M2tsSettings`](crate::model::M2tsSettings)
    pub fn builder() -> crate::model::m2ts_settings::Builder {
        crate::model::m2ts_settings::Builder::default()
    }
}

/// M2ts Timed Metadata Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsTimedMetadataBehavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsTimedMetadataBehavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => M2tsTimedMetadataBehavior::NoPassthrough,
            "PASSTHROUGH" => M2tsTimedMetadataBehavior::Passthrough,
            other => M2tsTimedMetadataBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsTimedMetadataBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsTimedMetadataBehavior::from(s))
    }
}
impl M2tsTimedMetadataBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsTimedMetadataBehavior::NoPassthrough => "NO_PASSTHROUGH",
            M2tsTimedMetadataBehavior::Passthrough => "PASSTHROUGH",
            M2tsTimedMetadataBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M2tsTimedMetadataBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Segmentation Style
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsSegmentationStyle {
    #[allow(missing_docs)] // documentation missing in model
    MaintainCadence,
    #[allow(missing_docs)] // documentation missing in model
    ResetCadence,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsSegmentationStyle {
    fn from(s: &str) -> Self {
        match s {
            "MAINTAIN_CADENCE" => M2tsSegmentationStyle::MaintainCadence,
            "RESET_CADENCE" => M2tsSegmentationStyle::ResetCadence,
            other => M2tsSegmentationStyle::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsSegmentationStyle {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsSegmentationStyle::from(s))
    }
}
impl M2tsSegmentationStyle {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsSegmentationStyle::MaintainCadence => "MAINTAIN_CADENCE",
            M2tsSegmentationStyle::ResetCadence => "RESET_CADENCE",
            M2tsSegmentationStyle::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAINTAIN_CADENCE", "RESET_CADENCE"]
    }
}
impl AsRef<str> for M2tsSegmentationStyle {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Segmentation Markers
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsSegmentationMarkers {
    #[allow(missing_docs)] // documentation missing in model
    Ebp,
    #[allow(missing_docs)] // documentation missing in model
    EbpLegacy,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    PsiSegstart,
    #[allow(missing_docs)] // documentation missing in model
    RaiAdapt,
    #[allow(missing_docs)] // documentation missing in model
    RaiSegstart,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsSegmentationMarkers {
    fn from(s: &str) -> Self {
        match s {
            "EBP" => M2tsSegmentationMarkers::Ebp,
            "EBP_LEGACY" => M2tsSegmentationMarkers::EbpLegacy,
            "NONE" => M2tsSegmentationMarkers::None,
            "PSI_SEGSTART" => M2tsSegmentationMarkers::PsiSegstart,
            "RAI_ADAPT" => M2tsSegmentationMarkers::RaiAdapt,
            "RAI_SEGSTART" => M2tsSegmentationMarkers::RaiSegstart,
            other => M2tsSegmentationMarkers::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsSegmentationMarkers {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsSegmentationMarkers::from(s))
    }
}
impl M2tsSegmentationMarkers {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsSegmentationMarkers::Ebp => "EBP",
            M2tsSegmentationMarkers::EbpLegacy => "EBP_LEGACY",
            M2tsSegmentationMarkers::None => "NONE",
            M2tsSegmentationMarkers::PsiSegstart => "PSI_SEGSTART",
            M2tsSegmentationMarkers::RaiAdapt => "RAI_ADAPT",
            M2tsSegmentationMarkers::RaiSegstart => "RAI_SEGSTART",
            M2tsSegmentationMarkers::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "EBP",
            "EBP_LEGACY",
            "NONE",
            "PSI_SEGSTART",
            "RAI_ADAPT",
            "RAI_SEGSTART",
        ]
    }
}
impl AsRef<str> for M2tsSegmentationMarkers {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Scte35 Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsScte35Control {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsScte35Control {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => M2tsScte35Control::None,
            "PASSTHROUGH" => M2tsScte35Control::Passthrough,
            other => M2tsScte35Control::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsScte35Control {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsScte35Control::from(s))
    }
}
impl M2tsScte35Control {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsScte35Control::None => "NONE",
            M2tsScte35Control::Passthrough => "PASSTHROUGH",
            M2tsScte35Control::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M2tsScte35Control {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Rate Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsRateMode {
    #[allow(missing_docs)] // documentation missing in model
    Cbr,
    #[allow(missing_docs)] // documentation missing in model
    Vbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsRateMode {
    fn from(s: &str) -> Self {
        match s {
            "CBR" => M2tsRateMode::Cbr,
            "VBR" => M2tsRateMode::Vbr,
            other => M2tsRateMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsRateMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsRateMode::from(s))
    }
}
impl M2tsRateMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsRateMode::Cbr => "CBR",
            M2tsRateMode::Vbr => "VBR",
            M2tsRateMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CBR", "VBR"]
    }
}
impl AsRef<str> for M2tsRateMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Pcr Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsPcrControl {
    #[allow(missing_docs)] // documentation missing in model
    ConfiguredPcrPeriod,
    #[allow(missing_docs)] // documentation missing in model
    PcrEveryPesPacket,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsPcrControl {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURED_PCR_PERIOD" => M2tsPcrControl::ConfiguredPcrPeriod,
            "PCR_EVERY_PES_PACKET" => M2tsPcrControl::PcrEveryPesPacket,
            other => M2tsPcrControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsPcrControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsPcrControl::from(s))
    }
}
impl M2tsPcrControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsPcrControl::ConfiguredPcrPeriod => "CONFIGURED_PCR_PERIOD",
            M2tsPcrControl::PcrEveryPesPacket => "PCR_EVERY_PES_PACKET",
            M2tsPcrControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIGURED_PCR_PERIOD", "PCR_EVERY_PES_PACKET"]
    }
}
impl AsRef<str> for M2tsPcrControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Nielsen Id3 Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsNielsenId3Behavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsNielsenId3Behavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => M2tsNielsenId3Behavior::NoPassthrough,
            "PASSTHROUGH" => M2tsNielsenId3Behavior::Passthrough,
            other => M2tsNielsenId3Behavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsNielsenId3Behavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsNielsenId3Behavior::from(s))
    }
}
impl M2tsNielsenId3Behavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsNielsenId3Behavior::NoPassthrough => "NO_PASSTHROUGH",
            M2tsNielsenId3Behavior::Passthrough => "PASSTHROUGH",
            M2tsNielsenId3Behavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M2tsNielsenId3Behavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Klv
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsKlv {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsKlv {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => M2tsKlv::None,
            "PASSTHROUGH" => M2tsKlv::Passthrough,
            other => M2tsKlv::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsKlv {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsKlv::from(s))
    }
}
impl M2tsKlv {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsKlv::None => "NONE",
            M2tsKlv::Passthrough => "PASSTHROUGH",
            M2tsKlv::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M2tsKlv {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Es Rate In Pes
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsEsRateInPes {
    #[allow(missing_docs)] // documentation missing in model
    Exclude,
    #[allow(missing_docs)] // documentation missing in model
    Include,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsEsRateInPes {
    fn from(s: &str) -> Self {
        match s {
            "EXCLUDE" => M2tsEsRateInPes::Exclude,
            "INCLUDE" => M2tsEsRateInPes::Include,
            other => M2tsEsRateInPes::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsEsRateInPes {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsEsRateInPes::from(s))
    }
}
impl M2tsEsRateInPes {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsEsRateInPes::Exclude => "EXCLUDE",
            M2tsEsRateInPes::Include => "INCLUDE",
            M2tsEsRateInPes::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXCLUDE", "INCLUDE"]
    }
}
impl AsRef<str> for M2tsEsRateInPes {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Ebp Placement
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsEbpPlacement {
    #[allow(missing_docs)] // documentation missing in model
    VideoAndAudioPids,
    #[allow(missing_docs)] // documentation missing in model
    VideoPid,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsEbpPlacement {
    fn from(s: &str) -> Self {
        match s {
            "VIDEO_AND_AUDIO_PIDS" => M2tsEbpPlacement::VideoAndAudioPids,
            "VIDEO_PID" => M2tsEbpPlacement::VideoPid,
            other => M2tsEbpPlacement::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsEbpPlacement {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsEbpPlacement::from(s))
    }
}
impl M2tsEbpPlacement {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsEbpPlacement::VideoAndAudioPids => "VIDEO_AND_AUDIO_PIDS",
            M2tsEbpPlacement::VideoPid => "VIDEO_PID",
            M2tsEbpPlacement::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VIDEO_AND_AUDIO_PIDS", "VIDEO_PID"]
    }
}
impl AsRef<str> for M2tsEbpPlacement {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Audio Interval
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsAudioInterval {
    #[allow(missing_docs)] // documentation missing in model
    VideoAndFixedIntervals,
    #[allow(missing_docs)] // documentation missing in model
    VideoInterval,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsAudioInterval {
    fn from(s: &str) -> Self {
        match s {
            "VIDEO_AND_FIXED_INTERVALS" => M2tsAudioInterval::VideoAndFixedIntervals,
            "VIDEO_INTERVAL" => M2tsAudioInterval::VideoInterval,
            other => M2tsAudioInterval::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsAudioInterval {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsAudioInterval::from(s))
    }
}
impl M2tsAudioInterval {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsAudioInterval::VideoAndFixedIntervals => "VIDEO_AND_FIXED_INTERVALS",
            M2tsAudioInterval::VideoInterval => "VIDEO_INTERVAL",
            M2tsAudioInterval::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VIDEO_AND_FIXED_INTERVALS", "VIDEO_INTERVAL"]
    }
}
impl AsRef<str> for M2tsAudioInterval {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Ebif Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsEbifControl {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsEbifControl {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => M2tsEbifControl::None,
            "PASSTHROUGH" => M2tsEbifControl::Passthrough,
            other => M2tsEbifControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsEbifControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsEbifControl::from(s))
    }
}
impl M2tsEbifControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsEbifControl::None => "NONE",
            M2tsEbifControl::Passthrough => "PASSTHROUGH",
            M2tsEbifControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M2tsEbifControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// DVB Time and Date Table (SDT)
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DvbTdtSettings {
    /// The number of milliseconds between instances of this table in the output transport stream.
    pub rep_interval: i32,
}
impl std::fmt::Debug for DvbTdtSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DvbTdtSettings");
        formatter.field("rep_interval", &self.rep_interval);
        formatter.finish()
    }
}
/// See [`DvbTdtSettings`](crate::model::DvbTdtSettings)
pub mod dvb_tdt_settings {
    /// A builder for [`DvbTdtSettings`](crate::model::DvbTdtSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) rep_interval: std::option::Option<i32>,
    }
    impl Builder {
        /// The number of milliseconds between instances of this table in the output transport stream.
        pub fn rep_interval(mut self, input: i32) -> Self {
            self.rep_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.
        pub fn set_rep_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.rep_interval = input;
            self
        }
        /// Consumes the builder and constructs a [`DvbTdtSettings`](crate::model::DvbTdtSettings)
        pub fn build(self) -> crate::model::DvbTdtSettings {
            crate::model::DvbTdtSettings {
                rep_interval: self.rep_interval.unwrap_or_default(),
            }
        }
    }
}
impl DvbTdtSettings {
    /// Creates a new builder-style object to manufacture [`DvbTdtSettings`](crate::model::DvbTdtSettings)
    pub fn builder() -> crate::model::dvb_tdt_settings::Builder {
        crate::model::dvb_tdt_settings::Builder::default()
    }
}

/// DVB Service Description Table (SDT)
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DvbSdtSettings {
    /// Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. The sdtManual setting means user will enter the SDT information. The sdtNone setting means output stream will not contain SDT information.
    pub output_sdt: std::option::Option<crate::model::DvbSdtOutputSdt>,
    /// The number of milliseconds between instances of this table in the output transport stream.
    pub rep_interval: i32,
    /// The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.
    pub service_name: std::option::Option<std::string::String>,
    /// The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.
    pub service_provider_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DvbSdtSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DvbSdtSettings");
        formatter.field("output_sdt", &self.output_sdt);
        formatter.field("rep_interval", &self.rep_interval);
        formatter.field("service_name", &self.service_name);
        formatter.field("service_provider_name", &self.service_provider_name);
        formatter.finish()
    }
}
/// See [`DvbSdtSettings`](crate::model::DvbSdtSettings)
pub mod dvb_sdt_settings {
    /// A builder for [`DvbSdtSettings`](crate::model::DvbSdtSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) output_sdt: std::option::Option<crate::model::DvbSdtOutputSdt>,
        pub(crate) rep_interval: std::option::Option<i32>,
        pub(crate) service_name: std::option::Option<std::string::String>,
        pub(crate) service_provider_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. The sdtManual setting means user will enter the SDT information. The sdtNone setting means output stream will not contain SDT information.
        pub fn output_sdt(mut self, input: crate::model::DvbSdtOutputSdt) -> Self {
            self.output_sdt = Some(input);
            self
        }
        /// Selects method of inserting SDT information into output stream. The sdtFollow setting copies SDT information from input stream to output stream. The sdtFollowIfPresent setting copies SDT information from input stream to output stream if SDT information is present in the input, otherwise it will fall back on the user-defined values. The sdtManual setting means user will enter the SDT information. The sdtNone setting means output stream will not contain SDT information.
        pub fn set_output_sdt(
            mut self,
            input: std::option::Option<crate::model::DvbSdtOutputSdt>,
        ) -> Self {
            self.output_sdt = input;
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.
        pub fn rep_interval(mut self, input: i32) -> Self {
            self.rep_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.
        pub fn set_rep_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.rep_interval = input;
            self
        }
        /// The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.
        pub fn service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_name = Some(input.into());
            self
        }
        /// The service name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.
        pub fn set_service_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_name = input;
            self
        }
        /// The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.
        pub fn service_provider_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_provider_name = Some(input.into());
            self
        }
        /// The service provider name placed in the serviceDescriptor in the Service Description Table. Maximum length is 256 characters.
        pub fn set_service_provider_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.service_provider_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DvbSdtSettings`](crate::model::DvbSdtSettings)
        pub fn build(self) -> crate::model::DvbSdtSettings {
            crate::model::DvbSdtSettings {
                output_sdt: self.output_sdt,
                rep_interval: self.rep_interval.unwrap_or_default(),
                service_name: self.service_name,
                service_provider_name: self.service_provider_name,
            }
        }
    }
}
impl DvbSdtSettings {
    /// Creates a new builder-style object to manufacture [`DvbSdtSettings`](crate::model::DvbSdtSettings)
    pub fn builder() -> crate::model::dvb_sdt_settings::Builder {
        crate::model::dvb_sdt_settings::Builder::default()
    }
}

/// Dvb Sdt Output Sdt
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DvbSdtOutputSdt {
    #[allow(missing_docs)] // documentation missing in model
    SdtFollow,
    #[allow(missing_docs)] // documentation missing in model
    SdtFollowIfPresent,
    #[allow(missing_docs)] // documentation missing in model
    SdtManual,
    #[allow(missing_docs)] // documentation missing in model
    SdtNone,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DvbSdtOutputSdt {
    fn from(s: &str) -> Self {
        match s {
            "SDT_FOLLOW" => DvbSdtOutputSdt::SdtFollow,
            "SDT_FOLLOW_IF_PRESENT" => DvbSdtOutputSdt::SdtFollowIfPresent,
            "SDT_MANUAL" => DvbSdtOutputSdt::SdtManual,
            "SDT_NONE" => DvbSdtOutputSdt::SdtNone,
            other => DvbSdtOutputSdt::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DvbSdtOutputSdt {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DvbSdtOutputSdt::from(s))
    }
}
impl DvbSdtOutputSdt {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DvbSdtOutputSdt::SdtFollow => "SDT_FOLLOW",
            DvbSdtOutputSdt::SdtFollowIfPresent => "SDT_FOLLOW_IF_PRESENT",
            DvbSdtOutputSdt::SdtManual => "SDT_MANUAL",
            DvbSdtOutputSdt::SdtNone => "SDT_NONE",
            DvbSdtOutputSdt::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "SDT_FOLLOW",
            "SDT_FOLLOW_IF_PRESENT",
            "SDT_MANUAL",
            "SDT_NONE",
        ]
    }
}
impl AsRef<str> for DvbSdtOutputSdt {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// DVB Network Information Table (NIT)
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DvbNitSettings {
    /// The numeric value placed in the Network Information Table (NIT).
    pub network_id: i32,
    /// The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum length is 256 characters.
    pub network_name: std::option::Option<std::string::String>,
    /// The number of milliseconds between instances of this table in the output transport stream.
    pub rep_interval: i32,
}
impl std::fmt::Debug for DvbNitSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DvbNitSettings");
        formatter.field("network_id", &self.network_id);
        formatter.field("network_name", &self.network_name);
        formatter.field("rep_interval", &self.rep_interval);
        formatter.finish()
    }
}
/// See [`DvbNitSettings`](crate::model::DvbNitSettings)
pub mod dvb_nit_settings {
    /// A builder for [`DvbNitSettings`](crate::model::DvbNitSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<i32>,
        pub(crate) network_name: std::option::Option<std::string::String>,
        pub(crate) rep_interval: std::option::Option<i32>,
    }
    impl Builder {
        /// The numeric value placed in the Network Information Table (NIT).
        pub fn network_id(mut self, input: i32) -> Self {
            self.network_id = Some(input);
            self
        }
        /// The numeric value placed in the Network Information Table (NIT).
        pub fn set_network_id(mut self, input: std::option::Option<i32>) -> Self {
            self.network_id = input;
            self
        }
        /// The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum length is 256 characters.
        pub fn network_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_name = Some(input.into());
            self
        }
        /// The network name text placed in the networkNameDescriptor inside the Network Information Table. Maximum length is 256 characters.
        pub fn set_network_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_name = input;
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.
        pub fn rep_interval(mut self, input: i32) -> Self {
            self.rep_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream.
        pub fn set_rep_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.rep_interval = input;
            self
        }
        /// Consumes the builder and constructs a [`DvbNitSettings`](crate::model::DvbNitSettings)
        pub fn build(self) -> crate::model::DvbNitSettings {
            crate::model::DvbNitSettings {
                network_id: self.network_id.unwrap_or_default(),
                network_name: self.network_name,
                rep_interval: self.rep_interval.unwrap_or_default(),
            }
        }
    }
}
impl DvbNitSettings {
    /// Creates a new builder-style object to manufacture [`DvbNitSettings`](crate::model::DvbNitSettings)
    pub fn builder() -> crate::model::dvb_nit_settings::Builder {
        crate::model::dvb_nit_settings::Builder::default()
    }
}

/// M2ts Cc Descriptor
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsCcDescriptor {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsCcDescriptor {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => M2tsCcDescriptor::Disabled,
            "ENABLED" => M2tsCcDescriptor::Enabled,
            other => M2tsCcDescriptor::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsCcDescriptor {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsCcDescriptor::from(s))
    }
}
impl M2tsCcDescriptor {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsCcDescriptor::Disabled => "DISABLED",
            M2tsCcDescriptor::Enabled => "ENABLED",
            M2tsCcDescriptor::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for M2tsCcDescriptor {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Buffer Model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsBufferModel {
    #[allow(missing_docs)] // documentation missing in model
    Multiplex,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsBufferModel {
    fn from(s: &str) -> Self {
        match s {
            "MULTIPLEX" => M2tsBufferModel::Multiplex,
            "NONE" => M2tsBufferModel::None,
            other => M2tsBufferModel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsBufferModel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsBufferModel::from(s))
    }
}
impl M2tsBufferModel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsBufferModel::Multiplex => "MULTIPLEX",
            M2tsBufferModel::None => "NONE",
            M2tsBufferModel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTIPLEX", "NONE"]
    }
}
impl AsRef<str> for M2tsBufferModel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Audio Stream Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsAudioStreamType {
    #[allow(missing_docs)] // documentation missing in model
    Atsc,
    #[allow(missing_docs)] // documentation missing in model
    Dvb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsAudioStreamType {
    fn from(s: &str) -> Self {
        match s {
            "ATSC" => M2tsAudioStreamType::Atsc,
            "DVB" => M2tsAudioStreamType::Dvb,
            other => M2tsAudioStreamType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsAudioStreamType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsAudioStreamType::from(s))
    }
}
impl M2tsAudioStreamType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsAudioStreamType::Atsc => "ATSC",
            M2tsAudioStreamType::Dvb => "DVB",
            M2tsAudioStreamType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ATSC", "DVB"]
    }
}
impl AsRef<str> for M2tsAudioStreamType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Audio Buffer Model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsAudioBufferModel {
    #[allow(missing_docs)] // documentation missing in model
    Atsc,
    #[allow(missing_docs)] // documentation missing in model
    Dvb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsAudioBufferModel {
    fn from(s: &str) -> Self {
        match s {
            "ATSC" => M2tsAudioBufferModel::Atsc,
            "DVB" => M2tsAudioBufferModel::Dvb,
            other => M2tsAudioBufferModel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsAudioBufferModel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsAudioBufferModel::from(s))
    }
}
impl M2tsAudioBufferModel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsAudioBufferModel::Atsc => "ATSC",
            M2tsAudioBufferModel::Dvb => "DVB",
            M2tsAudioBufferModel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ATSC", "DVB"]
    }
}
impl AsRef<str> for M2tsAudioBufferModel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Arib Captions Pid Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsAribCaptionsPidControl {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    UseConfigured,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsAribCaptionsPidControl {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => M2tsAribCaptionsPidControl::Auto,
            "USE_CONFIGURED" => M2tsAribCaptionsPidControl::UseConfigured,
            other => M2tsAribCaptionsPidControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsAribCaptionsPidControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsAribCaptionsPidControl::from(s))
    }
}
impl M2tsAribCaptionsPidControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsAribCaptionsPidControl::Auto => "AUTO",
            M2tsAribCaptionsPidControl::UseConfigured => "USE_CONFIGURED",
            M2tsAribCaptionsPidControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "USE_CONFIGURED"]
    }
}
impl AsRef<str> for M2tsAribCaptionsPidControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Arib
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsArib {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsArib {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => M2tsArib::Disabled,
            "ENABLED" => M2tsArib::Enabled,
            other => M2tsArib::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsArib {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsArib::from(s))
    }
}
impl M2tsArib {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsArib::Disabled => "DISABLED",
            M2tsArib::Enabled => "ENABLED",
            M2tsArib::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for M2tsArib {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M2ts Absent Input Audio Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M2tsAbsentInputAudioBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Drop,
    #[allow(missing_docs)] // documentation missing in model
    EncodeSilence,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M2tsAbsentInputAudioBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DROP" => M2tsAbsentInputAudioBehavior::Drop,
            "ENCODE_SILENCE" => M2tsAbsentInputAudioBehavior::EncodeSilence,
            other => M2tsAbsentInputAudioBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M2tsAbsentInputAudioBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M2tsAbsentInputAudioBehavior::from(s))
    }
}
impl M2tsAbsentInputAudioBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M2tsAbsentInputAudioBehavior::Drop => "DROP",
            M2tsAbsentInputAudioBehavior::EncodeSilence => "ENCODE_SILENCE",
            M2tsAbsentInputAudioBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DROP", "ENCODE_SILENCE"]
    }
}
impl AsRef<str> for M2tsAbsentInputAudioBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Rtmp Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RtmpOutputSettings {
    /// If set to verifyAuthenticity, verify the tls certificate chain to a trusted Certificate Authority (CA).  This will cause rtmps outputs with self-signed certificates to fail.
    pub certificate_mode: std::option::Option<crate::model::RtmpOutputCertificateMode>,
    /// Number of seconds to wait before retrying a connection to the Flash Media server if the connection is lost.
    pub connection_retry_interval: i32,
    /// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For connection to Akamai, a username and password must be supplied. URI fields accept format identifiers.
    pub destination: std::option::Option<crate::model::OutputLocationRef>,
    /// Number of retry attempts.
    pub num_retries: i32,
}
impl std::fmt::Debug for RtmpOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RtmpOutputSettings");
        formatter.field("certificate_mode", &self.certificate_mode);
        formatter.field("connection_retry_interval", &self.connection_retry_interval);
        formatter.field("destination", &self.destination);
        formatter.field("num_retries", &self.num_retries);
        formatter.finish()
    }
}
/// See [`RtmpOutputSettings`](crate::model::RtmpOutputSettings)
pub mod rtmp_output_settings {
    /// A builder for [`RtmpOutputSettings`](crate::model::RtmpOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) certificate_mode: std::option::Option<crate::model::RtmpOutputCertificateMode>,
        pub(crate) connection_retry_interval: std::option::Option<i32>,
        pub(crate) destination: std::option::Option<crate::model::OutputLocationRef>,
        pub(crate) num_retries: std::option::Option<i32>,
    }
    impl Builder {
        /// If set to verifyAuthenticity, verify the tls certificate chain to a trusted Certificate Authority (CA).  This will cause rtmps outputs with self-signed certificates to fail.
        pub fn certificate_mode(mut self, input: crate::model::RtmpOutputCertificateMode) -> Self {
            self.certificate_mode = Some(input);
            self
        }
        /// If set to verifyAuthenticity, verify the tls certificate chain to a trusted Certificate Authority (CA).  This will cause rtmps outputs with self-signed certificates to fail.
        pub fn set_certificate_mode(
            mut self,
            input: std::option::Option<crate::model::RtmpOutputCertificateMode>,
        ) -> Self {
            self.certificate_mode = input;
            self
        }
        /// Number of seconds to wait before retrying a connection to the Flash Media server if the connection is lost.
        pub fn connection_retry_interval(mut self, input: i32) -> Self {
            self.connection_retry_interval = Some(input);
            self
        }
        /// Number of seconds to wait before retrying a connection to the Flash Media server if the connection is lost.
        pub fn set_connection_retry_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_retry_interval = input;
            self
        }
        /// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For connection to Akamai, a username and password must be supplied. URI fields accept format identifiers.
        pub fn destination(mut self, input: crate::model::OutputLocationRef) -> Self {
            self.destination = Some(input);
            self
        }
        /// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For connection to Akamai, a username and password must be supplied. URI fields accept format identifiers.
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::OutputLocationRef>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Number of retry attempts.
        pub fn num_retries(mut self, input: i32) -> Self {
            self.num_retries = Some(input);
            self
        }
        /// Number of retry attempts.
        pub fn set_num_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.num_retries = input;
            self
        }
        /// Consumes the builder and constructs a [`RtmpOutputSettings`](crate::model::RtmpOutputSettings)
        pub fn build(self) -> crate::model::RtmpOutputSettings {
            crate::model::RtmpOutputSettings {
                certificate_mode: self.certificate_mode,
                connection_retry_interval: self.connection_retry_interval.unwrap_or_default(),
                destination: self.destination,
                num_retries: self.num_retries.unwrap_or_default(),
            }
        }
    }
}
impl RtmpOutputSettings {
    /// Creates a new builder-style object to manufacture [`RtmpOutputSettings`](crate::model::RtmpOutputSettings)
    pub fn builder() -> crate::model::rtmp_output_settings::Builder {
        crate::model::rtmp_output_settings::Builder::default()
    }
}

/// Rtmp Output Certificate Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RtmpOutputCertificateMode {
    #[allow(missing_docs)] // documentation missing in model
    SelfSigned,
    #[allow(missing_docs)] // documentation missing in model
    VerifyAuthenticity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RtmpOutputCertificateMode {
    fn from(s: &str) -> Self {
        match s {
            "SELF_SIGNED" => RtmpOutputCertificateMode::SelfSigned,
            "VERIFY_AUTHENTICITY" => RtmpOutputCertificateMode::VerifyAuthenticity,
            other => RtmpOutputCertificateMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RtmpOutputCertificateMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RtmpOutputCertificateMode::from(s))
    }
}
impl RtmpOutputCertificateMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RtmpOutputCertificateMode::SelfSigned => "SELF_SIGNED",
            RtmpOutputCertificateMode::VerifyAuthenticity => "VERIFY_AUTHENTICITY",
            RtmpOutputCertificateMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["SELF_SIGNED", "VERIFY_AUTHENTICITY"]
    }
}
impl AsRef<str> for RtmpOutputCertificateMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Multiplex Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexOutputSettings {
    /// Destination is a Multiplex.
    pub destination: std::option::Option<crate::model::OutputLocationRef>,
}
impl std::fmt::Debug for MultiplexOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexOutputSettings");
        formatter.field("destination", &self.destination);
        formatter.finish()
    }
}
/// See [`MultiplexOutputSettings`](crate::model::MultiplexOutputSettings)
pub mod multiplex_output_settings {
    /// A builder for [`MultiplexOutputSettings`](crate::model::MultiplexOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination: std::option::Option<crate::model::OutputLocationRef>,
    }
    impl Builder {
        /// Destination is a Multiplex.
        pub fn destination(mut self, input: crate::model::OutputLocationRef) -> Self {
            self.destination = Some(input);
            self
        }
        /// Destination is a Multiplex.
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::OutputLocationRef>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// Consumes the builder and constructs a [`MultiplexOutputSettings`](crate::model::MultiplexOutputSettings)
        pub fn build(self) -> crate::model::MultiplexOutputSettings {
            crate::model::MultiplexOutputSettings {
                destination: self.destination,
            }
        }
    }
}
impl MultiplexOutputSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexOutputSettings`](crate::model::MultiplexOutputSettings)
    pub fn builder() -> crate::model::multiplex_output_settings::Builder {
        crate::model::multiplex_output_settings::Builder::default()
    }
}

/// Ms Smooth Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MsSmoothOutputSettings {
    /// Only applicable when this output is referencing an H.265 video description.
    /// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
    pub h265_packaging_type: std::option::Option<crate::model::MsSmoothH265PackagingType>,
    /// String concatenated to the end of the destination filename.  Required for multiple outputs of the same type.
    pub name_modifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MsSmoothOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MsSmoothOutputSettings");
        formatter.field("h265_packaging_type", &self.h265_packaging_type);
        formatter.field("name_modifier", &self.name_modifier);
        formatter.finish()
    }
}
/// See [`MsSmoothOutputSettings`](crate::model::MsSmoothOutputSettings)
pub mod ms_smooth_output_settings {
    /// A builder for [`MsSmoothOutputSettings`](crate::model::MsSmoothOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) h265_packaging_type:
            std::option::Option<crate::model::MsSmoothH265PackagingType>,
        pub(crate) name_modifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Only applicable when this output is referencing an H.265 video description.
        /// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
        pub fn h265_packaging_type(
            mut self,
            input: crate::model::MsSmoothH265PackagingType,
        ) -> Self {
            self.h265_packaging_type = Some(input);
            self
        }
        /// Only applicable when this output is referencing an H.265 video description.
        /// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
        pub fn set_h265_packaging_type(
            mut self,
            input: std::option::Option<crate::model::MsSmoothH265PackagingType>,
        ) -> Self {
            self.h265_packaging_type = input;
            self
        }
        /// String concatenated to the end of the destination filename.  Required for multiple outputs of the same type.
        pub fn name_modifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_modifier = Some(input.into());
            self
        }
        /// String concatenated to the end of the destination filename.  Required for multiple outputs of the same type.
        pub fn set_name_modifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_modifier = input;
            self
        }
        /// Consumes the builder and constructs a [`MsSmoothOutputSettings`](crate::model::MsSmoothOutputSettings)
        pub fn build(self) -> crate::model::MsSmoothOutputSettings {
            crate::model::MsSmoothOutputSettings {
                h265_packaging_type: self.h265_packaging_type,
                name_modifier: self.name_modifier,
            }
        }
    }
}
impl MsSmoothOutputSettings {
    /// Creates a new builder-style object to manufacture [`MsSmoothOutputSettings`](crate::model::MsSmoothOutputSettings)
    pub fn builder() -> crate::model::ms_smooth_output_settings::Builder {
        crate::model::ms_smooth_output_settings::Builder::default()
    }
}

/// Ms Smooth H265 Packaging Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MsSmoothH265PackagingType {
    #[allow(missing_docs)] // documentation missing in model
    Hev1,
    #[allow(missing_docs)] // documentation missing in model
    Hvc1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MsSmoothH265PackagingType {
    fn from(s: &str) -> Self {
        match s {
            "HEV1" => MsSmoothH265PackagingType::Hev1,
            "HVC1" => MsSmoothH265PackagingType::Hvc1,
            other => MsSmoothH265PackagingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MsSmoothH265PackagingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MsSmoothH265PackagingType::from(s))
    }
}
impl MsSmoothH265PackagingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MsSmoothH265PackagingType::Hev1 => "HEV1",
            MsSmoothH265PackagingType::Hvc1 => "HVC1",
            MsSmoothH265PackagingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEV1", "HVC1"]
    }
}
impl AsRef<str> for MsSmoothH265PackagingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Media Package Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaPackageOutputSettings {}
impl std::fmt::Debug for MediaPackageOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaPackageOutputSettings");
        formatter.finish()
    }
}
/// See [`MediaPackageOutputSettings`](crate::model::MediaPackageOutputSettings)
pub mod media_package_output_settings {
    /// A builder for [`MediaPackageOutputSettings`](crate::model::MediaPackageOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`MediaPackageOutputSettings`](crate::model::MediaPackageOutputSettings)
        pub fn build(self) -> crate::model::MediaPackageOutputSettings {
            crate::model::MediaPackageOutputSettings {}
        }
    }
}
impl MediaPackageOutputSettings {
    /// Creates a new builder-style object to manufacture [`MediaPackageOutputSettings`](crate::model::MediaPackageOutputSettings)
    pub fn builder() -> crate::model::media_package_output_settings::Builder {
        crate::model::media_package_output_settings::Builder::default()
    }
}

/// Hls Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsOutputSettings {
    /// Only applicable when this output is referencing an H.265 video description.
    /// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
    pub h265_packaging_type: std::option::Option<crate::model::HlsH265PackagingType>,
    /// Settings regarding the underlying stream. These settings are different for audio-only outputs.
    pub hls_settings: std::option::Option<crate::model::HlsSettings>,
    /// String concatenated to the end of the destination filename. Accepts \"Format Identifiers\":#formatIdentifierParameters.
    pub name_modifier: std::option::Option<std::string::String>,
    /// String concatenated to end of segment filenames.
    pub segment_modifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for HlsOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsOutputSettings");
        formatter.field("h265_packaging_type", &self.h265_packaging_type);
        formatter.field("hls_settings", &self.hls_settings);
        formatter.field("name_modifier", &self.name_modifier);
        formatter.field("segment_modifier", &self.segment_modifier);
        formatter.finish()
    }
}
/// See [`HlsOutputSettings`](crate::model::HlsOutputSettings)
pub mod hls_output_settings {
    /// A builder for [`HlsOutputSettings`](crate::model::HlsOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) h265_packaging_type: std::option::Option<crate::model::HlsH265PackagingType>,
        pub(crate) hls_settings: std::option::Option<crate::model::HlsSettings>,
        pub(crate) name_modifier: std::option::Option<std::string::String>,
        pub(crate) segment_modifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Only applicable when this output is referencing an H.265 video description.
        /// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
        pub fn h265_packaging_type(mut self, input: crate::model::HlsH265PackagingType) -> Self {
            self.h265_packaging_type = Some(input);
            self
        }
        /// Only applicable when this output is referencing an H.265 video description.
        /// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
        pub fn set_h265_packaging_type(
            mut self,
            input: std::option::Option<crate::model::HlsH265PackagingType>,
        ) -> Self {
            self.h265_packaging_type = input;
            self
        }
        /// Settings regarding the underlying stream. These settings are different for audio-only outputs.
        pub fn hls_settings(mut self, input: crate::model::HlsSettings) -> Self {
            self.hls_settings = Some(input);
            self
        }
        /// Settings regarding the underlying stream. These settings are different for audio-only outputs.
        pub fn set_hls_settings(
            mut self,
            input: std::option::Option<crate::model::HlsSettings>,
        ) -> Self {
            self.hls_settings = input;
            self
        }
        /// String concatenated to the end of the destination filename. Accepts \"Format Identifiers\":#formatIdentifierParameters.
        pub fn name_modifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_modifier = Some(input.into());
            self
        }
        /// String concatenated to the end of the destination filename. Accepts \"Format Identifiers\":#formatIdentifierParameters.
        pub fn set_name_modifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_modifier = input;
            self
        }
        /// String concatenated to end of segment filenames.
        pub fn segment_modifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.segment_modifier = Some(input.into());
            self
        }
        /// String concatenated to end of segment filenames.
        pub fn set_segment_modifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.segment_modifier = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsOutputSettings`](crate::model::HlsOutputSettings)
        pub fn build(self) -> crate::model::HlsOutputSettings {
            crate::model::HlsOutputSettings {
                h265_packaging_type: self.h265_packaging_type,
                hls_settings: self.hls_settings,
                name_modifier: self.name_modifier,
                segment_modifier: self.segment_modifier,
            }
        }
    }
}
impl HlsOutputSettings {
    /// Creates a new builder-style object to manufacture [`HlsOutputSettings`](crate::model::HlsOutputSettings)
    pub fn builder() -> crate::model::hls_output_settings::Builder {
        crate::model::hls_output_settings::Builder::default()
    }
}

/// Hls Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct HlsSettings {
    /// Audio Only Hls Settings
    pub audio_only_hls_settings: std::option::Option<crate::model::AudioOnlyHlsSettings>,
    /// Fmp4 Hls Settings
    pub fmp4_hls_settings: std::option::Option<crate::model::Fmp4HlsSettings>,
    /// Frame Capture Hls Settings
    pub frame_capture_hls_settings: std::option::Option<crate::model::FrameCaptureHlsSettings>,
    /// Standard Hls Settings
    pub standard_hls_settings: std::option::Option<crate::model::StandardHlsSettings>,
}
impl std::fmt::Debug for HlsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("HlsSettings");
        formatter.field("audio_only_hls_settings", &self.audio_only_hls_settings);
        formatter.field("fmp4_hls_settings", &self.fmp4_hls_settings);
        formatter.field(
            "frame_capture_hls_settings",
            &self.frame_capture_hls_settings,
        );
        formatter.field("standard_hls_settings", &self.standard_hls_settings);
        formatter.finish()
    }
}
/// See [`HlsSettings`](crate::model::HlsSettings)
pub mod hls_settings {
    /// A builder for [`HlsSettings`](crate::model::HlsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_only_hls_settings: std::option::Option<crate::model::AudioOnlyHlsSettings>,
        pub(crate) fmp4_hls_settings: std::option::Option<crate::model::Fmp4HlsSettings>,
        pub(crate) frame_capture_hls_settings:
            std::option::Option<crate::model::FrameCaptureHlsSettings>,
        pub(crate) standard_hls_settings: std::option::Option<crate::model::StandardHlsSettings>,
    }
    impl Builder {
        /// Audio Only Hls Settings
        pub fn audio_only_hls_settings(
            mut self,
            input: crate::model::AudioOnlyHlsSettings,
        ) -> Self {
            self.audio_only_hls_settings = Some(input);
            self
        }
        /// Audio Only Hls Settings
        pub fn set_audio_only_hls_settings(
            mut self,
            input: std::option::Option<crate::model::AudioOnlyHlsSettings>,
        ) -> Self {
            self.audio_only_hls_settings = input;
            self
        }
        /// Fmp4 Hls Settings
        pub fn fmp4_hls_settings(mut self, input: crate::model::Fmp4HlsSettings) -> Self {
            self.fmp4_hls_settings = Some(input);
            self
        }
        /// Fmp4 Hls Settings
        pub fn set_fmp4_hls_settings(
            mut self,
            input: std::option::Option<crate::model::Fmp4HlsSettings>,
        ) -> Self {
            self.fmp4_hls_settings = input;
            self
        }
        /// Frame Capture Hls Settings
        pub fn frame_capture_hls_settings(
            mut self,
            input: crate::model::FrameCaptureHlsSettings,
        ) -> Self {
            self.frame_capture_hls_settings = Some(input);
            self
        }
        /// Frame Capture Hls Settings
        pub fn set_frame_capture_hls_settings(
            mut self,
            input: std::option::Option<crate::model::FrameCaptureHlsSettings>,
        ) -> Self {
            self.frame_capture_hls_settings = input;
            self
        }
        /// Standard Hls Settings
        pub fn standard_hls_settings(mut self, input: crate::model::StandardHlsSettings) -> Self {
            self.standard_hls_settings = Some(input);
            self
        }
        /// Standard Hls Settings
        pub fn set_standard_hls_settings(
            mut self,
            input: std::option::Option<crate::model::StandardHlsSettings>,
        ) -> Self {
            self.standard_hls_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`HlsSettings`](crate::model::HlsSettings)
        pub fn build(self) -> crate::model::HlsSettings {
            crate::model::HlsSettings {
                audio_only_hls_settings: self.audio_only_hls_settings,
                fmp4_hls_settings: self.fmp4_hls_settings,
                frame_capture_hls_settings: self.frame_capture_hls_settings,
                standard_hls_settings: self.standard_hls_settings,
            }
        }
    }
}
impl HlsSettings {
    /// Creates a new builder-style object to manufacture [`HlsSettings`](crate::model::HlsSettings)
    pub fn builder() -> crate::model::hls_settings::Builder {
        crate::model::hls_settings::Builder::default()
    }
}

/// Standard Hls Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StandardHlsSettings {
    /// List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
    pub audio_rendition_sets: std::option::Option<std::string::String>,
    /// Settings information for the .m3u8 container
    pub m3u8_settings: std::option::Option<crate::model::M3u8Settings>,
}
impl std::fmt::Debug for StandardHlsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StandardHlsSettings");
        formatter.field("audio_rendition_sets", &self.audio_rendition_sets);
        formatter.field("m3u8_settings", &self.m3u8_settings);
        formatter.finish()
    }
}
/// See [`StandardHlsSettings`](crate::model::StandardHlsSettings)
pub mod standard_hls_settings {
    /// A builder for [`StandardHlsSettings`](crate::model::StandardHlsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_rendition_sets: std::option::Option<std::string::String>,
        pub(crate) m3u8_settings: std::option::Option<crate::model::M3u8Settings>,
    }
    impl Builder {
        /// List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
        pub fn audio_rendition_sets(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_rendition_sets = Some(input.into());
            self
        }
        /// List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
        pub fn set_audio_rendition_sets(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_rendition_sets = input;
            self
        }
        /// Settings information for the .m3u8 container
        pub fn m3u8_settings(mut self, input: crate::model::M3u8Settings) -> Self {
            self.m3u8_settings = Some(input);
            self
        }
        /// Settings information for the .m3u8 container
        pub fn set_m3u8_settings(
            mut self,
            input: std::option::Option<crate::model::M3u8Settings>,
        ) -> Self {
            self.m3u8_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`StandardHlsSettings`](crate::model::StandardHlsSettings)
        pub fn build(self) -> crate::model::StandardHlsSettings {
            crate::model::StandardHlsSettings {
                audio_rendition_sets: self.audio_rendition_sets,
                m3u8_settings: self.m3u8_settings,
            }
        }
    }
}
impl StandardHlsSettings {
    /// Creates a new builder-style object to manufacture [`StandardHlsSettings`](crate::model::StandardHlsSettings)
    pub fn builder() -> crate::model::standard_hls_settings::Builder {
        crate::model::standard_hls_settings::Builder::default()
    }
}

/// Settings information for the .m3u8 container
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct M3u8Settings {
    /// The number of audio frames to insert for each PES packet.
    pub audio_frames_per_pes: i32,
    /// Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
    pub audio_pids: std::option::Option<std::string::String>,
    /// This parameter is unused and deprecated.
    pub ecm_pid: std::option::Option<std::string::String>,
    /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
    pub nielsen_id3_behavior: std::option::Option<crate::model::M3u8NielsenId3Behavior>,
    /// The number of milliseconds between instances of this table in the output transport stream. A value of \"0\" writes out the PMT once per segment file.
    pub pat_interval: i32,
    /// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
    pub pcr_control: std::option::Option<crate::model::M3u8PcrControl>,
    /// Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.
    pub pcr_period: i32,
    /// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.
    pub pcr_pid: std::option::Option<std::string::String>,
    /// The number of milliseconds between instances of this table in the output transport stream. A value of \"0\" writes out the PMT once per segment file.
    pub pmt_interval: i32,
    /// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value.
    pub pmt_pid: std::option::Option<std::string::String>,
    /// The value of the program number field in the Program Map Table.
    pub program_num: i32,
    /// If set to passthrough, passes any SCTE-35 signals from the input source to this output.
    pub scte35_behavior: std::option::Option<crate::model::M3u8Scte35Behavior>,
    /// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.
    pub scte35_pid: std::option::Option<std::string::String>,
    /// When set to passthrough, timed metadata is passed through from input to output.
    pub timed_metadata_behavior: std::option::Option<crate::model::M3u8TimedMetadataBehavior>,
    /// Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
    pub timed_metadata_pid: std::option::Option<std::string::String>,
    /// The value of the transport stream ID field in the Program Map Table.
    pub transport_stream_id: i32,
    /// Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.
    pub video_pid: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for M3u8Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("M3u8Settings");
        formatter.field("audio_frames_per_pes", &self.audio_frames_per_pes);
        formatter.field("audio_pids", &self.audio_pids);
        formatter.field("ecm_pid", &self.ecm_pid);
        formatter.field("nielsen_id3_behavior", &self.nielsen_id3_behavior);
        formatter.field("pat_interval", &self.pat_interval);
        formatter.field("pcr_control", &self.pcr_control);
        formatter.field("pcr_period", &self.pcr_period);
        formatter.field("pcr_pid", &self.pcr_pid);
        formatter.field("pmt_interval", &self.pmt_interval);
        formatter.field("pmt_pid", &self.pmt_pid);
        formatter.field("program_num", &self.program_num);
        formatter.field("scte35_behavior", &self.scte35_behavior);
        formatter.field("scte35_pid", &self.scte35_pid);
        formatter.field("timed_metadata_behavior", &self.timed_metadata_behavior);
        formatter.field("timed_metadata_pid", &self.timed_metadata_pid);
        formatter.field("transport_stream_id", &self.transport_stream_id);
        formatter.field("video_pid", &self.video_pid);
        formatter.finish()
    }
}
/// See [`M3u8Settings`](crate::model::M3u8Settings)
pub mod m3u8_settings {
    /// A builder for [`M3u8Settings`](crate::model::M3u8Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_frames_per_pes: std::option::Option<i32>,
        pub(crate) audio_pids: std::option::Option<std::string::String>,
        pub(crate) ecm_pid: std::option::Option<std::string::String>,
        pub(crate) nielsen_id3_behavior: std::option::Option<crate::model::M3u8NielsenId3Behavior>,
        pub(crate) pat_interval: std::option::Option<i32>,
        pub(crate) pcr_control: std::option::Option<crate::model::M3u8PcrControl>,
        pub(crate) pcr_period: std::option::Option<i32>,
        pub(crate) pcr_pid: std::option::Option<std::string::String>,
        pub(crate) pmt_interval: std::option::Option<i32>,
        pub(crate) pmt_pid: std::option::Option<std::string::String>,
        pub(crate) program_num: std::option::Option<i32>,
        pub(crate) scte35_behavior: std::option::Option<crate::model::M3u8Scte35Behavior>,
        pub(crate) scte35_pid: std::option::Option<std::string::String>,
        pub(crate) timed_metadata_behavior:
            std::option::Option<crate::model::M3u8TimedMetadataBehavior>,
        pub(crate) timed_metadata_pid: std::option::Option<std::string::String>,
        pub(crate) transport_stream_id: std::option::Option<i32>,
        pub(crate) video_pid: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The number of audio frames to insert for each PES packet.
        pub fn audio_frames_per_pes(mut self, input: i32) -> Self {
            self.audio_frames_per_pes = Some(input);
            self
        }
        /// The number of audio frames to insert for each PES packet.
        pub fn set_audio_frames_per_pes(mut self, input: std::option::Option<i32>) -> Self {
            self.audio_frames_per_pes = input;
            self
        }
        /// Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
        pub fn audio_pids(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_pids = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the elementary audio stream(s) in the transport stream. Multiple values are accepted, and can be entered in ranges and/or by comma separation. Can be entered as decimal or hexadecimal values.
        pub fn set_audio_pids(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.audio_pids = input;
            self
        }
        /// This parameter is unused and deprecated.
        pub fn ecm_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.ecm_pid = Some(input.into());
            self
        }
        /// This parameter is unused and deprecated.
        pub fn set_ecm_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ecm_pid = input;
            self
        }
        /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
        pub fn nielsen_id3_behavior(mut self, input: crate::model::M3u8NielsenId3Behavior) -> Self {
            self.nielsen_id3_behavior = Some(input);
            self
        }
        /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
        pub fn set_nielsen_id3_behavior(
            mut self,
            input: std::option::Option<crate::model::M3u8NielsenId3Behavior>,
        ) -> Self {
            self.nielsen_id3_behavior = input;
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream. A value of \"0\" writes out the PMT once per segment file.
        pub fn pat_interval(mut self, input: i32) -> Self {
            self.pat_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream. A value of \"0\" writes out the PMT once per segment file.
        pub fn set_pat_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.pat_interval = input;
            self
        }
        /// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
        pub fn pcr_control(mut self, input: crate::model::M3u8PcrControl) -> Self {
            self.pcr_control = Some(input);
            self
        }
        /// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for every Packetized Elementary Stream (PES) header. This parameter is effective only when the PCR PID is the same as the video or audio elementary stream.
        pub fn set_pcr_control(
            mut self,
            input: std::option::Option<crate::model::M3u8PcrControl>,
        ) -> Self {
            self.pcr_control = input;
            self
        }
        /// Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.
        pub fn pcr_period(mut self, input: i32) -> Self {
            self.pcr_period = Some(input);
            self
        }
        /// Maximum time in milliseconds between Program Clock References (PCRs) inserted into the transport stream.
        pub fn set_pcr_period(mut self, input: std::option::Option<i32>) -> Self {
            self.pcr_period = input;
            self
        }
        /// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.
        pub fn pcr_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.pcr_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport stream. When no value is given, the encoder will assign the same value as the Video PID. Can be entered as a decimal or hexadecimal value.
        pub fn set_pcr_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pcr_pid = input;
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream. A value of \"0\" writes out the PMT once per segment file.
        pub fn pmt_interval(mut self, input: i32) -> Self {
            self.pmt_interval = Some(input);
            self
        }
        /// The number of milliseconds between instances of this table in the output transport stream. A value of \"0\" writes out the PMT once per segment file.
        pub fn set_pmt_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.pmt_interval = input;
            self
        }
        /// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value.
        pub fn pmt_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.pmt_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream. Can be entered as a decimal or hexadecimal value.
        pub fn set_pmt_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.pmt_pid = input;
            self
        }
        /// The value of the program number field in the Program Map Table.
        pub fn program_num(mut self, input: i32) -> Self {
            self.program_num = Some(input);
            self
        }
        /// The value of the program number field in the Program Map Table.
        pub fn set_program_num(mut self, input: std::option::Option<i32>) -> Self {
            self.program_num = input;
            self
        }
        /// If set to passthrough, passes any SCTE-35 signals from the input source to this output.
        pub fn scte35_behavior(mut self, input: crate::model::M3u8Scte35Behavior) -> Self {
            self.scte35_behavior = Some(input);
            self
        }
        /// If set to passthrough, passes any SCTE-35 signals from the input source to this output.
        pub fn set_scte35_behavior(
            mut self,
            input: std::option::Option<crate::model::M3u8Scte35Behavior>,
        ) -> Self {
            self.scte35_behavior = input;
            self
        }
        /// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.
        pub fn scte35_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.scte35_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be entered as a decimal or hexadecimal value.
        pub fn set_scte35_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.scte35_pid = input;
            self
        }
        /// When set to passthrough, timed metadata is passed through from input to output.
        pub fn timed_metadata_behavior(
            mut self,
            input: crate::model::M3u8TimedMetadataBehavior,
        ) -> Self {
            self.timed_metadata_behavior = Some(input);
            self
        }
        /// When set to passthrough, timed metadata is passed through from input to output.
        pub fn set_timed_metadata_behavior(
            mut self,
            input: std::option::Option<crate::model::M3u8TimedMetadataBehavior>,
        ) -> Self {
            self.timed_metadata_behavior = input;
            self
        }
        /// Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn timed_metadata_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.timed_metadata_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the timed metadata stream in the transport stream. Can be entered as a decimal or hexadecimal value.  Valid values are 32 (or 0x20)..8182 (or 0x1ff6).
        pub fn set_timed_metadata_pid(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timed_metadata_pid = input;
            self
        }
        /// The value of the transport stream ID field in the Program Map Table.
        pub fn transport_stream_id(mut self, input: i32) -> Self {
            self.transport_stream_id = Some(input);
            self
        }
        /// The value of the transport stream ID field in the Program Map Table.
        pub fn set_transport_stream_id(mut self, input: std::option::Option<i32>) -> Self {
            self.transport_stream_id = input;
            self
        }
        /// Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.
        pub fn video_pid(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_pid = Some(input.into());
            self
        }
        /// Packet Identifier (PID) of the elementary video stream in the transport stream. Can be entered as a decimal or hexadecimal value.
        pub fn set_video_pid(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.video_pid = input;
            self
        }
        /// Consumes the builder and constructs a [`M3u8Settings`](crate::model::M3u8Settings)
        pub fn build(self) -> crate::model::M3u8Settings {
            crate::model::M3u8Settings {
                audio_frames_per_pes: self.audio_frames_per_pes.unwrap_or_default(),
                audio_pids: self.audio_pids,
                ecm_pid: self.ecm_pid,
                nielsen_id3_behavior: self.nielsen_id3_behavior,
                pat_interval: self.pat_interval.unwrap_or_default(),
                pcr_control: self.pcr_control,
                pcr_period: self.pcr_period.unwrap_or_default(),
                pcr_pid: self.pcr_pid,
                pmt_interval: self.pmt_interval.unwrap_or_default(),
                pmt_pid: self.pmt_pid,
                program_num: self.program_num.unwrap_or_default(),
                scte35_behavior: self.scte35_behavior,
                scte35_pid: self.scte35_pid,
                timed_metadata_behavior: self.timed_metadata_behavior,
                timed_metadata_pid: self.timed_metadata_pid,
                transport_stream_id: self.transport_stream_id.unwrap_or_default(),
                video_pid: self.video_pid,
            }
        }
    }
}
impl M3u8Settings {
    /// Creates a new builder-style object to manufacture [`M3u8Settings`](crate::model::M3u8Settings)
    pub fn builder() -> crate::model::m3u8_settings::Builder {
        crate::model::m3u8_settings::Builder::default()
    }
}

/// M3u8 Timed Metadata Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M3u8TimedMetadataBehavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M3u8TimedMetadataBehavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => M3u8TimedMetadataBehavior::NoPassthrough,
            "PASSTHROUGH" => M3u8TimedMetadataBehavior::Passthrough,
            other => M3u8TimedMetadataBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M3u8TimedMetadataBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M3u8TimedMetadataBehavior::from(s))
    }
}
impl M3u8TimedMetadataBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M3u8TimedMetadataBehavior::NoPassthrough => "NO_PASSTHROUGH",
            M3u8TimedMetadataBehavior::Passthrough => "PASSTHROUGH",
            M3u8TimedMetadataBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M3u8TimedMetadataBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M3u8 Scte35 Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M3u8Scte35Behavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M3u8Scte35Behavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => M3u8Scte35Behavior::NoPassthrough,
            "PASSTHROUGH" => M3u8Scte35Behavior::Passthrough,
            other => M3u8Scte35Behavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M3u8Scte35Behavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M3u8Scte35Behavior::from(s))
    }
}
impl M3u8Scte35Behavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M3u8Scte35Behavior::NoPassthrough => "NO_PASSTHROUGH",
            M3u8Scte35Behavior::Passthrough => "PASSTHROUGH",
            M3u8Scte35Behavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M3u8Scte35Behavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M3u8 Pcr Control
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M3u8PcrControl {
    #[allow(missing_docs)] // documentation missing in model
    ConfiguredPcrPeriod,
    #[allow(missing_docs)] // documentation missing in model
    PcrEveryPesPacket,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M3u8PcrControl {
    fn from(s: &str) -> Self {
        match s {
            "CONFIGURED_PCR_PERIOD" => M3u8PcrControl::ConfiguredPcrPeriod,
            "PCR_EVERY_PES_PACKET" => M3u8PcrControl::PcrEveryPesPacket,
            other => M3u8PcrControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M3u8PcrControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M3u8PcrControl::from(s))
    }
}
impl M3u8PcrControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M3u8PcrControl::ConfiguredPcrPeriod => "CONFIGURED_PCR_PERIOD",
            M3u8PcrControl::PcrEveryPesPacket => "PCR_EVERY_PES_PACKET",
            M3u8PcrControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONFIGURED_PCR_PERIOD", "PCR_EVERY_PES_PACKET"]
    }
}
impl AsRef<str> for M3u8PcrControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// M3u8 Nielsen Id3 Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum M3u8NielsenId3Behavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for M3u8NielsenId3Behavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => M3u8NielsenId3Behavior::NoPassthrough,
            "PASSTHROUGH" => M3u8NielsenId3Behavior::Passthrough,
            other => M3u8NielsenId3Behavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for M3u8NielsenId3Behavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(M3u8NielsenId3Behavior::from(s))
    }
}
impl M3u8NielsenId3Behavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            M3u8NielsenId3Behavior::NoPassthrough => "NO_PASSTHROUGH",
            M3u8NielsenId3Behavior::Passthrough => "PASSTHROUGH",
            M3u8NielsenId3Behavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for M3u8NielsenId3Behavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Frame Capture Hls Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameCaptureHlsSettings {}
impl std::fmt::Debug for FrameCaptureHlsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameCaptureHlsSettings");
        formatter.finish()
    }
}
/// See [`FrameCaptureHlsSettings`](crate::model::FrameCaptureHlsSettings)
pub mod frame_capture_hls_settings {
    /// A builder for [`FrameCaptureHlsSettings`](crate::model::FrameCaptureHlsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`FrameCaptureHlsSettings`](crate::model::FrameCaptureHlsSettings)
        pub fn build(self) -> crate::model::FrameCaptureHlsSettings {
            crate::model::FrameCaptureHlsSettings {}
        }
    }
}
impl FrameCaptureHlsSettings {
    /// Creates a new builder-style object to manufacture [`FrameCaptureHlsSettings`](crate::model::FrameCaptureHlsSettings)
    pub fn builder() -> crate::model::frame_capture_hls_settings::Builder {
        crate::model::frame_capture_hls_settings::Builder::default()
    }
}

/// Fmp4 Hls Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Fmp4HlsSettings {
    /// List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
    pub audio_rendition_sets: std::option::Option<std::string::String>,
    /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
    pub nielsen_id3_behavior: std::option::Option<crate::model::Fmp4NielsenId3Behavior>,
    /// When set to passthrough, timed metadata is passed through from input to output.
    pub timed_metadata_behavior: std::option::Option<crate::model::Fmp4TimedMetadataBehavior>,
}
impl std::fmt::Debug for Fmp4HlsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Fmp4HlsSettings");
        formatter.field("audio_rendition_sets", &self.audio_rendition_sets);
        formatter.field("nielsen_id3_behavior", &self.nielsen_id3_behavior);
        formatter.field("timed_metadata_behavior", &self.timed_metadata_behavior);
        formatter.finish()
    }
}
/// See [`Fmp4HlsSettings`](crate::model::Fmp4HlsSettings)
pub mod fmp4_hls_settings {
    /// A builder for [`Fmp4HlsSettings`](crate::model::Fmp4HlsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_rendition_sets: std::option::Option<std::string::String>,
        pub(crate) nielsen_id3_behavior: std::option::Option<crate::model::Fmp4NielsenId3Behavior>,
        pub(crate) timed_metadata_behavior:
            std::option::Option<crate::model::Fmp4TimedMetadataBehavior>,
    }
    impl Builder {
        /// List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
        pub fn audio_rendition_sets(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_rendition_sets = Some(input.into());
            self
        }
        /// List all the audio groups that are used with the video output stream. Input all the audio GROUP-IDs that are associated to the video, separate by ','.
        pub fn set_audio_rendition_sets(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_rendition_sets = input;
            self
        }
        /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
        pub fn nielsen_id3_behavior(mut self, input: crate::model::Fmp4NielsenId3Behavior) -> Self {
            self.nielsen_id3_behavior = Some(input);
            self
        }
        /// If set to passthrough, Nielsen inaudible tones for media tracking will be detected in the input audio and an equivalent ID3 tag will be inserted in the output.
        pub fn set_nielsen_id3_behavior(
            mut self,
            input: std::option::Option<crate::model::Fmp4NielsenId3Behavior>,
        ) -> Self {
            self.nielsen_id3_behavior = input;
            self
        }
        /// When set to passthrough, timed metadata is passed through from input to output.
        pub fn timed_metadata_behavior(
            mut self,
            input: crate::model::Fmp4TimedMetadataBehavior,
        ) -> Self {
            self.timed_metadata_behavior = Some(input);
            self
        }
        /// When set to passthrough, timed metadata is passed through from input to output.
        pub fn set_timed_metadata_behavior(
            mut self,
            input: std::option::Option<crate::model::Fmp4TimedMetadataBehavior>,
        ) -> Self {
            self.timed_metadata_behavior = input;
            self
        }
        /// Consumes the builder and constructs a [`Fmp4HlsSettings`](crate::model::Fmp4HlsSettings)
        pub fn build(self) -> crate::model::Fmp4HlsSettings {
            crate::model::Fmp4HlsSettings {
                audio_rendition_sets: self.audio_rendition_sets,
                nielsen_id3_behavior: self.nielsen_id3_behavior,
                timed_metadata_behavior: self.timed_metadata_behavior,
            }
        }
    }
}
impl Fmp4HlsSettings {
    /// Creates a new builder-style object to manufacture [`Fmp4HlsSettings`](crate::model::Fmp4HlsSettings)
    pub fn builder() -> crate::model::fmp4_hls_settings::Builder {
        crate::model::fmp4_hls_settings::Builder::default()
    }
}

/// Fmp4 Timed Metadata Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Fmp4TimedMetadataBehavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Fmp4TimedMetadataBehavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => Fmp4TimedMetadataBehavior::NoPassthrough,
            "PASSTHROUGH" => Fmp4TimedMetadataBehavior::Passthrough,
            other => Fmp4TimedMetadataBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Fmp4TimedMetadataBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Fmp4TimedMetadataBehavior::from(s))
    }
}
impl Fmp4TimedMetadataBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Fmp4TimedMetadataBehavior::NoPassthrough => "NO_PASSTHROUGH",
            Fmp4TimedMetadataBehavior::Passthrough => "PASSTHROUGH",
            Fmp4TimedMetadataBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for Fmp4TimedMetadataBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Fmp4 Nielsen Id3 Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Fmp4NielsenId3Behavior {
    #[allow(missing_docs)] // documentation missing in model
    NoPassthrough,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Fmp4NielsenId3Behavior {
    fn from(s: &str) -> Self {
        match s {
            "NO_PASSTHROUGH" => Fmp4NielsenId3Behavior::NoPassthrough,
            "PASSTHROUGH" => Fmp4NielsenId3Behavior::Passthrough,
            other => Fmp4NielsenId3Behavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Fmp4NielsenId3Behavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Fmp4NielsenId3Behavior::from(s))
    }
}
impl Fmp4NielsenId3Behavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Fmp4NielsenId3Behavior::NoPassthrough => "NO_PASSTHROUGH",
            Fmp4NielsenId3Behavior::Passthrough => "PASSTHROUGH",
            Fmp4NielsenId3Behavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_PASSTHROUGH", "PASSTHROUGH"]
    }
}
impl AsRef<str> for Fmp4NielsenId3Behavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Audio Only Hls Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AudioOnlyHlsSettings {
    /// Specifies the group to which the audio Rendition belongs.
    pub audio_group_id: std::option::Option<std::string::String>,
    /// Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a low bit-size file because the image increases the output audio bandwidth.
    ///
    /// The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native Frames" standard.
    pub audio_only_image: std::option::Option<crate::model::InputLocation>,
    /// Four types of audio-only tracks are supported:
    ///
    /// Audio-Only Variant Stream
    /// The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
    ///
    /// Alternate Audio, Auto Select, Default
    /// Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
    ///
    /// Alternate Audio, Auto Select, Not Default
    /// Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
    ///
    /// Alternate Audio, not Auto Select
    /// Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
    pub audio_track_type: std::option::Option<crate::model::AudioOnlyHlsTrackType>,
    /// Specifies the segment type.
    pub segment_type: std::option::Option<crate::model::AudioOnlyHlsSegmentType>,
}
impl std::fmt::Debug for AudioOnlyHlsSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AudioOnlyHlsSettings");
        formatter.field("audio_group_id", &self.audio_group_id);
        formatter.field("audio_only_image", &self.audio_only_image);
        formatter.field("audio_track_type", &self.audio_track_type);
        formatter.field("segment_type", &self.segment_type);
        formatter.finish()
    }
}
/// See [`AudioOnlyHlsSettings`](crate::model::AudioOnlyHlsSettings)
pub mod audio_only_hls_settings {
    /// A builder for [`AudioOnlyHlsSettings`](crate::model::AudioOnlyHlsSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_group_id: std::option::Option<std::string::String>,
        pub(crate) audio_only_image: std::option::Option<crate::model::InputLocation>,
        pub(crate) audio_track_type: std::option::Option<crate::model::AudioOnlyHlsTrackType>,
        pub(crate) segment_type: std::option::Option<crate::model::AudioOnlyHlsSegmentType>,
    }
    impl Builder {
        /// Specifies the group to which the audio Rendition belongs.
        pub fn audio_group_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.audio_group_id = Some(input.into());
            self
        }
        /// Specifies the group to which the audio Rendition belongs.
        pub fn set_audio_group_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.audio_group_id = input;
            self
        }
        /// Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a low bit-size file because the image increases the output audio bandwidth.
        ///
        /// The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native Frames" standard.
        pub fn audio_only_image(mut self, input: crate::model::InputLocation) -> Self {
            self.audio_only_image = Some(input);
            self
        }
        /// Optional. Specifies the .jpg or .png image to use as the cover art for an audio-only output. We recommend a low bit-size file because the image increases the output audio bandwidth.
        ///
        /// The image is attached to the audio as an ID3 tag, frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native Frames" standard.
        pub fn set_audio_only_image(
            mut self,
            input: std::option::Option<crate::model::InputLocation>,
        ) -> Self {
            self.audio_only_image = input;
            self
        }
        /// Four types of audio-only tracks are supported:
        ///
        /// Audio-Only Variant Stream
        /// The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
        ///
        /// Alternate Audio, Auto Select, Default
        /// Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
        ///
        /// Alternate Audio, Auto Select, Not Default
        /// Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
        ///
        /// Alternate Audio, not Auto Select
        /// Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
        pub fn audio_track_type(mut self, input: crate::model::AudioOnlyHlsTrackType) -> Self {
            self.audio_track_type = Some(input);
            self
        }
        /// Four types of audio-only tracks are supported:
        ///
        /// Audio-Only Variant Stream
        /// The client can play back this audio-only stream instead of video in low-bandwidth scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest.
        ///
        /// Alternate Audio, Auto Select, Default
        /// Alternate rendition that the client should try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=YES, AUTOSELECT=YES
        ///
        /// Alternate Audio, Auto Select, Not Default
        /// Alternate rendition that the client may try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES
        ///
        /// Alternate Audio, not Auto Select
        /// Alternate rendition that the client will not try to play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=NO
        pub fn set_audio_track_type(
            mut self,
            input: std::option::Option<crate::model::AudioOnlyHlsTrackType>,
        ) -> Self {
            self.audio_track_type = input;
            self
        }
        /// Specifies the segment type.
        pub fn segment_type(mut self, input: crate::model::AudioOnlyHlsSegmentType) -> Self {
            self.segment_type = Some(input);
            self
        }
        /// Specifies the segment type.
        pub fn set_segment_type(
            mut self,
            input: std::option::Option<crate::model::AudioOnlyHlsSegmentType>,
        ) -> Self {
            self.segment_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AudioOnlyHlsSettings`](crate::model::AudioOnlyHlsSettings)
        pub fn build(self) -> crate::model::AudioOnlyHlsSettings {
            crate::model::AudioOnlyHlsSettings {
                audio_group_id: self.audio_group_id,
                audio_only_image: self.audio_only_image,
                audio_track_type: self.audio_track_type,
                segment_type: self.segment_type,
            }
        }
    }
}
impl AudioOnlyHlsSettings {
    /// Creates a new builder-style object to manufacture [`AudioOnlyHlsSettings`](crate::model::AudioOnlyHlsSettings)
    pub fn builder() -> crate::model::audio_only_hls_settings::Builder {
        crate::model::audio_only_hls_settings::Builder::default()
    }
}

/// Audio Only Hls Segment Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AudioOnlyHlsSegmentType {
    #[allow(missing_docs)] // documentation missing in model
    Aac,
    #[allow(missing_docs)] // documentation missing in model
    Fmp4,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AudioOnlyHlsSegmentType {
    fn from(s: &str) -> Self {
        match s {
            "AAC" => AudioOnlyHlsSegmentType::Aac,
            "FMP4" => AudioOnlyHlsSegmentType::Fmp4,
            other => AudioOnlyHlsSegmentType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AudioOnlyHlsSegmentType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AudioOnlyHlsSegmentType::from(s))
    }
}
impl AudioOnlyHlsSegmentType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AudioOnlyHlsSegmentType::Aac => "AAC",
            AudioOnlyHlsSegmentType::Fmp4 => "FMP4",
            AudioOnlyHlsSegmentType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AAC", "FMP4"]
    }
}
impl AsRef<str> for AudioOnlyHlsSegmentType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Audio Only Hls Track Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AudioOnlyHlsTrackType {
    #[allow(missing_docs)] // documentation missing in model
    AlternateAudioAutoSelect,
    #[allow(missing_docs)] // documentation missing in model
    AlternateAudioAutoSelectDefault,
    #[allow(missing_docs)] // documentation missing in model
    AlternateAudioNotAutoSelect,
    #[allow(missing_docs)] // documentation missing in model
    AudioOnlyVariantStream,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AudioOnlyHlsTrackType {
    fn from(s: &str) -> Self {
        match s {
            "ALTERNATE_AUDIO_AUTO_SELECT" => AudioOnlyHlsTrackType::AlternateAudioAutoSelect,
            "ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT" => {
                AudioOnlyHlsTrackType::AlternateAudioAutoSelectDefault
            }
            "ALTERNATE_AUDIO_NOT_AUTO_SELECT" => AudioOnlyHlsTrackType::AlternateAudioNotAutoSelect,
            "AUDIO_ONLY_VARIANT_STREAM" => AudioOnlyHlsTrackType::AudioOnlyVariantStream,
            other => AudioOnlyHlsTrackType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AudioOnlyHlsTrackType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AudioOnlyHlsTrackType::from(s))
    }
}
impl AudioOnlyHlsTrackType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AudioOnlyHlsTrackType::AlternateAudioAutoSelect => "ALTERNATE_AUDIO_AUTO_SELECT",
            AudioOnlyHlsTrackType::AlternateAudioAutoSelectDefault => {
                "ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT"
            }
            AudioOnlyHlsTrackType::AlternateAudioNotAutoSelect => "ALTERNATE_AUDIO_NOT_AUTO_SELECT",
            AudioOnlyHlsTrackType::AudioOnlyVariantStream => "AUDIO_ONLY_VARIANT_STREAM",
            AudioOnlyHlsTrackType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ALTERNATE_AUDIO_AUTO_SELECT",
            "ALTERNATE_AUDIO_AUTO_SELECT_DEFAULT",
            "ALTERNATE_AUDIO_NOT_AUTO_SELECT",
            "AUDIO_ONLY_VARIANT_STREAM",
        ]
    }
}
impl AsRef<str> for AudioOnlyHlsTrackType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Location
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputLocation {
    /// key used to extract the password from EC2 Parameter store
    pub password_param: std::option::Option<std::string::String>,
    /// Uniform Resource Identifier - This should be a path to a file accessible to the Live system (eg. a http:// URI) depending on the output type. For example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
    pub uri: std::option::Option<std::string::String>,
    /// Documentation update needed
    pub username: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InputLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputLocation");
        formatter.field("password_param", &self.password_param);
        formatter.field("uri", &self.uri);
        formatter.field("username", &self.username);
        formatter.finish()
    }
}
/// See [`InputLocation`](crate::model::InputLocation)
pub mod input_location {
    /// A builder for [`InputLocation`](crate::model::InputLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) password_param: std::option::Option<std::string::String>,
        pub(crate) uri: std::option::Option<std::string::String>,
        pub(crate) username: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// key used to extract the password from EC2 Parameter store
        pub fn password_param(mut self, input: impl Into<std::string::String>) -> Self {
            self.password_param = Some(input.into());
            self
        }
        /// key used to extract the password from EC2 Parameter store
        pub fn set_password_param(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.password_param = input;
            self
        }
        /// Uniform Resource Identifier - This should be a path to a file accessible to the Live system (eg. a http:// URI) depending on the output type. For example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
        pub fn uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.uri = Some(input.into());
            self
        }
        /// Uniform Resource Identifier - This should be a path to a file accessible to the Live system (eg. a http:// URI) depending on the output type. For example, a RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
        pub fn set_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.uri = input;
            self
        }
        /// Documentation update needed
        pub fn username(mut self, input: impl Into<std::string::String>) -> Self {
            self.username = Some(input.into());
            self
        }
        /// Documentation update needed
        pub fn set_username(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.username = input;
            self
        }
        /// Consumes the builder and constructs a [`InputLocation`](crate::model::InputLocation)
        pub fn build(self) -> crate::model::InputLocation {
            crate::model::InputLocation {
                password_param: self.password_param,
                uri: self.uri,
                username: self.username,
            }
        }
    }
}
impl InputLocation {
    /// Creates a new builder-style object to manufacture [`InputLocation`](crate::model::InputLocation)
    pub fn builder() -> crate::model::input_location::Builder {
        crate::model::input_location::Builder::default()
    }
}

/// Hls H265 Packaging Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum HlsH265PackagingType {
    #[allow(missing_docs)] // documentation missing in model
    Hev1,
    #[allow(missing_docs)] // documentation missing in model
    Hvc1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for HlsH265PackagingType {
    fn from(s: &str) -> Self {
        match s {
            "HEV1" => HlsH265PackagingType::Hev1,
            "HVC1" => HlsH265PackagingType::Hvc1,
            other => HlsH265PackagingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for HlsH265PackagingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(HlsH265PackagingType::from(s))
    }
}
impl HlsH265PackagingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            HlsH265PackagingType::Hev1 => "HEV1",
            HlsH265PackagingType::Hvc1 => "HVC1",
            HlsH265PackagingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEV1", "HVC1"]
    }
}
impl AsRef<str> for HlsH265PackagingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Frame Capture Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FrameCaptureOutputSettings {
    /// Required if the output group contains more than one output. This modifier forms part of the output file name.
    pub name_modifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for FrameCaptureOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FrameCaptureOutputSettings");
        formatter.field("name_modifier", &self.name_modifier);
        formatter.finish()
    }
}
/// See [`FrameCaptureOutputSettings`](crate::model::FrameCaptureOutputSettings)
pub mod frame_capture_output_settings {
    /// A builder for [`FrameCaptureOutputSettings`](crate::model::FrameCaptureOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name_modifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Required if the output group contains more than one output. This modifier forms part of the output file name.
        pub fn name_modifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_modifier = Some(input.into());
            self
        }
        /// Required if the output group contains more than one output. This modifier forms part of the output file name.
        pub fn set_name_modifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_modifier = input;
            self
        }
        /// Consumes the builder and constructs a [`FrameCaptureOutputSettings`](crate::model::FrameCaptureOutputSettings)
        pub fn build(self) -> crate::model::FrameCaptureOutputSettings {
            crate::model::FrameCaptureOutputSettings {
                name_modifier: self.name_modifier,
            }
        }
    }
}
impl FrameCaptureOutputSettings {
    /// Creates a new builder-style object to manufacture [`FrameCaptureOutputSettings`](crate::model::FrameCaptureOutputSettings)
    pub fn builder() -> crate::model::frame_capture_output_settings::Builder {
        crate::model::frame_capture_output_settings::Builder::default()
    }
}

/// Archive Output Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArchiveOutputSettings {
    /// Settings specific to the container type of the file.
    pub container_settings: std::option::Option<crate::model::ArchiveContainerSettings>,
    /// Output file extension. If excluded, this will be auto-selected from the container type.
    pub extension: std::option::Option<std::string::String>,
    /// String concatenated to the end of the destination filename.  Required for multiple outputs of the same type.
    pub name_modifier: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ArchiveOutputSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArchiveOutputSettings");
        formatter.field("container_settings", &self.container_settings);
        formatter.field("extension", &self.extension);
        formatter.field("name_modifier", &self.name_modifier);
        formatter.finish()
    }
}
/// See [`ArchiveOutputSettings`](crate::model::ArchiveOutputSettings)
pub mod archive_output_settings {
    /// A builder for [`ArchiveOutputSettings`](crate::model::ArchiveOutputSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) container_settings: std::option::Option<crate::model::ArchiveContainerSettings>,
        pub(crate) extension: std::option::Option<std::string::String>,
        pub(crate) name_modifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Settings specific to the container type of the file.
        pub fn container_settings(mut self, input: crate::model::ArchiveContainerSettings) -> Self {
            self.container_settings = Some(input);
            self
        }
        /// Settings specific to the container type of the file.
        pub fn set_container_settings(
            mut self,
            input: std::option::Option<crate::model::ArchiveContainerSettings>,
        ) -> Self {
            self.container_settings = input;
            self
        }
        /// Output file extension. If excluded, this will be auto-selected from the container type.
        pub fn extension(mut self, input: impl Into<std::string::String>) -> Self {
            self.extension = Some(input.into());
            self
        }
        /// Output file extension. If excluded, this will be auto-selected from the container type.
        pub fn set_extension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.extension = input;
            self
        }
        /// String concatenated to the end of the destination filename.  Required for multiple outputs of the same type.
        pub fn name_modifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.name_modifier = Some(input.into());
            self
        }
        /// String concatenated to the end of the destination filename.  Required for multiple outputs of the same type.
        pub fn set_name_modifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.name_modifier = input;
            self
        }
        /// Consumes the builder and constructs a [`ArchiveOutputSettings`](crate::model::ArchiveOutputSettings)
        pub fn build(self) -> crate::model::ArchiveOutputSettings {
            crate::model::ArchiveOutputSettings {
                container_settings: self.container_settings,
                extension: self.extension,
                name_modifier: self.name_modifier,
            }
        }
    }
}
impl ArchiveOutputSettings {
    /// Creates a new builder-style object to manufacture [`ArchiveOutputSettings`](crate::model::ArchiveOutputSettings)
    pub fn builder() -> crate::model::archive_output_settings::Builder {
        crate::model::archive_output_settings::Builder::default()
    }
}

/// Archive Container Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ArchiveContainerSettings {
    /// M2ts Settings
    pub m2ts_settings: std::option::Option<crate::model::M2tsSettings>,
    /// Raw Settings
    pub raw_settings: std::option::Option<crate::model::RawSettings>,
}
impl std::fmt::Debug for ArchiveContainerSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ArchiveContainerSettings");
        formatter.field("m2ts_settings", &self.m2ts_settings);
        formatter.field("raw_settings", &self.raw_settings);
        formatter.finish()
    }
}
/// See [`ArchiveContainerSettings`](crate::model::ArchiveContainerSettings)
pub mod archive_container_settings {
    /// A builder for [`ArchiveContainerSettings`](crate::model::ArchiveContainerSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) m2ts_settings: std::option::Option<crate::model::M2tsSettings>,
        pub(crate) raw_settings: std::option::Option<crate::model::RawSettings>,
    }
    impl Builder {
        /// M2ts Settings
        pub fn m2ts_settings(mut self, input: crate::model::M2tsSettings) -> Self {
            self.m2ts_settings = Some(input);
            self
        }
        /// M2ts Settings
        pub fn set_m2ts_settings(
            mut self,
            input: std::option::Option<crate::model::M2tsSettings>,
        ) -> Self {
            self.m2ts_settings = input;
            self
        }
        /// Raw Settings
        pub fn raw_settings(mut self, input: crate::model::RawSettings) -> Self {
            self.raw_settings = Some(input);
            self
        }
        /// Raw Settings
        pub fn set_raw_settings(
            mut self,
            input: std::option::Option<crate::model::RawSettings>,
        ) -> Self {
            self.raw_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`ArchiveContainerSettings`](crate::model::ArchiveContainerSettings)
        pub fn build(self) -> crate::model::ArchiveContainerSettings {
            crate::model::ArchiveContainerSettings {
                m2ts_settings: self.m2ts_settings,
                raw_settings: self.raw_settings,
            }
        }
    }
}
impl ArchiveContainerSettings {
    /// Creates a new builder-style object to manufacture [`ArchiveContainerSettings`](crate::model::ArchiveContainerSettings)
    pub fn builder() -> crate::model::archive_container_settings::Builder {
        crate::model::archive_container_settings::Builder::default()
    }
}

/// Raw Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RawSettings {}
impl std::fmt::Debug for RawSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RawSettings");
        formatter.finish()
    }
}
/// See [`RawSettings`](crate::model::RawSettings)
pub mod raw_settings {
    /// A builder for [`RawSettings`](crate::model::RawSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`RawSettings`](crate::model::RawSettings)
        pub fn build(self) -> crate::model::RawSettings {
            crate::model::RawSettings {}
        }
    }
}
impl RawSettings {
    /// Creates a new builder-style object to manufacture [`RawSettings`](crate::model::RawSettings)
    pub fn builder() -> crate::model::raw_settings::Builder {
        crate::model::raw_settings::Builder::default()
    }
}

/// Output Group Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct OutputGroupSettings {
    /// Archive Group Settings
    pub archive_group_settings: std::option::Option<crate::model::ArchiveGroupSettings>,
    /// Frame Capture Group Settings
    pub frame_capture_group_settings: std::option::Option<crate::model::FrameCaptureGroupSettings>,
    /// Hls Group Settings
    pub hls_group_settings: std::option::Option<crate::model::HlsGroupSettings>,
    /// Media Package Group Settings
    pub media_package_group_settings: std::option::Option<crate::model::MediaPackageGroupSettings>,
    /// Ms Smooth Group Settings
    pub ms_smooth_group_settings: std::option::Option<crate::model::MsSmoothGroupSettings>,
    /// Multiplex Group Settings
    pub multiplex_group_settings: std::option::Option<crate::model::MultiplexGroupSettings>,
    /// Rtmp Group Settings
    pub rtmp_group_settings: std::option::Option<crate::model::RtmpGroupSettings>,
    /// Udp Group Settings
    pub udp_group_settings: std::option::Option<crate::model::UdpGroupSettings>,
}
impl std::fmt::Debug for OutputGroupSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("OutputGroupSettings");
        formatter.field("archive_group_settings", &self.archive_group_settings);
        formatter.field(
            "frame_capture_group_settings",
            &self.frame_capture_group_settings,
        );
        formatter.field("hls_group_settings", &self.hls_group_settings);
        formatter.field(
            "media_package_group_settings",
            &self.media_package_group_settings,
        );
        formatter.field("ms_smooth_group_settings", &self.ms_smooth_group_settings);
        formatter.field("multiplex_group_settings", &self.multiplex_group_settings);
        formatter.field("rtmp_group_settings", &self.rtmp_group_settings);
        formatter.field("udp_group_settings", &self.udp_group_settings);
        formatter.finish()
    }
}
/// See [`OutputGroupSettings`](crate::model::OutputGroupSettings)
pub mod output_group_settings {
    /// A builder for [`OutputGroupSettings`](crate::model::OutputGroupSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) archive_group_settings: std::option::Option<crate::model::ArchiveGroupSettings>,
        pub(crate) frame_capture_group_settings:
            std::option::Option<crate::model::FrameCaptureGroupSettings>,
        pub(crate) hls_group_settings: std::option::Option<crate::model::HlsGroupSettings>,
        pub(crate) media_package_group_settings:
            std::option::Option<crate::model::MediaPackageGroupSettings>,
        pub(crate) ms_smooth_group_settings:
            std::option::Option<crate::model::MsSmoothGroupSettings>,
        pub(crate) multiplex_group_settings:
            std::option::Option<crate::model::MultiplexGroupSettings>,
        pub(crate) rtmp_group_settings: std::option::Option<crate::model::RtmpGroupSettings>,
        pub(crate) udp_group_settings: std::option::Option<crate::model::UdpGroupSettings>,
    }
    impl Builder {
        /// Archive Group Settings
        pub fn archive_group_settings(mut self, input: crate::model::ArchiveGroupSettings) -> Self {
            self.archive_group_settings = Some(input);
            self
        }
        /// Archive Group Settings
        pub fn set_archive_group_settings(
            mut self,
            input: std::option::Option<crate::model::ArchiveGroupSettings>,
        ) -> Self {
            self.archive_group_settings = input;
            self
        }
        /// Frame Capture Group Settings
        pub fn frame_capture_group_settings(
            mut self,
            input: crate::model::FrameCaptureGroupSettings,
        ) -> Self {
            self.frame_capture_group_settings = Some(input);
            self
        }
        /// Frame Capture Group Settings
        pub fn set_frame_capture_group_settings(
            mut self,
            input: std::option::Option<crate::model::FrameCaptureGroupSettings>,
        ) -> Self {
            self.frame_capture_group_settings = input;
            self
        }
        /// Hls Group Settings
        pub fn hls_group_settings(mut self, input: crate::model::HlsGroupSettings) -> Self {
            self.hls_group_settings = Some(input);
            self
        }
        /// Hls Group Settings
        pub fn set_hls_group_settings(
            mut self,
            input: std::option::Option<crate::model::HlsGroupSettings>,
        ) -> Self {
            self.hls_group_settings = input;
            self
        }
        /// Media Package Group Settings
        pub fn media_package_group_settings(
            mut self,
            input: crate::model::MediaPackageGroupSettings,
        ) -> Self {
            self.media_package_group_settings = Some(input);
            self
        }
        /// Media Package Group Settings
        pub fn set_media_package_group_settings(
            mut self,
            input: std::option::Option<crate::model::MediaPackageGroupSettings>,
        ) -> Self {
            self.media_package_group_settings = input;
            self
        }
        /// Ms Smooth Group Settings
        pub fn ms_smooth_group_settings(
            mut self,
            input: crate::model::MsSmoothGroupSettings,
        ) -> Self {
            self.ms_smooth_group_settings = Some(input);
            self
        }
        /// Ms Smooth Group Settings
        pub fn set_ms_smooth_group_settings(
            mut self,
            input: std::option::Option<crate::model::MsSmoothGroupSettings>,
        ) -> Self {
            self.ms_smooth_group_settings = input;
            self
        }
        /// Multiplex Group Settings
        pub fn multiplex_group_settings(
            mut self,
            input: crate::model::MultiplexGroupSettings,
        ) -> Self {
            self.multiplex_group_settings = Some(input);
            self
        }
        /// Multiplex Group Settings
        pub fn set_multiplex_group_settings(
            mut self,
            input: std::option::Option<crate::model::MultiplexGroupSettings>,
        ) -> Self {
            self.multiplex_group_settings = input;
            self
        }
        /// Rtmp Group Settings
        pub fn rtmp_group_settings(mut self, input: crate::model::RtmpGroupSettings) -> Self {
            self.rtmp_group_settings = Some(input);
            self
        }
        /// Rtmp Group Settings
        pub fn set_rtmp_group_settings(
            mut self,
            input: std::option::Option<crate::model::RtmpGroupSettings>,
        ) -> Self {
            self.rtmp_group_settings = input;
            self
        }
        /// Udp Group Settings
        pub fn udp_group_settings(mut self, input: crate::model::UdpGroupSettings) -> Self {
            self.udp_group_settings = Some(input);
            self
        }
        /// Udp Group Settings
        pub fn set_udp_group_settings(
            mut self,
            input: std::option::Option<crate::model::UdpGroupSettings>,
        ) -> Self {
            self.udp_group_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`OutputGroupSettings`](crate::model::OutputGroupSettings)
        pub fn build(self) -> crate::model::OutputGroupSettings {
            crate::model::OutputGroupSettings {
                archive_group_settings: self.archive_group_settings,
                frame_capture_group_settings: self.frame_capture_group_settings,
                hls_group_settings: self.hls_group_settings,
                media_package_group_settings: self.media_package_group_settings,
                ms_smooth_group_settings: self.ms_smooth_group_settings,
                multiplex_group_settings: self.multiplex_group_settings,
                rtmp_group_settings: self.rtmp_group_settings,
                udp_group_settings: self.udp_group_settings,
            }
        }
    }
}
impl OutputGroupSettings {
    /// Creates a new builder-style object to manufacture [`OutputGroupSettings`](crate::model::OutputGroupSettings)
    pub fn builder() -> crate::model::output_group_settings::Builder {
        crate::model::output_group_settings::Builder::default()
    }
}

/// Udp Group Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UdpGroupSettings {
    /// Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs is selected the entire transport stream will stop being emitted.  When dropProgram is selected the program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement).  Or, when emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black frames, or slate frames substituted for the absent input video.
    pub input_loss_action: std::option::Option<crate::model::InputLossActionForUdpOut>,
    /// Indicates ID3 frame that has the timecode.
    pub timed_metadata_id3_frame: std::option::Option<crate::model::UdpTimedMetadataId3Frame>,
    /// Timed Metadata interval in seconds.
    pub timed_metadata_id3_period: i32,
}
impl std::fmt::Debug for UdpGroupSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UdpGroupSettings");
        formatter.field("input_loss_action", &self.input_loss_action);
        formatter.field("timed_metadata_id3_frame", &self.timed_metadata_id3_frame);
        formatter.field("timed_metadata_id3_period", &self.timed_metadata_id3_period);
        formatter.finish()
    }
}
/// See [`UdpGroupSettings`](crate::model::UdpGroupSettings)
pub mod udp_group_settings {
    /// A builder for [`UdpGroupSettings`](crate::model::UdpGroupSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_loss_action: std::option::Option<crate::model::InputLossActionForUdpOut>,
        pub(crate) timed_metadata_id3_frame:
            std::option::Option<crate::model::UdpTimedMetadataId3Frame>,
        pub(crate) timed_metadata_id3_period: std::option::Option<i32>,
    }
    impl Builder {
        /// Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs is selected the entire transport stream will stop being emitted.  When dropProgram is selected the program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement).  Or, when emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black frames, or slate frames substituted for the absent input video.
        pub fn input_loss_action(mut self, input: crate::model::InputLossActionForUdpOut) -> Self {
            self.input_loss_action = Some(input);
            self
        }
        /// Specifies behavior of last resort when input video is lost, and no more backup inputs are available. When dropTs is selected the entire transport stream will stop being emitted.  When dropProgram is selected the program can be dropped from the transport stream (and replaced with null packets to meet the TS bitrate requirement).  Or, when emitProgram is chosen the transport stream will continue to be produced normally with repeat frames, black frames, or slate frames substituted for the absent input video.
        pub fn set_input_loss_action(
            mut self,
            input: std::option::Option<crate::model::InputLossActionForUdpOut>,
        ) -> Self {
            self.input_loss_action = input;
            self
        }
        /// Indicates ID3 frame that has the timecode.
        pub fn timed_metadata_id3_frame(
            mut self,
            input: crate::model::UdpTimedMetadataId3Frame,
        ) -> Self {
            self.timed_metadata_id3_frame = Some(input);
            self
        }
        /// Indicates ID3 frame that has the timecode.
        pub fn set_timed_metadata_id3_frame(
            mut self,
            input: std::option::Option<crate::model::UdpTimedMetadataId3Frame>,
        ) -> Self {
            self.timed_metadata_id3_frame = input;
            self
        }
        /// Timed Metadata interval in seconds.
        pub fn timed_metadata_id3_period(mut self, input: i32) -> Self {
            self.timed_metadata_id3_period = Some(input);
            self
        }
        /// Timed Metadata interval in seconds.
        pub fn set_timed_metadata_id3_period(mut self, input: std::option::Option<i32>) -> Self {
            self.timed_metadata_id3_period = input;
            self
        }
        /// Consumes the builder and constructs a [`UdpGroupSettings`](crate::model::UdpGroupSettings)
        pub fn build(self) -> crate::model::UdpGroupSettings {
            crate::model::UdpGroupSettings {
                input_loss_action: self.input_loss_action,
                timed_metadata_id3_frame: self.timed_metadata_id3_frame,
                timed_metadata_id3_period: self.timed_metadata_id3_period.unwrap_or_default(),
            }
        }
    }
}
impl UdpGroupSettings {
    /// Creates a new builder-style object to manufacture [`UdpGroupSettings`](crate::model::UdpGroupSettings)
    pub fn builder() -> crate::model::udp_group_settings::Builder {
        crate::model::udp_group_settings::Builder::default()
    }
}

/// Udp Timed Metadata Id3 Frame
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UdpTimedMetadataId3Frame {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Priv,
    #[allow(missing_docs)] // documentation missing in model
    Tdrl,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UdpTimedMetadataId3Frame {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => UdpTimedMetadataId3Frame::None,
            "PRIV" => UdpTimedMetadataId3Frame::Priv,
            "TDRL" => UdpTimedMetadataId3Frame::Tdrl,
            other => UdpTimedMetadataId3Frame::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UdpTimedMetadataId3Frame {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UdpTimedMetadataId3Frame::from(s))
    }
}
impl UdpTimedMetadataId3Frame {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UdpTimedMetadataId3Frame::None => "NONE",
            UdpTimedMetadataId3Frame::Priv => "PRIV",
            UdpTimedMetadataId3Frame::Tdrl => "TDRL",
            UdpTimedMetadataId3Frame::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PRIV", "TDRL"]
    }
}
impl AsRef<str> for UdpTimedMetadataId3Frame {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Loss Action For Udp Out
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputLossActionForUdpOut {
    #[allow(missing_docs)] // documentation missing in model
    DropProgram,
    #[allow(missing_docs)] // documentation missing in model
    DropTs,
    #[allow(missing_docs)] // documentation missing in model
    EmitProgram,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputLossActionForUdpOut {
    fn from(s: &str) -> Self {
        match s {
            "DROP_PROGRAM" => InputLossActionForUdpOut::DropProgram,
            "DROP_TS" => InputLossActionForUdpOut::DropTs,
            "EMIT_PROGRAM" => InputLossActionForUdpOut::EmitProgram,
            other => InputLossActionForUdpOut::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputLossActionForUdpOut {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputLossActionForUdpOut::from(s))
    }
}
impl InputLossActionForUdpOut {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputLossActionForUdpOut::DropProgram => "DROP_PROGRAM",
            InputLossActionForUdpOut::DropTs => "DROP_TS",
            InputLossActionForUdpOut::EmitProgram => "EMIT_PROGRAM",
            InputLossActionForUdpOut::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DROP_PROGRAM", "DROP_TS", "EMIT_PROGRAM"]
    }
}
impl AsRef<str> for InputLossActionForUdpOut {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Rtmp Group Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RtmpGroupSettings {
    /// Choose the ad marker type for this output group. MediaLive will create a message based on the content of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
    pub ad_markers: std::option::Option<std::vec::Vec<crate::model::RtmpAdMarkers>>,
    /// Authentication scheme to use when connecting with CDN
    pub authentication_scheme: std::option::Option<crate::model::AuthenticationScheme>,
    /// Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data again.
    pub cache_full_behavior: std::option::Option<crate::model::RtmpCacheFullBehavior>,
    /// Cache length, in seconds, is used to calculate buffer size.
    pub cache_length: i32,
    /// Controls the types of data that passes to onCaptionInfo outputs.  If set to 'all' then 608 and 708 carried DTVCC data will be passed.  If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video will be passed.
    pub caption_data: std::option::Option<crate::model::RtmpCaptionData>,
    /// Controls the behavior of this RTMP group if input becomes unavailable.
    ///
    /// - emitOutput: Emit a slate until input returns.
    /// - pauseOutput: Stop transmitting data until input returns. This does not close the underlying RTMP connection.
    pub input_loss_action: std::option::Option<crate::model::InputLossActionForRtmpOut>,
    /// If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.
    pub restart_delay: i32,
}
impl std::fmt::Debug for RtmpGroupSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RtmpGroupSettings");
        formatter.field("ad_markers", &self.ad_markers);
        formatter.field("authentication_scheme", &self.authentication_scheme);
        formatter.field("cache_full_behavior", &self.cache_full_behavior);
        formatter.field("cache_length", &self.cache_length);
        formatter.field("caption_data", &self.caption_data);
        formatter.field("input_loss_action", &self.input_loss_action);
        formatter.field("restart_delay", &self.restart_delay);
        formatter.finish()
    }
}
/// See [`RtmpGroupSettings`](crate::model::RtmpGroupSettings)
pub mod rtmp_group_settings {
    /// A builder for [`RtmpGroupSettings`](crate::model::RtmpGroupSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ad_markers: std::option::Option<std::vec::Vec<crate::model::RtmpAdMarkers>>,
        pub(crate) authentication_scheme: std::option::Option<crate::model::AuthenticationScheme>,
        pub(crate) cache_full_behavior: std::option::Option<crate::model::RtmpCacheFullBehavior>,
        pub(crate) cache_length: std::option::Option<i32>,
        pub(crate) caption_data: std::option::Option<crate::model::RtmpCaptionData>,
        pub(crate) input_loss_action: std::option::Option<crate::model::InputLossActionForRtmpOut>,
        pub(crate) restart_delay: std::option::Option<i32>,
    }
    impl Builder {
        /// Appends an item to `ad_markers`.
        ///
        /// To override the contents of this collection use [`set_ad_markers`](Self::set_ad_markers).
        ///
        /// Choose the ad marker type for this output group. MediaLive will create a message based on the content of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
        pub fn ad_markers(mut self, input: impl Into<crate::model::RtmpAdMarkers>) -> Self {
            let mut v = self.ad_markers.unwrap_or_default();
            v.push(input.into());
            self.ad_markers = Some(v);
            self
        }
        /// Choose the ad marker type for this output group. MediaLive will create a message based on the content of each SCTE-35 message, format it for that marker type, and insert it in the datastream.
        pub fn set_ad_markers(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RtmpAdMarkers>>,
        ) -> Self {
            self.ad_markers = input;
            self
        }
        /// Authentication scheme to use when connecting with CDN
        pub fn authentication_scheme(mut self, input: crate::model::AuthenticationScheme) -> Self {
            self.authentication_scheme = Some(input);
            self
        }
        /// Authentication scheme to use when connecting with CDN
        pub fn set_authentication_scheme(
            mut self,
            input: std::option::Option<crate::model::AuthenticationScheme>,
        ) -> Self {
            self.authentication_scheme = input;
            self
        }
        /// Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data again.
        pub fn cache_full_behavior(mut self, input: crate::model::RtmpCacheFullBehavior) -> Self {
            self.cache_full_behavior = Some(input);
            self
        }
        /// Controls behavior when content cache fills up. If remote origin server stalls the RTMP connection and does not accept content fast enough the 'Media Cache' will fill up. When the cache reaches the duration specified by cacheLength the cache will stop accepting new content. If set to disconnectImmediately, the RTMP output will force a disconnect. Clear the media cache, and reconnect after restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5 minutes to allow the origin server to begin accepting data again.
        pub fn set_cache_full_behavior(
            mut self,
            input: std::option::Option<crate::model::RtmpCacheFullBehavior>,
        ) -> Self {
            self.cache_full_behavior = input;
            self
        }
        /// Cache length, in seconds, is used to calculate buffer size.
        pub fn cache_length(mut self, input: i32) -> Self {
            self.cache_length = Some(input);
            self
        }
        /// Cache length, in seconds, is used to calculate buffer size.
        pub fn set_cache_length(mut self, input: std::option::Option<i32>) -> Self {
            self.cache_length = input;
            self
        }
        /// Controls the types of data that passes to onCaptionInfo outputs.  If set to 'all' then 608 and 708 carried DTVCC data will be passed.  If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video will be passed.
        pub fn caption_data(mut self, input: crate::model::RtmpCaptionData) -> Self {
            self.caption_data = Some(input);
            self
        }
        /// Controls the types of data that passes to onCaptionInfo outputs.  If set to 'all' then 608 and 708 carried DTVCC data will be passed.  If set to 'field1AndField2608' then DTVCC data will be stripped out, but 608 data from both fields will be passed. If set to 'field1608' then only the data carried in 608 from field 1 video will be passed.
        pub fn set_caption_data(
            mut self,
            input: std::option::Option<crate::model::RtmpCaptionData>,
        ) -> Self {
            self.caption_data = input;
            self
        }
        /// Controls the behavior of this RTMP group if input becomes unavailable.
        ///
        /// - emitOutput: Emit a slate until input returns.
        /// - pauseOutput: Stop transmitting data until input returns. This does not close the underlying RTMP connection.
        pub fn input_loss_action(mut self, input: crate::model::InputLossActionForRtmpOut) -> Self {
            self.input_loss_action = Some(input);
            self
        }
        /// Controls the behavior of this RTMP group if input becomes unavailable.
        ///
        /// - emitOutput: Emit a slate until input returns.
        /// - pauseOutput: Stop transmitting data until input returns. This does not close the underlying RTMP connection.
        pub fn set_input_loss_action(
            mut self,
            input: std::option::Option<crate::model::InputLossActionForRtmpOut>,
        ) -> Self {
            self.input_loss_action = input;
            self
        }
        /// If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.
        pub fn restart_delay(mut self, input: i32) -> Self {
            self.restart_delay = Some(input);
            self
        }
        /// If a streaming output fails, number of seconds to wait until a restart is initiated. A value of 0 means never restart.
        pub fn set_restart_delay(mut self, input: std::option::Option<i32>) -> Self {
            self.restart_delay = input;
            self
        }
        /// Consumes the builder and constructs a [`RtmpGroupSettings`](crate::model::RtmpGroupSettings)
        pub fn build(self) -> crate::model::RtmpGroupSettings {
            crate::model::RtmpGroupSettings {
                ad_markers: self.ad_markers,
                authentication_scheme: self.authentication_scheme,
                cache_full_behavior: self.cache_full_behavior,
                cache_length: self.cache_length.unwrap_or_default(),
                caption_data: self.caption_data,
                input_loss_action: self.input_loss_action,
                restart_delay: self.restart_delay.unwrap_or_default(),
            }
        }
    }
}
impl RtmpGroupSettings {
    /// Creates a new builder-style object to manufacture [`RtmpGroupSettings`](crate::model::RtmpGroupSettings)
    pub fn builder() -> crate::model::rtmp_group_settings::Builder {
        crate::model::rtmp_group_settings::Builder::default()
    }
}

/// Input Loss Action For Rtmp Out
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputLossActionForRtmpOut {
    #[allow(missing_docs)] // documentation missing in model
    EmitOutput,
    #[allow(missing_docs)] // documentation missing in model
    PauseOutput,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputLossActionForRtmpOut {
    fn from(s: &str) -> Self {
        match s {
            "EMIT_OUTPUT" => InputLossActionForRtmpOut::EmitOutput,
            "PAUSE_OUTPUT" => InputLossActionForRtmpOut::PauseOutput,
            other => InputLossActionForRtmpOut::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputLossActionForRtmpOut {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputLossActionForRtmpOut::from(s))
    }
}
impl InputLossActionForRtmpOut {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputLossActionForRtmpOut::EmitOutput => "EMIT_OUTPUT",
            InputLossActionForRtmpOut::PauseOutput => "PAUSE_OUTPUT",
            InputLossActionForRtmpOut::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMIT_OUTPUT", "PAUSE_OUTPUT"]
    }
}
impl AsRef<str> for InputLossActionForRtmpOut {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Rtmp Caption Data
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RtmpCaptionData {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Field1608,
    #[allow(missing_docs)] // documentation missing in model
    Field1AndField2608,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RtmpCaptionData {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => RtmpCaptionData::All,
            "FIELD1_608" => RtmpCaptionData::Field1608,
            "FIELD1_AND_FIELD2_608" => RtmpCaptionData::Field1AndField2608,
            other => RtmpCaptionData::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RtmpCaptionData {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RtmpCaptionData::from(s))
    }
}
impl RtmpCaptionData {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RtmpCaptionData::All => "ALL",
            RtmpCaptionData::Field1608 => "FIELD1_608",
            RtmpCaptionData::Field1AndField2608 => "FIELD1_AND_FIELD2_608",
            RtmpCaptionData::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "FIELD1_608", "FIELD1_AND_FIELD2_608"]
    }
}
impl AsRef<str> for RtmpCaptionData {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Rtmp Cache Full Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RtmpCacheFullBehavior {
    #[allow(missing_docs)] // documentation missing in model
    DisconnectImmediately,
    #[allow(missing_docs)] // documentation missing in model
    WaitForServer,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RtmpCacheFullBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DISCONNECT_IMMEDIATELY" => RtmpCacheFullBehavior::DisconnectImmediately,
            "WAIT_FOR_SERVER" => RtmpCacheFullBehavior::WaitForServer,
            other => RtmpCacheFullBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RtmpCacheFullBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RtmpCacheFullBehavior::from(s))
    }
}
impl RtmpCacheFullBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RtmpCacheFullBehavior::DisconnectImmediately => "DISCONNECT_IMMEDIATELY",
            RtmpCacheFullBehavior::WaitForServer => "WAIT_FOR_SERVER",
            RtmpCacheFullBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISCONNECT_IMMEDIATELY", "WAIT_FOR_SERVER"]
    }
}
impl AsRef<str> for RtmpCacheFullBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Authentication Scheme
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AuthenticationScheme {
    #[allow(missing_docs)] // documentation missing in model
    Akamai,
    #[allow(missing_docs)] // documentation missing in model
    Common,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AuthenticationScheme {
    fn from(s: &str) -> Self {
        match s {
            "AKAMAI" => AuthenticationScheme::Akamai,
            "COMMON" => AuthenticationScheme::Common,
            other => AuthenticationScheme::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AuthenticationScheme {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AuthenticationScheme::from(s))
    }
}
impl AuthenticationScheme {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AuthenticationScheme::Akamai => "AKAMAI",
            AuthenticationScheme::Common => "COMMON",
            AuthenticationScheme::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AKAMAI", "COMMON"]
    }
}
impl AsRef<str> for AuthenticationScheme {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Rtmp Ad Markers
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RtmpAdMarkers {
    #[allow(missing_docs)] // documentation missing in model
    OnCuePointScte35,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RtmpAdMarkers {
    fn from(s: &str) -> Self {
        match s {
            "ON_CUE_POINT_SCTE35" => RtmpAdMarkers::OnCuePointScte35,
            other => RtmpAdMarkers::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RtmpAdMarkers {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RtmpAdMarkers::from(s))
    }
}
impl RtmpAdMarkers {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RtmpAdMarkers::OnCuePointScte35 => "ON_CUE_POINT_SCTE35",
            RtmpAdMarkers::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_CUE_POINT_SCTE35"]
    }
}
impl AsRef<str> for RtmpAdMarkers {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Multiplex Group Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MultiplexGroupSettings {}
impl std::fmt::Debug for MultiplexGroupSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MultiplexGroupSettings");
        formatter.finish()
    }
}
/// See [`MultiplexGroupSettings`](crate::model::MultiplexGroupSettings)
pub mod multiplex_group_settings {
    /// A builder for [`MultiplexGroupSettings`](crate::model::MultiplexGroupSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`MultiplexGroupSettings`](crate::model::MultiplexGroupSettings)
        pub fn build(self) -> crate::model::MultiplexGroupSettings {
            crate::model::MultiplexGroupSettings {}
        }
    }
}
impl MultiplexGroupSettings {
    /// Creates a new builder-style object to manufacture [`MultiplexGroupSettings`](crate::model::MultiplexGroupSettings)
    pub fn builder() -> crate::model::multiplex_group_settings::Builder {
        crate::model::multiplex_group_settings::Builder::default()
    }
}

/// Ms Smooth Group Settings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MsSmoothGroupSettings {
    /// The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
    pub acquisition_point_id: std::option::Option<std::string::String>,
    /// If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the current timecode. This option does not write timecodes to the audio elementary stream.
    pub audio_only_timecode_control:
        std::option::Option<crate::model::SmoothGroupAudioOnlyTimecodeControl>,
    /// If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).  This will cause https outputs to self-signed certificates to fail.
    pub certificate_mode: std::option::Option<crate::model::SmoothGroupCertificateMode>,
    /// Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content will be cached during this time and the cache will be be delivered to the IIS server once the connection is re-established.
    pub connection_retry_interval: i32,
    /// Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
    pub destination: std::option::Option<crate::model::OutputLocationRef>,
    /// MS Smooth event ID to be sent to the IIS server.
    ///
    /// Should only be specified if eventIdMode is set to useConfigured.
    pub event_id: std::option::Option<std::string::String>,
    /// Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live Event is used without changing the publishing point, clients might see cached video from the previous run.
    ///
    /// Options:
    /// - "useConfigured" - use the value provided in eventId
    /// - "useTimestamp" - generate and send an event ID based on the current timestamp
    /// - "noEventId" - do not send an event ID to the IIS server.
    pub event_id_mode: std::option::Option<crate::model::SmoothGroupEventIdMode>,
    /// When set to sendEos, send EOS signal to IIS server when stopping the event
    pub event_stop_behavior: std::option::Option<crate::model::SmoothGroupEventStopBehavior>,
    /// Size in seconds of file cache for streaming outputs.
    pub filecache_duration: i32,
    /// Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and framerate.
    pub fragment_length: i32,
    /// Parameter that control output group behavior on input loss.
    pub input_loss_action: std::option::Option<crate::model::InputLossActionForMsSmoothOut>,
    /// Number of retry attempts.
    pub num_retries: i32,
    /// Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one segment, or exceeding filecacheDuration.
    pub restart_delay: i32,
    /// useInputSegmentation has been deprecated. The configured segment size is always used.
    pub segmentation_mode: std::option::Option<crate::model::SmoothGroupSegmentationMode>,
    /// Number of milliseconds to delay the output from the second pipeline.
    pub send_delay_ms: i32,
    /// Identifies the type of data to place in the sparse track:
    /// - SCTE35: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame to start a new segment.
    /// - SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new segment.
    /// - NONE: Don't generate a sparse track for any outputs in this output group.
    pub sparse_track_type: std::option::Option<crate::model::SmoothGroupSparseTrackType>,
    /// When set to send, send stream manifest so publishing point doesn't start until all streams start.
    pub stream_manifest_behavior:
        std::option::Option<crate::model::SmoothGroupStreamManifestBehavior>,
    /// Timestamp offset for the event.  Only used if timestampOffsetMode is set to useConfiguredOffset.
    pub timestamp_offset: std::option::Option<std::string::String>,
    /// Type of timestamp date offset to use.
    /// - useEventStartDate: Use the date the event was started as the offset
    /// - useConfiguredOffset: Use an explicitly configured date as the offset
    pub timestamp_offset_mode: std::option::Option<crate::model::SmoothGroupTimestampOffsetMode>,
}
impl std::fmt::Debug for MsSmoothGroupSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MsSmoothGroupSettings");
        formatter.field("acquisition_point_id", &self.acquisition_point_id);
        formatter.field(
            "audio_only_timecode_control",
            &self.audio_only_timecode_control,
        );
        formatter.field("certificate_mode", &self.certificate_mode);
        formatter.field("connection_retry_interval", &self.connection_retry_interval);
        formatter.field("destination", &self.destination);
        formatter.field("event_id", &self.event_id);
        formatter.field("event_id_mode", &self.event_id_mode);
        formatter.field("event_stop_behavior", &self.event_stop_behavior);
        formatter.field("filecache_duration", &self.filecache_duration);
        formatter.field("fragment_length", &self.fragment_length);
        formatter.field("input_loss_action", &self.input_loss_action);
        formatter.field("num_retries", &self.num_retries);
        formatter.field("restart_delay", &self.restart_delay);
        formatter.field("segmentation_mode", &self.segmentation_mode);
        formatter.field("send_delay_ms", &self.send_delay_ms);
        formatter.field("sparse_track_type", &self.sparse_track_type);
        formatter.field("stream_manifest_behavior", &self.stream_manifest_behavior);
        formatter.field("timestamp_offset", &self.timestamp_offset);
        formatter.field("timestamp_offset_mode", &self.timestamp_offset_mode);
        formatter.finish()
    }
}
/// See [`MsSmoothGroupSettings`](crate::model::MsSmoothGroupSettings)
pub mod ms_smooth_group_settings {
    /// A builder for [`MsSmoothGroupSettings`](crate::model::MsSmoothGroupSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) acquisition_point_id: std::option::Option<std::string::String>,
        pub(crate) audio_only_timecode_control:
            std::option::Option<crate::model::SmoothGroupAudioOnlyTimecodeControl>,
        pub(crate) certificate_mode: std::option::Option<crate::model::SmoothGroupCertificateMode>,
        pub(crate) connection_retry_interval: std::option::Option<i32>,
        pub(crate) destination: std::option::Option<crate::model::OutputLocationRef>,
        pub(crate) event_id: std::option::Option<std::string::String>,
        pub(crate) event_id_mode: std::option::Option<crate::model::SmoothGroupEventIdMode>,
        pub(crate) event_stop_behavior:
            std::option::Option<crate::model::SmoothGroupEventStopBehavior>,
        pub(crate) filecache_duration: std::option::Option<i32>,
        pub(crate) fragment_length: std::option::Option<i32>,
        pub(crate) input_loss_action:
            std::option::Option<crate::model::InputLossActionForMsSmoothOut>,
        pub(crate) num_retries: std::option::Option<i32>,
        pub(crate) restart_delay: std::option::Option<i32>,
        pub(crate) segmentation_mode:
            std::option::Option<crate::model::SmoothGroupSegmentationMode>,
        pub(crate) send_delay_ms: std::option::Option<i32>,
        pub(crate) sparse_track_type: std::option::Option<crate::model::SmoothGroupSparseTrackType>,
        pub(crate) stream_manifest_behavior:
            std::option::Option<crate::model::SmoothGroupStreamManifestBehavior>,
        pub(crate) timestamp_offset: std::option::Option<std::string::String>,
        pub(crate) timestamp_offset_mode:
            std::option::Option<crate::model::SmoothGroupTimestampOffsetMode>,
    }
    impl Builder {
        /// The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
        pub fn acquisition_point_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.acquisition_point_id = Some(input.into());
            self
        }
        /// The ID to include in each message in the sparse track. Ignored if sparseTrackType is NONE.
        pub fn set_acquisition_point_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.acquisition_point_id = input;
            self
        }
        /// If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the current timecode. This option does not write timecodes to the audio elementary stream.
        pub fn audio_only_timecode_control(
            mut self,
            input: crate::model::SmoothGroupAudioOnlyTimecodeControl,
        ) -> Self {
            self.audio_only_timecode_control = Some(input);
            self
        }
        /// If set to passthrough for an audio-only MS Smooth output, the fragment absolute time will be set to the current timecode. This option does not write timecodes to the audio elementary stream.
        pub fn set_audio_only_timecode_control(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupAudioOnlyTimecodeControl>,
        ) -> Self {
            self.audio_only_timecode_control = input;
            self
        }
        /// If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).  This will cause https outputs to self-signed certificates to fail.
        pub fn certificate_mode(mut self, input: crate::model::SmoothGroupCertificateMode) -> Self {
            self.certificate_mode = Some(input);
            self
        }
        /// If set to verifyAuthenticity, verify the https certificate chain to a trusted Certificate Authority (CA).  This will cause https outputs to self-signed certificates to fail.
        pub fn set_certificate_mode(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupCertificateMode>,
        ) -> Self {
            self.certificate_mode = input;
            self
        }
        /// Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content will be cached during this time and the cache will be be delivered to the IIS server once the connection is re-established.
        pub fn connection_retry_interval(mut self, input: i32) -> Self {
            self.connection_retry_interval = Some(input);
            self
        }
        /// Number of seconds to wait before retrying connection to the IIS server if the connection is lost. Content will be cached during this time and the cache will be be delivered to the IIS server once the connection is re-established.
        pub fn set_connection_retry_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.connection_retry_interval = input;
            self
        }
        /// Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
        pub fn destination(mut self, input: crate::model::OutputLocationRef) -> Self {
            self.destination = Some(input);
            self
        }
        /// Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push" encoder to IIS.
        pub fn set_destination(
            mut self,
            input: std::option::Option<crate::model::OutputLocationRef>,
        ) -> Self {
            self.destination = input;
            self
        }
        /// MS Smooth event ID to be sent to the IIS server.
        ///
        /// Should only be specified if eventIdMode is set to useConfigured.
        pub fn event_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.event_id = Some(input.into());
            self
        }
        /// MS Smooth event ID to be sent to the IIS server.
        ///
        /// Should only be specified if eventIdMode is set to useConfigured.
        pub fn set_event_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.event_id = input;
            self
        }
        /// Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live Event is used without changing the publishing point, clients might see cached video from the previous run.
        ///
        /// Options:
        /// - "useConfigured" - use the value provided in eventId
        /// - "useTimestamp" - generate and send an event ID based on the current timestamp
        /// - "noEventId" - do not send an event ID to the IIS server.
        pub fn event_id_mode(mut self, input: crate::model::SmoothGroupEventIdMode) -> Self {
            self.event_id_mode = Some(input);
            self
        }
        /// Specifies whether or not to send an event ID to the IIS server. If no event ID is sent and the same Live Event is used without changing the publishing point, clients might see cached video from the previous run.
        ///
        /// Options:
        /// - "useConfigured" - use the value provided in eventId
        /// - "useTimestamp" - generate and send an event ID based on the current timestamp
        /// - "noEventId" - do not send an event ID to the IIS server.
        pub fn set_event_id_mode(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupEventIdMode>,
        ) -> Self {
            self.event_id_mode = input;
            self
        }
        /// When set to sendEos, send EOS signal to IIS server when stopping the event
        pub fn event_stop_behavior(
            mut self,
            input: crate::model::SmoothGroupEventStopBehavior,
        ) -> Self {
            self.event_stop_behavior = Some(input);
            self
        }
        /// When set to sendEos, send EOS signal to IIS server when stopping the event
        pub fn set_event_stop_behavior(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupEventStopBehavior>,
        ) -> Self {
            self.event_stop_behavior = input;
            self
        }
        /// Size in seconds of file cache for streaming outputs.
        pub fn filecache_duration(mut self, input: i32) -> Self {
            self.filecache_duration = Some(input);
            self
        }
        /// Size in seconds of file cache for streaming outputs.
        pub fn set_filecache_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.filecache_duration = input;
            self
        }
        /// Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and framerate.
        pub fn fragment_length(mut self, input: i32) -> Self {
            self.fragment_length = Some(input);
            self
        }
        /// Length of mp4 fragments to generate (in seconds). Fragment length must be compatible with GOP size and framerate.
        pub fn set_fragment_length(mut self, input: std::option::Option<i32>) -> Self {
            self.fragment_length = input;
            self
        }
        /// Parameter that control output group behavior on input loss.
        pub fn input_loss_action(
            mut self,
            input: crate::model::InputLossActionForMsSmoothOut,
        ) -> Self {
            self.input_loss_action = Some(input);
            self
        }
        /// Parameter that control output group behavior on input loss.
        pub fn set_input_loss_action(
            mut self,
            input: std::option::Option<crate::model::InputLossActionForMsSmoothOut>,
        ) -> Self {
            self.input_loss_action = input;
            self
        }
        /// Number of retry attempts.
        pub fn num_retries(mut self, input: i32) -> Self {
            self.num_retries = Some(input);
            self
        }
        /// Number of retry attempts.
        pub fn set_num_retries(mut self, input: std::option::Option<i32>) -> Self {
            self.num_retries = input;
            self
        }
        /// Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one segment, or exceeding filecacheDuration.
        pub fn restart_delay(mut self, input: i32) -> Self {
            self.restart_delay = Some(input);
            self
        }
        /// Number of seconds before initiating a restart due to output failure, due to exhausting the numRetries on one segment, or exceeding filecacheDuration.
        pub fn set_restart_delay(mut self, input: std::option::Option<i32>) -> Self {
            self.restart_delay = input;
            self
        }
        /// useInputSegmentation has been deprecated. The configured segment size is always used.
        pub fn segmentation_mode(
            mut self,
            input: crate::model::SmoothGroupSegmentationMode,
        ) -> Self {
            self.segmentation_mode = Some(input);
            self
        }
        /// useInputSegmentation has been deprecated. The configured segment size is always used.
        pub fn set_segmentation_mode(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupSegmentationMode>,
        ) -> Self {
            self.segmentation_mode = input;
            self
        }
        /// Number of milliseconds to delay the output from the second pipeline.
        pub fn send_delay_ms(mut self, input: i32) -> Self {
            self.send_delay_ms = Some(input);
            self
        }
        /// Number of milliseconds to delay the output from the second pipeline.
        pub fn set_send_delay_ms(mut self, input: std::option::Option<i32>) -> Self {
            self.send_delay_ms = input;
            self
        }
        /// Identifies the type of data to place in the sparse track:
        /// - SCTE35: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame to start a new segment.
        /// - SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new segment.
        /// - NONE: Don't generate a sparse track for any outputs in this output group.
        pub fn sparse_track_type(
            mut self,
            input: crate::model::SmoothGroupSparseTrackType,
        ) -> Self {
            self.sparse_track_type = Some(input);
            self
        }
        /// Identifies the type of data to place in the sparse track:
        /// - SCTE35: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame to start a new segment.
        /// - SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages from the source content. With each message, insert an IDR frame but don't start a new segment.
        /// - NONE: Don't generate a sparse track for any outputs in this output group.
        pub fn set_sparse_track_type(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupSparseTrackType>,
        ) -> Self {
            self.sparse_track_type = input;
            self
        }
        /// When set to send, send stream manifest so publishing point doesn't start until all streams start.
        pub fn stream_manifest_behavior(
            mut self,
            input: crate::model::SmoothGroupStreamManifestBehavior,
        ) -> Self {
            self.stream_manifest_behavior = Some(input);
            self
        }
        /// When set to send, send stream manifest so publishing point doesn't start until all streams start.
        pub fn set_stream_manifest_behavior(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupStreamManifestBehavior>,
        ) -> Self {
            self.stream_manifest_behavior = input;
            self
        }
        /// Timestamp offset for the event.  Only used if timestampOffsetMode is set to useConfiguredOffset.
        pub fn timestamp_offset(mut self, input: impl Into<std::string::String>) -> Self {
            self.timestamp_offset = Some(input.into());
            self
        }
        /// Timestamp offset for the event.  Only used if timestampOffsetMode is set to useConfiguredOffset.
        pub fn set_timestamp_offset(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.timestamp_offset = input;
            self
        }
        /// Type of timestamp date offset to use.
        /// - useEventStartDate: Use the date the event was started as the offset
        /// - useConfiguredOffset: Use an explicitly configured date as the offset
        pub fn timestamp_offset_mode(
            mut self,
            input: crate::model::SmoothGroupTimestampOffsetMode,
        ) -> Self {
            self.timestamp_offset_mode = Some(input);
            self
        }
        /// Type of timestamp date offset to use.
        /// - useEventStartDate: Use the date the event was started as the offset
        /// - useConfiguredOffset: Use an explicitly configured date as the offset
        pub fn set_timestamp_offset_mode(
            mut self,
            input: std::option::Option<crate::model::SmoothGroupTimestampOffsetMode>,
        ) -> Self {
            self.timestamp_offset_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`MsSmoothGroupSettings`](crate::model::MsSmoothGroupSettings)
        pub fn build(self) -> crate::model::MsSmoothGroupSettings {
            crate::model::MsSmoothGroupSettings {
                acquisition_point_id: self.acquisition_point_id,
                audio_only_timecode_control: self.audio_only_timecode_control,
                certificate_mode: self.certificate_mode,
                connection_retry_interval: self.connection_retry_interval.unwrap_or_default(),
                destination: self.destination,
                event_id: self.event_id,
                event_id_mode: self.event_id_mode,
                event_stop_behavior: self.event_stop_behavior,
                filecache_duration: self.filecache_duration.unwrap_or_default(),
                fragment_length: self.fragment_length.unwrap_or_default(),
                input_loss_action: self.input_loss_action,
                num_retries: self.num_retries.unwrap_or_default(),
                restart_delay: self.restart_delay.unwrap_or_default(),
                segmentation_mode: self.segmentation_mode,
                send_delay_ms: self.send_delay_ms.unwrap_or_default(),
                sparse_track_type: self.sparse_track_type,
                stream_manifest_behavior: self.stream_manifest_behavior,
                timestamp_offset: self.timestamp_offset,
                timestamp_offset_mode: self.timestamp_offset_mode,
            }
        }
    }
}
impl MsSmoothGroupSettings {
    /// Creates a new builder-style object to manufacture [`MsSmoothGroupSettings`](crate::model::MsSmoothGroupSettings)
    pub fn builder() -> crate::model::ms_smooth_group_settings::Builder {
        crate::model::ms_smooth_group_settings::Builder::default()
    }
}

/// Smooth Group Timestamp Offset Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupTimestampOffsetMode {
    #[allow(missing_docs)] // documentation missing in model
    UseConfiguredOffset,
    #[allow(missing_docs)] // documentation missing in model
    UseEventStartDate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupTimestampOffsetMode {
    fn from(s: &str) -> Self {
        match s {
            "USE_CONFIGURED_OFFSET" => SmoothGroupTimestampOffsetMode::UseConfiguredOffset,
            "USE_EVENT_START_DATE" => SmoothGroupTimestampOffsetMode::UseEventStartDate,
            other => SmoothGroupTimestampOffsetMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmoothGroupTimestampOffsetMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmoothGroupTimestampOffsetMode::from(s))
    }
}
impl SmoothGroupTimestampOffsetMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmoothGroupTimestampOffsetMode::UseConfiguredOffset => "USE_CONFIGURED_OFFSET",
            SmoothGroupTimestampOffsetMode::UseEventStartDate => "USE_EVENT_START_DATE",
            SmoothGroupTimestampOffsetMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USE_CONFIGURED_OFFSET", "USE_EVENT_START_DATE"]
    }
}
impl AsRef<str> for SmoothGroupTimestampOffsetMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smooth Group Stream Manifest Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupStreamManifestBehavior {
    #[allow(missing_docs)] // documentation missing in model
    DoNotSend,
    #[allow(missing_docs)] // documentation missing in model
    Send,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupStreamManifestBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DO_NOT_SEND" => SmoothGroupStreamManifestBehavior::DoNotSend,
            "SEND" => SmoothGroupStreamManifestBehavior::Send,
            other => SmoothGroupStreamManifestBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmoothGroupStreamManifestBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmoothGroupStreamManifestBehavior::from(s))
    }
}
impl SmoothGroupStreamManifestBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmoothGroupStreamManifestBehavior::DoNotSend => "DO_NOT_SEND",
            SmoothGroupStreamManifestBehavior::Send => "SEND",
            SmoothGroupStreamManifestBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DO_NOT_SEND", "SEND"]
    }
}
impl AsRef<str> for SmoothGroupStreamManifestBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smooth Group Sparse Track Type
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupSparseTrackType {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Scte35,
    #[allow(missing_docs)] // documentation missing in model
    Scte35WithoutSegmentation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupSparseTrackType {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => SmoothGroupSparseTrackType::None,
            "SCTE_35" => SmoothGroupSparseTrackType::Scte35,
            "SCTE_35_WITHOUT_SEGMENTATION" => SmoothGroupSparseTrackType::Scte35WithoutSegmentation,
            other => SmoothGroupSparseTrackType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmoothGroupSparseTrackType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmoothGroupSparseTrackType::from(s))
    }
}
impl SmoothGroupSparseTrackType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmoothGroupSparseTrackType::None => "NONE",
            SmoothGroupSparseTrackType::Scte35 => "SCTE_35",
            SmoothGroupSparseTrackType::Scte35WithoutSegmentation => "SCTE_35_WITHOUT_SEGMENTATION",
            SmoothGroupSparseTrackType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SCTE_35", "SCTE_35_WITHOUT_SEGMENTATION"]
    }
}
impl AsRef<str> for SmoothGroupSparseTrackType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smooth Group Segmentation Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupSegmentationMode {
    #[allow(missing_docs)] // documentation missing in model
    UseInputSegmentation,
    #[allow(missing_docs)] // documentation missing in model
    UseSegmentDuration,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupSegmentationMode {
    fn from(s: &str) -> Self {
        match s {
            "USE_INPUT_SEGMENTATION" => SmoothGroupSegmentationMode::UseInputSegmentation,
            "USE_SEGMENT_DURATION" => SmoothGroupSegmentationMode::UseSegmentDuration,
            other => SmoothGroupSegmentationMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmoothGroupSegmentationMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmoothGroupSegmentationMode::from(s))
    }
}
impl SmoothGroupSegmentationMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmoothGroupSegmentationMode::UseInputSegmentation => "USE_INPUT_SEGMENTATION",
            SmoothGroupSegmentationMode::UseSegmentDuration => "USE_SEGMENT_DURATION",
            SmoothGroupSegmentationMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USE_INPUT_SEGMENTATION", "USE_SEGMENT_DURATION"]
    }
}
impl AsRef<str> for SmoothGroupSegmentationMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Input Loss Action For Ms Smooth Out
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InputLossActionForMsSmoothOut {
    #[allow(missing_docs)] // documentation missing in model
    EmitOutput,
    #[allow(missing_docs)] // documentation missing in model
    PauseOutput,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InputLossActionForMsSmoothOut {
    fn from(s: &str) -> Self {
        match s {
            "EMIT_OUTPUT" => InputLossActionForMsSmoothOut::EmitOutput,
            "PAUSE_OUTPUT" => InputLossActionForMsSmoothOut::PauseOutput,
            other => InputLossActionForMsSmoothOut::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InputLossActionForMsSmoothOut {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InputLossActionForMsSmoothOut::from(s))
    }
}
impl InputLossActionForMsSmoothOut {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InputLossActionForMsSmoothOut::EmitOutput => "EMIT_OUTPUT",
            InputLossActionForMsSmoothOut::PauseOutput => "PAUSE_OUTPUT",
            InputLossActionForMsSmoothOut::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EMIT_OUTPUT", "PAUSE_OUTPUT"]
    }
}
impl AsRef<str> for InputLossActionForMsSmoothOut {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smooth Group Event Stop Behavior
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupEventStopBehavior {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    SendEos,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupEventStopBehavior {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => SmoothGroupEventStopBehavior::None,
            "SEND_EOS" => SmoothGroupEventStopBehavior::SendEos,
            other => SmoothGroupEventStopBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmoothGroupEventStopBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmoothGroupEventStopBehavior::from(s))
    }
}
impl SmoothGroupEventStopBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmoothGroupEventStopBehavior::None => "NONE",
            SmoothGroupEventStopBehavior::SendEos => "SEND_EOS",
            SmoothGroupEventStopBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "SEND_EOS"]
    }
}
impl AsRef<str> for SmoothGroupEventStopBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smooth Group Event Id Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupEventIdMode {
    #[allow(missing_docs)] // documentation missing in model
    NoEventId,
    #[allow(missing_docs)] // documentation missing in model
    UseConfigured,
    #[allow(missing_docs)] // documentation missing in model
    UseTimestamp,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupEventIdMode {
    fn from(s: &str) -> Self {
        match s {
            "NO_EVENT_ID" => SmoothGroupEventIdMode::NoEventId,
            "USE_CONFIGURED" => SmoothGroupEventIdMode::UseConfigured,
            "USE_TIMESTAMP" => SmoothGroupEventIdMode::UseTimestamp,
            other => SmoothGroupEventIdMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SmoothGroupEventIdMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SmoothGroupEventIdMode::from(s))
    }
}
impl SmoothGroupEventIdMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SmoothGroupEventIdMode::NoEventId => "NO_EVENT_ID",
            SmoothGroupEventIdMode::UseConfigured => "USE_CONFIGURED",
            SmoothGroupEventIdMode::UseTimestamp => "USE_TIMESTAMP",
            SmoothGroupEventIdMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO_EVENT_ID", "USE_CONFIGURED", "USE_TIMESTAMP"]
    }
}
impl AsRef<str> for SmoothGroupEventIdMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Smooth Group Certificate Mode
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SmoothGroupCertificateMode {
    #[allow(missing_docs)] // documentation missing in model
    SelfSigned,
    #[allow(missing_docs)] // documentation missing in model
    VerifyAuthenticity,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SmoothGroupCertificateMode {
    fn from(s: &str) -> Self {
        match s {
            "SELF_SIGNED" => SmoothGroupCertificateMode::SelfSigned,
            "VERIFY_AUTHENTICITY" => SmoothGroupCertificateMode::VerifyAuthenticity