// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptInputDeviceTransfer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_input_device_transfer`](crate::client::Client::accept_input_device_transfer).
///
/// See [`crate::client::fluent_builders::AcceptInputDeviceTransfer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInputDeviceTransfer {
    _private: (),
}
impl AcceptInputDeviceTransfer {
    /// Creates a new builder-style object to manufacture [`AcceptInputDeviceTransferInput`](crate::input::AcceptInputDeviceTransferInput)
    pub fn builder() -> crate::input::accept_input_device_transfer_input::Builder {
        crate::input::accept_input_device_transfer_input::Builder::default()
    }
    /// Creates a new `AcceptInputDeviceTransfer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInputDeviceTransfer {
    type Output = std::result::Result<
        crate::output::AcceptInputDeviceTransferOutput,
        crate::error::AcceptInputDeviceTransferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_input_device_transfer_error(response)
        } else {
            crate::operation_deser::parse_accept_input_device_transfer_response(response)
        }
    }
}

/// Operation shape for `BatchDelete`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_delete`](crate::client::Client::batch_delete).
///
/// See [`crate::client::fluent_builders::BatchDelete`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchDelete {
    _private: (),
}
impl BatchDelete {
    /// Creates a new builder-style object to manufacture [`BatchDeleteInput`](crate::input::BatchDeleteInput)
    pub fn builder() -> crate::input::batch_delete_input::Builder {
        crate::input::batch_delete_input::Builder::default()
    }
    /// Creates a new `BatchDelete` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchDelete {
    type Output =
        std::result::Result<crate::output::BatchDeleteOutput, crate::error::BatchDeleteError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_delete_error(response)
        } else {
            crate::operation_deser::parse_batch_delete_response(response)
        }
    }
}

/// Operation shape for `BatchStart`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_start`](crate::client::Client::batch_start).
///
/// See [`crate::client::fluent_builders::BatchStart`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchStart {
    _private: (),
}
impl BatchStart {
    /// Creates a new builder-style object to manufacture [`BatchStartInput`](crate::input::BatchStartInput)
    pub fn builder() -> crate::input::batch_start_input::Builder {
        crate::input::batch_start_input::Builder::default()
    }
    /// Creates a new `BatchStart` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchStart {
    type Output =
        std::result::Result<crate::output::BatchStartOutput, crate::error::BatchStartError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_start_error(response)
        } else {
            crate::operation_deser::parse_batch_start_response(response)
        }
    }
}

/// Operation shape for `BatchStop`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_stop`](crate::client::Client::batch_stop).
///
/// See [`crate::client::fluent_builders::BatchStop`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchStop {
    _private: (),
}
impl BatchStop {
    /// Creates a new builder-style object to manufacture [`BatchStopInput`](crate::input::BatchStopInput)
    pub fn builder() -> crate::input::batch_stop_input::Builder {
        crate::input::batch_stop_input::Builder::default()
    }
    /// Creates a new `BatchStop` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchStop {
    type Output = std::result::Result<crate::output::BatchStopOutput, crate::error::BatchStopError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_stop_error(response)
        } else {
            crate::operation_deser::parse_batch_stop_response(response)
        }
    }
}

/// Operation shape for `BatchUpdateSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_update_schedule`](crate::client::Client::batch_update_schedule).
///
/// See [`crate::client::fluent_builders::BatchUpdateSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchUpdateSchedule {
    _private: (),
}
impl BatchUpdateSchedule {
    /// Creates a new builder-style object to manufacture [`BatchUpdateScheduleInput`](crate::input::BatchUpdateScheduleInput)
    pub fn builder() -> crate::input::batch_update_schedule_input::Builder {
        crate::input::batch_update_schedule_input::Builder::default()
    }
    /// Creates a new `BatchUpdateSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchUpdateSchedule {
    type Output = std::result::Result<
        crate::output::BatchUpdateScheduleOutput,
        crate::error::BatchUpdateScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_update_schedule_error(response)
        } else {
            crate::operation_deser::parse_batch_update_schedule_response(response)
        }
    }
}

/// Operation shape for `CancelInputDeviceTransfer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_input_device_transfer`](crate::client::Client::cancel_input_device_transfer).
///
/// See [`crate::client::fluent_builders::CancelInputDeviceTransfer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelInputDeviceTransfer {
    _private: (),
}
impl CancelInputDeviceTransfer {
    /// Creates a new builder-style object to manufacture [`CancelInputDeviceTransferInput`](crate::input::CancelInputDeviceTransferInput)
    pub fn builder() -> crate::input::cancel_input_device_transfer_input::Builder {
        crate::input::cancel_input_device_transfer_input::Builder::default()
    }
    /// Creates a new `CancelInputDeviceTransfer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelInputDeviceTransfer {
    type Output = std::result::Result<
        crate::output::CancelInputDeviceTransferOutput,
        crate::error::CancelInputDeviceTransferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_input_device_transfer_error(response)
        } else {
            crate::operation_deser::parse_cancel_input_device_transfer_response(response)
        }
    }
}

/// Operation shape for `ClaimDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`claim_device`](crate::client::Client::claim_device).
///
/// See [`crate::client::fluent_builders::ClaimDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ClaimDevice {
    _private: (),
}
impl ClaimDevice {
    /// Creates a new builder-style object to manufacture [`ClaimDeviceInput`](crate::input::ClaimDeviceInput)
    pub fn builder() -> crate::input::claim_device_input::Builder {
        crate::input::claim_device_input::Builder::default()
    }
    /// Creates a new `ClaimDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ClaimDevice {
    type Output =
        std::result::Result<crate::output::ClaimDeviceOutput, crate::error::ClaimDeviceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_claim_device_error(response)
        } else {
            crate::operation_deser::parse_claim_device_response(response)
        }
    }
}

/// Operation shape for `CreateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_channel`](crate::client::Client::create_channel).
///
/// See [`crate::client::fluent_builders::CreateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateChannel {
    _private: (),
}
impl CreateChannel {
    /// Creates a new builder-style object to manufacture [`CreateChannelInput`](crate::input::CreateChannelInput)
    pub fn builder() -> crate::input::create_channel_input::Builder {
        crate::input::create_channel_input::Builder::default()
    }
    /// Creates a new `CreateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateChannel {
    type Output =
        std::result::Result<crate::output::CreateChannelOutput, crate::error::CreateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_channel_error(response)
        } else {
            crate::operation_deser::parse_create_channel_response(response)
        }
    }
}

/// Operation shape for `CreateInput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_input`](crate::client::Client::create_input).
///
/// See [`crate::client::fluent_builders::CreateInput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInput {
    _private: (),
}
impl CreateInput {
    /// Creates a new builder-style object to manufacture [`CreateInputInput`](crate::input::CreateInputInput)
    pub fn builder() -> crate::input::create_input_input::Builder {
        crate::input::create_input_input::Builder::default()
    }
    /// Creates a new `CreateInput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInput {
    type Output =
        std::result::Result<crate::output::CreateInputOutput, crate::error::CreateInputError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_input_error(response)
        } else {
            crate::operation_deser::parse_create_input_response(response)
        }
    }
}

/// Operation shape for `CreateInputSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_input_security_group`](crate::client::Client::create_input_security_group).
///
/// See [`crate::client::fluent_builders::CreateInputSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInputSecurityGroup {
    _private: (),
}
impl CreateInputSecurityGroup {
    /// Creates a new builder-style object to manufacture [`CreateInputSecurityGroupInput`](crate::input::CreateInputSecurityGroupInput)
    pub fn builder() -> crate::input::create_input_security_group_input::Builder {
        crate::input::create_input_security_group_input::Builder::default()
    }
    /// Creates a new `CreateInputSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInputSecurityGroup {
    type Output = std::result::Result<
        crate::output::CreateInputSecurityGroupOutput,
        crate::error::CreateInputSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_input_security_group_error(response)
        } else {
            crate::operation_deser::parse_create_input_security_group_response(response)
        }
    }
}

/// Operation shape for `CreateMultiplex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_multiplex`](crate::client::Client::create_multiplex).
///
/// See [`crate::client::fluent_builders::CreateMultiplex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMultiplex {
    _private: (),
}
impl CreateMultiplex {
    /// Creates a new builder-style object to manufacture [`CreateMultiplexInput`](crate::input::CreateMultiplexInput)
    pub fn builder() -> crate::input::create_multiplex_input::Builder {
        crate::input::create_multiplex_input::Builder::default()
    }
    /// Creates a new `CreateMultiplex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMultiplex {
    type Output = std::result::Result<
        crate::output::CreateMultiplexOutput,
        crate::error::CreateMultiplexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_multiplex_error(response)
        } else {
            crate::operation_deser::parse_create_multiplex_response(response)
        }
    }
}

/// Operation shape for `CreateMultiplexProgram`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_multiplex_program`](crate::client::Client::create_multiplex_program).
///
/// See [`crate::client::fluent_builders::CreateMultiplexProgram`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMultiplexProgram {
    _private: (),
}
impl CreateMultiplexProgram {
    /// Creates a new builder-style object to manufacture [`CreateMultiplexProgramInput`](crate::input::CreateMultiplexProgramInput)
    pub fn builder() -> crate::input::create_multiplex_program_input::Builder {
        crate::input::create_multiplex_program_input::Builder::default()
    }
    /// Creates a new `CreateMultiplexProgram` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMultiplexProgram {
    type Output = std::result::Result<
        crate::output::CreateMultiplexProgramOutput,
        crate::error::CreateMultiplexProgramError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_multiplex_program_error(response)
        } else {
            crate::operation_deser::parse_create_multiplex_program_response(response)
        }
    }
}

/// Operation shape for `CreatePartnerInput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_partner_input`](crate::client::Client::create_partner_input).
///
/// See [`crate::client::fluent_builders::CreatePartnerInput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePartnerInput {
    _private: (),
}
impl CreatePartnerInput {
    /// Creates a new builder-style object to manufacture [`CreatePartnerInputInput`](crate::input::CreatePartnerInputInput)
    pub fn builder() -> crate::input::create_partner_input_input::Builder {
        crate::input::create_partner_input_input::Builder::default()
    }
    /// Creates a new `CreatePartnerInput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePartnerInput {
    type Output = std::result::Result<
        crate::output::CreatePartnerInputOutput,
        crate::error::CreatePartnerInputError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_partner_input_error(response)
        } else {
            crate::operation_deser::parse_create_partner_input_response(response)
        }
    }
}

/// Operation shape for `CreateTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_tags`](crate::client::Client::create_tags).
///
/// See [`crate::client::fluent_builders::CreateTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateTags {
    _private: (),
}
impl CreateTags {
    /// Creates a new builder-style object to manufacture [`CreateTagsInput`](crate::input::CreateTagsInput)
    pub fn builder() -> crate::input::create_tags_input::Builder {
        crate::input::create_tags_input::Builder::default()
    }
    /// Creates a new `CreateTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateTags {
    type Output =
        std::result::Result<crate::output::CreateTagsOutput, crate::error::CreateTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_create_tags_error(response)
        } else {
            crate::operation_deser::parse_create_tags_response(response)
        }
    }
}

/// Operation shape for `DeleteChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_channel`](crate::client::Client::delete_channel).
///
/// See [`crate::client::fluent_builders::DeleteChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteChannel {
    _private: (),
}
impl DeleteChannel {
    /// Creates a new builder-style object to manufacture [`DeleteChannelInput`](crate::input::DeleteChannelInput)
    pub fn builder() -> crate::input::delete_channel_input::Builder {
        crate::input::delete_channel_input::Builder::default()
    }
    /// Creates a new `DeleteChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteChannel {
    type Output =
        std::result::Result<crate::output::DeleteChannelOutput, crate::error::DeleteChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_channel_error(response)
        } else {
            crate::operation_deser::parse_delete_channel_response(response)
        }
    }
}

/// Operation shape for `DeleteInput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_input`](crate::client::Client::delete_input).
///
/// See [`crate::client::fluent_builders::DeleteInput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInput {
    _private: (),
}
impl DeleteInput {
    /// Creates a new builder-style object to manufacture [`DeleteInputInput`](crate::input::DeleteInputInput)
    pub fn builder() -> crate::input::delete_input_input::Builder {
        crate::input::delete_input_input::Builder::default()
    }
    /// Creates a new `DeleteInput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInput {
    type Output =
        std::result::Result<crate::output::DeleteInputOutput, crate::error::DeleteInputError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_input_error(response)
        } else {
            crate::operation_deser::parse_delete_input_response(response)
        }
    }
}

/// Operation shape for `DeleteInputSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_input_security_group`](crate::client::Client::delete_input_security_group).
///
/// See [`crate::client::fluent_builders::DeleteInputSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInputSecurityGroup {
    _private: (),
}
impl DeleteInputSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DeleteInputSecurityGroupInput`](crate::input::DeleteInputSecurityGroupInput)
    pub fn builder() -> crate::input::delete_input_security_group_input::Builder {
        crate::input::delete_input_security_group_input::Builder::default()
    }
    /// Creates a new `DeleteInputSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInputSecurityGroup {
    type Output = std::result::Result<
        crate::output::DeleteInputSecurityGroupOutput,
        crate::error::DeleteInputSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_input_security_group_error(response)
        } else {
            crate::operation_deser::parse_delete_input_security_group_response(response)
        }
    }
}

/// Operation shape for `DeleteMultiplex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_multiplex`](crate::client::Client::delete_multiplex).
///
/// See [`crate::client::fluent_builders::DeleteMultiplex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMultiplex {
    _private: (),
}
impl DeleteMultiplex {
    /// Creates a new builder-style object to manufacture [`DeleteMultiplexInput`](crate::input::DeleteMultiplexInput)
    pub fn builder() -> crate::input::delete_multiplex_input::Builder {
        crate::input::delete_multiplex_input::Builder::default()
    }
    /// Creates a new `DeleteMultiplex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMultiplex {
    type Output = std::result::Result<
        crate::output::DeleteMultiplexOutput,
        crate::error::DeleteMultiplexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_multiplex_error(response)
        } else {
            crate::operation_deser::parse_delete_multiplex_response(response)
        }
    }
}

/// Operation shape for `DeleteMultiplexProgram`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_multiplex_program`](crate::client::Client::delete_multiplex_program).
///
/// See [`crate::client::fluent_builders::DeleteMultiplexProgram`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMultiplexProgram {
    _private: (),
}
impl DeleteMultiplexProgram {
    /// Creates a new builder-style object to manufacture [`DeleteMultiplexProgramInput`](crate::input::DeleteMultiplexProgramInput)
    pub fn builder() -> crate::input::delete_multiplex_program_input::Builder {
        crate::input::delete_multiplex_program_input::Builder::default()
    }
    /// Creates a new `DeleteMultiplexProgram` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMultiplexProgram {
    type Output = std::result::Result<
        crate::output::DeleteMultiplexProgramOutput,
        crate::error::DeleteMultiplexProgramError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_multiplex_program_error(response)
        } else {
            crate::operation_deser::parse_delete_multiplex_program_response(response)
        }
    }
}

/// Operation shape for `DeleteReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_reservation`](crate::client::Client::delete_reservation).
///
/// See [`crate::client::fluent_builders::DeleteReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteReservation {
    _private: (),
}
impl DeleteReservation {
    /// Creates a new builder-style object to manufacture [`DeleteReservationInput`](crate::input::DeleteReservationInput)
    pub fn builder() -> crate::input::delete_reservation_input::Builder {
        crate::input::delete_reservation_input::Builder::default()
    }
    /// Creates a new `DeleteReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteReservation {
    type Output = std::result::Result<
        crate::output::DeleteReservationOutput,
        crate::error::DeleteReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_reservation_error(response)
        } else {
            crate::operation_deser::parse_delete_reservation_response(response)
        }
    }
}

/// Operation shape for `DeleteSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_schedule`](crate::client::Client::delete_schedule).
///
/// See [`crate::client::fluent_builders::DeleteSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteSchedule {
    _private: (),
}
impl DeleteSchedule {
    /// Creates a new builder-style object to manufacture [`DeleteScheduleInput`](crate::input::DeleteScheduleInput)
    pub fn builder() -> crate::input::delete_schedule_input::Builder {
        crate::input::delete_schedule_input::Builder::default()
    }
    /// Creates a new `DeleteSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteSchedule {
    type Output =
        std::result::Result<crate::output::DeleteScheduleOutput, crate::error::DeleteScheduleError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_schedule_error(response)
        } else {
            crate::operation_deser::parse_delete_schedule_response(response)
        }
    }
}

/// Operation shape for `DeleteTags`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_tags`](crate::client::Client::delete_tags).
///
/// See [`crate::client::fluent_builders::DeleteTags`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteTags {
    _private: (),
}
impl DeleteTags {
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
    /// Creates a new `DeleteTags` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteTags {
    type Output =
        std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_delete_tags_error(response)
        } else {
            crate::operation_deser::parse_delete_tags_response(response)
        }
    }
}

/// Operation shape for `DescribeChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_channel`](crate::client::Client::describe_channel).
///
/// See [`crate::client::fluent_builders::DescribeChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChannel {
    _private: (),
}
impl DescribeChannel {
    /// Creates a new builder-style object to manufacture [`DescribeChannelInput`](crate::input::DescribeChannelInput)
    pub fn builder() -> crate::input::describe_channel_input::Builder {
        crate::input::describe_channel_input::Builder::default()
    }
    /// Creates a new `DescribeChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChannel {
    type Output = std::result::Result<
        crate::output::DescribeChannelOutput,
        crate::error::DescribeChannelError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_channel_error(response)
        } else {
            crate::operation_deser::parse_describe_channel_response(response)
        }
    }
}

/// Operation shape for `DescribeInput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_input`](crate::client::Client::describe_input).
///
/// See [`crate::client::fluent_builders::DescribeInput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInput {
    _private: (),
}
impl DescribeInput {
    /// Creates a new builder-style object to manufacture [`DescribeInputInput`](crate::input::DescribeInputInput)
    pub fn builder() -> crate::input::describe_input_input::Builder {
        crate::input::describe_input_input::Builder::default()
    }
    /// Creates a new `DescribeInput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInput {
    type Output =
        std::result::Result<crate::output::DescribeInputOutput, crate::error::DescribeInputError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_input_error(response)
        } else {
            crate::operation_deser::parse_describe_input_response(response)
        }
    }
}

/// Operation shape for `DescribeInputDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_input_device`](crate::client::Client::describe_input_device).
///
/// See [`crate::client::fluent_builders::DescribeInputDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInputDevice {
    _private: (),
}
impl DescribeInputDevice {
    /// Creates a new builder-style object to manufacture [`DescribeInputDeviceInput`](crate::input::DescribeInputDeviceInput)
    pub fn builder() -> crate::input::describe_input_device_input::Builder {
        crate::input::describe_input_device_input::Builder::default()
    }
    /// Creates a new `DescribeInputDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInputDevice {
    type Output = std::result::Result<
        crate::output::DescribeInputDeviceOutput,
        crate::error::DescribeInputDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_input_device_error(response)
        } else {
            crate::operation_deser::parse_describe_input_device_response(response)
        }
    }
}

/// Operation shape for `DescribeInputDeviceThumbnail`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_input_device_thumbnail`](crate::client::Client::describe_input_device_thumbnail).
///
/// See [`crate::client::fluent_builders::DescribeInputDeviceThumbnail`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInputDeviceThumbnail {
    _private: (),
}
impl DescribeInputDeviceThumbnail {
    /// Creates a new builder-style object to manufacture [`DescribeInputDeviceThumbnailInput`](crate::input::DescribeInputDeviceThumbnailInput)
    pub fn builder() -> crate::input::describe_input_device_thumbnail_input::Builder {
        crate::input::describe_input_device_thumbnail_input::Builder::default()
    }
    /// Creates a new `DescribeInputDeviceThumbnail` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseHttpResponse for DescribeInputDeviceThumbnail {
    type Output = std::result::Result<
        crate::output::DescribeInputDeviceThumbnailOutput,
        crate::error::DescribeInputDeviceThumbnailError,
    >;
    fn parse_unloaded(
        &self,
        response: &mut aws_smithy_http::operation::Response,
    ) -> Option<Self::Output> {
        // This is an error, defer to the non-streaming parser
        if !response.http().status().is_success() && response.http().status().as_u16() != 200 {
            return None;
        }
        Some(crate::operation_deser::parse_describe_input_device_thumbnail(response))
    }
    fn parse_loaded(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        // if streaming, we only hit this case if its an error
        crate::operation_deser::parse_describe_input_device_thumbnail_error(response)
    }
}

/// Operation shape for `DescribeInputSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_input_security_group`](crate::client::Client::describe_input_security_group).
///
/// See [`crate::client::fluent_builders::DescribeInputSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeInputSecurityGroup {
    _private: (),
}
impl DescribeInputSecurityGroup {
    /// Creates a new builder-style object to manufacture [`DescribeInputSecurityGroupInput`](crate::input::DescribeInputSecurityGroupInput)
    pub fn builder() -> crate::input::describe_input_security_group_input::Builder {
        crate::input::describe_input_security_group_input::Builder::default()
    }
    /// Creates a new `DescribeInputSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeInputSecurityGroup {
    type Output = std::result::Result<
        crate::output::DescribeInputSecurityGroupOutput,
        crate::error::DescribeInputSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_input_security_group_error(response)
        } else {
            crate::operation_deser::parse_describe_input_security_group_response(response)
        }
    }
}

/// Operation shape for `DescribeMultiplex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_multiplex`](crate::client::Client::describe_multiplex).
///
/// See [`crate::client::fluent_builders::DescribeMultiplex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMultiplex {
    _private: (),
}
impl DescribeMultiplex {
    /// Creates a new builder-style object to manufacture [`DescribeMultiplexInput`](crate::input::DescribeMultiplexInput)
    pub fn builder() -> crate::input::describe_multiplex_input::Builder {
        crate::input::describe_multiplex_input::Builder::default()
    }
    /// Creates a new `DescribeMultiplex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMultiplex {
    type Output = std::result::Result<
        crate::output::DescribeMultiplexOutput,
        crate::error::DescribeMultiplexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_multiplex_error(response)
        } else {
            crate::operation_deser::parse_describe_multiplex_response(response)
        }
    }
}

/// Operation shape for `DescribeMultiplexProgram`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_multiplex_program`](crate::client::Client::describe_multiplex_program).
///
/// See [`crate::client::fluent_builders::DescribeMultiplexProgram`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeMultiplexProgram {
    _private: (),
}
impl DescribeMultiplexProgram {
    /// Creates a new builder-style object to manufacture [`DescribeMultiplexProgramInput`](crate::input::DescribeMultiplexProgramInput)
    pub fn builder() -> crate::input::describe_multiplex_program_input::Builder {
        crate::input::describe_multiplex_program_input::Builder::default()
    }
    /// Creates a new `DescribeMultiplexProgram` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeMultiplexProgram {
    type Output = std::result::Result<
        crate::output::DescribeMultiplexProgramOutput,
        crate::error::DescribeMultiplexProgramError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_multiplex_program_error(response)
        } else {
            crate::operation_deser::parse_describe_multiplex_program_response(response)
        }
    }
}

/// Operation shape for `DescribeOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_offering`](crate::client::Client::describe_offering).
///
/// See [`crate::client::fluent_builders::DescribeOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOffering {
    _private: (),
}
impl DescribeOffering {
    /// Creates a new builder-style object to manufacture [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
    pub fn builder() -> crate::input::describe_offering_input::Builder {
        crate::input::describe_offering_input::Builder::default()
    }
    /// Creates a new `DescribeOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOffering {
    type Output = std::result::Result<
        crate::output::DescribeOfferingOutput,
        crate::error::DescribeOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_offering_error(response)
        } else {
            crate::operation_deser::parse_describe_offering_response(response)
        }
    }
}

/// Operation shape for `DescribeReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reservation`](crate::client::Client::describe_reservation).
///
/// See [`crate::client::fluent_builders::DescribeReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservation {
    _private: (),
}
impl DescribeReservation {
    /// Creates a new builder-style object to manufacture [`DescribeReservationInput`](crate::input::DescribeReservationInput)
    pub fn builder() -> crate::input::describe_reservation_input::Builder {
        crate::input::describe_reservation_input::Builder::default()
    }
    /// Creates a new `DescribeReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservation {
    type Output = std::result::Result<
        crate::output::DescribeReservationOutput,
        crate::error::DescribeReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reservation_error(response)
        } else {
            crate::operation_deser::parse_describe_reservation_response(response)
        }
    }
}

/// Operation shape for `DescribeSchedule`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_schedule`](crate::client::Client::describe_schedule).
///
/// See [`crate::client::fluent_builders::DescribeSchedule`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeSchedule {
    _private: (),
}
impl DescribeSchedule {
    /// Creates a new builder-style object to manufacture [`DescribeScheduleInput`](crate::input::DescribeScheduleInput)
    pub fn builder() -> crate::input::describe_schedule_input::Builder {
        crate::input::describe_schedule_input::Builder::default()
    }
    /// Creates a new `DescribeSchedule` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeSchedule {
    type Output = std::result::Result<
        crate::output::DescribeScheduleOutput,
        crate::error::DescribeScheduleError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_schedule_error(response)
        } else {
            crate::operation_deser::parse_describe_schedule_response(response)
        }
    }
}

/// Operation shape for `ListChannels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_channels`](crate::client::Client::list_channels).
///
/// See [`crate::client::fluent_builders::ListChannels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChannels {
    _private: (),
}
impl ListChannels {
    /// Creates a new builder-style object to manufacture [`ListChannelsInput`](crate::input::ListChannelsInput)
    pub fn builder() -> crate::input::list_channels_input::Builder {
        crate::input::list_channels_input::Builder::default()
    }
    /// Creates a new `ListChannels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChannels {
    type Output =
        std::result::Result<crate::output::ListChannelsOutput, crate::error::ListChannelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_channels_error(response)
        } else {
            crate::operation_deser::parse_list_channels_response(response)
        }
    }
}

/// Operation shape for `ListInputDevices`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_input_devices`](crate::client::Client::list_input_devices).
///
/// See [`crate::client::fluent_builders::ListInputDevices`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInputDevices {
    _private: (),
}
impl ListInputDevices {
    /// Creates a new builder-style object to manufacture [`ListInputDevicesInput`](crate::input::ListInputDevicesInput)
    pub fn builder() -> crate::input::list_input_devices_input::Builder {
        crate::input::list_input_devices_input::Builder::default()
    }
    /// Creates a new `ListInputDevices` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInputDevices {
    type Output = std::result::Result<
        crate::output::ListInputDevicesOutput,
        crate::error::ListInputDevicesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_input_devices_error(response)
        } else {
            crate::operation_deser::parse_list_input_devices_response(response)
        }
    }
}

/// Operation shape for `ListInputDeviceTransfers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_input_device_transfers`](crate::client::Client::list_input_device_transfers).
///
/// See [`crate::client::fluent_builders::ListInputDeviceTransfers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInputDeviceTransfers {
    _private: (),
}
impl ListInputDeviceTransfers {
    /// Creates a new builder-style object to manufacture [`ListInputDeviceTransfersInput`](crate::input::ListInputDeviceTransfersInput)
    pub fn builder() -> crate::input::list_input_device_transfers_input::Builder {
        crate::input::list_input_device_transfers_input::Builder::default()
    }
    /// Creates a new `ListInputDeviceTransfers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInputDeviceTransfers {
    type Output = std::result::Result<
        crate::output::ListInputDeviceTransfersOutput,
        crate::error::ListInputDeviceTransfersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_input_device_transfers_error(response)
        } else {
            crate::operation_deser::parse_list_input_device_transfers_response(response)
        }
    }
}

/// Operation shape for `ListInputs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_inputs`](crate::client::Client::list_inputs).
///
/// See [`crate::client::fluent_builders::ListInputs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInputs {
    _private: (),
}
impl ListInputs {
    /// Creates a new builder-style object to manufacture [`ListInputsInput`](crate::input::ListInputsInput)
    pub fn builder() -> crate::input::list_inputs_input::Builder {
        crate::input::list_inputs_input::Builder::default()
    }
    /// Creates a new `ListInputs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInputs {
    type Output =
        std::result::Result<crate::output::ListInputsOutput, crate::error::ListInputsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_inputs_error(response)
        } else {
            crate::operation_deser::parse_list_inputs_response(response)
        }
    }
}

/// Operation shape for `ListInputSecurityGroups`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_input_security_groups`](crate::client::Client::list_input_security_groups).
///
/// See [`crate::client::fluent_builders::ListInputSecurityGroups`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInputSecurityGroups {
    _private: (),
}
impl ListInputSecurityGroups {
    /// Creates a new builder-style object to manufacture [`ListInputSecurityGroupsInput`](crate::input::ListInputSecurityGroupsInput)
    pub fn builder() -> crate::input::list_input_security_groups_input::Builder {
        crate::input::list_input_security_groups_input::Builder::default()
    }
    /// Creates a new `ListInputSecurityGroups` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInputSecurityGroups {
    type Output = std::result::Result<
        crate::output::ListInputSecurityGroupsOutput,
        crate::error::ListInputSecurityGroupsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_input_security_groups_error(response)
        } else {
            crate::operation_deser::parse_list_input_security_groups_response(response)
        }
    }
}

/// Operation shape for `ListMultiplexes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multiplexes`](crate::client::Client::list_multiplexes).
///
/// See [`crate::client::fluent_builders::ListMultiplexes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMultiplexes {
    _private: (),
}
impl ListMultiplexes {
    /// Creates a new builder-style object to manufacture [`ListMultiplexesInput`](crate::input::ListMultiplexesInput)
    pub fn builder() -> crate::input::list_multiplexes_input::Builder {
        crate::input::list_multiplexes_input::Builder::default()
    }
    /// Creates a new `ListMultiplexes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMultiplexes {
    type Output = std::result::Result<
        crate::output::ListMultiplexesOutput,
        crate::error::ListMultiplexesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multiplexes_error(response)
        } else {
            crate::operation_deser::parse_list_multiplexes_response(response)
        }
    }
}

/// Operation shape for `ListMultiplexPrograms`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_multiplex_programs`](crate::client::Client::list_multiplex_programs).
///
/// See [`crate::client::fluent_builders::ListMultiplexPrograms`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMultiplexPrograms {
    _private: (),
}
impl ListMultiplexPrograms {
    /// Creates a new builder-style object to manufacture [`ListMultiplexProgramsInput`](crate::input::ListMultiplexProgramsInput)
    pub fn builder() -> crate::input::list_multiplex_programs_input::Builder {
        crate::input::list_multiplex_programs_input::Builder::default()
    }
    /// Creates a new `ListMultiplexPrograms` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMultiplexPrograms {
    type Output = std::result::Result<
        crate::output::ListMultiplexProgramsOutput,
        crate::error::ListMultiplexProgramsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_multiplex_programs_error(response)
        } else {
            crate::operation_deser::parse_list_multiplex_programs_response(response)
        }
    }
}

/// Operation shape for `ListOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_offerings`](crate::client::Client::list_offerings).
///
/// See [`crate::client::fluent_builders::ListOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOfferings {
    _private: (),
}
impl ListOfferings {
    /// Creates a new builder-style object to manufacture [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    pub fn builder() -> crate::input::list_offerings_input::Builder {
        crate::input::list_offerings_input::Builder::default()
    }
    /// Creates a new `ListOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOfferings {
    type Output =
        std::result::Result<crate::output::ListOfferingsOutput, crate::error::ListOfferingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_offerings_error(response)
        } else {
            crate::operation_deser::parse_list_offerings_response(response)
        }
    }
}

/// Operation shape for `ListReservations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_reservations`](crate::client::Client::list_reservations).
///
/// See [`crate::client::fluent_builders::ListReservations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReservations {
    _private: (),
}
impl ListReservations {
    /// Creates a new builder-style object to manufacture [`ListReservationsInput`](crate::input::ListReservationsInput)
    pub fn builder() -> crate::input::list_reservations_input::Builder {
        crate::input::list_reservations_input::Builder::default()
    }
    /// Creates a new `ListReservations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReservations {
    type Output = std::result::Result<
        crate::output::ListReservationsOutput,
        crate::error::ListReservationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_reservations_error(response)
        } else {
            crate::operation_deser::parse_list_reservations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PurchaseOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_offering`](crate::client::Client::purchase_offering).
///
/// See [`crate::client::fluent_builders::PurchaseOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseOffering {
    _private: (),
}
impl PurchaseOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    pub fn builder() -> crate::input::purchase_offering_input::Builder {
        crate::input::purchase_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseOffering {
    type Output = std::result::Result<
        crate::output::PurchaseOfferingOutput,
        crate::error::PurchaseOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_purchase_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_offering_response(response)
        }
    }
}

/// Operation shape for `RejectInputDeviceTransfer`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_input_device_transfer`](crate::client::Client::reject_input_device_transfer).
///
/// See [`crate::client::fluent_builders::RejectInputDeviceTransfer`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectInputDeviceTransfer {
    _private: (),
}
impl RejectInputDeviceTransfer {
    /// Creates a new builder-style object to manufacture [`RejectInputDeviceTransferInput`](crate::input::RejectInputDeviceTransferInput)
    pub fn builder() -> crate::input::reject_input_device_transfer_input::Builder {
        crate::input::reject_input_device_transfer_input::Builder::default()
    }
    /// Creates a new `RejectInputDeviceTransfer` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectInputDeviceTransfer {
    type Output = std::result::Result<
        crate::output::RejectInputDeviceTransferOutput,
        crate::error::RejectInputDeviceTransferError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_input_device_transfer_error(response)
        } else {
            crate::operation_deser::parse_reject_input_device_transfer_response(response)
        }
    }
}

/// Operation shape for `StartChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_channel`](crate::client::Client::start_channel).
///
/// See [`crate::client::fluent_builders::StartChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartChannel {
    _private: (),
}
impl StartChannel {
    /// Creates a new builder-style object to manufacture [`StartChannelInput`](crate::input::StartChannelInput)
    pub fn builder() -> crate::input::start_channel_input::Builder {
        crate::input::start_channel_input::Builder::default()
    }
    /// Creates a new `StartChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartChannel {
    type Output =
        std::result::Result<crate::output::StartChannelOutput, crate::error::StartChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_channel_error(response)
        } else {
            crate::operation_deser::parse_start_channel_response(response)
        }
    }
}

/// Operation shape for `StartMultiplex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_multiplex`](crate::client::Client::start_multiplex).
///
/// See [`crate::client::fluent_builders::StartMultiplex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartMultiplex {
    _private: (),
}
impl StartMultiplex {
    /// Creates a new builder-style object to manufacture [`StartMultiplexInput`](crate::input::StartMultiplexInput)
    pub fn builder() -> crate::input::start_multiplex_input::Builder {
        crate::input::start_multiplex_input::Builder::default()
    }
    /// Creates a new `StartMultiplex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartMultiplex {
    type Output =
        std::result::Result<crate::output::StartMultiplexOutput, crate::error::StartMultiplexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_multiplex_error(response)
        } else {
            crate::operation_deser::parse_start_multiplex_response(response)
        }
    }
}

/// Operation shape for `StopChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_channel`](crate::client::Client::stop_channel).
///
/// See [`crate::client::fluent_builders::StopChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopChannel {
    _private: (),
}
impl StopChannel {
    /// Creates a new builder-style object to manufacture [`StopChannelInput`](crate::input::StopChannelInput)
    pub fn builder() -> crate::input::stop_channel_input::Builder {
        crate::input::stop_channel_input::Builder::default()
    }
    /// Creates a new `StopChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopChannel {
    type Output =
        std::result::Result<crate::output::StopChannelOutput, crate::error::StopChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_stop_channel_error(response)
        } else {
            crate::operation_deser::parse_stop_channel_response(response)
        }
    }
}

/// Operation shape for `StopMultiplex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_multiplex`](crate::client::Client::stop_multiplex).
///
/// See [`crate::client::fluent_builders::StopMultiplex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopMultiplex {
    _private: (),
}
impl StopMultiplex {
    /// Creates a new builder-style object to manufacture [`StopMultiplexInput`](crate::input::StopMultiplexInput)
    pub fn builder() -> crate::input::stop_multiplex_input::Builder {
        crate::input::stop_multiplex_input::Builder::default()
    }
    /// Creates a new `StopMultiplex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopMultiplex {
    type Output =
        std::result::Result<crate::output::StopMultiplexOutput, crate::error::StopMultiplexError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_stop_multiplex_error(response)
        } else {
            crate::operation_deser::parse_stop_multiplex_response(response)
        }
    }
}

/// Operation shape for `TransferInputDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`transfer_input_device`](crate::client::Client::transfer_input_device).
///
/// See [`crate::client::fluent_builders::TransferInputDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TransferInputDevice {
    _private: (),
}
impl TransferInputDevice {
    /// Creates a new builder-style object to manufacture [`TransferInputDeviceInput`](crate::input::TransferInputDeviceInput)
    pub fn builder() -> crate::input::transfer_input_device_input::Builder {
        crate::input::transfer_input_device_input::Builder::default()
    }
    /// Creates a new `TransferInputDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TransferInputDevice {
    type Output = std::result::Result<
        crate::output::TransferInputDeviceOutput,
        crate::error::TransferInputDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_transfer_input_device_error(response)
        } else {
            crate::operation_deser::parse_transfer_input_device_response(response)
        }
    }
}

/// Operation shape for `UpdateChannel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel`](crate::client::Client::update_channel).
///
/// See [`crate::client::fluent_builders::UpdateChannel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannel {
    _private: (),
}
impl UpdateChannel {
    /// Creates a new builder-style object to manufacture [`UpdateChannelInput`](crate::input::UpdateChannelInput)
    pub fn builder() -> crate::input::update_channel_input::Builder {
        crate::input::update_channel_input::Builder::default()
    }
    /// Creates a new `UpdateChannel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannel {
    type Output =
        std::result::Result<crate::output::UpdateChannelOutput, crate::error::UpdateChannelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_error(response)
        } else {
            crate::operation_deser::parse_update_channel_response(response)
        }
    }
}

/// Operation shape for `UpdateChannelClass`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_channel_class`](crate::client::Client::update_channel_class).
///
/// See [`crate::client::fluent_builders::UpdateChannelClass`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateChannelClass {
    _private: (),
}
impl UpdateChannelClass {
    /// Creates a new builder-style object to manufacture [`UpdateChannelClassInput`](crate::input::UpdateChannelClassInput)
    pub fn builder() -> crate::input::update_channel_class_input::Builder {
        crate::input::update_channel_class_input::Builder::default()
    }
    /// Creates a new `UpdateChannelClass` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateChannelClass {
    type Output = std::result::Result<
        crate::output::UpdateChannelClassOutput,
        crate::error::UpdateChannelClassError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_channel_class_error(response)
        } else {
            crate::operation_deser::parse_update_channel_class_response(response)
        }
    }
}

/// Operation shape for `UpdateInput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_input`](crate::client::Client::update_input).
///
/// See [`crate::client::fluent_builders::UpdateInput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInput {
    _private: (),
}
impl UpdateInput {
    /// Creates a new builder-style object to manufacture [`UpdateInputInput`](crate::input::UpdateInputInput)
    pub fn builder() -> crate::input::update_input_input::Builder {
        crate::input::update_input_input::Builder::default()
    }
    /// Creates a new `UpdateInput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInput {
    type Output =
        std::result::Result<crate::output::UpdateInputOutput, crate::error::UpdateInputError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_input_error(response)
        } else {
            crate::operation_deser::parse_update_input_response(response)
        }
    }
}

/// Operation shape for `UpdateInputDevice`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_input_device`](crate::client::Client::update_input_device).
///
/// See [`crate::client::fluent_builders::UpdateInputDevice`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInputDevice {
    _private: (),
}
impl UpdateInputDevice {
    /// Creates a new builder-style object to manufacture [`UpdateInputDeviceInput`](crate::input::UpdateInputDeviceInput)
    pub fn builder() -> crate::input::update_input_device_input::Builder {
        crate::input::update_input_device_input::Builder::default()
    }
    /// Creates a new `UpdateInputDevice` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInputDevice {
    type Output = std::result::Result<
        crate::output::UpdateInputDeviceOutput,
        crate::error::UpdateInputDeviceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_input_device_error(response)
        } else {
            crate::operation_deser::parse_update_input_device_response(response)
        }
    }
}

/// Operation shape for `UpdateInputSecurityGroup`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_input_security_group`](crate::client::Client::update_input_security_group).
///
/// See [`crate::client::fluent_builders::UpdateInputSecurityGroup`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateInputSecurityGroup {
    _private: (),
}
impl UpdateInputSecurityGroup {
    /// Creates a new builder-style object to manufacture [`UpdateInputSecurityGroupInput`](crate::input::UpdateInputSecurityGroupInput)
    pub fn builder() -> crate::input::update_input_security_group_input::Builder {
        crate::input::update_input_security_group_input::Builder::default()
    }
    /// Creates a new `UpdateInputSecurityGroup` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateInputSecurityGroup {
    type Output = std::result::Result<
        crate::output::UpdateInputSecurityGroupOutput,
        crate::error::UpdateInputSecurityGroupError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_input_security_group_error(response)
        } else {
            crate::operation_deser::parse_update_input_security_group_response(response)
        }
    }
}

/// Operation shape for `UpdateMultiplex`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_multiplex`](crate::client::Client::update_multiplex).
///
/// See [`crate::client::fluent_builders::UpdateMultiplex`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMultiplex {
    _private: (),
}
impl UpdateMultiplex {
    /// Creates a new builder-style object to manufacture [`UpdateMultiplexInput`](crate::input::UpdateMultiplexInput)
    pub fn builder() -> crate::input::update_multiplex_input::Builder {
        crate::input::update_multiplex_input::Builder::default()
    }
    /// Creates a new `UpdateMultiplex` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMultiplex {
    type Output = std::result::Result<
        crate::output::UpdateMultiplexOutput,
        crate::error::UpdateMultiplexError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_multiplex_error(response)
        } else {
            crate::operation_deser::parse_update_multiplex_response(response)
        }
    }
}

/// Operation shape for `UpdateMultiplexProgram`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_multiplex_program`](crate::client::Client::update_multiplex_program).
///
/// See [`crate::client::fluent_builders::UpdateMultiplexProgram`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMultiplexProgram {
    _private: (),
}
impl UpdateMultiplexProgram {
    /// Creates a new builder-style object to manufacture [`UpdateMultiplexProgramInput`](crate::input::UpdateMultiplexProgramInput)
    pub fn builder() -> crate::input::update_multiplex_program_input::Builder {
        crate::input::update_multiplex_program_input::Builder::default()
    }
    /// Creates a new `UpdateMultiplexProgram` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMultiplexProgram {
    type Output = std::result::Result<
        crate::output::UpdateMultiplexProgramOutput,
        crate::error::UpdateMultiplexProgramError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_multiplex_program_error(response)
        } else {
            crate::operation_deser::parse_update_multiplex_program_response(response)
        }
    }
}

/// Operation shape for `UpdateReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_reservation`](crate::client::Client::update_reservation).
///
/// See [`crate::client::fluent_builders::UpdateReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateReservation {
    _private: (),
}
impl UpdateReservation {
    /// Creates a new builder-style object to manufacture [`UpdateReservationInput`](crate::input::UpdateReservationInput)
    pub fn builder() -> crate::input::update_reservation_input::Builder {
        crate::input::update_reservation_input::Builder::default()
    }
    /// Creates a new `UpdateReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateReservation {
    type Output = std::result::Result<
        crate::output::UpdateReservationOutput,
        crate::error::UpdateReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_reservation_error(response)
        } else {
            crate::operation_deser::parse_update_reservation_response(response)
        }
    }
}
