// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateQueueOutput {
    /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
    pub queue: std::option::Option<crate::model::Queue>,
}
impl UpdateQueueOutput {
    /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
    pub fn queue(&self) -> std::option::Option<&crate::model::Queue> {
        self.queue.as_ref()
    }
}
impl std::fmt::Debug for UpdateQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateQueueOutput");
        formatter.field("queue", &self.queue);
        formatter.finish()
    }
}
/// See [`UpdateQueueOutput`](crate::output::UpdateQueueOutput)
pub mod update_queue_output {
    /// A builder for [`UpdateQueueOutput`](crate::output::UpdateQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue: std::option::Option<crate::model::Queue>,
    }
    impl Builder {
        /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
        pub fn queue(mut self, input: crate::model::Queue) -> Self {
            self.queue = Some(input);
            self
        }
        /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
        pub fn set_queue(mut self, input: std::option::Option<crate::model::Queue>) -> Self {
            self.queue = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateQueueOutput`](crate::output::UpdateQueueOutput)
        pub fn build(self) -> crate::output::UpdateQueueOutput {
            crate::output::UpdateQueueOutput { queue: self.queue }
        }
    }
}
impl UpdateQueueOutput {
    /// Creates a new builder-style object to manufacture [`UpdateQueueOutput`](crate::output::UpdateQueueOutput)
    pub fn builder() -> crate::output::update_queue_output::Builder {
        crate::output::update_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdatePresetOutput {
    /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
    pub preset: std::option::Option<crate::model::Preset>,
}
impl UpdatePresetOutput {
    /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
    pub fn preset(&self) -> std::option::Option<&crate::model::Preset> {
        self.preset.as_ref()
    }
}
impl std::fmt::Debug for UpdatePresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdatePresetOutput");
        formatter.field("preset", &self.preset);
        formatter.finish()
    }
}
/// See [`UpdatePresetOutput`](crate::output::UpdatePresetOutput)
pub mod update_preset_output {
    /// A builder for [`UpdatePresetOutput`](crate::output::UpdatePresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset: std::option::Option<crate::model::Preset>,
    }
    impl Builder {
        /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
        pub fn preset(mut self, input: crate::model::Preset) -> Self {
            self.preset = Some(input);
            self
        }
        /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
        pub fn set_preset(mut self, input: std::option::Option<crate::model::Preset>) -> Self {
            self.preset = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdatePresetOutput`](crate::output::UpdatePresetOutput)
        pub fn build(self) -> crate::output::UpdatePresetOutput {
            crate::output::UpdatePresetOutput {
                preset: self.preset,
            }
        }
    }
}
impl UpdatePresetOutput {
    /// Creates a new builder-style object to manufacture [`UpdatePresetOutput`](crate::output::UpdatePresetOutput)
    pub fn builder() -> crate::output::update_preset_output::Builder {
        crate::output::update_preset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateJobTemplateOutput {
    /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
    pub job_template: std::option::Option<crate::model::JobTemplate>,
}
impl UpdateJobTemplateOutput {
    /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
    pub fn job_template(&self) -> std::option::Option<&crate::model::JobTemplate> {
        self.job_template.as_ref()
    }
}
impl std::fmt::Debug for UpdateJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateJobTemplateOutput");
        formatter.field("job_template", &self.job_template);
        formatter.finish()
    }
}
/// See [`UpdateJobTemplateOutput`](crate::output::UpdateJobTemplateOutput)
pub mod update_job_template_output {
    /// A builder for [`UpdateJobTemplateOutput`](crate::output::UpdateJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template: std::option::Option<crate::model::JobTemplate>,
    }
    impl Builder {
        /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
        pub fn job_template(mut self, input: crate::model::JobTemplate) -> Self {
            self.job_template = Some(input);
            self
        }
        /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
        pub fn set_job_template(
            mut self,
            input: std::option::Option<crate::model::JobTemplate>,
        ) -> Self {
            self.job_template = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateJobTemplateOutput`](crate::output::UpdateJobTemplateOutput)
        pub fn build(self) -> crate::output::UpdateJobTemplateOutput {
            crate::output::UpdateJobTemplateOutput {
                job_template: self.job_template,
            }
        }
    }
}
impl UpdateJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`UpdateJobTemplateOutput`](crate::output::UpdateJobTemplateOutput)
    pub fn builder() -> crate::output::update_job_template_output::Builder {
        crate::output::update_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutPolicyOutput {
    /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub policy: std::option::Option<crate::model::Policy>,
}
impl PutPolicyOutput {
    /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for PutPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`PutPolicyOutput`](crate::output::PutPolicyOutput)
pub mod put_policy_output {
    /// A builder for [`PutPolicyOutput`](crate::output::PutPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`PutPolicyOutput`](crate::output::PutPolicyOutput)
        pub fn build(self) -> crate::output::PutPolicyOutput {
            crate::output::PutPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl PutPolicyOutput {
    /// Creates a new builder-style object to manufacture [`PutPolicyOutput`](crate::output::PutPolicyOutput)
    pub fn builder() -> crate::output::put_policy_output::Builder {
        crate::output::put_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
    pub resource_tags: std::option::Option<crate::model::ResourceTags>,
}
impl ListTagsForResourceOutput {
    /// The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
    pub fn resource_tags(&self) -> std::option::Option<&crate::model::ResourceTags> {
        self.resource_tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("resource_tags", &self.resource_tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_tags: std::option::Option<crate::model::ResourceTags>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
        pub fn resource_tags(mut self, input: crate::model::ResourceTags) -> Self {
            self.resource_tags = Some(input);
            self
        }
        /// The Amazon Resource Name (ARN) and tags for an AWS Elemental MediaConvert resource.
        pub fn set_resource_tags(
            mut self,
            input: std::option::Option<crate::model::ResourceTags>,
        ) -> Self {
            self.resource_tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput {
                resource_tags: self.resource_tags,
            }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListQueuesOutput {
    /// Use this string to request the next batch of queues.
    pub next_token: std::option::Option<std::string::String>,
    /// List of queues.
    pub queues: std::option::Option<std::vec::Vec<crate::model::Queue>>,
}
impl ListQueuesOutput {
    /// Use this string to request the next batch of queues.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// List of queues.
    pub fn queues(&self) -> std::option::Option<&[crate::model::Queue]> {
        self.queues.as_deref()
    }
}
impl std::fmt::Debug for ListQueuesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListQueuesOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("queues", &self.queues);
        formatter.finish()
    }
}
/// See [`ListQueuesOutput`](crate::output::ListQueuesOutput)
pub mod list_queues_output {
    /// A builder for [`ListQueuesOutput`](crate::output::ListQueuesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) queues: std::option::Option<std::vec::Vec<crate::model::Queue>>,
    }
    impl Builder {
        /// Use this string to request the next batch of queues.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Use this string to request the next batch of queues.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `queues`.
        ///
        /// To override the contents of this collection use [`set_queues`](Self::set_queues).
        ///
        /// List of queues.
        pub fn queues(mut self, input: impl Into<crate::model::Queue>) -> Self {
            let mut v = self.queues.unwrap_or_default();
            v.push(input.into());
            self.queues = Some(v);
            self
        }
        /// List of queues.
        pub fn set_queues(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Queue>>,
        ) -> Self {
            self.queues = input;
            self
        }
        /// Consumes the builder and constructs a [`ListQueuesOutput`](crate::output::ListQueuesOutput)
        pub fn build(self) -> crate::output::ListQueuesOutput {
            crate::output::ListQueuesOutput {
                next_token: self.next_token,
                queues: self.queues,
            }
        }
    }
}
impl ListQueuesOutput {
    /// Creates a new builder-style object to manufacture [`ListQueuesOutput`](crate::output::ListQueuesOutput)
    pub fn builder() -> crate::output::list_queues_output::Builder {
        crate::output::list_queues_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListPresetsOutput {
    /// Use this string to request the next batch of presets.
    pub next_token: std::option::Option<std::string::String>,
    /// List of presets
    pub presets: std::option::Option<std::vec::Vec<crate::model::Preset>>,
}
impl ListPresetsOutput {
    /// Use this string to request the next batch of presets.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// List of presets
    pub fn presets(&self) -> std::option::Option<&[crate::model::Preset]> {
        self.presets.as_deref()
    }
}
impl std::fmt::Debug for ListPresetsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListPresetsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("presets", &self.presets);
        formatter.finish()
    }
}
/// See [`ListPresetsOutput`](crate::output::ListPresetsOutput)
pub mod list_presets_output {
    /// A builder for [`ListPresetsOutput`](crate::output::ListPresetsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) presets: std::option::Option<std::vec::Vec<crate::model::Preset>>,
    }
    impl Builder {
        /// Use this string to request the next batch of presets.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Use this string to request the next batch of presets.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `presets`.
        ///
        /// To override the contents of this collection use [`set_presets`](Self::set_presets).
        ///
        /// List of presets
        pub fn presets(mut self, input: impl Into<crate::model::Preset>) -> Self {
            let mut v = self.presets.unwrap_or_default();
            v.push(input.into());
            self.presets = Some(v);
            self
        }
        /// List of presets
        pub fn set_presets(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Preset>>,
        ) -> Self {
            self.presets = input;
            self
        }
        /// Consumes the builder and constructs a [`ListPresetsOutput`](crate::output::ListPresetsOutput)
        pub fn build(self) -> crate::output::ListPresetsOutput {
            crate::output::ListPresetsOutput {
                next_token: self.next_token,
                presets: self.presets,
            }
        }
    }
}
impl ListPresetsOutput {
    /// Creates a new builder-style object to manufacture [`ListPresetsOutput`](crate::output::ListPresetsOutput)
    pub fn builder() -> crate::output::list_presets_output::Builder {
        crate::output::list_presets_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobTemplatesOutput {
    /// List of Job templates.
    pub job_templates: std::option::Option<std::vec::Vec<crate::model::JobTemplate>>,
    /// Use this string to request the next batch of job templates.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobTemplatesOutput {
    /// List of Job templates.
    pub fn job_templates(&self) -> std::option::Option<&[crate::model::JobTemplate]> {
        self.job_templates.as_deref()
    }
    /// Use this string to request the next batch of job templates.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobTemplatesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobTemplatesOutput");
        formatter.field("job_templates", &self.job_templates);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
pub mod list_job_templates_output {
    /// A builder for [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_templates: std::option::Option<std::vec::Vec<crate::model::JobTemplate>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `job_templates`.
        ///
        /// To override the contents of this collection use [`set_job_templates`](Self::set_job_templates).
        ///
        /// List of Job templates.
        pub fn job_templates(mut self, input: impl Into<crate::model::JobTemplate>) -> Self {
            let mut v = self.job_templates.unwrap_or_default();
            v.push(input.into());
            self.job_templates = Some(v);
            self
        }
        /// List of Job templates.
        pub fn set_job_templates(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobTemplate>>,
        ) -> Self {
            self.job_templates = input;
            self
        }
        /// Use this string to request the next batch of job templates.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Use this string to request the next batch of job templates.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
        pub fn build(self) -> crate::output::ListJobTemplatesOutput {
            crate::output::ListJobTemplatesOutput {
                job_templates: self.job_templates,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobTemplatesOutput {
    /// Creates a new builder-style object to manufacture [`ListJobTemplatesOutput`](crate::output::ListJobTemplatesOutput)
    pub fn builder() -> crate::output::list_job_templates_output::Builder {
        crate::output::list_job_templates_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsOutput {
    /// List of jobs
    pub jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
    /// Use this string to request the next batch of jobs.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListJobsOutput {
    /// List of jobs
    pub fn jobs(&self) -> std::option::Option<&[crate::model::Job]> {
        self.jobs.as_deref()
    }
    /// Use this string to request the next batch of jobs.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsOutput");
        formatter.field("jobs", &self.jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListJobsOutput`](crate::output::ListJobsOutput)
pub mod list_jobs_output {
    /// A builder for [`ListJobsOutput`](crate::output::ListJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) jobs: std::option::Option<std::vec::Vec<crate::model::Job>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `jobs`.
        ///
        /// To override the contents of this collection use [`set_jobs`](Self::set_jobs).
        ///
        /// List of jobs
        pub fn jobs(mut self, input: impl Into<crate::model::Job>) -> Self {
            let mut v = self.jobs.unwrap_or_default();
            v.push(input.into());
            self.jobs = Some(v);
            self
        }
        /// List of jobs
        pub fn set_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Job>>,
        ) -> Self {
            self.jobs = input;
            self
        }
        /// Use this string to request the next batch of jobs.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Use this string to request the next batch of jobs.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsOutput`](crate::output::ListJobsOutput)
        pub fn build(self) -> crate::output::ListJobsOutput {
            crate::output::ListJobsOutput {
                jobs: self.jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListJobsOutput`](crate::output::ListJobsOutput)
    pub fn builder() -> crate::output::list_jobs_output::Builder {
        crate::output::list_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetQueueOutput {
    /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
    pub queue: std::option::Option<crate::model::Queue>,
}
impl GetQueueOutput {
    /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
    pub fn queue(&self) -> std::option::Option<&crate::model::Queue> {
        self.queue.as_ref()
    }
}
impl std::fmt::Debug for GetQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetQueueOutput");
        formatter.field("queue", &self.queue);
        formatter.finish()
    }
}
/// See [`GetQueueOutput`](crate::output::GetQueueOutput)
pub mod get_queue_output {
    /// A builder for [`GetQueueOutput`](crate::output::GetQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue: std::option::Option<crate::model::Queue>,
    }
    impl Builder {
        /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
        pub fn queue(mut self, input: crate::model::Queue) -> Self {
            self.queue = Some(input);
            self
        }
        /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
        pub fn set_queue(mut self, input: std::option::Option<crate::model::Queue>) -> Self {
            self.queue = input;
            self
        }
        /// Consumes the builder and constructs a [`GetQueueOutput`](crate::output::GetQueueOutput)
        pub fn build(self) -> crate::output::GetQueueOutput {
            crate::output::GetQueueOutput { queue: self.queue }
        }
    }
}
impl GetQueueOutput {
    /// Creates a new builder-style object to manufacture [`GetQueueOutput`](crate::output::GetQueueOutput)
    pub fn builder() -> crate::output::get_queue_output::Builder {
        crate::output::get_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPresetOutput {
    /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
    pub preset: std::option::Option<crate::model::Preset>,
}
impl GetPresetOutput {
    /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
    pub fn preset(&self) -> std::option::Option<&crate::model::Preset> {
        self.preset.as_ref()
    }
}
impl std::fmt::Debug for GetPresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPresetOutput");
        formatter.field("preset", &self.preset);
        formatter.finish()
    }
}
/// See [`GetPresetOutput`](crate::output::GetPresetOutput)
pub mod get_preset_output {
    /// A builder for [`GetPresetOutput`](crate::output::GetPresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset: std::option::Option<crate::model::Preset>,
    }
    impl Builder {
        /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
        pub fn preset(mut self, input: crate::model::Preset) -> Self {
            self.preset = Some(input);
            self
        }
        /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
        pub fn set_preset(mut self, input: std::option::Option<crate::model::Preset>) -> Self {
            self.preset = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPresetOutput`](crate::output::GetPresetOutput)
        pub fn build(self) -> crate::output::GetPresetOutput {
            crate::output::GetPresetOutput {
                preset: self.preset,
            }
        }
    }
}
impl GetPresetOutput {
    /// Creates a new builder-style object to manufacture [`GetPresetOutput`](crate::output::GetPresetOutput)
    pub fn builder() -> crate::output::get_preset_output::Builder {
        crate::output::get_preset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetPolicyOutput {
    /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub policy: std::option::Option<crate::model::Policy>,
}
impl GetPolicyOutput {
    /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub fn policy(&self) -> std::option::Option<&crate::model::Policy> {
        self.policy.as_ref()
    }
}
impl std::fmt::Debug for GetPolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetPolicyOutput");
        formatter.field("policy", &self.policy);
        formatter.finish()
    }
}
/// See [`GetPolicyOutput`](crate::output::GetPolicyOutput)
pub mod get_policy_output {
    /// A builder for [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) policy: std::option::Option<crate::model::Policy>,
    }
    impl Builder {
        /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn policy(mut self, input: crate::model::Policy) -> Self {
            self.policy = Some(input);
            self
        }
        /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.policy = input;
            self
        }
        /// Consumes the builder and constructs a [`GetPolicyOutput`](crate::output::GetPolicyOutput)
        pub fn build(self) -> crate::output::GetPolicyOutput {
            crate::output::GetPolicyOutput {
                policy: self.policy,
            }
        }
    }
}
impl GetPolicyOutput {
    /// Creates a new builder-style object to manufacture [`GetPolicyOutput`](crate::output::GetPolicyOutput)
    pub fn builder() -> crate::output::get_policy_output::Builder {
        crate::output::get_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobTemplateOutput {
    /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
    pub job_template: std::option::Option<crate::model::JobTemplate>,
}
impl GetJobTemplateOutput {
    /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
    pub fn job_template(&self) -> std::option::Option<&crate::model::JobTemplate> {
        self.job_template.as_ref()
    }
}
impl std::fmt::Debug for GetJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobTemplateOutput");
        formatter.field("job_template", &self.job_template);
        formatter.finish()
    }
}
/// See [`GetJobTemplateOutput`](crate::output::GetJobTemplateOutput)
pub mod get_job_template_output {
    /// A builder for [`GetJobTemplateOutput`](crate::output::GetJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template: std::option::Option<crate::model::JobTemplate>,
    }
    impl Builder {
        /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
        pub fn job_template(mut self, input: crate::model::JobTemplate) -> Self {
            self.job_template = Some(input);
            self
        }
        /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
        pub fn set_job_template(
            mut self,
            input: std::option::Option<crate::model::JobTemplate>,
        ) -> Self {
            self.job_template = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobTemplateOutput`](crate::output::GetJobTemplateOutput)
        pub fn build(self) -> crate::output::GetJobTemplateOutput {
            crate::output::GetJobTemplateOutput {
                job_template: self.job_template,
            }
        }
    }
}
impl GetJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`GetJobTemplateOutput`](crate::output::GetJobTemplateOutput)
    pub fn builder() -> crate::output::get_job_template_output::Builder {
        crate::output::get_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetJobOutput {
    /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub job: std::option::Option<crate::model::Job>,
}
impl GetJobOutput {
    /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for GetJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`GetJobOutput`](crate::output::GetJobOutput)
pub mod get_job_output {
    /// A builder for [`GetJobOutput`](crate::output::GetJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`GetJobOutput`](crate::output::GetJobOutput)
        pub fn build(self) -> crate::output::GetJobOutput {
            crate::output::GetJobOutput { job: self.job }
        }
    }
}
impl GetJobOutput {
    /// Creates a new builder-style object to manufacture [`GetJobOutput`](crate::output::GetJobOutput)
    pub fn builder() -> crate::output::get_job_output::Builder {
        crate::output::get_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateCertificateOutput {}
impl std::fmt::Debug for DisassociateCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateCertificateOutput");
        formatter.finish()
    }
}
/// See [`DisassociateCertificateOutput`](crate::output::DisassociateCertificateOutput)
pub mod disassociate_certificate_output {
    /// A builder for [`DisassociateCertificateOutput`](crate::output::DisassociateCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateCertificateOutput`](crate::output::DisassociateCertificateOutput)
        pub fn build(self) -> crate::output::DisassociateCertificateOutput {
            crate::output::DisassociateCertificateOutput {}
        }
    }
}
impl DisassociateCertificateOutput {
    /// Creates a new builder-style object to manufacture [`DisassociateCertificateOutput`](crate::output::DisassociateCertificateOutput)
    pub fn builder() -> crate::output::disassociate_certificate_output::Builder {
        crate::output::disassociate_certificate_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEndpointsOutput {
    /// List of endpoints
    pub endpoints: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
    /// Use this string to request the next batch of endpoints.
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEndpointsOutput {
    /// List of endpoints
    pub fn endpoints(&self) -> std::option::Option<&[crate::model::Endpoint]> {
        self.endpoints.as_deref()
    }
    /// Use this string to request the next batch of endpoints.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEndpointsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEndpointsOutput");
        formatter.field("endpoints", &self.endpoints);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
pub mod describe_endpoints_output {
    /// A builder for [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) endpoints: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `endpoints`.
        ///
        /// To override the contents of this collection use [`set_endpoints`](Self::set_endpoints).
        ///
        /// List of endpoints
        pub fn endpoints(mut self, input: impl Into<crate::model::Endpoint>) -> Self {
            let mut v = self.endpoints.unwrap_or_default();
            v.push(input.into());
            self.endpoints = Some(v);
            self
        }
        /// List of endpoints
        pub fn set_endpoints(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Endpoint>>,
        ) -> Self {
            self.endpoints = input;
            self
        }
        /// Use this string to request the next batch of endpoints.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// Use this string to request the next batch of endpoints.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
        pub fn build(self) -> crate::output::DescribeEndpointsOutput {
            crate::output::DescribeEndpointsOutput {
                endpoints: self.endpoints,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEndpointsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsOutput`](crate::output::DescribeEndpointsOutput)
    pub fn builder() -> crate::output::describe_endpoints_output::Builder {
        crate::output::describe_endpoints_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteQueueOutput {}
impl std::fmt::Debug for DeleteQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteQueueOutput");
        formatter.finish()
    }
}
/// See [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
pub mod delete_queue_output {
    /// A builder for [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
        pub fn build(self) -> crate::output::DeleteQueueOutput {
            crate::output::DeleteQueueOutput {}
        }
    }
}
impl DeleteQueueOutput {
    /// Creates a new builder-style object to manufacture [`DeleteQueueOutput`](crate::output::DeleteQueueOutput)
    pub fn builder() -> crate::output::delete_queue_output::Builder {
        crate::output::delete_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePresetOutput {}
impl std::fmt::Debug for DeletePresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePresetOutput");
        formatter.finish()
    }
}
/// See [`DeletePresetOutput`](crate::output::DeletePresetOutput)
pub mod delete_preset_output {
    /// A builder for [`DeletePresetOutput`](crate::output::DeletePresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePresetOutput`](crate::output::DeletePresetOutput)
        pub fn build(self) -> crate::output::DeletePresetOutput {
            crate::output::DeletePresetOutput {}
        }
    }
}
impl DeletePresetOutput {
    /// Creates a new builder-style object to manufacture [`DeletePresetOutput`](crate::output::DeletePresetOutput)
    pub fn builder() -> crate::output::delete_preset_output::Builder {
        crate::output::delete_preset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeletePolicyOutput {}
impl std::fmt::Debug for DeletePolicyOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeletePolicyOutput");
        formatter.finish()
    }
}
/// See [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
pub mod delete_policy_output {
    /// A builder for [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
        pub fn build(self) -> crate::output::DeletePolicyOutput {
            crate::output::DeletePolicyOutput {}
        }
    }
}
impl DeletePolicyOutput {
    /// Creates a new builder-style object to manufacture [`DeletePolicyOutput`](crate::output::DeletePolicyOutput)
    pub fn builder() -> crate::output::delete_policy_output::Builder {
        crate::output::delete_policy_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteJobTemplateOutput {}
impl std::fmt::Debug for DeleteJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteJobTemplateOutput");
        formatter.finish()
    }
}
/// See [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
pub mod delete_job_template_output {
    /// A builder for [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
        pub fn build(self) -> crate::output::DeleteJobTemplateOutput {
            crate::output::DeleteJobTemplateOutput {}
        }
    }
}
impl DeleteJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`DeleteJobTemplateOutput`](crate::output::DeleteJobTemplateOutput)
    pub fn builder() -> crate::output::delete_job_template_output::Builder {
        crate::output::delete_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateQueueOutput {
    /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
    pub queue: std::option::Option<crate::model::Queue>,
}
impl CreateQueueOutput {
    /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
    pub fn queue(&self) -> std::option::Option<&crate::model::Queue> {
        self.queue.as_ref()
    }
}
impl std::fmt::Debug for CreateQueueOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateQueueOutput");
        formatter.field("queue", &self.queue);
        formatter.finish()
    }
}
/// See [`CreateQueueOutput`](crate::output::CreateQueueOutput)
pub mod create_queue_output {
    /// A builder for [`CreateQueueOutput`](crate::output::CreateQueueOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) queue: std::option::Option<crate::model::Queue>,
    }
    impl Builder {
        /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
        pub fn queue(mut self, input: crate::model::Queue) -> Self {
            self.queue = Some(input);
            self
        }
        /// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
        pub fn set_queue(mut self, input: std::option::Option<crate::model::Queue>) -> Self {
            self.queue = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateQueueOutput`](crate::output::CreateQueueOutput)
        pub fn build(self) -> crate::output::CreateQueueOutput {
            crate::output::CreateQueueOutput { queue: self.queue }
        }
    }
}
impl CreateQueueOutput {
    /// Creates a new builder-style object to manufacture [`CreateQueueOutput`](crate::output::CreateQueueOutput)
    pub fn builder() -> crate::output::create_queue_output::Builder {
        crate::output::create_queue_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreatePresetOutput {
    /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
    pub preset: std::option::Option<crate::model::Preset>,
}
impl CreatePresetOutput {
    /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
    pub fn preset(&self) -> std::option::Option<&crate::model::Preset> {
        self.preset.as_ref()
    }
}
impl std::fmt::Debug for CreatePresetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreatePresetOutput");
        formatter.field("preset", &self.preset);
        formatter.finish()
    }
}
/// See [`CreatePresetOutput`](crate::output::CreatePresetOutput)
pub mod create_preset_output {
    /// A builder for [`CreatePresetOutput`](crate::output::CreatePresetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) preset: std::option::Option<crate::model::Preset>,
    }
    impl Builder {
        /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
        pub fn preset(mut self, input: crate::model::Preset) -> Self {
            self.preset = Some(input);
            self
        }
        /// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
        pub fn set_preset(mut self, input: std::option::Option<crate::model::Preset>) -> Self {
            self.preset = input;
            self
        }
        /// Consumes the builder and constructs a [`CreatePresetOutput`](crate::output::CreatePresetOutput)
        pub fn build(self) -> crate::output::CreatePresetOutput {
            crate::output::CreatePresetOutput {
                preset: self.preset,
            }
        }
    }
}
impl CreatePresetOutput {
    /// Creates a new builder-style object to manufacture [`CreatePresetOutput`](crate::output::CreatePresetOutput)
    pub fn builder() -> crate::output::create_preset_output::Builder {
        crate::output::create_preset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobTemplateOutput {
    /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
    pub job_template: std::option::Option<crate::model::JobTemplate>,
}
impl CreateJobTemplateOutput {
    /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
    pub fn job_template(&self) -> std::option::Option<&crate::model::JobTemplate> {
        self.job_template.as_ref()
    }
}
impl std::fmt::Debug for CreateJobTemplateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobTemplateOutput");
        formatter.field("job_template", &self.job_template);
        formatter.finish()
    }
}
/// See [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
pub mod create_job_template_output {
    /// A builder for [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_template: std::option::Option<crate::model::JobTemplate>,
    }
    impl Builder {
        /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
        pub fn job_template(mut self, input: crate::model::JobTemplate) -> Self {
            self.job_template = Some(input);
            self
        }
        /// A job template is a pre-made set of encoding instructions that you can use to quickly create a job.
        pub fn set_job_template(
            mut self,
            input: std::option::Option<crate::model::JobTemplate>,
        ) -> Self {
            self.job_template = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
        pub fn build(self) -> crate::output::CreateJobTemplateOutput {
            crate::output::CreateJobTemplateOutput {
                job_template: self.job_template,
            }
        }
    }
}
impl CreateJobTemplateOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobTemplateOutput`](crate::output::CreateJobTemplateOutput)
    pub fn builder() -> crate::output::create_job_template_output::Builder {
        crate::output::create_job_template_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateJobOutput {
    /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub job: std::option::Option<crate::model::Job>,
}
impl CreateJobOutput {
    /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    pub fn job(&self) -> std::option::Option<&crate::model::Job> {
        self.job.as_ref()
    }
}
impl std::fmt::Debug for CreateJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateJobOutput");
        formatter.field("job", &self.job);
        formatter.finish()
    }
}
/// See [`CreateJobOutput`](crate::output::CreateJobOutput)
pub mod create_job_output {
    /// A builder for [`CreateJobOutput`](crate::output::CreateJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job: std::option::Option<crate::model::Job>,
    }
    impl Builder {
        /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn job(mut self, input: crate::model::Job) -> Self {
            self.job = Some(input);
            self
        }
        /// Each job converts an input file into an output file or files. For more information, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn set_job(mut self, input: std::option::Option<crate::model::Job>) -> Self {
            self.job = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateJobOutput`](crate::output::CreateJobOutput)
        pub fn build(self) -> crate::output::CreateJobOutput {
            crate::output::CreateJobOutput { job: self.job }
        }
    }
}
impl CreateJobOutput {
    /// Creates a new builder-style object to manufacture [`CreateJobOutput`](crate::output::CreateJobOutput)
    pub fn builder() -> crate::output::create_job_output::Builder {
        crate::output::create_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelJobOutput {}
impl std::fmt::Debug for CancelJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelJobOutput");
        formatter.finish()
    }
}
/// See [`CancelJobOutput`](crate::output::CancelJobOutput)
pub mod cancel_job_output {
    /// A builder for [`CancelJobOutput`](crate::output::CancelJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`CancelJobOutput`](crate::output::CancelJobOutput)
        pub fn build(self) -> crate::output::CancelJobOutput {
            crate::output::CancelJobOutput {}
        }
    }
}
impl CancelJobOutput {
    /// Creates a new builder-style object to manufacture [`CancelJobOutput`](crate::output::CancelJobOutput)
    pub fn builder() -> crate::output::cancel_job_output::Builder {
        crate::output::cancel_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssociateCertificateOutput {}
impl std::fmt::Debug for AssociateCertificateOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssociateCertificateOutput");
        formatter.finish()
    }
}
/// See [`AssociateCertificateOutput`](crate::output::AssociateCertificateOutput)
pub mod associate_certificate_output {
    /// A builder for [`AssociateCertificateOutput`](crate::output::AssociateCertificateOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`AssociateCertificateOutput`](crate::output::AssociateCertificateOutput)
        pub fn build(self) -> crate::output::AssociateCertificateOutput {
            crate::output::AssociateCertificateOutput {}
        }
    }
}
impl AssociateCertificateOutput {
    /// Creates a new builder-style object to manufacture [`AssociateCertificateOutput`](crate::output::AssociateCertificateOutput)
    pub fn builder() -> crate::output::associate_certificate_output::Builder {
        crate::output::associate_certificate_output::Builder::default()
    }
}
