// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AssociateCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`associate_certificate`](crate::client::Client::associate_certificate).
///
/// See [`crate::client::fluent_builders::AssociateCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AssociateCertificate {
    _private: (),
}
impl AssociateCertificate {
    /// Creates a new builder-style object to manufacture [`AssociateCertificateInput`](crate::input::AssociateCertificateInput)
    pub fn builder() -> crate::input::associate_certificate_input::Builder {
        crate::input::associate_certificate_input::Builder::default()
    }
    /// Creates a new `AssociateCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AssociateCertificate {
    type Output = std::result::Result<
        crate::output::AssociateCertificateOutput,
        crate::error::AssociateCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_associate_certificate_error(response)
        } else {
            crate::operation_deser::parse_associate_certificate_response(response)
        }
    }
}

/// Operation shape for `CancelJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_job`](crate::client::Client::cancel_job).
///
/// See [`crate::client::fluent_builders::CancelJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelJob {
    _private: (),
}
impl CancelJob {
    /// Creates a new builder-style object to manufacture [`CancelJobInput`](crate::input::CancelJobInput)
    pub fn builder() -> crate::input::cancel_job_input::Builder {
        crate::input::cancel_job_input::Builder::default()
    }
    /// Creates a new `CancelJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelJob {
    type Output = std::result::Result<crate::output::CancelJobOutput, crate::error::CancelJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_cancel_job_error(response)
        } else {
            crate::operation_deser::parse_cancel_job_response(response)
        }
    }
}

/// Operation shape for `CreateJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job`](crate::client::Client::create_job).
///
/// See [`crate::client::fluent_builders::CreateJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJob {
    _private: (),
}
impl CreateJob {
    /// Creates a new builder-style object to manufacture [`CreateJobInput`](crate::input::CreateJobInput)
    pub fn builder() -> crate::input::create_job_input::Builder {
        crate::input::create_job_input::Builder::default()
    }
    /// Creates a new `CreateJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJob {
    type Output = std::result::Result<crate::output::CreateJobOutput, crate::error::CreateJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_job_error(response)
        } else {
            crate::operation_deser::parse_create_job_response(response)
        }
    }
}

/// Operation shape for `CreateJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_job_template`](crate::client::Client::create_job_template).
///
/// See [`crate::client::fluent_builders::CreateJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateJobTemplate {
    _private: (),
}
impl CreateJobTemplate {
    /// Creates a new builder-style object to manufacture [`CreateJobTemplateInput`](crate::input::CreateJobTemplateInput)
    pub fn builder() -> crate::input::create_job_template_input::Builder {
        crate::input::create_job_template_input::Builder::default()
    }
    /// Creates a new `CreateJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateJobTemplate {
    type Output = std::result::Result<
        crate::output::CreateJobTemplateOutput,
        crate::error::CreateJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_job_template_error(response)
        } else {
            crate::operation_deser::parse_create_job_template_response(response)
        }
    }
}

/// Operation shape for `CreatePreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_preset`](crate::client::Client::create_preset).
///
/// See [`crate::client::fluent_builders::CreatePreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreatePreset {
    _private: (),
}
impl CreatePreset {
    /// Creates a new builder-style object to manufacture [`CreatePresetInput`](crate::input::CreatePresetInput)
    pub fn builder() -> crate::input::create_preset_input::Builder {
        crate::input::create_preset_input::Builder::default()
    }
    /// Creates a new `CreatePreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreatePreset {
    type Output =
        std::result::Result<crate::output::CreatePresetOutput, crate::error::CreatePresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_preset_error(response)
        } else {
            crate::operation_deser::parse_create_preset_response(response)
        }
    }
}

/// Operation shape for `CreateQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_queue`](crate::client::Client::create_queue).
///
/// See [`crate::client::fluent_builders::CreateQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateQueue {
    _private: (),
}
impl CreateQueue {
    /// Creates a new builder-style object to manufacture [`CreateQueueInput`](crate::input::CreateQueueInput)
    pub fn builder() -> crate::input::create_queue_input::Builder {
        crate::input::create_queue_input::Builder::default()
    }
    /// Creates a new `CreateQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateQueue {
    type Output =
        std::result::Result<crate::output::CreateQueueOutput, crate::error::CreateQueueError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_queue_error(response)
        } else {
            crate::operation_deser::parse_create_queue_response(response)
        }
    }
}

/// Operation shape for `DeleteJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_job_template`](crate::client::Client::delete_job_template).
///
/// See [`crate::client::fluent_builders::DeleteJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteJobTemplate {
    _private: (),
}
impl DeleteJobTemplate {
    /// Creates a new builder-style object to manufacture [`DeleteJobTemplateInput`](crate::input::DeleteJobTemplateInput)
    pub fn builder() -> crate::input::delete_job_template_input::Builder {
        crate::input::delete_job_template_input::Builder::default()
    }
    /// Creates a new `DeleteJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteJobTemplate {
    type Output = std::result::Result<
        crate::output::DeleteJobTemplateOutput,
        crate::error::DeleteJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_job_template_error(response)
        } else {
            crate::operation_deser::parse_delete_job_template_response(response)
        }
    }
}

/// Operation shape for `DeletePolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_policy`](crate::client::Client::delete_policy).
///
/// See [`crate::client::fluent_builders::DeletePolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePolicy {
    _private: (),
}
impl DeletePolicy {
    /// Creates a new builder-style object to manufacture [`DeletePolicyInput`](crate::input::DeletePolicyInput)
    pub fn builder() -> crate::input::delete_policy_input::Builder {
        crate::input::delete_policy_input::Builder::default()
    }
    /// Creates a new `DeletePolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePolicy {
    type Output =
        std::result::Result<crate::output::DeletePolicyOutput, crate::error::DeletePolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_policy_error(response)
        } else {
            crate::operation_deser::parse_delete_policy_response(response)
        }
    }
}

/// Operation shape for `DeletePreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_preset`](crate::client::Client::delete_preset).
///
/// See [`crate::client::fluent_builders::DeletePreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeletePreset {
    _private: (),
}
impl DeletePreset {
    /// Creates a new builder-style object to manufacture [`DeletePresetInput`](crate::input::DeletePresetInput)
    pub fn builder() -> crate::input::delete_preset_input::Builder {
        crate::input::delete_preset_input::Builder::default()
    }
    /// Creates a new `DeletePreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeletePreset {
    type Output =
        std::result::Result<crate::output::DeletePresetOutput, crate::error::DeletePresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_preset_error(response)
        } else {
            crate::operation_deser::parse_delete_preset_response(response)
        }
    }
}

/// Operation shape for `DeleteQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_queue`](crate::client::Client::delete_queue).
///
/// See [`crate::client::fluent_builders::DeleteQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteQueue {
    _private: (),
}
impl DeleteQueue {
    /// Creates a new builder-style object to manufacture [`DeleteQueueInput`](crate::input::DeleteQueueInput)
    pub fn builder() -> crate::input::delete_queue_input::Builder {
        crate::input::delete_queue_input::Builder::default()
    }
    /// Creates a new `DeleteQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteQueue {
    type Output =
        std::result::Result<crate::output::DeleteQueueOutput, crate::error::DeleteQueueError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_queue_error(response)
        } else {
            crate::operation_deser::parse_delete_queue_response(response)
        }
    }
}

/// Operation shape for `DescribeEndpoints`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_endpoints`](crate::client::Client::describe_endpoints).
///
/// See [`crate::client::fluent_builders::DescribeEndpoints`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEndpoints {
    _private: (),
}
impl DescribeEndpoints {
    /// Creates a new builder-style object to manufacture [`DescribeEndpointsInput`](crate::input::DescribeEndpointsInput)
    pub fn builder() -> crate::input::describe_endpoints_input::Builder {
        crate::input::describe_endpoints_input::Builder::default()
    }
    /// Creates a new `DescribeEndpoints` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEndpoints {
    type Output = std::result::Result<
        crate::output::DescribeEndpointsOutput,
        crate::error::DescribeEndpointsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_endpoints_error(response)
        } else {
            crate::operation_deser::parse_describe_endpoints_response(response)
        }
    }
}

/// Operation shape for `DisassociateCertificate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_certificate`](crate::client::Client::disassociate_certificate).
///
/// See [`crate::client::fluent_builders::DisassociateCertificate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateCertificate {
    _private: (),
}
impl DisassociateCertificate {
    /// Creates a new builder-style object to manufacture [`DisassociateCertificateInput`](crate::input::DisassociateCertificateInput)
    pub fn builder() -> crate::input::disassociate_certificate_input::Builder {
        crate::input::disassociate_certificate_input::Builder::default()
    }
    /// Creates a new `DisassociateCertificate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateCertificate {
    type Output = std::result::Result<
        crate::output::DisassociateCertificateOutput,
        crate::error::DisassociateCertificateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_disassociate_certificate_error(response)
        } else {
            crate::operation_deser::parse_disassociate_certificate_response(response)
        }
    }
}

/// Operation shape for `GetJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job`](crate::client::Client::get_job).
///
/// See [`crate::client::fluent_builders::GetJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJob {
    _private: (),
}
impl GetJob {
    /// Creates a new builder-style object to manufacture [`GetJobInput`](crate::input::GetJobInput)
    pub fn builder() -> crate::input::get_job_input::Builder {
        crate::input::get_job_input::Builder::default()
    }
    /// Creates a new `GetJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJob {
    type Output = std::result::Result<crate::output::GetJobOutput, crate::error::GetJobError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_error(response)
        } else {
            crate::operation_deser::parse_get_job_response(response)
        }
    }
}

/// Operation shape for `GetJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_job_template`](crate::client::Client::get_job_template).
///
/// See [`crate::client::fluent_builders::GetJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetJobTemplate {
    _private: (),
}
impl GetJobTemplate {
    /// Creates a new builder-style object to manufacture [`GetJobTemplateInput`](crate::input::GetJobTemplateInput)
    pub fn builder() -> crate::input::get_job_template_input::Builder {
        crate::input::get_job_template_input::Builder::default()
    }
    /// Creates a new `GetJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetJobTemplate {
    type Output =
        std::result::Result<crate::output::GetJobTemplateOutput, crate::error::GetJobTemplateError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_job_template_error(response)
        } else {
            crate::operation_deser::parse_get_job_template_response(response)
        }
    }
}

/// Operation shape for `GetPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_policy`](crate::client::Client::get_policy).
///
/// See [`crate::client::fluent_builders::GetPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPolicy {
    _private: (),
}
impl GetPolicy {
    /// Creates a new builder-style object to manufacture [`GetPolicyInput`](crate::input::GetPolicyInput)
    pub fn builder() -> crate::input::get_policy_input::Builder {
        crate::input::get_policy_input::Builder::default()
    }
    /// Creates a new `GetPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPolicy {
    type Output = std::result::Result<crate::output::GetPolicyOutput, crate::error::GetPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_policy_error(response)
        } else {
            crate::operation_deser::parse_get_policy_response(response)
        }
    }
}

/// Operation shape for `GetPreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_preset`](crate::client::Client::get_preset).
///
/// See [`crate::client::fluent_builders::GetPreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetPreset {
    _private: (),
}
impl GetPreset {
    /// Creates a new builder-style object to manufacture [`GetPresetInput`](crate::input::GetPresetInput)
    pub fn builder() -> crate::input::get_preset_input::Builder {
        crate::input::get_preset_input::Builder::default()
    }
    /// Creates a new `GetPreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetPreset {
    type Output = std::result::Result<crate::output::GetPresetOutput, crate::error::GetPresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_preset_error(response)
        } else {
            crate::operation_deser::parse_get_preset_response(response)
        }
    }
}

/// Operation shape for `GetQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_queue`](crate::client::Client::get_queue).
///
/// See [`crate::client::fluent_builders::GetQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetQueue {
    _private: (),
}
impl GetQueue {
    /// Creates a new builder-style object to manufacture [`GetQueueInput`](crate::input::GetQueueInput)
    pub fn builder() -> crate::input::get_queue_input::Builder {
        crate::input::get_queue_input::Builder::default()
    }
    /// Creates a new `GetQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetQueue {
    type Output = std::result::Result<crate::output::GetQueueOutput, crate::error::GetQueueError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_queue_error(response)
        } else {
            crate::operation_deser::parse_get_queue_response(response)
        }
    }
}

/// Operation shape for `ListJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_jobs`](crate::client::Client::list_jobs).
///
/// See [`crate::client::fluent_builders::ListJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobs {
    _private: (),
}
impl ListJobs {
    /// Creates a new builder-style object to manufacture [`ListJobsInput`](crate::input::ListJobsInput)
    pub fn builder() -> crate::input::list_jobs_input::Builder {
        crate::input::list_jobs_input::Builder::default()
    }
    /// Creates a new `ListJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobs {
    type Output = std::result::Result<crate::output::ListJobsOutput, crate::error::ListJobsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_jobs_response(response)
        }
    }
}

/// Operation shape for `ListJobTemplates`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_job_templates`](crate::client::Client::list_job_templates).
///
/// See [`crate::client::fluent_builders::ListJobTemplates`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListJobTemplates {
    _private: (),
}
impl ListJobTemplates {
    /// Creates a new builder-style object to manufacture [`ListJobTemplatesInput`](crate::input::ListJobTemplatesInput)
    pub fn builder() -> crate::input::list_job_templates_input::Builder {
        crate::input::list_job_templates_input::Builder::default()
    }
    /// Creates a new `ListJobTemplates` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListJobTemplates {
    type Output = std::result::Result<
        crate::output::ListJobTemplatesOutput,
        crate::error::ListJobTemplatesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_job_templates_error(response)
        } else {
            crate::operation_deser::parse_list_job_templates_response(response)
        }
    }
}

/// Operation shape for `ListPresets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_presets`](crate::client::Client::list_presets).
///
/// See [`crate::client::fluent_builders::ListPresets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListPresets {
    _private: (),
}
impl ListPresets {
    /// Creates a new builder-style object to manufacture [`ListPresetsInput`](crate::input::ListPresetsInput)
    pub fn builder() -> crate::input::list_presets_input::Builder {
        crate::input::list_presets_input::Builder::default()
    }
    /// Creates a new `ListPresets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListPresets {
    type Output =
        std::result::Result<crate::output::ListPresetsOutput, crate::error::ListPresetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_presets_error(response)
        } else {
            crate::operation_deser::parse_list_presets_response(response)
        }
    }
}

/// Operation shape for `ListQueues`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_queues`](crate::client::Client::list_queues).
///
/// See [`crate::client::fluent_builders::ListQueues`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListQueues {
    _private: (),
}
impl ListQueues {
    /// Creates a new builder-style object to manufacture [`ListQueuesInput`](crate::input::ListQueuesInput)
    pub fn builder() -> crate::input::list_queues_input::Builder {
        crate::input::list_queues_input::Builder::default()
    }
    /// Creates a new `ListQueues` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListQueues {
    type Output =
        std::result::Result<crate::output::ListQueuesOutput, crate::error::ListQueuesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_queues_error(response)
        } else {
            crate::operation_deser::parse_list_queues_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutPolicy`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_policy`](crate::client::Client::put_policy).
///
/// See [`crate::client::fluent_builders::PutPolicy`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutPolicy {
    _private: (),
}
impl PutPolicy {
    /// Creates a new builder-style object to manufacture [`PutPolicyInput`](crate::input::PutPolicyInput)
    pub fn builder() -> crate::input::put_policy_input::Builder {
        crate::input::put_policy_input::Builder::default()
    }
    /// Creates a new `PutPolicy` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutPolicy {
    type Output = std::result::Result<crate::output::PutPolicyOutput, crate::error::PutPolicyError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_policy_error(response)
        } else {
            crate::operation_deser::parse_put_policy_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateJobTemplate`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_job_template`](crate::client::Client::update_job_template).
///
/// See [`crate::client::fluent_builders::UpdateJobTemplate`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateJobTemplate {
    _private: (),
}
impl UpdateJobTemplate {
    /// Creates a new builder-style object to manufacture [`UpdateJobTemplateInput`](crate::input::UpdateJobTemplateInput)
    pub fn builder() -> crate::input::update_job_template_input::Builder {
        crate::input::update_job_template_input::Builder::default()
    }
    /// Creates a new `UpdateJobTemplate` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateJobTemplate {
    type Output = std::result::Result<
        crate::output::UpdateJobTemplateOutput,
        crate::error::UpdateJobTemplateError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_job_template_error(response)
        } else {
            crate::operation_deser::parse_update_job_template_response(response)
        }
    }
}

/// Operation shape for `UpdatePreset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_preset`](crate::client::Client::update_preset).
///
/// See [`crate::client::fluent_builders::UpdatePreset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdatePreset {
    _private: (),
}
impl UpdatePreset {
    /// Creates a new builder-style object to manufacture [`UpdatePresetInput`](crate::input::UpdatePresetInput)
    pub fn builder() -> crate::input::update_preset_input::Builder {
        crate::input::update_preset_input::Builder::default()
    }
    /// Creates a new `UpdatePreset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdatePreset {
    type Output =
        std::result::Result<crate::output::UpdatePresetOutput, crate::error::UpdatePresetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_preset_error(response)
        } else {
            crate::operation_deser::parse_update_preset_response(response)
        }
    }
}

/// Operation shape for `UpdateQueue`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_queue`](crate::client::Client::update_queue).
///
/// See [`crate::client::fluent_builders::UpdateQueue`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateQueue {
    _private: (),
}
impl UpdateQueue {
    /// Creates a new builder-style object to manufacture [`UpdateQueueInput`](crate::input::UpdateQueueInput)
    pub fn builder() -> crate::input::update_queue_input::Builder {
        crate::input::update_queue_input::Builder::default()
    }
    /// Creates a new `UpdateQueue` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateQueue {
    type Output =
        std::result::Result<crate::output::UpdateQueueOutput, crate::error::UpdateQueueError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_queue_error(response)
        } else {
            crate::operation_deser::parse_update_queue_response(response)
        }
    }
}
