// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// You can use queues to manage the resources that are available to your AWS account for running multiple transcoding jobs at the same time. If you don't specify a queue, the service sends all jobs through the default queue. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Queue {
    /// An identifier for this resource that is unique within all of AWS.
    pub arn: std::option::Option<std::string::String>,
    /// The timestamp in epoch seconds for when you created the queue.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// An optional description that you create for each queue.
    pub description: std::option::Option<std::string::String>,
    /// The timestamp in epoch seconds for when you most recently updated the queue.
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// A name that you create for each queue. Each name must be unique within your account.
    pub name: std::option::Option<std::string::String>,
    /// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
    pub pricing_plan: std::option::Option<crate::model::PricingPlan>,
    /// The estimated number of jobs with a PROGRESSING status.
    pub progressing_jobs_count: i32,
    /// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
    pub reservation_plan: std::option::Option<crate::model::ReservationPlan>,
    /// Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
    pub status: std::option::Option<crate::model::QueueStatus>,
    /// The estimated number of jobs with a SUBMITTED status.
    pub submitted_jobs_count: i32,
    /// Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
    pub r#type: std::option::Option<crate::model::Type>,
}
impl Queue {
    /// An identifier for this resource that is unique within all of AWS.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// The timestamp in epoch seconds for when you created the queue.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// An optional description that you create for each queue.
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// The timestamp in epoch seconds for when you most recently updated the queue.
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated.as_ref()
    }
    /// A name that you create for each queue. Each name must be unique within your account.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
    pub fn pricing_plan(&self) -> std::option::Option<&crate::model::PricingPlan> {
        self.pricing_plan.as_ref()
    }
    /// The estimated number of jobs with a PROGRESSING status.
    pub fn progressing_jobs_count(&self) -> i32 {
        self.progressing_jobs_count
    }
    /// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
    pub fn reservation_plan(&self) -> std::option::Option<&crate::model::ReservationPlan> {
        self.reservation_plan.as_ref()
    }
    /// Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
    pub fn status(&self) -> std::option::Option<&crate::model::QueueStatus> {
        self.status.as_ref()
    }
    /// The estimated number of jobs with a SUBMITTED status.
    pub fn submitted_jobs_count(&self) -> i32 {
        self.submitted_jobs_count
    }
    /// Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Queue {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Queue");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("name", &self.name);
        formatter.field("pricing_plan", &self.pricing_plan);
        formatter.field("progressing_jobs_count", &self.progressing_jobs_count);
        formatter.field("reservation_plan", &self.reservation_plan);
        formatter.field("status", &self.status);
        formatter.field("submitted_jobs_count", &self.submitted_jobs_count);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Queue`](crate::model::Queue)
pub mod queue {
    /// A builder for [`Queue`](crate::model::Queue)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) pricing_plan: std::option::Option<crate::model::PricingPlan>,
        pub(crate) progressing_jobs_count: std::option::Option<i32>,
        pub(crate) reservation_plan: std::option::Option<crate::model::ReservationPlan>,
        pub(crate) status: std::option::Option<crate::model::QueueStatus>,
        pub(crate) submitted_jobs_count: std::option::Option<i32>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// An identifier for this resource that is unique within all of AWS.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// An identifier for this resource that is unique within all of AWS.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// The timestamp in epoch seconds for when you created the queue.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The timestamp in epoch seconds for when you created the queue.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// An optional description that you create for each queue.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// An optional description that you create for each queue.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The timestamp in epoch seconds for when you most recently updated the queue.
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// The timestamp in epoch seconds for when you most recently updated the queue.
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// A name that you create for each queue. Each name must be unique within your account.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// A name that you create for each queue. Each name must be unique within your account.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
        pub fn pricing_plan(mut self, input: crate::model::PricingPlan) -> Self {
            self.pricing_plan = Some(input);
            self
        }
        /// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.pricing_plan = input;
            self
        }
        /// The estimated number of jobs with a PROGRESSING status.
        pub fn progressing_jobs_count(mut self, input: i32) -> Self {
            self.progressing_jobs_count = Some(input);
            self
        }
        /// The estimated number of jobs with a PROGRESSING status.
        pub fn set_progressing_jobs_count(mut self, input: std::option::Option<i32>) -> Self {
            self.progressing_jobs_count = input;
            self
        }
        /// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
        pub fn reservation_plan(mut self, input: crate::model::ReservationPlan) -> Self {
            self.reservation_plan = Some(input);
            self
        }
        /// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
        pub fn set_reservation_plan(
            mut self,
            input: std::option::Option<crate::model::ReservationPlan>,
        ) -> Self {
            self.reservation_plan = input;
            self
        }
        /// Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
        pub fn status(mut self, input: crate::model::QueueStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// Queues can be ACTIVE or PAUSED. If you pause a queue, the service won't begin processing jobs in that queue. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueueStatus>) -> Self {
            self.status = input;
            self
        }
        /// The estimated number of jobs with a SUBMITTED status.
        pub fn submitted_jobs_count(mut self, input: i32) -> Self {
            self.submitted_jobs_count = Some(input);
            self
        }
        /// The estimated number of jobs with a SUBMITTED status.
        pub fn set_submitted_jobs_count(mut self, input: std::option::Option<i32>) -> Self {
            self.submitted_jobs_count = input;
            self
        }
        /// Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// Specifies whether this on-demand queue is system or custom. System queues are built in. You can't modify or delete system queues. You can create and modify custom queues.
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Queue`](crate::model::Queue)
        pub fn build(self) -> crate::model::Queue {
            crate::model::Queue {
                arn: self.arn,
                created_at: self.created_at,
                description: self.description,
                last_updated: self.last_updated,
                name: self.name,
                pricing_plan: self.pricing_plan,
                progressing_jobs_count: self.progressing_jobs_count.unwrap_or_default(),
                reservation_plan: self.reservation_plan,
                status: self.status,
                submitted_jobs_count: self.submitted_jobs_count.unwrap_or_default(),
                r#type: self.r#type,
            }
        }
    }
}
impl Queue {
    /// Creates a new builder-style object to manufacture [`Queue`](crate::model::Queue)
    pub fn builder() -> crate::model::queue::Builder {
        crate::model::queue::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    Custom,
    #[allow(missing_docs)] // documentation missing in model
    System,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOM" => Type::Custom,
            "SYSTEM" => Type::System,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::Custom => "CUSTOM",
            Type::System => "SYSTEM",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOM", "SYSTEM"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Queues can be ACTIVE or PAUSED. If you pause a queue, jobs in that queue won't begin. Jobs that are running when you pause a queue continue to run until they finish or result in an error.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum QueueStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for QueueStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => QueueStatus::Active,
            "PAUSED" => QueueStatus::Paused,
            other => QueueStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for QueueStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(QueueStatus::from(s))
    }
}
impl QueueStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            QueueStatus::Active => "ACTIVE",
            QueueStatus::Paused => "PAUSED",
            QueueStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "PAUSED"]
    }
}
impl AsRef<str> for QueueStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationPlan {
    /// The length of the term of your reserved queue pricing plan commitment.
    pub commitment: std::option::Option<crate::model::Commitment>,
    /// The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.
    pub expires_at: std::option::Option<aws_smithy_types::Instant>,
    /// The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.
    pub purchased_at: std::option::Option<aws_smithy_types::Instant>,
    /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
    pub renewal_type: std::option::Option<crate::model::RenewalType>,
    /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can't decrease the number of RTS in your reserved queue.
    pub reserved_slots: i32,
    /// Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
    pub status: std::option::Option<crate::model::ReservationPlanStatus>,
}
impl ReservationPlan {
    /// The length of the term of your reserved queue pricing plan commitment.
    pub fn commitment(&self) -> std::option::Option<&crate::model::Commitment> {
        self.commitment.as_ref()
    }
    /// The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.
    pub fn expires_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.expires_at.as_ref()
    }
    /// The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.
    pub fn purchased_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.purchased_at.as_ref()
    }
    /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
    pub fn renewal_type(&self) -> std::option::Option<&crate::model::RenewalType> {
        self.renewal_type.as_ref()
    }
    /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can't decrease the number of RTS in your reserved queue.
    pub fn reserved_slots(&self) -> i32 {
        self.reserved_slots
    }
    /// Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
    pub fn status(&self) -> std::option::Option<&crate::model::ReservationPlanStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ReservationPlan {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationPlan");
        formatter.field("commitment", &self.commitment);
        formatter.field("expires_at", &self.expires_at);
        formatter.field("purchased_at", &self.purchased_at);
        formatter.field("renewal_type", &self.renewal_type);
        formatter.field("reserved_slots", &self.reserved_slots);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ReservationPlan`](crate::model::ReservationPlan)
pub mod reservation_plan {
    /// A builder for [`ReservationPlan`](crate::model::ReservationPlan)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commitment: std::option::Option<crate::model::Commitment>,
        pub(crate) expires_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) purchased_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) renewal_type: std::option::Option<crate::model::RenewalType>,
        pub(crate) reserved_slots: std::option::Option<i32>,
        pub(crate) status: std::option::Option<crate::model::ReservationPlanStatus>,
    }
    impl Builder {
        /// The length of the term of your reserved queue pricing plan commitment.
        pub fn commitment(mut self, input: crate::model::Commitment) -> Self {
            self.commitment = Some(input);
            self
        }
        /// The length of the term of your reserved queue pricing plan commitment.
        pub fn set_commitment(
            mut self,
            input: std::option::Option<crate::model::Commitment>,
        ) -> Self {
            self.commitment = input;
            self
        }
        /// The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.
        pub fn expires_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expires_at = Some(input);
            self
        }
        /// The timestamp in epoch seconds for when the current pricing plan term for this reserved queue expires.
        pub fn set_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expires_at = input;
            self
        }
        /// The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.
        pub fn purchased_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.purchased_at = Some(input);
            self
        }
        /// The timestamp in epoch seconds for when you set up the current pricing plan for this reserved queue.
        pub fn set_purchased_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.purchased_at = input;
            self
        }
        /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
        pub fn renewal_type(mut self, input: crate::model::RenewalType) -> Self {
            self.renewal_type = Some(input);
            self
        }
        /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
        pub fn set_renewal_type(
            mut self,
            input: std::option::Option<crate::model::RenewalType>,
        ) -> Self {
            self.renewal_type = input;
            self
        }
        /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can't decrease the number of RTS in your reserved queue.
        pub fn reserved_slots(mut self, input: i32) -> Self {
            self.reserved_slots = Some(input);
            self
        }
        /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. When you increase this number, you extend your existing commitment with a new 12-month commitment for a larger number of RTS. The new commitment begins when you purchase the additional capacity. You can't decrease the number of RTS in your reserved queue.
        pub fn set_reserved_slots(mut self, input: std::option::Option<i32>) -> Self {
            self.reserved_slots = input;
            self
        }
        /// Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
        pub fn status(mut self, input: crate::model::ReservationPlanStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ReservationPlanStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationPlan`](crate::model::ReservationPlan)
        pub fn build(self) -> crate::model::ReservationPlan {
            crate::model::ReservationPlan {
                commitment: self.commitment,
                expires_at: self.expires_at,
                purchased_at: self.purchased_at,
                renewal_type: self.renewal_type,
                reserved_slots: self.reserved_slots.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl ReservationPlan {
    /// Creates a new builder-style object to manufacture [`ReservationPlan`](crate::model::ReservationPlan)
    pub fn builder() -> crate::model::reservation_plan::Builder {
        crate::model::reservation_plan::Builder::default()
    }
}

/// Specifies whether the pricing plan for your reserved queue is ACTIVE or EXPIRED.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationPlanStatus {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationPlanStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReservationPlanStatus::Active,
            "EXPIRED" => ReservationPlanStatus::Expired,
            other => ReservationPlanStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationPlanStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationPlanStatus::from(s))
    }
}
impl ReservationPlanStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationPlanStatus::Active => "ACTIVE",
            ReservationPlanStatus::Expired => "EXPIRED",
            ReservationPlanStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "EXPIRED"]
    }
}
impl AsRef<str> for ReservationPlanStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RenewalType {
    #[allow(missing_docs)] // documentation missing in model
    AutoRenew,
    #[allow(missing_docs)] // documentation missing in model
    Expire,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RenewalType {
    fn from(s: &str) -> Self {
        match s {
            "AUTO_RENEW" => RenewalType::AutoRenew,
            "EXPIRE" => RenewalType::Expire,
            other => RenewalType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RenewalType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RenewalType::from(s))
    }
}
impl RenewalType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RenewalType::AutoRenew => "AUTO_RENEW",
            RenewalType::Expire => "EXPIRE",
            RenewalType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO_RENEW", "EXPIRE"]
    }
}
impl AsRef<str> for RenewalType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The length of the term of your reserved queue pricing plan commitment.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Commitment {
    #[allow(missing_docs)] // documentation missing in model
    OneYear,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Commitment {
    fn from(s: &str) -> Self {
        match s {
            "ONE_YEAR" => Commitment::OneYear,
            other => Commitment::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Commitment {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Commitment::from(s))
    }
}
impl Commitment {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Commitment::OneYear => "ONE_YEAR",
            Commitment::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONE_YEAR"]
    }
}
impl AsRef<str> for Commitment {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PricingPlan {
    #[allow(missing_docs)] // documentation missing in model
    OnDemand,
    #[allow(missing_docs)] // documentation missing in model
    Reserved,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PricingPlan {
    fn from(s: &str) -> Self {
        match s {
            "ON_DEMAND" => PricingPlan::OnDemand,
            "RESERVED" => PricingPlan::Reserved,
            other => PricingPlan::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PricingPlan {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PricingPlan::from(s))
    }
}
impl PricingPlan {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PricingPlan::OnDemand => "ON_DEMAND",
            PricingPlan::Reserved => "RESERVED",
            PricingPlan::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ON_DEMAND", "RESERVED"]
    }
}
impl AsRef<str> for PricingPlan {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReservationPlanSettings {
    /// The length of the term of your reserved queue pricing plan commitment.
    pub commitment: std::option::Option<crate::model::Commitment>,
    /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.
    pub renewal_type: std::option::Option<crate::model::RenewalType>,
    /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can't cancel your commitment or revert to your original commitment after you increase the capacity.
    pub reserved_slots: i32,
}
impl ReservationPlanSettings {
    /// The length of the term of your reserved queue pricing plan commitment.
    pub fn commitment(&self) -> std::option::Option<&crate::model::Commitment> {
        self.commitment.as_ref()
    }
    /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.
    pub fn renewal_type(&self) -> std::option::Option<&crate::model::RenewalType> {
        self.renewal_type.as_ref()
    }
    /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can't cancel your commitment or revert to your original commitment after you increase the capacity.
    pub fn reserved_slots(&self) -> i32 {
        self.reserved_slots
    }
}
impl std::fmt::Debug for ReservationPlanSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReservationPlanSettings");
        formatter.field("commitment", &self.commitment);
        formatter.field("renewal_type", &self.renewal_type);
        formatter.field("reserved_slots", &self.reserved_slots);
        formatter.finish()
    }
}
/// See [`ReservationPlanSettings`](crate::model::ReservationPlanSettings)
pub mod reservation_plan_settings {
    /// A builder for [`ReservationPlanSettings`](crate::model::ReservationPlanSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) commitment: std::option::Option<crate::model::Commitment>,
        pub(crate) renewal_type: std::option::Option<crate::model::RenewalType>,
        pub(crate) reserved_slots: std::option::Option<i32>,
    }
    impl Builder {
        /// The length of the term of your reserved queue pricing plan commitment.
        pub fn commitment(mut self, input: crate::model::Commitment) -> Self {
            self.commitment = Some(input);
            self
        }
        /// The length of the term of your reserved queue pricing plan commitment.
        pub fn set_commitment(
            mut self,
            input: std::option::Option<crate::model::Commitment>,
        ) -> Self {
            self.commitment = input;
            self
        }
        /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.
        pub fn renewal_type(mut self, input: crate::model::RenewalType) -> Self {
            self.renewal_type = Some(input);
            self
        }
        /// Specifies whether the term of your reserved queue pricing plan is automatically extended (AUTO_RENEW) or expires (EXPIRE) at the end of the term. When your term is auto renewed, you extend your commitment by 12 months from the auto renew date. You can cancel this commitment.
        pub fn set_renewal_type(
            mut self,
            input: std::option::Option<crate::model::RenewalType>,
        ) -> Self {
            self.renewal_type = input;
            self
        }
        /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can't cancel your commitment or revert to your original commitment after you increase the capacity.
        pub fn reserved_slots(mut self, input: i32) -> Self {
            self.reserved_slots = Some(input);
            self
        }
        /// Specifies the number of reserved transcode slots (RTS) for this queue. The number of RTS determines how many jobs the queue can process in parallel; each RTS can process one job at a time. You can't decrease the number of RTS in your reserved queue. You can increase the number of RTS by extending your existing commitment with a new 12-month commitment for the larger number. The new commitment begins when you purchase the additional capacity. You can't cancel your commitment or revert to your original commitment after you increase the capacity.
        pub fn set_reserved_slots(mut self, input: std::option::Option<i32>) -> Self {
            self.reserved_slots = input;
            self
        }
        /// Consumes the builder and constructs a [`ReservationPlanSettings`](crate::model::ReservationPlanSettings)
        pub fn build(self) -> crate::model::ReservationPlanSettings {
            crate::model::ReservationPlanSettings {
                commitment: self.commitment,
                renewal_type: self.renewal_type,
                reserved_slots: self.reserved_slots.unwrap_or_default(),
            }
        }
    }
}
impl ReservationPlanSettings {
    /// Creates a new builder-style object to manufacture [`ReservationPlanSettings`](crate::model::ReservationPlanSettings)
    pub fn builder() -> crate::model::reservation_plan_settings::Builder {
        crate::model::reservation_plan_settings::Builder::default()
    }
}

/// A preset is a collection of preconfigured media conversion settings that you want MediaConvert to apply to the output during the conversion process.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Preset {
    /// An identifier for this resource that is unique within all of AWS.
    pub arn: std::option::Option<std::string::String>,
    /// An optional category you create to organize your presets.
    pub category: std::option::Option<std::string::String>,
    /// The timestamp in epoch seconds for preset creation.
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// An optional description you create for each preset.
    pub description: std::option::Option<std::string::String>,
    /// The timestamp in epoch seconds when the preset was last updated.
    pub last_updated: std::option::Option<aws_smithy_types::Instant>,
    /// A name you create for each preset. Each name must be unique within your account.
    pub name: std::option::Option<std::string::String>,
    /// Settings for preset
    pub settings: std::option::Option<crate::model::PresetSettings>,
    /// A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the user.
    pub r#type: std::option::Option<crate::model::Type>,
}
impl Preset {
    /// An identifier for this resource that is unique within all of AWS.
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// An optional category you create to organize your presets.
    pub fn category(&self) -> std::option::Option<&str> {
        self.category.as_deref()
    }
    /// The timestamp in epoch seconds for preset creation.
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// An optional description you create for each preset.
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// The timestamp in epoch seconds when the preset was last updated.
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated.as_ref()
    }
    /// A name you create for each preset. Each name must be unique within your account.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// Settings for preset
    pub fn settings(&self) -> std::option::Option<&crate::model::PresetSettings> {
        self.settings.as_ref()
    }
    /// A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the user.
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for Preset {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Preset");
        formatter.field("arn", &self.arn);
        formatter.field("category", &self.category);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("name", &self.name);
        formatter.field("settings", &self.settings);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`Preset`](crate::model::Preset)
pub mod preset {
    /// A builder for [`Preset`](crate::model::Preset)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) category: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) settings: std::option::Option<crate::model::PresetSettings>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// An identifier for this resource that is unique within all of AWS.
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// An identifier for this resource that is unique within all of AWS.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// An optional category you create to organize your presets.
        pub fn category(mut self, input: impl Into<std::string::String>) -> Self {
            self.category = Some(input.into());
            self
        }
        /// An optional category you create to organize your presets.
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.category = input;
            self
        }
        /// The timestamp in epoch seconds for preset creation.
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// The timestamp in epoch seconds for preset creation.
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// An optional description you create for each preset.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// An optional description you create for each preset.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The timestamp in epoch seconds when the preset was last updated.
        pub fn last_updated(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// The timestamp in epoch seconds when the preset was last updated.
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// A name you create for each preset. Each name must be unique within your account.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// A name you create for each preset. Each name must be unique within your account.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Settings for preset
        pub fn settings(mut self, input: crate::model::PresetSettings) -> Self {
            self.settings = Some(input);
            self
        }
        /// Settings for preset
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::PresetSettings>,
        ) -> Self {
            self.settings = input;
            self
        }
        /// A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the user.
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// A preset can be of two types: system or custom. System or built-in preset can't be modified or deleted by the user.
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`Preset`](crate::model::Preset)
        pub fn build(self) -> crate::model::Preset {
            crate::model::Preset {
                arn: self.arn,
                category: self.category,
                created_at: self.created_at,
                description: self.description,
                last_updated: self.last_updated,
                name: self.name,
                settings: self.settings,
                r#type: self.r#type,
            }
        }
    }
}
impl Preset {
    /// Creates a new builder-style object to manufacture [`Preset`](crate::model::Preset)
    pub fn builder() -> crate::model::preset::Builder {
        crate::model::preset::Builder::default()
    }
}

/// Settings for preset
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PresetSettings {
    /// (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
    pub audio_descriptions: std::option::Option<std::vec::Vec<crate::model::AudioDescription>>,
    /// This object holds groups of settings related to captions for one output. For each output that has captions, include one instance of CaptionDescriptions.
    pub caption_descriptions:
        std::option::Option<std::vec::Vec<crate::model::CaptionDescriptionPreset>>,
    /// Container specific settings.
    pub container_settings: std::option::Option<crate::model::ContainerSettings>,
    /// VideoDescription contains a group of video encoding settings. The specific video settings depend on the video codec that you choose for the property codec. Include one instance of VideoDescription per output.
    pub video_description: std::option::Option<crate::model::VideoDescription>,
}
impl PresetSettings {
    /// (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
    pub fn audio_descriptions(&self) -> std::option::Option<&[crate::model::AudioDescription]> {
        self.audio_descriptions.as_deref()
    }
    /// This object holds groups of settings related to captions for one output. For each output that has captions, include one instance of CaptionDescriptions.
    pub fn caption_descriptions(
        &self,
    ) -> std::option::Option<&[crate::model::CaptionDescriptionPreset]> {
        self.caption_descriptions.as_deref()
    }
    /// Container specific settings.
    pub fn container_settings(&self) -> std::option::Option<&crate::model::ContainerSettings> {
        self.container_settings.as_ref()
    }
    /// VideoDescription contains a group of video encoding settings. The specific video settings depend on the video codec that you choose for the property codec. Include one instance of VideoDescription per output.
    pub fn video_description(&self) -> std::option::Option<&crate::model::VideoDescription> {
        self.video_description.as_ref()
    }
}
impl std::fmt::Debug for PresetSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PresetSettings");
        formatter.field("audio_descriptions", &self.audio_descriptions);
        formatter.field("caption_descriptions", &self.caption_descriptions);
        formatter.field("container_settings", &self.container_settings);
        formatter.field("video_description", &self.video_description);
        formatter.finish()
    }
}
/// See [`PresetSettings`](crate::model::PresetSettings)
pub mod preset_settings {
    /// A builder for [`PresetSettings`](crate::model::PresetSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) audio_descriptions:
            std::option::Option<std::vec::Vec<crate::model::AudioDescription>>,
        pub(crate) caption_descriptions:
            std::option::Option<std::vec::Vec<crate::model::CaptionDescriptionPreset>>,
        pub(crate) container_settings: std::option::Option<crate::model::ContainerSettings>,
        pub(crate) video_description: std::option::Option<crate::model::VideoDescription>,
    }
    impl Builder {
        /// Appends an item to `audio_descriptions`.
        ///
        /// To override the contents of this collection use [`set_audio_descriptions`](Self::set_audio_descriptions).
        ///
        /// (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
        pub fn audio_descriptions(
            mut self,
            input: impl Into<crate::model::AudioDescription>,
        ) -> Self {
            let mut v = self.audio_descriptions.unwrap_or_default();
            v.push(input.into());
            self.audio_descriptions = Some(v);
            self
        }
        /// (AudioDescriptions) contains groups of audio encoding settings organized by audio codec. Include one instance of (AudioDescriptions) per output. (AudioDescriptions) can contain multiple groups of encoding settings.
        pub fn set_audio_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AudioDescription>>,
        ) -> Self {
            self.audio_descriptions = input;
            self
        }
        /// Appends an item to `caption_descriptions`.
        ///
        /// To override the contents of this collection use [`set_caption_descriptions`](Self::set_caption_descriptions).
        ///
        /// This object holds groups of settings related to captions for one output. For each output that has captions, include one instance of CaptionDescriptions.
        pub fn caption_descriptions(
            mut self,
            input: impl Into<crate::model::CaptionDescriptionPreset>,
        ) -> Self {
            let mut v = self.caption_descriptions.unwrap_or_default();
            v.push(input.into());
            self.caption_descriptions = Some(v);
            self
        }
        /// This object holds groups of settings related to captions for one output. For each output that has captions, include one instance of CaptionDescriptions.
        pub fn set_caption_descriptions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CaptionDescriptionPreset>>,
        ) -> Self {
            self.caption_descriptions = input;
            self
        }
        /// Container specific settings.
        pub fn container_settings(mut self, input: crate::model::ContainerSettings) -> Self {
            self.container_settings = Some(input);
            self
        }
        /// Container specific settings.
        pub fn set_container_settings(
            mut self,
            input: std::option::Option<crate::model::ContainerSettings>,
        ) -> Self {
            self.container_settings = input;
            self
        }
        /// VideoDescription contains a group of video encoding settings. The specific video settings depend on the video codec that you choose for the property codec. Include one instance of VideoDescription per output.
        pub fn video_description(mut self, input: crate::model::VideoDescription) -> Self {
            self.video_description = Some(input);
            self
        }
        /// VideoDescription contains a group of video encoding settings. The specific video settings depend on the video codec that you choose for the property codec. Include one instance of VideoDescription per output.
        pub fn set_video_description(
            mut self,
            input: std::option::Option<crate::model::VideoDescription>,
        ) -> Self {
            self.video_description = input;
            self
        }
        /// Consumes the builder and constructs a [`PresetSettings`](crate::model::PresetSettings)
        pub fn build(self) -> crate::model::PresetSettings {
            crate::model::PresetSettings {
                audio_descriptions: self.audio_descriptions,
                caption_descriptions: self.caption_descriptions,
                container_settings: self.container_settings,
                video_description: self.video_description,
            }
        }
    }
}
impl PresetSettings {
    /// Creates a new builder-style object to manufacture [`PresetSettings`](crate::model::PresetSettings)
    pub fn builder() -> crate::model::preset_settings::Builder {
        crate::model::preset_settings::Builder::default()
    }
}

/// Settings related to video encoding of your output. The specific video settings depend on the video codec that you choose. When you work directly in your JSON job specification, include one instance of Video description (VideoDescription) per output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoDescription {
    /// This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
    pub afd_signaling: std::option::Option<crate::model::AfdSignaling>,
    /// The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
    pub anti_alias: std::option::Option<crate::model::AntiAlias>,
    /// Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
    pub codec_settings: std::option::Option<crate::model::VideoCodecSettings>,
    /// Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
    pub color_metadata: std::option::Option<crate::model::ColorMetadata>,
    /// Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
    pub crop: std::option::Option<crate::model::Rectangle>,
    /// Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
    pub drop_frame_timecode: std::option::Option<crate::model::DropFrameTimecode>,
    /// Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all  frames of this video output.
    pub fixed_afd: i32,
    /// Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don't provide a value here, the service will use the input height.
    pub height: i32,
    /// Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.
    pub position: std::option::Option<crate::model::Rectangle>,
    /// Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
    pub respond_to_afd: std::option::Option<crate::model::RespondToAfd>,
    /// Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
    pub scaling_behavior: std::option::Option<crate::model::ScalingBehavior>,
    /// Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
    pub sharpness: i32,
    /// Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
    pub timecode_insertion: std::option::Option<crate::model::VideoTimecodeInsertion>,
    /// Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
    pub video_preprocessors: std::option::Option<crate::model::VideoPreprocessor>,
    /// Use Width (Width) to define the video resolution width, in pixels, for this output. If you don't provide a value here, the service will use the input width.
    pub width: i32,
}
impl VideoDescription {
    /// This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
    pub fn afd_signaling(&self) -> std::option::Option<&crate::model::AfdSignaling> {
        self.afd_signaling.as_ref()
    }
    /// The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
    pub fn anti_alias(&self) -> std::option::Option<&crate::model::AntiAlias> {
        self.anti_alias.as_ref()
    }
    /// Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
    pub fn codec_settings(&self) -> std::option::Option<&crate::model::VideoCodecSettings> {
        self.codec_settings.as_ref()
    }
    /// Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
    pub fn color_metadata(&self) -> std::option::Option<&crate::model::ColorMetadata> {
        self.color_metadata.as_ref()
    }
    /// Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
    pub fn crop(&self) -> std::option::Option<&crate::model::Rectangle> {
        self.crop.as_ref()
    }
    /// Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
    pub fn drop_frame_timecode(&self) -> std::option::Option<&crate::model::DropFrameTimecode> {
        self.drop_frame_timecode.as_ref()
    }
    /// Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all  frames of this video output.
    pub fn fixed_afd(&self) -> i32 {
        self.fixed_afd
    }
    /// Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don't provide a value here, the service will use the input height.
    pub fn height(&self) -> i32 {
        self.height
    }
    /// Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.
    pub fn position(&self) -> std::option::Option<&crate::model::Rectangle> {
        self.position.as_ref()
    }
    /// Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
    pub fn respond_to_afd(&self) -> std::option::Option<&crate::model::RespondToAfd> {
        self.respond_to_afd.as_ref()
    }
    /// Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
    pub fn scaling_behavior(&self) -> std::option::Option<&crate::model::ScalingBehavior> {
        self.scaling_behavior.as_ref()
    }
    /// Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
    pub fn sharpness(&self) -> i32 {
        self.sharpness
    }
    /// Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
    pub fn timecode_insertion(&self) -> std::option::Option<&crate::model::VideoTimecodeInsertion> {
        self.timecode_insertion.as_ref()
    }
    /// Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
    pub fn video_preprocessors(&self) -> std::option::Option<&crate::model::VideoPreprocessor> {
        self.video_preprocessors.as_ref()
    }
    /// Use Width (Width) to define the video resolution width, in pixels, for this output. If you don't provide a value here, the service will use the input width.
    pub fn width(&self) -> i32 {
        self.width
    }
}
impl std::fmt::Debug for VideoDescription {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoDescription");
        formatter.field("afd_signaling", &self.afd_signaling);
        formatter.field("anti_alias", &self.anti_alias);
        formatter.field("codec_settings", &self.codec_settings);
        formatter.field("color_metadata", &self.color_metadata);
        formatter.field("crop", &self.crop);
        formatter.field("drop_frame_timecode", &self.drop_frame_timecode);
        formatter.field("fixed_afd", &self.fixed_afd);
        formatter.field("height", &self.height);
        formatter.field("position", &self.position);
        formatter.field("respond_to_afd", &self.respond_to_afd);
        formatter.field("scaling_behavior", &self.scaling_behavior);
        formatter.field("sharpness", &self.sharpness);
        formatter.field("timecode_insertion", &self.timecode_insertion);
        formatter.field("video_preprocessors", &self.video_preprocessors);
        formatter.field("width", &self.width);
        formatter.finish()
    }
}
/// See [`VideoDescription`](crate::model::VideoDescription)
pub mod video_description {
    /// A builder for [`VideoDescription`](crate::model::VideoDescription)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) afd_signaling: std::option::Option<crate::model::AfdSignaling>,
        pub(crate) anti_alias: std::option::Option<crate::model::AntiAlias>,
        pub(crate) codec_settings: std::option::Option<crate::model::VideoCodecSettings>,
        pub(crate) color_metadata: std::option::Option<crate::model::ColorMetadata>,
        pub(crate) crop: std::option::Option<crate::model::Rectangle>,
        pub(crate) drop_frame_timecode: std::option::Option<crate::model::DropFrameTimecode>,
        pub(crate) fixed_afd: std::option::Option<i32>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) position: std::option::Option<crate::model::Rectangle>,
        pub(crate) respond_to_afd: std::option::Option<crate::model::RespondToAfd>,
        pub(crate) scaling_behavior: std::option::Option<crate::model::ScalingBehavior>,
        pub(crate) sharpness: std::option::Option<i32>,
        pub(crate) timecode_insertion: std::option::Option<crate::model::VideoTimecodeInsertion>,
        pub(crate) video_preprocessors: std::option::Option<crate::model::VideoPreprocessor>,
        pub(crate) width: std::option::Option<i32>,
    }
    impl Builder {
        /// This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
        pub fn afd_signaling(mut self, input: crate::model::AfdSignaling) -> Self {
            self.afd_signaling = Some(input);
            self
        }
        /// This setting only applies to H.264, H.265, and MPEG2 outputs. Use Insert AFD signaling (AfdSignaling) to specify whether the service includes AFD values in the output video data and what those values are. * Choose None to remove all AFD values from this output. * Choose Fixed to ignore input AFD values and instead encode the value specified in the job. * Choose Auto to calculate output AFD values based on the input AFD scaler data.
        pub fn set_afd_signaling(
            mut self,
            input: std::option::Option<crate::model::AfdSignaling>,
        ) -> Self {
            self.afd_signaling = input;
            self
        }
        /// The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
        pub fn anti_alias(mut self, input: crate::model::AntiAlias) -> Self {
            self.anti_alias = Some(input);
            self
        }
        /// The anti-alias filter is automatically applied to all outputs. The service no longer accepts the value DISABLED for AntiAlias. If you specify that in your job, the service will ignore the setting.
        pub fn set_anti_alias(
            mut self,
            input: std::option::Option<crate::model::AntiAlias>,
        ) -> Self {
            self.anti_alias = input;
            self
        }
        /// Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
        pub fn codec_settings(mut self, input: crate::model::VideoCodecSettings) -> Self {
            self.codec_settings = Some(input);
            self
        }
        /// Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
        pub fn set_codec_settings(
            mut self,
            input: std::option::Option<crate::model::VideoCodecSettings>,
        ) -> Self {
            self.codec_settings = input;
            self
        }
        /// Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
        pub fn color_metadata(mut self, input: crate::model::ColorMetadata) -> Self {
            self.color_metadata = Some(input);
            self
        }
        /// Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
        pub fn set_color_metadata(
            mut self,
            input: std::option::Option<crate::model::ColorMetadata>,
        ) -> Self {
            self.color_metadata = input;
            self
        }
        /// Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
        pub fn crop(mut self, input: crate::model::Rectangle) -> Self {
            self.crop = Some(input);
            self
        }
        /// Use Cropping selection (crop) to specify the video area that the service will include in the output video frame.
        pub fn set_crop(mut self, input: std::option::Option<crate::model::Rectangle>) -> Self {
            self.crop = input;
            self
        }
        /// Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
        pub fn drop_frame_timecode(mut self, input: crate::model::DropFrameTimecode) -> Self {
            self.drop_frame_timecode = Some(input);
            self
        }
        /// Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
        pub fn set_drop_frame_timecode(
            mut self,
            input: std::option::Option<crate::model::DropFrameTimecode>,
        ) -> Self {
            self.drop_frame_timecode = input;
            self
        }
        /// Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all  frames of this video output.
        pub fn fixed_afd(mut self, input: i32) -> Self {
            self.fixed_afd = Some(input);
            self
        }
        /// Applies only if you set AFD Signaling(AfdSignaling) to Fixed (FIXED). Use Fixed (FixedAfd) to specify a four-bit AFD value which the service will write on all  frames of this video output.
        pub fn set_fixed_afd(mut self, input: std::option::Option<i32>) -> Self {
            self.fixed_afd = input;
            self
        }
        /// Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don't provide a value here, the service will use the input height.
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// Use the Height (Height) setting to define the video resolution height for this output. Specify in pixels. If you don't provide a value here, the service will use the input height.
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.
        pub fn position(mut self, input: crate::model::Rectangle) -> Self {
            self.position = Some(input);
            self
        }
        /// Use Selection placement (position) to define the video area in your output frame. The area outside of the rectangle that you specify here is black.
        pub fn set_position(mut self, input: std::option::Option<crate::model::Rectangle>) -> Self {
            self.position = input;
            self
        }
        /// Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
        pub fn respond_to_afd(mut self, input: crate::model::RespondToAfd) -> Self {
            self.respond_to_afd = Some(input);
            self
        }
        /// Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
        pub fn set_respond_to_afd(
            mut self,
            input: std::option::Option<crate::model::RespondToAfd>,
        ) -> Self {
            self.respond_to_afd = input;
            self
        }
        /// Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
        pub fn scaling_behavior(mut self, input: crate::model::ScalingBehavior) -> Self {
            self.scaling_behavior = Some(input);
            self
        }
        /// Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
        pub fn set_scaling_behavior(
            mut self,
            input: std::option::Option<crate::model::ScalingBehavior>,
        ) -> Self {
            self.scaling_behavior = input;
            self
        }
        /// Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
        pub fn sharpness(mut self, input: i32) -> Self {
            self.sharpness = Some(input);
            self
        }
        /// Use Sharpness (Sharpness) setting to specify the strength of anti-aliasing. This setting changes the width of the anti-alias filter kernel used for scaling. Sharpness only applies if your output resolution is different from your input resolution. 0 is the softest setting, 100 the sharpest, and 50 recommended for most content.
        pub fn set_sharpness(mut self, input: std::option::Option<i32>) -> Self {
            self.sharpness = input;
            self
        }
        /// Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
        pub fn timecode_insertion(mut self, input: crate::model::VideoTimecodeInsertion) -> Self {
            self.timecode_insertion = Some(input);
            self
        }
        /// Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
        pub fn set_timecode_insertion(
            mut self,
            input: std::option::Option<crate::model::VideoTimecodeInsertion>,
        ) -> Self {
            self.timecode_insertion = input;
            self
        }
        /// Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
        pub fn video_preprocessors(mut self, input: crate::model::VideoPreprocessor) -> Self {
            self.video_preprocessors = Some(input);
            self
        }
        /// Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
        pub fn set_video_preprocessors(
            mut self,
            input: std::option::Option<crate::model::VideoPreprocessor>,
        ) -> Self {
            self.video_preprocessors = input;
            self
        }
        /// Use Width (Width) to define the video resolution width, in pixels, for this output. If you don't provide a value here, the service will use the input width.
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// Use Width (Width) to define the video resolution width, in pixels, for this output. If you don't provide a value here, the service will use the input width.
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoDescription`](crate::model::VideoDescription)
        pub fn build(self) -> crate::model::VideoDescription {
            crate::model::VideoDescription {
                afd_signaling: self.afd_signaling,
                anti_alias: self.anti_alias,
                codec_settings: self.codec_settings,
                color_metadata: self.color_metadata,
                crop: self.crop,
                drop_frame_timecode: self.drop_frame_timecode,
                fixed_afd: self.fixed_afd.unwrap_or_default(),
                height: self.height.unwrap_or_default(),
                position: self.position,
                respond_to_afd: self.respond_to_afd,
                scaling_behavior: self.scaling_behavior,
                sharpness: self.sharpness.unwrap_or_default(),
                timecode_insertion: self.timecode_insertion,
                video_preprocessors: self.video_preprocessors,
                width: self.width.unwrap_or_default(),
            }
        }
    }
}
impl VideoDescription {
    /// Creates a new builder-style object to manufacture [`VideoDescription`](crate::model::VideoDescription)
    pub fn builder() -> crate::model::video_description::Builder {
        crate::model::video_description::Builder::default()
    }
}

/// Find additional transcoding features under Preprocessors (VideoPreprocessors). Enable the features at each output individually. These features are disabled by default.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoPreprocessor {
    /// Use these settings to convert the color space or to modify properties such as hue and contrast for this output. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/converting-the-color-space.html.
    pub color_corrector: std::option::Option<crate::model::ColorCorrector>,
    /// Use the deinterlacer to produce smoother motion and a clearer picture. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-scan-type.html.
    pub deinterlacer: std::option::Option<crate::model::Deinterlacer>,
    /// Enable Dolby Vision feature to produce Dolby Vision compatible video output.
    pub dolby_vision: std::option::Option<crate::model::DolbyVision>,
    /// Enable HDR10+ analyis and metadata injection. Compatible with HEVC only.
    pub hdr10_plus: std::option::Option<crate::model::Hdr10Plus>,
    /// Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or disable this feature for each output individually. This setting is disabled by default.
    pub image_inserter: std::option::Option<crate::model::ImageInserter>,
    /// Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default.
    pub noise_reducer: std::option::Option<crate::model::NoiseReducer>,
    /// If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.
    pub partner_watermarking: std::option::Option<crate::model::PartnerWatermarking>,
    /// Settings for burning the output timecode and specified prefix into the output.
    pub timecode_burnin: std::option::Option<crate::model::TimecodeBurnin>,
}
impl VideoPreprocessor {
    /// Use these settings to convert the color space or to modify properties such as hue and contrast for this output. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/converting-the-color-space.html.
    pub fn color_corrector(&self) -> std::option::Option<&crate::model::ColorCorrector> {
        self.color_corrector.as_ref()
    }
    /// Use the deinterlacer to produce smoother motion and a clearer picture. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-scan-type.html.
    pub fn deinterlacer(&self) -> std::option::Option<&crate::model::Deinterlacer> {
        self.deinterlacer.as_ref()
    }
    /// Enable Dolby Vision feature to produce Dolby Vision compatible video output.
    pub fn dolby_vision(&self) -> std::option::Option<&crate::model::DolbyVision> {
        self.dolby_vision.as_ref()
    }
    /// Enable HDR10+ analyis and metadata injection. Compatible with HEVC only.
    pub fn hdr10_plus(&self) -> std::option::Option<&crate::model::Hdr10Plus> {
        self.hdr10_plus.as_ref()
    }
    /// Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or disable this feature for each output individually. This setting is disabled by default.
    pub fn image_inserter(&self) -> std::option::Option<&crate::model::ImageInserter> {
        self.image_inserter.as_ref()
    }
    /// Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default.
    pub fn noise_reducer(&self) -> std::option::Option<&crate::model::NoiseReducer> {
        self.noise_reducer.as_ref()
    }
    /// If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.
    pub fn partner_watermarking(&self) -> std::option::Option<&crate::model::PartnerWatermarking> {
        self.partner_watermarking.as_ref()
    }
    /// Settings for burning the output timecode and specified prefix into the output.
    pub fn timecode_burnin(&self) -> std::option::Option<&crate::model::TimecodeBurnin> {
        self.timecode_burnin.as_ref()
    }
}
impl std::fmt::Debug for VideoPreprocessor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoPreprocessor");
        formatter.field("color_corrector", &self.color_corrector);
        formatter.field("deinterlacer", &self.deinterlacer);
        formatter.field("dolby_vision", &self.dolby_vision);
        formatter.field("hdr10_plus", &self.hdr10_plus);
        formatter.field("image_inserter", &self.image_inserter);
        formatter.field("noise_reducer", &self.noise_reducer);
        formatter.field("partner_watermarking", &self.partner_watermarking);
        formatter.field("timecode_burnin", &self.timecode_burnin);
        formatter.finish()
    }
}
/// See [`VideoPreprocessor`](crate::model::VideoPreprocessor)
pub mod video_preprocessor {
    /// A builder for [`VideoPreprocessor`](crate::model::VideoPreprocessor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) color_corrector: std::option::Option<crate::model::ColorCorrector>,
        pub(crate) deinterlacer: std::option::Option<crate::model::Deinterlacer>,
        pub(crate) dolby_vision: std::option::Option<crate::model::DolbyVision>,
        pub(crate) hdr10_plus: std::option::Option<crate::model::Hdr10Plus>,
        pub(crate) image_inserter: std::option::Option<crate::model::ImageInserter>,
        pub(crate) noise_reducer: std::option::Option<crate::model::NoiseReducer>,
        pub(crate) partner_watermarking: std::option::Option<crate::model::PartnerWatermarking>,
        pub(crate) timecode_burnin: std::option::Option<crate::model::TimecodeBurnin>,
    }
    impl Builder {
        /// Use these settings to convert the color space or to modify properties such as hue and contrast for this output. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/converting-the-color-space.html.
        pub fn color_corrector(mut self, input: crate::model::ColorCorrector) -> Self {
            self.color_corrector = Some(input);
            self
        }
        /// Use these settings to convert the color space or to modify properties such as hue and contrast for this output. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/converting-the-color-space.html.
        pub fn set_color_corrector(
            mut self,
            input: std::option::Option<crate::model::ColorCorrector>,
        ) -> Self {
            self.color_corrector = input;
            self
        }
        /// Use the deinterlacer to produce smoother motion and a clearer picture. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-scan-type.html.
        pub fn deinterlacer(mut self, input: crate::model::Deinterlacer) -> Self {
            self.deinterlacer = Some(input);
            self
        }
        /// Use the deinterlacer to produce smoother motion and a clearer picture. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-scan-type.html.
        pub fn set_deinterlacer(
            mut self,
            input: std::option::Option<crate::model::Deinterlacer>,
        ) -> Self {
            self.deinterlacer = input;
            self
        }
        /// Enable Dolby Vision feature to produce Dolby Vision compatible video output.
        pub fn dolby_vision(mut self, input: crate::model::DolbyVision) -> Self {
            self.dolby_vision = Some(input);
            self
        }
        /// Enable Dolby Vision feature to produce Dolby Vision compatible video output.
        pub fn set_dolby_vision(
            mut self,
            input: std::option::Option<crate::model::DolbyVision>,
        ) -> Self {
            self.dolby_vision = input;
            self
        }
        /// Enable HDR10+ analyis and metadata injection. Compatible with HEVC only.
        pub fn hdr10_plus(mut self, input: crate::model::Hdr10Plus) -> Self {
            self.hdr10_plus = Some(input);
            self
        }
        /// Enable HDR10+ analyis and metadata injection. Compatible with HEVC only.
        pub fn set_hdr10_plus(
            mut self,
            input: std::option::Option<crate::model::Hdr10Plus>,
        ) -> Self {
            self.hdr10_plus = input;
            self
        }
        /// Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or disable this feature for each output individually. This setting is disabled by default.
        pub fn image_inserter(mut self, input: crate::model::ImageInserter) -> Self {
            self.image_inserter = Some(input);
            self
        }
        /// Enable the Image inserter (ImageInserter) feature to include a graphic overlay on your video. Enable or disable this feature for each output individually. This setting is disabled by default.
        pub fn set_image_inserter(
            mut self,
            input: std::option::Option<crate::model::ImageInserter>,
        ) -> Self {
            self.image_inserter = input;
            self
        }
        /// Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default.
        pub fn noise_reducer(mut self, input: crate::model::NoiseReducer) -> Self {
            self.noise_reducer = Some(input);
            self
        }
        /// Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default.
        pub fn set_noise_reducer(
            mut self,
            input: std::option::Option<crate::model::NoiseReducer>,
        ) -> Self {
            self.noise_reducer = input;
            self
        }
        /// If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.
        pub fn partner_watermarking(mut self, input: crate::model::PartnerWatermarking) -> Self {
            self.partner_watermarking = Some(input);
            self
        }
        /// If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.
        pub fn set_partner_watermarking(
            mut self,
            input: std::option::Option<crate::model::PartnerWatermarking>,
        ) -> Self {
            self.partner_watermarking = input;
            self
        }
        /// Settings for burning the output timecode and specified prefix into the output.
        pub fn timecode_burnin(mut self, input: crate::model::TimecodeBurnin) -> Self {
            self.timecode_burnin = Some(input);
            self
        }
        /// Settings for burning the output timecode and specified prefix into the output.
        pub fn set_timecode_burnin(
            mut self,
            input: std::option::Option<crate::model::TimecodeBurnin>,
        ) -> Self {
            self.timecode_burnin = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoPreprocessor`](crate::model::VideoPreprocessor)
        pub fn build(self) -> crate::model::VideoPreprocessor {
            crate::model::VideoPreprocessor {
                color_corrector: self.color_corrector,
                deinterlacer: self.deinterlacer,
                dolby_vision: self.dolby_vision,
                hdr10_plus: self.hdr10_plus,
                image_inserter: self.image_inserter,
                noise_reducer: self.noise_reducer,
                partner_watermarking: self.partner_watermarking,
                timecode_burnin: self.timecode_burnin,
            }
        }
    }
}
impl VideoPreprocessor {
    /// Creates a new builder-style object to manufacture [`VideoPreprocessor`](crate::model::VideoPreprocessor)
    pub fn builder() -> crate::model::video_preprocessor::Builder {
        crate::model::video_preprocessor::Builder::default()
    }
}

/// Settings for burning the output timecode and specified prefix into the output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TimecodeBurnin {
    /// Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
    pub font_size: i32,
    /// Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.
    pub position: std::option::Option<crate::model::TimecodeBurninPosition>,
    /// Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all special characters represented on a standard English keyboard.
    pub prefix: std::option::Option<std::string::String>,
}
impl TimecodeBurnin {
    /// Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
    pub fn font_size(&self) -> i32 {
        self.font_size
    }
    /// Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.
    pub fn position(&self) -> std::option::Option<&crate::model::TimecodeBurninPosition> {
        self.position.as_ref()
    }
    /// Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all special characters represented on a standard English keyboard.
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for TimecodeBurnin {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TimecodeBurnin");
        formatter.field("font_size", &self.font_size);
        formatter.field("position", &self.position);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`TimecodeBurnin`](crate::model::TimecodeBurnin)
pub mod timecode_burnin {
    /// A builder for [`TimecodeBurnin`](crate::model::TimecodeBurnin)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) font_size: std::option::Option<i32>,
        pub(crate) position: std::option::Option<crate::model::TimecodeBurninPosition>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
        pub fn font_size(mut self, input: i32) -> Self {
            self.font_size = Some(input);
            self
        }
        /// Use Font Size (FontSize) to set the font size of any burned-in timecode. Valid values are 10, 16, 32, 48.
        pub fn set_font_size(mut self, input: std::option::Option<i32>) -> Self {
            self.font_size = input;
            self
        }
        /// Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.
        pub fn position(mut self, input: crate::model::TimecodeBurninPosition) -> Self {
            self.position = Some(input);
            self
        }
        /// Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.
        pub fn set_position(
            mut self,
            input: std::option::Option<crate::model::TimecodeBurninPosition>,
        ) -> Self {
            self.position = input;
            self
        }
        /// Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all special characters represented on a standard English keyboard.
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// Use Prefix (Prefix) to place ASCII characters before any burned-in timecode. For example, a prefix of "EZ-" will result in the timecode "EZ-00:00:00:00". Provide either the characters themselves or the ASCII code equivalents. The supported range of characters is 0x20 through 0x7e. This includes letters, numbers, and all special characters represented on a standard English keyboard.
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`TimecodeBurnin`](crate::model::TimecodeBurnin)
        pub fn build(self) -> crate::model::TimecodeBurnin {
            crate::model::TimecodeBurnin {
                font_size: self.font_size.unwrap_or_default(),
                position: self.position,
                prefix: self.prefix,
            }
        }
    }
}
impl TimecodeBurnin {
    /// Creates a new builder-style object to manufacture [`TimecodeBurnin`](crate::model::TimecodeBurnin)
    pub fn builder() -> crate::model::timecode_burnin::Builder {
        crate::model::timecode_burnin::Builder::default()
    }
}

/// Use Position (Position) under under Timecode burn-in (TimecodeBurnIn) to specify the location the burned-in timecode on output video.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimecodeBurninPosition {
    #[allow(missing_docs)] // documentation missing in model
    BottomCenter,
    #[allow(missing_docs)] // documentation missing in model
    BottomLeft,
    #[allow(missing_docs)] // documentation missing in model
    BottomRight,
    #[allow(missing_docs)] // documentation missing in model
    MiddleCenter,
    #[allow(missing_docs)] // documentation missing in model
    MiddleLeft,
    #[allow(missing_docs)] // documentation missing in model
    MiddleRight,
    #[allow(missing_docs)] // documentation missing in model
    TopCenter,
    #[allow(missing_docs)] // documentation missing in model
    TopLeft,
    #[allow(missing_docs)] // documentation missing in model
    TopRight,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimecodeBurninPosition {
    fn from(s: &str) -> Self {
        match s {
            "BOTTOM_CENTER" => TimecodeBurninPosition::BottomCenter,
            "BOTTOM_LEFT" => TimecodeBurninPosition::BottomLeft,
            "BOTTOM_RIGHT" => TimecodeBurninPosition::BottomRight,
            "MIDDLE_CENTER" => TimecodeBurninPosition::MiddleCenter,
            "MIDDLE_LEFT" => TimecodeBurninPosition::MiddleLeft,
            "MIDDLE_RIGHT" => TimecodeBurninPosition::MiddleRight,
            "TOP_CENTER" => TimecodeBurninPosition::TopCenter,
            "TOP_LEFT" => TimecodeBurninPosition::TopLeft,
            "TOP_RIGHT" => TimecodeBurninPosition::TopRight,
            other => TimecodeBurninPosition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimecodeBurninPosition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimecodeBurninPosition::from(s))
    }
}
impl TimecodeBurninPosition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimecodeBurninPosition::BottomCenter => "BOTTOM_CENTER",
            TimecodeBurninPosition::BottomLeft => "BOTTOM_LEFT",
            TimecodeBurninPosition::BottomRight => "BOTTOM_RIGHT",
            TimecodeBurninPosition::MiddleCenter => "MIDDLE_CENTER",
            TimecodeBurninPosition::MiddleLeft => "MIDDLE_LEFT",
            TimecodeBurninPosition::MiddleRight => "MIDDLE_RIGHT",
            TimecodeBurninPosition::TopCenter => "TOP_CENTER",
            TimecodeBurninPosition::TopLeft => "TOP_LEFT",
            TimecodeBurninPosition::TopRight => "TOP_RIGHT",
            TimecodeBurninPosition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOTTOM_CENTER",
            "BOTTOM_LEFT",
            "BOTTOM_RIGHT",
            "MIDDLE_CENTER",
            "MIDDLE_LEFT",
            "MIDDLE_RIGHT",
            "TOP_CENTER",
            "TOP_LEFT",
            "TOP_RIGHT",
        ]
    }
}
impl AsRef<str> for TimecodeBurninPosition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you work with a third party video watermarking partner, use the group of settings that correspond with your watermarking partner to include watermarks in your output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PartnerWatermarking {
    /// For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
    pub nexguard_file_marker_settings:
        std::option::Option<crate::model::NexGuardFileMarkerSettings>,
}
impl PartnerWatermarking {
    /// For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
    pub fn nexguard_file_marker_settings(
        &self,
    ) -> std::option::Option<&crate::model::NexGuardFileMarkerSettings> {
        self.nexguard_file_marker_settings.as_ref()
    }
}
impl std::fmt::Debug for PartnerWatermarking {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PartnerWatermarking");
        formatter.field(
            "nexguard_file_marker_settings",
            &self.nexguard_file_marker_settings,
        );
        formatter.finish()
    }
}
/// See [`PartnerWatermarking`](crate::model::PartnerWatermarking)
pub mod partner_watermarking {
    /// A builder for [`PartnerWatermarking`](crate::model::PartnerWatermarking)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) nexguard_file_marker_settings:
            std::option::Option<crate::model::NexGuardFileMarkerSettings>,
    }
    impl Builder {
        /// For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
        pub fn nexguard_file_marker_settings(
            mut self,
            input: crate::model::NexGuardFileMarkerSettings,
        ) -> Self {
            self.nexguard_file_marker_settings = Some(input);
            self
        }
        /// For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
        pub fn set_nexguard_file_marker_settings(
            mut self,
            input: std::option::Option<crate::model::NexGuardFileMarkerSettings>,
        ) -> Self {
            self.nexguard_file_marker_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`PartnerWatermarking`](crate::model::PartnerWatermarking)
        pub fn build(self) -> crate::model::PartnerWatermarking {
            crate::model::PartnerWatermarking {
                nexguard_file_marker_settings: self.nexguard_file_marker_settings,
            }
        }
    }
}
impl PartnerWatermarking {
    /// Creates a new builder-style object to manufacture [`PartnerWatermarking`](crate::model::PartnerWatermarking)
    pub fn builder() -> crate::model::partner_watermarking::Builder {
        crate::model::partner_watermarking::Builder::default()
    }
}

/// For forensic video watermarking, MediaConvert supports Nagra NexGuard File Marker watermarking. MediaConvert supports both PreRelease Content (NGPR/G2) and OTT Streaming workflows.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NexGuardFileMarkerSettings {
    /// Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
    pub license: std::option::Option<std::string::String>,
    /// Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.
    pub payload: i32,
    /// Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
    pub preset: std::option::Option<std::string::String>,
    /// Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
    pub strength: std::option::Option<crate::model::WatermarkingStrength>,
}
impl NexGuardFileMarkerSettings {
    /// Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
    pub fn license(&self) -> std::option::Option<&str> {
        self.license.as_deref()
    }
    /// Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.
    pub fn payload(&self) -> i32 {
        self.payload
    }
    /// Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
    pub fn preset(&self) -> std::option::Option<&str> {
        self.preset.as_deref()
    }
    /// Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
    pub fn strength(&self) -> std::option::Option<&crate::model::WatermarkingStrength> {
        self.strength.as_ref()
    }
}
impl std::fmt::Debug for NexGuardFileMarkerSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NexGuardFileMarkerSettings");
        formatter.field("license", &self.license);
        formatter.field("payload", &self.payload);
        formatter.field("preset", &self.preset);
        formatter.field("strength", &self.strength);
        formatter.finish()
    }
}
/// See [`NexGuardFileMarkerSettings`](crate::model::NexGuardFileMarkerSettings)
pub mod nex_guard_file_marker_settings {
    /// A builder for [`NexGuardFileMarkerSettings`](crate::model::NexGuardFileMarkerSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) license: std::option::Option<std::string::String>,
        pub(crate) payload: std::option::Option<i32>,
        pub(crate) preset: std::option::Option<std::string::String>,
        pub(crate) strength: std::option::Option<crate::model::WatermarkingStrength>,
    }
    impl Builder {
        /// Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
        pub fn license(mut self, input: impl Into<std::string::String>) -> Self {
            self.license = Some(input.into());
            self
        }
        /// Use the base64 license string that Nagra provides you. Enter it directly in your JSON job specification or in the console. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
        pub fn set_license(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.license = input;
            self
        }
        /// Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.
        pub fn payload(mut self, input: i32) -> Self {
            self.payload = Some(input);
            self
        }
        /// Specify the payload ID that you want associated with this output. Valid values vary depending on your Nagra NexGuard forensic watermarking workflow. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job. For PreRelease Content (NGPR/G2), specify an integer from 1 through 4,194,303. You must generate a unique ID for each asset you watermark, and keep a record of which ID you have assigned to each asset. Neither Nagra nor MediaConvert keep track of the relationship between output files and your IDs. For OTT Streaming, create two adaptive bitrate (ABR) stacks for each asset. Do this by setting up two output groups. For one output group, set the value of Payload ID (payload) to 0 in every output. For the other output group, set Payload ID (payload) to 1 in every output.
        pub fn set_payload(mut self, input: std::option::Option<i32>) -> Self {
            self.payload = input;
            self
        }
        /// Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
        pub fn preset(mut self, input: impl Into<std::string::String>) -> Self {
            self.preset = Some(input.into());
            self
        }
        /// Enter one of the watermarking preset strings that Nagra provides you. Required when you include Nagra NexGuard File Marker watermarking (NexGuardWatermarkingSettings) in your job.
        pub fn set_preset(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.preset = input;
            self
        }
        /// Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
        pub fn strength(mut self, input: crate::model::WatermarkingStrength) -> Self {
            self.strength = Some(input);
            self
        }
        /// Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
        pub fn set_strength(
            mut self,
            input: std::option::Option<crate::model::WatermarkingStrength>,
        ) -> Self {
            self.strength = input;
            self
        }
        /// Consumes the builder and constructs a [`NexGuardFileMarkerSettings`](crate::model::NexGuardFileMarkerSettings)
        pub fn build(self) -> crate::model::NexGuardFileMarkerSettings {
            crate::model::NexGuardFileMarkerSettings {
                license: self.license,
                payload: self.payload.unwrap_or_default(),
                preset: self.preset,
                strength: self.strength,
            }
        }
    }
}
impl NexGuardFileMarkerSettings {
    /// Creates a new builder-style object to manufacture [`NexGuardFileMarkerSettings`](crate::model::NexGuardFileMarkerSettings)
    pub fn builder() -> crate::model::nex_guard_file_marker_settings::Builder {
        crate::model::nex_guard_file_marker_settings::Builder::default()
    }
}

/// Optional. Ignore this setting unless Nagra support directs you to specify a value. When you don't specify a value here, the Nagra NexGuard library uses its default value.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum WatermarkingStrength {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Lighter,
    #[allow(missing_docs)] // documentation missing in model
    Lightest,
    #[allow(missing_docs)] // documentation missing in model
    Stronger,
    #[allow(missing_docs)] // documentation missing in model
    Strongest,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for WatermarkingStrength {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => WatermarkingStrength::Default,
            "LIGHTER" => WatermarkingStrength::Lighter,
            "LIGHTEST" => WatermarkingStrength::Lightest,
            "STRONGER" => WatermarkingStrength::Stronger,
            "STRONGEST" => WatermarkingStrength::Strongest,
            other => WatermarkingStrength::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for WatermarkingStrength {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(WatermarkingStrength::from(s))
    }
}
impl WatermarkingStrength {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            WatermarkingStrength::Default => "DEFAULT",
            WatermarkingStrength::Lighter => "LIGHTER",
            WatermarkingStrength::Lightest => "LIGHTEST",
            WatermarkingStrength::Stronger => "STRONGER",
            WatermarkingStrength::Strongest => "STRONGEST",
            WatermarkingStrength::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "LIGHTER", "LIGHTEST", "STRONGER", "STRONGEST"]
    }
}
impl AsRef<str> for WatermarkingStrength {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enable the Noise reducer (NoiseReducer) feature to remove noise from your video output if necessary. Enable or disable this feature for each output individually. This setting is disabled by default. When you enable Noise reducer (NoiseReducer), you must also select a value for Noise reducer filter (NoiseReducerFilter).
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoiseReducer {
    /// Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
    pub filter: std::option::Option<crate::model::NoiseReducerFilter>,
    /// Settings for a noise reducer filter
    pub filter_settings: std::option::Option<crate::model::NoiseReducerFilterSettings>,
    /// Noise reducer filter settings for spatial filter.
    pub spatial_filter_settings:
        std::option::Option<crate::model::NoiseReducerSpatialFilterSettings>,
    /// Noise reducer filter settings for temporal filter.
    pub temporal_filter_settings:
        std::option::Option<crate::model::NoiseReducerTemporalFilterSettings>,
}
impl NoiseReducer {
    /// Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
    pub fn filter(&self) -> std::option::Option<&crate::model::NoiseReducerFilter> {
        self.filter.as_ref()
    }
    /// Settings for a noise reducer filter
    pub fn filter_settings(
        &self,
    ) -> std::option::Option<&crate::model::NoiseReducerFilterSettings> {
        self.filter_settings.as_ref()
    }
    /// Noise reducer filter settings for spatial filter.
    pub fn spatial_filter_settings(
        &self,
    ) -> std::option::Option<&crate::model::NoiseReducerSpatialFilterSettings> {
        self.spatial_filter_settings.as_ref()
    }
    /// Noise reducer filter settings for temporal filter.
    pub fn temporal_filter_settings(
        &self,
    ) -> std::option::Option<&crate::model::NoiseReducerTemporalFilterSettings> {
        self.temporal_filter_settings.as_ref()
    }
}
impl std::fmt::Debug for NoiseReducer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoiseReducer");
        formatter.field("filter", &self.filter);
        formatter.field("filter_settings", &self.filter_settings);
        formatter.field("spatial_filter_settings", &self.spatial_filter_settings);
        formatter.field("temporal_filter_settings", &self.temporal_filter_settings);
        formatter.finish()
    }
}
/// See [`NoiseReducer`](crate::model::NoiseReducer)
pub mod noise_reducer {
    /// A builder for [`NoiseReducer`](crate::model::NoiseReducer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter: std::option::Option<crate::model::NoiseReducerFilter>,
        pub(crate) filter_settings: std::option::Option<crate::model::NoiseReducerFilterSettings>,
        pub(crate) spatial_filter_settings:
            std::option::Option<crate::model::NoiseReducerSpatialFilterSettings>,
        pub(crate) temporal_filter_settings:
            std::option::Option<crate::model::NoiseReducerTemporalFilterSettings>,
    }
    impl Builder {
        /// Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
        pub fn filter(mut self, input: crate::model::NoiseReducerFilter) -> Self {
            self.filter = Some(input);
            self
        }
        /// Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
        pub fn set_filter(
            mut self,
            input: std::option::Option<crate::model::NoiseReducerFilter>,
        ) -> Self {
            self.filter = input;
            self
        }
        /// Settings for a noise reducer filter
        pub fn filter_settings(mut self, input: crate::model::NoiseReducerFilterSettings) -> Self {
            self.filter_settings = Some(input);
            self
        }
        /// Settings for a noise reducer filter
        pub fn set_filter_settings(
            mut self,
            input: std::option::Option<crate::model::NoiseReducerFilterSettings>,
        ) -> Self {
            self.filter_settings = input;
            self
        }
        /// Noise reducer filter settings for spatial filter.
        pub fn spatial_filter_settings(
            mut self,
            input: crate::model::NoiseReducerSpatialFilterSettings,
        ) -> Self {
            self.spatial_filter_settings = Some(input);
            self
        }
        /// Noise reducer filter settings for spatial filter.
        pub fn set_spatial_filter_settings(
            mut self,
            input: std::option::Option<crate::model::NoiseReducerSpatialFilterSettings>,
        ) -> Self {
            self.spatial_filter_settings = input;
            self
        }
        /// Noise reducer filter settings for temporal filter.
        pub fn temporal_filter_settings(
            mut self,
            input: crate::model::NoiseReducerTemporalFilterSettings,
        ) -> Self {
            self.temporal_filter_settings = Some(input);
            self
        }
        /// Noise reducer filter settings for temporal filter.
        pub fn set_temporal_filter_settings(
            mut self,
            input: std::option::Option<crate::model::NoiseReducerTemporalFilterSettings>,
        ) -> Self {
            self.temporal_filter_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`NoiseReducer`](crate::model::NoiseReducer)
        pub fn build(self) -> crate::model::NoiseReducer {
            crate::model::NoiseReducer {
                filter: self.filter,
                filter_settings: self.filter_settings,
                spatial_filter_settings: self.spatial_filter_settings,
                temporal_filter_settings: self.temporal_filter_settings,
            }
        }
    }
}
impl NoiseReducer {
    /// Creates a new builder-style object to manufacture [`NoiseReducer`](crate::model::NoiseReducer)
    pub fn builder() -> crate::model::noise_reducer::Builder {
        crate::model::noise_reducer::Builder::default()
    }
}

/// Noise reducer filter settings for temporal filter.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoiseReducerTemporalFilterSettings {
    /// Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
    pub aggressive_mode: i32,
    /// Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can use this setting to apply sharpening. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply filtering, depending on input type and quality. When you set Noise reducer to Temporal, your output bandwidth is reduced. When Post temporal sharpening is also enabled, that bandwidth reduction is smaller.
    pub post_temporal_sharpening:
        std::option::Option<crate::model::NoiseFilterPostTemporalSharpening>,
    /// The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.
    pub speed: i32,
    /// Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction
    pub strength: i32,
}
impl NoiseReducerTemporalFilterSettings {
    /// Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
    pub fn aggressive_mode(&self) -> i32 {
        self.aggressive_mode
    }
    /// Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can use this setting to apply sharpening. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply filtering, depending on input type and quality. When you set Noise reducer to Temporal, your output bandwidth is reduced. When Post temporal sharpening is also enabled, that bandwidth reduction is smaller.
    pub fn post_temporal_sharpening(
        &self,
    ) -> std::option::Option<&crate::model::NoiseFilterPostTemporalSharpening> {
        self.post_temporal_sharpening.as_ref()
    }
    /// The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.
    pub fn speed(&self) -> i32 {
        self.speed
    }
    /// Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction
    pub fn strength(&self) -> i32 {
        self.strength
    }
}
impl std::fmt::Debug for NoiseReducerTemporalFilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoiseReducerTemporalFilterSettings");
        formatter.field("aggressive_mode", &self.aggressive_mode);
        formatter.field("post_temporal_sharpening", &self.post_temporal_sharpening);
        formatter.field("speed", &self.speed);
        formatter.field("strength", &self.strength);
        formatter.finish()
    }
}
/// See [`NoiseReducerTemporalFilterSettings`](crate::model::NoiseReducerTemporalFilterSettings)
pub mod noise_reducer_temporal_filter_settings {
    /// A builder for [`NoiseReducerTemporalFilterSettings`](crate::model::NoiseReducerTemporalFilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) aggressive_mode: std::option::Option<i32>,
        pub(crate) post_temporal_sharpening:
            std::option::Option<crate::model::NoiseFilterPostTemporalSharpening>,
        pub(crate) speed: std::option::Option<i32>,
        pub(crate) strength: std::option::Option<i32>,
    }
    impl Builder {
        /// Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
        pub fn aggressive_mode(mut self, input: i32) -> Self {
            self.aggressive_mode = Some(input);
            self
        }
        /// Use Aggressive mode for content that has complex motion. Higher values produce stronger temporal filtering. This filters highly complex scenes more aggressively and creates better VQ for low bitrate outputs.
        pub fn set_aggressive_mode(mut self, input: std::option::Option<i32>) -> Self {
            self.aggressive_mode = input;
            self
        }
        /// Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can use this setting to apply sharpening. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply filtering, depending on input type and quality. When you set Noise reducer to Temporal, your output bandwidth is reduced. When Post temporal sharpening is also enabled, that bandwidth reduction is smaller.
        pub fn post_temporal_sharpening(
            mut self,
            input: crate::model::NoiseFilterPostTemporalSharpening,
        ) -> Self {
            self.post_temporal_sharpening = Some(input);
            self
        }
        /// Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can use this setting to apply sharpening. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply filtering, depending on input type and quality. When you set Noise reducer to Temporal, your output bandwidth is reduced. When Post temporal sharpening is also enabled, that bandwidth reduction is smaller.
        pub fn set_post_temporal_sharpening(
            mut self,
            input: std::option::Option<crate::model::NoiseFilterPostTemporalSharpening>,
        ) -> Self {
            self.post_temporal_sharpening = input;
            self
        }
        /// The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.
        pub fn speed(mut self, input: i32) -> Self {
            self.speed = Some(input);
            self
        }
        /// The speed of the filter (higher number is faster). Low setting reduces bit rate at the cost of transcode time, high setting improves transcode time at the cost of bit rate.
        pub fn set_speed(mut self, input: std::option::Option<i32>) -> Self {
            self.speed = input;
            self
        }
        /// Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction
        pub fn strength(mut self, input: i32) -> Self {
            self.strength = Some(input);
            self
        }
        /// Specify the strength of the noise reducing filter on this output. Higher values produce stronger filtering. We recommend the following value ranges, depending on the result that you want: * 0-2 for complexity reduction with minimal sharpness loss * 2-8 for complexity reduction with image preservation * 8-16 for a high level of complexity reduction
        pub fn set_strength(mut self, input: std::option::Option<i32>) -> Self {
            self.strength = input;
            self
        }
        /// Consumes the builder and constructs a [`NoiseReducerTemporalFilterSettings`](crate::model::NoiseReducerTemporalFilterSettings)
        pub fn build(self) -> crate::model::NoiseReducerTemporalFilterSettings {
            crate::model::NoiseReducerTemporalFilterSettings {
                aggressive_mode: self.aggressive_mode.unwrap_or_default(),
                post_temporal_sharpening: self.post_temporal_sharpening,
                speed: self.speed.unwrap_or_default(),
                strength: self.strength.unwrap_or_default(),
            }
        }
    }
}
impl NoiseReducerTemporalFilterSettings {
    /// Creates a new builder-style object to manufacture [`NoiseReducerTemporalFilterSettings`](crate::model::NoiseReducerTemporalFilterSettings)
    pub fn builder() -> crate::model::noise_reducer_temporal_filter_settings::Builder {
        crate::model::noise_reducer_temporal_filter_settings::Builder::default()
    }
}

/// Optional. When you set Noise reducer (noiseReducer) to Temporal (TEMPORAL), you can use this setting to apply sharpening. The default behavior, Auto (AUTO), allows the transcoder to determine whether to apply filtering, depending on input type and quality. When you set Noise reducer to Temporal, your output bandwidth is reduced. When Post temporal sharpening is also enabled, that bandwidth reduction is smaller.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NoiseFilterPostTemporalSharpening {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NoiseFilterPostTemporalSharpening {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => NoiseFilterPostTemporalSharpening::Auto,
            "DISABLED" => NoiseFilterPostTemporalSharpening::Disabled,
            "ENABLED" => NoiseFilterPostTemporalSharpening::Enabled,
            other => NoiseFilterPostTemporalSharpening::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NoiseFilterPostTemporalSharpening {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NoiseFilterPostTemporalSharpening::from(s))
    }
}
impl NoiseFilterPostTemporalSharpening {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NoiseFilterPostTemporalSharpening::Auto => "AUTO",
            NoiseFilterPostTemporalSharpening::Disabled => "DISABLED",
            NoiseFilterPostTemporalSharpening::Enabled => "ENABLED",
            NoiseFilterPostTemporalSharpening::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for NoiseFilterPostTemporalSharpening {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Noise reducer filter settings for spatial filter.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoiseReducerSpatialFilterSettings {
    /// Specify strength of post noise reduction sharpening filter, with 0 disabling the filter and 3 enabling it at maximum strength.
    pub post_filter_sharpen_strength: i32,
    /// The speed of the filter, from -2 (lower speed) to 3 (higher speed), with 0 being the nominal value.
    pub speed: i32,
    /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
    pub strength: i32,
}
impl NoiseReducerSpatialFilterSettings {
    /// Specify strength of post noise reduction sharpening filter, with 0 disabling the filter and 3 enabling it at maximum strength.
    pub fn post_filter_sharpen_strength(&self) -> i32 {
        self.post_filter_sharpen_strength
    }
    /// The speed of the filter, from -2 (lower speed) to 3 (higher speed), with 0 being the nominal value.
    pub fn speed(&self) -> i32 {
        self.speed
    }
    /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
    pub fn strength(&self) -> i32 {
        self.strength
    }
}
impl std::fmt::Debug for NoiseReducerSpatialFilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoiseReducerSpatialFilterSettings");
        formatter.field(
            "post_filter_sharpen_strength",
            &self.post_filter_sharpen_strength,
        );
        formatter.field("speed", &self.speed);
        formatter.field("strength", &self.strength);
        formatter.finish()
    }
}
/// See [`NoiseReducerSpatialFilterSettings`](crate::model::NoiseReducerSpatialFilterSettings)
pub mod noise_reducer_spatial_filter_settings {
    /// A builder for [`NoiseReducerSpatialFilterSettings`](crate::model::NoiseReducerSpatialFilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) post_filter_sharpen_strength: std::option::Option<i32>,
        pub(crate) speed: std::option::Option<i32>,
        pub(crate) strength: std::option::Option<i32>,
    }
    impl Builder {
        /// Specify strength of post noise reduction sharpening filter, with 0 disabling the filter and 3 enabling it at maximum strength.
        pub fn post_filter_sharpen_strength(mut self, input: i32) -> Self {
            self.post_filter_sharpen_strength = Some(input);
            self
        }
        /// Specify strength of post noise reduction sharpening filter, with 0 disabling the filter and 3 enabling it at maximum strength.
        pub fn set_post_filter_sharpen_strength(mut self, input: std::option::Option<i32>) -> Self {
            self.post_filter_sharpen_strength = input;
            self
        }
        /// The speed of the filter, from -2 (lower speed) to 3 (higher speed), with 0 being the nominal value.
        pub fn speed(mut self, input: i32) -> Self {
            self.speed = Some(input);
            self
        }
        /// The speed of the filter, from -2 (lower speed) to 3 (higher speed), with 0 being the nominal value.
        pub fn set_speed(mut self, input: std::option::Option<i32>) -> Self {
            self.speed = input;
            self
        }
        /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
        pub fn strength(mut self, input: i32) -> Self {
            self.strength = Some(input);
            self
        }
        /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
        pub fn set_strength(mut self, input: std::option::Option<i32>) -> Self {
            self.strength = input;
            self
        }
        /// Consumes the builder and constructs a [`NoiseReducerSpatialFilterSettings`](crate::model::NoiseReducerSpatialFilterSettings)
        pub fn build(self) -> crate::model::NoiseReducerSpatialFilterSettings {
            crate::model::NoiseReducerSpatialFilterSettings {
                post_filter_sharpen_strength: self.post_filter_sharpen_strength.unwrap_or_default(),
                speed: self.speed.unwrap_or_default(),
                strength: self.strength.unwrap_or_default(),
            }
        }
    }
}
impl NoiseReducerSpatialFilterSettings {
    /// Creates a new builder-style object to manufacture [`NoiseReducerSpatialFilterSettings`](crate::model::NoiseReducerSpatialFilterSettings)
    pub fn builder() -> crate::model::noise_reducer_spatial_filter_settings::Builder {
        crate::model::noise_reducer_spatial_filter_settings::Builder::default()
    }
}

/// Settings for a noise reducer filter
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NoiseReducerFilterSettings {
    /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
    pub strength: i32,
}
impl NoiseReducerFilterSettings {
    /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
    pub fn strength(&self) -> i32 {
        self.strength
    }
}
impl std::fmt::Debug for NoiseReducerFilterSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NoiseReducerFilterSettings");
        formatter.field("strength", &self.strength);
        formatter.finish()
    }
}
/// See [`NoiseReducerFilterSettings`](crate::model::NoiseReducerFilterSettings)
pub mod noise_reducer_filter_settings {
    /// A builder for [`NoiseReducerFilterSettings`](crate::model::NoiseReducerFilterSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) strength: std::option::Option<i32>,
    }
    impl Builder {
        /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
        pub fn strength(mut self, input: i32) -> Self {
            self.strength = Some(input);
            self
        }
        /// Relative strength of noise reducing filter. Higher values produce stronger filtering.
        pub fn set_strength(mut self, input: std::option::Option<i32>) -> Self {
            self.strength = input;
            self
        }
        /// Consumes the builder and constructs a [`NoiseReducerFilterSettings`](crate::model::NoiseReducerFilterSettings)
        pub fn build(self) -> crate::model::NoiseReducerFilterSettings {
            crate::model::NoiseReducerFilterSettings {
                strength: self.strength.unwrap_or_default(),
            }
        }
    }
}
impl NoiseReducerFilterSettings {
    /// Creates a new builder-style object to manufacture [`NoiseReducerFilterSettings`](crate::model::NoiseReducerFilterSettings)
    pub fn builder() -> crate::model::noise_reducer_filter_settings::Builder {
        crate::model::noise_reducer_filter_settings::Builder::default()
    }
}

/// Use Noise reducer filter (NoiseReducerFilter) to select one of the following spatial image filtering functions. To use this setting, you must also enable Noise reducer (NoiseReducer). * Bilateral preserves edges while reducing noise. * Mean (softest), Gaussian, Lanczos, and Sharpen (sharpest) do convolution filtering. * Conserve does min/max noise reduction. * Spatial does frequency-domain filtering based on JND principles. * Temporal optimizes video quality for complex motion.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NoiseReducerFilter {
    #[allow(missing_docs)] // documentation missing in model
    Bilateral,
    #[allow(missing_docs)] // documentation missing in model
    Conserve,
    #[allow(missing_docs)] // documentation missing in model
    Gaussian,
    #[allow(missing_docs)] // documentation missing in model
    Lanczos,
    #[allow(missing_docs)] // documentation missing in model
    Mean,
    #[allow(missing_docs)] // documentation missing in model
    Sharpen,
    #[allow(missing_docs)] // documentation missing in model
    Spatial,
    #[allow(missing_docs)] // documentation missing in model
    Temporal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NoiseReducerFilter {
    fn from(s: &str) -> Self {
        match s {
            "BILATERAL" => NoiseReducerFilter::Bilateral,
            "CONSERVE" => NoiseReducerFilter::Conserve,
            "GAUSSIAN" => NoiseReducerFilter::Gaussian,
            "LANCZOS" => NoiseReducerFilter::Lanczos,
            "MEAN" => NoiseReducerFilter::Mean,
            "SHARPEN" => NoiseReducerFilter::Sharpen,
            "SPATIAL" => NoiseReducerFilter::Spatial,
            "TEMPORAL" => NoiseReducerFilter::Temporal,
            other => NoiseReducerFilter::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NoiseReducerFilter {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NoiseReducerFilter::from(s))
    }
}
impl NoiseReducerFilter {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NoiseReducerFilter::Bilateral => "BILATERAL",
            NoiseReducerFilter::Conserve => "CONSERVE",
            NoiseReducerFilter::Gaussian => "GAUSSIAN",
            NoiseReducerFilter::Lanczos => "LANCZOS",
            NoiseReducerFilter::Mean => "MEAN",
            NoiseReducerFilter::Sharpen => "SHARPEN",
            NoiseReducerFilter::Spatial => "SPATIAL",
            NoiseReducerFilter::Temporal => "TEMPORAL",
            NoiseReducerFilter::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BILATERAL",
            "CONSERVE",
            "GAUSSIAN",
            "LANCZOS",
            "MEAN",
            "SHARPEN",
            "SPATIAL",
            "TEMPORAL",
        ]
    }
}
impl AsRef<str> for NoiseReducerFilter {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use the image inserter feature to include a graphic overlay on your video. Enable or disable this feature for each input or output individually. For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/graphic-overlay.html. This setting is disabled by default.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ImageInserter {
    /// Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
    pub insertable_images: std::option::Option<std::vec::Vec<crate::model::InsertableImage>>,
}
impl ImageInserter {
    /// Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
    pub fn insertable_images(&self) -> std::option::Option<&[crate::model::InsertableImage]> {
        self.insertable_images.as_deref()
    }
}
impl std::fmt::Debug for ImageInserter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ImageInserter");
        formatter.field("insertable_images", &self.insertable_images);
        formatter.finish()
    }
}
/// See [`ImageInserter`](crate::model::ImageInserter)
pub mod image_inserter {
    /// A builder for [`ImageInserter`](crate::model::ImageInserter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) insertable_images:
            std::option::Option<std::vec::Vec<crate::model::InsertableImage>>,
    }
    impl Builder {
        /// Appends an item to `insertable_images`.
        ///
        /// To override the contents of this collection use [`set_insertable_images`](Self::set_insertable_images).
        ///
        /// Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
        pub fn insertable_images(
            mut self,
            input: impl Into<crate::model::InsertableImage>,
        ) -> Self {
            let mut v = self.insertable_images.unwrap_or_default();
            v.push(input.into());
            self.insertable_images = Some(v);
            self
        }
        /// Specify the images that you want to overlay on your video. The images must be PNG or TGA files.
        pub fn set_insertable_images(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InsertableImage>>,
        ) -> Self {
            self.insertable_images = input;
            self
        }
        /// Consumes the builder and constructs a [`ImageInserter`](crate::model::ImageInserter)
        pub fn build(self) -> crate::model::ImageInserter {
            crate::model::ImageInserter {
                insertable_images: self.insertable_images,
            }
        }
    }
}
impl ImageInserter {
    /// Creates a new builder-style object to manufacture [`ImageInserter`](crate::model::ImageInserter)
    pub fn builder() -> crate::model::image_inserter::Builder {
        crate::model::image_inserter::Builder::default()
    }
}

/// These settings apply to a specific graphic overlay. You can include multiple overlays in your job.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InsertableImage {
    /// Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.
    pub duration: i32,
    /// Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
    pub fade_in: i32,
    /// Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
    pub fade_out: i32,
    /// Specify the height of the inserted image in pixels. If you specify a value that's larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.
    pub height: i32,
    /// Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.
    pub image_inserter_input: std::option::Option<std::string::String>,
    /// Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.
    pub image_x: i32,
    /// Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.
    pub image_y: i32,
    /// Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.
    pub layer: i32,
    /// Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.
    pub opacity: i32,
    /// Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
    pub start_time: std::option::Option<std::string::String>,
    /// Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.
    pub width: i32,
}
impl InsertableImage {
    /// Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.
    pub fn duration(&self) -> i32 {
        self.duration
    }
    /// Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
    pub fn fade_in(&self) -> i32 {
        self.fade_in
    }
    /// Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
    pub fn fade_out(&self) -> i32 {
        self.fade_out
    }
    /// Specify the height of the inserted image in pixels. If you specify a value that's larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.
    pub fn height(&self) -> i32 {
        self.height
    }
    /// Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.
    pub fn image_inserter_input(&self) -> std::option::Option<&str> {
        self.image_inserter_input.as_deref()
    }
    /// Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.
    pub fn image_x(&self) -> i32 {
        self.image_x
    }
    /// Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.
    pub fn image_y(&self) -> i32 {
        self.image_y
    }
    /// Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.
    pub fn layer(&self) -> i32 {
        self.layer
    }
    /// Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.
    pub fn opacity(&self) -> i32 {
        self.opacity
    }
    /// Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.
    pub fn width(&self) -> i32 {
        self.width
    }
}
impl std::fmt::Debug for InsertableImage {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InsertableImage");
        formatter.field("duration", &self.duration);
        formatter.field("fade_in", &self.fade_in);
        formatter.field("fade_out", &self.fade_out);
        formatter.field("height", &self.height);
        formatter.field("image_inserter_input", &self.image_inserter_input);
        formatter.field("image_x", &self.image_x);
        formatter.field("image_y", &self.image_y);
        formatter.field("layer", &self.layer);
        formatter.field("opacity", &self.opacity);
        formatter.field("start_time", &self.start_time);
        formatter.field("width", &self.width);
        formatter.finish()
    }
}
/// See [`InsertableImage`](crate::model::InsertableImage)
pub mod insertable_image {
    /// A builder for [`InsertableImage`](crate::model::InsertableImage)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) fade_in: std::option::Option<i32>,
        pub(crate) fade_out: std::option::Option<i32>,
        pub(crate) height: std::option::Option<i32>,
        pub(crate) image_inserter_input: std::option::Option<std::string::String>,
        pub(crate) image_x: std::option::Option<i32>,
        pub(crate) image_y: std::option::Option<i32>,
        pub(crate) layer: std::option::Option<i32>,
        pub(crate) opacity: std::option::Option<i32>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) width: std::option::Option<i32>,
    }
    impl Builder {
        /// Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// Specify the time, in milliseconds, for the image to remain on the output video. This duration includes fade-in time but not fade-out time.
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
        pub fn fade_in(mut self, input: i32) -> Self {
            self.fade_in = Some(input);
            self
        }
        /// Specify the length of time, in milliseconds, between the Start time that you specify for the image insertion and the time that the image appears at full opacity. Full opacity is the level that you specify for the opacity setting. If you don't specify a value for Fade-in, the image will appear abruptly at the overlay start time.
        pub fn set_fade_in(mut self, input: std::option::Option<i32>) -> Self {
            self.fade_in = input;
            self
        }
        /// Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
        pub fn fade_out(mut self, input: i32) -> Self {
            self.fade_out = Some(input);
            self
        }
        /// Specify the length of time, in milliseconds, between the end of the time that you have specified for the image overlay Duration and when the overlaid image has faded to total transparency. If you don't specify a value for Fade-out, the image will disappear abruptly at the end of the inserted image duration.
        pub fn set_fade_out(mut self, input: std::option::Option<i32>) -> Self {
            self.fade_out = input;
            self
        }
        /// Specify the height of the inserted image in pixels. If you specify a value that's larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// Specify the height of the inserted image in pixels. If you specify a value that's larger than the video resolution height, the service will crop your overlaid image to fit. To use the native height of the image, keep this setting blank.
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.
        pub fn image_inserter_input(mut self, input: impl Into<std::string::String>) -> Self {
            self.image_inserter_input = Some(input.into());
            self
        }
        /// Specify the HTTP, HTTPS, or Amazon S3 location of the image that you want to overlay on the video. Use a PNG or TGA file.
        pub fn set_image_inserter_input(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.image_inserter_input = input;
            self
        }
        /// Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.
        pub fn image_x(mut self, input: i32) -> Self {
            self.image_x = Some(input);
            self
        }
        /// Specify the distance, in pixels, between the inserted image and the left edge of the video frame. Required for any image overlay that you specify.
        pub fn set_image_x(mut self, input: std::option::Option<i32>) -> Self {
            self.image_x = input;
            self
        }
        /// Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.
        pub fn image_y(mut self, input: i32) -> Self {
            self.image_y = Some(input);
            self
        }
        /// Specify the distance, in pixels, between the overlaid image and the top edge of the video frame. Required for any image overlay that you specify.
        pub fn set_image_y(mut self, input: std::option::Option<i32>) -> Self {
            self.image_y = input;
            self
        }
        /// Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.
        pub fn layer(mut self, input: i32) -> Self {
            self.layer = Some(input);
            self
        }
        /// Specify how overlapping inserted images appear. Images with higher values for Layer appear on top of images with lower values for Layer.
        pub fn set_layer(mut self, input: std::option::Option<i32>) -> Self {
            self.layer = input;
            self
        }
        /// Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.
        pub fn opacity(mut self, input: i32) -> Self {
            self.opacity = Some(input);
            self
        }
        /// Use Opacity (Opacity) to specify how much of the underlying video shows through the inserted image. 0 is transparent and 100 is fully opaque. Default is 50.
        pub fn set_opacity(mut self, input: std::option::Option<i32>) -> Self {
            self.opacity = input;
            self
        }
        /// Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// Specify the timecode of the frame that you want the overlay to first appear on. This must be in timecode (HH:MM:SS:FF or HH:MM:SS;FF) format. Remember to take into account your timecode source settings.
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// Specify the width of the inserted image in pixels. If you specify a value that's larger than the video resolution width, the service will crop your overlaid image to fit. To use the native width of the image, keep this setting blank.
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// Consumes the builder and constructs a [`InsertableImage`](crate::model::InsertableImage)
        pub fn build(self) -> crate::model::InsertableImage {
            crate::model::InsertableImage {
                duration: self.duration.unwrap_or_default(),
                fade_in: self.fade_in.unwrap_or_default(),
                fade_out: self.fade_out.unwrap_or_default(),
                height: self.height.unwrap_or_default(),
                image_inserter_input: self.image_inserter_input,
                image_x: self.image_x.unwrap_or_default(),
                image_y: self.image_y.unwrap_or_default(),
                layer: self.layer.unwrap_or_default(),
                opacity: self.opacity.unwrap_or_default(),
                start_time: self.start_time,
                width: self.width.unwrap_or_default(),
            }
        }
    }
}
impl InsertableImage {
    /// Creates a new builder-style object to manufacture [`InsertableImage`](crate::model::InsertableImage)
    pub fn builder() -> crate::model::insertable_image::Builder {
        crate::model::insertable_image::Builder::default()
    }
}

/// Setting for HDR10+ metadata insertion
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hdr10Plus {
    /// Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual peak luminance of the mastering display, as defined by ST 2094-40.
    pub mastering_monitor_nits: i32,
    /// Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance of the target display as defined by ST 2094-40.
    pub target_monitor_nits: i32,
}
impl Hdr10Plus {
    /// Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual peak luminance of the mastering display, as defined by ST 2094-40.
    pub fn mastering_monitor_nits(&self) -> i32 {
        self.mastering_monitor_nits
    }
    /// Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance of the target display as defined by ST 2094-40.
    pub fn target_monitor_nits(&self) -> i32 {
        self.target_monitor_nits
    }
}
impl std::fmt::Debug for Hdr10Plus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hdr10Plus");
        formatter.field("mastering_monitor_nits", &self.mastering_monitor_nits);
        formatter.field("target_monitor_nits", &self.target_monitor_nits);
        formatter.finish()
    }
}
/// See [`Hdr10Plus`](crate::model::Hdr10Plus)
pub mod hdr10_plus {
    /// A builder for [`Hdr10Plus`](crate::model::Hdr10Plus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) mastering_monitor_nits: std::option::Option<i32>,
        pub(crate) target_monitor_nits: std::option::Option<i32>,
    }
    impl Builder {
        /// Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual peak luminance of the mastering display, as defined by ST 2094-40.
        pub fn mastering_monitor_nits(mut self, input: i32) -> Self {
            self.mastering_monitor_nits = Some(input);
            self
        }
        /// Specify the HDR10+ mastering display normalized peak luminance, in nits. This is the normalized actual peak luminance of the mastering display, as defined by ST 2094-40.
        pub fn set_mastering_monitor_nits(mut self, input: std::option::Option<i32>) -> Self {
            self.mastering_monitor_nits = input;
            self
        }
        /// Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance of the target display as defined by ST 2094-40.
        pub fn target_monitor_nits(mut self, input: i32) -> Self {
            self.target_monitor_nits = Some(input);
            self
        }
        /// Specify the HDR10+ target display nominal peak luminance, in nits. This is the nominal maximum luminance of the target display as defined by ST 2094-40.
        pub fn set_target_monitor_nits(mut self, input: std::option::Option<i32>) -> Self {
            self.target_monitor_nits = input;
            self
        }
        /// Consumes the builder and constructs a [`Hdr10Plus`](crate::model::Hdr10Plus)
        pub fn build(self) -> crate::model::Hdr10Plus {
            crate::model::Hdr10Plus {
                mastering_monitor_nits: self.mastering_monitor_nits.unwrap_or_default(),
                target_monitor_nits: self.target_monitor_nits.unwrap_or_default(),
            }
        }
    }
}
impl Hdr10Plus {
    /// Creates a new builder-style object to manufacture [`Hdr10Plus`](crate::model::Hdr10Plus)
    pub fn builder() -> crate::model::hdr10_plus::Builder {
        crate::model::hdr10_plus::Builder::default()
    }
}

/// With AWS Elemental MediaConvert, you can create profile 5 Dolby Vision outputs from MXF and IMF sources that contain mastering information as frame-interleaved Dolby Vision metadata.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DolbyVision {
    /// Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.
    pub l6_metadata: std::option::Option<crate::model::DolbyVisionLevel6Metadata>,
    /// Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
    pub l6_mode: std::option::Option<crate::model::DolbyVisionLevel6Mode>,
    /// In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.
    pub profile: std::option::Option<crate::model::DolbyVisionProfile>,
}
impl DolbyVision {
    /// Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.
    pub fn l6_metadata(&self) -> std::option::Option<&crate::model::DolbyVisionLevel6Metadata> {
        self.l6_metadata.as_ref()
    }
    /// Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
    pub fn l6_mode(&self) -> std::option::Option<&crate::model::DolbyVisionLevel6Mode> {
        self.l6_mode.as_ref()
    }
    /// In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.
    pub fn profile(&self) -> std::option::Option<&crate::model::DolbyVisionProfile> {
        self.profile.as_ref()
    }
}
impl std::fmt::Debug for DolbyVision {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DolbyVision");
        formatter.field("l6_metadata", &self.l6_metadata);
        formatter.field("l6_mode", &self.l6_mode);
        formatter.field("profile", &self.profile);
        formatter.finish()
    }
}
/// See [`DolbyVision`](crate::model::DolbyVision)
pub mod dolby_vision {
    /// A builder for [`DolbyVision`](crate::model::DolbyVision)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) l6_metadata: std::option::Option<crate::model::DolbyVisionLevel6Metadata>,
        pub(crate) l6_mode: std::option::Option<crate::model::DolbyVisionLevel6Mode>,
        pub(crate) profile: std::option::Option<crate::model::DolbyVisionProfile>,
    }
    impl Builder {
        /// Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.
        pub fn l6_metadata(mut self, input: crate::model::DolbyVisionLevel6Metadata) -> Self {
            self.l6_metadata = Some(input);
            self
        }
        /// Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.
        pub fn set_l6_metadata(
            mut self,
            input: std::option::Option<crate::model::DolbyVisionLevel6Metadata>,
        ) -> Self {
            self.l6_metadata = input;
            self
        }
        /// Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
        pub fn l6_mode(mut self, input: crate::model::DolbyVisionLevel6Mode) -> Self {
            self.l6_mode = Some(input);
            self
        }
        /// Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
        pub fn set_l6_mode(
            mut self,
            input: std::option::Option<crate::model::DolbyVisionLevel6Mode>,
        ) -> Self {
            self.l6_mode = input;
            self
        }
        /// In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.
        pub fn profile(mut self, input: crate::model::DolbyVisionProfile) -> Self {
            self.profile = Some(input);
            self
        }
        /// In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.
        pub fn set_profile(
            mut self,
            input: std::option::Option<crate::model::DolbyVisionProfile>,
        ) -> Self {
            self.profile = input;
            self
        }
        /// Consumes the builder and constructs a [`DolbyVision`](crate::model::DolbyVision)
        pub fn build(self) -> crate::model::DolbyVision {
            crate::model::DolbyVision {
                l6_metadata: self.l6_metadata,
                l6_mode: self.l6_mode,
                profile: self.profile,
            }
        }
    }
}
impl DolbyVision {
    /// Creates a new builder-style object to manufacture [`DolbyVision`](crate::model::DolbyVision)
    pub fn builder() -> crate::model::dolby_vision::Builder {
        crate::model::dolby_vision::Builder::default()
    }
}

/// In the current MediaConvert implementation, the Dolby Vision profile is always 5 (PROFILE_5). Therefore, all of your inputs must contain Dolby Vision frame interleaved data.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DolbyVisionProfile {
    #[allow(missing_docs)] // documentation missing in model
    Profile5,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DolbyVisionProfile {
    fn from(s: &str) -> Self {
        match s {
            "PROFILE_5" => DolbyVisionProfile::Profile5,
            other => DolbyVisionProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DolbyVisionProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DolbyVisionProfile::from(s))
    }
}
impl DolbyVisionProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DolbyVisionProfile::Profile5 => "PROFILE_5",
            DolbyVisionProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PROFILE_5"]
    }
}
impl AsRef<str> for DolbyVisionProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Dolby Vision Mode to choose how the service will handle Dolby Vision MaxCLL and MaxFALL properies.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DolbyVisionLevel6Mode {
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    #[allow(missing_docs)] // documentation missing in model
    Recalculate,
    #[allow(missing_docs)] // documentation missing in model
    Specify,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DolbyVisionLevel6Mode {
    fn from(s: &str) -> Self {
        match s {
            "PASSTHROUGH" => DolbyVisionLevel6Mode::Passthrough,
            "RECALCULATE" => DolbyVisionLevel6Mode::Recalculate,
            "SPECIFY" => DolbyVisionLevel6Mode::Specify,
            other => DolbyVisionLevel6Mode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DolbyVisionLevel6Mode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DolbyVisionLevel6Mode::from(s))
    }
}
impl DolbyVisionLevel6Mode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DolbyVisionLevel6Mode::Passthrough => "PASSTHROUGH",
            DolbyVisionLevel6Mode::Recalculate => "RECALCULATE",
            DolbyVisionLevel6Mode::Specify => "SPECIFY",
            DolbyVisionLevel6Mode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PASSTHROUGH", "RECALCULATE", "SPECIFY"]
    }
}
impl AsRef<str> for DolbyVisionLevel6Mode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use these settings when you set DolbyVisionLevel6Mode to SPECIFY to override the MaxCLL and MaxFALL values in your input with new values.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DolbyVisionLevel6Metadata {
    /// Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire stream. Measured in nits.
    pub max_cll: i32,
    /// Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average brightness in the entire stream. Measured in nits.
    pub max_fall: i32,
}
impl DolbyVisionLevel6Metadata {
    /// Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire stream. Measured in nits.
    pub fn max_cll(&self) -> i32 {
        self.max_cll
    }
    /// Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average brightness in the entire stream. Measured in nits.
    pub fn max_fall(&self) -> i32 {
        self.max_fall
    }
}
impl std::fmt::Debug for DolbyVisionLevel6Metadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DolbyVisionLevel6Metadata");
        formatter.field("max_cll", &self.max_cll);
        formatter.field("max_fall", &self.max_fall);
        formatter.finish()
    }
}
/// See [`DolbyVisionLevel6Metadata`](crate::model::DolbyVisionLevel6Metadata)
pub mod dolby_vision_level6_metadata {
    /// A builder for [`DolbyVisionLevel6Metadata`](crate::model::DolbyVisionLevel6Metadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_cll: std::option::Option<i32>,
        pub(crate) max_fall: std::option::Option<i32>,
    }
    impl Builder {
        /// Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire stream. Measured in nits.
        pub fn max_cll(mut self, input: i32) -> Self {
            self.max_cll = Some(input);
            self
        }
        /// Maximum Content Light Level. Static HDR metadata that corresponds to the brightest pixel in the entire stream. Measured in nits.
        pub fn set_max_cll(mut self, input: std::option::Option<i32>) -> Self {
            self.max_cll = input;
            self
        }
        /// Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average brightness in the entire stream. Measured in nits.
        pub fn max_fall(mut self, input: i32) -> Self {
            self.max_fall = Some(input);
            self
        }
        /// Maximum Frame-Average Light Level. Static HDR metadata that corresponds to the highest frame-average brightness in the entire stream. Measured in nits.
        pub fn set_max_fall(mut self, input: std::option::Option<i32>) -> Self {
            self.max_fall = input;
            self
        }
        /// Consumes the builder and constructs a [`DolbyVisionLevel6Metadata`](crate::model::DolbyVisionLevel6Metadata)
        pub fn build(self) -> crate::model::DolbyVisionLevel6Metadata {
            crate::model::DolbyVisionLevel6Metadata {
                max_cll: self.max_cll.unwrap_or_default(),
                max_fall: self.max_fall.unwrap_or_default(),
            }
        }
    }
}
impl DolbyVisionLevel6Metadata {
    /// Creates a new builder-style object to manufacture [`DolbyVisionLevel6Metadata`](crate::model::DolbyVisionLevel6Metadata)
    pub fn builder() -> crate::model::dolby_vision_level6_metadata::Builder {
        crate::model::dolby_vision_level6_metadata::Builder::default()
    }
}

/// Settings for deinterlacer
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Deinterlacer {
    /// Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.
    pub algorithm: std::option::Option<crate::model::DeinterlaceAlgorithm>,
    /// - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged  in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is  a good chance that the metadata has tagged frames as progressive when they are not  progressive. Do not turn on otherwise; processing frames that are already progressive  into progressive will probably result in lower quality video.
    pub control: std::option::Option<crate::model::DeinterlacerControl>,
    /// Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
    pub mode: std::option::Option<crate::model::DeinterlacerMode>,
}
impl Deinterlacer {
    /// Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.
    pub fn algorithm(&self) -> std::option::Option<&crate::model::DeinterlaceAlgorithm> {
        self.algorithm.as_ref()
    }
    /// - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged  in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is  a good chance that the metadata has tagged frames as progressive when they are not  progressive. Do not turn on otherwise; processing frames that are already progressive  into progressive will probably result in lower quality video.
    pub fn control(&self) -> std::option::Option<&crate::model::DeinterlacerControl> {
        self.control.as_ref()
    }
    /// Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
    pub fn mode(&self) -> std::option::Option<&crate::model::DeinterlacerMode> {
        self.mode.as_ref()
    }
}
impl std::fmt::Debug for Deinterlacer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Deinterlacer");
        formatter.field("algorithm", &self.algorithm);
        formatter.field("control", &self.control);
        formatter.field("mode", &self.mode);
        formatter.finish()
    }
}
/// See [`Deinterlacer`](crate::model::Deinterlacer)
pub mod deinterlacer {
    /// A builder for [`Deinterlacer`](crate::model::Deinterlacer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm: std::option::Option<crate::model::DeinterlaceAlgorithm>,
        pub(crate) control: std::option::Option<crate::model::DeinterlacerControl>,
        pub(crate) mode: std::option::Option<crate::model::DeinterlacerMode>,
    }
    impl Builder {
        /// Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.
        pub fn algorithm(mut self, input: crate::model::DeinterlaceAlgorithm) -> Self {
            self.algorithm = Some(input);
            self
        }
        /// Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.
        pub fn set_algorithm(
            mut self,
            input: std::option::Option<crate::model::DeinterlaceAlgorithm>,
        ) -> Self {
            self.algorithm = input;
            self
        }
        /// - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged  in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is  a good chance that the metadata has tagged frames as progressive when they are not  progressive. Do not turn on otherwise; processing frames that are already progressive  into progressive will probably result in lower quality video.
        pub fn control(mut self, input: crate::model::DeinterlacerControl) -> Self {
            self.control = Some(input);
            self
        }
        /// - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged  in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is  a good chance that the metadata has tagged frames as progressive when they are not  progressive. Do not turn on otherwise; processing frames that are already progressive  into progressive will probably result in lower quality video.
        pub fn set_control(
            mut self,
            input: std::option::Option<crate::model::DeinterlacerControl>,
        ) -> Self {
            self.control = input;
            self
        }
        /// Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
        pub fn mode(mut self, input: crate::model::DeinterlacerMode) -> Self {
            self.mode = Some(input);
            self
        }
        /// Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DeinterlacerMode>,
        ) -> Self {
            self.mode = input;
            self
        }
        /// Consumes the builder and constructs a [`Deinterlacer`](crate::model::Deinterlacer)
        pub fn build(self) -> crate::model::Deinterlacer {
            crate::model::Deinterlacer {
                algorithm: self.algorithm,
                control: self.control,
                mode: self.mode,
            }
        }
    }
}
impl Deinterlacer {
    /// Creates a new builder-style object to manufacture [`Deinterlacer`](crate::model::Deinterlacer)
    pub fn builder() -> crate::model::deinterlacer::Builder {
        crate::model::deinterlacer::Builder::default()
    }
}

/// Use Deinterlacer (DeinterlaceMode) to choose how the service will do deinterlacing. Default is Deinterlace. - Deinterlace converts interlaced to progressive. - Inverse telecine converts Hard Telecine 29.97i to progressive 23.976p. - Adaptive auto-detects and converts to progressive.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeinterlacerMode {
    #[allow(missing_docs)] // documentation missing in model
    Adaptive,
    #[allow(missing_docs)] // documentation missing in model
    Deinterlace,
    #[allow(missing_docs)] // documentation missing in model
    InverseTelecine,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeinterlacerMode {
    fn from(s: &str) -> Self {
        match s {
            "ADAPTIVE" => DeinterlacerMode::Adaptive,
            "DEINTERLACE" => DeinterlacerMode::Deinterlace,
            "INVERSE_TELECINE" => DeinterlacerMode::InverseTelecine,
            other => DeinterlacerMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeinterlacerMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeinterlacerMode::from(s))
    }
}
impl DeinterlacerMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeinterlacerMode::Adaptive => "ADAPTIVE",
            DeinterlacerMode::Deinterlace => "DEINTERLACE",
            DeinterlacerMode::InverseTelecine => "INVERSE_TELECINE",
            DeinterlacerMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADAPTIVE", "DEINTERLACE", "INVERSE_TELECINE"]
    }
}
impl AsRef<str> for DeinterlacerMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// - When set to NORMAL (default), the deinterlacer does not convert frames that are tagged  in metadata as progressive. It will only convert those that are tagged as some other type. - When set to FORCE_ALL_FRAMES, the deinterlacer converts every frame to progressive - even those that are already tagged as progressive. Turn Force mode on only if there is  a good chance that the metadata has tagged frames as progressive when they are not  progressive. Do not turn on otherwise; processing frames that are already progressive  into progressive will probably result in lower quality video.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeinterlacerControl {
    #[allow(missing_docs)] // documentation missing in model
    ForceAllFrames,
    #[allow(missing_docs)] // documentation missing in model
    Normal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeinterlacerControl {
    fn from(s: &str) -> Self {
        match s {
            "FORCE_ALL_FRAMES" => DeinterlacerControl::ForceAllFrames,
            "NORMAL" => DeinterlacerControl::Normal,
            other => DeinterlacerControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeinterlacerControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeinterlacerControl::from(s))
    }
}
impl DeinterlacerControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeinterlacerControl::ForceAllFrames => "FORCE_ALL_FRAMES",
            DeinterlacerControl::Normal => "NORMAL",
            DeinterlacerControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FORCE_ALL_FRAMES", "NORMAL"]
    }
}
impl AsRef<str> for DeinterlacerControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Only applies when you set Deinterlacer (DeinterlaceMode) to Deinterlace (DEINTERLACE) or Adaptive (ADAPTIVE). Motion adaptive interpolate (INTERPOLATE) produces sharper pictures, while blend (BLEND) produces smoother motion. Use (INTERPOLATE_TICKER) OR (BLEND_TICKER) if your source file includes a ticker, such as a scrolling headline at the bottom of the frame.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DeinterlaceAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    Blend,
    #[allow(missing_docs)] // documentation missing in model
    BlendTicker,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    #[allow(missing_docs)] // documentation missing in model
    InterpolateTicker,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DeinterlaceAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "BLEND" => DeinterlaceAlgorithm::Blend,
            "BLEND_TICKER" => DeinterlaceAlgorithm::BlendTicker,
            "INTERPOLATE" => DeinterlaceAlgorithm::Interpolate,
            "INTERPOLATE_TICKER" => DeinterlaceAlgorithm::InterpolateTicker,
            other => DeinterlaceAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DeinterlaceAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DeinterlaceAlgorithm::from(s))
    }
}
impl DeinterlaceAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DeinterlaceAlgorithm::Blend => "BLEND",
            DeinterlaceAlgorithm::BlendTicker => "BLEND_TICKER",
            DeinterlaceAlgorithm::Interpolate => "INTERPOLATE",
            DeinterlaceAlgorithm::InterpolateTicker => "INTERPOLATE_TICKER",
            DeinterlaceAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BLEND", "BLEND_TICKER", "INTERPOLATE", "INTERPOLATE_TICKER"]
    }
}
impl AsRef<str> for DeinterlaceAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Settings for color correction.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ColorCorrector {
    /// Brightness level.
    pub brightness: i32,
    /// Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
    pub color_space_conversion: std::option::Option<crate::model::ColorSpaceConversion>,
    /// Contrast level.
    pub contrast: i32,
    /// Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
    pub hdr10_metadata: std::option::Option<crate::model::Hdr10Metadata>,
    /// Hue in degrees.
    pub hue: i32,
    /// Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
    pub sample_range_conversion: std::option::Option<crate::model::SampleRangeConversion>,
    /// Saturation level.
    pub saturation: i32,
}
impl ColorCorrector {
    /// Brightness level.
    pub fn brightness(&self) -> i32 {
        self.brightness
    }
    /// Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
    pub fn color_space_conversion(
        &self,
    ) -> std::option::Option<&crate::model::ColorSpaceConversion> {
        self.color_space_conversion.as_ref()
    }
    /// Contrast level.
    pub fn contrast(&self) -> i32 {
        self.contrast
    }
    /// Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
    pub fn hdr10_metadata(&self) -> std::option::Option<&crate::model::Hdr10Metadata> {
        self.hdr10_metadata.as_ref()
    }
    /// Hue in degrees.
    pub fn hue(&self) -> i32 {
        self.hue
    }
    /// Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
    pub fn sample_range_conversion(
        &self,
    ) -> std::option::Option<&crate::model::SampleRangeConversion> {
        self.sample_range_conversion.as_ref()
    }
    /// Saturation level.
    pub fn saturation(&self) -> i32 {
        self.saturation
    }
}
impl std::fmt::Debug for ColorCorrector {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ColorCorrector");
        formatter.field("brightness", &self.brightness);
        formatter.field("color_space_conversion", &self.color_space_conversion);
        formatter.field("contrast", &self.contrast);
        formatter.field("hdr10_metadata", &self.hdr10_metadata);
        formatter.field("hue", &self.hue);
        formatter.field("sample_range_conversion", &self.sample_range_conversion);
        formatter.field("saturation", &self.saturation);
        formatter.finish()
    }
}
/// See [`ColorCorrector`](crate::model::ColorCorrector)
pub mod color_corrector {
    /// A builder for [`ColorCorrector`](crate::model::ColorCorrector)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) brightness: std::option::Option<i32>,
        pub(crate) color_space_conversion: std::option::Option<crate::model::ColorSpaceConversion>,
        pub(crate) contrast: std::option::Option<i32>,
        pub(crate) hdr10_metadata: std::option::Option<crate::model::Hdr10Metadata>,
        pub(crate) hue: std::option::Option<i32>,
        pub(crate) sample_range_conversion:
            std::option::Option<crate::model::SampleRangeConversion>,
        pub(crate) saturation: std::option::Option<i32>,
    }
    impl Builder {
        /// Brightness level.
        pub fn brightness(mut self, input: i32) -> Self {
            self.brightness = Some(input);
            self
        }
        /// Brightness level.
        pub fn set_brightness(mut self, input: std::option::Option<i32>) -> Self {
            self.brightness = input;
            self
        }
        /// Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
        pub fn color_space_conversion(mut self, input: crate::model::ColorSpaceConversion) -> Self {
            self.color_space_conversion = Some(input);
            self
        }
        /// Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
        pub fn set_color_space_conversion(
            mut self,
            input: std::option::Option<crate::model::ColorSpaceConversion>,
        ) -> Self {
            self.color_space_conversion = input;
            self
        }
        /// Contrast level.
        pub fn contrast(mut self, input: i32) -> Self {
            self.contrast = Some(input);
            self
        }
        /// Contrast level.
        pub fn set_contrast(mut self, input: std::option::Option<i32>) -> Self {
            self.contrast = input;
            self
        }
        /// Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
        pub fn hdr10_metadata(mut self, input: crate::model::Hdr10Metadata) -> Self {
            self.hdr10_metadata = Some(input);
            self
        }
        /// Use these settings when you convert to the HDR 10 color space. Specify the SMPTE ST 2086 Mastering Display Color Volume static metadata that you want signaled in the output. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator. When you set Color space conversion (ColorSpaceConversion) to HDR 10 (FORCE_HDR10), these settings are required. You must set values for Max frame average light level (maxFrameAverageLightLevel) and Max content light level (maxContentLightLevel); these settings don't have a default value. The default values for the other HDR 10 metadata settings are defined by the P3D65 color space. For more information about MediaConvert HDR jobs, see https://docs.aws.amazon.com/console/mediaconvert/hdr.
        pub fn set_hdr10_metadata(
            mut self,
            input: std::option::Option<crate::model::Hdr10Metadata>,
        ) -> Self {
            self.hdr10_metadata = input;
            self
        }
        /// Hue in degrees.
        pub fn hue(mut self, input: i32) -> Self {
            self.hue = Some(input);
            self
        }
        /// Hue in degrees.
        pub fn set_hue(mut self, input: std::option::Option<i32>) -> Self {
            self.hue = input;
            self
        }
        /// Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
        pub fn sample_range_conversion(
            mut self,
            input: crate::model::SampleRangeConversion,
        ) -> Self {
            self.sample_range_conversion = Some(input);
            self
        }
        /// Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
        pub fn set_sample_range_conversion(
            mut self,
            input: std::option::Option<crate::model::SampleRangeConversion>,
        ) -> Self {
            self.sample_range_conversion = input;
            self
        }
        /// Saturation level.
        pub fn saturation(mut self, input: i32) -> Self {
            self.saturation = Some(input);
            self
        }
        /// Saturation level.
        pub fn set_saturation(mut self, input: std::option::Option<i32>) -> Self {
            self.saturation = input;
            self
        }
        /// Consumes the builder and constructs a [`ColorCorrector`](crate::model::ColorCorrector)
        pub fn build(self) -> crate::model::ColorCorrector {
            crate::model::ColorCorrector {
                brightness: self.brightness.unwrap_or_default(),
                color_space_conversion: self.color_space_conversion,
                contrast: self.contrast.unwrap_or_default(),
                hdr10_metadata: self.hdr10_metadata,
                hue: self.hue.unwrap_or_default(),
                sample_range_conversion: self.sample_range_conversion,
                saturation: self.saturation.unwrap_or_default(),
            }
        }
    }
}
impl ColorCorrector {
    /// Creates a new builder-style object to manufacture [`ColorCorrector`](crate::model::ColorCorrector)
    pub fn builder() -> crate::model::color_corrector::Builder {
        crate::model::color_corrector::Builder::default()
    }
}

/// Specify the video color sample range for this output. To create a full range output, you must start with a full range YUV input and keep the default value, None (NONE). To create a limited range output from a full range input, choose Limited range (LIMITED_RANGE_SQUEEZE). With RGB inputs, your output is always limited range, regardless of your choice here. When you create a limited range output from a full range input, MediaConvert limits the active pixel values in a way that depends on the output's bit depth: 8-bit outputs contain only values from 16 through 235 and 10-bit outputs contain only values from 64 through 940. With this conversion, MediaConvert also changes the output metadata to note the limited range.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SampleRangeConversion {
    #[allow(missing_docs)] // documentation missing in model
    LimitedRangeSqueeze,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SampleRangeConversion {
    fn from(s: &str) -> Self {
        match s {
            "LIMITED_RANGE_SQUEEZE" => SampleRangeConversion::LimitedRangeSqueeze,
            "NONE" => SampleRangeConversion::None,
            other => SampleRangeConversion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SampleRangeConversion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SampleRangeConversion::from(s))
    }
}
impl SampleRangeConversion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SampleRangeConversion::LimitedRangeSqueeze => "LIMITED_RANGE_SQUEEZE",
            SampleRangeConversion::None => "NONE",
            SampleRangeConversion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["LIMITED_RANGE_SQUEEZE", "NONE"]
    }
}
impl AsRef<str> for SampleRangeConversion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use these settings to specify static color calibration metadata, as defined by SMPTE ST 2086. These values don't affect the pixel values that are encoded in the video stream. They are intended to help the downstream video player display content in a way that reflects the intentions of the the content creator.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Hdr10Metadata {
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub blue_primary_x: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub blue_primary_y: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub green_primary_x: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub green_primary_y: i32,
    /// Maximum light level among all samples in the coded video sequence, in units of candelas per square meter.  This setting doesn't have a default value; you must specify a value that is suitable for the content.
    pub max_content_light_level: i32,
    /// Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter. This setting doesn't have a default value; you must specify a value that is suitable for the content.
    pub max_frame_average_light_level: i32,
    /// Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
    pub max_luminance: i32,
    /// Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
    pub min_luminance: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub red_primary_x: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub red_primary_y: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub white_point_x: i32,
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub white_point_y: i32,
}
impl Hdr10Metadata {
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn blue_primary_x(&self) -> i32 {
        self.blue_primary_x
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn blue_primary_y(&self) -> i32 {
        self.blue_primary_y
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn green_primary_x(&self) -> i32 {
        self.green_primary_x
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn green_primary_y(&self) -> i32 {
        self.green_primary_y
    }
    /// Maximum light level among all samples in the coded video sequence, in units of candelas per square meter.  This setting doesn't have a default value; you must specify a value that is suitable for the content.
    pub fn max_content_light_level(&self) -> i32 {
        self.max_content_light_level
    }
    /// Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter. This setting doesn't have a default value; you must specify a value that is suitable for the content.
    pub fn max_frame_average_light_level(&self) -> i32 {
        self.max_frame_average_light_level
    }
    /// Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
    pub fn max_luminance(&self) -> i32 {
        self.max_luminance
    }
    /// Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
    pub fn min_luminance(&self) -> i32 {
        self.min_luminance
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn red_primary_x(&self) -> i32 {
        self.red_primary_x
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn red_primary_y(&self) -> i32 {
        self.red_primary_y
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn white_point_x(&self) -> i32 {
        self.white_point_x
    }
    /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
    pub fn white_point_y(&self) -> i32 {
        self.white_point_y
    }
}
impl std::fmt::Debug for Hdr10Metadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Hdr10Metadata");
        formatter.field("blue_primary_x", &self.blue_primary_x);
        formatter.field("blue_primary_y", &self.blue_primary_y);
        formatter.field("green_primary_x", &self.green_primary_x);
        formatter.field("green_primary_y", &self.green_primary_y);
        formatter.field("max_content_light_level", &self.max_content_light_level);
        formatter.field(
            "max_frame_average_light_level",
            &self.max_frame_average_light_level,
        );
        formatter.field("max_luminance", &self.max_luminance);
        formatter.field("min_luminance", &self.min_luminance);
        formatter.field("red_primary_x", &self.red_primary_x);
        formatter.field("red_primary_y", &self.red_primary_y);
        formatter.field("white_point_x", &self.white_point_x);
        formatter.field("white_point_y", &self.white_point_y);
        formatter.finish()
    }
}
/// See [`Hdr10Metadata`](crate::model::Hdr10Metadata)
pub mod hdr10_metadata {
    /// A builder for [`Hdr10Metadata`](crate::model::Hdr10Metadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) blue_primary_x: std::option::Option<i32>,
        pub(crate) blue_primary_y: std::option::Option<i32>,
        pub(crate) green_primary_x: std::option::Option<i32>,
        pub(crate) green_primary_y: std::option::Option<i32>,
        pub(crate) max_content_light_level: std::option::Option<i32>,
        pub(crate) max_frame_average_light_level: std::option::Option<i32>,
        pub(crate) max_luminance: std::option::Option<i32>,
        pub(crate) min_luminance: std::option::Option<i32>,
        pub(crate) red_primary_x: std::option::Option<i32>,
        pub(crate) red_primary_y: std::option::Option<i32>,
        pub(crate) white_point_x: std::option::Option<i32>,
        pub(crate) white_point_y: std::option::Option<i32>,
    }
    impl Builder {
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn blue_primary_x(mut self, input: i32) -> Self {
            self.blue_primary_x = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_blue_primary_x(mut self, input: std::option::Option<i32>) -> Self {
            self.blue_primary_x = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn blue_primary_y(mut self, input: i32) -> Self {
            self.blue_primary_y = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_blue_primary_y(mut self, input: std::option::Option<i32>) -> Self {
            self.blue_primary_y = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn green_primary_x(mut self, input: i32) -> Self {
            self.green_primary_x = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_green_primary_x(mut self, input: std::option::Option<i32>) -> Self {
            self.green_primary_x = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn green_primary_y(mut self, input: i32) -> Self {
            self.green_primary_y = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_green_primary_y(mut self, input: std::option::Option<i32>) -> Self {
            self.green_primary_y = input;
            self
        }
        /// Maximum light level among all samples in the coded video sequence, in units of candelas per square meter.  This setting doesn't have a default value; you must specify a value that is suitable for the content.
        pub fn max_content_light_level(mut self, input: i32) -> Self {
            self.max_content_light_level = Some(input);
            self
        }
        /// Maximum light level among all samples in the coded video sequence, in units of candelas per square meter.  This setting doesn't have a default value; you must specify a value that is suitable for the content.
        pub fn set_max_content_light_level(mut self, input: std::option::Option<i32>) -> Self {
            self.max_content_light_level = input;
            self
        }
        /// Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter. This setting doesn't have a default value; you must specify a value that is suitable for the content.
        pub fn max_frame_average_light_level(mut self, input: i32) -> Self {
            self.max_frame_average_light_level = Some(input);
            self
        }
        /// Maximum average light level of any frame in the coded video sequence, in units of candelas per square meter. This setting doesn't have a default value; you must specify a value that is suitable for the content.
        pub fn set_max_frame_average_light_level(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.max_frame_average_light_level = input;
            self
        }
        /// Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
        pub fn max_luminance(mut self, input: i32) -> Self {
            self.max_luminance = Some(input);
            self
        }
        /// Nominal maximum mastering display luminance in units of of 0.0001 candelas per square meter.
        pub fn set_max_luminance(mut self, input: std::option::Option<i32>) -> Self {
            self.max_luminance = input;
            self
        }
        /// Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
        pub fn min_luminance(mut self, input: i32) -> Self {
            self.min_luminance = Some(input);
            self
        }
        /// Nominal minimum mastering display luminance in units of of 0.0001 candelas per square meter
        pub fn set_min_luminance(mut self, input: std::option::Option<i32>) -> Self {
            self.min_luminance = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn red_primary_x(mut self, input: i32) -> Self {
            self.red_primary_x = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_red_primary_x(mut self, input: std::option::Option<i32>) -> Self {
            self.red_primary_x = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn red_primary_y(mut self, input: i32) -> Self {
            self.red_primary_y = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_red_primary_y(mut self, input: std::option::Option<i32>) -> Self {
            self.red_primary_y = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn white_point_x(mut self, input: i32) -> Self {
            self.white_point_x = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_white_point_x(mut self, input: std::option::Option<i32>) -> Self {
            self.white_point_x = input;
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn white_point_y(mut self, input: i32) -> Self {
            self.white_point_y = Some(input);
            self
        }
        /// HDR Master Display Information must be provided by a color grader, using color grading tools. Range is 0 to 50,000, each increment represents 0.00002 in CIE1931 color coordinate. Note that this setting is not for color correction.
        pub fn set_white_point_y(mut self, input: std::option::Option<i32>) -> Self {
            self.white_point_y = input;
            self
        }
        /// Consumes the builder and constructs a [`Hdr10Metadata`](crate::model::Hdr10Metadata)
        pub fn build(self) -> crate::model::Hdr10Metadata {
            crate::model::Hdr10Metadata {
                blue_primary_x: self.blue_primary_x.unwrap_or_default(),
                blue_primary_y: self.blue_primary_y.unwrap_or_default(),
                green_primary_x: self.green_primary_x.unwrap_or_default(),
                green_primary_y: self.green_primary_y.unwrap_or_default(),
                max_content_light_level: self.max_content_light_level.unwrap_or_default(),
                max_frame_average_light_level: self
                    .max_frame_average_light_level
                    .unwrap_or_default(),
                max_luminance: self.max_luminance.unwrap_or_default(),
                min_luminance: self.min_luminance.unwrap_or_default(),
                red_primary_x: self.red_primary_x.unwrap_or_default(),
                red_primary_y: self.red_primary_y.unwrap_or_default(),
                white_point_x: self.white_point_x.unwrap_or_default(),
                white_point_y: self.white_point_y.unwrap_or_default(),
            }
        }
    }
}
impl Hdr10Metadata {
    /// Creates a new builder-style object to manufacture [`Hdr10Metadata`](crate::model::Hdr10Metadata)
    pub fn builder() -> crate::model::hdr10_metadata::Builder {
        crate::model::hdr10_metadata::Builder::default()
    }
}

/// Specify the color space you want for this output. The service supports conversion between HDR formats, between SDR formats, from SDR to HDR, and from HDR to SDR. SDR to HDR conversion doesn't upgrade the dynamic range. The converted video has an HDR format, but visually appears the same as an unconverted output. HDR to SDR conversion uses Elemental tone mapping technology to approximate the outcome of manually regrading from HDR to SDR.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColorSpaceConversion {
    #[allow(missing_docs)] // documentation missing in model
    Force601,
    #[allow(missing_docs)] // documentation missing in model
    Force709,
    #[allow(missing_docs)] // documentation missing in model
    ForceHdr10,
    #[allow(missing_docs)] // documentation missing in model
    ForceHlg2020,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColorSpaceConversion {
    fn from(s: &str) -> Self {
        match s {
            "FORCE_601" => ColorSpaceConversion::Force601,
            "FORCE_709" => ColorSpaceConversion::Force709,
            "FORCE_HDR10" => ColorSpaceConversion::ForceHdr10,
            "FORCE_HLG_2020" => ColorSpaceConversion::ForceHlg2020,
            "NONE" => ColorSpaceConversion::None,
            other => ColorSpaceConversion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColorSpaceConversion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColorSpaceConversion::from(s))
    }
}
impl ColorSpaceConversion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColorSpaceConversion::Force601 => "FORCE_601",
            ColorSpaceConversion::Force709 => "FORCE_709",
            ColorSpaceConversion::ForceHdr10 => "FORCE_HDR10",
            ColorSpaceConversion::ForceHlg2020 => "FORCE_HLG_2020",
            ColorSpaceConversion::None => "NONE",
            ColorSpaceConversion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FORCE_601",
            "FORCE_709",
            "FORCE_HDR10",
            "FORCE_HLG_2020",
            "NONE",
        ]
    }
}
impl AsRef<str> for ColorSpaceConversion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Applies only to H.264, H.265, MPEG2, and ProRes outputs. Only enable Timecode insertion when the input frame rate is identical to the output frame rate. To include timecodes in this output, set Timecode insertion (VideoTimecodeInsertion) to PIC_TIMING_SEI. To leave them out, set it to DISABLED. Default is DISABLED. When the service inserts timecodes in an output, by default, it uses any embedded timecodes from the input. If none are present, the service will set the timecode for the first output frame to zero. To change this default behavior, adjust the settings under Timecode configuration (TimecodeConfig). In the console, these settings are located under Job > Job settings > Timecode configuration. Note - Timecode source under input settings (InputTimecodeSource) does not affect the timecodes that are inserted in the output. Source under Job settings > Timecode configuration (TimecodeSource) does.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VideoTimecodeInsertion {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    PicTimingSei,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VideoTimecodeInsertion {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => VideoTimecodeInsertion::Disabled,
            "PIC_TIMING_SEI" => VideoTimecodeInsertion::PicTimingSei,
            other => VideoTimecodeInsertion::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VideoTimecodeInsertion {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VideoTimecodeInsertion::from(s))
    }
}
impl VideoTimecodeInsertion {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VideoTimecodeInsertion::Disabled => "DISABLED",
            VideoTimecodeInsertion::PicTimingSei => "PIC_TIMING_SEI",
            VideoTimecodeInsertion::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "PIC_TIMING_SEI"]
    }
}
impl AsRef<str> for VideoTimecodeInsertion {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify how the service handles outputs that have a different aspect ratio from the input aspect ratio. Choose Stretch to output (STRETCH_TO_OUTPUT) to have the service stretch your video image to fit. Keep the setting Default (DEFAULT) to have the service letterbox your video instead. This setting overrides any value that you specify for the setting Selection placement (position) in this output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScalingBehavior {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    StretchToOutput,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScalingBehavior {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => ScalingBehavior::Default,
            "STRETCH_TO_OUTPUT" => ScalingBehavior::StretchToOutput,
            other => ScalingBehavior::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScalingBehavior {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScalingBehavior::from(s))
    }
}
impl ScalingBehavior {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScalingBehavior::Default => "DEFAULT",
            ScalingBehavior::StretchToOutput => "STRETCH_TO_OUTPUT",
            ScalingBehavior::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "STRETCH_TO_OUTPUT"]
    }
}
impl AsRef<str> for ScalingBehavior {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Respond to AFD (RespondToAfd) to specify how the service changes the video itself in response to AFD values in the input. * Choose Respond to clip the input video frame according to the AFD value, input display aspect ratio, and output display aspect ratio. * Choose Passthrough to include the input AFD values. Do not choose this when AfdSignaling is set to (NONE). A preferred implementation of this workflow is to set RespondToAfd to (NONE) and set AfdSignaling to (AUTO). * Choose None to remove all input AFD values from this output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RespondToAfd {
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Passthrough,
    #[allow(missing_docs)] // documentation missing in model
    Respond,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RespondToAfd {
    fn from(s: &str) -> Self {
        match s {
            "NONE" => RespondToAfd::None,
            "PASSTHROUGH" => RespondToAfd::Passthrough,
            "RESPOND" => RespondToAfd::Respond,
            other => RespondToAfd::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RespondToAfd {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RespondToAfd::from(s))
    }
}
impl RespondToAfd {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RespondToAfd::None => "NONE",
            RespondToAfd::Passthrough => "PASSTHROUGH",
            RespondToAfd::Respond => "RESPOND",
            RespondToAfd::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NONE", "PASSTHROUGH", "RESPOND"]
    }
}
impl AsRef<str> for RespondToAfd {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Rectangle to identify a specific area of the video frame.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Rectangle {
    /// Height of rectangle in pixels. Specify only even numbers.
    pub height: i32,
    /// Width of rectangle in pixels. Specify only even numbers.
    pub width: i32,
    /// The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even numbers.
    pub x: i32,
    /// The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even numbers.
    pub y: i32,
}
impl Rectangle {
    /// Height of rectangle in pixels. Specify only even numbers.
    pub fn height(&self) -> i32 {
        self.height
    }
    /// Width of rectangle in pixels. Specify only even numbers.
    pub fn width(&self) -> i32 {
        self.width
    }
    /// The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even numbers.
    pub fn x(&self) -> i32 {
        self.x
    }
    /// The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even numbers.
    pub fn y(&self) -> i32 {
        self.y
    }
}
impl std::fmt::Debug for Rectangle {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Rectangle");
        formatter.field("height", &self.height);
        formatter.field("width", &self.width);
        formatter.field("x", &self.x);
        formatter.field("y", &self.y);
        formatter.finish()
    }
}
/// See [`Rectangle`](crate::model::Rectangle)
pub mod rectangle {
    /// A builder for [`Rectangle`](crate::model::Rectangle)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) height: std::option::Option<i32>,
        pub(crate) width: std::option::Option<i32>,
        pub(crate) x: std::option::Option<i32>,
        pub(crate) y: std::option::Option<i32>,
    }
    impl Builder {
        /// Height of rectangle in pixels. Specify only even numbers.
        pub fn height(mut self, input: i32) -> Self {
            self.height = Some(input);
            self
        }
        /// Height of rectangle in pixels. Specify only even numbers.
        pub fn set_height(mut self, input: std::option::Option<i32>) -> Self {
            self.height = input;
            self
        }
        /// Width of rectangle in pixels. Specify only even numbers.
        pub fn width(mut self, input: i32) -> Self {
            self.width = Some(input);
            self
        }
        /// Width of rectangle in pixels. Specify only even numbers.
        pub fn set_width(mut self, input: std::option::Option<i32>) -> Self {
            self.width = input;
            self
        }
        /// The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even numbers.
        pub fn x(mut self, input: i32) -> Self {
            self.x = Some(input);
            self
        }
        /// The distance, in pixels, between the rectangle and the left edge of the video frame. Specify only even numbers.
        pub fn set_x(mut self, input: std::option::Option<i32>) -> Self {
            self.x = input;
            self
        }
        /// The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even numbers.
        pub fn y(mut self, input: i32) -> Self {
            self.y = Some(input);
            self
        }
        /// The distance, in pixels, between the rectangle and the top edge of the video frame. Specify only even numbers.
        pub fn set_y(mut self, input: std::option::Option<i32>) -> Self {
            self.y = input;
            self
        }
        /// Consumes the builder and constructs a [`Rectangle`](crate::model::Rectangle)
        pub fn build(self) -> crate::model::Rectangle {
            crate::model::Rectangle {
                height: self.height.unwrap_or_default(),
                width: self.width.unwrap_or_default(),
                x: self.x.unwrap_or_default(),
                y: self.y.unwrap_or_default(),
            }
        }
    }
}
impl Rectangle {
    /// Creates a new builder-style object to manufacture [`Rectangle`](crate::model::Rectangle)
    pub fn builder() -> crate::model::rectangle::Builder {
        crate::model::rectangle::Builder::default()
    }
}

/// Applies only to 29.97 fps outputs. When this feature is enabled, the service will use drop-frame timecode on outputs. If it is not possible to use drop-frame timecode, the system will fall back to non-drop-frame. This setting is enabled by default when Timecode insertion (TimecodeInsertion) is enabled.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DropFrameTimecode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DropFrameTimecode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => DropFrameTimecode::Disabled,
            "ENABLED" => DropFrameTimecode::Enabled,
            other => DropFrameTimecode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DropFrameTimecode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DropFrameTimecode::from(s))
    }
}
impl DropFrameTimecode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DropFrameTimecode::Disabled => "DISABLED",
            DropFrameTimecode::Enabled => "ENABLED",
            DropFrameTimecode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for DropFrameTimecode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose Insert (INSERT) for this setting to include color metadata in this output. Choose Ignore (IGNORE) to exclude color metadata from this output. If you don't specify a value, the service sets this to Insert by default.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ColorMetadata {
    #[allow(missing_docs)] // documentation missing in model
    Ignore,
    #[allow(missing_docs)] // documentation missing in model
    Insert,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ColorMetadata {
    fn from(s: &str) -> Self {
        match s {
            "IGNORE" => ColorMetadata::Ignore,
            "INSERT" => ColorMetadata::Insert,
            other => ColorMetadata::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ColorMetadata {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ColorMetadata::from(s))
    }
}
impl ColorMetadata {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ColorMetadata::Ignore => "IGNORE",
            ColorMetadata::Insert => "INSERT",
            ColorMetadata::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["IGNORE", "INSERT"]
    }
}
impl AsRef<str> for ColorMetadata {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Video codec settings, (CodecSettings) under (VideoDescription), contains the group of settings related to video encoding. The settings in this group vary depending on the value that you choose for Video codec (Codec). For each codec enum that you choose, define the corresponding settings object. The following lists the codec enum, settings object pairs. * AV1, Av1Settings * AVC_INTRA, AvcIntraSettings * FRAME_CAPTURE, FrameCaptureSettings * H_264, H264Settings * H_265, H265Settings * MPEG2, Mpeg2Settings * PRORES, ProresSettings * VC3, Vc3Settings * VP8, Vp8Settings * VP9, Vp9Settings * XAVC, XavcSettings
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VideoCodecSettings {
    /// Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
    pub av1_settings: std::option::Option<crate::model::Av1Settings>,
    /// Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
    pub avc_intra_settings: std::option::Option<crate::model::AvcIntraSettings>,
    /// Specifies the video codec. This must be equal to one of the enum values defined by the object  VideoCodec.
    pub codec: std::option::Option<crate::model::VideoCodec>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
    pub frame_capture_settings: std::option::Option<crate::model::FrameCaptureSettings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
    pub h264_settings: std::option::Option<crate::model::H264Settings>,
    /// Settings for H265 codec
    pub h265_settings: std::option::Option<crate::model::H265Settings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
    pub mpeg2_settings: std::option::Option<crate::model::Mpeg2Settings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
    pub prores_settings: std::option::Option<crate::model::ProresSettings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
    pub vc3_settings: std::option::Option<crate::model::Vc3Settings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
    pub vp8_settings: std::option::Option<crate::model::Vp8Settings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
    pub vp9_settings: std::option::Option<crate::model::Vp9Settings>,
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
    pub xavc_settings: std::option::Option<crate::model::XavcSettings>,
}
impl VideoCodecSettings {
    /// Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
    pub fn av1_settings(&self) -> std::option::Option<&crate::model::Av1Settings> {
        self.av1_settings.as_ref()
    }
    /// Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
    pub fn avc_intra_settings(&self) -> std::option::Option<&crate::model::AvcIntraSettings> {
        self.avc_intra_settings.as_ref()
    }
    /// Specifies the video codec. This must be equal to one of the enum values defined by the object  VideoCodec.
    pub fn codec(&self) -> std::option::Option<&crate::model::VideoCodec> {
        self.codec.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
    pub fn frame_capture_settings(
        &self,
    ) -> std::option::Option<&crate::model::FrameCaptureSettings> {
        self.frame_capture_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
    pub fn h264_settings(&self) -> std::option::Option<&crate::model::H264Settings> {
        self.h264_settings.as_ref()
    }
    /// Settings for H265 codec
    pub fn h265_settings(&self) -> std::option::Option<&crate::model::H265Settings> {
        self.h265_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
    pub fn mpeg2_settings(&self) -> std::option::Option<&crate::model::Mpeg2Settings> {
        self.mpeg2_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
    pub fn prores_settings(&self) -> std::option::Option<&crate::model::ProresSettings> {
        self.prores_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
    pub fn vc3_settings(&self) -> std::option::Option<&crate::model::Vc3Settings> {
        self.vc3_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
    pub fn vp8_settings(&self) -> std::option::Option<&crate::model::Vp8Settings> {
        self.vp8_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
    pub fn vp9_settings(&self) -> std::option::Option<&crate::model::Vp9Settings> {
        self.vp9_settings.as_ref()
    }
    /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
    pub fn xavc_settings(&self) -> std::option::Option<&crate::model::XavcSettings> {
        self.xavc_settings.as_ref()
    }
}
impl std::fmt::Debug for VideoCodecSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VideoCodecSettings");
        formatter.field("av1_settings", &self.av1_settings);
        formatter.field("avc_intra_settings", &self.avc_intra_settings);
        formatter.field("codec", &self.codec);
        formatter.field("frame_capture_settings", &self.frame_capture_settings);
        formatter.field("h264_settings", &self.h264_settings);
        formatter.field("h265_settings", &self.h265_settings);
        formatter.field("mpeg2_settings", &self.mpeg2_settings);
        formatter.field("prores_settings", &self.prores_settings);
        formatter.field("vc3_settings", &self.vc3_settings);
        formatter.field("vp8_settings", &self.vp8_settings);
        formatter.field("vp9_settings", &self.vp9_settings);
        formatter.field("xavc_settings", &self.xavc_settings);
        formatter.finish()
    }
}
/// See [`VideoCodecSettings`](crate::model::VideoCodecSettings)
pub mod video_codec_settings {
    /// A builder for [`VideoCodecSettings`](crate::model::VideoCodecSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) av1_settings: std::option::Option<crate::model::Av1Settings>,
        pub(crate) avc_intra_settings: std::option::Option<crate::model::AvcIntraSettings>,
        pub(crate) codec: std::option::Option<crate::model::VideoCodec>,
        pub(crate) frame_capture_settings: std::option::Option<crate::model::FrameCaptureSettings>,
        pub(crate) h264_settings: std::option::Option<crate::model::H264Settings>,
        pub(crate) h265_settings: std::option::Option<crate::model::H265Settings>,
        pub(crate) mpeg2_settings: std::option::Option<crate::model::Mpeg2Settings>,
        pub(crate) prores_settings: std::option::Option<crate::model::ProresSettings>,
        pub(crate) vc3_settings: std::option::Option<crate::model::Vc3Settings>,
        pub(crate) vp8_settings: std::option::Option<crate::model::Vp8Settings>,
        pub(crate) vp9_settings: std::option::Option<crate::model::Vp9Settings>,
        pub(crate) xavc_settings: std::option::Option<crate::model::XavcSettings>,
    }
    impl Builder {
        /// Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
        pub fn av1_settings(mut self, input: crate::model::Av1Settings) -> Self {
            self.av1_settings = Some(input);
            self
        }
        /// Required when you set Codec, under VideoDescription>CodecSettings to the value AV1.
        pub fn set_av1_settings(
            mut self,
            input: std::option::Option<crate::model::Av1Settings>,
        ) -> Self {
            self.av1_settings = input;
            self
        }
        /// Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
        pub fn avc_intra_settings(mut self, input: crate::model::AvcIntraSettings) -> Self {
            self.avc_intra_settings = Some(input);
            self
        }
        /// Required when you choose AVC-Intra for your output video codec. For more information about the AVC-Intra settings, see the relevant specification. For detailed information about SD and HD in AVC-Intra, see https://ieeexplore.ieee.org/document/7290936. For information about 4K/2K in AVC-Intra, see https://pro-av.panasonic.net/en/avc-ultra/AVC-ULTRAoverview.pdf.
        pub fn set_avc_intra_settings(
            mut self,
            input: std::option::Option<crate::model::AvcIntraSettings>,
        ) -> Self {
            self.avc_intra_settings = input;
            self
        }
        /// Specifies the video codec. This must be equal to one of the enum values defined by the object  VideoCodec.
        pub fn codec(mut self, input: crate::model::VideoCodec) -> Self {
            self.codec = Some(input);
            self
        }
        /// Specifies the video codec. This must be equal to one of the enum values defined by the object  VideoCodec.
        pub fn set_codec(mut self, input: std::option::Option<crate::model::VideoCodec>) -> Self {
            self.codec = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
        pub fn frame_capture_settings(mut self, input: crate::model::FrameCaptureSettings) -> Self {
            self.frame_capture_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value FRAME_CAPTURE.
        pub fn set_frame_capture_settings(
            mut self,
            input: std::option::Option<crate::model::FrameCaptureSettings>,
        ) -> Self {
            self.frame_capture_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
        pub fn h264_settings(mut self, input: crate::model::H264Settings) -> Self {
            self.h264_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
        pub fn set_h264_settings(
            mut self,
            input: std::option::Option<crate::model::H264Settings>,
        ) -> Self {
            self.h264_settings = input;
            self
        }
        /// Settings for H265 codec
        pub fn h265_settings(mut self, input: crate::model::H265Settings) -> Self {
            self.h265_settings = Some(input);
            self
        }
        /// Settings for H265 codec
        pub fn set_h265_settings(
            mut self,
            input: std::option::Option<crate::model::H265Settings>,
        ) -> Self {
            self.h265_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
        pub fn mpeg2_settings(mut self, input: crate::model::Mpeg2Settings) -> Self {
            self.mpeg2_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
        pub fn set_mpeg2_settings(
            mut self,
            input: std::option::Option<crate::model::Mpeg2Settings>,
        ) -> Self {
            self.mpeg2_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
        pub fn prores_settings(mut self, input: crate::model::ProresSettings) -> Self {
            self.prores_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
        pub fn set_prores_settings(
            mut self,
            input: std::option::Option<crate::model::ProresSettings>,
        ) -> Self {
            self.prores_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
        pub fn vc3_settings(mut self, input: crate::model::Vc3Settings) -> Self {
            self.vc3_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
        pub fn set_vc3_settings(
            mut self,
            input: std::option::Option<crate::model::Vc3Settings>,
        ) -> Self {
            self.vc3_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
        pub fn vp8_settings(mut self, input: crate::model::Vp8Settings) -> Self {
            self.vp8_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
        pub fn set_vp8_settings(
            mut self,
            input: std::option::Option<crate::model::Vp8Settings>,
        ) -> Self {
            self.vp8_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
        pub fn vp9_settings(mut self, input: crate::model::Vp9Settings) -> Self {
            self.vp9_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
        pub fn set_vp9_settings(
            mut self,
            input: std::option::Option<crate::model::Vp9Settings>,
        ) -> Self {
            self.vp9_settings = input;
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
        pub fn xavc_settings(mut self, input: crate::model::XavcSettings) -> Self {
            self.xavc_settings = Some(input);
            self
        }
        /// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
        pub fn set_xavc_settings(
            mut self,
            input: std::option::Option<crate::model::XavcSettings>,
        ) -> Self {
            self.xavc_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`VideoCodecSettings`](crate::model::VideoCodecSettings)
        pub fn build(self) -> crate::model::VideoCodecSettings {
            crate::model::VideoCodecSettings {
                av1_settings: self.av1_settings,
                avc_intra_settings: self.avc_intra_settings,
                codec: self.codec,
                frame_capture_settings: self.frame_capture_settings,
                h264_settings: self.h264_settings,
                h265_settings: self.h265_settings,
                mpeg2_settings: self.mpeg2_settings,
                prores_settings: self.prores_settings,
                vc3_settings: self.vc3_settings,
                vp8_settings: self.vp8_settings,
                vp9_settings: self.vp9_settings,
                xavc_settings: self.xavc_settings,
            }
        }
    }
}
impl VideoCodecSettings {
    /// Creates a new builder-style object to manufacture [`VideoCodecSettings`](crate::model::VideoCodecSettings)
    pub fn builder() -> crate::model::video_codec_settings::Builder {
        crate::model::video_codec_settings::Builder::default()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value XAVC.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XavcSettings {
    /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
    pub adaptive_quantization: std::option::Option<crate::model::XavcAdaptiveQuantization>,
    /// Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
    pub entropy_encoding: std::option::Option<crate::model::XavcEntropyEncoding>,
    /// If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::XavcFramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::XavcFramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
    pub profile: std::option::Option<crate::model::XavcProfile>,
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub slow_pal: std::option::Option<crate::model::XavcSlowPal>,
    /// Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
    pub softness: i32,
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
    pub spatial_adaptive_quantization:
        std::option::Option<crate::model::XavcSpatialAdaptiveQuantization>,
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
    pub temporal_adaptive_quantization:
        std::option::Option<crate::model::XavcTemporalAdaptiveQuantization>,
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
    pub xavc4k_intra_cbg_profile_settings:
        std::option::Option<crate::model::Xavc4kIntraCbgProfileSettings>,
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
    pub xavc4k_intra_vbr_profile_settings:
        std::option::Option<crate::model::Xavc4kIntraVbrProfileSettings>,
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
    pub xavc4k_profile_settings: std::option::Option<crate::model::Xavc4kProfileSettings>,
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
    pub xavc_hd_intra_cbg_profile_settings:
        std::option::Option<crate::model::XavcHdIntraCbgProfileSettings>,
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
    pub xavc_hd_profile_settings: std::option::Option<crate::model::XavcHdProfileSettings>,
}
impl XavcSettings {
    /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
    pub fn adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::XavcAdaptiveQuantization> {
        self.adaptive_quantization.as_ref()
    }
    /// Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
    pub fn entropy_encoding(&self) -> std::option::Option<&crate::model::XavcEntropyEncoding> {
        self.entropy_encoding.as_ref()
    }
    /// If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::XavcFramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::XavcFramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
    pub fn profile(&self) -> std::option::Option<&crate::model::XavcProfile> {
        self.profile.as_ref()
    }
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub fn slow_pal(&self) -> std::option::Option<&crate::model::XavcSlowPal> {
        self.slow_pal.as_ref()
    }
    /// Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
    pub fn softness(&self) -> i32 {
        self.softness
    }
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
    pub fn spatial_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::XavcSpatialAdaptiveQuantization> {
        self.spatial_adaptive_quantization.as_ref()
    }
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
    pub fn temporal_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::XavcTemporalAdaptiveQuantization> {
        self.temporal_adaptive_quantization.as_ref()
    }
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
    pub fn xavc4k_intra_cbg_profile_settings(
        &self,
    ) -> std::option::Option<&crate::model::Xavc4kIntraCbgProfileSettings> {
        self.xavc4k_intra_cbg_profile_settings.as_ref()
    }
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
    pub fn xavc4k_intra_vbr_profile_settings(
        &self,
    ) -> std::option::Option<&crate::model::Xavc4kIntraVbrProfileSettings> {
        self.xavc4k_intra_vbr_profile_settings.as_ref()
    }
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
    pub fn xavc4k_profile_settings(
        &self,
    ) -> std::option::Option<&crate::model::Xavc4kProfileSettings> {
        self.xavc4k_profile_settings.as_ref()
    }
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
    pub fn xavc_hd_intra_cbg_profile_settings(
        &self,
    ) -> std::option::Option<&crate::model::XavcHdIntraCbgProfileSettings> {
        self.xavc_hd_intra_cbg_profile_settings.as_ref()
    }
    /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
    pub fn xavc_hd_profile_settings(
        &self,
    ) -> std::option::Option<&crate::model::XavcHdProfileSettings> {
        self.xavc_hd_profile_settings.as_ref()
    }
}
impl std::fmt::Debug for XavcSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XavcSettings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field("entropy_encoding", &self.entropy_encoding);
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("profile", &self.profile);
        formatter.field("slow_pal", &self.slow_pal);
        formatter.field("softness", &self.softness);
        formatter.field(
            "spatial_adaptive_quantization",
            &self.spatial_adaptive_quantization,
        );
        formatter.field(
            "temporal_adaptive_quantization",
            &self.temporal_adaptive_quantization,
        );
        formatter.field(
            "xavc4k_intra_cbg_profile_settings",
            &self.xavc4k_intra_cbg_profile_settings,
        );
        formatter.field(
            "xavc4k_intra_vbr_profile_settings",
            &self.xavc4k_intra_vbr_profile_settings,
        );
        formatter.field("xavc4k_profile_settings", &self.xavc4k_profile_settings);
        formatter.field(
            "xavc_hd_intra_cbg_profile_settings",
            &self.xavc_hd_intra_cbg_profile_settings,
        );
        formatter.field("xavc_hd_profile_settings", &self.xavc_hd_profile_settings);
        formatter.finish()
    }
}
/// See [`XavcSettings`](crate::model::XavcSettings)
pub mod xavc_settings {
    /// A builder for [`XavcSettings`](crate::model::XavcSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::XavcAdaptiveQuantization>,
        pub(crate) entropy_encoding: std::option::Option<crate::model::XavcEntropyEncoding>,
        pub(crate) framerate_control: std::option::Option<crate::model::XavcFramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::XavcFramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) profile: std::option::Option<crate::model::XavcProfile>,
        pub(crate) slow_pal: std::option::Option<crate::model::XavcSlowPal>,
        pub(crate) softness: std::option::Option<i32>,
        pub(crate) spatial_adaptive_quantization:
            std::option::Option<crate::model::XavcSpatialAdaptiveQuantization>,
        pub(crate) temporal_adaptive_quantization:
            std::option::Option<crate::model::XavcTemporalAdaptiveQuantization>,
        pub(crate) xavc4k_intra_cbg_profile_settings:
            std::option::Option<crate::model::Xavc4kIntraCbgProfileSettings>,
        pub(crate) xavc4k_intra_vbr_profile_settings:
            std::option::Option<crate::model::Xavc4kIntraVbrProfileSettings>,
        pub(crate) xavc4k_profile_settings:
            std::option::Option<crate::model::Xavc4kProfileSettings>,
        pub(crate) xavc_hd_intra_cbg_profile_settings:
            std::option::Option<crate::model::XavcHdIntraCbgProfileSettings>,
        pub(crate) xavc_hd_profile_settings:
            std::option::Option<crate::model::XavcHdProfileSettings>,
    }
    impl Builder {
        /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::XavcAdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::XavcAdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
        pub fn entropy_encoding(mut self, input: crate::model::XavcEntropyEncoding) -> Self {
            self.entropy_encoding = Some(input);
            self
        }
        /// Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
        pub fn set_entropy_encoding(
            mut self,
            input: std::option::Option<crate::model::XavcEntropyEncoding>,
        ) -> Self {
            self.entropy_encoding = input;
            self
        }
        /// If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::XavcFramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::XavcFramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::XavcFramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::XavcFramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Frame rate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example, 24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
        pub fn profile(mut self, input: crate::model::XavcProfile) -> Self {
            self.profile = Some(input);
            self
        }
        /// Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
        pub fn set_profile(
            mut self,
            input: std::option::Option<crate::model::XavcProfile>,
        ) -> Self {
            self.profile = input;
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn slow_pal(mut self, input: crate::model::XavcSlowPal) -> Self {
            self.slow_pal = Some(input);
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn set_slow_pal(
            mut self,
            input: std::option::Option<crate::model::XavcSlowPal>,
        ) -> Self {
            self.slow_pal = input;
            self
        }
        /// Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
        pub fn softness(mut self, input: i32) -> Self {
            self.softness = Some(input);
            self
        }
        /// Ignore this setting unless your downstream workflow requires that you specify it explicitly. Otherwise, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
        pub fn set_softness(mut self, input: std::option::Option<i32>) -> Self {
            self.softness = input;
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
        pub fn spatial_adaptive_quantization(
            mut self,
            input: crate::model::XavcSpatialAdaptiveQuantization,
        ) -> Self {
            self.spatial_adaptive_quantization = Some(input);
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
        pub fn set_spatial_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::XavcSpatialAdaptiveQuantization>,
        ) -> Self {
            self.spatial_adaptive_quantization = input;
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
        pub fn temporal_adaptive_quantization(
            mut self,
            input: crate::model::XavcTemporalAdaptiveQuantization,
        ) -> Self {
            self.temporal_adaptive_quantization = Some(input);
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
        pub fn set_temporal_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::XavcTemporalAdaptiveQuantization>,
        ) -> Self {
            self.temporal_adaptive_quantization = input;
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
        pub fn xavc4k_intra_cbg_profile_settings(
            mut self,
            input: crate::model::Xavc4kIntraCbgProfileSettings,
        ) -> Self {
            self.xavc4k_intra_cbg_profile_settings = Some(input);
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
        pub fn set_xavc4k_intra_cbg_profile_settings(
            mut self,
            input: std::option::Option<crate::model::Xavc4kIntraCbgProfileSettings>,
        ) -> Self {
            self.xavc4k_intra_cbg_profile_settings = input;
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
        pub fn xavc4k_intra_vbr_profile_settings(
            mut self,
            input: crate::model::Xavc4kIntraVbrProfileSettings,
        ) -> Self {
            self.xavc4k_intra_vbr_profile_settings = Some(input);
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
        pub fn set_xavc4k_intra_vbr_profile_settings(
            mut self,
            input: std::option::Option<crate::model::Xavc4kIntraVbrProfileSettings>,
        ) -> Self {
            self.xavc4k_intra_vbr_profile_settings = input;
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
        pub fn xavc4k_profile_settings(
            mut self,
            input: crate::model::Xavc4kProfileSettings,
        ) -> Self {
            self.xavc4k_profile_settings = Some(input);
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
        pub fn set_xavc4k_profile_settings(
            mut self,
            input: std::option::Option<crate::model::Xavc4kProfileSettings>,
        ) -> Self {
            self.xavc4k_profile_settings = input;
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
        pub fn xavc_hd_intra_cbg_profile_settings(
            mut self,
            input: crate::model::XavcHdIntraCbgProfileSettings,
        ) -> Self {
            self.xavc_hd_intra_cbg_profile_settings = Some(input);
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
        pub fn set_xavc_hd_intra_cbg_profile_settings(
            mut self,
            input: std::option::Option<crate::model::XavcHdIntraCbgProfileSettings>,
        ) -> Self {
            self.xavc_hd_intra_cbg_profile_settings = input;
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
        pub fn xavc_hd_profile_settings(
            mut self,
            input: crate::model::XavcHdProfileSettings,
        ) -> Self {
            self.xavc_hd_profile_settings = Some(input);
            self
        }
        /// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
        pub fn set_xavc_hd_profile_settings(
            mut self,
            input: std::option::Option<crate::model::XavcHdProfileSettings>,
        ) -> Self {
            self.xavc_hd_profile_settings = input;
            self
        }
        /// Consumes the builder and constructs a [`XavcSettings`](crate::model::XavcSettings)
        pub fn build(self) -> crate::model::XavcSettings {
            crate::model::XavcSettings {
                adaptive_quantization: self.adaptive_quantization,
                entropy_encoding: self.entropy_encoding,
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                profile: self.profile,
                slow_pal: self.slow_pal,
                softness: self.softness.unwrap_or_default(),
                spatial_adaptive_quantization: self.spatial_adaptive_quantization,
                temporal_adaptive_quantization: self.temporal_adaptive_quantization,
                xavc4k_intra_cbg_profile_settings: self.xavc4k_intra_cbg_profile_settings,
                xavc4k_intra_vbr_profile_settings: self.xavc4k_intra_vbr_profile_settings,
                xavc4k_profile_settings: self.xavc4k_profile_settings,
                xavc_hd_intra_cbg_profile_settings: self.xavc_hd_intra_cbg_profile_settings,
                xavc_hd_profile_settings: self.xavc_hd_profile_settings,
            }
        }
    }
}
impl XavcSettings {
    /// Creates a new builder-style object to manufacture [`XavcSettings`](crate::model::XavcSettings)
    pub fn builder() -> crate::model::xavc_settings::Builder {
        crate::model::xavc_settings::Builder::default()
    }
}

/// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XavcHdProfileSettings {
    /// Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub bitrate_class: std::option::Option<crate::model::XavcHdProfileBitrateClass>,
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
    pub flicker_adaptive_quantization:
        std::option::Option<crate::model::XavcFlickerAdaptiveQuantization>,
    /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
    pub gop_b_reference: std::option::Option<crate::model::XavcGopBReference>,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
    pub hrd_buffer_size: i32,
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub interlace_mode: std::option::Option<crate::model::XavcInterlaceMode>,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::XavcHdProfileQualityTuningLevel>,
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub slices: i32,
    /// Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
    pub telecine: std::option::Option<crate::model::XavcHdProfileTelecine>,
}
impl XavcHdProfileSettings {
    /// Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub fn bitrate_class(&self) -> std::option::Option<&crate::model::XavcHdProfileBitrateClass> {
        self.bitrate_class.as_ref()
    }
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
    pub fn flicker_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::XavcFlickerAdaptiveQuantization> {
        self.flicker_adaptive_quantization.as_ref()
    }
    /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
    pub fn gop_b_reference(&self) -> std::option::Option<&crate::model::XavcGopBReference> {
        self.gop_b_reference.as_ref()
    }
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub fn gop_closed_cadence(&self) -> i32 {
        self.gop_closed_cadence
    }
    /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub fn interlace_mode(&self) -> std::option::Option<&crate::model::XavcInterlaceMode> {
        self.interlace_mode.as_ref()
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::XavcHdProfileQualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub fn slices(&self) -> i32 {
        self.slices
    }
    /// Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
    pub fn telecine(&self) -> std::option::Option<&crate::model::XavcHdProfileTelecine> {
        self.telecine.as_ref()
    }
}
impl std::fmt::Debug for XavcHdProfileSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XavcHdProfileSettings");
        formatter.field("bitrate_class", &self.bitrate_class);
        formatter.field(
            "flicker_adaptive_quantization",
            &self.flicker_adaptive_quantization,
        );
        formatter.field("gop_b_reference", &self.gop_b_reference);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("interlace_mode", &self.interlace_mode);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("slices", &self.slices);
        formatter.field("telecine", &self.telecine);
        formatter.finish()
    }
}
/// See [`XavcHdProfileSettings`](crate::model::XavcHdProfileSettings)
pub mod xavc_hd_profile_settings {
    /// A builder for [`XavcHdProfileSettings`](crate::model::XavcHdProfileSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bitrate_class: std::option::Option<crate::model::XavcHdProfileBitrateClass>,
        pub(crate) flicker_adaptive_quantization:
            std::option::Option<crate::model::XavcFlickerAdaptiveQuantization>,
        pub(crate) gop_b_reference: std::option::Option<crate::model::XavcGopBReference>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) interlace_mode: std::option::Option<crate::model::XavcInterlaceMode>,
        pub(crate) quality_tuning_level:
            std::option::Option<crate::model::XavcHdProfileQualityTuningLevel>,
        pub(crate) slices: std::option::Option<i32>,
        pub(crate) telecine: std::option::Option<crate::model::XavcHdProfileTelecine>,
    }
    impl Builder {
        /// Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn bitrate_class(mut self, input: crate::model::XavcHdProfileBitrateClass) -> Self {
            self.bitrate_class = Some(input);
            self
        }
        /// Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn set_bitrate_class(
            mut self,
            input: std::option::Option<crate::model::XavcHdProfileBitrateClass>,
        ) -> Self {
            self.bitrate_class = input;
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
        pub fn flicker_adaptive_quantization(
            mut self,
            input: crate::model::XavcFlickerAdaptiveQuantization,
        ) -> Self {
            self.flicker_adaptive_quantization = Some(input);
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
        pub fn set_flicker_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::XavcFlickerAdaptiveQuantization>,
        ) -> Self {
            self.flicker_adaptive_quantization = input;
            self
        }
        /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
        pub fn gop_b_reference(mut self, input: crate::model::XavcGopBReference) -> Self {
            self.gop_b_reference = Some(input);
            self
        }
        /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
        pub fn set_gop_b_reference(
            mut self,
            input: std::option::Option<crate::model::XavcGopBReference>,
        ) -> Self {
            self.gop_b_reference = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn interlace_mode(mut self, input: crate::model::XavcInterlaceMode) -> Self {
            self.interlace_mode = Some(input);
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn set_interlace_mode(
            mut self,
            input: std::option::Option<crate::model::XavcInterlaceMode>,
        ) -> Self {
            self.interlace_mode = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn quality_tuning_level(
            mut self,
            input: crate::model::XavcHdProfileQualityTuningLevel,
        ) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::XavcHdProfileQualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn slices(mut self, input: i32) -> Self {
            self.slices = Some(input);
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn set_slices(mut self, input: std::option::Option<i32>) -> Self {
            self.slices = input;
            self
        }
        /// Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
        pub fn telecine(mut self, input: crate::model::XavcHdProfileTelecine) -> Self {
            self.telecine = Some(input);
            self
        }
        /// Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
        pub fn set_telecine(
            mut self,
            input: std::option::Option<crate::model::XavcHdProfileTelecine>,
        ) -> Self {
            self.telecine = input;
            self
        }
        /// Consumes the builder and constructs a [`XavcHdProfileSettings`](crate::model::XavcHdProfileSettings)
        pub fn build(self) -> crate::model::XavcHdProfileSettings {
            crate::model::XavcHdProfileSettings {
                bitrate_class: self.bitrate_class,
                flicker_adaptive_quantization: self.flicker_adaptive_quantization,
                gop_b_reference: self.gop_b_reference,
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                hrd_buffer_size: self.hrd_buffer_size.unwrap_or_default(),
                interlace_mode: self.interlace_mode,
                quality_tuning_level: self.quality_tuning_level,
                slices: self.slices.unwrap_or_default(),
                telecine: self.telecine,
            }
        }
    }
}
impl XavcHdProfileSettings {
    /// Creates a new builder-style object to manufacture [`XavcHdProfileSettings`](crate::model::XavcHdProfileSettings)
    pub fn builder() -> crate::model::xavc_hd_profile_settings::Builder {
        crate::model::xavc_hd_profile_settings::Builder::default()
    }
}

/// Ignore this setting unless you set Frame rate (framerateNumerator divided by framerateDenominator) to 29.970. If your input framerate is 23.976, choose Hard (HARD). Otherwise, keep the default value None (NONE). For more information, see https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-telecine-and-inverse-telecine.html.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcHdProfileTelecine {
    #[allow(missing_docs)] // documentation missing in model
    Hard,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcHdProfileTelecine {
    fn from(s: &str) -> Self {
        match s {
            "HARD" => XavcHdProfileTelecine::Hard,
            "NONE" => XavcHdProfileTelecine::None,
            other => XavcHdProfileTelecine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcHdProfileTelecine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcHdProfileTelecine::from(s))
    }
}
impl XavcHdProfileTelecine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcHdProfileTelecine::Hard => "HARD",
            XavcHdProfileTelecine::None => "NONE",
            XavcHdProfileTelecine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HARD", "NONE"]
    }
}
impl AsRef<str> for XavcHdProfileTelecine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcHdProfileQualityTuningLevel {
    #[allow(missing_docs)] // documentation missing in model
    MultiPassHq,
    #[allow(missing_docs)] // documentation missing in model
    SinglePass,
    #[allow(missing_docs)] // documentation missing in model
    SinglePassHq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcHdProfileQualityTuningLevel {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_PASS_HQ" => XavcHdProfileQualityTuningLevel::MultiPassHq,
            "SINGLE_PASS" => XavcHdProfileQualityTuningLevel::SinglePass,
            "SINGLE_PASS_HQ" => XavcHdProfileQualityTuningLevel::SinglePassHq,
            other => XavcHdProfileQualityTuningLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcHdProfileQualityTuningLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcHdProfileQualityTuningLevel::from(s))
    }
}
impl XavcHdProfileQualityTuningLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcHdProfileQualityTuningLevel::MultiPassHq => "MULTI_PASS_HQ",
            XavcHdProfileQualityTuningLevel::SinglePass => "SINGLE_PASS",
            XavcHdProfileQualityTuningLevel::SinglePassHq => "SINGLE_PASS_HQ",
            XavcHdProfileQualityTuningLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_PASS_HQ", "SINGLE_PASS", "SINGLE_PASS_HQ"]
    }
}
impl AsRef<str> for XavcHdProfileQualityTuningLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcInterlaceMode {
    #[allow(missing_docs)] // documentation missing in model
    BottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowBottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowTopField,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    #[allow(missing_docs)] // documentation missing in model
    TopField,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcInterlaceMode {
    fn from(s: &str) -> Self {
        match s {
            "BOTTOM_FIELD" => XavcInterlaceMode::BottomField,
            "FOLLOW_BOTTOM_FIELD" => XavcInterlaceMode::FollowBottomField,
            "FOLLOW_TOP_FIELD" => XavcInterlaceMode::FollowTopField,
            "PROGRESSIVE" => XavcInterlaceMode::Progressive,
            "TOP_FIELD" => XavcInterlaceMode::TopField,
            other => XavcInterlaceMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcInterlaceMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcInterlaceMode::from(s))
    }
}
impl XavcInterlaceMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcInterlaceMode::BottomField => "BOTTOM_FIELD",
            XavcInterlaceMode::FollowBottomField => "FOLLOW_BOTTOM_FIELD",
            XavcInterlaceMode::FollowTopField => "FOLLOW_TOP_FIELD",
            XavcInterlaceMode::Progressive => "PROGRESSIVE",
            XavcInterlaceMode::TopField => "TOP_FIELD",
            XavcInterlaceMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOTTOM_FIELD",
            "FOLLOW_BOTTOM_FIELD",
            "FOLLOW_TOP_FIELD",
            "PROGRESSIVE",
            "TOP_FIELD",
        ]
    }
}
impl AsRef<str> for XavcInterlaceMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcGopBReference {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcGopBReference {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => XavcGopBReference::Disabled,
            "ENABLED" => XavcGopBReference::Enabled,
            other => XavcGopBReference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcGopBReference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcGopBReference::from(s))
    }
}
impl XavcGopBReference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcGopBReference::Disabled => "DISABLED",
            XavcGopBReference::Enabled => "ENABLED",
            XavcGopBReference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for XavcGopBReference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcFlickerAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcFlickerAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => XavcFlickerAdaptiveQuantization::Disabled,
            "ENABLED" => XavcFlickerAdaptiveQuantization::Enabled,
            other => XavcFlickerAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcFlickerAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcFlickerAdaptiveQuantization::from(s))
    }
}
impl XavcFlickerAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcFlickerAdaptiveQuantization::Disabled => "DISABLED",
            XavcFlickerAdaptiveQuantization::Enabled => "ENABLED",
            XavcFlickerAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for XavcFlickerAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the XAVC HD (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcHdProfileBitrateClass {
    #[allow(missing_docs)] // documentation missing in model
    BitrateClass25,
    #[allow(missing_docs)] // documentation missing in model
    BitrateClass35,
    #[allow(missing_docs)] // documentation missing in model
    BitrateClass50,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcHdProfileBitrateClass {
    fn from(s: &str) -> Self {
        match s {
            "BITRATE_CLASS_25" => XavcHdProfileBitrateClass::BitrateClass25,
            "BITRATE_CLASS_35" => XavcHdProfileBitrateClass::BitrateClass35,
            "BITRATE_CLASS_50" => XavcHdProfileBitrateClass::BitrateClass50,
            other => XavcHdProfileBitrateClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcHdProfileBitrateClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcHdProfileBitrateClass::from(s))
    }
}
impl XavcHdProfileBitrateClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcHdProfileBitrateClass::BitrateClass25 => "BITRATE_CLASS_25",
            XavcHdProfileBitrateClass::BitrateClass35 => "BITRATE_CLASS_35",
            XavcHdProfileBitrateClass::BitrateClass50 => "BITRATE_CLASS_50",
            XavcHdProfileBitrateClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["BITRATE_CLASS_25", "BITRATE_CLASS_35", "BITRATE_CLASS_50"]
    }
}
impl AsRef<str> for XavcHdProfileBitrateClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_HD_INTRA_CBG.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct XavcHdIntraCbgProfileSettings {
    /// Specify the XAVC Intra HD (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub xavc_class: std::option::Option<crate::model::XavcHdIntraCbgProfileClass>,
}
impl XavcHdIntraCbgProfileSettings {
    /// Specify the XAVC Intra HD (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub fn xavc_class(&self) -> std::option::Option<&crate::model::XavcHdIntraCbgProfileClass> {
        self.xavc_class.as_ref()
    }
}
impl std::fmt::Debug for XavcHdIntraCbgProfileSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("XavcHdIntraCbgProfileSettings");
        formatter.field("xavc_class", &self.xavc_class);
        formatter.finish()
    }
}
/// See [`XavcHdIntraCbgProfileSettings`](crate::model::XavcHdIntraCbgProfileSettings)
pub mod xavc_hd_intra_cbg_profile_settings {
    /// A builder for [`XavcHdIntraCbgProfileSettings`](crate::model::XavcHdIntraCbgProfileSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xavc_class: std::option::Option<crate::model::XavcHdIntraCbgProfileClass>,
    }
    impl Builder {
        /// Specify the XAVC Intra HD (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn xavc_class(mut self, input: crate::model::XavcHdIntraCbgProfileClass) -> Self {
            self.xavc_class = Some(input);
            self
        }
        /// Specify the XAVC Intra HD (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn set_xavc_class(
            mut self,
            input: std::option::Option<crate::model::XavcHdIntraCbgProfileClass>,
        ) -> Self {
            self.xavc_class = input;
            self
        }
        /// Consumes the builder and constructs a [`XavcHdIntraCbgProfileSettings`](crate::model::XavcHdIntraCbgProfileSettings)
        pub fn build(self) -> crate::model::XavcHdIntraCbgProfileSettings {
            crate::model::XavcHdIntraCbgProfileSettings {
                xavc_class: self.xavc_class,
            }
        }
    }
}
impl XavcHdIntraCbgProfileSettings {
    /// Creates a new builder-style object to manufacture [`XavcHdIntraCbgProfileSettings`](crate::model::XavcHdIntraCbgProfileSettings)
    pub fn builder() -> crate::model::xavc_hd_intra_cbg_profile_settings::Builder {
        crate::model::xavc_hd_intra_cbg_profile_settings::Builder::default()
    }
}

/// Specify the XAVC Intra HD (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcHdIntraCbgProfileClass {
    #[allow(missing_docs)] // documentation missing in model
    Class100,
    #[allow(missing_docs)] // documentation missing in model
    Class200,
    #[allow(missing_docs)] // documentation missing in model
    Class50,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcHdIntraCbgProfileClass {
    fn from(s: &str) -> Self {
        match s {
            "CLASS_100" => XavcHdIntraCbgProfileClass::Class100,
            "CLASS_200" => XavcHdIntraCbgProfileClass::Class200,
            "CLASS_50" => XavcHdIntraCbgProfileClass::Class50,
            other => XavcHdIntraCbgProfileClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcHdIntraCbgProfileClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcHdIntraCbgProfileClass::from(s))
    }
}
impl XavcHdIntraCbgProfileClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcHdIntraCbgProfileClass::Class100 => "CLASS_100",
            XavcHdIntraCbgProfileClass::Class200 => "CLASS_200",
            XavcHdIntraCbgProfileClass::Class50 => "CLASS_50",
            XavcHdIntraCbgProfileClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLASS_100", "CLASS_200", "CLASS_50"]
    }
}
impl AsRef<str> for XavcHdIntraCbgProfileClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Xavc4kProfileSettings {
    /// Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub bitrate_class: std::option::Option<crate::model::Xavc4kProfileBitrateClass>,
    /// Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
    pub codec_profile: std::option::Option<crate::model::Xavc4kProfileCodecProfile>,
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
    pub flicker_adaptive_quantization:
        std::option::Option<crate::model::XavcFlickerAdaptiveQuantization>,
    /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
    pub gop_b_reference: std::option::Option<crate::model::XavcGopBReference>,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
    pub hrd_buffer_size: i32,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::Xavc4kProfileQualityTuningLevel>,
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub slices: i32,
}
impl Xavc4kProfileSettings {
    /// Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub fn bitrate_class(&self) -> std::option::Option<&crate::model::Xavc4kProfileBitrateClass> {
        self.bitrate_class.as_ref()
    }
    /// Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
    pub fn codec_profile(&self) -> std::option::Option<&crate::model::Xavc4kProfileCodecProfile> {
        self.codec_profile.as_ref()
    }
    /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
    pub fn flicker_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::XavcFlickerAdaptiveQuantization> {
        self.flicker_adaptive_quantization.as_ref()
    }
    /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
    pub fn gop_b_reference(&self) -> std::option::Option<&crate::model::XavcGopBReference> {
        self.gop_b_reference.as_ref()
    }
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub fn gop_closed_cadence(&self) -> i32 {
        self.gop_closed_cadence
    }
    /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::Xavc4kProfileQualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub fn slices(&self) -> i32 {
        self.slices
    }
}
impl std::fmt::Debug for Xavc4kProfileSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Xavc4kProfileSettings");
        formatter.field("bitrate_class", &self.bitrate_class);
        formatter.field("codec_profile", &self.codec_profile);
        formatter.field(
            "flicker_adaptive_quantization",
            &self.flicker_adaptive_quantization,
        );
        formatter.field("gop_b_reference", &self.gop_b_reference);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("slices", &self.slices);
        formatter.finish()
    }
}
/// See [`Xavc4kProfileSettings`](crate::model::Xavc4kProfileSettings)
pub mod xavc4k_profile_settings {
    /// A builder for [`Xavc4kProfileSettings`](crate::model::Xavc4kProfileSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bitrate_class: std::option::Option<crate::model::Xavc4kProfileBitrateClass>,
        pub(crate) codec_profile: std::option::Option<crate::model::Xavc4kProfileCodecProfile>,
        pub(crate) flicker_adaptive_quantization:
            std::option::Option<crate::model::XavcFlickerAdaptiveQuantization>,
        pub(crate) gop_b_reference: std::option::Option<crate::model::XavcGopBReference>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) quality_tuning_level:
            std::option::Option<crate::model::Xavc4kProfileQualityTuningLevel>,
        pub(crate) slices: std::option::Option<i32>,
    }
    impl Builder {
        /// Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn bitrate_class(mut self, input: crate::model::Xavc4kProfileBitrateClass) -> Self {
            self.bitrate_class = Some(input);
            self
        }
        /// Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn set_bitrate_class(
            mut self,
            input: std::option::Option<crate::model::Xavc4kProfileBitrateClass>,
        ) -> Self {
            self.bitrate_class = input;
            self
        }
        /// Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
        pub fn codec_profile(mut self, input: crate::model::Xavc4kProfileCodecProfile) -> Self {
            self.codec_profile = Some(input);
            self
        }
        /// Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
        pub fn set_codec_profile(
            mut self,
            input: std::option::Option<crate::model::Xavc4kProfileCodecProfile>,
        ) -> Self {
            self.codec_profile = input;
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
        pub fn flicker_adaptive_quantization(
            mut self,
            input: crate::model::XavcFlickerAdaptiveQuantization,
        ) -> Self {
            self.flicker_adaptive_quantization = Some(input);
            self
        }
        /// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (XavcAdaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set Adaptive quantization (adaptiveQuantization) to a value other than Off (OFF) or Auto (AUTO). Use Adaptive quantization to adjust the degree of smoothing that Flicker adaptive quantization provides.
        pub fn set_flicker_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::XavcFlickerAdaptiveQuantization>,
        ) -> Self {
            self.flicker_adaptive_quantization = input;
            self
        }
        /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
        pub fn gop_b_reference(mut self, input: crate::model::XavcGopBReference) -> Self {
            self.gop_b_reference = Some(input);
            self
        }
        /// Specify whether the encoder uses B-frames as reference frames for other pictures in the same GOP. Choose Allow (ENABLED) to allow the encoder to use B-frames as reference frames. Choose Don't allow (DISABLED) to prevent the encoder from using B-frames as reference frames.
        pub fn set_gop_b_reference(
            mut self,
            input: std::option::Option<crate::model::XavcGopBReference>,
        ) -> Self {
            self.gop_b_reference = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Specify the size of the buffer that MediaConvert uses in the HRD buffer model for this output. Specify this value in bits; for example, enter five megabits as 5000000. When you don't set this value, or you set it to zero, MediaConvert calculates the default by doubling the bitrate of this output point.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn quality_tuning_level(
            mut self,
            input: crate::model::Xavc4kProfileQualityTuningLevel,
        ) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::Xavc4kProfileQualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn slices(mut self, input: i32) -> Self {
            self.slices = Some(input);
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn set_slices(mut self, input: std::option::Option<i32>) -> Self {
            self.slices = input;
            self
        }
        /// Consumes the builder and constructs a [`Xavc4kProfileSettings`](crate::model::Xavc4kProfileSettings)
        pub fn build(self) -> crate::model::Xavc4kProfileSettings {
            crate::model::Xavc4kProfileSettings {
                bitrate_class: self.bitrate_class,
                codec_profile: self.codec_profile,
                flicker_adaptive_quantization: self.flicker_adaptive_quantization,
                gop_b_reference: self.gop_b_reference,
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                hrd_buffer_size: self.hrd_buffer_size.unwrap_or_default(),
                quality_tuning_level: self.quality_tuning_level,
                slices: self.slices.unwrap_or_default(),
            }
        }
    }
}
impl Xavc4kProfileSettings {
    /// Creates a new builder-style object to manufacture [`Xavc4kProfileSettings`](crate::model::Xavc4kProfileSettings)
    pub fn builder() -> crate::model::xavc4k_profile_settings::Builder {
        crate::model::xavc4k_profile_settings::Builder::default()
    }
}

/// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Xavc4kProfileQualityTuningLevel {
    #[allow(missing_docs)] // documentation missing in model
    MultiPassHq,
    #[allow(missing_docs)] // documentation missing in model
    SinglePass,
    #[allow(missing_docs)] // documentation missing in model
    SinglePassHq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Xavc4kProfileQualityTuningLevel {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_PASS_HQ" => Xavc4kProfileQualityTuningLevel::MultiPassHq,
            "SINGLE_PASS" => Xavc4kProfileQualityTuningLevel::SinglePass,
            "SINGLE_PASS_HQ" => Xavc4kProfileQualityTuningLevel::SinglePassHq,
            other => Xavc4kProfileQualityTuningLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Xavc4kProfileQualityTuningLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Xavc4kProfileQualityTuningLevel::from(s))
    }
}
impl Xavc4kProfileQualityTuningLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Xavc4kProfileQualityTuningLevel::MultiPassHq => "MULTI_PASS_HQ",
            Xavc4kProfileQualityTuningLevel::SinglePass => "SINGLE_PASS",
            Xavc4kProfileQualityTuningLevel::SinglePassHq => "SINGLE_PASS_HQ",
            Xavc4kProfileQualityTuningLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_PASS_HQ", "SINGLE_PASS", "SINGLE_PASS_HQ"]
    }
}
impl AsRef<str> for Xavc4kProfileQualityTuningLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the codec profile for this output. Choose High, 8-bit, 4:2:0 (HIGH) or High, 10-bit, 4:2:2 (HIGH_422). These profiles are specified in ITU-T H.264.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Xavc4kProfileCodecProfile {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    High422,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Xavc4kProfileCodecProfile {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => Xavc4kProfileCodecProfile::High,
            "HIGH_422" => Xavc4kProfileCodecProfile::High422,
            other => Xavc4kProfileCodecProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Xavc4kProfileCodecProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Xavc4kProfileCodecProfile::from(s))
    }
}
impl Xavc4kProfileCodecProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Xavc4kProfileCodecProfile::High => "HIGH",
            Xavc4kProfileCodecProfile::High422 => "HIGH_422",
            Xavc4kProfileCodecProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "HIGH_422"]
    }
}
impl AsRef<str> for Xavc4kProfileCodecProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the XAVC 4k (Long GOP) Bitrate Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Xavc4kProfileBitrateClass {
    #[allow(missing_docs)] // documentation missing in model
    BitrateClass100,
    #[allow(missing_docs)] // documentation missing in model
    BitrateClass140,
    #[allow(missing_docs)] // documentation missing in model
    BitrateClass200,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Xavc4kProfileBitrateClass {
    fn from(s: &str) -> Self {
        match s {
            "BITRATE_CLASS_100" => Xavc4kProfileBitrateClass::BitrateClass100,
            "BITRATE_CLASS_140" => Xavc4kProfileBitrateClass::BitrateClass140,
            "BITRATE_CLASS_200" => Xavc4kProfileBitrateClass::BitrateClass200,
            other => Xavc4kProfileBitrateClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Xavc4kProfileBitrateClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Xavc4kProfileBitrateClass::from(s))
    }
}
impl Xavc4kProfileBitrateClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Xavc4kProfileBitrateClass::BitrateClass100 => "BITRATE_CLASS_100",
            Xavc4kProfileBitrateClass::BitrateClass140 => "BITRATE_CLASS_140",
            Xavc4kProfileBitrateClass::BitrateClass200 => "BITRATE_CLASS_200",
            Xavc4kProfileBitrateClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BITRATE_CLASS_100",
            "BITRATE_CLASS_140",
            "BITRATE_CLASS_200",
        ]
    }
}
impl AsRef<str> for Xavc4kProfileBitrateClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_VBR.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Xavc4kIntraVbrProfileSettings {
    /// Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub xavc_class: std::option::Option<crate::model::Xavc4kIntraVbrProfileClass>,
}
impl Xavc4kIntraVbrProfileSettings {
    /// Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub fn xavc_class(&self) -> std::option::Option<&crate::model::Xavc4kIntraVbrProfileClass> {
        self.xavc_class.as_ref()
    }
}
impl std::fmt::Debug for Xavc4kIntraVbrProfileSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Xavc4kIntraVbrProfileSettings");
        formatter.field("xavc_class", &self.xavc_class);
        formatter.finish()
    }
}
/// See [`Xavc4kIntraVbrProfileSettings`](crate::model::Xavc4kIntraVbrProfileSettings)
pub mod xavc4k_intra_vbr_profile_settings {
    /// A builder for [`Xavc4kIntraVbrProfileSettings`](crate::model::Xavc4kIntraVbrProfileSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xavc_class: std::option::Option<crate::model::Xavc4kIntraVbrProfileClass>,
    }
    impl Builder {
        /// Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn xavc_class(mut self, input: crate::model::Xavc4kIntraVbrProfileClass) -> Self {
            self.xavc_class = Some(input);
            self
        }
        /// Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn set_xavc_class(
            mut self,
            input: std::option::Option<crate::model::Xavc4kIntraVbrProfileClass>,
        ) -> Self {
            self.xavc_class = input;
            self
        }
        /// Consumes the builder and constructs a [`Xavc4kIntraVbrProfileSettings`](crate::model::Xavc4kIntraVbrProfileSettings)
        pub fn build(self) -> crate::model::Xavc4kIntraVbrProfileSettings {
            crate::model::Xavc4kIntraVbrProfileSettings {
                xavc_class: self.xavc_class,
            }
        }
    }
}
impl Xavc4kIntraVbrProfileSettings {
    /// Creates a new builder-style object to manufacture [`Xavc4kIntraVbrProfileSettings`](crate::model::Xavc4kIntraVbrProfileSettings)
    pub fn builder() -> crate::model::xavc4k_intra_vbr_profile_settings::Builder {
        crate::model::xavc4k_intra_vbr_profile_settings::Builder::default()
    }
}

/// Specify the XAVC Intra 4k (VBR) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Xavc4kIntraVbrProfileClass {
    #[allow(missing_docs)] // documentation missing in model
    Class100,
    #[allow(missing_docs)] // documentation missing in model
    Class300,
    #[allow(missing_docs)] // documentation missing in model
    Class480,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Xavc4kIntraVbrProfileClass {
    fn from(s: &str) -> Self {
        match s {
            "CLASS_100" => Xavc4kIntraVbrProfileClass::Class100,
            "CLASS_300" => Xavc4kIntraVbrProfileClass::Class300,
            "CLASS_480" => Xavc4kIntraVbrProfileClass::Class480,
            other => Xavc4kIntraVbrProfileClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Xavc4kIntraVbrProfileClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Xavc4kIntraVbrProfileClass::from(s))
    }
}
impl Xavc4kIntraVbrProfileClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Xavc4kIntraVbrProfileClass::Class100 => "CLASS_100",
            Xavc4kIntraVbrProfileClass::Class300 => "CLASS_300",
            Xavc4kIntraVbrProfileClass::Class480 => "CLASS_480",
            Xavc4kIntraVbrProfileClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLASS_100", "CLASS_300", "CLASS_480"]
    }
}
impl AsRef<str> for Xavc4kIntraVbrProfileClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Profile) under (VideoDescription)>(CodecSettings)>(XavcSettings) to the value XAVC_4K_INTRA_CBG.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Xavc4kIntraCbgProfileSettings {
    /// Specify the XAVC Intra 4k (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub xavc_class: std::option::Option<crate::model::Xavc4kIntraCbgProfileClass>,
}
impl Xavc4kIntraCbgProfileSettings {
    /// Specify the XAVC Intra 4k (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
    pub fn xavc_class(&self) -> std::option::Option<&crate::model::Xavc4kIntraCbgProfileClass> {
        self.xavc_class.as_ref()
    }
}
impl std::fmt::Debug for Xavc4kIntraCbgProfileSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Xavc4kIntraCbgProfileSettings");
        formatter.field("xavc_class", &self.xavc_class);
        formatter.finish()
    }
}
/// See [`Xavc4kIntraCbgProfileSettings`](crate::model::Xavc4kIntraCbgProfileSettings)
pub mod xavc4k_intra_cbg_profile_settings {
    /// A builder for [`Xavc4kIntraCbgProfileSettings`](crate::model::Xavc4kIntraCbgProfileSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) xavc_class: std::option::Option<crate::model::Xavc4kIntraCbgProfileClass>,
    }
    impl Builder {
        /// Specify the XAVC Intra 4k (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn xavc_class(mut self, input: crate::model::Xavc4kIntraCbgProfileClass) -> Self {
            self.xavc_class = Some(input);
            self
        }
        /// Specify the XAVC Intra 4k (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
        pub fn set_xavc_class(
            mut self,
            input: std::option::Option<crate::model::Xavc4kIntraCbgProfileClass>,
        ) -> Self {
            self.xavc_class = input;
            self
        }
        /// Consumes the builder and constructs a [`Xavc4kIntraCbgProfileSettings`](crate::model::Xavc4kIntraCbgProfileSettings)
        pub fn build(self) -> crate::model::Xavc4kIntraCbgProfileSettings {
            crate::model::Xavc4kIntraCbgProfileSettings {
                xavc_class: self.xavc_class,
            }
        }
    }
}
impl Xavc4kIntraCbgProfileSettings {
    /// Creates a new builder-style object to manufacture [`Xavc4kIntraCbgProfileSettings`](crate::model::Xavc4kIntraCbgProfileSettings)
    pub fn builder() -> crate::model::xavc4k_intra_cbg_profile_settings::Builder {
        crate::model::xavc4k_intra_cbg_profile_settings::Builder::default()
    }
}

/// Specify the XAVC Intra 4k (CBG) Class to set the bitrate of your output. Outputs of the same class have similar image quality over the operating points that are valid for that class.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Xavc4kIntraCbgProfileClass {
    #[allow(missing_docs)] // documentation missing in model
    Class100,
    #[allow(missing_docs)] // documentation missing in model
    Class300,
    #[allow(missing_docs)] // documentation missing in model
    Class480,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Xavc4kIntraCbgProfileClass {
    fn from(s: &str) -> Self {
        match s {
            "CLASS_100" => Xavc4kIntraCbgProfileClass::Class100,
            "CLASS_300" => Xavc4kIntraCbgProfileClass::Class300,
            "CLASS_480" => Xavc4kIntraCbgProfileClass::Class480,
            other => Xavc4kIntraCbgProfileClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Xavc4kIntraCbgProfileClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Xavc4kIntraCbgProfileClass::from(s))
    }
}
impl Xavc4kIntraCbgProfileClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Xavc4kIntraCbgProfileClass::Class100 => "CLASS_100",
            Xavc4kIntraCbgProfileClass::Class300 => "CLASS_300",
            Xavc4kIntraCbgProfileClass::Class480 => "CLASS_480",
            Xavc4kIntraCbgProfileClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLASS_100", "CLASS_300", "CLASS_480"]
    }
}
impl AsRef<str> for Xavc4kIntraCbgProfileClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal adaptive quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcTemporalAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcTemporalAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => XavcTemporalAdaptiveQuantization::Disabled,
            "ENABLED" => XavcTemporalAdaptiveQuantization::Enabled,
            other => XavcTemporalAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcTemporalAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcTemporalAdaptiveQuantization::from(s))
    }
}
impl XavcTemporalAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcTemporalAdaptiveQuantization::Disabled => "DISABLED",
            XavcTemporalAdaptiveQuantization::Enabled => "ENABLED",
            XavcTemporalAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for XavcTemporalAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The best way to set up adaptive quantization is to keep the default value, Auto (AUTO), for the setting Adaptive quantization (adaptiveQuantization). When you do so, MediaConvert automatically applies the best types of quantization for your video content. Include this setting in your JSON job specification only when you choose to change the default value for Adaptive quantization. For this setting, keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcSpatialAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcSpatialAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => XavcSpatialAdaptiveQuantization::Disabled,
            "ENABLED" => XavcSpatialAdaptiveQuantization::Enabled,
            other => XavcSpatialAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcSpatialAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcSpatialAdaptiveQuantization::from(s))
    }
}
impl XavcSpatialAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcSpatialAdaptiveQuantization::Disabled => "DISABLED",
            XavcSpatialAdaptiveQuantization::Enabled => "ENABLED",
            XavcSpatialAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for XavcSpatialAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Frame rate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcSlowPal {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcSlowPal {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => XavcSlowPal::Disabled,
            "ENABLED" => XavcSlowPal::Enabled,
            other => XavcSlowPal::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcSlowPal {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcSlowPal::from(s))
    }
}
impl XavcSlowPal {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcSlowPal::Disabled => "DISABLED",
            XavcSlowPal::Enabled => "ENABLED",
            XavcSlowPal::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for XavcSlowPal {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the XAVC profile for this output. For more information, see the Sony documentation at https://www.xavc-info.org/. Note that MediaConvert doesn't support the interlaced video XAVC operating points for XAVC_HD_INTRA_CBG. To create an interlaced XAVC output, choose the profile XAVC_HD.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcProfile {
    #[allow(missing_docs)] // documentation missing in model
    Xavc4K,
    #[allow(missing_docs)] // documentation missing in model
    Xavc4KIntraCbg,
    #[allow(missing_docs)] // documentation missing in model
    Xavc4KIntraVbr,
    #[allow(missing_docs)] // documentation missing in model
    XavcHd,
    #[allow(missing_docs)] // documentation missing in model
    XavcHdIntraCbg,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcProfile {
    fn from(s: &str) -> Self {
        match s {
            "XAVC_4K" => XavcProfile::Xavc4K,
            "XAVC_4K_INTRA_CBG" => XavcProfile::Xavc4KIntraCbg,
            "XAVC_4K_INTRA_VBR" => XavcProfile::Xavc4KIntraVbr,
            "XAVC_HD" => XavcProfile::XavcHd,
            "XAVC_HD_INTRA_CBG" => XavcProfile::XavcHdIntraCbg,
            other => XavcProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcProfile::from(s))
    }
}
impl XavcProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcProfile::Xavc4K => "XAVC_4K",
            XavcProfile::Xavc4KIntraCbg => "XAVC_4K_INTRA_CBG",
            XavcProfile::Xavc4KIntraVbr => "XAVC_4K_INTRA_VBR",
            XavcProfile::XavcHd => "XAVC_HD",
            XavcProfile::XavcHdIntraCbg => "XAVC_HD_INTRA_CBG",
            XavcProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "XAVC_4K",
            "XAVC_4K_INTRA_CBG",
            "XAVC_4K_INTRA_VBR",
            "XAVC_HD",
            "XAVC_HD_INTRA_CBG",
        ]
    }
}
impl AsRef<str> for XavcProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcFramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcFramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => XavcFramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => XavcFramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => XavcFramerateConversionAlgorithm::Interpolate,
            other => XavcFramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcFramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcFramerateConversionAlgorithm::from(s))
    }
}
impl XavcFramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcFramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            XavcFramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            XavcFramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            XavcFramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for XavcFramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Frame rate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list. The framerates shown in the dropdown list are decimal approximations of fractions. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate that you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcFramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcFramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => XavcFramerateControl::InitializeFromSource,
            "SPECIFIED" => XavcFramerateControl::Specified,
            other => XavcFramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcFramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcFramerateControl::from(s))
    }
}
impl XavcFramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcFramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            XavcFramerateControl::Specified => "SPECIFIED",
            XavcFramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for XavcFramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Choose a specific entropy encoding mode only when you want to override XAVC recommendations. If you choose the value auto, MediaConvert uses the mode that the XAVC file format specifies given this output's operating point.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcEntropyEncoding {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Cabac,
    #[allow(missing_docs)] // documentation missing in model
    Cavlc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcEntropyEncoding {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => XavcEntropyEncoding::Auto,
            "CABAC" => XavcEntropyEncoding::Cabac,
            "CAVLC" => XavcEntropyEncoding::Cavlc,
            other => XavcEntropyEncoding::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcEntropyEncoding {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcEntropyEncoding::from(s))
    }
}
impl XavcEntropyEncoding {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcEntropyEncoding::Auto => "AUTO",
            XavcEntropyEncoding::Cabac => "CABAC",
            XavcEntropyEncoding::Cavlc => "CAVLC",
            XavcEntropyEncoding::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "CABAC", "CAVLC"]
    }
}
impl AsRef<str> for XavcEntropyEncoding {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set Adaptive quantization (adaptiveQuantization) to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization to Off (OFF). Related settings: The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum XavcAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Higher,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Max,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for XavcAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => XavcAdaptiveQuantization::Auto,
            "HIGH" => XavcAdaptiveQuantization::High,
            "HIGHER" => XavcAdaptiveQuantization::Higher,
            "LOW" => XavcAdaptiveQuantization::Low,
            "MAX" => XavcAdaptiveQuantization::Max,
            "MEDIUM" => XavcAdaptiveQuantization::Medium,
            "OFF" => XavcAdaptiveQuantization::Off,
            other => XavcAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for XavcAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(XavcAdaptiveQuantization::from(s))
    }
}
impl XavcAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            XavcAdaptiveQuantization::Auto => "AUTO",
            XavcAdaptiveQuantization::High => "HIGH",
            XavcAdaptiveQuantization::Higher => "HIGHER",
            XavcAdaptiveQuantization::Low => "LOW",
            XavcAdaptiveQuantization::Max => "MAX",
            XavcAdaptiveQuantization::Medium => "MEDIUM",
            XavcAdaptiveQuantization::Off => "OFF",
            XavcAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HIGH", "HIGHER", "LOW", "MAX", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for XavcAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP9.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Vp9Settings {
    /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
    pub bitrate: i32,
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::Vp9FramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::Vp9FramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// GOP Length (keyframe interval) in frames. Must be greater than zero.
    pub gop_size: f64,
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub hrd_buffer_size: i32,
    /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
    pub max_bitrate: i32,
    /// Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.
    pub par_control: std::option::Option<crate::model::Vp9ParControl>,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub par_denominator: i32,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub par_numerator: i32,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::Vp9QualityTuningLevel>,
    /// With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
    pub rate_control_mode: std::option::Option<crate::model::Vp9RateControlMode>,
}
impl Vp9Settings {
    /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
    pub fn bitrate(&self) -> i32 {
        self.bitrate
    }
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::Vp9FramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::Vp9FramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// GOP Length (keyframe interval) in frames. Must be greater than zero.
    pub fn gop_size(&self) -> f64 {
        self.gop_size
    }
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
    pub fn max_bitrate(&self) -> i32 {
        self.max_bitrate
    }
    /// Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.
    pub fn par_control(&self) -> std::option::Option<&crate::model::Vp9ParControl> {
        self.par_control.as_ref()
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub fn par_denominator(&self) -> i32 {
        self.par_denominator
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub fn par_numerator(&self) -> i32 {
        self.par_numerator
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::Vp9QualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
    pub fn rate_control_mode(&self) -> std::option::Option<&crate::model::Vp9RateControlMode> {
        self.rate_control_mode.as_ref()
    }
}
impl std::fmt::Debug for Vp9Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Vp9Settings");
        formatter.field("bitrate", &self.bitrate);
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.finish()
    }
}
/// See [`Vp9Settings`](crate::model::Vp9Settings)
pub mod vp9_settings {
    /// A builder for [`Vp9Settings`](crate::model::Vp9Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) framerate_control: std::option::Option<crate::model::Vp9FramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::Vp9FramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) par_control: std::option::Option<crate::model::Vp9ParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) quality_tuning_level: std::option::Option<crate::model::Vp9QualityTuningLevel>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::Vp9RateControlMode>,
    }
    impl Builder {
        /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::Vp9FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::Vp9FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::Vp9FramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::Vp9FramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// GOP Length (keyframe interval) in frames. Must be greater than zero.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// GOP Length (keyframe interval) in frames. Must be greater than zero.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.
        pub fn par_control(mut self, input: crate::model::Vp9ParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio for this output. The default behavior is to use the same pixel aspect ratio as your input video.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::Vp9ParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
        pub fn quality_tuning_level(mut self, input: crate::model::Vp9QualityTuningLevel) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::Vp9QualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
        pub fn rate_control_mode(mut self, input: crate::model::Vp9RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::Vp9RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`Vp9Settings`](crate::model::Vp9Settings)
        pub fn build(self) -> crate::model::Vp9Settings {
            crate::model::Vp9Settings {
                bitrate: self.bitrate.unwrap_or_default(),
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                hrd_buffer_size: self.hrd_buffer_size.unwrap_or_default(),
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                par_control: self.par_control,
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                quality_tuning_level: self.quality_tuning_level,
                rate_control_mode: self.rate_control_mode,
            }
        }
    }
}
impl Vp9Settings {
    /// Creates a new builder-style object to manufacture [`Vp9Settings`](crate::model::Vp9Settings)
    pub fn builder() -> crate::model::vp9_settings::Builder {
        crate::model::vp9_settings::Builder::default()
    }
}

/// With the VP9 codec, you can use only the variable bitrate (VBR) rate control mode.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp9RateControlMode {
    #[allow(missing_docs)] // documentation missing in model
    Vbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp9RateControlMode {
    fn from(s: &str) -> Self {
        match s {
            "VBR" => Vp9RateControlMode::Vbr,
            other => Vp9RateControlMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp9RateControlMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp9RateControlMode::from(s))
    }
}
impl Vp9RateControlMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp9RateControlMode::Vbr => "VBR",
            Vp9RateControlMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VBR"]
    }
}
impl AsRef<str> for Vp9RateControlMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp9QualityTuningLevel {
    #[allow(missing_docs)] // documentation missing in model
    MultiPass,
    #[allow(missing_docs)] // documentation missing in model
    MultiPassHq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp9QualityTuningLevel {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_PASS" => Vp9QualityTuningLevel::MultiPass,
            "MULTI_PASS_HQ" => Vp9QualityTuningLevel::MultiPassHq,
            other => Vp9QualityTuningLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp9QualityTuningLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp9QualityTuningLevel::from(s))
    }
}
impl Vp9QualityTuningLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp9QualityTuningLevel::MultiPass => "MULTI_PASS",
            Vp9QualityTuningLevel::MultiPassHq => "MULTI_PASS_HQ",
            Vp9QualityTuningLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_PASS", "MULTI_PASS_HQ"]
    }
}
impl AsRef<str> for Vp9QualityTuningLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp9ParControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp9ParControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Vp9ParControl::InitializeFromSource,
            "SPECIFIED" => Vp9ParControl::Specified,
            other => Vp9ParControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp9ParControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp9ParControl::from(s))
    }
}
impl Vp9ParControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp9ParControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Vp9ParControl::Specified => "SPECIFIED",
            Vp9ParControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Vp9ParControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp9FramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp9FramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => Vp9FramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => Vp9FramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => Vp9FramerateConversionAlgorithm::Interpolate,
            other => Vp9FramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp9FramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp9FramerateConversionAlgorithm::from(s))
    }
}
impl Vp9FramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp9FramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            Vp9FramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            Vp9FramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            Vp9FramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for Vp9FramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp9FramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp9FramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Vp9FramerateControl::InitializeFromSource,
            "SPECIFIED" => Vp9FramerateControl::Specified,
            other => Vp9FramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp9FramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp9FramerateControl::from(s))
    }
}
impl Vp9FramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp9FramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Vp9FramerateControl::Specified => "SPECIFIED",
            Vp9FramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Vp9FramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VP8.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Vp8Settings {
    /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
    pub bitrate: i32,
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::Vp8FramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::Vp8FramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// GOP Length (keyframe interval) in frames. Must be greater than zero.
    pub gop_size: f64,
    /// Optional. Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub hrd_buffer_size: i32,
    /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
    pub max_bitrate: i32,
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub par_control: std::option::Option<crate::model::Vp8ParControl>,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub par_denominator: i32,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub par_numerator: i32,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::Vp8QualityTuningLevel>,
    /// With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.
    pub rate_control_mode: std::option::Option<crate::model::Vp8RateControlMode>,
}
impl Vp8Settings {
    /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
    pub fn bitrate(&self) -> i32 {
        self.bitrate
    }
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::Vp8FramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::Vp8FramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// GOP Length (keyframe interval) in frames. Must be greater than zero.
    pub fn gop_size(&self) -> f64 {
        self.gop_size
    }
    /// Optional. Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
    pub fn max_bitrate(&self) -> i32 {
        self.max_bitrate
    }
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub fn par_control(&self) -> std::option::Option<&crate::model::Vp8ParControl> {
        self.par_control.as_ref()
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub fn par_denominator(&self) -> i32 {
        self.par_denominator
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub fn par_numerator(&self) -> i32 {
        self.par_numerator
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::Vp8QualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.
    pub fn rate_control_mode(&self) -> std::option::Option<&crate::model::Vp8RateControlMode> {
        self.rate_control_mode.as_ref()
    }
}
impl std::fmt::Debug for Vp8Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Vp8Settings");
        formatter.field("bitrate", &self.bitrate);
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.finish()
    }
}
/// See [`Vp8Settings`](crate::model::Vp8Settings)
pub mod vp8_settings {
    /// A builder for [`Vp8Settings`](crate::model::Vp8Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) framerate_control: std::option::Option<crate::model::Vp8FramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::Vp8FramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) par_control: std::option::Option<crate::model::Vp8ParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) quality_tuning_level: std::option::Option<crate::model::Vp8QualityTuningLevel>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::Vp8RateControlMode>,
    }
    impl Builder {
        /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Target bitrate in bits/second. For example, enter five megabits per second as 5000000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::Vp8FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::Vp8FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::Vp8FramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::Vp8FramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// GOP Length (keyframe interval) in frames. Must be greater than zero.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// GOP Length (keyframe interval) in frames. Must be greater than zero.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Optional. Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Optional. Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// Ignore this setting unless you set qualityTuningLevel to MULTI_PASS. Optional. Specify the maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. The default behavior uses twice the target bitrate as the maximum bitrate.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn par_control(mut self, input: crate::model::Vp8ParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::Vp8ParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
        pub fn quality_tuning_level(mut self, input: crate::model::Vp8QualityTuningLevel) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::Vp8QualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.
        pub fn rate_control_mode(mut self, input: crate::model::Vp8RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::Vp8RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Consumes the builder and constructs a [`Vp8Settings`](crate::model::Vp8Settings)
        pub fn build(self) -> crate::model::Vp8Settings {
            crate::model::Vp8Settings {
                bitrate: self.bitrate.unwrap_or_default(),
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                hrd_buffer_size: self.hrd_buffer_size.unwrap_or_default(),
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                par_control: self.par_control,
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                quality_tuning_level: self.quality_tuning_level,
                rate_control_mode: self.rate_control_mode,
            }
        }
    }
}
impl Vp8Settings {
    /// Creates a new builder-style object to manufacture [`Vp8Settings`](crate::model::Vp8Settings)
    pub fn builder() -> crate::model::vp8_settings::Builder {
        crate::model::vp8_settings::Builder::default()
    }
}

/// With the VP8 codec, you can use only the variable bitrate (VBR) rate control mode.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp8RateControlMode {
    #[allow(missing_docs)] // documentation missing in model
    Vbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp8RateControlMode {
    fn from(s: &str) -> Self {
        match s {
            "VBR" => Vp8RateControlMode::Vbr,
            other => Vp8RateControlMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp8RateControlMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp8RateControlMode::from(s))
    }
}
impl Vp8RateControlMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp8RateControlMode::Vbr => "VBR",
            Vp8RateControlMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["VBR"]
    }
}
impl AsRef<str> for Vp8RateControlMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, multi-pass encoding.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp8QualityTuningLevel {
    #[allow(missing_docs)] // documentation missing in model
    MultiPass,
    #[allow(missing_docs)] // documentation missing in model
    MultiPassHq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp8QualityTuningLevel {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_PASS" => Vp8QualityTuningLevel::MultiPass,
            "MULTI_PASS_HQ" => Vp8QualityTuningLevel::MultiPassHq,
            other => Vp8QualityTuningLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp8QualityTuningLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp8QualityTuningLevel::from(s))
    }
}
impl Vp8QualityTuningLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp8QualityTuningLevel::MultiPass => "MULTI_PASS",
            Vp8QualityTuningLevel::MultiPassHq => "MULTI_PASS_HQ",
            Vp8QualityTuningLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_PASS", "MULTI_PASS_HQ"]
    }
}
impl AsRef<str> for Vp8QualityTuningLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp8ParControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp8ParControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Vp8ParControl::InitializeFromSource,
            "SPECIFIED" => Vp8ParControl::Specified,
            other => Vp8ParControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp8ParControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp8ParControl::from(s))
    }
}
impl Vp8ParControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp8ParControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Vp8ParControl::Specified => "SPECIFIED",
            Vp8ParControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Vp8ParControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp8FramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp8FramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => Vp8FramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => Vp8FramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => Vp8FramerateConversionAlgorithm::Interpolate,
            other => Vp8FramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp8FramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp8FramerateConversionAlgorithm::from(s))
    }
}
impl Vp8FramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp8FramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            Vp8FramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            Vp8FramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            Vp8FramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for Vp8FramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vp8FramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vp8FramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Vp8FramerateControl::InitializeFromSource,
            "SPECIFIED" => Vp8FramerateControl::Specified,
            other => Vp8FramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vp8FramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vp8FramerateControl::from(s))
    }
}
impl Vp8FramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vp8FramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Vp8FramerateControl::Specified => "SPECIFIED",
            Vp8FramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Vp8FramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value VC3
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Vc3Settings {
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::Vc3FramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::Vc3FramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a progressive output.
    pub interlace_mode: std::option::Option<crate::model::Vc3InterlaceMode>,
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub scan_type_conversion_mode: std::option::Option<crate::model::Vc3ScanTypeConversionMode>,
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub slow_pal: std::option::Option<crate::model::Vc3SlowPal>,
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub telecine: std::option::Option<crate::model::Vc3Telecine>,
    /// Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of your output.
    pub vc3_class: std::option::Option<crate::model::Vc3Class>,
}
impl Vc3Settings {
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::Vc3FramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::Vc3FramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a progressive output.
    pub fn interlace_mode(&self) -> std::option::Option<&crate::model::Vc3InterlaceMode> {
        self.interlace_mode.as_ref()
    }
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub fn scan_type_conversion_mode(
        &self,
    ) -> std::option::Option<&crate::model::Vc3ScanTypeConversionMode> {
        self.scan_type_conversion_mode.as_ref()
    }
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub fn slow_pal(&self) -> std::option::Option<&crate::model::Vc3SlowPal> {
        self.slow_pal.as_ref()
    }
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub fn telecine(&self) -> std::option::Option<&crate::model::Vc3Telecine> {
        self.telecine.as_ref()
    }
    /// Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of your output.
    pub fn vc3_class(&self) -> std::option::Option<&crate::model::Vc3Class> {
        self.vc3_class.as_ref()
    }
}
impl std::fmt::Debug for Vc3Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Vc3Settings");
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("interlace_mode", &self.interlace_mode);
        formatter.field("scan_type_conversion_mode", &self.scan_type_conversion_mode);
        formatter.field("slow_pal", &self.slow_pal);
        formatter.field("telecine", &self.telecine);
        formatter.field("vc3_class", &self.vc3_class);
        formatter.finish()
    }
}
/// See [`Vc3Settings`](crate::model::Vc3Settings)
pub mod vc3_settings {
    /// A builder for [`Vc3Settings`](crate::model::Vc3Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) framerate_control: std::option::Option<crate::model::Vc3FramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::Vc3FramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) interlace_mode: std::option::Option<crate::model::Vc3InterlaceMode>,
        pub(crate) scan_type_conversion_mode:
            std::option::Option<crate::model::Vc3ScanTypeConversionMode>,
        pub(crate) slow_pal: std::option::Option<crate::model::Vc3SlowPal>,
        pub(crate) telecine: std::option::Option<crate::model::Vc3Telecine>,
        pub(crate) vc3_class: std::option::Option<crate::model::Vc3Class>,
    }
    impl Builder {
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::Vc3FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::Vc3FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::Vc3FramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::Vc3FramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a progressive output.
        pub fn interlace_mode(mut self, input: crate::model::Vc3InterlaceMode) -> Self {
            self.interlace_mode = Some(input);
            self
        }
        /// Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a progressive output.
        pub fn set_interlace_mode(
            mut self,
            input: std::option::Option<crate::model::Vc3InterlaceMode>,
        ) -> Self {
            self.interlace_mode = input;
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn scan_type_conversion_mode(
            mut self,
            input: crate::model::Vc3ScanTypeConversionMode,
        ) -> Self {
            self.scan_type_conversion_mode = Some(input);
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn set_scan_type_conversion_mode(
            mut self,
            input: std::option::Option<crate::model::Vc3ScanTypeConversionMode>,
        ) -> Self {
            self.scan_type_conversion_mode = input;
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn slow_pal(mut self, input: crate::model::Vc3SlowPal) -> Self {
            self.slow_pal = Some(input);
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn set_slow_pal(
            mut self,
            input: std::option::Option<crate::model::Vc3SlowPal>,
        ) -> Self {
            self.slow_pal = input;
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn telecine(mut self, input: crate::model::Vc3Telecine) -> Self {
            self.telecine = Some(input);
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn set_telecine(
            mut self,
            input: std::option::Option<crate::model::Vc3Telecine>,
        ) -> Self {
            self.telecine = input;
            self
        }
        /// Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of your output.
        pub fn vc3_class(mut self, input: crate::model::Vc3Class) -> Self {
            self.vc3_class = Some(input);
            self
        }
        /// Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of your output.
        pub fn set_vc3_class(mut self, input: std::option::Option<crate::model::Vc3Class>) -> Self {
            self.vc3_class = input;
            self
        }
        /// Consumes the builder and constructs a [`Vc3Settings`](crate::model::Vc3Settings)
        pub fn build(self) -> crate::model::Vc3Settings {
            crate::model::Vc3Settings {
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                interlace_mode: self.interlace_mode,
                scan_type_conversion_mode: self.scan_type_conversion_mode,
                slow_pal: self.slow_pal,
                telecine: self.telecine,
                vc3_class: self.vc3_class,
            }
        }
    }
}
impl Vc3Settings {
    /// Creates a new builder-style object to manufacture [`Vc3Settings`](crate::model::Vc3Settings)
    pub fn builder() -> crate::model::vc3_settings::Builder {
        crate::model::vc3_settings::Builder::default()
    }
}

/// Specify the VC3 class to choose the quality characteristics for this output. VC3 class, together with the settings Framerate (framerateNumerator and framerateDenominator) and Resolution (height and width), determine your output bitrate. For example, say that your video resolution is 1920x1080 and your framerate is 29.97. Then Class 145 (CLASS_145) gives you an output with a bitrate of approximately 145 Mbps and Class 220 (CLASS_220) gives you and output with a bitrate of approximately 220 Mbps. VC3 class also specifies the color bit depth of your output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3Class {
    #[allow(missing_docs)] // documentation missing in model
    Class1458Bit,
    #[allow(missing_docs)] // documentation missing in model
    Class22010Bit,
    #[allow(missing_docs)] // documentation missing in model
    Class2208Bit,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3Class {
    fn from(s: &str) -> Self {
        match s {
            "CLASS_145_8BIT" => Vc3Class::Class1458Bit,
            "CLASS_220_10BIT" => Vc3Class::Class22010Bit,
            "CLASS_220_8BIT" => Vc3Class::Class2208Bit,
            other => Vc3Class::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3Class {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3Class::from(s))
    }
}
impl Vc3Class {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3Class::Class1458Bit => "CLASS_145_8BIT",
            Vc3Class::Class22010Bit => "CLASS_220_10BIT",
            Vc3Class::Class2208Bit => "CLASS_220_8BIT",
            Vc3Class::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLASS_145_8BIT", "CLASS_220_10BIT", "CLASS_220_8BIT"]
    }
}
impl AsRef<str> for Vc3Class {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3Telecine {
    #[allow(missing_docs)] // documentation missing in model
    Hard,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3Telecine {
    fn from(s: &str) -> Self {
        match s {
            "HARD" => Vc3Telecine::Hard,
            "NONE" => Vc3Telecine::None,
            other => Vc3Telecine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3Telecine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3Telecine::from(s))
    }
}
impl Vc3Telecine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3Telecine::Hard => "HARD",
            Vc3Telecine::None => "NONE",
            Vc3Telecine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HARD", "NONE"]
    }
}
impl AsRef<str> for Vc3Telecine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output by relabeling the video frames and resampling your audio. Note that enabling this setting will slightly reduce the duration of your video. Related settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3SlowPal {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3SlowPal {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Vc3SlowPal::Disabled,
            "ENABLED" => Vc3SlowPal::Enabled,
            other => Vc3SlowPal::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3SlowPal {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3SlowPal::from(s))
    }
}
impl Vc3SlowPal {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3SlowPal::Disabled => "DISABLED",
            Vc3SlowPal::Enabled => "ENABLED",
            Vc3SlowPal::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Vc3SlowPal {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3ScanTypeConversionMode {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    InterlacedOptimize,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3ScanTypeConversionMode {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => Vc3ScanTypeConversionMode::Interlaced,
            "INTERLACED_OPTIMIZE" => Vc3ScanTypeConversionMode::InterlacedOptimize,
            other => Vc3ScanTypeConversionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3ScanTypeConversionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3ScanTypeConversionMode::from(s))
    }
}
impl Vc3ScanTypeConversionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3ScanTypeConversionMode::Interlaced => "INTERLACED",
            Vc3ScanTypeConversionMode::InterlacedOptimize => "INTERLACED_OPTIMIZE",
            Vc3ScanTypeConversionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "INTERLACED_OPTIMIZE"]
    }
}
impl AsRef<str> for Vc3ScanTypeConversionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Choose the scan line type for this output. If you don't specify a value, MediaConvert will create a progressive output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3InterlaceMode {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3InterlaceMode {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => Vc3InterlaceMode::Interlaced,
            "PROGRESSIVE" => Vc3InterlaceMode::Progressive,
            other => Vc3InterlaceMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3InterlaceMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3InterlaceMode::from(s))
    }
}
impl Vc3InterlaceMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3InterlaceMode::Interlaced => "INTERLACED",
            Vc3InterlaceMode::Progressive => "PROGRESSIVE",
            Vc3InterlaceMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "PROGRESSIVE"]
    }
}
impl AsRef<str> for Vc3InterlaceMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3FramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3FramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => Vc3FramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => Vc3FramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => Vc3FramerateConversionAlgorithm::Interpolate,
            other => Vc3FramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3FramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3FramerateConversionAlgorithm::from(s))
    }
}
impl Vc3FramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3FramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            Vc3FramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            Vc3FramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            Vc3FramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for Vc3FramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Vc3FramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Vc3FramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Vc3FramerateControl::InitializeFromSource,
            "SPECIFIED" => Vc3FramerateControl::Specified,
            other => Vc3FramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Vc3FramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Vc3FramerateControl::from(s))
    }
}
impl Vc3FramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Vc3FramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Vc3FramerateControl::Specified => "SPECIFIED",
            Vc3FramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Vc3FramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value PRORES.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProresSettings {
    /// This setting applies only to ProRes 4444 and ProRes 4444 XQ outputs that you create from inputs that use 4:4:4 chroma sampling. Set Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING) to allow outputs to also use 4:4:4 chroma sampling. You must specify a value for this setting when your output codec profile supports 4:4:4 chroma sampling. Related Settings: When you set Chroma sampling to Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING), you must choose an output codec profile that supports 4:4:4 chroma sampling. These values for Profile (CodecProfile) support 4:4:4 chroma sampling: Apple ProRes 4444 (APPLE_PRORES_4444) or Apple ProRes 4444 XQ (APPLE_PRORES_4444_XQ). When you set Chroma sampling to Preserve 4:4:4 sampling, you must disable all video preprocessors except for Nexguard file marker (PartnerWatermarking). When you set Chroma sampling to Preserve 4:4:4 sampling and use framerate conversion, you must set Frame rate conversion algorithm (FramerateConversionAlgorithm) to Drop duplicate (DUPLICATE_DROP).
    pub chroma_sampling: std::option::Option<crate::model::ProresChromaSampling>,
    /// Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
    pub codec_profile: std::option::Option<crate::model::ProresCodecProfile>,
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::ProresFramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::ProresFramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub interlace_mode: std::option::Option<crate::model::ProresInterlaceMode>,
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub par_control: std::option::Option<crate::model::ProresParControl>,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub par_denominator: i32,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub par_numerator: i32,
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub scan_type_conversion_mode: std::option::Option<crate::model::ProresScanTypeConversionMode>,
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub slow_pal: std::option::Option<crate::model::ProresSlowPal>,
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub telecine: std::option::Option<crate::model::ProresTelecine>,
}
impl ProresSettings {
    /// This setting applies only to ProRes 4444 and ProRes 4444 XQ outputs that you create from inputs that use 4:4:4 chroma sampling. Set Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING) to allow outputs to also use 4:4:4 chroma sampling. You must specify a value for this setting when your output codec profile supports 4:4:4 chroma sampling. Related Settings: When you set Chroma sampling to Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING), you must choose an output codec profile that supports 4:4:4 chroma sampling. These values for Profile (CodecProfile) support 4:4:4 chroma sampling: Apple ProRes 4444 (APPLE_PRORES_4444) or Apple ProRes 4444 XQ (APPLE_PRORES_4444_XQ). When you set Chroma sampling to Preserve 4:4:4 sampling, you must disable all video preprocessors except for Nexguard file marker (PartnerWatermarking). When you set Chroma sampling to Preserve 4:4:4 sampling and use framerate conversion, you must set Frame rate conversion algorithm (FramerateConversionAlgorithm) to Drop duplicate (DUPLICATE_DROP).
    pub fn chroma_sampling(&self) -> std::option::Option<&crate::model::ProresChromaSampling> {
        self.chroma_sampling.as_ref()
    }
    /// Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
    pub fn codec_profile(&self) -> std::option::Option<&crate::model::ProresCodecProfile> {
        self.codec_profile.as_ref()
    }
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::ProresFramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::ProresFramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub fn interlace_mode(&self) -> std::option::Option<&crate::model::ProresInterlaceMode> {
        self.interlace_mode.as_ref()
    }
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub fn par_control(&self) -> std::option::Option<&crate::model::ProresParControl> {
        self.par_control.as_ref()
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub fn par_denominator(&self) -> i32 {
        self.par_denominator
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub fn par_numerator(&self) -> i32 {
        self.par_numerator
    }
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub fn scan_type_conversion_mode(
        &self,
    ) -> std::option::Option<&crate::model::ProresScanTypeConversionMode> {
        self.scan_type_conversion_mode.as_ref()
    }
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub fn slow_pal(&self) -> std::option::Option<&crate::model::ProresSlowPal> {
        self.slow_pal.as_ref()
    }
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub fn telecine(&self) -> std::option::Option<&crate::model::ProresTelecine> {
        self.telecine.as_ref()
    }
}
impl std::fmt::Debug for ProresSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProresSettings");
        formatter.field("chroma_sampling", &self.chroma_sampling);
        formatter.field("codec_profile", &self.codec_profile);
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("interlace_mode", &self.interlace_mode);
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("scan_type_conversion_mode", &self.scan_type_conversion_mode);
        formatter.field("slow_pal", &self.slow_pal);
        formatter.field("telecine", &self.telecine);
        formatter.finish()
    }
}
/// See [`ProresSettings`](crate::model::ProresSettings)
pub mod prores_settings {
    /// A builder for [`ProresSettings`](crate::model::ProresSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) chroma_sampling: std::option::Option<crate::model::ProresChromaSampling>,
        pub(crate) codec_profile: std::option::Option<crate::model::ProresCodecProfile>,
        pub(crate) framerate_control: std::option::Option<crate::model::ProresFramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::ProresFramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) interlace_mode: std::option::Option<crate::model::ProresInterlaceMode>,
        pub(crate) par_control: std::option::Option<crate::model::ProresParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) scan_type_conversion_mode:
            std::option::Option<crate::model::ProresScanTypeConversionMode>,
        pub(crate) slow_pal: std::option::Option<crate::model::ProresSlowPal>,
        pub(crate) telecine: std::option::Option<crate::model::ProresTelecine>,
    }
    impl Builder {
        /// This setting applies only to ProRes 4444 and ProRes 4444 XQ outputs that you create from inputs that use 4:4:4 chroma sampling. Set Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING) to allow outputs to also use 4:4:4 chroma sampling. You must specify a value for this setting when your output codec profile supports 4:4:4 chroma sampling. Related Settings: When you set Chroma sampling to Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING), you must choose an output codec profile that supports 4:4:4 chroma sampling. These values for Profile (CodecProfile) support 4:4:4 chroma sampling: Apple ProRes 4444 (APPLE_PRORES_4444) or Apple ProRes 4444 XQ (APPLE_PRORES_4444_XQ). When you set Chroma sampling to Preserve 4:4:4 sampling, you must disable all video preprocessors except for Nexguard file marker (PartnerWatermarking). When you set Chroma sampling to Preserve 4:4:4 sampling and use framerate conversion, you must set Frame rate conversion algorithm (FramerateConversionAlgorithm) to Drop duplicate (DUPLICATE_DROP).
        pub fn chroma_sampling(mut self, input: crate::model::ProresChromaSampling) -> Self {
            self.chroma_sampling = Some(input);
            self
        }
        /// This setting applies only to ProRes 4444 and ProRes 4444 XQ outputs that you create from inputs that use 4:4:4 chroma sampling. Set Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING) to allow outputs to also use 4:4:4 chroma sampling. You must specify a value for this setting when your output codec profile supports 4:4:4 chroma sampling. Related Settings: When you set Chroma sampling to Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING), you must choose an output codec profile that supports 4:4:4 chroma sampling. These values for Profile (CodecProfile) support 4:4:4 chroma sampling: Apple ProRes 4444 (APPLE_PRORES_4444) or Apple ProRes 4444 XQ (APPLE_PRORES_4444_XQ). When you set Chroma sampling to Preserve 4:4:4 sampling, you must disable all video preprocessors except for Nexguard file marker (PartnerWatermarking). When you set Chroma sampling to Preserve 4:4:4 sampling and use framerate conversion, you must set Frame rate conversion algorithm (FramerateConversionAlgorithm) to Drop duplicate (DUPLICATE_DROP).
        pub fn set_chroma_sampling(
            mut self,
            input: std::option::Option<crate::model::ProresChromaSampling>,
        ) -> Self {
            self.chroma_sampling = input;
            self
        }
        /// Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
        pub fn codec_profile(mut self, input: crate::model::ProresCodecProfile) -> Self {
            self.codec_profile = Some(input);
            self
        }
        /// Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
        pub fn set_codec_profile(
            mut self,
            input: std::option::Option<crate::model::ProresCodecProfile>,
        ) -> Self {
            self.codec_profile = input;
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::ProresFramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::ProresFramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::ProresFramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::ProresFramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn interlace_mode(mut self, input: crate::model::ProresInterlaceMode) -> Self {
            self.interlace_mode = Some(input);
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn set_interlace_mode(
            mut self,
            input: std::option::Option<crate::model::ProresInterlaceMode>,
        ) -> Self {
            self.interlace_mode = input;
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn par_control(mut self, input: crate::model::ProresParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::ProresParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn scan_type_conversion_mode(
            mut self,
            input: crate::model::ProresScanTypeConversionMode,
        ) -> Self {
            self.scan_type_conversion_mode = Some(input);
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn set_scan_type_conversion_mode(
            mut self,
            input: std::option::Option<crate::model::ProresScanTypeConversionMode>,
        ) -> Self {
            self.scan_type_conversion_mode = input;
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn slow_pal(mut self, input: crate::model::ProresSlowPal) -> Self {
            self.slow_pal = Some(input);
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn set_slow_pal(
            mut self,
            input: std::option::Option<crate::model::ProresSlowPal>,
        ) -> Self {
            self.slow_pal = input;
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn telecine(mut self, input: crate::model::ProresTelecine) -> Self {
            self.telecine = Some(input);
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn set_telecine(
            mut self,
            input: std::option::Option<crate::model::ProresTelecine>,
        ) -> Self {
            self.telecine = input;
            self
        }
        /// Consumes the builder and constructs a [`ProresSettings`](crate::model::ProresSettings)
        pub fn build(self) -> crate::model::ProresSettings {
            crate::model::ProresSettings {
                chroma_sampling: self.chroma_sampling,
                codec_profile: self.codec_profile,
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                interlace_mode: self.interlace_mode,
                par_control: self.par_control,
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                scan_type_conversion_mode: self.scan_type_conversion_mode,
                slow_pal: self.slow_pal,
                telecine: self.telecine,
            }
        }
    }
}
impl ProresSettings {
    /// Creates a new builder-style object to manufacture [`ProresSettings`](crate::model::ProresSettings)
    pub fn builder() -> crate::model::prores_settings::Builder {
        crate::model::prores_settings::Builder::default()
    }
}

/// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard telecine (HARD) to create a smoother picture. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresTelecine {
    #[allow(missing_docs)] // documentation missing in model
    Hard,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresTelecine {
    fn from(s: &str) -> Self {
        match s {
            "HARD" => ProresTelecine::Hard,
            "NONE" => ProresTelecine::None,
            other => ProresTelecine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresTelecine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresTelecine::from(s))
    }
}
impl ProresTelecine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresTelecine::Hard => "HARD",
            ProresTelecine::None => "NONE",
            ProresTelecine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HARD", "NONE"]
    }
}
impl AsRef<str> for ProresTelecine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresSlowPal {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresSlowPal {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => ProresSlowPal::Disabled,
            "ENABLED" => ProresSlowPal::Enabled,
            other => ProresSlowPal::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresSlowPal {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresSlowPal::from(s))
    }
}
impl ProresSlowPal {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresSlowPal::Disabled => "DISABLED",
            ProresSlowPal::Enabled => "ENABLED",
            ProresSlowPal::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for ProresSlowPal {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresScanTypeConversionMode {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    InterlacedOptimize,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresScanTypeConversionMode {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => ProresScanTypeConversionMode::Interlaced,
            "INTERLACED_OPTIMIZE" => ProresScanTypeConversionMode::InterlacedOptimize,
            other => ProresScanTypeConversionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresScanTypeConversionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresScanTypeConversionMode::from(s))
    }
}
impl ProresScanTypeConversionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresScanTypeConversionMode::Interlaced => "INTERLACED",
            ProresScanTypeConversionMode::InterlacedOptimize => "INTERLACED_OPTIMIZE",
            ProresScanTypeConversionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "INTERLACED_OPTIMIZE"]
    }
}
impl AsRef<str> for ProresScanTypeConversionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresParControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresParControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => ProresParControl::InitializeFromSource,
            "SPECIFIED" => ProresParControl::Specified,
            other => ProresParControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresParControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresParControl::from(s))
    }
}
impl ProresParControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresParControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            ProresParControl::Specified => "SPECIFIED",
            ProresParControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for ProresParControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresInterlaceMode {
    #[allow(missing_docs)] // documentation missing in model
    BottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowBottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowTopField,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    #[allow(missing_docs)] // documentation missing in model
    TopField,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresInterlaceMode {
    fn from(s: &str) -> Self {
        match s {
            "BOTTOM_FIELD" => ProresInterlaceMode::BottomField,
            "FOLLOW_BOTTOM_FIELD" => ProresInterlaceMode::FollowBottomField,
            "FOLLOW_TOP_FIELD" => ProresInterlaceMode::FollowTopField,
            "PROGRESSIVE" => ProresInterlaceMode::Progressive,
            "TOP_FIELD" => ProresInterlaceMode::TopField,
            other => ProresInterlaceMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresInterlaceMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresInterlaceMode::from(s))
    }
}
impl ProresInterlaceMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresInterlaceMode::BottomField => "BOTTOM_FIELD",
            ProresInterlaceMode::FollowBottomField => "FOLLOW_BOTTOM_FIELD",
            ProresInterlaceMode::FollowTopField => "FOLLOW_TOP_FIELD",
            ProresInterlaceMode::Progressive => "PROGRESSIVE",
            ProresInterlaceMode::TopField => "TOP_FIELD",
            ProresInterlaceMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOTTOM_FIELD",
            "FOLLOW_BOTTOM_FIELD",
            "FOLLOW_TOP_FIELD",
            "PROGRESSIVE",
            "TOP_FIELD",
        ]
    }
}
impl AsRef<str> for ProresInterlaceMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresFramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresFramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => ProresFramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => ProresFramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => ProresFramerateConversionAlgorithm::Interpolate,
            other => ProresFramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresFramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresFramerateConversionAlgorithm::from(s))
    }
}
impl ProresFramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresFramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            ProresFramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            ProresFramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            ProresFramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for ProresFramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresFramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresFramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => ProresFramerateControl::InitializeFromSource,
            "SPECIFIED" => ProresFramerateControl::Specified,
            other => ProresFramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresFramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresFramerateControl::from(s))
    }
}
impl ProresFramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresFramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            ProresFramerateControl::Specified => "SPECIFIED",
            ProresFramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for ProresFramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Profile (ProResCodecProfile) to specify the type of Apple ProRes codec to use for this output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresCodecProfile {
    #[allow(missing_docs)] // documentation missing in model
    AppleProres422,
    #[allow(missing_docs)] // documentation missing in model
    AppleProres422Hq,
    #[allow(missing_docs)] // documentation missing in model
    AppleProres422Lt,
    #[allow(missing_docs)] // documentation missing in model
    AppleProres422Proxy,
    #[allow(missing_docs)] // documentation missing in model
    AppleProres4444,
    #[allow(missing_docs)] // documentation missing in model
    AppleProres4444Xq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresCodecProfile {
    fn from(s: &str) -> Self {
        match s {
            "APPLE_PRORES_422" => ProresCodecProfile::AppleProres422,
            "APPLE_PRORES_422_HQ" => ProresCodecProfile::AppleProres422Hq,
            "APPLE_PRORES_422_LT" => ProresCodecProfile::AppleProres422Lt,
            "APPLE_PRORES_422_PROXY" => ProresCodecProfile::AppleProres422Proxy,
            "APPLE_PRORES_4444" => ProresCodecProfile::AppleProres4444,
            "APPLE_PRORES_4444_XQ" => ProresCodecProfile::AppleProres4444Xq,
            other => ProresCodecProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresCodecProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresCodecProfile::from(s))
    }
}
impl ProresCodecProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresCodecProfile::AppleProres422 => "APPLE_PRORES_422",
            ProresCodecProfile::AppleProres422Hq => "APPLE_PRORES_422_HQ",
            ProresCodecProfile::AppleProres422Lt => "APPLE_PRORES_422_LT",
            ProresCodecProfile::AppleProres422Proxy => "APPLE_PRORES_422_PROXY",
            ProresCodecProfile::AppleProres4444 => "APPLE_PRORES_4444",
            ProresCodecProfile::AppleProres4444Xq => "APPLE_PRORES_4444_XQ",
            ProresCodecProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "APPLE_PRORES_422",
            "APPLE_PRORES_422_HQ",
            "APPLE_PRORES_422_LT",
            "APPLE_PRORES_422_PROXY",
            "APPLE_PRORES_4444",
            "APPLE_PRORES_4444_XQ",
        ]
    }
}
impl AsRef<str> for ProresCodecProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// This setting applies only to ProRes 4444 and ProRes 4444 XQ outputs that you create from inputs that use 4:4:4 chroma sampling. Set Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING) to allow outputs to also use 4:4:4 chroma sampling. You must specify a value for this setting when your output codec profile supports 4:4:4 chroma sampling. Related Settings: When you set Chroma sampling to Preserve 4:4:4 sampling (PRESERVE_444_SAMPLING), you must choose an output codec profile that supports 4:4:4 chroma sampling. These values for Profile (CodecProfile) support 4:4:4 chroma sampling: Apple ProRes 4444 (APPLE_PRORES_4444) or Apple ProRes 4444 XQ (APPLE_PRORES_4444_XQ). When you set Chroma sampling to Preserve 4:4:4 sampling, you must disable all video preprocessors except for Nexguard file marker (PartnerWatermarking). When you set Chroma sampling to Preserve 4:4:4 sampling and use framerate conversion, you must set Frame rate conversion algorithm (FramerateConversionAlgorithm) to Drop duplicate (DUPLICATE_DROP).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProresChromaSampling {
    #[allow(missing_docs)] // documentation missing in model
    Preserve444Sampling,
    #[allow(missing_docs)] // documentation missing in model
    SubsampleTo422,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProresChromaSampling {
    fn from(s: &str) -> Self {
        match s {
            "PRESERVE_444_SAMPLING" => ProresChromaSampling::Preserve444Sampling,
            "SUBSAMPLE_TO_422" => ProresChromaSampling::SubsampleTo422,
            other => ProresChromaSampling::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProresChromaSampling {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProresChromaSampling::from(s))
    }
}
impl ProresChromaSampling {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProresChromaSampling::Preserve444Sampling => "PRESERVE_444_SAMPLING",
            ProresChromaSampling::SubsampleTo422 => "SUBSAMPLE_TO_422",
            ProresChromaSampling::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["PRESERVE_444_SAMPLING", "SUBSAMPLE_TO_422"]
    }
}
impl AsRef<str> for ProresChromaSampling {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value MPEG2.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Mpeg2Settings {
    /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
    pub adaptive_quantization: std::option::Option<crate::model::Mpeg2AdaptiveQuantization>,
    /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
    pub bitrate: i32,
    /// Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
    pub codec_level: std::option::Option<crate::model::Mpeg2CodecLevel>,
    /// Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
    pub codec_profile: std::option::Option<crate::model::Mpeg2CodecProfile>,
    /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
    pub dynamic_sub_gop: std::option::Option<crate::model::Mpeg2DynamicSubGop>,
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::Mpeg2FramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::Mpeg2FramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// Specify the interval between keyframes, in seconds or frames, for this output. Default: 12 Related settings: When you specify the GOP size in seconds, set GOP mode control (GopSizeUnits) to Specified, seconds (SECONDS). The default value for GOP mode control (GopSizeUnits) is Frames (FRAMES).
    pub gop_size: f64,
    /// Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
    pub gop_size_units: std::option::Option<crate::model::Mpeg2GopSizeUnits>,
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub hrd_buffer_initial_fill_percentage: i32,
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub hrd_buffer_size: i32,
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub interlace_mode: std::option::Option<crate::model::Mpeg2InterlaceMode>,
    /// Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
    pub intra_dc_precision: std::option::Option<crate::model::Mpeg2IntraDcPrecision>,
    /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
    pub max_bitrate: i32,
    /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub min_i_interval: i32,
    /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
    pub number_b_frames_between_reference_frames: i32,
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub par_control: std::option::Option<crate::model::Mpeg2ParControl>,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub par_denominator: i32,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub par_numerator: i32,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::Mpeg2QualityTuningLevel>,
    /// Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
    pub rate_control_mode: std::option::Option<crate::model::Mpeg2RateControlMode>,
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub scan_type_conversion_mode: std::option::Option<crate::model::Mpeg2ScanTypeConversionMode>,
    /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
    pub scene_change_detect: std::option::Option<crate::model::Mpeg2SceneChangeDetect>,
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub slow_pal: std::option::Option<crate::model::Mpeg2SlowPal>,
    /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, to use the AWS Elemental default matrices. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
    pub softness: i32,
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
    pub spatial_adaptive_quantization:
        std::option::Option<crate::model::Mpeg2SpatialAdaptiveQuantization>,
    /// Specify whether this output's video uses the D10 syntax. Keep the default value to  not use the syntax. Related settings: When you choose D10 (D_10) for your MXF  profile (profile), you must also set this value to to D10 (D_10).
    pub syntax: std::option::Option<crate::model::Mpeg2Syntax>,
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub telecine: std::option::Option<crate::model::Mpeg2Telecine>,
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
    pub temporal_adaptive_quantization:
        std::option::Option<crate::model::Mpeg2TemporalAdaptiveQuantization>,
}
impl Mpeg2Settings {
    /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
    pub fn adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2AdaptiveQuantization> {
        self.adaptive_quantization.as_ref()
    }
    /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
    pub fn bitrate(&self) -> i32 {
        self.bitrate
    }
    /// Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
    pub fn codec_level(&self) -> std::option::Option<&crate::model::Mpeg2CodecLevel> {
        self.codec_level.as_ref()
    }
    /// Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
    pub fn codec_profile(&self) -> std::option::Option<&crate::model::Mpeg2CodecProfile> {
        self.codec_profile.as_ref()
    }
    /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
    pub fn dynamic_sub_gop(&self) -> std::option::Option<&crate::model::Mpeg2DynamicSubGop> {
        self.dynamic_sub_gop.as_ref()
    }
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::Mpeg2FramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2FramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub fn gop_closed_cadence(&self) -> i32 {
        self.gop_closed_cadence
    }
    /// Specify the interval between keyframes, in seconds or frames, for this output. Default: 12 Related settings: When you specify the GOP size in seconds, set GOP mode control (GopSizeUnits) to Specified, seconds (SECONDS). The default value for GOP mode control (GopSizeUnits) is Frames (FRAMES).
    pub fn gop_size(&self) -> f64 {
        self.gop_size
    }
    /// Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
    pub fn gop_size_units(&self) -> std::option::Option<&crate::model::Mpeg2GopSizeUnits> {
        self.gop_size_units.as_ref()
    }
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub fn hrd_buffer_initial_fill_percentage(&self) -> i32 {
        self.hrd_buffer_initial_fill_percentage
    }
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub fn interlace_mode(&self) -> std::option::Option<&crate::model::Mpeg2InterlaceMode> {
        self.interlace_mode.as_ref()
    }
    /// Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
    pub fn intra_dc_precision(&self) -> std::option::Option<&crate::model::Mpeg2IntraDcPrecision> {
        self.intra_dc_precision.as_ref()
    }
    /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
    pub fn max_bitrate(&self) -> i32 {
        self.max_bitrate
    }
    /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub fn min_i_interval(&self) -> i32 {
        self.min_i_interval
    }
    /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
    pub fn number_b_frames_between_reference_frames(&self) -> i32 {
        self.number_b_frames_between_reference_frames
    }
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub fn par_control(&self) -> std::option::Option<&crate::model::Mpeg2ParControl> {
        self.par_control.as_ref()
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub fn par_denominator(&self) -> i32 {
        self.par_denominator
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub fn par_numerator(&self) -> i32 {
        self.par_numerator
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2QualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
    pub fn rate_control_mode(&self) -> std::option::Option<&crate::model::Mpeg2RateControlMode> {
        self.rate_control_mode.as_ref()
    }
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub fn scan_type_conversion_mode(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2ScanTypeConversionMode> {
        self.scan_type_conversion_mode.as_ref()
    }
    /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
    pub fn scene_change_detect(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2SceneChangeDetect> {
        self.scene_change_detect.as_ref()
    }
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub fn slow_pal(&self) -> std::option::Option<&crate::model::Mpeg2SlowPal> {
        self.slow_pal.as_ref()
    }
    /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, to use the AWS Elemental default matrices. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
    pub fn softness(&self) -> i32 {
        self.softness
    }
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
    pub fn spatial_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2SpatialAdaptiveQuantization> {
        self.spatial_adaptive_quantization.as_ref()
    }
    /// Specify whether this output's video uses the D10 syntax. Keep the default value to  not use the syntax. Related settings: When you choose D10 (D_10) for your MXF  profile (profile), you must also set this value to to D10 (D_10).
    pub fn syntax(&self) -> std::option::Option<&crate::model::Mpeg2Syntax> {
        self.syntax.as_ref()
    }
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub fn telecine(&self) -> std::option::Option<&crate::model::Mpeg2Telecine> {
        self.telecine.as_ref()
    }
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
    pub fn temporal_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::Mpeg2TemporalAdaptiveQuantization> {
        self.temporal_adaptive_quantization.as_ref()
    }
}
impl std::fmt::Debug for Mpeg2Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Mpeg2Settings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field("bitrate", &self.bitrate);
        formatter.field("codec_level", &self.codec_level);
        formatter.field("codec_profile", &self.codec_profile);
        formatter.field("dynamic_sub_gop", &self.dynamic_sub_gop);
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("gop_size_units", &self.gop_size_units);
        formatter.field(
            "hrd_buffer_initial_fill_percentage",
            &self.hrd_buffer_initial_fill_percentage,
        );
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("interlace_mode", &self.interlace_mode);
        formatter.field("intra_dc_precision", &self.intra_dc_precision);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("min_i_interval", &self.min_i_interval);
        formatter.field(
            "number_b_frames_between_reference_frames",
            &self.number_b_frames_between_reference_frames,
        );
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.field("scan_type_conversion_mode", &self.scan_type_conversion_mode);
        formatter.field("scene_change_detect", &self.scene_change_detect);
        formatter.field("slow_pal", &self.slow_pal);
        formatter.field("softness", &self.softness);
        formatter.field(
            "spatial_adaptive_quantization",
            &self.spatial_adaptive_quantization,
        );
        formatter.field("syntax", &self.syntax);
        formatter.field("telecine", &self.telecine);
        formatter.field(
            "temporal_adaptive_quantization",
            &self.temporal_adaptive_quantization,
        );
        formatter.finish()
    }
}
/// See [`Mpeg2Settings`](crate::model::Mpeg2Settings)
pub mod mpeg2_settings {
    /// A builder for [`Mpeg2Settings`](crate::model::Mpeg2Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::Mpeg2AdaptiveQuantization>,
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) codec_level: std::option::Option<crate::model::Mpeg2CodecLevel>,
        pub(crate) codec_profile: std::option::Option<crate::model::Mpeg2CodecProfile>,
        pub(crate) dynamic_sub_gop: std::option::Option<crate::model::Mpeg2DynamicSubGop>,
        pub(crate) framerate_control: std::option::Option<crate::model::Mpeg2FramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::Mpeg2FramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) gop_size_units: std::option::Option<crate::model::Mpeg2GopSizeUnits>,
        pub(crate) hrd_buffer_initial_fill_percentage: std::option::Option<i32>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) interlace_mode: std::option::Option<crate::model::Mpeg2InterlaceMode>,
        pub(crate) intra_dc_precision: std::option::Option<crate::model::Mpeg2IntraDcPrecision>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) min_i_interval: std::option::Option<i32>,
        pub(crate) number_b_frames_between_reference_frames: std::option::Option<i32>,
        pub(crate) par_control: std::option::Option<crate::model::Mpeg2ParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) quality_tuning_level: std::option::Option<crate::model::Mpeg2QualityTuningLevel>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::Mpeg2RateControlMode>,
        pub(crate) scan_type_conversion_mode:
            std::option::Option<crate::model::Mpeg2ScanTypeConversionMode>,
        pub(crate) scene_change_detect: std::option::Option<crate::model::Mpeg2SceneChangeDetect>,
        pub(crate) slow_pal: std::option::Option<crate::model::Mpeg2SlowPal>,
        pub(crate) softness: std::option::Option<i32>,
        pub(crate) spatial_adaptive_quantization:
            std::option::Option<crate::model::Mpeg2SpatialAdaptiveQuantization>,
        pub(crate) syntax: std::option::Option<crate::model::Mpeg2Syntax>,
        pub(crate) telecine: std::option::Option<crate::model::Mpeg2Telecine>,
        pub(crate) temporal_adaptive_quantization:
            std::option::Option<crate::model::Mpeg2TemporalAdaptiveQuantization>,
    }
    impl Builder {
        /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::Mpeg2AdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::Mpeg2AdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
        pub fn codec_level(mut self, input: crate::model::Mpeg2CodecLevel) -> Self {
            self.codec_level = Some(input);
            self
        }
        /// Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
        pub fn set_codec_level(
            mut self,
            input: std::option::Option<crate::model::Mpeg2CodecLevel>,
        ) -> Self {
            self.codec_level = input;
            self
        }
        /// Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
        pub fn codec_profile(mut self, input: crate::model::Mpeg2CodecProfile) -> Self {
            self.codec_profile = Some(input);
            self
        }
        /// Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
        pub fn set_codec_profile(
            mut self,
            input: std::option::Option<crate::model::Mpeg2CodecProfile>,
        ) -> Self {
            self.codec_profile = input;
            self
        }
        /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
        pub fn dynamic_sub_gop(mut self, input: crate::model::Mpeg2DynamicSubGop) -> Self {
            self.dynamic_sub_gop = Some(input);
            self
        }
        /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
        pub fn set_dynamic_sub_gop(
            mut self,
            input: std::option::Option<crate::model::Mpeg2DynamicSubGop>,
        ) -> Self {
            self.dynamic_sub_gop = input;
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::Mpeg2FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::Mpeg2FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::Mpeg2FramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::Mpeg2FramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// Specify the interval between keyframes, in seconds or frames, for this output. Default: 12 Related settings: When you specify the GOP size in seconds, set GOP mode control (GopSizeUnits) to Specified, seconds (SECONDS). The default value for GOP mode control (GopSizeUnits) is Frames (FRAMES).
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// Specify the interval between keyframes, in seconds or frames, for this output. Default: 12 Related settings: When you specify the GOP size in seconds, set GOP mode control (GopSizeUnits) to Specified, seconds (SECONDS). The default value for GOP mode control (GopSizeUnits) is Frames (FRAMES).
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
        pub fn gop_size_units(mut self, input: crate::model::Mpeg2GopSizeUnits) -> Self {
            self.gop_size_units = Some(input);
            self
        }
        /// Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
        pub fn set_gop_size_units(
            mut self,
            input: std::option::Option<crate::model::Mpeg2GopSizeUnits>,
        ) -> Self {
            self.gop_size_units = input;
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn hrd_buffer_initial_fill_percentage(mut self, input: i32) -> Self {
            self.hrd_buffer_initial_fill_percentage = Some(input);
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn set_hrd_buffer_initial_fill_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.hrd_buffer_initial_fill_percentage = input;
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn interlace_mode(mut self, input: crate::model::Mpeg2InterlaceMode) -> Self {
            self.interlace_mode = Some(input);
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn set_interlace_mode(
            mut self,
            input: std::option::Option<crate::model::Mpeg2InterlaceMode>,
        ) -> Self {
            self.interlace_mode = input;
            self
        }
        /// Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
        pub fn intra_dc_precision(mut self, input: crate::model::Mpeg2IntraDcPrecision) -> Self {
            self.intra_dc_precision = Some(input);
            self
        }
        /// Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
        pub fn set_intra_dc_precision(
            mut self,
            input: std::option::Option<crate::model::Mpeg2IntraDcPrecision>,
        ) -> Self {
            self.intra_dc_precision = input;
            self
        }
        /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn min_i_interval(mut self, input: i32) -> Self {
            self.min_i_interval = Some(input);
            self
        }
        /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn set_min_i_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.min_i_interval = input;
            self
        }
        /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
        pub fn number_b_frames_between_reference_frames(mut self, input: i32) -> Self {
            self.number_b_frames_between_reference_frames = Some(input);
            self
        }
        /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
        pub fn set_number_b_frames_between_reference_frames(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_b_frames_between_reference_frames = input;
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn par_control(mut self, input: crate::model::Mpeg2ParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::Mpeg2ParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn quality_tuning_level(
            mut self,
            input: crate::model::Mpeg2QualityTuningLevel,
        ) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::Mpeg2QualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
        pub fn rate_control_mode(mut self, input: crate::model::Mpeg2RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::Mpeg2RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn scan_type_conversion_mode(
            mut self,
            input: crate::model::Mpeg2ScanTypeConversionMode,
        ) -> Self {
            self.scan_type_conversion_mode = Some(input);
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn set_scan_type_conversion_mode(
            mut self,
            input: std::option::Option<crate::model::Mpeg2ScanTypeConversionMode>,
        ) -> Self {
            self.scan_type_conversion_mode = input;
            self
        }
        /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
        pub fn scene_change_detect(mut self, input: crate::model::Mpeg2SceneChangeDetect) -> Self {
            self.scene_change_detect = Some(input);
            self
        }
        /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
        pub fn set_scene_change_detect(
            mut self,
            input: std::option::Option<crate::model::Mpeg2SceneChangeDetect>,
        ) -> Self {
            self.scene_change_detect = input;
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn slow_pal(mut self, input: crate::model::Mpeg2SlowPal) -> Self {
            self.slow_pal = Some(input);
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn set_slow_pal(
            mut self,
            input: std::option::Option<crate::model::Mpeg2SlowPal>,
        ) -> Self {
            self.slow_pal = input;
            self
        }
        /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, to use the AWS Elemental default matrices. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
        pub fn softness(mut self, input: i32) -> Self {
            self.softness = Some(input);
            self
        }
        /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, to use the AWS Elemental default matrices. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
        pub fn set_softness(mut self, input: std::option::Option<i32>) -> Self {
            self.softness = input;
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
        pub fn spatial_adaptive_quantization(
            mut self,
            input: crate::model::Mpeg2SpatialAdaptiveQuantization,
        ) -> Self {
            self.spatial_adaptive_quantization = Some(input);
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
        pub fn set_spatial_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::Mpeg2SpatialAdaptiveQuantization>,
        ) -> Self {
            self.spatial_adaptive_quantization = input;
            self
        }
        /// Specify whether this output's video uses the D10 syntax. Keep the default value to  not use the syntax. Related settings: When you choose D10 (D_10) for your MXF  profile (profile), you must also set this value to to D10 (D_10).
        pub fn syntax(mut self, input: crate::model::Mpeg2Syntax) -> Self {
            self.syntax = Some(input);
            self
        }
        /// Specify whether this output's video uses the D10 syntax. Keep the default value to  not use the syntax. Related settings: When you choose D10 (D_10) for your MXF  profile (profile), you must also set this value to to D10 (D_10).
        pub fn set_syntax(mut self, input: std::option::Option<crate::model::Mpeg2Syntax>) -> Self {
            self.syntax = input;
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn telecine(mut self, input: crate::model::Mpeg2Telecine) -> Self {
            self.telecine = Some(input);
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn set_telecine(
            mut self,
            input: std::option::Option<crate::model::Mpeg2Telecine>,
        ) -> Self {
            self.telecine = input;
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
        pub fn temporal_adaptive_quantization(
            mut self,
            input: crate::model::Mpeg2TemporalAdaptiveQuantization,
        ) -> Self {
            self.temporal_adaptive_quantization = Some(input);
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
        pub fn set_temporal_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::Mpeg2TemporalAdaptiveQuantization>,
        ) -> Self {
            self.temporal_adaptive_quantization = input;
            self
        }
        /// Consumes the builder and constructs a [`Mpeg2Settings`](crate::model::Mpeg2Settings)
        pub fn build(self) -> crate::model::Mpeg2Settings {
            crate::model::Mpeg2Settings {
                adaptive_quantization: self.adaptive_quantization,
                bitrate: self.bitrate.unwrap_or_default(),
                codec_level: self.codec_level,
                codec_profile: self.codec_profile,
                dynamic_sub_gop: self.dynamic_sub_gop,
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                gop_size_units: self.gop_size_units,
                hrd_buffer_initial_fill_percentage: self
                    .hrd_buffer_initial_fill_percentage
                    .unwrap_or_default(),
                hrd_buffer_size: self.hrd_buffer_size.unwrap_or_default(),
                interlace_mode: self.interlace_mode,
                intra_dc_precision: self.intra_dc_precision,
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                min_i_interval: self.min_i_interval.unwrap_or_default(),
                number_b_frames_between_reference_frames: self
                    .number_b_frames_between_reference_frames
                    .unwrap_or_default(),
                par_control: self.par_control,
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                quality_tuning_level: self.quality_tuning_level,
                rate_control_mode: self.rate_control_mode,
                scan_type_conversion_mode: self.scan_type_conversion_mode,
                scene_change_detect: self.scene_change_detect,
                slow_pal: self.slow_pal,
                softness: self.softness.unwrap_or_default(),
                spatial_adaptive_quantization: self.spatial_adaptive_quantization,
                syntax: self.syntax,
                telecine: self.telecine,
                temporal_adaptive_quantization: self.temporal_adaptive_quantization,
            }
        }
    }
}
impl Mpeg2Settings {
    /// Creates a new builder-style object to manufacture [`Mpeg2Settings`](crate::model::Mpeg2Settings)
    pub fn builder() -> crate::model::mpeg2_settings::Builder {
        crate::model::mpeg2_settings::Builder::default()
    }
}

/// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2TemporalAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2TemporalAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Mpeg2TemporalAdaptiveQuantization::Disabled,
            "ENABLED" => Mpeg2TemporalAdaptiveQuantization::Enabled,
            other => Mpeg2TemporalAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2TemporalAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2TemporalAdaptiveQuantization::from(s))
    }
}
impl Mpeg2TemporalAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2TemporalAdaptiveQuantization::Disabled => "DISABLED",
            Mpeg2TemporalAdaptiveQuantization::Enabled => "ENABLED",
            Mpeg2TemporalAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Mpeg2TemporalAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2Telecine {
    #[allow(missing_docs)] // documentation missing in model
    Hard,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Soft,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2Telecine {
    fn from(s: &str) -> Self {
        match s {
            "HARD" => Mpeg2Telecine::Hard,
            "NONE" => Mpeg2Telecine::None,
            "SOFT" => Mpeg2Telecine::Soft,
            other => Mpeg2Telecine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2Telecine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2Telecine::from(s))
    }
}
impl Mpeg2Telecine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2Telecine::Hard => "HARD",
            Mpeg2Telecine::None => "NONE",
            Mpeg2Telecine::Soft => "SOFT",
            Mpeg2Telecine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HARD", "NONE", "SOFT"]
    }
}
impl AsRef<str> for Mpeg2Telecine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify whether this output's video uses the D10 syntax. Keep the default value to  not use the syntax. Related settings: When you choose D10 (D_10) for your MXF  profile (profile), you must also set this value to to D10 (D_10).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2Syntax {
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    D10,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2Syntax {
    fn from(s: &str) -> Self {
        match s {
            "DEFAULT" => Mpeg2Syntax::Default,
            "D_10" => Mpeg2Syntax::D10,
            other => Mpeg2Syntax::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2Syntax {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2Syntax::from(s))
    }
}
impl Mpeg2Syntax {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2Syntax::Default => "DEFAULT",
            Mpeg2Syntax::D10 => "D_10",
            Mpeg2Syntax::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DEFAULT", "D_10"]
    }
}
impl AsRef<str> for Mpeg2Syntax {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2SpatialAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2SpatialAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Mpeg2SpatialAdaptiveQuantization::Disabled,
            "ENABLED" => Mpeg2SpatialAdaptiveQuantization::Enabled,
            other => Mpeg2SpatialAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2SpatialAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2SpatialAdaptiveQuantization::from(s))
    }
}
impl Mpeg2SpatialAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2SpatialAdaptiveQuantization::Disabled => "DISABLED",
            Mpeg2SpatialAdaptiveQuantization::Enabled => "ENABLED",
            Mpeg2SpatialAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Mpeg2SpatialAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2SlowPal {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2SlowPal {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Mpeg2SlowPal::Disabled,
            "ENABLED" => Mpeg2SlowPal::Enabled,
            other => Mpeg2SlowPal::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2SlowPal {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2SlowPal::from(s))
    }
}
impl Mpeg2SlowPal {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2SlowPal::Disabled => "DISABLED",
            Mpeg2SlowPal::Enabled => "ENABLED",
            Mpeg2SlowPal::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Mpeg2SlowPal {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2SceneChangeDetect {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2SceneChangeDetect {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => Mpeg2SceneChangeDetect::Disabled,
            "ENABLED" => Mpeg2SceneChangeDetect::Enabled,
            other => Mpeg2SceneChangeDetect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2SceneChangeDetect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2SceneChangeDetect::from(s))
    }
}
impl Mpeg2SceneChangeDetect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2SceneChangeDetect::Disabled => "DISABLED",
            Mpeg2SceneChangeDetect::Enabled => "ENABLED",
            Mpeg2SceneChangeDetect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for Mpeg2SceneChangeDetect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2ScanTypeConversionMode {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    InterlacedOptimize,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2ScanTypeConversionMode {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => Mpeg2ScanTypeConversionMode::Interlaced,
            "INTERLACED_OPTIMIZE" => Mpeg2ScanTypeConversionMode::InterlacedOptimize,
            other => Mpeg2ScanTypeConversionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2ScanTypeConversionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2ScanTypeConversionMode::from(s))
    }
}
impl Mpeg2ScanTypeConversionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2ScanTypeConversionMode::Interlaced => "INTERLACED",
            Mpeg2ScanTypeConversionMode::InterlacedOptimize => "INTERLACED_OPTIMIZE",
            Mpeg2ScanTypeConversionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "INTERLACED_OPTIMIZE"]
    }
}
impl AsRef<str> for Mpeg2ScanTypeConversionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Rate control mode (Mpeg2RateControlMode) to specify whether the bitrate is variable (vbr) or constant (cbr).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2RateControlMode {
    #[allow(missing_docs)] // documentation missing in model
    Cbr,
    #[allow(missing_docs)] // documentation missing in model
    Vbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2RateControlMode {
    fn from(s: &str) -> Self {
        match s {
            "CBR" => Mpeg2RateControlMode::Cbr,
            "VBR" => Mpeg2RateControlMode::Vbr,
            other => Mpeg2RateControlMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2RateControlMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2RateControlMode::from(s))
    }
}
impl Mpeg2RateControlMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2RateControlMode::Cbr => "CBR",
            Mpeg2RateControlMode::Vbr => "VBR",
            Mpeg2RateControlMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CBR", "VBR"]
    }
}
impl AsRef<str> for Mpeg2RateControlMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2QualityTuningLevel {
    #[allow(missing_docs)] // documentation missing in model
    MultiPass,
    #[allow(missing_docs)] // documentation missing in model
    SinglePass,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2QualityTuningLevel {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_PASS" => Mpeg2QualityTuningLevel::MultiPass,
            "SINGLE_PASS" => Mpeg2QualityTuningLevel::SinglePass,
            other => Mpeg2QualityTuningLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2QualityTuningLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2QualityTuningLevel::from(s))
    }
}
impl Mpeg2QualityTuningLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2QualityTuningLevel::MultiPass => "MULTI_PASS",
            Mpeg2QualityTuningLevel::SinglePass => "SINGLE_PASS",
            Mpeg2QualityTuningLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_PASS", "SINGLE_PASS"]
    }
}
impl AsRef<str> for Mpeg2QualityTuningLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2ParControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2ParControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Mpeg2ParControl::InitializeFromSource,
            "SPECIFIED" => Mpeg2ParControl::Specified,
            other => Mpeg2ParControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2ParControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2ParControl::from(s))
    }
}
impl Mpeg2ParControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2ParControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Mpeg2ParControl::Specified => "SPECIFIED",
            Mpeg2ParControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Mpeg2ParControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Intra DC precision (Mpeg2IntraDcPrecision) to set quantization precision for intra-block DC coefficients. If you choose the value auto, the service will automatically select the precision based on the per-frame compression ratio.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2IntraDcPrecision {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    IntraDcPrecision10,
    #[allow(missing_docs)] // documentation missing in model
    IntraDcPrecision11,
    #[allow(missing_docs)] // documentation missing in model
    IntraDcPrecision8,
    #[allow(missing_docs)] // documentation missing in model
    IntraDcPrecision9,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2IntraDcPrecision {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => Mpeg2IntraDcPrecision::Auto,
            "INTRA_DC_PRECISION_10" => Mpeg2IntraDcPrecision::IntraDcPrecision10,
            "INTRA_DC_PRECISION_11" => Mpeg2IntraDcPrecision::IntraDcPrecision11,
            "INTRA_DC_PRECISION_8" => Mpeg2IntraDcPrecision::IntraDcPrecision8,
            "INTRA_DC_PRECISION_9" => Mpeg2IntraDcPrecision::IntraDcPrecision9,
            other => Mpeg2IntraDcPrecision::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2IntraDcPrecision {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2IntraDcPrecision::from(s))
    }
}
impl Mpeg2IntraDcPrecision {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2IntraDcPrecision::Auto => "AUTO",
            Mpeg2IntraDcPrecision::IntraDcPrecision10 => "INTRA_DC_PRECISION_10",
            Mpeg2IntraDcPrecision::IntraDcPrecision11 => "INTRA_DC_PRECISION_11",
            Mpeg2IntraDcPrecision::IntraDcPrecision8 => "INTRA_DC_PRECISION_8",
            Mpeg2IntraDcPrecision::IntraDcPrecision9 => "INTRA_DC_PRECISION_9",
            Mpeg2IntraDcPrecision::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTO",
            "INTRA_DC_PRECISION_10",
            "INTRA_DC_PRECISION_11",
            "INTRA_DC_PRECISION_8",
            "INTRA_DC_PRECISION_9",
        ]
    }
}
impl AsRef<str> for Mpeg2IntraDcPrecision {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2InterlaceMode {
    #[allow(missing_docs)] // documentation missing in model
    BottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowBottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowTopField,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    #[allow(missing_docs)] // documentation missing in model
    TopField,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2InterlaceMode {
    fn from(s: &str) -> Self {
        match s {
            "BOTTOM_FIELD" => Mpeg2InterlaceMode::BottomField,
            "FOLLOW_BOTTOM_FIELD" => Mpeg2InterlaceMode::FollowBottomField,
            "FOLLOW_TOP_FIELD" => Mpeg2InterlaceMode::FollowTopField,
            "PROGRESSIVE" => Mpeg2InterlaceMode::Progressive,
            "TOP_FIELD" => Mpeg2InterlaceMode::TopField,
            other => Mpeg2InterlaceMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2InterlaceMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2InterlaceMode::from(s))
    }
}
impl Mpeg2InterlaceMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2InterlaceMode::BottomField => "BOTTOM_FIELD",
            Mpeg2InterlaceMode::FollowBottomField => "FOLLOW_BOTTOM_FIELD",
            Mpeg2InterlaceMode::FollowTopField => "FOLLOW_TOP_FIELD",
            Mpeg2InterlaceMode::Progressive => "PROGRESSIVE",
            Mpeg2InterlaceMode::TopField => "TOP_FIELD",
            Mpeg2InterlaceMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOTTOM_FIELD",
            "FOLLOW_BOTTOM_FIELD",
            "FOLLOW_TOP_FIELD",
            "PROGRESSIVE",
            "TOP_FIELD",
        ]
    }
}
impl AsRef<str> for Mpeg2InterlaceMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the units for GOP size (GopSize). If you don't specify a value here, by default the encoder measures GOP size in frames.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2GopSizeUnits {
    #[allow(missing_docs)] // documentation missing in model
    Frames,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2GopSizeUnits {
    fn from(s: &str) -> Self {
        match s {
            "FRAMES" => Mpeg2GopSizeUnits::Frames,
            "SECONDS" => Mpeg2GopSizeUnits::Seconds,
            other => Mpeg2GopSizeUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2GopSizeUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2GopSizeUnits::from(s))
    }
}
impl Mpeg2GopSizeUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2GopSizeUnits::Frames => "FRAMES",
            Mpeg2GopSizeUnits::Seconds => "SECONDS",
            Mpeg2GopSizeUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAMES", "SECONDS"]
    }
}
impl AsRef<str> for Mpeg2GopSizeUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2FramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2FramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => Mpeg2FramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => Mpeg2FramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => Mpeg2FramerateConversionAlgorithm::Interpolate,
            other => Mpeg2FramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2FramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2FramerateConversionAlgorithm::from(s))
    }
}
impl Mpeg2FramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2FramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            Mpeg2FramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            Mpeg2FramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            Mpeg2FramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for Mpeg2FramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2FramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2FramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => Mpeg2FramerateControl::InitializeFromSource,
            "SPECIFIED" => Mpeg2FramerateControl::Specified,
            other => Mpeg2FramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2FramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2FramerateControl::from(s))
    }
}
impl Mpeg2FramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2FramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            Mpeg2FramerateControl::Specified => "SPECIFIED",
            Mpeg2FramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for Mpeg2FramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2DynamicSubGop {
    #[allow(missing_docs)] // documentation missing in model
    Adaptive,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2DynamicSubGop {
    fn from(s: &str) -> Self {
        match s {
            "ADAPTIVE" => Mpeg2DynamicSubGop::Adaptive,
            "STATIC" => Mpeg2DynamicSubGop::Static,
            other => Mpeg2DynamicSubGop::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2DynamicSubGop {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2DynamicSubGop::from(s))
    }
}
impl Mpeg2DynamicSubGop {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2DynamicSubGop::Adaptive => "ADAPTIVE",
            Mpeg2DynamicSubGop::Static => "STATIC",
            Mpeg2DynamicSubGop::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADAPTIVE", "STATIC"]
    }
}
impl AsRef<str> for Mpeg2DynamicSubGop {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Profile (Mpeg2CodecProfile) to set the MPEG-2 profile for the video output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2CodecProfile {
    #[allow(missing_docs)] // documentation missing in model
    Main,
    #[allow(missing_docs)] // documentation missing in model
    Profile422,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2CodecProfile {
    fn from(s: &str) -> Self {
        match s {
            "MAIN" => Mpeg2CodecProfile::Main,
            "PROFILE_422" => Mpeg2CodecProfile::Profile422,
            other => Mpeg2CodecProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2CodecProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2CodecProfile::from(s))
    }
}
impl Mpeg2CodecProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2CodecProfile::Main => "MAIN",
            Mpeg2CodecProfile::Profile422 => "PROFILE_422",
            Mpeg2CodecProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MAIN", "PROFILE_422"]
    }
}
impl AsRef<str> for Mpeg2CodecProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use Level (Mpeg2CodecLevel) to set the MPEG-2 level for the video output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2CodecLevel {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    High1440,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Main,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2CodecLevel {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => Mpeg2CodecLevel::Auto,
            "HIGH" => Mpeg2CodecLevel::High,
            "HIGH1440" => Mpeg2CodecLevel::High1440,
            "LOW" => Mpeg2CodecLevel::Low,
            "MAIN" => Mpeg2CodecLevel::Main,
            other => Mpeg2CodecLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2CodecLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2CodecLevel::from(s))
    }
}
impl Mpeg2CodecLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2CodecLevel::Auto => "AUTO",
            Mpeg2CodecLevel::High => "HIGH",
            Mpeg2CodecLevel::High1440 => "HIGH1440",
            Mpeg2CodecLevel::Low => "LOW",
            Mpeg2CodecLevel::Main => "MAIN",
            Mpeg2CodecLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AUTO", "HIGH", "HIGH1440", "LOW", "MAIN"]
    }
}
impl AsRef<str> for Mpeg2CodecLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Mpeg2AdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Mpeg2AdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => Mpeg2AdaptiveQuantization::High,
            "LOW" => Mpeg2AdaptiveQuantization::Low,
            "MEDIUM" => Mpeg2AdaptiveQuantization::Medium,
            "OFF" => Mpeg2AdaptiveQuantization::Off,
            other => Mpeg2AdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Mpeg2AdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Mpeg2AdaptiveQuantization::from(s))
    }
}
impl Mpeg2AdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Mpeg2AdaptiveQuantization::High => "HIGH",
            Mpeg2AdaptiveQuantization::Low => "LOW",
            Mpeg2AdaptiveQuantization::Medium => "MEDIUM",
            Mpeg2AdaptiveQuantization::Off => "OFF",
            Mpeg2AdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for Mpeg2AdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Settings for H265 codec
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H265Settings {
    /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
    pub adaptive_quantization: std::option::Option<crate::model::H265AdaptiveQuantization>,
    /// Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
    pub alternate_transfer_function_sei:
        std::option::Option<crate::model::H265AlternateTransferFunctionSei>,
    /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
    pub bitrate: i32,
    /// H.265 Level.
    pub codec_level: std::option::Option<crate::model::H265CodecLevel>,
    /// Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
    pub codec_profile: std::option::Option<crate::model::H265CodecProfile>,
    /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
    pub dynamic_sub_gop: std::option::Option<crate::model::H265DynamicSubGop>,
    /// Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
    pub flicker_adaptive_quantization:
        std::option::Option<crate::model::H265FlickerAdaptiveQuantization>,
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::H265FramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::H265FramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// If enable, use reference B frames for GOP structures that have B frames > 1.
    pub gop_b_reference: std::option::Option<crate::model::H265GopBReference>,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
    pub gop_size: f64,
    /// Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
    pub gop_size_units: std::option::Option<crate::model::H265GopSizeUnits>,
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub hrd_buffer_initial_fill_percentage: i32,
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub hrd_buffer_size: i32,
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub interlace_mode: std::option::Option<crate::model::H265InterlaceMode>,
    /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
    pub max_bitrate: i32,
    /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub min_i_interval: i32,
    /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
    pub number_b_frames_between_reference_frames: i32,
    /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
    pub number_reference_frames: i32,
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub par_control: std::option::Option<crate::model::H265ParControl>,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub par_denominator: i32,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub par_numerator: i32,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::H265QualityTuningLevel>,
    /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
    pub qvbr_settings: std::option::Option<crate::model::H265QvbrSettings>,
    /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
    pub rate_control_mode: std::option::Option<crate::model::H265RateControlMode>,
    /// Specify Sample Adaptive Offset (SAO) filter strength.  Adaptive mode dynamically selects best strength based on content
    pub sample_adaptive_offset_filter_mode:
        std::option::Option<crate::model::H265SampleAdaptiveOffsetFilterMode>,
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub scan_type_conversion_mode: std::option::Option<crate::model::H265ScanTypeConversionMode>,
    /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
    pub scene_change_detect: std::option::Option<crate::model::H265SceneChangeDetect>,
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub slices: i32,
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub slow_pal: std::option::Option<crate::model::H265SlowPal>,
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
    pub spatial_adaptive_quantization:
        std::option::Option<crate::model::H265SpatialAdaptiveQuantization>,
    /// This field applies only if the Streams > Advanced > Framerate (framerate) field  is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer  field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode)  to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
    pub telecine: std::option::Option<crate::model::H265Telecine>,
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
    pub temporal_adaptive_quantization:
        std::option::Option<crate::model::H265TemporalAdaptiveQuantization>,
    /// Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
    pub temporal_ids: std::option::Option<crate::model::H265TemporalIds>,
    /// Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
    pub tiles: std::option::Option<crate::model::H265Tiles>,
    /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
    pub unregistered_sei_timecode: std::option::Option<crate::model::H265UnregisteredSeiTimecode>,
    /// If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
    pub write_mp4_packaging_type: std::option::Option<crate::model::H265WriteMp4PackagingType>,
}
impl H265Settings {
    /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
    pub fn adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H265AdaptiveQuantization> {
        self.adaptive_quantization.as_ref()
    }
    /// Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
    pub fn alternate_transfer_function_sei(
        &self,
    ) -> std::option::Option<&crate::model::H265AlternateTransferFunctionSei> {
        self.alternate_transfer_function_sei.as_ref()
    }
    /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
    pub fn bitrate(&self) -> i32 {
        self.bitrate
    }
    /// H.265 Level.
    pub fn codec_level(&self) -> std::option::Option<&crate::model::H265CodecLevel> {
        self.codec_level.as_ref()
    }
    /// Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
    pub fn codec_profile(&self) -> std::option::Option<&crate::model::H265CodecProfile> {
        self.codec_profile.as_ref()
    }
    /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
    pub fn dynamic_sub_gop(&self) -> std::option::Option<&crate::model::H265DynamicSubGop> {
        self.dynamic_sub_gop.as_ref()
    }
    /// Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
    pub fn flicker_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H265FlickerAdaptiveQuantization> {
        self.flicker_adaptive_quantization.as_ref()
    }
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::H265FramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::H265FramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// If enable, use reference B frames for GOP structures that have B frames > 1.
    pub fn gop_b_reference(&self) -> std::option::Option<&crate::model::H265GopBReference> {
        self.gop_b_reference.as_ref()
    }
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub fn gop_closed_cadence(&self) -> i32 {
        self.gop_closed_cadence
    }
    /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
    pub fn gop_size(&self) -> f64 {
        self.gop_size
    }
    /// Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
    pub fn gop_size_units(&self) -> std::option::Option<&crate::model::H265GopSizeUnits> {
        self.gop_size_units.as_ref()
    }
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub fn hrd_buffer_initial_fill_percentage(&self) -> i32 {
        self.hrd_buffer_initial_fill_percentage
    }
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub fn interlace_mode(&self) -> std::option::Option<&crate::model::H265InterlaceMode> {
        self.interlace_mode.as_ref()
    }
    /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
    pub fn max_bitrate(&self) -> i32 {
        self.max_bitrate
    }
    /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub fn min_i_interval(&self) -> i32 {
        self.min_i_interval
    }
    /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
    pub fn number_b_frames_between_reference_frames(&self) -> i32 {
        self.number_b_frames_between_reference_frames
    }
    /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
    pub fn number_reference_frames(&self) -> i32 {
        self.number_reference_frames
    }
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub fn par_control(&self) -> std::option::Option<&crate::model::H265ParControl> {
        self.par_control.as_ref()
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub fn par_denominator(&self) -> i32 {
        self.par_denominator
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub fn par_numerator(&self) -> i32 {
        self.par_numerator
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::H265QualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
    pub fn qvbr_settings(&self) -> std::option::Option<&crate::model::H265QvbrSettings> {
        self.qvbr_settings.as_ref()
    }
    /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
    pub fn rate_control_mode(&self) -> std::option::Option<&crate::model::H265RateControlMode> {
        self.rate_control_mode.as_ref()
    }
    /// Specify Sample Adaptive Offset (SAO) filter strength.  Adaptive mode dynamically selects best strength based on content
    pub fn sample_adaptive_offset_filter_mode(
        &self,
    ) -> std::option::Option<&crate::model::H265SampleAdaptiveOffsetFilterMode> {
        self.sample_adaptive_offset_filter_mode.as_ref()
    }
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub fn scan_type_conversion_mode(
        &self,
    ) -> std::option::Option<&crate::model::H265ScanTypeConversionMode> {
        self.scan_type_conversion_mode.as_ref()
    }
    /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
    pub fn scene_change_detect(&self) -> std::option::Option<&crate::model::H265SceneChangeDetect> {
        self.scene_change_detect.as_ref()
    }
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub fn slices(&self) -> i32 {
        self.slices
    }
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub fn slow_pal(&self) -> std::option::Option<&crate::model::H265SlowPal> {
        self.slow_pal.as_ref()
    }
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
    pub fn spatial_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H265SpatialAdaptiveQuantization> {
        self.spatial_adaptive_quantization.as_ref()
    }
    /// This field applies only if the Streams > Advanced > Framerate (framerate) field  is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer  field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode)  to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
    pub fn telecine(&self) -> std::option::Option<&crate::model::H265Telecine> {
        self.telecine.as_ref()
    }
    /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
    pub fn temporal_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H265TemporalAdaptiveQuantization> {
        self.temporal_adaptive_quantization.as_ref()
    }
    /// Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
    pub fn temporal_ids(&self) -> std::option::Option<&crate::model::H265TemporalIds> {
        self.temporal_ids.as_ref()
    }
    /// Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
    pub fn tiles(&self) -> std::option::Option<&crate::model::H265Tiles> {
        self.tiles.as_ref()
    }
    /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
    pub fn unregistered_sei_timecode(
        &self,
    ) -> std::option::Option<&crate::model::H265UnregisteredSeiTimecode> {
        self.unregistered_sei_timecode.as_ref()
    }
    /// If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
    pub fn write_mp4_packaging_type(
        &self,
    ) -> std::option::Option<&crate::model::H265WriteMp4PackagingType> {
        self.write_mp4_packaging_type.as_ref()
    }
}
impl std::fmt::Debug for H265Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H265Settings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field(
            "alternate_transfer_function_sei",
            &self.alternate_transfer_function_sei,
        );
        formatter.field("bitrate", &self.bitrate);
        formatter.field("codec_level", &self.codec_level);
        formatter.field("codec_profile", &self.codec_profile);
        formatter.field("dynamic_sub_gop", &self.dynamic_sub_gop);
        formatter.field(
            "flicker_adaptive_quantization",
            &self.flicker_adaptive_quantization,
        );
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_b_reference", &self.gop_b_reference);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("gop_size_units", &self.gop_size_units);
        formatter.field(
            "hrd_buffer_initial_fill_percentage",
            &self.hrd_buffer_initial_fill_percentage,
        );
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("interlace_mode", &self.interlace_mode);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("min_i_interval", &self.min_i_interval);
        formatter.field(
            "number_b_frames_between_reference_frames",
            &self.number_b_frames_between_reference_frames,
        );
        formatter.field("number_reference_frames", &self.number_reference_frames);
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("qvbr_settings", &self.qvbr_settings);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.field(
            "sample_adaptive_offset_filter_mode",
            &self.sample_adaptive_offset_filter_mode,
        );
        formatter.field("scan_type_conversion_mode", &self.scan_type_conversion_mode);
        formatter.field("scene_change_detect", &self.scene_change_detect);
        formatter.field("slices", &self.slices);
        formatter.field("slow_pal", &self.slow_pal);
        formatter.field(
            "spatial_adaptive_quantization",
            &self.spatial_adaptive_quantization,
        );
        formatter.field("telecine", &self.telecine);
        formatter.field(
            "temporal_adaptive_quantization",
            &self.temporal_adaptive_quantization,
        );
        formatter.field("temporal_ids", &self.temporal_ids);
        formatter.field("tiles", &self.tiles);
        formatter.field("unregistered_sei_timecode", &self.unregistered_sei_timecode);
        formatter.field("write_mp4_packaging_type", &self.write_mp4_packaging_type);
        formatter.finish()
    }
}
/// See [`H265Settings`](crate::model::H265Settings)
pub mod h265_settings {
    /// A builder for [`H265Settings`](crate::model::H265Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::H265AdaptiveQuantization>,
        pub(crate) alternate_transfer_function_sei:
            std::option::Option<crate::model::H265AlternateTransferFunctionSei>,
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) codec_level: std::option::Option<crate::model::H265CodecLevel>,
        pub(crate) codec_profile: std::option::Option<crate::model::H265CodecProfile>,
        pub(crate) dynamic_sub_gop: std::option::Option<crate::model::H265DynamicSubGop>,
        pub(crate) flicker_adaptive_quantization:
            std::option::Option<crate::model::H265FlickerAdaptiveQuantization>,
        pub(crate) framerate_control: std::option::Option<crate::model::H265FramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::H265FramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_b_reference: std::option::Option<crate::model::H265GopBReference>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) gop_size_units: std::option::Option<crate::model::H265GopSizeUnits>,
        pub(crate) hrd_buffer_initial_fill_percentage: std::option::Option<i32>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) interlace_mode: std::option::Option<crate::model::H265InterlaceMode>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) min_i_interval: std::option::Option<i32>,
        pub(crate) number_b_frames_between_reference_frames: std::option::Option<i32>,
        pub(crate) number_reference_frames: std::option::Option<i32>,
        pub(crate) par_control: std::option::Option<crate::model::H265ParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) quality_tuning_level: std::option::Option<crate::model::H265QualityTuningLevel>,
        pub(crate) qvbr_settings: std::option::Option<crate::model::H265QvbrSettings>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::H265RateControlMode>,
        pub(crate) sample_adaptive_offset_filter_mode:
            std::option::Option<crate::model::H265SampleAdaptiveOffsetFilterMode>,
        pub(crate) scan_type_conversion_mode:
            std::option::Option<crate::model::H265ScanTypeConversionMode>,
        pub(crate) scene_change_detect: std::option::Option<crate::model::H265SceneChangeDetect>,
        pub(crate) slices: std::option::Option<i32>,
        pub(crate) slow_pal: std::option::Option<crate::model::H265SlowPal>,
        pub(crate) spatial_adaptive_quantization:
            std::option::Option<crate::model::H265SpatialAdaptiveQuantization>,
        pub(crate) telecine: std::option::Option<crate::model::H265Telecine>,
        pub(crate) temporal_adaptive_quantization:
            std::option::Option<crate::model::H265TemporalAdaptiveQuantization>,
        pub(crate) temporal_ids: std::option::Option<crate::model::H265TemporalIds>,
        pub(crate) tiles: std::option::Option<crate::model::H265Tiles>,
        pub(crate) unregistered_sei_timecode:
            std::option::Option<crate::model::H265UnregisteredSeiTimecode>,
        pub(crate) write_mp4_packaging_type:
            std::option::Option<crate::model::H265WriteMp4PackagingType>,
    }
    impl Builder {
        /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::H265AdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H265AdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
        pub fn alternate_transfer_function_sei(
            mut self,
            input: crate::model::H265AlternateTransferFunctionSei,
        ) -> Self {
            self.alternate_transfer_function_sei = Some(input);
            self
        }
        /// Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
        pub fn set_alternate_transfer_function_sei(
            mut self,
            input: std::option::Option<crate::model::H265AlternateTransferFunctionSei>,
        ) -> Self {
            self.alternate_transfer_function_sei = input;
            self
        }
        /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// H.265 Level.
        pub fn codec_level(mut self, input: crate::model::H265CodecLevel) -> Self {
            self.codec_level = Some(input);
            self
        }
        /// H.265 Level.
        pub fn set_codec_level(
            mut self,
            input: std::option::Option<crate::model::H265CodecLevel>,
        ) -> Self {
            self.codec_level = input;
            self
        }
        /// Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
        pub fn codec_profile(mut self, input: crate::model::H265CodecProfile) -> Self {
            self.codec_profile = Some(input);
            self
        }
        /// Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
        pub fn set_codec_profile(
            mut self,
            input: std::option::Option<crate::model::H265CodecProfile>,
        ) -> Self {
            self.codec_profile = input;
            self
        }
        /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
        pub fn dynamic_sub_gop(mut self, input: crate::model::H265DynamicSubGop) -> Self {
            self.dynamic_sub_gop = Some(input);
            self
        }
        /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
        pub fn set_dynamic_sub_gop(
            mut self,
            input: std::option::Option<crate::model::H265DynamicSubGop>,
        ) -> Self {
            self.dynamic_sub_gop = input;
            self
        }
        /// Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
        pub fn flicker_adaptive_quantization(
            mut self,
            input: crate::model::H265FlickerAdaptiveQuantization,
        ) -> Self {
            self.flicker_adaptive_quantization = Some(input);
            self
        }
        /// Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
        pub fn set_flicker_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H265FlickerAdaptiveQuantization>,
        ) -> Self {
            self.flicker_adaptive_quantization = input;
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::H265FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::H265FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::H265FramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::H265FramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// If enable, use reference B frames for GOP structures that have B frames > 1.
        pub fn gop_b_reference(mut self, input: crate::model::H265GopBReference) -> Self {
            self.gop_b_reference = Some(input);
            self
        }
        /// If enable, use reference B frames for GOP structures that have B frames > 1.
        pub fn set_gop_b_reference(
            mut self,
            input: std::option::Option<crate::model::H265GopBReference>,
        ) -> Self {
            self.gop_b_reference = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
        pub fn gop_size_units(mut self, input: crate::model::H265GopSizeUnits) -> Self {
            self.gop_size_units = Some(input);
            self
        }
        /// Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
        pub fn set_gop_size_units(
            mut self,
            input: std::option::Option<crate::model::H265GopSizeUnits>,
        ) -> Self {
            self.gop_size_units = input;
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn hrd_buffer_initial_fill_percentage(mut self, input: i32) -> Self {
            self.hrd_buffer_initial_fill_percentage = Some(input);
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn set_hrd_buffer_initial_fill_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.hrd_buffer_initial_fill_percentage = input;
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn interlace_mode(mut self, input: crate::model::H265InterlaceMode) -> Self {
            self.interlace_mode = Some(input);
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn set_interlace_mode(
            mut self,
            input: std::option::Option<crate::model::H265InterlaceMode>,
        ) -> Self {
            self.interlace_mode = input;
            self
        }
        /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn min_i_interval(mut self, input: i32) -> Self {
            self.min_i_interval = Some(input);
            self
        }
        /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn set_min_i_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.min_i_interval = input;
            self
        }
        /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
        pub fn number_b_frames_between_reference_frames(mut self, input: i32) -> Self {
            self.number_b_frames_between_reference_frames = Some(input);
            self
        }
        /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
        pub fn set_number_b_frames_between_reference_frames(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_b_frames_between_reference_frames = input;
            self
        }
        /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
        pub fn number_reference_frames(mut self, input: i32) -> Self {
            self.number_reference_frames = Some(input);
            self
        }
        /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
        pub fn set_number_reference_frames(mut self, input: std::option::Option<i32>) -> Self {
            self.number_reference_frames = input;
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn par_control(mut self, input: crate::model::H265ParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::H265ParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn quality_tuning_level(mut self, input: crate::model::H265QualityTuningLevel) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::H265QualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
        pub fn qvbr_settings(mut self, input: crate::model::H265QvbrSettings) -> Self {
            self.qvbr_settings = Some(input);
            self
        }
        /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
        pub fn set_qvbr_settings(
            mut self,
            input: std::option::Option<crate::model::H265QvbrSettings>,
        ) -> Self {
            self.qvbr_settings = input;
            self
        }
        /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
        pub fn rate_control_mode(mut self, input: crate::model::H265RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::H265RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Specify Sample Adaptive Offset (SAO) filter strength.  Adaptive mode dynamically selects best strength based on content
        pub fn sample_adaptive_offset_filter_mode(
            mut self,
            input: crate::model::H265SampleAdaptiveOffsetFilterMode,
        ) -> Self {
            self.sample_adaptive_offset_filter_mode = Some(input);
            self
        }
        /// Specify Sample Adaptive Offset (SAO) filter strength.  Adaptive mode dynamically selects best strength based on content
        pub fn set_sample_adaptive_offset_filter_mode(
            mut self,
            input: std::option::Option<crate::model::H265SampleAdaptiveOffsetFilterMode>,
        ) -> Self {
            self.sample_adaptive_offset_filter_mode = input;
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn scan_type_conversion_mode(
            mut self,
            input: crate::model::H265ScanTypeConversionMode,
        ) -> Self {
            self.scan_type_conversion_mode = Some(input);
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn set_scan_type_conversion_mode(
            mut self,
            input: std::option::Option<crate::model::H265ScanTypeConversionMode>,
        ) -> Self {
            self.scan_type_conversion_mode = input;
            self
        }
        /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
        pub fn scene_change_detect(mut self, input: crate::model::H265SceneChangeDetect) -> Self {
            self.scene_change_detect = Some(input);
            self
        }
        /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
        pub fn set_scene_change_detect(
            mut self,
            input: std::option::Option<crate::model::H265SceneChangeDetect>,
        ) -> Self {
            self.scene_change_detect = input;
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn slices(mut self, input: i32) -> Self {
            self.slices = Some(input);
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn set_slices(mut self, input: std::option::Option<i32>) -> Self {
            self.slices = input;
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn slow_pal(mut self, input: crate::model::H265SlowPal) -> Self {
            self.slow_pal = Some(input);
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn set_slow_pal(
            mut self,
            input: std::option::Option<crate::model::H265SlowPal>,
        ) -> Self {
            self.slow_pal = input;
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
        pub fn spatial_adaptive_quantization(
            mut self,
            input: crate::model::H265SpatialAdaptiveQuantization,
        ) -> Self {
            self.spatial_adaptive_quantization = Some(input);
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
        pub fn set_spatial_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H265SpatialAdaptiveQuantization>,
        ) -> Self {
            self.spatial_adaptive_quantization = input;
            self
        }
        /// This field applies only if the Streams > Advanced > Framerate (framerate) field  is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer  field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode)  to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
        pub fn telecine(mut self, input: crate::model::H265Telecine) -> Self {
            self.telecine = Some(input);
            self
        }
        /// This field applies only if the Streams > Advanced > Framerate (framerate) field  is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer  field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode)  to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
        pub fn set_telecine(
            mut self,
            input: std::option::Option<crate::model::H265Telecine>,
        ) -> Self {
            self.telecine = input;
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
        pub fn temporal_adaptive_quantization(
            mut self,
            input: crate::model::H265TemporalAdaptiveQuantization,
        ) -> Self {
            self.temporal_adaptive_quantization = Some(input);
            self
        }
        /// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
        pub fn set_temporal_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H265TemporalAdaptiveQuantization>,
        ) -> Self {
            self.temporal_adaptive_quantization = input;
            self
        }
        /// Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
        pub fn temporal_ids(mut self, input: crate::model::H265TemporalIds) -> Self {
            self.temporal_ids = Some(input);
            self
        }
        /// Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
        pub fn set_temporal_ids(
            mut self,
            input: std::option::Option<crate::model::H265TemporalIds>,
        ) -> Self {
            self.temporal_ids = input;
            self
        }
        /// Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
        pub fn tiles(mut self, input: crate::model::H265Tiles) -> Self {
            self.tiles = Some(input);
            self
        }
        /// Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
        pub fn set_tiles(mut self, input: std::option::Option<crate::model::H265Tiles>) -> Self {
            self.tiles = input;
            self
        }
        /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
        pub fn unregistered_sei_timecode(
            mut self,
            input: crate::model::H265UnregisteredSeiTimecode,
        ) -> Self {
            self.unregistered_sei_timecode = Some(input);
            self
        }
        /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
        pub fn set_unregistered_sei_timecode(
            mut self,
            input: std::option::Option<crate::model::H265UnregisteredSeiTimecode>,
        ) -> Self {
            self.unregistered_sei_timecode = input;
            self
        }
        /// If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
        pub fn write_mp4_packaging_type(
            mut self,
            input: crate::model::H265WriteMp4PackagingType,
        ) -> Self {
            self.write_mp4_packaging_type = Some(input);
            self
        }
        /// If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
        pub fn set_write_mp4_packaging_type(
            mut self,
            input: std::option::Option<crate::model::H265WriteMp4PackagingType>,
        ) -> Self {
            self.write_mp4_packaging_type = input;
            self
        }
        /// Consumes the builder and constructs a [`H265Settings`](crate::model::H265Settings)
        pub fn build(self) -> crate::model::H265Settings {
            crate::model::H265Settings {
                adaptive_quantization: self.adaptive_quantization,
                alternate_transfer_function_sei: self.alternate_transfer_function_sei,
                bitrate: self.bitrate.unwrap_or_default(),
                codec_level: self.codec_level,
                codec_profile: self.codec_profile,
                dynamic_sub_gop: self.dynamic_sub_gop,
                flicker_adaptive_quantization: self.flicker_adaptive_quantization,
                framerate_control: self.framerate_control,
                framerate_conversion_algorithm: self.framerate_conversion_algorithm,
                framerate_denominator: self.framerate_denominator.unwrap_or_default(),
                framerate_numerator: self.framerate_numerator.unwrap_or_default(),
                gop_b_reference: self.gop_b_reference,
                gop_closed_cadence: self.gop_closed_cadence.unwrap_or_default(),
                gop_size: self.gop_size.unwrap_or_default(),
                gop_size_units: self.gop_size_units,
                hrd_buffer_initial_fill_percentage: self
                    .hrd_buffer_initial_fill_percentage
                    .unwrap_or_default(),
                hrd_buffer_size: self.hrd_buffer_size.unwrap_or_default(),
                interlace_mode: self.interlace_mode,
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                min_i_interval: self.min_i_interval.unwrap_or_default(),
                number_b_frames_between_reference_frames: self
                    .number_b_frames_between_reference_frames
                    .unwrap_or_default(),
                number_reference_frames: self.number_reference_frames.unwrap_or_default(),
                par_control: self.par_control,
                par_denominator: self.par_denominator.unwrap_or_default(),
                par_numerator: self.par_numerator.unwrap_or_default(),
                quality_tuning_level: self.quality_tuning_level,
                qvbr_settings: self.qvbr_settings,
                rate_control_mode: self.rate_control_mode,
                sample_adaptive_offset_filter_mode: self.sample_adaptive_offset_filter_mode,
                scan_type_conversion_mode: self.scan_type_conversion_mode,
                scene_change_detect: self.scene_change_detect,
                slices: self.slices.unwrap_or_default(),
                slow_pal: self.slow_pal,
                spatial_adaptive_quantization: self.spatial_adaptive_quantization,
                telecine: self.telecine,
                temporal_adaptive_quantization: self.temporal_adaptive_quantization,
                temporal_ids: self.temporal_ids,
                tiles: self.tiles,
                unregistered_sei_timecode: self.unregistered_sei_timecode,
                write_mp4_packaging_type: self.write_mp4_packaging_type,
            }
        }
    }
}
impl H265Settings {
    /// Creates a new builder-style object to manufacture [`H265Settings`](crate::model::H265Settings)
    pub fn builder() -> crate::model::h265_settings::Builder {
        crate::model::h265_settings::Builder::default()
    }
}

/// If the location of parameter set NAL units doesn't matter in your workflow, ignore this setting. Use this setting only with CMAF or DASH outputs, or with standalone file outputs in an MPEG-4 container (MP4 outputs). Choose HVC1 to mark your output as HVC1. This makes your output compliant with the following specification: ISO IECJTC1 SC29 N13798 Text ISO/IEC FDIS 14496-15 3rd Edition. For these outputs, the service stores parameter set NAL units in the sample headers but not in the samples directly. For MP4 outputs, when you choose HVC1, your output video might not work properly with some downstream systems and video players. The service defaults to marking your output as HEV1. For these outputs, the service writes parameter set NAL units directly into the samples.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265WriteMp4PackagingType {
    #[allow(missing_docs)] // documentation missing in model
    Hev1,
    #[allow(missing_docs)] // documentation missing in model
    Hvc1,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265WriteMp4PackagingType {
    fn from(s: &str) -> Self {
        match s {
            "HEV1" => H265WriteMp4PackagingType::Hev1,
            "HVC1" => H265WriteMp4PackagingType::Hvc1,
            other => H265WriteMp4PackagingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265WriteMp4PackagingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265WriteMp4PackagingType::from(s))
    }
}
impl H265WriteMp4PackagingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265WriteMp4PackagingType::Hev1 => "HEV1",
            H265WriteMp4PackagingType::Hvc1 => "HVC1",
            H265WriteMp4PackagingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HEV1", "HVC1"]
    }
}
impl AsRef<str> for H265WriteMp4PackagingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265UnregisteredSeiTimecode {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265UnregisteredSeiTimecode {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265UnregisteredSeiTimecode::Disabled,
            "ENABLED" => H265UnregisteredSeiTimecode::Enabled,
            other => H265UnregisteredSeiTimecode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265UnregisteredSeiTimecode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265UnregisteredSeiTimecode::from(s))
    }
}
impl H265UnregisteredSeiTimecode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265UnregisteredSeiTimecode::Disabled => "DISABLED",
            H265UnregisteredSeiTimecode::Enabled => "ENABLED",
            H265UnregisteredSeiTimecode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265UnregisteredSeiTimecode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enable use of tiles, allowing horizontal as well as vertical subdivision of the encoded pictures.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265Tiles {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265Tiles {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265Tiles::Disabled,
            "ENABLED" => H265Tiles::Enabled,
            other => H265Tiles::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265Tiles {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265Tiles::from(s))
    }
}
impl H265Tiles {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265Tiles::Disabled => "DISABLED",
            H265Tiles::Enabled => "ENABLED",
            H265Tiles::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265Tiles {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enables temporal layer identifiers in the encoded bitstream. Up to 3 layers are supported depending on GOP structure: I- and P-frames form one layer, reference B-frames can form a second layer and non-reference b-frames can form a third layer. Decoders can optionally decode only the lower temporal layers to generate a lower frame rate output. For example, given a bitstream with temporal IDs and with b-frames = 1 (i.e. IbPbPb display order), a decoder could decode all the frames for full frame rate output or only the I and P frames (lowest temporal layer) for a half frame rate output.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265TemporalIds {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265TemporalIds {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265TemporalIds::Disabled,
            "ENABLED" => H265TemporalIds::Enabled,
            other => H265TemporalIds::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265TemporalIds {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265TemporalIds::from(s))
    }
}
impl H265TemporalIds {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265TemporalIds::Disabled => "DISABLED",
            H265TemporalIds::Enabled => "ENABLED",
            H265TemporalIds::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265TemporalIds {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to disable this feature. Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265TemporalAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265TemporalAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265TemporalAdaptiveQuantization::Disabled,
            "ENABLED" => H265TemporalAdaptiveQuantization::Enabled,
            other => H265TemporalAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265TemporalAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265TemporalAdaptiveQuantization::from(s))
    }
}
impl H265TemporalAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265TemporalAdaptiveQuantization::Disabled => "DISABLED",
            H265TemporalAdaptiveQuantization::Enabled => "ENABLED",
            H265TemporalAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265TemporalAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// This field applies only if the Streams > Advanced > Framerate (framerate) field  is set to 29.970. This field works with the Streams > Advanced > Preprocessors > Deinterlacer  field (deinterlace_mode) and the Streams > Advanced > Interlaced Mode field (interlace_mode)  to identify the scan type for the output: Progressive, Interlaced, Hard Telecine or Soft Telecine. - Hard: produces 29.97i output from 23.976 input. - Soft: produces 23.976; the player converts this output to 29.97i.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265Telecine {
    #[allow(missing_docs)] // documentation missing in model
    Hard,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    Soft,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265Telecine {
    fn from(s: &str) -> Self {
        match s {
            "HARD" => H265Telecine::Hard,
            "NONE" => H265Telecine::None,
            "SOFT" => H265Telecine::Soft,
            other => H265Telecine::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265Telecine {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265Telecine::from(s))
    }
}
impl H265Telecine {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265Telecine::Hard => "HARD",
            H265Telecine::None => "NONE",
            H265Telecine::Soft => "SOFT",
            H265Telecine::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HARD", "NONE", "SOFT"]
    }
}
impl AsRef<str> for H265Telecine {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Keep the default value, Enabled (ENABLED), to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to disable this feature. Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (adaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265SpatialAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265SpatialAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265SpatialAdaptiveQuantization::Disabled,
            "ENABLED" => H265SpatialAdaptiveQuantization::Enabled,
            other => H265SpatialAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265SpatialAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265SpatialAdaptiveQuantization::from(s))
    }
}
impl H265SpatialAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265SpatialAdaptiveQuantization::Disabled => "DISABLED",
            H265SpatialAdaptiveQuantization::Enabled => "ENABLED",
            H265SpatialAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265SpatialAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265SlowPal {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265SlowPal {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265SlowPal::Disabled,
            "ENABLED" => H265SlowPal::Enabled,
            other => H265SlowPal::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265SlowPal {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265SlowPal::from(s))
    }
}
impl H265SlowPal {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265SlowPal::Disabled => "DISABLED",
            H265SlowPal::Enabled => "ENABLED",
            H265SlowPal::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265SlowPal {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265SceneChangeDetect {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    TransitionDetection,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265SceneChangeDetect {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265SceneChangeDetect::Disabled,
            "ENABLED" => H265SceneChangeDetect::Enabled,
            "TRANSITION_DETECTION" => H265SceneChangeDetect::TransitionDetection,
            other => H265SceneChangeDetect::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265SceneChangeDetect {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265SceneChangeDetect::from(s))
    }
}
impl H265SceneChangeDetect {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265SceneChangeDetect::Disabled => "DISABLED",
            H265SceneChangeDetect::Enabled => "ENABLED",
            H265SceneChangeDetect::TransitionDetection => "TRANSITION_DETECTION",
            H265SceneChangeDetect::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED", "TRANSITION_DETECTION"]
    }
}
impl AsRef<str> for H265SceneChangeDetect {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265ScanTypeConversionMode {
    #[allow(missing_docs)] // documentation missing in model
    Interlaced,
    #[allow(missing_docs)] // documentation missing in model
    InterlacedOptimize,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265ScanTypeConversionMode {
    fn from(s: &str) -> Self {
        match s {
            "INTERLACED" => H265ScanTypeConversionMode::Interlaced,
            "INTERLACED_OPTIMIZE" => H265ScanTypeConversionMode::InterlacedOptimize,
            other => H265ScanTypeConversionMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265ScanTypeConversionMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265ScanTypeConversionMode::from(s))
    }
}
impl H265ScanTypeConversionMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265ScanTypeConversionMode::Interlaced => "INTERLACED",
            H265ScanTypeConversionMode::InterlacedOptimize => "INTERLACED_OPTIMIZE",
            H265ScanTypeConversionMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INTERLACED", "INTERLACED_OPTIMIZE"]
    }
}
impl AsRef<str> for H265ScanTypeConversionMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify Sample Adaptive Offset (SAO) filter strength.  Adaptive mode dynamically selects best strength based on content
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265SampleAdaptiveOffsetFilterMode {
    #[allow(missing_docs)] // documentation missing in model
    Adaptive,
    #[allow(missing_docs)] // documentation missing in model
    Default,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265SampleAdaptiveOffsetFilterMode {
    fn from(s: &str) -> Self {
        match s {
            "ADAPTIVE" => H265SampleAdaptiveOffsetFilterMode::Adaptive,
            "DEFAULT" => H265SampleAdaptiveOffsetFilterMode::Default,
            "OFF" => H265SampleAdaptiveOffsetFilterMode::Off,
            other => H265SampleAdaptiveOffsetFilterMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265SampleAdaptiveOffsetFilterMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265SampleAdaptiveOffsetFilterMode::from(s))
    }
}
impl H265SampleAdaptiveOffsetFilterMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265SampleAdaptiveOffsetFilterMode::Adaptive => "ADAPTIVE",
            H265SampleAdaptiveOffsetFilterMode::Default => "DEFAULT",
            H265SampleAdaptiveOffsetFilterMode::Off => "OFF",
            H265SampleAdaptiveOffsetFilterMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADAPTIVE", "DEFAULT", "OFF"]
    }
}
impl AsRef<str> for H265SampleAdaptiveOffsetFilterMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265RateControlMode {
    #[allow(missing_docs)] // documentation missing in model
    Cbr,
    #[allow(missing_docs)] // documentation missing in model
    Qvbr,
    #[allow(missing_docs)] // documentation missing in model
    Vbr,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265RateControlMode {
    fn from(s: &str) -> Self {
        match s {
            "CBR" => H265RateControlMode::Cbr,
            "QVBR" => H265RateControlMode::Qvbr,
            "VBR" => H265RateControlMode::Vbr,
            other => H265RateControlMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265RateControlMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265RateControlMode::from(s))
    }
}
impl H265RateControlMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265RateControlMode::Cbr => "CBR",
            H265RateControlMode::Qvbr => "QVBR",
            H265RateControlMode::Vbr => "VBR",
            H265RateControlMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CBR", "QVBR", "VBR"]
    }
}
impl AsRef<str> for H265RateControlMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H265QvbrSettings {
    /// Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video part of this output to the value that you choose. That is, the total size of the video element is less than or equal to the value you set multiplied by the number of seconds of encoded output.
    pub max_average_bitrate: i32,
    /// Use this setting only when you set Rate control mode (RateControlMode) to QVBR. Specify the target quality level for this output. MediaConvert determines the right number of bits to use for each part of the video to maintain the video quality that you specify. When you keep the default value, AUTO, MediaConvert picks a quality level for you, based on characteristics of your input video. If you prefer to specify a quality level, specify a number from 1 through 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
    pub qvbr_quality_level: i32,
    /// Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
    pub qvbr_quality_level_fine_tune: f64,
}
impl H265QvbrSettings {
    /// Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video part of this output to the value that you choose. That is, the total size of the video element is less than or equal to the value you set multiplied by the number of seconds of encoded output.
    pub fn max_average_bitrate(&self) -> i32 {
        self.max_average_bitrate
    }
    /// Use this setting only when you set Rate control mode (RateControlMode) to QVBR. Specify the target quality level for this output. MediaConvert determines the right number of bits to use for each part of the video to maintain the video quality that you specify. When you keep the default value, AUTO, MediaConvert picks a quality level for you, based on characteristics of your input video. If you prefer to specify a quality level, specify a number from 1 through 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
    pub fn qvbr_quality_level(&self) -> i32 {
        self.qvbr_quality_level
    }
    /// Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
    pub fn qvbr_quality_level_fine_tune(&self) -> f64 {
        self.qvbr_quality_level_fine_tune
    }
}
impl std::fmt::Debug for H265QvbrSettings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H265QvbrSettings");
        formatter.field("max_average_bitrate", &self.max_average_bitrate);
        formatter.field("qvbr_quality_level", &self.qvbr_quality_level);
        formatter.field(
            "qvbr_quality_level_fine_tune",
            &self.qvbr_quality_level_fine_tune,
        );
        formatter.finish()
    }
}
/// See [`H265QvbrSettings`](crate::model::H265QvbrSettings)
pub mod h265_qvbr_settings {
    /// A builder for [`H265QvbrSettings`](crate::model::H265QvbrSettings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_average_bitrate: std::option::Option<i32>,
        pub(crate) qvbr_quality_level: std::option::Option<i32>,
        pub(crate) qvbr_quality_level_fine_tune: std::option::Option<f64>,
    }
    impl Builder {
        /// Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video part of this output to the value that you choose. That is, the total size of the video element is less than or equal to the value you set multiplied by the number of seconds of encoded output.
        pub fn max_average_bitrate(mut self, input: i32) -> Self {
            self.max_average_bitrate = Some(input);
            self
        }
        /// Use this setting only when Rate control mode is QVBR and Quality tuning level is Multi-pass HQ. For Max average bitrate values suited to the complexity of your input video, the service limits the average bitrate of the video part of this output to the value that you choose. That is, the total size of the video element is less than or equal to the value you set multiplied by the number of seconds of encoded output.
        pub fn set_max_average_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_average_bitrate = input;
            self
        }
        /// Use this setting only when you set Rate control mode (RateControlMode) to QVBR. Specify the target quality level for this output. MediaConvert determines the right number of bits to use for each part of the video to maintain the video quality that you specify. When you keep the default value, AUTO, MediaConvert picks a quality level for you, based on characteristics of your input video. If you prefer to specify a quality level, specify a number from 1 through 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
        pub fn qvbr_quality_level(mut self, input: i32) -> Self {
            self.qvbr_quality_level = Some(input);
            self
        }
        /// Use this setting only when you set Rate control mode (RateControlMode) to QVBR. Specify the target quality level for this output. MediaConvert determines the right number of bits to use for each part of the video to maintain the video quality that you specify. When you keep the default value, AUTO, MediaConvert picks a quality level for you, based on characteristics of your input video. If you prefer to specify a quality level, specify a number from 1 through 10. Use higher numbers for greater quality. Level 10 results in nearly lossless compression. The quality level for most broadcast-quality transcodes is between 6 and 9. Optionally, to specify a value between whole numbers, also provide a value for the setting qvbrQualityLevelFineTune. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33.
        pub fn set_qvbr_quality_level(mut self, input: std::option::Option<i32>) -> Self {
            self.qvbr_quality_level = input;
            self
        }
        /// Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
        pub fn qvbr_quality_level_fine_tune(mut self, input: f64) -> Self {
            self.qvbr_quality_level_fine_tune = Some(input);
            self
        }
        /// Optional. Specify a value here to set the QVBR quality to a level that is between whole numbers. For example, if you want your QVBR quality level to be 7.33, set qvbrQualityLevel to 7 and set qvbrQualityLevelFineTune to .33. MediaConvert rounds your QVBR quality level to the nearest third of a whole number. For example, if you set qvbrQualityLevel to 7 and you set qvbrQualityLevelFineTune to .25, your actual QVBR quality level is 7.33.
        pub fn set_qvbr_quality_level_fine_tune(mut self, input: std::option::Option<f64>) -> Self {
            self.qvbr_quality_level_fine_tune = input;
            self
        }
        /// Consumes the builder and constructs a [`H265QvbrSettings`](crate::model::H265QvbrSettings)
        pub fn build(self) -> crate::model::H265QvbrSettings {
            crate::model::H265QvbrSettings {
                max_average_bitrate: self.max_average_bitrate.unwrap_or_default(),
                qvbr_quality_level: self.qvbr_quality_level.unwrap_or_default(),
                qvbr_quality_level_fine_tune: self.qvbr_quality_level_fine_tune.unwrap_or_default(),
            }
        }
    }
}
impl H265QvbrSettings {
    /// Creates a new builder-style object to manufacture [`H265QvbrSettings`](crate::model::H265QvbrSettings)
    pub fn builder() -> crate::model::h265_qvbr_settings::Builder {
        crate::model::h265_qvbr_settings::Builder::default()
    }
}

/// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265QualityTuningLevel {
    #[allow(missing_docs)] // documentation missing in model
    MultiPassHq,
    #[allow(missing_docs)] // documentation missing in model
    SinglePass,
    #[allow(missing_docs)] // documentation missing in model
    SinglePassHq,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265QualityTuningLevel {
    fn from(s: &str) -> Self {
        match s {
            "MULTI_PASS_HQ" => H265QualityTuningLevel::MultiPassHq,
            "SINGLE_PASS" => H265QualityTuningLevel::SinglePass,
            "SINGLE_PASS_HQ" => H265QualityTuningLevel::SinglePassHq,
            other => H265QualityTuningLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265QualityTuningLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265QualityTuningLevel::from(s))
    }
}
impl H265QualityTuningLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265QualityTuningLevel::MultiPassHq => "MULTI_PASS_HQ",
            H265QualityTuningLevel::SinglePass => "SINGLE_PASS",
            H265QualityTuningLevel::SinglePassHq => "SINGLE_PASS_HQ",
            H265QualityTuningLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MULTI_PASS_HQ", "SINGLE_PASS", "SINGLE_PASS_HQ"]
    }
}
impl AsRef<str> for H265QualityTuningLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265ParControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265ParControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => H265ParControl::InitializeFromSource,
            "SPECIFIED" => H265ParControl::Specified,
            other => H265ParControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265ParControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265ParControl::from(s))
    }
}
impl H265ParControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265ParControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            H265ParControl::Specified => "SPECIFIED",
            H265ParControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for H265ParControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265InterlaceMode {
    #[allow(missing_docs)] // documentation missing in model
    BottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowBottomField,
    #[allow(missing_docs)] // documentation missing in model
    FollowTopField,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    #[allow(missing_docs)] // documentation missing in model
    TopField,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265InterlaceMode {
    fn from(s: &str) -> Self {
        match s {
            "BOTTOM_FIELD" => H265InterlaceMode::BottomField,
            "FOLLOW_BOTTOM_FIELD" => H265InterlaceMode::FollowBottomField,
            "FOLLOW_TOP_FIELD" => H265InterlaceMode::FollowTopField,
            "PROGRESSIVE" => H265InterlaceMode::Progressive,
            "TOP_FIELD" => H265InterlaceMode::TopField,
            other => H265InterlaceMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265InterlaceMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265InterlaceMode::from(s))
    }
}
impl H265InterlaceMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265InterlaceMode::BottomField => "BOTTOM_FIELD",
            H265InterlaceMode::FollowBottomField => "FOLLOW_BOTTOM_FIELD",
            H265InterlaceMode::FollowTopField => "FOLLOW_TOP_FIELD",
            H265InterlaceMode::Progressive => "PROGRESSIVE",
            H265InterlaceMode::TopField => "TOP_FIELD",
            H265InterlaceMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BOTTOM_FIELD",
            "FOLLOW_BOTTOM_FIELD",
            "FOLLOW_TOP_FIELD",
            "PROGRESSIVE",
            "TOP_FIELD",
        ]
    }
}
impl AsRef<str> for H265InterlaceMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Indicates if the GOP Size in H265 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265GopSizeUnits {
    #[allow(missing_docs)] // documentation missing in model
    Frames,
    #[allow(missing_docs)] // documentation missing in model
    Seconds,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265GopSizeUnits {
    fn from(s: &str) -> Self {
        match s {
            "FRAMES" => H265GopSizeUnits::Frames,
            "SECONDS" => H265GopSizeUnits::Seconds,
            other => H265GopSizeUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265GopSizeUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265GopSizeUnits::from(s))
    }
}
impl H265GopSizeUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265GopSizeUnits::Frames => "FRAMES",
            H265GopSizeUnits::Seconds => "SECONDS",
            H265GopSizeUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FRAMES", "SECONDS"]
    }
}
impl AsRef<str> for H265GopSizeUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If enable, use reference B frames for GOP structures that have B frames > 1.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265GopBReference {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265GopBReference {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265GopBReference::Disabled,
            "ENABLED" => H265GopBReference::Enabled,
            other => H265GopBReference::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265GopBReference {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265GopBReference::from(s))
    }
}
impl H265GopBReference {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265GopBReference::Disabled => "DISABLED",
            H265GopBReference::Enabled => "ENABLED",
            H265GopBReference::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265GopBReference {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265FramerateConversionAlgorithm {
    #[allow(missing_docs)] // documentation missing in model
    DuplicateDrop,
    #[allow(missing_docs)] // documentation missing in model
    Frameformer,
    #[allow(missing_docs)] // documentation missing in model
    Interpolate,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265FramerateConversionAlgorithm {
    fn from(s: &str) -> Self {
        match s {
            "DUPLICATE_DROP" => H265FramerateConversionAlgorithm::DuplicateDrop,
            "FRAMEFORMER" => H265FramerateConversionAlgorithm::Frameformer,
            "INTERPOLATE" => H265FramerateConversionAlgorithm::Interpolate,
            other => H265FramerateConversionAlgorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265FramerateConversionAlgorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265FramerateConversionAlgorithm::from(s))
    }
}
impl H265FramerateConversionAlgorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265FramerateConversionAlgorithm::DuplicateDrop => "DUPLICATE_DROP",
            H265FramerateConversionAlgorithm::Frameformer => "FRAMEFORMER",
            H265FramerateConversionAlgorithm::Interpolate => "INTERPOLATE",
            H265FramerateConversionAlgorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DUPLICATE_DROP", "FRAMEFORMER", "INTERPOLATE"]
    }
}
impl AsRef<str> for H265FramerateConversionAlgorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265FramerateControl {
    #[allow(missing_docs)] // documentation missing in model
    InitializeFromSource,
    #[allow(missing_docs)] // documentation missing in model
    Specified,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265FramerateControl {
    fn from(s: &str) -> Self {
        match s {
            "INITIALIZE_FROM_SOURCE" => H265FramerateControl::InitializeFromSource,
            "SPECIFIED" => H265FramerateControl::Specified,
            other => H265FramerateControl::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265FramerateControl {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265FramerateControl::from(s))
    }
}
impl H265FramerateControl {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265FramerateControl::InitializeFromSource => "INITIALIZE_FROM_SOURCE",
            H265FramerateControl::Specified => "SPECIFIED",
            H265FramerateControl::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["INITIALIZE_FROM_SOURCE", "SPECIFIED"]
    }
}
impl AsRef<str> for H265FramerateControl {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enable this setting to have the encoder reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. This setting is disabled by default. Related setting: In addition to enabling this setting, you must also set adaptiveQuantization to a value other than Off (OFF).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265FlickerAdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265FlickerAdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265FlickerAdaptiveQuantization::Disabled,
            "ENABLED" => H265FlickerAdaptiveQuantization::Enabled,
            other => H265FlickerAdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265FlickerAdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265FlickerAdaptiveQuantization::from(s))
    }
}
impl H265FlickerAdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265FlickerAdaptiveQuantization::Disabled => "DISABLED",
            H265FlickerAdaptiveQuantization::Enabled => "ENABLED",
            H265FlickerAdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265FlickerAdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265DynamicSubGop {
    #[allow(missing_docs)] // documentation missing in model
    Adaptive,
    #[allow(missing_docs)] // documentation missing in model
    Static,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265DynamicSubGop {
    fn from(s: &str) -> Self {
        match s {
            "ADAPTIVE" => H265DynamicSubGop::Adaptive,
            "STATIC" => H265DynamicSubGop::Static,
            other => H265DynamicSubGop::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265DynamicSubGop {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265DynamicSubGop::from(s))
    }
}
impl H265DynamicSubGop {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265DynamicSubGop::Adaptive => "ADAPTIVE",
            H265DynamicSubGop::Static => "STATIC",
            H265DynamicSubGop::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ADAPTIVE", "STATIC"]
    }
}
impl AsRef<str> for H265DynamicSubGop {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Represents the Profile and Tier, per the HEVC (H.265) specification. Selections are grouped as [Profile] / [Tier], so "Main/High" represents Main Profile with High Tier. 4:2:2 profiles are only available with the HEVC 4:2:2 License.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265CodecProfile {
    #[allow(missing_docs)] // documentation missing in model
    Main10High,
    #[allow(missing_docs)] // documentation missing in model
    Main10Main,
    #[allow(missing_docs)] // documentation missing in model
    Main42210BitHigh,
    #[allow(missing_docs)] // documentation missing in model
    Main42210BitMain,
    #[allow(missing_docs)] // documentation missing in model
    Main4228BitHigh,
    #[allow(missing_docs)] // documentation missing in model
    Main4228BitMain,
    #[allow(missing_docs)] // documentation missing in model
    MainHigh,
    #[allow(missing_docs)] // documentation missing in model
    MainMain,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265CodecProfile {
    fn from(s: &str) -> Self {
        match s {
            "MAIN10_HIGH" => H265CodecProfile::Main10High,
            "MAIN10_MAIN" => H265CodecProfile::Main10Main,
            "MAIN_422_10BIT_HIGH" => H265CodecProfile::Main42210BitHigh,
            "MAIN_422_10BIT_MAIN" => H265CodecProfile::Main42210BitMain,
            "MAIN_422_8BIT_HIGH" => H265CodecProfile::Main4228BitHigh,
            "MAIN_422_8BIT_MAIN" => H265CodecProfile::Main4228BitMain,
            "MAIN_HIGH" => H265CodecProfile::MainHigh,
            "MAIN_MAIN" => H265CodecProfile::MainMain,
            other => H265CodecProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265CodecProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265CodecProfile::from(s))
    }
}
impl H265CodecProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265CodecProfile::Main10High => "MAIN10_HIGH",
            H265CodecProfile::Main10Main => "MAIN10_MAIN",
            H265CodecProfile::Main42210BitHigh => "MAIN_422_10BIT_HIGH",
            H265CodecProfile::Main42210BitMain => "MAIN_422_10BIT_MAIN",
            H265CodecProfile::Main4228BitHigh => "MAIN_422_8BIT_HIGH",
            H265CodecProfile::Main4228BitMain => "MAIN_422_8BIT_MAIN",
            H265CodecProfile::MainHigh => "MAIN_HIGH",
            H265CodecProfile::MainMain => "MAIN_MAIN",
            H265CodecProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "MAIN10_HIGH",
            "MAIN10_MAIN",
            "MAIN_422_10BIT_HIGH",
            "MAIN_422_10BIT_MAIN",
            "MAIN_422_8BIT_HIGH",
            "MAIN_422_8BIT_MAIN",
            "MAIN_HIGH",
            "MAIN_MAIN",
        ]
    }
}
impl AsRef<str> for H265CodecProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// H.265 Level.
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265CodecLevel {
    #[allow(missing_docs)] // documentation missing in model
    Auto,
    #[allow(missing_docs)] // documentation missing in model
    Level1,
    #[allow(missing_docs)] // documentation missing in model
    Level2,
    #[allow(missing_docs)] // documentation missing in model
    Level21,
    #[allow(missing_docs)] // documentation missing in model
    Level3,
    #[allow(missing_docs)] // documentation missing in model
    Level31,
    #[allow(missing_docs)] // documentation missing in model
    Level4,
    #[allow(missing_docs)] // documentation missing in model
    Level41,
    #[allow(missing_docs)] // documentation missing in model
    Level5,
    #[allow(missing_docs)] // documentation missing in model
    Level51,
    #[allow(missing_docs)] // documentation missing in model
    Level52,
    #[allow(missing_docs)] // documentation missing in model
    Level6,
    #[allow(missing_docs)] // documentation missing in model
    Level61,
    #[allow(missing_docs)] // documentation missing in model
    Level62,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265CodecLevel {
    fn from(s: &str) -> Self {
        match s {
            "AUTO" => H265CodecLevel::Auto,
            "LEVEL_1" => H265CodecLevel::Level1,
            "LEVEL_2" => H265CodecLevel::Level2,
            "LEVEL_2_1" => H265CodecLevel::Level21,
            "LEVEL_3" => H265CodecLevel::Level3,
            "LEVEL_3_1" => H265CodecLevel::Level31,
            "LEVEL_4" => H265CodecLevel::Level4,
            "LEVEL_4_1" => H265CodecLevel::Level41,
            "LEVEL_5" => H265CodecLevel::Level5,
            "LEVEL_5_1" => H265CodecLevel::Level51,
            "LEVEL_5_2" => H265CodecLevel::Level52,
            "LEVEL_6" => H265CodecLevel::Level6,
            "LEVEL_6_1" => H265CodecLevel::Level61,
            "LEVEL_6_2" => H265CodecLevel::Level62,
            other => H265CodecLevel::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265CodecLevel {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265CodecLevel::from(s))
    }
}
impl H265CodecLevel {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265CodecLevel::Auto => "AUTO",
            H265CodecLevel::Level1 => "LEVEL_1",
            H265CodecLevel::Level2 => "LEVEL_2",
            H265CodecLevel::Level21 => "LEVEL_2_1",
            H265CodecLevel::Level3 => "LEVEL_3",
            H265CodecLevel::Level31 => "LEVEL_3_1",
            H265CodecLevel::Level4 => "LEVEL_4",
            H265CodecLevel::Level41 => "LEVEL_4_1",
            H265CodecLevel::Level5 => "LEVEL_5",
            H265CodecLevel::Level51 => "LEVEL_5_1",
            H265CodecLevel::Level52 => "LEVEL_5_2",
            H265CodecLevel::Level6 => "LEVEL_6",
            H265CodecLevel::Level61 => "LEVEL_6_1",
            H265CodecLevel::Level62 => "LEVEL_6_2",
            H265CodecLevel::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AUTO",
            "LEVEL_1",
            "LEVEL_2",
            "LEVEL_2_1",
            "LEVEL_3",
            "LEVEL_3_1",
            "LEVEL_4",
            "LEVEL_4_1",
            "LEVEL_5",
            "LEVEL_5_1",
            "LEVEL_5_2",
            "LEVEL_6",
            "LEVEL_6_1",
            "LEVEL_6_2",
        ]
    }
}
impl AsRef<str> for H265CodecLevel {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Enables Alternate Transfer Function SEI message for outputs using Hybrid Log Gamma (HLG) Electro-Optical Transfer Function (EOTF).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265AlternateTransferFunctionSei {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265AlternateTransferFunctionSei {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => H265AlternateTransferFunctionSei::Disabled,
            "ENABLED" => H265AlternateTransferFunctionSei::Enabled,
            other => H265AlternateTransferFunctionSei::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265AlternateTransferFunctionSei {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265AlternateTransferFunctionSei::from(s))
    }
}
impl H265AlternateTransferFunctionSei {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265AlternateTransferFunctionSei::Disabled => "DISABLED",
            H265AlternateTransferFunctionSei::Enabled => "ENABLED",
            H265AlternateTransferFunctionSei::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for H265AlternateTransferFunctionSei {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Specify the strength of any adaptive quantization filters that you enable. The value that you choose here applies to the following settings: Flicker adaptive quantization (flickerAdaptiveQuantization), Spatial adaptive quantization (spatialAdaptiveQuantization), and Temporal adaptive quantization (temporalAdaptiveQuantization).
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum H265AdaptiveQuantization {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Higher,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Max,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    #[allow(missing_docs)] // documentation missing in model
    Off,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for H265AdaptiveQuantization {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => H265AdaptiveQuantization::High,
            "HIGHER" => H265AdaptiveQuantization::Higher,
            "LOW" => H265AdaptiveQuantization::Low,
            "MAX" => H265AdaptiveQuantization::Max,
            "MEDIUM" => H265AdaptiveQuantization::Medium,
            "OFF" => H265AdaptiveQuantization::Off,
            other => H265AdaptiveQuantization::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for H265AdaptiveQuantization {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(H265AdaptiveQuantization::from(s))
    }
}
impl H265AdaptiveQuantization {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            H265AdaptiveQuantization::High => "HIGH",
            H265AdaptiveQuantization::Higher => "HIGHER",
            H265AdaptiveQuantization::Low => "LOW",
            H265AdaptiveQuantization::Max => "MAX",
            H265AdaptiveQuantization::Medium => "MEDIUM",
            H265AdaptiveQuantization::Off => "OFF",
            H265AdaptiveQuantization::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "HIGHER", "LOW", "MAX", "MEDIUM", "OFF"]
    }
}
impl AsRef<str> for H265AdaptiveQuantization {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Required when you set (Codec) under (VideoDescription)>(CodecSettings) to the value H_264.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct H264Settings {
    /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
    pub adaptive_quantization: std::option::Option<crate::model::H264AdaptiveQuantization>,
    /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
    pub bitrate: i32,
    /// Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to specify, choose Auto (AUTO).
    pub codec_level: std::option::Option<crate::model::H264CodecLevel>,
    /// H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
    pub codec_profile: std::option::Option<crate::model::H264CodecProfile>,
    /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
    pub dynamic_sub_gop: std::option::Option<crate::model::H264DynamicSubGop>,
    /// Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
    pub entropy_encoding: std::option::Option<crate::model::H264EntropyEncoding>,
    /// The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
    pub field_encoding: std::option::Option<crate::model::H264FieldEncoding>,
    /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
    pub flicker_adaptive_quantization:
        std::option::Option<crate::model::H264FlickerAdaptiveQuantization>,
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub framerate_control: std::option::Option<crate::model::H264FramerateControl>,
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub framerate_conversion_algorithm:
        std::option::Option<crate::model::H264FramerateConversionAlgorithm>,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_denominator: i32,
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub framerate_numerator: i32,
    /// If enable, use reference B frames for GOP structures that have B frames > 1.
    pub gop_b_reference: std::option::Option<crate::model::H264GopBReference>,
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub gop_closed_cadence: i32,
    /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
    pub gop_size: f64,
    /// Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
    pub gop_size_units: std::option::Option<crate::model::H264GopSizeUnits>,
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub hrd_buffer_initial_fill_percentage: i32,
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub hrd_buffer_size: i32,
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub interlace_mode: std::option::Option<crate::model::H264InterlaceMode>,
    /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
    pub max_bitrate: i32,
    /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub min_i_interval: i32,
    /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
    pub number_b_frames_between_reference_frames: i32,
    /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
    pub number_reference_frames: i32,
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub par_control: std::option::Option<crate::model::H264ParControl>,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub par_denominator: i32,
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub par_numerator: i32,
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub quality_tuning_level: std::option::Option<crate::model::H264QualityTuningLevel>,
    /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
    pub qvbr_settings: std::option::Option<crate::model::H264QvbrSettings>,
    /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
    pub rate_control_mode: std::option::Option<crate::model::H264RateControlMode>,
    /// Places a PPS header on each encoded picture, even if repeated.
    pub repeat_pps: std::option::Option<crate::model::H264RepeatPps>,
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub scan_type_conversion_mode: std::option::Option<crate::model::H264ScanTypeConversionMode>,
    /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
    pub scene_change_detect: std::option::Option<crate::model::H264SceneChangeDetect>,
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub slices: i32,
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub slow_pal: std::option::Option<crate::model::H264SlowPal>,
    /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
    pub softness: i32,
    /// Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
    pub spatial_adaptive_quantization:
        std::option::Option<crate::model::H264SpatialAdaptiveQuantization>,
    /// Produces a bitstream compliant with SMPTE RP-2027.
    pub syntax: std::option::Option<crate::model::H264Syntax>,
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub telecine: std::option::Option<crate::model::H264Telecine>,
    /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
    pub temporal_adaptive_quantization:
        std::option::Option<crate::model::H264TemporalAdaptiveQuantization>,
    /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
    pub unregistered_sei_timecode: std::option::Option<crate::model::H264UnregisteredSeiTimecode>,
}
impl H264Settings {
    /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
    pub fn adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H264AdaptiveQuantization> {
        self.adaptive_quantization.as_ref()
    }
    /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
    pub fn bitrate(&self) -> i32 {
        self.bitrate
    }
    /// Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to specify, choose Auto (AUTO).
    pub fn codec_level(&self) -> std::option::Option<&crate::model::H264CodecLevel> {
        self.codec_level.as_ref()
    }
    /// H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
    pub fn codec_profile(&self) -> std::option::Option<&crate::model::H264CodecProfile> {
        self.codec_profile.as_ref()
    }
    /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
    pub fn dynamic_sub_gop(&self) -> std::option::Option<&crate::model::H264DynamicSubGop> {
        self.dynamic_sub_gop.as_ref()
    }
    /// Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
    pub fn entropy_encoding(&self) -> std::option::Option<&crate::model::H264EntropyEncoding> {
        self.entropy_encoding.as_ref()
    }
    /// The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
    pub fn field_encoding(&self) -> std::option::Option<&crate::model::H264FieldEncoding> {
        self.field_encoding.as_ref()
    }
    /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
    pub fn flicker_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H264FlickerAdaptiveQuantization> {
        self.flicker_adaptive_quantization.as_ref()
    }
    /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
    pub fn framerate_control(&self) -> std::option::Option<&crate::model::H264FramerateControl> {
        self.framerate_control.as_ref()
    }
    /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
    pub fn framerate_conversion_algorithm(
        &self,
    ) -> std::option::Option<&crate::model::H264FramerateConversionAlgorithm> {
        self.framerate_conversion_algorithm.as_ref()
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_denominator(&self) -> i32 {
        self.framerate_denominator
    }
    /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
    pub fn framerate_numerator(&self) -> i32 {
        self.framerate_numerator
    }
    /// If enable, use reference B frames for GOP structures that have B frames > 1.
    pub fn gop_b_reference(&self) -> std::option::Option<&crate::model::H264GopBReference> {
        self.gop_b_reference.as_ref()
    }
    /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
    pub fn gop_closed_cadence(&self) -> i32 {
        self.gop_closed_cadence
    }
    /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
    pub fn gop_size(&self) -> f64 {
        self.gop_size
    }
    /// Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
    pub fn gop_size_units(&self) -> std::option::Option<&crate::model::H264GopSizeUnits> {
        self.gop_size_units.as_ref()
    }
    /// Percentage of the buffer that should initially be filled (HRD buffer model).
    pub fn hrd_buffer_initial_fill_percentage(&self) -> i32 {
        self.hrd_buffer_initial_fill_percentage
    }
    /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
    pub fn hrd_buffer_size(&self) -> i32 {
        self.hrd_buffer_size
    }
    /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
    pub fn interlace_mode(&self) -> std::option::Option<&crate::model::H264InterlaceMode> {
        self.interlace_mode.as_ref()
    }
    /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
    pub fn max_bitrate(&self) -> i32 {
        self.max_bitrate
    }
    /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
    pub fn min_i_interval(&self) -> i32 {
        self.min_i_interval
    }
    /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
    pub fn number_b_frames_between_reference_frames(&self) -> i32 {
        self.number_b_frames_between_reference_frames
    }
    /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
    pub fn number_reference_frames(&self) -> i32 {
        self.number_reference_frames
    }
    /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
    pub fn par_control(&self) -> std::option::Option<&crate::model::H264ParControl> {
        self.par_control.as_ref()
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
    pub fn par_denominator(&self) -> i32 {
        self.par_denominator
    }
    /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
    pub fn par_numerator(&self) -> i32 {
        self.par_numerator
    }
    /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
    pub fn quality_tuning_level(
        &self,
    ) -> std::option::Option<&crate::model::H264QualityTuningLevel> {
        self.quality_tuning_level.as_ref()
    }
    /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
    pub fn qvbr_settings(&self) -> std::option::Option<&crate::model::H264QvbrSettings> {
        self.qvbr_settings.as_ref()
    }
    /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
    pub fn rate_control_mode(&self) -> std::option::Option<&crate::model::H264RateControlMode> {
        self.rate_control_mode.as_ref()
    }
    /// Places a PPS header on each encoded picture, even if repeated.
    pub fn repeat_pps(&self) -> std::option::Option<&crate::model::H264RepeatPps> {
        self.repeat_pps.as_ref()
    }
    /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
    pub fn scan_type_conversion_mode(
        &self,
    ) -> std::option::Option<&crate::model::H264ScanTypeConversionMode> {
        self.scan_type_conversion_mode.as_ref()
    }
    /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
    pub fn scene_change_detect(&self) -> std::option::Option<&crate::model::H264SceneChangeDetect> {
        self.scene_change_detect.as_ref()
    }
    /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
    pub fn slices(&self) -> i32 {
        self.slices
    }
    /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
    pub fn slow_pal(&self) -> std::option::Option<&crate::model::H264SlowPal> {
        self.slow_pal.as_ref()
    }
    /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
    pub fn softness(&self) -> i32 {
        self.softness
    }
    /// Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
    pub fn spatial_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H264SpatialAdaptiveQuantization> {
        self.spatial_adaptive_quantization.as_ref()
    }
    /// Produces a bitstream compliant with SMPTE RP-2027.
    pub fn syntax(&self) -> std::option::Option<&crate::model::H264Syntax> {
        self.syntax.as_ref()
    }
    /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
    pub fn telecine(&self) -> std::option::Option<&crate::model::H264Telecine> {
        self.telecine.as_ref()
    }
    /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
    pub fn temporal_adaptive_quantization(
        &self,
    ) -> std::option::Option<&crate::model::H264TemporalAdaptiveQuantization> {
        self.temporal_adaptive_quantization.as_ref()
    }
    /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
    pub fn unregistered_sei_timecode(
        &self,
    ) -> std::option::Option<&crate::model::H264UnregisteredSeiTimecode> {
        self.unregistered_sei_timecode.as_ref()
    }
}
impl std::fmt::Debug for H264Settings {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("H264Settings");
        formatter.field("adaptive_quantization", &self.adaptive_quantization);
        formatter.field("bitrate", &self.bitrate);
        formatter.field("codec_level", &self.codec_level);
        formatter.field("codec_profile", &self.codec_profile);
        formatter.field("dynamic_sub_gop", &self.dynamic_sub_gop);
        formatter.field("entropy_encoding", &self.entropy_encoding);
        formatter.field("field_encoding", &self.field_encoding);
        formatter.field(
            "flicker_adaptive_quantization",
            &self.flicker_adaptive_quantization,
        );
        formatter.field("framerate_control", &self.framerate_control);
        formatter.field(
            "framerate_conversion_algorithm",
            &self.framerate_conversion_algorithm,
        );
        formatter.field("framerate_denominator", &self.framerate_denominator);
        formatter.field("framerate_numerator", &self.framerate_numerator);
        formatter.field("gop_b_reference", &self.gop_b_reference);
        formatter.field("gop_closed_cadence", &self.gop_closed_cadence);
        formatter.field("gop_size", &self.gop_size);
        formatter.field("gop_size_units", &self.gop_size_units);
        formatter.field(
            "hrd_buffer_initial_fill_percentage",
            &self.hrd_buffer_initial_fill_percentage,
        );
        formatter.field("hrd_buffer_size", &self.hrd_buffer_size);
        formatter.field("interlace_mode", &self.interlace_mode);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("min_i_interval", &self.min_i_interval);
        formatter.field(
            "number_b_frames_between_reference_frames",
            &self.number_b_frames_between_reference_frames,
        );
        formatter.field("number_reference_frames", &self.number_reference_frames);
        formatter.field("par_control", &self.par_control);
        formatter.field("par_denominator", &self.par_denominator);
        formatter.field("par_numerator", &self.par_numerator);
        formatter.field("quality_tuning_level", &self.quality_tuning_level);
        formatter.field("qvbr_settings", &self.qvbr_settings);
        formatter.field("rate_control_mode", &self.rate_control_mode);
        formatter.field("repeat_pps", &self.repeat_pps);
        formatter.field("scan_type_conversion_mode", &self.scan_type_conversion_mode);
        formatter.field("scene_change_detect", &self.scene_change_detect);
        formatter.field("slices", &self.slices);
        formatter.field("slow_pal", &self.slow_pal);
        formatter.field("softness", &self.softness);
        formatter.field(
            "spatial_adaptive_quantization",
            &self.spatial_adaptive_quantization,
        );
        formatter.field("syntax", &self.syntax);
        formatter.field("telecine", &self.telecine);
        formatter.field(
            "temporal_adaptive_quantization",
            &self.temporal_adaptive_quantization,
        );
        formatter.field("unregistered_sei_timecode", &self.unregistered_sei_timecode);
        formatter.finish()
    }
}
/// See [`H264Settings`](crate::model::H264Settings)
pub mod h264_settings {
    /// A builder for [`H264Settings`](crate::model::H264Settings)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) adaptive_quantization:
            std::option::Option<crate::model::H264AdaptiveQuantization>,
        pub(crate) bitrate: std::option::Option<i32>,
        pub(crate) codec_level: std::option::Option<crate::model::H264CodecLevel>,
        pub(crate) codec_profile: std::option::Option<crate::model::H264CodecProfile>,
        pub(crate) dynamic_sub_gop: std::option::Option<crate::model::H264DynamicSubGop>,
        pub(crate) entropy_encoding: std::option::Option<crate::model::H264EntropyEncoding>,
        pub(crate) field_encoding: std::option::Option<crate::model::H264FieldEncoding>,
        pub(crate) flicker_adaptive_quantization:
            std::option::Option<crate::model::H264FlickerAdaptiveQuantization>,
        pub(crate) framerate_control: std::option::Option<crate::model::H264FramerateControl>,
        pub(crate) framerate_conversion_algorithm:
            std::option::Option<crate::model::H264FramerateConversionAlgorithm>,
        pub(crate) framerate_denominator: std::option::Option<i32>,
        pub(crate) framerate_numerator: std::option::Option<i32>,
        pub(crate) gop_b_reference: std::option::Option<crate::model::H264GopBReference>,
        pub(crate) gop_closed_cadence: std::option::Option<i32>,
        pub(crate) gop_size: std::option::Option<f64>,
        pub(crate) gop_size_units: std::option::Option<crate::model::H264GopSizeUnits>,
        pub(crate) hrd_buffer_initial_fill_percentage: std::option::Option<i32>,
        pub(crate) hrd_buffer_size: std::option::Option<i32>,
        pub(crate) interlace_mode: std::option::Option<crate::model::H264InterlaceMode>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) min_i_interval: std::option::Option<i32>,
        pub(crate) number_b_frames_between_reference_frames: std::option::Option<i32>,
        pub(crate) number_reference_frames: std::option::Option<i32>,
        pub(crate) par_control: std::option::Option<crate::model::H264ParControl>,
        pub(crate) par_denominator: std::option::Option<i32>,
        pub(crate) par_numerator: std::option::Option<i32>,
        pub(crate) quality_tuning_level: std::option::Option<crate::model::H264QualityTuningLevel>,
        pub(crate) qvbr_settings: std::option::Option<crate::model::H264QvbrSettings>,
        pub(crate) rate_control_mode: std::option::Option<crate::model::H264RateControlMode>,
        pub(crate) repeat_pps: std::option::Option<crate::model::H264RepeatPps>,
        pub(crate) scan_type_conversion_mode:
            std::option::Option<crate::model::H264ScanTypeConversionMode>,
        pub(crate) scene_change_detect: std::option::Option<crate::model::H264SceneChangeDetect>,
        pub(crate) slices: std::option::Option<i32>,
        pub(crate) slow_pal: std::option::Option<crate::model::H264SlowPal>,
        pub(crate) softness: std::option::Option<i32>,
        pub(crate) spatial_adaptive_quantization:
            std::option::Option<crate::model::H264SpatialAdaptiveQuantization>,
        pub(crate) syntax: std::option::Option<crate::model::H264Syntax>,
        pub(crate) telecine: std::option::Option<crate::model::H264Telecine>,
        pub(crate) temporal_adaptive_quantization:
            std::option::Option<crate::model::H264TemporalAdaptiveQuantization>,
        pub(crate) unregistered_sei_timecode:
            std::option::Option<crate::model::H264UnregisteredSeiTimecode>,
    }
    impl Builder {
        /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
        pub fn adaptive_quantization(
            mut self,
            input: crate::model::H264AdaptiveQuantization,
        ) -> Self {
            self.adaptive_quantization = Some(input);
            self
        }
        /// Keep the default value, Auto (AUTO), for this setting to have MediaConvert automatically apply the best types of quantization for your video content. When you want to apply your quantization settings manually, you must set H264AdaptiveQuantization to a value other than Auto (AUTO). Use this setting to specify the strength of any adaptive quantization filters that you enable. If you don't want MediaConvert to do any adaptive quantization in this transcode, set Adaptive quantization (H264AdaptiveQuantization) to Off (OFF). Related settings: The value that you choose here applies to the following settings: H264FlickerAdaptiveQuantization, H264SpatialAdaptiveQuantization, and H264TemporalAdaptiveQuantization.
        pub fn set_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H264AdaptiveQuantization>,
        ) -> Self {
            self.adaptive_quantization = input;
            self
        }
        /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
        pub fn bitrate(mut self, input: i32) -> Self {
            self.bitrate = Some(input);
            self
        }
        /// Specify the average bitrate in bits per second. Required for VBR and CBR. For MS Smooth outputs, bitrates must be unique when rounded down to the nearest multiple of 1000.
        pub fn set_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.bitrate = input;
            self
        }
        /// Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to specify, choose Auto (AUTO).
        pub fn codec_level(mut self, input: crate::model::H264CodecLevel) -> Self {
            self.codec_level = Some(input);
            self
        }
        /// Specify an H.264 level that is consistent with your output video settings. If you aren't sure what level to specify, choose Auto (AUTO).
        pub fn set_codec_level(
            mut self,
            input: std::option::Option<crate::model::H264CodecLevel>,
        ) -> Self {
            self.codec_level = input;
            self
        }
        /// H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
        pub fn codec_profile(mut self, input: crate::model::H264CodecProfile) -> Self {
            self.codec_profile = Some(input);
            self
        }
        /// H.264 Profile. High 4:2:2 and 10-bit profiles are only available with the AVC-I License.
        pub fn set_codec_profile(
            mut self,
            input: std::option::Option<crate::model::H264CodecProfile>,
        ) -> Self {
            self.codec_profile = input;
            self
        }
        /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
        pub fn dynamic_sub_gop(mut self, input: crate::model::H264DynamicSubGop) -> Self {
            self.dynamic_sub_gop = Some(input);
            self
        }
        /// Choose Adaptive to improve subjective video quality for high-motion content. This will cause the service to use fewer B-frames (which infer information based on other frames) for high-motion portions of the video and more B-frames for low-motion portions. The maximum number of B-frames is limited by the value you provide for the setting B frames between reference frames (numberBFramesBetweenReferenceFrames).
        pub fn set_dynamic_sub_gop(
            mut self,
            input: std::option::Option<crate::model::H264DynamicSubGop>,
        ) -> Self {
            self.dynamic_sub_gop = input;
            self
        }
        /// Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
        pub fn entropy_encoding(mut self, input: crate::model::H264EntropyEncoding) -> Self {
            self.entropy_encoding = Some(input);
            self
        }
        /// Entropy encoding mode. Use CABAC (must be in Main or High profile) or CAVLC.
        pub fn set_entropy_encoding(
            mut self,
            input: std::option::Option<crate::model::H264EntropyEncoding>,
        ) -> Self {
            self.entropy_encoding = input;
            self
        }
        /// The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
        pub fn field_encoding(mut self, input: crate::model::H264FieldEncoding) -> Self {
            self.field_encoding = Some(input);
            self
        }
        /// The video encoding method for your MPEG-4 AVC output. Keep the default value, PAFF, to have MediaConvert use PAFF encoding for interlaced outputs. Choose Force field (FORCE_FIELD) to disable PAFF encoding and create separate interlaced fields. Choose MBAFF to disable PAFF and have MediaConvert use MBAFF encoding for interlaced outputs.
        pub fn set_field_encoding(
            mut self,
            input: std::option::Option<crate::model::H264FieldEncoding>,
        ) -> Self {
            self.field_encoding = input;
            self
        }
        /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
        pub fn flicker_adaptive_quantization(
            mut self,
            input: crate::model::H264FlickerAdaptiveQuantization,
        ) -> Self {
            self.flicker_adaptive_quantization = Some(input);
            self
        }
        /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264FlickerAdaptiveQuantization is Disabled (DISABLED). Change this value to Enabled (ENABLED) to reduce I-frame pop. I-frame pop appears as a visual flicker that can arise when the encoder saves bits by copying some macroblocks many times from frame to frame, and then refreshes them at the I-frame. When you enable this setting, the encoder updates these macroblocks slightly more often to smooth out the flicker. To manually enable or disable H264FlickerAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
        pub fn set_flicker_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H264FlickerAdaptiveQuantization>,
        ) -> Self {
            self.flicker_adaptive_quantization = input;
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn framerate_control(mut self, input: crate::model::H264FramerateControl) -> Self {
            self.framerate_control = Some(input);
            self
        }
        /// If you are using the console, use the Framerate setting to specify the frame rate for this output. If you want to keep the same frame rate as the input video, choose Follow source. If you want to do frame rate conversion, choose a frame rate from the dropdown list or choose Custom. The framerates shown in the dropdown list are decimal approximations of fractions. If you choose Custom, specify your frame rate as a fraction. If you are creating your transcoding job specification as a JSON file without the console, use FramerateControl to specify which value the service uses for the frame rate for this output. Choose INITIALIZE_FROM_SOURCE if you want the service to use the frame rate from the input. Choose SPECIFIED if you want the service to use the frame rate you specify in the settings FramerateNumerator and FramerateDenominator.
        pub fn set_framerate_control(
            mut self,
            input: std::option::Option<crate::model::H264FramerateControl>,
        ) -> Self {
            self.framerate_control = input;
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn framerate_conversion_algorithm(
            mut self,
            input: crate::model::H264FramerateConversionAlgorithm,
        ) -> Self {
            self.framerate_conversion_algorithm = Some(input);
            self
        }
        /// Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. We recommend using drop duplicate (DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to 30 fps. For numerically complex conversions, you can use interpolate (INTERPOLATE) to avoid stutter. This results in a smooth picture, but might introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has already been converted from its original cadence, use FrameFormer (FRAMEFORMER) to do motion-compensated interpolation. FrameFormer chooses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding time and incurs a significant add-on cost.
        pub fn set_framerate_conversion_algorithm(
            mut self,
            input: std::option::Option<crate::model::H264FramerateConversionAlgorithm>,
        ) -> Self {
            self.framerate_conversion_algorithm = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_denominator(mut self, input: i32) -> Self {
            self.framerate_denominator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateDenominator to specify the denominator of this fraction. In this example, use 1001 for the value of FramerateDenominator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_denominator = input;
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn framerate_numerator(mut self, input: i32) -> Self {
            self.framerate_numerator = Some(input);
            self
        }
        /// When you use the API for transcode jobs that use frame rate conversion, specify the frame rate as a fraction. For example,  24000 / 1001 = 23.976 fps. Use FramerateNumerator to specify the numerator of this fraction. In this example, use 24000 for the value of FramerateNumerator. When you use the console for transcode jobs that use frame rate conversion, provide the value as a decimal number for Framerate. In this example, specify 23.976.
        pub fn set_framerate_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.framerate_numerator = input;
            self
        }
        /// If enable, use reference B frames for GOP structures that have B frames > 1.
        pub fn gop_b_reference(mut self, input: crate::model::H264GopBReference) -> Self {
            self.gop_b_reference = Some(input);
            self
        }
        /// If enable, use reference B frames for GOP structures that have B frames > 1.
        pub fn set_gop_b_reference(
            mut self,
            input: std::option::Option<crate::model::H264GopBReference>,
        ) -> Self {
            self.gop_b_reference = input;
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn gop_closed_cadence(mut self, input: i32) -> Self {
            self.gop_closed_cadence = Some(input);
            self
        }
        /// Frequency of closed GOPs. In streaming applications, it is recommended that this be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly as possible. Setting this value to 0 will break output segmenting.
        pub fn set_gop_closed_cadence(mut self, input: std::option::Option<i32>) -> Self {
            self.gop_closed_cadence = input;
            self
        }
        /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
        pub fn gop_size(mut self, input: f64) -> Self {
            self.gop_size = Some(input);
            self
        }
        /// GOP Length (keyframe interval) in frames or seconds. Must be greater than zero.
        pub fn set_gop_size(mut self, input: std::option::Option<f64>) -> Self {
            self.gop_size = input;
            self
        }
        /// Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
        pub fn gop_size_units(mut self, input: crate::model::H264GopSizeUnits) -> Self {
            self.gop_size_units = Some(input);
            self
        }
        /// Indicates if the GOP Size in H264 is specified in frames or seconds. If seconds the system will convert the GOP Size into a frame count at run time.
        pub fn set_gop_size_units(
            mut self,
            input: std::option::Option<crate::model::H264GopSizeUnits>,
        ) -> Self {
            self.gop_size_units = input;
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn hrd_buffer_initial_fill_percentage(mut self, input: i32) -> Self {
            self.hrd_buffer_initial_fill_percentage = Some(input);
            self
        }
        /// Percentage of the buffer that should initially be filled (HRD buffer model).
        pub fn set_hrd_buffer_initial_fill_percentage(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.hrd_buffer_initial_fill_percentage = input;
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn hrd_buffer_size(mut self, input: i32) -> Self {
            self.hrd_buffer_size = Some(input);
            self
        }
        /// Size of buffer (HRD buffer model) in bits. For example, enter five megabits as 5000000.
        pub fn set_hrd_buffer_size(mut self, input: std::option::Option<i32>) -> Self {
            self.hrd_buffer_size = input;
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn interlace_mode(mut self, input: crate::model::H264InterlaceMode) -> Self {
            self.interlace_mode = Some(input);
            self
        }
        /// Choose the scan line type for the output. Keep the default value, Progressive (PROGRESSIVE) to create a progressive output, regardless of the scan type of your input. Use Top field first (TOP_FIELD) or Bottom field first (BOTTOM_FIELD) to create an output that's interlaced with the same field polarity throughout. Use Follow, default top (FOLLOW_TOP_FIELD) or Follow, default bottom (FOLLOW_BOTTOM_FIELD) to produce outputs with the same field polarity as the source. For jobs that have multiple inputs, the output field polarity might change over the course of the output. Follow behavior depends on the input scan type. If the source is interlaced, the output will be interlaced with the same polarity as the source. If the source is progressive, the output will be interlaced with top field bottom field first, depending on which of the Follow options you choose.
        pub fn set_interlace_mode(
            mut self,
            input: std::option::Option<crate::model::H264InterlaceMode>,
        ) -> Self {
            self.interlace_mode = input;
            self
        }
        /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// Maximum bitrate in bits/second. For example, enter five megabits per second as 5000000. Required when Rate control mode is QVBR.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn min_i_interval(mut self, input: i32) -> Self {
            self.min_i_interval = Some(input);
            self
        }
        /// Enforces separation between repeated (cadence) I-frames and I-frames inserted by Scene Change Detection. If a scene change I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk and/or stretched to the scene change I-frame. GOP stretch requires enabling lookahead as well as setting I-interval. The normal cadence resumes for the next GOP. This setting is only used when Scene Change Detect is enabled. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
        pub fn set_min_i_interval(mut self, input: std::option::Option<i32>) -> Self {
            self.min_i_interval = input;
            self
        }
        /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
        pub fn number_b_frames_between_reference_frames(mut self, input: i32) -> Self {
            self.number_b_frames_between_reference_frames = Some(input);
            self
        }
        /// Specify the number of B-frames that MediaConvert puts between reference frames in this output. Valid values are whole numbers from 0 through 7. When you don't specify a value, MediaConvert defaults to 2.
        pub fn set_number_b_frames_between_reference_frames(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.number_b_frames_between_reference_frames = input;
            self
        }
        /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
        pub fn number_reference_frames(mut self, input: i32) -> Self {
            self.number_reference_frames = Some(input);
            self
        }
        /// Number of reference frames to use. The encoder may use more than requested if using B-frames and/or interlaced encoding.
        pub fn set_number_reference_frames(mut self, input: std::option::Option<i32>) -> Self {
            self.number_reference_frames = input;
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn par_control(mut self, input: crate::model::H264ParControl) -> Self {
            self.par_control = Some(input);
            self
        }
        /// Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior, Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the parNumerator and parDenominator settings.
        pub fn set_par_control(
            mut self,
            input: std::option::Option<crate::model::H264ParControl>,
        ) -> Self {
            self.par_control = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn par_denominator(mut self, input: i32) -> Self {
            self.par_denominator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parDenominator is 33.
        pub fn set_par_denominator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_denominator = input;
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn par_numerator(mut self, input: i32) -> Self {
            self.par_numerator = Some(input);
            self
        }
        /// Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On the console, this corresponds to any value other than Follow source. When you specify an output pixel aspect ratio (PAR) that is different from your input video PAR, provide your output PAR as a ratio. For example, for D1/DV NTSC widescreen, you would specify the ratio 40:33. In this example, the value for parNumerator is 40.
        pub fn set_par_numerator(mut self, input: std::option::Option<i32>) -> Self {
            self.par_numerator = input;
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn quality_tuning_level(mut self, input: crate::model::H264QualityTuningLevel) -> Self {
            self.quality_tuning_level = Some(input);
            self
        }
        /// Optional. Use Quality tuning level (qualityTuningLevel) to choose how you want to trade off encoding speed for output video quality. The default behavior is faster, lower quality, single-pass encoding.
        pub fn set_quality_tuning_level(
            mut self,
            input: std::option::Option<crate::model::H264QualityTuningLevel>,
        ) -> Self {
            self.quality_tuning_level = input;
            self
        }
        /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
        pub fn qvbr_settings(mut self, input: crate::model::H264QvbrSettings) -> Self {
            self.qvbr_settings = Some(input);
            self
        }
        /// Settings for quality-defined variable bitrate encoding with the H.265 codec. Use these settings only when you set QVBR for Rate control mode (RateControlMode).
        pub fn set_qvbr_settings(
            mut self,
            input: std::option::Option<crate::model::H264QvbrSettings>,
        ) -> Self {
            self.qvbr_settings = input;
            self
        }
        /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
        pub fn rate_control_mode(mut self, input: crate::model::H264RateControlMode) -> Self {
            self.rate_control_mode = Some(input);
            self
        }
        /// Use this setting to specify whether this output has a variable bitrate (VBR), constant bitrate (CBR) or quality-defined variable bitrate (QVBR).
        pub fn set_rate_control_mode(
            mut self,
            input: std::option::Option<crate::model::H264RateControlMode>,
        ) -> Self {
            self.rate_control_mode = input;
            self
        }
        /// Places a PPS header on each encoded picture, even if repeated.
        pub fn repeat_pps(mut self, input: crate::model::H264RepeatPps) -> Self {
            self.repeat_pps = Some(input);
            self
        }
        /// Places a PPS header on each encoded picture, even if repeated.
        pub fn set_repeat_pps(
            mut self,
            input: std::option::Option<crate::model::H264RepeatPps>,
        ) -> Self {
            self.repeat_pps = input;
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn scan_type_conversion_mode(
            mut self,
            input: crate::model::H264ScanTypeConversionMode,
        ) -> Self {
            self.scan_type_conversion_mode = Some(input);
            self
        }
        /// Use this setting for interlaced outputs, when your output frame rate is half of your input frame rate. In this situation, choose Optimized interlacing (INTERLACED_OPTIMIZE) to create a better quality interlaced output. In this case, each progressive frame from the input corresponds to an interlaced field in the output. Keep the default value, Basic interlacing (INTERLACED), for all other output frame rates. With basic interlacing, MediaConvert performs any frame rate conversion first and then interlaces the frames. When you choose Optimized interlacing and you set your output frame rate to a value that isn't suitable for optimized interlacing, MediaConvert automatically falls back to basic interlacing. Required settings: To use optimized interlacing, you must set Telecine (telecine) to None (NONE) or Soft (SOFT). You can't use optimized interlacing for hard telecine outputs. You must also set Interlace mode (interlaceMode) to a value other than Progressive (PROGRESSIVE).
        pub fn set_scan_type_conversion_mode(
            mut self,
            input: std::option::Option<crate::model::H264ScanTypeConversionMode>,
        ) -> Self {
            self.scan_type_conversion_mode = input;
            self
        }
        /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
        pub fn scene_change_detect(mut self, input: crate::model::H264SceneChangeDetect) -> Self {
            self.scene_change_detect = Some(input);
            self
        }
        /// Enable this setting to insert I-frames at scene changes that the service automatically detects. This improves video quality and is enabled by default. If this output uses QVBR, choose Transition detection (TRANSITION_DETECTION) for further video quality improvement. For more information about QVBR, see https://docs.aws.amazon.com/console/mediaconvert/cbr-vbr-qvbr.
        pub fn set_scene_change_detect(
            mut self,
            input: std::option::Option<crate::model::H264SceneChangeDetect>,
        ) -> Self {
            self.scene_change_detect = input;
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn slices(mut self, input: i32) -> Self {
            self.slices = Some(input);
            self
        }
        /// Number of slices per picture. Must be less than or equal to the number of macroblock rows for progressive pictures, and less than or equal to half the number of macroblock rows for interlaced pictures.
        pub fn set_slices(mut self, input: std::option::Option<i32>) -> Self {
            self.slices = input;
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn slow_pal(mut self, input: crate::model::H264SlowPal) -> Self {
            self.slow_pal = Some(input);
            self
        }
        /// Ignore this setting unless your input frame rate is 23.976 or 24 frames per second (fps). Enable slow PAL to create a 25 fps output. When you enable slow PAL, MediaConvert relabels the video frames to 25 fps and resamples your audio to keep it synchronized with the video. Note that enabling this setting will slightly reduce the duration of your video. Required settings: You must also set Framerate to 25. In your JSON job specification, set (framerateControl) to (SPECIFIED), (framerateNumerator) to 25 and (framerateDenominator) to 1.
        pub fn set_slow_pal(
            mut self,
            input: std::option::Option<crate::model::H264SlowPal>,
        ) -> Self {
            self.slow_pal = input;
            self
        }
        /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
        pub fn softness(mut self, input: i32) -> Self {
            self.softness = Some(input);
            self
        }
        /// Ignore this setting unless you need to comply with a specification that requires a specific value. If you don't have a specification requirement, we recommend that you adjust the softness of your output by using a lower value for the setting Sharpness (sharpness) or by enabling a noise reducer filter (noiseReducerFilter). The Softness (softness) setting specifies the quantization matrices that the encoder uses. Keep the default value, 0, for flat quantization. Choose the value 1 or 16 to use the default JVT softening quantization matricies from the H.264 specification. Choose a value from 17 to 128 to use planar interpolation. Increasing values from 17 to 128 result in increasing reduction of high-frequency data. The value 128 results in the softest video.
        pub fn set_softness(mut self, input: std::option::Option<i32>) -> Self {
            self.softness = input;
            self
        }
        /// Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
        pub fn spatial_adaptive_quantization(
            mut self,
            input: crate::model::H264SpatialAdaptiveQuantization,
        ) -> Self {
            self.spatial_adaptive_quantization = Some(input);
            self
        }
        /// Only use this setting when you change the default value, Auto (AUTO), for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264SpatialAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on spatial variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas that can sustain more distortion with no noticeable visual degradation and uses more bits on areas where any small distortion will be noticeable. For example, complex textured blocks are encoded with fewer bits and smooth textured blocks are encoded with more bits. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen with a lot of complex texture, you might choose to set H264SpatialAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable spatial adaptive quantization, set the value for Adaptive quantization (H264AdaptiveQuantization) depending on your content. For homogeneous content, such as cartoons and video games, set it to Low. For content with a wider variety of textures, set it to High or Higher. To manually enable or disable H264SpatialAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
        pub fn set_spatial_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H264SpatialAdaptiveQuantization>,
        ) -> Self {
            self.spatial_adaptive_quantization = input;
            self
        }
        /// Produces a bitstream compliant with SMPTE RP-2027.
        pub fn syntax(mut self, input: crate::model::H264Syntax) -> Self {
            self.syntax = Some(input);
            self
        }
        /// Produces a bitstream compliant with SMPTE RP-2027.
        pub fn set_syntax(mut self, input: std::option::Option<crate::model::H264Syntax>) -> Self {
            self.syntax = input;
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn telecine(mut self, input: crate::model::H264Telecine) -> Self {
            self.telecine = Some(input);
            self
        }
        /// When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD) produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother picture.
        pub fn set_telecine(
            mut self,
            input: std::option::Option<crate::model::H264Telecine>,
        ) -> Self {
            self.telecine = input;
            self
        }
        /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
        pub fn temporal_adaptive_quantization(
            mut self,
            input: crate::model::H264TemporalAdaptiveQuantization,
        ) -> Self {
            self.temporal_adaptive_quantization = Some(input);
            self
        }
        /// Only use this setting when you change the default value, AUTO, for the setting H264AdaptiveQuantization. When you keep all defaults, excluding H264AdaptiveQuantization and all other adaptive quantization from your JSON job specification, MediaConvert automatically applies the best types of quantization for your video content. When you set H264AdaptiveQuantization to a value other than AUTO, the default value for H264TemporalAdaptiveQuantization is Enabled (ENABLED). Keep this default value to adjust quantization within each frame based on temporal variation of content complexity. When you enable this feature, the encoder uses fewer bits on areas of the frame that aren't moving and uses more bits on complex objects with sharp edges that move a lot. For example, this feature improves the readability of text tickers on newscasts and scoreboards on sports matches. Enabling this feature will almost always improve your video quality. Note, though, that this feature doesn't take into account where the viewer's attention is likely to be. If viewers are likely to be focusing their attention on a part of the screen that doesn't have moving objects with sharp edges, such as sports athletes' faces, you might choose to set H264TemporalAdaptiveQuantization to Disabled (DISABLED). Related setting: When you enable temporal quantization, adjust the strength of the filter with the setting Adaptive quantization (adaptiveQuantization). To manually enable or disable H264TemporalAdaptiveQuantization, you must set Adaptive quantization (H264AdaptiveQuantization) to a value other than AUTO.
        pub fn set_temporal_adaptive_quantization(
            mut self,
            input: std::option::Option<crate::model::H264TemporalAdaptiveQuantization>,
        ) -> Self {
            self.temporal_adaptive_quantization = input;
            self
        }
        /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
        pub fn unregistered_sei_timecode(
            mut self,
            input: crate::model::H264UnregisteredSeiTimecode,
        ) -> Self {
            self.unregistered_sei_timecode = Some(input);
            self
        }
        /// Inserts timecode for each frame as 4 bytes of an unregistered SEI message.
        pub fn set_unregistered_sei_timecode(
            mut self,
            input: std::option::Option<crate::model::H264UnregisteredSeiTimecode>,
        ) -> Self {
            self.unregistered_sei_timecode = input;
            self
        }
        /// Consumes the builder and constructs a [`H264Settings`](crate::model::H264Settings)
        pub fn build(self) -> crate::model::H264Settings {
            crate::model::H264Settings {
                adaptive_quantization: self.adaptive_quantization,
                bitrate: self.bitrate.unwrap_or_default(),
                codec_level: self.codec_level,
                codec_profile: self.codec_profile,
                dynamic_sub_gop: self.dynamic_sub_gop,
                entropy_e