// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AssociateCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AssociateCertificateError {
    /// Kind of error that occurred.
    pub kind: AssociateCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AssociateCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AssociateCertificateErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AssociateCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AssociateCertificateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AssociateCertificateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AssociateCertificateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AssociateCertificateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AssociateCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AssociateCertificateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AssociateCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AssociateCertificateError {
    fn code(&self) -> Option<&str> {
        AssociateCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AssociateCertificateError {
    /// Creates a new `AssociateCertificateError`.
    pub fn new(kind: AssociateCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AssociateCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AssociateCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AssociateCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AssociateCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AssociateCertificateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCertificateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCertificateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCertificateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCertificateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCertificateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCertificateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCertificateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AssociateCertificateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AssociateCertificateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AssociateCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AssociateCertificateErrorKind::BadRequestException(_inner) => Some(_inner),
            AssociateCertificateErrorKind::ConflictException(_inner) => Some(_inner),
            AssociateCertificateErrorKind::ForbiddenException(_inner) => Some(_inner),
            AssociateCertificateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AssociateCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            AssociateCertificateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AssociateCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CancelJobError {
    /// Kind of error that occurred.
    pub kind: CancelJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CancelJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CancelJobErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CancelJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CancelJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CancelJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CancelJobError {
    fn code(&self) -> Option<&str> {
        CancelJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CancelJobError {
    /// Creates a new `CancelJobError`.
    pub fn new(kind: CancelJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CancelJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CancelJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CancelJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CancelJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CancelJobErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CancelJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, CancelJobErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for CancelJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CancelJobErrorKind::BadRequestException(_inner) => Some(_inner),
            CancelJobErrorKind::ConflictException(_inner) => Some(_inner),
            CancelJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            CancelJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CancelJobErrorKind::NotFoundException(_inner) => Some(_inner),
            CancelJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CancelJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobError {
    /// Kind of error that occurred.
    pub kind: CreateJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobError {
    fn code(&self) -> Option<&str> {
        CreateJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobError {
    /// Creates a new `CreateJobError`.
    pub fn new(kind: CreateJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, CreateJobErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for CreateJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateJobErrorKind::ConflictException(_inner) => Some(_inner),
            CreateJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateJobErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateJobTemplateError {
    /// Kind of error that occurred.
    pub kind: CreateJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateJobTemplateErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateJobTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateJobTemplateError {
    fn code(&self) -> Option<&str> {
        CreateJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateJobTemplateError {
    /// Creates a new `CreateJobTemplateError`.
    pub fn new(kind: CreateJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateJobTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateJobTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateJobTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateJobTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateJobTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreatePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreatePresetError {
    /// Kind of error that occurred.
    pub kind: CreatePresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreatePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreatePresetErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreatePresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreatePresetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreatePresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreatePresetError {
    fn code(&self) -> Option<&str> {
        CreatePresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreatePresetError {
    /// Creates a new `CreatePresetError`.
    pub fn new(kind: CreatePresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreatePresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreatePresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreatePresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreatePresetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePresetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreatePresetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreatePresetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreatePresetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreatePresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreatePresetErrorKind::BadRequestException(_inner) => Some(_inner),
            CreatePresetErrorKind::ConflictException(_inner) => Some(_inner),
            CreatePresetErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreatePresetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreatePresetErrorKind::NotFoundException(_inner) => Some(_inner),
            CreatePresetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreatePresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateQueueError {
    /// Kind of error that occurred.
    pub kind: CreateQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateQueueErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateQueueErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateQueueError {
    fn code(&self) -> Option<&str> {
        CreateQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateQueueError {
    /// Creates a new `CreateQueueError`.
    pub fn new(kind: CreateQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueueErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, CreateQueueErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `CreateQueueErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateQueueErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for CreateQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateQueueErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateQueueErrorKind::ConflictException(_inner) => Some(_inner),
            CreateQueueErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateQueueErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            CreateQueueErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteJobTemplateError {
    /// Kind of error that occurred.
    pub kind: DeleteJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteJobTemplateErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteJobTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteJobTemplateError {
    fn code(&self) -> Option<&str> {
        DeleteJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteJobTemplateError {
    /// Creates a new `DeleteJobTemplateError`.
    pub fn new(kind: DeleteJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteJobTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteJobTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteJobTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteJobTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePolicyError {
    /// Kind of error that occurred.
    pub kind: DeletePolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePolicyErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeletePolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePolicyError {
    fn code(&self) -> Option<&str> {
        DeletePolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePolicyError {
    /// Creates a new `DeletePolicyError`.
    pub fn new(kind: DeletePolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeletePolicyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeletePolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePolicyErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeletePolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeletePolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeletePolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            DeletePolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeletePolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeletePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeletePresetError {
    /// Kind of error that occurred.
    pub kind: DeletePresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeletePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeletePresetErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeletePresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeletePresetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeletePresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeletePresetError {
    fn code(&self) -> Option<&str> {
        DeletePresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeletePresetError {
    /// Creates a new `DeletePresetError`.
    pub fn new(kind: DeletePresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeletePresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeletePresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeletePresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeletePresetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeletePresetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeletePresetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeletePresetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePresetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeletePresetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeletePresetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeletePresetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeletePresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeletePresetErrorKind::BadRequestException(_inner) => Some(_inner),
            DeletePresetErrorKind::ConflictException(_inner) => Some(_inner),
            DeletePresetErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeletePresetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeletePresetErrorKind::NotFoundException(_inner) => Some(_inner),
            DeletePresetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeletePresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteQueueError {
    /// Kind of error that occurred.
    pub kind: DeleteQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteQueueErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteQueueErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteQueueErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteQueueErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteQueueErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteQueueErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteQueueError {
    fn code(&self) -> Option<&str> {
        DeleteQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteQueueError {
    /// Creates a new `DeleteQueueError`.
    pub fn new(kind: DeleteQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteQueueErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteQueueErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteQueueErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteQueueErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteQueueErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteQueueErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteQueueErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueueErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteQueueErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteQueueErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteQueueErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DeleteQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteQueueErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteQueueErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteQueueErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteQueueErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteQueueErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEndpointsError {
    /// Kind of error that occurred.
    pub kind: DescribeEndpointsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEndpoints` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEndpointsErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEndpointsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEndpointsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeEndpointsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEndpointsError {
    fn code(&self) -> Option<&str> {
        DescribeEndpointsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEndpointsError {
    /// Creates a new `DescribeEndpointsError`.
    pub fn new(kind: DescribeEndpointsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEndpointsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEndpointsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEndpointsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEndpointsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeEndpointsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeEndpointsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeEndpointsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEndpointsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeEndpointsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEndpointsErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeEndpointsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateCertificateError {
    /// Kind of error that occurred.
    pub kind: DisassociateCertificateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateCertificate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateCertificateErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateCertificateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateCertificateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DisassociateCertificateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateCertificateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DisassociateCertificateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DisassociateCertificateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DisassociateCertificateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DisassociateCertificateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateCertificateError {
    fn code(&self) -> Option<&str> {
        DisassociateCertificateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateCertificateError {
    /// Creates a new `DisassociateCertificateError`.
    pub fn new(kind: DisassociateCertificateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateCertificateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateCertificateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateCertificateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateCertificateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateCertificateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCertificateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCertificateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCertificateErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCertificateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCertificateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCertificateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCertificateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCertificateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCertificateErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateCertificateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateCertificateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DisassociateCertificateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateCertificateErrorKind::BadRequestException(_inner) => Some(_inner),
            DisassociateCertificateErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateCertificateErrorKind::ForbiddenException(_inner) => Some(_inner),
            DisassociateCertificateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DisassociateCertificateErrorKind::NotFoundException(_inner) => Some(_inner),
            DisassociateCertificateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DisassociateCertificateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobError {
    /// Kind of error that occurred.
    pub kind: GetJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetJobErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetJobErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetJobErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJobErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobError {
    fn code(&self) -> Option<&str> {
        GetJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobError {
    /// Creates a new `GetJobError`.
    pub fn new(kind: GetJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::InternalServerErrorException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetJobErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobErrorKind::BadRequestException(_inner) => Some(_inner),
            GetJobErrorKind::ConflictException(_inner) => Some(_inner),
            GetJobErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetJobErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetJobErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJobErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetJobTemplateError {
    /// Kind of error that occurred.
    pub kind: GetJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetJobTemplateErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetJobTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetJobTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetJobTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetJobTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetJobTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetJobTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetJobTemplateError {
    fn code(&self) -> Option<&str> {
        GetJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetJobTemplateError {
    /// Creates a new `GetJobTemplateError`.
    pub fn new(kind: GetJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetJobTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetJobTemplateErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetJobTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetJobTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetJobTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetJobTemplateErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetJobTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetJobTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetJobTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetJobTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetJobTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GetJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetJobTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            GetJobTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            GetJobTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetJobTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetJobTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            GetJobTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPolicyError {
    /// Kind of error that occurred.
    pub kind: GetPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPolicyErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPolicyError {
    fn code(&self) -> Option<&str> {
        GetPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPolicyError {
    /// Creates a new `GetPolicyError`.
    pub fn new(kind: GetPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetPolicyErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            GetPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            GetPolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetPolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetPreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetPresetError {
    /// Kind of error that occurred.
    pub kind: GetPresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetPreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetPresetErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetPresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetPresetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetPresetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetPresetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetPresetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetPresetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetPresetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetPresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetPresetError {
    fn code(&self) -> Option<&str> {
        GetPresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetPresetError {
    /// Creates a new `GetPresetError`.
    pub fn new(kind: GetPresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetPresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetPresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetPresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetPresetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetPresetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetPresetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetPresetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetPresetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetPresetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetPresetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetPresetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetPresetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetPresetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetPresetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetPresetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetPresetErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetPresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetPresetErrorKind::BadRequestException(_inner) => Some(_inner),
            GetPresetErrorKind::ConflictException(_inner) => Some(_inner),
            GetPresetErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetPresetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetPresetErrorKind::NotFoundException(_inner) => Some(_inner),
            GetPresetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetPresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetQueueError {
    /// Kind of error that occurred.
    pub kind: GetQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetQueueErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetQueueErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GetQueueErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetQueueErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GetQueueErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GetQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GetQueueErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GetQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetQueueError {
    fn code(&self) -> Option<&str> {
        GetQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetQueueError {
    /// Creates a new `GetQueueError`.
    pub fn new(kind: GetQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetQueueErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, GetQueueErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `GetQueueErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetQueueErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetQueueErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, GetQueueErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `GetQueueErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetQueueErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetQueueErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetQueueErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, GetQueueErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for GetQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetQueueErrorKind::BadRequestException(_inner) => Some(_inner),
            GetQueueErrorKind::ConflictException(_inner) => Some(_inner),
            GetQueueErrorKind::ForbiddenException(_inner) => Some(_inner),
            GetQueueErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GetQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            GetQueueErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GetQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobsError {
    /// Kind of error that occurred.
    pub kind: ListJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobsErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobsError {
    fn code(&self) -> Option<&str> {
        ListJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobsError {
    /// Creates a new `ListJobsError`.
    pub fn new(kind: ListJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJobsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListJobsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListJobsErrorKind::ConflictException(_inner) => Some(_inner),
            ListJobsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListJobsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListJobsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListJobsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListJobTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListJobTemplatesError {
    /// Kind of error that occurred.
    pub kind: ListJobTemplatesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListJobTemplates` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListJobTemplatesErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListJobTemplatesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListJobTemplatesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListJobTemplatesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListJobTemplatesError {
    fn code(&self) -> Option<&str> {
        ListJobTemplatesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListJobTemplatesError {
    /// Creates a new `ListJobTemplatesError`.
    pub fn new(kind: ListJobTemplatesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListJobTemplatesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListJobTemplatesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListJobTemplatesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListJobTemplatesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobTemplatesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListJobTemplatesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListJobTemplatesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobTemplatesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListJobTemplatesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListJobTemplatesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListJobTemplatesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListJobTemplatesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListJobTemplatesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::ConflictException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListJobTemplatesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListPresets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListPresetsError {
    /// Kind of error that occurred.
    pub kind: ListPresetsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListPresets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListPresetsErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListPresetsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListPresetsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListPresetsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListPresetsError {
    fn code(&self) -> Option<&str> {
        ListPresetsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListPresetsError {
    /// Creates a new `ListPresetsError`.
    pub fn new(kind: ListPresetsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListPresetsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListPresetsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListPresetsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListPresetsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListPresetsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListPresetsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListPresetsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPresetsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListPresetsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListPresetsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListPresetsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListPresetsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListPresetsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListPresetsErrorKind::ConflictException(_inner) => Some(_inner),
            ListPresetsErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListPresetsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListPresetsErrorKind::NotFoundException(_inner) => Some(_inner),
            ListPresetsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListPresetsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListQueuesError {
    /// Kind of error that occurred.
    pub kind: ListQueuesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListQueues` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListQueuesErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListQueuesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListQueuesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListQueuesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListQueuesError {
    fn code(&self) -> Option<&str> {
        ListQueuesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListQueuesError {
    /// Creates a new `ListQueuesError`.
    pub fn new(kind: ListQueuesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListQueuesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListQueuesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListQueuesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListQueuesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListQueuesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `ListQueuesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListQueuesErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListQueuesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListQueuesErrorKind::BadRequestException(_inner) => Some(_inner),
            ListQueuesErrorKind::ConflictException(_inner) => Some(_inner),
            ListQueuesErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListQueuesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListQueuesErrorKind::NotFoundException(_inner) => Some(_inner),
            ListQueuesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListQueuesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ConflictException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutPolicyError {
    /// Kind of error that occurred.
    pub kind: PutPolicyErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutPolicy` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutPolicyErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutPolicyError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutPolicyErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::ConflictException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PutPolicyErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutPolicyError {
    fn code(&self) -> Option<&str> {
        PutPolicyError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutPolicyError {
    /// Creates a new `PutPolicyError`.
    pub fn new(kind: PutPolicyErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutPolicyError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutPolicyErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutPolicyError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutPolicyErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutPolicyErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PutPolicyErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, PutPolicyErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for PutPolicyError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutPolicyErrorKind::BadRequestException(_inner) => Some(_inner),
            PutPolicyErrorKind::ConflictException(_inner) => Some(_inner),
            PutPolicyErrorKind::ForbiddenException(_inner) => Some(_inner),
            PutPolicyErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PutPolicyErrorKind::NotFoundException(_inner) => Some(_inner),
            PutPolicyErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PutPolicyErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateJobTemplateError {
    /// Kind of error that occurred.
    pub kind: UpdateJobTemplateErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateJobTemplate` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateJobTemplateErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateJobTemplateError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateJobTemplateErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateJobTemplateErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateJobTemplateErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateJobTemplateErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateJobTemplateErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateJobTemplateErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateJobTemplateErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateJobTemplateError {
    fn code(&self) -> Option<&str> {
        UpdateJobTemplateError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateJobTemplateError {
    /// Creates a new `UpdateJobTemplateError`.
    pub fn new(kind: UpdateJobTemplateErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateJobTemplateError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateJobTemplateErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateJobTemplateError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateJobTemplateErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateJobTemplateErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobTemplateErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobTemplateErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobTemplateErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobTemplateErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobTemplateErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobTemplateErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobTemplateErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateJobTemplateErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateJobTemplateErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateJobTemplateErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateJobTemplateErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateJobTemplateError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateJobTemplateErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateJobTemplateErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateJobTemplateErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateJobTemplateErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateJobTemplateErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateJobTemplateErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateJobTemplateErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdatePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdatePresetError {
    /// Kind of error that occurred.
    pub kind: UpdatePresetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdatePreset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdatePresetErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdatePresetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdatePresetErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdatePresetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdatePresetErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdatePresetErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdatePresetErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdatePresetErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdatePresetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdatePresetError {
    fn code(&self) -> Option<&str> {
        UpdatePresetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdatePresetError {
    /// Creates a new `UpdatePresetError`.
    pub fn new(kind: UpdatePresetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdatePresetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdatePresetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdatePresetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdatePresetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdatePresetErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdatePresetErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdatePresetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdatePresetErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdatePresetErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdatePresetErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdatePresetErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePresetErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdatePresetErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdatePresetErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdatePresetErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdatePresetErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdatePresetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdatePresetErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdatePresetErrorKind::ConflictException(_inner) => Some(_inner),
            UpdatePresetErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdatePresetErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdatePresetErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdatePresetErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdatePresetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateQueueError {
    /// Kind of error that occurred.
    pub kind: UpdateQueueErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateQueue` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateQueueErrorKind {
    /// The service can't process your request because of a problem in the request. Please check your request form and syntax.
    BadRequestException(crate::error::BadRequestException),
    /// The service couldn't complete your request because there is a conflict with the current state of the resource.
    ConflictException(crate::error::ConflictException),
    /// You don't have permissions for this action with the credentials you sent.
    ForbiddenException(crate::error::ForbiddenException),
    /// The service encountered an unexpected condition and can't fulfill your request.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// The resource you requested doesn't exist.
    NotFoundException(crate::error::NotFoundException),
    /// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateQueueError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateQueueErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateQueueErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateQueueErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateQueueErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateQueueErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateQueueErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateQueueErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateQueueError {
    fn code(&self) -> Option<&str> {
        UpdateQueueError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateQueueError {
    /// Creates a new `UpdateQueueError`.
    pub fn new(kind: UpdateQueueErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateQueueError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateQueueErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateQueueError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateQueueErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateQueueErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateQueueErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateQueueErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UpdateQueueErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `UpdateQueueErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateQueueErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateQueueErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateQueueErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateQueueErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateQueueErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateQueueErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateQueueError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateQueueErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateQueueErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateQueueErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateQueueErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateQueueErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateQueueErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateQueueErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Too many requests have been sent in too short of a time. The service limits the rate at which it will accept requests.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// The resource you requested doesn't exist.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// The service encountered an unexpected condition and can't fulfill your request.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// You don't have permissions for this action with the credentials you sent.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// The service couldn't complete your request because there is a conflict with the current state of the resource.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// The service can't process your request because of a problem in the request. Please check your request form and syntax.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}
