// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `MediaConvert`.
///
/// This client allows ergonomic access to a `MediaConvert`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AssociateCertificate` operation.
    ///
    /// See [`AssociateCertificate`](crate::client::fluent_builders::AssociateCertificate) for more information about the
    /// operation and its arguments.
    pub fn associate_certificate(&self) -> fluent_builders::AssociateCertificate<C, M, R> {
        fluent_builders::AssociateCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CancelJob` operation.
    ///
    /// See [`CancelJob`](crate::client::fluent_builders::CancelJob) for more information about the
    /// operation and its arguments.
    pub fn cancel_job(&self) -> fluent_builders::CancelJob<C, M, R> {
        fluent_builders::CancelJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJob` operation.
    ///
    /// See [`CreateJob`](crate::client::fluent_builders::CreateJob) for more information about the
    /// operation and its arguments.
    pub fn create_job(&self) -> fluent_builders::CreateJob<C, M, R> {
        fluent_builders::CreateJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateJobTemplate` operation.
    ///
    /// See [`CreateJobTemplate`](crate::client::fluent_builders::CreateJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn create_job_template(&self) -> fluent_builders::CreateJobTemplate<C, M, R> {
        fluent_builders::CreateJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreatePreset` operation.
    ///
    /// See [`CreatePreset`](crate::client::fluent_builders::CreatePreset) for more information about the
    /// operation and its arguments.
    pub fn create_preset(&self) -> fluent_builders::CreatePreset<C, M, R> {
        fluent_builders::CreatePreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateQueue` operation.
    ///
    /// See [`CreateQueue`](crate::client::fluent_builders::CreateQueue) for more information about the
    /// operation and its arguments.
    pub fn create_queue(&self) -> fluent_builders::CreateQueue<C, M, R> {
        fluent_builders::CreateQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteJobTemplate` operation.
    ///
    /// See [`DeleteJobTemplate`](crate::client::fluent_builders::DeleteJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn delete_job_template(&self) -> fluent_builders::DeleteJobTemplate<C, M, R> {
        fluent_builders::DeleteJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePolicy` operation.
    ///
    /// See [`DeletePolicy`](crate::client::fluent_builders::DeletePolicy) for more information about the
    /// operation and its arguments.
    pub fn delete_policy(&self) -> fluent_builders::DeletePolicy<C, M, R> {
        fluent_builders::DeletePolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeletePreset` operation.
    ///
    /// See [`DeletePreset`](crate::client::fluent_builders::DeletePreset) for more information about the
    /// operation and its arguments.
    pub fn delete_preset(&self) -> fluent_builders::DeletePreset<C, M, R> {
        fluent_builders::DeletePreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteQueue` operation.
    ///
    /// See [`DeleteQueue`](crate::client::fluent_builders::DeleteQueue) for more information about the
    /// operation and its arguments.
    pub fn delete_queue(&self) -> fluent_builders::DeleteQueue<C, M, R> {
        fluent_builders::DeleteQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEndpoints` operation.
    ///
    /// See [`DescribeEndpoints`](crate::client::fluent_builders::DescribeEndpoints) for more information about the
    /// operation and its arguments.
    pub fn describe_endpoints(&self) -> fluent_builders::DescribeEndpoints<C, M, R> {
        fluent_builders::DescribeEndpoints::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateCertificate` operation.
    ///
    /// See [`DisassociateCertificate`](crate::client::fluent_builders::DisassociateCertificate) for more information about the
    /// operation and its arguments.
    pub fn disassociate_certificate(&self) -> fluent_builders::DisassociateCertificate<C, M, R> {
        fluent_builders::DisassociateCertificate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJob` operation.
    ///
    /// See [`GetJob`](crate::client::fluent_builders::GetJob) for more information about the
    /// operation and its arguments.
    pub fn get_job(&self) -> fluent_builders::GetJob<C, M, R> {
        fluent_builders::GetJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetJobTemplate` operation.
    ///
    /// See [`GetJobTemplate`](crate::client::fluent_builders::GetJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn get_job_template(&self) -> fluent_builders::GetJobTemplate<C, M, R> {
        fluent_builders::GetJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPolicy` operation.
    ///
    /// See [`GetPolicy`](crate::client::fluent_builders::GetPolicy) for more information about the
    /// operation and its arguments.
    pub fn get_policy(&self) -> fluent_builders::GetPolicy<C, M, R> {
        fluent_builders::GetPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetPreset` operation.
    ///
    /// See [`GetPreset`](crate::client::fluent_builders::GetPreset) for more information about the
    /// operation and its arguments.
    pub fn get_preset(&self) -> fluent_builders::GetPreset<C, M, R> {
        fluent_builders::GetPreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetQueue` operation.
    ///
    /// See [`GetQueue`](crate::client::fluent_builders::GetQueue) for more information about the
    /// operation and its arguments.
    pub fn get_queue(&self) -> fluent_builders::GetQueue<C, M, R> {
        fluent_builders::GetQueue::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobs` operation.
    ///
    /// See [`ListJobs`](crate::client::fluent_builders::ListJobs) for more information about the
    /// operation and its arguments.
    pub fn list_jobs(&self) -> fluent_builders::ListJobs<C, M, R> {
        fluent_builders::ListJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListJobTemplates` operation.
    ///
    /// See [`ListJobTemplates`](crate::client::fluent_builders::ListJobTemplates) for more information about the
    /// operation and its arguments.
    pub fn list_job_templates(&self) -> fluent_builders::ListJobTemplates<C, M, R> {
        fluent_builders::ListJobTemplates::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListPresets` operation.
    ///
    /// See [`ListPresets`](crate::client::fluent_builders::ListPresets) for more information about the
    /// operation and its arguments.
    pub fn list_presets(&self) -> fluent_builders::ListPresets<C, M, R> {
        fluent_builders::ListPresets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListQueues` operation.
    ///
    /// See [`ListQueues`](crate::client::fluent_builders::ListQueues) for more information about the
    /// operation and its arguments.
    pub fn list_queues(&self) -> fluent_builders::ListQueues<C, M, R> {
        fluent_builders::ListQueues::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutPolicy` operation.
    ///
    /// See [`PutPolicy`](crate::client::fluent_builders::PutPolicy) for more information about the
    /// operation and its arguments.
    pub fn put_policy(&self) -> fluent_builders::PutPolicy<C, M, R> {
        fluent_builders::PutPolicy::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateJobTemplate` operation.
    ///
    /// See [`UpdateJobTemplate`](crate::client::fluent_builders::UpdateJobTemplate) for more information about the
    /// operation and its arguments.
    pub fn update_job_template(&self) -> fluent_builders::UpdateJobTemplate<C, M, R> {
        fluent_builders::UpdateJobTemplate::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdatePreset` operation.
    ///
    /// See [`UpdatePreset`](crate::client::fluent_builders::UpdatePreset) for more information about the
    /// operation and its arguments.
    pub fn update_preset(&self) -> fluent_builders::UpdatePreset<C, M, R> {
        fluent_builders::UpdatePreset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateQueue` operation.
    ///
    /// See [`UpdateQueue`](crate::client::fluent_builders::UpdateQueue) for more information about the
    /// operation and its arguments.
    pub fn update_queue(&self) -> fluent_builders::UpdateQueue<C, M, R> {
        fluent_builders::UpdateQueue::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateCertificate`.
    ///
    /// Associates an AWS Certificate Manager (ACM) Amazon Resource Name (ARN) with AWS Elemental MediaConvert.
    #[derive(std::fmt::Debug)]
    pub struct AssociateCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::associate_certificate_input::Builder,
    }
    impl<C, M, R> AssociateCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AssociateCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AssociateCertificateInputOperationOutputAlias,
                crate::output::AssociateCertificateOutput,
                crate::error::AssociateCertificateError,
                crate::input::AssociateCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the ACM certificate that you want to associate with your MediaConvert resource.
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// The ARN of the ACM certificate that you want to associate with your MediaConvert resource.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CancelJob`.
    ///
    /// Permanently cancel a job. Once you have canceled a job, you can't start it again.
    #[derive(std::fmt::Debug)]
    pub struct CancelJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_job_input::Builder,
    }
    impl<C, M, R> CancelJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelJobInputOperationOutputAlias,
                crate::output::CancelJobOutput,
                crate::error::CancelJobError,
                crate::input::CancelJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Job ID of the job to be cancelled.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// The Job ID of the job to be cancelled.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJob`.
    ///
    /// Create a new transcoding job. For information about jobs and job settings, see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    #[derive(std::fmt::Debug)]
    pub struct CreateJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_input::Builder,
    }
    impl<C, M, R> CreateJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobInputOperationOutputAlias,
                crate::output::CreateJobOutput,
                crate::error::CreateJobError,
                crate::input::CreateJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
        pub fn acceleration_settings(mut self, inp: crate::model::AccelerationSettings) -> Self {
            self.inner = self.inner.acceleration_settings(inp);
            self
        }
        /// Optional. Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
        pub fn set_acceleration_settings(
            mut self,
            input: std::option::Option<crate::model::AccelerationSettings>,
        ) -> Self {
            self.inner = self.inner.set_acceleration_settings(input);
            self
        }
        /// Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will appear on the billing report unsorted.
        pub fn billing_tags_source(mut self, inp: crate::model::BillingTagsSource) -> Self {
            self.inner = self.inner.billing_tags_source(inp);
            self
        }
        /// Optional. Choose a tag type that AWS Billing and Cost Management will use to sort your AWS Elemental MediaConvert costs on any billing report that you set up. Any transcoding outputs that don't have an associated tag will appear in your billing report unsorted. If you don't choose a valid value for this field, your job outputs will appear on the billing report unsorted.
        pub fn set_billing_tags_source(
            mut self,
            input: std::option::Option<crate::model::BillingTagsSource>,
        ) -> Self {
            self.inner = self.inner.set_billing_tags_source(input);
            self
        }
        /// Optional. Idempotency token for CreateJob operation.
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// Optional. Idempotency token for CreateJob operation.
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// Appends an item to `HopDestinations`.
        ///
        /// To override the contents of this collection use [`set_hop_destinations`](Self::set_hop_destinations).
        ///
        /// Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
        pub fn hop_destinations(mut self, inp: impl Into<crate::model::HopDestination>) -> Self {
            self.inner = self.inner.hop_destinations(inp);
            self
        }
        /// Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
        pub fn set_hop_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HopDestination>>,
        ) -> Self {
            self.inner = self.inner.set_hop_destinations(input);
            self
        }
        /// Optional. When you create a job, you can either specify a job template or specify the transcoding settings individually.
        pub fn job_template(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_template(inp);
            self
        }
        /// Optional. When you create a job, you can either specify a job template or specify the transcoding settings individually.
        pub fn set_job_template(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_template(input);
            self
        }
        /// Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// Optional. Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
        pub fn queue(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue(inp);
            self
        }
        /// Optional. When you create a job, you can specify a queue to send it to. If you don't specify, the job will go to the default queue. For more about queues, see the User Guide topic at https://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html.
        pub fn set_queue(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue(input);
            self
        }
        /// Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
        pub fn role(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role(inp);
            self
        }
        /// Required. The IAM role you use for creating this job. For details about permissions, see the User Guide topic at the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/iam-role.html.
        pub fn set_role(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role(input);
            self
        }
        /// JobSettings contains all the transcode settings for a job.
        pub fn settings(mut self, inp: crate::model::JobSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// JobSettings contains all the transcode settings for a job.
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::JobSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
        pub fn simulate_reserved_queue(mut self, inp: crate::model::SimulateReservedQueue) -> Self {
            self.inner = self.inner.simulate_reserved_queue(inp);
            self
        }
        /// Optional. Enable this setting when you run a test job to estimate how many reserved transcoding slots (RTS) you need. When this is enabled, MediaConvert runs your job from an on-demand queue with similar performance to what you will see with one RTS in a reserved queue. This setting is disabled by default.
        pub fn set_simulate_reserved_queue(
            mut self,
            input: std::option::Option<crate::model::SimulateReservedQueue>,
        ) -> Self {
            self.inner = self.inner.set_simulate_reserved_queue(input);
            self
        }
        /// Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
        pub fn status_update_interval(mut self, inp: crate::model::StatusUpdateInterval) -> Self {
            self.inner = self.inner.status_update_interval(inp);
            self
        }
        /// Optional. Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
        pub fn set_status_update_interval(
            mut self,
            input: std::option::Option<crate::model::StatusUpdateInterval>,
        ) -> Self {
            self.inner = self.inner.set_status_update_interval(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.  Use standard AWS tags on your job for automatic integration with AWS services and for custom integrations and workflows.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// Optional. The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.  Use standard AWS tags on your job for automatic integration with AWS services and for custom integrations and workflows.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// Adds a key-value pair to `UserMetadata`.
        ///
        /// To override the contents of this collection use [`set_user_metadata`](Self::set_user_metadata).
        ///
        /// Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.  Use only for existing integrations or workflows that rely on job metadata tags. Otherwise, we recommend that you use standard AWS tags.
        pub fn user_metadata(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.user_metadata(k, v);
            self
        }
        /// Optional. User-defined metadata that you want to associate with an MediaConvert job. You specify metadata in key/value pairs.  Use only for existing integrations or workflows that rely on job metadata tags. Otherwise, we recommend that you use standard AWS tags.
        pub fn set_user_metadata(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_user_metadata(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateJobTemplate`.
    ///
    /// Create a new job template. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    #[derive(std::fmt::Debug)]
    pub struct CreateJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_job_template_input::Builder,
    }
    impl<C, M, R> CreateJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateJobTemplateInputOperationOutputAlias,
                crate::output::CreateJobTemplateOutput,
                crate::error::CreateJobTemplateError,
                crate::input::CreateJobTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
        pub fn acceleration_settings(mut self, inp: crate::model::AccelerationSettings) -> Self {
            self.inner = self.inner.acceleration_settings(inp);
            self
        }
        /// Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
        pub fn set_acceleration_settings(
            mut self,
            input: std::option::Option<crate::model::AccelerationSettings>,
        ) -> Self {
            self.inner = self.inner.set_acceleration_settings(input);
            self
        }
        /// Optional. A category for the job template you are creating
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// Optional. A category for the job template you are creating
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// Optional. A description of the job template you are creating.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// Optional. A description of the job template you are creating.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `HopDestinations`.
        ///
        /// To override the contents of this collection use [`set_hop_destinations`](Self::set_hop_destinations).
        ///
        /// Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
        pub fn hop_destinations(mut self, inp: impl Into<crate::model::HopDestination>) -> Self {
            self.inner = self.inner.hop_destinations(inp);
            self
        }
        /// Optional. Use queue hopping to avoid overly long waits in the backlog of the queue that you submit your job to. Specify an alternate queue and the maximum time that your job will wait in the initial queue before hopping. For more information about this feature, see the AWS Elemental MediaConvert User Guide.
        pub fn set_hop_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HopDestination>>,
        ) -> Self {
            self.inner = self.inner.set_hop_destinations(input);
            self
        }
        /// The name of the job template you are creating.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the job template you are creating.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue.
        pub fn queue(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue(inp);
            self
        }
        /// Optional. The queue that jobs created from this template are assigned to. If you don't specify this, jobs will go to the default queue.
        pub fn set_queue(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue(input);
            self
        }
        /// JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
        pub fn settings(mut self, inp: crate::model::JobTemplateSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::JobTemplateSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
        pub fn status_update_interval(mut self, inp: crate::model::StatusUpdateInterval) -> Self {
            self.inner = self.inner.status_update_interval(inp);
            self
        }
        /// Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
        pub fn set_status_update_interval(
            mut self,
            input: std::option::Option<crate::model::StatusUpdateInterval>,
        ) -> Self {
            self.inner = self.inner.set_status_update_interval(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreatePreset`.
    ///
    /// Create a new preset. For information about job templates see the User Guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    #[derive(std::fmt::Debug)]
    pub struct CreatePreset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_preset_input::Builder,
    }
    impl<C, M, R> CreatePreset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreatePreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreatePresetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreatePresetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreatePresetInputOperationOutputAlias,
                crate::output::CreatePresetOutput,
                crate::error::CreatePresetError,
                crate::input::CreatePresetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optional. A category for the preset you are creating.
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// Optional. A category for the preset you are creating.
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// Optional. A description of the preset you are creating.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// Optional. A description of the preset you are creating.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The name of the preset you are creating.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the preset you are creating.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Settings for preset
        pub fn settings(mut self, inp: crate::model::PresetSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// Settings for preset
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::PresetSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateQueue`.
    ///
    /// Create a new transcoding queue. For information about queues, see Working With Queues in the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/working-with-queues.html
    #[derive(std::fmt::Debug)]
    pub struct CreateQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_queue_input::Builder,
    }
    impl<C, M, R> CreateQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateQueueInputOperationOutputAlias,
                crate::output::CreateQueueOutput,
                crate::error::CreateQueueError,
                crate::input::CreateQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optional. A description of the queue that you are creating.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// Optional. A description of the queue that you are creating.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The name of the queue that you are creating.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the queue that you are creating.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use the API to create a queue, the default is on-demand.
        pub fn pricing_plan(mut self, inp: crate::model::PricingPlan) -> Self {
            self.inner = self.inner.pricing_plan(inp);
            self
        }
        /// Specifies whether the pricing plan for the queue is on-demand or reserved. For on-demand, you pay per minute, billed in increments of .01 minute. For reserved, you pay for the transcoding capacity of the entire queue, regardless of how much or how little you use it. Reserved pricing requires a 12-month commitment. When you use the API to create a queue, the default is on-demand.
        pub fn set_pricing_plan(
            mut self,
            input: std::option::Option<crate::model::PricingPlan>,
        ) -> Self {
            self.inner = self.inner.set_pricing_plan(input);
            self
        }
        /// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
        pub fn reservation_plan_settings(
            mut self,
            inp: crate::model::ReservationPlanSettings,
        ) -> Self {
            self.inner = self.inner.reservation_plan_settings(inp);
            self
        }
        /// Details about the pricing plan for your reserved queue. Required for reserved queues and not applicable to on-demand queues.
        pub fn set_reservation_plan_settings(
            mut self,
            input: std::option::Option<crate::model::ReservationPlanSettings>,
        ) -> Self {
            self.inner = self.inner.set_reservation_plan_settings(input);
            self
        }
        /// Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
        pub fn status(mut self, inp: crate::model::QueueStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// Initial state of the queue. If you create a paused queue, then jobs in that queue won't begin.
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueueStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteJobTemplate`.
    ///
    /// Permanently delete a job template you have created.
    #[derive(std::fmt::Debug)]
    pub struct DeleteJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_job_template_input::Builder,
    }
    impl<C, M, R> DeleteJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteJobTemplateInputOperationOutputAlias,
                crate::output::DeleteJobTemplateOutput,
                crate::error::DeleteJobTemplateError,
                crate::input::DeleteJobTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the job template to be deleted.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the job template to be deleted.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeletePolicy`.
    ///
    /// Permanently delete a policy that you created.
    #[derive(std::fmt::Debug)]
    pub struct DeletePolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_policy_input::Builder,
    }
    impl<C, M, R> DeletePolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePolicyInputOperationOutputAlias,
                crate::output::DeletePolicyOutput,
                crate::error::DeletePolicyError,
                crate::input::DeletePolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DeletePreset`.
    ///
    /// Permanently delete a preset you have created.
    #[derive(std::fmt::Debug)]
    pub struct DeletePreset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_preset_input::Builder,
    }
    impl<C, M, R> DeletePreset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeletePreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeletePresetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeletePresetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeletePresetInputOperationOutputAlias,
                crate::output::DeletePresetOutput,
                crate::error::DeletePresetError,
                crate::input::DeletePresetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the preset to be deleted.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the preset to be deleted.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteQueue`.
    ///
    /// Permanently delete a queue you have created.
    #[derive(std::fmt::Debug)]
    pub struct DeleteQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_queue_input::Builder,
    }
    impl<C, M, R> DeleteQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteQueueInputOperationOutputAlias,
                crate::output::DeleteQueueOutput,
                crate::error::DeleteQueueError,
                crate::input::DeleteQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the queue that you want to delete.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the queue that you want to delete.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEndpoints`.
    ///
    /// Send an request with an empty body to the regional API endpoint to get your account API endpoint.
    #[derive(std::fmt::Debug)]
    pub struct DescribeEndpoints<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_endpoints_input::Builder,
    }
    impl<C, M, R> DescribeEndpoints<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEndpoints`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEndpointsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEndpointsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEndpointsInputOperationOutputAlias,
                crate::output::DescribeEndpointsOutput,
                crate::error::DescribeEndpointsError,
                crate::input::DescribeEndpointsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optional. Max number of endpoints, up to twenty, that will be returned at one time.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Optional. Max number of endpoints, up to twenty, that will be returned at one time.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to return your endpoints if any exist, or an empty list if none exist.
        pub fn mode(mut self, inp: crate::model::DescribeEndpointsMode) -> Self {
            self.inner = self.inner.mode(inp);
            self
        }
        /// Optional field, defaults to DEFAULT. Specify DEFAULT for this operation to return your endpoints if any exist, or to create an endpoint for you and return it if one doesn't already exist. Specify GET_ONLY to return your endpoints if any exist, or an empty list if none exist.
        pub fn set_mode(
            mut self,
            input: std::option::Option<crate::model::DescribeEndpointsMode>,
        ) -> Self {
            self.inner = self.inner.set_mode(input);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of endpoints.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of endpoints.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateCertificate`.
    ///
    /// Removes an association between the Amazon Resource Name (ARN) of an AWS Certificate Manager (ACM) certificate and an AWS Elemental MediaConvert resource.
    #[derive(std::fmt::Debug)]
    pub struct DisassociateCertificate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_certificate_input::Builder,
    }
    impl<C, M, R> DisassociateCertificate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateCertificate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateCertificateOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateCertificateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateCertificateInputOperationOutputAlias,
                crate::output::DisassociateCertificateOutput,
                crate::error::DisassociateCertificateError,
                crate::input::DisassociateCertificateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the ACM certificate that you want to disassociate from your MediaConvert resource.
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// The ARN of the ACM certificate that you want to disassociate from your MediaConvert resource.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJob`.
    ///
    /// Retrieve the JSON for a specific completed transcoding job.
    #[derive(std::fmt::Debug)]
    pub struct GetJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_input::Builder,
    }
    impl<C, M, R> GetJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobInputOperationOutputAlias,
                crate::output::GetJobOutput,
                crate::error::GetJobError,
                crate::input::GetJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// the job ID of the job.
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// the job ID of the job.
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetJobTemplate`.
    ///
    /// Retrieve the JSON for a specific job template.
    #[derive(std::fmt::Debug)]
    pub struct GetJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_job_template_input::Builder,
    }
    impl<C, M, R> GetJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::GetJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetJobTemplateInputOperationOutputAlias,
                crate::output::GetJobTemplateOutput,
                crate::error::GetJobTemplateError,
                crate::input::GetJobTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the job template.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the job template.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetPolicy`.
    ///
    /// Retrieve the JSON for your policy.
    #[derive(std::fmt::Debug)]
    pub struct GetPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_policy_input::Builder,
    }
    impl<C, M, R> GetPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPolicyInputOperationOutputAlias,
                crate::output::GetPolicyOutput,
                crate::error::GetPolicyError,
                crate::input::GetPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetPreset`.
    ///
    /// Retrieve the JSON for a specific preset.
    #[derive(std::fmt::Debug)]
    pub struct GetPreset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_preset_input::Builder,
    }
    impl<C, M, R> GetPreset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetPreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetPresetOutput,
            aws_smithy_http::result::SdkError<crate::error::GetPresetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetPresetInputOperationOutputAlias,
                crate::output::GetPresetOutput,
                crate::error::GetPresetError,
                crate::input::GetPresetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the preset.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the preset.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetQueue`.
    ///
    /// Retrieve the JSON for a specific queue.
    #[derive(std::fmt::Debug)]
    pub struct GetQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_queue_input::Builder,
    }
    impl<C, M, R> GetQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::GetQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetQueueInputOperationOutputAlias,
                crate::output::GetQueueOutput,
                crate::error::GetQueueError,
                crate::input::GetQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The name of the queue that you want information about.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the queue that you want information about.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobs`.
    ///
    /// Retrieve a JSON array of up to twenty of your most recently created jobs. This array includes in-process, completed, and errored jobs. This will return the jobs themselves, not just a list of the jobs. To retrieve the twenty next most recent jobs, use the nextToken string returned with the array.
    #[derive(std::fmt::Debug)]
    pub struct ListJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_jobs_input::Builder,
    }
    impl<C, M, R> ListJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobsInputOperationOutputAlias,
                crate::output::ListJobsOutput,
                crate::error::ListJobsError,
                crate::input::ListJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optional. Number of jobs, up to twenty, that will be returned at one time.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Optional. Number of jobs, up to twenty, that will be returned at one time.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Optional. Use this string, provided with the response to a previous request, to request the next batch of jobs.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Optional. Use this string, provided with the response to a previous request, to request the next batch of jobs.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn order(mut self, inp: crate::model::Order) -> Self {
            self.inner = self.inner.order(inp);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn set_order(mut self, input: std::option::Option<crate::model::Order>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
        /// Optional. Provide a queue name to get back only jobs from that queue.
        pub fn queue(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue(inp);
            self
        }
        /// Optional. Provide a queue name to get back only jobs from that queue.
        pub fn set_queue(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue(input);
            self
        }
        /// Optional. A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
        pub fn status(mut self, inp: crate::model::JobStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// Optional. A job's status can be SUBMITTED, PROGRESSING, COMPLETE, CANCELED, or ERROR.
        pub fn set_status(mut self, input: std::option::Option<crate::model::JobStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListJobTemplates`.
    ///
    /// Retrieve a JSON array of up to twenty of your job templates. This will return the templates themselves, not just a list of them. To retrieve the next twenty templates, use the nextToken string returned with the array
    #[derive(std::fmt::Debug)]
    pub struct ListJobTemplates<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_job_templates_input::Builder,
    }
    impl<C, M, R> ListJobTemplates<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListJobTemplates`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListJobTemplatesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListJobTemplatesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListJobTemplatesInputOperationOutputAlias,
                crate::output::ListJobTemplatesOutput,
                crate::error::ListJobTemplatesError,
                crate::input::ListJobTemplatesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optionally, specify a job template category to limit responses to only job templates from that category.
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// Optionally, specify a job template category to limit responses to only job templates from that category.
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
        pub fn list_by(mut self, inp: crate::model::JobTemplateListBy) -> Self {
            self.inner = self.inner.list_by(inp);
            self
        }
        /// Optional. When you request a list of job templates, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
        pub fn set_list_by(
            mut self,
            input: std::option::Option<crate::model::JobTemplateListBy>,
        ) -> Self {
            self.inner = self.inner.set_list_by(input);
            self
        }
        /// Optional. Number of job templates, up to twenty, that will be returned at one time.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Optional. Number of job templates, up to twenty, that will be returned at one time.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of job templates.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of job templates.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn order(mut self, inp: crate::model::Order) -> Self {
            self.inner = self.inner.order(inp);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn set_order(mut self, input: std::option::Option<crate::model::Order>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListPresets`.
    ///
    /// Retrieve a JSON array of up to twenty of your presets. This will return the presets themselves, not just a list of them. To retrieve the next twenty presets, use the nextToken string returned with the array.
    #[derive(std::fmt::Debug)]
    pub struct ListPresets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_presets_input::Builder,
    }
    impl<C, M, R> ListPresets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListPresets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListPresetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListPresetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListPresetsInputOperationOutputAlias,
                crate::output::ListPresetsOutput,
                crate::error::ListPresetsError,
                crate::input::ListPresetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optionally, specify a preset category to limit responses to only presets from that category.
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// Optionally, specify a preset category to limit responses to only presets from that category.
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// Optional. When you request a list of presets, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
        pub fn list_by(mut self, inp: crate::model::PresetListBy) -> Self {
            self.inner = self.inner.list_by(inp);
            self
        }
        /// Optional. When you request a list of presets, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by name.
        pub fn set_list_by(
            mut self,
            input: std::option::Option<crate::model::PresetListBy>,
        ) -> Self {
            self.inner = self.inner.set_list_by(input);
            self
        }
        /// Optional. Number of presets, up to twenty, that will be returned at one time
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Optional. Number of presets, up to twenty, that will be returned at one time
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of presets.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of presets.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn order(mut self, inp: crate::model::Order) -> Self {
            self.inner = self.inner.order(inp);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn set_order(mut self, input: std::option::Option<crate::model::Order>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListQueues`.
    ///
    /// Retrieve a JSON array of up to twenty of your queues. This will return the queues themselves, not just a list of them. To retrieve the next twenty queues, use the nextToken string returned with the array.
    #[derive(std::fmt::Debug)]
    pub struct ListQueues<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_queues_input::Builder,
    }
    impl<C, M, R> ListQueues<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListQueues`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListQueuesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListQueuesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListQueuesInputOperationOutputAlias,
                crate::output::ListQueuesOutput,
                crate::error::ListQueuesError,
                crate::input::ListQueuesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
        pub fn list_by(mut self, inp: crate::model::QueueListBy) -> Self {
            self.inner = self.inner.list_by(inp);
            self
        }
        /// Optional. When you request a list of queues, you can choose to list them alphabetically by NAME or chronologically by CREATION_DATE. If you don't specify, the service will list them by creation date.
        pub fn set_list_by(
            mut self,
            input: std::option::Option<crate::model::QueueListBy>,
        ) -> Self {
            self.inner = self.inner.set_list_by(input);
            self
        }
        /// Optional. Number of queues, up to twenty, that will be returned at one time.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// Optional. Number of queues, up to twenty, that will be returned at one time.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of queues.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// Use this string, provided with the response to a previous request, to request the next batch of queues.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn order(mut self, inp: crate::model::Order) -> Self {
            self.inner = self.inner.order(inp);
            self
        }
        /// Optional. When you request lists of resources, you can specify whether they are sorted in ASCENDING or DESCENDING order. Default varies by resource.
        pub fn set_order(mut self, input: std::option::Option<crate::model::Order>) -> Self {
            self.inner = self.inner.set_order(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// Retrieve the tags for a MediaConvert resource.
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the resource that you want to list tags for. To get the ARN, send a GET request with the resource name.
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the resource that you want to list tags for. To get the ARN, send a GET request with the resource name.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutPolicy`.
    ///
    /// Create or change your policy. For more information about policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
    #[derive(std::fmt::Debug)]
    pub struct PutPolicy<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_policy_input::Builder,
    }
    impl<C, M, R> PutPolicy<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutPolicy`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutPolicyOutput,
            aws_smithy_http::result::SdkError<crate::error::PutPolicyError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutPolicyInputOperationOutputAlias,
                crate::output::PutPolicyOutput,
                crate::error::PutPolicyError,
                crate::input::PutPolicyInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn policy(mut self, inp: crate::model::Policy) -> Self {
            self.inner = self.inner.policy(inp);
            self
        }
        /// A policy configures behavior that you allow or disallow for your account. For information about MediaConvert policies, see the user guide at http://docs.aws.amazon.com/mediaconvert/latest/ug/what-is.html
        pub fn set_policy(mut self, input: std::option::Option<crate::model::Policy>) -> Self {
            self.inner = self.inner.set_policy(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Add tags to a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the resource that you want to tag. To get the ARN, send a GET request with the resource name.
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the resource that you want to tag. To get the ARN, send a GET request with the resource name.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// The tags that you want to add to the resource. You can tag resources with a key-value pair or with only a key.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Remove tags from a MediaConvert queue, preset, or job template. For information about tagging, see the User Guide at https://docs.aws.amazon.com/mediaconvert/latest/ug/tagging-resources.html
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the resource that you want to remove tags from. To get the ARN, send a GET request with the resource name.
        pub fn arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the resource that you want to remove tags from. To get the ARN, send a GET request with the resource name.
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The keys of the tags that you want to remove from the resource.
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// The keys of the tags that you want to remove from the resource.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateJobTemplate`.
    ///
    /// Modify one of your existing job templates.
    #[derive(std::fmt::Debug)]
    pub struct UpdateJobTemplate<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_job_template_input::Builder,
    }
    impl<C, M, R> UpdateJobTemplate<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateJobTemplate`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateJobTemplateOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateJobTemplateError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateJobTemplateInputOperationOutputAlias,
                crate::output::UpdateJobTemplateOutput,
                crate::error::UpdateJobTemplateError,
                crate::input::UpdateJobTemplateInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
        pub fn acceleration_settings(mut self, inp: crate::model::AccelerationSettings) -> Self {
            self.inner = self.inner.acceleration_settings(inp);
            self
        }
        /// Accelerated transcoding can significantly speed up jobs with long, visually complex content. Outputs that use this feature incur pro-tier pricing. For information about feature limitations, see the AWS Elemental MediaConvert User Guide.
        pub fn set_acceleration_settings(
            mut self,
            input: std::option::Option<crate::model::AccelerationSettings>,
        ) -> Self {
            self.inner = self.inner.set_acceleration_settings(input);
            self
        }
        /// The new category for the job template, if you are changing it.
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// The new category for the job template, if you are changing it.
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// The new description for the job template, if you are changing it.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// The new description for the job template, if you are changing it.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `HopDestinations`.
        ///
        /// To override the contents of this collection use [`set_hop_destinations`](Self::set_hop_destinations).
        ///
        /// Optional list of hop destinations.
        pub fn hop_destinations(mut self, inp: impl Into<crate::model::HopDestination>) -> Self {
            self.inner = self.inner.hop_destinations(inp);
            self
        }
        /// Optional list of hop destinations.
        pub fn set_hop_destinations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::HopDestination>>,
        ) -> Self {
            self.inner = self.inner.set_hop_destinations(input);
            self
        }
        /// The name of the job template you are modifying
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the job template you are modifying
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
        pub fn priority(mut self, inp: i32) -> Self {
            self.inner = self.inner.priority(inp);
            self
        }
        /// Specify the relative priority for this job. In any given queue, the service begins processing the job with the highest value first. When more than one job has the same priority, the service begins processing the job that you submitted first. If you don't specify a priority, the service uses the default value 0.
        pub fn set_priority(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_priority(input);
            self
        }
        /// The new queue for the job template, if you are changing it.
        pub fn queue(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.queue(inp);
            self
        }
        /// The new queue for the job template, if you are changing it.
        pub fn set_queue(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_queue(input);
            self
        }
        /// JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
        pub fn settings(mut self, inp: crate::model::JobTemplateSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// JobTemplateSettings contains all the transcode settings saved in the template that will be applied to jobs created from it.
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::JobTemplateSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
        /// Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
        pub fn status_update_interval(mut self, inp: crate::model::StatusUpdateInterval) -> Self {
            self.inner = self.inner.status_update_interval(inp);
            self
        }
        /// Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds, between status updates. MediaConvert sends an update at this interval from the time the service begins processing your job to the time it completes the transcode or encounters an error.
        pub fn set_status_update_interval(
            mut self,
            input: std::option::Option<crate::model::StatusUpdateInterval>,
        ) -> Self {
            self.inner = self.inner.set_status_update_interval(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdatePreset`.
    ///
    /// Modify one of your existing presets.
    #[derive(std::fmt::Debug)]
    pub struct UpdatePreset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_preset_input::Builder,
    }
    impl<C, M, R> UpdatePreset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdatePreset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdatePresetOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdatePresetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdatePresetInputOperationOutputAlias,
                crate::output::UpdatePresetOutput,
                crate::error::UpdatePresetError,
                crate::input::UpdatePresetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The new category for the preset, if you are changing it.
        pub fn category(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.category(inp);
            self
        }
        /// The new category for the preset, if you are changing it.
        pub fn set_category(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_category(input);
            self
        }
        /// The new description for the preset, if you are changing it.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// The new description for the preset, if you are changing it.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The name of the preset you are modifying.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the preset you are modifying.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Settings for preset
        pub fn settings(mut self, inp: crate::model::PresetSettings) -> Self {
            self.inner = self.inner.settings(inp);
            self
        }
        /// Settings for preset
        pub fn set_settings(
            mut self,
            input: std::option::Option<crate::model::PresetSettings>,
        ) -> Self {
            self.inner = self.inner.set_settings(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateQueue`.
    ///
    /// Modify one of your existing queues.
    #[derive(std::fmt::Debug)]
    pub struct UpdateQueue<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_queue_input::Builder,
    }
    impl<C, M, R> UpdateQueue<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateQueue`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateQueueOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateQueueError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateQueueInputOperationOutputAlias,
                crate::output::UpdateQueueOutput,
                crate::error::UpdateQueueError,
                crate::input::UpdateQueueInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The new description for the queue, if you are changing it.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// The new description for the queue, if you are changing it.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The name of the queue that you are modifying.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the queue that you are modifying.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace an expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing the number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you make these commitments, you can't cancel them.
        pub fn reservation_plan_settings(
            mut self,
            inp: crate::model::ReservationPlanSettings,
        ) -> Self {
            self.inner = self.inner.reservation_plan_settings(inp);
            self
        }
        /// The new details of your pricing plan for your reserved queue. When you set up a new pricing plan to replace an expired one, you enter into another 12-month commitment. When you add capacity to your queue by increasing the number of RTS, you extend the term of your commitment to 12 months from when you add capacity. After you make these commitments, you can't cancel them.
        pub fn set_reservation_plan_settings(
            mut self,
            input: std::option::Option<crate::model::ReservationPlanSettings>,
        ) -> Self {
            self.inner = self.inner.set_reservation_plan_settings(input);
            self
        }
        /// Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
        pub fn status(mut self, inp: crate::model::QueueStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// Pause or activate a queue by changing its status between ACTIVE and PAUSED. If you pause a queue, jobs in that queue won't begin. Jobs that are running when you pause the queue continue to run until they finish or result in an error.
        pub fn set_status(mut self, input: std::option::Option<crate::model::QueueStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
