// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for AWS MediaConnect
///
/// Client for invoking operations on AWS MediaConnect. Each operation on AWS MediaConnect is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_mediaconnect::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_mediaconnect::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_mediaconnect::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddFlowMediaStreams`](crate::client::fluent_builders::AddFlowMediaStreams) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::AddFlowMediaStreams::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::AddFlowMediaStreams::set_flow_arn): The Amazon Resource Name (ARN) of the flow.
    ///   - [`media_streams(Vec<AddMediaStreamRequest>)`](crate::client::fluent_builders::AddFlowMediaStreams::media_streams) / [`set_media_streams(Option<Vec<AddMediaStreamRequest>>)`](crate::client::fluent_builders::AddFlowMediaStreams::set_media_streams): The media streams that you want to add to the flow.
    /// - On success, responds with [`AddFlowMediaStreamsOutput`](crate::output::AddFlowMediaStreamsOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::AddFlowMediaStreamsOutput::flow_arn): The ARN of the flow that you added media streams to.
    ///   - [`media_streams(Option<Vec<MediaStream>>)`](crate::output::AddFlowMediaStreamsOutput::media_streams): The media streams that you added to the flow.
    /// - On failure, responds with [`SdkError<AddFlowMediaStreamsError>`](crate::error::AddFlowMediaStreamsError)
    pub fn add_flow_media_streams(&self) -> fluent_builders::AddFlowMediaStreams {
        fluent_builders::AddFlowMediaStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddFlowOutputs`](crate::client::fluent_builders::AddFlowOutputs) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::AddFlowOutputs::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::AddFlowOutputs::set_flow_arn): The flow that you want to add outputs to.
    ///   - [`outputs(Vec<AddOutputRequest>)`](crate::client::fluent_builders::AddFlowOutputs::outputs) / [`set_outputs(Option<Vec<AddOutputRequest>>)`](crate::client::fluent_builders::AddFlowOutputs::set_outputs): A list of outputs that you want to add.
    /// - On success, responds with [`AddFlowOutputsOutput`](crate::output::AddFlowOutputsOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::AddFlowOutputsOutput::flow_arn): The ARN of the flow that these outputs were added to.
    ///   - [`outputs(Option<Vec<Output>>)`](crate::output::AddFlowOutputsOutput::outputs): The details of the newly added outputs.
    /// - On failure, responds with [`SdkError<AddFlowOutputsError>`](crate::error::AddFlowOutputsError)
    pub fn add_flow_outputs(&self) -> fluent_builders::AddFlowOutputs {
        fluent_builders::AddFlowOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddFlowSources`](crate::client::fluent_builders::AddFlowSources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::AddFlowSources::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::AddFlowSources::set_flow_arn): The flow that you want to mutate.
    ///   - [`sources(Vec<SetSourceRequest>)`](crate::client::fluent_builders::AddFlowSources::sources) / [`set_sources(Option<Vec<SetSourceRequest>>)`](crate::client::fluent_builders::AddFlowSources::set_sources): A list of sources that you want to add.
    /// - On success, responds with [`AddFlowSourcesOutput`](crate::output::AddFlowSourcesOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::AddFlowSourcesOutput::flow_arn): The ARN of the flow that these sources were added to.
    ///   - [`sources(Option<Vec<Source>>)`](crate::output::AddFlowSourcesOutput::sources): The details of the newly added sources.
    /// - On failure, responds with [`SdkError<AddFlowSourcesError>`](crate::error::AddFlowSourcesError)
    pub fn add_flow_sources(&self) -> fluent_builders::AddFlowSources {
        fluent_builders::AddFlowSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AddFlowVpcInterfaces`](crate::client::fluent_builders::AddFlowVpcInterfaces) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::AddFlowVpcInterfaces::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::AddFlowVpcInterfaces::set_flow_arn): The flow that you want to mutate.
    ///   - [`vpc_interfaces(Vec<VpcInterfaceRequest>)`](crate::client::fluent_builders::AddFlowVpcInterfaces::vpc_interfaces) / [`set_vpc_interfaces(Option<Vec<VpcInterfaceRequest>>)`](crate::client::fluent_builders::AddFlowVpcInterfaces::set_vpc_interfaces): A list of VPC interfaces that you want to add.
    /// - On success, responds with [`AddFlowVpcInterfacesOutput`](crate::output::AddFlowVpcInterfacesOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::AddFlowVpcInterfacesOutput::flow_arn): The ARN of the flow that these VPC interfaces were added to.
    ///   - [`vpc_interfaces(Option<Vec<VpcInterface>>)`](crate::output::AddFlowVpcInterfacesOutput::vpc_interfaces): The details of the newly added VPC interfaces.
    /// - On failure, responds with [`SdkError<AddFlowVpcInterfacesError>`](crate::error::AddFlowVpcInterfacesError)
    pub fn add_flow_vpc_interfaces(&self) -> fluent_builders::AddFlowVpcInterfaces {
        fluent_builders::AddFlowVpcInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFlow`](crate::client::fluent_builders::CreateFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`availability_zone(impl Into<String>)`](crate::client::fluent_builders::CreateFlow::availability_zone) / [`set_availability_zone(Option<String>)`](crate::client::fluent_builders::CreateFlow::set_availability_zone): The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
    ///   - [`entitlements(Vec<GrantEntitlementRequest>)`](crate::client::fluent_builders::CreateFlow::entitlements) / [`set_entitlements(Option<Vec<GrantEntitlementRequest>>)`](crate::client::fluent_builders::CreateFlow::set_entitlements): The entitlements that you want to grant on a flow.
    ///   - [`media_streams(Vec<AddMediaStreamRequest>)`](crate::client::fluent_builders::CreateFlow::media_streams) / [`set_media_streams(Option<Vec<AddMediaStreamRequest>>)`](crate::client::fluent_builders::CreateFlow::set_media_streams): The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFlow::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFlow::set_name): The name of the flow.
    ///   - [`outputs(Vec<AddOutputRequest>)`](crate::client::fluent_builders::CreateFlow::outputs) / [`set_outputs(Option<Vec<AddOutputRequest>>)`](crate::client::fluent_builders::CreateFlow::set_outputs): The outputs that you want to add to this flow.
    ///   - [`source(SetSourceRequest)`](crate::client::fluent_builders::CreateFlow::source) / [`set_source(Option<SetSourceRequest>)`](crate::client::fluent_builders::CreateFlow::set_source): The settings for the source of the flow.
    ///   - [`source_failover_config(FailoverConfig)`](crate::client::fluent_builders::CreateFlow::source_failover_config) / [`set_source_failover_config(Option<FailoverConfig>)`](crate::client::fluent_builders::CreateFlow::set_source_failover_config): The settings for source failover.
    ///   - [`sources(Vec<SetSourceRequest>)`](crate::client::fluent_builders::CreateFlow::sources) / [`set_sources(Option<Vec<SetSourceRequest>>)`](crate::client::fluent_builders::CreateFlow::set_sources): (undocumented)
    ///   - [`vpc_interfaces(Vec<VpcInterfaceRequest>)`](crate::client::fluent_builders::CreateFlow::vpc_interfaces) / [`set_vpc_interfaces(Option<Vec<VpcInterfaceRequest>>)`](crate::client::fluent_builders::CreateFlow::set_vpc_interfaces): The VPC interfaces you want on the flow.
    /// - On success, responds with [`CreateFlowOutput`](crate::output::CreateFlowOutput) with field(s):
    ///   - [`flow(Option<Flow>)`](crate::output::CreateFlowOutput::flow): The settings for a flow, including its source, outputs, and entitlements.
    /// - On failure, responds with [`SdkError<CreateFlowError>`](crate::error::CreateFlowError)
    pub fn create_flow(&self) -> fluent_builders::CreateFlow {
        fluent_builders::CreateFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFlow`](crate::client::fluent_builders::DeleteFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::DeleteFlow::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::DeleteFlow::set_flow_arn): The ARN of the flow that you want to delete.
    /// - On success, responds with [`DeleteFlowOutput`](crate::output::DeleteFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::DeleteFlowOutput::flow_arn): The ARN of the flow that was deleted.
    ///   - [`status(Option<Status>)`](crate::output::DeleteFlowOutput::status): The status of the flow when the DeleteFlow process begins.
    /// - On failure, responds with [`SdkError<DeleteFlowError>`](crate::error::DeleteFlowError)
    pub fn delete_flow(&self) -> fluent_builders::DeleteFlow {
        fluent_builders::DeleteFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeFlow`](crate::client::fluent_builders::DescribeFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeFlow::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::DescribeFlow::set_flow_arn): The ARN of the flow that you want to describe.
    /// - On success, responds with [`DescribeFlowOutput`](crate::output::DescribeFlowOutput) with field(s):
    ///   - [`flow(Option<Flow>)`](crate::output::DescribeFlowOutput::flow): The settings for a flow, including its source, outputs, and entitlements.
    ///   - [`messages(Option<Messages>)`](crate::output::DescribeFlowOutput::messages): Messages that provide the state of the flow.
    /// - On failure, responds with [`SdkError<DescribeFlowError>`](crate::error::DescribeFlowError)
    pub fn describe_flow(&self) -> fluent_builders::DescribeFlow {
        fluent_builders::DescribeFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOffering`](crate::client::fluent_builders::DescribeOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`offering_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeOffering::offering_arn) / [`set_offering_arn(Option<String>)`](crate::client::fluent_builders::DescribeOffering::set_offering_arn): The Amazon Resource Name (ARN) of the offering.
    /// - On success, responds with [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput) with field(s):
    ///   - [`offering(Option<Offering>)`](crate::output::DescribeOfferingOutput::offering): A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
    /// - On failure, responds with [`SdkError<DescribeOfferingError>`](crate::error::DescribeOfferingError)
    pub fn describe_offering(&self) -> fluent_builders::DescribeOffering {
        fluent_builders::DescribeOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeReservation`](crate::client::fluent_builders::DescribeReservation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`reservation_arn(impl Into<String>)`](crate::client::fluent_builders::DescribeReservation::reservation_arn) / [`set_reservation_arn(Option<String>)`](crate::client::fluent_builders::DescribeReservation::set_reservation_arn): The Amazon Resource Name (ARN) of the reservation.
    /// - On success, responds with [`DescribeReservationOutput`](crate::output::DescribeReservationOutput) with field(s):
    ///   - [`reservation(Option<Reservation>)`](crate::output::DescribeReservationOutput::reservation): A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
    /// - On failure, responds with [`SdkError<DescribeReservationError>`](crate::error::DescribeReservationError)
    pub fn describe_reservation(&self) -> fluent_builders::DescribeReservation {
        fluent_builders::DescribeReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GrantFlowEntitlements`](crate::client::fluent_builders::GrantFlowEntitlements) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entitlements(Vec<GrantEntitlementRequest>)`](crate::client::fluent_builders::GrantFlowEntitlements::entitlements) / [`set_entitlements(Option<Vec<GrantEntitlementRequest>>)`](crate::client::fluent_builders::GrantFlowEntitlements::set_entitlements): The list of entitlements that you want to grant.
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::GrantFlowEntitlements::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::GrantFlowEntitlements::set_flow_arn): The flow that you want to grant entitlements on.
    /// - On success, responds with [`GrantFlowEntitlementsOutput`](crate::output::GrantFlowEntitlementsOutput) with field(s):
    ///   - [`entitlements(Option<Vec<Entitlement>>)`](crate::output::GrantFlowEntitlementsOutput::entitlements): The entitlements that were just granted.
    ///   - [`flow_arn(Option<String>)`](crate::output::GrantFlowEntitlementsOutput::flow_arn): The ARN of the flow that these entitlements were granted to.
    /// - On failure, responds with [`SdkError<GrantFlowEntitlementsError>`](crate::error::GrantFlowEntitlementsError)
    pub fn grant_flow_entitlements(&self) -> fluent_builders::GrantFlowEntitlements {
        fluent_builders::GrantFlowEntitlements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListEntitlements`](crate::client::fluent_builders::ListEntitlements) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListEntitlements::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListEntitlements::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListEntitlements::set_max_results): The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListEntitlements::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListEntitlements::set_next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
    /// - On success, responds with [`ListEntitlementsOutput`](crate::output::ListEntitlementsOutput) with field(s):
    ///   - [`entitlements(Option<Vec<ListedEntitlement>>)`](crate::output::ListEntitlementsOutput::entitlements): A list of entitlements that have been granted to you from other AWS accounts.
    ///   - [`next_token(Option<String>)`](crate::output::ListEntitlementsOutput::next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
    /// - On failure, responds with [`SdkError<ListEntitlementsError>`](crate::error::ListEntitlementsError)
    pub fn list_entitlements(&self) -> fluent_builders::ListEntitlements {
        fluent_builders::ListEntitlements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFlows`](crate::client::fluent_builders::ListFlows) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFlows::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFlows::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListFlows::set_max_results): The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFlows::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFlows::set_next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
    /// - On success, responds with [`ListFlowsOutput`](crate::output::ListFlowsOutput) with field(s):
    ///   - [`flows(Option<Vec<ListedFlow>>)`](crate::output::ListFlowsOutput::flows): A list of flow summaries.
    ///   - [`next_token(Option<String>)`](crate::output::ListFlowsOutput::next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
    /// - On failure, responds with [`SdkError<ListFlowsError>`](crate::error::ListFlowsError)
    pub fn list_flows(&self) -> fluent_builders::ListFlows {
        fluent_builders::ListFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOfferings`](crate::client::fluent_builders::ListOfferings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOfferings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOfferings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListOfferings::set_max_results): The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOfferings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOfferings::set_next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    /// - On success, responds with [`ListOfferingsOutput`](crate::output::ListOfferingsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListOfferingsOutput::next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    ///   - [`offerings(Option<Vec<Offering>>)`](crate::output::ListOfferingsOutput::offerings): A list of offerings that are available to this account in the current AWS Region.
    /// - On failure, responds with [`SdkError<ListOfferingsError>`](crate::error::ListOfferingsError)
    pub fn list_offerings(&self) -> fluent_builders::ListOfferings {
        fluent_builders::ListOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListReservations`](crate::client::fluent_builders::ListReservations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListReservations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListReservations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListReservations::set_max_results): The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListReservations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListReservations::set_next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    /// - On success, responds with [`ListReservationsOutput`](crate::output::ListReservationsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::ListReservationsOutput::next_token): The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.
    ///   - [`reservations(Option<Vec<Reservation>>)`](crate::output::ListReservationsOutput::reservations): A list of all reservations that have been purchased by this account in the current AWS Region.
    /// - On failure, responds with [`SdkError<ListReservationsError>`](crate::error::ListReservationsError)
    pub fn list_reservations(&self) -> fluent_builders::ListReservations {
        fluent_builders::ListReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PurchaseOffering`](crate::client::fluent_builders::PurchaseOffering) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`offering_arn(impl Into<String>)`](crate::client::fluent_builders::PurchaseOffering::offering_arn) / [`set_offering_arn(Option<String>)`](crate::client::fluent_builders::PurchaseOffering::set_offering_arn): The Amazon Resource Name (ARN) of the offering.
    ///   - [`reservation_name(impl Into<String>)`](crate::client::fluent_builders::PurchaseOffering::reservation_name) / [`set_reservation_name(Option<String>)`](crate::client::fluent_builders::PurchaseOffering::set_reservation_name): The name that you want to use for the reservation.
    ///   - [`start(impl Into<String>)`](crate::client::fluent_builders::PurchaseOffering::start) / [`set_start(Option<String>)`](crate::client::fluent_builders::PurchaseOffering::set_start): The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
    /// - On success, responds with [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput) with field(s):
    ///   - [`reservation(Option<Reservation>)`](crate::output::PurchaseOfferingOutput::reservation): A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
    /// - On failure, responds with [`SdkError<PurchaseOfferingError>`](crate::error::PurchaseOfferingError)
    pub fn purchase_offering(&self) -> fluent_builders::PurchaseOffering {
        fluent_builders::PurchaseOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveFlowMediaStream`](crate::client::fluent_builders::RemoveFlowMediaStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowMediaStream::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::RemoveFlowMediaStream::set_flow_arn): The Amazon Resource Name (ARN) of the flow.
    ///   - [`media_stream_name(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowMediaStream::media_stream_name) / [`set_media_stream_name(Option<String>)`](crate::client::fluent_builders::RemoveFlowMediaStream::set_media_stream_name): The name of the media stream that you want to remove.
    /// - On success, responds with [`RemoveFlowMediaStreamOutput`](crate::output::RemoveFlowMediaStreamOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::RemoveFlowMediaStreamOutput::flow_arn): The Amazon Resource Name (ARN) of the flow.
    ///   - [`media_stream_name(Option<String>)`](crate::output::RemoveFlowMediaStreamOutput::media_stream_name): The name of the media stream that was removed.
    /// - On failure, responds with [`SdkError<RemoveFlowMediaStreamError>`](crate::error::RemoveFlowMediaStreamError)
    pub fn remove_flow_media_stream(&self) -> fluent_builders::RemoveFlowMediaStream {
        fluent_builders::RemoveFlowMediaStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveFlowOutput`](crate::client::fluent_builders::RemoveFlowOutput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowOutput::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::RemoveFlowOutput::set_flow_arn): The flow that you want to remove an output from.
    ///   - [`output_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowOutput::output_arn) / [`set_output_arn(Option<String>)`](crate::client::fluent_builders::RemoveFlowOutput::set_output_arn): The ARN of the output that you want to remove.
    /// - On success, responds with [`RemoveFlowOutputOutput`](crate::output::RemoveFlowOutputOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::RemoveFlowOutputOutput::flow_arn): The ARN of the flow that is associated with the output you removed.
    ///   - [`output_arn(Option<String>)`](crate::output::RemoveFlowOutputOutput::output_arn): The ARN of the output that was removed.
    /// - On failure, responds with [`SdkError<RemoveFlowOutputError>`](crate::error::RemoveFlowOutputError)
    pub fn remove_flow_output(&self) -> fluent_builders::RemoveFlowOutput {
        fluent_builders::RemoveFlowOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveFlowSource`](crate::client::fluent_builders::RemoveFlowSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowSource::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::RemoveFlowSource::set_flow_arn): The flow that you want to remove a source from.
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowSource::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::RemoveFlowSource::set_source_arn): The ARN of the source that you want to remove.
    /// - On success, responds with [`RemoveFlowSourceOutput`](crate::output::RemoveFlowSourceOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::RemoveFlowSourceOutput::flow_arn): The ARN of the flow that is associated with the source you removed.
    ///   - [`source_arn(Option<String>)`](crate::output::RemoveFlowSourceOutput::source_arn): The ARN of the source that was removed.
    /// - On failure, responds with [`SdkError<RemoveFlowSourceError>`](crate::error::RemoveFlowSourceError)
    pub fn remove_flow_source(&self) -> fluent_builders::RemoveFlowSource {
        fluent_builders::RemoveFlowSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RemoveFlowVpcInterface`](crate::client::fluent_builders::RemoveFlowVpcInterface) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowVpcInterface::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::RemoveFlowVpcInterface::set_flow_arn): The flow that you want to remove a VPC interface from.
    ///   - [`vpc_interface_name(impl Into<String>)`](crate::client::fluent_builders::RemoveFlowVpcInterface::vpc_interface_name) / [`set_vpc_interface_name(Option<String>)`](crate::client::fluent_builders::RemoveFlowVpcInterface::set_vpc_interface_name): The name of the VPC interface that you want to remove.
    /// - On success, responds with [`RemoveFlowVpcInterfaceOutput`](crate::output::RemoveFlowVpcInterfaceOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::RemoveFlowVpcInterfaceOutput::flow_arn): The ARN of the flow that is associated with the VPC interface you removed.
    ///   - [`non_deleted_network_interface_ids(Option<Vec<String>>)`](crate::output::RemoveFlowVpcInterfaceOutput::non_deleted_network_interface_ids): IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
    ///   - [`vpc_interface_name(Option<String>)`](crate::output::RemoveFlowVpcInterfaceOutput::vpc_interface_name): The name of the VPC interface that was removed.
    /// - On failure, responds with [`SdkError<RemoveFlowVpcInterfaceError>`](crate::error::RemoveFlowVpcInterfaceError)
    pub fn remove_flow_vpc_interface(&self) -> fluent_builders::RemoveFlowVpcInterface {
        fluent_builders::RemoveFlowVpcInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RevokeFlowEntitlement`](crate::client::fluent_builders::RevokeFlowEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`entitlement_arn(impl Into<String>)`](crate::client::fluent_builders::RevokeFlowEntitlement::entitlement_arn) / [`set_entitlement_arn(Option<String>)`](crate::client::fluent_builders::RevokeFlowEntitlement::set_entitlement_arn): The ARN of the entitlement that you want to revoke.
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::RevokeFlowEntitlement::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::RevokeFlowEntitlement::set_flow_arn): The flow that you want to revoke an entitlement from.
    /// - On success, responds with [`RevokeFlowEntitlementOutput`](crate::output::RevokeFlowEntitlementOutput) with field(s):
    ///   - [`entitlement_arn(Option<String>)`](crate::output::RevokeFlowEntitlementOutput::entitlement_arn): The ARN of the entitlement that was revoked.
    ///   - [`flow_arn(Option<String>)`](crate::output::RevokeFlowEntitlementOutput::flow_arn): The ARN of the flow that the entitlement was revoked from.
    /// - On failure, responds with [`SdkError<RevokeFlowEntitlementError>`](crate::error::RevokeFlowEntitlementError)
    pub fn revoke_flow_entitlement(&self) -> fluent_builders::RevokeFlowEntitlement {
        fluent_builders::RevokeFlowEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartFlow`](crate::client::fluent_builders::StartFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::StartFlow::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::StartFlow::set_flow_arn): The ARN of the flow that you want to start.
    /// - On success, responds with [`StartFlowOutput`](crate::output::StartFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::StartFlowOutput::flow_arn): The ARN of the flow that you started.
    ///   - [`status(Option<Status>)`](crate::output::StartFlowOutput::status): The status of the flow when the StartFlow process begins.
    /// - On failure, responds with [`SdkError<StartFlowError>`](crate::error::StartFlowError)
    pub fn start_flow(&self) -> fluent_builders::StartFlow {
        fluent_builders::StartFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopFlow`](crate::client::fluent_builders::StopFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::StopFlow::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::StopFlow::set_flow_arn): The ARN of the flow that you want to stop.
    /// - On success, responds with [`StopFlowOutput`](crate::output::StopFlowOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::StopFlowOutput::flow_arn): The ARN of the flow that you stopped.
    ///   - [`status(Option<Status>)`](crate::output::StopFlowOutput::status): The status of the flow when the StopFlow process begins.
    /// - On failure, responds with [`SdkError<StopFlowError>`](crate::error::StopFlowError)
    pub fn stop_flow(&self) -> fluent_builders::StopFlow {
        fluent_builders::StopFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): The keys of the tags to be removed.
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlow`](crate::client::fluent_builders::UpdateFlow) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlow::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlow::set_flow_arn): The flow that you want to update.
    ///   - [`source_failover_config(UpdateFailoverConfig)`](crate::client::fluent_builders::UpdateFlow::source_failover_config) / [`set_source_failover_config(Option<UpdateFailoverConfig>)`](crate::client::fluent_builders::UpdateFlow::set_source_failover_config): The settings for source failover.
    /// - On success, responds with [`UpdateFlowOutput`](crate::output::UpdateFlowOutput) with field(s):
    ///   - [`flow(Option<Flow>)`](crate::output::UpdateFlowOutput::flow): The settings for a flow, including its source, outputs, and entitlements.
    /// - On failure, responds with [`SdkError<UpdateFlowError>`](crate::error::UpdateFlowError)
    pub fn update_flow(&self) -> fluent_builders::UpdateFlow {
        fluent_builders::UpdateFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlowEntitlement`](crate::client::fluent_builders::UpdateFlowEntitlement) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::set_description): A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
    ///   - [`encryption(UpdateEncryption)`](crate::client::fluent_builders::UpdateFlowEntitlement::encryption) / [`set_encryption(Option<UpdateEncryption>)`](crate::client::fluent_builders::UpdateFlowEntitlement::set_encryption): The type of encryption that will be used on the output associated with this entitlement.
    ///   - [`entitlement_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::entitlement_arn) / [`set_entitlement_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::set_entitlement_arn): The ARN of the entitlement that you want to update.
    ///   - [`entitlement_status(EntitlementStatus)`](crate::client::fluent_builders::UpdateFlowEntitlement::entitlement_status) / [`set_entitlement_status(Option<EntitlementStatus>)`](crate::client::fluent_builders::UpdateFlowEntitlement::set_entitlement_status): An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::set_flow_arn): The flow that is associated with the entitlement that you want to update.
    ///   - [`subscribers(Vec<String>)`](crate::client::fluent_builders::UpdateFlowEntitlement::subscribers) / [`set_subscribers(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFlowEntitlement::set_subscribers): The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
    /// - On success, responds with [`UpdateFlowEntitlementOutput`](crate::output::UpdateFlowEntitlementOutput) with field(s):
    ///   - [`entitlement(Option<Entitlement>)`](crate::output::UpdateFlowEntitlementOutput::entitlement): The new configuration of the entitlement that you updated.
    ///   - [`flow_arn(Option<String>)`](crate::output::UpdateFlowEntitlementOutput::flow_arn): The ARN of the flow that this entitlement was granted on.
    /// - On failure, responds with [`SdkError<UpdateFlowEntitlementError>`](crate::error::UpdateFlowEntitlementError)
    pub fn update_flow_entitlement(&self) -> fluent_builders::UpdateFlowEntitlement {
        fluent_builders::UpdateFlowEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlowMediaStream`](crate::client::fluent_builders::UpdateFlowMediaStream) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`attributes(MediaStreamAttributesRequest)`](crate::client::fluent_builders::UpdateFlowMediaStream::attributes) / [`set_attributes(Option<MediaStreamAttributesRequest>)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_attributes): The attributes that you want to assign to the media stream.
    ///   - [`clock_rate(i32)`](crate::client::fluent_builders::UpdateFlowMediaStream::clock_rate) / [`set_clock_rate(i32)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_clock_rate): The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_description): Description
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_flow_arn): The Amazon Resource Name (ARN) of the flow.
    ///   - [`media_stream_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::media_stream_name) / [`set_media_stream_name(Option<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_media_stream_name): The name of the media stream that you want to update.
    ///   - [`media_stream_type(MediaStreamType)`](crate::client::fluent_builders::UpdateFlowMediaStream::media_stream_type) / [`set_media_stream_type(Option<MediaStreamType>)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_media_stream_type): The type of media stream.
    ///   - [`video_format(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::video_format) / [`set_video_format(Option<String>)`](crate::client::fluent_builders::UpdateFlowMediaStream::set_video_format): The resolution of the video.
    /// - On success, responds with [`UpdateFlowMediaStreamOutput`](crate::output::UpdateFlowMediaStreamOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::UpdateFlowMediaStreamOutput::flow_arn): The ARN of the flow that is associated with the media stream that you updated.
    ///   - [`media_stream(Option<MediaStream>)`](crate::output::UpdateFlowMediaStreamOutput::media_stream): The media stream that you updated.
    /// - On failure, responds with [`SdkError<UpdateFlowMediaStreamError>`](crate::error::UpdateFlowMediaStreamError)
    pub fn update_flow_media_stream(&self) -> fluent_builders::UpdateFlowMediaStream {
        fluent_builders::UpdateFlowMediaStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlowOutput`](crate::client::fluent_builders::UpdateFlowOutput) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`cidr_allow_list(Vec<String>)`](crate::client::fluent_builders::UpdateFlowOutput::cidr_allow_list) / [`set_cidr_allow_list(Option<Vec<String>>)`](crate::client::fluent_builders::UpdateFlowOutput::set_cidr_allow_list): The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_description): A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
    ///   - [`destination(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::destination) / [`set_destination(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_destination): The IP address where you want to send the output.
    ///   - [`encryption(UpdateEncryption)`](crate::client::fluent_builders::UpdateFlowOutput::encryption) / [`set_encryption(Option<UpdateEncryption>)`](crate::client::fluent_builders::UpdateFlowOutput::set_encryption): The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_flow_arn): The flow that is associated with the output that you want to update.
    ///   - [`max_latency(i32)`](crate::client::fluent_builders::UpdateFlowOutput::max_latency) / [`set_max_latency(i32)`](crate::client::fluent_builders::UpdateFlowOutput::set_max_latency): The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
    ///   - [`media_stream_output_configurations(Vec<MediaStreamOutputConfigurationRequest>)`](crate::client::fluent_builders::UpdateFlowOutput::media_stream_output_configurations) / [`set_media_stream_output_configurations(Option<Vec<MediaStreamOutputConfigurationRequest>>)`](crate::client::fluent_builders::UpdateFlowOutput::set_media_stream_output_configurations): The media streams that are associated with the output, and the parameters for those associations.
    ///   - [`min_latency(i32)`](crate::client::fluent_builders::UpdateFlowOutput::min_latency) / [`set_min_latency(i32)`](crate::client::fluent_builders::UpdateFlowOutput::set_min_latency): The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    ///   - [`output_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::output_arn) / [`set_output_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_output_arn): The ARN of the output that you want to update.
    ///   - [`port(i32)`](crate::client::fluent_builders::UpdateFlowOutput::port) / [`set_port(i32)`](crate::client::fluent_builders::UpdateFlowOutput::set_port): The port to use when content is distributed to this output.
    ///   - [`protocol(Protocol)`](crate::client::fluent_builders::UpdateFlowOutput::protocol) / [`set_protocol(Option<Protocol>)`](crate::client::fluent_builders::UpdateFlowOutput::set_protocol): The protocol to use for the output.
    ///   - [`remote_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::remote_id) / [`set_remote_id(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_remote_id): The remote ID for the Zixi-pull stream.
    ///   - [`sender_control_port(i32)`](crate::client::fluent_builders::UpdateFlowOutput::sender_control_port) / [`set_sender_control_port(i32)`](crate::client::fluent_builders::UpdateFlowOutput::set_sender_control_port): The port that the flow uses to send outbound requests to initiate connection with the sender.
    ///   - [`sender_ip_address(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::sender_ip_address) / [`set_sender_ip_address(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_sender_ip_address): The IP address that the flow communicates with to initiate connection with the sender.
    ///   - [`smoothing_latency(i32)`](crate::client::fluent_builders::UpdateFlowOutput::smoothing_latency) / [`set_smoothing_latency(i32)`](crate::client::fluent_builders::UpdateFlowOutput::set_smoothing_latency): The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowOutput::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::UpdateFlowOutput::set_stream_id): The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    ///   - [`vpc_interface_attachment(VpcInterfaceAttachment)`](crate::client::fluent_builders::UpdateFlowOutput::vpc_interface_attachment) / [`set_vpc_interface_attachment(Option<VpcInterfaceAttachment>)`](crate::client::fluent_builders::UpdateFlowOutput::set_vpc_interface_attachment): The name of the VPC interface attachment to use for this output.
    /// - On success, responds with [`UpdateFlowOutputOutput`](crate::output::UpdateFlowOutputOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::UpdateFlowOutputOutput::flow_arn): The ARN of the flow that is associated with the updated output.
    ///   - [`output(Option<Output>)`](crate::output::UpdateFlowOutputOutput::output): The new settings of the output that you updated.
    /// - On failure, responds with [`SdkError<UpdateFlowOutputError>`](crate::error::UpdateFlowOutputError)
    pub fn update_flow_output(&self) -> fluent_builders::UpdateFlowOutput {
        fluent_builders::UpdateFlowOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFlowSource`](crate::client::fluent_builders::UpdateFlowSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`decryption(UpdateEncryption)`](crate::client::fluent_builders::UpdateFlowSource::decryption) / [`set_decryption(Option<UpdateEncryption>)`](crate::client::fluent_builders::UpdateFlowSource::set_decryption): The type of encryption used on the content ingested from this source.
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_description): A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
    ///   - [`entitlement_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::entitlement_arn) / [`set_entitlement_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_entitlement_arn): The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
    ///   - [`flow_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::flow_arn) / [`set_flow_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_flow_arn): The flow that is associated with the source that you want to update.
    ///   - [`ingest_port(i32)`](crate::client::fluent_builders::UpdateFlowSource::ingest_port) / [`set_ingest_port(i32)`](crate::client::fluent_builders::UpdateFlowSource::set_ingest_port): The port that the flow will be listening on for incoming content.
    ///   - [`max_bitrate(i32)`](crate::client::fluent_builders::UpdateFlowSource::max_bitrate) / [`set_max_bitrate(i32)`](crate::client::fluent_builders::UpdateFlowSource::set_max_bitrate): The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
    ///   - [`max_latency(i32)`](crate::client::fluent_builders::UpdateFlowSource::max_latency) / [`set_max_latency(i32)`](crate::client::fluent_builders::UpdateFlowSource::set_max_latency): The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
    ///   - [`max_sync_buffer(i32)`](crate::client::fluent_builders::UpdateFlowSource::max_sync_buffer) / [`set_max_sync_buffer(i32)`](crate::client::fluent_builders::UpdateFlowSource::set_max_sync_buffer): The size of the buffer (in milliseconds) to use to sync incoming source data.
    ///   - [`media_stream_source_configurations(Vec<MediaStreamSourceConfigurationRequest>)`](crate::client::fluent_builders::UpdateFlowSource::media_stream_source_configurations) / [`set_media_stream_source_configurations(Option<Vec<MediaStreamSourceConfigurationRequest>>)`](crate::client::fluent_builders::UpdateFlowSource::set_media_stream_source_configurations): The media streams that are associated with the source, and the parameters for those associations.
    ///   - [`min_latency(i32)`](crate::client::fluent_builders::UpdateFlowSource::min_latency) / [`set_min_latency(i32)`](crate::client::fluent_builders::UpdateFlowSource::set_min_latency): The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    ///   - [`protocol(Protocol)`](crate::client::fluent_builders::UpdateFlowSource::protocol) / [`set_protocol(Option<Protocol>)`](crate::client::fluent_builders::UpdateFlowSource::set_protocol): The protocol that is used by the source.
    ///   - [`sender_control_port(i32)`](crate::client::fluent_builders::UpdateFlowSource::sender_control_port) / [`set_sender_control_port(i32)`](crate::client::fluent_builders::UpdateFlowSource::set_sender_control_port): The port that the flow uses to send outbound requests to initiate connection with the sender.
    ///   - [`sender_ip_address(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::sender_ip_address) / [`set_sender_ip_address(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_sender_ip_address): The IP address that the flow communicates with to initiate connection with the sender.
    ///   - [`source_arn(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::source_arn) / [`set_source_arn(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_source_arn): The ARN of the source that you want to update.
    ///   - [`stream_id(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::stream_id) / [`set_stream_id(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_stream_id): The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    ///   - [`vpc_interface_name(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::vpc_interface_name) / [`set_vpc_interface_name(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_vpc_interface_name): The name of the VPC interface to use for this source.
    ///   - [`whitelist_cidr(impl Into<String>)`](crate::client::fluent_builders::UpdateFlowSource::whitelist_cidr) / [`set_whitelist_cidr(Option<String>)`](crate::client::fluent_builders::UpdateFlowSource::set_whitelist_cidr): The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    /// - On success, responds with [`UpdateFlowSourceOutput`](crate::output::UpdateFlowSourceOutput) with field(s):
    ///   - [`flow_arn(Option<String>)`](crate::output::UpdateFlowSourceOutput::flow_arn): The ARN of the flow that you want to update.
    ///   - [`source(Option<Source>)`](crate::output::UpdateFlowSourceOutput::source): The settings for the source of the flow.
    /// - On failure, responds with [`SdkError<UpdateFlowSourceError>`](crate::error::UpdateFlowSourceError)
    pub fn update_flow_source(&self) -> fluent_builders::UpdateFlowSource {
        fluent_builders::UpdateFlowSource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddFlowMediaStreams`.
    ///
    /// Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddFlowMediaStreams {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_flow_media_streams_input::Builder,
    }
    impl AddFlowMediaStreams {
        /// Creates a new `AddFlowMediaStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowMediaStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowMediaStreamsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `MediaStreams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you want to add to the flow.
        pub fn media_streams(mut self, input: crate::model::AddMediaStreamRequest) -> Self {
            self.inner = self.inner.media_streams(input);
            self
        }
        /// The media streams that you want to add to the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        ) -> Self {
            self.inner = self.inner.set_media_streams(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddFlowOutputs`.
    ///
    /// Adds outputs to an existing flow. You can create up to 50 outputs per flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddFlowOutputs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_flow_outputs_input::Builder,
    }
    impl AddFlowOutputs {
        /// Creates a new `AddFlowOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowOutputsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to add outputs to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to add outputs to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// A list of outputs that you want to add.
        pub fn outputs(mut self, input: crate::model::AddOutputRequest) -> Self {
            self.inner = self.inner.outputs(input);
            self
        }
        /// A list of outputs that you want to add.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddFlowSources`.
    ///
    /// Adds Sources to flow
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddFlowSources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_flow_sources_input::Builder,
    }
    impl AddFlowSources {
        /// Creates a new `AddFlowSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowSourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to mutate.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to mutate.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// A list of sources that you want to add.
        pub fn sources(mut self, input: crate::model::SetSourceRequest) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        /// A list of sources that you want to add.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddFlowVpcInterfaces`.
    ///
    /// Adds VPC interfaces to flow
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddFlowVpcInterfaces {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_flow_vpc_interfaces_input::Builder,
    }
    impl AddFlowVpcInterfaces {
        /// Creates a new `AddFlowVpcInterfaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowVpcInterfacesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowVpcInterfacesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to mutate.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to mutate.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `VpcInterfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// A list of VPC interfaces that you want to add.
        pub fn vpc_interfaces(mut self, input: crate::model::VpcInterfaceRequest) -> Self {
            self.inner = self.inner.vpc_interfaces(input);
            self
        }
        /// A list of VPC interfaces that you want to add.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interfaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlow`.
    ///
    /// Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_flow_input::Builder,
    }
    impl CreateFlow {
        /// Creates a new `CreateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(input.into());
            self
        }
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The entitlements that you want to grant on a flow.
        pub fn entitlements(mut self, input: crate::model::GrantEntitlementRequest) -> Self {
            self.inner = self.inner.entitlements(input);
            self
        }
        /// The entitlements that you want to grant on a flow.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// Appends an item to `MediaStreams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
        pub fn media_streams(mut self, input: crate::model::AddMediaStreamRequest) -> Self {
            self.inner = self.inner.media_streams(input);
            self
        }
        /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        ) -> Self {
            self.inner = self.inner.set_media_streams(input);
            self
        }
        /// The name of the flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// The name of the flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// The outputs that you want to add to this flow.
        pub fn outputs(mut self, input: crate::model::AddOutputRequest) -> Self {
            self.inner = self.inner.outputs(input);
            self
        }
        /// The outputs that you want to add to this flow.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// The settings for the source of the flow.
        pub fn source(mut self, input: crate::model::SetSourceRequest) -> Self {
            self.inner = self.inner.source(input);
            self
        }
        /// The settings for the source of the flow.
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::SetSourceRequest>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// The settings for source failover.
        pub fn source_failover_config(mut self, input: crate::model::FailoverConfig) -> Self {
            self.inner = self.inner.source_failover_config(input);
            self
        }
        /// The settings for source failover.
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::FailoverConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_failover_config(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn sources(mut self, input: crate::model::SetSourceRequest) -> Self {
            self.inner = self.inner.sources(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// Appends an item to `VpcInterfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// The VPC interfaces you want on the flow.
        pub fn vpc_interfaces(mut self, input: crate::model::VpcInterfaceRequest) -> Self {
            self.inner = self.inner.vpc_interfaces(input);
            self
        }
        /// The VPC interfaces you want on the flow.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interfaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlow`.
    ///
    /// Deletes a flow. Before you can delete a flow, you must stop the flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_flow_input::Builder,
    }
    impl DeleteFlow {
        /// Creates a new `DeleteFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to delete.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The ARN of the flow that you want to delete.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlow`.
    ///
    /// Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_flow_input::Builder,
    }
    impl DescribeFlow {
        /// Creates a new `DescribeFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to describe.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The ARN of the flow that you want to describe.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOffering`.
    ///
    /// Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOffering {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_offering_input::Builder,
    }
    impl DescribeOffering {
        /// Creates a new `DescribeOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOfferingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn offering_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservation`.
    ///
    /// Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeReservation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_reservation_input::Builder,
    }
    impl DescribeReservation {
        /// Creates a new `DescribeReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the reservation.
        pub fn reservation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the reservation.
        pub fn set_reservation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GrantFlowEntitlements`.
    ///
    /// Grants entitlements to an existing flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GrantFlowEntitlements {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::grant_flow_entitlements_input::Builder,
    }
    impl GrantFlowEntitlements {
        /// Creates a new `GrantFlowEntitlements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GrantFlowEntitlementsOutput,
            aws_smithy_http::result::SdkError<crate::error::GrantFlowEntitlementsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The list of entitlements that you want to grant.
        pub fn entitlements(mut self, input: crate::model::GrantEntitlementRequest) -> Self {
            self.inner = self.inner.entitlements(input);
            self
        }
        /// The list of entitlements that you want to grant.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// The flow that you want to grant entitlements on.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to grant entitlements on.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntitlements`.
    ///
    /// Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListEntitlements {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_entitlements_input::Builder,
    }
    impl ListEntitlements {
        /// Creates a new `ListEntitlements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitlementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitlementsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListEntitlementsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListEntitlementsPaginator {
            crate::paginator::ListEntitlementsPaginator::new(self.handle, self.inner)
        }
        /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFlows`.
    ///
    /// Displays a list of flows that are associated with this account. This request returns a paginated result.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFlows {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_flows_input::Builder,
    }
    impl ListFlows {
        /// Creates a new `ListFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFlowsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFlowsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFlowsPaginator {
            crate::paginator::ListFlowsPaginator::new(self.handle, self.inner)
        }
        /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOfferings`.
    ///
    /// Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOfferings {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_offerings_input::Builder,
    }
    impl ListOfferings {
        /// Creates a new `ListOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOfferingsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOfferingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListOfferingsPaginator {
            crate::paginator::ListOfferingsPaginator::new(self.handle, self.inner)
        }
        /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReservations`.
    ///
    /// Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListReservations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_reservations_input::Builder,
    }
    impl ListReservations {
        /// Creates a new `ListReservations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReservationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReservationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListReservationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListReservationsPaginator {
            crate::paginator::ListReservationsPaginator::new(self.handle, self.inner)
        }
        /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// List all tags on an AWS Elemental MediaConnect resource
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseOffering`.
    ///
    /// Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PurchaseOffering {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::purchase_offering_input::Builder,
    }
    impl PurchaseOffering {
        /// Creates a new `PurchaseOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseOfferingError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn offering_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_arn(input);
            self
        }
        /// The name that you want to use for the reservation.
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_name(input.into());
            self
        }
        /// The name that you want to use for the reservation.
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_name(input);
            self
        }
        /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start(input.into());
            self
        }
        /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowMediaStream`.
    ///
    /// Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveFlowMediaStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_flow_media_stream_input::Builder,
    }
    impl RemoveFlowMediaStream {
        /// Creates a new `RemoveFlowMediaStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowMediaStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowMediaStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The name of the media stream that you want to remove.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_stream_name(input.into());
            self
        }
        /// The name of the media stream that you want to remove.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowOutput`.
    ///
    /// Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveFlowOutput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_flow_output_input::Builder,
    }
    impl RemoveFlowOutput {
        /// Creates a new `RemoveFlowOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowOutputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to remove an output from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to remove an output from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The ARN of the output that you want to remove.
        pub fn output_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_arn(input.into());
            self
        }
        /// The ARN of the output that you want to remove.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowSource`.
    ///
    /// Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveFlowSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_flow_source_input::Builder,
    }
    impl RemoveFlowSource {
        /// Creates a new `RemoveFlowSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to remove a source from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to remove a source from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The ARN of the source that you want to remove.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// The ARN of the source that you want to remove.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowVpcInterface`.
    ///
    /// Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RemoveFlowVpcInterface {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::remove_flow_vpc_interface_input::Builder,
    }
    impl RemoveFlowVpcInterface {
        /// Creates a new `RemoveFlowVpcInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowVpcInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowVpcInterfaceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to remove a VPC interface from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to remove a VPC interface from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The name of the VPC interface that you want to remove.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_interface_name(input.into());
            self
        }
        /// The name of the VPC interface that you want to remove.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interface_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeFlowEntitlement`.
    ///
    /// Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RevokeFlowEntitlement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::revoke_flow_entitlement_input::Builder,
    }
    impl RevokeFlowEntitlement {
        /// Creates a new `RevokeFlowEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeFlowEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeFlowEntitlementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the entitlement that you want to revoke.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_arn(input.into());
            self
        }
        /// The ARN of the entitlement that you want to revoke.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_arn(input);
            self
        }
        /// The flow that you want to revoke an entitlement from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to revoke an entitlement from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFlow`.
    ///
    /// Starts a flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_flow_input::Builder,
    }
    impl StartFlow {
        /// Creates a new `StartFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to start.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The ARN of the flow that you want to start.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFlow`.
    ///
    /// Stops a flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_flow_input::Builder,
    }
    impl StopFlow {
        /// Creates a new `StopFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to stop.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The ARN of the flow that you want to stop.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Deletes specified tags from a resource.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The keys of the tags to be removed.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// The keys of the tags to be removed.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlow`.
    ///
    /// Updates flow
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlow {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_input::Builder,
    }
    impl UpdateFlow {
        /// Creates a new `UpdateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The settings for source failover.
        pub fn source_failover_config(mut self, input: crate::model::UpdateFailoverConfig) -> Self {
            self.inner = self.inner.source_failover_config(input);
            self
        }
        /// The settings for source failover.
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::UpdateFailoverConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_failover_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowEntitlement`.
    ///
    /// You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlowEntitlement {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_entitlement_input::Builder,
    }
    impl UpdateFlowEntitlement {
        /// Creates a new `UpdateFlowEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowEntitlementError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The type of encryption that will be used on the output associated with this entitlement.
        pub fn encryption(mut self, input: crate::model::UpdateEncryption) -> Self {
            self.inner = self.inner.encryption(input);
            self
        }
        /// The type of encryption that will be used on the output associated with this entitlement.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.inner = self.inner.set_encryption(input);
            self
        }
        /// The ARN of the entitlement that you want to update.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_arn(input.into());
            self
        }
        /// The ARN of the entitlement that you want to update.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_arn(input);
            self
        }
        /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
        pub fn entitlement_status(mut self, input: crate::model::EntitlementStatus) -> Self {
            self.inner = self.inner.entitlement_status(input);
            self
        }
        /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
        pub fn set_entitlement_status(
            mut self,
            input: std::option::Option<crate::model::EntitlementStatus>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_status(input);
            self
        }
        /// The flow that is associated with the entitlement that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that is associated with the entitlement that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn subscribers(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscribers(input.into());
            self
        }
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowMediaStream`.
    ///
    /// Updates an existing media stream.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlowMediaStream {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_media_stream_input::Builder,
    }
    impl UpdateFlowMediaStream {
        /// Creates a new `UpdateFlowMediaStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowMediaStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowMediaStreamError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The attributes that you want to assign to the media stream.
        pub fn attributes(mut self, input: crate::model::MediaStreamAttributesRequest) -> Self {
            self.inner = self.inner.attributes(input);
            self
        }
        /// The attributes that you want to assign to the media stream.
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::MediaStreamAttributesRequest>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn clock_rate(mut self, input: i32) -> Self {
            self.inner = self.inner.clock_rate(input);
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn set_clock_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_clock_rate(input);
            self
        }
        /// Description
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// Description
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The name of the media stream that you want to update.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_stream_name(input.into());
            self
        }
        /// The name of the media stream that you want to update.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_stream_name(input);
            self
        }
        /// The type of media stream.
        pub fn media_stream_type(mut self, input: crate::model::MediaStreamType) -> Self {
            self.inner = self.inner.media_stream_type(input);
            self
        }
        /// The type of media stream.
        pub fn set_media_stream_type(
            mut self,
            input: std::option::Option<crate::model::MediaStreamType>,
        ) -> Self {
            self.inner = self.inner.set_media_stream_type(input);
            self
        }
        /// The resolution of the video.
        pub fn video_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.video_format(input.into());
            self
        }
        /// The resolution of the video.
        pub fn set_video_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_video_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowOutput`.
    ///
    /// Updates an existing flow output.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlowOutput {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_output_input::Builder,
    }
    impl UpdateFlowOutput {
        /// Creates a new `UpdateFlowOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowOutputError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `CidrAllowList`.
        ///
        /// To override the contents of this collection use [`set_cidr_allow_list`](Self::set_cidr_allow_list).
        ///
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn cidr_allow_list(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_allow_list(input.into());
            self
        }
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_cidr_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cidr_allow_list(input);
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The IP address where you want to send the output.
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination(input.into());
            self
        }
        /// The IP address where you want to send the output.
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn encryption(mut self, input: crate::model::UpdateEncryption) -> Self {
            self.inner = self.inner.encryption(input);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.inner = self.inner.set_encryption(input);
            self
        }
        /// The flow that is associated with the output that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that is associated with the output that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.inner = self.inner.max_latency(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_latency(input);
            self
        }
        /// Appends an item to `MediaStreamOutputConfigurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_output_configurations`](Self::set_media_stream_output_configurations).
        ///
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn media_stream_output_configurations(
            mut self,
            input: crate::model::MediaStreamOutputConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.media_stream_output_configurations(input);
            self
        }
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn set_media_stream_output_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_media_stream_output_configurations(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.inner = self.inner.min_latency(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_latency(input);
            self
        }
        /// The ARN of the output that you want to update.
        pub fn output_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_arn(input.into());
            self
        }
        /// The ARN of the output that you want to update.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_arn(input);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn port(mut self, input: i32) -> Self {
            self.inner = self.inner.port(input);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// The protocol to use for the output.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// The protocol to use for the output.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn remote_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_id(input.into());
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn set_remote_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_remote_id(input);
            self
        }
        /// The port that the flow uses to send outbound requests to initiate connection with the sender.
        pub fn sender_control_port(mut self, input: i32) -> Self {
            self.inner = self.inner.sender_control_port(input);
            self
        }
        /// The port that the flow uses to send outbound requests to initiate connection with the sender.
        pub fn set_sender_control_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_sender_control_port(input);
            self
        }
        /// The IP address that the flow communicates with to initiate connection with the sender.
        pub fn sender_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sender_ip_address(input.into());
            self
        }
        /// The IP address that the flow communicates with to initiate connection with the sender.
        pub fn set_sender_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sender_ip_address(input);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn smoothing_latency(mut self, input: i32) -> Self {
            self.inner = self.inner.smoothing_latency(input);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn set_smoothing_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_smoothing_latency(input);
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn vpc_interface_attachment(
            mut self,
            input: crate::model::VpcInterfaceAttachment,
        ) -> Self {
            self.inner = self.inner.vpc_interface_attachment(input);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn set_vpc_interface_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcInterfaceAttachment>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interface_attachment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowSource`.
    ///
    /// Updates the source of a flow.
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFlowSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_flow_source_input::Builder,
    }
    impl UpdateFlowSource {
        /// Creates a new `UpdateFlowSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The type of encryption used on the content ingested from this source.
        pub fn decryption(mut self, input: crate::model::UpdateEncryption) -> Self {
            self.inner = self.inner.decryption(input);
            self
        }
        /// The type of encryption used on the content ingested from this source.
        pub fn set_decryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.inner = self.inner.set_decryption(input);
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_arn(input.into());
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_arn(input);
            self
        }
        /// The flow that is associated with the source that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(input.into());
            self
        }
        /// The flow that is associated with the source that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn ingest_port(mut self, input: i32) -> Self {
            self.inner = self.inner.ingest_port(input);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn set_ingest_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ingest_port(input);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.inner = self.inner.max_bitrate(input);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_bitrate(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.inner = self.inner.max_latency(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based, Zixi-based, and Fujitsu-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_latency(input);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn max_sync_buffer(mut self, input: i32) -> Self {
            self.inner = self.inner.max_sync_buffer(input);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn set_max_sync_buffer(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_sync_buffer(input);
            self
        }
        /// Appends an item to `MediaStreamSourceConfigurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_source_configurations`](Self::set_media_stream_source_configurations).
        ///
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn media_stream_source_configurations(
            mut self,
            input: crate::model::MediaStreamSourceConfigurationRequest,
        ) -> Self {
            self.inner = self.inner.media_stream_source_configurations(input);
            self
        }
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn set_media_stream_source_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_media_stream_source_configurations(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.inner = self.inner.min_latency(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_latency(input);
            self
        }
        /// The protocol that is used by the source.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(input);
            self
        }
        /// The protocol that is used by the source.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// The port that the flow uses to send outbound requests to initiate connection with the sender.
        pub fn sender_control_port(mut self, input: i32) -> Self {
            self.inner = self.inner.sender_control_port(input);
            self
        }
        /// The port that the flow uses to send outbound requests to initiate connection with the sender.
        pub fn set_sender_control_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_sender_control_port(input);
            self
        }
        /// The IP address that the flow communicates with to initiate connection with the sender.
        pub fn sender_ip_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sender_ip_address(input.into());
            self
        }
        /// The IP address that the flow communicates with to initiate connection with the sender.
        pub fn set_sender_ip_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_sender_ip_address(input);
            self
        }
        /// The ARN of the source that you want to update.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(input.into());
            self
        }
        /// The ARN of the source that you want to update.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_interface_name(input.into());
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interface_name(input);
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn whitelist_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.whitelist_cidr(input.into());
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_whitelist_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_whitelist_cidr(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
