// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddFlowMediaStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddFlowMediaStreamsError {
    /// Kind of error that occurred.
    pub kind: AddFlowMediaStreamsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddFlowMediaStreams` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddFlowMediaStreamsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddFlowMediaStreamsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddFlowMediaStreamsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AddFlowMediaStreamsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AddFlowMediaStreamsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AddFlowMediaStreamsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AddFlowMediaStreamsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AddFlowMediaStreamsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddFlowMediaStreamsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddFlowMediaStreamsError {
    fn code(&self) -> Option<&str> {
        AddFlowMediaStreamsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddFlowMediaStreamsError {
    /// Creates a new `AddFlowMediaStreamsError`.
    pub fn new(kind: AddFlowMediaStreamsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddFlowMediaStreamsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddFlowMediaStreamsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddFlowMediaStreamsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddFlowMediaStreamsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddFlowMediaStreamsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowMediaStreamsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowMediaStreamsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowMediaStreamsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowMediaStreamsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowMediaStreamsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowMediaStreamsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowMediaStreamsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowMediaStreamsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowMediaStreamsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowMediaStreamsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowMediaStreamsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AddFlowMediaStreamsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddFlowMediaStreamsErrorKind::BadRequestException(_inner) => Some(_inner),
            AddFlowMediaStreamsErrorKind::ForbiddenException(_inner) => Some(_inner),
            AddFlowMediaStreamsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AddFlowMediaStreamsErrorKind::NotFoundException(_inner) => Some(_inner),
            AddFlowMediaStreamsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AddFlowMediaStreamsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddFlowMediaStreamsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddFlowOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddFlowOutputsError {
    /// Kind of error that occurred.
    pub kind: AddFlowOutputsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddFlowOutputs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddFlowOutputsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    AddFlowOutputs420Exception(crate::error::AddFlowOutputs420Exception),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddFlowOutputsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddFlowOutputsErrorKind::AddFlowOutputs420Exception(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddFlowOutputsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddFlowOutputsError {
    fn code(&self) -> Option<&str> {
        AddFlowOutputsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddFlowOutputsError {
    /// Creates a new `AddFlowOutputsError`.
    pub fn new(kind: AddFlowOutputsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddFlowOutputsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddFlowOutputsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddFlowOutputsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddFlowOutputsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::AddFlowOutputs420Exception`.
    pub fn is_add_flow_outputs420_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowOutputsErrorKind::AddFlowOutputs420Exception(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, AddFlowOutputsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, AddFlowOutputsErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowOutputsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddFlowOutputsErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowOutputsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowOutputsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowOutputsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AddFlowOutputsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddFlowOutputsErrorKind::AddFlowOutputs420Exception(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::BadRequestException(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::ForbiddenException(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::NotFoundException(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddFlowOutputsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddFlowSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddFlowSourcesError {
    /// Kind of error that occurred.
    pub kind: AddFlowSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddFlowSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddFlowSourcesErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddFlowSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddFlowSourcesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AddFlowSourcesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AddFlowSourcesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AddFlowSourcesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AddFlowSourcesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AddFlowSourcesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddFlowSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddFlowSourcesError {
    fn code(&self) -> Option<&str> {
        AddFlowSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddFlowSourcesError {
    /// Creates a new `AddFlowSourcesError`.
    pub fn new(kind: AddFlowSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddFlowSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddFlowSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddFlowSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddFlowSourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddFlowSourcesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, AddFlowSourcesErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `AddFlowSourcesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, AddFlowSourcesErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `AddFlowSourcesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowSourcesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowSourcesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddFlowSourcesErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `AddFlowSourcesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowSourcesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowSourcesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowSourcesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AddFlowSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddFlowSourcesErrorKind::BadRequestException(_inner) => Some(_inner),
            AddFlowSourcesErrorKind::ForbiddenException(_inner) => Some(_inner),
            AddFlowSourcesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AddFlowSourcesErrorKind::NotFoundException(_inner) => Some(_inner),
            AddFlowSourcesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AddFlowSourcesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddFlowSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `AddFlowVpcInterfaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddFlowVpcInterfacesError {
    /// Kind of error that occurred.
    pub kind: AddFlowVpcInterfacesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddFlowVpcInterfaces` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddFlowVpcInterfacesErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddFlowVpcInterfacesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddFlowVpcInterfacesErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            AddFlowVpcInterfacesErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            AddFlowVpcInterfacesErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            AddFlowVpcInterfacesErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            AddFlowVpcInterfacesErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            AddFlowVpcInterfacesErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            AddFlowVpcInterfacesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddFlowVpcInterfacesError {
    fn code(&self) -> Option<&str> {
        AddFlowVpcInterfacesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddFlowVpcInterfacesError {
    /// Creates a new `AddFlowVpcInterfacesError`.
    pub fn new(kind: AddFlowVpcInterfacesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddFlowVpcInterfacesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddFlowVpcInterfacesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddFlowVpcInterfacesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddFlowVpcInterfacesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddFlowVpcInterfacesErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowVpcInterfacesErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowVpcInterfacesErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowVpcInterfacesErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowVpcInterfacesErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowVpcInterfacesErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowVpcInterfacesErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowVpcInterfacesErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowVpcInterfacesErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowVpcInterfacesErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `AddFlowVpcInterfacesErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            AddFlowVpcInterfacesErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for AddFlowVpcInterfacesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddFlowVpcInterfacesErrorKind::BadRequestException(_inner) => Some(_inner),
            AddFlowVpcInterfacesErrorKind::ForbiddenException(_inner) => Some(_inner),
            AddFlowVpcInterfacesErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            AddFlowVpcInterfacesErrorKind::NotFoundException(_inner) => Some(_inner),
            AddFlowVpcInterfacesErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            AddFlowVpcInterfacesErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            AddFlowVpcInterfacesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFlowError {
    /// Kind of error that occurred.
    pub kind: CreateFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFlowErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    CreateFlow420Exception(crate::error::CreateFlow420Exception),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::CreateFlow420Exception(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            CreateFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFlowError {
    fn code(&self) -> Option<&str> {
        CreateFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFlowError {
    /// Creates a new `CreateFlowError`.
    pub fn new(kind: CreateFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::CreateFlow420Exception`.
    pub fn is_create_flow420_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::CreateFlow420Exception(_))
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFlowErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFlowErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, CreateFlowErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for CreateFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            CreateFlowErrorKind::CreateFlow420Exception(_inner) => Some(_inner),
            CreateFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            CreateFlowErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            CreateFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            CreateFlowErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            CreateFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFlowError {
    /// Kind of error that occurred.
    pub kind: DeleteFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFlowErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DeleteFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFlowError {
    fn code(&self) -> Option<&str> {
        DeleteFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFlowError {
    /// Creates a new `DeleteFlowError`.
    pub fn new(kind: DeleteFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteFlowErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DeleteFlowErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFlowErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DeleteFlowErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFlowErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, DeleteFlowErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for DeleteFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            DeleteFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            DeleteFlowErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DeleteFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            DeleteFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DeleteFlowErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DeleteFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeFlowError {
    /// Kind of error that occurred.
    pub kind: DescribeFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeFlowErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeFlowError {
    fn code(&self) -> Option<&str> {
        DescribeFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeFlowError {
    /// Creates a new `DescribeFlowError`.
    pub fn new(kind: DescribeFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, DescribeFlowErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, DescribeFlowErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeFlowErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeFlowErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeFlowErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            DescribeFlowErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeFlowErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOfferingError {
    /// Kind of error that occurred.
    pub kind: DescribeOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOfferingErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOfferingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOfferingError {
    fn code(&self) -> Option<&str> {
        DescribeOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOfferingError {
    /// Creates a new `DescribeOfferingError`.
    pub fn new(kind: DescribeOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOfferingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, DescribeOfferingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOfferingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOfferingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOfferingErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeReservationError {
    /// Kind of error that occurred.
    pub kind: DescribeReservationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeReservation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeReservationErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeReservationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeReservationErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            DescribeReservationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeReservationError {
    fn code(&self) -> Option<&str> {
        DescribeReservationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeReservationError {
    /// Creates a new `DescribeReservationError`.
    pub fn new(kind: DescribeReservationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeReservationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeReservationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeReservationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeReservationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeReservationErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeReservationErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for DescribeReservationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeReservationErrorKind::BadRequestException(_inner) => Some(_inner),
            DescribeReservationErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            DescribeReservationErrorKind::NotFoundException(_inner) => Some(_inner),
            DescribeReservationErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            DescribeReservationErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            DescribeReservationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GrantFlowEntitlements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GrantFlowEntitlementsError {
    /// Kind of error that occurred.
    pub kind: GrantFlowEntitlementsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GrantFlowEntitlements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GrantFlowEntitlementsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    GrantFlowEntitlements420Exception(crate::error::GrantFlowEntitlements420Exception),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GrantFlowEntitlementsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GrantFlowEntitlementsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            GrantFlowEntitlementsErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            GrantFlowEntitlementsErrorKind::GrantFlowEntitlements420Exception(_inner) => {
                _inner.fmt(f)
            }
            GrantFlowEntitlementsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            GrantFlowEntitlementsErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            GrantFlowEntitlementsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            GrantFlowEntitlementsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            GrantFlowEntitlementsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GrantFlowEntitlementsError {
    fn code(&self) -> Option<&str> {
        GrantFlowEntitlementsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GrantFlowEntitlementsError {
    /// Creates a new `GrantFlowEntitlementsError`.
    pub fn new(kind: GrantFlowEntitlementsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GrantFlowEntitlementsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GrantFlowEntitlementsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GrantFlowEntitlementsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GrantFlowEntitlementsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::GrantFlowEntitlements420Exception`.
    pub fn is_grant_flow_entitlements420_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::GrantFlowEntitlements420Exception(_)
        )
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `GrantFlowEntitlementsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            GrantFlowEntitlementsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for GrantFlowEntitlementsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GrantFlowEntitlementsErrorKind::BadRequestException(_inner) => Some(_inner),
            GrantFlowEntitlementsErrorKind::ForbiddenException(_inner) => Some(_inner),
            GrantFlowEntitlementsErrorKind::GrantFlowEntitlements420Exception(_inner) => {
                Some(_inner)
            }
            GrantFlowEntitlementsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            GrantFlowEntitlementsErrorKind::NotFoundException(_inner) => Some(_inner),
            GrantFlowEntitlementsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            GrantFlowEntitlementsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            GrantFlowEntitlementsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListEntitlements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListEntitlementsError {
    /// Kind of error that occurred.
    pub kind: ListEntitlementsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListEntitlements` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListEntitlementsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListEntitlementsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListEntitlementsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListEntitlementsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListEntitlementsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListEntitlementsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListEntitlementsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListEntitlementsError {
    fn code(&self) -> Option<&str> {
        ListEntitlementsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListEntitlementsError {
    /// Creates a new `ListEntitlementsError`.
    pub fn new(kind: ListEntitlementsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListEntitlementsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListEntitlementsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListEntitlementsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListEntitlementsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListEntitlementsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitlementsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitlementsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitlementsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitlementsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitlementsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListEntitlementsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListEntitlementsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListEntitlementsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListEntitlementsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListEntitlementsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListEntitlementsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListEntitlementsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListEntitlementsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFlowsError {
    /// Kind of error that occurred.
    pub kind: ListFlowsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFlows` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFlowsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFlowsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFlowsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListFlowsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListFlowsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListFlowsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListFlowsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFlowsError {
    fn code(&self) -> Option<&str> {
        ListFlowsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFlowsError {
    /// Creates a new `ListFlowsError`.
    pub fn new(kind: ListFlowsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFlowsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFlowsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFlowsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFlowsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFlowsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListFlowsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListFlowsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFlowsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFlowsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFlowsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFlowsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, ListFlowsErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for ListFlowsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFlowsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListFlowsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListFlowsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListFlowsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListFlowsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOfferingsError {
    /// Kind of error that occurred.
    pub kind: ListOfferingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOfferings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOfferingsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOfferingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOfferingsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListOfferingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOfferingsError {
    fn code(&self) -> Option<&str> {
        ListOfferingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOfferingsError {
    /// Creates a new `ListOfferingsError`.
    pub fn new(kind: ListOfferingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOfferingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOfferingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOfferingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOfferingsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, ListOfferingsErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOfferingsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOfferingsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListOfferingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOfferingsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListOfferingsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListOfferingsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListOfferingsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListOfferingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListReservations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListReservationsError {
    /// Kind of error that occurred.
    pub kind: ListReservationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListReservations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListReservationsErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListReservationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListReservationsErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            ListReservationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListReservationsError {
    fn code(&self) -> Option<&str> {
        ListReservationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListReservationsError {
    /// Creates a new `ListReservationsError`.
    pub fn new(kind: ListReservationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListReservationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListReservationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListReservationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListReservationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `ListReservationsErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListReservationsErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for ListReservationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListReservationsErrorKind::BadRequestException(_inner) => Some(_inner),
            ListReservationsErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListReservationsErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            ListReservationsErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            ListReservationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::NotFoundException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PurchaseOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PurchaseOfferingError {
    /// Kind of error that occurred.
    pub kind: PurchaseOfferingErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PurchaseOffering` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PurchaseOfferingErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PurchaseOfferingError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PurchaseOfferingErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            PurchaseOfferingErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PurchaseOfferingError {
    fn code(&self) -> Option<&str> {
        PurchaseOfferingError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PurchaseOfferingError {
    /// Creates a new `PurchaseOfferingError`.
    pub fn new(kind: PurchaseOfferingErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PurchaseOfferingError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PurchaseOfferingErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PurchaseOfferingError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PurchaseOfferingErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, PurchaseOfferingErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `PurchaseOfferingErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            PurchaseOfferingErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for PurchaseOfferingError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PurchaseOfferingErrorKind::BadRequestException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::ForbiddenException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::NotFoundException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            PurchaseOfferingErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveFlowMediaStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveFlowMediaStreamError {
    /// Kind of error that occurred.
    pub kind: RemoveFlowMediaStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveFlowMediaStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveFlowMediaStreamErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveFlowMediaStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveFlowMediaStreamErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveFlowMediaStreamErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RemoveFlowMediaStreamErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RemoveFlowMediaStreamErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveFlowMediaStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RemoveFlowMediaStreamErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveFlowMediaStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveFlowMediaStreamError {
    fn code(&self) -> Option<&str> {
        RemoveFlowMediaStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveFlowMediaStreamError {
    /// Creates a new `RemoveFlowMediaStreamError`.
    pub fn new(kind: RemoveFlowMediaStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveFlowMediaStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveFlowMediaStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveFlowMediaStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveFlowMediaStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveFlowMediaStreamErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowMediaStreamErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowMediaStreamErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowMediaStreamErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowMediaStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowMediaStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowMediaStreamErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowMediaStreamErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowMediaStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowMediaStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowMediaStreamErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowMediaStreamErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveFlowMediaStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveFlowMediaStreamErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveFlowMediaStreamErrorKind::ForbiddenException(_inner) => Some(_inner),
            RemoveFlowMediaStreamErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RemoveFlowMediaStreamErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveFlowMediaStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RemoveFlowMediaStreamErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveFlowMediaStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveFlowOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveFlowOutputError {
    /// Kind of error that occurred.
    pub kind: RemoveFlowOutputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveFlowOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveFlowOutputErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveFlowOutputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveFlowOutputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveFlowOutputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RemoveFlowOutputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RemoveFlowOutputErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveFlowOutputErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RemoveFlowOutputErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveFlowOutputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveFlowOutputError {
    fn code(&self) -> Option<&str> {
        RemoveFlowOutputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveFlowOutputError {
    /// Creates a new `RemoveFlowOutputError`.
    pub fn new(kind: RemoveFlowOutputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveFlowOutputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveFlowOutputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveFlowOutputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveFlowOutputErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveFlowOutputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowOutputErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowOutputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, RemoveFlowOutputErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `RemoveFlowOutputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowOutputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowOutputErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RemoveFlowOutputErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `RemoveFlowOutputErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowOutputErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowOutputErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowOutputErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveFlowOutputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveFlowOutputErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveFlowOutputErrorKind::ForbiddenException(_inner) => Some(_inner),
            RemoveFlowOutputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RemoveFlowOutputErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveFlowOutputErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RemoveFlowOutputErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveFlowOutputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveFlowSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveFlowSourceError {
    /// Kind of error that occurred.
    pub kind: RemoveFlowSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveFlowSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveFlowSourceErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveFlowSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveFlowSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveFlowSourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RemoveFlowSourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RemoveFlowSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveFlowSourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RemoveFlowSourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveFlowSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveFlowSourceError {
    fn code(&self) -> Option<&str> {
        RemoveFlowSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveFlowSourceError {
    /// Creates a new `RemoveFlowSourceError`.
    pub fn new(kind: RemoveFlowSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveFlowSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveFlowSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveFlowSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveFlowSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveFlowSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowSourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowSourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, RemoveFlowSourceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `RemoveFlowSourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowSourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, RemoveFlowSourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `RemoveFlowSourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowSourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowSourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowSourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveFlowSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveFlowSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveFlowSourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            RemoveFlowSourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RemoveFlowSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveFlowSourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RemoveFlowSourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveFlowSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RemoveFlowVpcInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RemoveFlowVpcInterfaceError {
    /// Kind of error that occurred.
    pub kind: RemoveFlowVpcInterfaceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RemoveFlowVpcInterface` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RemoveFlowVpcInterfaceErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RemoveFlowVpcInterfaceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RemoveFlowVpcInterfaceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RemoveFlowVpcInterfaceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RemoveFlowVpcInterfaceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RemoveFlowVpcInterfaceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RemoveFlowVpcInterfaceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RemoveFlowVpcInterfaceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RemoveFlowVpcInterfaceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RemoveFlowVpcInterfaceError {
    fn code(&self) -> Option<&str> {
        RemoveFlowVpcInterfaceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RemoveFlowVpcInterfaceError {
    /// Creates a new `RemoveFlowVpcInterfaceError`.
    pub fn new(kind: RemoveFlowVpcInterfaceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RemoveFlowVpcInterfaceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RemoveFlowVpcInterfaceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RemoveFlowVpcInterfaceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RemoveFlowVpcInterfaceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RemoveFlowVpcInterfaceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowVpcInterfaceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowVpcInterfaceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowVpcInterfaceErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowVpcInterfaceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowVpcInterfaceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowVpcInterfaceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowVpcInterfaceErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowVpcInterfaceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowVpcInterfaceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RemoveFlowVpcInterfaceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RemoveFlowVpcInterfaceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RemoveFlowVpcInterfaceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RemoveFlowVpcInterfaceErrorKind::BadRequestException(_inner) => Some(_inner),
            RemoveFlowVpcInterfaceErrorKind::ForbiddenException(_inner) => Some(_inner),
            RemoveFlowVpcInterfaceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RemoveFlowVpcInterfaceErrorKind::NotFoundException(_inner) => Some(_inner),
            RemoveFlowVpcInterfaceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RemoveFlowVpcInterfaceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RemoveFlowVpcInterfaceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RevokeFlowEntitlement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RevokeFlowEntitlementError {
    /// Kind of error that occurred.
    pub kind: RevokeFlowEntitlementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RevokeFlowEntitlement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RevokeFlowEntitlementErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RevokeFlowEntitlementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RevokeFlowEntitlementErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            RevokeFlowEntitlementErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            RevokeFlowEntitlementErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            RevokeFlowEntitlementErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            RevokeFlowEntitlementErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            RevokeFlowEntitlementErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            RevokeFlowEntitlementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RevokeFlowEntitlementError {
    fn code(&self) -> Option<&str> {
        RevokeFlowEntitlementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RevokeFlowEntitlementError {
    /// Creates a new `RevokeFlowEntitlementError`.
    pub fn new(kind: RevokeFlowEntitlementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RevokeFlowEntitlementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RevokeFlowEntitlementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RevokeFlowEntitlementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RevokeFlowEntitlementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RevokeFlowEntitlementErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeFlowEntitlementErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeFlowEntitlementErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeFlowEntitlementErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeFlowEntitlementErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeFlowEntitlementErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeFlowEntitlementErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeFlowEntitlementErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeFlowEntitlementErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeFlowEntitlementErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `RevokeFlowEntitlementErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            RevokeFlowEntitlementErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for RevokeFlowEntitlementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RevokeFlowEntitlementErrorKind::BadRequestException(_inner) => Some(_inner),
            RevokeFlowEntitlementErrorKind::ForbiddenException(_inner) => Some(_inner),
            RevokeFlowEntitlementErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            RevokeFlowEntitlementErrorKind::NotFoundException(_inner) => Some(_inner),
            RevokeFlowEntitlementErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            RevokeFlowEntitlementErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            RevokeFlowEntitlementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartFlowError {
    /// Kind of error that occurred.
    pub kind: StartFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartFlowErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StartFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartFlowError {
    fn code(&self) -> Option<&str> {
        StartFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartFlowError {
    /// Creates a new `StartFlowError`.
    pub fn new(kind: StartFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFlowErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StartFlowErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, StartFlowErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for StartFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            StartFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            StartFlowErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StartFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            StartFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StartFlowErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StartFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopFlowError {
    /// Kind of error that occurred.
    pub kind: StopFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopFlowErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            StopFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopFlowError {
    fn code(&self) -> Option<&str> {
        StopFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopFlowError {
    /// Creates a new `StopFlowError`.
    pub fn new(kind: StopFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFlowErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            StopFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `StopFlowErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, StopFlowErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for StopFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            StopFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            StopFlowErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            StopFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            StopFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            StopFlowErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            StopFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::NotFoundException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFlowError {
    /// Kind of error that occurred.
    pub kind: UpdateFlowErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFlow` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFlowErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFlowError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFlowErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFlowErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFlowError {
    fn code(&self) -> Option<&str> {
        UpdateFlowError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFlowError {
    /// Creates a new `UpdateFlowError`.
    pub fn new(kind: UpdateFlowErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFlowError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFlowErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFlowError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFlowErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::BadRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowErrorKind::TooManyRequestsException(_))
    }
}
impl std::error::Error for UpdateFlowError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFlowErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateFlowErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFlowErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFlowErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateFlowErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFlowErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFlowEntitlement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFlowEntitlementError {
    /// Kind of error that occurred.
    pub kind: UpdateFlowEntitlementErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFlowEntitlement` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFlowEntitlementErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFlowEntitlementError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFlowEntitlementErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFlowEntitlementErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateFlowEntitlementErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFlowEntitlementErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFlowEntitlementErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateFlowEntitlementErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFlowEntitlementErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFlowEntitlementError {
    fn code(&self) -> Option<&str> {
        UpdateFlowEntitlementError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFlowEntitlementError {
    /// Creates a new `UpdateFlowEntitlementError`.
    pub fn new(kind: UpdateFlowEntitlementErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFlowEntitlementError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFlowEntitlementErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFlowEntitlementError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFlowEntitlementErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFlowEntitlementErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowEntitlementErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowEntitlementErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowEntitlementErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowEntitlementErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowEntitlementErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowEntitlementErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowEntitlementErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowEntitlementErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowEntitlementErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowEntitlementErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowEntitlementErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFlowEntitlementError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFlowEntitlementErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFlowEntitlementErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateFlowEntitlementErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFlowEntitlementErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFlowEntitlementErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateFlowEntitlementErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFlowEntitlementErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFlowMediaStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFlowMediaStreamError {
    /// Kind of error that occurred.
    pub kind: UpdateFlowMediaStreamErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFlowMediaStream` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFlowMediaStreamErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFlowMediaStreamError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFlowMediaStreamErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFlowMediaStreamErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateFlowMediaStreamErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFlowMediaStreamErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFlowMediaStreamErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateFlowMediaStreamErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFlowMediaStreamErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFlowMediaStreamError {
    fn code(&self) -> Option<&str> {
        UpdateFlowMediaStreamError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFlowMediaStreamError {
    /// Creates a new `UpdateFlowMediaStreamError`.
    pub fn new(kind: UpdateFlowMediaStreamErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFlowMediaStreamError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFlowMediaStreamErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFlowMediaStreamError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFlowMediaStreamErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFlowMediaStreamErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowMediaStreamErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowMediaStreamErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowMediaStreamErrorKind::ForbiddenException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowMediaStreamErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowMediaStreamErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowMediaStreamErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowMediaStreamErrorKind::NotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowMediaStreamErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowMediaStreamErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowMediaStreamErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowMediaStreamErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFlowMediaStreamError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFlowMediaStreamErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFlowMediaStreamErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateFlowMediaStreamErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFlowMediaStreamErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFlowMediaStreamErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateFlowMediaStreamErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFlowMediaStreamErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFlowOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFlowOutputError {
    /// Kind of error that occurred.
    pub kind: UpdateFlowOutputErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFlowOutput` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFlowOutputErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFlowOutputError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFlowOutputErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFlowOutputErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateFlowOutputErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFlowOutputErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFlowOutputErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateFlowOutputErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFlowOutputErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFlowOutputError {
    fn code(&self) -> Option<&str> {
        UpdateFlowOutputError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFlowOutputError {
    /// Creates a new `UpdateFlowOutputError`.
    pub fn new(kind: UpdateFlowOutputErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFlowOutputError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFlowOutputErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFlowOutputError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFlowOutputErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFlowOutputErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowOutputErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowOutputErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowOutputErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowOutputErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowOutputErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowOutputErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowOutputErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowOutputErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowOutputErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowOutputErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowOutputErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFlowOutputError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFlowOutputErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFlowOutputErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateFlowOutputErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFlowOutputErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFlowOutputErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateFlowOutputErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFlowOutputErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFlowSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFlowSourceError {
    /// Kind of error that occurred.
    pub kind: UpdateFlowSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFlowSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFlowSourceErrorKind {
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    BadRequestException(crate::error::BadRequestException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ForbiddenException(crate::error::ForbiddenException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    InternalServerErrorException(crate::error::InternalServerErrorException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    NotFoundException(crate::error::NotFoundException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    ServiceUnavailableException(crate::error::ServiceUnavailableException),
    /// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
    TooManyRequestsException(crate::error::TooManyRequestsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFlowSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFlowSourceErrorKind::BadRequestException(_inner) => _inner.fmt(f),
            UpdateFlowSourceErrorKind::ForbiddenException(_inner) => _inner.fmt(f),
            UpdateFlowSourceErrorKind::InternalServerErrorException(_inner) => _inner.fmt(f),
            UpdateFlowSourceErrorKind::NotFoundException(_inner) => _inner.fmt(f),
            UpdateFlowSourceErrorKind::ServiceUnavailableException(_inner) => _inner.fmt(f),
            UpdateFlowSourceErrorKind::TooManyRequestsException(_inner) => _inner.fmt(f),
            UpdateFlowSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFlowSourceError {
    fn code(&self) -> Option<&str> {
        UpdateFlowSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFlowSourceError {
    /// Creates a new `UpdateFlowSourceError`.
    pub fn new(kind: UpdateFlowSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFlowSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFlowSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFlowSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFlowSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFlowSourceErrorKind::BadRequestException`.
    pub fn is_bad_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowSourceErrorKind::BadRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowSourceErrorKind::ForbiddenException`.
    pub fn is_forbidden_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowSourceErrorKind::ForbiddenException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowSourceErrorKind::InternalServerErrorException`.
    pub fn is_internal_server_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowSourceErrorKind::InternalServerErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowSourceErrorKind::NotFoundException`.
    pub fn is_not_found_exception(&self) -> bool {
        matches!(&self.kind, UpdateFlowSourceErrorKind::NotFoundException(_))
    }
    /// Returns `true` if the error kind is `UpdateFlowSourceErrorKind::ServiceUnavailableException`.
    pub fn is_service_unavailable_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowSourceErrorKind::ServiceUnavailableException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFlowSourceErrorKind::TooManyRequestsException`.
    pub fn is_too_many_requests_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFlowSourceErrorKind::TooManyRequestsException(_)
        )
    }
}
impl std::error::Error for UpdateFlowSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFlowSourceErrorKind::BadRequestException(_inner) => Some(_inner),
            UpdateFlowSourceErrorKind::ForbiddenException(_inner) => Some(_inner),
            UpdateFlowSourceErrorKind::InternalServerErrorException(_inner) => Some(_inner),
            UpdateFlowSourceErrorKind::NotFoundException(_inner) => Some(_inner),
            UpdateFlowSourceErrorKind::ServiceUnavailableException(_inner) => Some(_inner),
            UpdateFlowSourceErrorKind::TooManyRequestsException(_inner) => Some(_inner),
            UpdateFlowSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyRequestsException {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyRequestsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TooManyRequestsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyRequestsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyRequestsException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyRequestsException {}
/// See [`TooManyRequestsException`](crate::error::TooManyRequestsException)
pub mod too_many_requests_exception {
    /// A builder for [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyRequestsException`](crate::error::TooManyRequestsException)
        pub fn build(self) -> crate::error::TooManyRequestsException {
            crate::error::TooManyRequestsException {
                message: self.message,
            }
        }
    }
}
impl TooManyRequestsException {
    /// Creates a new builder-style object to manufacture [`TooManyRequestsException`](crate::error::TooManyRequestsException)
    pub fn builder() -> crate::error::too_many_requests_exception::Builder {
        crate::error::too_many_requests_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceUnavailableException {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceUnavailableException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceUnavailableException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceUnavailableException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceUnavailableException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceUnavailableException {}
/// See [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
pub mod service_unavailable_exception {
    /// A builder for [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
        pub fn build(self) -> crate::error::ServiceUnavailableException {
            crate::error::ServiceUnavailableException {
                message: self.message,
            }
        }
    }
}
impl ServiceUnavailableException {
    /// Creates a new builder-style object to manufacture [`ServiceUnavailableException`](crate::error::ServiceUnavailableException)
    pub fn builder() -> crate::error::service_unavailable_exception::Builder {
        crate::error::service_unavailable_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NotFoundException {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl NotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for NotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "NotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for NotFoundException {}
/// See [`NotFoundException`](crate::error::NotFoundException)
pub mod not_found_exception {
    /// A builder for [`NotFoundException`](crate::error::NotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`NotFoundException`](crate::error::NotFoundException)
        pub fn build(self) -> crate::error::NotFoundException {
            crate::error::NotFoundException {
                message: self.message,
            }
        }
    }
}
impl NotFoundException {
    /// Creates a new builder-style object to manufacture [`NotFoundException`](crate::error::NotFoundException)
    pub fn builder() -> crate::error::not_found_exception::Builder {
        crate::error::not_found_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerErrorException {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerErrorException {}
/// See [`InternalServerErrorException`](crate::error::InternalServerErrorException)
pub mod internal_server_error_exception {
    /// A builder for [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerErrorException`](crate::error::InternalServerErrorException)
        pub fn build(self) -> crate::error::InternalServerErrorException {
            crate::error::InternalServerErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServerErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServerErrorException`](crate::error::InternalServerErrorException)
    pub fn builder() -> crate::error::internal_server_error_exception::Builder {
        crate::error::internal_server_error_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ForbiddenException {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ForbiddenException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ForbiddenException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ForbiddenException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ForbiddenException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ForbiddenException {}
/// See [`ForbiddenException`](crate::error::ForbiddenException)
pub mod forbidden_exception {
    /// A builder for [`ForbiddenException`](crate::error::ForbiddenException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ForbiddenException`](crate::error::ForbiddenException)
        pub fn build(self) -> crate::error::ForbiddenException {
            crate::error::ForbiddenException {
                message: self.message,
            }
        }
    }
}
impl ForbiddenException {
    /// Creates a new builder-style object to manufacture [`ForbiddenException`](crate::error::ForbiddenException)
    pub fn builder() -> crate::error::forbidden_exception::Builder {
        crate::error::forbidden_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BadRequestException {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BadRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl BadRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for BadRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "BadRequestException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for BadRequestException {}
/// See [`BadRequestException`](crate::error::BadRequestException)
pub mod bad_request_exception {
    /// A builder for [`BadRequestException`](crate::error::BadRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`BadRequestException`](crate::error::BadRequestException)
        pub fn build(self) -> crate::error::BadRequestException {
            crate::error::BadRequestException {
                message: self.message,
            }
        }
    }
}
impl BadRequestException {
    /// Creates a new builder-style object to manufacture [`BadRequestException`](crate::error::BadRequestException)
    pub fn builder() -> crate::error::bad_request_exception::Builder {
        crate::error::bad_request_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantFlowEntitlements420Exception {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for GrantFlowEntitlements420Exception {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantFlowEntitlements420Exception");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl GrantFlowEntitlements420Exception {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for GrantFlowEntitlements420Exception {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "GrantFlowEntitlements420Exception")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for GrantFlowEntitlements420Exception {}
/// See [`GrantFlowEntitlements420Exception`](crate::error::GrantFlowEntitlements420Exception)
pub mod grant_flow_entitlements420_exception {
    /// A builder for [`GrantFlowEntitlements420Exception`](crate::error::GrantFlowEntitlements420Exception)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantFlowEntitlements420Exception`](crate::error::GrantFlowEntitlements420Exception)
        pub fn build(self) -> crate::error::GrantFlowEntitlements420Exception {
            crate::error::GrantFlowEntitlements420Exception {
                message: self.message,
            }
        }
    }
}
impl GrantFlowEntitlements420Exception {
    /// Creates a new builder-style object to manufacture [`GrantFlowEntitlements420Exception`](crate::error::GrantFlowEntitlements420Exception)
    pub fn builder() -> crate::error::grant_flow_entitlements420_exception::Builder {
        crate::error::grant_flow_entitlements420_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlow420Exception {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for CreateFlow420Exception {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlow420Exception");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl CreateFlow420Exception {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for CreateFlow420Exception {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "CreateFlow420Exception")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for CreateFlow420Exception {}
/// See [`CreateFlow420Exception`](crate::error::CreateFlow420Exception)
pub mod create_flow420_exception {
    /// A builder for [`CreateFlow420Exception`](crate::error::CreateFlow420Exception)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlow420Exception`](crate::error::CreateFlow420Exception)
        pub fn build(self) -> crate::error::CreateFlow420Exception {
            crate::error::CreateFlow420Exception {
                message: self.message,
            }
        }
    }
}
impl CreateFlow420Exception {
    /// Creates a new builder-style object to manufacture [`CreateFlow420Exception`](crate::error::CreateFlow420Exception)
    pub fn builder() -> crate::error::create_flow420_exception::Builder {
        crate::error::create_flow420_exception::Builder::default()
    }
}

/// Exception raised by AWS Elemental MediaConnect. See the error message and documentation for the operation for more information on the cause of this exception.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowOutputs420Exception {
    /// The error message returned by AWS Elemental MediaConnect.
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddFlowOutputs420Exception {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowOutputs420Exception");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AddFlowOutputs420Exception {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AddFlowOutputs420Exception {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AddFlowOutputs420Exception")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for AddFlowOutputs420Exception {}
/// See [`AddFlowOutputs420Exception`](crate::error::AddFlowOutputs420Exception)
pub mod add_flow_outputs420_exception {
    /// A builder for [`AddFlowOutputs420Exception`](crate::error::AddFlowOutputs420Exception)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// The error message returned by AWS Elemental MediaConnect.
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowOutputs420Exception`](crate::error::AddFlowOutputs420Exception)
        pub fn build(self) -> crate::error::AddFlowOutputs420Exception {
            crate::error::AddFlowOutputs420Exception {
                message: self.message,
            }
        }
    }
}
impl AddFlowOutputs420Exception {
    /// Creates a new builder-style object to manufacture [`AddFlowOutputs420Exception`](crate::error::AddFlowOutputs420Exception)
    pub fn builder() -> crate::error::add_flow_outputs420_exception::Builder {
        crate::error::add_flow_outputs420_exception::Builder::default()
    }
}
