// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AddFlowMediaStreams`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_flow_media_streams`](crate::client::Client::add_flow_media_streams).
///
/// See [`crate::client::fluent_builders::AddFlowMediaStreams`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddFlowMediaStreams {
    _private: (),
}
impl AddFlowMediaStreams {
    /// Creates a new builder-style object to manufacture [`AddFlowMediaStreamsInput`](crate::input::AddFlowMediaStreamsInput)
    pub fn builder() -> crate::input::add_flow_media_streams_input::Builder {
        crate::input::add_flow_media_streams_input::Builder::default()
    }
    /// Creates a new `AddFlowMediaStreams` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddFlowMediaStreams {
    type Output = std::result::Result<
        crate::output::AddFlowMediaStreamsOutput,
        crate::error::AddFlowMediaStreamsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_flow_media_streams_error(response)
        } else {
            crate::operation_deser::parse_add_flow_media_streams_response(response)
        }
    }
}

/// Operation shape for `AddFlowOutputs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_flow_outputs`](crate::client::Client::add_flow_outputs).
///
/// See [`crate::client::fluent_builders::AddFlowOutputs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddFlowOutputs {
    _private: (),
}
impl AddFlowOutputs {
    /// Creates a new builder-style object to manufacture [`AddFlowOutputsInput`](crate::input::AddFlowOutputsInput)
    pub fn builder() -> crate::input::add_flow_outputs_input::Builder {
        crate::input::add_flow_outputs_input::Builder::default()
    }
    /// Creates a new `AddFlowOutputs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddFlowOutputs {
    type Output =
        std::result::Result<crate::output::AddFlowOutputsOutput, crate::error::AddFlowOutputsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_flow_outputs_error(response)
        } else {
            crate::operation_deser::parse_add_flow_outputs_response(response)
        }
    }
}

/// Operation shape for `AddFlowSources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_flow_sources`](crate::client::Client::add_flow_sources).
///
/// See [`crate::client::fluent_builders::AddFlowSources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddFlowSources {
    _private: (),
}
impl AddFlowSources {
    /// Creates a new builder-style object to manufacture [`AddFlowSourcesInput`](crate::input::AddFlowSourcesInput)
    pub fn builder() -> crate::input::add_flow_sources_input::Builder {
        crate::input::add_flow_sources_input::Builder::default()
    }
    /// Creates a new `AddFlowSources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddFlowSources {
    type Output =
        std::result::Result<crate::output::AddFlowSourcesOutput, crate::error::AddFlowSourcesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_flow_sources_error(response)
        } else {
            crate::operation_deser::parse_add_flow_sources_response(response)
        }
    }
}

/// Operation shape for `AddFlowVpcInterfaces`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`add_flow_vpc_interfaces`](crate::client::Client::add_flow_vpc_interfaces).
///
/// See [`crate::client::fluent_builders::AddFlowVpcInterfaces`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AddFlowVpcInterfaces {
    _private: (),
}
impl AddFlowVpcInterfaces {
    /// Creates a new builder-style object to manufacture [`AddFlowVpcInterfacesInput`](crate::input::AddFlowVpcInterfacesInput)
    pub fn builder() -> crate::input::add_flow_vpc_interfaces_input::Builder {
        crate::input::add_flow_vpc_interfaces_input::Builder::default()
    }
    /// Creates a new `AddFlowVpcInterfaces` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AddFlowVpcInterfaces {
    type Output = std::result::Result<
        crate::output::AddFlowVpcInterfacesOutput,
        crate::error::AddFlowVpcInterfacesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_add_flow_vpc_interfaces_error(response)
        } else {
            crate::operation_deser::parse_add_flow_vpc_interfaces_response(response)
        }
    }
}

/// Operation shape for `CreateFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_flow`](crate::client::Client::create_flow).
///
/// See [`crate::client::fluent_builders::CreateFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFlow {
    _private: (),
}
impl CreateFlow {
    /// Creates a new builder-style object to manufacture [`CreateFlowInput`](crate::input::CreateFlowInput)
    pub fn builder() -> crate::input::create_flow_input::Builder {
        crate::input::create_flow_input::Builder::default()
    }
    /// Creates a new `CreateFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFlow {
    type Output =
        std::result::Result<crate::output::CreateFlowOutput, crate::error::CreateFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_create_flow_error(response)
        } else {
            crate::operation_deser::parse_create_flow_response(response)
        }
    }
}

/// Operation shape for `DeleteFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_flow`](crate::client::Client::delete_flow).
///
/// See [`crate::client::fluent_builders::DeleteFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFlow {
    _private: (),
}
impl DeleteFlow {
    /// Creates a new builder-style object to manufacture [`DeleteFlowInput`](crate::input::DeleteFlowInput)
    pub fn builder() -> crate::input::delete_flow_input::Builder {
        crate::input::delete_flow_input::Builder::default()
    }
    /// Creates a new `DeleteFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFlow {
    type Output =
        std::result::Result<crate::output::DeleteFlowOutput, crate::error::DeleteFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_flow_error(response)
        } else {
            crate::operation_deser::parse_delete_flow_response(response)
        }
    }
}

/// Operation shape for `DescribeFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_flow`](crate::client::Client::describe_flow).
///
/// See [`crate::client::fluent_builders::DescribeFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeFlow {
    _private: (),
}
impl DescribeFlow {
    /// Creates a new builder-style object to manufacture [`DescribeFlowInput`](crate::input::DescribeFlowInput)
    pub fn builder() -> crate::input::describe_flow_input::Builder {
        crate::input::describe_flow_input::Builder::default()
    }
    /// Creates a new `DescribeFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeFlow {
    type Output =
        std::result::Result<crate::output::DescribeFlowOutput, crate::error::DescribeFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_flow_error(response)
        } else {
            crate::operation_deser::parse_describe_flow_response(response)
        }
    }
}

/// Operation shape for `DescribeOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_offering`](crate::client::Client::describe_offering).
///
/// See [`crate::client::fluent_builders::DescribeOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOffering {
    _private: (),
}
impl DescribeOffering {
    /// Creates a new builder-style object to manufacture [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
    pub fn builder() -> crate::input::describe_offering_input::Builder {
        crate::input::describe_offering_input::Builder::default()
    }
    /// Creates a new `DescribeOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOffering {
    type Output = std::result::Result<
        crate::output::DescribeOfferingOutput,
        crate::error::DescribeOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_offering_error(response)
        } else {
            crate::operation_deser::parse_describe_offering_response(response)
        }
    }
}

/// Operation shape for `DescribeReservation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_reservation`](crate::client::Client::describe_reservation).
///
/// See [`crate::client::fluent_builders::DescribeReservation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeReservation {
    _private: (),
}
impl DescribeReservation {
    /// Creates a new builder-style object to manufacture [`DescribeReservationInput`](crate::input::DescribeReservationInput)
    pub fn builder() -> crate::input::describe_reservation_input::Builder {
        crate::input::describe_reservation_input::Builder::default()
    }
    /// Creates a new `DescribeReservation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeReservation {
    type Output = std::result::Result<
        crate::output::DescribeReservationOutput,
        crate::error::DescribeReservationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_reservation_error(response)
        } else {
            crate::operation_deser::parse_describe_reservation_response(response)
        }
    }
}

/// Operation shape for `GrantFlowEntitlements`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`grant_flow_entitlements`](crate::client::Client::grant_flow_entitlements).
///
/// See [`crate::client::fluent_builders::GrantFlowEntitlements`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GrantFlowEntitlements {
    _private: (),
}
impl GrantFlowEntitlements {
    /// Creates a new builder-style object to manufacture [`GrantFlowEntitlementsInput`](crate::input::GrantFlowEntitlementsInput)
    pub fn builder() -> crate::input::grant_flow_entitlements_input::Builder {
        crate::input::grant_flow_entitlements_input::Builder::default()
    }
    /// Creates a new `GrantFlowEntitlements` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GrantFlowEntitlements {
    type Output = std::result::Result<
        crate::output::GrantFlowEntitlementsOutput,
        crate::error::GrantFlowEntitlementsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_grant_flow_entitlements_error(response)
        } else {
            crate::operation_deser::parse_grant_flow_entitlements_response(response)
        }
    }
}

/// Operation shape for `ListEntitlements`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entitlements`](crate::client::Client::list_entitlements).
///
/// See [`crate::client::fluent_builders::ListEntitlements`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntitlements {
    _private: (),
}
impl ListEntitlements {
    /// Creates a new builder-style object to manufacture [`ListEntitlementsInput`](crate::input::ListEntitlementsInput)
    pub fn builder() -> crate::input::list_entitlements_input::Builder {
        crate::input::list_entitlements_input::Builder::default()
    }
    /// Creates a new `ListEntitlements` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntitlements {
    type Output = std::result::Result<
        crate::output::ListEntitlementsOutput,
        crate::error::ListEntitlementsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entitlements_error(response)
        } else {
            crate::operation_deser::parse_list_entitlements_response(response)
        }
    }
}

/// Operation shape for `ListFlows`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_flows`](crate::client::Client::list_flows).
///
/// See [`crate::client::fluent_builders::ListFlows`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFlows {
    _private: (),
}
impl ListFlows {
    /// Creates a new builder-style object to manufacture [`ListFlowsInput`](crate::input::ListFlowsInput)
    pub fn builder() -> crate::input::list_flows_input::Builder {
        crate::input::list_flows_input::Builder::default()
    }
    /// Creates a new `ListFlows` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFlows {
    type Output = std::result::Result<crate::output::ListFlowsOutput, crate::error::ListFlowsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_flows_error(response)
        } else {
            crate::operation_deser::parse_list_flows_response(response)
        }
    }
}

/// Operation shape for `ListOfferings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_offerings`](crate::client::Client::list_offerings).
///
/// See [`crate::client::fluent_builders::ListOfferings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOfferings {
    _private: (),
}
impl ListOfferings {
    /// Creates a new builder-style object to manufacture [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    pub fn builder() -> crate::input::list_offerings_input::Builder {
        crate::input::list_offerings_input::Builder::default()
    }
    /// Creates a new `ListOfferings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOfferings {
    type Output =
        std::result::Result<crate::output::ListOfferingsOutput, crate::error::ListOfferingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_offerings_error(response)
        } else {
            crate::operation_deser::parse_list_offerings_response(response)
        }
    }
}

/// Operation shape for `ListReservations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_reservations`](crate::client::Client::list_reservations).
///
/// See [`crate::client::fluent_builders::ListReservations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListReservations {
    _private: (),
}
impl ListReservations {
    /// Creates a new builder-style object to manufacture [`ListReservationsInput`](crate::input::ListReservationsInput)
    pub fn builder() -> crate::input::list_reservations_input::Builder {
        crate::input::list_reservations_input::Builder::default()
    }
    /// Creates a new `ListReservations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListReservations {
    type Output = std::result::Result<
        crate::output::ListReservationsOutput,
        crate::error::ListReservationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_reservations_error(response)
        } else {
            crate::operation_deser::parse_list_reservations_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PurchaseOffering`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`purchase_offering`](crate::client::Client::purchase_offering).
///
/// See [`crate::client::fluent_builders::PurchaseOffering`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PurchaseOffering {
    _private: (),
}
impl PurchaseOffering {
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    pub fn builder() -> crate::input::purchase_offering_input::Builder {
        crate::input::purchase_offering_input::Builder::default()
    }
    /// Creates a new `PurchaseOffering` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PurchaseOffering {
    type Output = std::result::Result<
        crate::output::PurchaseOfferingOutput,
        crate::error::PurchaseOfferingError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 201 {
            crate::operation_deser::parse_purchase_offering_error(response)
        } else {
            crate::operation_deser::parse_purchase_offering_response(response)
        }
    }
}

/// Operation shape for `RemoveFlowMediaStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_flow_media_stream`](crate::client::Client::remove_flow_media_stream).
///
/// See [`crate::client::fluent_builders::RemoveFlowMediaStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFlowMediaStream {
    _private: (),
}
impl RemoveFlowMediaStream {
    /// Creates a new builder-style object to manufacture [`RemoveFlowMediaStreamInput`](crate::input::RemoveFlowMediaStreamInput)
    pub fn builder() -> crate::input::remove_flow_media_stream_input::Builder {
        crate::input::remove_flow_media_stream_input::Builder::default()
    }
    /// Creates a new `RemoveFlowMediaStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFlowMediaStream {
    type Output = std::result::Result<
        crate::output::RemoveFlowMediaStreamOutput,
        crate::error::RemoveFlowMediaStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_flow_media_stream_error(response)
        } else {
            crate::operation_deser::parse_remove_flow_media_stream_response(response)
        }
    }
}

/// Operation shape for `RemoveFlowOutput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_flow_output`](crate::client::Client::remove_flow_output).
///
/// See [`crate::client::fluent_builders::RemoveFlowOutput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFlowOutput {
    _private: (),
}
impl RemoveFlowOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFlowOutputInput`](crate::input::RemoveFlowOutputInput)
    pub fn builder() -> crate::input::remove_flow_output_input::Builder {
        crate::input::remove_flow_output_input::Builder::default()
    }
    /// Creates a new `RemoveFlowOutput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFlowOutput {
    type Output = std::result::Result<
        crate::output::RemoveFlowOutputOutput,
        crate::error::RemoveFlowOutputError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_remove_flow_output_error(response)
        } else {
            crate::operation_deser::parse_remove_flow_output_response(response)
        }
    }
}

/// Operation shape for `RemoveFlowSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_flow_source`](crate::client::Client::remove_flow_source).
///
/// See [`crate::client::fluent_builders::RemoveFlowSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFlowSource {
    _private: (),
}
impl RemoveFlowSource {
    /// Creates a new builder-style object to manufacture [`RemoveFlowSourceInput`](crate::input::RemoveFlowSourceInput)
    pub fn builder() -> crate::input::remove_flow_source_input::Builder {
        crate::input::remove_flow_source_input::Builder::default()
    }
    /// Creates a new `RemoveFlowSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFlowSource {
    type Output = std::result::Result<
        crate::output::RemoveFlowSourceOutput,
        crate::error::RemoveFlowSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_remove_flow_source_error(response)
        } else {
            crate::operation_deser::parse_remove_flow_source_response(response)
        }
    }
}

/// Operation shape for `RemoveFlowVpcInterface`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`remove_flow_vpc_interface`](crate::client::Client::remove_flow_vpc_interface).
///
/// See [`crate::client::fluent_builders::RemoveFlowVpcInterface`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RemoveFlowVpcInterface {
    _private: (),
}
impl RemoveFlowVpcInterface {
    /// Creates a new builder-style object to manufacture [`RemoveFlowVpcInterfaceInput`](crate::input::RemoveFlowVpcInterfaceInput)
    pub fn builder() -> crate::input::remove_flow_vpc_interface_input::Builder {
        crate::input::remove_flow_vpc_interface_input::Builder::default()
    }
    /// Creates a new `RemoveFlowVpcInterface` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RemoveFlowVpcInterface {
    type Output = std::result::Result<
        crate::output::RemoveFlowVpcInterfaceOutput,
        crate::error::RemoveFlowVpcInterfaceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_remove_flow_vpc_interface_error(response)
        } else {
            crate::operation_deser::parse_remove_flow_vpc_interface_response(response)
        }
    }
}

/// Operation shape for `RevokeFlowEntitlement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`revoke_flow_entitlement`](crate::client::Client::revoke_flow_entitlement).
///
/// See [`crate::client::fluent_builders::RevokeFlowEntitlement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RevokeFlowEntitlement {
    _private: (),
}
impl RevokeFlowEntitlement {
    /// Creates a new builder-style object to manufacture [`RevokeFlowEntitlementInput`](crate::input::RevokeFlowEntitlementInput)
    pub fn builder() -> crate::input::revoke_flow_entitlement_input::Builder {
        crate::input::revoke_flow_entitlement_input::Builder::default()
    }
    /// Creates a new `RevokeFlowEntitlement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RevokeFlowEntitlement {
    type Output = std::result::Result<
        crate::output::RevokeFlowEntitlementOutput,
        crate::error::RevokeFlowEntitlementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_revoke_flow_entitlement_error(response)
        } else {
            crate::operation_deser::parse_revoke_flow_entitlement_response(response)
        }
    }
}

/// Operation shape for `StartFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_flow`](crate::client::Client::start_flow).
///
/// See [`crate::client::fluent_builders::StartFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartFlow {
    _private: (),
}
impl StartFlow {
    /// Creates a new builder-style object to manufacture [`StartFlowInput`](crate::input::StartFlowInput)
    pub fn builder() -> crate::input::start_flow_input::Builder {
        crate::input::start_flow_input::Builder::default()
    }
    /// Creates a new `StartFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartFlow {
    type Output = std::result::Result<crate::output::StartFlowOutput, crate::error::StartFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_flow_error(response)
        } else {
            crate::operation_deser::parse_start_flow_response(response)
        }
    }
}

/// Operation shape for `StopFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_flow`](crate::client::Client::stop_flow).
///
/// See [`crate::client::fluent_builders::StopFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopFlow {
    _private: (),
}
impl StopFlow {
    /// Creates a new builder-style object to manufacture [`StopFlowInput`](crate::input::StopFlowInput)
    pub fn builder() -> crate::input::stop_flow_input::Builder {
        crate::input::stop_flow_input::Builder::default()
    }
    /// Creates a new `StopFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopFlow {
    type Output = std::result::Result<crate::output::StopFlowOutput, crate::error::StopFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_stop_flow_error(response)
        } else {
            crate::operation_deser::parse_stop_flow_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateFlow`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_flow`](crate::client::Client::update_flow).
///
/// See [`crate::client::fluent_builders::UpdateFlow`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFlow {
    _private: (),
}
impl UpdateFlow {
    /// Creates a new builder-style object to manufacture [`UpdateFlowInput`](crate::input::UpdateFlowInput)
    pub fn builder() -> crate::input::update_flow_input::Builder {
        crate::input::update_flow_input::Builder::default()
    }
    /// Creates a new `UpdateFlow` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFlow {
    type Output =
        std::result::Result<crate::output::UpdateFlowOutput, crate::error::UpdateFlowError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_flow_error(response)
        } else {
            crate::operation_deser::parse_update_flow_response(response)
        }
    }
}

/// Operation shape for `UpdateFlowEntitlement`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_flow_entitlement`](crate::client::Client::update_flow_entitlement).
///
/// See [`crate::client::fluent_builders::UpdateFlowEntitlement`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFlowEntitlement {
    _private: (),
}
impl UpdateFlowEntitlement {
    /// Creates a new builder-style object to manufacture [`UpdateFlowEntitlementInput`](crate::input::UpdateFlowEntitlementInput)
    pub fn builder() -> crate::input::update_flow_entitlement_input::Builder {
        crate::input::update_flow_entitlement_input::Builder::default()
    }
    /// Creates a new `UpdateFlowEntitlement` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFlowEntitlement {
    type Output = std::result::Result<
        crate::output::UpdateFlowEntitlementOutput,
        crate::error::UpdateFlowEntitlementError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_flow_entitlement_error(response)
        } else {
            crate::operation_deser::parse_update_flow_entitlement_response(response)
        }
    }
}

/// Operation shape for `UpdateFlowMediaStream`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_flow_media_stream`](crate::client::Client::update_flow_media_stream).
///
/// See [`crate::client::fluent_builders::UpdateFlowMediaStream`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFlowMediaStream {
    _private: (),
}
impl UpdateFlowMediaStream {
    /// Creates a new builder-style object to manufacture [`UpdateFlowMediaStreamInput`](crate::input::UpdateFlowMediaStreamInput)
    pub fn builder() -> crate::input::update_flow_media_stream_input::Builder {
        crate::input::update_flow_media_stream_input::Builder::default()
    }
    /// Creates a new `UpdateFlowMediaStream` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFlowMediaStream {
    type Output = std::result::Result<
        crate::output::UpdateFlowMediaStreamOutput,
        crate::error::UpdateFlowMediaStreamError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_flow_media_stream_error(response)
        } else {
            crate::operation_deser::parse_update_flow_media_stream_response(response)
        }
    }
}

/// Operation shape for `UpdateFlowOutput`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_flow_output`](crate::client::Client::update_flow_output).
///
/// See [`crate::client::fluent_builders::UpdateFlowOutput`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFlowOutput {
    _private: (),
}
impl UpdateFlowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowOutputInput`](crate::input::UpdateFlowOutputInput)
    pub fn builder() -> crate::input::update_flow_output_input::Builder {
        crate::input::update_flow_output_input::Builder::default()
    }
    /// Creates a new `UpdateFlowOutput` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFlowOutput {
    type Output = std::result::Result<
        crate::output::UpdateFlowOutputOutput,
        crate::error::UpdateFlowOutputError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_flow_output_error(response)
        } else {
            crate::operation_deser::parse_update_flow_output_response(response)
        }
    }
}

/// Operation shape for `UpdateFlowSource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_flow_source`](crate::client::Client::update_flow_source).
///
/// See [`crate::client::fluent_builders::UpdateFlowSource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFlowSource {
    _private: (),
}
impl UpdateFlowSource {
    /// Creates a new builder-style object to manufacture [`UpdateFlowSourceInput`](crate::input::UpdateFlowSourceInput)
    pub fn builder() -> crate::input::update_flow_source_input::Builder {
        crate::input::update_flow_source_input::Builder::default()
    }
    /// Creates a new `UpdateFlowSource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFlowSource {
    type Output = std::result::Result<
        crate::output::UpdateFlowSourceOutput,
        crate::error::UpdateFlowSourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_flow_source_error(response)
        } else {
            crate::operation_deser::parse_update_flow_source_response(response)
        }
    }
}
