// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddFlowMediaStreamsInput`](crate::input::AddFlowMediaStreamsInput)
pub mod add_flow_media_streams_input {
    /// A builder for [`AddFlowMediaStreamsInput`](crate::input::AddFlowMediaStreamsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_streams:
            std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `media_streams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you want to add to the flow.
        pub fn media_streams(
            mut self,
            input: impl Into<crate::model::AddMediaStreamRequest>,
        ) -> Self {
            let mut v = self.media_streams.unwrap_or_default();
            v.push(input.into());
            self.media_streams = Some(v);
            self
        }
        /// The media streams that you want to add to the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        ) -> Self {
            self.media_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowMediaStreamsInput`](crate::input::AddFlowMediaStreamsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddFlowMediaStreamsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddFlowMediaStreamsInput {
                flow_arn: self.flow_arn,
                media_streams: self.media_streams,
            })
        }
    }
}
#[doc(hidden)]
pub type AddFlowMediaStreamsInputOperationOutputAlias = crate::operation::AddFlowMediaStreams;
#[doc(hidden)]
pub type AddFlowMediaStreamsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddFlowMediaStreamsInput {
    /// Consumes the builder and constructs an Operation<[`AddFlowMediaStreams`](crate::operation::AddFlowMediaStreams)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddFlowMediaStreams,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddFlowMediaStreamsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.flow_arn;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_1, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/mediaStreams",
                FlowArn = flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddFlowMediaStreamsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddFlowMediaStreamsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_flow_media_streams(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddFlowMediaStreams::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddFlowMediaStreams",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddFlowMediaStreamsInput`](crate::input::AddFlowMediaStreamsInput)
    pub fn builder() -> crate::input::add_flow_media_streams_input::Builder {
        crate::input::add_flow_media_streams_input::Builder::default()
    }
}

/// See [`AddFlowOutputsInput`](crate::input::AddFlowOutputsInput)
pub mod add_flow_outputs_input {
    /// A builder for [`AddFlowOutputsInput`](crate::input::AddFlowOutputsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
    }
    impl Builder {
        /// The flow that you want to add outputs to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to add outputs to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// A list of outputs that you want to add.
        pub fn outputs(mut self, input: impl Into<crate::model::AddOutputRequest>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// A list of outputs that you want to add.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowOutputsInput`](crate::input::AddFlowOutputsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddFlowOutputsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddFlowOutputsInput {
                flow_arn: self.flow_arn,
                outputs: self.outputs,
            })
        }
    }
}
#[doc(hidden)]
pub type AddFlowOutputsInputOperationOutputAlias = crate::operation::AddFlowOutputs;
#[doc(hidden)]
pub type AddFlowOutputsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddFlowOutputsInput {
    /// Consumes the builder and constructs an Operation<[`AddFlowOutputs`](crate::operation::AddFlowOutputs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddFlowOutputs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddFlowOutputsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.flow_arn;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_2, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/{FlowArn}/outputs", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddFlowOutputsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddFlowOutputsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_flow_outputs(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddFlowOutputs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddFlowOutputs",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddFlowOutputsInput`](crate::input::AddFlowOutputsInput)
    pub fn builder() -> crate::input::add_flow_outputs_input::Builder {
        crate::input::add_flow_outputs_input::Builder::default()
    }
}

/// See [`AddFlowSourcesInput`](crate::input::AddFlowSourcesInput)
pub mod add_flow_sources_input {
    /// A builder for [`AddFlowSourcesInput`](crate::input::AddFlowSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
    }
    impl Builder {
        /// The flow that you want to mutate.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to mutate.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// A list of sources that you want to add.
        pub fn sources(mut self, input: impl Into<crate::model::SetSourceRequest>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// A list of sources that you want to add.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowSourcesInput`](crate::input::AddFlowSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddFlowSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddFlowSourcesInput {
                flow_arn: self.flow_arn,
                sources: self.sources,
            })
        }
    }
}
#[doc(hidden)]
pub type AddFlowSourcesInputOperationOutputAlias = crate::operation::AddFlowSources;
#[doc(hidden)]
pub type AddFlowSourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddFlowSourcesInput {
    /// Consumes the builder and constructs an Operation<[`AddFlowSources`](crate::operation::AddFlowSources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddFlowSources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddFlowSourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.flow_arn;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_3, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/{FlowArn}/source", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddFlowSourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddFlowSourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_flow_sources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddFlowSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddFlowSources",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddFlowSourcesInput`](crate::input::AddFlowSourcesInput)
    pub fn builder() -> crate::input::add_flow_sources_input::Builder {
        crate::input::add_flow_sources_input::Builder::default()
    }
}

/// See [`AddFlowVpcInterfacesInput`](crate::input::AddFlowVpcInterfacesInput)
pub mod add_flow_vpc_interfaces_input {
    /// A builder for [`AddFlowVpcInterfacesInput`](crate::input::AddFlowVpcInterfacesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_interfaces:
            std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
    }
    impl Builder {
        /// The flow that you want to mutate.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to mutate.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `vpc_interfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// A list of VPC interfaces that you want to add.
        pub fn vpc_interfaces(
            mut self,
            input: impl Into<crate::model::VpcInterfaceRequest>,
        ) -> Self {
            let mut v = self.vpc_interfaces.unwrap_or_default();
            v.push(input.into());
            self.vpc_interfaces = Some(v);
            self
        }
        /// A list of VPC interfaces that you want to add.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
        ) -> Self {
            self.vpc_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowVpcInterfacesInput`](crate::input::AddFlowVpcInterfacesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AddFlowVpcInterfacesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AddFlowVpcInterfacesInput {
                flow_arn: self.flow_arn,
                vpc_interfaces: self.vpc_interfaces,
            })
        }
    }
}
#[doc(hidden)]
pub type AddFlowVpcInterfacesInputOperationOutputAlias = crate::operation::AddFlowVpcInterfaces;
#[doc(hidden)]
pub type AddFlowVpcInterfacesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddFlowVpcInterfacesInput {
    /// Consumes the builder and constructs an Operation<[`AddFlowVpcInterfaces`](crate::operation::AddFlowVpcInterfaces)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddFlowVpcInterfaces,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddFlowVpcInterfacesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.flow_arn;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_4, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/vpcInterfaces",
                FlowArn = flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddFlowVpcInterfacesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddFlowVpcInterfacesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_add_flow_vpc_interfaces(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AddFlowVpcInterfaces::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AddFlowVpcInterfaces",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddFlowVpcInterfacesInput`](crate::input::AddFlowVpcInterfacesInput)
    pub fn builder() -> crate::input::add_flow_vpc_interfaces_input::Builder {
        crate::input::add_flow_vpc_interfaces_input::Builder::default()
    }
}

/// See [`CreateFlowInput`](crate::input::CreateFlowInput)
pub mod create_flow_input {
    /// A builder for [`CreateFlowInput`](crate::input::CreateFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) entitlements:
            std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        pub(crate) media_streams:
            std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        pub(crate) source: std::option::Option<crate::model::SetSourceRequest>,
        pub(crate) source_failover_config: std::option::Option<crate::model::FailoverConfig>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        pub(crate) vpc_interfaces:
            std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
    }
    impl Builder {
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The entitlements that you want to grant on a flow.
        pub fn entitlements(
            mut self,
            input: impl Into<crate::model::GrantEntitlementRequest>,
        ) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// The entitlements that you want to grant on a flow.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// Appends an item to `media_streams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
        pub fn media_streams(
            mut self,
            input: impl Into<crate::model::AddMediaStreamRequest>,
        ) -> Self {
            let mut v = self.media_streams.unwrap_or_default();
            v.push(input.into());
            self.media_streams = Some(v);
            self
        }
        /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        ) -> Self {
            self.media_streams = input;
            self
        }
        /// The name of the flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// The outputs that you want to add to this flow.
        pub fn outputs(mut self, input: impl Into<crate::model::AddOutputRequest>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// The outputs that you want to add to this flow.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// The settings for the source of the flow.
        pub fn source(mut self, input: crate::model::SetSourceRequest) -> Self {
            self.source = Some(input);
            self
        }
        /// The settings for the source of the flow.
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::SetSourceRequest>,
        ) -> Self {
            self.source = input;
            self
        }
        /// The settings for source failover
        pub fn source_failover_config(mut self, input: crate::model::FailoverConfig) -> Self {
            self.source_failover_config = Some(input);
            self
        }
        /// The settings for source failover
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::FailoverConfig>,
        ) -> Self {
            self.source_failover_config = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        pub fn sources(mut self, input: impl Into<crate::model::SetSourceRequest>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Appends an item to `vpc_interfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// The VPC interfaces you want on the flow.
        pub fn vpc_interfaces(
            mut self,
            input: impl Into<crate::model::VpcInterfaceRequest>,
        ) -> Self {
            let mut v = self.vpc_interfaces.unwrap_or_default();
            v.push(input.into());
            self.vpc_interfaces = Some(v);
            self
        }
        /// The VPC interfaces you want on the flow.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
        ) -> Self {
            self.vpc_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowInput`](crate::input::CreateFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFlowInput {
                availability_zone: self.availability_zone,
                entitlements: self.entitlements,
                media_streams: self.media_streams,
                name: self.name,
                outputs: self.outputs,
                source: self.source,
                source_failover_config: self.source_failover_config,
                sources: self.sources,
                vpc_interfaces: self.vpc_interfaces,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFlowInputOperationOutputAlias = crate::operation::CreateFlow;
#[doc(hidden)]
pub type CreateFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFlowInput {
    /// Consumes the builder and constructs an Operation<[`CreateFlow`](crate::operation::CreateFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/flows").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFlow",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFlowInput`](crate::input::CreateFlowInput)
    pub fn builder() -> crate::input::create_flow_input::Builder {
        crate::input::create_flow_input::Builder::default()
    }
}

/// See [`DeleteFlowInput`](crate::input::DeleteFlowInput)
pub mod delete_flow_input {
    /// A builder for [`DeleteFlowInput`](crate::input::DeleteFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that you want to delete.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you want to delete.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFlowInput`](crate::input::DeleteFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFlowInput {
                flow_arn: self.flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteFlowInputOperationOutputAlias = crate::operation::DeleteFlow;
#[doc(hidden)]
pub type DeleteFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFlowInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFlow`](crate::operation::DeleteFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_5 = &_input.flow_arn;
            let input_5 =
                input_5
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_5, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/{FlowArn}", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFlow",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFlowInput`](crate::input::DeleteFlowInput)
    pub fn builder() -> crate::input::delete_flow_input::Builder {
        crate::input::delete_flow_input::Builder::default()
    }
}

/// See [`DescribeFlowInput`](crate::input::DescribeFlowInput)
pub mod describe_flow_input {
    /// A builder for [`DescribeFlowInput`](crate::input::DescribeFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that you want to describe.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you want to describe.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowInput`](crate::input::DescribeFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeFlowInput {
                flow_arn: self.flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeFlowInputOperationOutputAlias = crate::operation::DescribeFlow;
#[doc(hidden)]
pub type DescribeFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeFlowInput {
    /// Consumes the builder and constructs an Operation<[`DescribeFlow`](crate::operation::DescribeFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.flow_arn;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_6, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/{FlowArn}", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeFlow",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeFlowInput`](crate::input::DescribeFlowInput)
    pub fn builder() -> crate::input::describe_flow_input::Builder {
        crate::input::describe_flow_input::Builder::default()
    }
}

/// See [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
pub mod describe_offering_input {
    /// A builder for [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn offering_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOfferingInput {
                offering_arn: self.offering_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeOfferingInputOperationOutputAlias = crate::operation::DescribeOffering;
#[doc(hidden)]
pub type DescribeOfferingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOfferingInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOffering`](crate::operation::DescribeOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOffering,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.offering_arn;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "offering_arn",
                        details: "cannot be empty or unset",
                    })?;
            let offering_arn = aws_smithy_http::label::fmt_string(input_7, false);
            if offering_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "offering_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/offerings/{OfferingArn}",
                OfferingArn = offering_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOffering",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOfferingInput`](crate::input::DescribeOfferingInput)
    pub fn builder() -> crate::input::describe_offering_input::Builder {
        crate::input::describe_offering_input::Builder::default()
    }
}

/// See [`DescribeReservationInput`](crate::input::DescribeReservationInput)
pub mod describe_reservation_input {
    /// A builder for [`DescribeReservationInput`](crate::input::DescribeReservationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the reservation.
        pub fn reservation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the reservation.
        pub fn set_reservation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservationInput`](crate::input::DescribeReservationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeReservationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeReservationInput {
                reservation_arn: self.reservation_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeReservationInputOperationOutputAlias = crate::operation::DescribeReservation;
#[doc(hidden)]
pub type DescribeReservationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeReservationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeReservation`](crate::operation::DescribeReservation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeReservation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeReservationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.reservation_arn;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "reservation_arn",
                        details: "cannot be empty or unset",
                    })?;
            let reservation_arn = aws_smithy_http::label::fmt_string(input_8, false);
            if reservation_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "reservation_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/reservations/{ReservationArn}",
                ReservationArn = reservation_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeReservationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeReservationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeReservation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeReservation",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeReservationInput`](crate::input::DescribeReservationInput)
    pub fn builder() -> crate::input::describe_reservation_input::Builder {
        crate::input::describe_reservation_input::Builder::default()
    }
}

/// See [`GrantFlowEntitlementsInput`](crate::input::GrantFlowEntitlementsInput)
pub mod grant_flow_entitlements_input {
    /// A builder for [`GrantFlowEntitlementsInput`](crate::input::GrantFlowEntitlementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlements:
            std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The list of entitlements that you want to grant.
        pub fn entitlements(
            mut self,
            input: impl Into<crate::model::GrantEntitlementRequest>,
        ) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// The list of entitlements that you want to grant.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// The flow that you want to grant entitlements on.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to grant entitlements on.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantFlowEntitlementsInput`](crate::input::GrantFlowEntitlementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GrantFlowEntitlementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GrantFlowEntitlementsInput {
                entitlements: self.entitlements,
                flow_arn: self.flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type GrantFlowEntitlementsInputOperationOutputAlias = crate::operation::GrantFlowEntitlements;
#[doc(hidden)]
pub type GrantFlowEntitlementsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GrantFlowEntitlementsInput {
    /// Consumes the builder and constructs an Operation<[`GrantFlowEntitlements`](crate::operation::GrantFlowEntitlements)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GrantFlowEntitlements,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GrantFlowEntitlementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.flow_arn;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_9, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/entitlements",
                FlowArn = flow_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GrantFlowEntitlementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GrantFlowEntitlementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_grant_flow_entitlements(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GrantFlowEntitlements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GrantFlowEntitlements",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GrantFlowEntitlementsInput`](crate::input::GrantFlowEntitlementsInput)
    pub fn builder() -> crate::input::grant_flow_entitlements_input::Builder {
        crate::input::grant_flow_entitlements_input::Builder::default()
    }
}

/// See [`ListEntitlementsInput`](crate::input::ListEntitlementsInput)
pub mod list_entitlements_input {
    /// A builder for [`ListEntitlementsInput`](crate::input::ListEntitlementsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitlementsInput`](crate::input::ListEntitlementsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntitlementsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntitlementsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntitlementsInputOperationOutputAlias = crate::operation::ListEntitlements;
#[doc(hidden)]
pub type ListEntitlementsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntitlementsInput {
    /// Consumes the builder and constructs an Operation<[`ListEntitlements`](crate::operation::ListEntitlements)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntitlements,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntitlementsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/entitlements").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListEntitlementsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_10) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntitlementsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntitlementsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntitlements::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntitlements",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntitlementsInput`](crate::input::ListEntitlementsInput)
    pub fn builder() -> crate::input::list_entitlements_input::Builder {
        crate::input::list_entitlements_input::Builder::default()
    }
}

/// See [`ListFlowsInput`](crate::input::ListFlowsInput)
pub mod list_flows_input {
    /// A builder for [`ListFlowsInput`](crate::input::ListFlowsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowsInput`](crate::input::ListFlowsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListFlowsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListFlowsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFlowsInputOperationOutputAlias = crate::operation::ListFlows;
#[doc(hidden)]
pub type ListFlowsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFlowsInput {
    /// Consumes the builder and constructs an Operation<[`ListFlows`](crate::operation::ListFlows)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFlows,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFlowsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/flows").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFlowsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFlowsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFlowsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListFlows::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListFlows",
                    "mediaconnect",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFlowsInput`](crate::input::ListFlowsInput)
    pub fn builder() -> crate::input::list_flows_input::Builder {
        crate::input::list_flows_input::Builder::default()
    }
}

/// See [`ListOfferingsInput`](crate::input::ListOfferingsInput)
pub mod list_offerings_input {
    /// A builder for [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingsInput`](crate::input::ListOfferingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOfferingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOfferingsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOfferingsInputOperationOutputAlias = crate::operation::ListOfferings;
#[doc(hidden)]
pub type ListOfferingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOfferingsInput {
    /// Consumes the builder and constructs an Operation<[`ListOfferings`](crate::operation::ListOfferings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOfferings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOfferingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/offerings").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListOfferingsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_12) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_12));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOfferingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOfferingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOfferings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOfferings",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOfferingsInput`](crate::input::ListOfferingsInput)
    pub fn builder() -> crate::input::list_offerings_input::Builder {
        crate::input::list_offerings_input::Builder::default()
    }
}

/// See [`ListReservationsInput`](crate::input::ListReservationsInput)
pub mod list_reservations_input {
    /// A builder for [`ListReservationsInput`](crate::input::ListReservationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReservationsInput`](crate::input::ListReservationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListReservationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListReservationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListReservationsInputOperationOutputAlias = crate::operation::ListReservations;
#[doc(hidden)]
pub type ListReservationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListReservationsInput {
    /// Consumes the builder and constructs an Operation<[`ListReservations`](crate::operation::ListReservations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListReservations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListReservationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/v1/reservations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListReservationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_13) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListReservationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListReservationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListReservations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListReservations",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListReservationsInput`](crate::input::ListReservationsInput)
    pub fn builder() -> crate::input::list_reservations_input::Builder {
        crate::input::list_reservations_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_14 = &_input.resource_arn;
            let input_14 =
                input_14
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_14, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
pub mod purchase_offering_input {
    /// A builder for [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering_arn: std::option::Option<std::string::String>,
        pub(crate) reservation_name: std::option::Option<std::string::String>,
        pub(crate) start: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn offering_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_arn = input;
            self
        }
        /// The name that you want to use for the reservation.
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// The name that you want to use for the reservation.
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PurchaseOfferingInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PurchaseOfferingInput {
                offering_arn: self.offering_arn,
                reservation_name: self.reservation_name,
                start: self.start,
            })
        }
    }
}
#[doc(hidden)]
pub type PurchaseOfferingInputOperationOutputAlias = crate::operation::PurchaseOffering;
#[doc(hidden)]
pub type PurchaseOfferingInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PurchaseOfferingInput {
    /// Consumes the builder and constructs an Operation<[`PurchaseOffering`](crate::operation::PurchaseOffering)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PurchaseOffering,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PurchaseOfferingInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_15 = &_input.offering_arn;
            let input_15 =
                input_15
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "offering_arn",
                        details: "cannot be empty or unset",
                    })?;
            let offering_arn = aws_smithy_http::label::fmt_string(input_15, false);
            if offering_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "offering_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/offerings/{OfferingArn}",
                OfferingArn = offering_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PurchaseOfferingInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PurchaseOfferingInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_purchase_offering(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PurchaseOffering::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PurchaseOffering",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingInput`](crate::input::PurchaseOfferingInput)
    pub fn builder() -> crate::input::purchase_offering_input::Builder {
        crate::input::purchase_offering_input::Builder::default()
    }
}

/// See [`RemoveFlowMediaStreamInput`](crate::input::RemoveFlowMediaStreamInput)
pub mod remove_flow_media_stream_input {
    /// A builder for [`RemoveFlowMediaStreamInput`](crate::input::RemoveFlowMediaStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The name of the media stream that you want to remove.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream that you want to remove.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowMediaStreamInput`](crate::input::RemoveFlowMediaStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveFlowMediaStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveFlowMediaStreamInput {
                flow_arn: self.flow_arn,
                media_stream_name: self.media_stream_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveFlowMediaStreamInputOperationOutputAlias = crate::operation::RemoveFlowMediaStream;
#[doc(hidden)]
pub type RemoveFlowMediaStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveFlowMediaStreamInput {
    /// Consumes the builder and constructs an Operation<[`RemoveFlowMediaStream`](crate::operation::RemoveFlowMediaStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveFlowMediaStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveFlowMediaStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.flow_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_16, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_17 = &_input.media_stream_name;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "media_stream_name",
                        details: "cannot be empty or unset",
                    })?;
            let media_stream_name = aws_smithy_http::label::fmt_string(input_17, false);
            if media_stream_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "media_stream_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/mediaStreams/{MediaStreamName}",
                FlowArn = flow_arn,
                MediaStreamName = media_stream_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveFlowMediaStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveFlowMediaStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveFlowMediaStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveFlowMediaStream",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveFlowMediaStreamInput`](crate::input::RemoveFlowMediaStreamInput)
    pub fn builder() -> crate::input::remove_flow_media_stream_input::Builder {
        crate::input::remove_flow_media_stream_input::Builder::default()
    }
}

/// See [`RemoveFlowOutputInput`](crate::input::RemoveFlowOutputInput)
pub mod remove_flow_output_input {
    /// A builder for [`RemoveFlowOutputInput`](crate::input::RemoveFlowOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) output_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The flow that you want to remove an output from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to remove an output from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The ARN of the output that you want to remove.
        pub fn output_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_arn = Some(input.into());
            self
        }
        /// The ARN of the output that you want to remove.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowOutputInput`](crate::input::RemoveFlowOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveFlowOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveFlowOutputInput {
                flow_arn: self.flow_arn,
                output_arn: self.output_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveFlowOutputInputOperationOutputAlias = crate::operation::RemoveFlowOutput;
#[doc(hidden)]
pub type RemoveFlowOutputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveFlowOutputInput {
    /// Consumes the builder and constructs an Operation<[`RemoveFlowOutput`](crate::operation::RemoveFlowOutput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveFlowOutput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveFlowOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.flow_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_18, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_19 = &_input.output_arn;
            let input_19 =
                input_19
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "output_arn",
                        details: "cannot be empty or unset",
                    })?;
            let output_arn = aws_smithy_http::label::fmt_string(input_19, false);
            if output_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "output_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/outputs/{OutputArn}",
                FlowArn = flow_arn,
                OutputArn = output_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveFlowOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveFlowOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveFlowOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveFlowOutput",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveFlowOutputInput`](crate::input::RemoveFlowOutputInput)
    pub fn builder() -> crate::input::remove_flow_output_input::Builder {
        crate::input::remove_flow_output_input::Builder::default()
    }
}

/// See [`RemoveFlowSourceInput`](crate::input::RemoveFlowSourceInput)
pub mod remove_flow_source_input {
    /// A builder for [`RemoveFlowSourceInput`](crate::input::RemoveFlowSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The flow that you want to remove a source from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to remove a source from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The ARN of the source that you want to remove.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// The ARN of the source that you want to remove.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowSourceInput`](crate::input::RemoveFlowSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveFlowSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveFlowSourceInput {
                flow_arn: self.flow_arn,
                source_arn: self.source_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveFlowSourceInputOperationOutputAlias = crate::operation::RemoveFlowSource;
#[doc(hidden)]
pub type RemoveFlowSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveFlowSourceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveFlowSource`](crate::operation::RemoveFlowSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveFlowSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveFlowSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_20 = &_input.flow_arn;
            let input_20 =
                input_20
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_20, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_21 = &_input.source_arn;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "source_arn",
                        details: "cannot be empty or unset",
                    })?;
            let source_arn = aws_smithy_http::label::fmt_string(input_21, false);
            if source_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "source_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/source/{SourceArn}",
                FlowArn = flow_arn,
                SourceArn = source_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveFlowSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveFlowSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveFlowSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveFlowSource",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveFlowSourceInput`](crate::input::RemoveFlowSourceInput)
    pub fn builder() -> crate::input::remove_flow_source_input::Builder {
        crate::input::remove_flow_source_input::Builder::default()
    }
}

/// See [`RemoveFlowVpcInterfaceInput`](crate::input::RemoveFlowVpcInterfaceInput)
pub mod remove_flow_vpc_interface_input {
    /// A builder for [`RemoveFlowVpcInterfaceInput`](crate::input::RemoveFlowVpcInterfaceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_interface_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The flow that you want to remove a VPC interface from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to remove a VPC interface from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The name of the VPC interface that you want to remove.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_interface_name = Some(input.into());
            self
        }
        /// The name of the VPC interface that you want to remove.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_interface_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowVpcInterfaceInput`](crate::input::RemoveFlowVpcInterfaceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RemoveFlowVpcInterfaceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RemoveFlowVpcInterfaceInput {
                flow_arn: self.flow_arn,
                vpc_interface_name: self.vpc_interface_name,
            })
        }
    }
}
#[doc(hidden)]
pub type RemoveFlowVpcInterfaceInputOperationOutputAlias = crate::operation::RemoveFlowVpcInterface;
#[doc(hidden)]
pub type RemoveFlowVpcInterfaceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RemoveFlowVpcInterfaceInput {
    /// Consumes the builder and constructs an Operation<[`RemoveFlowVpcInterface`](crate::operation::RemoveFlowVpcInterface)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RemoveFlowVpcInterface,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RemoveFlowVpcInterfaceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.flow_arn;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_22, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_23 = &_input.vpc_interface_name;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "vpc_interface_name",
                        details: "cannot be empty or unset",
                    })?;
            let vpc_interface_name = aws_smithy_http::label::fmt_string(input_23, false);
            if vpc_interface_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "vpc_interface_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/vpcInterfaces/{VpcInterfaceName}",
                FlowArn = flow_arn,
                VpcInterfaceName = vpc_interface_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RemoveFlowVpcInterfaceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RemoveFlowVpcInterfaceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RemoveFlowVpcInterface::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RemoveFlowVpcInterface",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RemoveFlowVpcInterfaceInput`](crate::input::RemoveFlowVpcInterfaceInput)
    pub fn builder() -> crate::input::remove_flow_vpc_interface_input::Builder {
        crate::input::remove_flow_vpc_interface_input::Builder::default()
    }
}

/// See [`RevokeFlowEntitlementInput`](crate::input::RevokeFlowEntitlementInput)
pub mod revoke_flow_entitlement_input {
    /// A builder for [`RevokeFlowEntitlementInput`](crate::input::RevokeFlowEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the entitlement that you want to revoke.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement that you want to revoke.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The flow that you want to revoke an entitlement from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to revoke an entitlement from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeFlowEntitlementInput`](crate::input::RevokeFlowEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RevokeFlowEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RevokeFlowEntitlementInput {
                entitlement_arn: self.entitlement_arn,
                flow_arn: self.flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type RevokeFlowEntitlementInputOperationOutputAlias = crate::operation::RevokeFlowEntitlement;
#[doc(hidden)]
pub type RevokeFlowEntitlementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RevokeFlowEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`RevokeFlowEntitlement`](crate::operation::RevokeFlowEntitlement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RevokeFlowEntitlement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RevokeFlowEntitlementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_24 = &_input.flow_arn;
            let input_24 =
                input_24
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_24, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_25 = &_input.entitlement_arn;
            let input_25 =
                input_25
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "entitlement_arn",
                        details: "cannot be empty or unset",
                    })?;
            let entitlement_arn = aws_smithy_http::label::fmt_string(input_25, false);
            if entitlement_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "entitlement_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/entitlements/{EntitlementArn}",
                FlowArn = flow_arn,
                EntitlementArn = entitlement_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RevokeFlowEntitlementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RevokeFlowEntitlementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RevokeFlowEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RevokeFlowEntitlement",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RevokeFlowEntitlementInput`](crate::input::RevokeFlowEntitlementInput)
    pub fn builder() -> crate::input::revoke_flow_entitlement_input::Builder {
        crate::input::revoke_flow_entitlement_input::Builder::default()
    }
}

/// See [`StartFlowInput`](crate::input::StartFlowInput)
pub mod start_flow_input {
    /// A builder for [`StartFlowInput`](crate::input::StartFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that you want to start.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you want to start.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFlowInput`](crate::input::StartFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StartFlowInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StartFlowInput {
                flow_arn: self.flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StartFlowInputOperationOutputAlias = crate::operation::StartFlow;
#[doc(hidden)]
pub type StartFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartFlowInput {
    /// Consumes the builder and constructs an Operation<[`StartFlow`](crate::operation::StartFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_26 = &_input.flow_arn;
            let input_26 =
                input_26
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_26, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/start/{FlowArn}", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StartFlow::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StartFlow",
                    "mediaconnect",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartFlowInput`](crate::input::StartFlowInput)
    pub fn builder() -> crate::input::start_flow_input::Builder {
        crate::input::start_flow_input::Builder::default()
    }
}

/// See [`StopFlowInput`](crate::input::StopFlowInput)
pub mod stop_flow_input {
    /// A builder for [`StopFlowInput`](crate::input::StopFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that you want to stop.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you want to stop.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFlowInput`](crate::input::StopFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopFlowInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopFlowInput {
                flow_arn: self.flow_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type StopFlowInputOperationOutputAlias = crate::operation::StopFlow;
#[doc(hidden)]
pub type StopFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StopFlowInput {
    /// Consumes the builder and constructs an Operation<[`StopFlow`](crate::operation::StopFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StopFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_27 = &_input.flow_arn;
            let input_27 =
                input_27
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_27, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/stop/{FlowArn}", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StopFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StopFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopFlow::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopFlow",
                    "mediaconnect",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StopFlowInput`](crate::input::StopFlowInput)
    pub fn builder() -> crate::input::stop_flow_input::Builder {
        crate::input::stop_flow_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_28 = &_input.resource_arn;
            let input_28 =
                input_28
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_28, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The keys of the tags to be removed.
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// The keys of the tags to be removed.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_29 = &_input.resource_arn;
            let input_29 =
                input_29
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_29, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_30) = &_input.tag_keys {
                for inner_31 in inner_30 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_31));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateFlowInput`](crate::input::UpdateFlowInput)
pub mod update_flow_input {
    /// A builder for [`UpdateFlowInput`](crate::input::UpdateFlowInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) source_failover_config: std::option::Option<crate::model::UpdateFailoverConfig>,
    }
    impl Builder {
        /// The flow that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The settings for source failover
        pub fn source_failover_config(mut self, input: crate::model::UpdateFailoverConfig) -> Self {
            self.source_failover_config = Some(input);
            self
        }
        /// The settings for source failover
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::UpdateFailoverConfig>,
        ) -> Self {
            self.source_failover_config = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowInput`](crate::input::UpdateFlowInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowInput {
                flow_arn: self.flow_arn,
                source_failover_config: self.source_failover_config,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowInputOperationOutputAlias = crate::operation::UpdateFlow;
#[doc(hidden)]
pub type UpdateFlowInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFlowInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlow`](crate::operation::UpdateFlow)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlow,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_32 = &_input.flow_arn;
            let input_32 =
                input_32
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_32, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/v1/flows/{FlowArn}", FlowArn = flow_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_update_flow(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlow::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlow",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowInput`](crate::input::UpdateFlowInput)
    pub fn builder() -> crate::input::update_flow_input::Builder {
        crate::input::update_flow_input::Builder::default()
    }
}

/// See [`UpdateFlowEntitlementInput`](crate::input::UpdateFlowEntitlementInput)
pub mod update_flow_entitlement_input {
    /// A builder for [`UpdateFlowEntitlementInput`](crate::input::UpdateFlowEntitlementInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::UpdateEncryption>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) entitlement_status: std::option::Option<crate::model::EntitlementStatus>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The type of encryption that will be used on the output associated with this entitlement.
        pub fn encryption(mut self, input: crate::model::UpdateEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// The type of encryption that will be used on the output associated with this entitlement.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// The ARN of the entitlement that you want to update.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement that you want to update.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
        pub fn entitlement_status(mut self, input: crate::model::EntitlementStatus) -> Self {
            self.entitlement_status = Some(input);
            self
        }
        /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
        pub fn set_entitlement_status(
            mut self,
            input: std::option::Option<crate::model::EntitlementStatus>,
        ) -> Self {
            self.entitlement_status = input;
            self
        }
        /// The flow that is associated with the entitlement that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that is associated with the entitlement that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn subscribers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input.into());
            self.subscribers = Some(v);
            self
        }
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowEntitlementInput`](crate::input::UpdateFlowEntitlementInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowEntitlementInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowEntitlementInput {
                description: self.description,
                encryption: self.encryption,
                entitlement_arn: self.entitlement_arn,
                entitlement_status: self.entitlement_status,
                flow_arn: self.flow_arn,
                subscribers: self.subscribers,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowEntitlementInputOperationOutputAlias = crate::operation::UpdateFlowEntitlement;
#[doc(hidden)]
pub type UpdateFlowEntitlementInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFlowEntitlementInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlowEntitlement`](crate::operation::UpdateFlowEntitlement)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlowEntitlement,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowEntitlementInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_33 = &_input.flow_arn;
            let input_33 =
                input_33
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_33, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_34 = &_input.entitlement_arn;
            let input_34 =
                input_34
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "entitlement_arn",
                        details: "cannot be empty or unset",
                    })?;
            let entitlement_arn = aws_smithy_http::label::fmt_string(input_34, false);
            if entitlement_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "entitlement_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/entitlements/{EntitlementArn}",
                FlowArn = flow_arn,
                EntitlementArn = entitlement_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowEntitlementInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowEntitlementInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_flow_entitlement(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlowEntitlement::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlowEntitlement",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowEntitlementInput`](crate::input::UpdateFlowEntitlementInput)
    pub fn builder() -> crate::input::update_flow_entitlement_input::Builder {
        crate::input::update_flow_entitlement_input::Builder::default()
    }
}

/// See [`UpdateFlowMediaStreamInput`](crate::input::UpdateFlowMediaStreamInput)
pub mod update_flow_media_stream_input {
    /// A builder for [`UpdateFlowMediaStreamInput`](crate::input::UpdateFlowMediaStreamInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<crate::model::MediaStreamAttributesRequest>,
        pub(crate) clock_rate: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
        pub(crate) media_stream_type: std::option::Option<crate::model::MediaStreamType>,
        pub(crate) video_format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The attributes that you want to assign to the media stream.
        pub fn attributes(mut self, input: crate::model::MediaStreamAttributesRequest) -> Self {
            self.attributes = Some(input);
            self
        }
        /// The attributes that you want to assign to the media stream.
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::MediaStreamAttributesRequest>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn clock_rate(mut self, input: i32) -> Self {
            self.clock_rate = Some(input);
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn set_clock_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.clock_rate = input;
            self
        }
        /// Description
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// Description
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The name of the media stream that you want to update.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream that you want to update.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// The type of media stream.
        pub fn media_stream_type(mut self, input: crate::model::MediaStreamType) -> Self {
            self.media_stream_type = Some(input);
            self
        }
        /// The type of media stream.
        pub fn set_media_stream_type(
            mut self,
            input: std::option::Option<crate::model::MediaStreamType>,
        ) -> Self {
            self.media_stream_type = input;
            self
        }
        /// The resolution of the video.
        pub fn video_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_format = Some(input.into());
            self
        }
        /// The resolution of the video.
        pub fn set_video_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.video_format = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowMediaStreamInput`](crate::input::UpdateFlowMediaStreamInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowMediaStreamInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowMediaStreamInput {
                attributes: self.attributes,
                clock_rate: self.clock_rate.unwrap_or_default(),
                description: self.description,
                flow_arn: self.flow_arn,
                media_stream_name: self.media_stream_name,
                media_stream_type: self.media_stream_type,
                video_format: self.video_format,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowMediaStreamInputOperationOutputAlias = crate::operation::UpdateFlowMediaStream;
#[doc(hidden)]
pub type UpdateFlowMediaStreamInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFlowMediaStreamInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlowMediaStream`](crate::operation::UpdateFlowMediaStream)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlowMediaStream,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowMediaStreamInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_35 = &_input.flow_arn;
            let input_35 =
                input_35
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_35, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_36 = &_input.media_stream_name;
            let input_36 =
                input_36
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "media_stream_name",
                        details: "cannot be empty or unset",
                    })?;
            let media_stream_name = aws_smithy_http::label::fmt_string(input_36, false);
            if media_stream_name.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "media_stream_name",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/mediaStreams/{MediaStreamName}",
                FlowArn = flow_arn,
                MediaStreamName = media_stream_name
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowMediaStreamInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowMediaStreamInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_flow_media_stream(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlowMediaStream::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlowMediaStream",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowMediaStreamInput`](crate::input::UpdateFlowMediaStreamInput)
    pub fn builder() -> crate::input::update_flow_media_stream_input::Builder {
        crate::input::update_flow_media_stream_input::Builder::default()
    }
}

/// See [`UpdateFlowOutputInput`](crate::input::UpdateFlowOutputInput)
pub mod update_flow_output_input {
    /// A builder for [`UpdateFlowOutputInput`](crate::input::UpdateFlowOutputInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::UpdateEncryption>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) max_latency: std::option::Option<i32>,
        pub(crate) media_stream_output_configurations:
            std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>>,
        pub(crate) min_latency: std::option::Option<i32>,
        pub(crate) output_arn: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) remote_id: std::option::Option<std::string::String>,
        pub(crate) smoothing_latency: std::option::Option<i32>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) vpc_interface_attachment:
            std::option::Option<crate::model::VpcInterfaceAttachment>,
    }
    impl Builder {
        /// Appends an item to `cidr_allow_list`.
        ///
        /// To override the contents of this collection use [`set_cidr_allow_list`](Self::set_cidr_allow_list).
        ///
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn cidr_allow_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_allow_list.unwrap_or_default();
            v.push(input.into());
            self.cidr_allow_list = Some(v);
            self
        }
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_cidr_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_allow_list = input;
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The IP address where you want to send the output.
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// The IP address where you want to send the output.
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn encryption(mut self, input: crate::model::UpdateEncryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// The flow that is associated with the output that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that is associated with the output that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The maximum latency in milliseconds for Zixi-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.max_latency = Some(input);
            self
        }
        /// The maximum latency in milliseconds for Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_latency = input;
            self
        }
        /// Appends an item to `media_stream_output_configurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_output_configurations`](Self::set_media_stream_output_configurations).
        ///
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn media_stream_output_configurations(
            mut self,
            input: impl Into<crate::model::MediaStreamOutputConfigurationRequest>,
        ) -> Self {
            let mut v = self.media_stream_output_configurations.unwrap_or_default();
            v.push(input.into());
            self.media_stream_output_configurations = Some(v);
            self
        }
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn set_media_stream_output_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>,
            >,
        ) -> Self {
            self.media_stream_output_configurations = input;
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.min_latency = Some(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.min_latency = input;
            self
        }
        /// The ARN of the output that you want to update.
        pub fn output_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_arn = Some(input.into());
            self
        }
        /// The ARN of the output that you want to update.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_arn = input;
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// The protocol to use for the output.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// The protocol to use for the output.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn remote_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_id = Some(input.into());
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn set_remote_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.remote_id = input;
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn smoothing_latency(mut self, input: i32) -> Self {
            self.smoothing_latency = Some(input);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn set_smoothing_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.smoothing_latency = input;
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn vpc_interface_attachment(
            mut self,
            input: crate::model::VpcInterfaceAttachment,
        ) -> Self {
            self.vpc_interface_attachment = Some(input);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn set_vpc_interface_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcInterfaceAttachment>,
        ) -> Self {
            self.vpc_interface_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowOutputInput`](crate::input::UpdateFlowOutputInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowOutputInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowOutputInput {
                cidr_allow_list: self.cidr_allow_list,
                description: self.description,
                destination: self.destination,
                encryption: self.encryption,
                flow_arn: self.flow_arn,
                max_latency: self.max_latency.unwrap_or_default(),
                media_stream_output_configurations: self.media_stream_output_configurations,
                min_latency: self.min_latency.unwrap_or_default(),
                output_arn: self.output_arn,
                port: self.port.unwrap_or_default(),
                protocol: self.protocol,
                remote_id: self.remote_id,
                smoothing_latency: self.smoothing_latency.unwrap_or_default(),
                stream_id: self.stream_id,
                vpc_interface_attachment: self.vpc_interface_attachment,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowOutputInputOperationOutputAlias = crate::operation::UpdateFlowOutput;
#[doc(hidden)]
pub type UpdateFlowOutputInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFlowOutputInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlowOutput`](crate::operation::UpdateFlowOutput)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlowOutput,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowOutputInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_37 = &_input.flow_arn;
            let input_37 =
                input_37
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_37, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_38 = &_input.output_arn;
            let input_38 =
                input_38
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "output_arn",
                        details: "cannot be empty or unset",
                    })?;
            let output_arn = aws_smithy_http::label::fmt_string(input_38, false);
            if output_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "output_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/outputs/{OutputArn}",
                FlowArn = flow_arn,
                OutputArn = output_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowOutputInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowOutputInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_flow_output(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlowOutput::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlowOutput",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowOutputInput`](crate::input::UpdateFlowOutputInput)
    pub fn builder() -> crate::input::update_flow_output_input::Builder {
        crate::input::update_flow_output_input::Builder::default()
    }
}

/// See [`UpdateFlowSourceInput`](crate::input::UpdateFlowSourceInput)
pub mod update_flow_source_input {
    /// A builder for [`UpdateFlowSourceInput`](crate::input::UpdateFlowSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decryption: std::option::Option<crate::model::UpdateEncryption>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) ingest_port: std::option::Option<i32>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) max_latency: std::option::Option<i32>,
        pub(crate) max_sync_buffer: std::option::Option<i32>,
        pub(crate) media_stream_source_configurations:
            std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>>,
        pub(crate) min_latency: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) vpc_interface_name: std::option::Option<std::string::String>,
        pub(crate) whitelist_cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The type of encryption used on the content ingested from this source.
        pub fn decryption(mut self, input: crate::model::UpdateEncryption) -> Self {
            self.decryption = Some(input);
            self
        }
        /// The type of encryption used on the content ingested from this source.
        pub fn set_decryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.decryption = input;
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The flow that is associated with the source that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The flow that is associated with the source that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn ingest_port(mut self, input: i32) -> Self {
            self.ingest_port = Some(input);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn set_ingest_port(mut self, input: std::option::Option<i32>) -> Self {
            self.ingest_port = input;
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.max_latency = Some(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_latency = input;
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn max_sync_buffer(mut self, input: i32) -> Self {
            self.max_sync_buffer = Some(input);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn set_max_sync_buffer(mut self, input: std::option::Option<i32>) -> Self {
            self.max_sync_buffer = input;
            self
        }
        /// Appends an item to `media_stream_source_configurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_source_configurations`](Self::set_media_stream_source_configurations).
        ///
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn media_stream_source_configurations(
            mut self,
            input: impl Into<crate::model::MediaStreamSourceConfigurationRequest>,
        ) -> Self {
            let mut v = self.media_stream_source_configurations.unwrap_or_default();
            v.push(input.into());
            self.media_stream_source_configurations = Some(v);
            self
        }
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn set_media_stream_source_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>,
            >,
        ) -> Self {
            self.media_stream_source_configurations = input;
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.min_latency = Some(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.min_latency = input;
            self
        }
        /// The protocol that is used by the source.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// The protocol that is used by the source.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// The ARN of the source that you want to update.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// The ARN of the source that you want to update.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_interface_name = Some(input.into());
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_interface_name = input;
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn whitelist_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.whitelist_cidr = Some(input.into());
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_whitelist_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.whitelist_cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowSourceInput`](crate::input::UpdateFlowSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFlowSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFlowSourceInput {
                decryption: self.decryption,
                description: self.description,
                entitlement_arn: self.entitlement_arn,
                flow_arn: self.flow_arn,
                ingest_port: self.ingest_port.unwrap_or_default(),
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                max_latency: self.max_latency.unwrap_or_default(),
                max_sync_buffer: self.max_sync_buffer.unwrap_or_default(),
                media_stream_source_configurations: self.media_stream_source_configurations,
                min_latency: self.min_latency.unwrap_or_default(),
                protocol: self.protocol,
                source_arn: self.source_arn,
                stream_id: self.stream_id,
                vpc_interface_name: self.vpc_interface_name,
                whitelist_cidr: self.whitelist_cidr,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFlowSourceInputOperationOutputAlias = crate::operation::UpdateFlowSource;
#[doc(hidden)]
pub type UpdateFlowSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFlowSourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFlowSource`](crate::operation::UpdateFlowSource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFlowSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFlowSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_39 = &_input.flow_arn;
            let input_39 =
                input_39
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "flow_arn",
                        details: "cannot be empty or unset",
                    })?;
            let flow_arn = aws_smithy_http::label::fmt_string(input_39, false);
            if flow_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "flow_arn",
                    details: "cannot be empty or unset",
                });
            }
            let input_40 = &_input.source_arn;
            let input_40 =
                input_40
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "source_arn",
                        details: "cannot be empty or unset",
                    })?;
            let source_arn = aws_smithy_http::label::fmt_string(input_40, false);
            if source_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "source_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(
                output,
                "/v1/flows/{FlowArn}/source/{SourceArn}",
                FlowArn = flow_arn,
                SourceArn = source_arn
            )
            .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFlowSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFlowSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_flow_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFlowSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFlowSource",
            "mediaconnect",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFlowSourceInput`](crate::input::UpdateFlowSourceInput)
    pub fn builder() -> crate::input::update_flow_source_input::Builder {
        crate::input::update_flow_source_input::Builder::default()
    }
}

/// A request to update the source of a flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowSourceInput {
    /// The type of encryption used on the content ingested from this source.
    pub decryption: std::option::Option<crate::model::UpdateEncryption>,
    /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
    pub description: std::option::Option<std::string::String>,
    /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The flow that is associated with the source that you want to update.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The port that the flow will be listening on for incoming content.
    pub ingest_port: i32,
    /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
    pub max_bitrate: i32,
    /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
    pub max_latency: i32,
    /// The size of the buffer (in milliseconds) to use to sync incoming source data.
    pub max_sync_buffer: i32,
    /// The media streams that are associated with the source, and the parameters for those associations.
    pub media_stream_source_configurations:
        std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>>,
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub min_latency: i32,
    /// The protocol that is used by the source.
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// The ARN of the source that you want to update.
    pub source_arn: std::option::Option<std::string::String>,
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub stream_id: std::option::Option<std::string::String>,
    /// The name of the VPC interface to use for this source.
    pub vpc_interface_name: std::option::Option<std::string::String>,
    /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub whitelist_cidr: std::option::Option<std::string::String>,
}
impl UpdateFlowSourceInput {
    /// The type of encryption used on the content ingested from this source.
    pub fn decryption(&self) -> std::option::Option<&crate::model::UpdateEncryption> {
        self.decryption.as_ref()
    }
    /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
    pub fn entitlement_arn(&self) -> std::option::Option<&str> {
        self.entitlement_arn.as_deref()
    }
    /// The flow that is associated with the source that you want to update.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The port that the flow will be listening on for incoming content.
    pub fn ingest_port(&self) -> i32 {
        self.ingest_port
    }
    /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
    pub fn max_bitrate(&self) -> i32 {
        self.max_bitrate
    }
    /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
    pub fn max_latency(&self) -> i32 {
        self.max_latency
    }
    /// The size of the buffer (in milliseconds) to use to sync incoming source data.
    pub fn max_sync_buffer(&self) -> i32 {
        self.max_sync_buffer
    }
    /// The media streams that are associated with the source, and the parameters for those associations.
    pub fn media_stream_source_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::MediaStreamSourceConfigurationRequest]> {
        self.media_stream_source_configurations.as_deref()
    }
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub fn min_latency(&self) -> i32 {
        self.min_latency
    }
    /// The protocol that is used by the source.
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
    /// The ARN of the source that you want to update.
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// The name of the VPC interface to use for this source.
    pub fn vpc_interface_name(&self) -> std::option::Option<&str> {
        self.vpc_interface_name.as_deref()
    }
    /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub fn whitelist_cidr(&self) -> std::option::Option<&str> {
        self.whitelist_cidr.as_deref()
    }
}
impl std::fmt::Debug for UpdateFlowSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowSourceInput");
        formatter.field("decryption", &self.decryption);
        formatter.field("description", &self.description);
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("ingest_port", &self.ingest_port);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("max_latency", &self.max_latency);
        formatter.field("max_sync_buffer", &self.max_sync_buffer);
        formatter.field(
            "media_stream_source_configurations",
            &self.media_stream_source_configurations,
        );
        formatter.field("min_latency", &self.min_latency);
        formatter.field("protocol", &self.protocol);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("vpc_interface_name", &self.vpc_interface_name);
        formatter.field("whitelist_cidr", &self.whitelist_cidr);
        formatter.finish()
    }
}

/// The fields that you want to update in the output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowOutputInput {
    /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub cidr_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
    pub description: std::option::Option<std::string::String>,
    /// The IP address where you want to send the output.
    pub destination: std::option::Option<std::string::String>,
    /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    pub encryption: std::option::Option<crate::model::UpdateEncryption>,
    /// The flow that is associated with the output that you want to update.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The maximum latency in milliseconds for Zixi-based streams.
    pub max_latency: i32,
    /// The media streams that are associated with the output, and the parameters for those associations.
    pub media_stream_output_configurations:
        std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>>,
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub min_latency: i32,
    /// The ARN of the output that you want to update.
    pub output_arn: std::option::Option<std::string::String>,
    /// The port to use when content is distributed to this output.
    pub port: i32,
    /// The protocol to use for the output.
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// The remote ID for the Zixi-pull stream.
    pub remote_id: std::option::Option<std::string::String>,
    /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
    pub smoothing_latency: i32,
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub stream_id: std::option::Option<std::string::String>,
    /// The name of the VPC interface attachment to use for this output.
    pub vpc_interface_attachment: std::option::Option<crate::model::VpcInterfaceAttachment>,
}
impl UpdateFlowOutputInput {
    /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub fn cidr_allow_list(&self) -> std::option::Option<&[std::string::String]> {
        self.cidr_allow_list.as_deref()
    }
    /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// The IP address where you want to send the output.
    pub fn destination(&self) -> std::option::Option<&str> {
        self.destination.as_deref()
    }
    /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    pub fn encryption(&self) -> std::option::Option<&crate::model::UpdateEncryption> {
        self.encryption.as_ref()
    }
    /// The flow that is associated with the output that you want to update.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The maximum latency in milliseconds for Zixi-based streams.
    pub fn max_latency(&self) -> i32 {
        self.max_latency
    }
    /// The media streams that are associated with the output, and the parameters for those associations.
    pub fn media_stream_output_configurations(
        &self,
    ) -> std::option::Option<&[crate::model::MediaStreamOutputConfigurationRequest]> {
        self.media_stream_output_configurations.as_deref()
    }
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub fn min_latency(&self) -> i32 {
        self.min_latency
    }
    /// The ARN of the output that you want to update.
    pub fn output_arn(&self) -> std::option::Option<&str> {
        self.output_arn.as_deref()
    }
    /// The port to use when content is distributed to this output.
    pub fn port(&self) -> i32 {
        self.port
    }
    /// The protocol to use for the output.
    pub fn protocol(&self) -> std::option::Option<&crate::model::Protocol> {
        self.protocol.as_ref()
    }
    /// The remote ID for the Zixi-pull stream.
    pub fn remote_id(&self) -> std::option::Option<&str> {
        self.remote_id.as_deref()
    }
    /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
    pub fn smoothing_latency(&self) -> i32 {
        self.smoothing_latency
    }
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub fn stream_id(&self) -> std::option::Option<&str> {
        self.stream_id.as_deref()
    }
    /// The name of the VPC interface attachment to use for this output.
    pub fn vpc_interface_attachment(
        &self,
    ) -> std::option::Option<&crate::model::VpcInterfaceAttachment> {
        self.vpc_interface_attachment.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowOutputInput");
        formatter.field("cidr_allow_list", &self.cidr_allow_list);
        formatter.field("description", &self.description);
        formatter.field("destination", &self.destination);
        formatter.field("encryption", &self.encryption);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("max_latency", &self.max_latency);
        formatter.field(
            "media_stream_output_configurations",
            &self.media_stream_output_configurations,
        );
        formatter.field("min_latency", &self.min_latency);
        formatter.field("output_arn", &self.output_arn);
        formatter.field("port", &self.port);
        formatter.field("protocol", &self.protocol);
        formatter.field("remote_id", &self.remote_id);
        formatter.field("smoothing_latency", &self.smoothing_latency);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("vpc_interface_attachment", &self.vpc_interface_attachment);
        formatter.finish()
    }
}

/// The fields that you want to update in the media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowMediaStreamInput {
    /// The attributes that you want to assign to the media stream.
    pub attributes: std::option::Option<crate::model::MediaStreamAttributesRequest>,
    /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
    pub clock_rate: i32,
    /// Description
    pub description: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) of the flow.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The name of the media stream that you want to update.
    pub media_stream_name: std::option::Option<std::string::String>,
    /// The type of media stream.
    pub media_stream_type: std::option::Option<crate::model::MediaStreamType>,
    /// The resolution of the video.
    pub video_format: std::option::Option<std::string::String>,
}
impl UpdateFlowMediaStreamInput {
    /// The attributes that you want to assign to the media stream.
    pub fn attributes(&self) -> std::option::Option<&crate::model::MediaStreamAttributesRequest> {
        self.attributes.as_ref()
    }
    /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
    pub fn clock_rate(&self) -> i32 {
        self.clock_rate
    }
    /// Description
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// The Amazon Resource Name (ARN) of the flow.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The name of the media stream that you want to update.
    pub fn media_stream_name(&self) -> std::option::Option<&str> {
        self.media_stream_name.as_deref()
    }
    /// The type of media stream.
    pub fn media_stream_type(&self) -> std::option::Option<&crate::model::MediaStreamType> {
        self.media_stream_type.as_ref()
    }
    /// The resolution of the video.
    pub fn video_format(&self) -> std::option::Option<&str> {
        self.video_format.as_deref()
    }
}
impl std::fmt::Debug for UpdateFlowMediaStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowMediaStreamInput");
        formatter.field("attributes", &self.attributes);
        formatter.field("clock_rate", &self.clock_rate);
        formatter.field("description", &self.description);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.field("media_stream_type", &self.media_stream_type);
        formatter.field("video_format", &self.video_format);
        formatter.finish()
    }
}

/// The entitlement fields that you want to update.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowEntitlementInput {
    /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
    pub description: std::option::Option<std::string::String>,
    /// The type of encryption that will be used on the output associated with this entitlement.
    pub encryption: std::option::Option<crate::model::UpdateEncryption>,
    /// The ARN of the entitlement that you want to update.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
    pub entitlement_status: std::option::Option<crate::model::EntitlementStatus>,
    /// The flow that is associated with the entitlement that you want to update.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
    pub subscribers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UpdateFlowEntitlementInput {
    /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// The type of encryption that will be used on the output associated with this entitlement.
    pub fn encryption(&self) -> std::option::Option<&crate::model::UpdateEncryption> {
        self.encryption.as_ref()
    }
    /// The ARN of the entitlement that you want to update.
    pub fn entitlement_arn(&self) -> std::option::Option<&str> {
        self.entitlement_arn.as_deref()
    }
    /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
    pub fn entitlement_status(&self) -> std::option::Option<&crate::model::EntitlementStatus> {
        self.entitlement_status.as_ref()
    }
    /// The flow that is associated with the entitlement that you want to update.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
    pub fn subscribers(&self) -> std::option::Option<&[std::string::String]> {
        self.subscribers.as_deref()
    }
}
impl std::fmt::Debug for UpdateFlowEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowEntitlementInput");
        formatter.field("description", &self.description);
        formatter.field("encryption", &self.encryption);
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("entitlement_status", &self.entitlement_status);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}

/// A request to update flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowInput {
    /// The flow that you want to update.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The settings for source failover
    pub source_failover_config: std::option::Option<crate::model::UpdateFailoverConfig>,
}
impl UpdateFlowInput {
    /// The flow that you want to update.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The settings for source failover
    pub fn source_failover_config(
        &self,
    ) -> std::option::Option<&crate::model::UpdateFailoverConfig> {
        self.source_failover_config.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("source_failover_config", &self.source_failover_config);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
    pub resource_arn: std::option::Option<std::string::String>,
    /// The keys of the tags to be removed.
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// The keys of the tags to be removed.
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

/// The tags to add to the resource. A tag is an array of key-value pairs. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
    pub resource_arn: std::option::Option<std::string::String>,
    /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFlowInput {
    /// The ARN of the flow that you want to stop.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl StopFlowInput {
    /// The ARN of the flow that you want to stop.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for StopFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFlowInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFlowInput {
    /// The ARN of the flow that you want to start.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl StartFlowInput {
    /// The ARN of the flow that you want to start.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for StartFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFlowInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeFlowEntitlementInput {
    /// The ARN of the entitlement that you want to revoke.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The flow that you want to revoke an entitlement from.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl RevokeFlowEntitlementInput {
    /// The ARN of the entitlement that you want to revoke.
    pub fn entitlement_arn(&self) -> std::option::Option<&str> {
        self.entitlement_arn.as_deref()
    }
    /// The flow that you want to revoke an entitlement from.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for RevokeFlowEntitlementInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeFlowEntitlementInput");
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowVpcInterfaceInput {
    /// The flow that you want to remove a VPC interface from.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The name of the VPC interface that you want to remove.
    pub vpc_interface_name: std::option::Option<std::string::String>,
}
impl RemoveFlowVpcInterfaceInput {
    /// The flow that you want to remove a VPC interface from.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The name of the VPC interface that you want to remove.
    pub fn vpc_interface_name(&self) -> std::option::Option<&str> {
        self.vpc_interface_name.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowVpcInterfaceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowVpcInterfaceInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("vpc_interface_name", &self.vpc_interface_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowSourceInput {
    /// The flow that you want to remove a source from.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The ARN of the source that you want to remove.
    pub source_arn: std::option::Option<std::string::String>,
}
impl RemoveFlowSourceInput {
    /// The flow that you want to remove a source from.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The ARN of the source that you want to remove.
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowSourceInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("source_arn", &self.source_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowOutputInput {
    /// The flow that you want to remove an output from.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The ARN of the output that you want to remove.
    pub output_arn: std::option::Option<std::string::String>,
}
impl RemoveFlowOutputInput {
    /// The flow that you want to remove an output from.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The ARN of the output that you want to remove.
    pub fn output_arn(&self) -> std::option::Option<&str> {
        self.output_arn.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowOutputInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowOutputInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("output_arn", &self.output_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowMediaStreamInput {
    /// The Amazon Resource Name (ARN) of the flow.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The name of the media stream that you want to remove.
    pub media_stream_name: std::option::Option<std::string::String>,
}
impl RemoveFlowMediaStreamInput {
    /// The Amazon Resource Name (ARN) of the flow.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The name of the media stream that you want to remove.
    pub fn media_stream_name(&self) -> std::option::Option<&str> {
        self.media_stream_name.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowMediaStreamInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowMediaStreamInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.finish()
    }
}

/// A request to purchase a offering.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseOfferingInput {
    /// The Amazon Resource Name (ARN) of the offering.
    pub offering_arn: std::option::Option<std::string::String>,
    /// The name that you want to use for the reservation.
    pub reservation_name: std::option::Option<std::string::String>,
    /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
    pub start: std::option::Option<std::string::String>,
}
impl PurchaseOfferingInput {
    /// The Amazon Resource Name (ARN) of the offering.
    pub fn offering_arn(&self) -> std::option::Option<&str> {
        self.offering_arn.as_deref()
    }
    /// The name that you want to use for the reservation.
    pub fn reservation_name(&self) -> std::option::Option<&str> {
        self.reservation_name.as_deref()
    }
    /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
    pub fn start(&self) -> std::option::Option<&str> {
        self.start.as_deref()
    }
}
impl std::fmt::Debug for PurchaseOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseOfferingInput");
        formatter.field("offering_arn", &self.offering_arn);
        formatter.field("reservation_name", &self.reservation_name);
        formatter.field("start", &self.start);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReservationsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    pub max_results: i32,
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListReservationsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListReservationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReservationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    pub max_results: i32,
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOfferingsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    pub max_results: i32,
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFlowsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFlowsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitlementsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
    pub max_results: i32,
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEntitlementsInput {
    /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEntitlementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitlementsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

/// A request to grant entitlements on a flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantFlowEntitlementsInput {
    /// The list of entitlements that you want to grant.
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
    /// The flow that you want to grant entitlements on.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl GrantFlowEntitlementsInput {
    /// The list of entitlements that you want to grant.
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::GrantEntitlementRequest]> {
        self.entitlements.as_deref()
    }
    /// The flow that you want to grant entitlements on.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for GrantFlowEntitlementsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantFlowEntitlementsInput");
        formatter.field("entitlements", &self.entitlements);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservationInput {
    /// The Amazon Resource Name (ARN) of the reservation.
    pub reservation_arn: std::option::Option<std::string::String>,
}
impl DescribeReservationInput {
    /// The Amazon Resource Name (ARN) of the reservation.
    pub fn reservation_arn(&self) -> std::option::Option<&str> {
        self.reservation_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeReservationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservationInput");
        formatter.field("reservation_arn", &self.reservation_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOfferingInput {
    /// The Amazon Resource Name (ARN) of the offering.
    pub offering_arn: std::option::Option<std::string::String>,
}
impl DescribeOfferingInput {
    /// The Amazon Resource Name (ARN) of the offering.
    pub fn offering_arn(&self) -> std::option::Option<&str> {
        self.offering_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeOfferingInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOfferingInput");
        formatter.field("offering_arn", &self.offering_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowInput {
    /// The ARN of the flow that you want to describe.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl DescribeFlowInput {
    /// The ARN of the flow that you want to describe.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for DescribeFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFlowInput {
    /// The ARN of the flow that you want to delete.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl DeleteFlowInput {
    /// The ARN of the flow that you want to delete.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFlowInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}

/// Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlowInput {
    /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
    pub availability_zone: std::option::Option<std::string::String>,
    /// The entitlements that you want to grant on a flow.
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
    /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
    pub media_streams: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
    /// The name of the flow.
    pub name: std::option::Option<std::string::String>,
    /// The outputs that you want to add to this flow.
    pub outputs: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
    /// The settings for the source of the flow.
    pub source: std::option::Option<crate::model::SetSourceRequest>,
    /// The settings for source failover
    pub source_failover_config: std::option::Option<crate::model::FailoverConfig>,
    #[allow(missing_docs)] // documentation missing in model
    pub sources: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
    /// The VPC interfaces you want on the flow.
    pub vpc_interfaces: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
}
impl CreateFlowInput {
    /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
    pub fn availability_zone(&self) -> std::option::Option<&str> {
        self.availability_zone.as_deref()
    }
    /// The entitlements that you want to grant on a flow.
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::GrantEntitlementRequest]> {
        self.entitlements.as_deref()
    }
    /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
    pub fn media_streams(&self) -> std::option::Option<&[crate::model::AddMediaStreamRequest]> {
        self.media_streams.as_deref()
    }
    /// The name of the flow.
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// The outputs that you want to add to this flow.
    pub fn outputs(&self) -> std::option::Option<&[crate::model::AddOutputRequest]> {
        self.outputs.as_deref()
    }
    /// The settings for the source of the flow.
    pub fn source(&self) -> std::option::Option<&crate::model::SetSourceRequest> {
        self.source.as_ref()
    }
    /// The settings for source failover
    pub fn source_failover_config(&self) -> std::option::Option<&crate::model::FailoverConfig> {
        self.source_failover_config.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn sources(&self) -> std::option::Option<&[crate::model::SetSourceRequest]> {
        self.sources.as_deref()
    }
    /// The VPC interfaces you want on the flow.
    pub fn vpc_interfaces(&self) -> std::option::Option<&[crate::model::VpcInterfaceRequest]> {
        self.vpc_interfaces.as_deref()
    }
}
impl std::fmt::Debug for CreateFlowInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlowInput");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("media_streams", &self.media_streams);
        formatter.field("name", &self.name);
        formatter.field("outputs", &self.outputs);
        formatter.field("source", &self.source);
        formatter.field("source_failover_config", &self.source_failover_config);
        formatter.field("sources", &self.sources);
        formatter.field("vpc_interfaces", &self.vpc_interfaces);
        formatter.finish()
    }
}

/// A request to add VPC interfaces to the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowVpcInterfacesInput {
    /// The flow that you want to mutate.
    pub flow_arn: std::option::Option<std::string::String>,
    /// A list of VPC interfaces that you want to add.
    pub vpc_interfaces: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
}
impl AddFlowVpcInterfacesInput {
    /// The flow that you want to mutate.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// A list of VPC interfaces that you want to add.
    pub fn vpc_interfaces(&self) -> std::option::Option<&[crate::model::VpcInterfaceRequest]> {
        self.vpc_interfaces.as_deref()
    }
}
impl std::fmt::Debug for AddFlowVpcInterfacesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowVpcInterfacesInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("vpc_interfaces", &self.vpc_interfaces);
        formatter.finish()
    }
}

/// A request to add sources to the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowSourcesInput {
    /// The flow that you want to mutate.
    pub flow_arn: std::option::Option<std::string::String>,
    /// A list of sources that you want to add.
    pub sources: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
}
impl AddFlowSourcesInput {
    /// The flow that you want to mutate.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// A list of sources that you want to add.
    pub fn sources(&self) -> std::option::Option<&[crate::model::SetSourceRequest]> {
        self.sources.as_deref()
    }
}
impl std::fmt::Debug for AddFlowSourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowSourcesInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}

/// A request to add outputs to the specified flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowOutputsInput {
    /// The flow that you want to add outputs to.
    pub flow_arn: std::option::Option<std::string::String>,
    /// A list of outputs that you want to add.
    pub outputs: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
}
impl AddFlowOutputsInput {
    /// The flow that you want to add outputs to.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// A list of outputs that you want to add.
    pub fn outputs(&self) -> std::option::Option<&[crate::model::AddOutputRequest]> {
        self.outputs.as_deref()
    }
}
impl std::fmt::Debug for AddFlowOutputsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowOutputsInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("outputs", &self.outputs);
        formatter.finish()
    }
}

/// A request to add media streams to the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowMediaStreamsInput {
    /// The Amazon Resource Name (ARN) of the flow.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The media streams that you want to add to the flow.
    pub media_streams: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
}
impl AddFlowMediaStreamsInput {
    /// The Amazon Resource Name (ARN) of the flow.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The media streams that you want to add to the flow.
    pub fn media_streams(&self) -> std::option::Option<&[crate::model::AddMediaStreamRequest]> {
        self.media_streams.as_deref()
    }
}
impl std::fmt::Debug for AddFlowMediaStreamsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowMediaStreamsInput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_streams", &self.media_streams);
        formatter.finish()
    }
}
