// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `MediaConnect`.
///
/// This client allows ergonomic access to a `MediaConnect`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddFlowMediaStreams` operation.
    ///
    /// See [`AddFlowMediaStreams`](crate::client::fluent_builders::AddFlowMediaStreams) for more information about the
    /// operation and its arguments.
    pub fn add_flow_media_streams(&self) -> fluent_builders::AddFlowMediaStreams<C, M, R> {
        fluent_builders::AddFlowMediaStreams::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddFlowOutputs` operation.
    ///
    /// See [`AddFlowOutputs`](crate::client::fluent_builders::AddFlowOutputs) for more information about the
    /// operation and its arguments.
    pub fn add_flow_outputs(&self) -> fluent_builders::AddFlowOutputs<C, M, R> {
        fluent_builders::AddFlowOutputs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddFlowSources` operation.
    ///
    /// See [`AddFlowSources`](crate::client::fluent_builders::AddFlowSources) for more information about the
    /// operation and its arguments.
    pub fn add_flow_sources(&self) -> fluent_builders::AddFlowSources<C, M, R> {
        fluent_builders::AddFlowSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `AddFlowVpcInterfaces` operation.
    ///
    /// See [`AddFlowVpcInterfaces`](crate::client::fluent_builders::AddFlowVpcInterfaces) for more information about the
    /// operation and its arguments.
    pub fn add_flow_vpc_interfaces(&self) -> fluent_builders::AddFlowVpcInterfaces<C, M, R> {
        fluent_builders::AddFlowVpcInterfaces::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFlow` operation.
    ///
    /// See [`CreateFlow`](crate::client::fluent_builders::CreateFlow) for more information about the
    /// operation and its arguments.
    pub fn create_flow(&self) -> fluent_builders::CreateFlow<C, M, R> {
        fluent_builders::CreateFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFlow` operation.
    ///
    /// See [`DeleteFlow`](crate::client::fluent_builders::DeleteFlow) for more information about the
    /// operation and its arguments.
    pub fn delete_flow(&self) -> fluent_builders::DeleteFlow<C, M, R> {
        fluent_builders::DeleteFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeFlow` operation.
    ///
    /// See [`DescribeFlow`](crate::client::fluent_builders::DescribeFlow) for more information about the
    /// operation and its arguments.
    pub fn describe_flow(&self) -> fluent_builders::DescribeFlow<C, M, R> {
        fluent_builders::DescribeFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOffering` operation.
    ///
    /// See [`DescribeOffering`](crate::client::fluent_builders::DescribeOffering) for more information about the
    /// operation and its arguments.
    pub fn describe_offering(&self) -> fluent_builders::DescribeOffering<C, M, R> {
        fluent_builders::DescribeOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeReservation` operation.
    ///
    /// See [`DescribeReservation`](crate::client::fluent_builders::DescribeReservation) for more information about the
    /// operation and its arguments.
    pub fn describe_reservation(&self) -> fluent_builders::DescribeReservation<C, M, R> {
        fluent_builders::DescribeReservation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GrantFlowEntitlements` operation.
    ///
    /// See [`GrantFlowEntitlements`](crate::client::fluent_builders::GrantFlowEntitlements) for more information about the
    /// operation and its arguments.
    pub fn grant_flow_entitlements(&self) -> fluent_builders::GrantFlowEntitlements<C, M, R> {
        fluent_builders::GrantFlowEntitlements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntitlements` operation.
    ///
    /// See [`ListEntitlements`](crate::client::fluent_builders::ListEntitlements) for more information about the
    /// operation and its arguments.
    pub fn list_entitlements(&self) -> fluent_builders::ListEntitlements<C, M, R> {
        fluent_builders::ListEntitlements::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFlows` operation.
    ///
    /// See [`ListFlows`](crate::client::fluent_builders::ListFlows) for more information about the
    /// operation and its arguments.
    pub fn list_flows(&self) -> fluent_builders::ListFlows<C, M, R> {
        fluent_builders::ListFlows::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOfferings` operation.
    ///
    /// See [`ListOfferings`](crate::client::fluent_builders::ListOfferings) for more information about the
    /// operation and its arguments.
    pub fn list_offerings(&self) -> fluent_builders::ListOfferings<C, M, R> {
        fluent_builders::ListOfferings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListReservations` operation.
    ///
    /// See [`ListReservations`](crate::client::fluent_builders::ListReservations) for more information about the
    /// operation and its arguments.
    pub fn list_reservations(&self) -> fluent_builders::ListReservations<C, M, R> {
        fluent_builders::ListReservations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PurchaseOffering` operation.
    ///
    /// See [`PurchaseOffering`](crate::client::fluent_builders::PurchaseOffering) for more information about the
    /// operation and its arguments.
    pub fn purchase_offering(&self) -> fluent_builders::PurchaseOffering<C, M, R> {
        fluent_builders::PurchaseOffering::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFlowMediaStream` operation.
    ///
    /// See [`RemoveFlowMediaStream`](crate::client::fluent_builders::RemoveFlowMediaStream) for more information about the
    /// operation and its arguments.
    pub fn remove_flow_media_stream(&self) -> fluent_builders::RemoveFlowMediaStream<C, M, R> {
        fluent_builders::RemoveFlowMediaStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFlowOutput` operation.
    ///
    /// See [`RemoveFlowOutput`](crate::client::fluent_builders::RemoveFlowOutput) for more information about the
    /// operation and its arguments.
    pub fn remove_flow_output(&self) -> fluent_builders::RemoveFlowOutput<C, M, R> {
        fluent_builders::RemoveFlowOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFlowSource` operation.
    ///
    /// See [`RemoveFlowSource`](crate::client::fluent_builders::RemoveFlowSource) for more information about the
    /// operation and its arguments.
    pub fn remove_flow_source(&self) -> fluent_builders::RemoveFlowSource<C, M, R> {
        fluent_builders::RemoveFlowSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RemoveFlowVpcInterface` operation.
    ///
    /// See [`RemoveFlowVpcInterface`](crate::client::fluent_builders::RemoveFlowVpcInterface) for more information about the
    /// operation and its arguments.
    pub fn remove_flow_vpc_interface(&self) -> fluent_builders::RemoveFlowVpcInterface<C, M, R> {
        fluent_builders::RemoveFlowVpcInterface::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RevokeFlowEntitlement` operation.
    ///
    /// See [`RevokeFlowEntitlement`](crate::client::fluent_builders::RevokeFlowEntitlement) for more information about the
    /// operation and its arguments.
    pub fn revoke_flow_entitlement(&self) -> fluent_builders::RevokeFlowEntitlement<C, M, R> {
        fluent_builders::RevokeFlowEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartFlow` operation.
    ///
    /// See [`StartFlow`](crate::client::fluent_builders::StartFlow) for more information about the
    /// operation and its arguments.
    pub fn start_flow(&self) -> fluent_builders::StartFlow<C, M, R> {
        fluent_builders::StartFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopFlow` operation.
    ///
    /// See [`StopFlow`](crate::client::fluent_builders::StopFlow) for more information about the
    /// operation and its arguments.
    pub fn stop_flow(&self) -> fluent_builders::StopFlow<C, M, R> {
        fluent_builders::StopFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlow` operation.
    ///
    /// See [`UpdateFlow`](crate::client::fluent_builders::UpdateFlow) for more information about the
    /// operation and its arguments.
    pub fn update_flow(&self) -> fluent_builders::UpdateFlow<C, M, R> {
        fluent_builders::UpdateFlow::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlowEntitlement` operation.
    ///
    /// See [`UpdateFlowEntitlement`](crate::client::fluent_builders::UpdateFlowEntitlement) for more information about the
    /// operation and its arguments.
    pub fn update_flow_entitlement(&self) -> fluent_builders::UpdateFlowEntitlement<C, M, R> {
        fluent_builders::UpdateFlowEntitlement::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlowMediaStream` operation.
    ///
    /// See [`UpdateFlowMediaStream`](crate::client::fluent_builders::UpdateFlowMediaStream) for more information about the
    /// operation and its arguments.
    pub fn update_flow_media_stream(&self) -> fluent_builders::UpdateFlowMediaStream<C, M, R> {
        fluent_builders::UpdateFlowMediaStream::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlowOutput` operation.
    ///
    /// See [`UpdateFlowOutput`](crate::client::fluent_builders::UpdateFlowOutput) for more information about the
    /// operation and its arguments.
    pub fn update_flow_output(&self) -> fluent_builders::UpdateFlowOutput<C, M, R> {
        fluent_builders::UpdateFlowOutput::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFlowSource` operation.
    ///
    /// See [`UpdateFlowSource`](crate::client::fluent_builders::UpdateFlowSource) for more information about the
    /// operation and its arguments.
    pub fn update_flow_source(&self) -> fluent_builders::UpdateFlowSource<C, M, R> {
        fluent_builders::UpdateFlowSource::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddFlowMediaStreams`.
    ///
    /// Adds media streams to an existing flow. After you add a media stream to a flow, you can associate it with a source and/or an output that uses the ST 2110 JPEG XS or CDI protocol.
    #[derive(std::fmt::Debug)]
    pub struct AddFlowMediaStreams<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_flow_media_streams_input::Builder,
    }
    impl<C, M, R> AddFlowMediaStreams<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddFlowMediaStreams`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowMediaStreamsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowMediaStreamsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddFlowMediaStreamsInputOperationOutputAlias,
                crate::output::AddFlowMediaStreamsOutput,
                crate::error::AddFlowMediaStreamsError,
                crate::input::AddFlowMediaStreamsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `MediaStreams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you want to add to the flow.
        pub fn media_streams(
            mut self,
            inp: impl Into<crate::model::AddMediaStreamRequest>,
        ) -> Self {
            self.inner = self.inner.media_streams(inp);
            self
        }
        /// The media streams that you want to add to the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        ) -> Self {
            self.inner = self.inner.set_media_streams(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddFlowOutputs`.
    ///
    /// Adds outputs to an existing flow. You can create up to 50 outputs per flow.
    #[derive(std::fmt::Debug)]
    pub struct AddFlowOutputs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_flow_outputs_input::Builder,
    }
    impl<C, M, R> AddFlowOutputs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddFlowOutputs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowOutputsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowOutputsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddFlowOutputsInputOperationOutputAlias,
                crate::output::AddFlowOutputsOutput,
                crate::error::AddFlowOutputsError,
                crate::input::AddFlowOutputsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to add outputs to.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to add outputs to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// A list of outputs that you want to add.
        pub fn outputs(mut self, inp: impl Into<crate::model::AddOutputRequest>) -> Self {
            self.inner = self.inner.outputs(inp);
            self
        }
        /// A list of outputs that you want to add.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddFlowSources`.
    ///
    /// Adds Sources to flow
    #[derive(std::fmt::Debug)]
    pub struct AddFlowSources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_flow_sources_input::Builder,
    }
    impl<C, M, R> AddFlowSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddFlowSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddFlowSourcesInputOperationOutputAlias,
                crate::output::AddFlowSourcesOutput,
                crate::error::AddFlowSourcesError,
                crate::input::AddFlowSourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to mutate.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to mutate.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// A list of sources that you want to add.
        pub fn sources(mut self, inp: impl Into<crate::model::SetSourceRequest>) -> Self {
            self.inner = self.inner.sources(inp);
            self
        }
        /// A list of sources that you want to add.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AddFlowVpcInterfaces`.
    ///
    /// Adds VPC interfaces to flow
    #[derive(std::fmt::Debug)]
    pub struct AddFlowVpcInterfaces<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_flow_vpc_interfaces_input::Builder,
    }
    impl<C, M, R> AddFlowVpcInterfaces<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddFlowVpcInterfaces`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddFlowVpcInterfacesOutput,
            aws_smithy_http::result::SdkError<crate::error::AddFlowVpcInterfacesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddFlowVpcInterfacesInputOperationOutputAlias,
                crate::output::AddFlowVpcInterfacesOutput,
                crate::error::AddFlowVpcInterfacesError,
                crate::input::AddFlowVpcInterfacesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to mutate.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to mutate.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `VpcInterfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// A list of VPC interfaces that you want to add.
        pub fn vpc_interfaces(mut self, inp: impl Into<crate::model::VpcInterfaceRequest>) -> Self {
            self.inner = self.inner.vpc_interfaces(inp);
            self
        }
        /// A list of VPC interfaces that you want to add.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interfaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFlow`.
    ///
    /// Creates a new flow. The request must include one source. The request optionally can include outputs (up to 50) and entitlements (up to 50).
    #[derive(std::fmt::Debug)]
    pub struct CreateFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_flow_input::Builder,
    }
    impl<C, M, R> CreateFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFlowInputOperationOutputAlias,
                crate::output::CreateFlowOutput,
                crate::error::CreateFlowError,
                crate::input::CreateFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
        pub fn availability_zone(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.availability_zone(inp);
            self
        }
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS Region.
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_availability_zone(input);
            self
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The entitlements that you want to grant on a flow.
        pub fn entitlements(
            mut self,
            inp: impl Into<crate::model::GrantEntitlementRequest>,
        ) -> Self {
            self.inner = self.inner.entitlements(inp);
            self
        }
        /// The entitlements that you want to grant on a flow.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// Appends an item to `MediaStreams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
        pub fn media_streams(
            mut self,
            inp: impl Into<crate::model::AddMediaStreamRequest>,
        ) -> Self {
            self.inner = self.inner.media_streams(inp);
            self
        }
        /// The media streams that you want to add to the flow. You can associate these media streams with sources and outputs on the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddMediaStreamRequest>>,
        ) -> Self {
            self.inner = self.inner.set_media_streams(input);
            self
        }
        /// The name of the flow.
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// The name of the flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// Appends an item to `Outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// The outputs that you want to add to this flow.
        pub fn outputs(mut self, inp: impl Into<crate::model::AddOutputRequest>) -> Self {
            self.inner = self.inner.outputs(inp);
            self
        }
        /// The outputs that you want to add to this flow.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::AddOutputRequest>>,
        ) -> Self {
            self.inner = self.inner.set_outputs(input);
            self
        }
        /// The settings for the source of the flow.
        pub fn source(mut self, inp: crate::model::SetSourceRequest) -> Self {
            self.inner = self.inner.source(inp);
            self
        }
        /// The settings for the source of the flow.
        pub fn set_source(
            mut self,
            input: std::option::Option<crate::model::SetSourceRequest>,
        ) -> Self {
            self.inner = self.inner.set_source(input);
            self
        }
        /// The settings for source failover
        pub fn source_failover_config(mut self, inp: crate::model::FailoverConfig) -> Self {
            self.inner = self.inner.source_failover_config(inp);
            self
        }
        /// The settings for source failover
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::FailoverConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_failover_config(input);
            self
        }
        /// Appends an item to `Sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        #[allow(missing_docs)] // documentation missing in model
        pub fn sources(mut self, inp: impl Into<crate::model::SetSourceRequest>) -> Self {
            self.inner = self.inner.sources(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SetSourceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_sources(input);
            self
        }
        /// Appends an item to `VpcInterfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// The VPC interfaces you want on the flow.
        pub fn vpc_interfaces(mut self, inp: impl Into<crate::model::VpcInterfaceRequest>) -> Self {
            self.inner = self.inner.vpc_interfaces(inp);
            self
        }
        /// The VPC interfaces you want on the flow.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterfaceRequest>>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interfaces(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFlow`.
    ///
    /// Deletes a flow. Before you can delete a flow, you must stop the flow.
    #[derive(std::fmt::Debug)]
    pub struct DeleteFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_flow_input::Builder,
    }
    impl<C, M, R> DeleteFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFlowInputOperationOutputAlias,
                crate::output::DeleteFlowOutput,
                crate::error::DeleteFlowError,
                crate::input::DeleteFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to delete.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The ARN of the flow that you want to delete.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeFlow`.
    ///
    /// Displays the details of a flow. The response includes the flow ARN, name, and Availability Zone, as well as details about the source, outputs, and entitlements.
    #[derive(std::fmt::Debug)]
    pub struct DescribeFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_flow_input::Builder,
    }
    impl<C, M, R> DescribeFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeFlowInputOperationOutputAlias,
                crate::output::DescribeFlowOutput,
                crate::error::DescribeFlowError,
                crate::input::DescribeFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to describe.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The ARN of the flow that you want to describe.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOffering`.
    ///
    /// Displays the details of an offering. The response includes the offering description, duration, outbound bandwidth, price, and Amazon Resource Name (ARN).
    #[derive(std::fmt::Debug)]
    pub struct DescribeOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_offering_input::Builder,
    }
    impl<C, M, R> DescribeOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOfferingInputOperationOutputAlias,
                crate::output::DescribeOfferingOutput,
                crate::error::DescribeOfferingError,
                crate::input::DescribeOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn offering_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeReservation`.
    ///
    /// Displays the details of a reservation. The response includes the reservation name, state, start date and time, and the details of the offering that make up the rest of the reservation (such as price, duration, and outbound bandwidth).
    #[derive(std::fmt::Debug)]
    pub struct DescribeReservation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_reservation_input::Builder,
    }
    impl<C, M, R> DescribeReservation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeReservation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeReservationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeReservationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeReservationInputOperationOutputAlias,
                crate::output::DescribeReservationOutput,
                crate::error::DescribeReservationError,
                crate::input::DescribeReservationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the reservation.
        pub fn reservation_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the reservation.
        pub fn set_reservation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GrantFlowEntitlements`.
    ///
    /// Grants entitlements to an existing flow.
    #[derive(std::fmt::Debug)]
    pub struct GrantFlowEntitlements<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::grant_flow_entitlements_input::Builder,
    }
    impl<C, M, R> GrantFlowEntitlements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GrantFlowEntitlements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GrantFlowEntitlementsOutput,
            aws_smithy_http::result::SdkError<crate::error::GrantFlowEntitlementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GrantFlowEntitlementsInputOperationOutputAlias,
                crate::output::GrantFlowEntitlementsOutput,
                crate::error::GrantFlowEntitlementsError,
                crate::input::GrantFlowEntitlementsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The list of entitlements that you want to grant.
        pub fn entitlements(
            mut self,
            inp: impl Into<crate::model::GrantEntitlementRequest>,
        ) -> Self {
            self.inner = self.inner.entitlements(inp);
            self
        }
        /// The list of entitlements that you want to grant.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::GrantEntitlementRequest>>,
        ) -> Self {
            self.inner = self.inner.set_entitlements(input);
            self
        }
        /// The flow that you want to grant entitlements on.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to grant entitlements on.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntitlements`.
    ///
    /// Displays a list of all entitlements that have been granted to this account. This request returns 20 results per page.
    #[derive(std::fmt::Debug)]
    pub struct ListEntitlements<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entitlements_input::Builder,
    }
    impl<C, M, R> ListEntitlements<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntitlements`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitlementsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitlementsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitlementsInputOperationOutputAlias,
                crate::output::ListEntitlementsOutput,
                crate::error::ListEntitlementsError,
                crate::input::ListEntitlementsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListEntitlements request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 20 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFlows`.
    ///
    /// Displays a list of flows that are associated with this account. This request returns a paginated result.
    #[derive(std::fmt::Debug)]
    pub struct ListFlows<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_flows_input::Builder,
    }
    impl<C, M, R> ListFlows<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFlows`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFlowsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFlowsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFlowsInputOperationOutputAlias,
                crate::output::ListFlowsOutput,
                crate::error::ListFlowsError,
                crate::input::ListFlowsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListFlows request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOfferings`.
    ///
    /// Displays a list of all offerings that are available to this account in the current AWS Region. If you have an active reservation (which means you've purchased an offering that has already started and hasn't expired yet), your account isn't eligible for other offerings.
    #[derive(std::fmt::Debug)]
    pub struct ListOfferings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_offerings_input::Builder,
    }
    impl<C, M, R> ListOfferings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOfferings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOfferingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOfferingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOfferingsInputOperationOutputAlias,
                crate::output::ListOfferingsOutput,
                crate::error::ListOfferingsError,
                crate::input::ListOfferingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListOfferings request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListReservations`.
    ///
    /// Displays a list of all reservations that have been purchased by this account in the current AWS Region. This list includes all reservations in all states (such as active and expired).
    #[derive(std::fmt::Debug)]
    pub struct ListReservations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_reservations_input::Builder,
    }
    impl<C, M, R> ListReservations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListReservations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListReservationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListReservationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListReservationsInputOperationOutputAlias,
                crate::output::ListReservationsOutput,
                crate::error::ListReservationsError,
                crate::input::ListReservationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// The maximum number of results to return per API request. For example, you submit a ListReservations request with MaxResults set at 5. Although 20 items match your request, the service returns no more than the first 5 items. (The service also returns a NextToken value that you can use to fetch the next batch of results.) The service might return fewer results than the MaxResults value. If MaxResults is not included in the request, the service defaults to pagination with a maximum of 10 results per page.
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// List all tags on an AWS Elemental MediaConnect resource
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource for which to list the tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PurchaseOffering`.
    ///
    /// Submits a request to purchase an offering. If you already have an active reservation, you can't purchase another offering.
    #[derive(std::fmt::Debug)]
    pub struct PurchaseOffering<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::purchase_offering_input::Builder,
    }
    impl<C, M, R> PurchaseOffering<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PurchaseOffering`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PurchaseOfferingOutput,
            aws_smithy_http::result::SdkError<crate::error::PurchaseOfferingError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PurchaseOfferingInputOperationOutputAlias,
                crate::output::PurchaseOfferingOutput,
                crate::error::PurchaseOfferingError,
                crate::input::PurchaseOfferingInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn offering_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.offering_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_offering_arn(input);
            self
        }
        /// The name that you want to use for the reservation.
        pub fn reservation_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.reservation_name(inp);
            self
        }
        /// The name that you want to use for the reservation.
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_reservation_name(input);
            self
        }
        /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
        pub fn start(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.start(inp);
            self
        }
        /// The date and time that you want the reservation to begin, in Coordinated Universal Time (UTC). You can specify any date and time between 12:00am on the first day of the current month to the current time on today's date, inclusive. Specify the start in a 24-hour notation. Use the following format: YYYY-MM-DDTHH:mm:SSZ, where T and Z are literal characters. For example, to specify 11:30pm on March 5, 2020, enter 2020-03-05T23:30:00Z.
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_start(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowMediaStream`.
    ///
    /// Removes a media stream from a flow. This action is only available if the media stream is not associated with a source or output.
    #[derive(std::fmt::Debug)]
    pub struct RemoveFlowMediaStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_flow_media_stream_input::Builder,
    }
    impl<C, M, R> RemoveFlowMediaStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveFlowMediaStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowMediaStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowMediaStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveFlowMediaStreamInputOperationOutputAlias,
                crate::output::RemoveFlowMediaStreamOutput,
                crate::error::RemoveFlowMediaStreamError,
                crate::input::RemoveFlowMediaStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The name of the media stream that you want to remove.
        pub fn media_stream_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_stream_name(inp);
            self
        }
        /// The name of the media stream that you want to remove.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_stream_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowOutput`.
    ///
    /// Removes an output from an existing flow. This request can be made only on an output that does not have an entitlement associated with it. If the output has an entitlement, you must revoke the entitlement instead. When an entitlement is revoked from a flow, the service automatically removes the associated output.
    #[derive(std::fmt::Debug)]
    pub struct RemoveFlowOutput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_flow_output_input::Builder,
    }
    impl<C, M, R> RemoveFlowOutput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveFlowOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowOutputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveFlowOutputInputOperationOutputAlias,
                crate::output::RemoveFlowOutputOutput,
                crate::error::RemoveFlowOutputError,
                crate::input::RemoveFlowOutputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to remove an output from.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to remove an output from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The ARN of the output that you want to remove.
        pub fn output_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_arn(inp);
            self
        }
        /// The ARN of the output that you want to remove.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowSource`.
    ///
    /// Removes a source from an existing flow. This request can be made only if there is more than one source on the flow.
    #[derive(std::fmt::Debug)]
    pub struct RemoveFlowSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_flow_source_input::Builder,
    }
    impl<C, M, R> RemoveFlowSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveFlowSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveFlowSourceInputOperationOutputAlias,
                crate::output::RemoveFlowSourceOutput,
                crate::error::RemoveFlowSourceError,
                crate::input::RemoveFlowSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to remove a source from.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to remove a source from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The ARN of the source that you want to remove.
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// The ARN of the source that you want to remove.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RemoveFlowVpcInterface`.
    ///
    /// Removes a VPC Interface from an existing flow. This request can be made only on a VPC interface that does not have a Source or Output associated with it. If the VPC interface is referenced by a Source or Output, you must first delete or update the Source or Output to no longer reference the VPC interface.
    #[derive(std::fmt::Debug)]
    pub struct RemoveFlowVpcInterface<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::remove_flow_vpc_interface_input::Builder,
    }
    impl<C, M, R> RemoveFlowVpcInterface<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RemoveFlowVpcInterface`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RemoveFlowVpcInterfaceOutput,
            aws_smithy_http::result::SdkError<crate::error::RemoveFlowVpcInterfaceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RemoveFlowVpcInterfaceInputOperationOutputAlias,
                crate::output::RemoveFlowVpcInterfaceOutput,
                crate::error::RemoveFlowVpcInterfaceError,
                crate::input::RemoveFlowVpcInterfaceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to remove a VPC interface from.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to remove a VPC interface from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The name of the VPC interface that you want to remove.
        pub fn vpc_interface_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_interface_name(inp);
            self
        }
        /// The name of the VPC interface that you want to remove.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interface_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RevokeFlowEntitlement`.
    ///
    /// Revokes an entitlement from a flow. Once an entitlement is revoked, the content becomes unavailable to the subscriber and the associated output is removed.
    #[derive(std::fmt::Debug)]
    pub struct RevokeFlowEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::revoke_flow_entitlement_input::Builder,
    }
    impl<C, M, R> RevokeFlowEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RevokeFlowEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RevokeFlowEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::RevokeFlowEntitlementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RevokeFlowEntitlementInputOperationOutputAlias,
                crate::output::RevokeFlowEntitlementOutput,
                crate::error::RevokeFlowEntitlementError,
                crate::input::RevokeFlowEntitlementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the entitlement that you want to revoke.
        pub fn entitlement_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_arn(inp);
            self
        }
        /// The ARN of the entitlement that you want to revoke.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_arn(input);
            self
        }
        /// The flow that you want to revoke an entitlement from.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to revoke an entitlement from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartFlow`.
    ///
    /// Starts a flow.
    #[derive(std::fmt::Debug)]
    pub struct StartFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_flow_input::Builder,
    }
    impl<C, M, R> StartFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StartFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartFlowInputOperationOutputAlias,
                crate::output::StartFlowOutput,
                crate::error::StartFlowError,
                crate::input::StartFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to start.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The ARN of the flow that you want to start.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopFlow`.
    ///
    /// Stops a flow.
    #[derive(std::fmt::Debug)]
    pub struct StopFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_flow_input::Builder,
    }
    impl<C, M, R> StopFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::StopFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopFlowInputOperationOutputAlias,
                crate::output::StopFlowOutput,
                crate::error::StopFlowError,
                crate::input::StopFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The ARN of the flow that you want to stop.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The ARN of the flow that you want to stop.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// Associates the specified tags to a resource with the specified resourceArn. If existing tags on a resource are not specified in the request parameters, they are not changed. When a resource is deleted, the tags associated with that resource are deleted as well.
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource to which to add tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// Deletes specified tags from a resource.
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) that identifies the AWS Elemental MediaConnect resource from which to delete tags.
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// The keys of the tags to be removed.
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// The keys of the tags to be removed.
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlow`.
    ///
    /// Updates flow
    #[derive(std::fmt::Debug)]
    pub struct UpdateFlow<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_input::Builder,
    }
    impl<C, M, R> UpdateFlow<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlow`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowInputOperationOutputAlias,
                crate::output::UpdateFlowOutput,
                crate::error::UpdateFlowError,
                crate::input::UpdateFlowInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The flow that you want to update.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The settings for source failover
        pub fn source_failover_config(mut self, inp: crate::model::UpdateFailoverConfig) -> Self {
            self.inner = self.inner.source_failover_config(inp);
            self
        }
        /// The settings for source failover
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::UpdateFailoverConfig>,
        ) -> Self {
            self.inner = self.inner.set_source_failover_config(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowEntitlement`.
    ///
    /// You can change an entitlement's description, subscribers, and encryption. If you change the subscribers, the service will remove the outputs that are are used by the subscribers that are removed.
    #[derive(std::fmt::Debug)]
    pub struct UpdateFlowEntitlement<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_entitlement_input::Builder,
    }
    impl<C, M, R> UpdateFlowEntitlement<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlowEntitlement`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowEntitlementOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowEntitlementError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowEntitlementInputOperationOutputAlias,
                crate::output::UpdateFlowEntitlementOutput,
                crate::error::UpdateFlowEntitlementError,
                crate::input::UpdateFlowEntitlementInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The type of encryption that will be used on the output associated with this entitlement.
        pub fn encryption(mut self, inp: crate::model::UpdateEncryption) -> Self {
            self.inner = self.inner.encryption(inp);
            self
        }
        /// The type of encryption that will be used on the output associated with this entitlement.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.inner = self.inner.set_encryption(input);
            self
        }
        /// The ARN of the entitlement that you want to update.
        pub fn entitlement_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_arn(inp);
            self
        }
        /// The ARN of the entitlement that you want to update.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_arn(input);
            self
        }
        /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
        pub fn entitlement_status(mut self, inp: crate::model::EntitlementStatus) -> Self {
            self.inner = self.inner.entitlement_status(inp);
            self
        }
        /// An indication of whether you want to enable the entitlement to allow access, or disable it to stop streaming content to the subscriber’s flow temporarily. If you don’t specify the entitlementStatus field in your request, MediaConnect leaves the value unchanged.
        pub fn set_entitlement_status(
            mut self,
            input: std::option::Option<crate::model::EntitlementStatus>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_status(input);
            self
        }
        /// The flow that is associated with the entitlement that you want to update.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that is associated with the entitlement that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// Appends an item to `Subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn subscribers(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.subscribers(inp);
            self
        }
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_subscribers(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowMediaStream`.
    ///
    /// Updates an existing media stream.
    #[derive(std::fmt::Debug)]
    pub struct UpdateFlowMediaStream<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_media_stream_input::Builder,
    }
    impl<C, M, R> UpdateFlowMediaStream<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlowMediaStream`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowMediaStreamOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowMediaStreamError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowMediaStreamInputOperationOutputAlias,
                crate::output::UpdateFlowMediaStreamOutput,
                crate::error::UpdateFlowMediaStreamError,
                crate::input::UpdateFlowMediaStreamInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The attributes that you want to assign to the media stream.
        pub fn attributes(mut self, inp: crate::model::MediaStreamAttributesRequest) -> Self {
            self.inner = self.inner.attributes(inp);
            self
        }
        /// The attributes that you want to assign to the media stream.
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::MediaStreamAttributesRequest>,
        ) -> Self {
            self.inner = self.inner.set_attributes(input);
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn clock_rate(mut self, inp: i32) -> Self {
            self.inner = self.inner.clock_rate(inp);
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn set_clock_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_clock_rate(input);
            self
        }
        /// Description
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// Description
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The name of the media stream that you want to update.
        pub fn media_stream_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.media_stream_name(inp);
            self
        }
        /// The name of the media stream that you want to update.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_media_stream_name(input);
            self
        }
        /// The type of media stream.
        pub fn media_stream_type(mut self, inp: crate::model::MediaStreamType) -> Self {
            self.inner = self.inner.media_stream_type(inp);
            self
        }
        /// The type of media stream.
        pub fn set_media_stream_type(
            mut self,
            input: std::option::Option<crate::model::MediaStreamType>,
        ) -> Self {
            self.inner = self.inner.set_media_stream_type(input);
            self
        }
        /// The resolution of the video.
        pub fn video_format(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.video_format(inp);
            self
        }
        /// The resolution of the video.
        pub fn set_video_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_video_format(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowOutput`.
    ///
    /// Updates an existing flow output.
    #[derive(std::fmt::Debug)]
    pub struct UpdateFlowOutput<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_output_input::Builder,
    }
    impl<C, M, R> UpdateFlowOutput<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlowOutput`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowOutputOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowOutputError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowOutputInputOperationOutputAlias,
                crate::output::UpdateFlowOutputOutput,
                crate::error::UpdateFlowOutputError,
                crate::input::UpdateFlowOutputInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `CidrAllowList`.
        ///
        /// To override the contents of this collection use [`set_cidr_allow_list`](Self::set_cidr_allow_list).
        ///
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn cidr_allow_list(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.cidr_allow_list(inp);
            self
        }
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_cidr_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_cidr_allow_list(input);
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The IP address where you want to send the output.
        pub fn destination(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.destination(inp);
            self
        }
        /// The IP address where you want to send the output.
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_destination(input);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn encryption(mut self, inp: crate::model::UpdateEncryption) -> Self {
            self.inner = self.inner.encryption(inp);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.inner = self.inner.set_encryption(input);
            self
        }
        /// The flow that is associated with the output that you want to update.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that is associated with the output that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The maximum latency in milliseconds for Zixi-based streams.
        pub fn max_latency(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_latency(inp);
            self
        }
        /// The maximum latency in milliseconds for Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_latency(input);
            self
        }
        /// Appends an item to `MediaStreamOutputConfigurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_output_configurations`](Self::set_media_stream_output_configurations).
        ///
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn media_stream_output_configurations(
            mut self,
            inp: impl Into<crate::model::MediaStreamOutputConfigurationRequest>,
        ) -> Self {
            self.inner = self.inner.media_stream_output_configurations(inp);
            self
        }
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn set_media_stream_output_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_media_stream_output_configurations(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_latency(inp);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_latency(input);
            self
        }
        /// The ARN of the output that you want to update.
        pub fn output_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_arn(inp);
            self
        }
        /// The ARN of the output that you want to update.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_arn(input);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn port(mut self, inp: i32) -> Self {
            self.inner = self.inner.port(inp);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_port(input);
            self
        }
        /// The protocol to use for the output.
        pub fn protocol(mut self, inp: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// The protocol to use for the output.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn remote_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.remote_id(inp);
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn set_remote_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_remote_id(input);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn smoothing_latency(mut self, inp: i32) -> Self {
            self.inner = self.inner.smoothing_latency(inp);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn set_smoothing_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_smoothing_latency(input);
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(inp);
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn vpc_interface_attachment(
            mut self,
            inp: crate::model::VpcInterfaceAttachment,
        ) -> Self {
            self.inner = self.inner.vpc_interface_attachment(inp);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn set_vpc_interface_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcInterfaceAttachment>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interface_attachment(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFlowSource`.
    ///
    /// Updates the source of a flow.
    #[derive(std::fmt::Debug)]
    pub struct UpdateFlowSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_flow_source_input::Builder,
    }
    impl<C, M, R> UpdateFlowSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFlowSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFlowSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFlowSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFlowSourceInputOperationOutputAlias,
                crate::output::UpdateFlowSourceOutput,
                crate::error::UpdateFlowSourceError,
                crate::input::UpdateFlowSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// The type of encryption used on the content ingested from this source.
        pub fn decryption(mut self, inp: crate::model::UpdateEncryption) -> Self {
            self.inner = self.inner.decryption(inp);
            self
        }
        /// The type of encryption used on the content ingested from this source.
        pub fn set_decryption(
            mut self,
            input: std::option::Option<crate::model::UpdateEncryption>,
        ) -> Self {
            self.inner = self.inner.set_decryption(input);
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn entitlement_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entitlement_arn(inp);
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_entitlement_arn(input);
            self
        }
        /// The flow that is associated with the source that you want to update.
        pub fn flow_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.flow_arn(inp);
            self
        }
        /// The flow that is associated with the source that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_flow_arn(input);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn ingest_port(mut self, inp: i32) -> Self {
            self.inner = self.inner.ingest_port(inp);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn set_ingest_port(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_ingest_port(input);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn max_bitrate(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_bitrate(inp);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_bitrate(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn max_latency(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_latency(inp);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_latency(input);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn max_sync_buffer(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_sync_buffer(inp);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn set_max_sync_buffer(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_sync_buffer(input);
            self
        }
        /// Appends an item to `MediaStreamSourceConfigurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_source_configurations`](Self::set_media_stream_source_configurations).
        ///
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn media_stream_source_configurations(
            mut self,
            inp: impl Into<crate::model::MediaStreamSourceConfigurationRequest>,
        ) -> Self {
            self.inner = self.inner.media_stream_source_configurations(inp);
            self
        }
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn set_media_stream_source_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>,
            >,
        ) -> Self {
            self.inner = self.inner.set_media_stream_source_configurations(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_latency(inp);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_latency(input);
            self
        }
        /// The protocol that is used by the source.
        pub fn protocol(mut self, inp: crate::model::Protocol) -> Self {
            self.inner = self.inner.protocol(inp);
            self
        }
        /// The protocol that is used by the source.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.inner = self.inner.set_protocol(input);
            self
        }
        /// The ARN of the source that you want to update.
        pub fn source_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_arn(inp);
            self
        }
        /// The ARN of the source that you want to update.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_source_arn(input);
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.stream_id(inp);
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_stream_id(input);
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn vpc_interface_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.vpc_interface_name(inp);
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_vpc_interface_name(input);
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn whitelist_cidr(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.whitelist_cidr(inp);
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_whitelist_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_whitelist_cidr(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
