// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowSourceOutput {
    /// The ARN of the flow that you want to update.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The settings for the source of the flow.
    pub source: std::option::Option<crate::model::Source>,
}
impl UpdateFlowSourceOutput {
    /// The ARN of the flow that you want to update.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The settings for the source of the flow.
    pub fn source(&self) -> std::option::Option<&crate::model::Source> {
        self.source.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowSourceOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("source", &self.source);
        formatter.finish()
    }
}
/// See [`UpdateFlowSourceOutput`](crate::output::UpdateFlowSourceOutput)
pub mod update_flow_source_output {
    /// A builder for [`UpdateFlowSourceOutput`](crate::output::UpdateFlowSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) source: std::option::Option<crate::model::Source>,
    }
    impl Builder {
        /// The ARN of the flow that you want to update.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you want to update.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The settings for the source of the flow.
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// The settings for the source of the flow.
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowSourceOutput`](crate::output::UpdateFlowSourceOutput)
        pub fn build(self) -> crate::output::UpdateFlowSourceOutput {
            crate::output::UpdateFlowSourceOutput {
                flow_arn: self.flow_arn,
                source: self.source,
            }
        }
    }
}
impl UpdateFlowSourceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowSourceOutput`](crate::output::UpdateFlowSourceOutput)
    pub fn builder() -> crate::output::update_flow_source_output::Builder {
        crate::output::update_flow_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowOutputOutput {
    /// The ARN of the flow that is associated with the updated output.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The new settings of the output that you updated.
    pub output: std::option::Option<crate::model::Output>,
}
impl UpdateFlowOutputOutput {
    /// The ARN of the flow that is associated with the updated output.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The new settings of the output that you updated.
    pub fn output(&self) -> std::option::Option<&crate::model::Output> {
        self.output.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowOutputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowOutputOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("output", &self.output);
        formatter.finish()
    }
}
/// See [`UpdateFlowOutputOutput`](crate::output::UpdateFlowOutputOutput)
pub mod update_flow_output_output {
    /// A builder for [`UpdateFlowOutputOutput`](crate::output::UpdateFlowOutputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) output: std::option::Option<crate::model::Output>,
    }
    impl Builder {
        /// The ARN of the flow that is associated with the updated output.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that is associated with the updated output.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The new settings of the output that you updated.
        pub fn output(mut self, input: crate::model::Output) -> Self {
            self.output = Some(input);
            self
        }
        /// The new settings of the output that you updated.
        pub fn set_output(mut self, input: std::option::Option<crate::model::Output>) -> Self {
            self.output = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowOutputOutput`](crate::output::UpdateFlowOutputOutput)
        pub fn build(self) -> crate::output::UpdateFlowOutputOutput {
            crate::output::UpdateFlowOutputOutput {
                flow_arn: self.flow_arn,
                output: self.output,
            }
        }
    }
}
impl UpdateFlowOutputOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowOutputOutput`](crate::output::UpdateFlowOutputOutput)
    pub fn builder() -> crate::output::update_flow_output_output::Builder {
        crate::output::update_flow_output_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowMediaStreamOutput {
    /// The ARN of the flow that is associated with the media stream that you updated.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The media stream that you updated.
    pub media_stream: std::option::Option<crate::model::MediaStream>,
}
impl UpdateFlowMediaStreamOutput {
    /// The ARN of the flow that is associated with the media stream that you updated.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The media stream that you updated.
    pub fn media_stream(&self) -> std::option::Option<&crate::model::MediaStream> {
        self.media_stream.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowMediaStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowMediaStreamOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_stream", &self.media_stream);
        formatter.finish()
    }
}
/// See [`UpdateFlowMediaStreamOutput`](crate::output::UpdateFlowMediaStreamOutput)
pub mod update_flow_media_stream_output {
    /// A builder for [`UpdateFlowMediaStreamOutput`](crate::output::UpdateFlowMediaStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_stream: std::option::Option<crate::model::MediaStream>,
    }
    impl Builder {
        /// The ARN of the flow that is associated with the media stream that you updated.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that is associated with the media stream that you updated.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The media stream that you updated.
        pub fn media_stream(mut self, input: crate::model::MediaStream) -> Self {
            self.media_stream = Some(input);
            self
        }
        /// The media stream that you updated.
        pub fn set_media_stream(
            mut self,
            input: std::option::Option<crate::model::MediaStream>,
        ) -> Self {
            self.media_stream = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowMediaStreamOutput`](crate::output::UpdateFlowMediaStreamOutput)
        pub fn build(self) -> crate::output::UpdateFlowMediaStreamOutput {
            crate::output::UpdateFlowMediaStreamOutput {
                flow_arn: self.flow_arn,
                media_stream: self.media_stream,
            }
        }
    }
}
impl UpdateFlowMediaStreamOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowMediaStreamOutput`](crate::output::UpdateFlowMediaStreamOutput)
    pub fn builder() -> crate::output::update_flow_media_stream_output::Builder {
        crate::output::update_flow_media_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowEntitlementOutput {
    /// The new configuration of the entitlement that you updated.
    pub entitlement: std::option::Option<crate::model::Entitlement>,
    /// The ARN of the flow that this entitlement was granted on.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl UpdateFlowEntitlementOutput {
    /// The new configuration of the entitlement that you updated.
    pub fn entitlement(&self) -> std::option::Option<&crate::model::Entitlement> {
        self.entitlement.as_ref()
    }
    /// The ARN of the flow that this entitlement was granted on.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for UpdateFlowEntitlementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowEntitlementOutput");
        formatter.field("entitlement", &self.entitlement);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}
/// See [`UpdateFlowEntitlementOutput`](crate::output::UpdateFlowEntitlementOutput)
pub mod update_flow_entitlement_output {
    /// A builder for [`UpdateFlowEntitlementOutput`](crate::output::UpdateFlowEntitlementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlement: std::option::Option<crate::model::Entitlement>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The new configuration of the entitlement that you updated.
        pub fn entitlement(mut self, input: crate::model::Entitlement) -> Self {
            self.entitlement = Some(input);
            self
        }
        /// The new configuration of the entitlement that you updated.
        pub fn set_entitlement(
            mut self,
            input: std::option::Option<crate::model::Entitlement>,
        ) -> Self {
            self.entitlement = input;
            self
        }
        /// The ARN of the flow that this entitlement was granted on.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that this entitlement was granted on.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowEntitlementOutput`](crate::output::UpdateFlowEntitlementOutput)
        pub fn build(self) -> crate::output::UpdateFlowEntitlementOutput {
            crate::output::UpdateFlowEntitlementOutput {
                entitlement: self.entitlement,
                flow_arn: self.flow_arn,
            }
        }
    }
}
impl UpdateFlowEntitlementOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowEntitlementOutput`](crate::output::UpdateFlowEntitlementOutput)
    pub fn builder() -> crate::output::update_flow_entitlement_output::Builder {
        crate::output::update_flow_entitlement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFlowOutput {
    /// The settings for a flow, including its source, outputs, and entitlements.
    pub flow: std::option::Option<crate::model::Flow>,
}
impl UpdateFlowOutput {
    /// The settings for a flow, including its source, outputs, and entitlements.
    pub fn flow(&self) -> std::option::Option<&crate::model::Flow> {
        self.flow.as_ref()
    }
}
impl std::fmt::Debug for UpdateFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFlowOutput");
        formatter.field("flow", &self.flow);
        formatter.finish()
    }
}
/// See [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
pub mod update_flow_output {
    /// A builder for [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow: std::option::Option<crate::model::Flow>,
    }
    impl Builder {
        /// The settings for a flow, including its source, outputs, and entitlements.
        pub fn flow(mut self, input: crate::model::Flow) -> Self {
            self.flow = Some(input);
            self
        }
        /// The settings for a flow, including its source, outputs, and entitlements.
        pub fn set_flow(mut self, input: std::option::Option<crate::model::Flow>) -> Self {
            self.flow = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
        pub fn build(self) -> crate::output::UpdateFlowOutput {
            crate::output::UpdateFlowOutput { flow: self.flow }
        }
    }
}
impl UpdateFlowOutput {
    /// Creates a new builder-style object to manufacture [`UpdateFlowOutput`](crate::output::UpdateFlowOutput)
    pub fn builder() -> crate::output::update_flow_output::Builder {
        crate::output::update_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopFlowOutput {
    /// The ARN of the flow that you stopped.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The status of the flow when the StopFlow process begins.
    pub status: std::option::Option<crate::model::Status>,
}
impl StopFlowOutput {
    /// The ARN of the flow that you stopped.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The status of the flow when the StopFlow process begins.
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StopFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StopFlowOutput`](crate::output::StopFlowOutput)
pub mod stop_flow_output {
    /// A builder for [`StopFlowOutput`](crate::output::StopFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The ARN of the flow that you stopped.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you stopped.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The status of the flow when the StopFlow process begins.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of the flow when the StopFlow process begins.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StopFlowOutput`](crate::output::StopFlowOutput)
        pub fn build(self) -> crate::output::StopFlowOutput {
            crate::output::StopFlowOutput {
                flow_arn: self.flow_arn,
                status: self.status,
            }
        }
    }
}
impl StopFlowOutput {
    /// Creates a new builder-style object to manufacture [`StopFlowOutput`](crate::output::StopFlowOutput)
    pub fn builder() -> crate::output::stop_flow_output::Builder {
        crate::output::stop_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartFlowOutput {
    /// The ARN of the flow that you started.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The status of the flow when the StartFlow process begins.
    pub status: std::option::Option<crate::model::Status>,
}
impl StartFlowOutput {
    /// The ARN of the flow that you started.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The status of the flow when the StartFlow process begins.
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StartFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StartFlowOutput`](crate::output::StartFlowOutput)
pub mod start_flow_output {
    /// A builder for [`StartFlowOutput`](crate::output::StartFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The ARN of the flow that you started.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you started.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The status of the flow when the StartFlow process begins.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of the flow when the StartFlow process begins.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartFlowOutput`](crate::output::StartFlowOutput)
        pub fn build(self) -> crate::output::StartFlowOutput {
            crate::output::StartFlowOutput {
                flow_arn: self.flow_arn,
                status: self.status,
            }
        }
    }
}
impl StartFlowOutput {
    /// Creates a new builder-style object to manufacture [`StartFlowOutput`](crate::output::StartFlowOutput)
    pub fn builder() -> crate::output::start_flow_output::Builder {
        crate::output::start_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RevokeFlowEntitlementOutput {
    /// The ARN of the entitlement that was revoked.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The ARN of the flow that the entitlement was revoked from.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl RevokeFlowEntitlementOutput {
    /// The ARN of the entitlement that was revoked.
    pub fn entitlement_arn(&self) -> std::option::Option<&str> {
        self.entitlement_arn.as_deref()
    }
    /// The ARN of the flow that the entitlement was revoked from.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for RevokeFlowEntitlementOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RevokeFlowEntitlementOutput");
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}
/// See [`RevokeFlowEntitlementOutput`](crate::output::RevokeFlowEntitlementOutput)
pub mod revoke_flow_entitlement_output {
    /// A builder for [`RevokeFlowEntitlementOutput`](crate::output::RevokeFlowEntitlementOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the entitlement that was revoked.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement that was revoked.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The ARN of the flow that the entitlement was revoked from.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that the entitlement was revoked from.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RevokeFlowEntitlementOutput`](crate::output::RevokeFlowEntitlementOutput)
        pub fn build(self) -> crate::output::RevokeFlowEntitlementOutput {
            crate::output::RevokeFlowEntitlementOutput {
                entitlement_arn: self.entitlement_arn,
                flow_arn: self.flow_arn,
            }
        }
    }
}
impl RevokeFlowEntitlementOutput {
    /// Creates a new builder-style object to manufacture [`RevokeFlowEntitlementOutput`](crate::output::RevokeFlowEntitlementOutput)
    pub fn builder() -> crate::output::revoke_flow_entitlement_output::Builder {
        crate::output::revoke_flow_entitlement_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowVpcInterfaceOutput {
    /// The ARN of the flow that is associated with the VPC interface you removed.
    pub flow_arn: std::option::Option<std::string::String>,
    /// IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
    pub non_deleted_network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The name of the VPC interface that was removed.
    pub vpc_interface_name: std::option::Option<std::string::String>,
}
impl RemoveFlowVpcInterfaceOutput {
    /// The ARN of the flow that is associated with the VPC interface you removed.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
    pub fn non_deleted_network_interface_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.non_deleted_network_interface_ids.as_deref()
    }
    /// The name of the VPC interface that was removed.
    pub fn vpc_interface_name(&self) -> std::option::Option<&str> {
        self.vpc_interface_name.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowVpcInterfaceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowVpcInterfaceOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field(
            "non_deleted_network_interface_ids",
            &self.non_deleted_network_interface_ids,
        );
        formatter.field("vpc_interface_name", &self.vpc_interface_name);
        formatter.finish()
    }
}
/// See [`RemoveFlowVpcInterfaceOutput`](crate::output::RemoveFlowVpcInterfaceOutput)
pub mod remove_flow_vpc_interface_output {
    /// A builder for [`RemoveFlowVpcInterfaceOutput`](crate::output::RemoveFlowVpcInterfaceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) non_deleted_network_interface_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) vpc_interface_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that is associated with the VPC interface you removed.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that is associated with the VPC interface you removed.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `non_deleted_network_interface_ids`.
        ///
        /// To override the contents of this collection use [`set_non_deleted_network_interface_ids`](Self::set_non_deleted_network_interface_ids).
        ///
        /// IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
        pub fn non_deleted_network_interface_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.non_deleted_network_interface_ids.unwrap_or_default();
            v.push(input.into());
            self.non_deleted_network_interface_ids = Some(v);
            self
        }
        /// IDs of network interfaces associated with the removed VPC interface that Media Connect was unable to remove.
        pub fn set_non_deleted_network_interface_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.non_deleted_network_interface_ids = input;
            self
        }
        /// The name of the VPC interface that was removed.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_interface_name = Some(input.into());
            self
        }
        /// The name of the VPC interface that was removed.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_interface_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowVpcInterfaceOutput`](crate::output::RemoveFlowVpcInterfaceOutput)
        pub fn build(self) -> crate::output::RemoveFlowVpcInterfaceOutput {
            crate::output::RemoveFlowVpcInterfaceOutput {
                flow_arn: self.flow_arn,
                non_deleted_network_interface_ids: self.non_deleted_network_interface_ids,
                vpc_interface_name: self.vpc_interface_name,
            }
        }
    }
}
impl RemoveFlowVpcInterfaceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFlowVpcInterfaceOutput`](crate::output::RemoveFlowVpcInterfaceOutput)
    pub fn builder() -> crate::output::remove_flow_vpc_interface_output::Builder {
        crate::output::remove_flow_vpc_interface_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowSourceOutput {
    /// The ARN of the flow that is associated with the source you removed.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The ARN of the source that was removed.
    pub source_arn: std::option::Option<std::string::String>,
}
impl RemoveFlowSourceOutput {
    /// The ARN of the flow that is associated with the source you removed.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The ARN of the source that was removed.
    pub fn source_arn(&self) -> std::option::Option<&str> {
        self.source_arn.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowSourceOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("source_arn", &self.source_arn);
        formatter.finish()
    }
}
/// See [`RemoveFlowSourceOutput`](crate::output::RemoveFlowSourceOutput)
pub mod remove_flow_source_output {
    /// A builder for [`RemoveFlowSourceOutput`](crate::output::RemoveFlowSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that is associated with the source you removed.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that is associated with the source you removed.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The ARN of the source that was removed.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// The ARN of the source that was removed.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowSourceOutput`](crate::output::RemoveFlowSourceOutput)
        pub fn build(self) -> crate::output::RemoveFlowSourceOutput {
            crate::output::RemoveFlowSourceOutput {
                flow_arn: self.flow_arn,
                source_arn: self.source_arn,
            }
        }
    }
}
impl RemoveFlowSourceOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFlowSourceOutput`](crate::output::RemoveFlowSourceOutput)
    pub fn builder() -> crate::output::remove_flow_source_output::Builder {
        crate::output::remove_flow_source_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowOutputOutput {
    /// The ARN of the flow that is associated with the output you removed.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The ARN of the output that was removed.
    pub output_arn: std::option::Option<std::string::String>,
}
impl RemoveFlowOutputOutput {
    /// The ARN of the flow that is associated with the output you removed.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The ARN of the output that was removed.
    pub fn output_arn(&self) -> std::option::Option<&str> {
        self.output_arn.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowOutputOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowOutputOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("output_arn", &self.output_arn);
        formatter.finish()
    }
}
/// See [`RemoveFlowOutputOutput`](crate::output::RemoveFlowOutputOutput)
pub mod remove_flow_output_output {
    /// A builder for [`RemoveFlowOutputOutput`](crate::output::RemoveFlowOutputOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) output_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The ARN of the flow that is associated with the output you removed.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that is associated with the output you removed.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The ARN of the output that was removed.
        pub fn output_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_arn = Some(input.into());
            self
        }
        /// The ARN of the output that was removed.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowOutputOutput`](crate::output::RemoveFlowOutputOutput)
        pub fn build(self) -> crate::output::RemoveFlowOutputOutput {
            crate::output::RemoveFlowOutputOutput {
                flow_arn: self.flow_arn,
                output_arn: self.output_arn,
            }
        }
    }
}
impl RemoveFlowOutputOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFlowOutputOutput`](crate::output::RemoveFlowOutputOutput)
    pub fn builder() -> crate::output::remove_flow_output_output::Builder {
        crate::output::remove_flow_output_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveFlowMediaStreamOutput {
    /// The Amazon Resource Name (ARN) of the flow.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The name of the media stream that was removed.
    pub media_stream_name: std::option::Option<std::string::String>,
}
impl RemoveFlowMediaStreamOutput {
    /// The Amazon Resource Name (ARN) of the flow.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The name of the media stream that was removed.
    pub fn media_stream_name(&self) -> std::option::Option<&str> {
        self.media_stream_name.as_deref()
    }
}
impl std::fmt::Debug for RemoveFlowMediaStreamOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveFlowMediaStreamOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.finish()
    }
}
/// See [`RemoveFlowMediaStreamOutput`](crate::output::RemoveFlowMediaStreamOutput)
pub mod remove_flow_media_stream_output {
    /// A builder for [`RemoveFlowMediaStreamOutput`](crate::output::RemoveFlowMediaStreamOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The name of the media stream that was removed.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream that was removed.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveFlowMediaStreamOutput`](crate::output::RemoveFlowMediaStreamOutput)
        pub fn build(self) -> crate::output::RemoveFlowMediaStreamOutput {
            crate::output::RemoveFlowMediaStreamOutput {
                flow_arn: self.flow_arn,
                media_stream_name: self.media_stream_name,
            }
        }
    }
}
impl RemoveFlowMediaStreamOutput {
    /// Creates a new builder-style object to manufacture [`RemoveFlowMediaStreamOutput`](crate::output::RemoveFlowMediaStreamOutput)
    pub fn builder() -> crate::output::remove_flow_media_stream_output::Builder {
        crate::output::remove_flow_media_stream_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PurchaseOfferingOutput {
    /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
    pub reservation: std::option::Option<crate::model::Reservation>,
}
impl PurchaseOfferingOutput {
    /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
    pub fn reservation(&self) -> std::option::Option<&crate::model::Reservation> {
        self.reservation.as_ref()
    }
}
impl std::fmt::Debug for PurchaseOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PurchaseOfferingOutput");
        formatter.field("reservation", &self.reservation);
        formatter.finish()
    }
}
/// See [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
pub mod purchase_offering_output {
    /// A builder for [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation: std::option::Option<crate::model::Reservation>,
    }
    impl Builder {
        /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
        pub fn reservation(mut self, input: crate::model::Reservation) -> Self {
            self.reservation = Some(input);
            self
        }
        /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
        pub fn set_reservation(
            mut self,
            input: std::option::Option<crate::model::Reservation>,
        ) -> Self {
            self.reservation = input;
            self
        }
        /// Consumes the builder and constructs a [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
        pub fn build(self) -> crate::output::PurchaseOfferingOutput {
            crate::output::PurchaseOfferingOutput {
                reservation: self.reservation,
            }
        }
    }
}
impl PurchaseOfferingOutput {
    /// Creates a new builder-style object to manufacture [`PurchaseOfferingOutput`](crate::output::PurchaseOfferingOutput)
    pub fn builder() -> crate::output::purchase_offering_output::Builder {
        crate::output::purchase_offering_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl ListTagsForResourceOutput {
    /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// A map from tag keys to values. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListReservationsOutput {
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
    /// A list of all reservations that have been purchased by this account in the current AWS Region.
    pub reservations: std::option::Option<std::vec::Vec<crate::model::Reservation>>,
}
impl ListReservationsOutput {
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// A list of all reservations that have been purchased by this account in the current AWS Region.
    pub fn reservations(&self) -> std::option::Option<&[crate::model::Reservation]> {
        self.reservations.as_deref()
    }
}
impl std::fmt::Debug for ListReservationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListReservationsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("reservations", &self.reservations);
        formatter.finish()
    }
}
/// See [`ListReservationsOutput`](crate::output::ListReservationsOutput)
pub mod list_reservations_output {
    /// A builder for [`ListReservationsOutput`](crate::output::ListReservationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) reservations: std::option::Option<std::vec::Vec<crate::model::Reservation>>,
    }
    impl Builder {
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListReservations request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListReservations request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `reservations`.
        ///
        /// To override the contents of this collection use [`set_reservations`](Self::set_reservations).
        ///
        /// A list of all reservations that have been purchased by this account in the current AWS Region.
        pub fn reservations(mut self, input: impl Into<crate::model::Reservation>) -> Self {
            let mut v = self.reservations.unwrap_or_default();
            v.push(input.into());
            self.reservations = Some(v);
            self
        }
        /// A list of all reservations that have been purchased by this account in the current AWS Region.
        pub fn set_reservations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Reservation>>,
        ) -> Self {
            self.reservations = input;
            self
        }
        /// Consumes the builder and constructs a [`ListReservationsOutput`](crate::output::ListReservationsOutput)
        pub fn build(self) -> crate::output::ListReservationsOutput {
            crate::output::ListReservationsOutput {
                next_token: self.next_token,
                reservations: self.reservations,
            }
        }
    }
}
impl ListReservationsOutput {
    /// Creates a new builder-style object to manufacture [`ListReservationsOutput`](crate::output::ListReservationsOutput)
    pub fn builder() -> crate::output::list_reservations_output::Builder {
        crate::output::list_reservations_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOfferingsOutput {
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
    /// A list of offerings that are available to this account in the current AWS Region.
    pub offerings: std::option::Option<std::vec::Vec<crate::model::Offering>>,
}
impl ListOfferingsOutput {
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// A list of offerings that are available to this account in the current AWS Region.
    pub fn offerings(&self) -> std::option::Option<&[crate::model::Offering]> {
        self.offerings.as_deref()
    }
}
impl std::fmt::Debug for ListOfferingsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOfferingsOutput");
        formatter.field("next_token", &self.next_token);
        formatter.field("offerings", &self.offerings);
        formatter.finish()
    }
}
/// See [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
pub mod list_offerings_output {
    /// A builder for [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) offerings: std::option::Option<std::vec::Vec<crate::model::Offering>>,
    }
    impl Builder {
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListOfferings request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListOfferings request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Appends an item to `offerings`.
        ///
        /// To override the contents of this collection use [`set_offerings`](Self::set_offerings).
        ///
        /// A list of offerings that are available to this account in the current AWS Region.
        pub fn offerings(mut self, input: impl Into<crate::model::Offering>) -> Self {
            let mut v = self.offerings.unwrap_or_default();
            v.push(input.into());
            self.offerings = Some(v);
            self
        }
        /// A list of offerings that are available to this account in the current AWS Region.
        pub fn set_offerings(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Offering>>,
        ) -> Self {
            self.offerings = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
        pub fn build(self) -> crate::output::ListOfferingsOutput {
            crate::output::ListOfferingsOutput {
                next_token: self.next_token,
                offerings: self.offerings,
            }
        }
    }
}
impl ListOfferingsOutput {
    /// Creates a new builder-style object to manufacture [`ListOfferingsOutput`](crate::output::ListOfferingsOutput)
    pub fn builder() -> crate::output::list_offerings_output::Builder {
        crate::output::list_offerings_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFlowsOutput {
    /// A list of flow summaries.
    pub flows: std::option::Option<std::vec::Vec<crate::model::ListedFlow>>,
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFlowsOutput {
    /// A list of flow summaries.
    pub fn flows(&self) -> std::option::Option<&[crate::model::ListedFlow]> {
        self.flows.as_deref()
    }
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFlowsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFlowsOutput");
        formatter.field("flows", &self.flows);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListFlowsOutput`](crate::output::ListFlowsOutput)
pub mod list_flows_output {
    /// A builder for [`ListFlowsOutput`](crate::output::ListFlowsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flows: std::option::Option<std::vec::Vec<crate::model::ListedFlow>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `flows`.
        ///
        /// To override the contents of this collection use [`set_flows`](Self::set_flows).
        ///
        /// A list of flow summaries.
        pub fn flows(mut self, input: impl Into<crate::model::ListedFlow>) -> Self {
            let mut v = self.flows.unwrap_or_default();
            v.push(input.into());
            self.flows = Some(v);
            self
        }
        /// A list of flow summaries.
        pub fn set_flows(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedFlow>>,
        ) -> Self {
            self.flows = input;
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListFlows request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListFlows request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFlowsOutput`](crate::output::ListFlowsOutput)
        pub fn build(self) -> crate::output::ListFlowsOutput {
            crate::output::ListFlowsOutput {
                flows: self.flows,
                next_token: self.next_token,
            }
        }
    }
}
impl ListFlowsOutput {
    /// Creates a new builder-style object to manufacture [`ListFlowsOutput`](crate::output::ListFlowsOutput)
    pub fn builder() -> crate::output::list_flows_output::Builder {
        crate::output::list_flows_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitlementsOutput {
    /// A list of entitlements that have been granted to you from other AWS accounts.
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::ListedEntitlement>>,
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
    pub next_token: std::option::Option<std::string::String>,
}
impl ListEntitlementsOutput {
    /// A list of entitlements that have been granted to you from other AWS accounts.
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::ListedEntitlement]> {
        self.entitlements.as_deref()
    }
    /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListEntitlementsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitlementsOutput");
        formatter.field("entitlements", &self.entitlements);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListEntitlementsOutput`](crate::output::ListEntitlementsOutput)
pub mod list_entitlements_output {
    /// A builder for [`ListEntitlementsOutput`](crate::output::ListEntitlementsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlements:
            std::option::Option<std::vec::Vec<crate::model::ListedEntitlement>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// A list of entitlements that have been granted to you from other AWS accounts.
        pub fn entitlements(mut self, input: impl Into<crate::model::ListedEntitlement>) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// A list of entitlements that have been granted to you from other AWS accounts.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListedEntitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// The token that identifies which batch of results that you want to see. For example, you submit a ListEntitlements request with MaxResults set at 5. The service returns the first batch of results (up to 5) and a NextToken value. To see the next batch of results, you can submit the ListEntitlements request a second time and specify the NextToken value.
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitlementsOutput`](crate::output::ListEntitlementsOutput)
        pub fn build(self) -> crate::output::ListEntitlementsOutput {
            crate::output::ListEntitlementsOutput {
                entitlements: self.entitlements,
                next_token: self.next_token,
            }
        }
    }
}
impl ListEntitlementsOutput {
    /// Creates a new builder-style object to manufacture [`ListEntitlementsOutput`](crate::output::ListEntitlementsOutput)
    pub fn builder() -> crate::output::list_entitlements_output::Builder {
        crate::output::list_entitlements_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantFlowEntitlementsOutput {
    /// The entitlements that were just granted.
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
    /// The ARN of the flow that these entitlements were granted to.
    pub flow_arn: std::option::Option<std::string::String>,
}
impl GrantFlowEntitlementsOutput {
    /// The entitlements that were just granted.
    pub fn entitlements(&self) -> std::option::Option<&[crate::model::Entitlement]> {
        self.entitlements.as_deref()
    }
    /// The ARN of the flow that these entitlements were granted to.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
}
impl std::fmt::Debug for GrantFlowEntitlementsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantFlowEntitlementsOutput");
        formatter.field("entitlements", &self.entitlements);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.finish()
    }
}
/// See [`GrantFlowEntitlementsOutput`](crate::output::GrantFlowEntitlementsOutput)
pub mod grant_flow_entitlements_output {
    /// A builder for [`GrantFlowEntitlementsOutput`](crate::output::GrantFlowEntitlementsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The entitlements that were just granted.
        pub fn entitlements(mut self, input: impl Into<crate::model::Entitlement>) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// The entitlements that were just granted.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// The ARN of the flow that these entitlements were granted to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that these entitlements were granted to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantFlowEntitlementsOutput`](crate::output::GrantFlowEntitlementsOutput)
        pub fn build(self) -> crate::output::GrantFlowEntitlementsOutput {
            crate::output::GrantFlowEntitlementsOutput {
                entitlements: self.entitlements,
                flow_arn: self.flow_arn,
            }
        }
    }
}
impl GrantFlowEntitlementsOutput {
    /// Creates a new builder-style object to manufacture [`GrantFlowEntitlementsOutput`](crate::output::GrantFlowEntitlementsOutput)
    pub fn builder() -> crate::output::grant_flow_entitlements_output::Builder {
        crate::output::grant_flow_entitlements_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeReservationOutput {
    /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
    pub reservation: std::option::Option<crate::model::Reservation>,
}
impl DescribeReservationOutput {
    /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
    pub fn reservation(&self) -> std::option::Option<&crate::model::Reservation> {
        self.reservation.as_ref()
    }
}
impl std::fmt::Debug for DescribeReservationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeReservationOutput");
        formatter.field("reservation", &self.reservation);
        formatter.finish()
    }
}
/// See [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
pub mod describe_reservation_output {
    /// A builder for [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reservation: std::option::Option<crate::model::Reservation>,
    }
    impl Builder {
        /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
        pub fn reservation(mut self, input: crate::model::Reservation) -> Self {
            self.reservation = Some(input);
            self
        }
        /// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
        pub fn set_reservation(
            mut self,
            input: std::option::Option<crate::model::Reservation>,
        ) -> Self {
            self.reservation = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
        pub fn build(self) -> crate::output::DescribeReservationOutput {
            crate::output::DescribeReservationOutput {
                reservation: self.reservation,
            }
        }
    }
}
impl DescribeReservationOutput {
    /// Creates a new builder-style object to manufacture [`DescribeReservationOutput`](crate::output::DescribeReservationOutput)
    pub fn builder() -> crate::output::describe_reservation_output::Builder {
        crate::output::describe_reservation_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOfferingOutput {
    /// A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
    pub offering: std::option::Option<crate::model::Offering>,
}
impl DescribeOfferingOutput {
    /// A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
    pub fn offering(&self) -> std::option::Option<&crate::model::Offering> {
        self.offering.as_ref()
    }
}
impl std::fmt::Debug for DescribeOfferingOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOfferingOutput");
        formatter.field("offering", &self.offering);
        formatter.finish()
    }
}
/// See [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
pub mod describe_offering_output {
    /// A builder for [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) offering: std::option::Option<crate::model::Offering>,
    }
    impl Builder {
        /// A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
        pub fn offering(mut self, input: crate::model::Offering) -> Self {
            self.offering = Some(input);
            self
        }
        /// A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
        pub fn set_offering(mut self, input: std::option::Option<crate::model::Offering>) -> Self {
            self.offering = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
        pub fn build(self) -> crate::output::DescribeOfferingOutput {
            crate::output::DescribeOfferingOutput {
                offering: self.offering,
            }
        }
    }
}
impl DescribeOfferingOutput {
    /// Creates a new builder-style object to manufacture [`DescribeOfferingOutput`](crate::output::DescribeOfferingOutput)
    pub fn builder() -> crate::output::describe_offering_output::Builder {
        crate::output::describe_offering_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeFlowOutput {
    /// The settings for a flow, including its source, outputs, and entitlements.
    pub flow: std::option::Option<crate::model::Flow>,
    /// Messages that provide the state of the flow.
    pub messages: std::option::Option<crate::model::Messages>,
}
impl DescribeFlowOutput {
    /// The settings for a flow, including its source, outputs, and entitlements.
    pub fn flow(&self) -> std::option::Option<&crate::model::Flow> {
        self.flow.as_ref()
    }
    /// Messages that provide the state of the flow.
    pub fn messages(&self) -> std::option::Option<&crate::model::Messages> {
        self.messages.as_ref()
    }
}
impl std::fmt::Debug for DescribeFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeFlowOutput");
        formatter.field("flow", &self.flow);
        formatter.field("messages", &self.messages);
        formatter.finish()
    }
}
/// See [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
pub mod describe_flow_output {
    /// A builder for [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow: std::option::Option<crate::model::Flow>,
        pub(crate) messages: std::option::Option<crate::model::Messages>,
    }
    impl Builder {
        /// The settings for a flow, including its source, outputs, and entitlements.
        pub fn flow(mut self, input: crate::model::Flow) -> Self {
            self.flow = Some(input);
            self
        }
        /// The settings for a flow, including its source, outputs, and entitlements.
        pub fn set_flow(mut self, input: std::option::Option<crate::model::Flow>) -> Self {
            self.flow = input;
            self
        }
        /// Messages that provide the state of the flow.
        pub fn messages(mut self, input: crate::model::Messages) -> Self {
            self.messages = Some(input);
            self
        }
        /// Messages that provide the state of the flow.
        pub fn set_messages(mut self, input: std::option::Option<crate::model::Messages>) -> Self {
            self.messages = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
        pub fn build(self) -> crate::output::DescribeFlowOutput {
            crate::output::DescribeFlowOutput {
                flow: self.flow,
                messages: self.messages,
            }
        }
    }
}
impl DescribeFlowOutput {
    /// Creates a new builder-style object to manufacture [`DescribeFlowOutput`](crate::output::DescribeFlowOutput)
    pub fn builder() -> crate::output::describe_flow_output::Builder {
        crate::output::describe_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFlowOutput {
    /// The ARN of the flow that was deleted.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The status of the flow when the DeleteFlow process begins.
    pub status: std::option::Option<crate::model::Status>,
}
impl DeleteFlowOutput {
    /// The ARN of the flow that was deleted.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The status of the flow when the DeleteFlow process begins.
    pub fn status(&self) -> std::option::Option<&crate::model::Status> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for DeleteFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFlowOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
pub mod delete_flow_output {
    /// A builder for [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The ARN of the flow that was deleted.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that was deleted.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The status of the flow when the DeleteFlow process begins.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The status of the flow when the DeleteFlow process begins.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
        pub fn build(self) -> crate::output::DeleteFlowOutput {
            crate::output::DeleteFlowOutput {
                flow_arn: self.flow_arn,
                status: self.status,
            }
        }
    }
}
impl DeleteFlowOutput {
    /// Creates a new builder-style object to manufacture [`DeleteFlowOutput`](crate::output::DeleteFlowOutput)
    pub fn builder() -> crate::output::delete_flow_output::Builder {
        crate::output::delete_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFlowOutput {
    /// The settings for a flow, including its source, outputs, and entitlements.
    pub flow: std::option::Option<crate::model::Flow>,
}
impl CreateFlowOutput {
    /// The settings for a flow, including its source, outputs, and entitlements.
    pub fn flow(&self) -> std::option::Option<&crate::model::Flow> {
        self.flow.as_ref()
    }
}
impl std::fmt::Debug for CreateFlowOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFlowOutput");
        formatter.field("flow", &self.flow);
        formatter.finish()
    }
}
/// See [`CreateFlowOutput`](crate::output::CreateFlowOutput)
pub mod create_flow_output {
    /// A builder for [`CreateFlowOutput`](crate::output::CreateFlowOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow: std::option::Option<crate::model::Flow>,
    }
    impl Builder {
        /// The settings for a flow, including its source, outputs, and entitlements.
        pub fn flow(mut self, input: crate::model::Flow) -> Self {
            self.flow = Some(input);
            self
        }
        /// The settings for a flow, including its source, outputs, and entitlements.
        pub fn set_flow(mut self, input: std::option::Option<crate::model::Flow>) -> Self {
            self.flow = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFlowOutput`](crate::output::CreateFlowOutput)
        pub fn build(self) -> crate::output::CreateFlowOutput {
            crate::output::CreateFlowOutput { flow: self.flow }
        }
    }
}
impl CreateFlowOutput {
    /// Creates a new builder-style object to manufacture [`CreateFlowOutput`](crate::output::CreateFlowOutput)
    pub fn builder() -> crate::output::create_flow_output::Builder {
        crate::output::create_flow_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowVpcInterfacesOutput {
    /// The ARN of the flow that these VPC interfaces were added to.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The details of the newly added VPC interfaces.
    pub vpc_interfaces: std::option::Option<std::vec::Vec<crate::model::VpcInterface>>,
}
impl AddFlowVpcInterfacesOutput {
    /// The ARN of the flow that these VPC interfaces were added to.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The details of the newly added VPC interfaces.
    pub fn vpc_interfaces(&self) -> std::option::Option<&[crate::model::VpcInterface]> {
        self.vpc_interfaces.as_deref()
    }
}
impl std::fmt::Debug for AddFlowVpcInterfacesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowVpcInterfacesOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("vpc_interfaces", &self.vpc_interfaces);
        formatter.finish()
    }
}
/// See [`AddFlowVpcInterfacesOutput`](crate::output::AddFlowVpcInterfacesOutput)
pub mod add_flow_vpc_interfaces_output {
    /// A builder for [`AddFlowVpcInterfacesOutput`](crate::output::AddFlowVpcInterfacesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) vpc_interfaces: std::option::Option<std::vec::Vec<crate::model::VpcInterface>>,
    }
    impl Builder {
        /// The ARN of the flow that these VPC interfaces were added to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that these VPC interfaces were added to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `vpc_interfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// The details of the newly added VPC interfaces.
        pub fn vpc_interfaces(mut self, input: impl Into<crate::model::VpcInterface>) -> Self {
            let mut v = self.vpc_interfaces.unwrap_or_default();
            v.push(input.into());
            self.vpc_interfaces = Some(v);
            self
        }
        /// The details of the newly added VPC interfaces.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterface>>,
        ) -> Self {
            self.vpc_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowVpcInterfacesOutput`](crate::output::AddFlowVpcInterfacesOutput)
        pub fn build(self) -> crate::output::AddFlowVpcInterfacesOutput {
            crate::output::AddFlowVpcInterfacesOutput {
                flow_arn: self.flow_arn,
                vpc_interfaces: self.vpc_interfaces,
            }
        }
    }
}
impl AddFlowVpcInterfacesOutput {
    /// Creates a new builder-style object to manufacture [`AddFlowVpcInterfacesOutput`](crate::output::AddFlowVpcInterfacesOutput)
    pub fn builder() -> crate::output::add_flow_vpc_interfaces_output::Builder {
        crate::output::add_flow_vpc_interfaces_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowSourcesOutput {
    /// The ARN of the flow that these sources were added to.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The details of the newly added sources.
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
}
impl AddFlowSourcesOutput {
    /// The ARN of the flow that these sources were added to.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The details of the newly added sources.
    pub fn sources(&self) -> std::option::Option<&[crate::model::Source]> {
        self.sources.as_deref()
    }
}
impl std::fmt::Debug for AddFlowSourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowSourcesOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("sources", &self.sources);
        formatter.finish()
    }
}
/// See [`AddFlowSourcesOutput`](crate::output::AddFlowSourcesOutput)
pub mod add_flow_sources_output {
    /// A builder for [`AddFlowSourcesOutput`](crate::output::AddFlowSourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    }
    impl Builder {
        /// The ARN of the flow that these sources were added to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that these sources were added to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        /// The details of the newly added sources.
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        /// The details of the newly added sources.
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowSourcesOutput`](crate::output::AddFlowSourcesOutput)
        pub fn build(self) -> crate::output::AddFlowSourcesOutput {
            crate::output::AddFlowSourcesOutput {
                flow_arn: self.flow_arn,
                sources: self.sources,
            }
        }
    }
}
impl AddFlowSourcesOutput {
    /// Creates a new builder-style object to manufacture [`AddFlowSourcesOutput`](crate::output::AddFlowSourcesOutput)
    pub fn builder() -> crate::output::add_flow_sources_output::Builder {
        crate::output::add_flow_sources_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowOutputsOutput {
    /// The ARN of the flow that these outputs were added to.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The details of the newly added outputs.
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
}
impl AddFlowOutputsOutput {
    /// The ARN of the flow that these outputs were added to.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The details of the newly added outputs.
    pub fn outputs(&self) -> std::option::Option<&[crate::model::Output]> {
        self.outputs.as_deref()
    }
}
impl std::fmt::Debug for AddFlowOutputsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowOutputsOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("outputs", &self.outputs);
        formatter.finish()
    }
}
/// See [`AddFlowOutputsOutput`](crate::output::AddFlowOutputsOutput)
pub mod add_flow_outputs_output {
    /// A builder for [`AddFlowOutputsOutput`](crate::output::AddFlowOutputsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    }
    impl Builder {
        /// The ARN of the flow that these outputs were added to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that these outputs were added to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// The details of the newly added outputs.
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// The details of the newly added outputs.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowOutputsOutput`](crate::output::AddFlowOutputsOutput)
        pub fn build(self) -> crate::output::AddFlowOutputsOutput {
            crate::output::AddFlowOutputsOutput {
                flow_arn: self.flow_arn,
                outputs: self.outputs,
            }
        }
    }
}
impl AddFlowOutputsOutput {
    /// Creates a new builder-style object to manufacture [`AddFlowOutputsOutput`](crate::output::AddFlowOutputsOutput)
    pub fn builder() -> crate::output::add_flow_outputs_output::Builder {
        crate::output::add_flow_outputs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddFlowMediaStreamsOutput {
    /// The ARN of the flow that you added media streams to.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The media streams that you added to the flow.
    pub media_streams: std::option::Option<std::vec::Vec<crate::model::MediaStream>>,
}
impl AddFlowMediaStreamsOutput {
    /// The ARN of the flow that you added media streams to.
    pub fn flow_arn(&self) -> std::option::Option<&str> {
        self.flow_arn.as_deref()
    }
    /// The media streams that you added to the flow.
    pub fn media_streams(&self) -> std::option::Option<&[crate::model::MediaStream]> {
        self.media_streams.as_deref()
    }
}
impl std::fmt::Debug for AddFlowMediaStreamsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddFlowMediaStreamsOutput");
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_streams", &self.media_streams);
        formatter.finish()
    }
}
/// See [`AddFlowMediaStreamsOutput`](crate::output::AddFlowMediaStreamsOutput)
pub mod add_flow_media_streams_output {
    /// A builder for [`AddFlowMediaStreamsOutput`](crate::output::AddFlowMediaStreamsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_streams: std::option::Option<std::vec::Vec<crate::model::MediaStream>>,
    }
    impl Builder {
        /// The ARN of the flow that you added media streams to.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow that you added media streams to.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `media_streams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that you added to the flow.
        pub fn media_streams(mut self, input: impl Into<crate::model::MediaStream>) -> Self {
            let mut v = self.media_streams.unwrap_or_default();
            v.push(input.into());
            self.media_streams = Some(v);
            self
        }
        /// The media streams that you added to the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaStream>>,
        ) -> Self {
            self.media_streams = input;
            self
        }
        /// Consumes the builder and constructs a [`AddFlowMediaStreamsOutput`](crate::output::AddFlowMediaStreamsOutput)
        pub fn build(self) -> crate::output::AddFlowMediaStreamsOutput {
            crate::output::AddFlowMediaStreamsOutput {
                flow_arn: self.flow_arn,
                media_streams: self.media_streams,
            }
        }
    }
}
impl AddFlowMediaStreamsOutput {
    /// Creates a new builder-style object to manufacture [`AddFlowMediaStreamsOutput`](crate::output::AddFlowMediaStreamsOutput)
    pub fn builder() -> crate::output::add_flow_media_streams_output::Builder {
        crate::output::add_flow_media_streams_output::Builder::default()
    }
}
