// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// The settings for the source of the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Source {
    /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
    pub data_transfer_subscriber_fee_percent: i32,
    /// The type of encryption that is used on the content ingested from this source.
    pub decryption: std::option::Option<crate::model::Encryption>,
    /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
    pub description: std::option::Option<std::string::String>,
    /// The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The IP address that the flow will be listening on for incoming content.
    pub ingest_ip: std::option::Option<std::string::String>,
    /// The port that the flow will be listening on for incoming content.
    pub ingest_port: i32,
    /// The media streams that are associated with the source, and the parameters for those associations.
    pub media_stream_source_configurations:
        std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfiguration>>,
    /// The name of the source.
    pub name: std::option::Option<std::string::String>,
    /// The ARN of the source.
    pub source_arn: std::option::Option<std::string::String>,
    /// Attributes related to the transport stream that are used in the source.
    pub transport: std::option::Option<crate::model::Transport>,
    /// The name of the VPC interface that is used for this source.
    pub vpc_interface_name: std::option::Option<std::string::String>,
    /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub whitelist_cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Source {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Source");
        formatter.field(
            "data_transfer_subscriber_fee_percent",
            &self.data_transfer_subscriber_fee_percent,
        );
        formatter.field("decryption", &self.decryption);
        formatter.field("description", &self.description);
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("ingest_ip", &self.ingest_ip);
        formatter.field("ingest_port", &self.ingest_port);
        formatter.field(
            "media_stream_source_configurations",
            &self.media_stream_source_configurations,
        );
        formatter.field("name", &self.name);
        formatter.field("source_arn", &self.source_arn);
        formatter.field("transport", &self.transport);
        formatter.field("vpc_interface_name", &self.vpc_interface_name);
        formatter.field("whitelist_cidr", &self.whitelist_cidr);
        formatter.finish()
    }
}
/// See [`Source`](crate::model::Source)
pub mod source {
    /// A builder for [`Source`](crate::model::Source)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_transfer_subscriber_fee_percent: std::option::Option<i32>,
        pub(crate) decryption: std::option::Option<crate::model::Encryption>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) ingest_ip: std::option::Option<std::string::String>,
        pub(crate) ingest_port: std::option::Option<i32>,
        pub(crate) media_stream_source_configurations:
            std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfiguration>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_arn: std::option::Option<std::string::String>,
        pub(crate) transport: std::option::Option<crate::model::Transport>,
        pub(crate) vpc_interface_name: std::option::Option<std::string::String>,
        pub(crate) whitelist_cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn data_transfer_subscriber_fee_percent(mut self, input: i32) -> Self {
            self.data_transfer_subscriber_fee_percent = Some(input);
            self
        }
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn set_data_transfer_subscriber_fee_percent(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.data_transfer_subscriber_fee_percent = input;
            self
        }
        /// The type of encryption that is used on the content ingested from this source.
        pub fn decryption(mut self, input: crate::model::Encryption) -> Self {
            self.decryption = Some(input);
            self
        }
        /// The type of encryption that is used on the content ingested from this source.
        pub fn set_decryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.decryption = input;
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to content that comes from another AWS account. The entitlement is set by the content originator and the ARN is generated as part of the originator's flow.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The IP address that the flow will be listening on for incoming content.
        pub fn ingest_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.ingest_ip = Some(input.into());
            self
        }
        /// The IP address that the flow will be listening on for incoming content.
        pub fn set_ingest_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ingest_ip = input;
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn ingest_port(mut self, input: i32) -> Self {
            self.ingest_port = Some(input);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn set_ingest_port(mut self, input: std::option::Option<i32>) -> Self {
            self.ingest_port = input;
            self
        }
        /// Appends an item to `media_stream_source_configurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_source_configurations`](Self::set_media_stream_source_configurations).
        ///
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn media_stream_source_configurations(
            mut self,
            input: impl Into<crate::model::MediaStreamSourceConfiguration>,
        ) -> Self {
            let mut v = self.media_stream_source_configurations.unwrap_or_default();
            v.push(input.into());
            self.media_stream_source_configurations = Some(v);
            self
        }
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn set_media_stream_source_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfiguration>>,
        ) -> Self {
            self.media_stream_source_configurations = input;
            self
        }
        /// The name of the source.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the source.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The ARN of the source.
        pub fn source_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_arn = Some(input.into());
            self
        }
        /// The ARN of the source.
        pub fn set_source_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.source_arn = input;
            self
        }
        /// Attributes related to the transport stream that are used in the source.
        pub fn transport(mut self, input: crate::model::Transport) -> Self {
            self.transport = Some(input);
            self
        }
        /// Attributes related to the transport stream that are used in the source.
        pub fn set_transport(
            mut self,
            input: std::option::Option<crate::model::Transport>,
        ) -> Self {
            self.transport = input;
            self
        }
        /// The name of the VPC interface that is used for this source.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_interface_name = Some(input.into());
            self
        }
        /// The name of the VPC interface that is used for this source.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_interface_name = input;
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn whitelist_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.whitelist_cidr = Some(input.into());
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_whitelist_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.whitelist_cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`Source`](crate::model::Source)
        pub fn build(self) -> crate::model::Source {
            crate::model::Source {
                data_transfer_subscriber_fee_percent: self
                    .data_transfer_subscriber_fee_percent
                    .unwrap_or_default(),
                decryption: self.decryption,
                description: self.description,
                entitlement_arn: self.entitlement_arn,
                ingest_ip: self.ingest_ip,
                ingest_port: self.ingest_port.unwrap_or_default(),
                media_stream_source_configurations: self.media_stream_source_configurations,
                name: self.name,
                source_arn: self.source_arn,
                transport: self.transport,
                vpc_interface_name: self.vpc_interface_name,
                whitelist_cidr: self.whitelist_cidr,
            }
        }
    }
}
impl Source {
    /// Creates a new builder-style object to manufacture [`Source`](crate::model::Source)
    pub fn builder() -> crate::model::source::Builder {
        crate::model::source::Builder::default()
    }
}

/// Attributes related to the transport stream that are used in a source or output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Transport {
    /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub cidr_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
    pub max_bitrate: i32,
    /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
    pub max_latency: i32,
    /// The size of the buffer (in milliseconds) to use to sync incoming source data.
    pub max_sync_buffer: i32,
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub min_latency: i32,
    /// The protocol that is used by the source or output.
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// The remote ID for the Zixi-pull stream.
    pub remote_id: std::option::Option<std::string::String>,
    /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
    pub smoothing_latency: i32,
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub stream_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Transport {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Transport");
        formatter.field("cidr_allow_list", &self.cidr_allow_list);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("max_latency", &self.max_latency);
        formatter.field("max_sync_buffer", &self.max_sync_buffer);
        formatter.field("min_latency", &self.min_latency);
        formatter.field("protocol", &self.protocol);
        formatter.field("remote_id", &self.remote_id);
        formatter.field("smoothing_latency", &self.smoothing_latency);
        formatter.field("stream_id", &self.stream_id);
        formatter.finish()
    }
}
/// See [`Transport`](crate::model::Transport)
pub mod transport {
    /// A builder for [`Transport`](crate::model::Transport)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) max_latency: std::option::Option<i32>,
        pub(crate) max_sync_buffer: std::option::Option<i32>,
        pub(crate) min_latency: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) remote_id: std::option::Option<std::string::String>,
        pub(crate) smoothing_latency: std::option::Option<i32>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `cidr_allow_list`.
        ///
        /// To override the contents of this collection use [`set_cidr_allow_list`](Self::set_cidr_allow_list).
        ///
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn cidr_allow_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_allow_list.unwrap_or_default();
            v.push(input.into());
            self.cidr_allow_list = Some(v);
            self
        }
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_cidr_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_allow_list = input;
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.max_latency = Some(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_latency = input;
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn max_sync_buffer(mut self, input: i32) -> Self {
            self.max_sync_buffer = Some(input);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn set_max_sync_buffer(mut self, input: std::option::Option<i32>) -> Self {
            self.max_sync_buffer = input;
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.min_latency = Some(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.min_latency = input;
            self
        }
        /// The protocol that is used by the source or output.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// The protocol that is used by the source or output.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn remote_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_id = Some(input.into());
            self
        }
        /// The remote ID for the Zixi-pull stream.
        pub fn set_remote_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.remote_id = input;
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn smoothing_latency(mut self, input: i32) -> Self {
            self.smoothing_latency = Some(input);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn set_smoothing_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.smoothing_latency = input;
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// Consumes the builder and constructs a [`Transport`](crate::model::Transport)
        pub fn build(self) -> crate::model::Transport {
            crate::model::Transport {
                cidr_allow_list: self.cidr_allow_list,
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                max_latency: self.max_latency.unwrap_or_default(),
                max_sync_buffer: self.max_sync_buffer.unwrap_or_default(),
                min_latency: self.min_latency.unwrap_or_default(),
                protocol: self.protocol,
                remote_id: self.remote_id,
                smoothing_latency: self.smoothing_latency.unwrap_or_default(),
                stream_id: self.stream_id,
            }
        }
    }
}
impl Transport {
    /// Creates a new builder-style object to manufacture [`Transport`](crate::model::Transport)
    pub fn builder() -> crate::model::transport::Builder {
        crate::model::transport::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Protocol {
    #[allow(missing_docs)] // documentation missing in model
    Cdi,
    #[allow(missing_docs)] // documentation missing in model
    Rist,
    #[allow(missing_docs)] // documentation missing in model
    Rtp,
    #[allow(missing_docs)] // documentation missing in model
    RtpFec,
    #[allow(missing_docs)] // documentation missing in model
    SrtListener,
    #[allow(missing_docs)] // documentation missing in model
    St2110Jpegxs,
    #[allow(missing_docs)] // documentation missing in model
    ZixiPull,
    #[allow(missing_docs)] // documentation missing in model
    ZixiPush,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Protocol {
    fn from(s: &str) -> Self {
        match s {
            "cdi" => Protocol::Cdi,
            "rist" => Protocol::Rist,
            "rtp" => Protocol::Rtp,
            "rtp-fec" => Protocol::RtpFec,
            "srt-listener" => Protocol::SrtListener,
            "st2110-jpegxs" => Protocol::St2110Jpegxs,
            "zixi-pull" => Protocol::ZixiPull,
            "zixi-push" => Protocol::ZixiPush,
            other => Protocol::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Protocol {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Protocol::from(s))
    }
}
impl Protocol {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Protocol::Cdi => "cdi",
            Protocol::Rist => "rist",
            Protocol::Rtp => "rtp",
            Protocol::RtpFec => "rtp-fec",
            Protocol::SrtListener => "srt-listener",
            Protocol::St2110Jpegxs => "st2110-jpegxs",
            Protocol::ZixiPull => "zixi-pull",
            Protocol::ZixiPush => "zixi-push",
            Protocol::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "cdi",
            "rist",
            "rtp",
            "rtp-fec",
            "srt-listener",
            "st2110-jpegxs",
            "zixi-pull",
            "zixi-push",
        ]
    }
}
impl AsRef<str> for Protocol {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The media stream that is associated with the source, and the parameters for that association.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStreamSourceConfiguration {
    /// The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
    pub encoding_name: std::option::Option<crate::model::EncodingName>,
    /// The transport parameters that are associated with an incoming media stream.
    pub input_configurations: std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
    /// The name of the media stream.
    pub media_stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStreamSourceConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStreamSourceConfiguration");
        formatter.field("encoding_name", &self.encoding_name);
        formatter.field("input_configurations", &self.input_configurations);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.finish()
    }
}
/// See [`MediaStreamSourceConfiguration`](crate::model::MediaStreamSourceConfiguration)
pub mod media_stream_source_configuration {
    /// A builder for [`MediaStreamSourceConfiguration`](crate::model::MediaStreamSourceConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encoding_name: std::option::Option<crate::model::EncodingName>,
        pub(crate) input_configurations:
            std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn encoding_name(mut self, input: crate::model::EncodingName) -> Self {
            self.encoding_name = Some(input);
            self
        }
        /// The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn set_encoding_name(
            mut self,
            input: std::option::Option<crate::model::EncodingName>,
        ) -> Self {
            self.encoding_name = input;
            self
        }
        /// Appends an item to `input_configurations`.
        ///
        /// To override the contents of this collection use [`set_input_configurations`](Self::set_input_configurations).
        ///
        /// The transport parameters that are associated with an incoming media stream.
        pub fn input_configurations(
            mut self,
            input: impl Into<crate::model::InputConfiguration>,
        ) -> Self {
            let mut v = self.input_configurations.unwrap_or_default();
            v.push(input.into());
            self.input_configurations = Some(v);
            self
        }
        /// The transport parameters that are associated with an incoming media stream.
        pub fn set_input_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputConfiguration>>,
        ) -> Self {
            self.input_configurations = input;
            self
        }
        /// The name of the media stream.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStreamSourceConfiguration`](crate::model::MediaStreamSourceConfiguration)
        pub fn build(self) -> crate::model::MediaStreamSourceConfiguration {
            crate::model::MediaStreamSourceConfiguration {
                encoding_name: self.encoding_name,
                input_configurations: self.input_configurations,
                media_stream_name: self.media_stream_name,
            }
        }
    }
}
impl MediaStreamSourceConfiguration {
    /// Creates a new builder-style object to manufacture [`MediaStreamSourceConfiguration`](crate::model::MediaStreamSourceConfiguration)
    pub fn builder() -> crate::model::media_stream_source_configuration::Builder {
        crate::model::media_stream_source_configuration::Builder::default()
    }
}

/// The transport parameters that are associated with an incoming media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputConfiguration {
    /// The IP address that the flow listens on for incoming content for a media stream.
    pub input_ip: std::option::Option<std::string::String>,
    /// The port that the flow listens on for an incoming media stream.
    pub input_port: i32,
    /// The VPC interface where the media stream comes in from.
    pub interface: std::option::Option<crate::model::Interface>,
}
impl std::fmt::Debug for InputConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputConfiguration");
        formatter.field("input_ip", &self.input_ip);
        formatter.field("input_port", &self.input_port);
        formatter.field("interface", &self.interface);
        formatter.finish()
    }
}
/// See [`InputConfiguration`](crate::model::InputConfiguration)
pub mod input_configuration {
    /// A builder for [`InputConfiguration`](crate::model::InputConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_ip: std::option::Option<std::string::String>,
        pub(crate) input_port: std::option::Option<i32>,
        pub(crate) interface: std::option::Option<crate::model::Interface>,
    }
    impl Builder {
        /// The IP address that the flow listens on for incoming content for a media stream.
        pub fn input_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_ip = Some(input.into());
            self
        }
        /// The IP address that the flow listens on for incoming content for a media stream.
        pub fn set_input_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.input_ip = input;
            self
        }
        /// The port that the flow listens on for an incoming media stream.
        pub fn input_port(mut self, input: i32) -> Self {
            self.input_port = Some(input);
            self
        }
        /// The port that the flow listens on for an incoming media stream.
        pub fn set_input_port(mut self, input: std::option::Option<i32>) -> Self {
            self.input_port = input;
            self
        }
        /// The VPC interface where the media stream comes in from.
        pub fn interface(mut self, input: crate::model::Interface) -> Self {
            self.interface = Some(input);
            self
        }
        /// The VPC interface where the media stream comes in from.
        pub fn set_interface(
            mut self,
            input: std::option::Option<crate::model::Interface>,
        ) -> Self {
            self.interface = input;
            self
        }
        /// Consumes the builder and constructs a [`InputConfiguration`](crate::model::InputConfiguration)
        pub fn build(self) -> crate::model::InputConfiguration {
            crate::model::InputConfiguration {
                input_ip: self.input_ip,
                input_port: self.input_port.unwrap_or_default(),
                interface: self.interface,
            }
        }
    }
}
impl InputConfiguration {
    /// Creates a new builder-style object to manufacture [`InputConfiguration`](crate::model::InputConfiguration)
    pub fn builder() -> crate::model::input_configuration::Builder {
        crate::model::input_configuration::Builder::default()
    }
}

/// The VPC interface that is used for the media stream associated with the source or output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Interface {
    /// The name of the VPC interface.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Interface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Interface");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`Interface`](crate::model::Interface)
pub mod interface {
    /// A builder for [`Interface`](crate::model::Interface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the VPC interface.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the VPC interface.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`Interface`](crate::model::Interface)
        pub fn build(self) -> crate::model::Interface {
            crate::model::Interface { name: self.name }
        }
    }
}
impl Interface {
    /// Creates a new builder-style object to manufacture [`Interface`](crate::model::Interface)
    pub fn builder() -> crate::model::interface::Builder {
        crate::model::interface::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncodingName {
    #[allow(missing_docs)] // documentation missing in model
    Jxsv,
    #[allow(missing_docs)] // documentation missing in model
    Pcm,
    #[allow(missing_docs)] // documentation missing in model
    Raw,
    #[allow(missing_docs)] // documentation missing in model
    Smpte291,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncodingName {
    fn from(s: &str) -> Self {
        match s {
            "jxsv" => EncodingName::Jxsv,
            "pcm" => EncodingName::Pcm,
            "raw" => EncodingName::Raw,
            "smpte291" => EncodingName::Smpte291,
            other => EncodingName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncodingName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncodingName::from(s))
    }
}
impl EncodingName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncodingName::Jxsv => "jxsv",
            EncodingName::Pcm => "pcm",
            EncodingName::Raw => "raw",
            EncodingName::Smpte291 => "smpte291",
            EncodingName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["jxsv", "pcm", "raw", "smpte291"]
    }
}
impl AsRef<str> for EncodingName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Information about the encryption of the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Encryption {
    /// The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
    pub algorithm: std::option::Option<crate::model::Algorithm>,
    /// A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
    pub constant_initialization_vector: std::option::Option<std::string::String>,
    /// The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub device_id: std::option::Option<std::string::String>,
    /// The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    pub key_type: std::option::Option<crate::model::KeyType>,
    /// The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub region: std::option::Option<std::string::String>,
    /// An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub resource_id: std::option::Option<std::string::String>,
    /// The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
    pub role_arn: std::option::Option<std::string::String>,
    /// The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
    pub secret_arn: std::option::Option<std::string::String>,
    /// The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Encryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Encryption");
        formatter.field("algorithm", &self.algorithm);
        formatter.field(
            "constant_initialization_vector",
            &self.constant_initialization_vector,
        );
        formatter.field("device_id", &self.device_id);
        formatter.field("key_type", &self.key_type);
        formatter.field("region", &self.region);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`Encryption`](crate::model::Encryption)
pub mod encryption {
    /// A builder for [`Encryption`](crate::model::Encryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm: std::option::Option<crate::model::Algorithm>,
        pub(crate) constant_initialization_vector: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) key_type: std::option::Option<crate::model::KeyType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        pub fn algorithm(mut self, input: crate::model::Algorithm) -> Self {
            self.algorithm = Some(input);
            self
        }
        /// The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        pub fn set_algorithm(
            mut self,
            input: std::option::Option<crate::model::Algorithm>,
        ) -> Self {
            self.algorithm = input;
            self
        }
        /// A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        pub fn constant_initialization_vector(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = Some(input.into());
            self
        }
        /// A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        pub fn set_constant_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = input;
            self
        }
        /// The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.key_type = Some(input);
            self
        }
        /// The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.key_type = input;
            self
        }
        /// The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`Encryption`](crate::model::Encryption)
        pub fn build(self) -> crate::model::Encryption {
            crate::model::Encryption {
                algorithm: self.algorithm,
                constant_initialization_vector: self.constant_initialization_vector,
                device_id: self.device_id,
                key_type: self.key_type,
                region: self.region,
                resource_id: self.resource_id,
                role_arn: self.role_arn,
                secret_arn: self.secret_arn,
                url: self.url,
            }
        }
    }
}
impl Encryption {
    /// Creates a new builder-style object to manufacture [`Encryption`](crate::model::Encryption)
    pub fn builder() -> crate::model::encryption::Builder {
        crate::model::encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum KeyType {
    #[allow(missing_docs)] // documentation missing in model
    Speke,
    #[allow(missing_docs)] // documentation missing in model
    SrtPassword,
    #[allow(missing_docs)] // documentation missing in model
    StaticKey,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for KeyType {
    fn from(s: &str) -> Self {
        match s {
            "speke" => KeyType::Speke,
            "srt-password" => KeyType::SrtPassword,
            "static-key" => KeyType::StaticKey,
            other => KeyType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for KeyType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(KeyType::from(s))
    }
}
impl KeyType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeyType::Speke => "speke",
            KeyType::SrtPassword => "srt-password",
            KeyType::StaticKey => "static-key",
            KeyType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["speke", "srt-password", "static-key"]
    }
}
impl AsRef<str> for KeyType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Algorithm {
    #[allow(missing_docs)] // documentation missing in model
    Aes128,
    #[allow(missing_docs)] // documentation missing in model
    Aes192,
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Algorithm {
    fn from(s: &str) -> Self {
        match s {
            "aes128" => Algorithm::Aes128,
            "aes192" => Algorithm::Aes192,
            "aes256" => Algorithm::Aes256,
            other => Algorithm::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Algorithm {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Algorithm::from(s))
    }
}
impl Algorithm {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Algorithm::Aes128 => "aes128",
            Algorithm::Aes192 => "aes192",
            Algorithm::Aes256 => "aes256",
            Algorithm::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["aes128", "aes192", "aes256"]
    }
}
impl AsRef<str> for Algorithm {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The definition of a media stream that you want to associate with the source.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStreamSourceConfigurationRequest {
    /// The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
    pub encoding_name: std::option::Option<crate::model::EncodingName>,
    /// The transport parameters that you want to associate with the media stream.
    pub input_configurations:
        std::option::Option<std::vec::Vec<crate::model::InputConfigurationRequest>>,
    /// The name of the media stream.
    pub media_stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStreamSourceConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStreamSourceConfigurationRequest");
        formatter.field("encoding_name", &self.encoding_name);
        formatter.field("input_configurations", &self.input_configurations);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.finish()
    }
}
/// See [`MediaStreamSourceConfigurationRequest`](crate::model::MediaStreamSourceConfigurationRequest)
pub mod media_stream_source_configuration_request {
    /// A builder for [`MediaStreamSourceConfigurationRequest`](crate::model::MediaStreamSourceConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encoding_name: std::option::Option<crate::model::EncodingName>,
        pub(crate) input_configurations:
            std::option::Option<std::vec::Vec<crate::model::InputConfigurationRequest>>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn encoding_name(mut self, input: crate::model::EncodingName) -> Self {
            self.encoding_name = Some(input);
            self
        }
        /// The format you want to use to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn set_encoding_name(
            mut self,
            input: std::option::Option<crate::model::EncodingName>,
        ) -> Self {
            self.encoding_name = input;
            self
        }
        /// Appends an item to `input_configurations`.
        ///
        /// To override the contents of this collection use [`set_input_configurations`](Self::set_input_configurations).
        ///
        /// The transport parameters that you want to associate with the media stream.
        pub fn input_configurations(
            mut self,
            input: impl Into<crate::model::InputConfigurationRequest>,
        ) -> Self {
            let mut v = self.input_configurations.unwrap_or_default();
            v.push(input.into());
            self.input_configurations = Some(v);
            self
        }
        /// The transport parameters that you want to associate with the media stream.
        pub fn set_input_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InputConfigurationRequest>>,
        ) -> Self {
            self.input_configurations = input;
            self
        }
        /// The name of the media stream.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStreamSourceConfigurationRequest`](crate::model::MediaStreamSourceConfigurationRequest)
        pub fn build(self) -> crate::model::MediaStreamSourceConfigurationRequest {
            crate::model::MediaStreamSourceConfigurationRequest {
                encoding_name: self.encoding_name,
                input_configurations: self.input_configurations,
                media_stream_name: self.media_stream_name,
            }
        }
    }
}
impl MediaStreamSourceConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`MediaStreamSourceConfigurationRequest`](crate::model::MediaStreamSourceConfigurationRequest)
    pub fn builder() -> crate::model::media_stream_source_configuration_request::Builder {
        crate::model::media_stream_source_configuration_request::Builder::default()
    }
}

/// The transport parameters that you want to associate with an incoming media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InputConfigurationRequest {
    /// The port that you want the flow to listen on for an incoming media stream.
    pub input_port: i32,
    /// The VPC interface that you want to use for the incoming media stream.
    pub interface: std::option::Option<crate::model::InterfaceRequest>,
}
impl std::fmt::Debug for InputConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InputConfigurationRequest");
        formatter.field("input_port", &self.input_port);
        formatter.field("interface", &self.interface);
        formatter.finish()
    }
}
/// See [`InputConfigurationRequest`](crate::model::InputConfigurationRequest)
pub mod input_configuration_request {
    /// A builder for [`InputConfigurationRequest`](crate::model::InputConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) input_port: std::option::Option<i32>,
        pub(crate) interface: std::option::Option<crate::model::InterfaceRequest>,
    }
    impl Builder {
        /// The port that you want the flow to listen on for an incoming media stream.
        pub fn input_port(mut self, input: i32) -> Self {
            self.input_port = Some(input);
            self
        }
        /// The port that you want the flow to listen on for an incoming media stream.
        pub fn set_input_port(mut self, input: std::option::Option<i32>) -> Self {
            self.input_port = input;
            self
        }
        /// The VPC interface that you want to use for the incoming media stream.
        pub fn interface(mut self, input: crate::model::InterfaceRequest) -> Self {
            self.interface = Some(input);
            self
        }
        /// The VPC interface that you want to use for the incoming media stream.
        pub fn set_interface(
            mut self,
            input: std::option::Option<crate::model::InterfaceRequest>,
        ) -> Self {
            self.interface = input;
            self
        }
        /// Consumes the builder and constructs a [`InputConfigurationRequest`](crate::model::InputConfigurationRequest)
        pub fn build(self) -> crate::model::InputConfigurationRequest {
            crate::model::InputConfigurationRequest {
                input_port: self.input_port.unwrap_or_default(),
                interface: self.interface,
            }
        }
    }
}
impl InputConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`InputConfigurationRequest`](crate::model::InputConfigurationRequest)
    pub fn builder() -> crate::model::input_configuration_request::Builder {
        crate::model::input_configuration_request::Builder::default()
    }
}

/// The VPC interface that you want to designate where the media stream is coming from or going to.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InterfaceRequest {
    /// The name of the VPC interface.
    pub name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InterfaceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InterfaceRequest");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`InterfaceRequest`](crate::model::InterfaceRequest)
pub mod interface_request {
    /// A builder for [`InterfaceRequest`](crate::model::InterfaceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the VPC interface.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the VPC interface.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`InterfaceRequest`](crate::model::InterfaceRequest)
        pub fn build(self) -> crate::model::InterfaceRequest {
            crate::model::InterfaceRequest { name: self.name }
        }
    }
}
impl InterfaceRequest {
    /// Creates a new builder-style object to manufacture [`InterfaceRequest`](crate::model::InterfaceRequest)
    pub fn builder() -> crate::model::interface_request::Builder {
        crate::model::interface_request::Builder::default()
    }
}

/// Information about the encryption of the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEncryption {
    /// The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
    pub algorithm: std::option::Option<crate::model::Algorithm>,
    /// A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
    pub constant_initialization_vector: std::option::Option<std::string::String>,
    /// The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub device_id: std::option::Option<std::string::String>,
    /// The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    pub key_type: std::option::Option<crate::model::KeyType>,
    /// The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub region: std::option::Option<std::string::String>,
    /// An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub resource_id: std::option::Option<std::string::String>,
    /// The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
    pub role_arn: std::option::Option<std::string::String>,
    /// The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
    pub secret_arn: std::option::Option<std::string::String>,
    /// The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
    pub url: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for UpdateEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEncryption");
        formatter.field("algorithm", &self.algorithm);
        formatter.field(
            "constant_initialization_vector",
            &self.constant_initialization_vector,
        );
        formatter.field("device_id", &self.device_id);
        formatter.field("key_type", &self.key_type);
        formatter.field("region", &self.region);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("secret_arn", &self.secret_arn);
        formatter.field("url", &self.url);
        formatter.finish()
    }
}
/// See [`UpdateEncryption`](crate::model::UpdateEncryption)
pub mod update_encryption {
    /// A builder for [`UpdateEncryption`](crate::model::UpdateEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) algorithm: std::option::Option<crate::model::Algorithm>,
        pub(crate) constant_initialization_vector: std::option::Option<std::string::String>,
        pub(crate) device_id: std::option::Option<std::string::String>,
        pub(crate) key_type: std::option::Option<crate::model::KeyType>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) secret_arn: std::option::Option<std::string::String>,
        pub(crate) url: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        pub fn algorithm(mut self, input: crate::model::Algorithm) -> Self {
            self.algorithm = Some(input);
            self
        }
        /// The type of algorithm that is used for the encryption (such as aes128, aes192, or aes256).
        pub fn set_algorithm(
            mut self,
            input: std::option::Option<crate::model::Algorithm>,
        ) -> Self {
            self.algorithm = input;
            self
        }
        /// A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        pub fn constant_initialization_vector(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = Some(input.into());
            self
        }
        /// A 128-bit, 16-byte hex value represented by a 32-character string, to be used with the key for encrypting content. This parameter is not valid for static key encryption.
        pub fn set_constant_initialization_vector(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.constant_initialization_vector = input;
            self
        }
        /// The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn device_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.device_id = Some(input.into());
            self
        }
        /// The value of one of the devices that you configured with your digital rights management (DRM) platform key provider. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_device_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.device_id = input;
            self
        }
        /// The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn key_type(mut self, input: crate::model::KeyType) -> Self {
            self.key_type = Some(input);
            self
        }
        /// The type of key that is used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_key_type(mut self, input: std::option::Option<crate::model::KeyType>) -> Self {
            self.key_type = input;
            self
        }
        /// The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// The AWS Region that the API Gateway proxy endpoint was created in. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// An identifier for the content. The service sends this value to the key server to identify the current endpoint. The resource ID is also known as the content ID. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// The ARN of the role that you created during setup (when you set up AWS Elemental MediaConnect as a trusted entity).
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        pub fn secret_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.secret_arn = Some(input.into());
            self
        }
        /// The ARN of the secret that you created in AWS Secrets Manager to store the encryption key. This parameter is required for static key encryption and is not valid for SPEKE encryption.
        pub fn set_secret_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.secret_arn = input;
            self
        }
        /// The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn url(mut self, input: impl Into<std::string::String>) -> Self {
            self.url = Some(input.into());
            self
        }
        /// The URL from the API Gateway proxy that you set up to talk to your key server. This parameter is required for SPEKE encryption and is not valid for static key encryption.
        pub fn set_url(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.url = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEncryption`](crate::model::UpdateEncryption)
        pub fn build(self) -> crate::model::UpdateEncryption {
            crate::model::UpdateEncryption {
                algorithm: self.algorithm,
                constant_initialization_vector: self.constant_initialization_vector,
                device_id: self.device_id,
                key_type: self.key_type,
                region: self.region,
                resource_id: self.resource_id,
                role_arn: self.role_arn,
                secret_arn: self.secret_arn,
                url: self.url,
            }
        }
    }
}
impl UpdateEncryption {
    /// Creates a new builder-style object to manufacture [`UpdateEncryption`](crate::model::UpdateEncryption)
    pub fn builder() -> crate::model::update_encryption::Builder {
        crate::model::update_encryption::Builder::default()
    }
}

/// The settings for an output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Output {
    /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
    pub data_transfer_subscriber_fee_percent: i32,
    /// A description of the output.
    pub description: std::option::Option<std::string::String>,
    /// The address where you want to send the output.
    pub destination: std::option::Option<std::string::String>,
    /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
    pub listener_address: std::option::Option<std::string::String>,
    /// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
    pub media_live_input_arn: std::option::Option<std::string::String>,
    /// The configuration for each media stream that is associated with the output.
    pub media_stream_output_configurations:
        std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfiguration>>,
    /// The name of the output. This value must be unique within the current flow.
    pub name: std::option::Option<std::string::String>,
    /// The ARN of the output.
    pub output_arn: std::option::Option<std::string::String>,
    /// The port to use when content is distributed to this output.
    pub port: i32,
    /// Attributes related to the transport stream that are used in the output.
    pub transport: std::option::Option<crate::model::Transport>,
    /// The name of the VPC interface attachment to use for this output.
    pub vpc_interface_attachment: std::option::Option<crate::model::VpcInterfaceAttachment>,
}
impl std::fmt::Debug for Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Output");
        formatter.field(
            "data_transfer_subscriber_fee_percent",
            &self.data_transfer_subscriber_fee_percent,
        );
        formatter.field("description", &self.description);
        formatter.field("destination", &self.destination);
        formatter.field("encryption", &self.encryption);
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("listener_address", &self.listener_address);
        formatter.field("media_live_input_arn", &self.media_live_input_arn);
        formatter.field(
            "media_stream_output_configurations",
            &self.media_stream_output_configurations,
        );
        formatter.field("name", &self.name);
        formatter.field("output_arn", &self.output_arn);
        formatter.field("port", &self.port);
        formatter.field("transport", &self.transport);
        formatter.field("vpc_interface_attachment", &self.vpc_interface_attachment);
        formatter.finish()
    }
}
/// See [`Output`](crate::model::Output)
pub mod output {
    /// A builder for [`Output`](crate::model::Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_transfer_subscriber_fee_percent: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) listener_address: std::option::Option<std::string::String>,
        pub(crate) media_live_input_arn: std::option::Option<std::string::String>,
        pub(crate) media_stream_output_configurations:
            std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfiguration>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) output_arn: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) transport: std::option::Option<crate::model::Transport>,
        pub(crate) vpc_interface_attachment:
            std::option::Option<crate::model::VpcInterfaceAttachment>,
    }
    impl Builder {
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn data_transfer_subscriber_fee_percent(mut self, input: i32) -> Self {
            self.data_transfer_subscriber_fee_percent = Some(input);
            self
        }
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn set_data_transfer_subscriber_fee_percent(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.data_transfer_subscriber_fee_percent = input;
            self
        }
        /// A description of the output.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the output.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The address where you want to send the output.
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// The address where you want to send the output.
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement on the originator''s flow. This value is relevant only on entitled flows.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
        pub fn listener_address(mut self, input: impl Into<std::string::String>) -> Self {
            self.listener_address = Some(input.into());
            self
        }
        /// The IP address that the receiver requires in order to establish a connection with the flow. For public networking, the ListenerAddress is represented by the elastic IP address of the flow. For private networking, the ListenerAddress is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the Zixi pull or SRT listener protocol.
        pub fn set_listener_address(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.listener_address = input;
            self
        }
        /// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
        pub fn media_live_input_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_live_input_arn = Some(input.into());
            self
        }
        /// The input ARN of the AWS Elemental MediaLive channel. This parameter is relevant only for outputs that were added by creating a MediaLive input.
        pub fn set_media_live_input_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_live_input_arn = input;
            self
        }
        /// Appends an item to `media_stream_output_configurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_output_configurations`](Self::set_media_stream_output_configurations).
        ///
        /// The configuration for each media stream that is associated with the output.
        pub fn media_stream_output_configurations(
            mut self,
            input: impl Into<crate::model::MediaStreamOutputConfiguration>,
        ) -> Self {
            let mut v = self.media_stream_output_configurations.unwrap_or_default();
            v.push(input.into());
            self.media_stream_output_configurations = Some(v);
            self
        }
        /// The configuration for each media stream that is associated with the output.
        pub fn set_media_stream_output_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfiguration>>,
        ) -> Self {
            self.media_stream_output_configurations = input;
            self
        }
        /// The name of the output. This value must be unique within the current flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the output. This value must be unique within the current flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The ARN of the output.
        pub fn output_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_arn = Some(input.into());
            self
        }
        /// The ARN of the output.
        pub fn set_output_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_arn = input;
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// Attributes related to the transport stream that are used in the output.
        pub fn transport(mut self, input: crate::model::Transport) -> Self {
            self.transport = Some(input);
            self
        }
        /// Attributes related to the transport stream that are used in the output.
        pub fn set_transport(
            mut self,
            input: std::option::Option<crate::model::Transport>,
        ) -> Self {
            self.transport = input;
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn vpc_interface_attachment(
            mut self,
            input: crate::model::VpcInterfaceAttachment,
        ) -> Self {
            self.vpc_interface_attachment = Some(input);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn set_vpc_interface_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcInterfaceAttachment>,
        ) -> Self {
            self.vpc_interface_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`Output`](crate::model::Output)
        pub fn build(self) -> crate::model::Output {
            crate::model::Output {
                data_transfer_subscriber_fee_percent: self
                    .data_transfer_subscriber_fee_percent
                    .unwrap_or_default(),
                description: self.description,
                destination: self.destination,
                encryption: self.encryption,
                entitlement_arn: self.entitlement_arn,
                listener_address: self.listener_address,
                media_live_input_arn: self.media_live_input_arn,
                media_stream_output_configurations: self.media_stream_output_configurations,
                name: self.name,
                output_arn: self.output_arn,
                port: self.port.unwrap_or_default(),
                transport: self.transport,
                vpc_interface_attachment: self.vpc_interface_attachment,
            }
        }
    }
}
impl Output {
    /// Creates a new builder-style object to manufacture [`Output`](crate::model::Output)
    pub fn builder() -> crate::model::output::Builder {
        crate::model::output::Builder::default()
    }
}

/// The settings for attaching a VPC interface to an output.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcInterfaceAttachment {
    /// The name of the VPC interface to use for this output.
    pub vpc_interface_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcInterfaceAttachment {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcInterfaceAttachment");
        formatter.field("vpc_interface_name", &self.vpc_interface_name);
        formatter.finish()
    }
}
/// See [`VpcInterfaceAttachment`](crate::model::VpcInterfaceAttachment)
pub mod vpc_interface_attachment {
    /// A builder for [`VpcInterfaceAttachment`](crate::model::VpcInterfaceAttachment)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vpc_interface_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the VPC interface to use for this output.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_interface_name = Some(input.into());
            self
        }
        /// The name of the VPC interface to use for this output.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_interface_name = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcInterfaceAttachment`](crate::model::VpcInterfaceAttachment)
        pub fn build(self) -> crate::model::VpcInterfaceAttachment {
            crate::model::VpcInterfaceAttachment {
                vpc_interface_name: self.vpc_interface_name,
            }
        }
    }
}
impl VpcInterfaceAttachment {
    /// Creates a new builder-style object to manufacture [`VpcInterfaceAttachment`](crate::model::VpcInterfaceAttachment)
    pub fn builder() -> crate::model::vpc_interface_attachment::Builder {
        crate::model::vpc_interface_attachment::Builder::default()
    }
}

/// The media stream that is associated with the output, and the parameters for that association.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStreamOutputConfiguration {
    /// The transport parameters that are associated with each outbound media stream.
    pub destination_configurations:
        std::option::Option<std::vec::Vec<crate::model::DestinationConfiguration>>,
    /// The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
    pub encoding_name: std::option::Option<crate::model::EncodingName>,
    /// Encoding parameters
    pub encoding_parameters: std::option::Option<crate::model::EncodingParameters>,
    /// The name of the media stream.
    pub media_stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStreamOutputConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStreamOutputConfiguration");
        formatter.field(
            "destination_configurations",
            &self.destination_configurations,
        );
        formatter.field("encoding_name", &self.encoding_name);
        formatter.field("encoding_parameters", &self.encoding_parameters);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.finish()
    }
}
/// See [`MediaStreamOutputConfiguration`](crate::model::MediaStreamOutputConfiguration)
pub mod media_stream_output_configuration {
    /// A builder for [`MediaStreamOutputConfiguration`](crate::model::MediaStreamOutputConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_configurations:
            std::option::Option<std::vec::Vec<crate::model::DestinationConfiguration>>,
        pub(crate) encoding_name: std::option::Option<crate::model::EncodingName>,
        pub(crate) encoding_parameters: std::option::Option<crate::model::EncodingParameters>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `destination_configurations`.
        ///
        /// To override the contents of this collection use [`set_destination_configurations`](Self::set_destination_configurations).
        ///
        /// The transport parameters that are associated with each outbound media stream.
        pub fn destination_configurations(
            mut self,
            input: impl Into<crate::model::DestinationConfiguration>,
        ) -> Self {
            let mut v = self.destination_configurations.unwrap_or_default();
            v.push(input.into());
            self.destination_configurations = Some(v);
            self
        }
        /// The transport parameters that are associated with each outbound media stream.
        pub fn set_destination_configurations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DestinationConfiguration>>,
        ) -> Self {
            self.destination_configurations = input;
            self
        }
        /// The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn encoding_name(mut self, input: crate::model::EncodingName) -> Self {
            self.encoding_name = Some(input);
            self
        }
        /// The format that was used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn set_encoding_name(
            mut self,
            input: std::option::Option<crate::model::EncodingName>,
        ) -> Self {
            self.encoding_name = input;
            self
        }
        /// Encoding parameters
        pub fn encoding_parameters(mut self, input: crate::model::EncodingParameters) -> Self {
            self.encoding_parameters = Some(input);
            self
        }
        /// Encoding parameters
        pub fn set_encoding_parameters(
            mut self,
            input: std::option::Option<crate::model::EncodingParameters>,
        ) -> Self {
            self.encoding_parameters = input;
            self
        }
        /// The name of the media stream.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStreamOutputConfiguration`](crate::model::MediaStreamOutputConfiguration)
        pub fn build(self) -> crate::model::MediaStreamOutputConfiguration {
            crate::model::MediaStreamOutputConfiguration {
                destination_configurations: self.destination_configurations,
                encoding_name: self.encoding_name,
                encoding_parameters: self.encoding_parameters,
                media_stream_name: self.media_stream_name,
            }
        }
    }
}
impl MediaStreamOutputConfiguration {
    /// Creates a new builder-style object to manufacture [`MediaStreamOutputConfiguration`](crate::model::MediaStreamOutputConfiguration)
    pub fn builder() -> crate::model::media_stream_output_configuration::Builder {
        crate::model::media_stream_output_configuration::Builder::default()
    }
}

/// A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncodingParameters {
    /// A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
    pub compression_factor: f64,
    /// A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
    pub encoder_profile: std::option::Option<crate::model::EncoderProfile>,
}
impl std::fmt::Debug for EncodingParameters {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncodingParameters");
        formatter.field("compression_factor", &self.compression_factor);
        formatter.field("encoder_profile", &self.encoder_profile);
        formatter.finish()
    }
}
/// See [`EncodingParameters`](crate::model::EncodingParameters)
pub mod encoding_parameters {
    /// A builder for [`EncodingParameters`](crate::model::EncodingParameters)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compression_factor: std::option::Option<f64>,
        pub(crate) encoder_profile: std::option::Option<crate::model::EncoderProfile>,
    }
    impl Builder {
        /// A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
        pub fn compression_factor(mut self, input: f64) -> Self {
            self.compression_factor = Some(input);
            self
        }
        /// A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
        pub fn set_compression_factor(mut self, input: std::option::Option<f64>) -> Self {
            self.compression_factor = input;
            self
        }
        /// A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        pub fn encoder_profile(mut self, input: crate::model::EncoderProfile) -> Self {
            self.encoder_profile = Some(input);
            self
        }
        /// A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol.
        pub fn set_encoder_profile(
            mut self,
            input: std::option::Option<crate::model::EncoderProfile>,
        ) -> Self {
            self.encoder_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`EncodingParameters`](crate::model::EncodingParameters)
        pub fn build(self) -> crate::model::EncodingParameters {
            crate::model::EncodingParameters {
                compression_factor: self.compression_factor.unwrap_or_default(),
                encoder_profile: self.encoder_profile,
            }
        }
    }
}
impl EncodingParameters {
    /// Creates a new builder-style object to manufacture [`EncodingParameters`](crate::model::EncodingParameters)
    pub fn builder() -> crate::model::encoding_parameters::Builder {
        crate::model::encoding_parameters::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncoderProfile {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Main,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncoderProfile {
    fn from(s: &str) -> Self {
        match s {
            "high" => EncoderProfile::High,
            "main" => EncoderProfile::Main,
            other => EncoderProfile::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncoderProfile {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncoderProfile::from(s))
    }
}
impl EncoderProfile {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncoderProfile::High => "high",
            EncoderProfile::Main => "main",
            EncoderProfile::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["high", "main"]
    }
}
impl AsRef<str> for EncoderProfile {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The transport parameters that are associated with an outbound media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationConfiguration {
    /// The IP address where contents of the media stream will be sent.
    pub destination_ip: std::option::Option<std::string::String>,
    /// The port to use when the content of the media stream is distributed to the output.
    pub destination_port: i32,
    /// The VPC interface that is used for the media stream associated with the output.
    pub interface: std::option::Option<crate::model::Interface>,
    /// The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.
    pub outbound_ip: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for DestinationConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationConfiguration");
        formatter.field("destination_ip", &self.destination_ip);
        formatter.field("destination_port", &self.destination_port);
        formatter.field("interface", &self.interface);
        formatter.field("outbound_ip", &self.outbound_ip);
        formatter.finish()
    }
}
/// See [`DestinationConfiguration`](crate::model::DestinationConfiguration)
pub mod destination_configuration {
    /// A builder for [`DestinationConfiguration`](crate::model::DestinationConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_ip: std::option::Option<std::string::String>,
        pub(crate) destination_port: std::option::Option<i32>,
        pub(crate) interface: std::option::Option<crate::model::Interface>,
        pub(crate) outbound_ip: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The IP address where contents of the media stream will be sent.
        pub fn destination_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_ip = Some(input.into());
            self
        }
        /// The IP address where contents of the media stream will be sent.
        pub fn set_destination_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ip = input;
            self
        }
        /// The port to use when the content of the media stream is distributed to the output.
        pub fn destination_port(mut self, input: i32) -> Self {
            self.destination_port = Some(input);
            self
        }
        /// The port to use when the content of the media stream is distributed to the output.
        pub fn set_destination_port(mut self, input: std::option::Option<i32>) -> Self {
            self.destination_port = input;
            self
        }
        /// The VPC interface that is used for the media stream associated with the output.
        pub fn interface(mut self, input: crate::model::Interface) -> Self {
            self.interface = Some(input);
            self
        }
        /// The VPC interface that is used for the media stream associated with the output.
        pub fn set_interface(
            mut self,
            input: std::option::Option<crate::model::Interface>,
        ) -> Self {
            self.interface = input;
            self
        }
        /// The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.
        pub fn outbound_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.outbound_ip = Some(input.into());
            self
        }
        /// The IP address that the receiver requires in order to establish a connection with the flow. This value is represented by the elastic network interface IP address of the VPC. This field applies only to outputs that use the CDI or ST 2110 JPEG XS protocol.
        pub fn set_outbound_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.outbound_ip = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationConfiguration`](crate::model::DestinationConfiguration)
        pub fn build(self) -> crate::model::DestinationConfiguration {
            crate::model::DestinationConfiguration {
                destination_ip: self.destination_ip,
                destination_port: self.destination_port.unwrap_or_default(),
                interface: self.interface,
                outbound_ip: self.outbound_ip,
            }
        }
    }
}
impl DestinationConfiguration {
    /// Creates a new builder-style object to manufacture [`DestinationConfiguration`](crate::model::DestinationConfiguration)
    pub fn builder() -> crate::model::destination_configuration::Builder {
        crate::model::destination_configuration::Builder::default()
    }
}

/// The media stream that you want to associate with the output, and the parameters for that association.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStreamOutputConfigurationRequest {
    /// The transport parameters that you want to associate with the media stream.
    pub destination_configurations:
        std::option::Option<std::vec::Vec<crate::model::DestinationConfigurationRequest>>,
    /// The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
    pub encoding_name: std::option::Option<crate::model::EncodingName>,
    /// A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
    pub encoding_parameters: std::option::Option<crate::model::EncodingParametersRequest>,
    /// The name of the media stream that is associated with the output.
    pub media_stream_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStreamOutputConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStreamOutputConfigurationRequest");
        formatter.field(
            "destination_configurations",
            &self.destination_configurations,
        );
        formatter.field("encoding_name", &self.encoding_name);
        formatter.field("encoding_parameters", &self.encoding_parameters);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.finish()
    }
}
/// See [`MediaStreamOutputConfigurationRequest`](crate::model::MediaStreamOutputConfigurationRequest)
pub mod media_stream_output_configuration_request {
    /// A builder for [`MediaStreamOutputConfigurationRequest`](crate::model::MediaStreamOutputConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_configurations:
            std::option::Option<std::vec::Vec<crate::model::DestinationConfigurationRequest>>,
        pub(crate) encoding_name: std::option::Option<crate::model::EncodingName>,
        pub(crate) encoding_parameters:
            std::option::Option<crate::model::EncodingParametersRequest>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `destination_configurations`.
        ///
        /// To override the contents of this collection use [`set_destination_configurations`](Self::set_destination_configurations).
        ///
        /// The transport parameters that you want to associate with the media stream.
        pub fn destination_configurations(
            mut self,
            input: impl Into<crate::model::DestinationConfigurationRequest>,
        ) -> Self {
            let mut v = self.destination_configurations.unwrap_or_default();
            v.push(input.into());
            self.destination_configurations = Some(v);
            self
        }
        /// The transport parameters that you want to associate with the media stream.
        pub fn set_destination_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::DestinationConfigurationRequest>,
            >,
        ) -> Self {
            self.destination_configurations = input;
            self
        }
        /// The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn encoding_name(mut self, input: crate::model::EncodingName) -> Self {
            self.encoding_name = Some(input);
            self
        }
        /// The format that will be used to encode the data. For ancillary data streams, set the encoding name to smpte291. For audio streams, set the encoding name to pcm. For video, 2110 streams, set the encoding name to raw. For video, JPEG XS streams, set the encoding name to jxsv.
        pub fn set_encoding_name(
            mut self,
            input: std::option::Option<crate::model::EncodingName>,
        ) -> Self {
            self.encoding_name = input;
            self
        }
        /// A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        pub fn encoding_parameters(
            mut self,
            input: crate::model::EncodingParametersRequest,
        ) -> Self {
            self.encoding_parameters = Some(input);
            self
        }
        /// A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
        pub fn set_encoding_parameters(
            mut self,
            input: std::option::Option<crate::model::EncodingParametersRequest>,
        ) -> Self {
            self.encoding_parameters = input;
            self
        }
        /// The name of the media stream that is associated with the output.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// The name of the media stream that is associated with the output.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStreamOutputConfigurationRequest`](crate::model::MediaStreamOutputConfigurationRequest)
        pub fn build(self) -> crate::model::MediaStreamOutputConfigurationRequest {
            crate::model::MediaStreamOutputConfigurationRequest {
                destination_configurations: self.destination_configurations,
                encoding_name: self.encoding_name,
                encoding_parameters: self.encoding_parameters,
                media_stream_name: self.media_stream_name,
            }
        }
    }
}
impl MediaStreamOutputConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`MediaStreamOutputConfigurationRequest`](crate::model::MediaStreamOutputConfigurationRequest)
    pub fn builder() -> crate::model::media_stream_output_configuration_request::Builder {
        crate::model::media_stream_output_configuration_request::Builder::default()
    }
}

/// A collection of parameters that determine how MediaConnect will convert the content. These fields only apply to outputs on flows that have a CDI source.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EncodingParametersRequest {
    /// A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
    pub compression_factor: f64,
    /// A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, if at least one source on the flow uses the CDI protocol.
    pub encoder_profile: std::option::Option<crate::model::EncoderProfile>,
}
impl std::fmt::Debug for EncodingParametersRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EncodingParametersRequest");
        formatter.field("compression_factor", &self.compression_factor);
        formatter.field("encoder_profile", &self.encoder_profile);
        formatter.finish()
    }
}
/// See [`EncodingParametersRequest`](crate::model::EncodingParametersRequest)
pub mod encoding_parameters_request {
    /// A builder for [`EncodingParametersRequest`](crate::model::EncodingParametersRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) compression_factor: std::option::Option<f64>,
        pub(crate) encoder_profile: std::option::Option<crate::model::EncoderProfile>,
    }
    impl Builder {
        /// A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
        pub fn compression_factor(mut self, input: f64) -> Self {
            self.compression_factor = Some(input);
            self
        }
        /// A value that is used to calculate compression for an output. The bitrate of the output is calculated as follows: Output bitrate = (1 / compressionFactor) * (source bitrate) This property only applies to outputs that use the ST 2110 JPEG XS protocol, with a flow source that uses the CDI protocol. Valid values are floating point numbers in the range of 3.0 to 10.0, inclusive.
        pub fn set_compression_factor(mut self, input: std::option::Option<f64>) -> Self {
            self.compression_factor = input;
            self
        }
        /// A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, if at least one source on the flow uses the CDI protocol.
        pub fn encoder_profile(mut self, input: crate::model::EncoderProfile) -> Self {
            self.encoder_profile = Some(input);
            self
        }
        /// A setting on the encoder that drives compression settings. This property only applies to video media streams associated with outputs that use the ST 2110 JPEG XS protocol, if at least one source on the flow uses the CDI protocol.
        pub fn set_encoder_profile(
            mut self,
            input: std::option::Option<crate::model::EncoderProfile>,
        ) -> Self {
            self.encoder_profile = input;
            self
        }
        /// Consumes the builder and constructs a [`EncodingParametersRequest`](crate::model::EncodingParametersRequest)
        pub fn build(self) -> crate::model::EncodingParametersRequest {
            crate::model::EncodingParametersRequest {
                compression_factor: self.compression_factor.unwrap_or_default(),
                encoder_profile: self.encoder_profile,
            }
        }
    }
}
impl EncodingParametersRequest {
    /// Creates a new builder-style object to manufacture [`EncodingParametersRequest`](crate::model::EncodingParametersRequest)
    pub fn builder() -> crate::model::encoding_parameters_request::Builder {
        crate::model::encoding_parameters_request::Builder::default()
    }
}

/// The transport parameters that you want to associate with an outbound media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DestinationConfigurationRequest {
    /// The IP address where you want MediaConnect to send contents of the media stream.
    pub destination_ip: std::option::Option<std::string::String>,
    /// The port that you want MediaConnect to use when it distributes the media stream to the output.
    pub destination_port: i32,
    /// The VPC interface that you want to use for the media stream associated with the output.
    pub interface: std::option::Option<crate::model::InterfaceRequest>,
}
impl std::fmt::Debug for DestinationConfigurationRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DestinationConfigurationRequest");
        formatter.field("destination_ip", &self.destination_ip);
        formatter.field("destination_port", &self.destination_port);
        formatter.field("interface", &self.interface);
        formatter.finish()
    }
}
/// See [`DestinationConfigurationRequest`](crate::model::DestinationConfigurationRequest)
pub mod destination_configuration_request {
    /// A builder for [`DestinationConfigurationRequest`](crate::model::DestinationConfigurationRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) destination_ip: std::option::Option<std::string::String>,
        pub(crate) destination_port: std::option::Option<i32>,
        pub(crate) interface: std::option::Option<crate::model::InterfaceRequest>,
    }
    impl Builder {
        /// The IP address where you want MediaConnect to send contents of the media stream.
        pub fn destination_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination_ip = Some(input.into());
            self
        }
        /// The IP address where you want MediaConnect to send contents of the media stream.
        pub fn set_destination_ip(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.destination_ip = input;
            self
        }
        /// The port that you want MediaConnect to use when it distributes the media stream to the output.
        pub fn destination_port(mut self, input: i32) -> Self {
            self.destination_port = Some(input);
            self
        }
        /// The port that you want MediaConnect to use when it distributes the media stream to the output.
        pub fn set_destination_port(mut self, input: std::option::Option<i32>) -> Self {
            self.destination_port = input;
            self
        }
        /// The VPC interface that you want to use for the media stream associated with the output.
        pub fn interface(mut self, input: crate::model::InterfaceRequest) -> Self {
            self.interface = Some(input);
            self
        }
        /// The VPC interface that you want to use for the media stream associated with the output.
        pub fn set_interface(
            mut self,
            input: std::option::Option<crate::model::InterfaceRequest>,
        ) -> Self {
            self.interface = input;
            self
        }
        /// Consumes the builder and constructs a [`DestinationConfigurationRequest`](crate::model::DestinationConfigurationRequest)
        pub fn build(self) -> crate::model::DestinationConfigurationRequest {
            crate::model::DestinationConfigurationRequest {
                destination_ip: self.destination_ip,
                destination_port: self.destination_port.unwrap_or_default(),
                interface: self.interface,
            }
        }
    }
}
impl DestinationConfigurationRequest {
    /// Creates a new builder-style object to manufacture [`DestinationConfigurationRequest`](crate::model::DestinationConfigurationRequest)
    pub fn builder() -> crate::model::destination_configuration_request::Builder {
        crate::model::destination_configuration_request::Builder::default()
    }
}

/// A single track or stream of media that contains video, audio, or ancillary data. After you add a media stream to a flow, you can associate it with sources and outputs on that flow, as long as they use the CDI protocol or the ST 2110 JPEG XS protocol. Each source or output can consist of one or many media streams.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStream {
    /// Attributes that are related to the media stream.
    pub attributes: std::option::Option<crate::model::MediaStreamAttributes>,
    /// The sample rate for the stream. This value is measured in Hz.
    pub clock_rate: i32,
    /// A description that can help you quickly identify what your media stream is used for.
    pub description: std::option::Option<std::string::String>,
    /// The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
    pub fmt: i32,
    /// A unique identifier for the media stream.
    pub media_stream_id: i32,
    /// A name that helps you distinguish one media stream from another.
    pub media_stream_name: std::option::Option<std::string::String>,
    /// The type of media stream.
    pub media_stream_type: std::option::Option<crate::model::MediaStreamType>,
    /// The resolution of the video.
    pub video_format: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStream {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStream");
        formatter.field("attributes", &self.attributes);
        formatter.field("clock_rate", &self.clock_rate);
        formatter.field("description", &self.description);
        formatter.field("fmt", &self.fmt);
        formatter.field("media_stream_id", &self.media_stream_id);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.field("media_stream_type", &self.media_stream_type);
        formatter.field("video_format", &self.video_format);
        formatter.finish()
    }
}
/// See [`MediaStream`](crate::model::MediaStream)
pub mod media_stream {
    /// A builder for [`MediaStream`](crate::model::MediaStream)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<crate::model::MediaStreamAttributes>,
        pub(crate) clock_rate: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) fmt: std::option::Option<i32>,
        pub(crate) media_stream_id: std::option::Option<i32>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
        pub(crate) media_stream_type: std::option::Option<crate::model::MediaStreamType>,
        pub(crate) video_format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Attributes that are related to the media stream.
        pub fn attributes(mut self, input: crate::model::MediaStreamAttributes) -> Self {
            self.attributes = Some(input);
            self
        }
        /// Attributes that are related to the media stream.
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::MediaStreamAttributes>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// The sample rate for the stream. This value is measured in Hz.
        pub fn clock_rate(mut self, input: i32) -> Self {
            self.clock_rate = Some(input);
            self
        }
        /// The sample rate for the stream. This value is measured in Hz.
        pub fn set_clock_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.clock_rate = input;
            self
        }
        /// A description that can help you quickly identify what your media stream is used for.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description that can help you quickly identify what your media stream is used for.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        pub fn fmt(mut self, input: i32) -> Self {
            self.fmt = Some(input);
            self
        }
        /// The format type number (sometimes referred to as RTP payload type) of the media stream. MediaConnect assigns this value to the media stream. For ST 2110 JPEG XS outputs, you need to provide this value to the receiver.
        pub fn set_fmt(mut self, input: std::option::Option<i32>) -> Self {
            self.fmt = input;
            self
        }
        /// A unique identifier for the media stream.
        pub fn media_stream_id(mut self, input: i32) -> Self {
            self.media_stream_id = Some(input);
            self
        }
        /// A unique identifier for the media stream.
        pub fn set_media_stream_id(mut self, input: std::option::Option<i32>) -> Self {
            self.media_stream_id = input;
            self
        }
        /// A name that helps you distinguish one media stream from another.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// A name that helps you distinguish one media stream from another.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// The type of media stream.
        pub fn media_stream_type(mut self, input: crate::model::MediaStreamType) -> Self {
            self.media_stream_type = Some(input);
            self
        }
        /// The type of media stream.
        pub fn set_media_stream_type(
            mut self,
            input: std::option::Option<crate::model::MediaStreamType>,
        ) -> Self {
            self.media_stream_type = input;
            self
        }
        /// The resolution of the video.
        pub fn video_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_format = Some(input.into());
            self
        }
        /// The resolution of the video.
        pub fn set_video_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.video_format = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStream`](crate::model::MediaStream)
        pub fn build(self) -> crate::model::MediaStream {
            crate::model::MediaStream {
                attributes: self.attributes,
                clock_rate: self.clock_rate.unwrap_or_default(),
                description: self.description,
                fmt: self.fmt.unwrap_or_default(),
                media_stream_id: self.media_stream_id.unwrap_or_default(),
                media_stream_name: self.media_stream_name,
                media_stream_type: self.media_stream_type,
                video_format: self.video_format,
            }
        }
    }
}
impl MediaStream {
    /// Creates a new builder-style object to manufacture [`MediaStream`](crate::model::MediaStream)
    pub fn builder() -> crate::model::media_stream::Builder {
        crate::model::media_stream::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MediaStreamType {
    #[allow(missing_docs)] // documentation missing in model
    AncillaryData,
    #[allow(missing_docs)] // documentation missing in model
    Audio,
    #[allow(missing_docs)] // documentation missing in model
    Video,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MediaStreamType {
    fn from(s: &str) -> Self {
        match s {
            "ancillary-data" => MediaStreamType::AncillaryData,
            "audio" => MediaStreamType::Audio,
            "video" => MediaStreamType::Video,
            other => MediaStreamType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MediaStreamType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MediaStreamType::from(s))
    }
}
impl MediaStreamType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MediaStreamType::AncillaryData => "ancillary-data",
            MediaStreamType::Audio => "audio",
            MediaStreamType::Video => "video",
            MediaStreamType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ancillary-data", "audio", "video"]
    }
}
impl AsRef<str> for MediaStreamType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Attributes that are related to the media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStreamAttributes {
    /// A set of parameters that define the media stream.
    pub fmtp: std::option::Option<crate::model::Fmtp>,
    /// The audio language, in a format that is recognized by the receiver.
    pub lang: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStreamAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStreamAttributes");
        formatter.field("fmtp", &self.fmtp);
        formatter.field("lang", &self.lang);
        formatter.finish()
    }
}
/// See [`MediaStreamAttributes`](crate::model::MediaStreamAttributes)
pub mod media_stream_attributes {
    /// A builder for [`MediaStreamAttributes`](crate::model::MediaStreamAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fmtp: std::option::Option<crate::model::Fmtp>,
        pub(crate) lang: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// A set of parameters that define the media stream.
        pub fn fmtp(mut self, input: crate::model::Fmtp) -> Self {
            self.fmtp = Some(input);
            self
        }
        /// A set of parameters that define the media stream.
        pub fn set_fmtp(mut self, input: std::option::Option<crate::model::Fmtp>) -> Self {
            self.fmtp = input;
            self
        }
        /// The audio language, in a format that is recognized by the receiver.
        pub fn lang(mut self, input: impl Into<std::string::String>) -> Self {
            self.lang = Some(input.into());
            self
        }
        /// The audio language, in a format that is recognized by the receiver.
        pub fn set_lang(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lang = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStreamAttributes`](crate::model::MediaStreamAttributes)
        pub fn build(self) -> crate::model::MediaStreamAttributes {
            crate::model::MediaStreamAttributes {
                fmtp: self.fmtp,
                lang: self.lang,
            }
        }
    }
}
impl MediaStreamAttributes {
    /// Creates a new builder-style object to manufacture [`MediaStreamAttributes`](crate::model::MediaStreamAttributes)
    pub fn builder() -> crate::model::media_stream_attributes::Builder {
        crate::model::media_stream_attributes::Builder::default()
    }
}

/// FMTP
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Fmtp {
    /// The format of the audio channel.
    pub channel_order: std::option::Option<std::string::String>,
    /// The format that is used for the representation of color.
    pub colorimetry: std::option::Option<crate::model::Colorimetry>,
    /// The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
    pub exact_framerate: std::option::Option<std::string::String>,
    /// The pixel aspect ratio (PAR) of the video.
    pub par: std::option::Option<std::string::String>,
    /// The encoding range of the video.
    pub range: std::option::Option<crate::model::Range>,
    /// The type of compression that was used to smooth the video’s appearance
    pub scan_mode: std::option::Option<crate::model::ScanMode>,
    /// The transfer characteristic system (TCS) that is used in the video.
    pub tcs: std::option::Option<crate::model::Tcs>,
}
impl std::fmt::Debug for Fmtp {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Fmtp");
        formatter.field("channel_order", &self.channel_order);
        formatter.field("colorimetry", &self.colorimetry);
        formatter.field("exact_framerate", &self.exact_framerate);
        formatter.field("par", &self.par);
        formatter.field("range", &self.range);
        formatter.field("scan_mode", &self.scan_mode);
        formatter.field("tcs", &self.tcs);
        formatter.finish()
    }
}
/// See [`Fmtp`](crate::model::Fmtp)
pub mod fmtp {
    /// A builder for [`Fmtp`](crate::model::Fmtp)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_order: std::option::Option<std::string::String>,
        pub(crate) colorimetry: std::option::Option<crate::model::Colorimetry>,
        pub(crate) exact_framerate: std::option::Option<std::string::String>,
        pub(crate) par: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<crate::model::Range>,
        pub(crate) scan_mode: std::option::Option<crate::model::ScanMode>,
        pub(crate) tcs: std::option::Option<crate::model::Tcs>,
    }
    impl Builder {
        /// The format of the audio channel.
        pub fn channel_order(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_order = Some(input.into());
            self
        }
        /// The format of the audio channel.
        pub fn set_channel_order(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_order = input;
            self
        }
        /// The format that is used for the representation of color.
        pub fn colorimetry(mut self, input: crate::model::Colorimetry) -> Self {
            self.colorimetry = Some(input);
            self
        }
        /// The format that is used for the representation of color.
        pub fn set_colorimetry(
            mut self,
            input: std::option::Option<crate::model::Colorimetry>,
        ) -> Self {
            self.colorimetry = input;
            self
        }
        /// The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
        pub fn exact_framerate(mut self, input: impl Into<std::string::String>) -> Self {
            self.exact_framerate = Some(input.into());
            self
        }
        /// The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
        pub fn set_exact_framerate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exact_framerate = input;
            self
        }
        /// The pixel aspect ratio (PAR) of the video.
        pub fn par(mut self, input: impl Into<std::string::String>) -> Self {
            self.par = Some(input.into());
            self
        }
        /// The pixel aspect ratio (PAR) of the video.
        pub fn set_par(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.par = input;
            self
        }
        /// The encoding range of the video.
        pub fn range(mut self, input: crate::model::Range) -> Self {
            self.range = Some(input);
            self
        }
        /// The encoding range of the video.
        pub fn set_range(mut self, input: std::option::Option<crate::model::Range>) -> Self {
            self.range = input;
            self
        }
        /// The type of compression that was used to smooth the video’s appearance
        pub fn scan_mode(mut self, input: crate::model::ScanMode) -> Self {
            self.scan_mode = Some(input);
            self
        }
        /// The type of compression that was used to smooth the video’s appearance
        pub fn set_scan_mode(mut self, input: std::option::Option<crate::model::ScanMode>) -> Self {
            self.scan_mode = input;
            self
        }
        /// The transfer characteristic system (TCS) that is used in the video.
        pub fn tcs(mut self, input: crate::model::Tcs) -> Self {
            self.tcs = Some(input);
            self
        }
        /// The transfer characteristic system (TCS) that is used in the video.
        pub fn set_tcs(mut self, input: std::option::Option<crate::model::Tcs>) -> Self {
            self.tcs = input;
            self
        }
        /// Consumes the builder and constructs a [`Fmtp`](crate::model::Fmtp)
        pub fn build(self) -> crate::model::Fmtp {
            crate::model::Fmtp {
                channel_order: self.channel_order,
                colorimetry: self.colorimetry,
                exact_framerate: self.exact_framerate,
                par: self.par,
                range: self.range,
                scan_mode: self.scan_mode,
                tcs: self.tcs,
            }
        }
    }
}
impl Fmtp {
    /// Creates a new builder-style object to manufacture [`Fmtp`](crate::model::Fmtp)
    pub fn builder() -> crate::model::fmtp::Builder {
        crate::model::fmtp::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Tcs {
    #[allow(missing_docs)] // documentation missing in model
    Bt2100Linhlg,
    #[allow(missing_docs)] // documentation missing in model
    Bt2100Linpq,
    #[allow(missing_docs)] // documentation missing in model
    Density,
    #[allow(missing_docs)] // documentation missing in model
    Hlg,
    #[allow(missing_docs)] // documentation missing in model
    Linear,
    #[allow(missing_docs)] // documentation missing in model
    Pq,
    #[allow(missing_docs)] // documentation missing in model
    Sdr,
    #[allow(missing_docs)] // documentation missing in model
    St20651,
    #[allow(missing_docs)] // documentation missing in model
    St4281,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Tcs {
    fn from(s: &str) -> Self {
        match s {
            "BT2100LINHLG" => Tcs::Bt2100Linhlg,
            "BT2100LINPQ" => Tcs::Bt2100Linpq,
            "DENSITY" => Tcs::Density,
            "HLG" => Tcs::Hlg,
            "LINEAR" => Tcs::Linear,
            "PQ" => Tcs::Pq,
            "SDR" => Tcs::Sdr,
            "ST2065-1" => Tcs::St20651,
            "ST428-1" => Tcs::St4281,
            other => Tcs::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Tcs {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Tcs::from(s))
    }
}
impl Tcs {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Tcs::Bt2100Linhlg => "BT2100LINHLG",
            Tcs::Bt2100Linpq => "BT2100LINPQ",
            Tcs::Density => "DENSITY",
            Tcs::Hlg => "HLG",
            Tcs::Linear => "LINEAR",
            Tcs::Pq => "PQ",
            Tcs::Sdr => "SDR",
            Tcs::St20651 => "ST2065-1",
            Tcs::St4281 => "ST428-1",
            Tcs::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BT2100LINHLG",
            "BT2100LINPQ",
            "DENSITY",
            "HLG",
            "LINEAR",
            "PQ",
            "SDR",
            "ST2065-1",
            "ST428-1",
        ]
    }
}
impl AsRef<str> for Tcs {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScanMode {
    #[allow(missing_docs)] // documentation missing in model
    Interlace,
    #[allow(missing_docs)] // documentation missing in model
    Progressive,
    #[allow(missing_docs)] // documentation missing in model
    ProgressiveSegmentedFrame,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScanMode {
    fn from(s: &str) -> Self {
        match s {
            "interlace" => ScanMode::Interlace,
            "progressive" => ScanMode::Progressive,
            "progressive-segmented-frame" => ScanMode::ProgressiveSegmentedFrame,
            other => ScanMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScanMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScanMode::from(s))
    }
}
impl ScanMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScanMode::Interlace => "interlace",
            ScanMode::Progressive => "progressive",
            ScanMode::ProgressiveSegmentedFrame => "progressive-segmented-frame",
            ScanMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["interlace", "progressive", "progressive-segmented-frame"]
    }
}
impl AsRef<str> for ScanMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Range {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    Fullprotect,
    #[allow(missing_docs)] // documentation missing in model
    Narrow,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Range {
    fn from(s: &str) -> Self {
        match s {
            "FULL" => Range::Full,
            "FULLPROTECT" => Range::Fullprotect,
            "NARROW" => Range::Narrow,
            other => Range::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Range {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Range::from(s))
    }
}
impl Range {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Range::Full => "FULL",
            Range::Fullprotect => "FULLPROTECT",
            Range::Narrow => "NARROW",
            Range::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL", "FULLPROTECT", "NARROW"]
    }
}
impl AsRef<str> for Range {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Colorimetry {
    #[allow(missing_docs)] // documentation missing in model
    Bt2020,
    #[allow(missing_docs)] // documentation missing in model
    Bt2100,
    #[allow(missing_docs)] // documentation missing in model
    Bt601,
    #[allow(missing_docs)] // documentation missing in model
    Bt709,
    #[allow(missing_docs)] // documentation missing in model
    St20651,
    #[allow(missing_docs)] // documentation missing in model
    St20653,
    #[allow(missing_docs)] // documentation missing in model
    Xyz,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Colorimetry {
    fn from(s: &str) -> Self {
        match s {
            "BT2020" => Colorimetry::Bt2020,
            "BT2100" => Colorimetry::Bt2100,
            "BT601" => Colorimetry::Bt601,
            "BT709" => Colorimetry::Bt709,
            "ST2065-1" => Colorimetry::St20651,
            "ST2065-3" => Colorimetry::St20653,
            "XYZ" => Colorimetry::Xyz,
            other => Colorimetry::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Colorimetry {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Colorimetry::from(s))
    }
}
impl Colorimetry {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Colorimetry::Bt2020 => "BT2020",
            Colorimetry::Bt2100 => "BT2100",
            Colorimetry::Bt601 => "BT601",
            Colorimetry::Bt709 => "BT709",
            Colorimetry::St20651 => "ST2065-1",
            Colorimetry::St20653 => "ST2065-3",
            Colorimetry::Xyz => "XYZ",
            Colorimetry::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "BT2020", "BT2100", "BT601", "BT709", "ST2065-1", "ST2065-3", "XYZ",
        ]
    }
}
impl AsRef<str> for Colorimetry {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// Attributes that are related to the media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MediaStreamAttributesRequest {
    /// The settings that you want to use to define the media stream.
    pub fmtp: std::option::Option<crate::model::FmtpRequest>,
    /// The audio language, in a format that is recognized by the receiver.
    pub lang: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MediaStreamAttributesRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MediaStreamAttributesRequest");
        formatter.field("fmtp", &self.fmtp);
        formatter.field("lang", &self.lang);
        formatter.finish()
    }
}
/// See [`MediaStreamAttributesRequest`](crate::model::MediaStreamAttributesRequest)
pub mod media_stream_attributes_request {
    /// A builder for [`MediaStreamAttributesRequest`](crate::model::MediaStreamAttributesRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fmtp: std::option::Option<crate::model::FmtpRequest>,
        pub(crate) lang: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The settings that you want to use to define the media stream.
        pub fn fmtp(mut self, input: crate::model::FmtpRequest) -> Self {
            self.fmtp = Some(input);
            self
        }
        /// The settings that you want to use to define the media stream.
        pub fn set_fmtp(mut self, input: std::option::Option<crate::model::FmtpRequest>) -> Self {
            self.fmtp = input;
            self
        }
        /// The audio language, in a format that is recognized by the receiver.
        pub fn lang(mut self, input: impl Into<std::string::String>) -> Self {
            self.lang = Some(input.into());
            self
        }
        /// The audio language, in a format that is recognized by the receiver.
        pub fn set_lang(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lang = input;
            self
        }
        /// Consumes the builder and constructs a [`MediaStreamAttributesRequest`](crate::model::MediaStreamAttributesRequest)
        pub fn build(self) -> crate::model::MediaStreamAttributesRequest {
            crate::model::MediaStreamAttributesRequest {
                fmtp: self.fmtp,
                lang: self.lang,
            }
        }
    }
}
impl MediaStreamAttributesRequest {
    /// Creates a new builder-style object to manufacture [`MediaStreamAttributesRequest`](crate::model::MediaStreamAttributesRequest)
    pub fn builder() -> crate::model::media_stream_attributes_request::Builder {
        crate::model::media_stream_attributes_request::Builder::default()
    }
}

/// The settings that you want to use to define the media stream.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FmtpRequest {
    /// The format of the audio channel.
    pub channel_order: std::option::Option<std::string::String>,
    /// The format that is used for the representation of color.
    pub colorimetry: std::option::Option<crate::model::Colorimetry>,
    /// The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
    pub exact_framerate: std::option::Option<std::string::String>,
    /// The pixel aspect ratio (PAR) of the video.
    pub par: std::option::Option<std::string::String>,
    /// The encoding range of the video.
    pub range: std::option::Option<crate::model::Range>,
    /// The type of compression that was used to smooth the video’s appearance.
    pub scan_mode: std::option::Option<crate::model::ScanMode>,
    /// The transfer characteristic system (TCS) that is used in the video.
    pub tcs: std::option::Option<crate::model::Tcs>,
}
impl std::fmt::Debug for FmtpRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FmtpRequest");
        formatter.field("channel_order", &self.channel_order);
        formatter.field("colorimetry", &self.colorimetry);
        formatter.field("exact_framerate", &self.exact_framerate);
        formatter.field("par", &self.par);
        formatter.field("range", &self.range);
        formatter.field("scan_mode", &self.scan_mode);
        formatter.field("tcs", &self.tcs);
        formatter.finish()
    }
}
/// See [`FmtpRequest`](crate::model::FmtpRequest)
pub mod fmtp_request {
    /// A builder for [`FmtpRequest`](crate::model::FmtpRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) channel_order: std::option::Option<std::string::String>,
        pub(crate) colorimetry: std::option::Option<crate::model::Colorimetry>,
        pub(crate) exact_framerate: std::option::Option<std::string::String>,
        pub(crate) par: std::option::Option<std::string::String>,
        pub(crate) range: std::option::Option<crate::model::Range>,
        pub(crate) scan_mode: std::option::Option<crate::model::ScanMode>,
        pub(crate) tcs: std::option::Option<crate::model::Tcs>,
    }
    impl Builder {
        /// The format of the audio channel.
        pub fn channel_order(mut self, input: impl Into<std::string::String>) -> Self {
            self.channel_order = Some(input.into());
            self
        }
        /// The format of the audio channel.
        pub fn set_channel_order(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.channel_order = input;
            self
        }
        /// The format that is used for the representation of color.
        pub fn colorimetry(mut self, input: crate::model::Colorimetry) -> Self {
            self.colorimetry = Some(input);
            self
        }
        /// The format that is used for the representation of color.
        pub fn set_colorimetry(
            mut self,
            input: std::option::Option<crate::model::Colorimetry>,
        ) -> Self {
            self.colorimetry = input;
            self
        }
        /// The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
        pub fn exact_framerate(mut self, input: impl Into<std::string::String>) -> Self {
            self.exact_framerate = Some(input.into());
            self
        }
        /// The frame rate for the video stream, in frames/second. For example: 60000/1001. If you specify a whole number, MediaConnect uses a ratio of N/1. For example, if you specify 60, MediaConnect uses 60/1 as the exactFramerate.
        pub fn set_exact_framerate(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.exact_framerate = input;
            self
        }
        /// The pixel aspect ratio (PAR) of the video.
        pub fn par(mut self, input: impl Into<std::string::String>) -> Self {
            self.par = Some(input.into());
            self
        }
        /// The pixel aspect ratio (PAR) of the video.
        pub fn set_par(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.par = input;
            self
        }
        /// The encoding range of the video.
        pub fn range(mut self, input: crate::model::Range) -> Self {
            self.range = Some(input);
            self
        }
        /// The encoding range of the video.
        pub fn set_range(mut self, input: std::option::Option<crate::model::Range>) -> Self {
            self.range = input;
            self
        }
        /// The type of compression that was used to smooth the video’s appearance.
        pub fn scan_mode(mut self, input: crate::model::ScanMode) -> Self {
            self.scan_mode = Some(input);
            self
        }
        /// The type of compression that was used to smooth the video’s appearance.
        pub fn set_scan_mode(mut self, input: std::option::Option<crate::model::ScanMode>) -> Self {
            self.scan_mode = input;
            self
        }
        /// The transfer characteristic system (TCS) that is used in the video.
        pub fn tcs(mut self, input: crate::model::Tcs) -> Self {
            self.tcs = Some(input);
            self
        }
        /// The transfer characteristic system (TCS) that is used in the video.
        pub fn set_tcs(mut self, input: std::option::Option<crate::model::Tcs>) -> Self {
            self.tcs = input;
            self
        }
        /// Consumes the builder and constructs a [`FmtpRequest`](crate::model::FmtpRequest)
        pub fn build(self) -> crate::model::FmtpRequest {
            crate::model::FmtpRequest {
                channel_order: self.channel_order,
                colorimetry: self.colorimetry,
                exact_framerate: self.exact_framerate,
                par: self.par,
                range: self.range,
                scan_mode: self.scan_mode,
                tcs: self.tcs,
            }
        }
    }
}
impl FmtpRequest {
    /// Creates a new builder-style object to manufacture [`FmtpRequest`](crate::model::FmtpRequest)
    pub fn builder() -> crate::model::fmtp_request::Builder {
        crate::model::fmtp_request::Builder::default()
    }
}

/// The settings for a flow entitlement.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entitlement {
    /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
    pub data_transfer_subscriber_fee_percent: i32,
    /// A description of the entitlement.
    pub description: std::option::Option<std::string::String>,
    /// The type of encryption that will be used on the output that is associated with this entitlement.
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// The ARN of the entitlement.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// An indication of whether the entitlement is enabled.
    pub entitlement_status: std::option::Option<crate::model::EntitlementStatus>,
    /// The name of the entitlement.
    pub name: std::option::Option<std::string::String>,
    /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
    pub subscribers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Entitlement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entitlement");
        formatter.field(
            "data_transfer_subscriber_fee_percent",
            &self.data_transfer_subscriber_fee_percent,
        );
        formatter.field("description", &self.description);
        formatter.field("encryption", &self.encryption);
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("entitlement_status", &self.entitlement_status);
        formatter.field("name", &self.name);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}
/// See [`Entitlement`](crate::model::Entitlement)
pub mod entitlement {
    /// A builder for [`Entitlement`](crate::model::Entitlement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_transfer_subscriber_fee_percent: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) entitlement_status: std::option::Option<crate::model::EntitlementStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn data_transfer_subscriber_fee_percent(mut self, input: i32) -> Self {
            self.data_transfer_subscriber_fee_percent = Some(input);
            self
        }
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn set_data_transfer_subscriber_fee_percent(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.data_transfer_subscriber_fee_percent = input;
            self
        }
        /// A description of the entitlement.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the entitlement.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The type of encryption that will be used on the output that is associated with this entitlement.
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// The type of encryption that will be used on the output that is associated with this entitlement.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// The ARN of the entitlement.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// An indication of whether the entitlement is enabled.
        pub fn entitlement_status(mut self, input: crate::model::EntitlementStatus) -> Self {
            self.entitlement_status = Some(input);
            self
        }
        /// An indication of whether the entitlement is enabled.
        pub fn set_entitlement_status(
            mut self,
            input: std::option::Option<crate::model::EntitlementStatus>,
        ) -> Self {
            self.entitlement_status = input;
            self
        }
        /// The name of the entitlement.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the entitlement.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn subscribers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input.into());
            self.subscribers = Some(v);
            self
        }
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flow using your content as the source.
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`Entitlement`](crate::model::Entitlement)
        pub fn build(self) -> crate::model::Entitlement {
            crate::model::Entitlement {
                data_transfer_subscriber_fee_percent: self
                    .data_transfer_subscriber_fee_percent
                    .unwrap_or_default(),
                description: self.description,
                encryption: self.encryption,
                entitlement_arn: self.entitlement_arn,
                entitlement_status: self.entitlement_status,
                name: self.name,
                subscribers: self.subscribers,
            }
        }
    }
}
impl Entitlement {
    /// Creates a new builder-style object to manufacture [`Entitlement`](crate::model::Entitlement)
    pub fn builder() -> crate::model::entitlement::Builder {
        crate::model::entitlement::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EntitlementStatus {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EntitlementStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => EntitlementStatus::Disabled,
            "ENABLED" => EntitlementStatus::Enabled,
            other => EntitlementStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EntitlementStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EntitlementStatus::from(s))
    }
}
impl EntitlementStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EntitlementStatus::Disabled => "DISABLED",
            EntitlementStatus::Enabled => "ENABLED",
            EntitlementStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for EntitlementStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The settings for a flow, including its source, outputs, and entitlements.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Flow {
    /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
    pub availability_zone: std::option::Option<std::string::String>,
    /// A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
    pub description: std::option::Option<std::string::String>,
    /// The IP address from which video will be sent to output destinations.
    pub egress_ip: std::option::Option<std::string::String>,
    /// The entitlements in this flow.
    pub entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
    /// The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
    pub media_streams: std::option::Option<std::vec::Vec<crate::model::MediaStream>>,
    /// The name of the flow.
    pub name: std::option::Option<std::string::String>,
    /// The outputs in this flow.
    pub outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
    /// The settings for the source of the flow.
    pub source: std::option::Option<crate::model::Source>,
    /// The settings for source failover
    pub source_failover_config: std::option::Option<crate::model::FailoverConfig>,
    #[allow(missing_docs)] // documentation missing in model
    pub sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
    /// The current status of the flow.
    pub status: std::option::Option<crate::model::Status>,
    /// The VPC Interfaces for this flow.
    pub vpc_interfaces: std::option::Option<std::vec::Vec<crate::model::VpcInterface>>,
}
impl std::fmt::Debug for Flow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Flow");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("description", &self.description);
        formatter.field("egress_ip", &self.egress_ip);
        formatter.field("entitlements", &self.entitlements);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("media_streams", &self.media_streams);
        formatter.field("name", &self.name);
        formatter.field("outputs", &self.outputs);
        formatter.field("source", &self.source);
        formatter.field("source_failover_config", &self.source_failover_config);
        formatter.field("sources", &self.sources);
        formatter.field("status", &self.status);
        formatter.field("vpc_interfaces", &self.vpc_interfaces);
        formatter.finish()
    }
}
/// See [`Flow`](crate::model::Flow)
pub mod flow {
    /// A builder for [`Flow`](crate::model::Flow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) egress_ip: std::option::Option<std::string::String>,
        pub(crate) entitlements: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) media_streams: std::option::Option<std::vec::Vec<crate::model::MediaStream>>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) outputs: std::option::Option<std::vec::Vec<crate::model::Output>>,
        pub(crate) source: std::option::Option<crate::model::Source>,
        pub(crate) source_failover_config: std::option::Option<crate::model::FailoverConfig>,
        pub(crate) sources: std::option::Option<std::vec::Vec<crate::model::Source>>,
        pub(crate) status: std::option::Option<crate::model::Status>,
        pub(crate) vpc_interfaces: std::option::Option<std::vec::Vec<crate::model::VpcInterface>>,
    }
    impl Builder {
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the flow. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The IP address from which video will be sent to output destinations.
        pub fn egress_ip(mut self, input: impl Into<std::string::String>) -> Self {
            self.egress_ip = Some(input.into());
            self
        }
        /// The IP address from which video will be sent to output destinations.
        pub fn set_egress_ip(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.egress_ip = input;
            self
        }
        /// Appends an item to `entitlements`.
        ///
        /// To override the contents of this collection use [`set_entitlements`](Self::set_entitlements).
        ///
        /// The entitlements in this flow.
        pub fn entitlements(mut self, input: impl Into<crate::model::Entitlement>) -> Self {
            let mut v = self.entitlements.unwrap_or_default();
            v.push(input.into());
            self.entitlements = Some(v);
            self
        }
        /// The entitlements in this flow.
        pub fn set_entitlements(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Entitlement>>,
        ) -> Self {
            self.entitlements = input;
            self
        }
        /// The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// Appends an item to `media_streams`.
        ///
        /// To override the contents of this collection use [`set_media_streams`](Self::set_media_streams).
        ///
        /// The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
        pub fn media_streams(mut self, input: impl Into<crate::model::MediaStream>) -> Self {
            let mut v = self.media_streams.unwrap_or_default();
            v.push(input.into());
            self.media_streams = Some(v);
            self
        }
        /// The media streams that are associated with the flow. After you associate a media stream with a source, you can also associate it with outputs on the flow.
        pub fn set_media_streams(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MediaStream>>,
        ) -> Self {
            self.media_streams = input;
            self
        }
        /// The name of the flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `outputs`.
        ///
        /// To override the contents of this collection use [`set_outputs`](Self::set_outputs).
        ///
        /// The outputs in this flow.
        pub fn outputs(mut self, input: impl Into<crate::model::Output>) -> Self {
            let mut v = self.outputs.unwrap_or_default();
            v.push(input.into());
            self.outputs = Some(v);
            self
        }
        /// The outputs in this flow.
        pub fn set_outputs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Output>>,
        ) -> Self {
            self.outputs = input;
            self
        }
        /// The settings for the source of the flow.
        pub fn source(mut self, input: crate::model::Source) -> Self {
            self.source = Some(input);
            self
        }
        /// The settings for the source of the flow.
        pub fn set_source(mut self, input: std::option::Option<crate::model::Source>) -> Self {
            self.source = input;
            self
        }
        /// The settings for source failover
        pub fn source_failover_config(mut self, input: crate::model::FailoverConfig) -> Self {
            self.source_failover_config = Some(input);
            self
        }
        /// The settings for source failover
        pub fn set_source_failover_config(
            mut self,
            input: std::option::Option<crate::model::FailoverConfig>,
        ) -> Self {
            self.source_failover_config = input;
            self
        }
        /// Appends an item to `sources`.
        ///
        /// To override the contents of this collection use [`set_sources`](Self::set_sources).
        ///
        pub fn sources(mut self, input: impl Into<crate::model::Source>) -> Self {
            let mut v = self.sources.unwrap_or_default();
            v.push(input.into());
            self.sources = Some(v);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_sources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Source>>,
        ) -> Self {
            self.sources = input;
            self
        }
        /// The current status of the flow.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The current status of the flow.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `vpc_interfaces`.
        ///
        /// To override the contents of this collection use [`set_vpc_interfaces`](Self::set_vpc_interfaces).
        ///
        /// The VPC Interfaces for this flow.
        pub fn vpc_interfaces(mut self, input: impl Into<crate::model::VpcInterface>) -> Self {
            let mut v = self.vpc_interfaces.unwrap_or_default();
            v.push(input.into());
            self.vpc_interfaces = Some(v);
            self
        }
        /// The VPC Interfaces for this flow.
        pub fn set_vpc_interfaces(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::VpcInterface>>,
        ) -> Self {
            self.vpc_interfaces = input;
            self
        }
        /// Consumes the builder and constructs a [`Flow`](crate::model::Flow)
        pub fn build(self) -> crate::model::Flow {
            crate::model::Flow {
                availability_zone: self.availability_zone,
                description: self.description,
                egress_ip: self.egress_ip,
                entitlements: self.entitlements,
                flow_arn: self.flow_arn,
                media_streams: self.media_streams,
                name: self.name,
                outputs: self.outputs,
                source: self.source,
                source_failover_config: self.source_failover_config,
                sources: self.sources,
                status: self.status,
                vpc_interfaces: self.vpc_interfaces,
            }
        }
    }
}
impl Flow {
    /// Creates a new builder-style object to manufacture [`Flow`](crate::model::Flow)
    pub fn builder() -> crate::model::flow::Builder {
        crate::model::flow::Builder::default()
    }
}

/// The settings for a VPC Source.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcInterface {
    /// Immutable and has to be a unique against other VpcInterfaces in this Flow
    pub name: std::option::Option<std::string::String>,
    /// IDs of the network interfaces created in customer's account by MediaConnect.
    pub network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// The type of network interface.
    pub network_interface_type: std::option::Option<crate::model::NetworkInterfaceType>,
    /// Role Arn MediaConnect can assumes to create ENIs in customer's account
    pub role_arn: std::option::Option<std::string::String>,
    /// Security Group IDs to be used on ENI.
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Subnet must be in the AZ of the Flow
    pub subnet_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcInterface {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcInterface");
        formatter.field("name", &self.name);
        formatter.field("network_interface_ids", &self.network_interface_ids);
        formatter.field("network_interface_type", &self.network_interface_type);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.finish()
    }
}
/// See [`VpcInterface`](crate::model::VpcInterface)
pub mod vpc_interface {
    /// A builder for [`VpcInterface`](crate::model::VpcInterface)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) network_interface_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) network_interface_type: std::option::Option<crate::model::NetworkInterfaceType>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Immutable and has to be a unique against other VpcInterfaces in this Flow
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// Immutable and has to be a unique against other VpcInterfaces in this Flow
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `network_interface_ids`.
        ///
        /// To override the contents of this collection use [`set_network_interface_ids`](Self::set_network_interface_ids).
        ///
        /// IDs of the network interfaces created in customer's account by MediaConnect.
        pub fn network_interface_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.network_interface_ids.unwrap_or_default();
            v.push(input.into());
            self.network_interface_ids = Some(v);
            self
        }
        /// IDs of the network interfaces created in customer's account by MediaConnect.
        pub fn set_network_interface_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.network_interface_ids = input;
            self
        }
        /// The type of network interface.
        pub fn network_interface_type(mut self, input: crate::model::NetworkInterfaceType) -> Self {
            self.network_interface_type = Some(input);
            self
        }
        /// The type of network interface.
        pub fn set_network_interface_type(
            mut self,
            input: std::option::Option<crate::model::NetworkInterfaceType>,
        ) -> Self {
            self.network_interface_type = input;
            self
        }
        /// Role Arn MediaConnect can assumes to create ENIs in customer's account
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// Role Arn MediaConnect can assumes to create ENIs in customer's account
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// Security Group IDs to be used on ENI.
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// Security Group IDs to be used on ENI.
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Subnet must be in the AZ of the Flow
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// Subnet must be in the AZ of the Flow
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcInterface`](crate::model::VpcInterface)
        pub fn build(self) -> crate::model::VpcInterface {
            crate::model::VpcInterface {
                name: self.name,
                network_interface_ids: self.network_interface_ids,
                network_interface_type: self.network_interface_type,
                role_arn: self.role_arn,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
            }
        }
    }
}
impl VpcInterface {
    /// Creates a new builder-style object to manufacture [`VpcInterface`](crate::model::VpcInterface)
    pub fn builder() -> crate::model::vpc_interface::Builder {
        crate::model::vpc_interface::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkInterfaceType {
    #[allow(missing_docs)] // documentation missing in model
    Efa,
    #[allow(missing_docs)] // documentation missing in model
    Ena,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkInterfaceType {
    fn from(s: &str) -> Self {
        match s {
            "efa" => NetworkInterfaceType::Efa,
            "ena" => NetworkInterfaceType::Ena,
            other => NetworkInterfaceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkInterfaceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkInterfaceType::from(s))
    }
}
impl NetworkInterfaceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkInterfaceType::Efa => "efa",
            NetworkInterfaceType::Ena => "ena",
            NetworkInterfaceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["efa", "ena"]
    }
}
impl AsRef<str> for NetworkInterfaceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Status {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    Standby,
    #[allow(missing_docs)] // documentation missing in model
    Starting,
    #[allow(missing_docs)] // documentation missing in model
    Stopping,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Status {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => Status::Active,
            "DELETING" => Status::Deleting,
            "ERROR" => Status::Error,
            "STANDBY" => Status::Standby,
            "STARTING" => Status::Starting,
            "STOPPING" => Status::Stopping,
            "UPDATING" => Status::Updating,
            other => Status::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Status {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Status::from(s))
    }
}
impl Status {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Status::Active => "ACTIVE",
            Status::Deleting => "DELETING",
            Status::Error => "ERROR",
            Status::Standby => "STANDBY",
            Status::Starting => "STARTING",
            Status::Stopping => "STOPPING",
            Status::Updating => "UPDATING",
            Status::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTIVE", "DELETING", "ERROR", "STANDBY", "STARTING", "STOPPING", "UPDATING",
        ]
    }
}
impl AsRef<str> for Status {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The settings for source failover
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailoverConfig {
    /// The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
    pub failover_mode: std::option::Option<crate::model::FailoverMode>,
    /// Search window time to look for dash-7 packets
    pub recovery_window: i32,
    /// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
    pub source_priority: std::option::Option<crate::model::SourcePriority>,
    #[allow(missing_docs)] // documentation missing in model
    pub state: std::option::Option<crate::model::State>,
}
impl std::fmt::Debug for FailoverConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailoverConfig");
        formatter.field("failover_mode", &self.failover_mode);
        formatter.field("recovery_window", &self.recovery_window);
        formatter.field("source_priority", &self.source_priority);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`FailoverConfig`](crate::model::FailoverConfig)
pub mod failover_config {
    /// A builder for [`FailoverConfig`](crate::model::FailoverConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failover_mode: std::option::Option<crate::model::FailoverMode>,
        pub(crate) recovery_window: std::option::Option<i32>,
        pub(crate) source_priority: std::option::Option<crate::model::SourcePriority>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        pub fn failover_mode(mut self, input: crate::model::FailoverMode) -> Self {
            self.failover_mode = Some(input);
            self
        }
        /// The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        pub fn set_failover_mode(
            mut self,
            input: std::option::Option<crate::model::FailoverMode>,
        ) -> Self {
            self.failover_mode = input;
            self
        }
        /// Search window time to look for dash-7 packets
        pub fn recovery_window(mut self, input: i32) -> Self {
            self.recovery_window = Some(input);
            self
        }
        /// Search window time to look for dash-7 packets
        pub fn set_recovery_window(mut self, input: std::option::Option<i32>) -> Self {
            self.recovery_window = input;
            self
        }
        /// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        pub fn source_priority(mut self, input: crate::model::SourcePriority) -> Self {
            self.source_priority = Some(input);
            self
        }
        /// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        pub fn set_source_priority(
            mut self,
            input: std::option::Option<crate::model::SourcePriority>,
        ) -> Self {
            self.source_priority = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`FailoverConfig`](crate::model::FailoverConfig)
        pub fn build(self) -> crate::model::FailoverConfig {
            crate::model::FailoverConfig {
                failover_mode: self.failover_mode,
                recovery_window: self.recovery_window.unwrap_or_default(),
                source_priority: self.source_priority,
                state: self.state,
            }
        }
    }
}
impl FailoverConfig {
    /// Creates a new builder-style object to manufacture [`FailoverConfig`](crate::model::FailoverConfig)
    pub fn builder() -> crate::model::failover_config::Builder {
        crate::model::failover_config::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum State {
    #[allow(missing_docs)] // documentation missing in model
    Disabled,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for State {
    fn from(s: &str) -> Self {
        match s {
            "DISABLED" => State::Disabled,
            "ENABLED" => State::Enabled,
            other => State::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for State {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(State::from(s))
    }
}
impl State {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            State::Disabled => "DISABLED",
            State::Enabled => "ENABLED",
            State::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLED", "ENABLED"]
    }
}
impl AsRef<str> for State {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SourcePriority {
    /// The name of the source you choose as the primary source for this flow.
    pub primary_source: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SourcePriority {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SourcePriority");
        formatter.field("primary_source", &self.primary_source);
        formatter.finish()
    }
}
/// See [`SourcePriority`](crate::model::SourcePriority)
pub mod source_priority {
    /// A builder for [`SourcePriority`](crate::model::SourcePriority)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) primary_source: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the source you choose as the primary source for this flow.
        pub fn primary_source(mut self, input: impl Into<std::string::String>) -> Self {
            self.primary_source = Some(input.into());
            self
        }
        /// The name of the source you choose as the primary source for this flow.
        pub fn set_primary_source(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.primary_source = input;
            self
        }
        /// Consumes the builder and constructs a [`SourcePriority`](crate::model::SourcePriority)
        pub fn build(self) -> crate::model::SourcePriority {
            crate::model::SourcePriority {
                primary_source: self.primary_source,
            }
        }
    }
}
impl SourcePriority {
    /// Creates a new builder-style object to manufacture [`SourcePriority`](crate::model::SourcePriority)
    pub fn builder() -> crate::model::source_priority::Builder {
        crate::model::source_priority::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailoverMode {
    #[allow(missing_docs)] // documentation missing in model
    Failover,
    #[allow(missing_docs)] // documentation missing in model
    Merge,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailoverMode {
    fn from(s: &str) -> Self {
        match s {
            "FAILOVER" => FailoverMode::Failover,
            "MERGE" => FailoverMode::Merge,
            other => FailoverMode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailoverMode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailoverMode::from(s))
    }
}
impl FailoverMode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailoverMode::Failover => "FAILOVER",
            FailoverMode::Merge => "MERGE",
            FailoverMode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FAILOVER", "MERGE"]
    }
}
impl AsRef<str> for FailoverMode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// The settings for source failover
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFailoverConfig {
    /// The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
    pub failover_mode: std::option::Option<crate::model::FailoverMode>,
    /// Recovery window time to look for dash-7 packets
    pub recovery_window: i32,
    /// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
    pub source_priority: std::option::Option<crate::model::SourcePriority>,
    #[allow(missing_docs)] // documentation missing in model
    pub state: std::option::Option<crate::model::State>,
}
impl std::fmt::Debug for UpdateFailoverConfig {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFailoverConfig");
        formatter.field("failover_mode", &self.failover_mode);
        formatter.field("recovery_window", &self.recovery_window);
        formatter.field("source_priority", &self.source_priority);
        formatter.field("state", &self.state);
        formatter.finish()
    }
}
/// See [`UpdateFailoverConfig`](crate::model::UpdateFailoverConfig)
pub mod update_failover_config {
    /// A builder for [`UpdateFailoverConfig`](crate::model::UpdateFailoverConfig)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failover_mode: std::option::Option<crate::model::FailoverMode>,
        pub(crate) recovery_window: std::option::Option<i32>,
        pub(crate) source_priority: std::option::Option<crate::model::SourcePriority>,
        pub(crate) state: std::option::Option<crate::model::State>,
    }
    impl Builder {
        /// The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        pub fn failover_mode(mut self, input: crate::model::FailoverMode) -> Self {
            self.failover_mode = Some(input);
            self
        }
        /// The type of failover you choose for this flow. MERGE combines the source streams into a single stream, allowing graceful recovery from any single-source loss. FAILOVER allows switching between different streams.
        pub fn set_failover_mode(
            mut self,
            input: std::option::Option<crate::model::FailoverMode>,
        ) -> Self {
            self.failover_mode = input;
            self
        }
        /// Recovery window time to look for dash-7 packets
        pub fn recovery_window(mut self, input: i32) -> Self {
            self.recovery_window = Some(input);
            self
        }
        /// Recovery window time to look for dash-7 packets
        pub fn set_recovery_window(mut self, input: std::option::Option<i32>) -> Self {
            self.recovery_window = input;
            self
        }
        /// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        pub fn source_priority(mut self, input: crate::model::SourcePriority) -> Self {
            self.source_priority = Some(input);
            self
        }
        /// The priority you want to assign to a source. You can have a primary stream and a backup stream or two equally prioritized streams.
        pub fn set_source_priority(
            mut self,
            input: std::option::Option<crate::model::SourcePriority>,
        ) -> Self {
            self.source_priority = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn state(mut self, input: crate::model::State) -> Self {
            self.state = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_state(mut self, input: std::option::Option<crate::model::State>) -> Self {
            self.state = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFailoverConfig`](crate::model::UpdateFailoverConfig)
        pub fn build(self) -> crate::model::UpdateFailoverConfig {
            crate::model::UpdateFailoverConfig {
                failover_mode: self.failover_mode,
                recovery_window: self.recovery_window.unwrap_or_default(),
                source_priority: self.source_priority,
                state: self.state,
            }
        }
    }
}
impl UpdateFailoverConfig {
    /// Creates a new builder-style object to manufacture [`UpdateFailoverConfig`](crate::model::UpdateFailoverConfig)
    pub fn builder() -> crate::model::update_failover_config::Builder {
        crate::model::update_failover_config::Builder::default()
    }
}

/// A pricing agreement for a discounted rate for a specific outbound bandwidth that your MediaConnect account will use each month over a specific time period. The discounted rate in the reservation applies to outbound bandwidth for all flows from your account until your account reaches the amount of bandwidth in your reservation. If you use more outbound bandwidth than the agreed upon amount in a single month, the overage is charged at the on-demand rate.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Reservation {
    /// The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
    pub currency_code: std::option::Option<std::string::String>,
    /// The length of time that this reservation is active. MediaConnect defines this value in the offering.
    pub duration: i32,
    /// The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
    pub duration_units: std::option::Option<crate::model::DurationUnits>,
    /// The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
    pub end: std::option::Option<std::string::String>,
    /// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
    pub offering_arn: std::option::Option<std::string::String>,
    /// A description of the offering. MediaConnect defines this value in the offering.
    pub offering_description: std::option::Option<std::string::String>,
    /// The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
    pub price_per_unit: std::option::Option<std::string::String>,
    /// The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
    pub price_units: std::option::Option<crate::model::PriceUnits>,
    /// The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
    pub reservation_arn: std::option::Option<std::string::String>,
    /// The name that you assigned to the reservation when you purchased the offering.
    pub reservation_name: std::option::Option<std::string::String>,
    /// The status of your reservation.
    pub reservation_state: std::option::Option<crate::model::ReservationState>,
    /// A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
    pub resource_specification: std::option::Option<crate::model::ResourceSpecification>,
    /// The day and time that the reservation becomes active. You set this value when you purchase the offering.
    pub start: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Reservation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Reservation");
        formatter.field("currency_code", &self.currency_code);
        formatter.field("duration", &self.duration);
        formatter.field("duration_units", &self.duration_units);
        formatter.field("end", &self.end);
        formatter.field("offering_arn", &self.offering_arn);
        formatter.field("offering_description", &self.offering_description);
        formatter.field("price_per_unit", &self.price_per_unit);
        formatter.field("price_units", &self.price_units);
        formatter.field("reservation_arn", &self.reservation_arn);
        formatter.field("reservation_name", &self.reservation_name);
        formatter.field("reservation_state", &self.reservation_state);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.field("start", &self.start);
        formatter.finish()
    }
}
/// See [`Reservation`](crate::model::Reservation)
pub mod reservation {
    /// A builder for [`Reservation`](crate::model::Reservation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) duration_units: std::option::Option<crate::model::DurationUnits>,
        pub(crate) end: std::option::Option<std::string::String>,
        pub(crate) offering_arn: std::option::Option<std::string::String>,
        pub(crate) offering_description: std::option::Option<std::string::String>,
        pub(crate) price_per_unit: std::option::Option<std::string::String>,
        pub(crate) price_units: std::option::Option<crate::model::PriceUnits>,
        pub(crate) reservation_arn: std::option::Option<std::string::String>,
        pub(crate) reservation_name: std::option::Option<std::string::String>,
        pub(crate) reservation_state: std::option::Option<crate::model::ReservationState>,
        pub(crate) resource_specification: std::option::Option<crate::model::ResourceSpecification>,
        pub(crate) start: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// The type of currency that is used for billing. The currencyCode used for your reservation is US dollars.
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// The length of time that this reservation is active. MediaConnect defines this value in the offering.
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// The length of time that this reservation is active. MediaConnect defines this value in the offering.
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
        pub fn duration_units(mut self, input: crate::model::DurationUnits) -> Self {
            self.duration_units = Some(input);
            self
        }
        /// The unit of measurement for the duration of the reservation. MediaConnect defines this value in the offering.
        pub fn set_duration_units(
            mut self,
            input: std::option::Option<crate::model::DurationUnits>,
        ) -> Self {
            self.duration_units = input;
            self
        }
        /// The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
        pub fn end(mut self, input: impl Into<std::string::String>) -> Self {
            self.end = Some(input.into());
            self
        }
        /// The day and time that this reservation expires. This value is calculated based on the start date and time that you set and the offering's duration.
        pub fn set_end(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end = input;
            self
        }
        /// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
        pub fn offering_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_arn = input;
            self
        }
        /// A description of the offering. MediaConnect defines this value in the offering.
        pub fn offering_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_description = Some(input.into());
            self
        }
        /// A description of the offering. MediaConnect defines this value in the offering.
        pub fn set_offering_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_description = input;
            self
        }
        /// The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
        pub fn price_per_unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.price_per_unit = Some(input.into());
            self
        }
        /// The cost of a single unit. This value, in combination with priceUnits, makes up the rate. MediaConnect defines this value in the offering.
        pub fn set_price_per_unit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.price_per_unit = input;
            self
        }
        /// The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
        pub fn price_units(mut self, input: crate::model::PriceUnits) -> Self {
            self.price_units = Some(input);
            self
        }
        /// The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate. MediaConnect defines this value in the offering.
        pub fn set_price_units(
            mut self,
            input: std::option::Option<crate::model::PriceUnits>,
        ) -> Self {
            self.price_units = input;
            self
        }
        /// The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
        pub fn reservation_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that MediaConnect assigns to the reservation when you purchase an offering.
        pub fn set_reservation_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_arn = input;
            self
        }
        /// The name that you assigned to the reservation when you purchased the offering.
        pub fn reservation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.reservation_name = Some(input.into());
            self
        }
        /// The name that you assigned to the reservation when you purchased the offering.
        pub fn set_reservation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.reservation_name = input;
            self
        }
        /// The status of your reservation.
        pub fn reservation_state(mut self, input: crate::model::ReservationState) -> Self {
            self.reservation_state = Some(input);
            self
        }
        /// The status of your reservation.
        pub fn set_reservation_state(
            mut self,
            input: std::option::Option<crate::model::ReservationState>,
        ) -> Self {
            self.reservation_state = input;
            self
        }
        /// A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
        pub fn resource_specification(
            mut self,
            input: crate::model::ResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering. MediaConnect defines the values that make up the resourceSpecification in the offering.
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// The day and time that the reservation becomes active. You set this value when you purchase the offering.
        pub fn start(mut self, input: impl Into<std::string::String>) -> Self {
            self.start = Some(input.into());
            self
        }
        /// The day and time that the reservation becomes active. You set this value when you purchase the offering.
        pub fn set_start(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start = input;
            self
        }
        /// Consumes the builder and constructs a [`Reservation`](crate::model::Reservation)
        pub fn build(self) -> crate::model::Reservation {
            crate::model::Reservation {
                currency_code: self.currency_code,
                duration: self.duration.unwrap_or_default(),
                duration_units: self.duration_units,
                end: self.end,
                offering_arn: self.offering_arn,
                offering_description: self.offering_description,
                price_per_unit: self.price_per_unit,
                price_units: self.price_units,
                reservation_arn: self.reservation_arn,
                reservation_name: self.reservation_name,
                reservation_state: self.reservation_state,
                resource_specification: self.resource_specification,
                start: self.start,
            }
        }
    }
}
impl Reservation {
    /// Creates a new builder-style object to manufacture [`Reservation`](crate::model::Reservation)
    pub fn builder() -> crate::model::reservation::Builder {
        crate::model::reservation::Builder::default()
    }
}

/// A definition of what is being billed for, including the type and amount.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceSpecification {
    /// The amount of outbound bandwidth that is discounted in the offering.
    pub reserved_bitrate: i32,
    /// The type of resource and the unit that is being billed for.
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl std::fmt::Debug for ResourceSpecification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceSpecification");
        formatter.field("reserved_bitrate", &self.reserved_bitrate);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`ResourceSpecification`](crate::model::ResourceSpecification)
pub mod resource_specification {
    /// A builder for [`ResourceSpecification`](crate::model::ResourceSpecification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) reserved_bitrate: std::option::Option<i32>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        /// The amount of outbound bandwidth that is discounted in the offering.
        pub fn reserved_bitrate(mut self, input: i32) -> Self {
            self.reserved_bitrate = Some(input);
            self
        }
        /// The amount of outbound bandwidth that is discounted in the offering.
        pub fn set_reserved_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.reserved_bitrate = input;
            self
        }
        /// The type of resource and the unit that is being billed for.
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// The type of resource and the unit that is being billed for.
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceSpecification`](crate::model::ResourceSpecification)
        pub fn build(self) -> crate::model::ResourceSpecification {
            crate::model::ResourceSpecification {
                reserved_bitrate: self.reserved_bitrate.unwrap_or_default(),
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceSpecification {
    /// Creates a new builder-style object to manufacture [`ResourceSpecification`](crate::model::ResourceSpecification)
    pub fn builder() -> crate::model::resource_specification::Builder {
        crate::model::resource_specification::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ResourceType {
    #[allow(missing_docs)] // documentation missing in model
    MbpsOutboundBandwidth,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ResourceType {
    fn from(s: &str) -> Self {
        match s {
            "Mbps_Outbound_Bandwidth" => ResourceType::MbpsOutboundBandwidth,
            other => ResourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ResourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ResourceType::from(s))
    }
}
impl ResourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ResourceType::MbpsOutboundBandwidth => "Mbps_Outbound_Bandwidth",
            ResourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["Mbps_Outbound_Bandwidth"]
    }
}
impl AsRef<str> for ResourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ReservationState {
    #[allow(missing_docs)] // documentation missing in model
    Active,
    #[allow(missing_docs)] // documentation missing in model
    Canceled,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Processing,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ReservationState {
    fn from(s: &str) -> Self {
        match s {
            "ACTIVE" => ReservationState::Active,
            "CANCELED" => ReservationState::Canceled,
            "EXPIRED" => ReservationState::Expired,
            "PROCESSING" => ReservationState::Processing,
            other => ReservationState::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ReservationState {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ReservationState::from(s))
    }
}
impl ReservationState {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ReservationState::Active => "ACTIVE",
            ReservationState::Canceled => "CANCELED",
            ReservationState::Expired => "EXPIRED",
            ReservationState::Processing => "PROCESSING",
            ReservationState::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACTIVE", "CANCELED", "EXPIRED", "PROCESSING"]
    }
}
impl AsRef<str> for ReservationState {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum PriceUnits {
    #[allow(missing_docs)] // documentation missing in model
    Hourly,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for PriceUnits {
    fn from(s: &str) -> Self {
        match s {
            "HOURLY" => PriceUnits::Hourly,
            other => PriceUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for PriceUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(PriceUnits::from(s))
    }
}
impl PriceUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            PriceUnits::Hourly => "HOURLY",
            PriceUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HOURLY"]
    }
}
impl AsRef<str> for PriceUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DurationUnits {
    #[allow(missing_docs)] // documentation missing in model
    Months,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DurationUnits {
    fn from(s: &str) -> Self {
        match s {
            "MONTHS" => DurationUnits::Months,
            other => DurationUnits::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DurationUnits {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DurationUnits::from(s))
    }
}
impl DurationUnits {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DurationUnits::Months => "MONTHS",
            DurationUnits::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MONTHS"]
    }
}
impl AsRef<str> for DurationUnits {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// A savings plan that reserves a certain amount of outbound bandwidth usage at a discounted rate each month over a period of time.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Offering {
    /// The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
    pub currency_code: std::option::Option<std::string::String>,
    /// The length of time that your reservation would be active.
    pub duration: i32,
    /// The unit of measurement for the duration of the offering.
    pub duration_units: std::option::Option<crate::model::DurationUnits>,
    /// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
    pub offering_arn: std::option::Option<std::string::String>,
    /// A description of the offering.
    pub offering_description: std::option::Option<std::string::String>,
    /// The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
    pub price_per_unit: std::option::Option<std::string::String>,
    /// The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
    pub price_units: std::option::Option<crate::model::PriceUnits>,
    /// A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
    pub resource_specification: std::option::Option<crate::model::ResourceSpecification>,
}
impl std::fmt::Debug for Offering {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Offering");
        formatter.field("currency_code", &self.currency_code);
        formatter.field("duration", &self.duration);
        formatter.field("duration_units", &self.duration_units);
        formatter.field("offering_arn", &self.offering_arn);
        formatter.field("offering_description", &self.offering_description);
        formatter.field("price_per_unit", &self.price_per_unit);
        formatter.field("price_units", &self.price_units);
        formatter.field("resource_specification", &self.resource_specification);
        formatter.finish()
    }
}
/// See [`Offering`](crate::model::Offering)
pub mod offering {
    /// A builder for [`Offering`](crate::model::Offering)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) currency_code: std::option::Option<std::string::String>,
        pub(crate) duration: std::option::Option<i32>,
        pub(crate) duration_units: std::option::Option<crate::model::DurationUnits>,
        pub(crate) offering_arn: std::option::Option<std::string::String>,
        pub(crate) offering_description: std::option::Option<std::string::String>,
        pub(crate) price_per_unit: std::option::Option<std::string::String>,
        pub(crate) price_units: std::option::Option<crate::model::PriceUnits>,
        pub(crate) resource_specification: std::option::Option<crate::model::ResourceSpecification>,
    }
    impl Builder {
        /// The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
        pub fn currency_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.currency_code = Some(input.into());
            self
        }
        /// The type of currency that is used for billing. The currencyCode used for all reservations is US dollars.
        pub fn set_currency_code(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.currency_code = input;
            self
        }
        /// The length of time that your reservation would be active.
        pub fn duration(mut self, input: i32) -> Self {
            self.duration = Some(input);
            self
        }
        /// The length of time that your reservation would be active.
        pub fn set_duration(mut self, input: std::option::Option<i32>) -> Self {
            self.duration = input;
            self
        }
        /// The unit of measurement for the duration of the offering.
        pub fn duration_units(mut self, input: crate::model::DurationUnits) -> Self {
            self.duration_units = Some(input);
            self
        }
        /// The unit of measurement for the duration of the offering.
        pub fn set_duration_units(
            mut self,
            input: std::option::Option<crate::model::DurationUnits>,
        ) -> Self {
            self.duration_units = input;
            self
        }
        /// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
        pub fn offering_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_arn = Some(input.into());
            self
        }
        /// The Amazon Resource Name (ARN) that MediaConnect assigns to the offering.
        pub fn set_offering_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.offering_arn = input;
            self
        }
        /// A description of the offering.
        pub fn offering_description(mut self, input: impl Into<std::string::String>) -> Self {
            self.offering_description = Some(input.into());
            self
        }
        /// A description of the offering.
        pub fn set_offering_description(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.offering_description = input;
            self
        }
        /// The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
        pub fn price_per_unit(mut self, input: impl Into<std::string::String>) -> Self {
            self.price_per_unit = Some(input.into());
            self
        }
        /// The cost of a single unit. This value, in combination with priceUnits, makes up the rate.
        pub fn set_price_per_unit(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.price_per_unit = input;
            self
        }
        /// The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
        pub fn price_units(mut self, input: crate::model::PriceUnits) -> Self {
            self.price_units = Some(input);
            self
        }
        /// The unit of measurement that is used for billing. This value, in combination with pricePerUnit, makes up the rate.
        pub fn set_price_units(
            mut self,
            input: std::option::Option<crate::model::PriceUnits>,
        ) -> Self {
            self.price_units = input;
            self
        }
        /// A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
        pub fn resource_specification(
            mut self,
            input: crate::model::ResourceSpecification,
        ) -> Self {
            self.resource_specification = Some(input);
            self
        }
        /// A definition of the amount of outbound bandwidth that you would be reserving if you purchase the offering.
        pub fn set_resource_specification(
            mut self,
            input: std::option::Option<crate::model::ResourceSpecification>,
        ) -> Self {
            self.resource_specification = input;
            self
        }
        /// Consumes the builder and constructs a [`Offering`](crate::model::Offering)
        pub fn build(self) -> crate::model::Offering {
            crate::model::Offering {
                currency_code: self.currency_code,
                duration: self.duration.unwrap_or_default(),
                duration_units: self.duration_units,
                offering_arn: self.offering_arn,
                offering_description: self.offering_description,
                price_per_unit: self.price_per_unit,
                price_units: self.price_units,
                resource_specification: self.resource_specification,
            }
        }
    }
}
impl Offering {
    /// Creates a new builder-style object to manufacture [`Offering`](crate::model::Offering)
    pub fn builder() -> crate::model::offering::Builder {
        crate::model::offering::Builder::default()
    }
}

/// Provides a summary of a flow, including its ARN, Availability Zone, and source type.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedFlow {
    /// The Availability Zone that the flow was created in.
    pub availability_zone: std::option::Option<std::string::String>,
    /// A description of the flow.
    pub description: std::option::Option<std::string::String>,
    /// The ARN of the flow.
    pub flow_arn: std::option::Option<std::string::String>,
    /// The name of the flow.
    pub name: std::option::Option<std::string::String>,
    /// The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).
    pub source_type: std::option::Option<crate::model::SourceType>,
    /// The current status of the flow.
    pub status: std::option::Option<crate::model::Status>,
}
impl std::fmt::Debug for ListedFlow {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedFlow");
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("description", &self.description);
        formatter.field("flow_arn", &self.flow_arn);
        formatter.field("name", &self.name);
        formatter.field("source_type", &self.source_type);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ListedFlow`](crate::model::ListedFlow)
pub mod listed_flow {
    /// A builder for [`ListedFlow`](crate::model::ListedFlow)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) flow_arn: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) source_type: std::option::Option<crate::model::SourceType>,
        pub(crate) status: std::option::Option<crate::model::Status>,
    }
    impl Builder {
        /// The Availability Zone that the flow was created in.
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// The Availability Zone that the flow was created in.
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// A description of the flow.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the flow.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The ARN of the flow.
        pub fn flow_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.flow_arn = Some(input.into());
            self
        }
        /// The ARN of the flow.
        pub fn set_flow_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.flow_arn = input;
            self
        }
        /// The name of the flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).
        pub fn source_type(mut self, input: crate::model::SourceType) -> Self {
            self.source_type = Some(input);
            self
        }
        /// The type of source. This value is either owned (originated somewhere other than an AWS Elemental MediaConnect flow owned by another AWS account) or entitled (originated at an AWS Elemental MediaConnect flow owned by another AWS account).
        pub fn set_source_type(
            mut self,
            input: std::option::Option<crate::model::SourceType>,
        ) -> Self {
            self.source_type = input;
            self
        }
        /// The current status of the flow.
        pub fn status(mut self, input: crate::model::Status) -> Self {
            self.status = Some(input);
            self
        }
        /// The current status of the flow.
        pub fn set_status(mut self, input: std::option::Option<crate::model::Status>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedFlow`](crate::model::ListedFlow)
        pub fn build(self) -> crate::model::ListedFlow {
            crate::model::ListedFlow {
                availability_zone: self.availability_zone,
                description: self.description,
                flow_arn: self.flow_arn,
                name: self.name,
                source_type: self.source_type,
                status: self.status,
            }
        }
    }
}
impl ListedFlow {
    /// Creates a new builder-style object to manufacture [`ListedFlow`](crate::model::ListedFlow)
    pub fn builder() -> crate::model::listed_flow::Builder {
        crate::model::listed_flow::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SourceType {
    #[allow(missing_docs)] // documentation missing in model
    Entitled,
    #[allow(missing_docs)] // documentation missing in model
    Owned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SourceType {
    fn from(s: &str) -> Self {
        match s {
            "ENTITLED" => SourceType::Entitled,
            "OWNED" => SourceType::Owned,
            other => SourceType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SourceType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SourceType::from(s))
    }
}
impl SourceType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SourceType::Entitled => "ENTITLED",
            SourceType::Owned => "OWNED",
            SourceType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENTITLED", "OWNED"]
    }
}
impl AsRef<str> for SourceType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// An entitlement that has been granted to you from other AWS accounts.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListedEntitlement {
    /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
    pub data_transfer_subscriber_fee_percent: i32,
    /// The ARN of the entitlement.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The name of the entitlement.
    pub entitlement_name: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ListedEntitlement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListedEntitlement");
        formatter.field(
            "data_transfer_subscriber_fee_percent",
            &self.data_transfer_subscriber_fee_percent,
        );
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("entitlement_name", &self.entitlement_name);
        formatter.finish()
    }
}
/// See [`ListedEntitlement`](crate::model::ListedEntitlement)
pub mod listed_entitlement {
    /// A builder for [`ListedEntitlement`](crate::model::ListedEntitlement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_transfer_subscriber_fee_percent: std::option::Option<i32>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) entitlement_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn data_transfer_subscriber_fee_percent(mut self, input: i32) -> Self {
            self.data_transfer_subscriber_fee_percent = Some(input);
            self
        }
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn set_data_transfer_subscriber_fee_percent(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.data_transfer_subscriber_fee_percent = input;
            self
        }
        /// The ARN of the entitlement.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The name of the entitlement.
        pub fn entitlement_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_name = Some(input.into());
            self
        }
        /// The name of the entitlement.
        pub fn set_entitlement_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ListedEntitlement`](crate::model::ListedEntitlement)
        pub fn build(self) -> crate::model::ListedEntitlement {
            crate::model::ListedEntitlement {
                data_transfer_subscriber_fee_percent: self
                    .data_transfer_subscriber_fee_percent
                    .unwrap_or_default(),
                entitlement_arn: self.entitlement_arn,
                entitlement_name: self.entitlement_name,
            }
        }
    }
}
impl ListedEntitlement {
    /// Creates a new builder-style object to manufacture [`ListedEntitlement`](crate::model::ListedEntitlement)
    pub fn builder() -> crate::model::listed_entitlement::Builder {
        crate::model::listed_entitlement::Builder::default()
    }
}

/// The entitlements that you want to grant on a flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GrantEntitlementRequest {
    /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
    pub data_transfer_subscriber_fee_percent: i32,
    /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
    pub description: std::option::Option<std::string::String>,
    /// The type of encryption that will be used on the output that is associated with this entitlement.
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
    pub entitlement_status: std::option::Option<crate::model::EntitlementStatus>,
    /// The name of the entitlement. This value must be unique within the current flow.
    pub name: std::option::Option<std::string::String>,
    /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.
    pub subscribers: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for GrantEntitlementRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GrantEntitlementRequest");
        formatter.field(
            "data_transfer_subscriber_fee_percent",
            &self.data_transfer_subscriber_fee_percent,
        );
        formatter.field("description", &self.description);
        formatter.field("encryption", &self.encryption);
        formatter.field("entitlement_status", &self.entitlement_status);
        formatter.field("name", &self.name);
        formatter.field("subscribers", &self.subscribers);
        formatter.finish()
    }
}
/// See [`GrantEntitlementRequest`](crate::model::GrantEntitlementRequest)
pub mod grant_entitlement_request {
    /// A builder for [`GrantEntitlementRequest`](crate::model::GrantEntitlementRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_transfer_subscriber_fee_percent: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) entitlement_status: std::option::Option<crate::model::EntitlementStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) subscribers: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn data_transfer_subscriber_fee_percent(mut self, input: i32) -> Self {
            self.data_transfer_subscriber_fee_percent = Some(input);
            self
        }
        /// Percentage from 0-100 of the data transfer cost to be billed to the subscriber.
        pub fn set_data_transfer_subscriber_fee_percent(
            mut self,
            input: std::option::Option<i32>,
        ) -> Self {
            self.data_transfer_subscriber_fee_percent = input;
            self
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the entitlement. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the subscriber or end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The type of encryption that will be used on the output that is associated with this entitlement.
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// The type of encryption that will be used on the output that is associated with this entitlement.
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
        pub fn entitlement_status(mut self, input: crate::model::EntitlementStatus) -> Self {
            self.entitlement_status = Some(input);
            self
        }
        /// An indication of whether the new entitlement should be enabled or disabled as soon as it is created. If you don’t specify the entitlementStatus field in your request, MediaConnect sets it to ENABLED.
        pub fn set_entitlement_status(
            mut self,
            input: std::option::Option<crate::model::EntitlementStatus>,
        ) -> Self {
            self.entitlement_status = input;
            self
        }
        /// The name of the entitlement. This value must be unique within the current flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the entitlement. This value must be unique within the current flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `subscribers`.
        ///
        /// To override the contents of this collection use [`set_subscribers`](Self::set_subscribers).
        ///
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.
        pub fn subscribers(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.subscribers.unwrap_or_default();
            v.push(input.into());
            self.subscribers = Some(v);
            self
        }
        /// The AWS account IDs that you want to share your content with. The receiving accounts (subscribers) will be allowed to create their own flows using your content as the source.
        pub fn set_subscribers(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.subscribers = input;
            self
        }
        /// Consumes the builder and constructs a [`GrantEntitlementRequest`](crate::model::GrantEntitlementRequest)
        pub fn build(self) -> crate::model::GrantEntitlementRequest {
            crate::model::GrantEntitlementRequest {
                data_transfer_subscriber_fee_percent: self
                    .data_transfer_subscriber_fee_percent
                    .unwrap_or_default(),
                description: self.description,
                encryption: self.encryption,
                entitlement_status: self.entitlement_status,
                name: self.name,
                subscribers: self.subscribers,
            }
        }
    }
}
impl GrantEntitlementRequest {
    /// Creates a new builder-style object to manufacture [`GrantEntitlementRequest`](crate::model::GrantEntitlementRequest)
    pub fn builder() -> crate::model::grant_entitlement_request::Builder {
        crate::model::grant_entitlement_request::Builder::default()
    }
}

/// Messages that provide the state of the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Messages {
    /// A list of errors that might have been generated from processes on this flow.
    pub errors: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl std::fmt::Debug for Messages {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Messages");
        formatter.field("errors", &self.errors);
        formatter.finish()
    }
}
/// See [`Messages`](crate::model::Messages)
pub mod messages {
    /// A builder for [`Messages`](crate::model::Messages)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) errors: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `errors`.
        ///
        /// To override the contents of this collection use [`set_errors`](Self::set_errors).
        ///
        /// A list of errors that might have been generated from processes on this flow.
        pub fn errors(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.errors.unwrap_or_default();
            v.push(input.into());
            self.errors = Some(v);
            self
        }
        /// A list of errors that might have been generated from processes on this flow.
        pub fn set_errors(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.errors = input;
            self
        }
        /// Consumes the builder and constructs a [`Messages`](crate::model::Messages)
        pub fn build(self) -> crate::model::Messages {
            crate::model::Messages {
                errors: self.errors,
            }
        }
    }
}
impl Messages {
    /// Creates a new builder-style object to manufacture [`Messages`](crate::model::Messages)
    pub fn builder() -> crate::model::messages::Builder {
        crate::model::messages::Builder::default()
    }
}

/// Desired VPC Interface for a Flow
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VpcInterfaceRequest {
    /// The name of the VPC Interface. This value must be unique within the current flow.
    pub name: std::option::Option<std::string::String>,
    /// The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
    pub network_interface_type: std::option::Option<crate::model::NetworkInterfaceType>,
    /// Role Arn MediaConnect can assumes to create ENIs in customer's account
    pub role_arn: std::option::Option<std::string::String>,
    /// Security Group IDs to be used on ENI.
    pub security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// Subnet must be in the AZ of the Flow
    pub subnet_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VpcInterfaceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VpcInterfaceRequest");
        formatter.field("name", &self.name);
        formatter.field("network_interface_type", &self.network_interface_type);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("security_group_ids", &self.security_group_ids);
        formatter.field("subnet_id", &self.subnet_id);
        formatter.finish()
    }
}
/// See [`VpcInterfaceRequest`](crate::model::VpcInterfaceRequest)
pub mod vpc_interface_request {
    /// A builder for [`VpcInterfaceRequest`](crate::model::VpcInterfaceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) network_interface_type: std::option::Option<crate::model::NetworkInterfaceType>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) security_group_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) subnet_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The name of the VPC Interface. This value must be unique within the current flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the VPC Interface. This value must be unique within the current flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
        pub fn network_interface_type(mut self, input: crate::model::NetworkInterfaceType) -> Self {
            self.network_interface_type = Some(input);
            self
        }
        /// The type of network interface. If this value is not included in the request, MediaConnect uses ENA as the networkInterfaceType.
        pub fn set_network_interface_type(
            mut self,
            input: std::option::Option<crate::model::NetworkInterfaceType>,
        ) -> Self {
            self.network_interface_type = input;
            self
        }
        /// Role Arn MediaConnect can assumes to create ENIs in customer's account
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// Role Arn MediaConnect can assumes to create ENIs in customer's account
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// Appends an item to `security_group_ids`.
        ///
        /// To override the contents of this collection use [`set_security_group_ids`](Self::set_security_group_ids).
        ///
        /// Security Group IDs to be used on ENI.
        pub fn security_group_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.security_group_ids.unwrap_or_default();
            v.push(input.into());
            self.security_group_ids = Some(v);
            self
        }
        /// Security Group IDs to be used on ENI.
        pub fn set_security_group_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.security_group_ids = input;
            self
        }
        /// Subnet must be in the AZ of the Flow
        pub fn subnet_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.subnet_id = Some(input.into());
            self
        }
        /// Subnet must be in the AZ of the Flow
        pub fn set_subnet_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.subnet_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VpcInterfaceRequest`](crate::model::VpcInterfaceRequest)
        pub fn build(self) -> crate::model::VpcInterfaceRequest {
            crate::model::VpcInterfaceRequest {
                name: self.name,
                network_interface_type: self.network_interface_type,
                role_arn: self.role_arn,
                security_group_ids: self.security_group_ids,
                subnet_id: self.subnet_id,
            }
        }
    }
}
impl VpcInterfaceRequest {
    /// Creates a new builder-style object to manufacture [`VpcInterfaceRequest`](crate::model::VpcInterfaceRequest)
    pub fn builder() -> crate::model::vpc_interface_request::Builder {
        crate::model::vpc_interface_request::Builder::default()
    }
}

/// The settings for the source of the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SetSourceRequest {
    /// The type of encryption that is used on the content ingested from this source.
    pub decryption: std::option::Option<crate::model::Encryption>,
    /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
    pub description: std::option::Option<std::string::String>,
    /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
    pub entitlement_arn: std::option::Option<std::string::String>,
    /// The port that the flow will be listening on for incoming content.
    pub ingest_port: i32,
    /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
    pub max_bitrate: i32,
    /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
    pub max_latency: i32,
    /// The size of the buffer (in milliseconds) to use to sync incoming source data.
    pub max_sync_buffer: i32,
    /// The media streams that are associated with the source, and the parameters for those associations.
    pub media_stream_source_configurations:
        std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>>,
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub min_latency: i32,
    /// The name of the source.
    pub name: std::option::Option<std::string::String>,
    /// The protocol that is used by the source.
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub stream_id: std::option::Option<std::string::String>,
    /// The name of the VPC interface to use for this source.
    pub vpc_interface_name: std::option::Option<std::string::String>,
    /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub whitelist_cidr: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for SetSourceRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SetSourceRequest");
        formatter.field("decryption", &self.decryption);
        formatter.field("description", &self.description);
        formatter.field("entitlement_arn", &self.entitlement_arn);
        formatter.field("ingest_port", &self.ingest_port);
        formatter.field("max_bitrate", &self.max_bitrate);
        formatter.field("max_latency", &self.max_latency);
        formatter.field("max_sync_buffer", &self.max_sync_buffer);
        formatter.field(
            "media_stream_source_configurations",
            &self.media_stream_source_configurations,
        );
        formatter.field("min_latency", &self.min_latency);
        formatter.field("name", &self.name);
        formatter.field("protocol", &self.protocol);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("vpc_interface_name", &self.vpc_interface_name);
        formatter.field("whitelist_cidr", &self.whitelist_cidr);
        formatter.finish()
    }
}
/// See [`SetSourceRequest`](crate::model::SetSourceRequest)
pub mod set_source_request {
    /// A builder for [`SetSourceRequest`](crate::model::SetSourceRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) decryption: std::option::Option<crate::model::Encryption>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) entitlement_arn: std::option::Option<std::string::String>,
        pub(crate) ingest_port: std::option::Option<i32>,
        pub(crate) max_bitrate: std::option::Option<i32>,
        pub(crate) max_latency: std::option::Option<i32>,
        pub(crate) max_sync_buffer: std::option::Option<i32>,
        pub(crate) media_stream_source_configurations:
            std::option::Option<std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>>,
        pub(crate) min_latency: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) vpc_interface_name: std::option::Option<std::string::String>,
        pub(crate) whitelist_cidr: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The type of encryption that is used on the content ingested from this source.
        pub fn decryption(mut self, input: crate::model::Encryption) -> Self {
            self.decryption = Some(input);
            self
        }
        /// The type of encryption that is used on the content ingested from this source.
        pub fn set_decryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.decryption = input;
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description for the source. This value is not used or seen outside of the current AWS Elemental MediaConnect account.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn entitlement_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entitlement_arn = Some(input.into());
            self
        }
        /// The ARN of the entitlement that allows you to subscribe to this flow. The entitlement is set by the flow originator, and the ARN is generated as part of the originator's flow.
        pub fn set_entitlement_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.entitlement_arn = input;
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn ingest_port(mut self, input: i32) -> Self {
            self.ingest_port = Some(input);
            self
        }
        /// The port that the flow will be listening on for incoming content.
        pub fn set_ingest_port(mut self, input: std::option::Option<i32>) -> Self {
            self.ingest_port = input;
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn max_bitrate(mut self, input: i32) -> Self {
            self.max_bitrate = Some(input);
            self
        }
        /// The smoothing max bitrate for RIST, RTP, and RTP-FEC streams.
        pub fn set_max_bitrate(mut self, input: std::option::Option<i32>) -> Self {
            self.max_bitrate = input;
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.max_latency = Some(input);
            self
        }
        /// The maximum latency in milliseconds. This parameter applies only to RIST-based and Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_latency = input;
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn max_sync_buffer(mut self, input: i32) -> Self {
            self.max_sync_buffer = Some(input);
            self
        }
        /// The size of the buffer (in milliseconds) to use to sync incoming source data.
        pub fn set_max_sync_buffer(mut self, input: std::option::Option<i32>) -> Self {
            self.max_sync_buffer = input;
            self
        }
        /// Appends an item to `media_stream_source_configurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_source_configurations`](Self::set_media_stream_source_configurations).
        ///
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn media_stream_source_configurations(
            mut self,
            input: impl Into<crate::model::MediaStreamSourceConfigurationRequest>,
        ) -> Self {
            let mut v = self.media_stream_source_configurations.unwrap_or_default();
            v.push(input.into());
            self.media_stream_source_configurations = Some(v);
            self
        }
        /// The media streams that are associated with the source, and the parameters for those associations.
        pub fn set_media_stream_source_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamSourceConfigurationRequest>,
            >,
        ) -> Self {
            self.media_stream_source_configurations = input;
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.min_latency = Some(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.min_latency = input;
            self
        }
        /// The name of the source.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the source.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The protocol that is used by the source.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// The protocol that is used by the source.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn vpc_interface_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_interface_name = Some(input.into());
            self
        }
        /// The name of the VPC interface to use for this source.
        pub fn set_vpc_interface_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_interface_name = input;
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn whitelist_cidr(mut self, input: impl Into<std::string::String>) -> Self {
            self.whitelist_cidr = Some(input.into());
            self
        }
        /// The range of IP addresses that should be allowed to contribute content to your source. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_whitelist_cidr(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.whitelist_cidr = input;
            self
        }
        /// Consumes the builder and constructs a [`SetSourceRequest`](crate::model::SetSourceRequest)
        pub fn build(self) -> crate::model::SetSourceRequest {
            crate::model::SetSourceRequest {
                decryption: self.decryption,
                description: self.description,
                entitlement_arn: self.entitlement_arn,
                ingest_port: self.ingest_port.unwrap_or_default(),
                max_bitrate: self.max_bitrate.unwrap_or_default(),
                max_latency: self.max_latency.unwrap_or_default(),
                max_sync_buffer: self.max_sync_buffer.unwrap_or_default(),
                media_stream_source_configurations: self.media_stream_source_configurations,
                min_latency: self.min_latency.unwrap_or_default(),
                name: self.name,
                protocol: self.protocol,
                stream_id: self.stream_id,
                vpc_interface_name: self.vpc_interface_name,
                whitelist_cidr: self.whitelist_cidr,
            }
        }
    }
}
impl SetSourceRequest {
    /// Creates a new builder-style object to manufacture [`SetSourceRequest`](crate::model::SetSourceRequest)
    pub fn builder() -> crate::model::set_source_request::Builder {
        crate::model::set_source_request::Builder::default()
    }
}

/// The output that you want to add to this flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddOutputRequest {
    /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
    pub cidr_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
    pub description: std::option::Option<std::string::String>,
    /// The IP address from which video will be sent to output destinations.
    pub destination: std::option::Option<std::string::String>,
    /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
    pub encryption: std::option::Option<crate::model::Encryption>,
    /// The maximum latency in milliseconds for Zixi-based streams.
    pub max_latency: i32,
    /// The media streams that are associated with the output, and the parameters for those associations.
    pub media_stream_output_configurations:
        std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>>,
    /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
    pub min_latency: i32,
    /// The name of the output. This value must be unique within the current flow.
    pub name: std::option::Option<std::string::String>,
    /// The port to use when content is distributed to this output.
    pub port: i32,
    /// The protocol to use for the output.
    pub protocol: std::option::Option<crate::model::Protocol>,
    /// The remote ID for the Zixi-pull output stream.
    pub remote_id: std::option::Option<std::string::String>,
    /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
    pub smoothing_latency: i32,
    /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
    pub stream_id: std::option::Option<std::string::String>,
    /// The name of the VPC interface attachment to use for this output.
    pub vpc_interface_attachment: std::option::Option<crate::model::VpcInterfaceAttachment>,
}
impl std::fmt::Debug for AddOutputRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddOutputRequest");
        formatter.field("cidr_allow_list", &self.cidr_allow_list);
        formatter.field("description", &self.description);
        formatter.field("destination", &self.destination);
        formatter.field("encryption", &self.encryption);
        formatter.field("max_latency", &self.max_latency);
        formatter.field(
            "media_stream_output_configurations",
            &self.media_stream_output_configurations,
        );
        formatter.field("min_latency", &self.min_latency);
        formatter.field("name", &self.name);
        formatter.field("port", &self.port);
        formatter.field("protocol", &self.protocol);
        formatter.field("remote_id", &self.remote_id);
        formatter.field("smoothing_latency", &self.smoothing_latency);
        formatter.field("stream_id", &self.stream_id);
        formatter.field("vpc_interface_attachment", &self.vpc_interface_attachment);
        formatter.finish()
    }
}
/// See [`AddOutputRequest`](crate::model::AddOutputRequest)
pub mod add_output_request {
    /// A builder for [`AddOutputRequest`](crate::model::AddOutputRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cidr_allow_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) destination: std::option::Option<std::string::String>,
        pub(crate) encryption: std::option::Option<crate::model::Encryption>,
        pub(crate) max_latency: std::option::Option<i32>,
        pub(crate) media_stream_output_configurations:
            std::option::Option<std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>>,
        pub(crate) min_latency: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) port: std::option::Option<i32>,
        pub(crate) protocol: std::option::Option<crate::model::Protocol>,
        pub(crate) remote_id: std::option::Option<std::string::String>,
        pub(crate) smoothing_latency: std::option::Option<i32>,
        pub(crate) stream_id: std::option::Option<std::string::String>,
        pub(crate) vpc_interface_attachment:
            std::option::Option<crate::model::VpcInterfaceAttachment>,
    }
    impl Builder {
        /// Appends an item to `cidr_allow_list`.
        ///
        /// To override the contents of this collection use [`set_cidr_allow_list`](Self::set_cidr_allow_list).
        ///
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn cidr_allow_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.cidr_allow_list.unwrap_or_default();
            v.push(input.into());
            self.cidr_allow_list = Some(v);
            self
        }
        /// The range of IP addresses that should be allowed to initiate output requests to this flow. These IP addresses should be in the form of a Classless Inter-Domain Routing (CIDR) block; for example, 10.0.0.0/16.
        pub fn set_cidr_allow_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.cidr_allow_list = input;
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description of the output. This description appears only on the AWS Elemental MediaConnect console and will not be seen by the end user.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// The IP address from which video will be sent to output destinations.
        pub fn destination(mut self, input: impl Into<std::string::String>) -> Self {
            self.destination = Some(input.into());
            self
        }
        /// The IP address from which video will be sent to output destinations.
        pub fn set_destination(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.destination = input;
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn encryption(mut self, input: crate::model::Encryption) -> Self {
            self.encryption = Some(input);
            self
        }
        /// The type of key used for the encryption. If no keyType is provided, the service will use the default setting (static-key).
        pub fn set_encryption(
            mut self,
            input: std::option::Option<crate::model::Encryption>,
        ) -> Self {
            self.encryption = input;
            self
        }
        /// The maximum latency in milliseconds for Zixi-based streams.
        pub fn max_latency(mut self, input: i32) -> Self {
            self.max_latency = Some(input);
            self
        }
        /// The maximum latency in milliseconds for Zixi-based streams.
        pub fn set_max_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.max_latency = input;
            self
        }
        /// Appends an item to `media_stream_output_configurations`.
        ///
        /// To override the contents of this collection use [`set_media_stream_output_configurations`](Self::set_media_stream_output_configurations).
        ///
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn media_stream_output_configurations(
            mut self,
            input: impl Into<crate::model::MediaStreamOutputConfigurationRequest>,
        ) -> Self {
            let mut v = self.media_stream_output_configurations.unwrap_or_default();
            v.push(input.into());
            self.media_stream_output_configurations = Some(v);
            self
        }
        /// The media streams that are associated with the output, and the parameters for those associations.
        pub fn set_media_stream_output_configurations(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::MediaStreamOutputConfigurationRequest>,
            >,
        ) -> Self {
            self.media_stream_output_configurations = input;
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn min_latency(mut self, input: i32) -> Self {
            self.min_latency = Some(input);
            self
        }
        /// The minimum latency in milliseconds for SRT-based streams. In streams that use the SRT protocol, this value that you set on your MediaConnect source or output represents the minimal potential latency of that connection. The latency of the stream is set to the highest number between the sender’s minimum latency and the receiver’s minimum latency.
        pub fn set_min_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.min_latency = input;
            self
        }
        /// The name of the output. This value must be unique within the current flow.
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// The name of the output. This value must be unique within the current flow.
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn port(mut self, input: i32) -> Self {
            self.port = Some(input);
            self
        }
        /// The port to use when content is distributed to this output.
        pub fn set_port(mut self, input: std::option::Option<i32>) -> Self {
            self.port = input;
            self
        }
        /// The protocol to use for the output.
        pub fn protocol(mut self, input: crate::model::Protocol) -> Self {
            self.protocol = Some(input);
            self
        }
        /// The protocol to use for the output.
        pub fn set_protocol(mut self, input: std::option::Option<crate::model::Protocol>) -> Self {
            self.protocol = input;
            self
        }
        /// The remote ID for the Zixi-pull output stream.
        pub fn remote_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.remote_id = Some(input.into());
            self
        }
        /// The remote ID for the Zixi-pull output stream.
        pub fn set_remote_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.remote_id = input;
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn smoothing_latency(mut self, input: i32) -> Self {
            self.smoothing_latency = Some(input);
            self
        }
        /// The smoothing latency in milliseconds for RIST, RTP, and RTP-FEC streams.
        pub fn set_smoothing_latency(mut self, input: std::option::Option<i32>) -> Self {
            self.smoothing_latency = input;
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn stream_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.stream_id = Some(input.into());
            self
        }
        /// The stream ID that you want to use for this transport. This parameter applies only to Zixi-based streams.
        pub fn set_stream_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.stream_id = input;
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn vpc_interface_attachment(
            mut self,
            input: crate::model::VpcInterfaceAttachment,
        ) -> Self {
            self.vpc_interface_attachment = Some(input);
            self
        }
        /// The name of the VPC interface attachment to use for this output.
        pub fn set_vpc_interface_attachment(
            mut self,
            input: std::option::Option<crate::model::VpcInterfaceAttachment>,
        ) -> Self {
            self.vpc_interface_attachment = input;
            self
        }
        /// Consumes the builder and constructs a [`AddOutputRequest`](crate::model::AddOutputRequest)
        pub fn build(self) -> crate::model::AddOutputRequest {
            crate::model::AddOutputRequest {
                cidr_allow_list: self.cidr_allow_list,
                description: self.description,
                destination: self.destination,
                encryption: self.encryption,
                max_latency: self.max_latency.unwrap_or_default(),
                media_stream_output_configurations: self.media_stream_output_configurations,
                min_latency: self.min_latency.unwrap_or_default(),
                name: self.name,
                port: self.port.unwrap_or_default(),
                protocol: self.protocol,
                remote_id: self.remote_id,
                smoothing_latency: self.smoothing_latency.unwrap_or_default(),
                stream_id: self.stream_id,
                vpc_interface_attachment: self.vpc_interface_attachment,
            }
        }
    }
}
impl AddOutputRequest {
    /// Creates a new builder-style object to manufacture [`AddOutputRequest`](crate::model::AddOutputRequest)
    pub fn builder() -> crate::model::add_output_request::Builder {
        crate::model::add_output_request::Builder::default()
    }
}

/// The media stream that you want to add to the flow.
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddMediaStreamRequest {
    /// The attributes that you want to assign to the new media stream.
    pub attributes: std::option::Option<crate::model::MediaStreamAttributesRequest>,
    /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
    pub clock_rate: i32,
    /// A description that can help you quickly identify what your media stream is used for.
    pub description: std::option::Option<std::string::String>,
    /// A unique identifier for the media stream.
    pub media_stream_id: i32,
    /// A name that helps you distinguish one media stream from another.
    pub media_stream_name: std::option::Option<std::string::String>,
    /// The type of media stream.
    pub media_stream_type: std::option::Option<crate::model::MediaStreamType>,
    /// The resolution of the video.
    pub video_format: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AddMediaStreamRequest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddMediaStreamRequest");
        formatter.field("attributes", &self.attributes);
        formatter.field("clock_rate", &self.clock_rate);
        formatter.field("description", &self.description);
        formatter.field("media_stream_id", &self.media_stream_id);
        formatter.field("media_stream_name", &self.media_stream_name);
        formatter.field("media_stream_type", &self.media_stream_type);
        formatter.field("video_format", &self.video_format);
        formatter.finish()
    }
}
/// See [`AddMediaStreamRequest`](crate::model::AddMediaStreamRequest)
pub mod add_media_stream_request {
    /// A builder for [`AddMediaStreamRequest`](crate::model::AddMediaStreamRequest)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<crate::model::MediaStreamAttributesRequest>,
        pub(crate) clock_rate: std::option::Option<i32>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) media_stream_id: std::option::Option<i32>,
        pub(crate) media_stream_name: std::option::Option<std::string::String>,
        pub(crate) media_stream_type: std::option::Option<crate::model::MediaStreamType>,
        pub(crate) video_format: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// The attributes that you want to assign to the new media stream.
        pub fn attributes(mut self, input: crate::model::MediaStreamAttributesRequest) -> Self {
            self.attributes = Some(input);
            self
        }
        /// The attributes that you want to assign to the new media stream.
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::MediaStreamAttributesRequest>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn clock_rate(mut self, input: i32) -> Self {
            self.clock_rate = Some(input);
            self
        }
        /// The sample rate (in Hz) for the stream. If the media stream type is video or ancillary data, set this value to 90000. If the media stream type is audio, set this value to either 48000 or 96000.
        pub fn set_clock_rate(mut self, input: std::option::Option<i32>) -> Self {
            self.clock_rate = input;
            self
        }
        /// A description that can help you quickly identify what your media stream is used for.
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// A description that can help you quickly identify what your media stream is used for.
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// A unique identifier for the media stream.
        pub fn media_stream_id(mut self, input: i32) -> Self {
            self.media_stream_id = Some(input);
            self
        }
        /// A unique identifier for the media stream.
        pub fn set_media_stream_id(mut self, input: std::option::Option<i32>) -> Self {
            self.media_stream_id = input;
            self
        }
        /// A name that helps you distinguish one media stream from another.
        pub fn media_stream_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.media_stream_name = Some(input.into());
            self
        }
        /// A name that helps you distinguish one media stream from another.
        pub fn set_media_stream_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.media_stream_name = input;
            self
        }
        /// The type of media stream.
        pub fn media_stream_type(mut self, input: crate::model::MediaStreamType) -> Self {
            self.media_stream_type = Some(input);
            self
        }
        /// The type of media stream.
        pub fn set_media_stream_type(
            mut self,
            input: std::option::Option<crate::model::MediaStreamType>,
        ) -> Self {
            self.media_stream_type = input;
            self
        }
        /// The resolution of the video.
        pub fn video_format(mut self, input: impl Into<std::string::String>) -> Self {
            self.video_format = Some(input.into());
            self
        }
        /// The resolution of the video.
        pub fn set_video_format(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.video_format = input;
            self
        }
        /// Consumes the builder and constructs a [`AddMediaStreamRequest`](crate::model::AddMediaStreamRequest)
        pub fn build(self) -> crate::model::AddMediaStreamRequest {
            crate::model::AddMediaStreamRequest {
                attributes: self.attributes,
                clock_rate: self.clock_rate.unwrap_or_default(),
                description: self.description,
                media_stream_id: self.media_stream_id.unwrap_or_default(),
                media_stream_name: self.media_stream_name,
                media_stream_type: self.media_stream_type,
                video_format: self.video_format,
            }
        }
    }
}
impl AddMediaStreamRequest {
    /// Creates a new builder-style object to manufacture [`AddMediaStreamRequest`](crate::model::AddMediaStreamRequest)
    pub fn builder() -> crate::model::add_media_stream_request::Builder {
        crate::model::add_media_stream_request::Builder::default()
    }
}
