// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`BatchMeterUsageInput`](crate::input::BatchMeterUsageInput)
pub mod batch_meter_usage_input {
    /// A builder for [`BatchMeterUsageInput`](crate::input::BatchMeterUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) usage_records: std::option::Option<std::vec::Vec<crate::model::UsageRecord>>,
        pub(crate) product_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `usage_records`.
        ///
        /// To override the contents of this collection use [`set_usage_records`](Self::set_usage_records).
        ///
        /// <p>The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at
        /// a time.</p>
        pub fn usage_records(mut self, input: impl Into<crate::model::UsageRecord>) -> Self {
            let mut v = self.usage_records.unwrap_or_default();
            v.push(input.into());
            self.usage_records = Some(v);
            self
        }
        /// <p>The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at
        /// a time.</p>
        pub fn set_usage_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageRecord>>,
        ) -> Self {
            self.usage_records = input;
            self
        }
        /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
        /// code should be the same as the one used during the publishing of a new
        /// product.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
        /// code should be the same as the one used during the publishing of a new
        /// product.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchMeterUsageInput`](crate::input::BatchMeterUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchMeterUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchMeterUsageInput {
                usage_records: self.usage_records,
                product_code: self.product_code,
            })
        }
    }
}
#[doc(hidden)]
pub type BatchMeterUsageInputOperationOutputAlias = crate::operation::BatchMeterUsage;
#[doc(hidden)]
pub type BatchMeterUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchMeterUsageInput {
    /// Consumes the builder and constructs an Operation<[`BatchMeterUsage`](crate::operation::BatchMeterUsage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchMeterUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchMeterUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchMeterUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchMeterUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMPMeteringService.BatchMeterUsage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_meter_usage(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchMeterUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchMeterUsage",
            "marketplacemetering",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchMeterUsageInput`](crate::input::BatchMeterUsageInput)
    pub fn builder() -> crate::input::batch_meter_usage_input::Builder {
        crate::input::batch_meter_usage_input::Builder::default()
    }
}

/// See [`MeterUsageInput`](crate::input::MeterUsageInput)
pub mod meter_usage_input {
    /// A builder for [`MeterUsageInput`](crate::input::MeterUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) timestamp: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) usage_dimension: std::option::Option<std::string::String>,
        pub(crate) usage_quantity: std::option::Option<i32>,
        pub(crate) dry_run: std::option::Option<bool>,
        pub(crate) usage_allocations:
            std::option::Option<std::vec::Vec<crate::model::UsageAllocation>>,
    }
    impl Builder {
        /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
        /// code should be the same as the one used during the publishing of a new
        /// product.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
        /// code should be the same as the one used during the publishing of a new
        /// product.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// <p>Timestamp, in UTC, for which the usage is being reported. Your application can
        /// meter usage for up to one hour in the past. Make sure the timestamp value is not before
        /// the start of the software usage.</p>
        pub fn timestamp(mut self, input: aws_smithy_types::Instant) -> Self {
            self.timestamp = Some(input);
            self
        }
        /// <p>Timestamp, in UTC, for which the usage is being reported. Your application can
        /// meter usage for up to one hour in the past. Make sure the timestamp value is not before
        /// the start of the software usage.</p>
        pub fn set_timestamp(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.timestamp = input;
            self
        }
        /// <p>It will be one of the fcp dimension name provided during the publishing of the
        /// product.</p>
        pub fn usage_dimension(mut self, input: impl Into<std::string::String>) -> Self {
            self.usage_dimension = Some(input.into());
            self
        }
        /// <p>It will be one of the fcp dimension name provided during the publishing of the
        /// product.</p>
        pub fn set_usage_dimension(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.usage_dimension = input;
            self
        }
        /// <p>Consumption value for the hour. Defaults to <code>0</code> if not
        /// specified.</p>
        pub fn usage_quantity(mut self, input: i32) -> Self {
            self.usage_quantity = Some(input);
            self
        }
        /// <p>Consumption value for the hour. Defaults to <code>0</code> if not
        /// specified.</p>
        pub fn set_usage_quantity(mut self, input: std::option::Option<i32>) -> Self {
            self.usage_quantity = input;
            self
        }
        /// <p>Checks whether you have the permissions required for the action, but does not make
        /// the request. If you have the permissions, the request returns DryRunOperation;
        /// otherwise, it returns UnauthorizedException. Defaults to <code>false</code> if not
        /// specified.</p>
        pub fn dry_run(mut self, input: bool) -> Self {
            self.dry_run = Some(input);
            self
        }
        /// <p>Checks whether you have the permissions required for the action, but does not make
        /// the request. If you have the permissions, the request returns DryRunOperation;
        /// otherwise, it returns UnauthorizedException. Defaults to <code>false</code> if not
        /// specified.</p>
        pub fn set_dry_run(mut self, input: std::option::Option<bool>) -> Self {
            self.dry_run = input;
            self
        }
        /// Appends an item to `usage_allocations`.
        ///
        /// To override the contents of this collection use [`set_usage_allocations`](Self::set_usage_allocations).
        ///
        /// <p>The set of UsageAllocations to submit.</p>
        /// <p>The sum of all UsageAllocation quantities must equal the
        /// UsageQuantity of the MeterUsage request, and each UsageAllocation must have a
        /// unique set of tags (include no tags).</p>
        pub fn usage_allocations(
            mut self,
            input: impl Into<crate::model::UsageAllocation>,
        ) -> Self {
            let mut v = self.usage_allocations.unwrap_or_default();
            v.push(input.into());
            self.usage_allocations = Some(v);
            self
        }
        /// <p>The set of UsageAllocations to submit.</p>
        /// <p>The sum of all UsageAllocation quantities must equal the
        /// UsageQuantity of the MeterUsage request, and each UsageAllocation must have a
        /// unique set of tags (include no tags).</p>
        pub fn set_usage_allocations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageAllocation>>,
        ) -> Self {
            self.usage_allocations = input;
            self
        }
        /// Consumes the builder and constructs a [`MeterUsageInput`](crate::input::MeterUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::MeterUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::MeterUsageInput {
                product_code: self.product_code,
                timestamp: self.timestamp,
                usage_dimension: self.usage_dimension,
                usage_quantity: self.usage_quantity,
                dry_run: self.dry_run,
                usage_allocations: self.usage_allocations,
            })
        }
    }
}
#[doc(hidden)]
pub type MeterUsageInputOperationOutputAlias = crate::operation::MeterUsage;
#[doc(hidden)]
pub type MeterUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl MeterUsageInput {
    /// Consumes the builder and constructs an Operation<[`MeterUsage`](crate::operation::MeterUsage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::MeterUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::MeterUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::MeterUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::MeterUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMPMeteringService.MeterUsage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_meter_usage(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::MeterUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "MeterUsage",
            "marketplacemetering",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`MeterUsageInput`](crate::input::MeterUsageInput)
    pub fn builder() -> crate::input::meter_usage_input::Builder {
        crate::input::meter_usage_input::Builder::default()
    }
}

/// See [`RegisterUsageInput`](crate::input::RegisterUsageInput)
pub mod register_usage_input {
    /// A builder for [`RegisterUsageInput`](crate::input::RegisterUsageInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) public_key_version: std::option::Option<i32>,
        pub(crate) nonce: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
        /// code should be the same as the one used during the publishing of a new
        /// product.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
        /// code should be the same as the one used during the publishing of a new
        /// product.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// <p>Public Key Version provided by AWS Marketplace</p>
        pub fn public_key_version(mut self, input: i32) -> Self {
            self.public_key_version = Some(input);
            self
        }
        /// <p>Public Key Version provided by AWS Marketplace</p>
        pub fn set_public_key_version(mut self, input: std::option::Option<i32>) -> Self {
            self.public_key_version = input;
            self
        }
        /// <p>(Optional) To scope down the registration to a specific running software instance
        /// and guard against replay attacks.</p>
        pub fn nonce(mut self, input: impl Into<std::string::String>) -> Self {
            self.nonce = Some(input.into());
            self
        }
        /// <p>(Optional) To scope down the registration to a specific running software instance
        /// and guard against replay attacks.</p>
        pub fn set_nonce(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.nonce = input;
            self
        }
        /// Consumes the builder and constructs a [`RegisterUsageInput`](crate::input::RegisterUsageInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RegisterUsageInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RegisterUsageInput {
                product_code: self.product_code,
                public_key_version: self.public_key_version,
                nonce: self.nonce,
            })
        }
    }
}
#[doc(hidden)]
pub type RegisterUsageInputOperationOutputAlias = crate::operation::RegisterUsage;
#[doc(hidden)]
pub type RegisterUsageInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl RegisterUsageInput {
    /// Consumes the builder and constructs an Operation<[`RegisterUsage`](crate::operation::RegisterUsage)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RegisterUsage,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::RegisterUsageInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::RegisterUsageInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::RegisterUsageInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMPMeteringService.RegisterUsage",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_register_usage(&self)
            .map_err(|err| {
                aws_smithy_http::operation::BuildError::SerializationError(err.into())
            })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RegisterUsage::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RegisterUsage",
            "marketplacemetering",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`RegisterUsageInput`](crate::input::RegisterUsageInput)
    pub fn builder() -> crate::input::register_usage_input::Builder {
        crate::input::register_usage_input::Builder::default()
    }
}

/// See [`ResolveCustomerInput`](crate::input::ResolveCustomerInput)
pub mod resolve_customer_input {
    /// A builder for [`ResolveCustomerInput`](crate::input::ResolveCustomerInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) registration_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>When a buyer visits your website during the registration process, the buyer submits
        /// a registration token through the browser. The registration token is resolved to obtain a
        /// CustomerIdentifier and product code.</p>
        pub fn registration_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.registration_token = Some(input.into());
            self
        }
        /// <p>When a buyer visits your website during the registration process, the buyer submits
        /// a registration token through the browser. The registration token is resolved to obtain a
        /// CustomerIdentifier and product code.</p>
        pub fn set_registration_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.registration_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ResolveCustomerInput`](crate::input::ResolveCustomerInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ResolveCustomerInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ResolveCustomerInput {
                registration_token: self.registration_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ResolveCustomerInputOperationOutputAlias = crate::operation::ResolveCustomer;
#[doc(hidden)]
pub type ResolveCustomerInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ResolveCustomerInput {
    /// Consumes the builder and constructs an Operation<[`ResolveCustomer`](crate::operation::ResolveCustomer)>
    #[allow(clippy::let_and_return)]
    pub fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ResolveCustomer,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ResolveCustomerInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ResolveCustomerInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ResolveCustomerInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AWSMPMeteringService.ResolveCustomer",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_resolve_customer(&self)
                .map_err(|err| {
                    aws_smithy_http::operation::BuildError::SerializationError(err.into())
                })?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ResolveCustomer::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ResolveCustomer",
            "marketplacemetering",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        mut builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ResolveCustomerInput`](crate::input::ResolveCustomerInput)
    pub fn builder() -> crate::input::resolve_customer_input::Builder {
        crate::input::resolve_customer_input::Builder::default()
    }
}

/// <p>Contains input to the ResolveCustomer operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResolveCustomerInput {
    /// <p>When a buyer visits your website during the registration process, the buyer submits
    /// a registration token through the browser. The registration token is resolved to obtain a
    /// CustomerIdentifier and product code.</p>
    pub registration_token: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResolveCustomerInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResolveCustomerInput");
        formatter.field("registration_token", &self.registration_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RegisterUsageInput {
    /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
    /// code should be the same as the one used during the publishing of a new
    /// product.</p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p>Public Key Version provided by AWS Marketplace</p>
    pub public_key_version: std::option::Option<i32>,
    /// <p>(Optional) To scope down the registration to a specific running software instance
    /// and guard against replay attacks.</p>
    pub nonce: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RegisterUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RegisterUsageInput");
        formatter.field("product_code", &self.product_code);
        formatter.field("public_key_version", &self.public_key_version);
        formatter.field("nonce", &self.nonce);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MeterUsageInput {
    /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
    /// code should be the same as the one used during the publishing of a new
    /// product.</p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p>Timestamp, in UTC, for which the usage is being reported. Your application can
    /// meter usage for up to one hour in the past. Make sure the timestamp value is not before
    /// the start of the software usage.</p>
    pub timestamp: std::option::Option<aws_smithy_types::Instant>,
    /// <p>It will be one of the fcp dimension name provided during the publishing of the
    /// product.</p>
    pub usage_dimension: std::option::Option<std::string::String>,
    /// <p>Consumption value for the hour. Defaults to <code>0</code> if not
    /// specified.</p>
    pub usage_quantity: std::option::Option<i32>,
    /// <p>Checks whether you have the permissions required for the action, but does not make
    /// the request. If you have the permissions, the request returns DryRunOperation;
    /// otherwise, it returns UnauthorizedException. Defaults to <code>false</code> if not
    /// specified.</p>
    pub dry_run: std::option::Option<bool>,
    /// <p>The set of UsageAllocations to submit.</p>
    /// <p>The sum of all UsageAllocation quantities must equal the
    /// UsageQuantity of the MeterUsage request, and each UsageAllocation must have a
    /// unique set of tags (include no tags).</p>
    pub usage_allocations: std::option::Option<std::vec::Vec<crate::model::UsageAllocation>>,
}
impl std::fmt::Debug for MeterUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MeterUsageInput");
        formatter.field("product_code", &self.product_code);
        formatter.field("timestamp", &self.timestamp);
        formatter.field("usage_dimension", &self.usage_dimension);
        formatter.field("usage_quantity", &self.usage_quantity);
        formatter.field("dry_run", &self.dry_run);
        formatter.field("usage_allocations", &self.usage_allocations);
        formatter.finish()
    }
}

/// <p>A BatchMeterUsageRequest contains UsageRecords, which indicate quantities of usage
/// within your application.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchMeterUsageInput {
    /// <p>The set of UsageRecords to submit. BatchMeterUsage accepts up to 25 UsageRecords at
    /// a time.</p>
    pub usage_records: std::option::Option<std::vec::Vec<crate::model::UsageRecord>>,
    /// <p>Product code is used to uniquely identify a product in AWS Marketplace. The product
    /// code should be the same as the one used during the publishing of a new
    /// product.</p>
    pub product_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for BatchMeterUsageInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchMeterUsageInput");
        formatter.field("usage_records", &self.usage_records);
        formatter.field("product_code", &self.product_code);
        formatter.finish()
    }
}
