// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An entitlement represents capacity in a product owned by the customer. For example, a
/// customer might own some number of users or seats in an SaaS application or  some amount of
/// data capacity in a multi-tenant database.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entitlement {
    /// <p>The product code for which the given entitlement applies. Product codes are provided by
    /// AWS Marketplace when the product listing is created.</p>
    pub product_code: std::option::Option<std::string::String>,
    /// <p>The dimension for which the given entitlement applies. Dimensions represent categories of
    /// capacity in a product and are specified when the product is listed in AWS
    /// Marketplace.</p>
    pub dimension: std::option::Option<std::string::String>,
    /// <p>The customer identifier is a handle to each unique customer in an application. Customer
    /// identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering
    /// Service.</p>
    pub customer_identifier: std::option::Option<std::string::String>,
    /// <p>The EntitlementValue represents the amount of capacity that the customer is entitled to
    /// for the product.</p>
    pub value: std::option::Option<crate::model::EntitlementValue>,
    /// <p>The expiration date represents the minimum date through which this entitlement is
    /// expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date
    /// is the date at which the customer will renew or cancel their contract. Customers who are opting
    /// to renew their contract will still have entitlements with an expiration date.</p>
    pub expiration_date: std::option::Option<aws_smithy_types::DateTime>,
}
impl Entitlement {
    /// <p>The product code for which the given entitlement applies. Product codes are provided by
    /// AWS Marketplace when the product listing is created.</p>
    pub fn product_code(&self) -> std::option::Option<&str> {
        self.product_code.as_deref()
    }
    /// <p>The dimension for which the given entitlement applies. Dimensions represent categories of
    /// capacity in a product and are specified when the product is listed in AWS
    /// Marketplace.</p>
    pub fn dimension(&self) -> std::option::Option<&str> {
        self.dimension.as_deref()
    }
    /// <p>The customer identifier is a handle to each unique customer in an application. Customer
    /// identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering
    /// Service.</p>
    pub fn customer_identifier(&self) -> std::option::Option<&str> {
        self.customer_identifier.as_deref()
    }
    /// <p>The EntitlementValue represents the amount of capacity that the customer is entitled to
    /// for the product.</p>
    pub fn value(&self) -> std::option::Option<&crate::model::EntitlementValue> {
        self.value.as_ref()
    }
    /// <p>The expiration date represents the minimum date through which this entitlement is
    /// expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date
    /// is the date at which the customer will renew or cancel their contract. Customers who are opting
    /// to renew their contract will still have entitlements with an expiration date.</p>
    pub fn expiration_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.expiration_date.as_ref()
    }
}
impl std::fmt::Debug for Entitlement {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entitlement");
        formatter.field("product_code", &self.product_code);
        formatter.field("dimension", &self.dimension);
        formatter.field("customer_identifier", &self.customer_identifier);
        formatter.field("value", &self.value);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.finish()
    }
}
/// See [`Entitlement`](crate::model::Entitlement)
pub mod entitlement {
    /// A builder for [`Entitlement`](crate::model::Entitlement)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) product_code: std::option::Option<std::string::String>,
        pub(crate) dimension: std::option::Option<std::string::String>,
        pub(crate) customer_identifier: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<crate::model::EntitlementValue>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The product code for which the given entitlement applies. Product codes are provided by
        /// AWS Marketplace when the product listing is created.</p>
        pub fn product_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.product_code = Some(input.into());
            self
        }
        /// <p>The product code for which the given entitlement applies. Product codes are provided by
        /// AWS Marketplace when the product listing is created.</p>
        pub fn set_product_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.product_code = input;
            self
        }
        /// <p>The dimension for which the given entitlement applies. Dimensions represent categories of
        /// capacity in a product and are specified when the product is listed in AWS
        /// Marketplace.</p>
        pub fn dimension(mut self, input: impl Into<std::string::String>) -> Self {
            self.dimension = Some(input.into());
            self
        }
        /// <p>The dimension for which the given entitlement applies. Dimensions represent categories of
        /// capacity in a product and are specified when the product is listed in AWS
        /// Marketplace.</p>
        pub fn set_dimension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dimension = input;
            self
        }
        /// <p>The customer identifier is a handle to each unique customer in an application. Customer
        /// identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering
        /// Service.</p>
        pub fn customer_identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.customer_identifier = Some(input.into());
            self
        }
        /// <p>The customer identifier is a handle to each unique customer in an application. Customer
        /// identifiers are obtained through the ResolveCustomer operation in AWS Marketplace Metering
        /// Service.</p>
        pub fn set_customer_identifier(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.customer_identifier = input;
            self
        }
        /// <p>The EntitlementValue represents the amount of capacity that the customer is entitled to
        /// for the product.</p>
        pub fn value(mut self, input: crate::model::EntitlementValue) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The EntitlementValue represents the amount of capacity that the customer is entitled to
        /// for the product.</p>
        pub fn set_value(
            mut self,
            input: std::option::Option<crate::model::EntitlementValue>,
        ) -> Self {
            self.value = input;
            self
        }
        /// <p>The expiration date represents the minimum date through which this entitlement is
        /// expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date
        /// is the date at which the customer will renew or cancel their contract. Customers who are opting
        /// to renew their contract will still have entitlements with an expiration date.</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>The expiration date represents the minimum date through which this entitlement is
        /// expected to remain valid. For contractual products listed on AWS Marketplace, the expiration date
        /// is the date at which the customer will renew or cancel their contract. Customers who are opting
        /// to renew their contract will still have entitlements with an expiration date.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// Consumes the builder and constructs a [`Entitlement`](crate::model::Entitlement)
        pub fn build(self) -> crate::model::Entitlement {
            crate::model::Entitlement {
                product_code: self.product_code,
                dimension: self.dimension,
                customer_identifier: self.customer_identifier,
                value: self.value,
                expiration_date: self.expiration_date,
            }
        }
    }
}
impl Entitlement {
    /// Creates a new builder-style object to manufacture [`Entitlement`](crate::model::Entitlement)
    pub fn builder() -> crate::model::entitlement::Builder {
        crate::model::entitlement::Builder::default()
    }
}

/// <p>The EntitlementValue represents the amount of capacity that the customer is entitled to
/// for the product.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
pub enum EntitlementValue {
    /// <p>The BooleanValue field will be populated with a boolean value when the entitlement is a
    /// boolean type. Otherwise, the field will not be set.</p>
    BooleanValue(bool),
    /// <p>The DoubleValue field will be populated with a double value when the entitlement is a
    /// double type. Otherwise, the field will not be set.</p>
    DoubleValue(f64),
    /// <p>The IntegerValue field will be populated with an integer value when the entitlement is an
    /// integer type. Otherwise, the field will not be set.</p>
    IntegerValue(i32),
    /// <p>The StringValue field will be populated with a string value when the entitlement is a
    /// string type. Otherwise, the field will not be set.</p>
    StringValue(std::string::String),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl EntitlementValue {
    /// Tries to convert the enum instance into [`BooleanValue`](crate::model::EntitlementValue::BooleanValue), extracting the inner [`bool`](bool).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_boolean_value(&self) -> std::result::Result<&bool, &Self> {
        if let EntitlementValue::BooleanValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`BooleanValue`](crate::model::EntitlementValue::BooleanValue).
    pub fn is_boolean_value(&self) -> bool {
        self.as_boolean_value().is_ok()
    }
    /// Tries to convert the enum instance into [`DoubleValue`](crate::model::EntitlementValue::DoubleValue), extracting the inner [`f64`](f64).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_double_value(&self) -> std::result::Result<&f64, &Self> {
        if let EntitlementValue::DoubleValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`DoubleValue`](crate::model::EntitlementValue::DoubleValue).
    pub fn is_double_value(&self) -> bool {
        self.as_double_value().is_ok()
    }
    /// Tries to convert the enum instance into [`IntegerValue`](crate::model::EntitlementValue::IntegerValue), extracting the inner [`i32`](i32).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_integer_value(&self) -> std::result::Result<&i32, &Self> {
        if let EntitlementValue::IntegerValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`IntegerValue`](crate::model::EntitlementValue::IntegerValue).
    pub fn is_integer_value(&self) -> bool {
        self.as_integer_value().is_ok()
    }
    /// Tries to convert the enum instance into [`StringValue`](crate::model::EntitlementValue::StringValue), extracting the inner [`String`](std::string::String).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_string_value(&self) -> std::result::Result<&std::string::String, &Self> {
        if let EntitlementValue::StringValue(val) = &self {
            Ok(val)
        } else {
            Err(self)
        }
    }
    /// Returns true if this is a [`StringValue`](crate::model::EntitlementValue::StringValue).
    pub fn is_string_value(&self) -> bool {
        self.as_string_value().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GetEntitlementFilterName {
    #[allow(missing_docs)] // documentation missing in model
    CustomerIdentifier,
    #[allow(missing_docs)] // documentation missing in model
    Dimension,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GetEntitlementFilterName {
    fn from(s: &str) -> Self {
        match s {
            "CUSTOMER_IDENTIFIER" => GetEntitlementFilterName::CustomerIdentifier,
            "DIMENSION" => GetEntitlementFilterName::Dimension,
            other => GetEntitlementFilterName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GetEntitlementFilterName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GetEntitlementFilterName::from(s))
    }
}
impl GetEntitlementFilterName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GetEntitlementFilterName::CustomerIdentifier => "CUSTOMER_IDENTIFIER",
            GetEntitlementFilterName::Dimension => "DIMENSION",
            GetEntitlementFilterName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CUSTOMER_IDENTIFIER", "DIMENSION"]
    }
}
impl AsRef<str> for GetEntitlementFilterName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
