// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>An object that contains the <code>ChangeType</code>, <code>Details</code>, and
/// <code>Entity</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Change {
    /// <p>Change types are single string values that describe your intention for the change.
    /// Each change type is unique for each <code>EntityType</code> provided in the change's
    /// scope.</p>
    pub change_type: std::option::Option<std::string::String>,
    /// <p>The entity to be changed.</p>
    pub entity: std::option::Option<crate::model::Entity>,
    /// <p>This object contains details specific to the change type of the requested
    /// change.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>Optional name for the change.</p>
    pub change_name: std::option::Option<std::string::String>,
}
impl Change {
    /// <p>Change types are single string values that describe your intention for the change.
    /// Each change type is unique for each <code>EntityType</code> provided in the change's
    /// scope.</p>
    pub fn change_type(&self) -> std::option::Option<&str> {
        self.change_type.as_deref()
    }
    /// <p>The entity to be changed.</p>
    pub fn entity(&self) -> std::option::Option<&crate::model::Entity> {
        self.entity.as_ref()
    }
    /// <p>This object contains details specific to the change type of the requested
    /// change.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>Optional name for the change.</p>
    pub fn change_name(&self) -> std::option::Option<&str> {
        self.change_name.as_deref()
    }
}
impl std::fmt::Debug for Change {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Change");
        formatter.field("change_type", &self.change_type);
        formatter.field("entity", &self.entity);
        formatter.field("details", &self.details);
        formatter.field("change_name", &self.change_name);
        formatter.finish()
    }
}
/// See [`Change`](crate::model::Change)
pub mod change {
    /// A builder for [`Change`](crate::model::Change)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_type: std::option::Option<std::string::String>,
        pub(crate) entity: std::option::Option<crate::model::Entity>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) change_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Change types are single string values that describe your intention for the change.
        /// Each change type is unique for each <code>EntityType</code> provided in the change's
        /// scope.</p>
        pub fn change_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_type = Some(input.into());
            self
        }
        /// <p>Change types are single string values that describe your intention for the change.
        /// Each change type is unique for each <code>EntityType</code> provided in the change's
        /// scope.</p>
        pub fn set_change_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_type = input;
            self
        }
        /// <p>The entity to be changed.</p>
        pub fn entity(mut self, input: crate::model::Entity) -> Self {
            self.entity = Some(input);
            self
        }
        /// <p>The entity to be changed.</p>
        pub fn set_entity(mut self, input: std::option::Option<crate::model::Entity>) -> Self {
            self.entity = input;
            self
        }
        /// <p>This object contains details specific to the change type of the requested
        /// change.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>This object contains details specific to the change type of the requested
        /// change.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// <p>Optional name for the change.</p>
        pub fn change_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_name = Some(input.into());
            self
        }
        /// <p>Optional name for the change.</p>
        pub fn set_change_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_name = input;
            self
        }
        /// Consumes the builder and constructs a [`Change`](crate::model::Change)
        pub fn build(self) -> crate::model::Change {
            crate::model::Change {
                change_type: self.change_type,
                entity: self.entity,
                details: self.details,
                change_name: self.change_name,
            }
        }
    }
}
impl Change {
    /// Creates a new builder-style object to manufacture [`Change`](crate::model::Change)
    pub fn builder() -> crate::model::change::Builder {
        crate::model::change::Builder::default()
    }
}

/// <p>An entity contains data that describes your product, its supported features,
/// and how it can be used or launched by your customer. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Entity {
    /// <p>The type of entity.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The identifier for the entity.</p>
    pub identifier: std::option::Option<std::string::String>,
}
impl Entity {
    /// <p>The type of entity.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The identifier for the entity.</p>
    pub fn identifier(&self) -> std::option::Option<&str> {
        self.identifier.as_deref()
    }
}
impl std::fmt::Debug for Entity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Entity");
        formatter.field("r#type", &self.r#type);
        formatter.field("identifier", &self.identifier);
        formatter.finish()
    }
}
/// See [`Entity`](crate::model::Entity)
pub mod entity {
    /// A builder for [`Entity`](crate::model::Entity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) identifier: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of entity.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of entity.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The identifier for the entity.</p>
        pub fn identifier(mut self, input: impl Into<std::string::String>) -> Self {
            self.identifier = Some(input.into());
            self
        }
        /// <p>The identifier for the entity.</p>
        pub fn set_identifier(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.identifier = input;
            self
        }
        /// Consumes the builder and constructs a [`Entity`](crate::model::Entity)
        pub fn build(self) -> crate::model::Entity {
            crate::model::Entity {
                r#type: self.r#type,
                identifier: self.identifier,
            }
        }
    }
}
impl Entity {
    /// Creates a new builder-style object to manufacture [`Entity`](crate::model::Entity)
    pub fn builder() -> crate::model::entity::Builder {
        crate::model::entity::Builder::default()
    }
}

/// <p>This object is a container for common summary information about the entity. The
/// summary doesn't contain the whole entity structure, but it does contain information
/// common across all entities.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EntitySummary {
    /// <p>The name for the entity. This value is not unique. It is defined by the
    /// seller.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The type of the entity.</p>
    pub entity_type: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the entity.</p>
    pub entity_id: std::option::Option<std::string::String>,
    /// <p>The ARN associated with the unique identifier for the entity.</p>
    pub entity_arn: std::option::Option<std::string::String>,
    /// <p>The last time the entity was published, using ISO 8601 format
    /// (2018-02-27T13:45:22Z).</p>
    pub last_modified_date: std::option::Option<std::string::String>,
    /// <p>The visibility status of the entity to
    /// buyers.
    /// This value can be <code>Public</code> (everyone can view the entity),
    /// <code>Limited</code> (the entity is visible to limited accounts only), or
    /// <code>Restricted</code> (the entity was published and then unpublished and only
    /// existing
    /// buyers
    /// can view it). </p>
    pub visibility: std::option::Option<std::string::String>,
}
impl EntitySummary {
    /// <p>The name for the entity. This value is not unique. It is defined by the
    /// seller.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The type of the entity.</p>
    pub fn entity_type(&self) -> std::option::Option<&str> {
        self.entity_type.as_deref()
    }
    /// <p>The unique identifier for the entity.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
    /// <p>The ARN associated with the unique identifier for the entity.</p>
    pub fn entity_arn(&self) -> std::option::Option<&str> {
        self.entity_arn.as_deref()
    }
    /// <p>The last time the entity was published, using ISO 8601 format
    /// (2018-02-27T13:45:22Z).</p>
    pub fn last_modified_date(&self) -> std::option::Option<&str> {
        self.last_modified_date.as_deref()
    }
    /// <p>The visibility status of the entity to
    /// buyers.
    /// This value can be <code>Public</code> (everyone can view the entity),
    /// <code>Limited</code> (the entity is visible to limited accounts only), or
    /// <code>Restricted</code> (the entity was published and then unpublished and only
    /// existing
    /// buyers
    /// can view it). </p>
    pub fn visibility(&self) -> std::option::Option<&str> {
        self.visibility.as_deref()
    }
}
impl std::fmt::Debug for EntitySummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EntitySummary");
        formatter.field("name", &self.name);
        formatter.field("entity_type", &self.entity_type);
        formatter.field("entity_id", &self.entity_id);
        formatter.field("entity_arn", &self.entity_arn);
        formatter.field("last_modified_date", &self.last_modified_date);
        formatter.field("visibility", &self.visibility);
        formatter.finish()
    }
}
/// See [`EntitySummary`](crate::model::EntitySummary)
pub mod entity_summary {
    /// A builder for [`EntitySummary`](crate::model::EntitySummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) entity_type: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
        pub(crate) entity_arn: std::option::Option<std::string::String>,
        pub(crate) last_modified_date: std::option::Option<std::string::String>,
        pub(crate) visibility: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the entity. This value is not unique. It is defined by the
        /// seller.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name for the entity. This value is not unique. It is defined by the
        /// seller.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The type of the entity.</p>
        pub fn entity_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_type = Some(input.into());
            self
        }
        /// <p>The type of the entity.</p>
        pub fn set_entity_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_type = input;
            self
        }
        /// <p>The unique identifier for the entity.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// <p>The ARN associated with the unique identifier for the entity.</p>
        pub fn entity_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_arn = Some(input.into());
            self
        }
        /// <p>The ARN associated with the unique identifier for the entity.</p>
        pub fn set_entity_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_arn = input;
            self
        }
        /// <p>The last time the entity was published, using ISO 8601 format
        /// (2018-02-27T13:45:22Z).</p>
        pub fn last_modified_date(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_modified_date = Some(input.into());
            self
        }
        /// <p>The last time the entity was published, using ISO 8601 format
        /// (2018-02-27T13:45:22Z).</p>
        pub fn set_last_modified_date(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.last_modified_date = input;
            self
        }
        /// <p>The visibility status of the entity to
        /// buyers.
        /// This value can be <code>Public</code> (everyone can view the entity),
        /// <code>Limited</code> (the entity is visible to limited accounts only), or
        /// <code>Restricted</code> (the entity was published and then unpublished and only
        /// existing
        /// buyers
        /// can view it). </p>
        pub fn visibility(mut self, input: impl Into<std::string::String>) -> Self {
            self.visibility = Some(input.into());
            self
        }
        /// <p>The visibility status of the entity to
        /// buyers.
        /// This value can be <code>Public</code> (everyone can view the entity),
        /// <code>Limited</code> (the entity is visible to limited accounts only), or
        /// <code>Restricted</code> (the entity was published and then unpublished and only
        /// existing
        /// buyers
        /// can view it). </p>
        pub fn set_visibility(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.visibility = input;
            self
        }
        /// Consumes the builder and constructs a [`EntitySummary`](crate::model::EntitySummary)
        pub fn build(self) -> crate::model::EntitySummary {
            crate::model::EntitySummary {
                name: self.name,
                entity_type: self.entity_type,
                entity_id: self.entity_id,
                entity_arn: self.entity_arn,
                last_modified_date: self.last_modified_date,
                visibility: self.visibility,
            }
        }
    }
}
impl EntitySummary {
    /// Creates a new builder-style object to manufacture [`EntitySummary`](crate::model::EntitySummary)
    pub fn builder() -> crate::model::entity_summary::Builder {
        crate::model::entity_summary::Builder::default()
    }
}

/// <p>An object that contains two attributes, <code>SortBy</code> and
/// <code>SortOrder</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Sort {
    /// <p>For <code>ListEntities</code>, supported attributes include
    /// <code>LastModifiedDate</code> (default), <code>Visibility</code>,
    /// <code>EntityId</code>, and <code>Name</code>.</p>
    ///
    /// <p>For <code>ListChangeSets</code>, supported attributes include <code>StartTime</code>
    /// and <code>EndTime</code>.</p>
    pub sort_by: std::option::Option<std::string::String>,
    /// <p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The
    /// default value is <code>DESCENDING</code>.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
}
impl Sort {
    /// <p>For <code>ListEntities</code>, supported attributes include
    /// <code>LastModifiedDate</code> (default), <code>Visibility</code>,
    /// <code>EntityId</code>, and <code>Name</code>.</p>
    ///
    /// <p>For <code>ListChangeSets</code>, supported attributes include <code>StartTime</code>
    /// and <code>EndTime</code>.</p>
    pub fn sort_by(&self) -> std::option::Option<&str> {
        self.sort_by.as_deref()
    }
    /// <p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The
    /// default value is <code>DESCENDING</code>.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
}
impl std::fmt::Debug for Sort {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Sort");
        formatter.field("sort_by", &self.sort_by);
        formatter.field("sort_order", &self.sort_order);
        formatter.finish()
    }
}
/// See [`Sort`](crate::model::Sort)
pub mod sort {
    /// A builder for [`Sort`](crate::model::Sort)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) sort_by: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
    }
    impl Builder {
        /// <p>For <code>ListEntities</code>, supported attributes include
        /// <code>LastModifiedDate</code> (default), <code>Visibility</code>,
        /// <code>EntityId</code>, and <code>Name</code>.</p>
        ///
        /// <p>For <code>ListChangeSets</code>, supported attributes include <code>StartTime</code>
        /// and <code>EndTime</code>.</p>
        pub fn sort_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.sort_by = Some(input.into());
            self
        }
        /// <p>For <code>ListEntities</code>, supported attributes include
        /// <code>LastModifiedDate</code> (default), <code>Visibility</code>,
        /// <code>EntityId</code>, and <code>Name</code>.</p>
        ///
        /// <p>For <code>ListChangeSets</code>, supported attributes include <code>StartTime</code>
        /// and <code>EndTime</code>.</p>
        pub fn set_sort_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The
        /// default value is <code>DESCENDING</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>The sorting order. Can be <code>ASCENDING</code> or <code>DESCENDING</code>. The
        /// default value is <code>DESCENDING</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// Consumes the builder and constructs a [`Sort`](crate::model::Sort)
        pub fn build(self) -> crate::model::Sort {
            crate::model::Sort {
                sort_by: self.sort_by,
                sort_order: self.sort_order,
            }
        }
    }
}
impl Sort {
    /// Creates a new builder-style object to manufacture [`Sort`](crate::model::Sort)
    pub fn builder() -> crate::model::sort::Builder {
        crate::model::sort::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SortOrder {
    #[allow(missing_docs)] // documentation missing in model
    Ascending,
    #[allow(missing_docs)] // documentation missing in model
    Descending,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SortOrder {
    fn from(s: &str) -> Self {
        match s {
            "ASCENDING" => SortOrder::Ascending,
            "DESCENDING" => SortOrder::Descending,
            other => SortOrder::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SortOrder {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SortOrder::from(s))
    }
}
impl SortOrder {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SortOrder::Ascending => "ASCENDING",
            SortOrder::Descending => "DESCENDING",
            SortOrder::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASCENDING", "DESCENDING"]
    }
}
impl AsRef<str> for SortOrder {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A filter object, used to optionally filter results from calls to the
/// <code>ListEntities</code> and <code>ListChangeSets</code> actions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Filter {
    /// <p>For <code>ListEntities</code>, the supported value for this is an
    /// <code>EntityId</code>.</p>
    /// <p>For <code>ListChangeSets</code>, the supported values are as follows:</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>
    /// <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
    ///
    /// <p>
    /// <code>ListChangeSets</code> - The supported filter names and associated
    /// <code>ValueList</code>s is as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of
    /// non-unique <code>ChangeSetName</code>s. These are defined when you call the
    /// <code>StartChangeSet</code> action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - The supported <code>ValueList</code> is a list of
    /// statuses for all change set requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EntityId</code> - The supported <code>ValueList</code> is a list of
    /// unique <code>EntityId</code>s.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list
    /// of all change sets that started before the filter value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list
    /// of all change sets that started after the filter value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of
    /// all change sets that ended before the filter value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of
    /// all change sets that ended after the filter value.</p>
    /// </li>
    /// </ul>
    pub value_list: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl Filter {
    /// <p>For <code>ListEntities</code>, the supported value for this is an
    /// <code>EntityId</code>.</p>
    /// <p>For <code>ListChangeSets</code>, the supported values are as follows:</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>
    /// <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
    ///
    /// <p>
    /// <code>ListChangeSets</code> - The supported filter names and associated
    /// <code>ValueList</code>s is as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of
    /// non-unique <code>ChangeSetName</code>s. These are defined when you call the
    /// <code>StartChangeSet</code> action.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - The supported <code>ValueList</code> is a list of
    /// statuses for all change set requests.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EntityId</code> - The supported <code>ValueList</code> is a list of
    /// unique <code>EntityId</code>s.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list
    /// of all change sets that started before the filter value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list
    /// of all change sets that started after the filter value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of
    /// all change sets that ended before the filter value.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of
    /// all change sets that ended after the filter value.</p>
    /// </li>
    /// </ul>
    pub fn value_list(&self) -> std::option::Option<&[std::string::String]> {
        self.value_list.as_deref()
    }
}
impl std::fmt::Debug for Filter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Filter");
        formatter.field("name", &self.name);
        formatter.field("value_list", &self.value_list);
        formatter.finish()
    }
}
/// See [`Filter`](crate::model::Filter)
pub mod filter {
    /// A builder for [`Filter`](crate::model::Filter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) value_list: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>For <code>ListEntities</code>, the supported value for this is an
        /// <code>EntityId</code>.</p>
        /// <p>For <code>ListChangeSets</code>, the supported values are as follows:</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>For <code>ListEntities</code>, the supported value for this is an
        /// <code>EntityId</code>.</p>
        /// <p>For <code>ListChangeSets</code>, the supported values are as follows:</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Appends an item to `value_list`.
        ///
        /// To override the contents of this collection use [`set_value_list`](Self::set_value_list).
        ///
        /// <p>
        /// <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
        ///
        /// <p>
        /// <code>ListChangeSets</code> - The supported filter names and associated
        /// <code>ValueList</code>s is as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of
        /// non-unique <code>ChangeSetName</code>s. These are defined when you call the
        /// <code>StartChangeSet</code> action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - The supported <code>ValueList</code> is a list of
        /// statuses for all change set requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EntityId</code> - The supported <code>ValueList</code> is a list of
        /// unique <code>EntityId</code>s.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list
        /// of all change sets that started before the filter value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list
        /// of all change sets that started after the filter value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of
        /// all change sets that ended before the filter value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of
        /// all change sets that ended after the filter value.</p>
        /// </li>
        /// </ul>
        pub fn value_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.value_list.unwrap_or_default();
            v.push(input.into());
            self.value_list = Some(v);
            self
        }
        /// <p>
        /// <code>ListEntities</code> - This is a list of unique <code>EntityId</code>s.</p>
        ///
        /// <p>
        /// <code>ListChangeSets</code> - The supported filter names and associated
        /// <code>ValueList</code>s is as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>ChangeSetName</code> - The supported <code>ValueList</code> is a list of
        /// non-unique <code>ChangeSetName</code>s. These are defined when you call the
        /// <code>StartChangeSet</code> action.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - The supported <code>ValueList</code> is a list of
        /// statuses for all change set requests.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EntityId</code> - The supported <code>ValueList</code> is a list of
        /// unique <code>EntityId</code>s.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BeforeStartTime</code> - The supported <code>ValueList</code> is a list
        /// of all change sets that started before the filter value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AfterStartTime</code> - The supported <code>ValueList</code> is a list
        /// of all change sets that started after the filter value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>BeforeEndTime</code> - The supported <code>ValueList</code> is a list of
        /// all change sets that ended before the filter value.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AfterEndTime</code> - The supported <code>ValueList</code> is a list of
        /// all change sets that ended after the filter value.</p>
        /// </li>
        /// </ul>
        pub fn set_value_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.value_list = input;
            self
        }
        /// Consumes the builder and constructs a [`Filter`](crate::model::Filter)
        pub fn build(self) -> crate::model::Filter {
            crate::model::Filter {
                name: self.name,
                value_list: self.value_list,
            }
        }
    }
}
impl Filter {
    /// Creates a new builder-style object to manufacture [`Filter`](crate::model::Filter)
    pub fn builder() -> crate::model::filter::Builder {
        crate::model::filter::Builder::default()
    }
}

/// <p>A summary of a change set returned in a list of change sets when the
/// <code>ListChangeSets</code> action is called.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeSetSummaryListItem {
    /// <p>The unique identifier for a change set.</p>
    pub change_set_id: std::option::Option<std::string::String>,
    /// <p>The ARN associated with the unique identifier for the change set referenced in this
    /// request.</p>
    pub change_set_arn: std::option::Option<std::string::String>,
    /// <p>The non-unique name for the change set.</p>
    pub change_set_name: std::option::Option<std::string::String>,
    /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
    /// started.</p>
    pub start_time: std::option::Option<std::string::String>,
    /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
    /// finished.</p>
    pub end_time: std::option::Option<std::string::String>,
    /// <p>The current status of the change set.</p>
    pub status: std::option::Option<crate::model::ChangeStatus>,
    /// <p>This object is a list of entity IDs (string) that are a part of a change set. The
    /// entity ID list is a maximum of 20 entities. It must contain at least one entity.</p>
    pub entity_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Returned if the change set is in <code>FAILED</code> status. Can be either
    /// <code>CLIENT_ERROR</code>, which means that there are issues with the request (see the
    /// <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>,
    /// which means that there is a problem in the system, and you should retry your request.</p>
    pub failure_code: std::option::Option<crate::model::FailureCode>,
}
impl ChangeSetSummaryListItem {
    /// <p>The unique identifier for a change set.</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
    /// <p>The ARN associated with the unique identifier for the change set referenced in this
    /// request.</p>
    pub fn change_set_arn(&self) -> std::option::Option<&str> {
        self.change_set_arn.as_deref()
    }
    /// <p>The non-unique name for the change set.</p>
    pub fn change_set_name(&self) -> std::option::Option<&str> {
        self.change_set_name.as_deref()
    }
    /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
    /// started.</p>
    pub fn start_time(&self) -> std::option::Option<&str> {
        self.start_time.as_deref()
    }
    /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
    /// finished.</p>
    pub fn end_time(&self) -> std::option::Option<&str> {
        self.end_time.as_deref()
    }
    /// <p>The current status of the change set.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ChangeStatus> {
        self.status.as_ref()
    }
    /// <p>This object is a list of entity IDs (string) that are a part of a change set. The
    /// entity ID list is a maximum of 20 entities. It must contain at least one entity.</p>
    pub fn entity_id_list(&self) -> std::option::Option<&[std::string::String]> {
        self.entity_id_list.as_deref()
    }
    /// <p>Returned if the change set is in <code>FAILED</code> status. Can be either
    /// <code>CLIENT_ERROR</code>, which means that there are issues with the request (see the
    /// <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>,
    /// which means that there is a problem in the system, and you should retry your request.</p>
    pub fn failure_code(&self) -> std::option::Option<&crate::model::FailureCode> {
        self.failure_code.as_ref()
    }
}
impl std::fmt::Debug for ChangeSetSummaryListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeSetSummaryListItem");
        formatter.field("change_set_id", &self.change_set_id);
        formatter.field("change_set_arn", &self.change_set_arn);
        formatter.field("change_set_name", &self.change_set_name);
        formatter.field("start_time", &self.start_time);
        formatter.field("end_time", &self.end_time);
        formatter.field("status", &self.status);
        formatter.field("entity_id_list", &self.entity_id_list);
        formatter.field("failure_code", &self.failure_code);
        formatter.finish()
    }
}
/// See [`ChangeSetSummaryListItem`](crate::model::ChangeSetSummaryListItem)
pub mod change_set_summary_list_item {
    /// A builder for [`ChangeSetSummaryListItem`](crate::model::ChangeSetSummaryListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_set_id: std::option::Option<std::string::String>,
        pub(crate) change_set_arn: std::option::Option<std::string::String>,
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) start_time: std::option::Option<std::string::String>,
        pub(crate) end_time: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ChangeStatus>,
        pub(crate) entity_id_list: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) failure_code: std::option::Option<crate::model::FailureCode>,
    }
    impl Builder {
        /// <p>The unique identifier for a change set.</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for a change set.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// <p>The ARN associated with the unique identifier for the change set referenced in this
        /// request.</p>
        pub fn change_set_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_arn = Some(input.into());
            self
        }
        /// <p>The ARN associated with the unique identifier for the change set referenced in this
        /// request.</p>
        pub fn set_change_set_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_arn = input;
            self
        }
        /// <p>The non-unique name for the change set.</p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>The non-unique name for the change set.</p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
        /// started.</p>
        pub fn start_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.start_time = Some(input.into());
            self
        }
        /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
        /// started.</p>
        pub fn set_start_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.start_time = input;
            self
        }
        /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
        /// finished.</p>
        pub fn end_time(mut self, input: impl Into<std::string::String>) -> Self {
            self.end_time = Some(input.into());
            self
        }
        /// <p>The time, in ISO 8601 format (2018-02-27T13:45:22Z), when the change set was
        /// finished.</p>
        pub fn set_end_time(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.end_time = input;
            self
        }
        /// <p>The current status of the change set.</p>
        pub fn status(mut self, input: crate::model::ChangeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the change set.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ChangeStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Appends an item to `entity_id_list`.
        ///
        /// To override the contents of this collection use [`set_entity_id_list`](Self::set_entity_id_list).
        ///
        /// <p>This object is a list of entity IDs (string) that are a part of a change set. The
        /// entity ID list is a maximum of 20 entities. It must contain at least one entity.</p>
        pub fn entity_id_list(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.entity_id_list.unwrap_or_default();
            v.push(input.into());
            self.entity_id_list = Some(v);
            self
        }
        /// <p>This object is a list of entity IDs (string) that are a part of a change set. The
        /// entity ID list is a maximum of 20 entities. It must contain at least one entity.</p>
        pub fn set_entity_id_list(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.entity_id_list = input;
            self
        }
        /// <p>Returned if the change set is in <code>FAILED</code> status. Can be either
        /// <code>CLIENT_ERROR</code>, which means that there are issues with the request (see the
        /// <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>,
        /// which means that there is a problem in the system, and you should retry your request.</p>
        pub fn failure_code(mut self, input: crate::model::FailureCode) -> Self {
            self.failure_code = Some(input);
            self
        }
        /// <p>Returned if the change set is in <code>FAILED</code> status. Can be either
        /// <code>CLIENT_ERROR</code>, which means that there are issues with the request (see the
        /// <code>ErrorDetailList</code> of <code>DescribeChangeSet</code>), or <code>SERVER_FAULT</code>,
        /// which means that there is a problem in the system, and you should retry your request.</p>
        pub fn set_failure_code(
            mut self,
            input: std::option::Option<crate::model::FailureCode>,
        ) -> Self {
            self.failure_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeSetSummaryListItem`](crate::model::ChangeSetSummaryListItem)
        pub fn build(self) -> crate::model::ChangeSetSummaryListItem {
            crate::model::ChangeSetSummaryListItem {
                change_set_id: self.change_set_id,
                change_set_arn: self.change_set_arn,
                change_set_name: self.change_set_name,
                start_time: self.start_time,
                end_time: self.end_time,
                status: self.status,
                entity_id_list: self.entity_id_list,
                failure_code: self.failure_code,
            }
        }
    }
}
impl ChangeSetSummaryListItem {
    /// Creates a new builder-style object to manufacture [`ChangeSetSummaryListItem`](crate::model::ChangeSetSummaryListItem)
    pub fn builder() -> crate::model::change_set_summary_list_item::Builder {
        crate::model::change_set_summary_list_item::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FailureCode {
    #[allow(missing_docs)] // documentation missing in model
    ClientError,
    #[allow(missing_docs)] // documentation missing in model
    ServerFault,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FailureCode {
    fn from(s: &str) -> Self {
        match s {
            "CLIENT_ERROR" => FailureCode::ClientError,
            "SERVER_FAULT" => FailureCode::ServerFault,
            other => FailureCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FailureCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FailureCode::from(s))
    }
}
impl FailureCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FailureCode::ClientError => "CLIENT_ERROR",
            FailureCode::ServerFault => "SERVER_FAULT",
            FailureCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLIENT_ERROR", "SERVER_FAULT"]
    }
}
impl AsRef<str> for FailureCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ChangeStatus {
    #[allow(missing_docs)] // documentation missing in model
    Applying,
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    Preparing,
    #[allow(missing_docs)] // documentation missing in model
    Succeeded,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ChangeStatus {
    fn from(s: &str) -> Self {
        match s {
            "APPLYING" => ChangeStatus::Applying,
            "CANCELLED" => ChangeStatus::Cancelled,
            "FAILED" => ChangeStatus::Failed,
            "PREPARING" => ChangeStatus::Preparing,
            "SUCCEEDED" => ChangeStatus::Succeeded,
            other => ChangeStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ChangeStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ChangeStatus::from(s))
    }
}
impl ChangeStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ChangeStatus::Applying => "APPLYING",
            ChangeStatus::Cancelled => "CANCELLED",
            ChangeStatus::Failed => "FAILED",
            ChangeStatus::Preparing => "PREPARING",
            ChangeStatus::Succeeded => "SUCCEEDED",
            ChangeStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["APPLYING", "CANCELLED", "FAILED", "PREPARING", "SUCCEEDED"]
    }
}
impl AsRef<str> for ChangeStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>This object is a container for common summary information about the change. The
/// summary doesn't contain the whole change structure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ChangeSummary {
    /// <p>The type of the change.</p>
    pub change_type: std::option::Option<std::string::String>,
    /// <p>The entity to be changed.</p>
    pub entity: std::option::Option<crate::model::Entity>,
    /// <p>This object contains details specific to the change type of the requested
    /// change.</p>
    pub details: std::option::Option<std::string::String>,
    /// <p>An array of <code>ErrorDetail</code> objects associated with the change.</p>
    pub error_detail_list: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
    /// <p>Optional name for the change.</p>
    pub change_name: std::option::Option<std::string::String>,
}
impl ChangeSummary {
    /// <p>The type of the change.</p>
    pub fn change_type(&self) -> std::option::Option<&str> {
        self.change_type.as_deref()
    }
    /// <p>The entity to be changed.</p>
    pub fn entity(&self) -> std::option::Option<&crate::model::Entity> {
        self.entity.as_ref()
    }
    /// <p>This object contains details specific to the change type of the requested
    /// change.</p>
    pub fn details(&self) -> std::option::Option<&str> {
        self.details.as_deref()
    }
    /// <p>An array of <code>ErrorDetail</code> objects associated with the change.</p>
    pub fn error_detail_list(&self) -> std::option::Option<&[crate::model::ErrorDetail]> {
        self.error_detail_list.as_deref()
    }
    /// <p>Optional name for the change.</p>
    pub fn change_name(&self) -> std::option::Option<&str> {
        self.change_name.as_deref()
    }
}
impl std::fmt::Debug for ChangeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ChangeSummary");
        formatter.field("change_type", &self.change_type);
        formatter.field("entity", &self.entity);
        formatter.field("details", &self.details);
        formatter.field("error_detail_list", &self.error_detail_list);
        formatter.field("change_name", &self.change_name);
        formatter.finish()
    }
}
/// See [`ChangeSummary`](crate::model::ChangeSummary)
pub mod change_summary {
    /// A builder for [`ChangeSummary`](crate::model::ChangeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) change_type: std::option::Option<std::string::String>,
        pub(crate) entity: std::option::Option<crate::model::Entity>,
        pub(crate) details: std::option::Option<std::string::String>,
        pub(crate) error_detail_list: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
        pub(crate) change_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The type of the change.</p>
        pub fn change_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_type = Some(input.into());
            self
        }
        /// <p>The type of the change.</p>
        pub fn set_change_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_type = input;
            self
        }
        /// <p>The entity to be changed.</p>
        pub fn entity(mut self, input: crate::model::Entity) -> Self {
            self.entity = Some(input);
            self
        }
        /// <p>The entity to be changed.</p>
        pub fn set_entity(mut self, input: std::option::Option<crate::model::Entity>) -> Self {
            self.entity = input;
            self
        }
        /// <p>This object contains details specific to the change type of the requested
        /// change.</p>
        pub fn details(mut self, input: impl Into<std::string::String>) -> Self {
            self.details = Some(input.into());
            self
        }
        /// <p>This object contains details specific to the change type of the requested
        /// change.</p>
        pub fn set_details(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.details = input;
            self
        }
        /// Appends an item to `error_detail_list`.
        ///
        /// To override the contents of this collection use [`set_error_detail_list`](Self::set_error_detail_list).
        ///
        /// <p>An array of <code>ErrorDetail</code> objects associated with the change.</p>
        pub fn error_detail_list(mut self, input: impl Into<crate::model::ErrorDetail>) -> Self {
            let mut v = self.error_detail_list.unwrap_or_default();
            v.push(input.into());
            self.error_detail_list = Some(v);
            self
        }
        /// <p>An array of <code>ErrorDetail</code> objects associated with the change.</p>
        pub fn set_error_detail_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ErrorDetail>>,
        ) -> Self {
            self.error_detail_list = input;
            self
        }
        /// <p>Optional name for the change.</p>
        pub fn change_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_name = Some(input.into());
            self
        }
        /// <p>Optional name for the change.</p>
        pub fn set_change_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.change_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ChangeSummary`](crate::model::ChangeSummary)
        pub fn build(self) -> crate::model::ChangeSummary {
            crate::model::ChangeSummary {
                change_type: self.change_type,
                entity: self.entity,
                details: self.details,
                error_detail_list: self.error_detail_list,
                change_name: self.change_name,
            }
        }
    }
}
impl ChangeSummary {
    /// Creates a new builder-style object to manufacture [`ChangeSummary`](crate::model::ChangeSummary)
    pub fn builder() -> crate::model::change_summary::Builder {
        crate::model::change_summary::Builder::default()
    }
}

/// <p>Details about the error.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ErrorDetail {
    /// <p>The error code that identifies the type of error.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The message for the error.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl ErrorDetail {
    /// <p>The error code that identifies the type of error.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The message for the error.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for ErrorDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ErrorDetail");
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`ErrorDetail`](crate::model::ErrorDetail)
pub mod error_detail {
    /// A builder for [`ErrorDetail`](crate::model::ErrorDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The error code that identifies the type of error.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The error code that identifies the type of error.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The message for the error.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The message for the error.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`ErrorDetail`](crate::model::ErrorDetail)
        pub fn build(self) -> crate::model::ErrorDetail {
            crate::model::ErrorDetail {
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl ErrorDetail {
    /// Creates a new builder-style object to manufacture [`ErrorDetail`](crate::model::ErrorDetail)
    pub fn builder() -> crate::model::error_detail::Builder {
        crate::model::error_detail::Builder::default()
    }
}
