// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CancelChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`cancel_change_set`](crate::client::Client::cancel_change_set).
///
/// See [`crate::client::fluent_builders::CancelChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CancelChangeSet {
    _private: (),
}
impl CancelChangeSet {
    /// Creates a new builder-style object to manufacture [`CancelChangeSetInput`](crate::input::CancelChangeSetInput)
    pub fn builder() -> crate::input::cancel_change_set_input::Builder {
        crate::input::cancel_change_set_input::Builder::default()
    }
    /// Creates a new `CancelChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CancelChangeSet {
    type Output = std::result::Result<
        crate::output::CancelChangeSetOutput,
        crate::error::CancelChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_cancel_change_set_error(response)
        } else {
            crate::operation_deser::parse_cancel_change_set_response(response)
        }
    }
}

/// Operation shape for `DescribeChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_change_set`](crate::client::Client::describe_change_set).
///
/// See [`crate::client::fluent_builders::DescribeChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeChangeSet {
    _private: (),
}
impl DescribeChangeSet {
    /// Creates a new builder-style object to manufacture [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
    pub fn builder() -> crate::input::describe_change_set_input::Builder {
        crate::input::describe_change_set_input::Builder::default()
    }
    /// Creates a new `DescribeChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeChangeSet {
    type Output = std::result::Result<
        crate::output::DescribeChangeSetOutput,
        crate::error::DescribeChangeSetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_change_set_error(response)
        } else {
            crate::operation_deser::parse_describe_change_set_response(response)
        }
    }
}

/// Operation shape for `DescribeEntity`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_entity`](crate::client::Client::describe_entity).
///
/// See [`crate::client::fluent_builders::DescribeEntity`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeEntity {
    _private: (),
}
impl DescribeEntity {
    /// Creates a new builder-style object to manufacture [`DescribeEntityInput`](crate::input::DescribeEntityInput)
    pub fn builder() -> crate::input::describe_entity_input::Builder {
        crate::input::describe_entity_input::Builder::default()
    }
    /// Creates a new `DescribeEntity` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeEntity {
    type Output =
        std::result::Result<crate::output::DescribeEntityOutput, crate::error::DescribeEntityError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_entity_error(response)
        } else {
            crate::operation_deser::parse_describe_entity_response(response)
        }
    }
}

/// Operation shape for `ListChangeSets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_change_sets`](crate::client::Client::list_change_sets).
///
/// See [`crate::client::fluent_builders::ListChangeSets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListChangeSets {
    _private: (),
}
impl ListChangeSets {
    /// Creates a new builder-style object to manufacture [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
    pub fn builder() -> crate::input::list_change_sets_input::Builder {
        crate::input::list_change_sets_input::Builder::default()
    }
    /// Creates a new `ListChangeSets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListChangeSets {
    type Output =
        std::result::Result<crate::output::ListChangeSetsOutput, crate::error::ListChangeSetsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_change_sets_error(response)
        } else {
            crate::operation_deser::parse_list_change_sets_response(response)
        }
    }
}

/// Operation shape for `ListEntities`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_entities`](crate::client::Client::list_entities).
///
/// See [`crate::client::fluent_builders::ListEntities`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListEntities {
    _private: (),
}
impl ListEntities {
    /// Creates a new builder-style object to manufacture [`ListEntitiesInput`](crate::input::ListEntitiesInput)
    pub fn builder() -> crate::input::list_entities_input::Builder {
        crate::input::list_entities_input::Builder::default()
    }
    /// Creates a new `ListEntities` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListEntities {
    type Output =
        std::result::Result<crate::output::ListEntitiesOutput, crate::error::ListEntitiesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_entities_error(response)
        } else {
            crate::operation_deser::parse_list_entities_response(response)
        }
    }
}

/// Operation shape for `StartChangeSet`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_change_set`](crate::client::Client::start_change_set).
///
/// See [`crate::client::fluent_builders::StartChangeSet`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartChangeSet {
    _private: (),
}
impl StartChangeSet {
    /// Creates a new builder-style object to manufacture [`StartChangeSetInput`](crate::input::StartChangeSetInput)
    pub fn builder() -> crate::input::start_change_set_input::Builder {
        crate::input::start_change_set_input::Builder::default()
    }
    /// Creates a new `StartChangeSet` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartChangeSet {
    type Output =
        std::result::Result<crate::output::StartChangeSetOutput, crate::error::StartChangeSetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_change_set_error(response)
        } else {
            crate::operation_deser::parse_start_change_set_response(response)
        }
    }
}
