// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CancelChangeSetInput`](crate::input::CancelChangeSetInput)
pub mod cancel_change_set_input {
    /// A builder for [`CancelChangeSetInput`](crate::input::CancelChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) change_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>.</p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>.</p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// <p>Required. The unique identifier of the <code>StartChangeSet</code> request that you
        /// want to cancel.</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>Required. The unique identifier of the <code>StartChangeSet</code> request that you
        /// want to cancel.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CancelChangeSetInput`](crate::input::CancelChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CancelChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CancelChangeSetInput {
                catalog: self.catalog,
                change_set_id: self.change_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CancelChangeSetInputOperationOutputAlias = crate::operation::CancelChangeSet;
#[doc(hidden)]
pub type CancelChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CancelChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`CancelChangeSet`](crate::operation::CancelChangeSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CancelChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CancelChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/CancelChangeSet").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::CancelChangeSetInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_1) = &_input.catalog {
                query.push_kv("catalog", &aws_smithy_http::query::fmt_string(&inner_1));
            }
            if let Some(inner_2) = &_input.change_set_id {
                query.push_kv("changeSetId", &aws_smithy_http::query::fmt_string(&inner_2));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CancelChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CancelChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CancelChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CancelChangeSet",
            "marketplacecatalog",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CancelChangeSetInput`](crate::input::CancelChangeSetInput)
    pub fn builder() -> crate::input::cancel_change_set_input::Builder {
        crate::input::cancel_change_set_input::Builder::default()
    }
}

/// See [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
pub mod describe_change_set_input {
    /// A builder for [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) change_set_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// <p>Required. The unique identifier for the <code>StartChangeSet</code> request that you
        /// want to describe the details for.</p>
        pub fn change_set_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_id = Some(input.into());
            self
        }
        /// <p>Required. The unique identifier for the <code>StartChangeSet</code> request that you
        /// want to describe the details for.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeChangeSetInput {
                catalog: self.catalog,
                change_set_id: self.change_set_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeChangeSetInputOperationOutputAlias = crate::operation::DescribeChangeSet;
#[doc(hidden)]
pub type DescribeChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeChangeSet`](crate::operation::DescribeChangeSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeChangeSet").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeChangeSetInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_3) = &_input.catalog {
                query.push_kv("catalog", &aws_smithy_http::query::fmt_string(&inner_3));
            }
            if let Some(inner_4) = &_input.change_set_id {
                query.push_kv("changeSetId", &aws_smithy_http::query::fmt_string(&inner_4));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeChangeSet",
            "marketplacecatalog",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeChangeSetInput`](crate::input::DescribeChangeSetInput)
    pub fn builder() -> crate::input::describe_change_set_input::Builder {
        crate::input::describe_change_set_input::Builder::default()
    }
}

/// See [`DescribeEntityInput`](crate::input::DescribeEntityInput)
pub mod describe_entity_input {
    /// A builder for [`DescribeEntityInput`](crate::input::DescribeEntityInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) entity_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// <p>Required. The unique ID of the entity to describe.</p>
        pub fn entity_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_id = Some(input.into());
            self
        }
        /// <p>Required. The unique ID of the entity to describe.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEntityInput`](crate::input::DescribeEntityInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEntityInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEntityInput {
                catalog: self.catalog,
                entity_id: self.entity_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEntityInputOperationOutputAlias = crate::operation::DescribeEntity;
#[doc(hidden)]
pub type DescribeEntityInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEntityInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEntity`](crate::operation::DescribeEntity)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEntity,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEntityInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/DescribeEntity").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(_input: &crate::input::DescribeEntityInput, mut output: &mut String) {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.catalog {
                query.push_kv("catalog", &aws_smithy_http::query::fmt_string(&inner_5));
            }
            if let Some(inner_6) = &_input.entity_id {
                query.push_kv("entityId", &aws_smithy_http::query::fmt_string(&inner_6));
            }
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEntityInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri);
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEntityInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEntity::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEntity",
            "marketplacecatalog",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEntityInput`](crate::input::DescribeEntityInput)
    pub fn builder() -> crate::input::describe_entity_input::Builder {
        crate::input::describe_entity_input::Builder::default()
    }
}

/// See [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
pub mod list_change_sets_input {
    /// A builder for [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) filter_list: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort: std::option::Option<crate::model::Sort>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// Appends an item to `filter_list`.
        ///
        /// To override the contents of this collection use [`set_filter_list`](Self::set_filter_list).
        ///
        /// <p>An array of filter objects.</p>
        pub fn filter_list(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filter_list.unwrap_or_default();
            v.push(input.into());
            self.filter_list = Some(v);
            self
        }
        /// <p>An array of filter objects.</p>
        pub fn set_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filter_list = input;
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn sort(mut self, input: crate::model::Sort) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::Sort>) -> Self {
            self.sort = input;
            self
        }
        /// <p>The maximum number of results returned by a single call. This value must be provided
        /// in the next call to retrieve the next set of results. By default, this value is
        /// 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results returned by a single call. This value must be provided
        /// in the next call to retrieve the next set of results. By default, this value is
        /// 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of
        /// results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListChangeSetsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListChangeSetsInput {
                catalog: self.catalog,
                filter_list: self.filter_list,
                sort: self.sort,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListChangeSetsInputOperationOutputAlias = crate::operation::ListChangeSets;
#[doc(hidden)]
pub type ListChangeSetsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListChangeSetsInput {
    /// Consumes the builder and constructs an Operation<[`ListChangeSets`](crate::operation::ListChangeSets)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListChangeSets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListChangeSetsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListChangeSets").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListChangeSetsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListChangeSetsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_change_sets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListChangeSets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListChangeSets",
            "marketplacecatalog",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListChangeSetsInput`](crate::input::ListChangeSetsInput)
    pub fn builder() -> crate::input::list_change_sets_input::Builder {
        crate::input::list_change_sets_input::Builder::default()
    }
}

/// See [`ListEntitiesInput`](crate::input::ListEntitiesInput)
pub mod list_entities_input {
    /// A builder for [`ListEntitiesInput`](crate::input::ListEntitiesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) entity_type: std::option::Option<std::string::String>,
        pub(crate) filter_list: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        pub(crate) sort: std::option::Option<crate::model::Sort>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// <p>The type of entities to retrieve.</p>
        pub fn entity_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.entity_type = Some(input.into());
            self
        }
        /// <p>The type of entities to retrieve.</p>
        pub fn set_entity_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.entity_type = input;
            self
        }
        /// Appends an item to `filter_list`.
        ///
        /// To override the contents of this collection use [`set_filter_list`](Self::set_filter_list).
        ///
        /// <p>An array of filter objects. Each filter object contains two attributes,
        /// <code>filterName</code> and <code>filterValues</code>.</p>
        pub fn filter_list(mut self, input: impl Into<crate::model::Filter>) -> Self {
            let mut v = self.filter_list.unwrap_or_default();
            v.push(input.into());
            self.filter_list = Some(v);
            self
        }
        /// <p>An array of filter objects. Each filter object contains two attributes,
        /// <code>filterName</code> and <code>filterValues</code>.</p>
        pub fn set_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.filter_list = input;
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn sort(mut self, input: crate::model::Sort) -> Self {
            self.sort = Some(input);
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::Sort>) -> Self {
            self.sort = input;
            self
        }
        /// <p>The value of the next token, if it exists. Null if there are no more results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The value of the next token, if it exists. Null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies the upper limit of the elements on a single page. If a value isn't provided,
        /// the default value is 20.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>Specifies the upper limit of the elements on a single page. If a value isn't provided,
        /// the default value is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListEntitiesInput`](crate::input::ListEntitiesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListEntitiesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListEntitiesInput {
                catalog: self.catalog,
                entity_type: self.entity_type,
                filter_list: self.filter_list,
                sort: self.sort,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListEntitiesInputOperationOutputAlias = crate::operation::ListEntities;
#[doc(hidden)]
pub type ListEntitiesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListEntitiesInput {
    /// Consumes the builder and constructs an Operation<[`ListEntities`](crate::operation::ListEntities)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListEntities,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListEntitiesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/ListEntities").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListEntitiesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListEntitiesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_entities(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListEntities::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListEntities",
            "marketplacecatalog",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListEntitiesInput`](crate::input::ListEntitiesInput)
    pub fn builder() -> crate::input::list_entities_input::Builder {
        crate::input::list_entities_input::Builder::default()
    }
}

/// See [`StartChangeSetInput`](crate::input::StartChangeSetInput)
pub mod start_change_set_input {
    /// A builder for [`StartChangeSetInput`](crate::input::StartChangeSetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) catalog: std::option::Option<std::string::String>,
        pub(crate) change_set: std::option::Option<std::vec::Vec<crate::model::Change>>,
        pub(crate) change_set_name: std::option::Option<std::string::String>,
        pub(crate) client_request_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, input: impl Into<std::string::String>) -> Self {
            self.catalog = Some(input.into());
            self
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.catalog = input;
            self
        }
        /// Appends an item to `change_set`.
        ///
        /// To override the contents of this collection use [`set_change_set`](Self::set_change_set).
        ///
        /// <p>Array of <code>change</code> object.</p>
        pub fn change_set(mut self, input: impl Into<crate::model::Change>) -> Self {
            let mut v = self.change_set.unwrap_or_default();
            v.push(input.into());
            self.change_set = Some(v);
            self
        }
        /// <p>Array of <code>change</code> object.</p>
        pub fn set_change_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Change>>,
        ) -> Self {
            self.change_set = input;
            self
        }
        /// <p>Optional case sensitive string of up to 100 ASCII characters. The change set name can
        /// be used to filter the list of change sets. </p>
        pub fn change_set_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.change_set_name = Some(input.into());
            self
        }
        /// <p>Optional case sensitive string of up to 100 ASCII characters. The change set name can
        /// be used to filter the list of change sets. </p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.change_set_name = input;
            self
        }
        /// <p>A unique token to identify the request to ensure idempotency.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique token to identify the request to ensure idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartChangeSetInput`](crate::input::StartChangeSetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartChangeSetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartChangeSetInput {
                catalog: self.catalog,
                change_set: self.change_set,
                change_set_name: self.change_set_name,
                client_request_token: self.client_request_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartChangeSetInputOperationOutputAlias = crate::operation::StartChangeSet;
#[doc(hidden)]
pub type StartChangeSetInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl StartChangeSetInput {
    /// Consumes the builder and constructs an Operation<[`StartChangeSet`](crate::operation::StartChangeSet)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartChangeSet,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::StartChangeSetInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/StartChangeSet").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::StartChangeSetInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::StartChangeSetInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_start_change_set(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartChangeSet::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartChangeSet",
            "marketplacecatalog",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`StartChangeSetInput`](crate::input::StartChangeSetInput)
    pub fn builder() -> crate::input::start_change_set_input::Builder {
        crate::input::start_change_set_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartChangeSetInput {
    /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
    /// </p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>Array of <code>change</code> object.</p>
    pub change_set: std::option::Option<std::vec::Vec<crate::model::Change>>,
    /// <p>Optional case sensitive string of up to 100 ASCII characters. The change set name can
    /// be used to filter the list of change sets. </p>
    pub change_set_name: std::option::Option<std::string::String>,
    /// <p>A unique token to identify the request to ensure idempotency.</p>
    pub client_request_token: std::option::Option<std::string::String>,
}
impl StartChangeSetInput {
    /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
    /// </p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>Array of <code>change</code> object.</p>
    pub fn change_set(&self) -> std::option::Option<&[crate::model::Change]> {
        self.change_set.as_deref()
    }
    /// <p>Optional case sensitive string of up to 100 ASCII characters. The change set name can
    /// be used to filter the list of change sets. </p>
    pub fn change_set_name(&self) -> std::option::Option<&str> {
        self.change_set_name.as_deref()
    }
    /// <p>A unique token to identify the request to ensure idempotency.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
}
impl std::fmt::Debug for StartChangeSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartChangeSetInput");
        formatter.field("catalog", &self.catalog);
        formatter.field("change_set", &self.change_set);
        formatter.field("change_set_name", &self.change_set_name);
        formatter.field("client_request_token", &self.client_request_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListEntitiesInput {
    /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
    /// </p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>The type of entities to retrieve.</p>
    pub entity_type: std::option::Option<std::string::String>,
    /// <p>An array of filter objects. Each filter object contains two attributes,
    /// <code>filterName</code> and <code>filterValues</code>.</p>
    pub filter_list: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>An object that contains two attributes, <code>SortBy</code> and
    /// <code>SortOrder</code>.</p>
    pub sort: std::option::Option<crate::model::Sort>,
    /// <p>The value of the next token, if it exists. Null if there are no more results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies the upper limit of the elements on a single page. If a value isn't provided,
    /// the default value is 20.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListEntitiesInput {
    /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
    /// </p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>The type of entities to retrieve.</p>
    pub fn entity_type(&self) -> std::option::Option<&str> {
        self.entity_type.as_deref()
    }
    /// <p>An array of filter objects. Each filter object contains two attributes,
    /// <code>filterName</code> and <code>filterValues</code>.</p>
    pub fn filter_list(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filter_list.as_deref()
    }
    /// <p>An object that contains two attributes, <code>SortBy</code> and
    /// <code>SortOrder</code>.</p>
    pub fn sort(&self) -> std::option::Option<&crate::model::Sort> {
        self.sort.as_ref()
    }
    /// <p>The value of the next token, if it exists. Null if there are no more results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies the upper limit of the elements on a single page. If a value isn't provided,
    /// the default value is 20.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListEntitiesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListEntitiesInput");
        formatter.field("catalog", &self.catalog);
        formatter.field("entity_type", &self.entity_type);
        formatter.field("filter_list", &self.filter_list);
        formatter.field("sort", &self.sort);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListChangeSetsInput {
    /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
    /// </p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>An array of filter objects.</p>
    pub filter_list: std::option::Option<std::vec::Vec<crate::model::Filter>>,
    /// <p>An object that contains two attributes, <code>SortBy</code> and
    /// <code>SortOrder</code>.</p>
    pub sort: std::option::Option<crate::model::Sort>,
    /// <p>The maximum number of results returned by a single call. This value must be provided
    /// in the next call to retrieve the next set of results. By default, this value is
    /// 20.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The token value retrieved from a previous call to access the next page of
    /// results.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListChangeSetsInput {
    /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
    /// </p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>An array of filter objects.</p>
    pub fn filter_list(&self) -> std::option::Option<&[crate::model::Filter]> {
        self.filter_list.as_deref()
    }
    /// <p>An object that contains two attributes, <code>SortBy</code> and
    /// <code>SortOrder</code>.</p>
    pub fn sort(&self) -> std::option::Option<&crate::model::Sort> {
        self.sort.as_ref()
    }
    /// <p>The maximum number of results returned by a single call. This value must be provided
    /// in the next call to retrieve the next set of results. By default, this value is
    /// 20.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The token value retrieved from a previous call to access the next page of
    /// results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListChangeSetsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListChangeSetsInput");
        formatter.field("catalog", &self.catalog);
        formatter.field("filter_list", &self.filter_list);
        formatter.field("sort", &self.sort);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEntityInput {
    /// <p>Required. The catalog related to the request. Fixed value:
    /// <code>AWSMarketplace</code>
    /// </p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>Required. The unique ID of the entity to describe.</p>
    pub entity_id: std::option::Option<std::string::String>,
}
impl DescribeEntityInput {
    /// <p>Required. The catalog related to the request. Fixed value:
    /// <code>AWSMarketplace</code>
    /// </p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>Required. The unique ID of the entity to describe.</p>
    pub fn entity_id(&self) -> std::option::Option<&str> {
        self.entity_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeEntityInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEntityInput");
        formatter.field("catalog", &self.catalog);
        formatter.field("entity_id", &self.entity_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeChangeSetInput {
    /// <p>Required. The catalog related to the request. Fixed value:
    /// <code>AWSMarketplace</code>
    /// </p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>Required. The unique identifier for the <code>StartChangeSet</code> request that you
    /// want to describe the details for.</p>
    pub change_set_id: std::option::Option<std::string::String>,
}
impl DescribeChangeSetInput {
    /// <p>Required. The catalog related to the request. Fixed value:
    /// <code>AWSMarketplace</code>
    /// </p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>Required. The unique identifier for the <code>StartChangeSet</code> request that you
    /// want to describe the details for.</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeChangeSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeChangeSetInput");
        formatter.field("catalog", &self.catalog);
        formatter.field("change_set_id", &self.change_set_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CancelChangeSetInput {
    /// <p>Required. The catalog related to the request. Fixed value:
    /// <code>AWSMarketplace</code>.</p>
    pub catalog: std::option::Option<std::string::String>,
    /// <p>Required. The unique identifier of the <code>StartChangeSet</code> request that you
    /// want to cancel.</p>
    pub change_set_id: std::option::Option<std::string::String>,
}
impl CancelChangeSetInput {
    /// <p>Required. The catalog related to the request. Fixed value:
    /// <code>AWSMarketplace</code>.</p>
    pub fn catalog(&self) -> std::option::Option<&str> {
        self.catalog.as_deref()
    }
    /// <p>Required. The unique identifier of the <code>StartChangeSet</code> request that you
    /// want to cancel.</p>
    pub fn change_set_id(&self) -> std::option::Option<&str> {
        self.change_set_id.as_deref()
    }
}
impl std::fmt::Debug for CancelChangeSetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CancelChangeSetInput");
        formatter.field("catalog", &self.catalog);
        formatter.field("change_set_id", &self.change_set_id);
        formatter.finish()
    }
}
