// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AWSMPSeymour`.
///
/// This client allows ergonomic access to a `AWSMPSeymour`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CancelChangeSet` operation.
    ///
    /// See [`CancelChangeSet`](crate::client::fluent_builders::CancelChangeSet) for more information about the
    /// operation and its arguments.
    pub fn cancel_change_set(&self) -> fluent_builders::CancelChangeSet<C, M, R> {
        fluent_builders::CancelChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeChangeSet` operation.
    ///
    /// See [`DescribeChangeSet`](crate::client::fluent_builders::DescribeChangeSet) for more information about the
    /// operation and its arguments.
    pub fn describe_change_set(&self) -> fluent_builders::DescribeChangeSet<C, M, R> {
        fluent_builders::DescribeChangeSet::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEntity` operation.
    ///
    /// See [`DescribeEntity`](crate::client::fluent_builders::DescribeEntity) for more information about the
    /// operation and its arguments.
    pub fn describe_entity(&self) -> fluent_builders::DescribeEntity<C, M, R> {
        fluent_builders::DescribeEntity::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListChangeSets` operation.
    ///
    /// See [`ListChangeSets`](crate::client::fluent_builders::ListChangeSets) for more information about the
    /// operation and its arguments.
    pub fn list_change_sets(&self) -> fluent_builders::ListChangeSets<C, M, R> {
        fluent_builders::ListChangeSets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListEntities` operation.
    ///
    /// See [`ListEntities`](crate::client::fluent_builders::ListEntities) for more information about the
    /// operation and its arguments.
    pub fn list_entities(&self) -> fluent_builders::ListEntities<C, M, R> {
        fluent_builders::ListEntities::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartChangeSet` operation.
    ///
    /// See [`StartChangeSet`](crate::client::fluent_builders::StartChangeSet) for more information about the
    /// operation and its arguments.
    pub fn start_change_set(&self) -> fluent_builders::StartChangeSet<C, M, R> {
        fluent_builders::StartChangeSet::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CancelChangeSet`.
    ///
    /// <p>Used to cancel an open change request. Must be sent before the status of the request
    /// changes to <code>APPLYING</code>, the final stage of completing your change request. You
    /// can describe a change during the 60-day request history retention period for API
    /// calls.</p>
    #[derive(std::fmt::Debug)]
    pub struct CancelChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::cancel_change_set_input::Builder,
    }
    impl<C, M, R> CancelChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CancelChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CancelChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::CancelChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CancelChangeSetInputOperationOutputAlias,
                crate::output::CancelChangeSetOutput,
                crate::error::CancelChangeSetError,
                crate::input::CancelChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>.</p>
        pub fn catalog(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog(inp);
            self
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>.</p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog(input);
            self
        }
        /// <p>Required. The unique identifier of the <code>StartChangeSet</code> request that you
        /// want to cancel.</p>
        pub fn change_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_id(inp);
            self
        }
        /// <p>Required. The unique identifier of the <code>StartChangeSet</code> request that you
        /// want to cancel.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeChangeSet`.
    ///
    /// <p>Provides information about a given change set.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_change_set_input::Builder,
    }
    impl<C, M, R> DescribeChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeChangeSetInputOperationOutputAlias,
                crate::output::DescribeChangeSetOutput,
                crate::error::DescribeChangeSetError,
                crate::input::DescribeChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog(inp);
            self
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog(input);
            self
        }
        /// <p>Required. The unique identifier for the <code>StartChangeSet</code> request that you
        /// want to describe the details for.</p>
        pub fn change_set_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_id(inp);
            self
        }
        /// <p>Required. The unique identifier for the <code>StartChangeSet</code> request that you
        /// want to describe the details for.</p>
        pub fn set_change_set_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEntity`.
    ///
    /// <p>Returns the metadata and content of the entity.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEntity<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_entity_input::Builder,
    }
    impl<C, M, R> DescribeEntity<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEntity`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEntityOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEntityError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEntityInputOperationOutputAlias,
                crate::output::DescribeEntityOutput,
                crate::error::DescribeEntityError,
                crate::input::DescribeEntityInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog(inp);
            self
        }
        /// <p>Required. The catalog related to the request. Fixed value:
        /// <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog(input);
            self
        }
        /// <p>Required. The unique ID of the entity to describe.</p>
        pub fn entity_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_id(inp);
            self
        }
        /// <p>Required. The unique ID of the entity to describe.</p>
        pub fn set_entity_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListChangeSets`.
    ///
    /// <p>Returns the list of change sets owned by the account being used to make the call. You
    /// can filter this list by providing any combination of <code>entityId</code>,
    /// <code>ChangeSetName</code>, and status. If you provide more than one filter, the API
    /// operation applies a logical AND between the filters.</p>
    ///
    /// <p>You can describe a change during the 60-day request history retention period for API
    /// calls.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListChangeSets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_change_sets_input::Builder,
    }
    impl<C, M, R> ListChangeSets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListChangeSets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListChangeSetsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListChangeSetsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListChangeSetsInputOperationOutputAlias,
                crate::output::ListChangeSetsOutput,
                crate::error::ListChangeSetsError,
                crate::input::ListChangeSetsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog(inp);
            self
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog(input);
            self
        }
        /// Appends an item to `FilterList`.
        ///
        /// To override the contents of this collection use [`set_filter_list`](Self::set_filter_list).
        ///
        /// <p>An array of filter objects.</p>
        pub fn filter_list(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filter_list(inp);
            self
        }
        /// <p>An array of filter objects.</p>
        pub fn set_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filter_list(input);
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn sort(mut self, inp: crate::model::Sort) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::Sort>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>The maximum number of results returned by a single call. This value must be provided
        /// in the next call to retrieve the next set of results. By default, this value is
        /// 20.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results returned by a single call. This value must be provided
        /// in the next call to retrieve the next set of results. By default, this value is
        /// 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of
        /// results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The token value retrieved from a previous call to access the next page of
        /// results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListEntities`.
    ///
    /// <p>Provides the list of entities of a given type.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListEntities<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_entities_input::Builder,
    }
    impl<C, M, R> ListEntities<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListEntities`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListEntitiesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListEntitiesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListEntitiesInputOperationOutputAlias,
                crate::output::ListEntitiesOutput,
                crate::error::ListEntitiesError,
                crate::input::ListEntitiesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog(inp);
            self
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog(input);
            self
        }
        /// <p>The type of entities to retrieve.</p>
        pub fn entity_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.entity_type(inp);
            self
        }
        /// <p>The type of entities to retrieve.</p>
        pub fn set_entity_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_entity_type(input);
            self
        }
        /// Appends an item to `FilterList`.
        ///
        /// To override the contents of this collection use [`set_filter_list`](Self::set_filter_list).
        ///
        /// <p>An array of filter objects. Each filter object contains two attributes,
        /// <code>filterName</code> and <code>filterValues</code>.</p>
        pub fn filter_list(mut self, inp: impl Into<crate::model::Filter>) -> Self {
            self.inner = self.inner.filter_list(inp);
            self
        }
        /// <p>An array of filter objects. Each filter object contains two attributes,
        /// <code>filterName</code> and <code>filterValues</code>.</p>
        pub fn set_filter_list(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Filter>>,
        ) -> Self {
            self.inner = self.inner.set_filter_list(input);
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn sort(mut self, inp: crate::model::Sort) -> Self {
            self.inner = self.inner.sort(inp);
            self
        }
        /// <p>An object that contains two attributes, <code>SortBy</code> and
        /// <code>SortOrder</code>.</p>
        pub fn set_sort(mut self, input: std::option::Option<crate::model::Sort>) -> Self {
            self.inner = self.inner.set_sort(input);
            self
        }
        /// <p>The value of the next token, if it exists. Null if there are no more results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The value of the next token, if it exists. Null if there are no more results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies the upper limit of the elements on a single page. If a value isn't provided,
        /// the default value is 20.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>Specifies the upper limit of the elements on a single page. If a value isn't provided,
        /// the default value is 20.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartChangeSet`.
    ///
    /// <p>This operation allows you to request changes for your entities. Within a single
    /// ChangeSet, you cannot start the same change type against the same entity multiple times.
    /// Additionally, when a ChangeSet is running, all the entities targeted by the different
    /// changes are locked until the ChangeSet has completed (either succeeded, cancelled, or failed). If
    /// you try to start a ChangeSet containing a change against an entity that is already
    /// locked, you will receive a <code>ResourceInUseException</code>.</p>
    ///
    /// <p>For example, you cannot start the ChangeSet described in the <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_StartChangeSet.html#API_StartChangeSet_Examples">example</a> later in this topic, because it contains two changes to execute the same change
    /// type (<code>AddRevisions</code>) against the same entity
    /// (<code>entity-id@1)</code>.</p>
    ///
    /// <p>For more information about working with change sets, see <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/welcome.html#working-with-change-sets">
    /// Working with change sets</a>.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartChangeSet<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_change_set_input::Builder,
    }
    impl<C, M, R> StartChangeSet<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartChangeSet`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartChangeSetOutput,
            aws_smithy_http::result::SdkError<crate::error::StartChangeSetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartChangeSetInputOperationOutputAlias,
                crate::output::StartChangeSetOutput,
                crate::error::StartChangeSetError,
                crate::input::StartChangeSetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn catalog(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.catalog(inp);
            self
        }
        /// <p>The catalog related to the request. Fixed value: <code>AWSMarketplace</code>
        /// </p>
        pub fn set_catalog(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_catalog(input);
            self
        }
        /// Appends an item to `ChangeSet`.
        ///
        /// To override the contents of this collection use [`set_change_set`](Self::set_change_set).
        ///
        /// <p>Array of <code>change</code> object.</p>
        pub fn change_set(mut self, inp: impl Into<crate::model::Change>) -> Self {
            self.inner = self.inner.change_set(inp);
            self
        }
        /// <p>Array of <code>change</code> object.</p>
        pub fn set_change_set(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Change>>,
        ) -> Self {
            self.inner = self.inner.set_change_set(input);
            self
        }
        /// <p>Optional case sensitive string of up to 100 ASCII characters. The change set name can
        /// be used to filter the list of change sets. </p>
        pub fn change_set_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.change_set_name(inp);
            self
        }
        /// <p>Optional case sensitive string of up to 100 ASCII characters. The change set name can
        /// be used to filter the list of change sets. </p>
        pub fn set_change_set_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_change_set_name(input);
            self
        }
        /// <p>A unique token to identify the request to ensure idempotency.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique token to identify the request to ensure idempotency.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
