// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_member`](crate::client::Client::create_member).
///
/// See [`crate::client::fluent_builders::CreateMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMember {
    _private: (),
}
impl CreateMember {
    /// Creates a new builder-style object to manufacture [`CreateMemberInput`](crate::input::CreateMemberInput)
    pub fn builder() -> crate::input::create_member_input::Builder {
        crate::input::create_member_input::Builder::default()
    }
    /// Creates a new `CreateMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMember {
    type Output =
        std::result::Result<crate::output::CreateMemberOutput, crate::error::CreateMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_member_error(response)
        } else {
            crate::operation_deser::parse_create_member_response(response)
        }
    }
}

/// Operation shape for `CreateNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_network`](crate::client::Client::create_network).
///
/// See [`crate::client::fluent_builders::CreateNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNetwork {
    _private: (),
}
impl CreateNetwork {
    /// Creates a new builder-style object to manufacture [`CreateNetworkInput`](crate::input::CreateNetworkInput)
    pub fn builder() -> crate::input::create_network_input::Builder {
        crate::input::create_network_input::Builder::default()
    }
    /// Creates a new `CreateNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNetwork {
    type Output =
        std::result::Result<crate::output::CreateNetworkOutput, crate::error::CreateNetworkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_network_error(response)
        } else {
            crate::operation_deser::parse_create_network_response(response)
        }
    }
}

/// Operation shape for `CreateNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_node`](crate::client::Client::create_node).
///
/// See [`crate::client::fluent_builders::CreateNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateNode {
    _private: (),
}
impl CreateNode {
    /// Creates a new builder-style object to manufacture [`CreateNodeInput`](crate::input::CreateNodeInput)
    pub fn builder() -> crate::input::create_node_input::Builder {
        crate::input::create_node_input::Builder::default()
    }
    /// Creates a new `CreateNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateNode {
    type Output =
        std::result::Result<crate::output::CreateNodeOutput, crate::error::CreateNodeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_node_error(response)
        } else {
            crate::operation_deser::parse_create_node_response(response)
        }
    }
}

/// Operation shape for `CreateProposal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_proposal`](crate::client::Client::create_proposal).
///
/// See [`crate::client::fluent_builders::CreateProposal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProposal {
    _private: (),
}
impl CreateProposal {
    /// Creates a new builder-style object to manufacture [`CreateProposalInput`](crate::input::CreateProposalInput)
    pub fn builder() -> crate::input::create_proposal_input::Builder {
        crate::input::create_proposal_input::Builder::default()
    }
    /// Creates a new `CreateProposal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProposal {
    type Output =
        std::result::Result<crate::output::CreateProposalOutput, crate::error::CreateProposalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_proposal_error(response)
        } else {
            crate::operation_deser::parse_create_proposal_response(response)
        }
    }
}

/// Operation shape for `DeleteMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_member`](crate::client::Client::delete_member).
///
/// See [`crate::client::fluent_builders::DeleteMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMember {
    _private: (),
}
impl DeleteMember {
    /// Creates a new builder-style object to manufacture [`DeleteMemberInput`](crate::input::DeleteMemberInput)
    pub fn builder() -> crate::input::delete_member_input::Builder {
        crate::input::delete_member_input::Builder::default()
    }
    /// Creates a new `DeleteMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMember {
    type Output =
        std::result::Result<crate::output::DeleteMemberOutput, crate::error::DeleteMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_member_error(response)
        } else {
            crate::operation_deser::parse_delete_member_response(response)
        }
    }
}

/// Operation shape for `DeleteNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_node`](crate::client::Client::delete_node).
///
/// See [`crate::client::fluent_builders::DeleteNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteNode {
    _private: (),
}
impl DeleteNode {
    /// Creates a new builder-style object to manufacture [`DeleteNodeInput`](crate::input::DeleteNodeInput)
    pub fn builder() -> crate::input::delete_node_input::Builder {
        crate::input::delete_node_input::Builder::default()
    }
    /// Creates a new `DeleteNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteNode {
    type Output =
        std::result::Result<crate::output::DeleteNodeOutput, crate::error::DeleteNodeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_node_error(response)
        } else {
            crate::operation_deser::parse_delete_node_response(response)
        }
    }
}

/// Operation shape for `GetMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_member`](crate::client::Client::get_member).
///
/// See [`crate::client::fluent_builders::GetMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMember {
    _private: (),
}
impl GetMember {
    /// Creates a new builder-style object to manufacture [`GetMemberInput`](crate::input::GetMemberInput)
    pub fn builder() -> crate::input::get_member_input::Builder {
        crate::input::get_member_input::Builder::default()
    }
    /// Creates a new `GetMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMember {
    type Output = std::result::Result<crate::output::GetMemberOutput, crate::error::GetMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_member_error(response)
        } else {
            crate::operation_deser::parse_get_member_response(response)
        }
    }
}

/// Operation shape for `GetNetwork`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_network`](crate::client::Client::get_network).
///
/// See [`crate::client::fluent_builders::GetNetwork`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNetwork {
    _private: (),
}
impl GetNetwork {
    /// Creates a new builder-style object to manufacture [`GetNetworkInput`](crate::input::GetNetworkInput)
    pub fn builder() -> crate::input::get_network_input::Builder {
        crate::input::get_network_input::Builder::default()
    }
    /// Creates a new `GetNetwork` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNetwork {
    type Output =
        std::result::Result<crate::output::GetNetworkOutput, crate::error::GetNetworkError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_network_error(response)
        } else {
            crate::operation_deser::parse_get_network_response(response)
        }
    }
}

/// Operation shape for `GetNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_node`](crate::client::Client::get_node).
///
/// See [`crate::client::fluent_builders::GetNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetNode {
    _private: (),
}
impl GetNode {
    /// Creates a new builder-style object to manufacture [`GetNodeInput`](crate::input::GetNodeInput)
    pub fn builder() -> crate::input::get_node_input::Builder {
        crate::input::get_node_input::Builder::default()
    }
    /// Creates a new `GetNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetNode {
    type Output = std::result::Result<crate::output::GetNodeOutput, crate::error::GetNodeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_node_error(response)
        } else {
            crate::operation_deser::parse_get_node_response(response)
        }
    }
}

/// Operation shape for `GetProposal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_proposal`](crate::client::Client::get_proposal).
///
/// See [`crate::client::fluent_builders::GetProposal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetProposal {
    _private: (),
}
impl GetProposal {
    /// Creates a new builder-style object to manufacture [`GetProposalInput`](crate::input::GetProposalInput)
    pub fn builder() -> crate::input::get_proposal_input::Builder {
        crate::input::get_proposal_input::Builder::default()
    }
    /// Creates a new `GetProposal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetProposal {
    type Output =
        std::result::Result<crate::output::GetProposalOutput, crate::error::GetProposalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_proposal_error(response)
        } else {
            crate::operation_deser::parse_get_proposal_response(response)
        }
    }
}

/// Operation shape for `ListInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_invitations`](crate::client::Client::list_invitations).
///
/// See [`crate::client::fluent_builders::ListInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInvitations {
    _private: (),
}
impl ListInvitations {
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
    /// Creates a new `ListInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInvitations {
    type Output = std::result::Result<
        crate::output::ListInvitationsOutput,
        crate::error::ListInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_invitations_error(response)
        } else {
            crate::operation_deser::parse_list_invitations_response(response)
        }
    }
}

/// Operation shape for `ListMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_members`](crate::client::Client::list_members).
///
/// See [`crate::client::fluent_builders::ListMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMembers {
    _private: (),
}
impl ListMembers {
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
    /// Creates a new `ListMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMembers {
    type Output =
        std::result::Result<crate::output::ListMembersOutput, crate::error::ListMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_members_error(response)
        } else {
            crate::operation_deser::parse_list_members_response(response)
        }
    }
}

/// Operation shape for `ListNetworks`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_networks`](crate::client::Client::list_networks).
///
/// See [`crate::client::fluent_builders::ListNetworks`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNetworks {
    _private: (),
}
impl ListNetworks {
    /// Creates a new builder-style object to manufacture [`ListNetworksInput`](crate::input::ListNetworksInput)
    pub fn builder() -> crate::input::list_networks_input::Builder {
        crate::input::list_networks_input::Builder::default()
    }
    /// Creates a new `ListNetworks` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNetworks {
    type Output =
        std::result::Result<crate::output::ListNetworksOutput, crate::error::ListNetworksError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_networks_error(response)
        } else {
            crate::operation_deser::parse_list_networks_response(response)
        }
    }
}

/// Operation shape for `ListNodes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_nodes`](crate::client::Client::list_nodes).
///
/// See [`crate::client::fluent_builders::ListNodes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListNodes {
    _private: (),
}
impl ListNodes {
    /// Creates a new builder-style object to manufacture [`ListNodesInput`](crate::input::ListNodesInput)
    pub fn builder() -> crate::input::list_nodes_input::Builder {
        crate::input::list_nodes_input::Builder::default()
    }
    /// Creates a new `ListNodes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListNodes {
    type Output = std::result::Result<crate::output::ListNodesOutput, crate::error::ListNodesError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_nodes_error(response)
        } else {
            crate::operation_deser::parse_list_nodes_response(response)
        }
    }
}

/// Operation shape for `ListProposals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_proposals`](crate::client::Client::list_proposals).
///
/// See [`crate::client::fluent_builders::ListProposals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProposals {
    _private: (),
}
impl ListProposals {
    /// Creates a new builder-style object to manufacture [`ListProposalsInput`](crate::input::ListProposalsInput)
    pub fn builder() -> crate::input::list_proposals_input::Builder {
        crate::input::list_proposals_input::Builder::default()
    }
    /// Creates a new `ListProposals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProposals {
    type Output =
        std::result::Result<crate::output::ListProposalsOutput, crate::error::ListProposalsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_proposals_error(response)
        } else {
            crate::operation_deser::parse_list_proposals_response(response)
        }
    }
}

/// Operation shape for `ListProposalVotes`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_proposal_votes`](crate::client::Client::list_proposal_votes).
///
/// See [`crate::client::fluent_builders::ListProposalVotes`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProposalVotes {
    _private: (),
}
impl ListProposalVotes {
    /// Creates a new builder-style object to manufacture [`ListProposalVotesInput`](crate::input::ListProposalVotesInput)
    pub fn builder() -> crate::input::list_proposal_votes_input::Builder {
        crate::input::list_proposal_votes_input::Builder::default()
    }
    /// Creates a new `ListProposalVotes` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProposalVotes {
    type Output = std::result::Result<
        crate::output::ListProposalVotesOutput,
        crate::error::ListProposalVotesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_proposal_votes_error(response)
        } else {
            crate::operation_deser::parse_list_proposal_votes_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `RejectInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`reject_invitation`](crate::client::Client::reject_invitation).
///
/// See [`crate::client::fluent_builders::RejectInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct RejectInvitation {
    _private: (),
}
impl RejectInvitation {
    /// Creates a new builder-style object to manufacture [`RejectInvitationInput`](crate::input::RejectInvitationInput)
    pub fn builder() -> crate::input::reject_invitation_input::Builder {
        crate::input::reject_invitation_input::Builder::default()
    }
    /// Creates a new `RejectInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for RejectInvitation {
    type Output = std::result::Result<
        crate::output::RejectInvitationOutput,
        crate::error::RejectInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_reject_invitation_error(response)
        } else {
            crate::operation_deser::parse_reject_invitation_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_member`](crate::client::Client::update_member).
///
/// See [`crate::client::fluent_builders::UpdateMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMember {
    _private: (),
}
impl UpdateMember {
    /// Creates a new builder-style object to manufacture [`UpdateMemberInput`](crate::input::UpdateMemberInput)
    pub fn builder() -> crate::input::update_member_input::Builder {
        crate::input::update_member_input::Builder::default()
    }
    /// Creates a new `UpdateMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMember {
    type Output =
        std::result::Result<crate::output::UpdateMemberOutput, crate::error::UpdateMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_member_error(response)
        } else {
            crate::operation_deser::parse_update_member_response(response)
        }
    }
}

/// Operation shape for `UpdateNode`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_node`](crate::client::Client::update_node).
///
/// See [`crate::client::fluent_builders::UpdateNode`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateNode {
    _private: (),
}
impl UpdateNode {
    /// Creates a new builder-style object to manufacture [`UpdateNodeInput`](crate::input::UpdateNodeInput)
    pub fn builder() -> crate::input::update_node_input::Builder {
        crate::input::update_node_input::Builder::default()
    }
    /// Creates a new `UpdateNode` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateNode {
    type Output =
        std::result::Result<crate::output::UpdateNodeOutput, crate::error::UpdateNodeError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_node_error(response)
        } else {
            crate::operation_deser::parse_update_node_response(response)
        }
    }
}

/// Operation shape for `VoteOnProposal`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`vote_on_proposal`](crate::client::Client::vote_on_proposal).
///
/// See [`crate::client::fluent_builders::VoteOnProposal`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct VoteOnProposal {
    _private: (),
}
impl VoteOnProposal {
    /// Creates a new builder-style object to manufacture [`VoteOnProposalInput`](crate::input::VoteOnProposalInput)
    pub fn builder() -> crate::input::vote_on_proposal_input::Builder {
        crate::input::vote_on_proposal_input::Builder::default()
    }
    /// Creates a new `VoteOnProposal` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for VoteOnProposal {
    type Output =
        std::result::Result<crate::output::VoteOnProposalOutput, crate::error::VoteOnProposalError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_vote_on_proposal_error(response)
        } else {
            crate::operation_deser::parse_vote_on_proposal_response(response)
        }
    }
}
