// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateMemberInput`](crate::input::CreateMemberInput)
pub mod create_member_input {
    /// A builder for [`CreateMemberInput`](crate::input::CreateMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_configuration: std::option::Option<crate::model::MemberConfiguration>,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>The unique identifier of the network in which the member is created.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network in which the member is created.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>Member configuration parameters.</p>
        pub fn member_configuration(mut self, input: crate::model::MemberConfiguration) -> Self {
            self.member_configuration = Some(input);
            self
        }
        /// <p>Member configuration parameters.</p>
        pub fn set_member_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberConfiguration>,
        ) -> Self {
            self.member_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMemberInput`](crate::input::CreateMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMemberInput {
                client_request_token: self.client_request_token,
                invitation_id: self.invitation_id,
                network_id: self.network_id,
                member_configuration: self.member_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMemberInputOperationOutputAlias = crate::operation::CreateMember;
#[doc(hidden)]
pub type CreateMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateMemberInput {
    /// Consumes the builder and constructs an Operation<[`CreateMember`](crate::operation::CreateMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.network_id;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_1, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/members",
                    NetworkId = network_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_member(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMember",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateMemberInput`](crate::input::CreateMemberInput)
    pub fn builder() -> crate::input::create_member_input::Builder {
        crate::input::create_member_input::Builder::default()
    }
}

/// See [`CreateNetworkInput`](crate::input::CreateNetworkInput)
pub mod create_network_input {
    /// A builder for [`CreateNetworkInput`](crate::input::CreateNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) framework: std::option::Option<crate::model::Framework>,
        pub(crate) framework_version: std::option::Option<std::string::String>,
        pub(crate) framework_configuration:
            std::option::Option<crate::model::NetworkFrameworkConfiguration>,
        pub(crate) voting_policy: std::option::Option<crate::model::VotingPolicy>,
        pub(crate) member_configuration: std::option::Option<crate::model::MemberConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description for the network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn framework_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_version = Some(input.into());
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn set_framework_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_version = input;
            self
        }
        /// <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
        pub fn framework_configuration(
            mut self,
            input: crate::model::NetworkFrameworkConfiguration,
        ) -> Self {
            self.framework_configuration = Some(input);
            self
        }
        /// <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
        pub fn set_framework_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkFrameworkConfiguration>,
        ) -> Self {
            self.framework_configuration = input;
            self
        }
        /// <p> The voting rules used by the network to determine if a proposal is approved. </p>
        pub fn voting_policy(mut self, input: crate::model::VotingPolicy) -> Self {
            self.voting_policy = Some(input);
            self
        }
        /// <p> The voting rules used by the network to determine if a proposal is approved. </p>
        pub fn set_voting_policy(
            mut self,
            input: std::option::Option<crate::model::VotingPolicy>,
        ) -> Self {
            self.voting_policy = input;
            self
        }
        /// <p>Configuration properties for the first member within the network.</p>
        pub fn member_configuration(mut self, input: crate::model::MemberConfiguration) -> Self {
            self.member_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for the first member within the network.</p>
        pub fn set_member_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberConfiguration>,
        ) -> Self {
            self.member_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNetworkInput`](crate::input::CreateNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNetworkInput {
                client_request_token: self.client_request_token,
                name: self.name,
                description: self.description,
                framework: self.framework,
                framework_version: self.framework_version,
                framework_configuration: self.framework_configuration,
                voting_policy: self.voting_policy,
                member_configuration: self.member_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNetworkInputOperationOutputAlias = crate::operation::CreateNetwork;
#[doc(hidden)]
pub type CreateNetworkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNetworkInput {
    /// Consumes the builder and constructs an Operation<[`CreateNetwork`](crate::operation::CreateNetwork)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNetwork,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNetworkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/networks").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNetworkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_network(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNetwork",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNetworkInput`](crate::input::CreateNetworkInput)
    pub fn builder() -> crate::input::create_network_input::Builder {
        crate::input::create_network_input::Builder::default()
    }
}

/// See [`CreateNodeInput`](crate::input::CreateNodeInput)
pub mod create_node_input {
    /// A builder for [`CreateNodeInput`](crate::input::CreateNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) node_configuration: std::option::Option<crate::model::NodeConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p>The unique identifier of the network for the node.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network for the node.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The properties of a node configuration.</p>
        pub fn node_configuration(mut self, input: crate::model::NodeConfiguration) -> Self {
            self.node_configuration = Some(input);
            self
        }
        /// <p>The properties of a node configuration.</p>
        pub fn set_node_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeConfiguration>,
        ) -> Self {
            self.node_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateNodeInput`](crate::input::CreateNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateNodeInput {
                client_request_token: self.client_request_token,
                network_id: self.network_id,
                member_id: self.member_id,
                node_configuration: self.node_configuration,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateNodeInputOperationOutputAlias = crate::operation::CreateNode;
#[doc(hidden)]
pub type CreateNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateNodeInput {
    /// Consumes the builder and constructs an Operation<[`CreateNode`](crate::operation::CreateNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.network_id;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_2, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/nodes",
                    NetworkId = network_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_node(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateNode",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateNodeInput`](crate::input::CreateNodeInput)
    pub fn builder() -> crate::input::create_node_input::Builder {
        crate::input::create_node_input::Builder::default()
    }
}

/// See [`CreateProposalInput`](crate::input::CreateProposalInput)
pub mod create_proposal_input {
    /// A builder for [`CreateProposalInput`](crate::input::CreateProposalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_request_token: std::option::Option<std::string::String>,
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<crate::model::ProposalActions>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_request_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.client_request_token = input;
            self
        }
        /// <p> The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
        pub fn actions(mut self, input: crate::model::ProposalActions) -> Self {
            self.actions = Some(input);
            self
        }
        /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<crate::model::ProposalActions>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProposalInput`](crate::input::CreateProposalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProposalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProposalInput {
                client_request_token: self.client_request_token,
                network_id: self.network_id,
                member_id: self.member_id,
                actions: self.actions,
                description: self.description,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProposalInputOperationOutputAlias = crate::operation::CreateProposal;
#[doc(hidden)]
pub type CreateProposalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProposalInput {
    /// Consumes the builder and constructs an Operation<[`CreateProposal`](crate::operation::CreateProposal)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProposal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_request_token.is_none() {
            self.client_request_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProposalInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.network_id;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_3, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/proposals",
                    NetworkId = network_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProposalInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_proposal(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProposal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProposal",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProposalInput`](crate::input::CreateProposalInput)
    pub fn builder() -> crate::input::create_proposal_input::Builder {
        crate::input::create_proposal_input::Builder::default()
    }
}

/// See [`DeleteMemberInput`](crate::input::DeleteMemberInput)
pub mod delete_member_input {
    /// A builder for [`DeleteMemberInput`](crate::input::DeleteMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network from which the member is removed.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network from which the member is removed.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMemberInput`](crate::input::DeleteMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMemberInput {
                network_id: self.network_id,
                member_id: self.member_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMemberInputOperationOutputAlias = crate::operation::DeleteMember;
#[doc(hidden)]
pub type DeleteMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteMemberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMember`](crate::operation::DeleteMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_4 = &_input.network_id;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_4, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_5 = &_input.member_id;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let member_id = aws_smithy_http::label::fmt_string(input_5, false);
                if member_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/members/{MemberId}",
                    NetworkId = network_id,
                    MemberId = member_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMember",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteMemberInput`](crate::input::DeleteMemberInput)
    pub fn builder() -> crate::input::delete_member_input::Builder {
        crate::input::delete_member_input::Builder::default()
    }
}

/// See [`DeleteNodeInput`](crate::input::DeleteNodeInput)
pub mod delete_node_input {
    /// A builder for [`DeleteNodeInput`](crate::input::DeleteNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) node_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network that the node is on.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteNodeInput`](crate::input::DeleteNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteNodeInput {
                network_id: self.network_id,
                member_id: self.member_id,
                node_id: self.node_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteNodeInputOperationOutputAlias = crate::operation::DeleteNode;
#[doc(hidden)]
pub type DeleteNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteNodeInput {
    /// Consumes the builder and constructs an Operation<[`DeleteNode`](crate::operation::DeleteNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_6 = &_input.network_id;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_6, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_7 = &_input.node_id;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let node_id = aws_smithy_http::label::fmt_string(input_7, false);
                if node_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/nodes/{NodeId}",
                    NetworkId = network_id,
                    NodeId = node_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::DeleteNodeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_8) = &_input.member_id {
                    query.push_kv("memberId", &aws_smithy_http::query::fmt_string(&inner_8));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteNode",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteNodeInput`](crate::input::DeleteNodeInput)
    pub fn builder() -> crate::input::delete_node_input::Builder {
        crate::input::delete_node_input::Builder::default()
    }
}

/// See [`GetMemberInput`](crate::input::GetMemberInput)
pub mod get_member_input {
    /// A builder for [`GetMemberInput`](crate::input::GetMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMemberInput`](crate::input::GetMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetMemberInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetMemberInput {
                network_id: self.network_id,
                member_id: self.member_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetMemberInputOperationOutputAlias = crate::operation::GetMember;
#[doc(hidden)]
pub type GetMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetMemberInput {
    /// Consumes the builder and constructs an Operation<[`GetMember`](crate::operation::GetMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_9 = &_input.network_id;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_9, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_10 = &_input.member_id;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let member_id = aws_smithy_http::label::fmt_string(input_10, false);
                if member_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/members/{MemberId}",
                    NetworkId = network_id,
                    MemberId = member_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetMember::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetMember",
                    "managedblockchain",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetMemberInput`](crate::input::GetMemberInput)
    pub fn builder() -> crate::input::get_member_input::Builder {
        crate::input::get_member_input::Builder::default()
    }
}

/// See [`GetNetworkInput`](crate::input::GetNetworkInput)
pub mod get_network_input {
    /// A builder for [`GetNetworkInput`](crate::input::GetNetworkInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network to get information about.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network to get information about.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNetworkInput`](crate::input::GetNetworkInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetNetworkInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetNetworkInput {
                network_id: self.network_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNetworkInputOperationOutputAlias = crate::operation::GetNetwork;
#[doc(hidden)]
pub type GetNetworkInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetNetworkInput {
    /// Consumes the builder and constructs an Operation<[`GetNetwork`](crate::operation::GetNetwork)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNetwork,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetNetworkInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_11 = &_input.network_id;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_11, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/networks/{NetworkId}", NetworkId = network_id)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetNetworkInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetNetwork::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetNetwork",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetNetworkInput`](crate::input::GetNetworkInput)
    pub fn builder() -> crate::input::get_network_input::Builder {
        crate::input::get_network_input::Builder::default()
    }
}

/// See [`GetNodeInput`](crate::input::GetNodeInput)
pub mod get_node_input {
    /// A builder for [`GetNodeInput`](crate::input::GetNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) node_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetNodeInput`](crate::input::GetNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetNodeInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetNodeInput {
                network_id: self.network_id,
                member_id: self.member_id,
                node_id: self.node_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetNodeInputOperationOutputAlias = crate::operation::GetNode;
#[doc(hidden)]
pub type GetNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetNodeInput {
    /// Consumes the builder and constructs an Operation<[`GetNode`](crate::operation::GetNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.network_id;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_12, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.node_id;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let node_id = aws_smithy_http::label::fmt_string(input_13, false);
                if node_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/nodes/{NodeId}",
                    NetworkId = network_id,
                    NodeId = node_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::GetNodeInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_14) = &_input.member_id {
                    query.push_kv("memberId", &aws_smithy_http::query::fmt_string(&inner_14));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetNode::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetNode",
                    "managedblockchain",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetNodeInput`](crate::input::GetNodeInput)
    pub fn builder() -> crate::input::get_node_input::Builder {
        crate::input::get_node_input::Builder::default()
    }
}

/// See [`GetProposalInput`](crate::input::GetProposalInput)
pub mod get_proposal_input {
    /// A builder for [`GetProposalInput`](crate::input::GetProposalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) proposal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetProposalInput`](crate::input::GetProposalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetProposalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetProposalInput {
                network_id: self.network_id,
                proposal_id: self.proposal_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetProposalInputOperationOutputAlias = crate::operation::GetProposal;
#[doc(hidden)]
pub type GetProposalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl GetProposalInput {
    /// Consumes the builder and constructs an Operation<[`GetProposal`](crate::operation::GetProposal)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetProposal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::GetProposalInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.network_id;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_15, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.proposal_id;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "proposal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let proposal_id = aws_smithy_http::label::fmt_string(input_16, false);
                if proposal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "proposal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/proposals/{ProposalId}",
                    NetworkId = network_id,
                    ProposalId = proposal_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::GetProposalInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetProposal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetProposal",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`GetProposalInput`](crate::input::GetProposalInput)
    pub fn builder() -> crate::input::get_proposal_input::Builder {
        crate::input::get_proposal_input::Builder::default()
    }
}

/// See [`ListInvitationsInput`](crate::input::ListInvitationsInput)
pub mod list_invitations_input {
    /// A builder for [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of invitations to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of invitations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInvitationsInput`](crate::input::ListInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInvitationsInput {
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInvitationsInputOperationOutputAlias = crate::operation::ListInvitations;
#[doc(hidden)]
pub type ListInvitationsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`ListInvitations`](crate::operation::ListInvitations)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInvitations,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListInvitationsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/invitations").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListInvitationsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_17) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_17).encode(),
                    );
                }
                if let Some(inner_18) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_18));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListInvitationsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInvitations",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
}

/// See [`ListMembersInput`](crate::input::ListMembersInput)
pub mod list_members_input {
    /// A builder for [`ListMembersInput`](crate::input::ListMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MemberStatus>,
        pub(crate) is_owned: std::option::Option<bool>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network for which to list members.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network for which to list members.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The optional name of the member to list.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The optional name of the member to list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
        pub fn status(mut self, input: crate::model::MemberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MemberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
        pub fn is_owned(mut self, input: bool) -> Self {
            self.is_owned = Some(input);
            self
        }
        /// <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
        pub fn set_is_owned(mut self, input: std::option::Option<bool>) -> Self {
            self.is_owned = input;
            self
        }
        /// <p>The maximum number of members to return in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of members to return in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMembersInput`](crate::input::ListMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMembersInput {
                network_id: self.network_id,
                name: self.name,
                status: self.status,
                is_owned: self.is_owned,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMembersInputOperationOutputAlias = crate::operation::ListMembers;
#[doc(hidden)]
pub type ListMembersInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListMembers`](crate::operation::ListMembers)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMembers,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListMembersInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_19 = &_input.network_id;
                let input_19 = input_19.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_19, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/members",
                    NetworkId = network_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListMembersInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_20) = &_input.name {
                    query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_20));
                }
                if let Some(inner_21) = &_input.status {
                    query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_21));
                }
                if let Some(inner_22) = &_input.is_owned {
                    query.push_kv(
                        "isOwned",
                        aws_smithy_types::primitive::Encoder::from(*inner_22).encode(),
                    );
                }
                if let Some(inner_23) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_23).encode(),
                    );
                }
                if let Some(inner_24) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_24));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListMembersInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMembers",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
}

/// See [`ListNetworksInput`](crate::input::ListNetworksInput)
pub mod list_networks_input {
    /// A builder for [`ListNetworksInput`](crate::input::ListNetworksInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) framework: std::option::Option<crate::model::Framework>,
        pub(crate) status: std::option::Option<crate::model::NetworkStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the network.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn status(mut self, input: crate::model::NetworkStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NetworkStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of networks to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of networks to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNetworksInput`](crate::input::ListNetworksInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListNetworksInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListNetworksInput {
                name: self.name,
                framework: self.framework,
                status: self.status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNetworksInputOperationOutputAlias = crate::operation::ListNetworks;
#[doc(hidden)]
pub type ListNetworksInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListNetworksInput {
    /// Consumes the builder and constructs an Operation<[`ListNetworks`](crate::operation::ListNetworks)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNetworks,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListNetworksInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/networks").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListNetworksInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_25) = &_input.name {
                    query.push_kv("name", &aws_smithy_http::query::fmt_string(&inner_25));
                }
                if let Some(inner_26) = &_input.framework {
                    query.push_kv("framework", &aws_smithy_http::query::fmt_string(&inner_26));
                }
                if let Some(inner_27) = &_input.status {
                    query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_27));
                }
                if let Some(inner_28) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                    );
                }
                if let Some(inner_29) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_29));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListNetworksInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListNetworks::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListNetworks",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListNetworksInput`](crate::input::ListNetworksInput)
    pub fn builder() -> crate::input::list_networks_input::Builder {
        crate::input::list_networks_input::Builder::default()
    }
}

/// See [`ListNodesInput`](crate::input::ListNodesInput)
pub mod list_nodes_input {
    /// A builder for [`ListNodesInput`](crate::input::ListNodesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NodeStatus>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network for which to list nodes.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network for which to list nodes.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member who owns the nodes to list.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member who owns the nodes to list.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
        pub fn status(mut self, input: crate::model::NodeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::NodeStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The maximum number of nodes to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of nodes to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListNodesInput`](crate::input::ListNodesInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::ListNodesInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::ListNodesInput {
                network_id: self.network_id,
                member_id: self.member_id,
                status: self.status,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListNodesInputOperationOutputAlias = crate::operation::ListNodes;
#[doc(hidden)]
pub type ListNodesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListNodesInput {
    /// Consumes the builder and constructs an Operation<[`ListNodes`](crate::operation::ListNodes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListNodes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListNodesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_30 = &_input.network_id;
                let input_30 = input_30.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_30, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/nodes",
                    NetworkId = network_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListNodesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_31) = &_input.member_id {
                    query.push_kv("memberId", &aws_smithy_http::query::fmt_string(&inner_31));
                }
                if let Some(inner_32) = &_input.status {
                    query.push_kv("status", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                if let Some(inner_33) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_33).encode(),
                    );
                }
                if let Some(inner_34) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_34));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListNodesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::ListNodes::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "ListNodes",
                    "managedblockchain",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListNodesInput`](crate::input::ListNodesInput)
    pub fn builder() -> crate::input::list_nodes_input::Builder {
        crate::input::list_nodes_input::Builder::default()
    }
}

/// See [`ListProposalsInput`](crate::input::ListProposalsInput)
pub mod list_proposals_input {
    /// A builder for [`ListProposalsInput`](crate::input::ListProposalsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier of the network. </p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the network. </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p> The maximum number of proposals to return. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of proposals to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProposalsInput`](crate::input::ListProposalsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProposalsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProposalsInput {
                network_id: self.network_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProposalsInputOperationOutputAlias = crate::operation::ListProposals;
#[doc(hidden)]
pub type ListProposalsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProposalsInput {
    /// Consumes the builder and constructs an Operation<[`ListProposals`](crate::operation::ListProposals)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProposals,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProposalsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.network_id;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_35, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/proposals",
                    NetworkId = network_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProposalsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_36) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_36).encode(),
                    );
                }
                if let Some(inner_37) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_37));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProposalsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProposals::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProposals",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProposalsInput`](crate::input::ListProposalsInput)
    pub fn builder() -> crate::input::list_proposals_input::Builder {
        crate::input::list_proposals_input::Builder::default()
    }
}

/// See [`ListProposalVotesInput`](crate::input::ListProposalVotesInput)
pub mod list_proposal_votes_input {
    /// A builder for [`ListProposalVotesInput`](crate::input::ListProposalVotesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The unique identifier of the network. </p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the network. </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p> The maximum number of votes to return. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p> The maximum number of votes to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProposalVotesInput`](crate::input::ListProposalVotesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProposalVotesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProposalVotesInput {
                network_id: self.network_id,
                proposal_id: self.proposal_id,
                max_results: self.max_results,
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProposalVotesInputOperationOutputAlias = crate::operation::ListProposalVotes;
#[doc(hidden)]
pub type ListProposalVotesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProposalVotesInput {
    /// Consumes the builder and constructs an Operation<[`ListProposalVotes`](crate::operation::ListProposalVotes)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProposalVotes,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProposalVotesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.network_id;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_38, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.proposal_id;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "proposal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let proposal_id = aws_smithy_http::label::fmt_string(input_39, false);
                if proposal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "proposal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/proposals/{ProposalId}/votes",
                    NetworkId = network_id,
                    ProposalId = proposal_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProposalVotesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_40) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_40).encode(),
                    );
                }
                if let Some(inner_41) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_41));
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProposalVotesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProposalVotes::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProposalVotes",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProposalVotesInput`](crate::input::ListProposalVotesInput)
    pub fn builder() -> crate::input::list_proposal_votes_input::Builder {
        crate::input::list_proposal_votes_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_42 = &_input.resource_arn;
                let input_42 = input_42.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_42, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`RejectInvitationInput`](crate::input::RejectInvitationInput)
pub mod reject_invitation_input {
    /// A builder for [`RejectInvitationInput`](crate::input::RejectInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invitation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the invitation to reject.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the invitation to reject.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RejectInvitationInput`](crate::input::RejectInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::RejectInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::RejectInvitationInput {
                invitation_id: self.invitation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type RejectInvitationInputOperationOutputAlias = crate::operation::RejectInvitation;
#[doc(hidden)]
pub type RejectInvitationInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl RejectInvitationInput {
    /// Consumes the builder and constructs an Operation<[`RejectInvitation`](crate::operation::RejectInvitation)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::RejectInvitation,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::RejectInvitationInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_43 = &_input.invitation_id;
                let input_43 = input_43.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "invitation_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let invitation_id = aws_smithy_http::label::fmt_string(input_43, false);
                if invitation_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "invitation_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/invitations/{InvitationId}",
                    InvitationId = invitation_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::RejectInvitationInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::RejectInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "RejectInvitation",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`RejectInvitationInput`](crate::input::RejectInvitationInput)
    pub fn builder() -> crate::input::reject_invitation_input::Builder {
        crate::input::reject_invitation_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.resource_arn;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_44, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_45 = &_input.resource_arn;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_45, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(output, "/tags/{ResourceArn}", ResourceArn = resource_arn)
                    .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_46) = &_input.tag_keys {
                    for inner_47 in inner_46 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_47));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateMemberInput`](crate::input::UpdateMemberInput)
pub mod update_member_input {
    /// A builder for [`UpdateMemberInput`](crate::input::UpdateMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) log_publishing_configuration:
            std::option::Option<crate::model::MemberLogPublishingConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::MemberLogPublishingConfiguration,
        ) -> Self {
            self.log_publishing_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        ) -> Self {
            self.log_publishing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMemberInput`](crate::input::UpdateMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMemberInput {
                network_id: self.network_id,
                member_id: self.member_id,
                log_publishing_configuration: self.log_publishing_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMemberInputOperationOutputAlias = crate::operation::UpdateMember;
#[doc(hidden)]
pub type UpdateMemberInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateMemberInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMember`](crate::operation::UpdateMember)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMember,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateMemberInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_48 = &_input.network_id;
                let input_48 = input_48.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_48, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_49 = &_input.member_id;
                let input_49 = input_49.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let member_id = aws_smithy_http::label::fmt_string(input_49, false);
                if member_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "member_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/members/{MemberId}",
                    NetworkId = network_id,
                    MemberId = member_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateMemberInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_member(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMember",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateMemberInput`](crate::input::UpdateMemberInput)
    pub fn builder() -> crate::input::update_member_input::Builder {
        crate::input::update_member_input::Builder::default()
    }
}

/// See [`UpdateNodeInput`](crate::input::UpdateNodeInput)
pub mod update_node_input {
    /// A builder for [`UpdateNodeInput`](crate::input::UpdateNodeInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) node_id: std::option::Option<std::string::String>,
        pub(crate) log_publishing_configuration:
            std::option::Option<crate::model::NodeLogPublishingConfiguration>,
    }
    impl Builder {
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.node_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.node_id = input;
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::NodeLogPublishingConfiguration,
        ) -> Self {
            self.log_publishing_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        ) -> Self {
            self.log_publishing_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateNodeInput`](crate::input::UpdateNodeInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateNodeInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateNodeInput {
                network_id: self.network_id,
                member_id: self.member_id,
                node_id: self.node_id,
                log_publishing_configuration: self.log_publishing_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateNodeInputOperationOutputAlias = crate::operation::UpdateNode;
#[doc(hidden)]
pub type UpdateNodeInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateNodeInput {
    /// Consumes the builder and constructs an Operation<[`UpdateNode`](crate::operation::UpdateNode)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateNode,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateNodeInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_50 = &_input.network_id;
                let input_50 = input_50.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_50, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_51 = &_input.node_id;
                let input_51 = input_51.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let node_id = aws_smithy_http::label::fmt_string(input_51, false);
                if node_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "node_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/nodes/{NodeId}",
                    NetworkId = network_id,
                    NodeId = node_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateNodeInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_node(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateNode::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateNode",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateNodeInput`](crate::input::UpdateNodeInput)
    pub fn builder() -> crate::input::update_node_input::Builder {
        crate::input::update_node_input::Builder::default()
    }
}

/// See [`VoteOnProposalInput`](crate::input::VoteOnProposalInput)
pub mod vote_on_proposal_input {
    /// A builder for [`VoteOnProposalInput`](crate::input::VoteOnProposalInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) voter_member_id: std::option::Option<std::string::String>,
        pub(crate) vote: std::option::Option<crate::model::VoteValue>,
    }
    impl Builder {
        /// <p> The unique identifier of the network. </p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the network. </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p>The unique identifier of the member casting the vote. </p>
        pub fn voter_member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.voter_member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member casting the vote. </p>
        pub fn set_voter_member_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.voter_member_id = input;
            self
        }
        /// <p> The value of the vote. </p>
        pub fn vote(mut self, input: crate::model::VoteValue) -> Self {
            self.vote = Some(input);
            self
        }
        /// <p> The value of the vote. </p>
        pub fn set_vote(mut self, input: std::option::Option<crate::model::VoteValue>) -> Self {
            self.vote = input;
            self
        }
        /// Consumes the builder and constructs a [`VoteOnProposalInput`](crate::input::VoteOnProposalInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::VoteOnProposalInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::VoteOnProposalInput {
                network_id: self.network_id,
                proposal_id: self.proposal_id,
                voter_member_id: self.voter_member_id,
                vote: self.vote,
            })
        }
    }
}
#[doc(hidden)]
pub type VoteOnProposalInputOperationOutputAlias = crate::operation::VoteOnProposal;
#[doc(hidden)]
pub type VoteOnProposalInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl VoteOnProposalInput {
    /// Consumes the builder and constructs an Operation<[`VoteOnProposal`](crate::operation::VoteOnProposal)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::VoteOnProposal,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::VoteOnProposalInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_52 = &_input.network_id;
                let input_52 = input_52.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let network_id = aws_smithy_http::label::fmt_string(input_52, false);
                if network_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "network_id",
                        details: "cannot be empty or unset",
                    });
                }
                let input_53 = &_input.proposal_id;
                let input_53 = input_53.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "proposal_id",
                        details: "cannot be empty or unset",
                    },
                )?;
                let proposal_id = aws_smithy_http::label::fmt_string(input_53, false);
                if proposal_id.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "proposal_id",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/networks/{NetworkId}/proposals/{ProposalId}/votes",
                    NetworkId = network_id,
                    ProposalId = proposal_id
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::VoteOnProposalInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_vote_on_proposal(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::VoteOnProposal::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "VoteOnProposal",
            "managedblockchain",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`VoteOnProposalInput`](crate::input::VoteOnProposalInput)
    pub fn builder() -> crate::input::vote_on_proposal_input::Builder {
        crate::input::vote_on_proposal_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoteOnProposalInput {
    /// <p> The unique identifier of the network. </p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p> The unique identifier of the proposal. </p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member casting the vote. </p>
    pub voter_member_id: std::option::Option<std::string::String>,
    /// <p> The value of the vote. </p>
    pub vote: std::option::Option<crate::model::VoteValue>,
}
impl VoteOnProposalInput {
    /// <p> The unique identifier of the network. </p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p> The unique identifier of the proposal. </p>
    pub fn proposal_id(&self) -> std::option::Option<&str> {
        self.proposal_id.as_deref()
    }
    /// <p>The unique identifier of the member casting the vote. </p>
    pub fn voter_member_id(&self) -> std::option::Option<&str> {
        self.voter_member_id.as_deref()
    }
    /// <p> The value of the vote. </p>
    pub fn vote(&self) -> std::option::Option<&crate::model::VoteValue> {
        self.vote.as_ref()
    }
}
impl std::fmt::Debug for VoteOnProposalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoteOnProposalInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field("voter_member_id", &self.voter_member_id);
        formatter.field("vote", &self.vote);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateNodeInput {
    /// <p>The unique identifier of the network that the node is on.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member that owns the node.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the node.</p>
    pub node_id: std::option::Option<std::string::String>,
    /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
    pub log_publishing_configuration:
        std::option::Option<crate::model::NodeLogPublishingConfiguration>,
}
impl UpdateNodeInput {
    /// <p>The unique identifier of the network that the node is on.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member that owns the node.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The unique identifier of the node.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
    /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
    pub fn log_publishing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NodeLogPublishingConfiguration> {
        self.log_publishing_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateNodeInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("node_id", &self.node_id);
        formatter.field(
            "log_publishing_configuration",
            &self.log_publishing_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMemberInput {
    /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
    pub log_publishing_configuration:
        std::option::Option<crate::model::MemberLogPublishingConfiguration>,
}
impl UpdateMemberInput {
    /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
    pub fn log_publishing_configuration(
        &self,
    ) -> std::option::Option<&crate::model::MemberLogPublishingConfiguration> {
        self.log_publishing_configuration.as_ref()
    }
}
impl std::fmt::Debug for UpdateMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMemberInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field(
            "log_publishing_configuration",
            &self.log_publishing_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tag keys.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tag keys.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RejectInvitationInput {
    /// <p>The unique identifier of the invitation to reject.</p>
    pub invitation_id: std::option::Option<std::string::String>,
}
impl RejectInvitationInput {
    /// <p>The unique identifier of the invitation to reject.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
}
impl std::fmt::Debug for RejectInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RejectInvitationInput");
        formatter.field("invitation_id", &self.invitation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProposalVotesInput {
    /// <p> The unique identifier of the network. </p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p> The unique identifier of the proposal. </p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p> The maximum number of votes to return. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token that indicates the next set of results to retrieve. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProposalVotesInput {
    /// <p> The unique identifier of the network. </p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p> The unique identifier of the proposal. </p>
    pub fn proposal_id(&self) -> std::option::Option<&str> {
        self.proposal_id.as_deref()
    }
    /// <p> The maximum number of votes to return. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token that indicates the next set of results to retrieve. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProposalVotesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProposalVotesInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProposalsInput {
    /// <p> The unique identifier of the network. </p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p> The maximum number of proposals to return. </p>
    pub max_results: std::option::Option<i32>,
    /// <p> The pagination token that indicates the next set of results to retrieve. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProposalsInput {
    /// <p> The unique identifier of the network. </p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p> The maximum number of proposals to return. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p> The pagination token that indicates the next set of results to retrieve. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProposalsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProposalsInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNodesInput {
    /// <p>The unique identifier of the network for which to list nodes.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member who owns the nodes to list.</p>
    /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
    pub status: std::option::Option<crate::model::NodeStatus>,
    /// <p>The maximum number of nodes to list.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNodesInput {
    /// <p>The unique identifier of the network for which to list nodes.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member who owns the nodes to list.</p>
    /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NodeStatus> {
        self.status.as_ref()
    }
    /// <p>The maximum number of nodes to list.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNodesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNodesInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("status", &self.status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListNetworksInput {
    /// <p>The name of the network.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
    pub framework: std::option::Option<crate::model::Framework>,
    /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub status: std::option::Option<crate::model::NetworkStatus>,
    /// <p>The maximum number of networks to list.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListNetworksInput {
    /// <p>The name of the network.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
    pub fn framework(&self) -> std::option::Option<&crate::model::Framework> {
        self.framework.as_ref()
    }
    /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::NetworkStatus> {
        self.status.as_ref()
    }
    /// <p>The maximum number of networks to list.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListNetworksInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListNetworksInput");
        formatter.field("name", &self.name);
        formatter.field("framework", &self.framework);
        formatter.field("status", &self.status);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMembersInput {
    /// <p>The unique identifier of the network for which to list members.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The optional name of the member to list.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
    pub status: std::option::Option<crate::model::MemberStatus>,
    /// <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
    pub is_owned: std::option::Option<bool>,
    /// <p>The maximum number of members to return in the request.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListMembersInput {
    /// <p>The unique identifier of the network for which to list members.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The optional name of the member to list.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MemberStatus> {
        self.status.as_ref()
    }
    /// <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
    pub fn is_owned(&self) -> std::option::Option<bool> {
        self.is_owned
    }
    /// <p>The maximum number of members to return in the request.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMembersInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("is_owned", &self.is_owned);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInvitationsInput {
    /// <p>The maximum number of invitations to return.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInvitationsInput {
    /// <p>The maximum number of invitations to return.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>The pagination token that indicates the next set of results to retrieve.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInvitationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetProposalInput {
    /// <p>The unique identifier of the network for which the proposal is made.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the proposal.</p>
    pub proposal_id: std::option::Option<std::string::String>,
}
impl GetProposalInput {
    /// <p>The unique identifier of the network for which the proposal is made.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the proposal.</p>
    pub fn proposal_id(&self) -> std::option::Option<&str> {
        self.proposal_id.as_deref()
    }
}
impl std::fmt::Debug for GetProposalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetProposalInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("proposal_id", &self.proposal_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNodeInput {
    /// <p>The unique identifier of the network that the node is on.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member that owns the node.</p>
    /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the node.</p>
    pub node_id: std::option::Option<std::string::String>,
}
impl GetNodeInput {
    /// <p>The unique identifier of the network that the node is on.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member that owns the node.</p>
    /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The unique identifier of the node.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
}
impl std::fmt::Debug for GetNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNodeInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("node_id", &self.node_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetNetworkInput {
    /// <p>The unique identifier of the network to get information about.</p>
    pub network_id: std::option::Option<std::string::String>,
}
impl GetNetworkInput {
    /// <p>The unique identifier of the network to get information about.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
}
impl std::fmt::Debug for GetNetworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetNetworkInput");
        formatter.field("network_id", &self.network_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMemberInput {
    /// <p>The unique identifier of the network to which the member belongs.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member.</p>
    pub member_id: std::option::Option<std::string::String>,
}
impl GetMemberInput {
    /// <p>The unique identifier of the network to which the member belongs.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
}
impl std::fmt::Debug for GetMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMemberInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteNodeInput {
    /// <p>The unique identifier of the network that the node is on.</p>
    /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
    /// <ul>
    /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
    /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
    /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
    /// </ul>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member that owns this node.</p>
    /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the node.</p>
    pub node_id: std::option::Option<std::string::String>,
}
impl DeleteNodeInput {
    /// <p>The unique identifier of the network that the node is on.</p>
    /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
    /// <ul>
    /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
    /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
    /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
    /// </ul>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member that owns this node.</p>
    /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The unique identifier of the node.</p>
    pub fn node_id(&self) -> std::option::Option<&str> {
        self.node_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteNodeInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("node_id", &self.node_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMemberInput {
    /// <p>The unique identifier of the network from which the member is removed.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member to remove.</p>
    pub member_id: std::option::Option<std::string::String>,
}
impl DeleteMemberInput {
    /// <p>The unique identifier of the network from which the member is removed.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member to remove.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMemberInput");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProposalInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p> The unique identifier of the network for which the proposal is made.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
    pub actions: std::option::Option<crate::model::ProposalActions>,
    /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateProposalInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p> The unique identifier of the network for which the proposal is made.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
    pub fn actions(&self) -> std::option::Option<&crate::model::ProposalActions> {
        self.actions.as_ref()
    }
    /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateProposalInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProposalInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("actions", &self.actions);
        formatter.field("description", &self.description);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNodeInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the network for the node.</p>
    /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
    /// <ul>
    /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
    /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
    /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
    /// </ul>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member that owns this node.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The properties of a node configuration.</p>
    pub node_configuration: std::option::Option<crate::model::NodeConfiguration>,
    /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateNodeInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The unique identifier of the network for the node.</p>
    /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
    /// <ul>
    /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
    /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
    /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
    /// </ul>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>The unique identifier of the member that owns this node.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub fn member_id(&self) -> std::option::Option<&str> {
        self.member_id.as_deref()
    }
    /// <p>The properties of a node configuration.</p>
    pub fn node_configuration(&self) -> std::option::Option<&crate::model::NodeConfiguration> {
        self.node_configuration.as_ref()
    }
    /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateNodeInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNodeInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("node_configuration", &self.node_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateNetworkInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The name of the network.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description for the network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The blockchain framework that the network uses.</p>
    pub framework: std::option::Option<crate::model::Framework>,
    /// <p>The version of the blockchain framework that the network uses.</p>
    pub framework_version: std::option::Option<std::string::String>,
    /// <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
    pub framework_configuration: std::option::Option<crate::model::NetworkFrameworkConfiguration>,
    /// <p> The voting rules used by the network to determine if a proposal is approved. </p>
    pub voting_policy: std::option::Option<crate::model::VotingPolicy>,
    /// <p>Configuration properties for the first member within the network.</p>
    pub member_configuration: std::option::Option<crate::model::MemberConfiguration>,
    /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateNetworkInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The name of the network.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>An optional description for the network.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The blockchain framework that the network uses.</p>
    pub fn framework(&self) -> std::option::Option<&crate::model::Framework> {
        self.framework.as_ref()
    }
    /// <p>The version of the blockchain framework that the network uses.</p>
    pub fn framework_version(&self) -> std::option::Option<&str> {
        self.framework_version.as_deref()
    }
    /// <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
    pub fn framework_configuration(
        &self,
    ) -> std::option::Option<&crate::model::NetworkFrameworkConfiguration> {
        self.framework_configuration.as_ref()
    }
    /// <p> The voting rules used by the network to determine if a proposal is approved. </p>
    pub fn voting_policy(&self) -> std::option::Option<&crate::model::VotingPolicy> {
        self.voting_policy.as_ref()
    }
    /// <p>Configuration properties for the first member within the network.</p>
    pub fn member_configuration(&self) -> std::option::Option<&crate::model::MemberConfiguration> {
        self.member_configuration.as_ref()
    }
    /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateNetworkInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateNetworkInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("framework", &self.framework);
        formatter.field("framework_version", &self.framework_version);
        formatter.field("framework_configuration", &self.framework_configuration);
        formatter.field("voting_policy", &self.voting_policy);
        formatter.field("member_configuration", &self.member_configuration);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMemberInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub client_request_token: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the network in which the member is created.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>Member configuration parameters.</p>
    pub member_configuration: std::option::Option<crate::model::MemberConfiguration>,
}
impl CreateMemberInput {
    /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    pub fn client_request_token(&self) -> std::option::Option<&str> {
        self.client_request_token.as_deref()
    }
    /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
    /// <p>The unique identifier of the network in which the member is created.</p>
    pub fn network_id(&self) -> std::option::Option<&str> {
        self.network_id.as_deref()
    }
    /// <p>Member configuration parameters.</p>
    pub fn member_configuration(&self) -> std::option::Option<&crate::model::MemberConfiguration> {
        self.member_configuration.as_ref()
    }
}
impl std::fmt::Debug for CreateMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMemberInput");
        formatter.field("client_request_token", &self.client_request_token);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("network_id", &self.network_id);
        formatter.field("member_configuration", &self.member_configuration);
        formatter.finish()
    }
}
