// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Managed Blockchain
///
/// Client for invoking operations on Amazon Managed Blockchain. Each operation on Amazon Managed Blockchain is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_managedblockchain::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_managedblockchain::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_managedblockchain::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateMember`](crate::client::fluent_builders::CreateMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateMember::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateMember::set_client_request_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    ///   - [`invitation_id(impl Into<String>)`](crate::client::fluent_builders::CreateMember::invitation_id) / [`set_invitation_id(Option<String>)`](crate::client::fluent_builders::CreateMember::set_invitation_id): <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::CreateMember::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::CreateMember::set_network_id): <p>The unique identifier of the network in which the member is created.</p>
    ///   - [`member_configuration(MemberConfiguration)`](crate::client::fluent_builders::CreateMember::member_configuration) / [`set_member_configuration(Option<MemberConfiguration>)`](crate::client::fluent_builders::CreateMember::set_member_configuration): <p>Member configuration parameters.</p>
    /// - On success, responds with [`CreateMemberOutput`](crate::output::CreateMemberOutput) with field(s):
    ///   - [`member_id(Option<String>)`](crate::output::CreateMemberOutput::member_id): <p>The unique identifier of the member.</p>
    /// - On failure, responds with [`SdkError<CreateMemberError>`](crate::error::CreateMemberError)
    pub fn create_member(&self) -> fluent_builders::CreateMember {
        fluent_builders::CreateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNetwork`](crate::client::fluent_builders::CreateNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateNetwork::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateNetwork::set_client_request_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateNetwork::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateNetwork::set_name): <p>The name of the network.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateNetwork::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateNetwork::set_description): <p>An optional description for the network.</p>
    ///   - [`framework(Framework)`](crate::client::fluent_builders::CreateNetwork::framework) / [`set_framework(Option<Framework>)`](crate::client::fluent_builders::CreateNetwork::set_framework): <p>The blockchain framework that the network uses.</p>
    ///   - [`framework_version(impl Into<String>)`](crate::client::fluent_builders::CreateNetwork::framework_version) / [`set_framework_version(Option<String>)`](crate::client::fluent_builders::CreateNetwork::set_framework_version): <p>The version of the blockchain framework that the network uses.</p>
    ///   - [`framework_configuration(NetworkFrameworkConfiguration)`](crate::client::fluent_builders::CreateNetwork::framework_configuration) / [`set_framework_configuration(Option<NetworkFrameworkConfiguration>)`](crate::client::fluent_builders::CreateNetwork::set_framework_configuration): <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
    ///   - [`voting_policy(VotingPolicy)`](crate::client::fluent_builders::CreateNetwork::voting_policy) / [`set_voting_policy(Option<VotingPolicy>)`](crate::client::fluent_builders::CreateNetwork::set_voting_policy): <p> The voting rules used by the network to determine if a proposal is approved. </p>
    ///   - [`member_configuration(MemberConfiguration)`](crate::client::fluent_builders::CreateNetwork::member_configuration) / [`set_member_configuration(Option<MemberConfiguration>)`](crate::client::fluent_builders::CreateNetwork::set_member_configuration): <p>Configuration properties for the first member within the network.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateNetwork::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateNetwork::set_tags): <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>  <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>  <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    /// - On success, responds with [`CreateNetworkOutput`](crate::output::CreateNetworkOutput) with field(s):
    ///   - [`network_id(Option<String>)`](crate::output::CreateNetworkOutput::network_id): <p>The unique identifier for the network.</p>
    ///   - [`member_id(Option<String>)`](crate::output::CreateNetworkOutput::member_id): <p>The unique identifier for the first member within the network.</p>
    /// - On failure, responds with [`SdkError<CreateNetworkError>`](crate::error::CreateNetworkError)
    pub fn create_network(&self) -> fluent_builders::CreateNetwork {
        fluent_builders::CreateNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateNode`](crate::client::fluent_builders::CreateNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateNode::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateNode::set_client_request_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::CreateNode::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::CreateNode::set_network_id): <p>The unique identifier of the network for the node.</p>  <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>  <ul>   <li> <p> <code>n-ethereum-mainnet</code> </p> </li>   <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>   <li> <p> <code>n-ethereum-ropsten</code> </p> </li>  </ul>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::CreateNode::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::CreateNode::set_member_id): <p>The unique identifier of the member that owns this node.</p>  <p>Applies only to Hyperledger Fabric.</p>
    ///   - [`node_configuration(NodeConfiguration)`](crate::client::fluent_builders::CreateNode::node_configuration) / [`set_node_configuration(Option<NodeConfiguration>)`](crate::client::fluent_builders::CreateNode::set_node_configuration): <p>The properties of a node configuration.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateNode::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateNode::set_tags): <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>  <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>  <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    /// - On success, responds with [`CreateNodeOutput`](crate::output::CreateNodeOutput) with field(s):
    ///   - [`node_id(Option<String>)`](crate::output::CreateNodeOutput::node_id): <p>The unique identifier of the node.</p>
    /// - On failure, responds with [`SdkError<CreateNodeError>`](crate::error::CreateNodeError)
    pub fn create_node(&self) -> fluent_builders::CreateNode {
        fluent_builders::CreateNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProposal`](crate::client::fluent_builders::CreateProposal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_request_token(impl Into<String>)`](crate::client::fluent_builders::CreateProposal::client_request_token) / [`set_client_request_token(Option<String>)`](crate::client::fluent_builders::CreateProposal::set_client_request_token): <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::CreateProposal::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::CreateProposal::set_network_id): <p> The unique identifier of the network for which the proposal is made.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::CreateProposal::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::CreateProposal::set_member_id): <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
    ///   - [`actions(ProposalActions)`](crate::client::fluent_builders::CreateProposal::actions) / [`set_actions(Option<ProposalActions>)`](crate::client::fluent_builders::CreateProposal::set_actions): <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateProposal::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateProposal::set_description): <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateProposal::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateProposal::set_tags): <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>  <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>  <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    /// - On success, responds with [`CreateProposalOutput`](crate::output::CreateProposalOutput) with field(s):
    ///   - [`proposal_id(Option<String>)`](crate::output::CreateProposalOutput::proposal_id): <p>The unique identifier of the proposal.</p>
    /// - On failure, responds with [`SdkError<CreateProposalError>`](crate::error::CreateProposalError)
    pub fn create_proposal(&self) -> fluent_builders::CreateProposal {
        fluent_builders::CreateProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMember`](crate::client::fluent_builders::DeleteMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMember::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::DeleteMember::set_network_id): <p>The unique identifier of the network from which the member is removed.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMember::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::DeleteMember::set_member_id): <p>The unique identifier of the member to remove.</p>
    /// - On success, responds with [`DeleteMemberOutput`](crate::output::DeleteMemberOutput)

    /// - On failure, responds with [`SdkError<DeleteMemberError>`](crate::error::DeleteMemberError)
    pub fn delete_member(&self) -> fluent_builders::DeleteMember {
        fluent_builders::DeleteMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteNode`](crate::client::fluent_builders::DeleteNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNode::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::DeleteNode::set_network_id): <p>The unique identifier of the network that the node is on.</p>  <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>  <ul>   <li> <p> <code>n-ethereum-mainnet</code> </p> </li>   <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>   <li> <p> <code>n-ethereum-ropsten</code> </p> </li>  </ul>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNode::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::DeleteNode::set_member_id): <p>The unique identifier of the member that owns this node.</p>  <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    ///   - [`node_id(impl Into<String>)`](crate::client::fluent_builders::DeleteNode::node_id) / [`set_node_id(Option<String>)`](crate::client::fluent_builders::DeleteNode::set_node_id): <p>The unique identifier of the node.</p>
    /// - On success, responds with [`DeleteNodeOutput`](crate::output::DeleteNodeOutput)

    /// - On failure, responds with [`SdkError<DeleteNodeError>`](crate::error::DeleteNodeError)
    pub fn delete_node(&self) -> fluent_builders::DeleteNode {
        fluent_builders::DeleteNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMember`](crate::client::fluent_builders::GetMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::GetMember::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::GetMember::set_network_id): <p>The unique identifier of the network to which the member belongs.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::GetMember::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::GetMember::set_member_id): <p>The unique identifier of the member.</p>
    /// - On success, responds with [`GetMemberOutput`](crate::output::GetMemberOutput) with field(s):
    ///   - [`member(Option<Member>)`](crate::output::GetMemberOutput::member): <p>The properties of a member.</p>
    /// - On failure, responds with [`SdkError<GetMemberError>`](crate::error::GetMemberError)
    pub fn get_member(&self) -> fluent_builders::GetMember {
        fluent_builders::GetMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNetwork`](crate::client::fluent_builders::GetNetwork) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::GetNetwork::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::GetNetwork::set_network_id): <p>The unique identifier of the network to get information about.</p>
    /// - On success, responds with [`GetNetworkOutput`](crate::output::GetNetworkOutput) with field(s):
    ///   - [`network(Option<Network>)`](crate::output::GetNetworkOutput::network): <p>An object containing network configuration parameters.</p>
    /// - On failure, responds with [`SdkError<GetNetworkError>`](crate::error::GetNetworkError)
    pub fn get_network(&self) -> fluent_builders::GetNetwork {
        fluent_builders::GetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetNode`](crate::client::fluent_builders::GetNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::GetNode::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::GetNode::set_network_id): <p>The unique identifier of the network that the node is on.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::GetNode::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::GetNode::set_member_id): <p>The unique identifier of the member that owns the node.</p>  <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    ///   - [`node_id(impl Into<String>)`](crate::client::fluent_builders::GetNode::node_id) / [`set_node_id(Option<String>)`](crate::client::fluent_builders::GetNode::set_node_id): <p>The unique identifier of the node.</p>
    /// - On success, responds with [`GetNodeOutput`](crate::output::GetNodeOutput) with field(s):
    ///   - [`node(Option<Node>)`](crate::output::GetNodeOutput::node): <p>Properties of the node configuration.</p>
    /// - On failure, responds with [`SdkError<GetNodeError>`](crate::error::GetNodeError)
    pub fn get_node(&self) -> fluent_builders::GetNode {
        fluent_builders::GetNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetProposal`](crate::client::fluent_builders::GetProposal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::GetProposal::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::GetProposal::set_network_id): <p>The unique identifier of the network for which the proposal is made.</p>
    ///   - [`proposal_id(impl Into<String>)`](crate::client::fluent_builders::GetProposal::proposal_id) / [`set_proposal_id(Option<String>)`](crate::client::fluent_builders::GetProposal::set_proposal_id): <p>The unique identifier of the proposal.</p>
    /// - On success, responds with [`GetProposalOutput`](crate::output::GetProposalOutput) with field(s):
    ///   - [`proposal(Option<Proposal>)`](crate::output::GetProposalOutput::proposal): <p>Information about a proposal.</p>
    /// - On failure, responds with [`SdkError<GetProposalError>`](crate::error::GetProposalError)
    pub fn get_proposal(&self) -> fluent_builders::GetProposal {
        fluent_builders::GetProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInvitations`](crate::client::fluent_builders::ListInvitations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInvitations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInvitations::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListInvitations::set_max_results): <p>The maximum number of invitations to return.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInvitations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInvitations::set_next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListInvitationsOutput`](crate::output::ListInvitationsOutput) with field(s):
    ///   - [`invitations(Option<Vec<Invitation>>)`](crate::output::ListInvitationsOutput::invitations): <p>The invitations for the network.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInvitationsOutput::next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListInvitationsError>`](crate::error::ListInvitationsError)
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMembers`](crate::client::fluent_builders::ListMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::ListMembers::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::ListMembers::set_network_id): <p>The unique identifier of the network for which to list members.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListMembers::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListMembers::set_name): <p>The optional name of the member to list.</p>
    ///   - [`status(MemberStatus)`](crate::client::fluent_builders::ListMembers::status) / [`set_status(Option<MemberStatus>)`](crate::client::fluent_builders::ListMembers::set_status): <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
    ///   - [`is_owned(bool)`](crate::client::fluent_builders::ListMembers::is_owned) / [`set_is_owned(Option<bool>)`](crate::client::fluent_builders::ListMembers::set_is_owned): <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMembers::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMembers::set_max_results): <p>The maximum number of members to return in the request.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMembers::set_next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListMembersOutput`](crate::output::ListMembersOutput) with field(s):
    ///   - [`members(Option<Vec<MemberSummary>>)`](crate::output::ListMembersOutput::members): <p>An array of <code>MemberSummary</code> objects. Each object contains details about a network member.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMembersOutput::next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListMembersError>`](crate::error::ListMembersError)
    pub fn list_members(&self) -> fluent_builders::ListMembers {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNetworks`](crate::client::fluent_builders::ListNetworks) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNetworks::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::ListNetworks::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::ListNetworks::set_name): <p>The name of the network.</p>
    ///   - [`framework(Framework)`](crate::client::fluent_builders::ListNetworks::framework) / [`set_framework(Option<Framework>)`](crate::client::fluent_builders::ListNetworks::set_framework): <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
    ///   - [`status(NetworkStatus)`](crate::client::fluent_builders::ListNetworks::status) / [`set_status(Option<NetworkStatus>)`](crate::client::fluent_builders::ListNetworks::set_status): <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>  <p>Applies only to Hyperledger Fabric.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNetworks::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNetworks::set_max_results): <p>The maximum number of networks to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNetworks::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNetworks::set_next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListNetworksOutput`](crate::output::ListNetworksOutput) with field(s):
    ///   - [`networks(Option<Vec<NetworkSummary>>)`](crate::output::ListNetworksOutput::networks): <p>An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNetworksOutput::next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListNetworksError>`](crate::error::ListNetworksError)
    pub fn list_networks(&self) -> fluent_builders::ListNetworks {
        fluent_builders::ListNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListNodes`](crate::client::fluent_builders::ListNodes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListNodes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::ListNodes::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::ListNodes::set_network_id): <p>The unique identifier of the network for which to list nodes.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::ListNodes::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::ListNodes::set_member_id): <p>The unique identifier of the member who owns the nodes to list.</p>  <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
    ///   - [`status(NodeStatus)`](crate::client::fluent_builders::ListNodes::status) / [`set_status(Option<NodeStatus>)`](crate::client::fluent_builders::ListNodes::set_status): <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListNodes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListNodes::set_max_results): <p>The maximum number of nodes to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListNodes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListNodes::set_next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On success, responds with [`ListNodesOutput`](crate::output::ListNodesOutput) with field(s):
    ///   - [`nodes(Option<Vec<NodeSummary>>)`](crate::output::ListNodesOutput::nodes): <p>An array of <code>NodeSummary</code> objects that contain configuration properties for each node.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListNodesOutput::next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListNodesError>`](crate::error::ListNodesError)
    pub fn list_nodes(&self) -> fluent_builders::ListNodes {
        fluent_builders::ListNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProposals`](crate::client::fluent_builders::ListProposals) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProposals::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::ListProposals::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::ListProposals::set_network_id): <p> The unique identifier of the network. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProposals::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProposals::set_max_results): <p> The maximum number of proposals to return. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProposals::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProposals::set_next_token): <p> The pagination token that indicates the next set of results to retrieve. </p>
    /// - On success, responds with [`ListProposalsOutput`](crate::output::ListProposalsOutput) with field(s):
    ///   - [`proposals(Option<Vec<ProposalSummary>>)`](crate::output::ListProposalsOutput::proposals): <p>The summary of each proposal made on the network.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProposalsOutput::next_token): <p>The pagination token that indicates the next set of results to retrieve.</p>
    /// - On failure, responds with [`SdkError<ListProposalsError>`](crate::error::ListProposalsError)
    pub fn list_proposals(&self) -> fluent_builders::ListProposals {
        fluent_builders::ListProposals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProposalVotes`](crate::client::fluent_builders::ListProposalVotes) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProposalVotes::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::ListProposalVotes::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::ListProposalVotes::set_network_id): <p> The unique identifier of the network. </p>
    ///   - [`proposal_id(impl Into<String>)`](crate::client::fluent_builders::ListProposalVotes::proposal_id) / [`set_proposal_id(Option<String>)`](crate::client::fluent_builders::ListProposalVotes::set_proposal_id): <p> The unique identifier of the proposal. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProposalVotes::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProposalVotes::set_max_results): <p> The maximum number of votes to return. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProposalVotes::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProposalVotes::set_next_token): <p> The pagination token that indicates the next set of results to retrieve. </p>
    /// - On success, responds with [`ListProposalVotesOutput`](crate::output::ListProposalVotesOutput) with field(s):
    ///   - [`proposal_votes(Option<Vec<VoteSummary>>)`](crate::output::ListProposalVotesOutput::proposal_votes): <p> The list of votes. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProposalVotesOutput::next_token): <p> The pagination token that indicates the next set of results to retrieve. </p>
    /// - On failure, responds with [`SdkError<ListProposalVotesError>`](crate::error::ListProposalVotesError)
    pub fn list_proposal_votes(&self) -> fluent_builders::ListProposalVotes {
        fluent_builders::ListProposalVotes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>The tags assigned to the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`RejectInvitation`](crate::client::fluent_builders::RejectInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`invitation_id(impl Into<String>)`](crate::client::fluent_builders::RejectInvitation::invitation_id) / [`set_invitation_id(Option<String>)`](crate::client::fluent_builders::RejectInvitation::set_invitation_id): <p>The unique identifier of the invitation to reject.</p>
    /// - On success, responds with [`RejectInvitationOutput`](crate::output::RejectInvitationOutput)

    /// - On failure, responds with [`SdkError<RejectInvitationError>`](crate::error::RejectInvitationError)
    pub fn reject_invitation(&self) -> fluent_builders::RejectInvitation {
        fluent_builders::RejectInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The tag keys.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMember`](crate::client::fluent_builders::UpdateMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMember::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::UpdateMember::set_network_id): <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMember::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::UpdateMember::set_member_id): <p>The unique identifier of the member.</p>
    ///   - [`log_publishing_configuration(MemberLogPublishingConfiguration)`](crate::client::fluent_builders::UpdateMember::log_publishing_configuration) / [`set_log_publishing_configuration(Option<MemberLogPublishingConfiguration>)`](crate::client::fluent_builders::UpdateMember::set_log_publishing_configuration): <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
    /// - On success, responds with [`UpdateMemberOutput`](crate::output::UpdateMemberOutput)

    /// - On failure, responds with [`SdkError<UpdateMemberError>`](crate::error::UpdateMemberError)
    pub fn update_member(&self) -> fluent_builders::UpdateMember {
        fluent_builders::UpdateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateNode`](crate::client::fluent_builders::UpdateNode) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNode::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::UpdateNode::set_network_id): <p>The unique identifier of the network that the node is on.</p>
    ///   - [`member_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNode::member_id) / [`set_member_id(Option<String>)`](crate::client::fluent_builders::UpdateNode::set_member_id): <p>The unique identifier of the member that owns the node.</p>  <p>Applies only to Hyperledger Fabric.</p>
    ///   - [`node_id(impl Into<String>)`](crate::client::fluent_builders::UpdateNode::node_id) / [`set_node_id(Option<String>)`](crate::client::fluent_builders::UpdateNode::set_node_id): <p>The unique identifier of the node.</p>
    ///   - [`log_publishing_configuration(NodeLogPublishingConfiguration)`](crate::client::fluent_builders::UpdateNode::log_publishing_configuration) / [`set_log_publishing_configuration(Option<NodeLogPublishingConfiguration>)`](crate::client::fluent_builders::UpdateNode::set_log_publishing_configuration): <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
    /// - On success, responds with [`UpdateNodeOutput`](crate::output::UpdateNodeOutput)

    /// - On failure, responds with [`SdkError<UpdateNodeError>`](crate::error::UpdateNodeError)
    pub fn update_node(&self) -> fluent_builders::UpdateNode {
        fluent_builders::UpdateNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`VoteOnProposal`](crate::client::fluent_builders::VoteOnProposal) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`network_id(impl Into<String>)`](crate::client::fluent_builders::VoteOnProposal::network_id) / [`set_network_id(Option<String>)`](crate::client::fluent_builders::VoteOnProposal::set_network_id): <p> The unique identifier of the network. </p>
    ///   - [`proposal_id(impl Into<String>)`](crate::client::fluent_builders::VoteOnProposal::proposal_id) / [`set_proposal_id(Option<String>)`](crate::client::fluent_builders::VoteOnProposal::set_proposal_id): <p> The unique identifier of the proposal. </p>
    ///   - [`voter_member_id(impl Into<String>)`](crate::client::fluent_builders::VoteOnProposal::voter_member_id) / [`set_voter_member_id(Option<String>)`](crate::client::fluent_builders::VoteOnProposal::set_voter_member_id): <p>The unique identifier of the member casting the vote. </p>
    ///   - [`vote(VoteValue)`](crate::client::fluent_builders::VoteOnProposal::vote) / [`set_vote(Option<VoteValue>)`](crate::client::fluent_builders::VoteOnProposal::set_vote): <p> The value of the vote. </p>
    /// - On success, responds with [`VoteOnProposalOutput`](crate::output::VoteOnProposalOutput)

    /// - On failure, responds with [`SdkError<VoteOnProposalError>`](crate::error::VoteOnProposalError)
    pub fn vote_on_proposal(&self) -> fluent_builders::VoteOnProposal {
        fluent_builders::VoteOnProposal::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateMember`.
    ///
    /// <p>Creates a member within a Managed Blockchain network.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_member_input::Builder,
    }
    impl CreateMember {
        /// Creates a new `CreateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(input.into());
            self
        }
        /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
        /// <p>The unique identifier of the network in which the member is created.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network in which the member is created.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>Member configuration parameters.</p>
        pub fn member_configuration(mut self, input: crate::model::MemberConfiguration) -> Self {
            self.inner = self.inner.member_configuration(input);
            self
        }
        /// <p>Member configuration parameters.</p>
        pub fn set_member_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_member_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetwork`.
    ///
    /// <p>Creates a new blockchain network using Amazon Managed Blockchain.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_network_input::Builder,
    }
    impl CreateNetwork {
        /// Creates a new `CreateNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>An optional description for the network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.inner = self.inner.framework(input);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn framework_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_version(input.into());
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn set_framework_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_version(input);
            self
        }
        /// <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
        pub fn framework_configuration(
            mut self,
            input: crate::model::NetworkFrameworkConfiguration,
        ) -> Self {
            self.inner = self.inner.framework_configuration(input);
            self
        }
        /// <p> Configuration properties of the blockchain framework relevant to the network configuration. </p>
        pub fn set_framework_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkFrameworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_framework_configuration(input);
            self
        }
        /// <p> The voting rules used by the network to determine if a proposal is approved. </p>
        pub fn voting_policy(mut self, input: crate::model::VotingPolicy) -> Self {
            self.inner = self.inner.voting_policy(input);
            self
        }
        /// <p> The voting rules used by the network to determine if a proposal is approved. </p>
        pub fn set_voting_policy(
            mut self,
            input: std::option::Option<crate::model::VotingPolicy>,
        ) -> Self {
            self.inner = self.inner.set_voting_policy(input);
            self
        }
        /// <p>Configuration properties for the first member within the network.</p>
        pub fn member_configuration(mut self, input: crate::model::MemberConfiguration) -> Self {
            self.inner = self.inner.member_configuration(input);
            self
        }
        /// <p>Configuration properties for the first member within the network.</p>
        pub fn set_member_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_member_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNode`.
    ///
    /// <p>Creates a node on the specified blockchain network.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_node_input::Builder,
    }
    impl CreateNode {
        /// Creates a new `CreateNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The unique identifier of the network for the node.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network for the node.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The properties of a node configuration.</p>
        pub fn node_configuration(mut self, input: crate::model::NodeConfiguration) -> Self {
            self.inner = self.inner.node_configuration(input);
            self
        }
        /// <p>The properties of a node configuration.</p>
        pub fn set_node_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_node_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProposal`.
    ///
    /// <p>Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProposal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_proposal_input::Builder,
    }
    impl CreateProposal {
        /// Creates a new `CreateProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProposalOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProposalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p> The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p> The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
        pub fn actions(mut self, input: crate::model::ProposalActions) -> Self {
            self.inner = self.inner.actions(input);
            self
        }
        /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<crate::model::ProposalActions>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMember`.
    ///
    /// <p>Deletes a member. Deleting a member removes the member and all associated resources from the network. <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing the action is associated with the AWS account that owns the member. In all other cases, the <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If <code>MemberId</code> is the last member in a network specified by the last AWS account, the network is deleted also.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_member_input::Builder,
    }
    impl DeleteMember {
        /// Creates a new `DeleteMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network from which the member is removed.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network from which the member is removed.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNode`.
    ///
    /// <p>Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_node_input::Builder,
    }
    impl DeleteNode {
        /// Creates a new `DeleteNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li> <p> <code>n-ethereum-mainnet</code> </p> </li>
        /// <li> <p> <code>n-ethereum-rinkeby</code> </p> </li>
        /// <li> <p> <code>n-ethereum-ropsten</code> </p> </li>
        /// </ul>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMember`.
    ///
    /// <p>Returns detailed information about a member.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_member_input::Builder,
    }
    impl GetMember {
        /// Creates a new `GetMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetwork`.
    ///
    /// <p>Returns detailed information about a network.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNetwork {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_network_input::Builder,
    }
    impl GetNetwork {
        /// Creates a new `GetNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network to get information about.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network to get information about.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNode`.
    ///
    /// <p>Returns detailed information about a node.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_node_input::Builder,
    }
    impl GetNode {
        /// Creates a new `GetNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProposal`.
    ///
    /// <p>Returns detailed information about a proposal.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetProposal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_proposal_input::Builder,
    }
    impl GetProposal {
        /// Creates a new `GetProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProposalOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProposalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(input.into());
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Returns a list of all invitations for the current AWS account.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInvitations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl ListInvitations {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInvitationsPaginator {
            crate::paginator::ListInvitationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of invitations to return.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of invitations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Returns a list of the members in a network and properties of their configurations.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMembers {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_members_input::Builder,
    }
    impl ListMembers {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMembersPaginator {
            crate::paginator::ListMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the network for which to list members.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network for which to list members.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The optional name of the member to list.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The optional name of the member to list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
        pub fn status(mut self, input: crate::model::MemberStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MemberStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
        pub fn is_owned(mut self, input: bool) -> Self {
            self.inner = self.inner.is_owned(input);
            self
        }
        /// <p>An optional Boolean value. If provided, the request is limited either to members that the current AWS account owns (<code>true</code>) or that other AWS accounts own (<code>false</code>). If omitted, all members are listed.</p>
        pub fn set_is_owned(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_owned(input);
            self
        }
        /// <p>The maximum number of members to return in the request.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of members to return in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNetworks`.
    ///
    /// <p>Returns information about the networks in which the current AWS account participates.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNetworks {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_networks_input::Builder,
    }
    impl ListNetworks {
        /// Creates a new `ListNetworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNetworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNetworksError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNetworksPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNetworksPaginator {
            crate::paginator::ListNetworksPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.inner = self.inner.framework(input);
            self
        }
        /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn status(mut self, input: crate::model::NetworkStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NetworkStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of networks to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of networks to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNodes`.
    ///
    /// <p>Returns information about the nodes within a network.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListNodes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_nodes_input::Builder,
    }
    impl ListNodes {
        /// Creates a new `ListNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNodesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListNodesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListNodesPaginator {
            crate::paginator::ListNodesPaginator::new(self.handle, self.inner)
        }
        /// <p>The unique identifier of the network for which to list nodes.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network for which to list nodes.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member who owns the nodes to list.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member who owns the nodes to list.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
        pub fn status(mut self, input: crate::model::NodeStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::NodeStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of nodes to list.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of nodes to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProposals`.
    ///
    /// <p>Returns a list of proposals for the network.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProposals {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_proposals_input::Builder,
    }
    impl ListProposals {
        /// Creates a new `ListProposals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProposalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProposalsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProposalsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProposalsPaginator {
            crate::paginator::ListProposalsPaginator::new(self.handle, self.inner)
        }
        /// <p> The unique identifier of the network. </p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p> The unique identifier of the network. </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p> The maximum number of proposals to return. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of proposals to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProposalVotes`.
    ///
    /// <p>Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProposalVotes {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_proposal_votes_input::Builder,
    }
    impl ListProposalVotes {
        /// Creates a new `ListProposalVotes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProposalVotesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProposalVotesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProposalVotesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProposalVotesPaginator {
            crate::paginator::ListProposalVotesPaginator::new(self.handle, self.inner)
        }
        /// <p> The unique identifier of the network. </p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p> The unique identifier of the network. </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(input.into());
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p> The maximum number of votes to return. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p> The maximum number of votes to return. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p> The pagination token that indicates the next set of results to retrieve. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags for the specified resource. Each tag consists of a key and optional value.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInvitation`.
    ///
    /// <p>Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has received an invitation to create a member and join a network.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct RejectInvitation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::reject_invitation_input::Builder,
    }
    impl RejectInvitation {
        /// Creates a new `RejectInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectInvitationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the invitation to reject.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(input.into());
            self
        }
        /// <p>The unique identifier of the invitation to reject.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.</p>
    /// <p>When you specify a tag key that already exists, the tag value is overwritten with the new value. Use <code>UntagResource</code> to remove tag keys.</p>
    /// <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the Amazon Managed Blockchain resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMember`.
    ///
    /// <p>Updates a member configuration with new parameters.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMember {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_member_input::Builder,
    }
    impl UpdateMember {
        /// Creates a new `UpdateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMemberError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::MemberLogPublishingConfiguration,
        ) -> Self {
            self.inner = self.inner.log_publishing_configuration(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNode`.
    ///
    /// <p>Updates a node configuration with new parameters.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateNode {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_node_input::Builder,
    }
    impl UpdateNode {
        /// Creates a new `UpdateNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNodeError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::NodeLogPublishingConfiguration,
        ) -> Self {
            self.inner = self.inner.log_publishing_configuration(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VoteOnProposal`.
    ///
    /// <p>Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by <code>VoterMemberId</code>, must be in the same AWS account as the principal that calls the action.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct VoteOnProposal {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::vote_on_proposal_input::Builder,
    }
    impl VoteOnProposal {
        /// Creates a new `VoteOnProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VoteOnProposalOutput,
            aws_smithy_http::result::SdkError<crate::error::VoteOnProposalError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The unique identifier of the network. </p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(input.into());
            self
        }
        /// <p> The unique identifier of the network. </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(input.into());
            self
        }
        /// <p> The unique identifier of the proposal. </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>The unique identifier of the member casting the vote. </p>
        pub fn voter_member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voter_member_id(input.into());
            self
        }
        /// <p>The unique identifier of the member casting the vote. </p>
        pub fn set_voter_member_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voter_member_id(input);
            self
        }
        /// <p> The value of the vote. </p>
        pub fn vote(mut self, input: crate::model::VoteValue) -> Self {
            self.inner = self.inner.vote(input);
            self
        }
        /// <p> The value of the vote. </p>
        pub fn set_vote(mut self, input: std::option::Option<crate::model::VoteValue>) -> Self {
            self.inner = self.inner.set_vote(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
