// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `TaigaWebService`.
///
/// This client allows ergonomic access to a `TaigaWebService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateMember` operation.
    ///
    /// See [`CreateMember`](crate::client::fluent_builders::CreateMember) for more information about the
    /// operation and its arguments.
    pub fn create_member(&self) -> fluent_builders::CreateMember<C, M, R> {
        fluent_builders::CreateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNetwork` operation.
    ///
    /// See [`CreateNetwork`](crate::client::fluent_builders::CreateNetwork) for more information about the
    /// operation and its arguments.
    pub fn create_network(&self) -> fluent_builders::CreateNetwork<C, M, R> {
        fluent_builders::CreateNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateNode` operation.
    ///
    /// See [`CreateNode`](crate::client::fluent_builders::CreateNode) for more information about the
    /// operation and its arguments.
    pub fn create_node(&self) -> fluent_builders::CreateNode<C, M, R> {
        fluent_builders::CreateNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProposal` operation.
    ///
    /// See [`CreateProposal`](crate::client::fluent_builders::CreateProposal) for more information about the
    /// operation and its arguments.
    pub fn create_proposal(&self) -> fluent_builders::CreateProposal<C, M, R> {
        fluent_builders::CreateProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMember` operation.
    ///
    /// See [`DeleteMember`](crate::client::fluent_builders::DeleteMember) for more information about the
    /// operation and its arguments.
    pub fn delete_member(&self) -> fluent_builders::DeleteMember<C, M, R> {
        fluent_builders::DeleteMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteNode` operation.
    ///
    /// See [`DeleteNode`](crate::client::fluent_builders::DeleteNode) for more information about the
    /// operation and its arguments.
    pub fn delete_node(&self) -> fluent_builders::DeleteNode<C, M, R> {
        fluent_builders::DeleteNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMember` operation.
    ///
    /// See [`GetMember`](crate::client::fluent_builders::GetMember) for more information about the
    /// operation and its arguments.
    pub fn get_member(&self) -> fluent_builders::GetMember<C, M, R> {
        fluent_builders::GetMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNetwork` operation.
    ///
    /// See [`GetNetwork`](crate::client::fluent_builders::GetNetwork) for more information about the
    /// operation and its arguments.
    pub fn get_network(&self) -> fluent_builders::GetNetwork<C, M, R> {
        fluent_builders::GetNetwork::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetNode` operation.
    ///
    /// See [`GetNode`](crate::client::fluent_builders::GetNode) for more information about the
    /// operation and its arguments.
    pub fn get_node(&self) -> fluent_builders::GetNode<C, M, R> {
        fluent_builders::GetNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetProposal` operation.
    ///
    /// See [`GetProposal`](crate::client::fluent_builders::GetProposal) for more information about the
    /// operation and its arguments.
    pub fn get_proposal(&self) -> fluent_builders::GetProposal<C, M, R> {
        fluent_builders::GetProposal::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInvitations` operation.
    ///
    /// See [`ListInvitations`](crate::client::fluent_builders::ListInvitations) for more information about the
    /// operation and its arguments.
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations<C, M, R> {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMembers` operation.
    ///
    /// See [`ListMembers`](crate::client::fluent_builders::ListMembers) for more information about the
    /// operation and its arguments.
    pub fn list_members(&self) -> fluent_builders::ListMembers<C, M, R> {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNetworks` operation.
    ///
    /// See [`ListNetworks`](crate::client::fluent_builders::ListNetworks) for more information about the
    /// operation and its arguments.
    pub fn list_networks(&self) -> fluent_builders::ListNetworks<C, M, R> {
        fluent_builders::ListNetworks::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListNodes` operation.
    ///
    /// See [`ListNodes`](crate::client::fluent_builders::ListNodes) for more information about the
    /// operation and its arguments.
    pub fn list_nodes(&self) -> fluent_builders::ListNodes<C, M, R> {
        fluent_builders::ListNodes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProposals` operation.
    ///
    /// See [`ListProposals`](crate::client::fluent_builders::ListProposals) for more information about the
    /// operation and its arguments.
    pub fn list_proposals(&self) -> fluent_builders::ListProposals<C, M, R> {
        fluent_builders::ListProposals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProposalVotes` operation.
    ///
    /// See [`ListProposalVotes`](crate::client::fluent_builders::ListProposalVotes) for more information about the
    /// operation and its arguments.
    pub fn list_proposal_votes(&self) -> fluent_builders::ListProposalVotes<C, M, R> {
        fluent_builders::ListProposalVotes::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `RejectInvitation` operation.
    ///
    /// See [`RejectInvitation`](crate::client::fluent_builders::RejectInvitation) for more information about the
    /// operation and its arguments.
    pub fn reject_invitation(&self) -> fluent_builders::RejectInvitation<C, M, R> {
        fluent_builders::RejectInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMember` operation.
    ///
    /// See [`UpdateMember`](crate::client::fluent_builders::UpdateMember) for more information about the
    /// operation and its arguments.
    pub fn update_member(&self) -> fluent_builders::UpdateMember<C, M, R> {
        fluent_builders::UpdateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateNode` operation.
    ///
    /// See [`UpdateNode`](crate::client::fluent_builders::UpdateNode) for more information about the
    /// operation and its arguments.
    pub fn update_node(&self) -> fluent_builders::UpdateNode<C, M, R> {
        fluent_builders::UpdateNode::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `VoteOnProposal` operation.
    ///
    /// See [`VoteOnProposal`](crate::client::fluent_builders::VoteOnProposal) for more information about the
    /// operation and its arguments.
    pub fn vote_on_proposal(&self) -> fluent_builders::VoteOnProposal<C, M, R> {
        fluent_builders::VoteOnProposal::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateMember`.
    ///
    /// <p>Creates a member within a Managed Blockchain network.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_member_input::Builder,
    }
    impl<C, M, R> CreateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMemberInputOperationOutputAlias,
                crate::output::CreateMemberOutput,
                crate::error::CreateMemberError,
                crate::input::CreateMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
        pub fn invitation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(inp);
            self
        }
        /// <p>The unique identifier of the invitation that is sent to the member to join the network.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
        /// <p>The unique identifier of the network in which the member is created.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network in which the member is created.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>Member configuration parameters.</p>
        pub fn member_configuration(mut self, inp: crate::model::MemberConfiguration) -> Self {
            self.inner = self.inner.member_configuration(inp);
            self
        }
        /// <p>Member configuration parameters.</p>
        pub fn set_member_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_member_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNetwork`.
    ///
    /// <p>Creates a new blockchain network using Amazon Managed Blockchain.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_network_input::Builder,
    }
    impl<C, M, R> CreateNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNetworkInputOperationOutputAlias,
                crate::output::CreateNetworkOutput,
                crate::error::CreateNetworkError,
                crate::input::CreateNetworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional description for the network.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>An optional description for the network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn framework(mut self, inp: crate::model::Framework) -> Self {
            self.inner = self.inner.framework(inp);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn framework_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.framework_version(inp);
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn set_framework_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_framework_version(input);
            self
        }
        /// <p>
        /// Configuration properties of the blockchain framework relevant to the network configuration.
        /// </p>
        pub fn framework_configuration(
            mut self,
            inp: crate::model::NetworkFrameworkConfiguration,
        ) -> Self {
            self.inner = self.inner.framework_configuration(inp);
            self
        }
        /// <p>
        /// Configuration properties of the blockchain framework relevant to the network configuration.
        /// </p>
        pub fn set_framework_configuration(
            mut self,
            input: std::option::Option<crate::model::NetworkFrameworkConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_framework_configuration(input);
            self
        }
        /// <p>
        /// The voting rules used by the network to determine if a proposal is approved.
        /// </p>
        pub fn voting_policy(mut self, inp: crate::model::VotingPolicy) -> Self {
            self.inner = self.inner.voting_policy(inp);
            self
        }
        /// <p>
        /// The voting rules used by the network to determine if a proposal is approved.
        /// </p>
        pub fn set_voting_policy(
            mut self,
            input: std::option::Option<crate::model::VotingPolicy>,
        ) -> Self {
            self.inner = self.inner.set_voting_policy(input);
            self
        }
        /// <p>Configuration properties for the first member within the network.</p>
        pub fn member_configuration(mut self, inp: crate::model::MemberConfiguration) -> Self {
            self.inner = self.inner.member_configuration(inp);
            self
        }
        /// <p>Configuration properties for the first member within the network.</p>
        pub fn set_member_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_member_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags to assign to the network. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateNode`.
    ///
    /// <p>Creates a node on the specified blockchain network.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_node_input::Builder,
    }
    impl<C, M, R> CreateNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateNodeInputOperationOutputAlias,
                crate::output::CreateNodeOutput,
                crate::error::CreateNodeError,
                crate::input::CreateNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>The unique identifier of the network for the node.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>n-ethereum-mainnet</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-rinkeby</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-ropsten</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network for the node.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>n-ethereum-mainnet</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-rinkeby</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-ropsten</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The properties of a node configuration.</p>
        pub fn node_configuration(mut self, inp: crate::model::NodeConfiguration) -> Self {
            self.inner = self.inner.node_configuration(inp);
            self
        }
        /// <p>The properties of a node configuration.</p>
        pub fn set_node_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_node_configuration(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags to assign to the node. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProposal`.
    ///
    /// <p>Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProposal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_proposal_input::Builder,
    }
    impl<C, M, R> CreateProposal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProposalOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProposalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProposalInputOperationOutputAlias,
                crate::output::CreateProposalOutput,
                crate::error::CreateProposalError,
                crate::input::CreateProposalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn client_request_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_request_token(inp);
            self
        }
        /// <p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.</p>
        pub fn set_client_request_token(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_client_request_token(input);
            self
        }
        /// <p>
        /// The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>
        /// The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single AWS account.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
        pub fn actions(mut self, inp: crate::model::ProposalActions) -> Self {
            self.inner = self.inner.actions(inp);
            self
        }
        /// <p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<crate::model::ProposalActions>,
        ) -> Self {
            self.inner = self.inner.set_actions(input);
            self
        }
        /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>Tags to assign to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource. If the proposal is for a network invitation, the invitation inherits the tags added to the proposal.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMember`.
    ///
    /// <p>Deletes a member. Deleting a member removes the member and all associated resources from the network. <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing the action is associated with the AWS account that owns the member. In all other cases, the <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If <code>MemberId</code> is the last member in a network specified by the last AWS account, the network is deleted also.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_member_input::Builder,
    }
    impl<C, M, R> DeleteMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMemberInputOperationOutputAlias,
                crate::output::DeleteMemberOutput,
                crate::error::DeleteMemberError,
                crate::input::DeleteMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network from which the member is removed.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network from which the member is removed.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteNode`.
    ///
    /// <p>Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_node_input::Builder,
    }
    impl<C, M, R> DeleteNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteNodeInputOperationOutputAlias,
                crate::output::DeleteNodeOutput,
                crate::error::DeleteNodeError,
                crate::input::DeleteNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>n-ethereum-mainnet</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-rinkeby</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-ropsten</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        /// <p>Ethereum public networks have the following <code>NetworkId</code>s:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>n-ethereum-mainnet</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-rinkeby</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>n-ethereum-ropsten</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member that owns this node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(inp);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMember`.
    ///
    /// <p>Returns detailed information about a member.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_member_input::Builder,
    }
    impl<C, M, R> GetMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMemberInputOperationOutputAlias,
                crate::output::GetMemberOutput,
                crate::error::GetMemberError,
                crate::input::GetMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNetwork`.
    ///
    /// <p>Returns detailed information about a network.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetNetwork<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_network_input::Builder,
    }
    impl<C, M, R> GetNetwork<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNetwork`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNetworkOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNetworkError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNetworkInputOperationOutputAlias,
                crate::output::GetNetworkOutput,
                crate::error::GetNetworkError,
                crate::input::GetNetworkInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network to get information about.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network to get information about.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetNode`.
    ///
    /// <p>Returns detailed information about a node.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_node_input::Builder,
    }
    impl<C, M, R> GetNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::GetNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetNodeInputOperationOutputAlias,
                crate::output::GetNodeOutput,
                crate::error::GetNodeError,
                crate::input::GetNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(inp);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetProposal`.
    ///
    /// <p>Returns detailed information about a proposal.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetProposal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_proposal_input::Builder,
    }
    impl<C, M, R> GetProposal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetProposalOutput,
            aws_smithy_http::result::SdkError<crate::error::GetProposalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetProposalInputOperationOutputAlias,
                crate::output::GetProposalOutput,
                crate::error::GetProposalError,
                crate::input::GetProposalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn proposal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(inp);
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Returns a list of all invitations for the current AWS account.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl<C, M, R> ListInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInvitationsInputOperationOutputAlias,
                crate::output::ListInvitationsOutput,
                crate::error::ListInvitationsError,
                crate::input::ListInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of invitations to return.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of invitations to return.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Returns a list of the members in a network and properties of their configurations.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_members_input::Builder,
    }
    impl<C, M, R> ListMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMembersInputOperationOutputAlias,
                crate::output::ListMembersOutput,
                crate::error::ListMembersError,
                crate::input::ListMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network for which to list members.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network for which to list members.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The optional name of the member to list.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The optional name of the member to list.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
        pub fn status(mut self, inp: crate::model::MemberStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>An optional status specifier. If provided, only members currently in this status are listed.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MemberStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>An optional Boolean value. If provided, the request is limited either to
        /// members that the current AWS account owns (<code>true</code>) or that other AWS accounts
        /// own (<code>false</code>). If omitted, all members are listed.</p>
        pub fn is_owned(mut self, inp: bool) -> Self {
            self.inner = self.inner.is_owned(inp);
            self
        }
        /// <p>An optional Boolean value. If provided, the request is limited either to
        /// members that the current AWS account owns (<code>true</code>) or that other AWS accounts
        /// own (<code>false</code>). If omitted, all members are listed.</p>
        pub fn set_is_owned(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_is_owned(input);
            self
        }
        /// <p>The maximum number of members to return in the request.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of members to return in the request.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNetworks`.
    ///
    /// <p>Returns information about the networks in which the current AWS account participates.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNetworks<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_networks_input::Builder,
    }
    impl<C, M, R> ListNetworks<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNetworks`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNetworksOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNetworksError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNetworksInputOperationOutputAlias,
                crate::output::ListNetworksOutput,
                crate::error::ListNetworksError,
                crate::input::ListNetworksInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
        pub fn framework(mut self, inp: crate::model::Framework) -> Self {
            self.inner = self.inner.framework(inp);
            self
        }
        /// <p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.inner = self.inner.set_framework(input);
            self
        }
        /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn status(mut self, inp: crate::model::NetworkStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>An optional status specifier. If provided, only networks currently in this status are listed.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NetworkStatus>,
        ) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of networks to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of networks to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListNodes`.
    ///
    /// <p>Returns information about the nodes within a network.</p>
    /// <p>Applies to Hyperledger Fabric and Ethereum.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListNodes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_nodes_input::Builder,
    }
    impl<C, M, R> ListNodes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListNodes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListNodesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListNodesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListNodesInputOperationOutputAlias,
                crate::output::ListNodesOutput,
                crate::error::ListNodesError,
                crate::input::ListNodesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network for which to list nodes.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network for which to list nodes.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member who owns the nodes to list.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member who owns the nodes to list.</p>
        /// <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
        pub fn status(mut self, inp: crate::model::NodeStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::NodeStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
        /// <p>The maximum number of nodes to list.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of nodes to list.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The pagination token that indicates the next set of results to retrieve.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProposals`.
    ///
    /// <p>Returns a list of proposals for the network.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProposals<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_proposals_input::Builder,
    }
    impl<C, M, R> ListProposals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProposals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProposalsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProposalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProposalsInputOperationOutputAlias,
                crate::output::ListProposalsOutput,
                crate::error::ListProposalsError,
                crate::input::ListProposalsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The unique identifier of the network.
        /// </p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>
        /// The unique identifier of the network.
        /// </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>
        /// The maximum number of proposals to return.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of proposals to return.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The pagination token that indicates the next set of results to retrieve.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token that indicates the next set of results to retrieve.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProposalVotes`.
    ///
    /// <p>Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProposalVotes<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_proposal_votes_input::Builder,
    }
    impl<C, M, R> ListProposalVotes<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProposalVotes`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProposalVotesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProposalVotesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProposalVotesInputOperationOutputAlias,
                crate::output::ListProposalVotesOutput,
                crate::error::ListProposalVotesError,
                crate::input::ListProposalVotesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The unique identifier of the network.
        /// </p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>
        /// The unique identifier of the network.
        /// </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>
        /// The unique identifier of the proposal.
        /// </p>
        pub fn proposal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(inp);
            self
        }
        /// <p>
        /// The unique identifier of the proposal.
        /// </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>
        /// The maximum number of votes to return.
        /// </p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>
        /// The maximum number of votes to return.
        /// </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>
        /// The pagination token that indicates the next set of results to retrieve.
        /// </p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>
        /// The pagination token that indicates the next set of results to retrieve.
        /// </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags for the specified resource. Each tag consists of a key and optional value.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `RejectInvitation`.
    ///
    /// <p>Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has received an invitation to create a member and join a network.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct RejectInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::reject_invitation_input::Builder,
    }
    impl<C, M, R> RejectInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `RejectInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::RejectInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::RejectInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::RejectInvitationInputOperationOutputAlias,
                crate::output::RejectInvitationOutput,
                crate::error::RejectInvitationError,
                crate::input::RejectInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the invitation to reject.</p>
        pub fn invitation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(inp);
            self
        }
        /// <p>The unique identifier of the invitation to reject.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.</p>
    /// <p>When you specify a tag key that already exists, the tag value is overwritten with the new value. Use <code>UntagResource</code> to remove tag keys.</p>
    /// <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes the specified tags from the Amazon Managed Blockchain resource.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The tag keys.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The tag keys.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMember`.
    ///
    /// <p>Updates a member configuration with new parameters.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_member_input::Builder,
    }
    impl<C, M, R> UpdateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMemberInputOperationOutputAlias,
                crate::output::UpdateMemberOutput,
                crate::error::UpdateMemberError,
                crate::input::UpdateMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn log_publishing_configuration(
            mut self,
            inp: crate::model::MemberLogPublishingConfiguration,
        ) -> Self {
            self.inner = self.inner.log_publishing_configuration(inp);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateNode`.
    ///
    /// <p>Updates a node configuration with new parameters.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateNode<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_node_input::Builder,
    }
    impl<C, M, R> UpdateNode<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateNode`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateNodeOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateNodeError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateNodeInputOperationOutputAlias,
                crate::output::UpdateNodeOutput,
                crate::error::UpdateNodeError,
                crate::input::UpdateNodeInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_id(inp);
            self
        }
        /// <p>The unique identifier of the member that owns the node.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_member_id(input);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn node_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.node_id(inp);
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_node_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_node_id(input);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn log_publishing_configuration(
            mut self,
            inp: crate::model::NodeLogPublishingConfiguration,
        ) -> Self {
            self.inner = self.inner.log_publishing_configuration(inp);
            self
        }
        /// <p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_log_publishing_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `VoteOnProposal`.
    ///
    /// <p>Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by <code>VoterMemberId</code>, must be in the same AWS account as the principal that calls the action.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    #[derive(std::fmt::Debug)]
    pub struct VoteOnProposal<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::vote_on_proposal_input::Builder,
    }
    impl<C, M, R> VoteOnProposal<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `VoteOnProposal`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::VoteOnProposalOutput,
            aws_smithy_http::result::SdkError<crate::error::VoteOnProposalError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::VoteOnProposalInputOperationOutputAlias,
                crate::output::VoteOnProposalOutput,
                crate::error::VoteOnProposalError,
                crate::input::VoteOnProposalInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>
        /// The unique identifier of the network.
        /// </p>
        pub fn network_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.network_id(inp);
            self
        }
        /// <p>
        /// The unique identifier of the network.
        /// </p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_network_id(input);
            self
        }
        /// <p>
        /// The unique identifier of the proposal.
        /// </p>
        pub fn proposal_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.proposal_id(inp);
            self
        }
        /// <p>
        /// The unique identifier of the proposal.
        /// </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_proposal_id(input);
            self
        }
        /// <p>The unique identifier of the member casting the vote.
        /// </p>
        pub fn voter_member_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.voter_member_id(inp);
            self
        }
        /// <p>The unique identifier of the member casting the vote.
        /// </p>
        pub fn set_voter_member_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_voter_member_id(input);
            self
        }
        /// <p>
        /// The value of the vote.
        /// </p>
        pub fn vote(mut self, inp: crate::model::VoteValue) -> Self {
            self.inner = self.inner.vote(inp);
            self
        }
        /// <p>
        /// The value of the vote.
        /// </p>
        pub fn set_vote(mut self, input: std::option::Option<crate::model::VoteValue>) -> Self {
            self.inner = self.inner.set_vote(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
