// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMemberError {
    /// Kind of error that occurred.
    pub kind: CreateMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource request is issued for a resource that already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The maximum number of resources of that type already exist. Ensure the resources requested are within the boundaries of the service edition and your account limits.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMemberError {
    fn code(&self) -> Option<&str> {
        CreateMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMemberError {
    /// Creates a new `CreateMemberError`.
    pub fn new(kind: CreateMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateMemberErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateMemberErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateMemberErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateMemberErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateMemberErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            CreateMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateMemberErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNetworkError {
    /// Kind of error that occurred.
    pub kind: CreateNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource request is issued for a resource that already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The maximum number of resources of that type already exist. Ensure the resources requested are within the boundaries of the service edition and your account limits.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNetworkError {
    fn code(&self) -> Option<&str> {
        CreateNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNetworkError {
    /// Creates a new `CreateNetworkError`.
    pub fn new(kind: CreateNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNetworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateNetworkErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNetworkErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateNetworkErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateNetworkErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateNetworkErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateNetworkErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateNetworkErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateNetworkErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateNetworkErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateNetworkErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateNodeError {
    /// Kind of error that occurred.
    pub kind: CreateNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateNodeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A resource request is issued for a resource that already exists.</p>
    ResourceAlreadyExistsException(crate::error::ResourceAlreadyExistsException),
    /// <p>The maximum number of resources of that type already exist. Ensure the resources requested are within the boundaries of the service edition and your account limits.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateNodeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::ResourceAlreadyExistsException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateNodeError {
    fn code(&self) -> Option<&str> {
        CreateNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateNodeError {
    /// Creates a new `CreateNodeError`.
    pub fn new(kind: CreateNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateNodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateNodeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, CreateNodeErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::ResourceAlreadyExistsException`.
    pub fn is_resource_already_exists_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeErrorKind::ResourceAlreadyExistsException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateNodeErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateNodeErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateNodeErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateNodeErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateNodeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateNodeErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateNodeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateNodeErrorKind::ResourceAlreadyExistsException(_inner) => Some(_inner),
            CreateNodeErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            CreateNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateNodeErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            CreateNodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateNodeErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProposalError {
    /// Kind of error that occurred.
    pub kind: CreateProposalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProposalErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p></p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProposalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProposalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            CreateProposalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProposalError {
    fn code(&self) -> Option<&str> {
        CreateProposalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProposalError {
    /// Creates a new `CreateProposalError`.
    pub fn new(kind: CreateProposalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProposalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProposalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProposalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProposalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProposalErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProposalErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProposalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProposalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProposalErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateProposalErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateProposalErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, CreateProposalErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for CreateProposalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProposalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateProposalErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            CreateProposalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            CreateProposalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProposalErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            CreateProposalErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProposalErrorKind::TooManyTagsException(_inner) => Some(_inner),
            CreateProposalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMemberError {
    /// Kind of error that occurred.
    pub kind: DeleteMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMemberError {
    fn code(&self) -> Option<&str> {
        DeleteMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMemberError {
    /// Creates a new `DeleteMemberError`.
    pub fn new(kind: DeleteMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteMemberErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteMemberErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteMemberErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteNodeError {
    /// Kind of error that occurred.
    pub kind: DeleteNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteNodeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteNodeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteNodeErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            DeleteNodeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            DeleteNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteNodeErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            DeleteNodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteNodeError {
    fn code(&self) -> Option<&str> {
        DeleteNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteNodeError {
    /// Creates a new `DeleteNodeError`.
    pub fn new(kind: DeleteNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteNodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteNodeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteNodeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteNodeErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodeErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNodeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, DeleteNodeErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `DeleteNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNodeErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteNodeErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteNodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteNodeErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for DeleteNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteNodeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteNodeErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            DeleteNodeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            DeleteNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteNodeErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            DeleteNodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMemberError {
    /// Kind of error that occurred.
    pub kind: GetMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMemberError {
    fn code(&self) -> Option<&str> {
        GetMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMemberError {
    /// Creates a new `GetMemberError`.
    pub fn new(kind: GetMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMemberErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMemberErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            GetMemberErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNetworkError {
    /// Kind of error that occurred.
    pub kind: GetNetworkErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNetwork` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNetworkErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNetworkError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNetworkErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNetworkErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            GetNetworkErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetNetworkErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNetworkErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNetworkErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNetworkError {
    fn code(&self) -> Option<&str> {
        GetNetworkError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNetworkError {
    /// Creates a new `GetNetworkError`.
    pub fn new(kind: GetNetworkErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNetworkError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNetworkErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNetworkError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNetworkErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNetworkErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetNetworkErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetNetworkErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetNetworkErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetNetworkErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNetworkErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNetworkErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetNetworkErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetNetworkError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNetworkErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNetworkErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            GetNetworkErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetNetworkErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNetworkErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNetworkErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetNodeError {
    /// Kind of error that occurred.
    pub kind: GetNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetNodeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetNodeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetNodeErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            GetNodeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetNodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetNodeError {
    fn code(&self) -> Option<&str> {
        GetNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetNodeError {
    /// Creates a new `GetNodeError`.
    pub fn new(kind: GetNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetNodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetNodeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetNodeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetNodeErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetNodeErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetNodeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetNodeErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetNodeErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetNodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetNodeErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetNodeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetNodeErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            GetNodeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetNodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetProposalError {
    /// Kind of error that occurred.
    pub kind: GetProposalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetProposalErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetProposalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetProposalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetProposalErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            GetProposalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            GetProposalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetProposalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetProposalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetProposalError {
    fn code(&self) -> Option<&str> {
        GetProposalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetProposalError {
    /// Creates a new `GetProposalError`.
    pub fn new(kind: GetProposalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetProposalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetProposalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetProposalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetProposalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetProposalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetProposalErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetProposalErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProposalErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProposalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, GetProposalErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `GetProposalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetProposalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetProposalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetProposalErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for GetProposalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetProposalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetProposalErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            GetProposalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            GetProposalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetProposalErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetProposalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInvitationsError {
    /// Kind of error that occurred.
    pub kind: ListInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInvitationsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The maximum number of resources of that type already exist. Ensure the resources requested are within the boundaries of the service edition and your account limits.</p>
    ResourceLimitExceededException(crate::error::ResourceLimitExceededException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInvitationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ResourceLimitExceededException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInvitationsError {
    fn code(&self) -> Option<&str> {
        ListInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInvitationsError {
    /// Creates a new `ListInvitationsError`.
    pub fn new(kind: ListInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ResourceLimitExceededException`.
    pub fn is_resource_limit_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::ResourceLimitExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListInvitationsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInvitationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListInvitationsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListInvitationsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ResourceLimitExceededException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMembersError {
    /// Kind of error that occurred.
    pub kind: ListMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMembersErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMembersError {
    fn code(&self) -> Option<&str> {
        ListMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMembersError {
    /// Creates a new `ListMembersError`.
    pub fn new(kind: ListMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMembersErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMembersErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListMembersErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNetworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNetworksError {
    /// Kind of error that occurred.
    pub kind: ListNetworksErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNetworks` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNetworksErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNetworksError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNetworksErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNetworksErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListNetworksErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListNetworksErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNetworksErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNetworksError {
    fn code(&self) -> Option<&str> {
        ListNetworksError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNetworksError {
    /// Creates a new `ListNetworksError`.
    pub fn new(kind: ListNetworksErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNetworksError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNetworksErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNetworksError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNetworksErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNetworksErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListNetworksErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListNetworksErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworksErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworksErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNetworksErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNetworksErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListNetworksErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListNetworksError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNetworksErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNetworksErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListNetworksErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListNetworksErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNetworksErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListNodesError {
    /// Kind of error that occurred.
    pub kind: ListNodesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListNodes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListNodesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListNodesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListNodesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListNodesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListNodesError {
    fn code(&self) -> Option<&str> {
        ListNodesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListNodesError {
    /// Creates a new `ListNodesError`.
    pub fn new(kind: ListNodesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListNodesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListNodesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListNodesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListNodesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListNodesErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListNodesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, ListNodesErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `ListNodesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListNodesErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListNodesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListNodesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListNodesErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListNodesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListNodesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListNodesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProposals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProposalsError {
    /// Kind of error that occurred.
    pub kind: ListProposalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProposals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProposalsErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProposalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProposalsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProposalsErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListProposalsErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListProposalsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProposalsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProposalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProposalsError {
    fn code(&self) -> Option<&str> {
        ListProposalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProposalsError {
    /// Creates a new `ListProposalsError`.
    pub fn new(kind: ListProposalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProposalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProposalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProposalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProposalsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProposalsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListProposalsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListProposalsErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalsErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProposalsErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalsErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProposalsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProposalsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListProposalsErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for ListProposalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProposalsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProposalsErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListProposalsErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListProposalsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProposalsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProposalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProposalVotes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProposalVotesError {
    /// Kind of error that occurred.
    pub kind: ListProposalVotesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProposalVotes` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProposalVotesErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProposalVotesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProposalVotesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProposalVotesErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListProposalVotesErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListProposalVotesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProposalVotesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProposalVotesError {
    fn code(&self) -> Option<&str> {
        ListProposalVotesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProposalVotesError {
    /// Creates a new `ListProposalVotesError`.
    pub fn new(kind: ListProposalVotesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProposalVotesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProposalVotesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProposalVotesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProposalVotesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListProposalVotesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalVotesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProposalVotesErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalVotesErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProposalVotesErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalVotesErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListProposalVotesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProposalVotesErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for ListProposalVotesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProposalVotesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProposalVotesErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListProposalVotesErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListProposalVotesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProposalVotesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListTagsForResourceErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotReadyException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `RejectInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct RejectInvitationError {
    /// Kind of error that occurred.
    pub kind: RejectInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `RejectInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum RejectInvitationErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    IllegalActionException(crate::error::IllegalActionException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for RejectInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            RejectInvitationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            RejectInvitationErrorKind::IllegalActionException(_inner) => _inner.fmt(f),
            RejectInvitationErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            RejectInvitationErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            RejectInvitationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            RejectInvitationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            RejectInvitationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for RejectInvitationError {
    fn code(&self) -> Option<&str> {
        RejectInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl RejectInvitationError {
    /// Creates a new `RejectInvitationError`.
    pub fn new(kind: RejectInvitationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `RejectInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: RejectInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `RejectInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: RejectInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `RejectInvitationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInvitationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInvitationErrorKind::IllegalActionException`.
    pub fn is_illegal_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInvitationErrorKind::IllegalActionException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInvitationErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInvitationErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInvitationErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInvitationErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInvitationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInvitationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `RejectInvitationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            RejectInvitationErrorKind::ThrottlingException(_)
        )
    }
}
impl std::error::Error for RejectInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            RejectInvitationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            RejectInvitationErrorKind::IllegalActionException(_inner) => Some(_inner),
            RejectInvitationErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            RejectInvitationErrorKind::InvalidRequestException(_inner) => Some(_inner),
            RejectInvitationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            RejectInvitationErrorKind::ThrottlingException(_inner) => Some(_inner),
            RejectInvitationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// <p></p>
    TooManyTagsException(crate::error::TooManyTagsException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::TooManyTagsException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotReadyException(_)
        )
    }
    /// Returns `true` if the error kind is `TagResourceErrorKind::TooManyTagsException`.
    pub fn is_too_many_tags_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::TooManyTagsException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            TagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            TagResourceErrorKind::TooManyTagsException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The requested resource exists but is not in a status that can complete the operation.</p>
    ResourceNotReadyException(crate::error::ResourceNotReadyException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotReadyException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UntagResourceErrorKind::ResourceNotReadyException`.
    pub fn is_resource_not_ready_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotReadyException(_)
        )
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UntagResourceErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotReadyException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMemberError {
    /// Kind of error that occurred.
    pub kind: UpdateMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMemberErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateMemberErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UpdateMemberErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMemberError {
    fn code(&self) -> Option<&str> {
        UpdateMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMemberError {
    /// Creates a new `UpdateMemberError`.
    pub fn new(kind: UpdateMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateMemberErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateMemberErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateMemberErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UpdateMemberErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateNodeError {
    /// Kind of error that occurred.
    pub kind: UpdateNodeErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateNode` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateNodeErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateNodeError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateNodeErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateNodeErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            UpdateNodeErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            UpdateNodeErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateNodeErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateNodeErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateNodeError {
    fn code(&self) -> Option<&str> {
        UpdateNodeError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateNodeError {
    /// Creates a new `UpdateNodeError`.
    pub fn new(kind: UpdateNodeErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateNodeError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateNodeErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateNodeError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateNodeErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateNodeErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UpdateNodeErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `UpdateNodeErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodeErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodeErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(&self.kind, UpdateNodeErrorKind::InvalidRequestException(_))
    }
    /// Returns `true` if the error kind is `UpdateNodeErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateNodeErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateNodeErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UpdateNodeErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for UpdateNodeError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateNodeErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateNodeErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            UpdateNodeErrorKind::InvalidRequestException(_inner) => Some(_inner),
            UpdateNodeErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateNodeErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateNodeErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `VoteOnProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct VoteOnProposalError {
    /// Kind of error that occurred.
    pub kind: VoteOnProposalErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `VoteOnProposal` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum VoteOnProposalErrorKind {
    /// <p>You do not have sufficient access to perform this action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p></p>
    IllegalActionException(crate::error::IllegalActionException),
    /// <p>The request processing has failed because of an unknown error, exception or failure.</p>
    InternalServiceErrorException(crate::error::InternalServiceErrorException),
    /// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
    InvalidRequestException(crate::error::InvalidRequestException),
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for VoteOnProposalError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            VoteOnProposalErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            VoteOnProposalErrorKind::IllegalActionException(_inner) => _inner.fmt(f),
            VoteOnProposalErrorKind::InternalServiceErrorException(_inner) => _inner.fmt(f),
            VoteOnProposalErrorKind::InvalidRequestException(_inner) => _inner.fmt(f),
            VoteOnProposalErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            VoteOnProposalErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            VoteOnProposalErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for VoteOnProposalError {
    fn code(&self) -> Option<&str> {
        VoteOnProposalError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl VoteOnProposalError {
    /// Creates a new `VoteOnProposalError`.
    pub fn new(kind: VoteOnProposalErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `VoteOnProposalError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: VoteOnProposalErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `VoteOnProposalError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: VoteOnProposalErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `VoteOnProposalErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            VoteOnProposalErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `VoteOnProposalErrorKind::IllegalActionException`.
    pub fn is_illegal_action_exception(&self) -> bool {
        matches!(
            &self.kind,
            VoteOnProposalErrorKind::IllegalActionException(_)
        )
    }
    /// Returns `true` if the error kind is `VoteOnProposalErrorKind::InternalServiceErrorException`.
    pub fn is_internal_service_error_exception(&self) -> bool {
        matches!(
            &self.kind,
            VoteOnProposalErrorKind::InternalServiceErrorException(_)
        )
    }
    /// Returns `true` if the error kind is `VoteOnProposalErrorKind::InvalidRequestException`.
    pub fn is_invalid_request_exception(&self) -> bool {
        matches!(
            &self.kind,
            VoteOnProposalErrorKind::InvalidRequestException(_)
        )
    }
    /// Returns `true` if the error kind is `VoteOnProposalErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            VoteOnProposalErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `VoteOnProposalErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, VoteOnProposalErrorKind::ThrottlingException(_))
    }
}
impl std::error::Error for VoteOnProposalError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            VoteOnProposalErrorKind::AccessDeniedException(_inner) => Some(_inner),
            VoteOnProposalErrorKind::IllegalActionException(_inner) => Some(_inner),
            VoteOnProposalErrorKind::InternalServiceErrorException(_inner) => Some(_inner),
            VoteOnProposalErrorKind::InvalidRequestException(_inner) => Some(_inner),
            VoteOnProposalErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            VoteOnProposalErrorKind::ThrottlingException(_inner) => Some(_inner),
            VoteOnProposalErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>The request or operation could not be performed because a service is throttling requests. The most common source of throttling errors is launching EC2 instances such that your service limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl ResourceNotFoundException {
    /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p>A requested resource does not exist. It may have been deleted or referenced inaccurately.</p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidRequestException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidRequestException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidRequestException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidRequestException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidRequestException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidRequestException {}
/// See [`InvalidRequestException`](crate::error::InvalidRequestException)
pub mod invalid_request_exception {
    /// A builder for [`InvalidRequestException`](crate::error::InvalidRequestException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidRequestException`](crate::error::InvalidRequestException)
        pub fn build(self) -> crate::error::InvalidRequestException {
            crate::error::InvalidRequestException {
                message: self.message,
            }
        }
    }
}
impl InvalidRequestException {
    /// Creates a new builder-style object to manufacture [`InvalidRequestException`](crate::error::InvalidRequestException)
    pub fn builder() -> crate::error::invalid_request_exception::Builder {
        crate::error::invalid_request_exception::Builder::default()
    }
}

/// <p>The request processing has failed because of an unknown error, exception or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServiceErrorException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServiceErrorException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServiceErrorException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServiceErrorException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServiceErrorException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServiceErrorException {}
/// See [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
pub mod internal_service_error_exception {
    /// A builder for [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
        pub fn build(self) -> crate::error::InternalServiceErrorException {
            crate::error::InternalServiceErrorException {
                message: self.message,
            }
        }
    }
}
impl InternalServiceErrorException {
    /// Creates a new builder-style object to manufacture [`InternalServiceErrorException`](crate::error::InternalServiceErrorException)
    pub fn builder() -> crate::error::internal_service_error_exception::Builder {
        crate::error::internal_service_error_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IllegalActionException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for IllegalActionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IllegalActionException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl IllegalActionException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IllegalActionException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IllegalActionException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for IllegalActionException {}
/// See [`IllegalActionException`](crate::error::IllegalActionException)
pub mod illegal_action_exception {
    /// A builder for [`IllegalActionException`](crate::error::IllegalActionException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`IllegalActionException`](crate::error::IllegalActionException)
        pub fn build(self) -> crate::error::IllegalActionException {
            crate::error::IllegalActionException {
                message: self.message,
            }
        }
    }
}
impl IllegalActionException {
    /// Creates a new builder-style object to manufacture [`IllegalActionException`](crate::error::IllegalActionException)
    pub fn builder() -> crate::error::illegal_action_exception::Builder {
        crate::error::illegal_action_exception::Builder::default()
    }
}

/// <p>You do not have sufficient access to perform this action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>The requested resource exists but is not in a status that can complete the operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotReadyException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotReadyException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotReadyException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotReadyException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotReadyException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotReadyException {}
/// See [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
pub mod resource_not_ready_exception {
    /// A builder for [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
        pub fn build(self) -> crate::error::ResourceNotReadyException {
            crate::error::ResourceNotReadyException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotReadyException {
    /// Creates a new builder-style object to manufacture [`ResourceNotReadyException`](crate::error::ResourceNotReadyException)
    pub fn builder() -> crate::error::resource_not_ready_exception::Builder {
        crate::error::resource_not_ready_exception::Builder::default()
    }
}

/// <p></p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TooManyTagsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p></p>
    pub resource_name: std::option::Option<std::string::String>,
}
impl TooManyTagsException {
    /// <p></p>
    pub fn resource_name(&self) -> std::option::Option<&str> {
        self.resource_name.as_deref()
    }
}
impl std::fmt::Debug for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TooManyTagsException");
        formatter.field("message", &self.message);
        formatter.field("resource_name", &self.resource_name);
        formatter.finish()
    }
}
impl TooManyTagsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TooManyTagsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TooManyTagsException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TooManyTagsException {}
/// See [`TooManyTagsException`](crate::error::TooManyTagsException)
pub mod too_many_tags_exception {
    /// A builder for [`TooManyTagsException`](crate::error::TooManyTagsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p></p>
        pub fn resource_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_name = Some(input.into());
            self
        }
        /// <p></p>
        pub fn set_resource_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.resource_name = input;
            self
        }
        /// Consumes the builder and constructs a [`TooManyTagsException`](crate::error::TooManyTagsException)
        pub fn build(self) -> crate::error::TooManyTagsException {
            crate::error::TooManyTagsException {
                message: self.message,
                resource_name: self.resource_name,
            }
        }
    }
}
impl TooManyTagsException {
    /// Creates a new builder-style object to manufacture [`TooManyTagsException`](crate::error::TooManyTagsException)
    pub fn builder() -> crate::error::too_many_tags_exception::Builder {
        crate::error::too_many_tags_exception::Builder::default()
    }
}

/// <p>The maximum number of resources of that type already exist. Ensure the resources requested are within the boundaries of the service edition and your account limits.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceLimitExceededException")?;
        if let Some(inner_9) = &self.message {
            write!(f, ": {}", inner_9)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceLimitExceededException {}
/// See [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
pub mod resource_limit_exceeded_exception {
    /// A builder for [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
        pub fn build(self) -> crate::error::ResourceLimitExceededException {
            crate::error::ResourceLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl ResourceLimitExceededException {
    /// Creates a new builder-style object to manufacture [`ResourceLimitExceededException`](crate::error::ResourceLimitExceededException)
    pub fn builder() -> crate::error::resource_limit_exceeded_exception::Builder {
        crate::error::resource_limit_exceeded_exception::Builder::default()
    }
}

/// <p>A resource request is issued for a resource that already exists.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceAlreadyExistsException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceAlreadyExistsException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceAlreadyExistsException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceAlreadyExistsException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceAlreadyExistsException")?;
        if let Some(inner_10) = &self.message {
            write!(f, ": {}", inner_10)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceAlreadyExistsException {}
/// See [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
pub mod resource_already_exists_exception {
    /// A builder for [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
        pub fn build(self) -> crate::error::ResourceAlreadyExistsException {
            crate::error::ResourceAlreadyExistsException {
                message: self.message,
            }
        }
    }
}
impl ResourceAlreadyExistsException {
    /// Creates a new builder-style object to manufacture [`ResourceAlreadyExistsException`](crate::error::ResourceAlreadyExistsException)
    pub fn builder() -> crate::error::resource_already_exists_exception::Builder {
        crate::error::resource_already_exists_exception::Builder::default()
    }
}
