// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum VoteValue {
    #[allow(missing_docs)] // documentation missing in model
    No,
    #[allow(missing_docs)] // documentation missing in model
    Yes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for VoteValue {
    fn from(s: &str) -> Self {
        match s {
            "NO" => VoteValue::No,
            "YES" => VoteValue::Yes,
            other => VoteValue::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for VoteValue {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(VoteValue::from(s))
    }
}
impl VoteValue {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            VoteValue::No => "NO",
            VoteValue::Yes => "YES",
            VoteValue::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NO", "YES"]
    }
}
impl AsRef<str> for VoteValue {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeLogPublishingConfiguration {
    /// <p>Configuration properties for logging events associated with a node that is owned by a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
    pub fabric: std::option::Option<crate::model::NodeFabricLogPublishingConfiguration>,
}
impl std::fmt::Debug for NodeLogPublishingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeLogPublishingConfiguration");
        formatter.field("fabric", &self.fabric);
        formatter.finish()
    }
}
/// See [`NodeLogPublishingConfiguration`](crate::model::NodeLogPublishingConfiguration)
pub mod node_log_publishing_configuration {
    /// A builder for [`NodeLogPublishingConfiguration`](crate::model::NodeLogPublishingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric: std::option::Option<crate::model::NodeFabricLogPublishingConfiguration>,
    }
    impl Builder {
        /// <p>Configuration properties for logging events associated with a node that is owned by a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
        pub fn fabric(mut self, input: crate::model::NodeFabricLogPublishingConfiguration) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a node that is owned by a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::NodeFabricLogPublishingConfiguration>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeLogPublishingConfiguration`](crate::model::NodeLogPublishingConfiguration)
        pub fn build(self) -> crate::model::NodeLogPublishingConfiguration {
            crate::model::NodeLogPublishingConfiguration {
                fabric: self.fabric,
            }
        }
    }
}
impl NodeLogPublishingConfiguration {
    /// Creates a new builder-style object to manufacture [`NodeLogPublishingConfiguration`](crate::model::NodeLogPublishingConfiguration)
    pub fn builder() -> crate::model::node_log_publishing_configuration::Builder {
        crate::model::node_log_publishing_configuration::Builder::default()
    }
}

/// <p>Configuration properties for logging events associated with a peer node owned by a member in a Managed Blockchain network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeFabricLogPublishingConfiguration {
    /// <p>Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each chaincode.</p>
    pub chaincode_logs: std::option::Option<crate::model::LogConfigurations>,
    /// <p>Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode instances on a peer node. </p>
    pub peer_logs: std::option::Option<crate::model::LogConfigurations>,
}
impl std::fmt::Debug for NodeFabricLogPublishingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeFabricLogPublishingConfiguration");
        formatter.field("chaincode_logs", &self.chaincode_logs);
        formatter.field("peer_logs", &self.peer_logs);
        formatter.finish()
    }
}
/// See [`NodeFabricLogPublishingConfiguration`](crate::model::NodeFabricLogPublishingConfiguration)
pub mod node_fabric_log_publishing_configuration {
    /// A builder for [`NodeFabricLogPublishingConfiguration`](crate::model::NodeFabricLogPublishingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) chaincode_logs: std::option::Option<crate::model::LogConfigurations>,
        pub(crate) peer_logs: std::option::Option<crate::model::LogConfigurations>,
    }
    impl Builder {
        /// <p>Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each chaincode.</p>
        pub fn chaincode_logs(mut self, input: crate::model::LogConfigurations) -> Self {
            self.chaincode_logs = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each chaincode.</p>
        pub fn set_chaincode_logs(
            mut self,
            input: std::option::Option<crate::model::LogConfigurations>,
        ) -> Self {
            self.chaincode_logs = input;
            self
        }
        /// <p>Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode instances on a peer node. </p>
        pub fn peer_logs(mut self, input: crate::model::LogConfigurations) -> Self {
            self.peer_logs = Some(input);
            self
        }
        /// <p>Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode instances on a peer node. </p>
        pub fn set_peer_logs(
            mut self,
            input: std::option::Option<crate::model::LogConfigurations>,
        ) -> Self {
            self.peer_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeFabricLogPublishingConfiguration`](crate::model::NodeFabricLogPublishingConfiguration)
        pub fn build(self) -> crate::model::NodeFabricLogPublishingConfiguration {
            crate::model::NodeFabricLogPublishingConfiguration {
                chaincode_logs: self.chaincode_logs,
                peer_logs: self.peer_logs,
            }
        }
    }
}
impl NodeFabricLogPublishingConfiguration {
    /// Creates a new builder-style object to manufacture [`NodeFabricLogPublishingConfiguration`](crate::model::NodeFabricLogPublishingConfiguration)
    pub fn builder() -> crate::model::node_fabric_log_publishing_configuration::Builder {
        crate::model::node_fabric_log_publishing_configuration::Builder::default()
    }
}

/// <p>A collection of log configurations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogConfigurations {
    /// <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
    pub cloudwatch: std::option::Option<crate::model::LogConfiguration>,
}
impl std::fmt::Debug for LogConfigurations {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogConfigurations");
        formatter.field("cloudwatch", &self.cloudwatch);
        formatter.finish()
    }
}
/// See [`LogConfigurations`](crate::model::LogConfigurations)
pub mod log_configurations {
    /// A builder for [`LogConfigurations`](crate::model::LogConfigurations)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cloudwatch: std::option::Option<crate::model::LogConfiguration>,
    }
    impl Builder {
        /// <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
        pub fn cloudwatch(mut self, input: crate::model::LogConfiguration) -> Self {
            self.cloudwatch = Some(input);
            self
        }
        /// <p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>
        pub fn set_cloudwatch(
            mut self,
            input: std::option::Option<crate::model::LogConfiguration>,
        ) -> Self {
            self.cloudwatch = input;
            self
        }
        /// Consumes the builder and constructs a [`LogConfigurations`](crate::model::LogConfigurations)
        pub fn build(self) -> crate::model::LogConfigurations {
            crate::model::LogConfigurations {
                cloudwatch: self.cloudwatch,
            }
        }
    }
}
impl LogConfigurations {
    /// Creates a new builder-style object to manufacture [`LogConfigurations`](crate::model::LogConfigurations)
    pub fn builder() -> crate::model::log_configurations::Builder {
        crate::model::log_configurations::Builder::default()
    }
}

/// <p>A configuration for logging events.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LogConfiguration {
    /// <p>Indicates whether logging is enabled.</p>
    pub enabled: std::option::Option<bool>,
}
impl std::fmt::Debug for LogConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LogConfiguration");
        formatter.field("enabled", &self.enabled);
        formatter.finish()
    }
}
/// See [`LogConfiguration`](crate::model::LogConfiguration)
pub mod log_configuration {
    /// A builder for [`LogConfiguration`](crate::model::LogConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) enabled: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Indicates whether logging is enabled.</p>
        pub fn enabled(mut self, input: bool) -> Self {
            self.enabled = Some(input);
            self
        }
        /// <p>Indicates whether logging is enabled.</p>
        pub fn set_enabled(mut self, input: std::option::Option<bool>) -> Self {
            self.enabled = input;
            self
        }
        /// Consumes the builder and constructs a [`LogConfiguration`](crate::model::LogConfiguration)
        pub fn build(self) -> crate::model::LogConfiguration {
            crate::model::LogConfiguration {
                enabled: self.enabled,
            }
        }
    }
}
impl LogConfiguration {
    /// Creates a new builder-style object to manufacture [`LogConfiguration`](crate::model::LogConfiguration)
    pub fn builder() -> crate::model::log_configuration::Builder {
        crate::model::log_configuration::Builder::default()
    }
}

/// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberLogPublishingConfiguration {
    /// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
    pub fabric: std::option::Option<crate::model::MemberFabricLogPublishingConfiguration>,
}
impl std::fmt::Debug for MemberLogPublishingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberLogPublishingConfiguration");
        formatter.field("fabric", &self.fabric);
        formatter.finish()
    }
}
/// See [`MemberLogPublishingConfiguration`](crate::model::MemberLogPublishingConfiguration)
pub mod member_log_publishing_configuration {
    /// A builder for [`MemberLogPublishingConfiguration`](crate::model::MemberLogPublishingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric:
            std::option::Option<crate::model::MemberFabricLogPublishingConfiguration>,
    }
    impl Builder {
        /// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
        pub fn fabric(
            mut self,
            input: crate::model::MemberFabricLogPublishingConfiguration,
        ) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::MemberFabricLogPublishingConfiguration>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberLogPublishingConfiguration`](crate::model::MemberLogPublishingConfiguration)
        pub fn build(self) -> crate::model::MemberLogPublishingConfiguration {
            crate::model::MemberLogPublishingConfiguration {
                fabric: self.fabric,
            }
        }
    }
}
impl MemberLogPublishingConfiguration {
    /// Creates a new builder-style object to manufacture [`MemberLogPublishingConfiguration`](crate::model::MemberLogPublishingConfiguration)
    pub fn builder() -> crate::model::member_log_publishing_configuration::Builder {
        crate::model::member_log_publishing_configuration::Builder::default()
    }
}

/// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberFabricLogPublishingConfiguration {
    /// <p>Configuration properties for logging events associated with a member's Certificate Authority (CA). CA logs help you determine when a member in your account joins the network, or when new peers register with a member CA.</p>
    pub ca_logs: std::option::Option<crate::model::LogConfigurations>,
}
impl std::fmt::Debug for MemberFabricLogPublishingConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberFabricLogPublishingConfiguration");
        formatter.field("ca_logs", &self.ca_logs);
        formatter.finish()
    }
}
/// See [`MemberFabricLogPublishingConfiguration`](crate::model::MemberFabricLogPublishingConfiguration)
pub mod member_fabric_log_publishing_configuration {
    /// A builder for [`MemberFabricLogPublishingConfiguration`](crate::model::MemberFabricLogPublishingConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ca_logs: std::option::Option<crate::model::LogConfigurations>,
    }
    impl Builder {
        /// <p>Configuration properties for logging events associated with a member's Certificate Authority (CA). CA logs help you determine when a member in your account joins the network, or when new peers register with a member CA.</p>
        pub fn ca_logs(mut self, input: crate::model::LogConfigurations) -> Self {
            self.ca_logs = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a member's Certificate Authority (CA). CA logs help you determine when a member in your account joins the network, or when new peers register with a member CA.</p>
        pub fn set_ca_logs(
            mut self,
            input: std::option::Option<crate::model::LogConfigurations>,
        ) -> Self {
            self.ca_logs = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberFabricLogPublishingConfiguration`](crate::model::MemberFabricLogPublishingConfiguration)
        pub fn build(self) -> crate::model::MemberFabricLogPublishingConfiguration {
            crate::model::MemberFabricLogPublishingConfiguration {
                ca_logs: self.ca_logs,
            }
        }
    }
}
impl MemberFabricLogPublishingConfiguration {
    /// Creates a new builder-style object to manufacture [`MemberFabricLogPublishingConfiguration`](crate::model::MemberFabricLogPublishingConfiguration)
    pub fn builder() -> crate::model::member_fabric_log_publishing_configuration::Builder {
        crate::model::member_fabric_log_publishing_configuration::Builder::default()
    }
}

/// <p>
/// Properties of an individual vote that a member cast for a proposal.
/// </p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VoteSummary {
    /// <p>
    /// The vote value, either <code>YES</code> or <code>NO</code>.
    /// </p>
    pub vote: std::option::Option<crate::model::VoteValue>,
    /// <p>
    /// The name of the member that cast the vote.
    /// </p>
    pub member_name: std::option::Option<std::string::String>,
    /// <p>
    /// The unique identifier of the member that cast the vote.
    /// </p>
    pub member_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for VoteSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VoteSummary");
        formatter.field("vote", &self.vote);
        formatter.field("member_name", &self.member_name);
        formatter.field("member_id", &self.member_id);
        formatter.finish()
    }
}
/// See [`VoteSummary`](crate::model::VoteSummary)
pub mod vote_summary {
    /// A builder for [`VoteSummary`](crate::model::VoteSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) vote: std::option::Option<crate::model::VoteValue>,
        pub(crate) member_name: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The vote value, either <code>YES</code> or <code>NO</code>.
        /// </p>
        pub fn vote(mut self, input: crate::model::VoteValue) -> Self {
            self.vote = Some(input);
            self
        }
        /// <p>
        /// The vote value, either <code>YES</code> or <code>NO</code>.
        /// </p>
        pub fn set_vote(mut self, input: std::option::Option<crate::model::VoteValue>) -> Self {
            self.vote = input;
            self
        }
        /// <p>
        /// The name of the member that cast the vote.
        /// </p>
        pub fn member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the member that cast the vote.
        /// </p>
        pub fn set_member_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_name = input;
            self
        }
        /// <p>
        /// The unique identifier of the member that cast the vote.
        /// </p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier of the member that cast the vote.
        /// </p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`VoteSummary`](crate::model::VoteSummary)
        pub fn build(self) -> crate::model::VoteSummary {
            crate::model::VoteSummary {
                vote: self.vote,
                member_name: self.member_name,
                member_id: self.member_id,
            }
        }
    }
}
impl VoteSummary {
    /// Creates a new builder-style object to manufacture [`VoteSummary`](crate::model::VoteSummary)
    pub fn builder() -> crate::model::vote_summary::Builder {
        crate::model::vote_summary::Builder::default()
    }
}

/// <p>Properties of a proposal.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProposalSummary {
    /// <p>
    /// The unique identifier of the proposal.
    /// </p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p>
    /// The description of the proposal.
    /// </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>
    /// The unique identifier of the member that created the proposal.
    /// </p>
    pub proposed_by_member_id: std::option::Option<std::string::String>,
    /// <p>
    /// The name of the member that created the proposal.
    /// </p>
    pub proposed_by_member_name: std::option::Option<std::string::String>,
    /// <p>The status of the proposal. Values are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> are not carried out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved could not be completed because of an error.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ProposalStatus>,
    /// <p>
    /// The date and time that the proposal was created.
    /// </p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>.  After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
    /// </p>
    pub expiration_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ProposalSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProposalSummary");
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field("description", &self.description);
        formatter.field("proposed_by_member_id", &self.proposed_by_member_id);
        formatter.field("proposed_by_member_name", &self.proposed_by_member_name);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`ProposalSummary`](crate::model::ProposalSummary)
pub mod proposal_summary {
    /// A builder for [`ProposalSummary`](crate::model::ProposalSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) proposed_by_member_id: std::option::Option<std::string::String>,
        pub(crate) proposed_by_member_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProposalStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>
        /// The unique identifier of the proposal.
        /// </p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier of the proposal.
        /// </p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p>
        /// The description of the proposal.
        /// </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>
        /// The description of the proposal.
        /// </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>
        /// The unique identifier of the member that created the proposal.
        /// </p>
        pub fn proposed_by_member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposed_by_member_id = Some(input.into());
            self
        }
        /// <p>
        /// The unique identifier of the member that created the proposal.
        /// </p>
        pub fn set_proposed_by_member_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proposed_by_member_id = input;
            self
        }
        /// <p>
        /// The name of the member that created the proposal.
        /// </p>
        pub fn proposed_by_member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposed_by_member_name = Some(input.into());
            self
        }
        /// <p>
        /// The name of the member that created the proposal.
        /// </p>
        pub fn set_proposed_by_member_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proposed_by_member_name = input;
            self
        }
        /// <p>The status of the proposal. Values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved could not be completed because of an error.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ProposalStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proposal. Values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved could not be completed because of an error.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProposalStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// The date and time that the proposal was created.
        /// </p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>
        /// The date and time that the proposal was created.
        /// </p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>
        /// The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>.  After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
        /// </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>
        /// The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>.  After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
        /// </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ProposalSummary`](crate::model::ProposalSummary)
        pub fn build(self) -> crate::model::ProposalSummary {
            crate::model::ProposalSummary {
                proposal_id: self.proposal_id,
                description: self.description,
                proposed_by_member_id: self.proposed_by_member_id,
                proposed_by_member_name: self.proposed_by_member_name,
                status: self.status,
                creation_date: self.creation_date,
                expiration_date: self.expiration_date,
                arn: self.arn,
            }
        }
    }
}
impl ProposalSummary {
    /// Creates a new builder-style object to manufacture [`ProposalSummary`](crate::model::ProposalSummary)
    pub fn builder() -> crate::model::proposal_summary::Builder {
        crate::model::proposal_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ProposalStatus {
    #[allow(missing_docs)] // documentation missing in model
    ActionFailed,
    #[allow(missing_docs)] // documentation missing in model
    Approved,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    InProgress,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ProposalStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACTION_FAILED" => ProposalStatus::ActionFailed,
            "APPROVED" => ProposalStatus::Approved,
            "EXPIRED" => ProposalStatus::Expired,
            "IN_PROGRESS" => ProposalStatus::InProgress,
            "REJECTED" => ProposalStatus::Rejected,
            other => ProposalStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ProposalStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ProposalStatus::from(s))
    }
}
impl ProposalStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ProposalStatus::ActionFailed => "ACTION_FAILED",
            ProposalStatus::Approved => "APPROVED",
            ProposalStatus::Expired => "EXPIRED",
            ProposalStatus::InProgress => "IN_PROGRESS",
            ProposalStatus::Rejected => "REJECTED",
            ProposalStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACTION_FAILED",
            "APPROVED",
            "EXPIRED",
            "IN_PROGRESS",
            "REJECTED",
        ]
    }
}
impl AsRef<str> for ProposalStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of configuration properties for a node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeSummary {
    /// <p>The unique identifier of the node.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The status of the node.</p>
    pub status: std::option::Option<crate::model::NodeStatus>,
    /// <p>The date and time that the node was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Availability Zone in which the node exists.</p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>The EC2 instance type for the node.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeSummary");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`NodeSummary`](crate::model::NodeSummary)
pub mod node_summary {
    /// A builder for [`NodeSummary`](crate::model::NodeSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NodeStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the node.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The status of the node.</p>
        pub fn status(mut self, input: crate::model::NodeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the node.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::NodeStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the node was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the node was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Availability Zone in which the node exists.</p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the node exists.</p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>The EC2 instance type for the node.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The EC2 instance type for the node.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeSummary`](crate::model::NodeSummary)
        pub fn build(self) -> crate::model::NodeSummary {
            crate::model::NodeSummary {
                id: self.id,
                status: self.status,
                creation_date: self.creation_date,
                availability_zone: self.availability_zone,
                instance_type: self.instance_type,
                arn: self.arn,
            }
        }
    }
}
impl NodeSummary {
    /// Creates a new builder-style object to manufacture [`NodeSummary`](crate::model::NodeSummary)
    pub fn builder() -> crate::model::node_summary::Builder {
        crate::model::node_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NodeStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    Failed,
    #[allow(missing_docs)] // documentation missing in model
    InaccessibleEncryptionKey,
    #[allow(missing_docs)] // documentation missing in model
    Unhealthy,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NodeStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => NodeStatus::Available,
            "CREATE_FAILED" => NodeStatus::CreateFailed,
            "CREATING" => NodeStatus::Creating,
            "DELETED" => NodeStatus::Deleted,
            "DELETING" => NodeStatus::Deleting,
            "FAILED" => NodeStatus::Failed,
            "INACCESSIBLE_ENCRYPTION_KEY" => NodeStatus::InaccessibleEncryptionKey,
            "UNHEALTHY" => NodeStatus::Unhealthy,
            "UPDATING" => NodeStatus::Updating,
            other => NodeStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NodeStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NodeStatus::from(s))
    }
}
impl NodeStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NodeStatus::Available => "AVAILABLE",
            NodeStatus::CreateFailed => "CREATE_FAILED",
            NodeStatus::Creating => "CREATING",
            NodeStatus::Deleted => "DELETED",
            NodeStatus::Deleting => "DELETING",
            NodeStatus::Failed => "FAILED",
            NodeStatus::InaccessibleEncryptionKey => "INACCESSIBLE_ENCRYPTION_KEY",
            NodeStatus::Unhealthy => "UNHEALTHY",
            NodeStatus::Updating => "UPDATING",
            NodeStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATE_FAILED",
            "CREATING",
            "DELETED",
            "DELETING",
            "FAILED",
            "INACCESSIBLE_ENCRYPTION_KEY",
            "UNHEALTHY",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for NodeStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of network configuration properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkSummary {
    /// <p>The unique identifier of the network.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the network.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The blockchain framework that the network uses.</p>
    pub framework: std::option::Option<crate::model::Framework>,
    /// <p>The version of the blockchain framework that the network uses.</p>
    pub framework_version: std::option::Option<std::string::String>,
    /// <p>The current status of the network.</p>
    pub status: std::option::Option<crate::model::NetworkStatus>,
    /// <p>The date and time that the network was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("framework", &self.framework);
        formatter.field("framework_version", &self.framework_version);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`NetworkSummary`](crate::model::NetworkSummary)
pub mod network_summary {
    /// A builder for [`NetworkSummary`](crate::model::NetworkSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) framework: std::option::Option<crate::model::Framework>,
        pub(crate) framework_version: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::NetworkStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn framework_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_version = Some(input.into());
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn set_framework_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_version = input;
            self
        }
        /// <p>The current status of the network.</p>
        pub fn status(mut self, input: crate::model::NetworkStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the network.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NetworkStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the network was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the network was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkSummary`](crate::model::NetworkSummary)
        pub fn build(self) -> crate::model::NetworkSummary {
            crate::model::NetworkSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                framework: self.framework,
                framework_version: self.framework_version,
                status: self.status,
                creation_date: self.creation_date,
                arn: self.arn,
            }
        }
    }
}
impl NetworkSummary {
    /// Creates a new builder-style object to manufacture [`NetworkSummary`](crate::model::NetworkSummary)
    pub fn builder() -> crate::model::network_summary::Builder {
        crate::model::network_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum NetworkStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for NetworkStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => NetworkStatus::Available,
            "CREATE_FAILED" => NetworkStatus::CreateFailed,
            "CREATING" => NetworkStatus::Creating,
            "DELETED" => NetworkStatus::Deleted,
            "DELETING" => NetworkStatus::Deleting,
            other => NetworkStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for NetworkStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(NetworkStatus::from(s))
    }
}
impl NetworkStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            NetworkStatus::Available => "AVAILABLE",
            NetworkStatus::CreateFailed => "CREATE_FAILED",
            NetworkStatus::Creating => "CREATING",
            NetworkStatus::Deleted => "DELETED",
            NetworkStatus::Deleting => "DELETING",
            NetworkStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATE_FAILED",
            "CREATING",
            "DELETED",
            "DELETING",
        ]
    }
}
impl AsRef<str> for NetworkStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Framework {
    #[allow(missing_docs)] // documentation missing in model
    Ethereum,
    #[allow(missing_docs)] // documentation missing in model
    HyperledgerFabric,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Framework {
    fn from(s: &str) -> Self {
        match s {
            "ETHEREUM" => Framework::Ethereum,
            "HYPERLEDGER_FABRIC" => Framework::HyperledgerFabric,
            other => Framework::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Framework {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Framework::from(s))
    }
}
impl Framework {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Framework::Ethereum => "ETHEREUM",
            Framework::HyperledgerFabric => "HYPERLEDGER_FABRIC",
            Framework::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ETHEREUM", "HYPERLEDGER_FABRIC"]
    }
}
impl AsRef<str> for Framework {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>A summary of configuration properties for a member.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberSummary {
    /// <p>The unique identifier of the member.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the member.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the member.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The status of the member.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The AWS account is in the process of creating a member.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The member has been created and can participate in the network.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - The member is in the process of being updated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
    /// <code>PROPOSAL</code> to remove the member.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
    /// <code>PROPOSAL</code> to remove the member.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in AWS Key Management Service (AWS KMS) for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
    /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The member resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::MemberStatus>,
    /// <p>The date and time that the member was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>An indicator of whether the member is owned by your AWS account or a different AWS account.</p>
    pub is_owned: std::option::Option<bool>,
    /// <p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MemberSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberSummary");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("is_owned", &self.is_owned);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`MemberSummary`](crate::model::MemberSummary)
pub mod member_summary {
    /// A builder for [`MemberSummary`](crate::model::MemberSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MemberStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) is_owned: std::option::Option<bool>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the member.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the member.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the member.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the member.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the member.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The status of the member.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The AWS account is in the process of creating a member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The member has been created and can participate in the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The member is in the process of being updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in AWS Key Management Service (AWS KMS) for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
        /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The member resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::MemberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the member.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The AWS account is in the process of creating a member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The member has been created and can participate in the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The member is in the process of being updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in AWS Key Management Service (AWS KMS) for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
        /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The member resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MemberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the member was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the member was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>An indicator of whether the member is owned by your AWS account or a different AWS account.</p>
        pub fn is_owned(mut self, input: bool) -> Self {
            self.is_owned = Some(input);
            self
        }
        /// <p>An indicator of whether the member is owned by your AWS account or a different AWS account.</p>
        pub fn set_is_owned(mut self, input: std::option::Option<bool>) -> Self {
            self.is_owned = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberSummary`](crate::model::MemberSummary)
        pub fn build(self) -> crate::model::MemberSummary {
            crate::model::MemberSummary {
                id: self.id,
                name: self.name,
                description: self.description,
                status: self.status,
                creation_date: self.creation_date,
                is_owned: self.is_owned,
                arn: self.arn,
            }
        }
    }
}
impl MemberSummary {
    /// Creates a new builder-style object to manufacture [`MemberSummary`](crate::model::MemberSummary)
    pub fn builder() -> crate::model::member_summary::Builder {
        crate::model::member_summary::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MemberStatus {
    #[allow(missing_docs)] // documentation missing in model
    Available,
    #[allow(missing_docs)] // documentation missing in model
    CreateFailed,
    #[allow(missing_docs)] // documentation missing in model
    Creating,
    #[allow(missing_docs)] // documentation missing in model
    Deleted,
    #[allow(missing_docs)] // documentation missing in model
    Deleting,
    #[allow(missing_docs)] // documentation missing in model
    InaccessibleEncryptionKey,
    #[allow(missing_docs)] // documentation missing in model
    Updating,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MemberStatus {
    fn from(s: &str) -> Self {
        match s {
            "AVAILABLE" => MemberStatus::Available,
            "CREATE_FAILED" => MemberStatus::CreateFailed,
            "CREATING" => MemberStatus::Creating,
            "DELETED" => MemberStatus::Deleted,
            "DELETING" => MemberStatus::Deleting,
            "INACCESSIBLE_ENCRYPTION_KEY" => MemberStatus::InaccessibleEncryptionKey,
            "UPDATING" => MemberStatus::Updating,
            other => MemberStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MemberStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MemberStatus::from(s))
    }
}
impl MemberStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MemberStatus::Available => "AVAILABLE",
            MemberStatus::CreateFailed => "CREATE_FAILED",
            MemberStatus::Creating => "CREATING",
            MemberStatus::Deleted => "DELETED",
            MemberStatus::Deleting => "DELETING",
            MemberStatus::InaccessibleEncryptionKey => "INACCESSIBLE_ENCRYPTION_KEY",
            MemberStatus::Updating => "UPDATING",
            MemberStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AVAILABLE",
            "CREATE_FAILED",
            "CREATING",
            "DELETED",
            "DELETING",
            "INACCESSIBLE_ENCRYPTION_KEY",
            "UPDATING",
        ]
    }
}
impl AsRef<str> for MemberStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An invitation to an AWS account to create a member and join the network.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Invitation {
    /// <p>The unique identifier for the invitation.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>The date and time that the invitation was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The date and time that the invitation expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, the invitee can no longer create a member and join the network using this <code>InvitationId</code>.</p>
    pub expiration_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The status of the invitation:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not yet expired.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACCEPTED</code> - The invitee created a member and joined the network using the <code>InvitationID</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REJECTED</code> - The invitee rejected the invitation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the <code>ExpirationDate</code>.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::InvitationStatus>,
    /// <p>A summary of network configuration properties.</p>
    pub network_summary: std::option::Option<crate::model::NetworkSummary>,
    /// <p>The Amazon Resource Name (ARN) of the invitation. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Invitation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Invitation");
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("status", &self.status);
        formatter.field("network_summary", &self.network_summary);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Invitation`](crate::model::Invitation)
pub mod invitation {
    /// A builder for [`Invitation`](crate::model::Invitation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) status: std::option::Option<crate::model::InvitationStatus>,
        pub(crate) network_summary: std::option::Option<crate::model::NetworkSummary>,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the invitation.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the invitation.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>The date and time that the invitation was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the invitation was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>The date and time that the invitation expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, the invitee can no longer create a member and join the network using this <code>InvitationId</code>.</p>
        pub fn expiration_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>The date and time that the invitation expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, the invitee can no longer create a member and join the network using this <code>InvitationId</code>.</p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p>The status of the invitation:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not yet expired.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCEPTED</code> - The invitee created a member and joined the network using the <code>InvitationID</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The invitee rejected the invitation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the <code>ExpirationDate</code>.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::InvitationStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the invitation:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not yet expired.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACCEPTED</code> - The invitee created a member and joined the network using the <code>InvitationID</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The invitee rejected the invitation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the <code>ExpirationDate</code>.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::InvitationStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A summary of network configuration properties.</p>
        pub fn network_summary(mut self, input: crate::model::NetworkSummary) -> Self {
            self.network_summary = Some(input);
            self
        }
        /// <p>A summary of network configuration properties.</p>
        pub fn set_network_summary(
            mut self,
            input: std::option::Option<crate::model::NetworkSummary>,
        ) -> Self {
            self.network_summary = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the invitation. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Invitation`](crate::model::Invitation)
        pub fn build(self) -> crate::model::Invitation {
            crate::model::Invitation {
                invitation_id: self.invitation_id,
                creation_date: self.creation_date,
                expiration_date: self.expiration_date,
                status: self.status,
                network_summary: self.network_summary,
                arn: self.arn,
            }
        }
    }
}
impl Invitation {
    /// Creates a new builder-style object to manufacture [`Invitation`](crate::model::Invitation)
    pub fn builder() -> crate::model::invitation::Builder {
        crate::model::invitation::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum InvitationStatus {
    #[allow(missing_docs)] // documentation missing in model
    Accepted,
    #[allow(missing_docs)] // documentation missing in model
    Accepting,
    #[allow(missing_docs)] // documentation missing in model
    Expired,
    #[allow(missing_docs)] // documentation missing in model
    Pending,
    #[allow(missing_docs)] // documentation missing in model
    Rejected,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for InvitationStatus {
    fn from(s: &str) -> Self {
        match s {
            "ACCEPTED" => InvitationStatus::Accepted,
            "ACCEPTING" => InvitationStatus::Accepting,
            "EXPIRED" => InvitationStatus::Expired,
            "PENDING" => InvitationStatus::Pending,
            "REJECTED" => InvitationStatus::Rejected,
            other => InvitationStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for InvitationStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(InvitationStatus::from(s))
    }
}
impl InvitationStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            InvitationStatus::Accepted => "ACCEPTED",
            InvitationStatus::Accepting => "ACCEPTING",
            InvitationStatus::Expired => "EXPIRED",
            InvitationStatus::Pending => "PENDING",
            InvitationStatus::Rejected => "REJECTED",
            InvitationStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCEPTED", "ACCEPTING", "EXPIRED", "PENDING", "REJECTED"]
    }
}
impl AsRef<str> for InvitationStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Properties of a proposal on a Managed Blockchain network.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Proposal {
    /// <p>The unique identifier of the proposal.</p>
    pub proposal_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the network for which the proposal is made.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The description of the proposal.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The actions to perform on the network if the proposal is <code>APPROVED</code>.</p>
    pub actions: std::option::Option<crate::model::ProposalActions>,
    /// <p>The unique identifier of the member that created the proposal.</p>
    pub proposed_by_member_id: std::option::Option<std::string::String>,
    /// <p>The name of the member that created the proposal.</p>
    pub proposed_by_member_name: std::option::Option<std::string::String>,
    /// <p>The status of the proposal. Values are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> are not carried out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved could not be completed because of an error. The <code>ACTION_FAILED</code> status occurs even if only one ProposalAction fails and other actions are successful.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::ProposalStatus>,
    /// <p>
    /// The date and time that the proposal was created.
    /// </p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
    /// </p>
    pub expiration_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>
    /// The current total of <code>YES</code> votes cast on the proposal by members.
    /// </p>
    pub yes_vote_count: std::option::Option<i32>,
    /// <p>
    /// The current total of <code>NO</code> votes cast on the proposal by members.
    /// </p>
    pub no_vote_count: std::option::Option<i32>,
    /// <p>
    /// The number of votes remaining to be cast on the proposal by members. In other words, the number of members minus the sum of <code>YES</code> votes and <code>NO</code> votes.
    /// </p>
    pub outstanding_vote_count: std::option::Option<i32>,
    /// <p>Tags assigned to the proposal. Each tag consists of a key and optional value.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Proposal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Proposal");
        formatter.field("proposal_id", &self.proposal_id);
        formatter.field("network_id", &self.network_id);
        formatter.field("description", &self.description);
        formatter.field("actions", &self.actions);
        formatter.field("proposed_by_member_id", &self.proposed_by_member_id);
        formatter.field("proposed_by_member_name", &self.proposed_by_member_name);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("expiration_date", &self.expiration_date);
        formatter.field("yes_vote_count", &self.yes_vote_count);
        formatter.field("no_vote_count", &self.no_vote_count);
        formatter.field("outstanding_vote_count", &self.outstanding_vote_count);
        formatter.field("tags", &self.tags);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Proposal`](crate::model::Proposal)
pub mod proposal {
    /// A builder for [`Proposal`](crate::model::Proposal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) proposal_id: std::option::Option<std::string::String>,
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) actions: std::option::Option<crate::model::ProposalActions>,
        pub(crate) proposed_by_member_id: std::option::Option<std::string::String>,
        pub(crate) proposed_by_member_name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::ProposalStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) expiration_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) yes_vote_count: std::option::Option<i32>,
        pub(crate) no_vote_count: std::option::Option<i32>,
        pub(crate) outstanding_vote_count: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the proposal.</p>
        pub fn proposal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the proposal.</p>
        pub fn set_proposal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.proposal_id = input;
            self
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network for which the proposal is made.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The description of the proposal.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the proposal.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The actions to perform on the network if the proposal is <code>APPROVED</code>.</p>
        pub fn actions(mut self, input: crate::model::ProposalActions) -> Self {
            self.actions = Some(input);
            self
        }
        /// <p>The actions to perform on the network if the proposal is <code>APPROVED</code>.</p>
        pub fn set_actions(
            mut self,
            input: std::option::Option<crate::model::ProposalActions>,
        ) -> Self {
            self.actions = input;
            self
        }
        /// <p>The unique identifier of the member that created the proposal.</p>
        pub fn proposed_by_member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposed_by_member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member that created the proposal.</p>
        pub fn set_proposed_by_member_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proposed_by_member_id = input;
            self
        }
        /// <p>The name of the member that created the proposal.</p>
        pub fn proposed_by_member_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.proposed_by_member_name = Some(input.into());
            self
        }
        /// <p>The name of the member that created the proposal.</p>
        pub fn set_proposed_by_member_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.proposed_by_member_name = input;
            self
        }
        /// <p>The status of the proposal. Values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved could not be completed because of an error. The <code>ACTION_FAILED</code> status occurs even if only one ProposalAction fails and other actions are successful.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::ProposalStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the proposal. Values are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved could not be completed because of an error. The <code>ACTION_FAILED</code> status occurs even if only one ProposalAction fails and other actions are successful.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ProposalStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>
        /// The date and time that the proposal was created.
        /// </p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>
        /// The date and time that the proposal was created.
        /// </p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>
        /// The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
        /// </p>
        pub fn expiration_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.expiration_date = Some(input);
            self
        }
        /// <p>
        /// The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
        /// </p>
        pub fn set_expiration_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.expiration_date = input;
            self
        }
        /// <p>
        /// The current total of <code>YES</code> votes cast on the proposal by members.
        /// </p>
        pub fn yes_vote_count(mut self, input: i32) -> Self {
            self.yes_vote_count = Some(input);
            self
        }
        /// <p>
        /// The current total of <code>YES</code> votes cast on the proposal by members.
        /// </p>
        pub fn set_yes_vote_count(mut self, input: std::option::Option<i32>) -> Self {
            self.yes_vote_count = input;
            self
        }
        /// <p>
        /// The current total of <code>NO</code> votes cast on the proposal by members.
        /// </p>
        pub fn no_vote_count(mut self, input: i32) -> Self {
            self.no_vote_count = Some(input);
            self
        }
        /// <p>
        /// The current total of <code>NO</code> votes cast on the proposal by members.
        /// </p>
        pub fn set_no_vote_count(mut self, input: std::option::Option<i32>) -> Self {
            self.no_vote_count = input;
            self
        }
        /// <p>
        /// The number of votes remaining to be cast on the proposal by members. In other words, the number of members minus the sum of <code>YES</code> votes and <code>NO</code> votes.
        /// </p>
        pub fn outstanding_vote_count(mut self, input: i32) -> Self {
            self.outstanding_vote_count = Some(input);
            self
        }
        /// <p>
        /// The number of votes remaining to be cast on the proposal by members. In other words, the number of members minus the sum of <code>YES</code> votes and <code>NO</code> votes.
        /// </p>
        pub fn set_outstanding_vote_count(mut self, input: std::option::Option<i32>) -> Self {
            self.outstanding_vote_count = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to the proposal. Each tag consists of a key and optional value.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Proposal`](crate::model::Proposal)
        pub fn build(self) -> crate::model::Proposal {
            crate::model::Proposal {
                proposal_id: self.proposal_id,
                network_id: self.network_id,
                description: self.description,
                actions: self.actions,
                proposed_by_member_id: self.proposed_by_member_id,
                proposed_by_member_name: self.proposed_by_member_name,
                status: self.status,
                creation_date: self.creation_date,
                expiration_date: self.expiration_date,
                yes_vote_count: self.yes_vote_count,
                no_vote_count: self.no_vote_count,
                outstanding_vote_count: self.outstanding_vote_count,
                tags: self.tags,
                arn: self.arn,
            }
        }
    }
}
impl Proposal {
    /// Creates a new builder-style object to manufacture [`Proposal`](crate::model::Proposal)
    pub fn builder() -> crate::model::proposal::Builder {
        crate::model::proposal::Builder::default()
    }
}

/// <p>
/// The actions to carry out if a proposal is <code>APPROVED</code>.
/// </p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ProposalActions {
    /// <p>
    /// The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and join the network.
    /// </p>
    pub invitations: std::option::Option<std::vec::Vec<crate::model::InviteAction>>,
    /// <p>
    /// The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which deletes the member and all associated member resources from the network.
    /// </p>
    pub removals: std::option::Option<std::vec::Vec<crate::model::RemoveAction>>,
}
impl std::fmt::Debug for ProposalActions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ProposalActions");
        formatter.field("invitations", &self.invitations);
        formatter.field("removals", &self.removals);
        formatter.finish()
    }
}
/// See [`ProposalActions`](crate::model::ProposalActions)
pub mod proposal_actions {
    /// A builder for [`ProposalActions`](crate::model::ProposalActions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invitations: std::option::Option<std::vec::Vec<crate::model::InviteAction>>,
        pub(crate) removals: std::option::Option<std::vec::Vec<crate::model::RemoveAction>>,
    }
    impl Builder {
        /// Appends an item to `invitations`.
        ///
        /// To override the contents of this collection use [`set_invitations`](Self::set_invitations).
        ///
        /// <p>
        /// The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and join the network.
        /// </p>
        pub fn invitations(mut self, input: impl Into<crate::model::InviteAction>) -> Self {
            let mut v = self.invitations.unwrap_or_default();
            v.push(input.into());
            self.invitations = Some(v);
            self
        }
        /// <p>
        /// The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and join the network.
        /// </p>
        pub fn set_invitations(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::InviteAction>>,
        ) -> Self {
            self.invitations = input;
            self
        }
        /// Appends an item to `removals`.
        ///
        /// To override the contents of this collection use [`set_removals`](Self::set_removals).
        ///
        /// <p>
        /// The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which deletes the member and all associated member resources from the network.
        /// </p>
        pub fn removals(mut self, input: impl Into<crate::model::RemoveAction>) -> Self {
            let mut v = self.removals.unwrap_or_default();
            v.push(input.into());
            self.removals = Some(v);
            self
        }
        /// <p>
        /// The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which deletes the member and all associated member resources from the network.
        /// </p>
        pub fn set_removals(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::RemoveAction>>,
        ) -> Self {
            self.removals = input;
            self
        }
        /// Consumes the builder and constructs a [`ProposalActions`](crate::model::ProposalActions)
        pub fn build(self) -> crate::model::ProposalActions {
            crate::model::ProposalActions {
                invitations: self.invitations,
                removals: self.removals,
            }
        }
    }
}
impl ProposalActions {
    /// Creates a new builder-style object to manufacture [`ProposalActions`](crate::model::ProposalActions)
    pub fn builder() -> crate::model::proposal_actions::Builder {
        crate::model::proposal_actions::Builder::default()
    }
}

/// <p>An action to remove a member from a Managed Blockchain network as the result of a removal proposal that is <code>APPROVED</code>. The member and all associated resources are deleted from the network.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct RemoveAction {
    /// <p>The unique identifier of the member to remove.</p>
    pub member_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for RemoveAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("RemoveAction");
        formatter.field("member_id", &self.member_id);
        formatter.finish()
    }
}
/// See [`RemoveAction`](crate::model::RemoveAction)
pub mod remove_action {
    /// A builder for [`RemoveAction`](crate::model::RemoveAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) member_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the member to remove.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member to remove.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// Consumes the builder and constructs a [`RemoveAction`](crate::model::RemoveAction)
        pub fn build(self) -> crate::model::RemoveAction {
            crate::model::RemoveAction {
                member_id: self.member_id,
            }
        }
    }
}
impl RemoveAction {
    /// Creates a new builder-style object to manufacture [`RemoveAction`](crate::model::RemoveAction)
    pub fn builder() -> crate::model::remove_action::Builder {
        crate::model::remove_action::Builder::default()
    }
}

/// <p>An action to invite a specific AWS account to create a member and join the network. The <code>InviteAction</code> is carried out when a <code>Proposal</code> is <code>APPROVED</code>.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InviteAction {
    /// <p>The AWS account ID to invite.</p>
    pub principal: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InviteAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InviteAction");
        formatter.field("principal", &self.principal);
        formatter.finish()
    }
}
/// See [`InviteAction`](crate::model::InviteAction)
pub mod invite_action {
    /// A builder for [`InviteAction`](crate::model::InviteAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) principal: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID to invite.</p>
        pub fn principal(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal = Some(input.into());
            self
        }
        /// <p>The AWS account ID to invite.</p>
        pub fn set_principal(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal = input;
            self
        }
        /// Consumes the builder and constructs a [`InviteAction`](crate::model::InviteAction)
        pub fn build(self) -> crate::model::InviteAction {
            crate::model::InviteAction {
                principal: self.principal,
            }
        }
    }
}
impl InviteAction {
    /// Creates a new builder-style object to manufacture [`InviteAction`](crate::model::InviteAction)
    pub fn builder() -> crate::model::invite_action::Builder {
        crate::model::invite_action::Builder::default()
    }
}

/// <p>Configuration properties of a node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Node {
    /// <p>The unique identifier of the network that the node is on.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member to which the node belongs.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub member_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the node.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The instance type of the node.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Attributes of the blockchain framework being used.</p>
    pub framework_attributes: std::option::Option<crate::model::NodeFrameworkAttributes>,
    /// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>
    pub log_publishing_configuration:
        std::option::Option<crate::model::NodeLogPublishingConfiguration>,
    /// <p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub state_db: std::option::Option<crate::model::StateDbType>,
    /// <p>The status of the node.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The AWS account is in the process of creating a node.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The node has been created and can participate in the network.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UNHEALTHY</code> - The node is impaired and might not function as expected. Amazon Managed Blockchain automatically finds nodes in this state and tries to recover them. If a node is recoverable, it returns to <code>AVAILABLE</code>. Otherwise, it moves to <code>FAILED</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> - The AWS account attempted to create a node and creation failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - The node is in the process of being updated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The node is in the process of being deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The node can no longer participate on the network.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The node is no longer functional, cannot be recovered, and must be deleted.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The node is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
    /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The node resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::NodeStatus>,
    /// <p>The date and time that the node was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Tags assigned to the node. Each tag consists of a key and optional value.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the node uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the node uses an AWS owned KMS key for encryption. The node inherits this parameter from the member that it belongs to.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Node {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Node");
        formatter.field("network_id", &self.network_id);
        formatter.field("member_id", &self.member_id);
        formatter.field("id", &self.id);
        formatter.field("instance_type", &self.instance_type);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field("framework_attributes", &self.framework_attributes);
        formatter.field(
            "log_publishing_configuration",
            &self.log_publishing_configuration,
        );
        formatter.field("state_db", &self.state_db);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("tags", &self.tags);
        formatter.field("arn", &self.arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`Node`](crate::model::Node)
pub mod node {
    /// A builder for [`Node`](crate::model::Node)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) member_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) framework_attributes: std::option::Option<crate::model::NodeFrameworkAttributes>,
        pub(crate) log_publishing_configuration:
            std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        pub(crate) state_db: std::option::Option<crate::model::StateDbType>,
        pub(crate) status: std::option::Option<crate::model::NodeStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network that the node is on.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member to which the node belongs.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn member_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.member_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member to which the node belongs.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_member_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.member_id = input;
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the node.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The instance type of the node.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The instance type of the node.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Attributes of the blockchain framework being used.</p>
        pub fn framework_attributes(
            mut self,
            input: crate::model::NodeFrameworkAttributes,
        ) -> Self {
            self.framework_attributes = Some(input);
            self
        }
        /// <p>Attributes of the blockchain framework being used.</p>
        pub fn set_framework_attributes(
            mut self,
            input: std::option::Option<crate::model::NodeFrameworkAttributes>,
        ) -> Self {
            self.framework_attributes = input;
            self
        }
        /// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::NodeLogPublishingConfiguration,
        ) -> Self {
            self.log_publishing_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        ) -> Self {
            self.log_publishing_configuration = input;
            self
        }
        /// <p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn state_db(mut self, input: crate::model::StateDbType) -> Self {
            self.state_db = Some(input);
            self
        }
        /// <p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_state_db(
            mut self,
            input: std::option::Option<crate::model::StateDbType>,
        ) -> Self {
            self.state_db = input;
            self
        }
        /// <p>The status of the node.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The AWS account is in the process of creating a node.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The node has been created and can participate in the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> - The node is impaired and might not function as expected. Amazon Managed Blockchain automatically finds nodes in this state and tries to recover them. If a node is recoverable, it returns to <code>AVAILABLE</code>. Otherwise, it moves to <code>FAILED</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> - The AWS account attempted to create a node and creation failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The node is in the process of being updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The node is in the process of being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The node can no longer participate on the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The node is no longer functional, cannot be recovered, and must be deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The node is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
        /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The node resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::NodeStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the node.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The AWS account is in the process of creating a node.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The node has been created and can participate in the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UNHEALTHY</code> - The node is impaired and might not function as expected. Amazon Managed Blockchain automatically finds nodes in this state and tries to recover them. If a node is recoverable, it returns to <code>AVAILABLE</code>. Otherwise, it moves to <code>FAILED</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> - The AWS account attempted to create a node and creation failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The node is in the process of being updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The node is in the process of being deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The node can no longer participate on the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The node is no longer functional, cannot be recovered, and must be deleted.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The node is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
        /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The node resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
        /// </li>
        /// </ul>
        pub fn set_status(mut self, input: std::option::Option<crate::model::NodeStatus>) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the node was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the node was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the node. Each tag consists of a key and optional value.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to the node. Each tag consists of a key and optional value.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the node uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the node uses an AWS owned KMS key for encryption. The node inherits this parameter from the member that it belongs to.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the node uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the node uses an AWS owned KMS key for encryption. The node inherits this parameter from the member that it belongs to.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Node`](crate::model::Node)
        pub fn build(self) -> crate::model::Node {
            crate::model::Node {
                network_id: self.network_id,
                member_id: self.member_id,
                id: self.id,
                instance_type: self.instance_type,
                availability_zone: self.availability_zone,
                framework_attributes: self.framework_attributes,
                log_publishing_configuration: self.log_publishing_configuration,
                state_db: self.state_db,
                status: self.status,
                creation_date: self.creation_date,
                tags: self.tags,
                arn: self.arn,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl Node {
    /// Creates a new builder-style object to manufacture [`Node`](crate::model::Node)
    pub fn builder() -> crate::model::node::Builder {
        crate::model::node::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StateDbType {
    #[allow(missing_docs)] // documentation missing in model
    CouchDb,
    #[allow(missing_docs)] // documentation missing in model
    LevelDb,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StateDbType {
    fn from(s: &str) -> Self {
        match s {
            "CouchDB" => StateDbType::CouchDb,
            "LevelDB" => StateDbType::LevelDb,
            other => StateDbType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StateDbType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StateDbType::from(s))
    }
}
impl StateDbType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StateDbType::CouchDb => "CouchDB",
            StateDbType::LevelDb => "LevelDB",
            StateDbType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CouchDB", "LevelDB"]
    }
}
impl AsRef<str> for StateDbType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Attributes relevant to a node on a Managed Blockchain network for the blockchain framework that the network uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeFrameworkAttributes {
    /// <p>Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger Fabric.</p>
    pub fabric: std::option::Option<crate::model::NodeFabricAttributes>,
    /// <p>Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum. </p>
    pub ethereum: std::option::Option<crate::model::NodeEthereumAttributes>,
}
impl std::fmt::Debug for NodeFrameworkAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeFrameworkAttributes");
        formatter.field("fabric", &self.fabric);
        formatter.field("ethereum", &self.ethereum);
        formatter.finish()
    }
}
/// See [`NodeFrameworkAttributes`](crate::model::NodeFrameworkAttributes)
pub mod node_framework_attributes {
    /// A builder for [`NodeFrameworkAttributes`](crate::model::NodeFrameworkAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric: std::option::Option<crate::model::NodeFabricAttributes>,
        pub(crate) ethereum: std::option::Option<crate::model::NodeEthereumAttributes>,
    }
    impl Builder {
        /// <p>Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn fabric(mut self, input: crate::model::NodeFabricAttributes) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::NodeFabricAttributes>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// <p>Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum. </p>
        pub fn ethereum(mut self, input: crate::model::NodeEthereumAttributes) -> Self {
            self.ethereum = Some(input);
            self
        }
        /// <p>Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum. </p>
        pub fn set_ethereum(
            mut self,
            input: std::option::Option<crate::model::NodeEthereumAttributes>,
        ) -> Self {
            self.ethereum = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeFrameworkAttributes`](crate::model::NodeFrameworkAttributes)
        pub fn build(self) -> crate::model::NodeFrameworkAttributes {
            crate::model::NodeFrameworkAttributes {
                fabric: self.fabric,
                ethereum: self.ethereum,
            }
        }
    }
}
impl NodeFrameworkAttributes {
    /// Creates a new builder-style object to manufacture [`NodeFrameworkAttributes`](crate::model::NodeFrameworkAttributes)
    pub fn builder() -> crate::model::node_framework_attributes::Builder {
        crate::model::node_framework_attributes::Builder::default()
    }
}

/// <p>Attributes of an Ethereum node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeEthereumAttributes {
    /// <p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over HTTP connections from a client. Use this endpoint in client code for smart contracts when using an HTTP connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
    pub http_endpoint: std::option::Option<std::string::String>,
    /// <p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over WebSockets connections from a client. Use this endpoint in client code for smart contracts when using a WebSockets connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
    pub web_socket_endpoint: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeEthereumAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeEthereumAttributes");
        formatter.field("http_endpoint", &self.http_endpoint);
        formatter.field("web_socket_endpoint", &self.web_socket_endpoint);
        formatter.finish()
    }
}
/// See [`NodeEthereumAttributes`](crate::model::NodeEthereumAttributes)
pub mod node_ethereum_attributes {
    /// A builder for [`NodeEthereumAttributes`](crate::model::NodeEthereumAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) http_endpoint: std::option::Option<std::string::String>,
        pub(crate) web_socket_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over HTTP connections from a client. Use this endpoint in client code for smart contracts when using an HTTP connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
        pub fn http_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.http_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over HTTP connections from a client. Use this endpoint in client code for smart contracts when using an HTTP connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
        pub fn set_http_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.http_endpoint = input;
            self
        }
        /// <p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over WebSockets connections from a client. Use this endpoint in client code for smart contracts when using a WebSockets connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
        pub fn web_socket_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.web_socket_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over WebSockets connections from a client. Use this endpoint in client code for smart contracts when using a WebSockets connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>
        pub fn set_web_socket_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.web_socket_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeEthereumAttributes`](crate::model::NodeEthereumAttributes)
        pub fn build(self) -> crate::model::NodeEthereumAttributes {
            crate::model::NodeEthereumAttributes {
                http_endpoint: self.http_endpoint,
                web_socket_endpoint: self.web_socket_endpoint,
            }
        }
    }
}
impl NodeEthereumAttributes {
    /// Creates a new builder-style object to manufacture [`NodeEthereumAttributes`](crate::model::NodeEthereumAttributes)
    pub fn builder() -> crate::model::node_ethereum_attributes::Builder {
        crate::model::node_ethereum_attributes::Builder::default()
    }
}

/// <p>Attributes of Hyperledger Fabric for a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeFabricAttributes {
    /// <p>The endpoint that identifies the peer node for all services except peer channel-based event services.</p>
    pub peer_endpoint: std::option::Option<std::string::String>,
    /// <p>The endpoint that identifies the peer node for peer channel-based event services.</p>
    pub peer_event_endpoint: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NodeFabricAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeFabricAttributes");
        formatter.field("peer_endpoint", &self.peer_endpoint);
        formatter.field("peer_event_endpoint", &self.peer_event_endpoint);
        formatter.finish()
    }
}
/// See [`NodeFabricAttributes`](crate::model::NodeFabricAttributes)
pub mod node_fabric_attributes {
    /// A builder for [`NodeFabricAttributes`](crate::model::NodeFabricAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) peer_endpoint: std::option::Option<std::string::String>,
        pub(crate) peer_event_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The endpoint that identifies the peer node for all services except peer channel-based event services.</p>
        pub fn peer_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint that identifies the peer node for all services except peer channel-based event services.</p>
        pub fn set_peer_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.peer_endpoint = input;
            self
        }
        /// <p>The endpoint that identifies the peer node for peer channel-based event services.</p>
        pub fn peer_event_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.peer_event_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint that identifies the peer node for peer channel-based event services.</p>
        pub fn set_peer_event_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.peer_event_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeFabricAttributes`](crate::model::NodeFabricAttributes)
        pub fn build(self) -> crate::model::NodeFabricAttributes {
            crate::model::NodeFabricAttributes {
                peer_endpoint: self.peer_endpoint,
                peer_event_endpoint: self.peer_event_endpoint,
            }
        }
    }
}
impl NodeFabricAttributes {
    /// Creates a new builder-style object to manufacture [`NodeFabricAttributes`](crate::model::NodeFabricAttributes)
    pub fn builder() -> crate::model::node_fabric_attributes::Builder {
        crate::model::node_fabric_attributes::Builder::default()
    }
}

/// <p>Network configuration properties.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Network {
    /// <p>The unique identifier of the network.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the network.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>Attributes of the blockchain framework for the network.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The blockchain framework that the network uses.</p>
    pub framework: std::option::Option<crate::model::Framework>,
    /// <p>The version of the blockchain framework that the network uses.</p>
    pub framework_version: std::option::Option<std::string::String>,
    /// <p>Attributes of the blockchain framework that the network uses.</p>
    pub framework_attributes: std::option::Option<crate::model::NetworkFrameworkAttributes>,
    /// <p>The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service name to create a VPC endpoint to access network resources.</p>
    pub vpc_endpoint_service_name: std::option::Option<std::string::String>,
    /// <p>The voting rules for the network to decide if a proposal is accepted.</p>
    pub voting_policy: std::option::Option<crate::model::VotingPolicy>,
    /// <p>The current status of the network.</p>
    pub status: std::option::Option<crate::model::NetworkStatus>,
    /// <p>The date and time that the network was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Tags assigned to the network. Each tag consists of a key and optional value.</p>
    /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Network {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Network");
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("framework", &self.framework);
        formatter.field("framework_version", &self.framework_version);
        formatter.field("framework_attributes", &self.framework_attributes);
        formatter.field("vpc_endpoint_service_name", &self.vpc_endpoint_service_name);
        formatter.field("voting_policy", &self.voting_policy);
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("tags", &self.tags);
        formatter.field("arn", &self.arn);
        formatter.finish()
    }
}
/// See [`Network`](crate::model::Network)
pub mod network {
    /// A builder for [`Network`](crate::model::Network)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) framework: std::option::Option<crate::model::Framework>,
        pub(crate) framework_version: std::option::Option<std::string::String>,
        pub(crate) framework_attributes:
            std::option::Option<crate::model::NetworkFrameworkAttributes>,
        pub(crate) vpc_endpoint_service_name: std::option::Option<std::string::String>,
        pub(crate) voting_policy: std::option::Option<crate::model::VotingPolicy>,
        pub(crate) status: std::option::Option<crate::model::NetworkStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the network.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the network.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>Attributes of the blockchain framework for the network.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>Attributes of the blockchain framework for the network.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn framework(mut self, input: crate::model::Framework) -> Self {
            self.framework = Some(input);
            self
        }
        /// <p>The blockchain framework that the network uses.</p>
        pub fn set_framework(
            mut self,
            input: std::option::Option<crate::model::Framework>,
        ) -> Self {
            self.framework = input;
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn framework_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.framework_version = Some(input.into());
            self
        }
        /// <p>The version of the blockchain framework that the network uses.</p>
        pub fn set_framework_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.framework_version = input;
            self
        }
        /// <p>Attributes of the blockchain framework that the network uses.</p>
        pub fn framework_attributes(
            mut self,
            input: crate::model::NetworkFrameworkAttributes,
        ) -> Self {
            self.framework_attributes = Some(input);
            self
        }
        /// <p>Attributes of the blockchain framework that the network uses.</p>
        pub fn set_framework_attributes(
            mut self,
            input: std::option::Option<crate::model::NetworkFrameworkAttributes>,
        ) -> Self {
            self.framework_attributes = input;
            self
        }
        /// <p>The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service name to create a VPC endpoint to access network resources.</p>
        pub fn vpc_endpoint_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.vpc_endpoint_service_name = Some(input.into());
            self
        }
        /// <p>The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service name to create a VPC endpoint to access network resources.</p>
        pub fn set_vpc_endpoint_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.vpc_endpoint_service_name = input;
            self
        }
        /// <p>The voting rules for the network to decide if a proposal is accepted.</p>
        pub fn voting_policy(mut self, input: crate::model::VotingPolicy) -> Self {
            self.voting_policy = Some(input);
            self
        }
        /// <p>The voting rules for the network to decide if a proposal is accepted.</p>
        pub fn set_voting_policy(
            mut self,
            input: std::option::Option<crate::model::VotingPolicy>,
        ) -> Self {
            self.voting_policy = input;
            self
        }
        /// <p>The current status of the network.</p>
        pub fn status(mut self, input: crate::model::NetworkStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the network.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::NetworkStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the network was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the network was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the network. Each tag consists of a key and optional value.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to the network. Each tag consists of a key and optional value.</p>
        /// <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Network`](crate::model::Network)
        pub fn build(self) -> crate::model::Network {
            crate::model::Network {
                id: self.id,
                name: self.name,
                description: self.description,
                framework: self.framework,
                framework_version: self.framework_version,
                framework_attributes: self.framework_attributes,
                vpc_endpoint_service_name: self.vpc_endpoint_service_name,
                voting_policy: self.voting_policy,
                status: self.status,
                creation_date: self.creation_date,
                tags: self.tags,
                arn: self.arn,
            }
        }
    }
}
impl Network {
    /// Creates a new builder-style object to manufacture [`Network`](crate::model::Network)
    pub fn builder() -> crate::model::network::Builder {
        crate::model::network::Builder::default()
    }
}

/// <p>
/// The voting rules for the network to decide if a proposal is accepted
/// </p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct VotingPolicy {
    /// <p>Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.</p>
    pub approval_threshold_policy: std::option::Option<crate::model::ApprovalThresholdPolicy>,
}
impl std::fmt::Debug for VotingPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("VotingPolicy");
        formatter.field("approval_threshold_policy", &self.approval_threshold_policy);
        formatter.finish()
    }
}
/// See [`VotingPolicy`](crate::model::VotingPolicy)
pub mod voting_policy {
    /// A builder for [`VotingPolicy`](crate::model::VotingPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approval_threshold_policy:
            std::option::Option<crate::model::ApprovalThresholdPolicy>,
    }
    impl Builder {
        /// <p>Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.</p>
        pub fn approval_threshold_policy(
            mut self,
            input: crate::model::ApprovalThresholdPolicy,
        ) -> Self {
            self.approval_threshold_policy = Some(input);
            self
        }
        /// <p>Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.</p>
        pub fn set_approval_threshold_policy(
            mut self,
            input: std::option::Option<crate::model::ApprovalThresholdPolicy>,
        ) -> Self {
            self.approval_threshold_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`VotingPolicy`](crate::model::VotingPolicy)
        pub fn build(self) -> crate::model::VotingPolicy {
            crate::model::VotingPolicy {
                approval_threshold_policy: self.approval_threshold_policy,
            }
        }
    }
}
impl VotingPolicy {
    /// Creates a new builder-style object to manufacture [`VotingPolicy`](crate::model::VotingPolicy)
    pub fn builder() -> crate::model::voting_policy::Builder {
        crate::model::voting_policy::Builder::default()
    }
}

/// <p>A policy type that defines the voting rules for the network. The rules decide if a proposal is approved. Approval may be based on criteria such as the percentage of <code>YES</code> votes and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApprovalThresholdPolicy {
    /// <p>The percentage of votes among all members that must be <code>YES</code> for a proposal to be approved. For example, a <code>ThresholdPercentage</code> value of <code>50</code> indicates 50%. The <code>ThresholdComparator</code> determines the precise comparison. If a <code>ThresholdPercentage</code> value of <code>50</code> is specified on a network with 10 members, along with a <code>ThresholdComparator</code> value of <code>GREATER_THAN</code>, this indicates that 6 <code>YES</code> votes are required for the proposal to be approved.</p>
    pub threshold_percentage: std::option::Option<i32>,
    /// <p>The duration from the time that a proposal is created until it expires. If members cast neither the required number of <code>YES</code> votes to approve the proposal nor the number of <code>NO</code> votes required to reject it before the duration expires, the proposal is <code>EXPIRED</code> and <code>ProposalActions</code> are not carried out.</p>
    pub proposal_duration_in_hours: std::option::Option<i32>,
    /// <p>Determines whether the vote percentage must be greater than the <code>ThresholdPercentage</code> or must be greater than or equal to the <code>ThreholdPercentage</code> to be approved.</p>
    pub threshold_comparator: std::option::Option<crate::model::ThresholdComparator>,
}
impl std::fmt::Debug for ApprovalThresholdPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApprovalThresholdPolicy");
        formatter.field("threshold_percentage", &self.threshold_percentage);
        formatter.field(
            "proposal_duration_in_hours",
            &self.proposal_duration_in_hours,
        );
        formatter.field("threshold_comparator", &self.threshold_comparator);
        formatter.finish()
    }
}
/// See [`ApprovalThresholdPolicy`](crate::model::ApprovalThresholdPolicy)
pub mod approval_threshold_policy {
    /// A builder for [`ApprovalThresholdPolicy`](crate::model::ApprovalThresholdPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) threshold_percentage: std::option::Option<i32>,
        pub(crate) proposal_duration_in_hours: std::option::Option<i32>,
        pub(crate) threshold_comparator: std::option::Option<crate::model::ThresholdComparator>,
    }
    impl Builder {
        /// <p>The percentage of votes among all members that must be <code>YES</code> for a proposal to be approved. For example, a <code>ThresholdPercentage</code> value of <code>50</code> indicates 50%. The <code>ThresholdComparator</code> determines the precise comparison. If a <code>ThresholdPercentage</code> value of <code>50</code> is specified on a network with 10 members, along with a <code>ThresholdComparator</code> value of <code>GREATER_THAN</code>, this indicates that 6 <code>YES</code> votes are required for the proposal to be approved.</p>
        pub fn threshold_percentage(mut self, input: i32) -> Self {
            self.threshold_percentage = Some(input);
            self
        }
        /// <p>The percentage of votes among all members that must be <code>YES</code> for a proposal to be approved. For example, a <code>ThresholdPercentage</code> value of <code>50</code> indicates 50%. The <code>ThresholdComparator</code> determines the precise comparison. If a <code>ThresholdPercentage</code> value of <code>50</code> is specified on a network with 10 members, along with a <code>ThresholdComparator</code> value of <code>GREATER_THAN</code>, this indicates that 6 <code>YES</code> votes are required for the proposal to be approved.</p>
        pub fn set_threshold_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.threshold_percentage = input;
            self
        }
        /// <p>The duration from the time that a proposal is created until it expires. If members cast neither the required number of <code>YES</code> votes to approve the proposal nor the number of <code>NO</code> votes required to reject it before the duration expires, the proposal is <code>EXPIRED</code> and <code>ProposalActions</code> are not carried out.</p>
        pub fn proposal_duration_in_hours(mut self, input: i32) -> Self {
            self.proposal_duration_in_hours = Some(input);
            self
        }
        /// <p>The duration from the time that a proposal is created until it expires. If members cast neither the required number of <code>YES</code> votes to approve the proposal nor the number of <code>NO</code> votes required to reject it before the duration expires, the proposal is <code>EXPIRED</code> and <code>ProposalActions</code> are not carried out.</p>
        pub fn set_proposal_duration_in_hours(mut self, input: std::option::Option<i32>) -> Self {
            self.proposal_duration_in_hours = input;
            self
        }
        /// <p>Determines whether the vote percentage must be greater than the <code>ThresholdPercentage</code> or must be greater than or equal to the <code>ThreholdPercentage</code> to be approved.</p>
        pub fn threshold_comparator(mut self, input: crate::model::ThresholdComparator) -> Self {
            self.threshold_comparator = Some(input);
            self
        }
        /// <p>Determines whether the vote percentage must be greater than the <code>ThresholdPercentage</code> or must be greater than or equal to the <code>ThreholdPercentage</code> to be approved.</p>
        pub fn set_threshold_comparator(
            mut self,
            input: std::option::Option<crate::model::ThresholdComparator>,
        ) -> Self {
            self.threshold_comparator = input;
            self
        }
        /// Consumes the builder and constructs a [`ApprovalThresholdPolicy`](crate::model::ApprovalThresholdPolicy)
        pub fn build(self) -> crate::model::ApprovalThresholdPolicy {
            crate::model::ApprovalThresholdPolicy {
                threshold_percentage: self.threshold_percentage,
                proposal_duration_in_hours: self.proposal_duration_in_hours,
                threshold_comparator: self.threshold_comparator,
            }
        }
    }
}
impl ApprovalThresholdPolicy {
    /// Creates a new builder-style object to manufacture [`ApprovalThresholdPolicy`](crate::model::ApprovalThresholdPolicy)
    pub fn builder() -> crate::model::approval_threshold_policy::Builder {
        crate::model::approval_threshold_policy::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ThresholdComparator {
    #[allow(missing_docs)] // documentation missing in model
    GreaterThan,
    #[allow(missing_docs)] // documentation missing in model
    GreaterThanOrEqualTo,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ThresholdComparator {
    fn from(s: &str) -> Self {
        match s {
            "GREATER_THAN" => ThresholdComparator::GreaterThan,
            "GREATER_THAN_OR_EQUAL_TO" => ThresholdComparator::GreaterThanOrEqualTo,
            other => ThresholdComparator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ThresholdComparator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ThresholdComparator::from(s))
    }
}
impl ThresholdComparator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ThresholdComparator::GreaterThan => "GREATER_THAN",
            ThresholdComparator::GreaterThanOrEqualTo => "GREATER_THAN_OR_EQUAL_TO",
            ThresholdComparator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["GREATER_THAN", "GREATER_THAN_OR_EQUAL_TO"]
    }
}
impl AsRef<str> for ThresholdComparator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Attributes relevant to the network for the blockchain framework that the network uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFrameworkAttributes {
    /// <p>Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.</p>
    pub fabric: std::option::Option<crate::model::NetworkFabricAttributes>,
    /// <p>Attributes of an Ethereum network for Managed Blockchain resources participating in an Ethereum network. </p>
    pub ethereum: std::option::Option<crate::model::NetworkEthereumAttributes>,
}
impl std::fmt::Debug for NetworkFrameworkAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFrameworkAttributes");
        formatter.field("fabric", &self.fabric);
        formatter.field("ethereum", &self.ethereum);
        formatter.finish()
    }
}
/// See [`NetworkFrameworkAttributes`](crate::model::NetworkFrameworkAttributes)
pub mod network_framework_attributes {
    /// A builder for [`NetworkFrameworkAttributes`](crate::model::NetworkFrameworkAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric: std::option::Option<crate::model::NetworkFabricAttributes>,
        pub(crate) ethereum: std::option::Option<crate::model::NetworkEthereumAttributes>,
    }
    impl Builder {
        /// <p>Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn fabric(mut self, input: crate::model::NetworkFabricAttributes) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricAttributes>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// <p>Attributes of an Ethereum network for Managed Blockchain resources participating in an Ethereum network. </p>
        pub fn ethereum(mut self, input: crate::model::NetworkEthereumAttributes) -> Self {
            self.ethereum = Some(input);
            self
        }
        /// <p>Attributes of an Ethereum network for Managed Blockchain resources participating in an Ethereum network. </p>
        pub fn set_ethereum(
            mut self,
            input: std::option::Option<crate::model::NetworkEthereumAttributes>,
        ) -> Self {
            self.ethereum = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFrameworkAttributes`](crate::model::NetworkFrameworkAttributes)
        pub fn build(self) -> crate::model::NetworkFrameworkAttributes {
            crate::model::NetworkFrameworkAttributes {
                fabric: self.fabric,
                ethereum: self.ethereum,
            }
        }
    }
}
impl NetworkFrameworkAttributes {
    /// Creates a new builder-style object to manufacture [`NetworkFrameworkAttributes`](crate::model::NetworkFrameworkAttributes)
    pub fn builder() -> crate::model::network_framework_attributes::Builder {
        crate::model::network_framework_attributes::Builder::default()
    }
}

/// <p>Attributes of Ethereum for a network. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkEthereumAttributes {
    /// <p>The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:</p>
    /// <ul>
    /// <li>
    /// <p>mainnet = <code>1</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>rinkeby = <code>4</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>ropsten = <code>3</code>
    /// </p>
    /// </li>
    /// </ul>
    pub chain_id: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for NetworkEthereumAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkEthereumAttributes");
        formatter.field("chain_id", &self.chain_id);
        formatter.finish()
    }
}
/// See [`NetworkEthereumAttributes`](crate::model::NetworkEthereumAttributes)
pub mod network_ethereum_attributes {
    /// A builder for [`NetworkEthereumAttributes`](crate::model::NetworkEthereumAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) chain_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>mainnet = <code>1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>rinkeby = <code>4</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ropsten = <code>3</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn chain_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.chain_id = Some(input.into());
            self
        }
        /// <p>The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:</p>
        /// <ul>
        /// <li>
        /// <p>mainnet = <code>1</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>rinkeby = <code>4</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>ropsten = <code>3</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_chain_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.chain_id = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkEthereumAttributes`](crate::model::NetworkEthereumAttributes)
        pub fn build(self) -> crate::model::NetworkEthereumAttributes {
            crate::model::NetworkEthereumAttributes {
                chain_id: self.chain_id,
            }
        }
    }
}
impl NetworkEthereumAttributes {
    /// Creates a new builder-style object to manufacture [`NetworkEthereumAttributes`](crate::model::NetworkEthereumAttributes)
    pub fn builder() -> crate::model::network_ethereum_attributes::Builder {
        crate::model::network_ethereum_attributes::Builder::default()
    }
}

/// <p>Attributes of Hyperledger Fabric for a network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFabricAttributes {
    /// <p>The endpoint of the ordering service for the network.</p>
    pub ordering_service_endpoint: std::option::Option<std::string::String>,
    /// <p>The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>
    pub edition: std::option::Option<crate::model::Edition>,
}
impl std::fmt::Debug for NetworkFabricAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFabricAttributes");
        formatter.field("ordering_service_endpoint", &self.ordering_service_endpoint);
        formatter.field("edition", &self.edition);
        formatter.finish()
    }
}
/// See [`NetworkFabricAttributes`](crate::model::NetworkFabricAttributes)
pub mod network_fabric_attributes {
    /// A builder for [`NetworkFabricAttributes`](crate::model::NetworkFabricAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ordering_service_endpoint: std::option::Option<std::string::String>,
        pub(crate) edition: std::option::Option<crate::model::Edition>,
    }
    impl Builder {
        /// <p>The endpoint of the ordering service for the network.</p>
        pub fn ordering_service_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.ordering_service_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint of the ordering service for the network.</p>
        pub fn set_ordering_service_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ordering_service_endpoint = input;
            self
        }
        /// <p>The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>
        pub fn edition(mut self, input: crate::model::Edition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>
        pub fn set_edition(mut self, input: std::option::Option<crate::model::Edition>) -> Self {
            self.edition = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFabricAttributes`](crate::model::NetworkFabricAttributes)
        pub fn build(self) -> crate::model::NetworkFabricAttributes {
            crate::model::NetworkFabricAttributes {
                ordering_service_endpoint: self.ordering_service_endpoint,
                edition: self.edition,
            }
        }
    }
}
impl NetworkFabricAttributes {
    /// Creates a new builder-style object to manufacture [`NetworkFabricAttributes`](crate::model::NetworkFabricAttributes)
    pub fn builder() -> crate::model::network_fabric_attributes::Builder {
        crate::model::network_fabric_attributes::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Edition {
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    Starter,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Edition {
    fn from(s: &str) -> Self {
        match s {
            "STANDARD" => Edition::Standard,
            "STARTER" => Edition::Starter,
            other => Edition::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Edition {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Edition::from(s))
    }
}
impl Edition {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Edition::Standard => "STANDARD",
            Edition::Starter => "STARTER",
            Edition::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["STANDARD", "STARTER"]
    }
}
impl AsRef<str> for Edition {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Member configuration properties.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The unique identifier of the network to which the member belongs.</p>
    pub network_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier of the member.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The name of the member.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description for the member.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>
    pub framework_attributes: std::option::Option<crate::model::MemberFrameworkAttributes>,
    /// <p>Configuration properties for logging events associated with a member.</p>
    pub log_publishing_configuration:
        std::option::Option<crate::model::MemberLogPublishingConfiguration>,
    /// <p>The status of a member.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CREATING</code> - The AWS account is in the process of creating a member.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>AVAILABLE</code> - The member has been created and can participate in the network.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>UPDATING</code> - The member is in the process of being updated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
    /// <code>PROPOSAL</code> to remove the member.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
    /// <code>PROPOSAL</code> to remove the member.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
    /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The member resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::MemberStatus>,
    /// <p>The date and time that the member was created.</p>
    pub creation_date: std::option::Option<aws_smithy_types::Instant>,
    /// <p>Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the member uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the member uses an AWS owned KMS key for encryption. This parameter is inherited by the nodes that this member owns.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("network_id", &self.network_id);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("framework_attributes", &self.framework_attributes);
        formatter.field(
            "log_publishing_configuration",
            &self.log_publishing_configuration,
        );
        formatter.field("status", &self.status);
        formatter.field("creation_date", &self.creation_date);
        formatter.field("tags", &self.tags);
        formatter.field("arn", &self.arn);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) network_id: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) framework_attributes:
            std::option::Option<crate::model::MemberFrameworkAttributes>,
        pub(crate) log_publishing_configuration:
            std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        pub(crate) status: std::option::Option<crate::model::MemberStatus>,
        pub(crate) creation_date: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn network_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.network_id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the network to which the member belongs.</p>
        pub fn set_network_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.network_id = input;
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier of the member.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The name of the member.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the member.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description for the member.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description for the member.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>
        pub fn framework_attributes(
            mut self,
            input: crate::model::MemberFrameworkAttributes,
        ) -> Self {
            self.framework_attributes = Some(input);
            self
        }
        /// <p>Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>
        pub fn set_framework_attributes(
            mut self,
            input: std::option::Option<crate::model::MemberFrameworkAttributes>,
        ) -> Self {
            self.framework_attributes = input;
            self
        }
        /// <p>Configuration properties for logging events associated with a member.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::MemberLogPublishingConfiguration,
        ) -> Self {
            self.log_publishing_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a member.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        ) -> Self {
            self.log_publishing_configuration = input;
            self
        }
        /// <p>The status of a member.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The AWS account is in the process of creating a member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The member has been created and can participate in the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The member is in the process of being updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
        /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The member resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::MemberStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of a member.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CREATING</code> - The AWS account is in the process of creating a member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>AVAILABLE</code> - The member has been created and can participate in the network.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>UPDATING</code> - The member is in the process of being updated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code>
        /// <code>PROPOSAL</code> to remove the member.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in AWS KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p>
        /// <p>The effect of disabling or deleting a key, or revoking a grant is not immediate. The member resource might take some time to find that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::MemberStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The date and time that the member was created.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::Instant) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time that the member was created.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>AWS General Reference</i>.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the member uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the member uses an AWS owned KMS key for encryption. This parameter is inherited by the nodes that this member owns.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) that the member uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the member uses an AWS owned KMS key for encryption. This parameter is inherited by the nodes that this member owns.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                network_id: self.network_id,
                id: self.id,
                name: self.name,
                description: self.description,
                framework_attributes: self.framework_attributes,
                log_publishing_configuration: self.log_publishing_configuration,
                status: self.status,
                creation_date: self.creation_date,
                tags: self.tags,
                arn: self.arn,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

/// <p>Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberFrameworkAttributes {
    /// <p>Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>
    pub fabric: std::option::Option<crate::model::MemberFabricAttributes>,
}
impl std::fmt::Debug for MemberFrameworkAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberFrameworkAttributes");
        formatter.field("fabric", &self.fabric);
        formatter.finish()
    }
}
/// See [`MemberFrameworkAttributes`](crate::model::MemberFrameworkAttributes)
pub mod member_framework_attributes {
    /// A builder for [`MemberFrameworkAttributes`](crate::model::MemberFrameworkAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric: std::option::Option<crate::model::MemberFabricAttributes>,
    }
    impl Builder {
        /// <p>Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn fabric(mut self, input: crate::model::MemberFabricAttributes) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::MemberFabricAttributes>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberFrameworkAttributes`](crate::model::MemberFrameworkAttributes)
        pub fn build(self) -> crate::model::MemberFrameworkAttributes {
            crate::model::MemberFrameworkAttributes {
                fabric: self.fabric,
            }
        }
    }
}
impl MemberFrameworkAttributes {
    /// Creates a new builder-style object to manufacture [`MemberFrameworkAttributes`](crate::model::MemberFrameworkAttributes)
    pub fn builder() -> crate::model::member_framework_attributes::Builder {
        crate::model::member_framework_attributes::Builder::default()
    }
}

/// <p>Attributes of Hyperledger Fabric for a member in a Managed Blockchain network using the Hyperledger Fabric framework.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberFabricAttributes {
    /// <p>The user name for the initial administrator user for the member.</p>
    pub admin_username: std::option::Option<std::string::String>,
    /// <p>The endpoint used to access the member's certificate authority.</p>
    pub ca_endpoint: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MemberFabricAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberFabricAttributes");
        formatter.field("admin_username", &self.admin_username);
        formatter.field("ca_endpoint", &self.ca_endpoint);
        formatter.finish()
    }
}
/// See [`MemberFabricAttributes`](crate::model::MemberFabricAttributes)
pub mod member_fabric_attributes {
    /// A builder for [`MemberFabricAttributes`](crate::model::MemberFabricAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_username: std::option::Option<std::string::String>,
        pub(crate) ca_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name for the initial administrator user for the member.</p>
        pub fn admin_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_username = Some(input.into());
            self
        }
        /// <p>The user name for the initial administrator user for the member.</p>
        pub fn set_admin_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_username = input;
            self
        }
        /// <p>The endpoint used to access the member's certificate authority.</p>
        pub fn ca_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.ca_endpoint = Some(input.into());
            self
        }
        /// <p>The endpoint used to access the member's certificate authority.</p>
        pub fn set_ca_endpoint(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ca_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberFabricAttributes`](crate::model::MemberFabricAttributes)
        pub fn build(self) -> crate::model::MemberFabricAttributes {
            crate::model::MemberFabricAttributes {
                admin_username: self.admin_username,
                ca_endpoint: self.ca_endpoint,
            }
        }
    }
}
impl MemberFabricAttributes {
    /// Creates a new builder-style object to manufacture [`MemberFabricAttributes`](crate::model::MemberFabricAttributes)
    pub fn builder() -> crate::model::member_fabric_attributes::Builder {
        crate::model::member_fabric_attributes::Builder::default()
    }
}

/// <p>Configuration properties of a node.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NodeConfiguration {
    /// <p>The Amazon Managed Blockchain instance type for the node.</p>
    pub instance_type: std::option::Option<std::string::String>,
    /// <p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>
    pub availability_zone: std::option::Option<std::string::String>,
    /// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.      
    /// </p>
    pub log_publishing_configuration:
        std::option::Option<crate::model::NodeLogPublishingConfiguration>,
    /// <p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is <code>CouchDB</code>.</p>
    /// <p>Applies only to Hyperledger Fabric.</p>
    pub state_db: std::option::Option<crate::model::StateDbType>,
}
impl std::fmt::Debug for NodeConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NodeConfiguration");
        formatter.field("instance_type", &self.instance_type);
        formatter.field("availability_zone", &self.availability_zone);
        formatter.field(
            "log_publishing_configuration",
            &self.log_publishing_configuration,
        );
        formatter.field("state_db", &self.state_db);
        formatter.finish()
    }
}
/// See [`NodeConfiguration`](crate::model::NodeConfiguration)
pub mod node_configuration {
    /// A builder for [`NodeConfiguration`](crate::model::NodeConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) instance_type: std::option::Option<std::string::String>,
        pub(crate) availability_zone: std::option::Option<std::string::String>,
        pub(crate) log_publishing_configuration:
            std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        pub(crate) state_db: std::option::Option<crate::model::StateDbType>,
    }
    impl Builder {
        /// <p>The Amazon Managed Blockchain instance type for the node.</p>
        pub fn instance_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.instance_type = Some(input.into());
            self
        }
        /// <p>The Amazon Managed Blockchain instance type for the node.</p>
        pub fn set_instance_type(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.instance_type = input;
            self
        }
        /// <p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>
        pub fn availability_zone(mut self, input: impl Into<std::string::String>) -> Self {
            self.availability_zone = Some(input.into());
            self
        }
        /// <p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>
        pub fn set_availability_zone(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.availability_zone = input;
            self
        }
        /// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.      
        /// </p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::NodeLogPublishingConfiguration,
        ) -> Self {
            self.log_publishing_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.      
        /// </p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::NodeLogPublishingConfiguration>,
        ) -> Self {
            self.log_publishing_configuration = input;
            self
        }
        /// <p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is <code>CouchDB</code>.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn state_db(mut self, input: crate::model::StateDbType) -> Self {
            self.state_db = Some(input);
            self
        }
        /// <p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is <code>CouchDB</code>.</p>
        /// <p>Applies only to Hyperledger Fabric.</p>
        pub fn set_state_db(
            mut self,
            input: std::option::Option<crate::model::StateDbType>,
        ) -> Self {
            self.state_db = input;
            self
        }
        /// Consumes the builder and constructs a [`NodeConfiguration`](crate::model::NodeConfiguration)
        pub fn build(self) -> crate::model::NodeConfiguration {
            crate::model::NodeConfiguration {
                instance_type: self.instance_type,
                availability_zone: self.availability_zone,
                log_publishing_configuration: self.log_publishing_configuration,
                state_db: self.state_db,
            }
        }
    }
}
impl NodeConfiguration {
    /// Creates a new builder-style object to manufacture [`NodeConfiguration`](crate::model::NodeConfiguration)
    pub fn builder() -> crate::model::node_configuration::Builder {
        crate::model::node_configuration::Builder::default()
    }
}

/// <p>Configuration properties of the member.</p>
/// <p>Applies only to Hyperledger Fabric.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberConfiguration {
    /// <p>The name of the member.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>An optional description of the member.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>Configuration properties of the blockchain framework relevant to the member.</p>
    pub framework_configuration: std::option::Option<crate::model::MemberFrameworkConfiguration>,
    /// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network.</p>
    pub log_publishing_configuration:
        std::option::Option<crate::model::MemberLogPublishingConfiguration>,
    /// <p>Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
    /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to use for encryption at rest in the member. This parameter is inherited by any nodes that this member creates.</p>
    /// <p>Use one of the following options to specify this parameter:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.</p>
    /// <p>Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
    /// <p>The following is an example of a KMS key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
    /// </p>
    /// </li>
    /// </ul>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MemberConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberConfiguration");
        formatter.field("name", &self.name);
        formatter.field("description", &self.description);
        formatter.field("framework_configuration", &self.framework_configuration);
        formatter.field(
            "log_publishing_configuration",
            &self.log_publishing_configuration,
        );
        formatter.field("tags", &self.tags);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`MemberConfiguration`](crate::model::MemberConfiguration)
pub mod member_configuration {
    /// A builder for [`MemberConfiguration`](crate::model::MemberConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) framework_configuration:
            std::option::Option<crate::model::MemberFrameworkConfiguration>,
        pub(crate) log_publishing_configuration:
            std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the member.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the member.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>An optional description of the member.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>An optional description of the member.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>Configuration properties of the blockchain framework relevant to the member.</p>
        pub fn framework_configuration(
            mut self,
            input: crate::model::MemberFrameworkConfiguration,
        ) -> Self {
            self.framework_configuration = Some(input);
            self
        }
        /// <p>Configuration properties of the blockchain framework relevant to the member.</p>
        pub fn set_framework_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberFrameworkConfiguration>,
        ) -> Self {
            self.framework_configuration = input;
            self
        }
        /// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network.</p>
        pub fn log_publishing_configuration(
            mut self,
            input: crate::model::MemberLogPublishingConfiguration,
        ) -> Self {
            self.log_publishing_configuration = Some(input);
            self
        }
        /// <p>Configuration properties for logging events associated with a member of a Managed Blockchain network.</p>
        pub fn set_log_publishing_configuration(
            mut self,
            input: std::option::Option<crate::model::MemberLogPublishingConfiguration>,
        ) -> Self {
            self.log_publishing_configuration = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
        /// <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to use for encryption at rest in the member. This parameter is inherited by any nodes that this member creates.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.</p>
        /// <p>Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
        /// <p>The following is an example of a KMS key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to use for encryption at rest in the member. This parameter is inherited by any nodes that this member creates.</p>
        /// <p>Use one of the following options to specify this parameter:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.</p>
        /// <p>Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.</p>
        /// <p>The following is an example of a KMS key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberConfiguration`](crate::model::MemberConfiguration)
        pub fn build(self) -> crate::model::MemberConfiguration {
            crate::model::MemberConfiguration {
                name: self.name,
                description: self.description,
                framework_configuration: self.framework_configuration,
                log_publishing_configuration: self.log_publishing_configuration,
                tags: self.tags,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl MemberConfiguration {
    /// Creates a new builder-style object to manufacture [`MemberConfiguration`](crate::model::MemberConfiguration)
    pub fn builder() -> crate::model::member_configuration::Builder {
        crate::model::member_configuration::Builder::default()
    }
}

/// <p>Configuration properties relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberFrameworkConfiguration {
    /// <p>Attributes of Hyperledger Fabric for a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>
    pub fabric: std::option::Option<crate::model::MemberFabricConfiguration>,
}
impl std::fmt::Debug for MemberFrameworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberFrameworkConfiguration");
        formatter.field("fabric", &self.fabric);
        formatter.finish()
    }
}
/// See [`MemberFrameworkConfiguration`](crate::model::MemberFrameworkConfiguration)
pub mod member_framework_configuration {
    /// A builder for [`MemberFrameworkConfiguration`](crate::model::MemberFrameworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric: std::option::Option<crate::model::MemberFabricConfiguration>,
    }
    impl Builder {
        /// <p>Attributes of Hyperledger Fabric for a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn fabric(mut self, input: crate::model::MemberFabricConfiguration) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>Attributes of Hyperledger Fabric for a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::MemberFabricConfiguration>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberFrameworkConfiguration`](crate::model::MemberFrameworkConfiguration)
        pub fn build(self) -> crate::model::MemberFrameworkConfiguration {
            crate::model::MemberFrameworkConfiguration {
                fabric: self.fabric,
            }
        }
    }
}
impl MemberFrameworkConfiguration {
    /// Creates a new builder-style object to manufacture [`MemberFrameworkConfiguration`](crate::model::MemberFrameworkConfiguration)
    pub fn builder() -> crate::model::member_framework_configuration::Builder {
        crate::model::member_framework_configuration::Builder::default()
    }
}

/// <p>Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network using the Hyperledger Fabric framework.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberFabricConfiguration {
    /// <p>The user name for the member's initial administrative user.</p>
    pub admin_username: std::option::Option<std::string::String>,
    /// <p>The password for the member's initial administrative user. The <code>AdminPassword</code> must be at least eight characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(\), @, or a space.</p>
    pub admin_password: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for MemberFabricConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberFabricConfiguration");
        formatter.field("admin_username", &self.admin_username);
        formatter.field("admin_password", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
/// See [`MemberFabricConfiguration`](crate::model::MemberFabricConfiguration)
pub mod member_fabric_configuration {
    /// A builder for [`MemberFabricConfiguration`](crate::model::MemberFabricConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_username: std::option::Option<std::string::String>,
        pub(crate) admin_password: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user name for the member's initial administrative user.</p>
        pub fn admin_username(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_username = Some(input.into());
            self
        }
        /// <p>The user name for the member's initial administrative user.</p>
        pub fn set_admin_username(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_username = input;
            self
        }
        /// <p>The password for the member's initial administrative user. The <code>AdminPassword</code> must be at least eight characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(\), @, or a space.</p>
        pub fn admin_password(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_password = Some(input.into());
            self
        }
        /// <p>The password for the member's initial administrative user. The <code>AdminPassword</code> must be at least eight characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(\), @, or a space.</p>
        pub fn set_admin_password(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_password = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberFabricConfiguration`](crate::model::MemberFabricConfiguration)
        pub fn build(self) -> crate::model::MemberFabricConfiguration {
            crate::model::MemberFabricConfiguration {
                admin_username: self.admin_username,
                admin_password: self.admin_password,
            }
        }
    }
}
impl MemberFabricConfiguration {
    /// Creates a new builder-style object to manufacture [`MemberFabricConfiguration`](crate::model::MemberFabricConfiguration)
    pub fn builder() -> crate::model::member_fabric_configuration::Builder {
        crate::model::member_fabric_configuration::Builder::default()
    }
}

/// <p>
/// Configuration properties relevant to the network for the blockchain framework that the network uses.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFrameworkConfiguration {
    /// <p>
    /// Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric.
    /// </p>
    pub fabric: std::option::Option<crate::model::NetworkFabricConfiguration>,
}
impl std::fmt::Debug for NetworkFrameworkConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFrameworkConfiguration");
        formatter.field("fabric", &self.fabric);
        formatter.finish()
    }
}
/// See [`NetworkFrameworkConfiguration`](crate::model::NetworkFrameworkConfiguration)
pub mod network_framework_configuration {
    /// A builder for [`NetworkFrameworkConfiguration`](crate::model::NetworkFrameworkConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) fabric: std::option::Option<crate::model::NetworkFabricConfiguration>,
    }
    impl Builder {
        /// <p>
        /// Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric.
        /// </p>
        pub fn fabric(mut self, input: crate::model::NetworkFabricConfiguration) -> Self {
            self.fabric = Some(input);
            self
        }
        /// <p>
        /// Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric.
        /// </p>
        pub fn set_fabric(
            mut self,
            input: std::option::Option<crate::model::NetworkFabricConfiguration>,
        ) -> Self {
            self.fabric = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFrameworkConfiguration`](crate::model::NetworkFrameworkConfiguration)
        pub fn build(self) -> crate::model::NetworkFrameworkConfiguration {
            crate::model::NetworkFrameworkConfiguration {
                fabric: self.fabric,
            }
        }
    }
}
impl NetworkFrameworkConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkFrameworkConfiguration`](crate::model::NetworkFrameworkConfiguration)
    pub fn builder() -> crate::model::network_framework_configuration::Builder {
        crate::model::network_framework_configuration::Builder::default()
    }
}

/// <p>Hyperledger Fabric configuration properties for the network.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct NetworkFabricConfiguration {
    /// <p>The edition of Amazon Managed Blockchain that the network uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>
    pub edition: std::option::Option<crate::model::Edition>,
}
impl std::fmt::Debug for NetworkFabricConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("NetworkFabricConfiguration");
        formatter.field("edition", &self.edition);
        formatter.finish()
    }
}
/// See [`NetworkFabricConfiguration`](crate::model::NetworkFabricConfiguration)
pub mod network_fabric_configuration {
    /// A builder for [`NetworkFabricConfiguration`](crate::model::NetworkFabricConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) edition: std::option::Option<crate::model::Edition>,
    }
    impl Builder {
        /// <p>The edition of Amazon Managed Blockchain that the network uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>
        pub fn edition(mut self, input: crate::model::Edition) -> Self {
            self.edition = Some(input);
            self
        }
        /// <p>The edition of Amazon Managed Blockchain that the network uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>
        pub fn set_edition(mut self, input: std::option::Option<crate::model::Edition>) -> Self {
            self.edition = input;
            self
        }
        /// Consumes the builder and constructs a [`NetworkFabricConfiguration`](crate::model::NetworkFabricConfiguration)
        pub fn build(self) -> crate::model::NetworkFabricConfiguration {
            crate::model::NetworkFabricConfiguration {
                edition: self.edition,
            }
        }
    }
}
impl NetworkFabricConfiguration {
    /// Creates a new builder-style object to manufacture [`NetworkFabricConfiguration`](crate::model::NetworkFabricConfiguration)
    pub fn builder() -> crate::model::network_fabric_configuration::Builder {
        crate::model::network_fabric_configuration::Builder::default()
    }
}
