// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>The status of an Amazon Macie account. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum MacieStatus {
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for MacieStatus {
    fn from(s: &str) -> Self {
        match s {
            "ENABLED" => MacieStatus::Enabled,
            "PAUSED" => MacieStatus::Paused,
            other => MacieStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for MacieStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(MacieStatus::from(s))
    }
}
impl MacieStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            MacieStatus::Enabled => "ENABLED",
            MacieStatus::Paused => "PAUSED",
            MacieStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ENABLED", "PAUSED"]
    }
}
impl AsRef<str> for MacieStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The frequency with which Amazon Macie publishes updates to policy findings for an account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events). For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-monitor.html">Monitoring and processing findings</a> in the <i>Amazon Macie User Guide</i>. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingPublishingFrequency {
    #[allow(missing_docs)] // documentation missing in model
    FifteenMinutes,
    #[allow(missing_docs)] // documentation missing in model
    OneHour,
    #[allow(missing_docs)] // documentation missing in model
    SixHours,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingPublishingFrequency {
    fn from(s: &str) -> Self {
        match s {
            "FIFTEEN_MINUTES" => FindingPublishingFrequency::FifteenMinutes,
            "ONE_HOUR" => FindingPublishingFrequency::OneHour,
            "SIX_HOURS" => FindingPublishingFrequency::SixHours,
            other => FindingPublishingFrequency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingPublishingFrequency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingPublishingFrequency::from(s))
    }
}
impl FindingPublishingFrequency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingPublishingFrequency::FifteenMinutes => "FIFTEEN_MINUTES",
            FindingPublishingFrequency::OneHour => "ONE_HOUR",
            FindingPublishingFrequency::SixHours => "SIX_HOURS",
            FindingPublishingFrequency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FIFTEEN_MINUTES", "ONE_HOUR", "SIX_HOURS"]
    }
}
impl AsRef<str> for FindingPublishingFrequency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies, as a map, one or more property-based conditions that filter the results of a query for findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingCriteria {
    /// <p>A condition that specifies the property, operator, and one or more values to use to filter the results.</p>
    pub criterion: std::option::Option<
        std::collections::HashMap<std::string::String, crate::model::CriterionAdditionalProperties>,
    >,
}
impl FindingCriteria {
    /// <p>A condition that specifies the property, operator, and one or more values to use to filter the results.</p>
    pub fn criterion(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::CriterionAdditionalProperties,
        >,
    > {
        self.criterion.as_ref()
    }
}
impl std::fmt::Debug for FindingCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingCriteria");
        formatter.field("criterion", &self.criterion);
        formatter.finish()
    }
}
/// See [`FindingCriteria`](crate::model::FindingCriteria)
pub mod finding_criteria {
    /// A builder for [`FindingCriteria`](crate::model::FindingCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) criterion: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::CriterionAdditionalProperties,
            >,
        >,
    }
    impl Builder {
        /// Adds a key-value pair to `criterion`.
        ///
        /// To override the contents of this collection use [`set_criterion`](Self::set_criterion).
        ///
        /// <p>A condition that specifies the property, operator, and one or more values to use to filter the results.</p>
        pub fn criterion(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::CriterionAdditionalProperties,
        ) -> Self {
            let mut hash_map = self.criterion.unwrap_or_default();
            hash_map.insert(k.into(), v);
            self.criterion = Some(hash_map);
            self
        }
        /// <p>A condition that specifies the property, operator, and one or more values to use to filter the results.</p>
        pub fn set_criterion(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::CriterionAdditionalProperties,
                >,
            >,
        ) -> Self {
            self.criterion = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingCriteria`](crate::model::FindingCriteria)
        pub fn build(self) -> crate::model::FindingCriteria {
            crate::model::FindingCriteria {
                criterion: self.criterion,
            }
        }
    }
}
impl FindingCriteria {
    /// Creates a new builder-style object to manufacture [`FindingCriteria`](crate::model::FindingCriteria)
    pub fn builder() -> crate::model::finding_criteria::Builder {
        crate::model::finding_criteria::Builder::default()
    }
}

/// <p>Specifies the operator to use in a property-based condition that filters the results of a query for findings. For detailed information and examples of each operator, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html">Fundamentals of filtering findings</a> in the <i>Amazon Macie User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CriterionAdditionalProperties {
    /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
    pub eq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
    /// <p>You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.</p>
    pub eq_exact_match: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The value for the property is greater than the specified value.</p>
    pub gt: i64,
    /// <p>The value for the property is greater than or equal to the specified value.</p>
    pub gte: i64,
    /// <p>The value for the property is less than the specified value.</p>
    pub lt: i64,
    /// <p>The value for the property is less than or equal to the specified value.</p>
    pub lte: i64,
    /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
    pub neq: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl CriterionAdditionalProperties {
    /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
    pub fn eq(&self) -> std::option::Option<&[std::string::String]> {
        self.eq.as_deref()
    }
    /// <p>The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
    /// <p>You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.</p>
    pub fn eq_exact_match(&self) -> std::option::Option<&[std::string::String]> {
        self.eq_exact_match.as_deref()
    }
    /// <p>The value for the property is greater than the specified value.</p>
    pub fn gt(&self) -> i64 {
        self.gt
    }
    /// <p>The value for the property is greater than or equal to the specified value.</p>
    pub fn gte(&self) -> i64 {
        self.gte
    }
    /// <p>The value for the property is less than the specified value.</p>
    pub fn lt(&self) -> i64 {
        self.lt
    }
    /// <p>The value for the property is less than or equal to the specified value.</p>
    pub fn lte(&self) -> i64 {
        self.lte
    }
    /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
    pub fn neq(&self) -> std::option::Option<&[std::string::String]> {
        self.neq.as_deref()
    }
}
impl std::fmt::Debug for CriterionAdditionalProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CriterionAdditionalProperties");
        formatter.field("eq", &self.eq);
        formatter.field("eq_exact_match", &self.eq_exact_match);
        formatter.field("gt", &self.gt);
        formatter.field("gte", &self.gte);
        formatter.field("lt", &self.lt);
        formatter.field("lte", &self.lte);
        formatter.field("neq", &self.neq);
        formatter.finish()
    }
}
/// See [`CriterionAdditionalProperties`](crate::model::CriterionAdditionalProperties)
pub mod criterion_additional_properties {
    /// A builder for [`CriterionAdditionalProperties`](crate::model::CriterionAdditionalProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) eq_exact_match: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) gt: std::option::Option<i64>,
        pub(crate) gte: std::option::Option<i64>,
        pub(crate) lt: std::option::Option<i64>,
        pub(crate) lte: std::option::Option<i64>,
        pub(crate) neq: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `eq`.
        ///
        /// To override the contents of this collection use [`set_eq`](Self::set_eq).
        ///
        /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eq.unwrap_or_default();
            v.push(input.into());
            self.eq = Some(v);
            self
        }
        /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
        pub fn set_eq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eq = input;
            self
        }
        /// Appends an item to `eq_exact_match`.
        ///
        /// To override the contents of this collection use [`set_eq_exact_match`](Self::set_eq_exact_match).
        ///
        /// <p>The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
        /// <p>You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.</p>
        pub fn eq_exact_match(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eq_exact_match.unwrap_or_default();
            v.push(input.into());
            self.eq_exact_match = Some(v);
            self
        }
        /// <p>The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
        /// <p>You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.</p>
        pub fn set_eq_exact_match(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eq_exact_match = input;
            self
        }
        /// <p>The value for the property is greater than the specified value.</p>
        pub fn gt(mut self, input: i64) -> Self {
            self.gt = Some(input);
            self
        }
        /// <p>The value for the property is greater than the specified value.</p>
        pub fn set_gt(mut self, input: std::option::Option<i64>) -> Self {
            self.gt = input;
            self
        }
        /// <p>The value for the property is greater than or equal to the specified value.</p>
        pub fn gte(mut self, input: i64) -> Self {
            self.gte = Some(input);
            self
        }
        /// <p>The value for the property is greater than or equal to the specified value.</p>
        pub fn set_gte(mut self, input: std::option::Option<i64>) -> Self {
            self.gte = input;
            self
        }
        /// <p>The value for the property is less than the specified value.</p>
        pub fn lt(mut self, input: i64) -> Self {
            self.lt = Some(input);
            self
        }
        /// <p>The value for the property is less than the specified value.</p>
        pub fn set_lt(mut self, input: std::option::Option<i64>) -> Self {
            self.lt = input;
            self
        }
        /// <p>The value for the property is less than or equal to the specified value.</p>
        pub fn lte(mut self, input: i64) -> Self {
            self.lte = Some(input);
            self
        }
        /// <p>The value for the property is less than or equal to the specified value.</p>
        pub fn set_lte(mut self, input: std::option::Option<i64>) -> Self {
            self.lte = input;
            self
        }
        /// Appends an item to `neq`.
        ///
        /// To override the contents of this collection use [`set_neq`](Self::set_neq).
        ///
        /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
        pub fn neq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.neq.unwrap_or_default();
            v.push(input.into());
            self.neq = Some(v);
            self
        }
        /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.</p>
        pub fn set_neq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.neq = input;
            self
        }
        /// Consumes the builder and constructs a [`CriterionAdditionalProperties`](crate::model::CriterionAdditionalProperties)
        pub fn build(self) -> crate::model::CriterionAdditionalProperties {
            crate::model::CriterionAdditionalProperties {
                eq: self.eq,
                eq_exact_match: self.eq_exact_match,
                gt: self.gt.unwrap_or_default(),
                gte: self.gte.unwrap_or_default(),
                lt: self.lt.unwrap_or_default(),
                lte: self.lte.unwrap_or_default(),
                neq: self.neq,
            }
        }
    }
}
impl CriterionAdditionalProperties {
    /// Creates a new builder-style object to manufacture [`CriterionAdditionalProperties`](crate::model::CriterionAdditionalProperties)
    pub fn builder() -> crate::model::criterion_additional_properties::Builder {
        crate::model::criterion_additional_properties::Builder::default()
    }
}

/// <p>The action to perform on findings that meet the filter criteria. To suppress (automatically archive) findings that meet the criteria, set this value to ARCHIVE. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingsFilterAction {
    #[allow(missing_docs)] // documentation missing in model
    Archive,
    #[allow(missing_docs)] // documentation missing in model
    Noop,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingsFilterAction {
    fn from(s: &str) -> Self {
        match s {
            "ARCHIVE" => FindingsFilterAction::Archive,
            "NOOP" => FindingsFilterAction::Noop,
            other => FindingsFilterAction::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingsFilterAction {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingsFilterAction::from(s))
    }
}
impl FindingsFilterAction {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingsFilterAction::Archive => "ARCHIVE",
            FindingsFilterAction::Noop => "NOOP",
            FindingsFilterAction::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ARCHIVE", "NOOP"]
    }
}
impl AsRef<str> for FindingsFilterAction {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The status of a classification job. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobStatus {
    #[allow(missing_docs)] // documentation missing in model
    Cancelled,
    #[allow(missing_docs)] // documentation missing in model
    Complete,
    #[allow(missing_docs)] // documentation missing in model
    Idle,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    Running,
    #[allow(missing_docs)] // documentation missing in model
    UserPaused,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobStatus {
    fn from(s: &str) -> Self {
        match s {
            "CANCELLED" => JobStatus::Cancelled,
            "COMPLETE" => JobStatus::Complete,
            "IDLE" => JobStatus::Idle,
            "PAUSED" => JobStatus::Paused,
            "RUNNING" => JobStatus::Running,
            "USER_PAUSED" => JobStatus::UserPaused,
            other => JobStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobStatus::from(s))
    }
}
impl JobStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobStatus::Cancelled => "CANCELLED",
            JobStatus::Complete => "COMPLETE",
            JobStatus::Idle => "IDLE",
            JobStatus::Paused => "PAUSED",
            JobStatus::Running => "RUNNING",
            JobStatus::UserPaused => "USER_PAUSED",
            JobStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CANCELLED",
            "COMPLETE",
            "IDLE",
            "PAUSED",
            "RUNNING",
            "USER_PAUSED",
        ]
    }
}
impl AsRef<str> for JobStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides statistical data and other information about an Amazon Web Services resource that Amazon Macie monitors and analyzes for your account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchingResource {
    /// <p>The details of an S3 bucket that Amazon Macie monitors and analyzes.</p>
    pub matching_bucket: std::option::Option<crate::model::MatchingBucket>,
}
impl MatchingResource {
    /// <p>The details of an S3 bucket that Amazon Macie monitors and analyzes.</p>
    pub fn matching_bucket(&self) -> std::option::Option<&crate::model::MatchingBucket> {
        self.matching_bucket.as_ref()
    }
}
impl std::fmt::Debug for MatchingResource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchingResource");
        formatter.field("matching_bucket", &self.matching_bucket);
        formatter.finish()
    }
}
/// See [`MatchingResource`](crate::model::MatchingResource)
pub mod matching_resource {
    /// A builder for [`MatchingResource`](crate::model::MatchingResource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) matching_bucket: std::option::Option<crate::model::MatchingBucket>,
    }
    impl Builder {
        /// <p>The details of an S3 bucket that Amazon Macie monitors and analyzes.</p>
        pub fn matching_bucket(mut self, input: crate::model::MatchingBucket) -> Self {
            self.matching_bucket = Some(input);
            self
        }
        /// <p>The details of an S3 bucket that Amazon Macie monitors and analyzes.</p>
        pub fn set_matching_bucket(
            mut self,
            input: std::option::Option<crate::model::MatchingBucket>,
        ) -> Self {
            self.matching_bucket = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchingResource`](crate::model::MatchingResource)
        pub fn build(self) -> crate::model::MatchingResource {
            crate::model::MatchingResource {
                matching_bucket: self.matching_bucket,
            }
        }
    }
}
impl MatchingResource {
    /// Creates a new builder-style object to manufacture [`MatchingResource`](crate::model::MatchingResource)
    pub fn builder() -> crate::model::matching_resource::Builder {
        crate::model::matching_resource::Builder::default()
    }
}

/// <p>Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes for your account. If an error occurs when Macie attempts to retrieve and process information about the bucket or the bucket's objects, the value for most of these properties is null. Exceptions are accountId and bucketName. To identify the cause of the error, refer to the errorCode and errorMessage values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MatchingBucket {
    /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The name of the bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    pub classifiable_object_count: i64,
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub classifiable_size_in_bytes: i64,
    /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
    pub error_code: std::option::Option<crate::model::BucketMetadataErrorCode>,
    /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.</p>
    pub job_details: std::option::Option<crate::model::JobDetails>,
    /// <p>The total number of objects in the bucket.</p>
    pub object_count: i64,
    /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
    pub object_count_by_encryption_type:
        std::option::Option<crate::model::ObjectCountByEncryptionType>,
    /// <p>The total storage size, in bytes, of the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
    pub size_in_bytes: i64,
    /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub size_in_bytes_compressed: i64,
    /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub unclassifiable_object_count: std::option::Option<crate::model::ObjectLevelStatistics>,
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub unclassifiable_object_size_in_bytes:
        std::option::Option<crate::model::ObjectLevelStatistics>,
}
impl MatchingBucket {
    /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The name of the bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    pub fn classifiable_object_count(&self) -> i64 {
        self.classifiable_object_count
    }
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub fn classifiable_size_in_bytes(&self) -> i64 {
        self.classifiable_size_in_bytes
    }
    /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::BucketMetadataErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.</p>
    pub fn job_details(&self) -> std::option::Option<&crate::model::JobDetails> {
        self.job_details.as_ref()
    }
    /// <p>The total number of objects in the bucket.</p>
    pub fn object_count(&self) -> i64 {
        self.object_count
    }
    /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
    pub fn object_count_by_encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::ObjectCountByEncryptionType> {
        self.object_count_by_encryption_type.as_ref()
    }
    /// <p>The total storage size, in bytes, of the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
    pub fn size_in_bytes(&self) -> i64 {
        self.size_in_bytes
    }
    /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub fn size_in_bytes_compressed(&self) -> i64 {
        self.size_in_bytes_compressed
    }
    /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub fn unclassifiable_object_count(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLevelStatistics> {
        self.unclassifiable_object_count.as_ref()
    }
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub fn unclassifiable_object_size_in_bytes(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLevelStatistics> {
        self.unclassifiable_object_size_in_bytes.as_ref()
    }
}
impl std::fmt::Debug for MatchingBucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MatchingBucket");
        formatter.field("account_id", &self.account_id);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("classifiable_object_count", &self.classifiable_object_count);
        formatter.field(
            "classifiable_size_in_bytes",
            &self.classifiable_size_in_bytes,
        );
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("job_details", &self.job_details);
        formatter.field("object_count", &self.object_count);
        formatter.field(
            "object_count_by_encryption_type",
            &self.object_count_by_encryption_type,
        );
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.field("size_in_bytes_compressed", &self.size_in_bytes_compressed);
        formatter.field(
            "unclassifiable_object_count",
            &self.unclassifiable_object_count,
        );
        formatter.field(
            "unclassifiable_object_size_in_bytes",
            &self.unclassifiable_object_size_in_bytes,
        );
        formatter.finish()
    }
}
/// See [`MatchingBucket`](crate::model::MatchingBucket)
pub mod matching_bucket {
    /// A builder for [`MatchingBucket`](crate::model::MatchingBucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) classifiable_object_count: std::option::Option<i64>,
        pub(crate) classifiable_size_in_bytes: std::option::Option<i64>,
        pub(crate) error_code: std::option::Option<crate::model::BucketMetadataErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) job_details: std::option::Option<crate::model::JobDetails>,
        pub(crate) object_count: std::option::Option<i64>,
        pub(crate) object_count_by_encryption_type:
            std::option::Option<crate::model::ObjectCountByEncryptionType>,
        pub(crate) size_in_bytes: std::option::Option<i64>,
        pub(crate) size_in_bytes_compressed: std::option::Option<i64>,
        pub(crate) unclassifiable_object_count:
            std::option::Option<crate::model::ObjectLevelStatistics>,
        pub(crate) unclassifiable_object_size_in_bytes:
            std::option::Option<crate::model::ObjectLevelStatistics>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        pub fn classifiable_object_count(mut self, input: i64) -> Self {
            self.classifiable_object_count = Some(input);
            self
        }
        /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        pub fn set_classifiable_object_count(mut self, input: std::option::Option<i64>) -> Self {
            self.classifiable_object_count = input;
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn classifiable_size_in_bytes(mut self, input: i64) -> Self {
            self.classifiable_size_in_bytes = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn set_classifiable_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.classifiable_size_in_bytes = input;
            self
        }
        /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
        pub fn error_code(mut self, input: crate::model::BucketMetadataErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::BucketMetadataErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.</p>
        pub fn job_details(mut self, input: crate::model::JobDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze objects in the bucket, and, if so, the details of the job that ran most recently.</p>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::JobDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// <p>The total number of objects in the bucket.</p>
        pub fn object_count(mut self, input: i64) -> Self {
            self.object_count = Some(input);
            self
        }
        /// <p>The total number of objects in the bucket.</p>
        pub fn set_object_count(mut self, input: std::option::Option<i64>) -> Self {
            self.object_count = input;
            self
        }
        /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
        pub fn object_count_by_encryption_type(
            mut self,
            input: crate::model::ObjectCountByEncryptionType,
        ) -> Self {
            self.object_count_by_encryption_type = Some(input);
            self
        }
        /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
        pub fn set_object_count_by_encryption_type(
            mut self,
            input: std::option::Option<crate::model::ObjectCountByEncryptionType>,
        ) -> Self {
            self.object_count_by_encryption_type = input;
            self
        }
        /// <p>The total storage size, in bytes, of the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
        pub fn size_in_bytes(mut self, input: i64) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
        pub fn set_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn size_in_bytes_compressed(mut self, input: i64) -> Self {
            self.size_in_bytes_compressed = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn set_size_in_bytes_compressed(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes_compressed = input;
            self
        }
        /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn unclassifiable_object_count(
            mut self,
            input: crate::model::ObjectLevelStatistics,
        ) -> Self {
            self.unclassifiable_object_count = Some(input);
            self
        }
        /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn set_unclassifiable_object_count(
            mut self,
            input: std::option::Option<crate::model::ObjectLevelStatistics>,
        ) -> Self {
            self.unclassifiable_object_count = input;
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn unclassifiable_object_size_in_bytes(
            mut self,
            input: crate::model::ObjectLevelStatistics,
        ) -> Self {
            self.unclassifiable_object_size_in_bytes = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn set_unclassifiable_object_size_in_bytes(
            mut self,
            input: std::option::Option<crate::model::ObjectLevelStatistics>,
        ) -> Self {
            self.unclassifiable_object_size_in_bytes = input;
            self
        }
        /// Consumes the builder and constructs a [`MatchingBucket`](crate::model::MatchingBucket)
        pub fn build(self) -> crate::model::MatchingBucket {
            crate::model::MatchingBucket {
                account_id: self.account_id,
                bucket_name: self.bucket_name,
                classifiable_object_count: self.classifiable_object_count.unwrap_or_default(),
                classifiable_size_in_bytes: self.classifiable_size_in_bytes.unwrap_or_default(),
                error_code: self.error_code,
                error_message: self.error_message,
                job_details: self.job_details,
                object_count: self.object_count.unwrap_or_default(),
                object_count_by_encryption_type: self.object_count_by_encryption_type,
                size_in_bytes: self.size_in_bytes.unwrap_or_default(),
                size_in_bytes_compressed: self.size_in_bytes_compressed.unwrap_or_default(),
                unclassifiable_object_count: self.unclassifiable_object_count,
                unclassifiable_object_size_in_bytes: self.unclassifiable_object_size_in_bytes,
            }
        }
    }
}
impl MatchingBucket {
    /// Creates a new builder-style object to manufacture [`MatchingBucket`](crate::model::MatchingBucket)
    pub fn builder() -> crate::model::matching_bucket::Builder {
        crate::model::matching_bucket::Builder::default()
    }
}

/// <p>Provides information about the total storage size (in bytes) or number of objects that Amazon Macie can't analyze in one or more S3 buckets. In a BucketMetadata or MatchingBucket object, this data is for a specific bucket. In a GetBucketStatisticsResponse object, this data is aggregated for the buckets in the query results. If versioning is enabled for a bucket, total storage size values are based on the size of the latest version of each applicable object in the bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectLevelStatistics {
    /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.</p>
    pub file_type: i64,
    /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.</p>
    pub storage_class: i64,
    /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub total: i64,
}
impl ObjectLevelStatistics {
    /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.</p>
    pub fn file_type(&self) -> i64 {
        self.file_type
    }
    /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.</p>
    pub fn storage_class(&self) -> i64 {
        self.storage_class
    }
    /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub fn total(&self) -> i64 {
        self.total
    }
}
impl std::fmt::Debug for ObjectLevelStatistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectLevelStatistics");
        formatter.field("file_type", &self.file_type);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("total", &self.total);
        formatter.finish()
    }
}
/// See [`ObjectLevelStatistics`](crate::model::ObjectLevelStatistics)
pub mod object_level_statistics {
    /// A builder for [`ObjectLevelStatistics`](crate::model::ObjectLevelStatistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) file_type: std::option::Option<i64>,
        pub(crate) storage_class: std::option::Option<i64>,
        pub(crate) total: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.</p>
        pub fn file_type(mut self, input: i64) -> Self {
            self.file_type = Some(input);
            self
        }
        /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects don't have a file name extension for a supported file or storage format.</p>
        pub fn set_file_type(mut self, input: std::option::Option<i64>) -> Self {
            self.file_type = input;
            self
        }
        /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.</p>
        pub fn storage_class(mut self, input: i64) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class.</p>
        pub fn set_storage_class(mut self, input: std::option::Option<i64>) -> Self {
            self.storage_class = input;
            self
        }
        /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn total(mut self, input: i64) -> Self {
            self.total = Some(input);
            self
        }
        /// <p>The total storage size (in bytes) or number of objects that Amazon Macie can't analyze because the objects use an unsupported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn set_total(mut self, input: std::option::Option<i64>) -> Self {
            self.total = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectLevelStatistics`](crate::model::ObjectLevelStatistics)
        pub fn build(self) -> crate::model::ObjectLevelStatistics {
            crate::model::ObjectLevelStatistics {
                file_type: self.file_type.unwrap_or_default(),
                storage_class: self.storage_class.unwrap_or_default(),
                total: self.total.unwrap_or_default(),
            }
        }
    }
}
impl ObjectLevelStatistics {
    /// Creates a new builder-style object to manufacture [`ObjectLevelStatistics`](crate::model::ObjectLevelStatistics)
    pub fn builder() -> crate::model::object_level_statistics::Builder {
        crate::model::object_level_statistics::Builder::default()
    }
}

/// <p>Provides information about the number of objects that are in an S3 bucket and use certain types of server-side encryption, use client-side encryption, or aren't encrypted.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ObjectCountByEncryptionType {
    /// <p>The total number of objects that are encrypted with a customer-provided key. The objects use customer-provided server-side encryption (SSE-C).</p>
    pub customer_managed: i64,
    /// <p>The total number of objects that are encrypted with an KMS key, either an Amazon Web Services managed key or a customer managed key. The objects use KMS encryption (SSE-KMS).</p>
    pub kms_managed: i64,
    /// <p>The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).</p>
    pub s3_managed: i64,
    /// <p>The total number of objects that aren't encrypted or use client-side encryption.</p>
    pub unencrypted: i64,
    /// <p>The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.</p>
    pub unknown: i64,
}
impl ObjectCountByEncryptionType {
    /// <p>The total number of objects that are encrypted with a customer-provided key. The objects use customer-provided server-side encryption (SSE-C).</p>
    pub fn customer_managed(&self) -> i64 {
        self.customer_managed
    }
    /// <p>The total number of objects that are encrypted with an KMS key, either an Amazon Web Services managed key or a customer managed key. The objects use KMS encryption (SSE-KMS).</p>
    pub fn kms_managed(&self) -> i64 {
        self.kms_managed
    }
    /// <p>The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).</p>
    pub fn s3_managed(&self) -> i64 {
        self.s3_managed
    }
    /// <p>The total number of objects that aren't encrypted or use client-side encryption.</p>
    pub fn unencrypted(&self) -> i64 {
        self.unencrypted
    }
    /// <p>The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.</p>
    pub fn unknown(&self) -> i64 {
        self.unknown
    }
}
impl std::fmt::Debug for ObjectCountByEncryptionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ObjectCountByEncryptionType");
        formatter.field("customer_managed", &self.customer_managed);
        formatter.field("kms_managed", &self.kms_managed);
        formatter.field("s3_managed", &self.s3_managed);
        formatter.field("unencrypted", &self.unencrypted);
        formatter.field("unknown", &self.unknown);
        formatter.finish()
    }
}
/// See [`ObjectCountByEncryptionType`](crate::model::ObjectCountByEncryptionType)
pub mod object_count_by_encryption_type {
    /// A builder for [`ObjectCountByEncryptionType`](crate::model::ObjectCountByEncryptionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) customer_managed: std::option::Option<i64>,
        pub(crate) kms_managed: std::option::Option<i64>,
        pub(crate) s3_managed: std::option::Option<i64>,
        pub(crate) unencrypted: std::option::Option<i64>,
        pub(crate) unknown: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of objects that are encrypted with a customer-provided key. The objects use customer-provided server-side encryption (SSE-C).</p>
        pub fn customer_managed(mut self, input: i64) -> Self {
            self.customer_managed = Some(input);
            self
        }
        /// <p>The total number of objects that are encrypted with a customer-provided key. The objects use customer-provided server-side encryption (SSE-C).</p>
        pub fn set_customer_managed(mut self, input: std::option::Option<i64>) -> Self {
            self.customer_managed = input;
            self
        }
        /// <p>The total number of objects that are encrypted with an KMS key, either an Amazon Web Services managed key or a customer managed key. The objects use KMS encryption (SSE-KMS).</p>
        pub fn kms_managed(mut self, input: i64) -> Self {
            self.kms_managed = Some(input);
            self
        }
        /// <p>The total number of objects that are encrypted with an KMS key, either an Amazon Web Services managed key or a customer managed key. The objects use KMS encryption (SSE-KMS).</p>
        pub fn set_kms_managed(mut self, input: std::option::Option<i64>) -> Self {
            self.kms_managed = input;
            self
        }
        /// <p>The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).</p>
        pub fn s3_managed(mut self, input: i64) -> Self {
            self.s3_managed = Some(input);
            self
        }
        /// <p>The total number of objects that are encrypted with an Amazon S3 managed key. The objects use Amazon S3 managed encryption (SSE-S3).</p>
        pub fn set_s3_managed(mut self, input: std::option::Option<i64>) -> Self {
            self.s3_managed = input;
            self
        }
        /// <p>The total number of objects that aren't encrypted or use client-side encryption.</p>
        pub fn unencrypted(mut self, input: i64) -> Self {
            self.unencrypted = Some(input);
            self
        }
        /// <p>The total number of objects that aren't encrypted or use client-side encryption.</p>
        pub fn set_unencrypted(mut self, input: std::option::Option<i64>) -> Self {
            self.unencrypted = input;
            self
        }
        /// <p>The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.</p>
        pub fn unknown(mut self, input: i64) -> Self {
            self.unknown = Some(input);
            self
        }
        /// <p>The total number of objects that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the encryption settings for these objects.</p>
        pub fn set_unknown(mut self, input: std::option::Option<i64>) -> Self {
            self.unknown = input;
            self
        }
        /// Consumes the builder and constructs a [`ObjectCountByEncryptionType`](crate::model::ObjectCountByEncryptionType)
        pub fn build(self) -> crate::model::ObjectCountByEncryptionType {
            crate::model::ObjectCountByEncryptionType {
                customer_managed: self.customer_managed.unwrap_or_default(),
                kms_managed: self.kms_managed.unwrap_or_default(),
                s3_managed: self.s3_managed.unwrap_or_default(),
                unencrypted: self.unencrypted.unwrap_or_default(),
                unknown: self.unknown.unwrap_or_default(),
            }
        }
    }
}
impl ObjectCountByEncryptionType {
    /// Creates a new builder-style object to manufacture [`ObjectCountByEncryptionType`](crate::model::ObjectCountByEncryptionType)
    pub fn builder() -> crate::model::object_count_by_encryption_type::Builder {
        crate::model::object_count_by_encryption_type::Builder::default()
    }
}

/// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze data in an S3 bucket, and, if so, the details of the job that ran most recently.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobDetails {
    /// <p>Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.</p></li>
    /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.</p></li>
    /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
    /// </ul>
    /// <p></p>
    pub is_defined_in_job: std::option::Option<crate::model::IsDefinedInJob>,
    /// <p>Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.</p></li>
    /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.</p></li>
    /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
    /// </ul>
    pub is_monitored_by_job: std::option::Option<crate::model::IsMonitoredByJob>,
    /// <p>The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job.</p>
    /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
    pub last_job_id: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.</p>
    /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
    pub last_job_run_time: std::option::Option<aws_smithy_types::DateTime>,
}
impl JobDetails {
    /// <p>Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.</p></li>
    /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.</p></li>
    /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
    /// </ul>
    /// <p></p>
    pub fn is_defined_in_job(&self) -> std::option::Option<&crate::model::IsDefinedInJob> {
        self.is_defined_in_job.as_ref()
    }
    /// <p>Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.</p></li>
    /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.</p></li>
    /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
    /// </ul>
    pub fn is_monitored_by_job(&self) -> std::option::Option<&crate::model::IsMonitoredByJob> {
        self.is_monitored_by_job.as_ref()
    }
    /// <p>The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job.</p>
    /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
    pub fn last_job_id(&self) -> std::option::Option<&str> {
        self.last_job_id.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.</p>
    /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
    pub fn last_job_run_time(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_job_run_time.as_ref()
    }
}
impl std::fmt::Debug for JobDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobDetails");
        formatter.field("is_defined_in_job", &self.is_defined_in_job);
        formatter.field("is_monitored_by_job", &self.is_monitored_by_job);
        formatter.field("last_job_id", &self.last_job_id);
        formatter.field("last_job_run_time", &self.last_job_run_time);
        formatter.finish()
    }
}
/// See [`JobDetails`](crate::model::JobDetails)
pub mod job_details {
    /// A builder for [`JobDetails`](crate::model::JobDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_defined_in_job: std::option::Option<crate::model::IsDefinedInJob>,
        pub(crate) is_monitored_by_job: std::option::Option<crate::model::IsMonitoredByJob>,
        pub(crate) last_job_id: std::option::Option<std::string::String>,
        pub(crate) last_job_run_time: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.</p></li>
        /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.</p></li>
        /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
        /// </ul>
        /// <p></p>
        pub fn is_defined_in_job(mut self, input: crate::model::IsDefinedInJob) -> Self {
            self.is_defined_in_job = Some(input);
            self
        }
        /// <p>Specifies whether any one-time or recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more jobs and at least one of those jobs has a status other than CANCELLED. Or the bucket matched the bucket criteria (S3BucketCriteriaForJob) for at least one job that previously ran.</p></li>
        /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any jobs, all the jobs that explicitly include the bucket in their bucket definitions have a status of CANCELLED, or the bucket didn't match the bucket criteria (S3BucketCriteriaForJob) for any jobs that previously ran.</p></li>
        /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
        /// </ul>
        /// <p></p>
        pub fn set_is_defined_in_job(
            mut self,
            input: std::option::Option<crate::model::IsDefinedInJob>,
        ) -> Self {
            self.is_defined_in_job = input;
            self
        }
        /// <p>Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.</p></li>
        /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.</p></li>
        /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
        /// </ul>
        pub fn is_monitored_by_job(mut self, input: crate::model::IsMonitoredByJob) -> Self {
            self.is_monitored_by_job = Some(input);
            self
        }
        /// <p>Specifies whether any recurring jobs are configured to analyze data in the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>TRUE - The bucket is explicitly included in the bucket definition (S3BucketDefinitionForJob) for one or more recurring jobs or the bucket matches the bucket criteria (S3BucketCriteriaForJob) for one or more recurring jobs. At least one of those jobs has a status other than CANCELLED.</p></li>
        /// <li><p>FALSE - The bucket isn't explicitly included in the bucket definition (S3BucketDefinitionForJob) for any recurring jobs, the bucket doesn't match the bucket criteria (S3BucketCriteriaForJob) for any recurring jobs, or all the recurring jobs that are configured to analyze data in the bucket have a status of CANCELLED.</p></li>
        /// <li><p>UNKNOWN - An exception occurred when Amazon Macie attempted to retrieve job data for the bucket.</p></li>
        /// </ul>
        pub fn set_is_monitored_by_job(
            mut self,
            input: std::option::Option<crate::model::IsMonitoredByJob>,
        ) -> Self {
            self.is_monitored_by_job = input;
            self
        }
        /// <p>The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job.</p>
        /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
        pub fn last_job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.last_job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job that ran most recently and is configured to analyze data in the bucket, either the latest run of a recurring job or the only run of a one-time job.</p>
        /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
        pub fn set_last_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.last_job_id = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.</p>
        /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
        pub fn last_job_run_time(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_job_run_time = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the job (lastJobId) started. If the job is a recurring job, this value indicates when the most recent run started.</p>
        /// <p>This value is typically null if the value for the isDefinedInJob property is FALSE or UNKNOWN.</p>
        pub fn set_last_job_run_time(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_job_run_time = input;
            self
        }
        /// Consumes the builder and constructs a [`JobDetails`](crate::model::JobDetails)
        pub fn build(self) -> crate::model::JobDetails {
            crate::model::JobDetails {
                is_defined_in_job: self.is_defined_in_job,
                is_monitored_by_job: self.is_monitored_by_job,
                last_job_id: self.last_job_id,
                last_job_run_time: self.last_job_run_time,
            }
        }
    }
}
impl JobDetails {
    /// Creates a new builder-style object to manufacture [`JobDetails`](crate::model::JobDetails)
    pub fn builder() -> crate::model::job_details::Builder {
        crate::model::job_details::Builder::default()
    }
}

/// _Note: `IsMonitoredByJob::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IsMonitoredByJob {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IsMonitoredByJob {
    fn from(s: &str) -> Self {
        match s {
            "FALSE" => IsMonitoredByJob::False,
            "TRUE" => IsMonitoredByJob::True,
            "UNKNOWN" => IsMonitoredByJob::UnknownValue,
            other => IsMonitoredByJob::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IsMonitoredByJob {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IsMonitoredByJob::from(s))
    }
}
impl IsMonitoredByJob {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IsMonitoredByJob::False => "FALSE",
            IsMonitoredByJob::True => "TRUE",
            IsMonitoredByJob::UnknownValue => "UNKNOWN",
            IsMonitoredByJob::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALSE", "TRUE", "UNKNOWN"]
    }
}
impl AsRef<str> for IsMonitoredByJob {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// _Note: `IsDefinedInJob::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum IsDefinedInJob {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for IsDefinedInJob {
    fn from(s: &str) -> Self {
        match s {
            "FALSE" => IsDefinedInJob::False,
            "TRUE" => IsDefinedInJob::True,
            "UNKNOWN" => IsDefinedInJob::UnknownValue,
            other => IsDefinedInJob::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for IsDefinedInJob {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(IsDefinedInJob::from(s))
    }
}
impl IsDefinedInJob {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            IsDefinedInJob::False => "FALSE",
            IsDefinedInJob::True => "TRUE",
            IsDefinedInJob::UnknownValue => "UNKNOWN",
            IsDefinedInJob::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALSE", "TRUE", "UNKNOWN"]
    }
}
impl AsRef<str> for IsDefinedInJob {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The error code for an error that prevented Amazon Macie from retrieving and processing information about an S3 bucket and the bucket's objects.</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum BucketMetadataErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    AccessDenied,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for BucketMetadataErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ACCESS_DENIED" => BucketMetadataErrorCode::AccessDenied,
            other => BucketMetadataErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for BucketMetadataErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(BucketMetadataErrorCode::from(s))
    }
}
impl BucketMetadataErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            BucketMetadataErrorCode::AccessDenied => "ACCESS_DENIED",
            BucketMetadataErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ACCESS_DENIED"]
    }
}
impl AsRef<str> for BucketMetadataErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies criteria for sorting the results of a query for information about Amazon Web Services resources that Amazon Macie monitors and analyzes.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesSortCriteria {
    /// <p>The property to sort the results by.</p>
    pub attribute_name: std::option::Option<crate::model::SearchResourcesSortAttributeName>,
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl SearchResourcesSortCriteria {
    /// <p>The property to sort the results by.</p>
    pub fn attribute_name(
        &self,
    ) -> std::option::Option<&crate::model::SearchResourcesSortAttributeName> {
        self.attribute_name.as_ref()
    }
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::OrderBy> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for SearchResourcesSortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesSortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`SearchResourcesSortCriteria`](crate::model::SearchResourcesSortCriteria)
pub mod search_resources_sort_criteria {
    /// A builder for [`SearchResourcesSortCriteria`](crate::model::SearchResourcesSortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name:
            std::option::Option<crate::model::SearchResourcesSortAttributeName>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The property to sort the results by.</p>
        pub fn attribute_name(
            mut self,
            input: crate::model::SearchResourcesSortAttributeName,
        ) -> Self {
            self.attribute_name = Some(input);
            self
        }
        /// <p>The property to sort the results by.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesSortAttributeName>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesSortCriteria`](crate::model::SearchResourcesSortCriteria)
        pub fn build(self) -> crate::model::SearchResourcesSortCriteria {
            crate::model::SearchResourcesSortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl SearchResourcesSortCriteria {
    /// Creates a new builder-style object to manufacture [`SearchResourcesSortCriteria`](crate::model::SearchResourcesSortCriteria)
    pub fn builder() -> crate::model::search_resources_sort_criteria::Builder {
        crate::model::search_resources_sort_criteria::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum OrderBy {
    #[allow(missing_docs)] // documentation missing in model
    Asc,
    #[allow(missing_docs)] // documentation missing in model
    Desc,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for OrderBy {
    fn from(s: &str) -> Self {
        match s {
            "ASC" => OrderBy::Asc,
            "DESC" => OrderBy::Desc,
            other => OrderBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for OrderBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(OrderBy::from(s))
    }
}
impl OrderBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            OrderBy::Asc => "ASC",
            OrderBy::Desc => "DESC",
            OrderBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ASC", "DESC"]
    }
}
impl AsRef<str> for OrderBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The property to sort the query results by. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SearchResourcesSortAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    ResourceName,
    #[allow(missing_docs)] // documentation missing in model
    S3ClassifiableObjectCount,
    #[allow(missing_docs)] // documentation missing in model
    S3ClassifiableSizeInBytes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SearchResourcesSortAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => SearchResourcesSortAttributeName::AccountId,
            "RESOURCE_NAME" => SearchResourcesSortAttributeName::ResourceName,
            "S3_CLASSIFIABLE_OBJECT_COUNT" => {
                SearchResourcesSortAttributeName::S3ClassifiableObjectCount
            }
            "S3_CLASSIFIABLE_SIZE_IN_BYTES" => {
                SearchResourcesSortAttributeName::S3ClassifiableSizeInBytes
            }
            other => SearchResourcesSortAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SearchResourcesSortAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SearchResourcesSortAttributeName::from(s))
    }
}
impl SearchResourcesSortAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SearchResourcesSortAttributeName::AccountId => "ACCOUNT_ID",
            SearchResourcesSortAttributeName::ResourceName => "RESOURCE_NAME",
            SearchResourcesSortAttributeName::S3ClassifiableObjectCount => {
                "S3_CLASSIFIABLE_OBJECT_COUNT"
            }
            SearchResourcesSortAttributeName::S3ClassifiableSizeInBytes => {
                "S3_CLASSIFIABLE_SIZE_IN_BYTES"
            }
            SearchResourcesSortAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_ID",
            "RESOURCE_NAME",
            "S3_CLASSIFIABLE_OBJECT_COUNT",
            "S3_CLASSIFIABLE_SIZE_IN_BYTES",
        ]
    }
}
impl AsRef<str> for SearchResourcesSortAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies property- and tag-based conditions that define filter criteria for including or excluding S3 buckets from the query results. Exclude conditions take precedence over include conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesBucketCriteria {
    /// <p>The property- and tag-based conditions that determine which buckets to exclude from the results.</p>
    pub excludes: std::option::Option<crate::model::SearchResourcesCriteriaBlock>,
    /// <p>The property- and tag-based conditions that determine which buckets to include in the results.</p>
    pub includes: std::option::Option<crate::model::SearchResourcesCriteriaBlock>,
}
impl SearchResourcesBucketCriteria {
    /// <p>The property- and tag-based conditions that determine which buckets to exclude from the results.</p>
    pub fn excludes(&self) -> std::option::Option<&crate::model::SearchResourcesCriteriaBlock> {
        self.excludes.as_ref()
    }
    /// <p>The property- and tag-based conditions that determine which buckets to include in the results.</p>
    pub fn includes(&self) -> std::option::Option<&crate::model::SearchResourcesCriteriaBlock> {
        self.includes.as_ref()
    }
}
impl std::fmt::Debug for SearchResourcesBucketCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesBucketCriteria");
        formatter.field("excludes", &self.excludes);
        formatter.field("includes", &self.includes);
        formatter.finish()
    }
}
/// See [`SearchResourcesBucketCriteria`](crate::model::SearchResourcesBucketCriteria)
pub mod search_resources_bucket_criteria {
    /// A builder for [`SearchResourcesBucketCriteria`](crate::model::SearchResourcesBucketCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) excludes: std::option::Option<crate::model::SearchResourcesCriteriaBlock>,
        pub(crate) includes: std::option::Option<crate::model::SearchResourcesCriteriaBlock>,
    }
    impl Builder {
        /// <p>The property- and tag-based conditions that determine which buckets to exclude from the results.</p>
        pub fn excludes(mut self, input: crate::model::SearchResourcesCriteriaBlock) -> Self {
            self.excludes = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which buckets to exclude from the results.</p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesCriteriaBlock>,
        ) -> Self {
            self.excludes = input;
            self
        }
        /// <p>The property- and tag-based conditions that determine which buckets to include in the results.</p>
        pub fn includes(mut self, input: crate::model::SearchResourcesCriteriaBlock) -> Self {
            self.includes = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which buckets to include in the results.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesCriteriaBlock>,
        ) -> Self {
            self.includes = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesBucketCriteria`](crate::model::SearchResourcesBucketCriteria)
        pub fn build(self) -> crate::model::SearchResourcesBucketCriteria {
            crate::model::SearchResourcesBucketCriteria {
                excludes: self.excludes,
                includes: self.includes,
            }
        }
    }
}
impl SearchResourcesBucketCriteria {
    /// Creates a new builder-style object to manufacture [`SearchResourcesBucketCriteria`](crate::model::SearchResourcesBucketCriteria)
    pub fn builder() -> crate::model::search_resources_bucket_criteria::Builder {
        crate::model::search_resources_bucket_criteria::Builder::default()
    }
}

/// <p>Specifies property- and tag-based conditions that define filter criteria for including or excluding Amazon Web Services resources from the query results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesCriteriaBlock {
    /// <p>An array of objects, one for each property- or tag-based condition that includes or excludes resources from the query results. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
    pub and: std::option::Option<std::vec::Vec<crate::model::SearchResourcesCriteria>>,
}
impl SearchResourcesCriteriaBlock {
    /// <p>An array of objects, one for each property- or tag-based condition that includes or excludes resources from the query results. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
    pub fn and(&self) -> std::option::Option<&[crate::model::SearchResourcesCriteria]> {
        self.and.as_deref()
    }
}
impl std::fmt::Debug for SearchResourcesCriteriaBlock {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesCriteriaBlock");
        formatter.field("and", &self.and);
        formatter.finish()
    }
}
/// See [`SearchResourcesCriteriaBlock`](crate::model::SearchResourcesCriteriaBlock)
pub mod search_resources_criteria_block {
    /// A builder for [`SearchResourcesCriteriaBlock`](crate::model::SearchResourcesCriteriaBlock)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) and: std::option::Option<std::vec::Vec<crate::model::SearchResourcesCriteria>>,
    }
    impl Builder {
        /// Appends an item to `and`.
        ///
        /// To override the contents of this collection use [`set_and`](Self::set_and).
        ///
        /// <p>An array of objects, one for each property- or tag-based condition that includes or excludes resources from the query results. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
        pub fn and(mut self, input: crate::model::SearchResourcesCriteria) -> Self {
            let mut v = self.and.unwrap_or_default();
            v.push(input);
            self.and = Some(v);
            self
        }
        /// <p>An array of objects, one for each property- or tag-based condition that includes or excludes resources from the query results. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SearchResourcesCriteria>>,
        ) -> Self {
            self.and = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesCriteriaBlock`](crate::model::SearchResourcesCriteriaBlock)
        pub fn build(self) -> crate::model::SearchResourcesCriteriaBlock {
            crate::model::SearchResourcesCriteriaBlock { and: self.and }
        }
    }
}
impl SearchResourcesCriteriaBlock {
    /// Creates a new builder-style object to manufacture [`SearchResourcesCriteriaBlock`](crate::model::SearchResourcesCriteriaBlock)
    pub fn builder() -> crate::model::search_resources_criteria_block::Builder {
        crate::model::search_resources_criteria_block::Builder::default()
    }
}

/// <p>Specifies a property- or tag-based filter condition for including or excluding Amazon Web Services resources from the query results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesCriteria {
    /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding resources from the results.</p>
    pub simple_criterion: std::option::Option<crate::model::SearchResourcesSimpleCriterion>,
    /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding resources from the results.</p>
    pub tag_criterion: std::option::Option<crate::model::SearchResourcesTagCriterion>,
}
impl SearchResourcesCriteria {
    /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding resources from the results.</p>
    pub fn simple_criterion(
        &self,
    ) -> std::option::Option<&crate::model::SearchResourcesSimpleCriterion> {
        self.simple_criterion.as_ref()
    }
    /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding resources from the results.</p>
    pub fn tag_criterion(&self) -> std::option::Option<&crate::model::SearchResourcesTagCriterion> {
        self.tag_criterion.as_ref()
    }
}
impl std::fmt::Debug for SearchResourcesCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesCriteria");
        formatter.field("simple_criterion", &self.simple_criterion);
        formatter.field("tag_criterion", &self.tag_criterion);
        formatter.finish()
    }
}
/// See [`SearchResourcesCriteria`](crate::model::SearchResourcesCriteria)
pub mod search_resources_criteria {
    /// A builder for [`SearchResourcesCriteria`](crate::model::SearchResourcesCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple_criterion:
            std::option::Option<crate::model::SearchResourcesSimpleCriterion>,
        pub(crate) tag_criterion: std::option::Option<crate::model::SearchResourcesTagCriterion>,
    }
    impl Builder {
        /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding resources from the results.</p>
        pub fn simple_criterion(
            mut self,
            input: crate::model::SearchResourcesSimpleCriterion,
        ) -> Self {
            self.simple_criterion = Some(input);
            self
        }
        /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding resources from the results.</p>
        pub fn set_simple_criterion(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesSimpleCriterion>,
        ) -> Self {
            self.simple_criterion = input;
            self
        }
        /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding resources from the results.</p>
        pub fn tag_criterion(mut self, input: crate::model::SearchResourcesTagCriterion) -> Self {
            self.tag_criterion = Some(input);
            self
        }
        /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding resources from the results.</p>
        pub fn set_tag_criterion(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesTagCriterion>,
        ) -> Self {
            self.tag_criterion = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesCriteria`](crate::model::SearchResourcesCriteria)
        pub fn build(self) -> crate::model::SearchResourcesCriteria {
            crate::model::SearchResourcesCriteria {
                simple_criterion: self.simple_criterion,
                tag_criterion: self.tag_criterion,
            }
        }
    }
}
impl SearchResourcesCriteria {
    /// Creates a new builder-style object to manufacture [`SearchResourcesCriteria`](crate::model::SearchResourcesCriteria)
    pub fn builder() -> crate::model::search_resources_criteria::Builder {
        crate::model::search_resources_criteria::Builder::default()
    }
}

/// <p>Specifies a tag-based filter condition that determines which Amazon Web Services resources are included or excluded from the query results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesTagCriterion {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub comparator: std::option::Option<crate::model::SearchResourcesComparator>,
    /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
    pub tag_values:
        std::option::Option<std::vec::Vec<crate::model::SearchResourcesTagCriterionPair>>,
}
impl SearchResourcesTagCriterion {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::SearchResourcesComparator> {
        self.comparator.as_ref()
    }
    /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
    pub fn tag_values(
        &self,
    ) -> std::option::Option<&[crate::model::SearchResourcesTagCriterionPair]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for SearchResourcesTagCriterion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesTagCriterion");
        formatter.field("comparator", &self.comparator);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`SearchResourcesTagCriterion`](crate::model::SearchResourcesTagCriterion)
pub mod search_resources_tag_criterion {
    /// A builder for [`SearchResourcesTagCriterion`](crate::model::SearchResourcesTagCriterion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::SearchResourcesComparator>,
        pub(crate) tag_values:
            std::option::Option<std::vec::Vec<crate::model::SearchResourcesTagCriterionPair>>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn comparator(mut self, input: crate::model::SearchResourcesComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
        pub fn tag_values(mut self, input: crate::model::SearchResourcesTagCriterionPair) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input);
            self.tag_values = Some(v);
            self
        }
        /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<
                std::vec::Vec<crate::model::SearchResourcesTagCriterionPair>,
            >,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesTagCriterion`](crate::model::SearchResourcesTagCriterion)
        pub fn build(self) -> crate::model::SearchResourcesTagCriterion {
            crate::model::SearchResourcesTagCriterion {
                comparator: self.comparator,
                tag_values: self.tag_values,
            }
        }
    }
}
impl SearchResourcesTagCriterion {
    /// Creates a new builder-style object to manufacture [`SearchResourcesTagCriterion`](crate::model::SearchResourcesTagCriterion)
    pub fn builder() -> crate::model::search_resources_tag_criterion::Builder {
        crate::model::search_resources_tag_criterion::Builder::default()
    }
}

/// <p>Specifies a tag key, a tag value, or a tag key and value (as a pair) to use in a tag-based filter condition for a query. Tag keys and values are case sensitive. Also, Amazon Macie doesn't support use of partial values or wildcard characters in tag-based filter conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesTagCriterionPair {
    /// <p>The value for the tag key to use in the condition.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value to use in the condition.</p>
    pub value: std::option::Option<std::string::String>,
}
impl SearchResourcesTagCriterionPair {
    /// <p>The value for the tag key to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value to use in the condition.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for SearchResourcesTagCriterionPair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesTagCriterionPair");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`SearchResourcesTagCriterionPair`](crate::model::SearchResourcesTagCriterionPair)
pub mod search_resources_tag_criterion_pair {
    /// A builder for [`SearchResourcesTagCriterionPair`](crate::model::SearchResourcesTagCriterionPair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value for the tag key to use in the condition.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The value for the tag key to use in the condition.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value to use in the condition.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value to use in the condition.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesTagCriterionPair`](crate::model::SearchResourcesTagCriterionPair)
        pub fn build(self) -> crate::model::SearchResourcesTagCriterionPair {
            crate::model::SearchResourcesTagCriterionPair {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl SearchResourcesTagCriterionPair {
    /// Creates a new builder-style object to manufacture [`SearchResourcesTagCriterionPair`](crate::model::SearchResourcesTagCriterionPair)
    pub fn builder() -> crate::model::search_resources_tag_criterion_pair::Builder {
        crate::model::search_resources_tag_criterion_pair::Builder::default()
    }
}

/// <p>The operator to use in a condition that filters the results of a query. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SearchResourcesComparator {
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SearchResourcesComparator {
    fn from(s: &str) -> Self {
        match s {
            "EQ" => SearchResourcesComparator::Eq,
            "NE" => SearchResourcesComparator::Ne,
            other => SearchResourcesComparator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SearchResourcesComparator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SearchResourcesComparator::from(s))
    }
}
impl SearchResourcesComparator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SearchResourcesComparator::Eq => "EQ",
            SearchResourcesComparator::Ne => "NE",
            SearchResourcesComparator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EQ", "NE"]
    }
}
impl AsRef<str> for SearchResourcesComparator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a property-based filter condition that determines which Amazon Web Services resources are included or excluded from the query results.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesSimpleCriterion {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub comparator: std::option::Option<crate::model::SearchResourcesComparator>,
    /// <p>The property to use in the condition.</p>
    pub key: std::option::Option<crate::model::SearchResourcesSimpleCriterionKey>,
    /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource.</p></li>
    /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of an S3 bucket.</p></li>
    /// <li><p>S3_BUCKET_NAME - A string that represents the name of an S3 bucket.</p></li>
    /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of an S3 bucket.</p></li>
    /// </ul>
    /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SearchResourcesSimpleCriterion {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::SearchResourcesComparator> {
        self.comparator.as_ref()
    }
    /// <p>The property to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::SearchResourcesSimpleCriterionKey> {
        self.key.as_ref()
    }
    /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource.</p></li>
    /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of an S3 bucket.</p></li>
    /// <li><p>S3_BUCKET_NAME - A string that represents the name of an S3 bucket.</p></li>
    /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of an S3 bucket.</p></li>
    /// </ul>
    /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for SearchResourcesSimpleCriterion {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesSimpleCriterion");
        formatter.field("comparator", &self.comparator);
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SearchResourcesSimpleCriterion`](crate::model::SearchResourcesSimpleCriterion)
pub mod search_resources_simple_criterion {
    /// A builder for [`SearchResourcesSimpleCriterion`](crate::model::SearchResourcesSimpleCriterion)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::SearchResourcesComparator>,
        pub(crate) key: std::option::Option<crate::model::SearchResourcesSimpleCriterionKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn comparator(mut self, input: crate::model::SearchResourcesComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// <p>The property to use in the condition.</p>
        pub fn key(mut self, input: crate::model::SearchResourcesSimpleCriterionKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The property to use in the condition.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesSimpleCriterionKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource.</p></li>
        /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of an S3 bucket.</p></li>
        /// <li><p>S3_BUCKET_NAME - A string that represents the name of an S3 bucket.</p></li>
        /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of an S3 bucket.</p></li>
        /// </ul>
        /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the resource.</p></li>
        /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of an S3 bucket.</p></li>
        /// <li><p>S3_BUCKET_NAME - A string that represents the name of an S3 bucket.</p></li>
        /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of an S3 bucket.</p></li>
        /// </ul>
        /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesSimpleCriterion`](crate::model::SearchResourcesSimpleCriterion)
        pub fn build(self) -> crate::model::SearchResourcesSimpleCriterion {
            crate::model::SearchResourcesSimpleCriterion {
                comparator: self.comparator,
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl SearchResourcesSimpleCriterion {
    /// Creates a new builder-style object to manufacture [`SearchResourcesSimpleCriterion`](crate::model::SearchResourcesSimpleCriterion)
    pub fn builder() -> crate::model::search_resources_simple_criterion::Builder {
        crate::model::search_resources_simple_criterion::Builder::default()
    }
}

/// <p>The property to use in a condition that filters the query results. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SearchResourcesSimpleCriterionKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketEffectivePermission,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketName,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketSharedAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SearchResourcesSimpleCriterionKey {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => SearchResourcesSimpleCriterionKey::AccountId,
            "S3_BUCKET_EFFECTIVE_PERMISSION" => {
                SearchResourcesSimpleCriterionKey::S3BucketEffectivePermission
            }
            "S3_BUCKET_NAME" => SearchResourcesSimpleCriterionKey::S3BucketName,
            "S3_BUCKET_SHARED_ACCESS" => SearchResourcesSimpleCriterionKey::S3BucketSharedAccess,
            other => SearchResourcesSimpleCriterionKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SearchResourcesSimpleCriterionKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SearchResourcesSimpleCriterionKey::from(s))
    }
}
impl SearchResourcesSimpleCriterionKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SearchResourcesSimpleCriterionKey::AccountId => "ACCOUNT_ID",
            SearchResourcesSimpleCriterionKey::S3BucketEffectivePermission => {
                "S3_BUCKET_EFFECTIVE_PERMISSION"
            }
            SearchResourcesSimpleCriterionKey::S3BucketName => "S3_BUCKET_NAME",
            SearchResourcesSimpleCriterionKey::S3BucketSharedAccess => "S3_BUCKET_SHARED_ACCESS",
            SearchResourcesSimpleCriterionKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_ID",
            "S3_BUCKET_EFFECTIVE_PERMISSION",
            "S3_BUCKET_NAME",
            "S3_BUCKET_SHARED_ACCESS",
        ]
    }
}
impl AsRef<str> for SearchResourcesSimpleCriterionKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies configuration settings that determine which findings are published to Security Hub automatically. For information about how Macie publishes findings to Security Hub, see <a href="https://docs.aws.amazon.com/macie/latest/user/securityhub-integration.html">Amazon Macie integration with Security Hub</a> in the <i>Amazon Macie User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SecurityHubConfiguration {
    /// <p>Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.</p>
    pub publish_classification_findings: bool,
    /// <p>Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.</p>
    pub publish_policy_findings: bool,
}
impl SecurityHubConfiguration {
    /// <p>Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.</p>
    pub fn publish_classification_findings(&self) -> bool {
        self.publish_classification_findings
    }
    /// <p>Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.</p>
    pub fn publish_policy_findings(&self) -> bool {
        self.publish_policy_findings
    }
}
impl std::fmt::Debug for SecurityHubConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SecurityHubConfiguration");
        formatter.field(
            "publish_classification_findings",
            &self.publish_classification_findings,
        );
        formatter.field("publish_policy_findings", &self.publish_policy_findings);
        formatter.finish()
    }
}
/// See [`SecurityHubConfiguration`](crate::model::SecurityHubConfiguration)
pub mod security_hub_configuration {
    /// A builder for [`SecurityHubConfiguration`](crate::model::SecurityHubConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) publish_classification_findings: std::option::Option<bool>,
        pub(crate) publish_policy_findings: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.</p>
        pub fn publish_classification_findings(mut self, input: bool) -> Self {
            self.publish_classification_findings = Some(input);
            self
        }
        /// <p>Specifies whether to publish sensitive data findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all sensitive data findings that weren't suppressed by a findings filter. The default value is false.</p>
        pub fn set_publish_classification_findings(
            mut self,
            input: std::option::Option<bool>,
        ) -> Self {
            self.publish_classification_findings = input;
            self
        }
        /// <p>Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.</p>
        pub fn publish_policy_findings(mut self, input: bool) -> Self {
            self.publish_policy_findings = Some(input);
            self
        }
        /// <p>Specifies whether to publish policy findings to Security Hub. If you set this value to true, Amazon Macie automatically publishes all new and updated policy findings that weren't suppressed by a findings filter. The default value is true.</p>
        pub fn set_publish_policy_findings(mut self, input: std::option::Option<bool>) -> Self {
            self.publish_policy_findings = input;
            self
        }
        /// Consumes the builder and constructs a [`SecurityHubConfiguration`](crate::model::SecurityHubConfiguration)
        pub fn build(self) -> crate::model::SecurityHubConfiguration {
            crate::model::SecurityHubConfiguration {
                publish_classification_findings: self
                    .publish_classification_findings
                    .unwrap_or_default(),
                publish_policy_findings: self.publish_policy_findings.unwrap_or_default(),
            }
        }
    }
}
impl SecurityHubConfiguration {
    /// Creates a new builder-style object to manufacture [`SecurityHubConfiguration`](crate::model::SecurityHubConfiguration)
    pub fn builder() -> crate::model::security_hub_configuration::Builder {
        crate::model::security_hub_configuration::Builder::default()
    }
}

/// <p>Specifies where to store data classification results, and the encryption settings to use when storing results in that location. Currently, you can store classification results only in an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassificationExportConfiguration {
    /// <p>The S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>
    pub s3_destination: std::option::Option<crate::model::S3Destination>,
}
impl ClassificationExportConfiguration {
    /// <p>The S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>
    pub fn s3_destination(&self) -> std::option::Option<&crate::model::S3Destination> {
        self.s3_destination.as_ref()
    }
}
impl std::fmt::Debug for ClassificationExportConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassificationExportConfiguration");
        formatter.field("s3_destination", &self.s3_destination);
        formatter.finish()
    }
}
/// See [`ClassificationExportConfiguration`](crate::model::ClassificationExportConfiguration)
pub mod classification_export_configuration {
    /// A builder for [`ClassificationExportConfiguration`](crate::model::ClassificationExportConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_destination: std::option::Option<crate::model::S3Destination>,
    }
    impl Builder {
        /// <p>The S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>
        pub fn s3_destination(mut self, input: crate::model::S3Destination) -> Self {
            self.s3_destination = Some(input);
            self
        }
        /// <p>The S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>
        pub fn set_s3_destination(
            mut self,
            input: std::option::Option<crate::model::S3Destination>,
        ) -> Self {
            self.s3_destination = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassificationExportConfiguration`](crate::model::ClassificationExportConfiguration)
        pub fn build(self) -> crate::model::ClassificationExportConfiguration {
            crate::model::ClassificationExportConfiguration {
                s3_destination: self.s3_destination,
            }
        }
    }
}
impl ClassificationExportConfiguration {
    /// Creates a new builder-style object to manufacture [`ClassificationExportConfiguration`](crate::model::ClassificationExportConfiguration)
    pub fn builder() -> crate::model::classification_export_configuration::Builder {
        crate::model::classification_export_configuration::Builder::default()
    }
}

/// <p>Specifies an S3 bucket to store data classification results in, and the encryption settings to use when storing results in that bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Destination {
    /// <p>The name of the bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.</p>
    pub key_prefix: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric, customer managed KMS key that's in the same Amazon Web Services Region as the bucket.</p>
    pub kms_key_arn: std::option::Option<std::string::String>,
}
impl S3Destination {
    /// <p>The name of the bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.</p>
    pub fn key_prefix(&self) -> std::option::Option<&str> {
        self.key_prefix.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric, customer managed KMS key that's in the same Amazon Web Services Region as the bucket.</p>
    pub fn kms_key_arn(&self) -> std::option::Option<&str> {
        self.kms_key_arn.as_deref()
    }
}
impl std::fmt::Debug for S3Destination {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Destination");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("key_prefix", &self.key_prefix);
        formatter.field("kms_key_arn", &self.kms_key_arn);
        formatter.finish()
    }
}
/// See [`S3Destination`](crate::model::S3Destination)
pub mod s3_destination {
    /// A builder for [`S3Destination`](crate::model::S3Destination)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) key_prefix: std::option::Option<std::string::String>,
        pub(crate) kms_key_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.</p>
        pub fn key_prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.key_prefix = Some(input.into());
            self
        }
        /// <p>The path prefix to use in the path to the location in the bucket. This prefix specifies where to store classification results in the bucket.</p>
        pub fn set_key_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key_prefix = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric, customer managed KMS key that's in the same Amazon Web Services Region as the bucket.</p>
        pub fn kms_key_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the KMS key to use for encryption of the results. This must be the ARN of an existing, symmetric, customer managed KMS key that's in the same Amazon Web Services Region as the bucket.</p>
        pub fn set_kms_key_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Destination`](crate::model::S3Destination)
        pub fn build(self) -> crate::model::S3Destination {
            crate::model::S3Destination {
                bucket_name: self.bucket_name,
                key_prefix: self.key_prefix,
                kms_key_arn: self.kms_key_arn,
            }
        }
    }
}
impl S3Destination {
    /// Creates a new builder-style object to manufacture [`S3Destination`](crate::model::S3Destination)
    pub fn builder() -> crate::model::s3_destination::Builder {
        crate::model::s3_destination::Builder::default()
    }
}

/// <p>Provides information about the delegated Amazon Macie administrator account for an organization in Organizations.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AdminAccount {
    /// <p>The Amazon Web Services account ID for the account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The current status of the account as the delegated Amazon Macie administrator account for the organization.</p>
    pub status: std::option::Option<crate::model::AdminStatus>,
}
impl AdminAccount {
    /// <p>The Amazon Web Services account ID for the account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The current status of the account as the delegated Amazon Macie administrator account for the organization.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::AdminStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for AdminAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AdminAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`AdminAccount`](crate::model::AdminAccount)
pub mod admin_account {
    /// A builder for [`AdminAccount`](crate::model::AdminAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::AdminStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The current status of the account as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn status(mut self, input: crate::model::AdminStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the account as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::AdminStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`AdminAccount`](crate::model::AdminAccount)
        pub fn build(self) -> crate::model::AdminAccount {
            crate::model::AdminAccount {
                account_id: self.account_id,
                status: self.status,
            }
        }
    }
}
impl AdminAccount {
    /// Creates a new builder-style object to manufacture [`AdminAccount`](crate::model::AdminAccount)
    pub fn builder() -> crate::model::admin_account::Builder {
        crate::model::admin_account::Builder::default()
    }
}

/// <p>The current status of an account as the delegated Amazon Macie administrator account for an organization in Organizations. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AdminStatus {
    #[allow(missing_docs)] // documentation missing in model
    DisablingInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AdminStatus {
    fn from(s: &str) -> Self {
        match s {
            "DISABLING_IN_PROGRESS" => AdminStatus::DisablingInProgress,
            "ENABLED" => AdminStatus::Enabled,
            other => AdminStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AdminStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AdminStatus::from(s))
    }
}
impl AdminStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AdminStatus::DisablingInProgress => "DISABLING_IN_PROGRESS",
            AdminStatus::Enabled => "ENABLED",
            AdminStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DISABLING_IN_PROGRESS", "ENABLED"]
    }
}
impl AsRef<str> for AdminStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about an account that's associated with an Amazon Macie administrator account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Member {
    /// <p>The Amazon Web Services account ID for the account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services account ID for the administrator account.</p>
    pub administrator_account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the account.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The email address for the account.</p>
    pub email: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if an invitation hasn't been sent to the account.</p>
    pub invited_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
    pub master_account_id: std::option::Option<std::string::String>,
    /// <p>The current status of the relationship between the account and the administrator account.</p>
    pub relationship_status: std::option::Option<crate::model::RelationshipStatus>,
    /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the account in Amazon Macie.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl Member {
    /// <p>The Amazon Web Services account ID for the account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Web Services account ID for the administrator account.</p>
    pub fn administrator_account_id(&self) -> std::option::Option<&str> {
        self.administrator_account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the account.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The email address for the account.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if an invitation hasn't been sent to the account.</p>
    pub fn invited_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.invited_at.as_ref()
    }
    /// <p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
    pub fn master_account_id(&self) -> std::option::Option<&str> {
        self.master_account_id.as_deref()
    }
    /// <p>The current status of the relationship between the account and the administrator account.</p>
    pub fn relationship_status(&self) -> std::option::Option<&crate::model::RelationshipStatus> {
        self.relationship_status.as_ref()
    }
    /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the account in Amazon Macie.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for Member {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Member");
        formatter.field("account_id", &self.account_id);
        formatter.field("administrator_account_id", &self.administrator_account_id);
        formatter.field("arn", &self.arn);
        formatter.field("email", &self.email);
        formatter.field("invited_at", &self.invited_at);
        formatter.field("master_account_id", &self.master_account_id);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.field("tags", &self.tags);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Member`](crate::model::Member)
pub mod member {
    /// A builder for [`Member`](crate::model::Member)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) administrator_account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) master_account_id: std::option::Option<std::string::String>,
        pub(crate) relationship_status: std::option::Option<crate::model::RelationshipStatus>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Web Services account ID for the administrator account.</p>
        pub fn administrator_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the administrator account.</p>
        pub fn set_administrator_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the account.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The email address for the account.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address for the account.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if an invitation hasn't been sent to the account.</p>
        pub fn invited_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.invited_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if an invitation hasn't been sent to the account.</p>
        pub fn set_invited_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.invited_at = input;
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn master_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_account_id = Some(input.into());
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn set_master_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_account_id = input;
            self
        }
        /// <p>The current status of the relationship between the account and the administrator account.</p>
        pub fn relationship_status(mut self, input: crate::model::RelationshipStatus) -> Self {
            self.relationship_status = Some(input);
            self
        }
        /// <p>The current status of the relationship between the account and the administrator account.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<crate::model::RelationshipStatus>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the account in Amazon Macie.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the account in Amazon Macie.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Member`](crate::model::Member)
        pub fn build(self) -> crate::model::Member {
            crate::model::Member {
                account_id: self.account_id,
                administrator_account_id: self.administrator_account_id,
                arn: self.arn,
                email: self.email,
                invited_at: self.invited_at,
                master_account_id: self.master_account_id,
                relationship_status: self.relationship_status,
                tags: self.tags,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Member {
    /// Creates a new builder-style object to manufacture [`Member`](crate::model::Member)
    pub fn builder() -> crate::model::member::Builder {
        crate::model::member::Builder::default()
    }
}

/// <p>The current status of the relationship between an account and an associated Amazon Macie administrator account. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum RelationshipStatus {
    #[allow(missing_docs)] // documentation missing in model
    AccountSuspended,
    #[allow(missing_docs)] // documentation missing in model
    Created,
    #[allow(missing_docs)] // documentation missing in model
    EmailVerificationFailed,
    #[allow(missing_docs)] // documentation missing in model
    EmailVerificationInProgress,
    #[allow(missing_docs)] // documentation missing in model
    Enabled,
    #[allow(missing_docs)] // documentation missing in model
    Invited,
    #[allow(missing_docs)] // documentation missing in model
    Paused,
    #[allow(missing_docs)] // documentation missing in model
    RegionDisabled,
    #[allow(missing_docs)] // documentation missing in model
    Removed,
    #[allow(missing_docs)] // documentation missing in model
    Resigned,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for RelationshipStatus {
    fn from(s: &str) -> Self {
        match s {
            "AccountSuspended" => RelationshipStatus::AccountSuspended,
            "Created" => RelationshipStatus::Created,
            "EmailVerificationFailed" => RelationshipStatus::EmailVerificationFailed,
            "EmailVerificationInProgress" => RelationshipStatus::EmailVerificationInProgress,
            "Enabled" => RelationshipStatus::Enabled,
            "Invited" => RelationshipStatus::Invited,
            "Paused" => RelationshipStatus::Paused,
            "RegionDisabled" => RelationshipStatus::RegionDisabled,
            "Removed" => RelationshipStatus::Removed,
            "Resigned" => RelationshipStatus::Resigned,
            other => RelationshipStatus::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for RelationshipStatus {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(RelationshipStatus::from(s))
    }
}
impl RelationshipStatus {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            RelationshipStatus::AccountSuspended => "AccountSuspended",
            RelationshipStatus::Created => "Created",
            RelationshipStatus::EmailVerificationFailed => "EmailVerificationFailed",
            RelationshipStatus::EmailVerificationInProgress => "EmailVerificationInProgress",
            RelationshipStatus::Enabled => "Enabled",
            RelationshipStatus::Invited => "Invited",
            RelationshipStatus::Paused => "Paused",
            RelationshipStatus::RegionDisabled => "RegionDisabled",
            RelationshipStatus::Removed => "Removed",
            RelationshipStatus::Resigned => "Resigned",
            RelationshipStatus::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AccountSuspended",
            "Created",
            "EmailVerificationFailed",
            "EmailVerificationInProgress",
            "Enabled",
            "Invited",
            "Paused",
            "RegionDisabled",
            "Removed",
            "Resigned",
        ]
    }
}
impl AsRef<str> for RelationshipStatus {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a managed data identifier. For additional information, see <a href="https://docs.aws.amazon.com/macie/latest/user/managed-data-identifiers.html">Using managed data identifiers</a> in the <i>Amazon Macie User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ManagedDataIdentifierSummary {
    /// <p>The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
    pub category: std::option::Option<crate::model::SensitiveDataItemCategory>,
    /// <p>The unique identifier for the managed data identifier. This is a string that describes the type of sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.</p>
    pub id: std::option::Option<std::string::String>,
}
impl ManagedDataIdentifierSummary {
    /// <p>The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::SensitiveDataItemCategory> {
        self.category.as_ref()
    }
    /// <p>The unique identifier for the managed data identifier. This is a string that describes the type of sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for ManagedDataIdentifierSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ManagedDataIdentifierSummary");
        formatter.field("category", &self.category);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`ManagedDataIdentifierSummary`](crate::model::ManagedDataIdentifierSummary)
pub mod managed_data_identifier_summary {
    /// A builder for [`ManagedDataIdentifierSummary`](crate::model::ManagedDataIdentifierSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::SensitiveDataItemCategory>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
        pub fn category(mut self, input: crate::model::SensitiveDataItemCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of sensitive data that the managed data identifier detects: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::SensitiveDataItemCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The unique identifier for the managed data identifier. This is a string that describes the type of sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the managed data identifier. This is a string that describes the type of sensitive data that the managed data identifier detects. For example: OPENSSH_PRIVATE_KEY for OpenSSH private keys, CREDIT_CARD_NUMBER for credit card numbers, or USA_PASSPORT_NUMBER for US passport numbers.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`ManagedDataIdentifierSummary`](crate::model::ManagedDataIdentifierSummary)
        pub fn build(self) -> crate::model::ManagedDataIdentifierSummary {
            crate::model::ManagedDataIdentifierSummary {
                category: self.category,
                id: self.id,
            }
        }
    }
}
impl ManagedDataIdentifierSummary {
    /// Creates a new builder-style object to manufacture [`ManagedDataIdentifierSummary`](crate::model::ManagedDataIdentifierSummary)
    pub fn builder() -> crate::model::managed_data_identifier_summary::Builder {
        crate::model::managed_data_identifier_summary::Builder::default()
    }
}

/// <p>For a finding, the category of sensitive data that was detected and produced the finding. For a managed data identifier, the category of sensitive data that the managed data identifier detects. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SensitiveDataItemCategory {
    #[allow(missing_docs)] // documentation missing in model
    Credentials,
    #[allow(missing_docs)] // documentation missing in model
    CustomIdentifier,
    #[allow(missing_docs)] // documentation missing in model
    FinancialInformation,
    #[allow(missing_docs)] // documentation missing in model
    PersonalInformation,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SensitiveDataItemCategory {
    fn from(s: &str) -> Self {
        match s {
            "CREDENTIALS" => SensitiveDataItemCategory::Credentials,
            "CUSTOM_IDENTIFIER" => SensitiveDataItemCategory::CustomIdentifier,
            "FINANCIAL_INFORMATION" => SensitiveDataItemCategory::FinancialInformation,
            "PERSONAL_INFORMATION" => SensitiveDataItemCategory::PersonalInformation,
            other => SensitiveDataItemCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SensitiveDataItemCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SensitiveDataItemCategory::from(s))
    }
}
impl SensitiveDataItemCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SensitiveDataItemCategory::Credentials => "CREDENTIALS",
            SensitiveDataItemCategory::CustomIdentifier => "CUSTOM_IDENTIFIER",
            SensitiveDataItemCategory::FinancialInformation => "FINANCIAL_INFORMATION",
            SensitiveDataItemCategory::PersonalInformation => "PERSONAL_INFORMATION",
            SensitiveDataItemCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CREDENTIALS",
            "CUSTOM_IDENTIFIER",
            "FINANCIAL_INFORMATION",
            "PERSONAL_INFORMATION",
        ]
    }
}
impl AsRef<str> for SensitiveDataItemCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about an Amazon Macie membership invitation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Invitation {
    /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the invitation.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.</p>
    pub invited_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The status of the relationship between the account that sent the invitation and the account that received the invitation.</p>
    pub relationship_status: std::option::Option<crate::model::RelationshipStatus>,
}
impl Invitation {
    /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The unique identifier for the invitation.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.</p>
    pub fn invited_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.invited_at.as_ref()
    }
    /// <p>The status of the relationship between the account that sent the invitation and the account that received the invitation.</p>
    pub fn relationship_status(&self) -> std::option::Option<&crate::model::RelationshipStatus> {
        self.relationship_status.as_ref()
    }
}
impl std::fmt::Debug for Invitation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Invitation");
        formatter.field("account_id", &self.account_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("invited_at", &self.invited_at);
        formatter.field("relationship_status", &self.relationship_status);
        formatter.finish()
    }
}
/// See [`Invitation`](crate::model::Invitation)
pub mod invitation {
    /// A builder for [`Invitation`](crate::model::Invitation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) invited_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) relationship_status: std::option::Option<crate::model::RelationshipStatus>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The unique identifier for the invitation.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the invitation.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.</p>
        pub fn invited_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.invited_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the invitation was sent.</p>
        pub fn set_invited_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.invited_at = input;
            self
        }
        /// <p>The status of the relationship between the account that sent the invitation and the account that received the invitation.</p>
        pub fn relationship_status(mut self, input: crate::model::RelationshipStatus) -> Self {
            self.relationship_status = Some(input);
            self
        }
        /// <p>The status of the relationship between the account that sent the invitation and the account that received the invitation.</p>
        pub fn set_relationship_status(
            mut self,
            input: std::option::Option<crate::model::RelationshipStatus>,
        ) -> Self {
            self.relationship_status = input;
            self
        }
        /// Consumes the builder and constructs a [`Invitation`](crate::model::Invitation)
        pub fn build(self) -> crate::model::Invitation {
            crate::model::Invitation {
                account_id: self.account_id,
                invitation_id: self.invitation_id,
                invited_at: self.invited_at,
                relationship_status: self.relationship_status,
            }
        }
    }
}
impl Invitation {
    /// Creates a new builder-style object to manufacture [`Invitation`](crate::model::Invitation)
    pub fn builder() -> crate::model::invitation::Builder {
        crate::model::invitation::Builder::default()
    }
}

/// <p>Provides information about a findings filter.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingsFilterListItem {
    /// <p>The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    pub action: std::option::Option<crate::model::FindingsFilterAction>,
    /// <p>The Amazon Resource Name (ARN) of the filter.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the filter.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The custom name of the filter.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl FindingsFilterListItem {
    /// <p>The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FindingsFilterAction> {
        self.action.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the filter.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier for the filter.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The custom name of the filter.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for FindingsFilterListItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingsFilterListItem");
        formatter.field("action", &self.action);
        formatter.field("arn", &self.arn);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`FindingsFilterListItem`](crate::model::FindingsFilterListItem)
pub mod findings_filter_list_item {
    /// A builder for [`FindingsFilterListItem`](crate::model::FindingsFilterListItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::FindingsFilterAction>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, input: crate::model::FindingsFilterAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that's performed on findings that meet the filter criteria. Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the filter.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the filter.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier for the filter.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the filter.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The custom name of the filter.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name of the filter.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingsFilterListItem`](crate::model::FindingsFilterListItem)
        pub fn build(self) -> crate::model::FindingsFilterListItem {
            crate::model::FindingsFilterListItem {
                action: self.action,
                arn: self.arn,
                id: self.id,
                name: self.name,
                tags: self.tags,
            }
        }
    }
}
impl FindingsFilterListItem {
    /// Creates a new builder-style object to manufacture [`FindingsFilterListItem`](crate::model::FindingsFilterListItem)
    pub fn builder() -> crate::model::findings_filter_list_item::Builder {
        crate::model::findings_filter_list_item::Builder::default()
    }
}

/// <p>Specifies criteria for sorting the results of a request for findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SortCriteria {
    /// <p>The name of the property to sort the results by. This value can be the name of any property that Amazon Macie defines for a finding.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl SortCriteria {
    /// <p>The name of the property to sort the results by. This value can be the name of any property that Amazon Macie defines for a finding.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::OrderBy> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for SortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`SortCriteria`](crate::model::SortCriteria)
pub mod sort_criteria {
    /// A builder for [`SortCriteria`](crate::model::SortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The name of the property to sort the results by. This value can be the name of any property that Amazon Macie defines for a finding.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the property to sort the results by. This value can be the name of any property that Amazon Macie defines for a finding.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`SortCriteria`](crate::model::SortCriteria)
        pub fn build(self) -> crate::model::SortCriteria {
            crate::model::SortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl SortCriteria {
    /// Creates a new builder-style object to manufacture [`SortCriteria`](crate::model::SortCriteria)
    pub fn builder() -> crate::model::sort_criteria::Builder {
        crate::model::sort_criteria::Builder::default()
    }
}

/// <p>Provides information about a custom data identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomDataIdentifierSummary {
    /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The custom description of the custom data identifier.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the custom data identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The custom name of the custom data identifier.</p>
    pub name: std::option::Option<std::string::String>,
}
impl CustomDataIdentifierSummary {
    /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The custom description of the custom data identifier.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the custom data identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The custom name of the custom data identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for CustomDataIdentifierSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomDataIdentifierSummary");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`CustomDataIdentifierSummary`](crate::model::CustomDataIdentifierSummary)
pub mod custom_data_identifier_summary {
    /// A builder for [`CustomDataIdentifierSummary`](crate::model::CustomDataIdentifierSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The custom description of the custom data identifier.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The custom description of the custom data identifier.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the custom data identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the custom data identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The custom name of the custom data identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name of the custom data identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomDataIdentifierSummary`](crate::model::CustomDataIdentifierSummary)
        pub fn build(self) -> crate::model::CustomDataIdentifierSummary {
            crate::model::CustomDataIdentifierSummary {
                arn: self.arn,
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl CustomDataIdentifierSummary {
    /// Creates a new builder-style object to manufacture [`CustomDataIdentifierSummary`](crate::model::CustomDataIdentifierSummary)
    pub fn builder() -> crate::model::custom_data_identifier_summary::Builder {
        crate::model::custom_data_identifier_summary::Builder::default()
    }
}

/// <p>Provides information about a classification job, including the current status of the job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobSummary {
    /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
    pub bucket_definitions:
        std::option::Option<std::vec::Vec<crate::model::S3BucketDefinitionForJob>>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The unique identifier for the job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The current status of the job. Possible values are:</p>
    /// <ul>
    /// <li><p>CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.</p></li>
    /// <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.</p></li>
    /// <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.</p></li>
    /// <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li>
    /// <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li>
    /// <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li>
    /// </ul>
    pub job_status: std::option::Option<crate::model::JobStatus>,
    /// <p>The schedule for running the job. Possible values are:</p>
    /// <ul>
    /// <li><p>ONE_TIME - The job runs only once.</p></li>
    /// <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis.</p></li>
    /// </ul>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.</p>
    pub last_run_error_status: std::option::Option<crate::model::LastRunErrorStatus>,
    /// <p>The custom name of the job.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>
    pub user_paused_details: std::option::Option<crate::model::UserPausedDetails>,
    /// <p>The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
    pub bucket_criteria: std::option::Option<crate::model::S3BucketCriteriaForJob>,
}
impl JobSummary {
    /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
    pub fn bucket_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::S3BucketDefinitionForJob]> {
        self.bucket_definitions.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The unique identifier for the job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The current status of the job. Possible values are:</p>
    /// <ul>
    /// <li><p>CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.</p></li>
    /// <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.</p></li>
    /// <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.</p></li>
    /// <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li>
    /// <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li>
    /// <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li>
    /// </ul>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
    /// <p>The schedule for running the job. Possible values are:</p>
    /// <ul>
    /// <li><p>ONE_TIME - The job runs only once.</p></li>
    /// <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis.</p></li>
    /// </ul>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.</p>
    pub fn last_run_error_status(&self) -> std::option::Option<&crate::model::LastRunErrorStatus> {
        self.last_run_error_status.as_ref()
    }
    /// <p>The custom name of the job.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>
    pub fn user_paused_details(&self) -> std::option::Option<&crate::model::UserPausedDetails> {
        self.user_paused_details.as_ref()
    }
    /// <p>The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
    pub fn bucket_criteria(&self) -> std::option::Option<&crate::model::S3BucketCriteriaForJob> {
        self.bucket_criteria.as_ref()
    }
}
impl std::fmt::Debug for JobSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobSummary");
        formatter.field("bucket_definitions", &self.bucket_definitions);
        formatter.field("created_at", &self.created_at);
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.field("job_type", &self.job_type);
        formatter.field("last_run_error_status", &self.last_run_error_status);
        formatter.field("name", &self.name);
        formatter.field("user_paused_details", &self.user_paused_details);
        formatter.field("bucket_criteria", &self.bucket_criteria);
        formatter.finish()
    }
}
/// See [`JobSummary`](crate::model::JobSummary)
pub mod job_summary {
    /// A builder for [`JobSummary`](crate::model::JobSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_definitions:
            std::option::Option<std::vec::Vec<crate::model::S3BucketDefinitionForJob>>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) last_run_error_status: std::option::Option<crate::model::LastRunErrorStatus>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) user_paused_details: std::option::Option<crate::model::UserPausedDetails>,
        pub(crate) bucket_criteria: std::option::Option<crate::model::S3BucketCriteriaForJob>,
    }
    impl Builder {
        /// Appends an item to `bucket_definitions`.
        ///
        /// To override the contents of this collection use [`set_bucket_definitions`](Self::set_bucket_definitions).
        ///
        /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
        pub fn bucket_definitions(mut self, input: crate::model::S3BucketDefinitionForJob) -> Self {
            let mut v = self.bucket_definitions.unwrap_or_default();
            v.push(input);
            self.bucket_definitions = Some(v);
            self
        }
        /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets for the job to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
        pub fn set_bucket_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3BucketDefinitionForJob>>,
        ) -> Self {
            self.bucket_definitions = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The current status of the job. Possible values are:</p>
        /// <ul>
        /// <li><p>CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.</p></li>
        /// <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.</p></li>
        /// <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.</p></li>
        /// <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li>
        /// <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li>
        /// <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li>
        /// </ul>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The current status of the job. Possible values are:</p>
        /// <ul>
        /// <li><p>CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.</p></li>
        /// <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.</p></li>
        /// <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.</p></li>
        /// <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li>
        /// <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li>
        /// <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li>
        /// </ul>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// <p>The schedule for running the job. Possible values are:</p>
        /// <ul>
        /// <li><p>ONE_TIME - The job runs only once.</p></li>
        /// <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis.</p></li>
        /// </ul>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The schedule for running the job. Possible values are:</p>
        /// <ul>
        /// <li><p>ONE_TIME - The job runs only once.</p></li>
        /// <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis.</p></li>
        /// </ul>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.</p>
        pub fn last_run_error_status(mut self, input: crate::model::LastRunErrorStatus) -> Self {
            self.last_run_error_status = Some(input);
            self
        }
        /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.</p>
        pub fn set_last_run_error_status(
            mut self,
            input: std::option::Option<crate::model::LastRunErrorStatus>,
        ) -> Self {
            self.last_run_error_status = input;
            self
        }
        /// <p>The custom name of the job.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name of the job.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>
        pub fn user_paused_details(mut self, input: crate::model::UserPausedDetails) -> Self {
            self.user_paused_details = Some(input);
            self
        }
        /// <p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>
        pub fn set_user_paused_details(
            mut self,
            input: std::option::Option<crate::model::UserPausedDetails>,
        ) -> Self {
            self.user_paused_details = input;
            self
        }
        /// <p>The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
        pub fn bucket_criteria(mut self, input: crate::model::S3BucketCriteriaForJob) -> Self {
            self.bucket_criteria = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which S3 buckets are included or excluded from the job's analysis. Each time the job runs, the job uses these criteria to determine which buckets to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
        pub fn set_bucket_criteria(
            mut self,
            input: std::option::Option<crate::model::S3BucketCriteriaForJob>,
        ) -> Self {
            self.bucket_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`JobSummary`](crate::model::JobSummary)
        pub fn build(self) -> crate::model::JobSummary {
            crate::model::JobSummary {
                bucket_definitions: self.bucket_definitions,
                created_at: self.created_at,
                job_id: self.job_id,
                job_status: self.job_status,
                job_type: self.job_type,
                last_run_error_status: self.last_run_error_status,
                name: self.name,
                user_paused_details: self.user_paused_details,
                bucket_criteria: self.bucket_criteria,
            }
        }
    }
}
impl JobSummary {
    /// Creates a new builder-style object to manufacture [`JobSummary`](crate::model::JobSummary)
    pub fn builder() -> crate::model::job_summary::Builder {
        crate::model::job_summary::Builder::default()
    }
}

/// <p>Specifies property- and tag-based conditions that define criteria for including or excluding S3 buckets from a classification job. Exclude conditions take precedence over include conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketCriteriaForJob {
    /// <p>The property- and tag-based conditions that determine which buckets to exclude from the job.</p>
    pub excludes: std::option::Option<crate::model::CriteriaBlockForJob>,
    /// <p>The property- and tag-based conditions that determine which buckets to include in the job.</p>
    pub includes: std::option::Option<crate::model::CriteriaBlockForJob>,
}
impl S3BucketCriteriaForJob {
    /// <p>The property- and tag-based conditions that determine which buckets to exclude from the job.</p>
    pub fn excludes(&self) -> std::option::Option<&crate::model::CriteriaBlockForJob> {
        self.excludes.as_ref()
    }
    /// <p>The property- and tag-based conditions that determine which buckets to include in the job.</p>
    pub fn includes(&self) -> std::option::Option<&crate::model::CriteriaBlockForJob> {
        self.includes.as_ref()
    }
}
impl std::fmt::Debug for S3BucketCriteriaForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketCriteriaForJob");
        formatter.field("excludes", &self.excludes);
        formatter.field("includes", &self.includes);
        formatter.finish()
    }
}
/// See [`S3BucketCriteriaForJob`](crate::model::S3BucketCriteriaForJob)
pub mod s3_bucket_criteria_for_job {
    /// A builder for [`S3BucketCriteriaForJob`](crate::model::S3BucketCriteriaForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) excludes: std::option::Option<crate::model::CriteriaBlockForJob>,
        pub(crate) includes: std::option::Option<crate::model::CriteriaBlockForJob>,
    }
    impl Builder {
        /// <p>The property- and tag-based conditions that determine which buckets to exclude from the job.</p>
        pub fn excludes(mut self, input: crate::model::CriteriaBlockForJob) -> Self {
            self.excludes = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which buckets to exclude from the job.</p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<crate::model::CriteriaBlockForJob>,
        ) -> Self {
            self.excludes = input;
            self
        }
        /// <p>The property- and tag-based conditions that determine which buckets to include in the job.</p>
        pub fn includes(mut self, input: crate::model::CriteriaBlockForJob) -> Self {
            self.includes = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which buckets to include in the job.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<crate::model::CriteriaBlockForJob>,
        ) -> Self {
            self.includes = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketCriteriaForJob`](crate::model::S3BucketCriteriaForJob)
        pub fn build(self) -> crate::model::S3BucketCriteriaForJob {
            crate::model::S3BucketCriteriaForJob {
                excludes: self.excludes,
                includes: self.includes,
            }
        }
    }
}
impl S3BucketCriteriaForJob {
    /// Creates a new builder-style object to manufacture [`S3BucketCriteriaForJob`](crate::model::S3BucketCriteriaForJob)
    pub fn builder() -> crate::model::s3_bucket_criteria_for_job::Builder {
        crate::model::s3_bucket_criteria_for_job::Builder::default()
    }
}

/// <p>Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 buckets from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CriteriaBlockForJob {
    /// <p>An array of conditions, one for each condition that determines which buckets to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
    pub and: std::option::Option<std::vec::Vec<crate::model::CriteriaForJob>>,
}
impl CriteriaBlockForJob {
    /// <p>An array of conditions, one for each condition that determines which buckets to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
    pub fn and(&self) -> std::option::Option<&[crate::model::CriteriaForJob]> {
        self.and.as_deref()
    }
}
impl std::fmt::Debug for CriteriaBlockForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CriteriaBlockForJob");
        formatter.field("and", &self.and);
        formatter.finish()
    }
}
/// See [`CriteriaBlockForJob`](crate::model::CriteriaBlockForJob)
pub mod criteria_block_for_job {
    /// A builder for [`CriteriaBlockForJob`](crate::model::CriteriaBlockForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) and: std::option::Option<std::vec::Vec<crate::model::CriteriaForJob>>,
    }
    impl Builder {
        /// Appends an item to `and`.
        ///
        /// To override the contents of this collection use [`set_and`](Self::set_and).
        ///
        /// <p>An array of conditions, one for each condition that determines which buckets to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
        pub fn and(mut self, input: crate::model::CriteriaForJob) -> Self {
            let mut v = self.and.unwrap_or_default();
            v.push(input);
            self.and = Some(v);
            self
        }
        /// <p>An array of conditions, one for each condition that determines which buckets to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CriteriaForJob>>,
        ) -> Self {
            self.and = input;
            self
        }
        /// Consumes the builder and constructs a [`CriteriaBlockForJob`](crate::model::CriteriaBlockForJob)
        pub fn build(self) -> crate::model::CriteriaBlockForJob {
            crate::model::CriteriaBlockForJob { and: self.and }
        }
    }
}
impl CriteriaBlockForJob {
    /// Creates a new builder-style object to manufacture [`CriteriaBlockForJob`](crate::model::CriteriaBlockForJob)
    pub fn builder() -> crate::model::criteria_block_for_job::Builder {
        crate::model::criteria_block_for_job::Builder::default()
    }
}

/// <p>Specifies a property- or tag-based condition that defines criteria for including or excluding S3 buckets from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CriteriaForJob {
    /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding buckets from the job.</p>
    pub simple_criterion: std::option::Option<crate::model::SimpleCriterionForJob>,
    /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding buckets from the job.</p>
    pub tag_criterion: std::option::Option<crate::model::TagCriterionForJob>,
}
impl CriteriaForJob {
    /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding buckets from the job.</p>
    pub fn simple_criterion(&self) -> std::option::Option<&crate::model::SimpleCriterionForJob> {
        self.simple_criterion.as_ref()
    }
    /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding buckets from the job.</p>
    pub fn tag_criterion(&self) -> std::option::Option<&crate::model::TagCriterionForJob> {
        self.tag_criterion.as_ref()
    }
}
impl std::fmt::Debug for CriteriaForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CriteriaForJob");
        formatter.field("simple_criterion", &self.simple_criterion);
        formatter.field("tag_criterion", &self.tag_criterion);
        formatter.finish()
    }
}
/// See [`CriteriaForJob`](crate::model::CriteriaForJob)
pub mod criteria_for_job {
    /// A builder for [`CriteriaForJob`](crate::model::CriteriaForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple_criterion: std::option::Option<crate::model::SimpleCriterionForJob>,
        pub(crate) tag_criterion: std::option::Option<crate::model::TagCriterionForJob>,
    }
    impl Builder {
        /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding buckets from the job.</p>
        pub fn simple_criterion(mut self, input: crate::model::SimpleCriterionForJob) -> Self {
            self.simple_criterion = Some(input);
            self
        }
        /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding buckets from the job.</p>
        pub fn set_simple_criterion(
            mut self,
            input: std::option::Option<crate::model::SimpleCriterionForJob>,
        ) -> Self {
            self.simple_criterion = input;
            self
        }
        /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding buckets from the job.</p>
        pub fn tag_criterion(mut self, input: crate::model::TagCriterionForJob) -> Self {
            self.tag_criterion = Some(input);
            self
        }
        /// <p>A tag-based condition that defines an operator and tag keys, tag values, or tag key and value pairs for including or excluding buckets from the job.</p>
        pub fn set_tag_criterion(
            mut self,
            input: std::option::Option<crate::model::TagCriterionForJob>,
        ) -> Self {
            self.tag_criterion = input;
            self
        }
        /// Consumes the builder and constructs a [`CriteriaForJob`](crate::model::CriteriaForJob)
        pub fn build(self) -> crate::model::CriteriaForJob {
            crate::model::CriteriaForJob {
                simple_criterion: self.simple_criterion,
                tag_criterion: self.tag_criterion,
            }
        }
    }
}
impl CriteriaForJob {
    /// Creates a new builder-style object to manufacture [`CriteriaForJob`](crate::model::CriteriaForJob)
    pub fn builder() -> crate::model::criteria_for_job::Builder {
        crate::model::criteria_for_job::Builder::default()
    }
}

/// <p>Specifies a tag-based condition that determines whether an S3 bucket is included or excluded from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagCriterionForJob {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub comparator: std::option::Option<crate::model::JobComparator>,
    /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
    pub tag_values: std::option::Option<std::vec::Vec<crate::model::TagCriterionPairForJob>>,
}
impl TagCriterionForJob {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::JobComparator> {
        self.comparator.as_ref()
    }
    /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
    pub fn tag_values(&self) -> std::option::Option<&[crate::model::TagCriterionPairForJob]> {
        self.tag_values.as_deref()
    }
}
impl std::fmt::Debug for TagCriterionForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagCriterionForJob");
        formatter.field("comparator", &self.comparator);
        formatter.field("tag_values", &self.tag_values);
        formatter.finish()
    }
}
/// See [`TagCriterionForJob`](crate::model::TagCriterionForJob)
pub mod tag_criterion_for_job {
    /// A builder for [`TagCriterionForJob`](crate::model::TagCriterionForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::JobComparator>,
        pub(crate) tag_values:
            std::option::Option<std::vec::Vec<crate::model::TagCriterionPairForJob>>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn comparator(mut self, input: crate::model::JobComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::JobComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
        pub fn tag_values(mut self, input: crate::model::TagCriterionPairForJob) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input);
            self.tag_values = Some(v);
            self
        }
        /// <p>The tag keys, tag values, or tag key and value pairs to use in the condition.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagCriterionPairForJob>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// Consumes the builder and constructs a [`TagCriterionForJob`](crate::model::TagCriterionForJob)
        pub fn build(self) -> crate::model::TagCriterionForJob {
            crate::model::TagCriterionForJob {
                comparator: self.comparator,
                tag_values: self.tag_values,
            }
        }
    }
}
impl TagCriterionForJob {
    /// Creates a new builder-style object to manufacture [`TagCriterionForJob`](crate::model::TagCriterionForJob)
    pub fn builder() -> crate::model::tag_criterion_for_job::Builder {
        crate::model::tag_criterion_for_job::Builder::default()
    }
}

/// <p>Specifies a tag key, a tag value, or a tag key and value (as a pair) to use in a tag-based condition that determines whether an S3 bucket is included or excluded from a classification job. Tag keys and values are case sensitive. Also, Amazon Macie doesn't support use of partial values or wildcard characters in tag-based conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagCriterionPairForJob {
    /// <p>The value for the tag key to use in the condition.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value to use in the condition.</p>
    pub value: std::option::Option<std::string::String>,
}
impl TagCriterionPairForJob {
    /// <p>The value for the tag key to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value to use in the condition.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for TagCriterionPairForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagCriterionPairForJob");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TagCriterionPairForJob`](crate::model::TagCriterionPairForJob)
pub mod tag_criterion_pair_for_job {
    /// A builder for [`TagCriterionPairForJob`](crate::model::TagCriterionPairForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value for the tag key to use in the condition.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The value for the tag key to use in the condition.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value to use in the condition.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value to use in the condition.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TagCriterionPairForJob`](crate::model::TagCriterionPairForJob)
        pub fn build(self) -> crate::model::TagCriterionPairForJob {
            crate::model::TagCriterionPairForJob {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl TagCriterionPairForJob {
    /// Creates a new builder-style object to manufacture [`TagCriterionPairForJob`](crate::model::TagCriterionPairForJob)
    pub fn builder() -> crate::model::tag_criterion_pair_for_job::Builder {
        crate::model::tag_criterion_pair_for_job::Builder::default()
    }
}

/// <p>The operator to use in a condition. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobComparator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Gte,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Lte,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    #[allow(missing_docs)] // documentation missing in model
    StartsWith,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobComparator {
    fn from(s: &str) -> Self {
        match s {
            "CONTAINS" => JobComparator::Contains,
            "EQ" => JobComparator::Eq,
            "GT" => JobComparator::Gt,
            "GTE" => JobComparator::Gte,
            "LT" => JobComparator::Lt,
            "LTE" => JobComparator::Lte,
            "NE" => JobComparator::Ne,
            "STARTS_WITH" => JobComparator::StartsWith,
            other => JobComparator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobComparator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobComparator::from(s))
    }
}
impl JobComparator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobComparator::Contains => "CONTAINS",
            JobComparator::Eq => "EQ",
            JobComparator::Gt => "GT",
            JobComparator::Gte => "GTE",
            JobComparator::Lt => "LT",
            JobComparator::Lte => "LTE",
            JobComparator::Ne => "NE",
            JobComparator::StartsWith => "STARTS_WITH",
            JobComparator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "CONTAINS",
            "EQ",
            "GT",
            "GTE",
            "LT",
            "LTE",
            "NE",
            "STARTS_WITH",
        ]
    }
}
impl AsRef<str> for JobComparator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a property-based condition that determines whether an S3 bucket is included or excluded from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimpleCriterionForJob {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub comparator: std::option::Option<crate::model::JobComparator>,
    /// <p>The property to use in the condition.</p>
    pub key: std::option::Option<crate::model::SimpleCriterionKeyForJob>,
    /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.</p></li>
    /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of a bucket.</p></li>
    /// <li><p>S3_BUCKET_NAME - A string that represents the name of a bucket.</p></li>
    /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of a bucket.</p></li>
    /// </ul>
    /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these values.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SimpleCriterionForJob {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::JobComparator> {
        self.comparator.as_ref()
    }
    /// <p>The property to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::SimpleCriterionKeyForJob> {
        self.key.as_ref()
    }
    /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.</p></li>
    /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of a bucket.</p></li>
    /// <li><p>S3_BUCKET_NAME - A string that represents the name of a bucket.</p></li>
    /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of a bucket.</p></li>
    /// </ul>
    /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these values.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for SimpleCriterionForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimpleCriterionForJob");
        formatter.field("comparator", &self.comparator);
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SimpleCriterionForJob`](crate::model::SimpleCriterionForJob)
pub mod simple_criterion_for_job {
    /// A builder for [`SimpleCriterionForJob`](crate::model::SimpleCriterionForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::JobComparator>,
        pub(crate) key: std::option::Option<crate::model::SimpleCriterionKeyForJob>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn comparator(mut self, input: crate::model::JobComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. Valid values are EQ (equals) and NE (not equals).</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::JobComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// <p>The property to use in the condition.</p>
        pub fn key(mut self, input: crate::model::SimpleCriterionKeyForJob) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The property to use in the condition.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::SimpleCriterionKeyForJob>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.</p></li>
        /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of a bucket.</p></li>
        /// <li><p>S3_BUCKET_NAME - A string that represents the name of a bucket.</p></li>
        /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of a bucket.</p></li>
        /// </ul>
        /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these values.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array that lists one or more values to use in the condition. If you specify multiple values, Amazon Macie uses OR logic to join the values. Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>ACCOUNT_ID - A string that represents the unique identifier for the Amazon Web Services account that owns the bucket.</p></li>
        /// <li><p>S3_BUCKET_EFFECTIVE_PERMISSION - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketpublicaccess-effectivepermission">BucketPublicAccess.effectivePermission</a> property of a bucket.</p></li>
        /// <li><p>S3_BUCKET_NAME - A string that represents the name of a bucket.</p></li>
        /// <li><p>S3_BUCKET_SHARED_ACCESS - A string that represents an enumerated value that Macie defines for the <a href="https://docs.aws.amazon.com/macie/latest/APIReference/datasources-s3.html#datasources-s3-prop-bucketmetadata-sharedaccess">BucketMetadata.sharedAccess</a> property of a bucket.</p></li>
        /// </ul>
        /// <p>Values are case sensitive. Also, Macie doesn't support use of partial values or wildcard characters in these values.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SimpleCriterionForJob`](crate::model::SimpleCriterionForJob)
        pub fn build(self) -> crate::model::SimpleCriterionForJob {
            crate::model::SimpleCriterionForJob {
                comparator: self.comparator,
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl SimpleCriterionForJob {
    /// Creates a new builder-style object to manufacture [`SimpleCriterionForJob`](crate::model::SimpleCriterionForJob)
    pub fn builder() -> crate::model::simple_criterion_for_job::Builder {
        crate::model::simple_criterion_for_job::Builder::default()
    }
}

/// <p>The property to use in a condition that determines whether an S3 bucket is included or excluded from a classification job. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SimpleCriterionKeyForJob {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketEffectivePermission,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketName,
    #[allow(missing_docs)] // documentation missing in model
    S3BucketSharedAccess,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SimpleCriterionKeyForJob {
    fn from(s: &str) -> Self {
        match s {
            "ACCOUNT_ID" => SimpleCriterionKeyForJob::AccountId,
            "S3_BUCKET_EFFECTIVE_PERMISSION" => {
                SimpleCriterionKeyForJob::S3BucketEffectivePermission
            }
            "S3_BUCKET_NAME" => SimpleCriterionKeyForJob::S3BucketName,
            "S3_BUCKET_SHARED_ACCESS" => SimpleCriterionKeyForJob::S3BucketSharedAccess,
            other => SimpleCriterionKeyForJob::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SimpleCriterionKeyForJob {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SimpleCriterionKeyForJob::from(s))
    }
}
impl SimpleCriterionKeyForJob {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SimpleCriterionKeyForJob::AccountId => "ACCOUNT_ID",
            SimpleCriterionKeyForJob::S3BucketEffectivePermission => {
                "S3_BUCKET_EFFECTIVE_PERMISSION"
            }
            SimpleCriterionKeyForJob::S3BucketName => "S3_BUCKET_NAME",
            SimpleCriterionKeyForJob::S3BucketSharedAccess => "S3_BUCKET_SHARED_ACCESS",
            SimpleCriterionKeyForJob::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "ACCOUNT_ID",
            "S3_BUCKET_EFFECTIVE_PERMISSION",
            "S3_BUCKET_NAME",
            "S3_BUCKET_SHARED_ACCESS",
        ]
    }
}
impl AsRef<str> for SimpleCriterionKeyForJob {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about when a classification job was paused. For a one-time job, this object also specifies when the job will expire and be cancelled if it isn't resumed. For a recurring job, this object also specifies when the paused job run will expire and be cancelled if it isn't resumed. This object is present only if a job's current status (jobStatus) is USER_PAUSED. The information in this object applies only to a job that was paused while it had a status of RUNNING.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserPausedDetails {
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.</p>
    pub job_expires_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.</p>
    pub job_imminent_expiration_health_event_arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when you paused the job.</p>
    pub job_paused_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl UserPausedDetails {
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.</p>
    pub fn job_expires_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_expires_at.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.</p>
    pub fn job_imminent_expiration_health_event_arn(&self) -> std::option::Option<&str> {
        self.job_imminent_expiration_health_event_arn.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when you paused the job.</p>
    pub fn job_paused_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.job_paused_at.as_ref()
    }
}
impl std::fmt::Debug for UserPausedDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserPausedDetails");
        formatter.field("job_expires_at", &self.job_expires_at);
        formatter.field(
            "job_imminent_expiration_health_event_arn",
            &self.job_imminent_expiration_health_event_arn,
        );
        formatter.field("job_paused_at", &self.job_paused_at);
        formatter.finish()
    }
}
/// See [`UserPausedDetails`](crate::model::UserPausedDetails)
pub mod user_paused_details {
    /// A builder for [`UserPausedDetails`](crate::model::UserPausedDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_expires_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) job_imminent_expiration_health_event_arn:
            std::option::Option<std::string::String>,
        pub(crate) job_paused_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.</p>
        pub fn job_expires_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_expires_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the job or job run will expire and be cancelled if you don't resume it first.</p>
        pub fn set_job_expires_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_expires_at = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.</p>
        pub fn job_imminent_expiration_health_event_arn(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.job_imminent_expiration_health_event_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the Health event that Amazon Macie sent to notify you of the job or job run's pending expiration and cancellation. This value is null if a job has been paused for less than 23 days.</p>
        pub fn set_job_imminent_expiration_health_event_arn(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.job_imminent_expiration_health_event_arn = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when you paused the job.</p>
        pub fn job_paused_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.job_paused_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when you paused the job.</p>
        pub fn set_job_paused_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.job_paused_at = input;
            self
        }
        /// Consumes the builder and constructs a [`UserPausedDetails`](crate::model::UserPausedDetails)
        pub fn build(self) -> crate::model::UserPausedDetails {
            crate::model::UserPausedDetails {
                job_expires_at: self.job_expires_at,
                job_imminent_expiration_health_event_arn: self
                    .job_imminent_expiration_health_event_arn,
                job_paused_at: self.job_paused_at,
            }
        }
    }
}
impl UserPausedDetails {
    /// Creates a new builder-style object to manufacture [`UserPausedDetails`](crate::model::UserPausedDetails)
    pub fn builder() -> crate::model::user_paused_details::Builder {
        crate::model::user_paused_details::Builder::default()
    }
}

/// <p>Specifies whether any account- or bucket-level access errors occurred when a classification job ran. For information about using logging data to investigate these errors, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-jobs-monitor-cw-logs.html">Monitoring sensitive data discovery jobs</a> in the <i>Amazon Macie User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LastRunErrorStatus {
    /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run. Possible values are:</p>
    /// <ul>
    /// <li><p>ERROR - One or more errors occurred. Amazon Macie didn't process all the data specified for the job.</p></li>
    /// <li><p>NONE - No errors occurred. Macie processed all the data specified for the job.</p></li>
    /// </ul>
    pub code: std::option::Option<crate::model::LastRunErrorStatusCode>,
}
impl LastRunErrorStatus {
    /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run. Possible values are:</p>
    /// <ul>
    /// <li><p>ERROR - One or more errors occurred. Amazon Macie didn't process all the data specified for the job.</p></li>
    /// <li><p>NONE - No errors occurred. Macie processed all the data specified for the job.</p></li>
    /// </ul>
    pub fn code(&self) -> std::option::Option<&crate::model::LastRunErrorStatusCode> {
        self.code.as_ref()
    }
}
impl std::fmt::Debug for LastRunErrorStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LastRunErrorStatus");
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
/// See [`LastRunErrorStatus`](crate::model::LastRunErrorStatus)
pub mod last_run_error_status {
    /// A builder for [`LastRunErrorStatus`](crate::model::LastRunErrorStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<crate::model::LastRunErrorStatusCode>,
    }
    impl Builder {
        /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run. Possible values are:</p>
        /// <ul>
        /// <li><p>ERROR - One or more errors occurred. Amazon Macie didn't process all the data specified for the job.</p></li>
        /// <li><p>NONE - No errors occurred. Macie processed all the data specified for the job.</p></li>
        /// </ul>
        pub fn code(mut self, input: crate::model::LastRunErrorStatusCode) -> Self {
            self.code = Some(input);
            self
        }
        /// <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run. Possible values are:</p>
        /// <ul>
        /// <li><p>ERROR - One or more errors occurred. Amazon Macie didn't process all the data specified for the job.</p></li>
        /// <li><p>NONE - No errors occurred. Macie processed all the data specified for the job.</p></li>
        /// </ul>
        pub fn set_code(
            mut self,
            input: std::option::Option<crate::model::LastRunErrorStatusCode>,
        ) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`LastRunErrorStatus`](crate::model::LastRunErrorStatus)
        pub fn build(self) -> crate::model::LastRunErrorStatus {
            crate::model::LastRunErrorStatus { code: self.code }
        }
    }
}
impl LastRunErrorStatus {
    /// Creates a new builder-style object to manufacture [`LastRunErrorStatus`](crate::model::LastRunErrorStatus)
    pub fn builder() -> crate::model::last_run_error_status::Builder {
        crate::model::last_run_error_status::Builder::default()
    }
}

/// <p>Specifies whether any account- or bucket-level access errors occurred during the run of a one-time classification job or the most recent run of a recurring classification job. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum LastRunErrorStatusCode {
    #[allow(missing_docs)] // documentation missing in model
    Error,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for LastRunErrorStatusCode {
    fn from(s: &str) -> Self {
        match s {
            "ERROR" => LastRunErrorStatusCode::Error,
            "NONE" => LastRunErrorStatusCode::None,
            other => LastRunErrorStatusCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for LastRunErrorStatusCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(LastRunErrorStatusCode::from(s))
    }
}
impl LastRunErrorStatusCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            LastRunErrorStatusCode::Error => "ERROR",
            LastRunErrorStatusCode::None => "NONE",
            LastRunErrorStatusCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ERROR", "NONE"]
    }
}
impl AsRef<str> for LastRunErrorStatusCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The schedule for running a classification job. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum JobType {
    #[allow(missing_docs)] // documentation missing in model
    OneTime,
    #[allow(missing_docs)] // documentation missing in model
    Scheduled,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for JobType {
    fn from(s: &str) -> Self {
        match s {
            "ONE_TIME" => JobType::OneTime,
            "SCHEDULED" => JobType::Scheduled,
            other => JobType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for JobType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(JobType::from(s))
    }
}
impl JobType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            JobType::OneTime => "ONE_TIME",
            JobType::Scheduled => "SCHEDULED",
            JobType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ONE_TIME", "SCHEDULED"]
    }
}
impl AsRef<str> for JobType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies an Amazon Web Services account that owns S3 buckets for a classification job to analyze, and one or more specific buckets to analyze for that account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketDefinitionForJob {
    /// <p>The unique identifier for the Amazon Web Services account that owns the buckets.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>An array that lists the names of the buckets.</p>
    pub buckets: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl S3BucketDefinitionForJob {
    /// <p>The unique identifier for the Amazon Web Services account that owns the buckets.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>An array that lists the names of the buckets.</p>
    pub fn buckets(&self) -> std::option::Option<&[std::string::String]> {
        self.buckets.as_deref()
    }
}
impl std::fmt::Debug for S3BucketDefinitionForJob {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketDefinitionForJob");
        formatter.field("account_id", &self.account_id);
        formatter.field("buckets", &self.buckets);
        formatter.finish()
    }
}
/// See [`S3BucketDefinitionForJob`](crate::model::S3BucketDefinitionForJob)
pub mod s3_bucket_definition_for_job {
    /// A builder for [`S3BucketDefinitionForJob`](crate::model::S3BucketDefinitionForJob)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) buckets: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that owns the buckets.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the buckets.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Appends an item to `buckets`.
        ///
        /// To override the contents of this collection use [`set_buckets`](Self::set_buckets).
        ///
        /// <p>An array that lists the names of the buckets.</p>
        pub fn buckets(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.buckets.unwrap_or_default();
            v.push(input.into());
            self.buckets = Some(v);
            self
        }
        /// <p>An array that lists the names of the buckets.</p>
        pub fn set_buckets(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketDefinitionForJob`](crate::model::S3BucketDefinitionForJob)
        pub fn build(self) -> crate::model::S3BucketDefinitionForJob {
            crate::model::S3BucketDefinitionForJob {
                account_id: self.account_id,
                buckets: self.buckets,
            }
        }
    }
}
impl S3BucketDefinitionForJob {
    /// Creates a new builder-style object to manufacture [`S3BucketDefinitionForJob`](crate::model::S3BucketDefinitionForJob)
    pub fn builder() -> crate::model::s3_bucket_definition_for_job::Builder {
        crate::model::s3_bucket_definition_for_job::Builder::default()
    }
}

/// <p>Specifies criteria for sorting the results of a request for information about classification jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsSortCriteria {
    /// <p>The property to sort the results by.</p>
    pub attribute_name: std::option::Option<crate::model::ListJobsSortAttributeName>,
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl ListJobsSortCriteria {
    /// <p>The property to sort the results by.</p>
    pub fn attribute_name(&self) -> std::option::Option<&crate::model::ListJobsSortAttributeName> {
        self.attribute_name.as_ref()
    }
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::OrderBy> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for ListJobsSortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsSortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`ListJobsSortCriteria`](crate::model::ListJobsSortCriteria)
pub mod list_jobs_sort_criteria {
    /// A builder for [`ListJobsSortCriteria`](crate::model::ListJobsSortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<crate::model::ListJobsSortAttributeName>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The property to sort the results by.</p>
        pub fn attribute_name(mut self, input: crate::model::ListJobsSortAttributeName) -> Self {
            self.attribute_name = Some(input);
            self
        }
        /// <p>The property to sort the results by.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<crate::model::ListJobsSortAttributeName>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsSortCriteria`](crate::model::ListJobsSortCriteria)
        pub fn build(self) -> crate::model::ListJobsSortCriteria {
            crate::model::ListJobsSortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl ListJobsSortCriteria {
    /// Creates a new builder-style object to manufacture [`ListJobsSortCriteria`](crate::model::ListJobsSortCriteria)
    pub fn builder() -> crate::model::list_jobs_sort_criteria::Builder {
        crate::model::list_jobs_sort_criteria::Builder::default()
    }
}

/// <p>The property to sort the results by. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ListJobsSortAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    CreatedAt,
    #[allow(missing_docs)] // documentation missing in model
    JobStatus,
    #[allow(missing_docs)] // documentation missing in model
    JobType,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ListJobsSortAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "createdAt" => ListJobsSortAttributeName::CreatedAt,
            "jobStatus" => ListJobsSortAttributeName::JobStatus,
            "jobType" => ListJobsSortAttributeName::JobType,
            "name" => ListJobsSortAttributeName::Name,
            other => ListJobsSortAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ListJobsSortAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ListJobsSortAttributeName::from(s))
    }
}
impl ListJobsSortAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ListJobsSortAttributeName::CreatedAt => "createdAt",
            ListJobsSortAttributeName::JobStatus => "jobStatus",
            ListJobsSortAttributeName::JobType => "jobType",
            ListJobsSortAttributeName::Name => "name",
            ListJobsSortAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["createdAt", "jobStatus", "jobType", "name"]
    }
}
impl AsRef<str> for ListJobsSortAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies criteria for filtering the results of a request for information about classification jobs.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsFilterCriteria {
    /// <p>An array of objects, one for each condition that determines which jobs to exclude from the results.</p>
    pub excludes: std::option::Option<std::vec::Vec<crate::model::ListJobsFilterTerm>>,
    /// <p>An array of objects, one for each condition that determines which jobs to include in the results.</p>
    pub includes: std::option::Option<std::vec::Vec<crate::model::ListJobsFilterTerm>>,
}
impl ListJobsFilterCriteria {
    /// <p>An array of objects, one for each condition that determines which jobs to exclude from the results.</p>
    pub fn excludes(&self) -> std::option::Option<&[crate::model::ListJobsFilterTerm]> {
        self.excludes.as_deref()
    }
    /// <p>An array of objects, one for each condition that determines which jobs to include in the results.</p>
    pub fn includes(&self) -> std::option::Option<&[crate::model::ListJobsFilterTerm]> {
        self.includes.as_deref()
    }
}
impl std::fmt::Debug for ListJobsFilterCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsFilterCriteria");
        formatter.field("excludes", &self.excludes);
        formatter.field("includes", &self.includes);
        formatter.finish()
    }
}
/// See [`ListJobsFilterCriteria`](crate::model::ListJobsFilterCriteria)
pub mod list_jobs_filter_criteria {
    /// A builder for [`ListJobsFilterCriteria`](crate::model::ListJobsFilterCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) excludes: std::option::Option<std::vec::Vec<crate::model::ListJobsFilterTerm>>,
        pub(crate) includes: std::option::Option<std::vec::Vec<crate::model::ListJobsFilterTerm>>,
    }
    impl Builder {
        /// Appends an item to `excludes`.
        ///
        /// To override the contents of this collection use [`set_excludes`](Self::set_excludes).
        ///
        /// <p>An array of objects, one for each condition that determines which jobs to exclude from the results.</p>
        pub fn excludes(mut self, input: crate::model::ListJobsFilterTerm) -> Self {
            let mut v = self.excludes.unwrap_or_default();
            v.push(input);
            self.excludes = Some(v);
            self
        }
        /// <p>An array of objects, one for each condition that determines which jobs to exclude from the results.</p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListJobsFilterTerm>>,
        ) -> Self {
            self.excludes = input;
            self
        }
        /// Appends an item to `includes`.
        ///
        /// To override the contents of this collection use [`set_includes`](Self::set_includes).
        ///
        /// <p>An array of objects, one for each condition that determines which jobs to include in the results.</p>
        pub fn includes(mut self, input: crate::model::ListJobsFilterTerm) -> Self {
            let mut v = self.includes.unwrap_or_default();
            v.push(input);
            self.includes = Some(v);
            self
        }
        /// <p>An array of objects, one for each condition that determines which jobs to include in the results.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ListJobsFilterTerm>>,
        ) -> Self {
            self.includes = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsFilterCriteria`](crate::model::ListJobsFilterCriteria)
        pub fn build(self) -> crate::model::ListJobsFilterCriteria {
            crate::model::ListJobsFilterCriteria {
                excludes: self.excludes,
                includes: self.includes,
            }
        }
    }
}
impl ListJobsFilterCriteria {
    /// Creates a new builder-style object to manufacture [`ListJobsFilterCriteria`](crate::model::ListJobsFilterCriteria)
    pub fn builder() -> crate::model::list_jobs_filter_criteria::Builder {
        crate::model::list_jobs_filter_criteria::Builder::default()
    }
}

/// <p>Specifies a condition that filters the results of a request for information about classification jobs. Each condition consists of a property, an operator, and one or more values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListJobsFilterTerm {
    /// <p>The operator to use to filter the results.</p>
    pub comparator: std::option::Option<crate::model::JobComparator>,
    /// <p>The property to use to filter the results.</p>
    pub key: std::option::Option<crate::model::ListJobsFilterKey>,
    /// <p>An array that lists one or more values to use to filter the results.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ListJobsFilterTerm {
    /// <p>The operator to use to filter the results.</p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::JobComparator> {
        self.comparator.as_ref()
    }
    /// <p>The property to use to filter the results.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::ListJobsFilterKey> {
        self.key.as_ref()
    }
    /// <p>An array that lists one or more values to use to filter the results.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for ListJobsFilterTerm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListJobsFilterTerm");
        formatter.field("comparator", &self.comparator);
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`ListJobsFilterTerm`](crate::model::ListJobsFilterTerm)
pub mod list_jobs_filter_term {
    /// A builder for [`ListJobsFilterTerm`](crate::model::ListJobsFilterTerm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::JobComparator>,
        pub(crate) key: std::option::Option<crate::model::ListJobsFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The operator to use to filter the results.</p>
        pub fn comparator(mut self, input: crate::model::JobComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use to filter the results.</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::JobComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// <p>The property to use to filter the results.</p>
        pub fn key(mut self, input: crate::model::ListJobsFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The property to use to filter the results.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::ListJobsFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array that lists one or more values to use to filter the results.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array that lists one or more values to use to filter the results.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`ListJobsFilterTerm`](crate::model::ListJobsFilterTerm)
        pub fn build(self) -> crate::model::ListJobsFilterTerm {
            crate::model::ListJobsFilterTerm {
                comparator: self.comparator,
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl ListJobsFilterTerm {
    /// Creates a new builder-style object to manufacture [`ListJobsFilterTerm`](crate::model::ListJobsFilterTerm)
    pub fn builder() -> crate::model::list_jobs_filter_term::Builder {
        crate::model::list_jobs_filter_term::Builder::default()
    }
}

/// <p>The property to use to filter the results. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ListJobsFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    CreatedAt,
    #[allow(missing_docs)] // documentation missing in model
    JobStatus,
    #[allow(missing_docs)] // documentation missing in model
    JobType,
    #[allow(missing_docs)] // documentation missing in model
    Name,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ListJobsFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "createdAt" => ListJobsFilterKey::CreatedAt,
            "jobStatus" => ListJobsFilterKey::JobStatus,
            "jobType" => ListJobsFilterKey::JobType,
            "name" => ListJobsFilterKey::Name,
            other => ListJobsFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ListJobsFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ListJobsFilterKey::from(s))
    }
}
impl ListJobsFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ListJobsFilterKey::CreatedAt => "createdAt",
            ListJobsFilterKey::JobStatus => "jobStatus",
            ListJobsFilterKey::JobType => "jobType",
            ListJobsFilterKey::Name => "name",
            ListJobsFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["createdAt", "jobStatus", "jobType", "name"]
    }
}
impl AsRef<str> for ListJobsFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides aggregated data for an Amazon Macie usage metric. The value for the metric reports estimated usage data for an account for the preceding 30 days or the current calendar month to date, depending on the time period (timeRange) specified in the request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageTotal {
    /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
    pub currency: std::option::Option<crate::model::Currency>,
    /// <p>The estimated value for the metric.</p>
    pub estimated_cost: std::option::Option<std::string::String>,
    /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
    pub r#type: std::option::Option<crate::model::UsageType>,
}
impl UsageTotal {
    /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
    pub fn currency(&self) -> std::option::Option<&crate::model::Currency> {
        self.currency.as_ref()
    }
    /// <p>The estimated value for the metric.</p>
    pub fn estimated_cost(&self) -> std::option::Option<&str> {
        self.estimated_cost.as_deref()
    }
    /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UsageType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UsageTotal {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageTotal");
        formatter.field("currency", &self.currency);
        formatter.field("estimated_cost", &self.estimated_cost);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`UsageTotal`](crate::model::UsageTotal)
pub mod usage_total {
    /// A builder for [`UsageTotal`](crate::model::UsageTotal)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) currency: std::option::Option<crate::model::Currency>,
        pub(crate) estimated_cost: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::UsageType>,
    }
    impl Builder {
        /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
        pub fn currency(mut self, input: crate::model::Currency) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
        pub fn set_currency(mut self, input: std::option::Option<crate::model::Currency>) -> Self {
            self.currency = input;
            self
        }
        /// <p>The estimated value for the metric.</p>
        pub fn estimated_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_cost = Some(input.into());
            self
        }
        /// <p>The estimated value for the metric.</p>
        pub fn set_estimated_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_cost = input;
            self
        }
        /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
        pub fn r#type(mut self, input: crate::model::UsageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UsageType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageTotal`](crate::model::UsageTotal)
        pub fn build(self) -> crate::model::UsageTotal {
            crate::model::UsageTotal {
                currency: self.currency,
                estimated_cost: self.estimated_cost,
                r#type: self.r#type,
            }
        }
    }
}
impl UsageTotal {
    /// Creates a new builder-style object to manufacture [`UsageTotal`](crate::model::UsageTotal)
    pub fn builder() -> crate::model::usage_total::Builder {
        crate::model::usage_total::Builder::default()
    }
}

/// <p>The name of an Amazon Macie usage metric for an account. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageType {
    #[allow(missing_docs)] // documentation missing in model
    DataInventoryEvaluation,
    #[allow(missing_docs)] // documentation missing in model
    SensitiveDataDiscovery,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageType {
    fn from(s: &str) -> Self {
        match s {
            "DATA_INVENTORY_EVALUATION" => UsageType::DataInventoryEvaluation,
            "SENSITIVE_DATA_DISCOVERY" => UsageType::SensitiveDataDiscovery,
            other => UsageType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageType::from(s))
    }
}
impl UsageType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageType::DataInventoryEvaluation => "DATA_INVENTORY_EVALUATION",
            UsageType::SensitiveDataDiscovery => "SENSITIVE_DATA_DISCOVERY",
            UsageType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["DATA_INVENTORY_EVALUATION", "SENSITIVE_DATA_DISCOVERY"]
    }
}
impl AsRef<str> for UsageType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The type of currency that the data for an Amazon Macie usage metric is reported in. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Currency {
    #[allow(missing_docs)] // documentation missing in model
    Usd,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Currency {
    fn from(s: &str) -> Self {
        match s {
            "USD" => Currency::Usd,
            other => Currency::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Currency {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Currency::from(s))
    }
}
impl Currency {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Currency::Usd => "USD",
            Currency::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["USD"]
    }
}
impl AsRef<str> for Currency {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>An inclusive time period that Amazon Macie usage data applies to. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TimeRange {
    #[allow(missing_docs)] // documentation missing in model
    MonthToDate,
    #[allow(missing_docs)] // documentation missing in model
    Past30Days,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TimeRange {
    fn from(s: &str) -> Self {
        match s {
            "MONTH_TO_DATE" => TimeRange::MonthToDate,
            "PAST_30_DAYS" => TimeRange::Past30Days,
            other => TimeRange::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TimeRange {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TimeRange::from(s))
    }
}
impl TimeRange {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TimeRange::MonthToDate => "MONTH_TO_DATE",
            TimeRange::Past30Days => "PAST_30_DAYS",
            TimeRange::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["MONTH_TO_DATE", "PAST_30_DAYS"]
    }
}
impl AsRef<str> for TimeRange {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides quota and aggregated usage data for an Amazon Macie account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageRecord {
    /// <p>The unique identifier for the Amazon Web Services account that the data applies to.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.</p>
    pub free_trial_start_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.</p>
    pub usage: std::option::Option<std::vec::Vec<crate::model::UsageByAccount>>,
}
impl UsageRecord {
    /// <p>The unique identifier for the Amazon Web Services account that the data applies to.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.</p>
    pub fn free_trial_start_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.free_trial_start_date.as_ref()
    }
    /// <p>An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.</p>
    pub fn usage(&self) -> std::option::Option<&[crate::model::UsageByAccount]> {
        self.usage.as_deref()
    }
}
impl std::fmt::Debug for UsageRecord {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageRecord");
        formatter.field("account_id", &self.account_id);
        formatter.field("free_trial_start_date", &self.free_trial_start_date);
        formatter.field("usage", &self.usage);
        formatter.finish()
    }
}
/// See [`UsageRecord`](crate::model::UsageRecord)
pub mod usage_record {
    /// A builder for [`UsageRecord`](crate::model::UsageRecord)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) free_trial_start_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) usage: std::option::Option<std::vec::Vec<crate::model::UsageByAccount>>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that the data applies to.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that the data applies to.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.</p>
        pub fn free_trial_start_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.free_trial_start_date = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the free trial started for the account.</p>
        pub fn set_free_trial_start_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.free_trial_start_date = input;
            self
        }
        /// Appends an item to `usage`.
        ///
        /// To override the contents of this collection use [`set_usage`](Self::set_usage).
        ///
        /// <p>An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.</p>
        pub fn usage(mut self, input: crate::model::UsageByAccount) -> Self {
            let mut v = self.usage.unwrap_or_default();
            v.push(input);
            self.usage = Some(v);
            self
        }
        /// <p>An array of objects that contains usage data and quotas for the account. Each object contains the data for a specific usage metric and the corresponding quota.</p>
        pub fn set_usage(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageByAccount>>,
        ) -> Self {
            self.usage = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageRecord`](crate::model::UsageRecord)
        pub fn build(self) -> crate::model::UsageRecord {
            crate::model::UsageRecord {
                account_id: self.account_id,
                free_trial_start_date: self.free_trial_start_date,
                usage: self.usage,
            }
        }
    }
}
impl UsageRecord {
    /// Creates a new builder-style object to manufacture [`UsageRecord`](crate::model::UsageRecord)
    pub fn builder() -> crate::model::usage_record::Builder {
        crate::model::usage_record::Builder::default()
    }
}

/// <p>Provides data for a specific usage metric and the corresponding quota for an Amazon Macie account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageByAccount {
    /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
    pub currency: std::option::Option<crate::model::Currency>,
    /// <p>The estimated value for the metric.</p>
    pub estimated_cost: std::option::Option<std::string::String>,
    /// <p>The current value for the quota that corresponds to the metric specified by the type field.</p>
    pub service_limit: std::option::Option<crate::model::ServiceLimit>,
    /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
    pub r#type: std::option::Option<crate::model::UsageType>,
}
impl UsageByAccount {
    /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
    pub fn currency(&self) -> std::option::Option<&crate::model::Currency> {
        self.currency.as_ref()
    }
    /// <p>The estimated value for the metric.</p>
    pub fn estimated_cost(&self) -> std::option::Option<&str> {
        self.estimated_cost.as_deref()
    }
    /// <p>The current value for the quota that corresponds to the metric specified by the type field.</p>
    pub fn service_limit(&self) -> std::option::Option<&crate::model::ServiceLimit> {
        self.service_limit.as_ref()
    }
    /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UsageType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UsageByAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageByAccount");
        formatter.field("currency", &self.currency);
        formatter.field("estimated_cost", &self.estimated_cost);
        formatter.field("service_limit", &self.service_limit);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`UsageByAccount`](crate::model::UsageByAccount)
pub mod usage_by_account {
    /// A builder for [`UsageByAccount`](crate::model::UsageByAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) currency: std::option::Option<crate::model::Currency>,
        pub(crate) estimated_cost: std::option::Option<std::string::String>,
        pub(crate) service_limit: std::option::Option<crate::model::ServiceLimit>,
        pub(crate) r#type: std::option::Option<crate::model::UsageType>,
    }
    impl Builder {
        /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
        pub fn currency(mut self, input: crate::model::Currency) -> Self {
            self.currency = Some(input);
            self
        }
        /// <p>The type of currency that the value for the metric (estimatedCost) is reported in.</p>
        pub fn set_currency(mut self, input: std::option::Option<crate::model::Currency>) -> Self {
            self.currency = input;
            self
        }
        /// <p>The estimated value for the metric.</p>
        pub fn estimated_cost(mut self, input: impl Into<std::string::String>) -> Self {
            self.estimated_cost = Some(input.into());
            self
        }
        /// <p>The estimated value for the metric.</p>
        pub fn set_estimated_cost(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.estimated_cost = input;
            self
        }
        /// <p>The current value for the quota that corresponds to the metric specified by the type field.</p>
        pub fn service_limit(mut self, input: crate::model::ServiceLimit) -> Self {
            self.service_limit = Some(input);
            self
        }
        /// <p>The current value for the quota that corresponds to the metric specified by the type field.</p>
        pub fn set_service_limit(
            mut self,
            input: std::option::Option<crate::model::ServiceLimit>,
        ) -> Self {
            self.service_limit = input;
            self
        }
        /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
        pub fn r#type(mut self, input: crate::model::UsageType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION, for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing S3 objects to detect sensitive data.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::UsageType>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageByAccount`](crate::model::UsageByAccount)
        pub fn build(self) -> crate::model::UsageByAccount {
            crate::model::UsageByAccount {
                currency: self.currency,
                estimated_cost: self.estimated_cost,
                service_limit: self.service_limit,
                r#type: self.r#type,
            }
        }
    }
}
impl UsageByAccount {
    /// Creates a new builder-style object to manufacture [`UsageByAccount`](crate::model::UsageByAccount)
    pub fn builder() -> crate::model::usage_by_account::Builder {
        crate::model::usage_by_account::Builder::default()
    }
}

/// <p>Specifies a current quota for an Amazon Macie account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceLimit {
    /// <p>Specifies whether the account has met the quota that corresponds to the metric specified by the UsageByAccount.type field in the response.</p>
    pub is_service_limited: bool,
    /// <p>The unit of measurement for the value specified by the value field.</p>
    pub unit: std::option::Option<crate::model::Unit>,
    /// <p>The value for the metric specified by the UsageByAccount.type field in the response.</p>
    pub value: i64,
}
impl ServiceLimit {
    /// <p>Specifies whether the account has met the quota that corresponds to the metric specified by the UsageByAccount.type field in the response.</p>
    pub fn is_service_limited(&self) -> bool {
        self.is_service_limited
    }
    /// <p>The unit of measurement for the value specified by the value field.</p>
    pub fn unit(&self) -> std::option::Option<&crate::model::Unit> {
        self.unit.as_ref()
    }
    /// <p>The value for the metric specified by the UsageByAccount.type field in the response.</p>
    pub fn value(&self) -> i64 {
        self.value
    }
}
impl std::fmt::Debug for ServiceLimit {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceLimit");
        formatter.field("is_service_limited", &self.is_service_limited);
        formatter.field("unit", &self.unit);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`ServiceLimit`](crate::model::ServiceLimit)
pub mod service_limit {
    /// A builder for [`ServiceLimit`](crate::model::ServiceLimit)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) is_service_limited: std::option::Option<bool>,
        pub(crate) unit: std::option::Option<crate::model::Unit>,
        pub(crate) value: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Specifies whether the account has met the quota that corresponds to the metric specified by the UsageByAccount.type field in the response.</p>
        pub fn is_service_limited(mut self, input: bool) -> Self {
            self.is_service_limited = Some(input);
            self
        }
        /// <p>Specifies whether the account has met the quota that corresponds to the metric specified by the UsageByAccount.type field in the response.</p>
        pub fn set_is_service_limited(mut self, input: std::option::Option<bool>) -> Self {
            self.is_service_limited = input;
            self
        }
        /// <p>The unit of measurement for the value specified by the value field.</p>
        pub fn unit(mut self, input: crate::model::Unit) -> Self {
            self.unit = Some(input);
            self
        }
        /// <p>The unit of measurement for the value specified by the value field.</p>
        pub fn set_unit(mut self, input: std::option::Option<crate::model::Unit>) -> Self {
            self.unit = input;
            self
        }
        /// <p>The value for the metric specified by the UsageByAccount.type field in the response.</p>
        pub fn value(mut self, input: i64) -> Self {
            self.value = Some(input);
            self
        }
        /// <p>The value for the metric specified by the UsageByAccount.type field in the response.</p>
        pub fn set_value(mut self, input: std::option::Option<i64>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceLimit`](crate::model::ServiceLimit)
        pub fn build(self) -> crate::model::ServiceLimit {
            crate::model::ServiceLimit {
                is_service_limited: self.is_service_limited.unwrap_or_default(),
                unit: self.unit,
                value: self.value.unwrap_or_default(),
            }
        }
    }
}
impl ServiceLimit {
    /// Creates a new builder-style object to manufacture [`ServiceLimit`](crate::model::ServiceLimit)
    pub fn builder() -> crate::model::service_limit::Builder {
        crate::model::service_limit::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Unit {
    #[allow(missing_docs)] // documentation missing in model
    Terabytes,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Unit {
    fn from(s: &str) -> Self {
        match s {
            "TERABYTES" => Unit::Terabytes,
            other => Unit::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Unit {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Unit::from(s))
    }
}
impl Unit {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Unit::Terabytes => "TERABYTES",
            Unit::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["TERABYTES"]
    }
}
impl AsRef<str> for Unit {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies criteria for sorting the results of a query for Amazon Macie account quotas and usage data.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageStatisticsSortBy {
    /// <p>The field to sort the results by.</p>
    pub key: std::option::Option<crate::model::UsageStatisticsSortKey>,
    /// <p>The sort order to apply to the results, based on the value for the field specified by the key property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl UsageStatisticsSortBy {
    /// <p>The field to sort the results by.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::UsageStatisticsSortKey> {
        self.key.as_ref()
    }
    /// <p>The sort order to apply to the results, based on the value for the field specified by the key property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::OrderBy> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for UsageStatisticsSortBy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageStatisticsSortBy");
        formatter.field("key", &self.key);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`UsageStatisticsSortBy`](crate::model::UsageStatisticsSortBy)
pub mod usage_statistics_sort_by {
    /// A builder for [`UsageStatisticsSortBy`](crate::model::UsageStatisticsSortBy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<crate::model::UsageStatisticsSortKey>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The field to sort the results by.</p>
        pub fn key(mut self, input: crate::model::UsageStatisticsSortKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The field to sort the results by.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticsSortKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the field specified by the key property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the field specified by the key property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageStatisticsSortBy`](crate::model::UsageStatisticsSortBy)
        pub fn build(self) -> crate::model::UsageStatisticsSortBy {
            crate::model::UsageStatisticsSortBy {
                key: self.key,
                order_by: self.order_by,
            }
        }
    }
}
impl UsageStatisticsSortBy {
    /// Creates a new builder-style object to manufacture [`UsageStatisticsSortBy`](crate::model::UsageStatisticsSortBy)
    pub fn builder() -> crate::model::usage_statistics_sort_by::Builder {
        crate::model::usage_statistics_sort_by::Builder::default()
    }
}

/// <p>The field to use to sort the results of a query for Amazon Macie account quotas and usage data. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageStatisticsSortKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    FreeTrialStartDate,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLimitValue,
    #[allow(missing_docs)] // documentation missing in model
    Total,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageStatisticsSortKey {
    fn from(s: &str) -> Self {
        match s {
            "accountId" => UsageStatisticsSortKey::AccountId,
            "freeTrialStartDate" => UsageStatisticsSortKey::FreeTrialStartDate,
            "serviceLimitValue" => UsageStatisticsSortKey::ServiceLimitValue,
            "total" => UsageStatisticsSortKey::Total,
            other => UsageStatisticsSortKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageStatisticsSortKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageStatisticsSortKey::from(s))
    }
}
impl UsageStatisticsSortKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageStatisticsSortKey::AccountId => "accountId",
            UsageStatisticsSortKey::FreeTrialStartDate => "freeTrialStartDate",
            UsageStatisticsSortKey::ServiceLimitValue => "serviceLimitValue",
            UsageStatisticsSortKey::Total => "total",
            UsageStatisticsSortKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "accountId",
            "freeTrialStartDate",
            "serviceLimitValue",
            "total",
        ]
    }
}
impl AsRef<str> for UsageStatisticsSortKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a condition for filtering the results of a query for quota and usage data for one or more Amazon Macie accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UsageStatisticsFilter {
    /// <p>The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.</p>
    pub comparator: std::option::Option<crate::model::UsageStatisticsFilterComparator>,
    /// <p>The field to use in the condition.</p>
    pub key: std::option::Option<crate::model::UsageStatisticsFilterKey>,
    /// <p>An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.</p>
    /// <p>Valid values for each supported field are:</p>
    /// <ul>
    /// <li><p>accountId - The unique identifier for an Amazon Web Services account.</p></li>
    /// <li><p>freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account.</p></li>
    /// <li><p>serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.</p></li>
    /// <li><p>total - A string that represents the current estimated cost for an account.</p></li>
    /// </ul>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UsageStatisticsFilter {
    /// <p>The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.</p>
    pub fn comparator(
        &self,
    ) -> std::option::Option<&crate::model::UsageStatisticsFilterComparator> {
        self.comparator.as_ref()
    }
    /// <p>The field to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::UsageStatisticsFilterKey> {
        self.key.as_ref()
    }
    /// <p>An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.</p>
    /// <p>Valid values for each supported field are:</p>
    /// <ul>
    /// <li><p>accountId - The unique identifier for an Amazon Web Services account.</p></li>
    /// <li><p>freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account.</p></li>
    /// <li><p>serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.</p></li>
    /// <li><p>total - A string that represents the current estimated cost for an account.</p></li>
    /// </ul>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for UsageStatisticsFilter {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UsageStatisticsFilter");
        formatter.field("comparator", &self.comparator);
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`UsageStatisticsFilter`](crate::model::UsageStatisticsFilter)
pub mod usage_statistics_filter {
    /// A builder for [`UsageStatisticsFilter`](crate::model::UsageStatisticsFilter)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::UsageStatisticsFilterComparator>,
        pub(crate) key: std::option::Option<crate::model::UsageStatisticsFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.</p>
        pub fn comparator(mut self, input: crate::model::UsageStatisticsFilterComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. If the value for the key property is accountId, this value must be CONTAINS. If the value for the key property is any other supported field, this value can be EQ, GT, GTE, LT, LTE, or NE.</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticsFilterComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// <p>The field to use in the condition.</p>
        pub fn key(mut self, input: crate::model::UsageStatisticsFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The field to use in the condition.</p>
        pub fn set_key(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticsFilterKey>,
        ) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.</p>
        /// <p>Valid values for each supported field are:</p>
        /// <ul>
        /// <li><p>accountId - The unique identifier for an Amazon Web Services account.</p></li>
        /// <li><p>freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account.</p></li>
        /// <li><p>serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.</p></li>
        /// <li><p>total - A string that represents the current estimated cost for an account.</p></li>
        /// </ul>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array that lists values to use in the condition, based on the value for the field specified by the key property. If the value for the key property is accountId, this array can specify multiple values. Otherwise, this array can specify only one value.</p>
        /// <p>Valid values for each supported field are:</p>
        /// <ul>
        /// <li><p>accountId - The unique identifier for an Amazon Web Services account.</p></li>
        /// <li><p>freeTrialStartDate - The date and time, in UTC and extended ISO 8601 format, when the free trial started for an account.</p></li>
        /// <li><p>serviceLimit - A Boolean (true or false) value that indicates whether an account has reached its monthly quota.</p></li>
        /// <li><p>total - A string that represents the current estimated cost for an account.</p></li>
        /// </ul>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`UsageStatisticsFilter`](crate::model::UsageStatisticsFilter)
        pub fn build(self) -> crate::model::UsageStatisticsFilter {
            crate::model::UsageStatisticsFilter {
                comparator: self.comparator,
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl UsageStatisticsFilter {
    /// Creates a new builder-style object to manufacture [`UsageStatisticsFilter`](crate::model::UsageStatisticsFilter)
    pub fn builder() -> crate::model::usage_statistics_filter::Builder {
        crate::model::usage_statistics_filter::Builder::default()
    }
}

/// <p>The field to use in a condition that filters the results of a query for Amazon Macie account quotas and usage data. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageStatisticsFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    AccountId,
    #[allow(missing_docs)] // documentation missing in model
    FreeTrialStartDate,
    #[allow(missing_docs)] // documentation missing in model
    ServiceLimit,
    #[allow(missing_docs)] // documentation missing in model
    Total,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageStatisticsFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "accountId" => UsageStatisticsFilterKey::AccountId,
            "freeTrialStartDate" => UsageStatisticsFilterKey::FreeTrialStartDate,
            "serviceLimit" => UsageStatisticsFilterKey::ServiceLimit,
            "total" => UsageStatisticsFilterKey::Total,
            other => UsageStatisticsFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageStatisticsFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageStatisticsFilterKey::from(s))
    }
}
impl UsageStatisticsFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageStatisticsFilterKey::AccountId => "accountId",
            UsageStatisticsFilterKey::FreeTrialStartDate => "freeTrialStartDate",
            UsageStatisticsFilterKey::ServiceLimit => "serviceLimit",
            UsageStatisticsFilterKey::Total => "total",
            UsageStatisticsFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["accountId", "freeTrialStartDate", "serviceLimit", "total"]
    }
}
impl AsRef<str> for UsageStatisticsFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The operator to use in a condition that filters the results of a query for Amazon Macie account quotas and usage data. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UsageStatisticsFilterComparator {
    #[allow(missing_docs)] // documentation missing in model
    Contains,
    #[allow(missing_docs)] // documentation missing in model
    Eq,
    #[allow(missing_docs)] // documentation missing in model
    Gt,
    #[allow(missing_docs)] // documentation missing in model
    Gte,
    #[allow(missing_docs)] // documentation missing in model
    Lt,
    #[allow(missing_docs)] // documentation missing in model
    Lte,
    #[allow(missing_docs)] // documentation missing in model
    Ne,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UsageStatisticsFilterComparator {
    fn from(s: &str) -> Self {
        match s {
            "CONTAINS" => UsageStatisticsFilterComparator::Contains,
            "EQ" => UsageStatisticsFilterComparator::Eq,
            "GT" => UsageStatisticsFilterComparator::Gt,
            "GTE" => UsageStatisticsFilterComparator::Gte,
            "LT" => UsageStatisticsFilterComparator::Lt,
            "LTE" => UsageStatisticsFilterComparator::Lte,
            "NE" => UsageStatisticsFilterComparator::Ne,
            other => UsageStatisticsFilterComparator::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UsageStatisticsFilterComparator {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UsageStatisticsFilterComparator::from(s))
    }
}
impl UsageStatisticsFilterComparator {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UsageStatisticsFilterComparator::Contains => "CONTAINS",
            UsageStatisticsFilterComparator::Eq => "EQ",
            UsageStatisticsFilterComparator::Gt => "GT",
            UsageStatisticsFilterComparator::Gte => "GTE",
            UsageStatisticsFilterComparator::Lt => "LT",
            UsageStatisticsFilterComparator::Lte => "LTE",
            UsageStatisticsFilterComparator::Ne => "NE",
            UsageStatisticsFilterComparator::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CONTAINS", "EQ", "GT", "GTE", "LT", "LTE", "NE"]
    }
}
impl AsRef<str> for UsageStatisticsFilterComparator {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides a group of results for a query that retrieved aggregated statistical data about findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GroupCount {
    /// <p>The total number of findings in the group of query results.</p>
    pub count: i64,
    /// <p>The name of the property that defines the group in the query results, as specified by the groupBy property in the query request.</p>
    pub group_key: std::option::Option<std::string::String>,
}
impl GroupCount {
    /// <p>The total number of findings in the group of query results.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
    /// <p>The name of the property that defines the group in the query results, as specified by the groupBy property in the query request.</p>
    pub fn group_key(&self) -> std::option::Option<&str> {
        self.group_key.as_deref()
    }
}
impl std::fmt::Debug for GroupCount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GroupCount");
        formatter.field("count", &self.count);
        formatter.field("group_key", &self.group_key);
        formatter.finish()
    }
}
/// See [`GroupCount`](crate::model::GroupCount)
pub mod group_count {
    /// A builder for [`GroupCount`](crate::model::GroupCount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i64>,
        pub(crate) group_key: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total number of findings in the group of query results.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The total number of findings in the group of query results.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The name of the property that defines the group in the query results, as specified by the groupBy property in the query request.</p>
        pub fn group_key(mut self, input: impl Into<std::string::String>) -> Self {
            self.group_key = Some(input.into());
            self
        }
        /// <p>The name of the property that defines the group in the query results, as specified by the groupBy property in the query request.</p>
        pub fn set_group_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.group_key = input;
            self
        }
        /// Consumes the builder and constructs a [`GroupCount`](crate::model::GroupCount)
        pub fn build(self) -> crate::model::GroupCount {
            crate::model::GroupCount {
                count: self.count.unwrap_or_default(),
                group_key: self.group_key,
            }
        }
    }
}
impl GroupCount {
    /// Creates a new builder-style object to manufacture [`GroupCount`](crate::model::GroupCount)
    pub fn builder() -> crate::model::group_count::Builder {
        crate::model::group_count::Builder::default()
    }
}

/// <p>Specifies criteria for sorting the results of a query that retrieves aggregated statistical data about findings.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingStatisticsSortCriteria {
    /// <p>The grouping to sort the results by. Valid values are: count, sort the results by the number of findings in each group of results; and, groupKey, sort the results by the name of each group of results.</p>
    pub attribute_name: std::option::Option<crate::model::FindingStatisticsSortAttributeName>,
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl FindingStatisticsSortCriteria {
    /// <p>The grouping to sort the results by. Valid values are: count, sort the results by the number of findings in each group of results; and, groupKey, sort the results by the name of each group of results.</p>
    pub fn attribute_name(
        &self,
    ) -> std::option::Option<&crate::model::FindingStatisticsSortAttributeName> {
        self.attribute_name.as_ref()
    }
    /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::OrderBy> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for FindingStatisticsSortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingStatisticsSortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`FindingStatisticsSortCriteria`](crate::model::FindingStatisticsSortCriteria)
pub mod finding_statistics_sort_criteria {
    /// A builder for [`FindingStatisticsSortCriteria`](crate::model::FindingStatisticsSortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name:
            std::option::Option<crate::model::FindingStatisticsSortAttributeName>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The grouping to sort the results by. Valid values are: count, sort the results by the number of findings in each group of results; and, groupKey, sort the results by the name of each group of results.</p>
        pub fn attribute_name(
            mut self,
            input: crate::model::FindingStatisticsSortAttributeName,
        ) -> Self {
            self.attribute_name = Some(input);
            self
        }
        /// <p>The grouping to sort the results by. Valid values are: count, sort the results by the number of findings in each group of results; and, groupKey, sort the results by the name of each group of results.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<crate::model::FindingStatisticsSortAttributeName>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order to apply to the results, based on the value for the property specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingStatisticsSortCriteria`](crate::model::FindingStatisticsSortCriteria)
        pub fn build(self) -> crate::model::FindingStatisticsSortCriteria {
            crate::model::FindingStatisticsSortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl FindingStatisticsSortCriteria {
    /// Creates a new builder-style object to manufacture [`FindingStatisticsSortCriteria`](crate::model::FindingStatisticsSortCriteria)
    pub fn builder() -> crate::model::finding_statistics_sort_criteria::Builder {
        crate::model::finding_statistics_sort_criteria::Builder::default()
    }
}

/// <p>The grouping to sort the results by. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingStatisticsSortAttributeName {
    #[allow(missing_docs)] // documentation missing in model
    Count,
    #[allow(missing_docs)] // documentation missing in model
    GroupKey,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingStatisticsSortAttributeName {
    fn from(s: &str) -> Self {
        match s {
            "count" => FindingStatisticsSortAttributeName::Count,
            "groupKey" => FindingStatisticsSortAttributeName::GroupKey,
            other => FindingStatisticsSortAttributeName::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingStatisticsSortAttributeName {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingStatisticsSortAttributeName::from(s))
    }
}
impl FindingStatisticsSortAttributeName {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingStatisticsSortAttributeName::Count => "count",
            FindingStatisticsSortAttributeName::GroupKey => "groupKey",
            FindingStatisticsSortAttributeName::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["count", "groupKey"]
    }
}
impl AsRef<str> for FindingStatisticsSortAttributeName {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum GroupBy {
    #[allow(missing_docs)] // documentation missing in model
    ClassificationDetailsJobId,
    #[allow(missing_docs)] // documentation missing in model
    ResourcesAffectedS3BucketName,
    #[allow(missing_docs)] // documentation missing in model
    SeverityDescription,
    #[allow(missing_docs)] // documentation missing in model
    Type,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for GroupBy {
    fn from(s: &str) -> Self {
        match s {
            "classificationDetails.jobId" => GroupBy::ClassificationDetailsJobId,
            "resourcesAffected.s3Bucket.name" => GroupBy::ResourcesAffectedS3BucketName,
            "severity.description" => GroupBy::SeverityDescription,
            "type" => GroupBy::Type,
            other => GroupBy::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for GroupBy {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(GroupBy::from(s))
    }
}
impl GroupBy {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            GroupBy::ClassificationDetailsJobId => "classificationDetails.jobId",
            GroupBy::ResourcesAffectedS3BucketName => "resourcesAffected.s3Bucket.name",
            GroupBy::SeverityDescription => "severity.description",
            GroupBy::Type => "type",
            GroupBy::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "classificationDetails.jobId",
            "resourcesAffected.s3Bucket.name",
            "severity.description",
            "type",
        ]
    }
}
impl AsRef<str> for GroupBy {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of a finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Finding {
    /// <p>The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the finding is archived (suppressed).</p>
    pub archived: bool,
    /// <p>The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.</p>
    pub category: std::option::Option<crate::model::FindingCategory>,
    /// <p>The details of a sensitive data finding. This value is null for a policy finding.</p>
    pub classification_details: std::option::Option<crate::model::ClassificationDetails>,
    /// <p>The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
    pub count: i64,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The description of the finding.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The Amazon Web Services partition that Amazon Macie created the finding in.</p>
    pub partition: std::option::Option<std::string::String>,
    /// <p>The details of a policy finding. This value is null for a sensitive data finding.</p>
    pub policy_details: std::option::Option<crate::model::PolicyDetails>,
    /// <p>The Amazon Web Services Region that Amazon Macie created the finding in.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>The resources that the finding applies to.</p>
    pub resources_affected: std::option::Option<crate::model::ResourcesAffected>,
    /// <p>Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example data to demonstrate what a finding might contain.</p>
    pub sample: bool,
    /// <p>The version of the schema that was used to define the data structures in the finding.</p>
    pub schema_version: std::option::Option<std::string::String>,
    /// <p>The severity level and score for the finding.</p>
    pub severity: std::option::Option<crate::model::Severity>,
    /// <p>The brief description of the finding.</p>
    pub title: std::option::Option<std::string::String>,
    /// <p>The type of the finding.</p>
    pub r#type: std::option::Option<crate::model::FindingType>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
    pub updated_at: std::option::Option<aws_smithy_types::DateTime>,
}
impl Finding {
    /// <p>The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies whether the finding is archived (suppressed).</p>
    pub fn archived(&self) -> bool {
        self.archived
    }
    /// <p>The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::FindingCategory> {
        self.category.as_ref()
    }
    /// <p>The details of a sensitive data finding. This value is null for a policy finding.</p>
    pub fn classification_details(
        &self,
    ) -> std::option::Option<&crate::model::ClassificationDetails> {
        self.classification_details.as_ref()
    }
    /// <p>The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The description of the finding.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The Amazon Web Services partition that Amazon Macie created the finding in.</p>
    pub fn partition(&self) -> std::option::Option<&str> {
        self.partition.as_deref()
    }
    /// <p>The details of a policy finding. This value is null for a sensitive data finding.</p>
    pub fn policy_details(&self) -> std::option::Option<&crate::model::PolicyDetails> {
        self.policy_details.as_ref()
    }
    /// <p>The Amazon Web Services Region that Amazon Macie created the finding in.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>The resources that the finding applies to.</p>
    pub fn resources_affected(&self) -> std::option::Option<&crate::model::ResourcesAffected> {
        self.resources_affected.as_ref()
    }
    /// <p>Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example data to demonstrate what a finding might contain.</p>
    pub fn sample(&self) -> bool {
        self.sample
    }
    /// <p>The version of the schema that was used to define the data structures in the finding.</p>
    pub fn schema_version(&self) -> std::option::Option<&str> {
        self.schema_version.as_deref()
    }
    /// <p>The severity level and score for the finding.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::Severity> {
        self.severity.as_ref()
    }
    /// <p>The brief description of the finding.</p>
    pub fn title(&self) -> std::option::Option<&str> {
        self.title.as_deref()
    }
    /// <p>The type of the finding.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::FindingType> {
        self.r#type.as_ref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
    pub fn updated_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.updated_at.as_ref()
    }
}
impl std::fmt::Debug for Finding {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Finding");
        formatter.field("account_id", &self.account_id);
        formatter.field("archived", &self.archived);
        formatter.field("category", &self.category);
        formatter.field("classification_details", &self.classification_details);
        formatter.field("count", &self.count);
        formatter.field("created_at", &self.created_at);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("partition", &self.partition);
        formatter.field("policy_details", &self.policy_details);
        formatter.field("region", &self.region);
        formatter.field("resources_affected", &self.resources_affected);
        formatter.field("sample", &self.sample);
        formatter.field("schema_version", &self.schema_version);
        formatter.field("severity", &self.severity);
        formatter.field("title", &self.title);
        formatter.field("r#type", &self.r#type);
        formatter.field("updated_at", &self.updated_at);
        formatter.finish()
    }
}
/// See [`Finding`](crate::model::Finding)
pub mod finding {
    /// A builder for [`Finding`](crate::model::Finding)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) archived: std::option::Option<bool>,
        pub(crate) category: std::option::Option<crate::model::FindingCategory>,
        pub(crate) classification_details: std::option::Option<crate::model::ClassificationDetails>,
        pub(crate) count: std::option::Option<i64>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) partition: std::option::Option<std::string::String>,
        pub(crate) policy_details: std::option::Option<crate::model::PolicyDetails>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) resources_affected: std::option::Option<crate::model::ResourcesAffected>,
        pub(crate) sample: std::option::Option<bool>,
        pub(crate) schema_version: std::option::Option<std::string::String>,
        pub(crate) severity: std::option::Option<crate::model::Severity>,
        pub(crate) title: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::FindingType>,
        pub(crate) updated_at: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies whether the finding is archived (suppressed).</p>
        pub fn archived(mut self, input: bool) -> Self {
            self.archived = Some(input);
            self
        }
        /// <p>Specifies whether the finding is archived (suppressed).</p>
        pub fn set_archived(mut self, input: std::option::Option<bool>) -> Self {
            self.archived = input;
            self
        }
        /// <p>The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.</p>
        pub fn category(mut self, input: crate::model::FindingCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::FindingCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// <p>The details of a sensitive data finding. This value is null for a policy finding.</p>
        pub fn classification_details(
            mut self,
            input: crate::model::ClassificationDetails,
        ) -> Self {
            self.classification_details = Some(input);
            self
        }
        /// <p>The details of a sensitive data finding. This value is null for a policy finding.</p>
        pub fn set_classification_details(
            mut self,
            input: std::option::Option<crate::model::ClassificationDetails>,
        ) -> Self {
            self.classification_details = input;
            self
        }
        /// <p>The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The description of the finding.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The description of the finding.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The Amazon Web Services partition that Amazon Macie created the finding in.</p>
        pub fn partition(mut self, input: impl Into<std::string::String>) -> Self {
            self.partition = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services partition that Amazon Macie created the finding in.</p>
        pub fn set_partition(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.partition = input;
            self
        }
        /// <p>The details of a policy finding. This value is null for a sensitive data finding.</p>
        pub fn policy_details(mut self, input: crate::model::PolicyDetails) -> Self {
            self.policy_details = Some(input);
            self
        }
        /// <p>The details of a policy finding. This value is null for a sensitive data finding.</p>
        pub fn set_policy_details(
            mut self,
            input: std::option::Option<crate::model::PolicyDetails>,
        ) -> Self {
            self.policy_details = input;
            self
        }
        /// <p>The Amazon Web Services Region that Amazon Macie created the finding in.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region that Amazon Macie created the finding in.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>The resources that the finding applies to.</p>
        pub fn resources_affected(mut self, input: crate::model::ResourcesAffected) -> Self {
            self.resources_affected = Some(input);
            self
        }
        /// <p>The resources that the finding applies to.</p>
        pub fn set_resources_affected(
            mut self,
            input: std::option::Option<crate::model::ResourcesAffected>,
        ) -> Self {
            self.resources_affected = input;
            self
        }
        /// <p>Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example data to demonstrate what a finding might contain.</p>
        pub fn sample(mut self, input: bool) -> Self {
            self.sample = Some(input);
            self
        }
        /// <p>Specifies whether the finding is a sample finding. A <i>sample finding</i> is a finding that uses example data to demonstrate what a finding might contain.</p>
        pub fn set_sample(mut self, input: std::option::Option<bool>) -> Self {
            self.sample = input;
            self
        }
        /// <p>The version of the schema that was used to define the data structures in the finding.</p>
        pub fn schema_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema_version = Some(input.into());
            self
        }
        /// <p>The version of the schema that was used to define the data structures in the finding.</p>
        pub fn set_schema_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.schema_version = input;
            self
        }
        /// <p>The severity level and score for the finding.</p>
        pub fn severity(mut self, input: crate::model::Severity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity level and score for the finding.</p>
        pub fn set_severity(mut self, input: std::option::Option<crate::model::Severity>) -> Self {
            self.severity = input;
            self
        }
        /// <p>The brief description of the finding.</p>
        pub fn title(mut self, input: impl Into<std::string::String>) -> Self {
            self.title = Some(input.into());
            self
        }
        /// <p>The brief description of the finding.</p>
        pub fn set_title(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.title = input;
            self
        }
        /// <p>The type of the finding.</p>
        pub fn r#type(mut self, input: crate::model::FindingType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of the finding.</p>
        pub fn set_type(mut self, input: std::option::Option<crate::model::FindingType>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
        pub fn updated_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.updated_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.</p>
        pub fn set_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.updated_at = input;
            self
        }
        /// Consumes the builder and constructs a [`Finding`](crate::model::Finding)
        pub fn build(self) -> crate::model::Finding {
            crate::model::Finding {
                account_id: self.account_id,
                archived: self.archived.unwrap_or_default(),
                category: self.category,
                classification_details: self.classification_details,
                count: self.count.unwrap_or_default(),
                created_at: self.created_at,
                description: self.description,
                id: self.id,
                partition: self.partition,
                policy_details: self.policy_details,
                region: self.region,
                resources_affected: self.resources_affected,
                sample: self.sample.unwrap_or_default(),
                schema_version: self.schema_version,
                severity: self.severity,
                title: self.title,
                r#type: self.r#type,
                updated_at: self.updated_at,
            }
        }
    }
}
impl Finding {
    /// Creates a new builder-style object to manufacture [`Finding`](crate::model::Finding)
    pub fn builder() -> crate::model::finding::Builder {
        crate::model::finding::Builder::default()
    }
}

/// <p>The type of finding. For details about each type, see <a href="https://docs.aws.amazon.com/macie/latest/user/findings-types.html">Types of Amazon Macie findings</a> in the <i>Amazon Macie User Guide</i>. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingType {
    #[allow(missing_docs)] // documentation missing in model
    PolicyIamUserS3BlockPublicAccessDisabled,
    #[allow(missing_docs)] // documentation missing in model
    PolicyIamUserS3BucketEncryptionDisabled,
    #[allow(missing_docs)] // documentation missing in model
    PolicyIamUserS3BucketPublic,
    #[allow(missing_docs)] // documentation missing in model
    PolicyIamUserS3BucketReplicatedExternally,
    #[allow(missing_docs)] // documentation missing in model
    PolicyIamUserS3BucketSharedExternally,
    #[allow(missing_docs)] // documentation missing in model
    SensitiveDataS3ObjectCredentials,
    #[allow(missing_docs)] // documentation missing in model
    SensitiveDataS3ObjectCustomIdentifier,
    #[allow(missing_docs)] // documentation missing in model
    SensitiveDataS3ObjectFinancial,
    #[allow(missing_docs)] // documentation missing in model
    SensitiveDataS3ObjectMultiple,
    #[allow(missing_docs)] // documentation missing in model
    SensitiveDataS3ObjectPersonal,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingType {
    fn from(s: &str) -> Self {
        match s {
            "Policy:IAMUser/S3BlockPublicAccessDisabled" => {
                FindingType::PolicyIamUserS3BlockPublicAccessDisabled
            }
            "Policy:IAMUser/S3BucketEncryptionDisabled" => {
                FindingType::PolicyIamUserS3BucketEncryptionDisabled
            }
            "Policy:IAMUser/S3BucketPublic" => FindingType::PolicyIamUserS3BucketPublic,
            "Policy:IAMUser/S3BucketReplicatedExternally" => {
                FindingType::PolicyIamUserS3BucketReplicatedExternally
            }
            "Policy:IAMUser/S3BucketSharedExternally" => {
                FindingType::PolicyIamUserS3BucketSharedExternally
            }
            "SensitiveData:S3Object/Credentials" => FindingType::SensitiveDataS3ObjectCredentials,
            "SensitiveData:S3Object/CustomIdentifier" => {
                FindingType::SensitiveDataS3ObjectCustomIdentifier
            }
            "SensitiveData:S3Object/Financial" => FindingType::SensitiveDataS3ObjectFinancial,
            "SensitiveData:S3Object/Multiple" => FindingType::SensitiveDataS3ObjectMultiple,
            "SensitiveData:S3Object/Personal" => FindingType::SensitiveDataS3ObjectPersonal,
            other => FindingType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingType::from(s))
    }
}
impl FindingType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingType::PolicyIamUserS3BlockPublicAccessDisabled => {
                "Policy:IAMUser/S3BlockPublicAccessDisabled"
            }
            FindingType::PolicyIamUserS3BucketEncryptionDisabled => {
                "Policy:IAMUser/S3BucketEncryptionDisabled"
            }
            FindingType::PolicyIamUserS3BucketPublic => "Policy:IAMUser/S3BucketPublic",
            FindingType::PolicyIamUserS3BucketReplicatedExternally => {
                "Policy:IAMUser/S3BucketReplicatedExternally"
            }
            FindingType::PolicyIamUserS3BucketSharedExternally => {
                "Policy:IAMUser/S3BucketSharedExternally"
            }
            FindingType::SensitiveDataS3ObjectCredentials => "SensitiveData:S3Object/Credentials",
            FindingType::SensitiveDataS3ObjectCustomIdentifier => {
                "SensitiveData:S3Object/CustomIdentifier"
            }
            FindingType::SensitiveDataS3ObjectFinancial => "SensitiveData:S3Object/Financial",
            FindingType::SensitiveDataS3ObjectMultiple => "SensitiveData:S3Object/Multiple",
            FindingType::SensitiveDataS3ObjectPersonal => "SensitiveData:S3Object/Personal",
            FindingType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "Policy:IAMUser/S3BlockPublicAccessDisabled",
            "Policy:IAMUser/S3BucketEncryptionDisabled",
            "Policy:IAMUser/S3BucketPublic",
            "Policy:IAMUser/S3BucketReplicatedExternally",
            "Policy:IAMUser/S3BucketSharedExternally",
            "SensitiveData:S3Object/Credentials",
            "SensitiveData:S3Object/CustomIdentifier",
            "SensitiveData:S3Object/Financial",
            "SensitiveData:S3Object/Multiple",
            "SensitiveData:S3Object/Personal",
        ]
    }
}
impl AsRef<str> for FindingType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the numerical and qualitative representations of a finding's severity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Severity {
    /// <p>The qualitative representation of the finding's severity, ranging from Low (least severe) to High (most severe).</p>
    pub description: std::option::Option<crate::model::SeverityDescription>,
    /// <p>The numerical representation of the finding's severity, ranging from 1 (least severe) to 3 (most severe).</p>
    pub score: i64,
}
impl Severity {
    /// <p>The qualitative representation of the finding's severity, ranging from Low (least severe) to High (most severe).</p>
    pub fn description(&self) -> std::option::Option<&crate::model::SeverityDescription> {
        self.description.as_ref()
    }
    /// <p>The numerical representation of the finding's severity, ranging from 1 (least severe) to 3 (most severe).</p>
    pub fn score(&self) -> i64 {
        self.score
    }
}
impl std::fmt::Debug for Severity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Severity");
        formatter.field("description", &self.description);
        formatter.field("score", &self.score);
        formatter.finish()
    }
}
/// See [`Severity`](crate::model::Severity)
pub mod severity {
    /// A builder for [`Severity`](crate::model::Severity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) description: std::option::Option<crate::model::SeverityDescription>,
        pub(crate) score: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The qualitative representation of the finding's severity, ranging from Low (least severe) to High (most severe).</p>
        pub fn description(mut self, input: crate::model::SeverityDescription) -> Self {
            self.description = Some(input);
            self
        }
        /// <p>The qualitative representation of the finding's severity, ranging from Low (least severe) to High (most severe).</p>
        pub fn set_description(
            mut self,
            input: std::option::Option<crate::model::SeverityDescription>,
        ) -> Self {
            self.description = input;
            self
        }
        /// <p>The numerical representation of the finding's severity, ranging from 1 (least severe) to 3 (most severe).</p>
        pub fn score(mut self, input: i64) -> Self {
            self.score = Some(input);
            self
        }
        /// <p>The numerical representation of the finding's severity, ranging from 1 (least severe) to 3 (most severe).</p>
        pub fn set_score(mut self, input: std::option::Option<i64>) -> Self {
            self.score = input;
            self
        }
        /// Consumes the builder and constructs a [`Severity`](crate::model::Severity)
        pub fn build(self) -> crate::model::Severity {
            crate::model::Severity {
                description: self.description,
                score: self.score.unwrap_or_default(),
            }
        }
    }
}
impl Severity {
    /// Creates a new builder-style object to manufacture [`Severity`](crate::model::Severity)
    pub fn builder() -> crate::model::severity::Builder {
        crate::model::severity::Builder::default()
    }
}

/// <p>The qualitative representation of the finding's severity. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SeverityDescription {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SeverityDescription {
    fn from(s: &str) -> Self {
        match s {
            "High" => SeverityDescription::High,
            "Low" => SeverityDescription::Low,
            "Medium" => SeverityDescription::Medium,
            other => SeverityDescription::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SeverityDescription {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SeverityDescription::from(s))
    }
}
impl SeverityDescription {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SeverityDescription::High => "High",
            SeverityDescription::Low => "Low",
            SeverityDescription::Medium => "Medium",
            SeverityDescription::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["High", "Low", "Medium"]
    }
}
impl AsRef<str> for SeverityDescription {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the resources that a finding applies to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourcesAffected {
    /// <p>The details of the S3 bucket that the finding applies to.</p>
    pub s3_bucket: std::option::Option<crate::model::S3Bucket>,
    /// <p>The details of the S3 object that the finding applies to.</p>
    pub s3_object: std::option::Option<crate::model::S3Object>,
}
impl ResourcesAffected {
    /// <p>The details of the S3 bucket that the finding applies to.</p>
    pub fn s3_bucket(&self) -> std::option::Option<&crate::model::S3Bucket> {
        self.s3_bucket.as_ref()
    }
    /// <p>The details of the S3 object that the finding applies to.</p>
    pub fn s3_object(&self) -> std::option::Option<&crate::model::S3Object> {
        self.s3_object.as_ref()
    }
}
impl std::fmt::Debug for ResourcesAffected {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourcesAffected");
        formatter.field("s3_bucket", &self.s3_bucket);
        formatter.field("s3_object", &self.s3_object);
        formatter.finish()
    }
}
/// See [`ResourcesAffected`](crate::model::ResourcesAffected)
pub mod resources_affected {
    /// A builder for [`ResourcesAffected`](crate::model::ResourcesAffected)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) s3_bucket: std::option::Option<crate::model::S3Bucket>,
        pub(crate) s3_object: std::option::Option<crate::model::S3Object>,
    }
    impl Builder {
        /// <p>The details of the S3 bucket that the finding applies to.</p>
        pub fn s3_bucket(mut self, input: crate::model::S3Bucket) -> Self {
            self.s3_bucket = Some(input);
            self
        }
        /// <p>The details of the S3 bucket that the finding applies to.</p>
        pub fn set_s3_bucket(mut self, input: std::option::Option<crate::model::S3Bucket>) -> Self {
            self.s3_bucket = input;
            self
        }
        /// <p>The details of the S3 object that the finding applies to.</p>
        pub fn s3_object(mut self, input: crate::model::S3Object) -> Self {
            self.s3_object = Some(input);
            self
        }
        /// <p>The details of the S3 object that the finding applies to.</p>
        pub fn set_s3_object(mut self, input: std::option::Option<crate::model::S3Object>) -> Self {
            self.s3_object = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourcesAffected`](crate::model::ResourcesAffected)
        pub fn build(self) -> crate::model::ResourcesAffected {
            crate::model::ResourcesAffected {
                s3_bucket: self.s3_bucket,
                s3_object: self.s3_object,
            }
        }
    }
}
impl ResourcesAffected {
    /// Creates a new builder-style object to manufacture [`ResourcesAffected`](crate::model::ResourcesAffected)
    pub fn builder() -> crate::model::resources_affected::Builder {
        crate::model::resources_affected::Builder::default()
    }
}

/// <p>Provides information about the S3 object that a finding applies to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Object {
    /// <p>The Amazon Resource Name (ARN) of the bucket that contains the object.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.</p>
    pub e_tag: std::option::Option<std::string::String>,
    /// <p>The file name extension of the object. If the object doesn't have a file name extension, this value is "".</p>
    pub extension: std::option::Option<std::string::String>,
    /// <p>The full key (name) that's assigned to the object.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the object was last modified.</p>
    pub last_modified: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The path to the object, including the full key (name).</p>
    pub path: std::option::Option<std::string::String>,
    /// <p>Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.</p>
    pub public_access: bool,
    /// <p>The type of server-side encryption that's used to encrypt the object.</p>
    pub server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>The total storage size, in bytes, of the object.</p>
    pub size: i64,
    /// <p>The storage class of the object.</p>
    pub storage_class: std::option::Option<crate::model::StorageClass>,
    /// <p>The tags that are associated with the object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    /// <p>The identifier for the affected version of the object.</p>
    pub version_id: std::option::Option<std::string::String>,
}
impl S3Object {
    /// <p>The Amazon Resource Name (ARN) of the bucket that contains the object.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.</p>
    pub fn e_tag(&self) -> std::option::Option<&str> {
        self.e_tag.as_deref()
    }
    /// <p>The file name extension of the object. If the object doesn't have a file name extension, this value is "".</p>
    pub fn extension(&self) -> std::option::Option<&str> {
        self.extension.as_deref()
    }
    /// <p>The full key (name) that's assigned to the object.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the object was last modified.</p>
    pub fn last_modified(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_modified.as_ref()
    }
    /// <p>The path to the object, including the full key (name).</p>
    pub fn path(&self) -> std::option::Option<&str> {
        self.path.as_deref()
    }
    /// <p>Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.</p>
    pub fn public_access(&self) -> bool {
        self.public_access
    }
    /// <p>The type of server-side encryption that's used to encrypt the object.</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>The total storage size, in bytes, of the object.</p>
    pub fn size(&self) -> i64 {
        self.size
    }
    /// <p>The storage class of the object.</p>
    pub fn storage_class(&self) -> std::option::Option<&crate::model::StorageClass> {
        self.storage_class.as_ref()
    }
    /// <p>The tags that are associated with the object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::KeyValuePair]> {
        self.tags.as_deref()
    }
    /// <p>The identifier for the affected version of the object.</p>
    pub fn version_id(&self) -> std::option::Option<&str> {
        self.version_id.as_deref()
    }
}
impl std::fmt::Debug for S3Object {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Object");
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("e_tag", &self.e_tag);
        formatter.field("extension", &self.extension);
        formatter.field("key", &self.key);
        formatter.field("last_modified", &self.last_modified);
        formatter.field("path", &self.path);
        formatter.field("public_access", &self.public_access);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("size", &self.size);
        formatter.field("storage_class", &self.storage_class);
        formatter.field("tags", &self.tags);
        formatter.field("version_id", &self.version_id);
        formatter.finish()
    }
}
/// See [`S3Object`](crate::model::S3Object)
pub mod s3_object {
    /// A builder for [`S3Object`](crate::model::S3Object)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) e_tag: std::option::Option<std::string::String>,
        pub(crate) extension: std::option::Option<std::string::String>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) last_modified: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) path: std::option::Option<std::string::String>,
        pub(crate) public_access: std::option::Option<bool>,
        pub(crate) server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) size: std::option::Option<i64>,
        pub(crate) storage_class: std::option::Option<crate::model::StorageClass>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        pub(crate) version_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the bucket that contains the object.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket that contains the object.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.</p>
        pub fn e_tag(mut self, input: impl Into<std::string::String>) -> Self {
            self.e_tag = Some(input.into());
            self
        }
        /// <p>The entity tag (ETag) that identifies the affected version of the object. If the object was overwritten or changed after Amazon Macie produced the finding, this value might be different from the current ETag for the object.</p>
        pub fn set_e_tag(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.e_tag = input;
            self
        }
        /// <p>The file name extension of the object. If the object doesn't have a file name extension, this value is "".</p>
        pub fn extension(mut self, input: impl Into<std::string::String>) -> Self {
            self.extension = Some(input.into());
            self
        }
        /// <p>The file name extension of the object. If the object doesn't have a file name extension, this value is "".</p>
        pub fn set_extension(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.extension = input;
            self
        }
        /// <p>The full key (name) that's assigned to the object.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The full key (name) that's assigned to the object.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the object was last modified.</p>
        pub fn last_modified(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_modified = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the object was last modified.</p>
        pub fn set_last_modified(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_modified = input;
            self
        }
        /// <p>The path to the object, including the full key (name).</p>
        pub fn path(mut self, input: impl Into<std::string::String>) -> Self {
            self.path = Some(input.into());
            self
        }
        /// <p>The path to the object, including the full key (name).</p>
        pub fn set_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.path = input;
            self
        }
        /// <p>Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.</p>
        pub fn public_access(mut self, input: bool) -> Self {
            self.public_access = Some(input);
            self
        }
        /// <p>Specifies whether the object is publicly accessible due to the combination of permissions settings that apply to the object.</p>
        pub fn set_public_access(mut self, input: std::option::Option<bool>) -> Self {
            self.public_access = input;
            self
        }
        /// <p>The type of server-side encryption that's used to encrypt the object.</p>
        pub fn server_side_encryption(mut self, input: crate::model::ServerSideEncryption) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>The type of server-side encryption that's used to encrypt the object.</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>The total storage size, in bytes, of the object.</p>
        pub fn size(mut self, input: i64) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the object.</p>
        pub fn set_size(mut self, input: std::option::Option<i64>) -> Self {
            self.size = input;
            self
        }
        /// <p>The storage class of the object.</p>
        pub fn storage_class(mut self, input: crate::model::StorageClass) -> Self {
            self.storage_class = Some(input);
            self
        }
        /// <p>The storage class of the object.</p>
        pub fn set_storage_class(
            mut self,
            input: std::option::Option<crate::model::StorageClass>,
        ) -> Self {
            self.storage_class = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are associated with the object.</p>
        pub fn tags(mut self, input: crate::model::KeyValuePair) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are associated with the object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The identifier for the affected version of the object.</p>
        pub fn version_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.version_id = Some(input.into());
            self
        }
        /// <p>The identifier for the affected version of the object.</p>
        pub fn set_version_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.version_id = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Object`](crate::model::S3Object)
        pub fn build(self) -> crate::model::S3Object {
            crate::model::S3Object {
                bucket_arn: self.bucket_arn,
                e_tag: self.e_tag,
                extension: self.extension,
                key: self.key,
                last_modified: self.last_modified,
                path: self.path,
                public_access: self.public_access.unwrap_or_default(),
                server_side_encryption: self.server_side_encryption,
                size: self.size.unwrap_or_default(),
                storage_class: self.storage_class,
                tags: self.tags,
                version_id: self.version_id,
            }
        }
    }
}
impl S3Object {
    /// Creates a new builder-style object to manufacture [`S3Object`](crate::model::S3Object)
    pub fn builder() -> crate::model::s3_object::Builder {
        crate::model::s3_object::Builder::default()
    }
}

/// <p>Provides information about the tags that are associated with an S3 bucket or object. Each tag consists of a required tag key and an associated tag value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct KeyValuePair {
    /// <p>One part of a key-value pair that comprises a tag. A tag key is a general label that acts as a category for more specific tag values.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>One part of a key-value pair that comprises a tag. A tag value acts as a descriptor for a tag key. A tag value can be an empty string.</p>
    pub value: std::option::Option<std::string::String>,
}
impl KeyValuePair {
    /// <p>One part of a key-value pair that comprises a tag. A tag key is a general label that acts as a category for more specific tag values.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>One part of a key-value pair that comprises a tag. A tag value acts as a descriptor for a tag key. A tag value can be an empty string.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for KeyValuePair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("KeyValuePair");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`KeyValuePair`](crate::model::KeyValuePair)
pub mod key_value_pair {
    /// A builder for [`KeyValuePair`](crate::model::KeyValuePair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>One part of a key-value pair that comprises a tag. A tag key is a general label that acts as a category for more specific tag values.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that comprises a tag. A tag key is a general label that acts as a category for more specific tag values.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>One part of a key-value pair that comprises a tag. A tag value acts as a descriptor for a tag key. A tag value can be an empty string.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>One part of a key-value pair that comprises a tag. A tag value acts as a descriptor for a tag key. A tag value can be an empty string.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`KeyValuePair`](crate::model::KeyValuePair)
        pub fn build(self) -> crate::model::KeyValuePair {
            crate::model::KeyValuePair {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl KeyValuePair {
    /// Creates a new builder-style object to manufacture [`KeyValuePair`](crate::model::KeyValuePair)
    pub fn builder() -> crate::model::key_value_pair::Builder {
        crate::model::key_value_pair::Builder::default()
    }
}

/// <p>The storage class of the S3 object. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum StorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    ReducedRedundancy,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for StorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => StorageClass::DeepArchive,
            "GLACIER" => StorageClass::Glacier,
            "INTELLIGENT_TIERING" => StorageClass::IntelligentTiering,
            "ONEZONE_IA" => StorageClass::OnezoneIa,
            "REDUCED_REDUNDANCY" => StorageClass::ReducedRedundancy,
            "STANDARD" => StorageClass::Standard,
            "STANDARD_IA" => StorageClass::StandardIa,
            other => StorageClass::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for StorageClass {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(StorageClass::from(s))
    }
}
impl StorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            StorageClass::DeepArchive => "DEEP_ARCHIVE",
            StorageClass::Glacier => "GLACIER",
            StorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            StorageClass::OnezoneIa => "ONEZONE_IA",
            StorageClass::ReducedRedundancy => "REDUCED_REDUNDANCY",
            StorageClass::Standard => "STANDARD",
            StorageClass::StandardIa => "STANDARD_IA",
            StorageClass::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "GLACIER",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "REDUCED_REDUNDANCY",
            "STANDARD",
            "STANDARD_IA",
        ]
    }
}
impl AsRef<str> for StorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the server-side encryption settings for an S3 bucket or S3 object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServerSideEncryption {
    /// <p>The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.</p>
    pub encryption_type: std::option::Option<crate::model::EncryptionType>,
    /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used to encrypt data in the bucket or the object. This value is null if an KMS key isn't used to encrypt the data.</p>
    pub kms_master_key_id: std::option::Option<std::string::String>,
}
impl ServerSideEncryption {
    /// <p>The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.</p>
    pub fn encryption_type(&self) -> std::option::Option<&crate::model::EncryptionType> {
        self.encryption_type.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used to encrypt data in the bucket or the object. This value is null if an KMS key isn't used to encrypt the data.</p>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
}
impl std::fmt::Debug for ServerSideEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServerSideEncryption");
        formatter.field("encryption_type", &self.encryption_type);
        formatter.field("kms_master_key_id", &self.kms_master_key_id);
        formatter.finish()
    }
}
/// See [`ServerSideEncryption`](crate::model::ServerSideEncryption)
pub mod server_side_encryption {
    /// A builder for [`ServerSideEncryption`](crate::model::ServerSideEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) encryption_type: std::option::Option<crate::model::EncryptionType>,
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.</p>
        pub fn encryption_type(mut self, input: crate::model::EncryptionType) -> Self {
            self.encryption_type = Some(input);
            self
        }
        /// <p>The server-side encryption algorithm that's used when storing data in the bucket or object. If default encryption is disabled for the bucket or the object isn't encrypted using server-side encryption, this value is NONE.</p>
        pub fn set_encryption_type(
            mut self,
            input: std::option::Option<crate::model::EncryptionType>,
        ) -> Self {
            self.encryption_type = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used to encrypt data in the bucket or the object. This value is null if an KMS key isn't used to encrypt the data.</p>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used to encrypt data in the bucket or the object. This value is null if an KMS key isn't used to encrypt the data.</p>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// Consumes the builder and constructs a [`ServerSideEncryption`](crate::model::ServerSideEncryption)
        pub fn build(self) -> crate::model::ServerSideEncryption {
            crate::model::ServerSideEncryption {
                encryption_type: self.encryption_type,
                kms_master_key_id: self.kms_master_key_id,
            }
        }
    }
}
impl ServerSideEncryption {
    /// Creates a new builder-style object to manufacture [`ServerSideEncryption`](crate::model::ServerSideEncryption)
    pub fn builder() -> crate::model::server_side_encryption::Builder {
        crate::model::server_side_encryption::Builder::default()
    }
}

/// <p>The type of server-side encryption that's used to encrypt an S3 object or objects in an S3 bucket. Valid values are:</p>
///
/// _Note: `EncryptionType::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EncryptionType {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    #[allow(missing_docs)] // documentation missing in model
    AwsKms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EncryptionType {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => EncryptionType::Aes256,
            "NONE" => EncryptionType::None,
            "UNKNOWN" => EncryptionType::UnknownValue,
            "aws:kms" => EncryptionType::AwsKms,
            other => EncryptionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EncryptionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EncryptionType::from(s))
    }
}
impl EncryptionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EncryptionType::Aes256 => "AES256",
            EncryptionType::None => "NONE",
            EncryptionType::UnknownValue => "UNKNOWN",
            EncryptionType::AwsKms => "aws:kms",
            EncryptionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "NONE", "UNKNOWN", "aws:kms"]
    }
}
impl AsRef<str> for EncryptionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the S3 bucket that a finding applies to.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Bucket {
    /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
    /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.</p></li>
    /// </ul>
    pub allows_unencrypted_object_uploads:
        std::option::Option<crate::model::AllowsUnencryptedObjectUploads>,
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The type of server-side encryption that's used by default to encrypt objects in the bucket.</p>
    pub default_server_side_encryption: std::option::Option<crate::model::ServerSideEncryption>,
    /// <p>The name of the bucket.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The display name and canonical user ID for the Amazon Web Services account that owns the bucket.</p>
    pub owner: std::option::Option<crate::model::S3BucketOwner>,
    /// <p>The permissions settings that determine whether the bucket is publicly accessible.</p>
    pub public_access: std::option::Option<crate::model::BucketPublicAccess>,
    /// <p>The tags that are associated with the bucket.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
}
impl S3Bucket {
    /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
    /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.</p></li>
    /// </ul>
    pub fn allows_unencrypted_object_uploads(
        &self,
    ) -> std::option::Option<&crate::model::AllowsUnencryptedObjectUploads> {
        self.allows_unencrypted_object_uploads.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>The type of server-side encryption that's used by default to encrypt objects in the bucket.</p>
    pub fn default_server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::ServerSideEncryption> {
        self.default_server_side_encryption.as_ref()
    }
    /// <p>The name of the bucket.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The display name and canonical user ID for the Amazon Web Services account that owns the bucket.</p>
    pub fn owner(&self) -> std::option::Option<&crate::model::S3BucketOwner> {
        self.owner.as_ref()
    }
    /// <p>The permissions settings that determine whether the bucket is publicly accessible.</p>
    pub fn public_access(&self) -> std::option::Option<&crate::model::BucketPublicAccess> {
        self.public_access.as_ref()
    }
    /// <p>The tags that are associated with the bucket.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::KeyValuePair]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for S3Bucket {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Bucket");
        formatter.field(
            "allows_unencrypted_object_uploads",
            &self.allows_unencrypted_object_uploads,
        );
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field(
            "default_server_side_encryption",
            &self.default_server_side_encryption,
        );
        formatter.field("name", &self.name);
        formatter.field("owner", &self.owner);
        formatter.field("public_access", &self.public_access);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`S3Bucket`](crate::model::S3Bucket)
pub mod s3_bucket {
    /// A builder for [`S3Bucket`](crate::model::S3Bucket)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allows_unencrypted_object_uploads:
            std::option::Option<crate::model::AllowsUnencryptedObjectUploads>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) default_server_side_encryption:
            std::option::Option<crate::model::ServerSideEncryption>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) owner: std::option::Option<crate::model::S3BucketOwner>,
        pub(crate) public_access: std::option::Option<crate::model::BucketPublicAccess>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    }
    impl Builder {
        /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
        /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.</p></li>
        /// </ul>
        pub fn allows_unencrypted_object_uploads(
            mut self,
            input: crate::model::AllowsUnencryptedObjectUploads,
        ) -> Self {
            self.allows_unencrypted_object_uploads = Some(input);
            self
        }
        /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
        /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of objects.</p></li>
        /// </ul>
        pub fn set_allows_unencrypted_object_uploads(
            mut self,
            input: std::option::Option<crate::model::AllowsUnencryptedObjectUploads>,
        ) -> Self {
            self.allows_unencrypted_object_uploads = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The type of server-side encryption that's used by default to encrypt objects in the bucket.</p>
        pub fn default_server_side_encryption(
            mut self,
            input: crate::model::ServerSideEncryption,
        ) -> Self {
            self.default_server_side_encryption = Some(input);
            self
        }
        /// <p>The type of server-side encryption that's used by default to encrypt objects in the bucket.</p>
        pub fn set_default_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::ServerSideEncryption>,
        ) -> Self {
            self.default_server_side_encryption = input;
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The display name and canonical user ID for the Amazon Web Services account that owns the bucket.</p>
        pub fn owner(mut self, input: crate::model::S3BucketOwner) -> Self {
            self.owner = Some(input);
            self
        }
        /// <p>The display name and canonical user ID for the Amazon Web Services account that owns the bucket.</p>
        pub fn set_owner(
            mut self,
            input: std::option::Option<crate::model::S3BucketOwner>,
        ) -> Self {
            self.owner = input;
            self
        }
        /// <p>The permissions settings that determine whether the bucket is publicly accessible.</p>
        pub fn public_access(mut self, input: crate::model::BucketPublicAccess) -> Self {
            self.public_access = Some(input);
            self
        }
        /// <p>The permissions settings that determine whether the bucket is publicly accessible.</p>
        pub fn set_public_access(
            mut self,
            input: std::option::Option<crate::model::BucketPublicAccess>,
        ) -> Self {
            self.public_access = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The tags that are associated with the bucket.</p>
        pub fn tags(mut self, input: crate::model::KeyValuePair) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The tags that are associated with the bucket.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Bucket`](crate::model::S3Bucket)
        pub fn build(self) -> crate::model::S3Bucket {
            crate::model::S3Bucket {
                allows_unencrypted_object_uploads: self.allows_unencrypted_object_uploads,
                arn: self.arn,
                created_at: self.created_at,
                default_server_side_encryption: self.default_server_side_encryption,
                name: self.name,
                owner: self.owner,
                public_access: self.public_access,
                tags: self.tags,
            }
        }
    }
}
impl S3Bucket {
    /// Creates a new builder-style object to manufacture [`S3Bucket`](crate::model::S3Bucket)
    pub fn builder() -> crate::model::s3_bucket::Builder {
        crate::model::s3_bucket::Builder::default()
    }
}

/// <p>Provides information about the permissions settings that determine whether an S3 bucket is publicly accessible.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketPublicAccess {
    /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>NOT_PUBLIC - The bucket isn't publicly accessible.</p></li>
    /// <li><p>PUBLIC - The bucket is publicly accessible.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.</p></li>
    /// </ul>
    pub effective_permission: std::option::Option<crate::model::EffectivePermission>,
    /// <p>The account-level and bucket-level permissions settings for the bucket.</p>
    pub permission_configuration: std::option::Option<crate::model::BucketPermissionConfiguration>,
}
impl BucketPublicAccess {
    /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>NOT_PUBLIC - The bucket isn't publicly accessible.</p></li>
    /// <li><p>PUBLIC - The bucket is publicly accessible.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.</p></li>
    /// </ul>
    pub fn effective_permission(&self) -> std::option::Option<&crate::model::EffectivePermission> {
        self.effective_permission.as_ref()
    }
    /// <p>The account-level and bucket-level permissions settings for the bucket.</p>
    pub fn permission_configuration(
        &self,
    ) -> std::option::Option<&crate::model::BucketPermissionConfiguration> {
        self.permission_configuration.as_ref()
    }
}
impl std::fmt::Debug for BucketPublicAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketPublicAccess");
        formatter.field("effective_permission", &self.effective_permission);
        formatter.field("permission_configuration", &self.permission_configuration);
        formatter.finish()
    }
}
/// See [`BucketPublicAccess`](crate::model::BucketPublicAccess)
pub mod bucket_public_access {
    /// A builder for [`BucketPublicAccess`](crate::model::BucketPublicAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) effective_permission: std::option::Option<crate::model::EffectivePermission>,
        pub(crate) permission_configuration:
            std::option::Option<crate::model::BucketPermissionConfiguration>,
    }
    impl Builder {
        /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>NOT_PUBLIC - The bucket isn't publicly accessible.</p></li>
        /// <li><p>PUBLIC - The bucket is publicly accessible.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.</p></li>
        /// </ul>
        pub fn effective_permission(mut self, input: crate::model::EffectivePermission) -> Self {
            self.effective_permission = Some(input);
            self
        }
        /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>NOT_PUBLIC - The bucket isn't publicly accessible.</p></li>
        /// <li><p>PUBLIC - The bucket is publicly accessible.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.</p></li>
        /// </ul>
        pub fn set_effective_permission(
            mut self,
            input: std::option::Option<crate::model::EffectivePermission>,
        ) -> Self {
            self.effective_permission = input;
            self
        }
        /// <p>The account-level and bucket-level permissions settings for the bucket.</p>
        pub fn permission_configuration(
            mut self,
            input: crate::model::BucketPermissionConfiguration,
        ) -> Self {
            self.permission_configuration = Some(input);
            self
        }
        /// <p>The account-level and bucket-level permissions settings for the bucket.</p>
        pub fn set_permission_configuration(
            mut self,
            input: std::option::Option<crate::model::BucketPermissionConfiguration>,
        ) -> Self {
            self.permission_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketPublicAccess`](crate::model::BucketPublicAccess)
        pub fn build(self) -> crate::model::BucketPublicAccess {
            crate::model::BucketPublicAccess {
                effective_permission: self.effective_permission,
                permission_configuration: self.permission_configuration,
            }
        }
    }
}
impl BucketPublicAccess {
    /// Creates a new builder-style object to manufacture [`BucketPublicAccess`](crate::model::BucketPublicAccess)
    pub fn builder() -> crate::model::bucket_public_access::Builder {
        crate::model::bucket_public_access::Builder::default()
    }
}

/// <p>Provides information about the account-level and bucket-level permissions settings for an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketPermissionConfiguration {
    /// <p>The account-level permissions settings that apply to the bucket.</p>
    pub account_level_permissions: std::option::Option<crate::model::AccountLevelPermissions>,
    /// <p>The bucket-level permissions settings for the bucket.</p>
    pub bucket_level_permissions: std::option::Option<crate::model::BucketLevelPermissions>,
}
impl BucketPermissionConfiguration {
    /// <p>The account-level permissions settings that apply to the bucket.</p>
    pub fn account_level_permissions(
        &self,
    ) -> std::option::Option<&crate::model::AccountLevelPermissions> {
        self.account_level_permissions.as_ref()
    }
    /// <p>The bucket-level permissions settings for the bucket.</p>
    pub fn bucket_level_permissions(
        &self,
    ) -> std::option::Option<&crate::model::BucketLevelPermissions> {
        self.bucket_level_permissions.as_ref()
    }
}
impl std::fmt::Debug for BucketPermissionConfiguration {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketPermissionConfiguration");
        formatter.field("account_level_permissions", &self.account_level_permissions);
        formatter.field("bucket_level_permissions", &self.bucket_level_permissions);
        formatter.finish()
    }
}
/// See [`BucketPermissionConfiguration`](crate::model::BucketPermissionConfiguration)
pub mod bucket_permission_configuration {
    /// A builder for [`BucketPermissionConfiguration`](crate::model::BucketPermissionConfiguration)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_level_permissions:
            std::option::Option<crate::model::AccountLevelPermissions>,
        pub(crate) bucket_level_permissions:
            std::option::Option<crate::model::BucketLevelPermissions>,
    }
    impl Builder {
        /// <p>The account-level permissions settings that apply to the bucket.</p>
        pub fn account_level_permissions(
            mut self,
            input: crate::model::AccountLevelPermissions,
        ) -> Self {
            self.account_level_permissions = Some(input);
            self
        }
        /// <p>The account-level permissions settings that apply to the bucket.</p>
        pub fn set_account_level_permissions(
            mut self,
            input: std::option::Option<crate::model::AccountLevelPermissions>,
        ) -> Self {
            self.account_level_permissions = input;
            self
        }
        /// <p>The bucket-level permissions settings for the bucket.</p>
        pub fn bucket_level_permissions(
            mut self,
            input: crate::model::BucketLevelPermissions,
        ) -> Self {
            self.bucket_level_permissions = Some(input);
            self
        }
        /// <p>The bucket-level permissions settings for the bucket.</p>
        pub fn set_bucket_level_permissions(
            mut self,
            input: std::option::Option<crate::model::BucketLevelPermissions>,
        ) -> Self {
            self.bucket_level_permissions = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketPermissionConfiguration`](crate::model::BucketPermissionConfiguration)
        pub fn build(self) -> crate::model::BucketPermissionConfiguration {
            crate::model::BucketPermissionConfiguration {
                account_level_permissions: self.account_level_permissions,
                bucket_level_permissions: self.bucket_level_permissions,
            }
        }
    }
}
impl BucketPermissionConfiguration {
    /// Creates a new builder-style object to manufacture [`BucketPermissionConfiguration`](crate::model::BucketPermissionConfiguration)
    pub fn builder() -> crate::model::bucket_permission_configuration::Builder {
        crate::model::bucket_permission_configuration::Builder::default()
    }
}

/// <p>Provides information about the bucket-level permissions settings for an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketLevelPermissions {
    /// <p>The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.</p>
    pub access_control_list: std::option::Option<crate::model::AccessControlList>,
    /// <p>The block public access settings for the bucket.</p>
    pub block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
    /// <p>The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.</p>
    pub bucket_policy: std::option::Option<crate::model::BucketPolicy>,
}
impl BucketLevelPermissions {
    /// <p>The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.</p>
    pub fn access_control_list(&self) -> std::option::Option<&crate::model::AccessControlList> {
        self.access_control_list.as_ref()
    }
    /// <p>The block public access settings for the bucket.</p>
    pub fn block_public_access(&self) -> std::option::Option<&crate::model::BlockPublicAccess> {
        self.block_public_access.as_ref()
    }
    /// <p>The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.</p>
    pub fn bucket_policy(&self) -> std::option::Option<&crate::model::BucketPolicy> {
        self.bucket_policy.as_ref()
    }
}
impl std::fmt::Debug for BucketLevelPermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketLevelPermissions");
        formatter.field("access_control_list", &self.access_control_list);
        formatter.field("block_public_access", &self.block_public_access);
        formatter.field("bucket_policy", &self.bucket_policy);
        formatter.finish()
    }
}
/// See [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
pub mod bucket_level_permissions {
    /// A builder for [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_control_list: std::option::Option<crate::model::AccessControlList>,
        pub(crate) block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
        pub(crate) bucket_policy: std::option::Option<crate::model::BucketPolicy>,
    }
    impl Builder {
        /// <p>The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.</p>
        pub fn access_control_list(mut self, input: crate::model::AccessControlList) -> Self {
            self.access_control_list = Some(input);
            self
        }
        /// <p>The permissions settings of the access control list (ACL) for the bucket. This value is null if an ACL hasn't been defined for the bucket.</p>
        pub fn set_access_control_list(
            mut self,
            input: std::option::Option<crate::model::AccessControlList>,
        ) -> Self {
            self.access_control_list = input;
            self
        }
        /// <p>The block public access settings for the bucket.</p>
        pub fn block_public_access(mut self, input: crate::model::BlockPublicAccess) -> Self {
            self.block_public_access = Some(input);
            self
        }
        /// <p>The block public access settings for the bucket.</p>
        pub fn set_block_public_access(
            mut self,
            input: std::option::Option<crate::model::BlockPublicAccess>,
        ) -> Self {
            self.block_public_access = input;
            self
        }
        /// <p>The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.</p>
        pub fn bucket_policy(mut self, input: crate::model::BucketPolicy) -> Self {
            self.bucket_policy = Some(input);
            self
        }
        /// <p>The permissions settings of the bucket policy for the bucket. This value is null if a bucket policy hasn't been defined for the bucket.</p>
        pub fn set_bucket_policy(
            mut self,
            input: std::option::Option<crate::model::BucketPolicy>,
        ) -> Self {
            self.bucket_policy = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
        pub fn build(self) -> crate::model::BucketLevelPermissions {
            crate::model::BucketLevelPermissions {
                access_control_list: self.access_control_list,
                block_public_access: self.block_public_access,
                bucket_policy: self.bucket_policy,
            }
        }
    }
}
impl BucketLevelPermissions {
    /// Creates a new builder-style object to manufacture [`BucketLevelPermissions`](crate::model::BucketLevelPermissions)
    pub fn builder() -> crate::model::bucket_level_permissions::Builder {
        crate::model::bucket_level_permissions::Builder::default()
    }
}

/// <p>Provides information about the permissions settings of the bucket policy for an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketPolicy {
    /// <p>Specifies whether the bucket policy allows the general public to have read access to the bucket.</p>
    pub allows_public_read_access: bool,
    /// <p>Specifies whether the bucket policy allows the general public to have write access to the bucket.</p>
    pub allows_public_write_access: bool,
}
impl BucketPolicy {
    /// <p>Specifies whether the bucket policy allows the general public to have read access to the bucket.</p>
    pub fn allows_public_read_access(&self) -> bool {
        self.allows_public_read_access
    }
    /// <p>Specifies whether the bucket policy allows the general public to have write access to the bucket.</p>
    pub fn allows_public_write_access(&self) -> bool {
        self.allows_public_write_access
    }
}
impl std::fmt::Debug for BucketPolicy {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketPolicy");
        formatter.field("allows_public_read_access", &self.allows_public_read_access);
        formatter.field(
            "allows_public_write_access",
            &self.allows_public_write_access,
        );
        formatter.finish()
    }
}
/// See [`BucketPolicy`](crate::model::BucketPolicy)
pub mod bucket_policy {
    /// A builder for [`BucketPolicy`](crate::model::BucketPolicy)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allows_public_read_access: std::option::Option<bool>,
        pub(crate) allows_public_write_access: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether the bucket policy allows the general public to have read access to the bucket.</p>
        pub fn allows_public_read_access(mut self, input: bool) -> Self {
            self.allows_public_read_access = Some(input);
            self
        }
        /// <p>Specifies whether the bucket policy allows the general public to have read access to the bucket.</p>
        pub fn set_allows_public_read_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_read_access = input;
            self
        }
        /// <p>Specifies whether the bucket policy allows the general public to have write access to the bucket.</p>
        pub fn allows_public_write_access(mut self, input: bool) -> Self {
            self.allows_public_write_access = Some(input);
            self
        }
        /// <p>Specifies whether the bucket policy allows the general public to have write access to the bucket.</p>
        pub fn set_allows_public_write_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_write_access = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketPolicy`](crate::model::BucketPolicy)
        pub fn build(self) -> crate::model::BucketPolicy {
            crate::model::BucketPolicy {
                allows_public_read_access: self.allows_public_read_access.unwrap_or_default(),
                allows_public_write_access: self.allows_public_write_access.unwrap_or_default(),
            }
        }
    }
}
impl BucketPolicy {
    /// Creates a new builder-style object to manufacture [`BucketPolicy`](crate::model::BucketPolicy)
    pub fn builder() -> crate::model::bucket_policy::Builder {
        crate::model::bucket_policy::Builder::default()
    }
}

/// <p>Provides information about the block public access settings for an S3 bucket. These settings can apply to a bucket at the account level or bucket level. For detailed information about each setting, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html">Blocking public access to your Amazon S3 storage</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BlockPublicAccess {
    /// <p>Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.</p>
    pub block_public_acls: bool,
    /// <p>Specifies whether Amazon S3 blocks public bucket policies for the bucket.</p>
    pub block_public_policy: bool,
    /// <p>Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.</p>
    pub ignore_public_acls: bool,
    /// <p>Specifies whether Amazon S3 restricts public bucket policies for the bucket.</p>
    pub restrict_public_buckets: bool,
}
impl BlockPublicAccess {
    /// <p>Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.</p>
    pub fn block_public_acls(&self) -> bool {
        self.block_public_acls
    }
    /// <p>Specifies whether Amazon S3 blocks public bucket policies for the bucket.</p>
    pub fn block_public_policy(&self) -> bool {
        self.block_public_policy
    }
    /// <p>Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.</p>
    pub fn ignore_public_acls(&self) -> bool {
        self.ignore_public_acls
    }
    /// <p>Specifies whether Amazon S3 restricts public bucket policies for the bucket.</p>
    pub fn restrict_public_buckets(&self) -> bool {
        self.restrict_public_buckets
    }
}
impl std::fmt::Debug for BlockPublicAccess {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BlockPublicAccess");
        formatter.field("block_public_acls", &self.block_public_acls);
        formatter.field("block_public_policy", &self.block_public_policy);
        formatter.field("ignore_public_acls", &self.ignore_public_acls);
        formatter.field("restrict_public_buckets", &self.restrict_public_buckets);
        formatter.finish()
    }
}
/// See [`BlockPublicAccess`](crate::model::BlockPublicAccess)
pub mod block_public_access {
    /// A builder for [`BlockPublicAccess`](crate::model::BlockPublicAccess)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_acls: std::option::Option<bool>,
        pub(crate) block_public_policy: std::option::Option<bool>,
        pub(crate) ignore_public_acls: std::option::Option<bool>,
        pub(crate) restrict_public_buckets: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.</p>
        pub fn block_public_acls(mut self, input: bool) -> Self {
            self.block_public_acls = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.</p>
        pub fn set_block_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_acls = input;
            self
        }
        /// <p>Specifies whether Amazon S3 blocks public bucket policies for the bucket.</p>
        pub fn block_public_policy(mut self, input: bool) -> Self {
            self.block_public_policy = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 blocks public bucket policies for the bucket.</p>
        pub fn set_block_public_policy(mut self, input: std::option::Option<bool>) -> Self {
            self.block_public_policy = input;
            self
        }
        /// <p>Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.</p>
        pub fn ignore_public_acls(mut self, input: bool) -> Self {
            self.ignore_public_acls = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.</p>
        pub fn set_ignore_public_acls(mut self, input: std::option::Option<bool>) -> Self {
            self.ignore_public_acls = input;
            self
        }
        /// <p>Specifies whether Amazon S3 restricts public bucket policies for the bucket.</p>
        pub fn restrict_public_buckets(mut self, input: bool) -> Self {
            self.restrict_public_buckets = Some(input);
            self
        }
        /// <p>Specifies whether Amazon S3 restricts public bucket policies for the bucket.</p>
        pub fn set_restrict_public_buckets(mut self, input: std::option::Option<bool>) -> Self {
            self.restrict_public_buckets = input;
            self
        }
        /// Consumes the builder and constructs a [`BlockPublicAccess`](crate::model::BlockPublicAccess)
        pub fn build(self) -> crate::model::BlockPublicAccess {
            crate::model::BlockPublicAccess {
                block_public_acls: self.block_public_acls.unwrap_or_default(),
                block_public_policy: self.block_public_policy.unwrap_or_default(),
                ignore_public_acls: self.ignore_public_acls.unwrap_or_default(),
                restrict_public_buckets: self.restrict_public_buckets.unwrap_or_default(),
            }
        }
    }
}
impl BlockPublicAccess {
    /// Creates a new builder-style object to manufacture [`BlockPublicAccess`](crate::model::BlockPublicAccess)
    pub fn builder() -> crate::model::block_public_access::Builder {
        crate::model::block_public_access::Builder::default()
    }
}

/// <p>Provides information about the permissions settings of the bucket-level access control list (ACL) for an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessControlList {
    /// <p>Specifies whether the ACL grants the general public with read access permissions for the bucket.</p>
    pub allows_public_read_access: bool,
    /// <p>Specifies whether the ACL grants the general public with write access permissions for the bucket.</p>
    pub allows_public_write_access: bool,
}
impl AccessControlList {
    /// <p>Specifies whether the ACL grants the general public with read access permissions for the bucket.</p>
    pub fn allows_public_read_access(&self) -> bool {
        self.allows_public_read_access
    }
    /// <p>Specifies whether the ACL grants the general public with write access permissions for the bucket.</p>
    pub fn allows_public_write_access(&self) -> bool {
        self.allows_public_write_access
    }
}
impl std::fmt::Debug for AccessControlList {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessControlList");
        formatter.field("allows_public_read_access", &self.allows_public_read_access);
        formatter.field(
            "allows_public_write_access",
            &self.allows_public_write_access,
        );
        formatter.finish()
    }
}
/// See [`AccessControlList`](crate::model::AccessControlList)
pub mod access_control_list {
    /// A builder for [`AccessControlList`](crate::model::AccessControlList)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allows_public_read_access: std::option::Option<bool>,
        pub(crate) allows_public_write_access: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether the ACL grants the general public with read access permissions for the bucket.</p>
        pub fn allows_public_read_access(mut self, input: bool) -> Self {
            self.allows_public_read_access = Some(input);
            self
        }
        /// <p>Specifies whether the ACL grants the general public with read access permissions for the bucket.</p>
        pub fn set_allows_public_read_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_read_access = input;
            self
        }
        /// <p>Specifies whether the ACL grants the general public with write access permissions for the bucket.</p>
        pub fn allows_public_write_access(mut self, input: bool) -> Self {
            self.allows_public_write_access = Some(input);
            self
        }
        /// <p>Specifies whether the ACL grants the general public with write access permissions for the bucket.</p>
        pub fn set_allows_public_write_access(mut self, input: std::option::Option<bool>) -> Self {
            self.allows_public_write_access = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessControlList`](crate::model::AccessControlList)
        pub fn build(self) -> crate::model::AccessControlList {
            crate::model::AccessControlList {
                allows_public_read_access: self.allows_public_read_access.unwrap_or_default(),
                allows_public_write_access: self.allows_public_write_access.unwrap_or_default(),
            }
        }
    }
}
impl AccessControlList {
    /// Creates a new builder-style object to manufacture [`AccessControlList`](crate::model::AccessControlList)
    pub fn builder() -> crate::model::access_control_list::Builder {
        crate::model::access_control_list::Builder::default()
    }
}

/// <p>Provides information about the account-level permissions settings that apply to an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountLevelPermissions {
    /// <p>The block public access settings for the Amazon Web Services account that owns the bucket.</p>
    pub block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
}
impl AccountLevelPermissions {
    /// <p>The block public access settings for the Amazon Web Services account that owns the bucket.</p>
    pub fn block_public_access(&self) -> std::option::Option<&crate::model::BlockPublicAccess> {
        self.block_public_access.as_ref()
    }
}
impl std::fmt::Debug for AccountLevelPermissions {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountLevelPermissions");
        formatter.field("block_public_access", &self.block_public_access);
        formatter.finish()
    }
}
/// See [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
pub mod account_level_permissions {
    /// A builder for [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) block_public_access: std::option::Option<crate::model::BlockPublicAccess>,
    }
    impl Builder {
        /// <p>The block public access settings for the Amazon Web Services account that owns the bucket.</p>
        pub fn block_public_access(mut self, input: crate::model::BlockPublicAccess) -> Self {
            self.block_public_access = Some(input);
            self
        }
        /// <p>The block public access settings for the Amazon Web Services account that owns the bucket.</p>
        pub fn set_block_public_access(
            mut self,
            input: std::option::Option<crate::model::BlockPublicAccess>,
        ) -> Self {
            self.block_public_access = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
        pub fn build(self) -> crate::model::AccountLevelPermissions {
            crate::model::AccountLevelPermissions {
                block_public_access: self.block_public_access,
            }
        }
    }
}
impl AccountLevelPermissions {
    /// Creates a new builder-style object to manufacture [`AccountLevelPermissions`](crate::model::AccountLevelPermissions)
    pub fn builder() -> crate::model::account_level_permissions::Builder {
        crate::model::account_level_permissions::Builder::default()
    }
}

/// _Note: `EffectivePermission::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum EffectivePermission {
    #[allow(missing_docs)] // documentation missing in model
    NotPublic,
    #[allow(missing_docs)] // documentation missing in model
    Public,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for EffectivePermission {
    fn from(s: &str) -> Self {
        match s {
            "NOT_PUBLIC" => EffectivePermission::NotPublic,
            "PUBLIC" => EffectivePermission::Public,
            "UNKNOWN" => EffectivePermission::UnknownValue,
            other => EffectivePermission::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for EffectivePermission {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(EffectivePermission::from(s))
    }
}
impl EffectivePermission {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            EffectivePermission::NotPublic => "NOT_PUBLIC",
            EffectivePermission::Public => "PUBLIC",
            EffectivePermission::UnknownValue => "UNKNOWN",
            EffectivePermission::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["NOT_PUBLIC", "PUBLIC", "UNKNOWN"]
    }
}
impl AsRef<str> for EffectivePermission {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the Amazon Web Services account that owns an S3 bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3BucketOwner {
    /// <p>The display name of the account that owns the bucket.</p>
    pub display_name: std::option::Option<std::string::String>,
    /// <p>The canonical user ID for the account that owns the bucket.</p>
    pub id: std::option::Option<std::string::String>,
}
impl S3BucketOwner {
    /// <p>The display name of the account that owns the bucket.</p>
    pub fn display_name(&self) -> std::option::Option<&str> {
        self.display_name.as_deref()
    }
    /// <p>The canonical user ID for the account that owns the bucket.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for S3BucketOwner {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3BucketOwner");
        formatter.field("display_name", &self.display_name);
        formatter.field("id", &self.id);
        formatter.finish()
    }
}
/// See [`S3BucketOwner`](crate::model::S3BucketOwner)
pub mod s3_bucket_owner {
    /// A builder for [`S3BucketOwner`](crate::model::S3BucketOwner)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) display_name: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The display name of the account that owns the bucket.</p>
        pub fn display_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.display_name = Some(input.into());
            self
        }
        /// <p>The display name of the account that owns the bucket.</p>
        pub fn set_display_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.display_name = input;
            self
        }
        /// <p>The canonical user ID for the account that owns the bucket.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The canonical user ID for the account that owns the bucket.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`S3BucketOwner`](crate::model::S3BucketOwner)
        pub fn build(self) -> crate::model::S3BucketOwner {
            crate::model::S3BucketOwner {
                display_name: self.display_name,
                id: self.id,
            }
        }
    }
}
impl S3BucketOwner {
    /// Creates a new builder-style object to manufacture [`S3BucketOwner`](crate::model::S3BucketOwner)
    pub fn builder() -> crate::model::s3_bucket_owner::Builder {
        crate::model::s3_bucket_owner::Builder::default()
    }
}

/// _Note: `AllowsUnencryptedObjectUploads::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum AllowsUnencryptedObjectUploads {
    #[allow(missing_docs)] // documentation missing in model
    False,
    #[allow(missing_docs)] // documentation missing in model
    True,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for AllowsUnencryptedObjectUploads {
    fn from(s: &str) -> Self {
        match s {
            "FALSE" => AllowsUnencryptedObjectUploads::False,
            "TRUE" => AllowsUnencryptedObjectUploads::True,
            "UNKNOWN" => AllowsUnencryptedObjectUploads::UnknownValue,
            other => AllowsUnencryptedObjectUploads::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for AllowsUnencryptedObjectUploads {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(AllowsUnencryptedObjectUploads::from(s))
    }
}
impl AllowsUnencryptedObjectUploads {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            AllowsUnencryptedObjectUploads::False => "FALSE",
            AllowsUnencryptedObjectUploads::True => "TRUE",
            AllowsUnencryptedObjectUploads::UnknownValue => "UNKNOWN",
            AllowsUnencryptedObjectUploads::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FALSE", "TRUE", "UNKNOWN"]
    }
}
impl AsRef<str> for AllowsUnencryptedObjectUploads {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides the details of a policy finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PolicyDetails {
    /// <p>The action that produced the finding.</p>
    pub action: std::option::Option<crate::model::FindingAction>,
    /// <p>The entity that performed the action that produced the finding.</p>
    pub actor: std::option::Option<crate::model::FindingActor>,
}
impl PolicyDetails {
    /// <p>The action that produced the finding.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FindingAction> {
        self.action.as_ref()
    }
    /// <p>The entity that performed the action that produced the finding.</p>
    pub fn actor(&self) -> std::option::Option<&crate::model::FindingActor> {
        self.actor.as_ref()
    }
}
impl std::fmt::Debug for PolicyDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PolicyDetails");
        formatter.field("action", &self.action);
        formatter.field("actor", &self.actor);
        formatter.finish()
    }
}
/// See [`PolicyDetails`](crate::model::PolicyDetails)
pub mod policy_details {
    /// A builder for [`PolicyDetails`](crate::model::PolicyDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::FindingAction>,
        pub(crate) actor: std::option::Option<crate::model::FindingActor>,
    }
    impl Builder {
        /// <p>The action that produced the finding.</p>
        pub fn action(mut self, input: crate::model::FindingAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action that produced the finding.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>The entity that performed the action that produced the finding.</p>
        pub fn actor(mut self, input: crate::model::FindingActor) -> Self {
            self.actor = Some(input);
            self
        }
        /// <p>The entity that performed the action that produced the finding.</p>
        pub fn set_actor(mut self, input: std::option::Option<crate::model::FindingActor>) -> Self {
            self.actor = input;
            self
        }
        /// Consumes the builder and constructs a [`PolicyDetails`](crate::model::PolicyDetails)
        pub fn build(self) -> crate::model::PolicyDetails {
            crate::model::PolicyDetails {
                action: self.action,
                actor: self.actor,
            }
        }
    }
}
impl PolicyDetails {
    /// Creates a new builder-style object to manufacture [`PolicyDetails`](crate::model::PolicyDetails)
    pub fn builder() -> crate::model::policy_details::Builder {
        crate::model::policy_details::Builder::default()
    }
}

/// <p>Provides information about an entity that performed an action that produced a policy finding for a resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingActor {
    /// <p>The domain name of the device that the entity used to perform the action on the affected resource.</p>
    pub domain_details: std::option::Option<crate::model::DomainDetails>,
    /// <p>The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.</p>
    pub ip_address_details: std::option::Option<crate::model::IpAddressDetails>,
    /// <p>The type and other characteristics of the entity that performed the action on the affected resource.</p>
    pub user_identity: std::option::Option<crate::model::UserIdentity>,
}
impl FindingActor {
    /// <p>The domain name of the device that the entity used to perform the action on the affected resource.</p>
    pub fn domain_details(&self) -> std::option::Option<&crate::model::DomainDetails> {
        self.domain_details.as_ref()
    }
    /// <p>The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.</p>
    pub fn ip_address_details(&self) -> std::option::Option<&crate::model::IpAddressDetails> {
        self.ip_address_details.as_ref()
    }
    /// <p>The type and other characteristics of the entity that performed the action on the affected resource.</p>
    pub fn user_identity(&self) -> std::option::Option<&crate::model::UserIdentity> {
        self.user_identity.as_ref()
    }
}
impl std::fmt::Debug for FindingActor {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingActor");
        formatter.field("domain_details", &self.domain_details);
        formatter.field("ip_address_details", &self.ip_address_details);
        formatter.field("user_identity", &self.user_identity);
        formatter.finish()
    }
}
/// See [`FindingActor`](crate::model::FindingActor)
pub mod finding_actor {
    /// A builder for [`FindingActor`](crate::model::FindingActor)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_details: std::option::Option<crate::model::DomainDetails>,
        pub(crate) ip_address_details: std::option::Option<crate::model::IpAddressDetails>,
        pub(crate) user_identity: std::option::Option<crate::model::UserIdentity>,
    }
    impl Builder {
        /// <p>The domain name of the device that the entity used to perform the action on the affected resource.</p>
        pub fn domain_details(mut self, input: crate::model::DomainDetails) -> Self {
            self.domain_details = Some(input);
            self
        }
        /// <p>The domain name of the device that the entity used to perform the action on the affected resource.</p>
        pub fn set_domain_details(
            mut self,
            input: std::option::Option<crate::model::DomainDetails>,
        ) -> Self {
            self.domain_details = input;
            self
        }
        /// <p>The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.</p>
        pub fn ip_address_details(mut self, input: crate::model::IpAddressDetails) -> Self {
            self.ip_address_details = Some(input);
            self
        }
        /// <p>The IP address of the device that the entity used to perform the action on the affected resource. This object also provides information such as the owner and geographic location for the IP address.</p>
        pub fn set_ip_address_details(
            mut self,
            input: std::option::Option<crate::model::IpAddressDetails>,
        ) -> Self {
            self.ip_address_details = input;
            self
        }
        /// <p>The type and other characteristics of the entity that performed the action on the affected resource.</p>
        pub fn user_identity(mut self, input: crate::model::UserIdentity) -> Self {
            self.user_identity = Some(input);
            self
        }
        /// <p>The type and other characteristics of the entity that performed the action on the affected resource.</p>
        pub fn set_user_identity(
            mut self,
            input: std::option::Option<crate::model::UserIdentity>,
        ) -> Self {
            self.user_identity = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingActor`](crate::model::FindingActor)
        pub fn build(self) -> crate::model::FindingActor {
            crate::model::FindingActor {
                domain_details: self.domain_details,
                ip_address_details: self.ip_address_details,
                user_identity: self.user_identity,
            }
        }
    }
}
impl FindingActor {
    /// Creates a new builder-style object to manufacture [`FindingActor`](crate::model::FindingActor)
    pub fn builder() -> crate::model::finding_actor::Builder {
        crate::model::finding_actor::Builder::default()
    }
}

/// <p>Provides information about the type and other characteristics of an entity that performed an action on an affected resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserIdentity {
    /// <p>If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
    pub assumed_role: std::option::Option<crate::model::AssumedRole>,
    /// <p>If the action was performed using the credentials for another Amazon Web Services account, the details of that account.</p>
    pub aws_account: std::option::Option<crate::model::AwsAccount>,
    /// <p>If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.</p>
    pub aws_service: std::option::Option<crate::model::AwsService>,
    /// <p>If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
    pub federated_user: std::option::Option<crate::model::FederatedUser>,
    /// <p>If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.</p>
    pub iam_user: std::option::Option<crate::model::IamUser>,
    /// <p>If the action was performed using the credentials for your Amazon Web Services account, the details of your account.</p>
    pub root: std::option::Option<crate::model::UserIdentityRoot>,
    /// <p>The type of entity that performed the action.</p>
    pub r#type: std::option::Option<crate::model::UserIdentityType>,
}
impl UserIdentity {
    /// <p>If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
    pub fn assumed_role(&self) -> std::option::Option<&crate::model::AssumedRole> {
        self.assumed_role.as_ref()
    }
    /// <p>If the action was performed using the credentials for another Amazon Web Services account, the details of that account.</p>
    pub fn aws_account(&self) -> std::option::Option<&crate::model::AwsAccount> {
        self.aws_account.as_ref()
    }
    /// <p>If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.</p>
    pub fn aws_service(&self) -> std::option::Option<&crate::model::AwsService> {
        self.aws_service.as_ref()
    }
    /// <p>If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
    pub fn federated_user(&self) -> std::option::Option<&crate::model::FederatedUser> {
        self.federated_user.as_ref()
    }
    /// <p>If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.</p>
    pub fn iam_user(&self) -> std::option::Option<&crate::model::IamUser> {
        self.iam_user.as_ref()
    }
    /// <p>If the action was performed using the credentials for your Amazon Web Services account, the details of your account.</p>
    pub fn root(&self) -> std::option::Option<&crate::model::UserIdentityRoot> {
        self.root.as_ref()
    }
    /// <p>The type of entity that performed the action.</p>
    pub fn r#type(&self) -> std::option::Option<&crate::model::UserIdentityType> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for UserIdentity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserIdentity");
        formatter.field("assumed_role", &self.assumed_role);
        formatter.field("aws_account", &self.aws_account);
        formatter.field("aws_service", &self.aws_service);
        formatter.field("federated_user", &self.federated_user);
        formatter.field("iam_user", &self.iam_user);
        formatter.field("root", &self.root);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`UserIdentity`](crate::model::UserIdentity)
pub mod user_identity {
    /// A builder for [`UserIdentity`](crate::model::UserIdentity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) assumed_role: std::option::Option<crate::model::AssumedRole>,
        pub(crate) aws_account: std::option::Option<crate::model::AwsAccount>,
        pub(crate) aws_service: std::option::Option<crate::model::AwsService>,
        pub(crate) federated_user: std::option::Option<crate::model::FederatedUser>,
        pub(crate) iam_user: std::option::Option<crate::model::IamUser>,
        pub(crate) root: std::option::Option<crate::model::UserIdentityRoot>,
        pub(crate) r#type: std::option::Option<crate::model::UserIdentityType>,
    }
    impl Builder {
        /// <p>If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
        pub fn assumed_role(mut self, input: crate::model::AssumedRole) -> Self {
            self.assumed_role = Some(input);
            self
        }
        /// <p>If the action was performed with temporary security credentials that were obtained using the AssumeRole operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
        pub fn set_assumed_role(
            mut self,
            input: std::option::Option<crate::model::AssumedRole>,
        ) -> Self {
            self.assumed_role = input;
            self
        }
        /// <p>If the action was performed using the credentials for another Amazon Web Services account, the details of that account.</p>
        pub fn aws_account(mut self, input: crate::model::AwsAccount) -> Self {
            self.aws_account = Some(input);
            self
        }
        /// <p>If the action was performed using the credentials for another Amazon Web Services account, the details of that account.</p>
        pub fn set_aws_account(
            mut self,
            input: std::option::Option<crate::model::AwsAccount>,
        ) -> Self {
            self.aws_account = input;
            self
        }
        /// <p>If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.</p>
        pub fn aws_service(mut self, input: crate::model::AwsService) -> Self {
            self.aws_service = Some(input);
            self
        }
        /// <p>If the action was performed by an Amazon Web Services account that belongs to an Amazon Web Service, the name of the service.</p>
        pub fn set_aws_service(
            mut self,
            input: std::option::Option<crate::model::AwsService>,
        ) -> Self {
            self.aws_service = input;
            self
        }
        /// <p>If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
        pub fn federated_user(mut self, input: crate::model::FederatedUser) -> Self {
            self.federated_user = Some(input);
            self
        }
        /// <p>If the action was performed with temporary security credentials that were obtained using the GetFederationToken operation of the Security Token Service (STS) API, the identifiers, session context, and other details about the identity.</p>
        pub fn set_federated_user(
            mut self,
            input: std::option::Option<crate::model::FederatedUser>,
        ) -> Self {
            self.federated_user = input;
            self
        }
        /// <p>If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.</p>
        pub fn iam_user(mut self, input: crate::model::IamUser) -> Self {
            self.iam_user = Some(input);
            self
        }
        /// <p>If the action was performed using the credentials for an Identity and Access Management (IAM) user, the name and other details about the user.</p>
        pub fn set_iam_user(mut self, input: std::option::Option<crate::model::IamUser>) -> Self {
            self.iam_user = input;
            self
        }
        /// <p>If the action was performed using the credentials for your Amazon Web Services account, the details of your account.</p>
        pub fn root(mut self, input: crate::model::UserIdentityRoot) -> Self {
            self.root = Some(input);
            self
        }
        /// <p>If the action was performed using the credentials for your Amazon Web Services account, the details of your account.</p>
        pub fn set_root(
            mut self,
            input: std::option::Option<crate::model::UserIdentityRoot>,
        ) -> Self {
            self.root = input;
            self
        }
        /// <p>The type of entity that performed the action.</p>
        pub fn r#type(mut self, input: crate::model::UserIdentityType) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of entity that performed the action.</p>
        pub fn set_type(
            mut self,
            input: std::option::Option<crate::model::UserIdentityType>,
        ) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`UserIdentity`](crate::model::UserIdentity)
        pub fn build(self) -> crate::model::UserIdentity {
            crate::model::UserIdentity {
                assumed_role: self.assumed_role,
                aws_account: self.aws_account,
                aws_service: self.aws_service,
                federated_user: self.federated_user,
                iam_user: self.iam_user,
                root: self.root,
                r#type: self.r#type,
            }
        }
    }
}
impl UserIdentity {
    /// Creates a new builder-style object to manufacture [`UserIdentity`](crate::model::UserIdentity)
    pub fn builder() -> crate::model::user_identity::Builder {
        crate::model::user_identity::Builder::default()
    }
}

/// <p>The type of entity that performed the action on the affected resource. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum UserIdentityType {
    #[allow(missing_docs)] // documentation missing in model
    AwsAccount,
    #[allow(missing_docs)] // documentation missing in model
    AwsService,
    #[allow(missing_docs)] // documentation missing in model
    AssumedRole,
    #[allow(missing_docs)] // documentation missing in model
    FederatedUser,
    #[allow(missing_docs)] // documentation missing in model
    IamUser,
    #[allow(missing_docs)] // documentation missing in model
    Root,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for UserIdentityType {
    fn from(s: &str) -> Self {
        match s {
            "AWSAccount" => UserIdentityType::AwsAccount,
            "AWSService" => UserIdentityType::AwsService,
            "AssumedRole" => UserIdentityType::AssumedRole,
            "FederatedUser" => UserIdentityType::FederatedUser,
            "IAMUser" => UserIdentityType::IamUser,
            "Root" => UserIdentityType::Root,
            other => UserIdentityType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for UserIdentityType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(UserIdentityType::from(s))
    }
}
impl UserIdentityType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            UserIdentityType::AwsAccount => "AWSAccount",
            UserIdentityType::AwsService => "AWSService",
            UserIdentityType::AssumedRole => "AssumedRole",
            UserIdentityType::FederatedUser => "FederatedUser",
            UserIdentityType::IamUser => "IAMUser",
            UserIdentityType::Root => "Root",
            UserIdentityType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "AWSAccount",
            "AWSService",
            "AssumedRole",
            "FederatedUser",
            "IAMUser",
            "Root",
        ]
    }
}
impl AsRef<str> for UserIdentityType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for your Amazon Web Services account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UserIdentityRoot {
    /// <p>The unique identifier for the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the entity that performed the action.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl UserIdentityRoot {
    /// <p>The unique identifier for the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier for the entity that performed the action.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for UserIdentityRoot {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UserIdentityRoot");
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}
/// See [`UserIdentityRoot`](crate::model::UserIdentityRoot)
pub mod user_identity_root {
    /// A builder for [`UserIdentityRoot`](crate::model::UserIdentityRoot)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user or role that performed the action.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier for the entity that performed the action.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity that performed the action.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UserIdentityRoot`](crate::model::UserIdentityRoot)
        pub fn build(self) -> crate::model::UserIdentityRoot {
            crate::model::UserIdentityRoot {
                account_id: self.account_id,
                arn: self.arn,
                principal_id: self.principal_id,
            }
        }
    }
}
impl UserIdentityRoot {
    /// Creates a new builder-style object to manufacture [`UserIdentityRoot`](crate::model::UserIdentityRoot)
    pub fn builder() -> crate::model::user_identity_root::Builder {
        crate::model::user_identity_root::Builder::default()
    }
}

/// <p>Provides information about an Identity and Access Management (IAM) user who performed an action on an affected resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IamUser {
    /// <p>The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the IAM user who performed the action.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The user name of the IAM user who performed the action.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl IamUser {
    /// <p>The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier for the IAM user who performed the action.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The user name of the IAM user who performed the action.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for IamUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IamUser");
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`IamUser`](crate::model::IamUser)
pub mod iam_user {
    /// A builder for [`IamUser`](crate::model::IamUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that's associated with the IAM user who performed the action.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the principal that performed the action. The last section of the ARN contains the name of the user who performed the action.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier for the IAM user who performed the action.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the IAM user who performed the action.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The user name of the IAM user who performed the action.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The user name of the IAM user who performed the action.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`IamUser`](crate::model::IamUser)
        pub fn build(self) -> crate::model::IamUser {
            crate::model::IamUser {
                account_id: self.account_id,
                arn: self.arn,
                principal_id: self.principal_id,
                user_name: self.user_name,
            }
        }
    }
}
impl IamUser {
    /// Creates a new builder-style object to manufacture [`IamUser`](crate::model::IamUser)
    pub fn builder() -> crate::model::iam_user::Builder {
        crate::model::iam_user::Builder::default()
    }
}

/// <p>Provides information about an identity that performed an action on an affected resource by using temporary security credentials. The credentials were obtained using the GetFederationToken operation of the Security Token Service (STS) API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FederatedUser {
    /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the entity that was used to get the credentials.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
    pub session_context: std::option::Option<crate::model::SessionContext>,
}
impl FederatedUser {
    /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier for the entity that was used to get the credentials.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
    pub fn session_context(&self) -> std::option::Option<&crate::model::SessionContext> {
        self.session_context.as_ref()
    }
}
impl std::fmt::Debug for FederatedUser {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FederatedUser");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("session_context", &self.session_context);
        formatter.finish()
    }
}
/// See [`FederatedUser`](crate::model::FederatedUser)
pub mod federated_user {
    /// A builder for [`FederatedUser`](crate::model::FederatedUser)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) session_context: std::option::Option<crate::model::SessionContext>,
    }
    impl Builder {
        /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier for the entity that was used to get the credentials.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity that was used to get the credentials.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
        pub fn session_context(mut self, input: crate::model::SessionContext) -> Self {
            self.session_context = Some(input);
            self
        }
        /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
        pub fn set_session_context(
            mut self,
            input: std::option::Option<crate::model::SessionContext>,
        ) -> Self {
            self.session_context = input;
            self
        }
        /// Consumes the builder and constructs a [`FederatedUser`](crate::model::FederatedUser)
        pub fn build(self) -> crate::model::FederatedUser {
            crate::model::FederatedUser {
                access_key_id: self.access_key_id,
                account_id: self.account_id,
                arn: self.arn,
                principal_id: self.principal_id,
                session_context: self.session_context,
            }
        }
    }
}
impl FederatedUser {
    /// Creates a new builder-style object to manufacture [`FederatedUser`](crate::model::FederatedUser)
    pub fn builder() -> crate::model::federated_user::Builder {
        crate::model::federated_user::Builder::default()
    }
}

/// <p>Provides information about a session that was created for an entity that performed an action by using temporary security credentials.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionContext {
    /// <p>The date and time when the credentials were issued, and whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
    pub attributes: std::option::Option<crate::model::SessionContextAttributes>,
    /// <p>The source and type of credentials that were issued to the entity.</p>
    pub session_issuer: std::option::Option<crate::model::SessionIssuer>,
}
impl SessionContext {
    /// <p>The date and time when the credentials were issued, and whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
    pub fn attributes(&self) -> std::option::Option<&crate::model::SessionContextAttributes> {
        self.attributes.as_ref()
    }
    /// <p>The source and type of credentials that were issued to the entity.</p>
    pub fn session_issuer(&self) -> std::option::Option<&crate::model::SessionIssuer> {
        self.session_issuer.as_ref()
    }
}
impl std::fmt::Debug for SessionContext {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionContext");
        formatter.field("attributes", &self.attributes);
        formatter.field("session_issuer", &self.session_issuer);
        formatter.finish()
    }
}
/// See [`SessionContext`](crate::model::SessionContext)
pub mod session_context {
    /// A builder for [`SessionContext`](crate::model::SessionContext)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attributes: std::option::Option<crate::model::SessionContextAttributes>,
        pub(crate) session_issuer: std::option::Option<crate::model::SessionIssuer>,
    }
    impl Builder {
        /// <p>The date and time when the credentials were issued, and whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
        pub fn attributes(mut self, input: crate::model::SessionContextAttributes) -> Self {
            self.attributes = Some(input);
            self
        }
        /// <p>The date and time when the credentials were issued, and whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
        pub fn set_attributes(
            mut self,
            input: std::option::Option<crate::model::SessionContextAttributes>,
        ) -> Self {
            self.attributes = input;
            self
        }
        /// <p>The source and type of credentials that were issued to the entity.</p>
        pub fn session_issuer(mut self, input: crate::model::SessionIssuer) -> Self {
            self.session_issuer = Some(input);
            self
        }
        /// <p>The source and type of credentials that were issued to the entity.</p>
        pub fn set_session_issuer(
            mut self,
            input: std::option::Option<crate::model::SessionIssuer>,
        ) -> Self {
            self.session_issuer = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionContext`](crate::model::SessionContext)
        pub fn build(self) -> crate::model::SessionContext {
            crate::model::SessionContext {
                attributes: self.attributes,
                session_issuer: self.session_issuer,
            }
        }
    }
}
impl SessionContext {
    /// Creates a new builder-style object to manufacture [`SessionContext`](crate::model::SessionContext)
    pub fn builder() -> crate::model::session_context::Builder {
        crate::model::session_context::Builder::default()
    }
}

/// <p>Provides information about the source and type of temporary security credentials that were issued to an entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionIssuer {
    /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the entity that was used to get the credentials.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The source of the temporary security credentials, such as Root, IAMUser, or Role.</p>
    pub r#type: std::option::Option<std::string::String>,
    /// <p>The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.</p>
    pub user_name: std::option::Option<std::string::String>,
}
impl SessionIssuer {
    /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier for the entity that was used to get the credentials.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The source of the temporary security credentials, such as Root, IAMUser, or Role.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.</p>
    pub fn user_name(&self) -> std::option::Option<&str> {
        self.user_name.as_deref()
    }
}
impl std::fmt::Debug for SessionIssuer {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionIssuer");
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("r#type", &self.r#type);
        formatter.field("user_name", &self.user_name);
        formatter.finish()
    }
}
/// See [`SessionIssuer`](crate::model::SessionIssuer)
pub mod session_issuer {
    /// A builder for [`SessionIssuer`](crate::model::SessionIssuer)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<std::string::String>,
        pub(crate) user_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the source account, IAM user, or role that was used to get the credentials.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier for the entity that was used to get the credentials.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity that was used to get the credentials.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The source of the temporary security credentials, such as Root, IAMUser, or Role.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The source of the temporary security credentials, such as Root, IAMUser, or Role.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// <p>The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.</p>
        pub fn user_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.user_name = Some(input.into());
            self
        }
        /// <p>The name or alias of the user or role that issued the session. This value is null if the credentials were obtained from a root account that doesn't have an alias.</p>
        pub fn set_user_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.user_name = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionIssuer`](crate::model::SessionIssuer)
        pub fn build(self) -> crate::model::SessionIssuer {
            crate::model::SessionIssuer {
                account_id: self.account_id,
                arn: self.arn,
                principal_id: self.principal_id,
                r#type: self.r#type,
                user_name: self.user_name,
            }
        }
    }
}
impl SessionIssuer {
    /// Creates a new builder-style object to manufacture [`SessionIssuer`](crate::model::SessionIssuer)
    pub fn builder() -> crate::model::session_issuer::Builder {
        crate::model::session_issuer::Builder::default()
    }
}

/// <p>Provides information about the context in which temporary security credentials were issued to an entity.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SessionContextAttributes {
    /// <p>The date and time, in UTC and ISO 8601 format, when the credentials were issued.</p>
    pub creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
    pub mfa_authenticated: bool,
}
impl SessionContextAttributes {
    /// <p>The date and time, in UTC and ISO 8601 format, when the credentials were issued.</p>
    pub fn creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.creation_date.as_ref()
    }
    /// <p>Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
    pub fn mfa_authenticated(&self) -> bool {
        self.mfa_authenticated
    }
}
impl std::fmt::Debug for SessionContextAttributes {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SessionContextAttributes");
        formatter.field("creation_date", &self.creation_date);
        formatter.field("mfa_authenticated", &self.mfa_authenticated);
        formatter.finish()
    }
}
/// See [`SessionContextAttributes`](crate::model::SessionContextAttributes)
pub mod session_context_attributes {
    /// A builder for [`SessionContextAttributes`](crate::model::SessionContextAttributes)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) mfa_authenticated: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The date and time, in UTC and ISO 8601 format, when the credentials were issued.</p>
        pub fn creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.creation_date = Some(input);
            self
        }
        /// <p>The date and time, in UTC and ISO 8601 format, when the credentials were issued.</p>
        pub fn set_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.creation_date = input;
            self
        }
        /// <p>Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
        pub fn mfa_authenticated(mut self, input: bool) -> Self {
            self.mfa_authenticated = Some(input);
            self
        }
        /// <p>Specifies whether the credentials were authenticated with a multi-factor authentication (MFA) device.</p>
        pub fn set_mfa_authenticated(mut self, input: std::option::Option<bool>) -> Self {
            self.mfa_authenticated = input;
            self
        }
        /// Consumes the builder and constructs a [`SessionContextAttributes`](crate::model::SessionContextAttributes)
        pub fn build(self) -> crate::model::SessionContextAttributes {
            crate::model::SessionContextAttributes {
                creation_date: self.creation_date,
                mfa_authenticated: self.mfa_authenticated.unwrap_or_default(),
            }
        }
    }
}
impl SessionContextAttributes {
    /// Creates a new builder-style object to manufacture [`SessionContextAttributes`](crate::model::SessionContextAttributes)
    pub fn builder() -> crate::model::session_context_attributes::Builder {
        crate::model::session_context_attributes::Builder::default()
    }
}

/// <p>Provides information about an Amazon Web Service that performed an action on an affected resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsService {
    /// <p>The name of the Amazon Web Service that performed the action.</p>
    pub invoked_by: std::option::Option<std::string::String>,
}
impl AwsService {
    /// <p>The name of the Amazon Web Service that performed the action.</p>
    pub fn invoked_by(&self) -> std::option::Option<&str> {
        self.invoked_by.as_deref()
    }
}
impl std::fmt::Debug for AwsService {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsService");
        formatter.field("invoked_by", &self.invoked_by);
        formatter.finish()
    }
}
/// See [`AwsService`](crate::model::AwsService)
pub mod aws_service {
    /// A builder for [`AwsService`](crate::model::AwsService)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) invoked_by: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the Amazon Web Service that performed the action.</p>
        pub fn invoked_by(mut self, input: impl Into<std::string::String>) -> Self {
            self.invoked_by = Some(input.into());
            self
        }
        /// <p>The name of the Amazon Web Service that performed the action.</p>
        pub fn set_invoked_by(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.invoked_by = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsService`](crate::model::AwsService)
        pub fn build(self) -> crate::model::AwsService {
            crate::model::AwsService {
                invoked_by: self.invoked_by,
            }
        }
    }
}
impl AwsService {
    /// Creates a new builder-style object to manufacture [`AwsService`](crate::model::AwsService)
    pub fn builder() -> crate::model::aws_service::Builder {
        crate::model::aws_service::Builder::default()
    }
}

/// <p>Provides information about an Amazon Web Services account and entity that performed an action on an affected resource. The action was performed using the credentials for an Amazon Web Services account other than your own account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AwsAccount {
    /// <p>The unique identifier for the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the entity that performed the action.</p>
    pub principal_id: std::option::Option<std::string::String>,
}
impl AwsAccount {
    /// <p>The unique identifier for the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The unique identifier for the entity that performed the action.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
}
impl std::fmt::Debug for AwsAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AwsAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("principal_id", &self.principal_id);
        formatter.finish()
    }
}
/// See [`AwsAccount`](crate::model::AwsAccount)
pub mod aws_account {
    /// A builder for [`AwsAccount`](crate::model::AwsAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The unique identifier for the entity that performed the action.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity that performed the action.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// Consumes the builder and constructs a [`AwsAccount`](crate::model::AwsAccount)
        pub fn build(self) -> crate::model::AwsAccount {
            crate::model::AwsAccount {
                account_id: self.account_id,
                principal_id: self.principal_id,
            }
        }
    }
}
impl AwsAccount {
    /// Creates a new builder-style object to manufacture [`AwsAccount`](crate::model::AwsAccount)
    pub fn builder() -> crate::model::aws_account::Builder {
        crate::model::aws_account::Builder::default()
    }
}

/// <p>Provides information about an identity that performed an action on an affected resource by using temporary security credentials. The credentials were obtained using the AssumeRole operation of the Security Token Service (STS) API.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AssumedRole {
    /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
    pub access_key_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the entity that was used to get the credentials.</p>
    pub principal_id: std::option::Option<std::string::String>,
    /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
    pub session_context: std::option::Option<crate::model::SessionContext>,
}
impl AssumedRole {
    /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
    pub fn access_key_id(&self) -> std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The unique identifier for the entity that was used to get the credentials.</p>
    pub fn principal_id(&self) -> std::option::Option<&str> {
        self.principal_id.as_deref()
    }
    /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
    pub fn session_context(&self) -> std::option::Option<&crate::model::SessionContext> {
        self.session_context.as_ref()
    }
}
impl std::fmt::Debug for AssumedRole {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AssumedRole");
        formatter.field("access_key_id", &self.access_key_id);
        formatter.field("account_id", &self.account_id);
        formatter.field("arn", &self.arn);
        formatter.field("principal_id", &self.principal_id);
        formatter.field("session_context", &self.session_context);
        formatter.finish()
    }
}
/// See [`AssumedRole`](crate::model::AssumedRole)
pub mod assumed_role {
    /// A builder for [`AssumedRole`](crate::model::AssumedRole)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) access_key_id: std::option::Option<std::string::String>,
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) principal_id: std::option::Option<std::string::String>,
        pub(crate) session_context: std::option::Option<crate::model::SessionContext>,
    }
    impl Builder {
        /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
        pub fn access_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.access_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services access key ID that identifies the credentials.</p>
        pub fn set_access_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.access_key_id = input;
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the entity that was used to get the credentials.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The unique identifier for the entity that was used to get the credentials.</p>
        pub fn principal_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.principal_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the entity that was used to get the credentials.</p>
        pub fn set_principal_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.principal_id = input;
            self
        }
        /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
        pub fn session_context(mut self, input: crate::model::SessionContext) -> Self {
            self.session_context = Some(input);
            self
        }
        /// <p>The details of the session that was created for the credentials, including the entity that issued the session.</p>
        pub fn set_session_context(
            mut self,
            input: std::option::Option<crate::model::SessionContext>,
        ) -> Self {
            self.session_context = input;
            self
        }
        /// Consumes the builder and constructs a [`AssumedRole`](crate::model::AssumedRole)
        pub fn build(self) -> crate::model::AssumedRole {
            crate::model::AssumedRole {
                access_key_id: self.access_key_id,
                account_id: self.account_id,
                arn: self.arn,
                principal_id: self.principal_id,
                session_context: self.session_context,
            }
        }
    }
}
impl AssumedRole {
    /// Creates a new builder-style object to manufacture [`AssumedRole`](crate::model::AssumedRole)
    pub fn builder() -> crate::model::assumed_role::Builder {
        crate::model::assumed_role::Builder::default()
    }
}

/// <p>Provides information about the IP address of the device that an entity used to perform an action on an affected resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpAddressDetails {
    /// <p>The Internet Protocol version 4 (IPv4) address of the device.</p>
    pub ip_address_v4: std::option::Option<std::string::String>,
    /// <p>The city that the IP address originated from.</p>
    pub ip_city: std::option::Option<crate::model::IpCity>,
    /// <p>The country that the IP address originated from.</p>
    pub ip_country: std::option::Option<crate::model::IpCountry>,
    /// <p>The geographic coordinates of the location that the IP address originated from.</p>
    pub ip_geo_location: std::option::Option<crate::model::IpGeoLocation>,
    /// <p>The registered owner of the IP address.</p>
    pub ip_owner: std::option::Option<crate::model::IpOwner>,
}
impl IpAddressDetails {
    /// <p>The Internet Protocol version 4 (IPv4) address of the device.</p>
    pub fn ip_address_v4(&self) -> std::option::Option<&str> {
        self.ip_address_v4.as_deref()
    }
    /// <p>The city that the IP address originated from.</p>
    pub fn ip_city(&self) -> std::option::Option<&crate::model::IpCity> {
        self.ip_city.as_ref()
    }
    /// <p>The country that the IP address originated from.</p>
    pub fn ip_country(&self) -> std::option::Option<&crate::model::IpCountry> {
        self.ip_country.as_ref()
    }
    /// <p>The geographic coordinates of the location that the IP address originated from.</p>
    pub fn ip_geo_location(&self) -> std::option::Option<&crate::model::IpGeoLocation> {
        self.ip_geo_location.as_ref()
    }
    /// <p>The registered owner of the IP address.</p>
    pub fn ip_owner(&self) -> std::option::Option<&crate::model::IpOwner> {
        self.ip_owner.as_ref()
    }
}
impl std::fmt::Debug for IpAddressDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpAddressDetails");
        formatter.field("ip_address_v4", &self.ip_address_v4);
        formatter.field("ip_city", &self.ip_city);
        formatter.field("ip_country", &self.ip_country);
        formatter.field("ip_geo_location", &self.ip_geo_location);
        formatter.field("ip_owner", &self.ip_owner);
        formatter.finish()
    }
}
/// See [`IpAddressDetails`](crate::model::IpAddressDetails)
pub mod ip_address_details {
    /// A builder for [`IpAddressDetails`](crate::model::IpAddressDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ip_address_v4: std::option::Option<std::string::String>,
        pub(crate) ip_city: std::option::Option<crate::model::IpCity>,
        pub(crate) ip_country: std::option::Option<crate::model::IpCountry>,
        pub(crate) ip_geo_location: std::option::Option<crate::model::IpGeoLocation>,
        pub(crate) ip_owner: std::option::Option<crate::model::IpOwner>,
    }
    impl Builder {
        /// <p>The Internet Protocol version 4 (IPv4) address of the device.</p>
        pub fn ip_address_v4(mut self, input: impl Into<std::string::String>) -> Self {
            self.ip_address_v4 = Some(input.into());
            self
        }
        /// <p>The Internet Protocol version 4 (IPv4) address of the device.</p>
        pub fn set_ip_address_v4(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ip_address_v4 = input;
            self
        }
        /// <p>The city that the IP address originated from.</p>
        pub fn ip_city(mut self, input: crate::model::IpCity) -> Self {
            self.ip_city = Some(input);
            self
        }
        /// <p>The city that the IP address originated from.</p>
        pub fn set_ip_city(mut self, input: std::option::Option<crate::model::IpCity>) -> Self {
            self.ip_city = input;
            self
        }
        /// <p>The country that the IP address originated from.</p>
        pub fn ip_country(mut self, input: crate::model::IpCountry) -> Self {
            self.ip_country = Some(input);
            self
        }
        /// <p>The country that the IP address originated from.</p>
        pub fn set_ip_country(
            mut self,
            input: std::option::Option<crate::model::IpCountry>,
        ) -> Self {
            self.ip_country = input;
            self
        }
        /// <p>The geographic coordinates of the location that the IP address originated from.</p>
        pub fn ip_geo_location(mut self, input: crate::model::IpGeoLocation) -> Self {
            self.ip_geo_location = Some(input);
            self
        }
        /// <p>The geographic coordinates of the location that the IP address originated from.</p>
        pub fn set_ip_geo_location(
            mut self,
            input: std::option::Option<crate::model::IpGeoLocation>,
        ) -> Self {
            self.ip_geo_location = input;
            self
        }
        /// <p>The registered owner of the IP address.</p>
        pub fn ip_owner(mut self, input: crate::model::IpOwner) -> Self {
            self.ip_owner = Some(input);
            self
        }
        /// <p>The registered owner of the IP address.</p>
        pub fn set_ip_owner(mut self, input: std::option::Option<crate::model::IpOwner>) -> Self {
            self.ip_owner = input;
            self
        }
        /// Consumes the builder and constructs a [`IpAddressDetails`](crate::model::IpAddressDetails)
        pub fn build(self) -> crate::model::IpAddressDetails {
            crate::model::IpAddressDetails {
                ip_address_v4: self.ip_address_v4,
                ip_city: self.ip_city,
                ip_country: self.ip_country,
                ip_geo_location: self.ip_geo_location,
                ip_owner: self.ip_owner,
            }
        }
    }
}
impl IpAddressDetails {
    /// Creates a new builder-style object to manufacture [`IpAddressDetails`](crate::model::IpAddressDetails)
    pub fn builder() -> crate::model::ip_address_details::Builder {
        crate::model::ip_address_details::Builder::default()
    }
}

/// <p>Provides information about the registered owner of an IP address.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpOwner {
    /// <p>The autonomous system number (ASN) for the autonomous system that included the IP address.</p>
    pub asn: std::option::Option<std::string::String>,
    /// <p>The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.</p>
    pub asn_org: std::option::Option<std::string::String>,
    /// <p>The name of the internet service provider (ISP) that owned the IP address.</p>
    pub isp: std::option::Option<std::string::String>,
    /// <p>The name of the organization that owned the IP address.</p>
    pub org: std::option::Option<std::string::String>,
}
impl IpOwner {
    /// <p>The autonomous system number (ASN) for the autonomous system that included the IP address.</p>
    pub fn asn(&self) -> std::option::Option<&str> {
        self.asn.as_deref()
    }
    /// <p>The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.</p>
    pub fn asn_org(&self) -> std::option::Option<&str> {
        self.asn_org.as_deref()
    }
    /// <p>The name of the internet service provider (ISP) that owned the IP address.</p>
    pub fn isp(&self) -> std::option::Option<&str> {
        self.isp.as_deref()
    }
    /// <p>The name of the organization that owned the IP address.</p>
    pub fn org(&self) -> std::option::Option<&str> {
        self.org.as_deref()
    }
}
impl std::fmt::Debug for IpOwner {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpOwner");
        formatter.field("asn", &self.asn);
        formatter.field("asn_org", &self.asn_org);
        formatter.field("isp", &self.isp);
        formatter.field("org", &self.org);
        formatter.finish()
    }
}
/// See [`IpOwner`](crate::model::IpOwner)
pub mod ip_owner {
    /// A builder for [`IpOwner`](crate::model::IpOwner)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) asn: std::option::Option<std::string::String>,
        pub(crate) asn_org: std::option::Option<std::string::String>,
        pub(crate) isp: std::option::Option<std::string::String>,
        pub(crate) org: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The autonomous system number (ASN) for the autonomous system that included the IP address.</p>
        pub fn asn(mut self, input: impl Into<std::string::String>) -> Self {
            self.asn = Some(input.into());
            self
        }
        /// <p>The autonomous system number (ASN) for the autonomous system that included the IP address.</p>
        pub fn set_asn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asn = input;
            self
        }
        /// <p>The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.</p>
        pub fn asn_org(mut self, input: impl Into<std::string::String>) -> Self {
            self.asn_org = Some(input.into());
            self
        }
        /// <p>The organization identifier that's associated with the autonomous system number (ASN) for the autonomous system that included the IP address.</p>
        pub fn set_asn_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.asn_org = input;
            self
        }
        /// <p>The name of the internet service provider (ISP) that owned the IP address.</p>
        pub fn isp(mut self, input: impl Into<std::string::String>) -> Self {
            self.isp = Some(input.into());
            self
        }
        /// <p>The name of the internet service provider (ISP) that owned the IP address.</p>
        pub fn set_isp(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.isp = input;
            self
        }
        /// <p>The name of the organization that owned the IP address.</p>
        pub fn org(mut self, input: impl Into<std::string::String>) -> Self {
            self.org = Some(input.into());
            self
        }
        /// <p>The name of the organization that owned the IP address.</p>
        pub fn set_org(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.org = input;
            self
        }
        /// Consumes the builder and constructs a [`IpOwner`](crate::model::IpOwner)
        pub fn build(self) -> crate::model::IpOwner {
            crate::model::IpOwner {
                asn: self.asn,
                asn_org: self.asn_org,
                isp: self.isp,
                org: self.org,
            }
        }
    }
}
impl IpOwner {
    /// Creates a new builder-style object to manufacture [`IpOwner`](crate::model::IpOwner)
    pub fn builder() -> crate::model::ip_owner::Builder {
        crate::model::ip_owner::Builder::default()
    }
}

/// <p>Provides geographic coordinates that indicate where a specified IP address originated from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpGeoLocation {
    /// <p>The latitude coordinate of the location, rounded to four decimal places.</p>
    pub lat: f64,
    /// <p>The longitude coordinate of the location, rounded to four decimal places.</p>
    pub lon: f64,
}
impl IpGeoLocation {
    /// <p>The latitude coordinate of the location, rounded to four decimal places.</p>
    pub fn lat(&self) -> f64 {
        self.lat
    }
    /// <p>The longitude coordinate of the location, rounded to four decimal places.</p>
    pub fn lon(&self) -> f64 {
        self.lon
    }
}
impl std::fmt::Debug for IpGeoLocation {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpGeoLocation");
        formatter.field("lat", &self.lat);
        formatter.field("lon", &self.lon);
        formatter.finish()
    }
}
/// See [`IpGeoLocation`](crate::model::IpGeoLocation)
pub mod ip_geo_location {
    /// A builder for [`IpGeoLocation`](crate::model::IpGeoLocation)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) lat: std::option::Option<f64>,
        pub(crate) lon: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The latitude coordinate of the location, rounded to four decimal places.</p>
        pub fn lat(mut self, input: f64) -> Self {
            self.lat = Some(input);
            self
        }
        /// <p>The latitude coordinate of the location, rounded to four decimal places.</p>
        pub fn set_lat(mut self, input: std::option::Option<f64>) -> Self {
            self.lat = input;
            self
        }
        /// <p>The longitude coordinate of the location, rounded to four decimal places.</p>
        pub fn lon(mut self, input: f64) -> Self {
            self.lon = Some(input);
            self
        }
        /// <p>The longitude coordinate of the location, rounded to four decimal places.</p>
        pub fn set_lon(mut self, input: std::option::Option<f64>) -> Self {
            self.lon = input;
            self
        }
        /// Consumes the builder and constructs a [`IpGeoLocation`](crate::model::IpGeoLocation)
        pub fn build(self) -> crate::model::IpGeoLocation {
            crate::model::IpGeoLocation {
                lat: self.lat.unwrap_or_default(),
                lon: self.lon.unwrap_or_default(),
            }
        }
    }
}
impl IpGeoLocation {
    /// Creates a new builder-style object to manufacture [`IpGeoLocation`](crate::model::IpGeoLocation)
    pub fn builder() -> crate::model::ip_geo_location::Builder {
        crate::model::ip_geo_location::Builder::default()
    }
}

/// <p>Provides information about the country that an IP address originated from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpCountry {
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country that the IP address originated from. For example, US for the United States.</p>
    pub code: std::option::Option<std::string::String>,
    /// <p>The name of the country that the IP address originated from.</p>
    pub name: std::option::Option<std::string::String>,
}
impl IpCountry {
    /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country that the IP address originated from. For example, US for the United States.</p>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>The name of the country that the IP address originated from.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for IpCountry {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpCountry");
        formatter.field("code", &self.code);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`IpCountry`](crate::model::IpCountry)
pub mod ip_country {
    /// A builder for [`IpCountry`](crate::model::IpCountry)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country that the IP address originated from. For example, US for the United States.</p>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country that the IP address originated from. For example, US for the United States.</p>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>The name of the country that the IP address originated from.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the country that the IP address originated from.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`IpCountry`](crate::model::IpCountry)
        pub fn build(self) -> crate::model::IpCountry {
            crate::model::IpCountry {
                code: self.code,
                name: self.name,
            }
        }
    }
}
impl IpCountry {
    /// Creates a new builder-style object to manufacture [`IpCountry`](crate::model::IpCountry)
    pub fn builder() -> crate::model::ip_country::Builder {
        crate::model::ip_country::Builder::default()
    }
}

/// <p>Provides information about the city that an IP address originated from.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IpCity {
    /// <p>The name of the city.</p>
    pub name: std::option::Option<std::string::String>,
}
impl IpCity {
    /// <p>The name of the city.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for IpCity {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IpCity");
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`IpCity`](crate::model::IpCity)
pub mod ip_city {
    /// A builder for [`IpCity`](crate::model::IpCity)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the city.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the city.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`IpCity`](crate::model::IpCity)
        pub fn build(self) -> crate::model::IpCity {
            crate::model::IpCity { name: self.name }
        }
    }
}
impl IpCity {
    /// Creates a new builder-style object to manufacture [`IpCity`](crate::model::IpCity)
    pub fn builder() -> crate::model::ip_city::Builder {
        crate::model::ip_city::Builder::default()
    }
}

/// <p>Provides information about the domain name of the device that an entity used to perform an action on an affected resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DomainDetails {
    /// <p>The name of the domain.</p>
    pub domain_name: std::option::Option<std::string::String>,
}
impl DomainDetails {
    /// <p>The name of the domain.</p>
    pub fn domain_name(&self) -> std::option::Option<&str> {
        self.domain_name.as_deref()
    }
}
impl std::fmt::Debug for DomainDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DomainDetails");
        formatter.field("domain_name", &self.domain_name);
        formatter.finish()
    }
}
/// See [`DomainDetails`](crate::model::DomainDetails)
pub mod domain_details {
    /// A builder for [`DomainDetails`](crate::model::DomainDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) domain_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the domain.</p>
        pub fn domain_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.domain_name = Some(input.into());
            self
        }
        /// <p>The name of the domain.</p>
        pub fn set_domain_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.domain_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DomainDetails`](crate::model::DomainDetails)
        pub fn build(self) -> crate::model::DomainDetails {
            crate::model::DomainDetails {
                domain_name: self.domain_name,
            }
        }
    }
}
impl DomainDetails {
    /// Creates a new builder-style object to manufacture [`DomainDetails`](crate::model::DomainDetails)
    pub fn builder() -> crate::model::domain_details::Builder {
        crate::model::domain_details::Builder::default()
    }
}

/// <p>Provides information about an action that occurred for a resource and produced a policy finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FindingAction {
    /// <p>The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.</p>
    pub action_type: std::option::Option<crate::model::FindingActionType>,
    /// <p>The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.</p>
    pub api_call_details: std::option::Option<crate::model::ApiCallDetails>,
}
impl FindingAction {
    /// <p>The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.</p>
    pub fn action_type(&self) -> std::option::Option<&crate::model::FindingActionType> {
        self.action_type.as_ref()
    }
    /// <p>The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.</p>
    pub fn api_call_details(&self) -> std::option::Option<&crate::model::ApiCallDetails> {
        self.api_call_details.as_ref()
    }
}
impl std::fmt::Debug for FindingAction {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FindingAction");
        formatter.field("action_type", &self.action_type);
        formatter.field("api_call_details", &self.api_call_details);
        formatter.finish()
    }
}
/// See [`FindingAction`](crate::model::FindingAction)
pub mod finding_action {
    /// A builder for [`FindingAction`](crate::model::FindingAction)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action_type: std::option::Option<crate::model::FindingActionType>,
        pub(crate) api_call_details: std::option::Option<crate::model::ApiCallDetails>,
    }
    impl Builder {
        /// <p>The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.</p>
        pub fn action_type(mut self, input: crate::model::FindingActionType) -> Self {
            self.action_type = Some(input);
            self
        }
        /// <p>The type of action that occurred for the affected resource. This value is typically AWS_API_CALL, which indicates that an entity invoked an API operation for the resource.</p>
        pub fn set_action_type(
            mut self,
            input: std::option::Option<crate::model::FindingActionType>,
        ) -> Self {
            self.action_type = input;
            self
        }
        /// <p>The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.</p>
        pub fn api_call_details(mut self, input: crate::model::ApiCallDetails) -> Self {
            self.api_call_details = Some(input);
            self
        }
        /// <p>The invocation details of the API operation that an entity invoked for the affected resource, if the value for the actionType property is AWS_API_CALL.</p>
        pub fn set_api_call_details(
            mut self,
            input: std::option::Option<crate::model::ApiCallDetails>,
        ) -> Self {
            self.api_call_details = input;
            self
        }
        /// Consumes the builder and constructs a [`FindingAction`](crate::model::FindingAction)
        pub fn build(self) -> crate::model::FindingAction {
            crate::model::FindingAction {
                action_type: self.action_type,
                api_call_details: self.api_call_details,
            }
        }
    }
}
impl FindingAction {
    /// Creates a new builder-style object to manufacture [`FindingAction`](crate::model::FindingAction)
    pub fn builder() -> crate::model::finding_action::Builder {
        crate::model::finding_action::Builder::default()
    }
}

/// <p>Provides information about an API operation that an entity invoked for an affected resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ApiCallDetails {
    /// <p>The name of the operation that was invoked most recently and produced the finding.</p>
    pub api: std::option::Option<std::string::String>,
    /// <p>The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.</p>
    pub api_service_name: std::option::Option<std::string::String>,
    /// <p>The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.</p>
    pub first_seen: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.</p>
    pub last_seen: std::option::Option<aws_smithy_types::DateTime>,
}
impl ApiCallDetails {
    /// <p>The name of the operation that was invoked most recently and produced the finding.</p>
    pub fn api(&self) -> std::option::Option<&str> {
        self.api.as_deref()
    }
    /// <p>The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.</p>
    pub fn api_service_name(&self) -> std::option::Option<&str> {
        self.api_service_name.as_deref()
    }
    /// <p>The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.</p>
    pub fn first_seen(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.first_seen.as_ref()
    }
    /// <p>The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.</p>
    pub fn last_seen(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_seen.as_ref()
    }
}
impl std::fmt::Debug for ApiCallDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ApiCallDetails");
        formatter.field("api", &self.api);
        formatter.field("api_service_name", &self.api_service_name);
        formatter.field("first_seen", &self.first_seen);
        formatter.field("last_seen", &self.last_seen);
        formatter.finish()
    }
}
/// See [`ApiCallDetails`](crate::model::ApiCallDetails)
pub mod api_call_details {
    /// A builder for [`ApiCallDetails`](crate::model::ApiCallDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) api: std::option::Option<std::string::String>,
        pub(crate) api_service_name: std::option::Option<std::string::String>,
        pub(crate) first_seen: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) last_seen: std::option::Option<aws_smithy_types::DateTime>,
    }
    impl Builder {
        /// <p>The name of the operation that was invoked most recently and produced the finding.</p>
        pub fn api(mut self, input: impl Into<std::string::String>) -> Self {
            self.api = Some(input.into());
            self
        }
        /// <p>The name of the operation that was invoked most recently and produced the finding.</p>
        pub fn set_api(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.api = input;
            self
        }
        /// <p>The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.</p>
        pub fn api_service_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.api_service_name = Some(input.into());
            self
        }
        /// <p>The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.</p>
        pub fn set_api_service_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.api_service_name = input;
            self
        }
        /// <p>The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.</p>
        pub fn first_seen(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.first_seen = Some(input);
            self
        }
        /// <p>The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.</p>
        pub fn set_first_seen(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.first_seen = input;
            self
        }
        /// <p>The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.</p>
        pub fn last_seen(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_seen = Some(input);
            self
        }
        /// <p>The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.</p>
        pub fn set_last_seen(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_seen = input;
            self
        }
        /// Consumes the builder and constructs a [`ApiCallDetails`](crate::model::ApiCallDetails)
        pub fn build(self) -> crate::model::ApiCallDetails {
            crate::model::ApiCallDetails {
                api: self.api,
                api_service_name: self.api_service_name,
                first_seen: self.first_seen,
                last_seen: self.last_seen,
            }
        }
    }
}
impl ApiCallDetails {
    /// Creates a new builder-style object to manufacture [`ApiCallDetails`](crate::model::ApiCallDetails)
    pub fn builder() -> crate::model::api_call_details::Builder {
        crate::model::api_call_details::Builder::default()
    }
}

/// <p>The type of action that occurred for the resource and produced the policy finding:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingActionType {
    #[allow(missing_docs)] // documentation missing in model
    AwsApiCall,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingActionType {
    fn from(s: &str) -> Self {
        match s {
            "AWS_API_CALL" => FindingActionType::AwsApiCall,
            other => FindingActionType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingActionType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingActionType::from(s))
    }
}
impl FindingActionType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingActionType::AwsApiCall => "AWS_API_CALL",
            FindingActionType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AWS_API_CALL"]
    }
}
impl AsRef<str> for FindingActionType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about a sensitive data finding, including the classification job that produced the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassificationDetails {
    /// <p>The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.</p>
    pub detailed_results_location: std::option::Option<std::string::String>,
    /// <p>The Amazon Resource Name (ARN) of the classification job that produced the finding.</p>
    pub job_arn: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the classification job that produced the finding.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The status and other details of the finding.</p>
    pub result: std::option::Option<crate::model::ClassificationResult>,
}
impl ClassificationDetails {
    /// <p>The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.</p>
    pub fn detailed_results_location(&self) -> std::option::Option<&str> {
        self.detailed_results_location.as_deref()
    }
    /// <p>The Amazon Resource Name (ARN) of the classification job that produced the finding.</p>
    pub fn job_arn(&self) -> std::option::Option<&str> {
        self.job_arn.as_deref()
    }
    /// <p>The unique identifier for the classification job that produced the finding.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The status and other details of the finding.</p>
    pub fn result(&self) -> std::option::Option<&crate::model::ClassificationResult> {
        self.result.as_ref()
    }
}
impl std::fmt::Debug for ClassificationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassificationDetails");
        formatter.field("detailed_results_location", &self.detailed_results_location);
        formatter.field("job_arn", &self.job_arn);
        formatter.field("job_id", &self.job_id);
        formatter.field("result", &self.result);
        formatter.finish()
    }
}
/// See [`ClassificationDetails`](crate::model::ClassificationDetails)
pub mod classification_details {
    /// A builder for [`ClassificationDetails`](crate::model::ClassificationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detailed_results_location: std::option::Option<std::string::String>,
        pub(crate) job_arn: std::option::Option<std::string::String>,
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) result: std::option::Option<crate::model::ClassificationResult>,
    }
    impl Builder {
        /// <p>The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.</p>
        pub fn detailed_results_location(mut self, input: impl Into<std::string::String>) -> Self {
            self.detailed_results_location = Some(input.into());
            self
        }
        /// <p>The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.</p>
        pub fn set_detailed_results_location(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.detailed_results_location = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job that produced the finding.</p>
        pub fn job_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job that produced the finding.</p>
        pub fn set_job_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_arn = input;
            self
        }
        /// <p>The unique identifier for the classification job that produced the finding.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the classification job that produced the finding.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The status and other details of the finding.</p>
        pub fn result(mut self, input: crate::model::ClassificationResult) -> Self {
            self.result = Some(input);
            self
        }
        /// <p>The status and other details of the finding.</p>
        pub fn set_result(
            mut self,
            input: std::option::Option<crate::model::ClassificationResult>,
        ) -> Self {
            self.result = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassificationDetails`](crate::model::ClassificationDetails)
        pub fn build(self) -> crate::model::ClassificationDetails {
            crate::model::ClassificationDetails {
                detailed_results_location: self.detailed_results_location,
                job_arn: self.job_arn,
                job_id: self.job_id,
                result: self.result,
            }
        }
    }
}
impl ClassificationDetails {
    /// Creates a new builder-style object to manufacture [`ClassificationDetails`](crate::model::ClassificationDetails)
    pub fn builder() -> crate::model::classification_details::Builder {
        crate::model::classification_details::Builder::default()
    }
}

/// <p>Provides the details of a sensitive data finding, including the types, number of occurrences, and locations of the sensitive data that was detected.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassificationResult {
    /// <p>Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
    /// <p>This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p>
    pub additional_occurrences: bool,
    /// <p>The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.</p>
    pub custom_data_identifiers: std::option::Option<crate::model::CustomDataIdentifiers>,
    /// <p>The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.</p>
    pub mime_type: std::option::Option<std::string::String>,
    /// <p>The category, types, and number of occurrences of the sensitive data that produced the finding.</p>
    pub sensitive_data: std::option::Option<std::vec::Vec<crate::model::SensitiveDataItem>>,
    /// <p>The total size, in bytes, of the data that the finding applies to.</p>
    pub size_classified: i64,
    /// <p>The status of the finding.</p>
    pub status: std::option::Option<crate::model::ClassificationResultStatus>,
}
impl ClassificationResult {
    /// <p>Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
    /// <p>This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p>
    pub fn additional_occurrences(&self) -> bool {
        self.additional_occurrences
    }
    /// <p>The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.</p>
    pub fn custom_data_identifiers(
        &self,
    ) -> std::option::Option<&crate::model::CustomDataIdentifiers> {
        self.custom_data_identifiers.as_ref()
    }
    /// <p>The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.</p>
    pub fn mime_type(&self) -> std::option::Option<&str> {
        self.mime_type.as_deref()
    }
    /// <p>The category, types, and number of occurrences of the sensitive data that produced the finding.</p>
    pub fn sensitive_data(&self) -> std::option::Option<&[crate::model::SensitiveDataItem]> {
        self.sensitive_data.as_deref()
    }
    /// <p>The total size, in bytes, of the data that the finding applies to.</p>
    pub fn size_classified(&self) -> i64 {
        self.size_classified
    }
    /// <p>The status of the finding.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ClassificationResultStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for ClassificationResult {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassificationResult");
        formatter.field("additional_occurrences", &self.additional_occurrences);
        formatter.field("custom_data_identifiers", &self.custom_data_identifiers);
        formatter.field("mime_type", &self.mime_type);
        formatter.field("sensitive_data", &self.sensitive_data);
        formatter.field("size_classified", &self.size_classified);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`ClassificationResult`](crate::model::ClassificationResult)
pub mod classification_result {
    /// A builder for [`ClassificationResult`](crate::model::ClassificationResult)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) additional_occurrences: std::option::Option<bool>,
        pub(crate) custom_data_identifiers:
            std::option::Option<crate::model::CustomDataIdentifiers>,
        pub(crate) mime_type: std::option::Option<std::string::String>,
        pub(crate) sensitive_data:
            std::option::Option<std::vec::Vec<crate::model::SensitiveDataItem>>,
        pub(crate) size_classified: std::option::Option<i64>,
        pub(crate) status: std::option::Option<crate::model::ClassificationResultStatus>,
    }
    impl Builder {
        /// <p>Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
        /// <p>This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p>
        pub fn additional_occurrences(mut self, input: bool) -> Self {
            self.additional_occurrences = Some(input);
            self
        }
        /// <p>Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
        /// <p>This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p>
        pub fn set_additional_occurrences(mut self, input: std::option::Option<bool>) -> Self {
            self.additional_occurrences = input;
            self
        }
        /// <p>The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.</p>
        pub fn custom_data_identifiers(
            mut self,
            input: crate::model::CustomDataIdentifiers,
        ) -> Self {
            self.custom_data_identifiers = Some(input);
            self
        }
        /// <p>The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.</p>
        pub fn set_custom_data_identifiers(
            mut self,
            input: std::option::Option<crate::model::CustomDataIdentifiers>,
        ) -> Self {
            self.custom_data_identifiers = input;
            self
        }
        /// <p>The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.</p>
        pub fn mime_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.mime_type = Some(input.into());
            self
        }
        /// <p>The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.</p>
        pub fn set_mime_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.mime_type = input;
            self
        }
        /// Appends an item to `sensitive_data`.
        ///
        /// To override the contents of this collection use [`set_sensitive_data`](Self::set_sensitive_data).
        ///
        /// <p>The category, types, and number of occurrences of the sensitive data that produced the finding.</p>
        pub fn sensitive_data(mut self, input: crate::model::SensitiveDataItem) -> Self {
            let mut v = self.sensitive_data.unwrap_or_default();
            v.push(input);
            self.sensitive_data = Some(v);
            self
        }
        /// <p>The category, types, and number of occurrences of the sensitive data that produced the finding.</p>
        pub fn set_sensitive_data(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SensitiveDataItem>>,
        ) -> Self {
            self.sensitive_data = input;
            self
        }
        /// <p>The total size, in bytes, of the data that the finding applies to.</p>
        pub fn size_classified(mut self, input: i64) -> Self {
            self.size_classified = Some(input);
            self
        }
        /// <p>The total size, in bytes, of the data that the finding applies to.</p>
        pub fn set_size_classified(mut self, input: std::option::Option<i64>) -> Self {
            self.size_classified = input;
            self
        }
        /// <p>The status of the finding.</p>
        pub fn status(mut self, input: crate::model::ClassificationResultStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the finding.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ClassificationResultStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassificationResult`](crate::model::ClassificationResult)
        pub fn build(self) -> crate::model::ClassificationResult {
            crate::model::ClassificationResult {
                additional_occurrences: self.additional_occurrences.unwrap_or_default(),
                custom_data_identifiers: self.custom_data_identifiers,
                mime_type: self.mime_type,
                sensitive_data: self.sensitive_data,
                size_classified: self.size_classified.unwrap_or_default(),
                status: self.status,
            }
        }
    }
}
impl ClassificationResult {
    /// Creates a new builder-style object to manufacture [`ClassificationResult`](crate::model::ClassificationResult)
    pub fn builder() -> crate::model::classification_result::Builder {
        crate::model::classification_result::Builder::default()
    }
}

/// <p>Provides information about the status of a sensitive data finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassificationResultStatus {
    /// <p>The status of the finding. Possible values are:</p>
    /// <ul>
    /// <li><p>COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.</p></li>
    /// <li><p>PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format.</p></li>
    /// <li><p>SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file that uses an unsupported format.</p></li>
    /// </ul>
    pub code: std::option::Option<std::string::String>,
    /// <p>A brief description of the status of the finding. This value is null if the status (code) of the finding is COMPLETE.</p>
    /// <p>Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding and the affected S3 object. Possible values are:</p>
    /// <ul>
    /// <li><p>ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some or none of the files in the archive. To determine which files Macie analyzed, if any, you can refer to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p></li>
    /// <li><p>ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota for this type of archive.</p></li>
    /// <li><p>ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the maximum number of nested levels that Macie analyzes for this type of archive.</p></li>
    /// <li><p>ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the maximum amount of data that Macie extracts and analyzes for this type of archive.</p></li>
    /// <li><p>ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the maximum number of files that Macie extracts and analyzes for this type of archive.</p></li>
    /// <li><p>FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.</p></li>
    /// <li><p>INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn’t allowed to use the key. Macie can’t decrypt and analyze the object.</p></li>
    /// <li><p>INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can’t decrypt and analyze the object.</p></li>
    /// <li><p>INVALID_OBJECT_STATE - The object doesn’t use a supported Amazon S3 storage class. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/data-classification.html">Discovering sensitive data</a> in the <i>Amazon Macie User Guide</i>.</p></li>
    /// <li><p>JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the quota for the number of nested levels that Macie analyzes for this type of file.</p></li>
    /// <li><p>MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to detect the file’s type or extract data from the file.</p></li>
    /// <li><p>OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.</p></li>
    /// <li><p>NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted to analyze the object.</p></li>
    /// <li><p>MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract data from the file.</p></li>
    /// <li><p>OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for this type of file.</p></li>
    /// <li><p>OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio exceeds the compression quota for this type of file.</p></li>
    /// <li><p>PERMISSION_DENIED - Macie isn’t allowed to access the object. The object’s permissions settings prevent Macie from analyzing the object.</p></li>
    /// <li><p>SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze it.</p></li>
    /// <li><p>UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie attempted to parse the data.</p></li>
    /// <li><p>UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-formats.html">Supported file and storage formats</a> in the <i>Amazon Macie User Guide</i>.</p></li>
    /// </ul>
    /// <p>For information about sensitive data discovery quotas for files, see <a href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Amazon Macie quotas</a> in the <i>Amazon Macie User Guide</i>.</p>
    pub reason: std::option::Option<std::string::String>,
}
impl ClassificationResultStatus {
    /// <p>The status of the finding. Possible values are:</p>
    /// <ul>
    /// <li><p>COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.</p></li>
    /// <li><p>PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format.</p></li>
    /// <li><p>SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file that uses an unsupported format.</p></li>
    /// </ul>
    pub fn code(&self) -> std::option::Option<&str> {
        self.code.as_deref()
    }
    /// <p>A brief description of the status of the finding. This value is null if the status (code) of the finding is COMPLETE.</p>
    /// <p>Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding and the affected S3 object. Possible values are:</p>
    /// <ul>
    /// <li><p>ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some or none of the files in the archive. To determine which files Macie analyzed, if any, you can refer to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p></li>
    /// <li><p>ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota for this type of archive.</p></li>
    /// <li><p>ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the maximum number of nested levels that Macie analyzes for this type of archive.</p></li>
    /// <li><p>ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the maximum amount of data that Macie extracts and analyzes for this type of archive.</p></li>
    /// <li><p>ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the maximum number of files that Macie extracts and analyzes for this type of archive.</p></li>
    /// <li><p>FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.</p></li>
    /// <li><p>INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn’t allowed to use the key. Macie can’t decrypt and analyze the object.</p></li>
    /// <li><p>INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can’t decrypt and analyze the object.</p></li>
    /// <li><p>INVALID_OBJECT_STATE - The object doesn’t use a supported Amazon S3 storage class. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/data-classification.html">Discovering sensitive data</a> in the <i>Amazon Macie User Guide</i>.</p></li>
    /// <li><p>JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the quota for the number of nested levels that Macie analyzes for this type of file.</p></li>
    /// <li><p>MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to detect the file’s type or extract data from the file.</p></li>
    /// <li><p>OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.</p></li>
    /// <li><p>NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted to analyze the object.</p></li>
    /// <li><p>MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract data from the file.</p></li>
    /// <li><p>OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for this type of file.</p></li>
    /// <li><p>OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio exceeds the compression quota for this type of file.</p></li>
    /// <li><p>PERMISSION_DENIED - Macie isn’t allowed to access the object. The object’s permissions settings prevent Macie from analyzing the object.</p></li>
    /// <li><p>SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze it.</p></li>
    /// <li><p>UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie attempted to parse the data.</p></li>
    /// <li><p>UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-formats.html">Supported file and storage formats</a> in the <i>Amazon Macie User Guide</i>.</p></li>
    /// </ul>
    /// <p>For information about sensitive data discovery quotas for files, see <a href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Amazon Macie quotas</a> in the <i>Amazon Macie User Guide</i>.</p>
    pub fn reason(&self) -> std::option::Option<&str> {
        self.reason.as_deref()
    }
}
impl std::fmt::Debug for ClassificationResultStatus {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassificationResultStatus");
        formatter.field("code", &self.code);
        formatter.field("reason", &self.reason);
        formatter.finish()
    }
}
/// See [`ClassificationResultStatus`](crate::model::ClassificationResultStatus)
pub mod classification_result_status {
    /// A builder for [`ClassificationResultStatus`](crate::model::ClassificationResultStatus)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) code: std::option::Option<std::string::String>,
        pub(crate) reason: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The status of the finding. Possible values are:</p>
        /// <ul>
        /// <li><p>COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.</p></li>
        /// <li><p>PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format.</p></li>
        /// <li><p>SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file that uses an unsupported format.</p></li>
        /// </ul>
        pub fn code(mut self, input: impl Into<std::string::String>) -> Self {
            self.code = Some(input.into());
            self
        }
        /// <p>The status of the finding. Possible values are:</p>
        /// <ul>
        /// <li><p>COMPLETE - Amazon Macie successfully completed its analysis of the S3 object that the finding applies to.</p></li>
        /// <li><p>PARTIAL - Macie analyzed only a subset of the data in the S3 object that the finding applies to. For example, the object is an archive file that contains files in an unsupported format.</p></li>
        /// <li><p>SKIPPED - Macie wasn't able to analyze the S3 object that the finding applies to. For example, the object is a file that uses an unsupported format.</p></li>
        /// </ul>
        pub fn set_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.code = input;
            self
        }
        /// <p>A brief description of the status of the finding. This value is null if the status (code) of the finding is COMPLETE.</p>
        /// <p>Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding and the affected S3 object. Possible values are:</p>
        /// <ul>
        /// <li><p>ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some or none of the files in the archive. To determine which files Macie analyzed, if any, you can refer to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p></li>
        /// <li><p>ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota for this type of archive.</p></li>
        /// <li><p>ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the maximum number of nested levels that Macie analyzes for this type of archive.</p></li>
        /// <li><p>ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the maximum amount of data that Macie extracts and analyzes for this type of archive.</p></li>
        /// <li><p>ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the maximum number of files that Macie extracts and analyzes for this type of archive.</p></li>
        /// <li><p>FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.</p></li>
        /// <li><p>INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn’t allowed to use the key. Macie can’t decrypt and analyze the object.</p></li>
        /// <li><p>INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can’t decrypt and analyze the object.</p></li>
        /// <li><p>INVALID_OBJECT_STATE - The object doesn’t use a supported Amazon S3 storage class. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/data-classification.html">Discovering sensitive data</a> in the <i>Amazon Macie User Guide</i>.</p></li>
        /// <li><p>JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the quota for the number of nested levels that Macie analyzes for this type of file.</p></li>
        /// <li><p>MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to detect the file’s type or extract data from the file.</p></li>
        /// <li><p>OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.</p></li>
        /// <li><p>NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted to analyze the object.</p></li>
        /// <li><p>MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract data from the file.</p></li>
        /// <li><p>OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for this type of file.</p></li>
        /// <li><p>OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio exceeds the compression quota for this type of file.</p></li>
        /// <li><p>PERMISSION_DENIED - Macie isn’t allowed to access the object. The object’s permissions settings prevent Macie from analyzing the object.</p></li>
        /// <li><p>SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze it.</p></li>
        /// <li><p>UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie attempted to parse the data.</p></li>
        /// <li><p>UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-formats.html">Supported file and storage formats</a> in the <i>Amazon Macie User Guide</i>.</p></li>
        /// </ul>
        /// <p>For information about sensitive data discovery quotas for files, see <a href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Amazon Macie quotas</a> in the <i>Amazon Macie User Guide</i>.</p>
        pub fn reason(mut self, input: impl Into<std::string::String>) -> Self {
            self.reason = Some(input.into());
            self
        }
        /// <p>A brief description of the status of the finding. This value is null if the status (code) of the finding is COMPLETE.</p>
        /// <p>Amazon Macie uses this value to notify you of any errors, warnings, or considerations that might impact your analysis of the finding and the affected S3 object. Possible values are:</p>
        /// <ul>
        /// <li><p>ARCHIVE_CONTAINS_UNPROCESSED_FILES - The object is an archive file and Macie extracted and analyzed only some or none of the files in the archive. To determine which files Macie analyzed, if any, you can refer to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).</p></li>
        /// <li><p>ARCHIVE_EXCEEDS_SIZE_LIMIT - The object is an archive file whose total storage size exceeds the size quota for this type of archive.</p></li>
        /// <li><p>ARCHIVE_NESTING_LEVEL_OVER_LIMIT - The object is an archive file whose nested depth exceeds the quota for the maximum number of nested levels that Macie analyzes for this type of archive.</p></li>
        /// <li><p>ARCHIVE_TOTAL_BYTES_EXTRACTED_OVER_LIMIT - The object is an archive file that exceeds the quota for the maximum amount of data that Macie extracts and analyzes for this type of archive.</p></li>
        /// <li><p>ARCHIVE_TOTAL_DOCUMENTS_PROCESSED_OVER_LIMIT - The object is an archive file that contains more than the maximum number of files that Macie extracts and analyzes for this type of archive.</p></li>
        /// <li><p>FILE_EXCEEDS_SIZE_LIMIT - The storage size of the object exceeds the size quota for this type of file.</p></li>
        /// <li><p>INVALID_ENCRYPTION - The object is encrypted using server-side encryption but Macie isn’t allowed to use the key. Macie can’t decrypt and analyze the object.</p></li>
        /// <li><p>INVALID_KMS_KEY - The object is encrypted with an KMS key that was disabled or is being deleted. Macie can’t decrypt and analyze the object.</p></li>
        /// <li><p>INVALID_OBJECT_STATE - The object doesn’t use a supported Amazon S3 storage class. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/data-classification.html">Discovering sensitive data</a> in the <i>Amazon Macie User Guide</i>.</p></li>
        /// <li><p>JSON_NESTING_LEVEL_OVER_LIMIT - The object contains JSON data and the nested depth of the data exceeds the quota for the number of nested levels that Macie analyzes for this type of file.</p></li>
        /// <li><p>MALFORMED_FILE - The object is a malformed or corrupted file. An error occurred when Macie attempted to detect the file’s type or extract data from the file.</p></li>
        /// <li><p>OBJECT_VERSION_MISMATCH - The object was changed while Macie was analyzing it.</p></li>
        /// <li><p>NO_SUCH_BUCKET_AVAILABLE - The object was in a bucket that was deleted shortly before or when Macie attempted to analyze the object.</p></li>
        /// <li><p>MALFORMED_OR_FILE_SIZE_EXCEEDS_LIMIT - The object is a Microsoft Office file that is malformed or exceeds the size quota for this type of file. If the file is malformed, an error occurred when Macie attempted to extract data from the file.</p></li>
        /// <li><p>OOXML_UNCOMPRESSED_SIZE_EXCEEDS_LIMIT - The object is an Office Open XML file that exceeds the size quota for this type of file.</p></li>
        /// <li><p>OOXML_UNCOMPRESSED_RATIO_EXCEEDS_LIMIT - The object is an Office Open XML file whose compression ratio exceeds the compression quota for this type of file.</p></li>
        /// <li><p>PERMISSION_DENIED - Macie isn’t allowed to access the object. The object’s permissions settings prevent Macie from analyzing the object.</p></li>
        /// <li><p>SOURCE_OBJECT_NO_LONGER_AVAILABLE - The object was deleted shortly before or when Macie attempted to analyze it.</p></li>
        /// <li><p>UNABLE_TO_PARSE_FILE - The object is a file that contains structured data and an error occurred when Macie attempted to parse the data.</p></li>
        /// <li><p>UNSUPPORTED_FILE_TYPE_EXCEPTION - The object is a file that uses an unsupported file or storage format. For more information, see <a href="https://docs.aws.amazon.com/macie/latest/user/discovery-supported-formats.html">Supported file and storage formats</a> in the <i>Amazon Macie User Guide</i>.</p></li>
        /// </ul>
        /// <p>For information about sensitive data discovery quotas for files, see <a href="https://docs.aws.amazon.com/macie/latest/user/macie-quotas.html">Amazon Macie quotas</a> in the <i>Amazon Macie User Guide</i>.</p>
        pub fn set_reason(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.reason = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassificationResultStatus`](crate::model::ClassificationResultStatus)
        pub fn build(self) -> crate::model::ClassificationResultStatus {
            crate::model::ClassificationResultStatus {
                code: self.code,
                reason: self.reason,
            }
        }
    }
}
impl ClassificationResultStatus {
    /// Creates a new builder-style object to manufacture [`ClassificationResultStatus`](crate::model::ClassificationResultStatus)
    pub fn builder() -> crate::model::classification_result_status::Builder {
        crate::model::classification_result_status::Builder::default()
    }
}

/// <p>Provides information about the category, types, and occurrences of sensitive data that produced a sensitive data finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SensitiveDataItem {
    /// <p>The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
    pub category: std::option::Option<crate::model::SensitiveDataItemCategory>,
    /// <p>An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.</p>
    pub detections: std::option::Option<std::vec::Vec<crate::model::DefaultDetection>>,
    /// <p>The total number of occurrences of the sensitive data that was detected.</p>
    pub total_count: i64,
}
impl SensitiveDataItem {
    /// <p>The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
    pub fn category(&self) -> std::option::Option<&crate::model::SensitiveDataItemCategory> {
        self.category.as_ref()
    }
    /// <p>An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.</p>
    pub fn detections(&self) -> std::option::Option<&[crate::model::DefaultDetection]> {
        self.detections.as_deref()
    }
    /// <p>The total number of occurrences of the sensitive data that was detected.</p>
    pub fn total_count(&self) -> i64 {
        self.total_count
    }
}
impl std::fmt::Debug for SensitiveDataItem {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SensitiveDataItem");
        formatter.field("category", &self.category);
        formatter.field("detections", &self.detections);
        formatter.field("total_count", &self.total_count);
        formatter.finish()
    }
}
/// See [`SensitiveDataItem`](crate::model::SensitiveDataItem)
pub mod sensitive_data_item {
    /// A builder for [`SensitiveDataItem`](crate::model::SensitiveDataItem)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) category: std::option::Option<crate::model::SensitiveDataItemCategory>,
        pub(crate) detections: std::option::Option<std::vec::Vec<crate::model::DefaultDetection>>,
        pub(crate) total_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
        pub fn category(mut self, input: crate::model::SensitiveDataItemCategory) -> Self {
            self.category = Some(input);
            self
        }
        /// <p>The category of sensitive data that was detected. For example: CREDENTIALS, for credentials data such as private keys or Amazon Web Services secret access keys; FINANCIAL_INFORMATION, for financial data such as credit card numbers; or, PERSONAL_INFORMATION, for personal health information, such as health insurance identification numbers, or personally identifiable information, such as passport numbers.</p>
        pub fn set_category(
            mut self,
            input: std::option::Option<crate::model::SensitiveDataItemCategory>,
        ) -> Self {
            self.category = input;
            self
        }
        /// Appends an item to `detections`.
        ///
        /// To override the contents of this collection use [`set_detections`](Self::set_detections).
        ///
        /// <p>An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.</p>
        pub fn detections(mut self, input: crate::model::DefaultDetection) -> Self {
            let mut v = self.detections.unwrap_or_default();
            v.push(input);
            self.detections = Some(v);
            self
        }
        /// <p>An array of objects, one for each type of sensitive data that was detected. Each object reports the number of occurrences of a specific type of sensitive data that was detected, and the location of up to 15 of those occurrences.</p>
        pub fn set_detections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DefaultDetection>>,
        ) -> Self {
            self.detections = input;
            self
        }
        /// <p>The total number of occurrences of the sensitive data that was detected.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of occurrences of the sensitive data that was detected.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// Consumes the builder and constructs a [`SensitiveDataItem`](crate::model::SensitiveDataItem)
        pub fn build(self) -> crate::model::SensitiveDataItem {
            crate::model::SensitiveDataItem {
                category: self.category,
                detections: self.detections,
                total_count: self.total_count.unwrap_or_default(),
            }
        }
    }
}
impl SensitiveDataItem {
    /// Creates a new builder-style object to manufacture [`SensitiveDataItem`](crate::model::SensitiveDataItem)
    pub fn builder() -> crate::model::sensitive_data_item::Builder {
        crate::model::sensitive_data_item::Builder::default()
    }
}

/// <p>Provides information about a type of sensitive data that was detected by a managed data identifier and produced a sensitive data finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DefaultDetection {
    /// <p>The total number of occurrences of the type of sensitive data that was detected.</p>
    pub count: i64,
    /// <p>The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
    pub occurrences: std::option::Option<crate::model::Occurrences>,
    /// <p>The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.</p>
    pub r#type: std::option::Option<std::string::String>,
}
impl DefaultDetection {
    /// <p>The total number of occurrences of the type of sensitive data that was detected.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
    /// <p>The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
    pub fn occurrences(&self) -> std::option::Option<&crate::model::Occurrences> {
        self.occurrences.as_ref()
    }
    /// <p>The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.</p>
    pub fn r#type(&self) -> std::option::Option<&str> {
        self.r#type.as_deref()
    }
}
impl std::fmt::Debug for DefaultDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DefaultDetection");
        formatter.field("count", &self.count);
        formatter.field("occurrences", &self.occurrences);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`DefaultDetection`](crate::model::DefaultDetection)
pub mod default_detection {
    /// A builder for [`DefaultDetection`](crate::model::DefaultDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) count: std::option::Option<i64>,
        pub(crate) occurrences: std::option::Option<crate::model::Occurrences>,
        pub(crate) r#type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The total number of occurrences of the type of sensitive data that was detected.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The total number of occurrences of the type of sensitive data that was detected.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
        pub fn occurrences(mut self, input: crate::model::Occurrences) -> Self {
            self.occurrences = Some(input);
            self
        }
        /// <p>The location of 1-15 occurrences of the sensitive data that was detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
        pub fn set_occurrences(
            mut self,
            input: std::option::Option<crate::model::Occurrences>,
        ) -> Self {
            self.occurrences = input;
            self
        }
        /// <p>The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.</p>
        pub fn r#type(mut self, input: impl Into<std::string::String>) -> Self {
            self.r#type = Some(input.into());
            self
        }
        /// <p>The type of sensitive data that was detected. For example, AWS_CREDENTIALS, PHONE_NUMBER, or ADDRESS.</p>
        pub fn set_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`DefaultDetection`](crate::model::DefaultDetection)
        pub fn build(self) -> crate::model::DefaultDetection {
            crate::model::DefaultDetection {
                count: self.count.unwrap_or_default(),
                occurrences: self.occurrences,
                r#type: self.r#type,
            }
        }
    }
}
impl DefaultDetection {
    /// Creates a new builder-style object to manufacture [`DefaultDetection`](crate::model::DefaultDetection)
    pub fn builder() -> crate::model::default_detection::Builder {
        crate::model::default_detection::Builder::default()
    }
}

/// <p>Specifies the location of 1-15 occurrences of sensitive data that was detected by a managed data identifier or a custom data identifier and produced a sensitive data finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Occurrences {
    /// <p>An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.</p>
    /// <p>Each Cell object specifies a cell or field that contains the sensitive data.</p>
    pub cells: std::option::Option<std::vec::Vec<crate::model::Cell>>,
    /// <p>An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.</p>
    /// <p>This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.</p>
    pub line_ranges: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>Reserved for future use.</p>
    pub offset_ranges: std::option::Option<std::vec::Vec<crate::model::Range>>,
    /// <p>An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.</p>
    /// <p>Each Page object specifies a page that contains the sensitive data.</p>
    pub pages: std::option::Option<std::vec::Vec<crate::model::Page>>,
    /// <p>An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.</p>
    /// <p>For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.</p>
    pub records: std::option::Option<std::vec::Vec<crate::model::Record>>,
}
impl Occurrences {
    /// <p>An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.</p>
    /// <p>Each Cell object specifies a cell or field that contains the sensitive data.</p>
    pub fn cells(&self) -> std::option::Option<&[crate::model::Cell]> {
        self.cells.as_deref()
    }
    /// <p>An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.</p>
    /// <p>This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.</p>
    pub fn line_ranges(&self) -> std::option::Option<&[crate::model::Range]> {
        self.line_ranges.as_deref()
    }
    /// <p>Reserved for future use.</p>
    pub fn offset_ranges(&self) -> std::option::Option<&[crate::model::Range]> {
        self.offset_ranges.as_deref()
    }
    /// <p>An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.</p>
    /// <p>Each Page object specifies a page that contains the sensitive data.</p>
    pub fn pages(&self) -> std::option::Option<&[crate::model::Page]> {
        self.pages.as_deref()
    }
    /// <p>An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.</p>
    /// <p>For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.</p>
    pub fn records(&self) -> std::option::Option<&[crate::model::Record]> {
        self.records.as_deref()
    }
}
impl std::fmt::Debug for Occurrences {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Occurrences");
        formatter.field("cells", &self.cells);
        formatter.field("line_ranges", &self.line_ranges);
        formatter.field("offset_ranges", &self.offset_ranges);
        formatter.field("pages", &self.pages);
        formatter.field("records", &self.records);
        formatter.finish()
    }
}
/// See [`Occurrences`](crate::model::Occurrences)
pub mod occurrences {
    /// A builder for [`Occurrences`](crate::model::Occurrences)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cells: std::option::Option<std::vec::Vec<crate::model::Cell>>,
        pub(crate) line_ranges: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) offset_ranges: std::option::Option<std::vec::Vec<crate::model::Range>>,
        pub(crate) pages: std::option::Option<std::vec::Vec<crate::model::Page>>,
        pub(crate) records: std::option::Option<std::vec::Vec<crate::model::Record>>,
    }
    impl Builder {
        /// Appends an item to `cells`.
        ///
        /// To override the contents of this collection use [`set_cells`](Self::set_cells).
        ///
        /// <p>An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.</p>
        /// <p>Each Cell object specifies a cell or field that contains the sensitive data.</p>
        pub fn cells(mut self, input: crate::model::Cell) -> Self {
            let mut v = self.cells.unwrap_or_default();
            v.push(input);
            self.cells = Some(v);
            self
        }
        /// <p>An array of objects, one for each occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file. This value is null for all other types of files.</p>
        /// <p>Each Cell object specifies a cell or field that contains the sensitive data.</p>
        pub fn set_cells(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Cell>>,
        ) -> Self {
            self.cells = input;
            self
        }
        /// Appends an item to `line_ranges`.
        ///
        /// To override the contents of this collection use [`set_line_ranges`](Self::set_line_ranges).
        ///
        /// <p>An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.</p>
        /// <p>This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.</p>
        pub fn line_ranges(mut self, input: crate::model::Range) -> Self {
            let mut v = self.line_ranges.unwrap_or_default();
            v.push(input);
            self.line_ranges = Some(v);
            self
        }
        /// <p>An array of objects, one for each occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file. Each Range object specifies a line or inclusive range of lines that contains the sensitive data, and the position of the data on the specified line or lines.</p>
        /// <p>This value is often null for file types that are supported by Cell, Page, or Record objects. Exceptions are the location of sensitive data in: unstructured sections of an otherwise structured file, such as a comment in a file; a malformed file that Amazon Macie analyzes as plain text; and, a CSV or TSV file that has any column names that contain sensitive data.</p>
        pub fn set_line_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.line_ranges = input;
            self
        }
        /// Appends an item to `offset_ranges`.
        ///
        /// To override the contents of this collection use [`set_offset_ranges`](Self::set_offset_ranges).
        ///
        /// <p>Reserved for future use.</p>
        pub fn offset_ranges(mut self, input: crate::model::Range) -> Self {
            let mut v = self.offset_ranges.unwrap_or_default();
            v.push(input);
            self.offset_ranges = Some(v);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_offset_ranges(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Range>>,
        ) -> Self {
            self.offset_ranges = input;
            self
        }
        /// Appends an item to `pages`.
        ///
        /// To override the contents of this collection use [`set_pages`](Self::set_pages).
        ///
        /// <p>An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.</p>
        /// <p>Each Page object specifies a page that contains the sensitive data.</p>
        pub fn pages(mut self, input: crate::model::Page) -> Self {
            let mut v = self.pages.unwrap_or_default();
            v.push(input);
            self.pages = Some(v);
            self
        }
        /// <p>An array of objects, one for each occurrence of sensitive data in an Adobe Portable Document Format file. This value is null for all other types of files.</p>
        /// <p>Each Page object specifies a page that contains the sensitive data.</p>
        pub fn set_pages(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Page>>,
        ) -> Self {
            self.pages = input;
            self
        }
        /// Appends an item to `records`.
        ///
        /// To override the contents of this collection use [`set_records`](Self::set_records).
        ///
        /// <p>An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.</p>
        /// <p>For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.</p>
        pub fn records(mut self, input: crate::model::Record) -> Self {
            let mut v = self.records.unwrap_or_default();
            v.push(input);
            self.records = Some(v);
            self
        }
        /// <p>An array of objects, one for each occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file. This value is null for all other types of files.</p>
        /// <p>For an Avro object container or Parquet file, each Record object specifies a record index and the path to a field in a record that contains the sensitive data. For a JSON or JSON Lines file, each Record object specifies the path to a field or array that contains the sensitive data. For a JSON Lines file, it also specifies the index of the line that contains the data.</p>
        pub fn set_records(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Record>>,
        ) -> Self {
            self.records = input;
            self
        }
        /// Consumes the builder and constructs a [`Occurrences`](crate::model::Occurrences)
        pub fn build(self) -> crate::model::Occurrences {
            crate::model::Occurrences {
                cells: self.cells,
                line_ranges: self.line_ranges,
                offset_ranges: self.offset_ranges,
                pages: self.pages,
                records: self.records,
            }
        }
    }
}
impl Occurrences {
    /// Creates a new builder-style object to manufacture [`Occurrences`](crate::model::Occurrences)
    pub fn builder() -> crate::model::occurrences::Builder {
        crate::model::occurrences::Builder::default()
    }
}

/// <p>Specifies the location of an occurrence of sensitive data in an Apache Avro object container, Apache Parquet file, JSON file, or JSON Lines file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Record {
    /// <p>The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data.</p>
    /// <p>If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.</p>
    pub json_path: std::option::Option<std::string::String>,
    /// <p>For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.</p>
    pub record_index: i64,
}
impl Record {
    /// <p>The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data.</p>
    /// <p>If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.</p>
    pub fn json_path(&self) -> std::option::Option<&str> {
        self.json_path.as_deref()
    }
    /// <p>For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.</p>
    pub fn record_index(&self) -> i64 {
        self.record_index
    }
}
impl std::fmt::Debug for Record {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Record");
        formatter.field("json_path", &self.json_path);
        formatter.field("record_index", &self.record_index);
        formatter.finish()
    }
}
/// See [`Record`](crate::model::Record)
pub mod record {
    /// A builder for [`Record`](crate::model::Record)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) json_path: std::option::Option<std::string::String>,
        pub(crate) record_index: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data.</p>
        /// <p>If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.</p>
        pub fn json_path(mut self, input: impl Into<std::string::String>) -> Self {
            self.json_path = Some(input.into());
            self
        }
        /// <p>The path, as a JSONPath expression, to the sensitive data. For an Avro object container or Parquet file, this is the path to the field in the record (recordIndex) that contains the data. For a JSON or JSON Lines file, this is the path to the field or array that contains the data. If the data is a value in an array, the path also indicates which value contains the data.</p>
        /// <p>If Amazon Macie detects sensitive data in the name of any element in the path, Macie omits this field. If the name of an element exceeds 20 characters, Macie truncates the name by removing characters from the beginning of the name. If the resulting full path exceeds 250 characters, Macie also truncates the path, starting with the first element in the path, until the path contains 250 or fewer characters.</p>
        pub fn set_json_path(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.json_path = input;
            self
        }
        /// <p>For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.</p>
        pub fn record_index(mut self, input: i64) -> Self {
            self.record_index = Some(input);
            self
        }
        /// <p>For an Avro object container or Parquet file, the record index, starting from 0, for the record that contains the sensitive data. For a JSON Lines file, the line index, starting from 0, for the line that contains the sensitive data. This value is always 0 for JSON files.</p>
        pub fn set_record_index(mut self, input: std::option::Option<i64>) -> Self {
            self.record_index = input;
            self
        }
        /// Consumes the builder and constructs a [`Record`](crate::model::Record)
        pub fn build(self) -> crate::model::Record {
            crate::model::Record {
                json_path: self.json_path,
                record_index: self.record_index.unwrap_or_default(),
            }
        }
    }
}
impl Record {
    /// Creates a new builder-style object to manufacture [`Record`](crate::model::Record)
    pub fn builder() -> crate::model::record::Builder {
        crate::model::record::Builder::default()
    }
}

/// <p>Specifies the location of an occurrence of sensitive data in an Adobe Portable Document Format file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Page {
    /// <p>Reserved for future use.</p>
    pub line_range: std::option::Option<crate::model::Range>,
    /// <p>Reserved for future use.</p>
    pub offset_range: std::option::Option<crate::model::Range>,
    /// <p>The page number of the page that contains the sensitive data.</p>
    pub page_number: i64,
}
impl Page {
    /// <p>Reserved for future use.</p>
    pub fn line_range(&self) -> std::option::Option<&crate::model::Range> {
        self.line_range.as_ref()
    }
    /// <p>Reserved for future use.</p>
    pub fn offset_range(&self) -> std::option::Option<&crate::model::Range> {
        self.offset_range.as_ref()
    }
    /// <p>The page number of the page that contains the sensitive data.</p>
    pub fn page_number(&self) -> i64 {
        self.page_number
    }
}
impl std::fmt::Debug for Page {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Page");
        formatter.field("line_range", &self.line_range);
        formatter.field("offset_range", &self.offset_range);
        formatter.field("page_number", &self.page_number);
        formatter.finish()
    }
}
/// See [`Page`](crate::model::Page)
pub mod page {
    /// A builder for [`Page`](crate::model::Page)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) line_range: std::option::Option<crate::model::Range>,
        pub(crate) offset_range: std::option::Option<crate::model::Range>,
        pub(crate) page_number: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>Reserved for future use.</p>
        pub fn line_range(mut self, input: crate::model::Range) -> Self {
            self.line_range = Some(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_line_range(mut self, input: std::option::Option<crate::model::Range>) -> Self {
            self.line_range = input;
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn offset_range(mut self, input: crate::model::Range) -> Self {
            self.offset_range = Some(input);
            self
        }
        /// <p>Reserved for future use.</p>
        pub fn set_offset_range(mut self, input: std::option::Option<crate::model::Range>) -> Self {
            self.offset_range = input;
            self
        }
        /// <p>The page number of the page that contains the sensitive data.</p>
        pub fn page_number(mut self, input: i64) -> Self {
            self.page_number = Some(input);
            self
        }
        /// <p>The page number of the page that contains the sensitive data.</p>
        pub fn set_page_number(mut self, input: std::option::Option<i64>) -> Self {
            self.page_number = input;
            self
        }
        /// Consumes the builder and constructs a [`Page`](crate::model::Page)
        pub fn build(self) -> crate::model::Page {
            crate::model::Page {
                line_range: self.line_range,
                offset_range: self.offset_range,
                page_number: self.page_number.unwrap_or_default(),
            }
        }
    }
}
impl Page {
    /// Creates a new builder-style object to manufacture [`Page`](crate::model::Page)
    pub fn builder() -> crate::model::page::Builder {
        crate::model::page::Builder::default()
    }
}

/// <p>Specifies the location of an occurrence of sensitive data in a non-binary text file, such as an HTML, TXT, or XML file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Range {
    /// <p>The number of lines from the beginning of the file to the end of the sensitive data.</p>
    pub end: i64,
    /// <p>The number of lines from the beginning of the file to the beginning of the sensitive data.</p>
    pub start: i64,
    /// <p>The number of characters, with spaces and starting from 1, from the beginning of the first line that contains the sensitive data (start) to the beginning of the sensitive data.</p>
    pub start_column: i64,
}
impl Range {
    /// <p>The number of lines from the beginning of the file to the end of the sensitive data.</p>
    pub fn end(&self) -> i64 {
        self.end
    }
    /// <p>The number of lines from the beginning of the file to the beginning of the sensitive data.</p>
    pub fn start(&self) -> i64 {
        self.start
    }
    /// <p>The number of characters, with spaces and starting from 1, from the beginning of the first line that contains the sensitive data (start) to the beginning of the sensitive data.</p>
    pub fn start_column(&self) -> i64 {
        self.start_column
    }
}
impl std::fmt::Debug for Range {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Range");
        formatter.field("end", &self.end);
        formatter.field("start", &self.start);
        formatter.field("start_column", &self.start_column);
        formatter.finish()
    }
}
/// See [`Range`](crate::model::Range)
pub mod range {
    /// A builder for [`Range`](crate::model::Range)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) end: std::option::Option<i64>,
        pub(crate) start: std::option::Option<i64>,
        pub(crate) start_column: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The number of lines from the beginning of the file to the end of the sensitive data.</p>
        pub fn end(mut self, input: i64) -> Self {
            self.end = Some(input);
            self
        }
        /// <p>The number of lines from the beginning of the file to the end of the sensitive data.</p>
        pub fn set_end(mut self, input: std::option::Option<i64>) -> Self {
            self.end = input;
            self
        }
        /// <p>The number of lines from the beginning of the file to the beginning of the sensitive data.</p>
        pub fn start(mut self, input: i64) -> Self {
            self.start = Some(input);
            self
        }
        /// <p>The number of lines from the beginning of the file to the beginning of the sensitive data.</p>
        pub fn set_start(mut self, input: std::option::Option<i64>) -> Self {
            self.start = input;
            self
        }
        /// <p>The number of characters, with spaces and starting from 1, from the beginning of the first line that contains the sensitive data (start) to the beginning of the sensitive data.</p>
        pub fn start_column(mut self, input: i64) -> Self {
            self.start_column = Some(input);
            self
        }
        /// <p>The number of characters, with spaces and starting from 1, from the beginning of the first line that contains the sensitive data (start) to the beginning of the sensitive data.</p>
        pub fn set_start_column(mut self, input: std::option::Option<i64>) -> Self {
            self.start_column = input;
            self
        }
        /// Consumes the builder and constructs a [`Range`](crate::model::Range)
        pub fn build(self) -> crate::model::Range {
            crate::model::Range {
                end: self.end.unwrap_or_default(),
                start: self.start.unwrap_or_default(),
                start_column: self.start_column.unwrap_or_default(),
            }
        }
    }
}
impl Range {
    /// Creates a new builder-style object to manufacture [`Range`](crate::model::Range)
    pub fn builder() -> crate::model::range::Builder {
        crate::model::range::Builder::default()
    }
}

/// <p>Specifies the location of an occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Cell {
    /// <p>The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.</p>
    pub cell_reference: std::option::Option<std::string::String>,
    /// <p>The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.</p>
    pub column: i64,
    /// <p>The name of the column that contains the sensitive data, if available.</p>
    pub column_name: std::option::Option<std::string::String>,
    /// <p>The row number of the row that contains the sensitive data.</p>
    pub row: i64,
}
impl Cell {
    /// <p>The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.</p>
    pub fn cell_reference(&self) -> std::option::Option<&str> {
        self.cell_reference.as_deref()
    }
    /// <p>The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.</p>
    pub fn column(&self) -> i64 {
        self.column
    }
    /// <p>The name of the column that contains the sensitive data, if available.</p>
    pub fn column_name(&self) -> std::option::Option<&str> {
        self.column_name.as_deref()
    }
    /// <p>The row number of the row that contains the sensitive data.</p>
    pub fn row(&self) -> i64 {
        self.row
    }
}
impl std::fmt::Debug for Cell {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Cell");
        formatter.field("cell_reference", &self.cell_reference);
        formatter.field("column", &self.column);
        formatter.field("column_name", &self.column_name);
        formatter.field("row", &self.row);
        formatter.finish()
    }
}
/// See [`Cell`](crate::model::Cell)
pub mod cell {
    /// A builder for [`Cell`](crate::model::Cell)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) cell_reference: std::option::Option<std::string::String>,
        pub(crate) column: std::option::Option<i64>,
        pub(crate) column_name: std::option::Option<std::string::String>,
        pub(crate) row: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.</p>
        pub fn cell_reference(mut self, input: impl Into<std::string::String>) -> Self {
            self.cell_reference = Some(input.into());
            self
        }
        /// <p>The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.</p>
        pub fn set_cell_reference(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.cell_reference = input;
            self
        }
        /// <p>The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.</p>
        pub fn column(mut self, input: i64) -> Self {
            self.column = Some(input);
            self
        }
        /// <p>The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.</p>
        pub fn set_column(mut self, input: std::option::Option<i64>) -> Self {
            self.column = input;
            self
        }
        /// <p>The name of the column that contains the sensitive data, if available.</p>
        pub fn column_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.column_name = Some(input.into());
            self
        }
        /// <p>The name of the column that contains the sensitive data, if available.</p>
        pub fn set_column_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.column_name = input;
            self
        }
        /// <p>The row number of the row that contains the sensitive data.</p>
        pub fn row(mut self, input: i64) -> Self {
            self.row = Some(input);
            self
        }
        /// <p>The row number of the row that contains the sensitive data.</p>
        pub fn set_row(mut self, input: std::option::Option<i64>) -> Self {
            self.row = input;
            self
        }
        /// Consumes the builder and constructs a [`Cell`](crate::model::Cell)
        pub fn build(self) -> crate::model::Cell {
            crate::model::Cell {
                cell_reference: self.cell_reference,
                column: self.column.unwrap_or_default(),
                column_name: self.column_name,
                row: self.row.unwrap_or_default(),
            }
        }
    }
}
impl Cell {
    /// Creates a new builder-style object to manufacture [`Cell`](crate::model::Cell)
    pub fn builder() -> crate::model::cell::Builder {
        crate::model::cell::Builder::default()
    }
}

/// <p>Provides information about custom data identifiers that produced a sensitive data finding, and the number of occurrences of the data that they detected for the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomDataIdentifiers {
    /// <p>The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.</p>
    pub detections: std::option::Option<std::vec::Vec<crate::model::CustomDetection>>,
    /// <p>The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.</p>
    pub total_count: i64,
}
impl CustomDataIdentifiers {
    /// <p>The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.</p>
    pub fn detections(&self) -> std::option::Option<&[crate::model::CustomDetection]> {
        self.detections.as_deref()
    }
    /// <p>The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.</p>
    pub fn total_count(&self) -> i64 {
        self.total_count
    }
}
impl std::fmt::Debug for CustomDataIdentifiers {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomDataIdentifiers");
        formatter.field("detections", &self.detections);
        formatter.field("total_count", &self.total_count);
        formatter.finish()
    }
}
/// See [`CustomDataIdentifiers`](crate::model::CustomDataIdentifiers)
pub mod custom_data_identifiers {
    /// A builder for [`CustomDataIdentifiers`](crate::model::CustomDataIdentifiers)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detections: std::option::Option<std::vec::Vec<crate::model::CustomDetection>>,
        pub(crate) total_count: std::option::Option<i64>,
    }
    impl Builder {
        /// Appends an item to `detections`.
        ///
        /// To override the contents of this collection use [`set_detections`](Self::set_detections).
        ///
        /// <p>The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.</p>
        pub fn detections(mut self, input: crate::model::CustomDetection) -> Self {
            let mut v = self.detections.unwrap_or_default();
            v.push(input);
            self.detections = Some(v);
            self
        }
        /// <p>The custom data identifiers that detected the data, and the number of occurrences of the data that each identifier detected.</p>
        pub fn set_detections(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::CustomDetection>>,
        ) -> Self {
            self.detections = input;
            self
        }
        /// <p>The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.</p>
        pub fn total_count(mut self, input: i64) -> Self {
            self.total_count = Some(input);
            self
        }
        /// <p>The total number of occurrences of the data that was detected by the custom data identifiers and produced the finding.</p>
        pub fn set_total_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_count = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomDataIdentifiers`](crate::model::CustomDataIdentifiers)
        pub fn build(self) -> crate::model::CustomDataIdentifiers {
            crate::model::CustomDataIdentifiers {
                detections: self.detections,
                total_count: self.total_count.unwrap_or_default(),
            }
        }
    }
}
impl CustomDataIdentifiers {
    /// Creates a new builder-style object to manufacture [`CustomDataIdentifiers`](crate::model::CustomDataIdentifiers)
    pub fn builder() -> crate::model::custom_data_identifiers::Builder {
        crate::model::custom_data_identifiers::Builder::default()
    }
}

/// <p>Provides information about a custom data identifier that produced a sensitive data finding, and the sensitive data that it detected for the finding.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CustomDetection {
    /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The total number of occurrences of the sensitive data that the custom data identifier detected.</p>
    pub count: i64,
    /// <p>The name of the custom data identifier.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
    pub occurrences: std::option::Option<crate::model::Occurrences>,
}
impl CustomDetection {
    /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The total number of occurrences of the sensitive data that the custom data identifier detected.</p>
    pub fn count(&self) -> i64 {
        self.count
    }
    /// <p>The name of the custom data identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
    pub fn occurrences(&self) -> std::option::Option<&crate::model::Occurrences> {
        self.occurrences.as_ref()
    }
}
impl std::fmt::Debug for CustomDetection {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CustomDetection");
        formatter.field("arn", &self.arn);
        formatter.field("count", &self.count);
        formatter.field("name", &self.name);
        formatter.field("occurrences", &self.occurrences);
        formatter.finish()
    }
}
/// See [`CustomDetection`](crate::model::CustomDetection)
pub mod custom_detection {
    /// A builder for [`CustomDetection`](crate::model::CustomDetection)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) count: std::option::Option<i64>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) occurrences: std::option::Option<crate::model::Occurrences>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The total number of occurrences of the sensitive data that the custom data identifier detected.</p>
        pub fn count(mut self, input: i64) -> Self {
            self.count = Some(input);
            self
        }
        /// <p>The total number of occurrences of the sensitive data that the custom data identifier detected.</p>
        pub fn set_count(mut self, input: std::option::Option<i64>) -> Self {
            self.count = input;
            self
        }
        /// <p>The name of the custom data identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The name of the custom data identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
        pub fn occurrences(mut self, input: crate::model::Occurrences) -> Self {
            self.occurrences = Some(input);
            self
        }
        /// <p>The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.</p>
        pub fn set_occurrences(
            mut self,
            input: std::option::Option<crate::model::Occurrences>,
        ) -> Self {
            self.occurrences = input;
            self
        }
        /// Consumes the builder and constructs a [`CustomDetection`](crate::model::CustomDetection)
        pub fn build(self) -> crate::model::CustomDetection {
            crate::model::CustomDetection {
                arn: self.arn,
                count: self.count.unwrap_or_default(),
                name: self.name,
                occurrences: self.occurrences,
            }
        }
    }
}
impl CustomDetection {
    /// Creates a new builder-style object to manufacture [`CustomDetection`](crate::model::CustomDetection)
    pub fn builder() -> crate::model::custom_detection::Builder {
        crate::model::custom_detection::Builder::default()
    }
}

/// <p>The category of the finding. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum FindingCategory {
    #[allow(missing_docs)] // documentation missing in model
    Classification,
    #[allow(missing_docs)] // documentation missing in model
    Policy,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for FindingCategory {
    fn from(s: &str) -> Self {
        match s {
            "CLASSIFICATION" => FindingCategory::Classification,
            "POLICY" => FindingCategory::Policy,
            other => FindingCategory::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for FindingCategory {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(FindingCategory::from(s))
    }
}
impl FindingCategory {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            FindingCategory::Classification => "CLASSIFICATION",
            FindingCategory::Policy => "POLICY",
            FindingCategory::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["CLASSIFICATION", "POLICY"]
    }
}
impl AsRef<str> for FindingCategory {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a severity level for findings that a custom data identifier produces. A severity level determines which severity is assigned to the findings, based on the number of occurrences of text that matches the custom data identifier's detection criteria.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SeverityLevel {
    /// <p>The minimum number of occurrences of text that must match the custom data identifier's detection criteria in order to produce a finding with the specified severity (severity).</p>
    pub occurrences_threshold: i64,
    /// <p>The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.</p>
    pub severity: std::option::Option<crate::model::DataIdentifierSeverity>,
}
impl SeverityLevel {
    /// <p>The minimum number of occurrences of text that must match the custom data identifier's detection criteria in order to produce a finding with the specified severity (severity).</p>
    pub fn occurrences_threshold(&self) -> i64 {
        self.occurrences_threshold
    }
    /// <p>The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.</p>
    pub fn severity(&self) -> std::option::Option<&crate::model::DataIdentifierSeverity> {
        self.severity.as_ref()
    }
}
impl std::fmt::Debug for SeverityLevel {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SeverityLevel");
        formatter.field("occurrences_threshold", &self.occurrences_threshold);
        formatter.field("severity", &self.severity);
        formatter.finish()
    }
}
/// See [`SeverityLevel`](crate::model::SeverityLevel)
pub mod severity_level {
    /// A builder for [`SeverityLevel`](crate::model::SeverityLevel)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) occurrences_threshold: std::option::Option<i64>,
        pub(crate) severity: std::option::Option<crate::model::DataIdentifierSeverity>,
    }
    impl Builder {
        /// <p>The minimum number of occurrences of text that must match the custom data identifier's detection criteria in order to produce a finding with the specified severity (severity).</p>
        pub fn occurrences_threshold(mut self, input: i64) -> Self {
            self.occurrences_threshold = Some(input);
            self
        }
        /// <p>The minimum number of occurrences of text that must match the custom data identifier's detection criteria in order to produce a finding with the specified severity (severity).</p>
        pub fn set_occurrences_threshold(mut self, input: std::option::Option<i64>) -> Self {
            self.occurrences_threshold = input;
            self
        }
        /// <p>The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.</p>
        pub fn severity(mut self, input: crate::model::DataIdentifierSeverity) -> Self {
            self.severity = Some(input);
            self
        }
        /// <p>The severity to assign to a finding: if the number of occurrences is greater than or equal to the specified threshold (occurrencesThreshold); and, if applicable, the number of occurrences is less than the threshold for the next consecutive severity level for the custom data identifier, moving from LOW to HIGH.</p>
        pub fn set_severity(
            mut self,
            input: std::option::Option<crate::model::DataIdentifierSeverity>,
        ) -> Self {
            self.severity = input;
            self
        }
        /// Consumes the builder and constructs a [`SeverityLevel`](crate::model::SeverityLevel)
        pub fn build(self) -> crate::model::SeverityLevel {
            crate::model::SeverityLevel {
                occurrences_threshold: self.occurrences_threshold.unwrap_or_default(),
                severity: self.severity,
            }
        }
    }
}
impl SeverityLevel {
    /// Creates a new builder-style object to manufacture [`SeverityLevel`](crate::model::SeverityLevel)
    pub fn builder() -> crate::model::severity_level::Builder {
        crate::model::severity_level::Builder::default()
    }
}

/// <p>The severity of a finding, ranging from LOW, for least severe, to HIGH, for most severe. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DataIdentifierSeverity {
    #[allow(missing_docs)] // documentation missing in model
    High,
    #[allow(missing_docs)] // documentation missing in model
    Low,
    #[allow(missing_docs)] // documentation missing in model
    Medium,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DataIdentifierSeverity {
    fn from(s: &str) -> Self {
        match s {
            "HIGH" => DataIdentifierSeverity::High,
            "LOW" => DataIdentifierSeverity::Low,
            "MEDIUM" => DataIdentifierSeverity::Medium,
            other => DataIdentifierSeverity::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DataIdentifierSeverity {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DataIdentifierSeverity::from(s))
    }
}
impl DataIdentifierSeverity {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DataIdentifierSeverity::High => "HIGH",
            DataIdentifierSeverity::Low => "LOW",
            DataIdentifierSeverity::Medium => "MEDIUM",
            DataIdentifierSeverity::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["HIGH", "LOW", "MEDIUM"]
    }
}
impl AsRef<str> for DataIdentifierSeverity {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the number of S3 buckets that are or aren't shared with other Amazon Web Services accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketCountBySharedAccessType {
    /// <p>The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
    pub external: i64,
    /// <p>The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p>
    pub internal: i64,
    /// <p>The total number of buckets that aren't shared with other Amazon Web Services accounts.</p>
    pub not_shared: i64,
    /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.</p>
    pub unknown: i64,
}
impl BucketCountBySharedAccessType {
    /// <p>The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
    pub fn external(&self) -> i64 {
        self.external
    }
    /// <p>The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p>
    pub fn internal(&self) -> i64 {
        self.internal
    }
    /// <p>The total number of buckets that aren't shared with other Amazon Web Services accounts.</p>
    pub fn not_shared(&self) -> i64 {
        self.not_shared
    }
    /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.</p>
    pub fn unknown(&self) -> i64 {
        self.unknown
    }
}
impl std::fmt::Debug for BucketCountBySharedAccessType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketCountBySharedAccessType");
        formatter.field("external", &self.external);
        formatter.field("internal", &self.internal);
        formatter.field("not_shared", &self.not_shared);
        formatter.field("unknown", &self.unknown);
        formatter.finish()
    }
}
/// See [`BucketCountBySharedAccessType`](crate::model::BucketCountBySharedAccessType)
pub mod bucket_count_by_shared_access_type {
    /// A builder for [`BucketCountBySharedAccessType`](crate::model::BucketCountBySharedAccessType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) external: std::option::Option<i64>,
        pub(crate) internal: std::option::Option<i64>,
        pub(crate) not_shared: std::option::Option<i64>,
        pub(crate) unknown: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
        pub fn external(mut self, input: i64) -> Self {
            self.external = Some(input);
            self
        }
        /// <p>The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
        pub fn set_external(mut self, input: std::option::Option<i64>) -> Self {
            self.external = input;
            self
        }
        /// <p>The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p>
        pub fn internal(mut self, input: i64) -> Self {
            self.internal = Some(input);
            self
        }
        /// <p>The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p>
        pub fn set_internal(mut self, input: std::option::Option<i64>) -> Self {
            self.internal = input;
            self
        }
        /// <p>The total number of buckets that aren't shared with other Amazon Web Services accounts.</p>
        pub fn not_shared(mut self, input: i64) -> Self {
            self.not_shared = Some(input);
            self
        }
        /// <p>The total number of buckets that aren't shared with other Amazon Web Services accounts.</p>
        pub fn set_not_shared(mut self, input: std::option::Option<i64>) -> Self {
            self.not_shared = input;
            self
        }
        /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.</p>
        pub fn unknown(mut self, input: i64) -> Self {
            self.unknown = Some(input);
            self
        }
        /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.</p>
        pub fn set_unknown(mut self, input: std::option::Option<i64>) -> Self {
            self.unknown = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketCountBySharedAccessType`](crate::model::BucketCountBySharedAccessType)
        pub fn build(self) -> crate::model::BucketCountBySharedAccessType {
            crate::model::BucketCountBySharedAccessType {
                external: self.external.unwrap_or_default(),
                internal: self.internal.unwrap_or_default(),
                not_shared: self.not_shared.unwrap_or_default(),
                unknown: self.unknown.unwrap_or_default(),
            }
        }
    }
}
impl BucketCountBySharedAccessType {
    /// Creates a new builder-style object to manufacture [`BucketCountBySharedAccessType`](crate::model::BucketCountBySharedAccessType)
    pub fn builder() -> crate::model::bucket_count_by_shared_access_type::Builder {
        crate::model::bucket_count_by_shared_access_type::Builder::default()
    }
}

/// <p>Provides information about the number of S3 buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketCountPolicyAllowsUnencryptedObjectUploads {
    /// <p>The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p>
    pub allows_unencrypted_object_uploads: i64,
    /// <p>The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p>
    pub denies_unencrypted_object_uploads: i64,
    /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.</p>
    pub unknown: i64,
}
impl BucketCountPolicyAllowsUnencryptedObjectUploads {
    /// <p>The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p>
    pub fn allows_unencrypted_object_uploads(&self) -> i64 {
        self.allows_unencrypted_object_uploads
    }
    /// <p>The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p>
    pub fn denies_unencrypted_object_uploads(&self) -> i64 {
        self.denies_unencrypted_object_uploads
    }
    /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.</p>
    pub fn unknown(&self) -> i64 {
        self.unknown
    }
}
impl std::fmt::Debug for BucketCountPolicyAllowsUnencryptedObjectUploads {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketCountPolicyAllowsUnencryptedObjectUploads");
        formatter.field(
            "allows_unencrypted_object_uploads",
            &self.allows_unencrypted_object_uploads,
        );
        formatter.field(
            "denies_unencrypted_object_uploads",
            &self.denies_unencrypted_object_uploads,
        );
        formatter.field("unknown", &self.unknown);
        formatter.finish()
    }
}
/// See [`BucketCountPolicyAllowsUnencryptedObjectUploads`](crate::model::BucketCountPolicyAllowsUnencryptedObjectUploads)
pub mod bucket_count_policy_allows_unencrypted_object_uploads {
    /// A builder for [`BucketCountPolicyAllowsUnencryptedObjectUploads`](crate::model::BucketCountPolicyAllowsUnencryptedObjectUploads)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) allows_unencrypted_object_uploads: std::option::Option<i64>,
        pub(crate) denies_unencrypted_object_uploads: std::option::Option<i64>,
        pub(crate) unknown: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p>
        pub fn allows_unencrypted_object_uploads(mut self, input: i64) -> Self {
            self.allows_unencrypted_object_uploads = Some(input);
            self
        }
        /// <p>The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p>
        pub fn set_allows_unencrypted_object_uploads(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.allows_unencrypted_object_uploads = input;
            self
        }
        /// <p>The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p>
        pub fn denies_unencrypted_object_uploads(mut self, input: i64) -> Self {
            self.denies_unencrypted_object_uploads = Some(input);
            self
        }
        /// <p>The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p>
        pub fn set_denies_unencrypted_object_uploads(
            mut self,
            input: std::option::Option<i64>,
        ) -> Self {
            self.denies_unencrypted_object_uploads = input;
            self
        }
        /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.</p>
        pub fn unknown(mut self, input: i64) -> Self {
            self.unknown = Some(input);
            self
        }
        /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.</p>
        pub fn set_unknown(mut self, input: std::option::Option<i64>) -> Self {
            self.unknown = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketCountPolicyAllowsUnencryptedObjectUploads`](crate::model::BucketCountPolicyAllowsUnencryptedObjectUploads)
        pub fn build(self) -> crate::model::BucketCountPolicyAllowsUnencryptedObjectUploads {
            crate::model::BucketCountPolicyAllowsUnencryptedObjectUploads {
                allows_unencrypted_object_uploads: self
                    .allows_unencrypted_object_uploads
                    .unwrap_or_default(),
                denies_unencrypted_object_uploads: self
                    .denies_unencrypted_object_uploads
                    .unwrap_or_default(),
                unknown: self.unknown.unwrap_or_default(),
            }
        }
    }
}
impl BucketCountPolicyAllowsUnencryptedObjectUploads {
    /// Creates a new builder-style object to manufacture [`BucketCountPolicyAllowsUnencryptedObjectUploads`](crate::model::BucketCountPolicyAllowsUnencryptedObjectUploads)
    pub fn builder() -> crate::model::bucket_count_policy_allows_unencrypted_object_uploads::Builder
    {
        crate::model::bucket_count_policy_allows_unencrypted_object_uploads::Builder::default()
    }
}

/// <p>Provides information about the number of S3 buckets that use certain types of server-side encryption by default or don't encrypt new objects by default. For detailed information about these settings, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side encryption behavior for Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketCountByEncryptionType {
    /// <p>The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.</p>
    pub kms_managed: i64,
    /// <p>The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.</p>
    pub s3_managed: i64,
    /// <p>The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.</p>
    pub unencrypted: i64,
    /// <p>The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.</p>
    pub unknown: i64,
}
impl BucketCountByEncryptionType {
    /// <p>The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.</p>
    pub fn kms_managed(&self) -> i64 {
        self.kms_managed
    }
    /// <p>The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.</p>
    pub fn s3_managed(&self) -> i64 {
        self.s3_managed
    }
    /// <p>The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.</p>
    pub fn unencrypted(&self) -> i64 {
        self.unencrypted
    }
    /// <p>The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.</p>
    pub fn unknown(&self) -> i64 {
        self.unknown
    }
}
impl std::fmt::Debug for BucketCountByEncryptionType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketCountByEncryptionType");
        formatter.field("kms_managed", &self.kms_managed);
        formatter.field("s3_managed", &self.s3_managed);
        formatter.field("unencrypted", &self.unencrypted);
        formatter.field("unknown", &self.unknown);
        formatter.finish()
    }
}
/// See [`BucketCountByEncryptionType`](crate::model::BucketCountByEncryptionType)
pub mod bucket_count_by_encryption_type {
    /// A builder for [`BucketCountByEncryptionType`](crate::model::BucketCountByEncryptionType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_managed: std::option::Option<i64>,
        pub(crate) s3_managed: std::option::Option<i64>,
        pub(crate) unencrypted: std::option::Option<i64>,
        pub(crate) unknown: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.</p>
        pub fn kms_managed(mut self, input: i64) -> Self {
            self.kms_managed = Some(input);
            self
        }
        /// <p>The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.</p>
        pub fn set_kms_managed(mut self, input: std::option::Option<i64>) -> Self {
            self.kms_managed = input;
            self
        }
        /// <p>The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.</p>
        pub fn s3_managed(mut self, input: i64) -> Self {
            self.s3_managed = Some(input);
            self
        }
        /// <p>The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.</p>
        pub fn set_s3_managed(mut self, input: std::option::Option<i64>) -> Self {
            self.s3_managed = input;
            self
        }
        /// <p>The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.</p>
        pub fn unencrypted(mut self, input: i64) -> Self {
            self.unencrypted = Some(input);
            self
        }
        /// <p>The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.</p>
        pub fn set_unencrypted(mut self, input: std::option::Option<i64>) -> Self {
            self.unencrypted = input;
            self
        }
        /// <p>The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.</p>
        pub fn unknown(mut self, input: i64) -> Self {
            self.unknown = Some(input);
            self
        }
        /// <p>The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.</p>
        pub fn set_unknown(mut self, input: std::option::Option<i64>) -> Self {
            self.unknown = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketCountByEncryptionType`](crate::model::BucketCountByEncryptionType)
        pub fn build(self) -> crate::model::BucketCountByEncryptionType {
            crate::model::BucketCountByEncryptionType {
                kms_managed: self.kms_managed.unwrap_or_default(),
                s3_managed: self.s3_managed.unwrap_or_default(),
                unencrypted: self.unencrypted.unwrap_or_default(),
                unknown: self.unknown.unwrap_or_default(),
            }
        }
    }
}
impl BucketCountByEncryptionType {
    /// Creates a new builder-style object to manufacture [`BucketCountByEncryptionType`](crate::model::BucketCountByEncryptionType)
    pub fn builder() -> crate::model::bucket_count_by_encryption_type::Builder {
        crate::model::bucket_count_by_encryption_type::Builder::default()
    }
}

/// <p>Provides information about the number of S3 buckets that are publicly accessible based on a combination of permissions settings for each bucket.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketCountByEffectivePermission {
    /// <p>The total number of buckets that allow the general public to have read or write access to the bucket.</p>
    pub publicly_accessible: i64,
    /// <p>The total number of buckets that allow the general public to have read access to the bucket.</p>
    pub publicly_readable: i64,
    /// <p>The total number of buckets that allow the general public to have write access to the bucket.</p>
    pub publicly_writable: i64,
    /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.</p>
    pub unknown: i64,
}
impl BucketCountByEffectivePermission {
    /// <p>The total number of buckets that allow the general public to have read or write access to the bucket.</p>
    pub fn publicly_accessible(&self) -> i64 {
        self.publicly_accessible
    }
    /// <p>The total number of buckets that allow the general public to have read access to the bucket.</p>
    pub fn publicly_readable(&self) -> i64 {
        self.publicly_readable
    }
    /// <p>The total number of buckets that allow the general public to have write access to the bucket.</p>
    pub fn publicly_writable(&self) -> i64 {
        self.publicly_writable
    }
    /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.</p>
    pub fn unknown(&self) -> i64 {
        self.unknown
    }
}
impl std::fmt::Debug for BucketCountByEffectivePermission {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketCountByEffectivePermission");
        formatter.field("publicly_accessible", &self.publicly_accessible);
        formatter.field("publicly_readable", &self.publicly_readable);
        formatter.field("publicly_writable", &self.publicly_writable);
        formatter.field("unknown", &self.unknown);
        formatter.finish()
    }
}
/// See [`BucketCountByEffectivePermission`](crate::model::BucketCountByEffectivePermission)
pub mod bucket_count_by_effective_permission {
    /// A builder for [`BucketCountByEffectivePermission`](crate::model::BucketCountByEffectivePermission)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) publicly_accessible: std::option::Option<i64>,
        pub(crate) publicly_readable: std::option::Option<i64>,
        pub(crate) publicly_writable: std::option::Option<i64>,
        pub(crate) unknown: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>The total number of buckets that allow the general public to have read or write access to the bucket.</p>
        pub fn publicly_accessible(mut self, input: i64) -> Self {
            self.publicly_accessible = Some(input);
            self
        }
        /// <p>The total number of buckets that allow the general public to have read or write access to the bucket.</p>
        pub fn set_publicly_accessible(mut self, input: std::option::Option<i64>) -> Self {
            self.publicly_accessible = input;
            self
        }
        /// <p>The total number of buckets that allow the general public to have read access to the bucket.</p>
        pub fn publicly_readable(mut self, input: i64) -> Self {
            self.publicly_readable = Some(input);
            self
        }
        /// <p>The total number of buckets that allow the general public to have read access to the bucket.</p>
        pub fn set_publicly_readable(mut self, input: std::option::Option<i64>) -> Self {
            self.publicly_readable = input;
            self
        }
        /// <p>The total number of buckets that allow the general public to have write access to the bucket.</p>
        pub fn publicly_writable(mut self, input: i64) -> Self {
            self.publicly_writable = Some(input);
            self
        }
        /// <p>The total number of buckets that allow the general public to have write access to the bucket.</p>
        pub fn set_publicly_writable(mut self, input: std::option::Option<i64>) -> Self {
            self.publicly_writable = input;
            self
        }
        /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.</p>
        pub fn unknown(mut self, input: i64) -> Self {
            self.unknown = Some(input);
            self
        }
        /// <p>The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.</p>
        pub fn set_unknown(mut self, input: std::option::Option<i64>) -> Self {
            self.unknown = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketCountByEffectivePermission`](crate::model::BucketCountByEffectivePermission)
        pub fn build(self) -> crate::model::BucketCountByEffectivePermission {
            crate::model::BucketCountByEffectivePermission {
                publicly_accessible: self.publicly_accessible.unwrap_or_default(),
                publicly_readable: self.publicly_readable.unwrap_or_default(),
                publicly_writable: self.publicly_writable.unwrap_or_default(),
                unknown: self.unknown.unwrap_or_default(),
            }
        }
    }
}
impl BucketCountByEffectivePermission {
    /// Creates a new builder-style object to manufacture [`BucketCountByEffectivePermission`](crate::model::BucketCountByEffectivePermission)
    pub fn builder() -> crate::model::bucket_count_by_effective_permission::Builder {
        crate::model::bucket_count_by_effective_permission::Builder::default()
    }
}

/// <p>Provides processing statistics for a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Statistics {
    /// <p>The approximate number of objects that the job has yet to process during its current run.</p>
    pub approximate_number_of_objects_to_process: f64,
    /// <p>The number of times that the job has run.</p>
    pub number_of_runs: f64,
}
impl Statistics {
    /// <p>The approximate number of objects that the job has yet to process during its current run.</p>
    pub fn approximate_number_of_objects_to_process(&self) -> f64 {
        self.approximate_number_of_objects_to_process
    }
    /// <p>The number of times that the job has run.</p>
    pub fn number_of_runs(&self) -> f64 {
        self.number_of_runs
    }
}
impl std::fmt::Debug for Statistics {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Statistics");
        formatter.field(
            "approximate_number_of_objects_to_process",
            &self.approximate_number_of_objects_to_process,
        );
        formatter.field("number_of_runs", &self.number_of_runs);
        formatter.finish()
    }
}
/// See [`Statistics`](crate::model::Statistics)
pub mod statistics {
    /// A builder for [`Statistics`](crate::model::Statistics)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) approximate_number_of_objects_to_process: std::option::Option<f64>,
        pub(crate) number_of_runs: std::option::Option<f64>,
    }
    impl Builder {
        /// <p>The approximate number of objects that the job has yet to process during its current run.</p>
        pub fn approximate_number_of_objects_to_process(mut self, input: f64) -> Self {
            self.approximate_number_of_objects_to_process = Some(input);
            self
        }
        /// <p>The approximate number of objects that the job has yet to process during its current run.</p>
        pub fn set_approximate_number_of_objects_to_process(
            mut self,
            input: std::option::Option<f64>,
        ) -> Self {
            self.approximate_number_of_objects_to_process = input;
            self
        }
        /// <p>The number of times that the job has run.</p>
        pub fn number_of_runs(mut self, input: f64) -> Self {
            self.number_of_runs = Some(input);
            self
        }
        /// <p>The number of times that the job has run.</p>
        pub fn set_number_of_runs(mut self, input: std::option::Option<f64>) -> Self {
            self.number_of_runs = input;
            self
        }
        /// Consumes the builder and constructs a [`Statistics`](crate::model::Statistics)
        pub fn build(self) -> crate::model::Statistics {
            crate::model::Statistics {
                approximate_number_of_objects_to_process: self
                    .approximate_number_of_objects_to_process
                    .unwrap_or_default(),
                number_of_runs: self.number_of_runs.unwrap_or_default(),
            }
        }
    }
}
impl Statistics {
    /// Creates a new builder-style object to manufacture [`Statistics`](crate::model::Statistics)
    pub fn builder() -> crate::model::statistics::Builder {
        crate::model::statistics::Builder::default()
    }
}

/// <p>Specifies the recurrence pattern for running a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobScheduleFrequency {
    /// <p>Specifies a daily recurrence pattern for running the job.</p>
    pub daily_schedule: std::option::Option<crate::model::DailySchedule>,
    /// <p>Specifies a monthly recurrence pattern for running the job.</p>
    pub monthly_schedule: std::option::Option<crate::model::MonthlySchedule>,
    /// <p>Specifies a weekly recurrence pattern for running the job.</p>
    pub weekly_schedule: std::option::Option<crate::model::WeeklySchedule>,
}
impl JobScheduleFrequency {
    /// <p>Specifies a daily recurrence pattern for running the job.</p>
    pub fn daily_schedule(&self) -> std::option::Option<&crate::model::DailySchedule> {
        self.daily_schedule.as_ref()
    }
    /// <p>Specifies a monthly recurrence pattern for running the job.</p>
    pub fn monthly_schedule(&self) -> std::option::Option<&crate::model::MonthlySchedule> {
        self.monthly_schedule.as_ref()
    }
    /// <p>Specifies a weekly recurrence pattern for running the job.</p>
    pub fn weekly_schedule(&self) -> std::option::Option<&crate::model::WeeklySchedule> {
        self.weekly_schedule.as_ref()
    }
}
impl std::fmt::Debug for JobScheduleFrequency {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobScheduleFrequency");
        formatter.field("daily_schedule", &self.daily_schedule);
        formatter.field("monthly_schedule", &self.monthly_schedule);
        formatter.field("weekly_schedule", &self.weekly_schedule);
        formatter.finish()
    }
}
/// See [`JobScheduleFrequency`](crate::model::JobScheduleFrequency)
pub mod job_schedule_frequency {
    /// A builder for [`JobScheduleFrequency`](crate::model::JobScheduleFrequency)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) daily_schedule: std::option::Option<crate::model::DailySchedule>,
        pub(crate) monthly_schedule: std::option::Option<crate::model::MonthlySchedule>,
        pub(crate) weekly_schedule: std::option::Option<crate::model::WeeklySchedule>,
    }
    impl Builder {
        /// <p>Specifies a daily recurrence pattern for running the job.</p>
        pub fn daily_schedule(mut self, input: crate::model::DailySchedule) -> Self {
            self.daily_schedule = Some(input);
            self
        }
        /// <p>Specifies a daily recurrence pattern for running the job.</p>
        pub fn set_daily_schedule(
            mut self,
            input: std::option::Option<crate::model::DailySchedule>,
        ) -> Self {
            self.daily_schedule = input;
            self
        }
        /// <p>Specifies a monthly recurrence pattern for running the job.</p>
        pub fn monthly_schedule(mut self, input: crate::model::MonthlySchedule) -> Self {
            self.monthly_schedule = Some(input);
            self
        }
        /// <p>Specifies a monthly recurrence pattern for running the job.</p>
        pub fn set_monthly_schedule(
            mut self,
            input: std::option::Option<crate::model::MonthlySchedule>,
        ) -> Self {
            self.monthly_schedule = input;
            self
        }
        /// <p>Specifies a weekly recurrence pattern for running the job.</p>
        pub fn weekly_schedule(mut self, input: crate::model::WeeklySchedule) -> Self {
            self.weekly_schedule = Some(input);
            self
        }
        /// <p>Specifies a weekly recurrence pattern for running the job.</p>
        pub fn set_weekly_schedule(
            mut self,
            input: std::option::Option<crate::model::WeeklySchedule>,
        ) -> Self {
            self.weekly_schedule = input;
            self
        }
        /// Consumes the builder and constructs a [`JobScheduleFrequency`](crate::model::JobScheduleFrequency)
        pub fn build(self) -> crate::model::JobScheduleFrequency {
            crate::model::JobScheduleFrequency {
                daily_schedule: self.daily_schedule,
                monthly_schedule: self.monthly_schedule,
                weekly_schedule: self.weekly_schedule,
            }
        }
    }
}
impl JobScheduleFrequency {
    /// Creates a new builder-style object to manufacture [`JobScheduleFrequency`](crate::model::JobScheduleFrequency)
    pub fn builder() -> crate::model::job_schedule_frequency::Builder {
        crate::model::job_schedule_frequency::Builder::default()
    }
}

/// <p>Specifies a weekly recurrence pattern for running a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct WeeklySchedule {
    /// <p>The day of the week when Amazon Macie runs the job.</p>
    pub day_of_week: std::option::Option<crate::model::DayOfWeek>,
}
impl WeeklySchedule {
    /// <p>The day of the week when Amazon Macie runs the job.</p>
    pub fn day_of_week(&self) -> std::option::Option<&crate::model::DayOfWeek> {
        self.day_of_week.as_ref()
    }
}
impl std::fmt::Debug for WeeklySchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("WeeklySchedule");
        formatter.field("day_of_week", &self.day_of_week);
        formatter.finish()
    }
}
/// See [`WeeklySchedule`](crate::model::WeeklySchedule)
pub mod weekly_schedule {
    /// A builder for [`WeeklySchedule`](crate::model::WeeklySchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) day_of_week: std::option::Option<crate::model::DayOfWeek>,
    }
    impl Builder {
        /// <p>The day of the week when Amazon Macie runs the job.</p>
        pub fn day_of_week(mut self, input: crate::model::DayOfWeek) -> Self {
            self.day_of_week = Some(input);
            self
        }
        /// <p>The day of the week when Amazon Macie runs the job.</p>
        pub fn set_day_of_week(
            mut self,
            input: std::option::Option<crate::model::DayOfWeek>,
        ) -> Self {
            self.day_of_week = input;
            self
        }
        /// Consumes the builder and constructs a [`WeeklySchedule`](crate::model::WeeklySchedule)
        pub fn build(self) -> crate::model::WeeklySchedule {
            crate::model::WeeklySchedule {
                day_of_week: self.day_of_week,
            }
        }
    }
}
impl WeeklySchedule {
    /// Creates a new builder-style object to manufacture [`WeeklySchedule`](crate::model::WeeklySchedule)
    pub fn builder() -> crate::model::weekly_schedule::Builder {
        crate::model::weekly_schedule::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum DayOfWeek {
    #[allow(missing_docs)] // documentation missing in model
    Friday,
    #[allow(missing_docs)] // documentation missing in model
    Monday,
    #[allow(missing_docs)] // documentation missing in model
    Saturday,
    #[allow(missing_docs)] // documentation missing in model
    Sunday,
    #[allow(missing_docs)] // documentation missing in model
    Thursday,
    #[allow(missing_docs)] // documentation missing in model
    Tuesday,
    #[allow(missing_docs)] // documentation missing in model
    Wednesday,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for DayOfWeek {
    fn from(s: &str) -> Self {
        match s {
            "FRIDAY" => DayOfWeek::Friday,
            "MONDAY" => DayOfWeek::Monday,
            "SATURDAY" => DayOfWeek::Saturday,
            "SUNDAY" => DayOfWeek::Sunday,
            "THURSDAY" => DayOfWeek::Thursday,
            "TUESDAY" => DayOfWeek::Tuesday,
            "WEDNESDAY" => DayOfWeek::Wednesday,
            other => DayOfWeek::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for DayOfWeek {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(DayOfWeek::from(s))
    }
}
impl DayOfWeek {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            DayOfWeek::Friday => "FRIDAY",
            DayOfWeek::Monday => "MONDAY",
            DayOfWeek::Saturday => "SATURDAY",
            DayOfWeek::Sunday => "SUNDAY",
            DayOfWeek::Thursday => "THURSDAY",
            DayOfWeek::Tuesday => "TUESDAY",
            DayOfWeek::Wednesday => "WEDNESDAY",
            DayOfWeek::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "FRIDAY",
            "MONDAY",
            "SATURDAY",
            "SUNDAY",
            "THURSDAY",
            "TUESDAY",
            "WEDNESDAY",
        ]
    }
}
impl AsRef<str> for DayOfWeek {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a monthly recurrence pattern for running a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MonthlySchedule {
    /// <p>The numeric day of the month when Amazon Macie runs the job. This value can be an integer from 1 through 31.</p>
    /// <p>If this value exceeds the number of days in a certain month, Macie doesn't run the job that month. Macie runs the job only during months that have the specified day. For example, if this value is 31 and a month has only 30 days, Macie doesn't run the job that month. To run the job every month, specify a value that's less than 29.</p>
    pub day_of_month: i32,
}
impl MonthlySchedule {
    /// <p>The numeric day of the month when Amazon Macie runs the job. This value can be an integer from 1 through 31.</p>
    /// <p>If this value exceeds the number of days in a certain month, Macie doesn't run the job that month. Macie runs the job only during months that have the specified day. For example, if this value is 31 and a month has only 30 days, Macie doesn't run the job that month. To run the job every month, specify a value that's less than 29.</p>
    pub fn day_of_month(&self) -> i32 {
        self.day_of_month
    }
}
impl std::fmt::Debug for MonthlySchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MonthlySchedule");
        formatter.field("day_of_month", &self.day_of_month);
        formatter.finish()
    }
}
/// See [`MonthlySchedule`](crate::model::MonthlySchedule)
pub mod monthly_schedule {
    /// A builder for [`MonthlySchedule`](crate::model::MonthlySchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) day_of_month: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The numeric day of the month when Amazon Macie runs the job. This value can be an integer from 1 through 31.</p>
        /// <p>If this value exceeds the number of days in a certain month, Macie doesn't run the job that month. Macie runs the job only during months that have the specified day. For example, if this value is 31 and a month has only 30 days, Macie doesn't run the job that month. To run the job every month, specify a value that's less than 29.</p>
        pub fn day_of_month(mut self, input: i32) -> Self {
            self.day_of_month = Some(input);
            self
        }
        /// <p>The numeric day of the month when Amazon Macie runs the job. This value can be an integer from 1 through 31.</p>
        /// <p>If this value exceeds the number of days in a certain month, Macie doesn't run the job that month. Macie runs the job only during months that have the specified day. For example, if this value is 31 and a month has only 30 days, Macie doesn't run the job that month. To run the job every month, specify a value that's less than 29.</p>
        pub fn set_day_of_month(mut self, input: std::option::Option<i32>) -> Self {
            self.day_of_month = input;
            self
        }
        /// Consumes the builder and constructs a [`MonthlySchedule`](crate::model::MonthlySchedule)
        pub fn build(self) -> crate::model::MonthlySchedule {
            crate::model::MonthlySchedule {
                day_of_month: self.day_of_month.unwrap_or_default(),
            }
        }
    }
}
impl MonthlySchedule {
    /// Creates a new builder-style object to manufacture [`MonthlySchedule`](crate::model::MonthlySchedule)
    pub fn builder() -> crate::model::monthly_schedule::Builder {
        crate::model::monthly_schedule::Builder::default()
    }
}

/// <p>Specifies that a classification job runs once a day, every day. This is an empty object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DailySchedule {}
impl std::fmt::Debug for DailySchedule {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DailySchedule");
        formatter.finish()
    }
}
/// See [`DailySchedule`](crate::model::DailySchedule)
pub mod daily_schedule {
    /// A builder for [`DailySchedule`](crate::model::DailySchedule)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DailySchedule`](crate::model::DailySchedule)
        pub fn build(self) -> crate::model::DailySchedule {
            crate::model::DailySchedule {}
        }
    }
}
impl DailySchedule {
    /// Creates a new builder-style object to manufacture [`DailySchedule`](crate::model::DailySchedule)
    pub fn builder() -> crate::model::daily_schedule::Builder {
        crate::model::daily_schedule::Builder::default()
    }
}

/// <p>Specifies which S3 buckets contain the objects that a classification job analyzes, and the scope of that analysis. The bucket specification can be static (bucketDefinitions) or dynamic (bucketCriteria). If it's static, the job analyzes objects in the same predefined set of buckets each time the job runs. If it's dynamic, the job analyzes objects in any buckets that match the specified criteria each time the job starts to run.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3JobDefinition {
    /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
    pub bucket_definitions:
        std::option::Option<std::vec::Vec<crate::model::S3BucketDefinitionForJob>>,
    /// <p>The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.</p>
    pub scoping: std::option::Option<crate::model::Scoping>,
    /// <p>The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
    pub bucket_criteria: std::option::Option<crate::model::S3BucketCriteriaForJob>,
}
impl S3JobDefinition {
    /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
    pub fn bucket_definitions(
        &self,
    ) -> std::option::Option<&[crate::model::S3BucketDefinitionForJob]> {
        self.bucket_definitions.as_deref()
    }
    /// <p>The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.</p>
    pub fn scoping(&self) -> std::option::Option<&crate::model::Scoping> {
        self.scoping.as_ref()
    }
    /// <p>The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
    pub fn bucket_criteria(&self) -> std::option::Option<&crate::model::S3BucketCriteriaForJob> {
        self.bucket_criteria.as_ref()
    }
}
impl std::fmt::Debug for S3JobDefinition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3JobDefinition");
        formatter.field("bucket_definitions", &self.bucket_definitions);
        formatter.field("scoping", &self.scoping);
        formatter.field("bucket_criteria", &self.bucket_criteria);
        formatter.finish()
    }
}
/// See [`S3JobDefinition`](crate::model::S3JobDefinition)
pub mod s3_job_definition {
    /// A builder for [`S3JobDefinition`](crate::model::S3JobDefinition)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_definitions:
            std::option::Option<std::vec::Vec<crate::model::S3BucketDefinitionForJob>>,
        pub(crate) scoping: std::option::Option<crate::model::Scoping>,
        pub(crate) bucket_criteria: std::option::Option<crate::model::S3BucketCriteriaForJob>,
    }
    impl Builder {
        /// Appends an item to `bucket_definitions`.
        ///
        /// To override the contents of this collection use [`set_bucket_definitions`](Self::set_bucket_definitions).
        ///
        /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
        pub fn bucket_definitions(mut self, input: crate::model::S3BucketDefinitionForJob) -> Self {
            let mut v = self.bucket_definitions.unwrap_or_default();
            v.push(input);
            self.bucket_definitions = Some(v);
            self
        }
        /// <p>An array of objects, one for each Amazon Web Services account that owns specific S3 buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for that account. A job's definition can contain a bucketDefinitions array or a bucketCriteria object, not both.</p>
        pub fn set_bucket_definitions(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3BucketDefinitionForJob>>,
        ) -> Self {
            self.bucket_definitions = input;
            self
        }
        /// <p>The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.</p>
        pub fn scoping(mut self, input: crate::model::Scoping) -> Self {
            self.scoping = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which S3 objects to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which objects to analyze.</p>
        pub fn set_scoping(mut self, input: std::option::Option<crate::model::Scoping>) -> Self {
            self.scoping = input;
            self
        }
        /// <p>The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
        pub fn bucket_criteria(mut self, input: crate::model::S3BucketCriteriaForJob) -> Self {
            self.bucket_criteria = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Each time the job runs, the job uses these criteria to determine which buckets contain objects to analyze. A job's definition can contain a bucketCriteria object or a bucketDefinitions array, not both.</p>
        pub fn set_bucket_criteria(
            mut self,
            input: std::option::Option<crate::model::S3BucketCriteriaForJob>,
        ) -> Self {
            self.bucket_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`S3JobDefinition`](crate::model::S3JobDefinition)
        pub fn build(self) -> crate::model::S3JobDefinition {
            crate::model::S3JobDefinition {
                bucket_definitions: self.bucket_definitions,
                scoping: self.scoping,
                bucket_criteria: self.bucket_criteria,
            }
        }
    }
}
impl S3JobDefinition {
    /// Creates a new builder-style object to manufacture [`S3JobDefinition`](crate::model::S3JobDefinition)
    pub fn builder() -> crate::model::s3_job_definition::Builder {
        crate::model::s3_job_definition::Builder::default()
    }
}

/// <p>Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 objects from a classification job. Exclude conditions take precedence over include conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct Scoping {
    /// <p>The property- and tag-based conditions that determine which objects to exclude from the analysis.</p>
    pub excludes: std::option::Option<crate::model::JobScopingBlock>,
    /// <p>The property- and tag-based conditions that determine which objects to include in the analysis.</p>
    pub includes: std::option::Option<crate::model::JobScopingBlock>,
}
impl Scoping {
    /// <p>The property- and tag-based conditions that determine which objects to exclude from the analysis.</p>
    pub fn excludes(&self) -> std::option::Option<&crate::model::JobScopingBlock> {
        self.excludes.as_ref()
    }
    /// <p>The property- and tag-based conditions that determine which objects to include in the analysis.</p>
    pub fn includes(&self) -> std::option::Option<&crate::model::JobScopingBlock> {
        self.includes.as_ref()
    }
}
impl std::fmt::Debug for Scoping {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("Scoping");
        formatter.field("excludes", &self.excludes);
        formatter.field("includes", &self.includes);
        formatter.finish()
    }
}
/// See [`Scoping`](crate::model::Scoping)
pub mod scoping {
    /// A builder for [`Scoping`](crate::model::Scoping)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) excludes: std::option::Option<crate::model::JobScopingBlock>,
        pub(crate) includes: std::option::Option<crate::model::JobScopingBlock>,
    }
    impl Builder {
        /// <p>The property- and tag-based conditions that determine which objects to exclude from the analysis.</p>
        pub fn excludes(mut self, input: crate::model::JobScopingBlock) -> Self {
            self.excludes = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which objects to exclude from the analysis.</p>
        pub fn set_excludes(
            mut self,
            input: std::option::Option<crate::model::JobScopingBlock>,
        ) -> Self {
            self.excludes = input;
            self
        }
        /// <p>The property- and tag-based conditions that determine which objects to include in the analysis.</p>
        pub fn includes(mut self, input: crate::model::JobScopingBlock) -> Self {
            self.includes = Some(input);
            self
        }
        /// <p>The property- and tag-based conditions that determine which objects to include in the analysis.</p>
        pub fn set_includes(
            mut self,
            input: std::option::Option<crate::model::JobScopingBlock>,
        ) -> Self {
            self.includes = input;
            self
        }
        /// Consumes the builder and constructs a [`Scoping`](crate::model::Scoping)
        pub fn build(self) -> crate::model::Scoping {
            crate::model::Scoping {
                excludes: self.excludes,
                includes: self.includes,
            }
        }
    }
}
impl Scoping {
    /// Creates a new builder-style object to manufacture [`Scoping`](crate::model::Scoping)
    pub fn builder() -> crate::model::scoping::Builder {
        crate::model::scoping::Builder::default()
    }
}

/// <p>Specifies one or more property- and tag-based conditions that define criteria for including or excluding S3 objects from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobScopingBlock {
    /// <p>An array of conditions, one for each property- or tag-based condition that determines which objects to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
    pub and: std::option::Option<std::vec::Vec<crate::model::JobScopeTerm>>,
}
impl JobScopingBlock {
    /// <p>An array of conditions, one for each property- or tag-based condition that determines which objects to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
    pub fn and(&self) -> std::option::Option<&[crate::model::JobScopeTerm]> {
        self.and.as_deref()
    }
}
impl std::fmt::Debug for JobScopingBlock {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobScopingBlock");
        formatter.field("and", &self.and);
        formatter.finish()
    }
}
/// See [`JobScopingBlock`](crate::model::JobScopingBlock)
pub mod job_scoping_block {
    /// A builder for [`JobScopingBlock`](crate::model::JobScopingBlock)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) and: std::option::Option<std::vec::Vec<crate::model::JobScopeTerm>>,
    }
    impl Builder {
        /// Appends an item to `and`.
        ///
        /// To override the contents of this collection use [`set_and`](Self::set_and).
        ///
        /// <p>An array of conditions, one for each property- or tag-based condition that determines which objects to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
        pub fn and(mut self, input: crate::model::JobScopeTerm) -> Self {
            let mut v = self.and.unwrap_or_default();
            v.push(input);
            self.and = Some(v);
            self
        }
        /// <p>An array of conditions, one for each property- or tag-based condition that determines which objects to include or exclude from the job. If you specify more than one condition, Amazon Macie uses AND logic to join the conditions.</p>
        pub fn set_and(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::JobScopeTerm>>,
        ) -> Self {
            self.and = input;
            self
        }
        /// Consumes the builder and constructs a [`JobScopingBlock`](crate::model::JobScopingBlock)
        pub fn build(self) -> crate::model::JobScopingBlock {
            crate::model::JobScopingBlock { and: self.and }
        }
    }
}
impl JobScopingBlock {
    /// Creates a new builder-style object to manufacture [`JobScopingBlock`](crate::model::JobScopingBlock)
    pub fn builder() -> crate::model::job_scoping_block::Builder {
        crate::model::job_scoping_block::Builder::default()
    }
}

/// <p>Specifies a property- or tag-based condition that defines criteria for including or excluding S3 objects from a classification job. A JobScopeTerm object can contain only one simpleScopeTerm object or one tagScopeTerm object.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct JobScopeTerm {
    /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding objects from the job.</p>
    pub simple_scope_term: std::option::Option<crate::model::SimpleScopeTerm>,
    /// <p>A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding objects from the job.</p>
    pub tag_scope_term: std::option::Option<crate::model::TagScopeTerm>,
}
impl JobScopeTerm {
    /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding objects from the job.</p>
    pub fn simple_scope_term(&self) -> std::option::Option<&crate::model::SimpleScopeTerm> {
        self.simple_scope_term.as_ref()
    }
    /// <p>A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding objects from the job.</p>
    pub fn tag_scope_term(&self) -> std::option::Option<&crate::model::TagScopeTerm> {
        self.tag_scope_term.as_ref()
    }
}
impl std::fmt::Debug for JobScopeTerm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("JobScopeTerm");
        formatter.field("simple_scope_term", &self.simple_scope_term);
        formatter.field("tag_scope_term", &self.tag_scope_term);
        formatter.finish()
    }
}
/// See [`JobScopeTerm`](crate::model::JobScopeTerm)
pub mod job_scope_term {
    /// A builder for [`JobScopeTerm`](crate::model::JobScopeTerm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) simple_scope_term: std::option::Option<crate::model::SimpleScopeTerm>,
        pub(crate) tag_scope_term: std::option::Option<crate::model::TagScopeTerm>,
    }
    impl Builder {
        /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding objects from the job.</p>
        pub fn simple_scope_term(mut self, input: crate::model::SimpleScopeTerm) -> Self {
            self.simple_scope_term = Some(input);
            self
        }
        /// <p>A property-based condition that defines a property, operator, and one or more values for including or excluding objects from the job.</p>
        pub fn set_simple_scope_term(
            mut self,
            input: std::option::Option<crate::model::SimpleScopeTerm>,
        ) -> Self {
            self.simple_scope_term = input;
            self
        }
        /// <p>A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding objects from the job.</p>
        pub fn tag_scope_term(mut self, input: crate::model::TagScopeTerm) -> Self {
            self.tag_scope_term = Some(input);
            self
        }
        /// <p>A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding objects from the job.</p>
        pub fn set_tag_scope_term(
            mut self,
            input: std::option::Option<crate::model::TagScopeTerm>,
        ) -> Self {
            self.tag_scope_term = input;
            self
        }
        /// Consumes the builder and constructs a [`JobScopeTerm`](crate::model::JobScopeTerm)
        pub fn build(self) -> crate::model::JobScopeTerm {
            crate::model::JobScopeTerm {
                simple_scope_term: self.simple_scope_term,
                tag_scope_term: self.tag_scope_term,
            }
        }
    }
}
impl JobScopeTerm {
    /// Creates a new builder-style object to manufacture [`JobScopeTerm`](crate::model::JobScopeTerm)
    pub fn builder() -> crate::model::job_scope_term::Builder {
        crate::model::job_scope_term::Builder::default()
    }
}

/// <p>Specifies a tag-based condition that determines whether an S3 object is included or excluded from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagScopeTerm {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).</p>
    pub comparator: std::option::Option<crate::model::JobComparator>,
    /// <p>The object property to use in the condition. The only valid value is TAG.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.</p>
    pub tag_values: std::option::Option<std::vec::Vec<crate::model::TagValuePair>>,
    /// <p>The type of object to apply the condition to.</p>
    pub target: std::option::Option<crate::model::TagTarget>,
}
impl TagScopeTerm {
    /// <p>The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).</p>
    pub fn comparator(&self) -> std::option::Option<&crate::model::JobComparator> {
        self.comparator.as_ref()
    }
    /// <p>The object property to use in the condition. The only valid value is TAG.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.</p>
    pub fn tag_values(&self) -> std::option::Option<&[crate::model::TagValuePair]> {
        self.tag_values.as_deref()
    }
    /// <p>The type of object to apply the condition to.</p>
    pub fn target(&self) -> std::option::Option<&crate::model::TagTarget> {
        self.target.as_ref()
    }
}
impl std::fmt::Debug for TagScopeTerm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagScopeTerm");
        formatter.field("comparator", &self.comparator);
        formatter.field("key", &self.key);
        formatter.field("tag_values", &self.tag_values);
        formatter.field("target", &self.target);
        formatter.finish()
    }
}
/// See [`TagScopeTerm`](crate::model::TagScopeTerm)
pub mod tag_scope_term {
    /// A builder for [`TagScopeTerm`](crate::model::TagScopeTerm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::JobComparator>,
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) tag_values: std::option::Option<std::vec::Vec<crate::model::TagValuePair>>,
        pub(crate) target: std::option::Option<crate::model::TagTarget>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).</p>
        pub fn comparator(mut self, input: crate::model::JobComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. Valid values are EQ (equals) or NE (not equals).</p>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::JobComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// <p>The object property to use in the condition. The only valid value is TAG.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The object property to use in the condition. The only valid value is TAG.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `tag_values`.
        ///
        /// To override the contents of this collection use [`set_tag_values`](Self::set_tag_values).
        ///
        /// <p>The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.</p>
        pub fn tag_values(mut self, input: crate::model::TagValuePair) -> Self {
            let mut v = self.tag_values.unwrap_or_default();
            v.push(input);
            self.tag_values = Some(v);
            self
        }
        /// <p>The tag keys or tag key and value pairs to use in the condition. To specify only tag keys in a condition, specify the keys in this array and set the value for each associated tag value to an empty string.</p>
        pub fn set_tag_values(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::TagValuePair>>,
        ) -> Self {
            self.tag_values = input;
            self
        }
        /// <p>The type of object to apply the condition to.</p>
        pub fn target(mut self, input: crate::model::TagTarget) -> Self {
            self.target = Some(input);
            self
        }
        /// <p>The type of object to apply the condition to.</p>
        pub fn set_target(mut self, input: std::option::Option<crate::model::TagTarget>) -> Self {
            self.target = input;
            self
        }
        /// Consumes the builder and constructs a [`TagScopeTerm`](crate::model::TagScopeTerm)
        pub fn build(self) -> crate::model::TagScopeTerm {
            crate::model::TagScopeTerm {
                comparator: self.comparator,
                key: self.key,
                tag_values: self.tag_values,
                target: self.target,
            }
        }
    }
}
impl TagScopeTerm {
    /// Creates a new builder-style object to manufacture [`TagScopeTerm`](crate::model::TagScopeTerm)
    pub fn builder() -> crate::model::tag_scope_term::Builder {
        crate::model::tag_scope_term::Builder::default()
    }
}

/// <p>The type of object to apply a tag-based condition to. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum TagTarget {
    #[allow(missing_docs)] // documentation missing in model
    S3Object,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for TagTarget {
    fn from(s: &str) -> Self {
        match s {
            "S3_OBJECT" => TagTarget::S3Object,
            other => TagTarget::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for TagTarget {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(TagTarget::from(s))
    }
}
impl TagTarget {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            TagTarget::S3Object => "S3_OBJECT",
            TagTarget::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["S3_OBJECT"]
    }
}
impl AsRef<str> for TagTarget {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies a tag key or tag key and value pair to use in a tag-based condition that determines whether an S3 object is included or excluded from a classification job. Tag keys and values are case sensitive. Also, Amazon Macie doesn't support use of partial values or wildcard characters in tag-based conditions.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagValuePair {
    /// <p>The value for the tag key to use in the condition.</p>
    pub key: std::option::Option<std::string::String>,
    /// <p>The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.</p>
    pub value: std::option::Option<std::string::String>,
}
impl TagValuePair {
    /// <p>The value for the tag key to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&str> {
        self.key.as_deref()
    }
    /// <p>The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.</p>
    pub fn value(&self) -> std::option::Option<&str> {
        self.value.as_deref()
    }
}
impl std::fmt::Debug for TagValuePair {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagValuePair");
        formatter.field("key", &self.key);
        formatter.field("value", &self.value);
        formatter.finish()
    }
}
/// See [`TagValuePair`](crate::model::TagValuePair)
pub mod tag_value_pair {
    /// A builder for [`TagValuePair`](crate::model::TagValuePair)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) key: std::option::Option<std::string::String>,
        pub(crate) value: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The value for the tag key to use in the condition.</p>
        pub fn key(mut self, input: impl Into<std::string::String>) -> Self {
            self.key = Some(input.into());
            self
        }
        /// <p>The value for the tag key to use in the condition.</p>
        pub fn set_key(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.key = input;
            self
        }
        /// <p>The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.</p>
        pub fn value(mut self, input: impl Into<std::string::String>) -> Self {
            self.value = Some(input.into());
            self
        }
        /// <p>The tag value, associated with the specified tag key (key), to use in the condition. To specify only a tag key for a condition, specify the tag key for the key property and set this value to an empty string.</p>
        pub fn set_value(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.value = input;
            self
        }
        /// Consumes the builder and constructs a [`TagValuePair`](crate::model::TagValuePair)
        pub fn build(self) -> crate::model::TagValuePair {
            crate::model::TagValuePair {
                key: self.key,
                value: self.value,
            }
        }
    }
}
impl TagValuePair {
    /// Creates a new builder-style object to manufacture [`TagValuePair`](crate::model::TagValuePair)
    pub fn builder() -> crate::model::tag_value_pair::Builder {
        crate::model::tag_value_pair::Builder::default()
    }
}

/// <p>Specifies a property-based condition that determines whether an S3 object is included or excluded from a classification job.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SimpleScopeTerm {
    /// <p>The operator to use in the condition. Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>OBJECT_EXTENSION - EQ (equals) or NE (not equals)</p></li>
    /// <li><p>OBJECT_KEY - STARTS_WITH</p></li>
    /// <li><p>OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS</p></li>
    /// <li><p>OBJECT_SIZE - Any operator except CONTAINS</p></li>
    /// </ul>
    pub comparator: std::option::Option<crate::model::JobComparator>,
    /// <p>The object property to use in the condition.</p>
    pub key: std::option::Option<crate::model::ScopeFilterKey>,
    /// <p>An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.</p>
    /// <p>Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf</p></li>
    /// <li><p>OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.</p></li>
    /// <li><p>OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z</p></li>
    /// <li><p>OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.</p></li>
    /// </ul>
    /// <p>Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.</p>
    pub values: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl SimpleScopeTerm {
    /// <p>The operator to use in the condition. Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>OBJECT_EXTENSION - EQ (equals) or NE (not equals)</p></li>
    /// <li><p>OBJECT_KEY - STARTS_WITH</p></li>
    /// <li><p>OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS</p></li>
    /// <li><p>OBJECT_SIZE - Any operator except CONTAINS</p></li>
    /// </ul>
    pub fn comparator(&self) -> std::option::Option<&crate::model::JobComparator> {
        self.comparator.as_ref()
    }
    /// <p>The object property to use in the condition.</p>
    pub fn key(&self) -> std::option::Option<&crate::model::ScopeFilterKey> {
        self.key.as_ref()
    }
    /// <p>An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.</p>
    /// <p>Valid values for each supported property (key) are:</p>
    /// <ul>
    /// <li><p>OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf</p></li>
    /// <li><p>OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.</p></li>
    /// <li><p>OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z</p></li>
    /// <li><p>OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.</p></li>
    /// </ul>
    /// <p>Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.</p>
    pub fn values(&self) -> std::option::Option<&[std::string::String]> {
        self.values.as_deref()
    }
}
impl std::fmt::Debug for SimpleScopeTerm {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SimpleScopeTerm");
        formatter.field("comparator", &self.comparator);
        formatter.field("key", &self.key);
        formatter.field("values", &self.values);
        formatter.finish()
    }
}
/// See [`SimpleScopeTerm`](crate::model::SimpleScopeTerm)
pub mod simple_scope_term {
    /// A builder for [`SimpleScopeTerm`](crate::model::SimpleScopeTerm)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) comparator: std::option::Option<crate::model::JobComparator>,
        pub(crate) key: std::option::Option<crate::model::ScopeFilterKey>,
        pub(crate) values: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The operator to use in the condition. Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>OBJECT_EXTENSION - EQ (equals) or NE (not equals)</p></li>
        /// <li><p>OBJECT_KEY - STARTS_WITH</p></li>
        /// <li><p>OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS</p></li>
        /// <li><p>OBJECT_SIZE - Any operator except CONTAINS</p></li>
        /// </ul>
        pub fn comparator(mut self, input: crate::model::JobComparator) -> Self {
            self.comparator = Some(input);
            self
        }
        /// <p>The operator to use in the condition. Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>OBJECT_EXTENSION - EQ (equals) or NE (not equals)</p></li>
        /// <li><p>OBJECT_KEY - STARTS_WITH</p></li>
        /// <li><p>OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS</p></li>
        /// <li><p>OBJECT_SIZE - Any operator except CONTAINS</p></li>
        /// </ul>
        pub fn set_comparator(
            mut self,
            input: std::option::Option<crate::model::JobComparator>,
        ) -> Self {
            self.comparator = input;
            self
        }
        /// <p>The object property to use in the condition.</p>
        pub fn key(mut self, input: crate::model::ScopeFilterKey) -> Self {
            self.key = Some(input);
            self
        }
        /// <p>The object property to use in the condition.</p>
        pub fn set_key(mut self, input: std::option::Option<crate::model::ScopeFilterKey>) -> Self {
            self.key = input;
            self
        }
        /// Appends an item to `values`.
        ///
        /// To override the contents of this collection use [`set_values`](Self::set_values).
        ///
        /// <p>An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.</p>
        /// <p>Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf</p></li>
        /// <li><p>OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.</p></li>
        /// <li><p>OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z</p></li>
        /// <li><p>OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.</p></li>
        /// </ul>
        /// <p>Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.</p>
        pub fn values(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.values.unwrap_or_default();
            v.push(input.into());
            self.values = Some(v);
            self
        }
        /// <p>An array that lists the values to use in the condition. If the value for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can specify multiple values and Amazon Macie uses OR logic to join the values. Otherwise, this array can specify only one value.</p>
        /// <p>Valid values for each supported property (key) are:</p>
        /// <ul>
        /// <li><p>OBJECT_EXTENSION - A string that represents the file name extension of an object. For example: docx or pdf</p></li>
        /// <li><p>OBJECT_KEY - A string that represents the key prefix (folder name or path) of an object. For example: logs or awslogs/eventlogs. This value applies a condition to objects whose keys (names) begin with the specified value.</p></li>
        /// <li><p>OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO 8601 format) when an object was created or last changed, whichever is latest. For example: 2020-09-28T14:31:13Z</p></li>
        /// <li><p>OBJECT_SIZE - An integer that represents the storage size (in bytes) of an object.</p></li>
        /// </ul>
        /// <p>Macie doesn't support use of wildcard characters in these values. Also, string values are case sensitive.</p>
        pub fn set_values(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.values = input;
            self
        }
        /// Consumes the builder and constructs a [`SimpleScopeTerm`](crate::model::SimpleScopeTerm)
        pub fn build(self) -> crate::model::SimpleScopeTerm {
            crate::model::SimpleScopeTerm {
                comparator: self.comparator,
                key: self.key,
                values: self.values,
            }
        }
    }
}
impl SimpleScopeTerm {
    /// Creates a new builder-style object to manufacture [`SimpleScopeTerm`](crate::model::SimpleScopeTerm)
    pub fn builder() -> crate::model::simple_scope_term::Builder {
        crate::model::simple_scope_term::Builder::default()
    }
}

/// <p>The property to use in a condition that determines whether an S3 object is included or excluded from a classification job. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ScopeFilterKey {
    #[allow(missing_docs)] // documentation missing in model
    ObjectExtension,
    #[allow(missing_docs)] // documentation missing in model
    ObjectKey,
    #[allow(missing_docs)] // documentation missing in model
    ObjectLastModifiedDate,
    #[allow(missing_docs)] // documentation missing in model
    ObjectSize,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ScopeFilterKey {
    fn from(s: &str) -> Self {
        match s {
            "OBJECT_EXTENSION" => ScopeFilterKey::ObjectExtension,
            "OBJECT_KEY" => ScopeFilterKey::ObjectKey,
            "OBJECT_LAST_MODIFIED_DATE" => ScopeFilterKey::ObjectLastModifiedDate,
            "OBJECT_SIZE" => ScopeFilterKey::ObjectSize,
            other => ScopeFilterKey::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ScopeFilterKey {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ScopeFilterKey::from(s))
    }
}
impl ScopeFilterKey {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ScopeFilterKey::ObjectExtension => "OBJECT_EXTENSION",
            ScopeFilterKey::ObjectKey => "OBJECT_KEY",
            ScopeFilterKey::ObjectLastModifiedDate => "OBJECT_LAST_MODIFIED_DATE",
            ScopeFilterKey::ObjectSize => "OBJECT_SIZE",
            ScopeFilterKey::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &[
            "OBJECT_EXTENSION",
            "OBJECT_KEY",
            "OBJECT_LAST_MODIFIED_DATE",
            "OBJECT_SIZE",
        ]
    }
}
impl AsRef<str> for ScopeFilterKey {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The selection type that determines which managed data identifiers a classification job uses to analyze data. Valid values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ManagedDataIdentifierSelector {
    #[allow(missing_docs)] // documentation missing in model
    All,
    #[allow(missing_docs)] // documentation missing in model
    Exclude,
    #[allow(missing_docs)] // documentation missing in model
    Include,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ManagedDataIdentifierSelector {
    fn from(s: &str) -> Self {
        match s {
            "ALL" => ManagedDataIdentifierSelector::All,
            "EXCLUDE" => ManagedDataIdentifierSelector::Exclude,
            "INCLUDE" => ManagedDataIdentifierSelector::Include,
            "NONE" => ManagedDataIdentifierSelector::None,
            other => ManagedDataIdentifierSelector::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ManagedDataIdentifierSelector {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ManagedDataIdentifierSelector::from(s))
    }
}
impl ManagedDataIdentifierSelector {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ManagedDataIdentifierSelector::All => "ALL",
            ManagedDataIdentifierSelector::Exclude => "EXCLUDE",
            ManagedDataIdentifierSelector::Include => "INCLUDE",
            ManagedDataIdentifierSelector::None => "NONE",
            ManagedDataIdentifierSelector::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ALL", "EXCLUDE", "INCLUDE", "NONE"]
    }
}
impl AsRef<str> for ManagedDataIdentifierSelector {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes for your account. If an error occurs when Macie attempts to retrieve and process information about the bucket or the bucket's objects, the value for the versioning property is false and the value for most other properties is null. Exceptions are accountId, bucketArn, bucketCreatedAt, bucketName, lastUpdated, and region. To identify the cause of the error, refer to the errorCode and errorMessage values.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketMetadata {
    /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
    /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.</p></li>
    /// </ul>
    pub allows_unencrypted_object_uploads:
        std::option::Option<crate::model::AllowsUnencryptedObjectUploads>,
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    pub bucket_arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
    pub bucket_created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The name of the bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    pub classifiable_object_count: i64,
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub classifiable_size_in_bytes: i64,
    /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
    pub error_code: std::option::Option<crate::model::BucketMetadataErrorCode>,
    /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
    pub error_message: std::option::Option<std::string::String>,
    /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.</p>
    pub job_details: std::option::Option<crate::model::JobDetails>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.</p>
    pub last_updated: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>The total number of objects in the bucket.</p>
    pub object_count: i64,
    /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
    pub object_count_by_encryption_type:
        std::option::Option<crate::model::ObjectCountByEncryptionType>,
    /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.</p>
    pub public_access: std::option::Option<crate::model::BucketPublicAccess>,
    /// <p>The Amazon Web Services Region that hosts the bucket.</p>
    pub region: std::option::Option<std::string::String>,
    /// <p>Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.</p>
    pub replication_details: std::option::Option<crate::model::ReplicationDetails>,
    /// <p>Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.</p>
    pub server_side_encryption: std::option::Option<crate::model::BucketServerSideEncryption>,
    /// <p>Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are:</p>
    /// <ul>
    /// <li><p>EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p></li>
    /// <li><p>INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p></li>
    /// <li><p>NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.</p></li>
    /// </ul>
    pub shared_access: std::option::Option<crate::model::SharedAccess>,
    /// <p>The total storage size, in bytes, of the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
    pub size_in_bytes: i64,
    /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub size_in_bytes_compressed: i64,
    /// <p>An array that specifies the tags (keys and values) that are associated with the bucket.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
    /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub unclassifiable_object_count: std::option::Option<crate::model::ObjectLevelStatistics>,
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub unclassifiable_object_size_in_bytes:
        std::option::Option<crate::model::ObjectLevelStatistics>,
    /// <p>Specifies whether versioning is enabled for the bucket.</p>
    pub versioning: bool,
}
impl BucketMetadata {
    /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
    /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.</p></li>
    /// </ul>
    pub fn allows_unencrypted_object_uploads(
        &self,
    ) -> std::option::Option<&crate::model::AllowsUnencryptedObjectUploads> {
        self.allows_unencrypted_object_uploads.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
    pub fn bucket_arn(&self) -> std::option::Option<&str> {
        self.bucket_arn.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
    pub fn bucket_created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.bucket_created_at.as_ref()
    }
    /// <p>The name of the bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    pub fn classifiable_object_count(&self) -> i64 {
        self.classifiable_object_count
    }
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub fn classifiable_size_in_bytes(&self) -> i64 {
        self.classifiable_size_in_bytes
    }
    /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::BucketMetadataErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
    /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.</p>
    pub fn job_details(&self) -> std::option::Option<&crate::model::JobDetails> {
        self.job_details.as_ref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.</p>
    pub fn last_updated(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.last_updated.as_ref()
    }
    /// <p>The total number of objects in the bucket.</p>
    pub fn object_count(&self) -> i64 {
        self.object_count
    }
    /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
    pub fn object_count_by_encryption_type(
        &self,
    ) -> std::option::Option<&crate::model::ObjectCountByEncryptionType> {
        self.object_count_by_encryption_type.as_ref()
    }
    /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.</p>
    pub fn public_access(&self) -> std::option::Option<&crate::model::BucketPublicAccess> {
        self.public_access.as_ref()
    }
    /// <p>The Amazon Web Services Region that hosts the bucket.</p>
    pub fn region(&self) -> std::option::Option<&str> {
        self.region.as_deref()
    }
    /// <p>Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.</p>
    pub fn replication_details(&self) -> std::option::Option<&crate::model::ReplicationDetails> {
        self.replication_details.as_ref()
    }
    /// <p>Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.</p>
    pub fn server_side_encryption(
        &self,
    ) -> std::option::Option<&crate::model::BucketServerSideEncryption> {
        self.server_side_encryption.as_ref()
    }
    /// <p>Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are:</p>
    /// <ul>
    /// <li><p>EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p></li>
    /// <li><p>INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p></li>
    /// <li><p>NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts.</p></li>
    /// <li><p>UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.</p></li>
    /// </ul>
    pub fn shared_access(&self) -> std::option::Option<&crate::model::SharedAccess> {
        self.shared_access.as_ref()
    }
    /// <p>The total storage size, in bytes, of the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
    pub fn size_in_bytes(&self) -> i64 {
        self.size_in_bytes
    }
    /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
    /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
    pub fn size_in_bytes_compressed(&self) -> i64 {
        self.size_in_bytes_compressed
    }
    /// <p>An array that specifies the tags (keys and values) that are associated with the bucket.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::KeyValuePair]> {
        self.tags.as_deref()
    }
    /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub fn unclassifiable_object_count(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLevelStatistics> {
        self.unclassifiable_object_count.as_ref()
    }
    /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    pub fn unclassifiable_object_size_in_bytes(
        &self,
    ) -> std::option::Option<&crate::model::ObjectLevelStatistics> {
        self.unclassifiable_object_size_in_bytes.as_ref()
    }
    /// <p>Specifies whether versioning is enabled for the bucket.</p>
    pub fn versioning(&self) -> bool {
        self.versioning
    }
}
impl std::fmt::Debug for BucketMetadata {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketMetadata");
        formatter.field("account_id", &self.account_id);
        formatter.field(
            "allows_unencrypted_object_uploads",
            &self.allows_unencrypted_object_uploads,
        );
        formatter.field("bucket_arn", &self.bucket_arn);
        formatter.field("bucket_created_at", &self.bucket_created_at);
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("classifiable_object_count", &self.classifiable_object_count);
        formatter.field(
            "classifiable_size_in_bytes",
            &self.classifiable_size_in_bytes,
        );
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.field("job_details", &self.job_details);
        formatter.field("last_updated", &self.last_updated);
        formatter.field("object_count", &self.object_count);
        formatter.field(
            "object_count_by_encryption_type",
            &self.object_count_by_encryption_type,
        );
        formatter.field("public_access", &self.public_access);
        formatter.field("region", &self.region);
        formatter.field("replication_details", &self.replication_details);
        formatter.field("server_side_encryption", &self.server_side_encryption);
        formatter.field("shared_access", &self.shared_access);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.field("size_in_bytes_compressed", &self.size_in_bytes_compressed);
        formatter.field("tags", &self.tags);
        formatter.field(
            "unclassifiable_object_count",
            &self.unclassifiable_object_count,
        );
        formatter.field(
            "unclassifiable_object_size_in_bytes",
            &self.unclassifiable_object_size_in_bytes,
        );
        formatter.field("versioning", &self.versioning);
        formatter.finish()
    }
}
/// See [`BucketMetadata`](crate::model::BucketMetadata)
pub mod bucket_metadata {
    /// A builder for [`BucketMetadata`](crate::model::BucketMetadata)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) allows_unencrypted_object_uploads:
            std::option::Option<crate::model::AllowsUnencryptedObjectUploads>,
        pub(crate) bucket_arn: std::option::Option<std::string::String>,
        pub(crate) bucket_created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) classifiable_object_count: std::option::Option<i64>,
        pub(crate) classifiable_size_in_bytes: std::option::Option<i64>,
        pub(crate) error_code: std::option::Option<crate::model::BucketMetadataErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
        pub(crate) job_details: std::option::Option<crate::model::JobDetails>,
        pub(crate) last_updated: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) object_count: std::option::Option<i64>,
        pub(crate) object_count_by_encryption_type:
            std::option::Option<crate::model::ObjectCountByEncryptionType>,
        pub(crate) public_access: std::option::Option<crate::model::BucketPublicAccess>,
        pub(crate) region: std::option::Option<std::string::String>,
        pub(crate) replication_details: std::option::Option<crate::model::ReplicationDetails>,
        pub(crate) server_side_encryption:
            std::option::Option<crate::model::BucketServerSideEncryption>,
        pub(crate) shared_access: std::option::Option<crate::model::SharedAccess>,
        pub(crate) size_in_bytes: std::option::Option<i64>,
        pub(crate) size_in_bytes_compressed: std::option::Option<i64>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        pub(crate) unclassifiable_object_count:
            std::option::Option<crate::model::ObjectLevelStatistics>,
        pub(crate) unclassifiable_object_size_in_bytes:
            std::option::Option<crate::model::ObjectLevelStatistics>,
        pub(crate) versioning: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account that owns the bucket.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
        /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.</p></li>
        /// </ul>
        pub fn allows_unencrypted_object_uploads(
            mut self,
            input: crate::model::AllowsUnencryptedObjectUploads,
        ) -> Self {
            self.allows_unencrypted_object_uploads = Some(input);
            self
        }
        /// <p>Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.</p></li>
        /// <li><p>TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.</p></li>
        /// </ul>
        pub fn set_allows_unencrypted_object_uploads(
            mut self,
            input: std::option::Option<crate::model::AllowsUnencryptedObjectUploads>,
        ) -> Self {
            self.allows_unencrypted_object_uploads = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        pub fn bucket_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the bucket.</p>
        pub fn set_bucket_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_arn = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
        pub fn bucket_created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.bucket_created_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the bucket was created.</p>
        pub fn set_bucket_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.bucket_created_at = input;
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        pub fn classifiable_object_count(mut self, input: i64) -> Self {
            self.classifiable_object_count = Some(input);
            self
        }
        /// <p>The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        pub fn set_classifiable_object_count(mut self, input: std::option::Option<i64>) -> Self {
            self.classifiable_object_count = input;
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn classifiable_size_in_bytes(mut self, input: i64) -> Self {
            self.classifiable_size_in_bytes = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
        /// <p>If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn set_classifiable_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.classifiable_size_in_bytes = input;
            self
        }
        /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
        pub fn error_code(mut self, input: crate::model::BucketMetadataErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::BucketMetadataErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.</p>
        pub fn job_details(mut self, input: crate::model::JobDetails) -> Self {
            self.job_details = Some(input);
            self
        }
        /// <p>Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.</p>
        pub fn set_job_details(
            mut self,
            input: std::option::Option<crate::model::JobDetails>,
        ) -> Self {
            self.job_details = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.</p>
        pub fn last_updated(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.last_updated = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.</p>
        pub fn set_last_updated(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.last_updated = input;
            self
        }
        /// <p>The total number of objects in the bucket.</p>
        pub fn object_count(mut self, input: i64) -> Self {
            self.object_count = Some(input);
            self
        }
        /// <p>The total number of objects in the bucket.</p>
        pub fn set_object_count(mut self, input: std::option::Option<i64>) -> Self {
            self.object_count = input;
            self
        }
        /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
        pub fn object_count_by_encryption_type(
            mut self,
            input: crate::model::ObjectCountByEncryptionType,
        ) -> Self {
            self.object_count_by_encryption_type = Some(input);
            self
        }
        /// <p>The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.</p>
        pub fn set_object_count_by_encryption_type(
            mut self,
            input: std::option::Option<crate::model::ObjectCountByEncryptionType>,
        ) -> Self {
            self.object_count_by_encryption_type = input;
            self
        }
        /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.</p>
        pub fn public_access(mut self, input: crate::model::BucketPublicAccess) -> Self {
            self.public_access = Some(input);
            self
        }
        /// <p>Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.</p>
        pub fn set_public_access(
            mut self,
            input: std::option::Option<crate::model::BucketPublicAccess>,
        ) -> Self {
            self.public_access = input;
            self
        }
        /// <p>The Amazon Web Services Region that hosts the bucket.</p>
        pub fn region(mut self, input: impl Into<std::string::String>) -> Self {
            self.region = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services Region that hosts the bucket.</p>
        pub fn set_region(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.region = input;
            self
        }
        /// <p>Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.</p>
        pub fn replication_details(mut self, input: crate::model::ReplicationDetails) -> Self {
            self.replication_details = Some(input);
            self
        }
        /// <p>Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.</p>
        pub fn set_replication_details(
            mut self,
            input: std::option::Option<crate::model::ReplicationDetails>,
        ) -> Self {
            self.replication_details = input;
            self
        }
        /// <p>Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.</p>
        pub fn server_side_encryption(
            mut self,
            input: crate::model::BucketServerSideEncryption,
        ) -> Self {
            self.server_side_encryption = Some(input);
            self
        }
        /// <p>Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.</p>
        pub fn set_server_side_encryption(
            mut self,
            input: std::option::Option<crate::model::BucketServerSideEncryption>,
        ) -> Self {
            self.server_side_encryption = input;
            self
        }
        /// <p>Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are:</p>
        /// <ul>
        /// <li><p>EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p></li>
        /// <li><p>INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p></li>
        /// <li><p>NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.</p></li>
        /// </ul>
        pub fn shared_access(mut self, input: crate::model::SharedAccess) -> Self {
            self.shared_access = Some(input);
            self
        }
        /// <p>Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are:</p>
        /// <ul>
        /// <li><p>EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p></li>
        /// <li><p>INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization.</p></li>
        /// <li><p>NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts.</p></li>
        /// <li><p>UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.</p></li>
        /// </ul>
        pub fn set_shared_access(
            mut self,
            input: std::option::Option<crate::model::SharedAccess>,
        ) -> Self {
            self.shared_access = input;
            self
        }
        /// <p>The total storage size, in bytes, of the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
        pub fn size_in_bytes(mut self, input: i64) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.</p>
        pub fn set_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn size_in_bytes_compressed(mut self, input: i64) -> Self {
            self.size_in_bytes_compressed = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.</p>
        /// <p>If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.</p>
        pub fn set_size_in_bytes_compressed(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes_compressed = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>An array that specifies the tags (keys and values) that are associated with the bucket.</p>
        pub fn tags(mut self, input: crate::model::KeyValuePair) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>An array that specifies the tags (keys and values) that are associated with the bucket.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::KeyValuePair>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn unclassifiable_object_count(
            mut self,
            input: crate::model::ObjectLevelStatistics,
        ) -> Self {
            self.unclassifiable_object_count = Some(input);
            self
        }
        /// <p>The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn set_unclassifiable_object_count(
            mut self,
            input: std::option::Option<crate::model::ObjectLevelStatistics>,
        ) -> Self {
            self.unclassifiable_object_count = input;
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn unclassifiable_object_size_in_bytes(
            mut self,
            input: crate::model::ObjectLevelStatistics,
        ) -> Self {
            self.unclassifiable_object_size_in_bytes = Some(input);
            self
        }
        /// <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
        pub fn set_unclassifiable_object_size_in_bytes(
            mut self,
            input: std::option::Option<crate::model::ObjectLevelStatistics>,
        ) -> Self {
            self.unclassifiable_object_size_in_bytes = input;
            self
        }
        /// <p>Specifies whether versioning is enabled for the bucket.</p>
        pub fn versioning(mut self, input: bool) -> Self {
            self.versioning = Some(input);
            self
        }
        /// <p>Specifies whether versioning is enabled for the bucket.</p>
        pub fn set_versioning(mut self, input: std::option::Option<bool>) -> Self {
            self.versioning = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketMetadata`](crate::model::BucketMetadata)
        pub fn build(self) -> crate::model::BucketMetadata {
            crate::model::BucketMetadata {
                account_id: self.account_id,
                allows_unencrypted_object_uploads: self.allows_unencrypted_object_uploads,
                bucket_arn: self.bucket_arn,
                bucket_created_at: self.bucket_created_at,
                bucket_name: self.bucket_name,
                classifiable_object_count: self.classifiable_object_count.unwrap_or_default(),
                classifiable_size_in_bytes: self.classifiable_size_in_bytes.unwrap_or_default(),
                error_code: self.error_code,
                error_message: self.error_message,
                job_details: self.job_details,
                last_updated: self.last_updated,
                object_count: self.object_count.unwrap_or_default(),
                object_count_by_encryption_type: self.object_count_by_encryption_type,
                public_access: self.public_access,
                region: self.region,
                replication_details: self.replication_details,
                server_side_encryption: self.server_side_encryption,
                shared_access: self.shared_access,
                size_in_bytes: self.size_in_bytes.unwrap_or_default(),
                size_in_bytes_compressed: self.size_in_bytes_compressed.unwrap_or_default(),
                tags: self.tags,
                unclassifiable_object_count: self.unclassifiable_object_count,
                unclassifiable_object_size_in_bytes: self.unclassifiable_object_size_in_bytes,
                versioning: self.versioning.unwrap_or_default(),
            }
        }
    }
}
impl BucketMetadata {
    /// Creates a new builder-style object to manufacture [`BucketMetadata`](crate::model::BucketMetadata)
    pub fn builder() -> crate::model::bucket_metadata::Builder {
        crate::model::bucket_metadata::Builder::default()
    }
}

/// _Note: `SharedAccess::Unknown` has been renamed to `::UnknownValue`._
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum SharedAccess {
    #[allow(missing_docs)] // documentation missing in model
    External,
    #[allow(missing_docs)] // documentation missing in model
    Internal,
    #[allow(missing_docs)] // documentation missing in model
    NotShared,
    /// _Note: `::Unknown` has been renamed to `::UnknownValue`._
    UnknownValue,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for SharedAccess {
    fn from(s: &str) -> Self {
        match s {
            "EXTERNAL" => SharedAccess::External,
            "INTERNAL" => SharedAccess::Internal,
            "NOT_SHARED" => SharedAccess::NotShared,
            "UNKNOWN" => SharedAccess::UnknownValue,
            other => SharedAccess::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for SharedAccess {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(SharedAccess::from(s))
    }
}
impl SharedAccess {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            SharedAccess::External => "EXTERNAL",
            SharedAccess::Internal => "INTERNAL",
            SharedAccess::NotShared => "NOT_SHARED",
            SharedAccess::UnknownValue => "UNKNOWN",
            SharedAccess::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["EXTERNAL", "INTERNAL", "NOT_SHARED", "UNKNOWN"]
    }
}
impl AsRef<str> for SharedAccess {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about the default server-side encryption settings for an S3 bucket. For detailed information about these settings, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html">Setting default server-side encryption behavior for Amazon S3 buckets</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketServerSideEncryption {
    /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.</p>
    pub kms_master_key_id: std::option::Option<std::string::String>,
    /// <p>The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>AES256 - New objects are encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.</p></li>
    /// <li><p>aws:kms - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key. They use SSE-KMS encryption.</p></li>
    /// <li><p>NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.</p></li>
    /// </ul>
    pub r#type: std::option::Option<crate::model::Type>,
}
impl BucketServerSideEncryption {
    /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.</p>
    pub fn kms_master_key_id(&self) -> std::option::Option<&str> {
        self.kms_master_key_id.as_deref()
    }
    /// <p>The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are:</p>
    /// <ul>
    /// <li><p>AES256 - New objects are encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.</p></li>
    /// <li><p>aws:kms - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key. They use SSE-KMS encryption.</p></li>
    /// <li><p>NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.</p></li>
    /// </ul>
    pub fn r#type(&self) -> std::option::Option<&crate::model::Type> {
        self.r#type.as_ref()
    }
}
impl std::fmt::Debug for BucketServerSideEncryption {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketServerSideEncryption");
        formatter.field("kms_master_key_id", &self.kms_master_key_id);
        formatter.field("r#type", &self.r#type);
        formatter.finish()
    }
}
/// See [`BucketServerSideEncryption`](crate::model::BucketServerSideEncryption)
pub mod bucket_server_side_encryption {
    /// A builder for [`BucketServerSideEncryption`](crate::model::BucketServerSideEncryption)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) kms_master_key_id: std::option::Option<std::string::String>,
        pub(crate) r#type: std::option::Option<crate::model::Type>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.</p>
        pub fn kms_master_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_master_key_id = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.</p>
        pub fn set_kms_master_key_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.kms_master_key_id = input;
            self
        }
        /// <p>The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>AES256 - New objects are encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.</p></li>
        /// <li><p>aws:kms - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key. They use SSE-KMS encryption.</p></li>
        /// <li><p>NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.</p></li>
        /// </ul>
        pub fn r#type(mut self, input: crate::model::Type) -> Self {
            self.r#type = Some(input);
            self
        }
        /// <p>The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are:</p>
        /// <ul>
        /// <li><p>AES256 - New objects are encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.</p></li>
        /// <li><p>aws:kms - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key. They use SSE-KMS encryption.</p></li>
        /// <li><p>NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.</p></li>
        /// </ul>
        pub fn set_type(mut self, input: std::option::Option<crate::model::Type>) -> Self {
            self.r#type = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketServerSideEncryption`](crate::model::BucketServerSideEncryption)
        pub fn build(self) -> crate::model::BucketServerSideEncryption {
            crate::model::BucketServerSideEncryption {
                kms_master_key_id: self.kms_master_key_id,
                r#type: self.r#type,
            }
        }
    }
}
impl BucketServerSideEncryption {
    /// Creates a new builder-style object to manufacture [`BucketServerSideEncryption`](crate::model::BucketServerSideEncryption)
    pub fn builder() -> crate::model::bucket_server_side_encryption::Builder {
        crate::model::bucket_server_side_encryption::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum Type {
    #[allow(missing_docs)] // documentation missing in model
    Aes256,
    #[allow(missing_docs)] // documentation missing in model
    None,
    #[allow(missing_docs)] // documentation missing in model
    AwsKms,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for Type {
    fn from(s: &str) -> Self {
        match s {
            "AES256" => Type::Aes256,
            "NONE" => Type::None,
            "aws:kms" => Type::AwsKms,
            other => Type::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for Type {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(Type::from(s))
    }
}
impl Type {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            Type::Aes256 => "AES256",
            Type::None => "NONE",
            Type::AwsKms => "aws:kms",
            Type::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["AES256", "NONE", "aws:kms"]
    }
}
impl AsRef<str> for Type {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Provides information about settings that define whether one or more objects in an S3 bucket are replicated to S3 buckets for other Amazon Web Services accounts and, if so, which accounts.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ReplicationDetails {
    /// <p>Specifies whether the bucket is configured to replicate one or more objects to any destination.</p>
    pub replicated: bool,
    /// <p>Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
    pub replicated_externally: bool,
    /// <p>An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.</p>
    pub replication_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl ReplicationDetails {
    /// <p>Specifies whether the bucket is configured to replicate one or more objects to any destination.</p>
    pub fn replicated(&self) -> bool {
        self.replicated
    }
    /// <p>Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
    pub fn replicated_externally(&self) -> bool {
        self.replicated_externally
    }
    /// <p>An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.</p>
    pub fn replication_accounts(&self) -> std::option::Option<&[std::string::String]> {
        self.replication_accounts.as_deref()
    }
}
impl std::fmt::Debug for ReplicationDetails {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ReplicationDetails");
        formatter.field("replicated", &self.replicated);
        formatter.field("replicated_externally", &self.replicated_externally);
        formatter.field("replication_accounts", &self.replication_accounts);
        formatter.finish()
    }
}
/// See [`ReplicationDetails`](crate::model::ReplicationDetails)
pub mod replication_details {
    /// A builder for [`ReplicationDetails`](crate::model::ReplicationDetails)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) replicated: std::option::Option<bool>,
        pub(crate) replicated_externally: std::option::Option<bool>,
        pub(crate) replication_accounts: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>Specifies whether the bucket is configured to replicate one or more objects to any destination.</p>
        pub fn replicated(mut self, input: bool) -> Self {
            self.replicated = Some(input);
            self
        }
        /// <p>Specifies whether the bucket is configured to replicate one or more objects to any destination.</p>
        pub fn set_replicated(mut self, input: std::option::Option<bool>) -> Self {
            self.replicated = input;
            self
        }
        /// <p>Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
        pub fn replicated_externally(mut self, input: bool) -> Self {
            self.replicated_externally = Some(input);
            self
        }
        /// <p>Specifies whether the bucket is configured to replicate one or more objects to an Amazon Web Services account that isn't part of the same Amazon Macie organization.</p>
        pub fn set_replicated_externally(mut self, input: std::option::Option<bool>) -> Self {
            self.replicated_externally = input;
            self
        }
        /// Appends an item to `replication_accounts`.
        ///
        /// To override the contents of this collection use [`set_replication_accounts`](Self::set_replication_accounts).
        ///
        /// <p>An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.</p>
        pub fn replication_accounts(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.replication_accounts.unwrap_or_default();
            v.push(input.into());
            self.replication_accounts = Some(v);
            self
        }
        /// <p>An array of Amazon Web Services account IDs, one for each Amazon Web Services account that the bucket is configured to replicate one or more objects to.</p>
        pub fn set_replication_accounts(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.replication_accounts = input;
            self
        }
        /// Consumes the builder and constructs a [`ReplicationDetails`](crate::model::ReplicationDetails)
        pub fn build(self) -> crate::model::ReplicationDetails {
            crate::model::ReplicationDetails {
                replicated: self.replicated.unwrap_or_default(),
                replicated_externally: self.replicated_externally.unwrap_or_default(),
                replication_accounts: self.replication_accounts,
            }
        }
    }
}
impl ReplicationDetails {
    /// Creates a new builder-style object to manufacture [`ReplicationDetails`](crate::model::ReplicationDetails)
    pub fn builder() -> crate::model::replication_details::Builder {
        crate::model::replication_details::Builder::default()
    }
}

/// <p>Specifies criteria for sorting the results of a query for information about S3 buckets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketSortCriteria {
    /// <p>The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.</p>
    pub attribute_name: std::option::Option<std::string::String>,
    /// <p>The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub order_by: std::option::Option<crate::model::OrderBy>,
}
impl BucketSortCriteria {
    /// <p>The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.</p>
    pub fn attribute_name(&self) -> std::option::Option<&str> {
        self.attribute_name.as_deref()
    }
    /// <p>The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
    pub fn order_by(&self) -> std::option::Option<&crate::model::OrderBy> {
        self.order_by.as_ref()
    }
}
impl std::fmt::Debug for BucketSortCriteria {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketSortCriteria");
        formatter.field("attribute_name", &self.attribute_name);
        formatter.field("order_by", &self.order_by);
        formatter.finish()
    }
}
/// See [`BucketSortCriteria`](crate::model::BucketSortCriteria)
pub mod bucket_sort_criteria {
    /// A builder for [`BucketSortCriteria`](crate::model::BucketSortCriteria)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) attribute_name: std::option::Option<std::string::String>,
        pub(crate) order_by: std::option::Option<crate::model::OrderBy>,
    }
    impl Builder {
        /// <p>The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.</p>
        pub fn attribute_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.attribute_name = Some(input.into());
            self
        }
        /// <p>The name of the bucket property to sort the results by. This value can be one of the following properties that Amazon Macie defines as bucket metadata: accountId, bucketName, classifiableObjectCount, classifiableSizeInBytes, objectCount, or sizeInBytes.</p>
        pub fn set_attribute_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.attribute_name = input;
            self
        }
        /// <p>The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn order_by(mut self, input: crate::model::OrderBy) -> Self {
            self.order_by = Some(input);
            self
        }
        /// <p>The sort order to apply to the results, based on the value specified by the attributeName property. Valid values are: ASC, sort the results in ascending order; and, DESC, sort the results in descending order.</p>
        pub fn set_order_by(mut self, input: std::option::Option<crate::model::OrderBy>) -> Self {
            self.order_by = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketSortCriteria`](crate::model::BucketSortCriteria)
        pub fn build(self) -> crate::model::BucketSortCriteria {
            crate::model::BucketSortCriteria {
                attribute_name: self.attribute_name,
                order_by: self.order_by,
            }
        }
    }
}
impl BucketSortCriteria {
    /// Creates a new builder-style object to manufacture [`BucketSortCriteria`](crate::model::BucketSortCriteria)
    pub fn builder() -> crate::model::bucket_sort_criteria::Builder {
        crate::model::bucket_sort_criteria::Builder::default()
    }
}

/// <p>Specifies the operator to use in a property-based condition that filters the results of a query for information about S3 buckets.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BucketCriteriaAdditionalProperties {
    /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
    pub eq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The value for the property is greater than the specified value.</p>
    pub gt: i64,
    /// <p>The value for the property is greater than or equal to the specified value.</p>
    pub gte: i64,
    /// <p>The value for the property is less than the specified value.</p>
    pub lt: i64,
    /// <p>The value for the property is less than or equal to the specified value.</p>
    pub lte: i64,
    /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
    pub neq: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The name of the bucket begins with the specified value.</p>
    pub prefix: std::option::Option<std::string::String>,
}
impl BucketCriteriaAdditionalProperties {
    /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
    pub fn eq(&self) -> std::option::Option<&[std::string::String]> {
        self.eq.as_deref()
    }
    /// <p>The value for the property is greater than the specified value.</p>
    pub fn gt(&self) -> i64 {
        self.gt
    }
    /// <p>The value for the property is greater than or equal to the specified value.</p>
    pub fn gte(&self) -> i64 {
        self.gte
    }
    /// <p>The value for the property is less than the specified value.</p>
    pub fn lt(&self) -> i64 {
        self.lt
    }
    /// <p>The value for the property is less than or equal to the specified value.</p>
    pub fn lte(&self) -> i64 {
        self.lte
    }
    /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
    pub fn neq(&self) -> std::option::Option<&[std::string::String]> {
        self.neq.as_deref()
    }
    /// <p>The name of the bucket begins with the specified value.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for BucketCriteriaAdditionalProperties {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BucketCriteriaAdditionalProperties");
        formatter.field("eq", &self.eq);
        formatter.field("gt", &self.gt);
        formatter.field("gte", &self.gte);
        formatter.field("lt", &self.lt);
        formatter.field("lte", &self.lte);
        formatter.field("neq", &self.neq);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`BucketCriteriaAdditionalProperties`](crate::model::BucketCriteriaAdditionalProperties)
pub mod bucket_criteria_additional_properties {
    /// A builder for [`BucketCriteriaAdditionalProperties`](crate::model::BucketCriteriaAdditionalProperties)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) eq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) gt: std::option::Option<i64>,
        pub(crate) gte: std::option::Option<i64>,
        pub(crate) lt: std::option::Option<i64>,
        pub(crate) lte: std::option::Option<i64>,
        pub(crate) neq: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `eq`.
        ///
        /// To override the contents of this collection use [`set_eq`](Self::set_eq).
        ///
        /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.eq.unwrap_or_default();
            v.push(input.into());
            self.eq = Some(v);
            self
        }
        /// <p>The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
        pub fn set_eq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.eq = input;
            self
        }
        /// <p>The value for the property is greater than the specified value.</p>
        pub fn gt(mut self, input: i64) -> Self {
            self.gt = Some(input);
            self
        }
        /// <p>The value for the property is greater than the specified value.</p>
        pub fn set_gt(mut self, input: std::option::Option<i64>) -> Self {
            self.gt = input;
            self
        }
        /// <p>The value for the property is greater than or equal to the specified value.</p>
        pub fn gte(mut self, input: i64) -> Self {
            self.gte = Some(input);
            self
        }
        /// <p>The value for the property is greater than or equal to the specified value.</p>
        pub fn set_gte(mut self, input: std::option::Option<i64>) -> Self {
            self.gte = input;
            self
        }
        /// <p>The value for the property is less than the specified value.</p>
        pub fn lt(mut self, input: i64) -> Self {
            self.lt = Some(input);
            self
        }
        /// <p>The value for the property is less than the specified value.</p>
        pub fn set_lt(mut self, input: std::option::Option<i64>) -> Self {
            self.lt = input;
            self
        }
        /// <p>The value for the property is less than or equal to the specified value.</p>
        pub fn lte(mut self, input: i64) -> Self {
            self.lte = Some(input);
            self
        }
        /// <p>The value for the property is less than or equal to the specified value.</p>
        pub fn set_lte(mut self, input: std::option::Option<i64>) -> Self {
            self.lte = input;
            self
        }
        /// Appends an item to `neq`.
        ///
        /// To override the contents of this collection use [`set_neq`](Self::set_neq).
        ///
        /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
        pub fn neq(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.neq.unwrap_or_default();
            v.push(input.into());
            self.neq = Some(v);
            self
        }
        /// <p>The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.</p>
        pub fn set_neq(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.neq = input;
            self
        }
        /// <p>The name of the bucket begins with the specified value.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The name of the bucket begins with the specified value.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`BucketCriteriaAdditionalProperties`](crate::model::BucketCriteriaAdditionalProperties)
        pub fn build(self) -> crate::model::BucketCriteriaAdditionalProperties {
            crate::model::BucketCriteriaAdditionalProperties {
                eq: self.eq,
                gt: self.gt.unwrap_or_default(),
                gte: self.gte.unwrap_or_default(),
                lt: self.lt.unwrap_or_default(),
                lte: self.lte.unwrap_or_default(),
                neq: self.neq,
                prefix: self.prefix,
            }
        }
    }
}
impl BucketCriteriaAdditionalProperties {
    /// Creates a new builder-style object to manufacture [`BucketCriteriaAdditionalProperties`](crate::model::BucketCriteriaAdditionalProperties)
    pub fn builder() -> crate::model::bucket_criteria_additional_properties::Builder {
        crate::model::bucket_criteria_additional_properties::Builder::default()
    }
}

/// <p>Provides information about an account-related request that hasn't been processed.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UnprocessedAccount {
    /// <p>The Amazon Web Services account ID for the account that the request applies to.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The source of the issue or delay in processing the request.</p>
    pub error_code: std::option::Option<crate::model::ErrorCode>,
    /// <p>The reason why the request hasn't been processed.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl UnprocessedAccount {
    /// <p>The Amazon Web Services account ID for the account that the request applies to.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The source of the issue or delay in processing the request.</p>
    pub fn error_code(&self) -> std::option::Option<&crate::model::ErrorCode> {
        self.error_code.as_ref()
    }
    /// <p>The reason why the request hasn't been processed.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for UnprocessedAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UnprocessedAccount");
        formatter.field("account_id", &self.account_id);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`UnprocessedAccount`](crate::model::UnprocessedAccount)
pub mod unprocessed_account {
    /// A builder for [`UnprocessedAccount`](crate::model::UnprocessedAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) error_code: std::option::Option<crate::model::ErrorCode>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account that the request applies to.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that the request applies to.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The source of the issue or delay in processing the request.</p>
        pub fn error_code(mut self, input: crate::model::ErrorCode) -> Self {
            self.error_code = Some(input);
            self
        }
        /// <p>The source of the issue or delay in processing the request.</p>
        pub fn set_error_code(
            mut self,
            input: std::option::Option<crate::model::ErrorCode>,
        ) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The reason why the request hasn't been processed.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The reason why the request hasn't been processed.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`UnprocessedAccount`](crate::model::UnprocessedAccount)
        pub fn build(self) -> crate::model::UnprocessedAccount {
            crate::model::UnprocessedAccount {
                account_id: self.account_id,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl UnprocessedAccount {
    /// Creates a new builder-style object to manufacture [`UnprocessedAccount`](crate::model::UnprocessedAccount)
    pub fn builder() -> crate::model::unprocessed_account::Builder {
        crate::model::unprocessed_account::Builder::default()
    }
}

/// <p>The source of an issue or delay. Possible values are:</p>
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum ErrorCode {
    #[allow(missing_docs)] // documentation missing in model
    ClientError,
    #[allow(missing_docs)] // documentation missing in model
    InternalError,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for ErrorCode {
    fn from(s: &str) -> Self {
        match s {
            "ClientError" => ErrorCode::ClientError,
            "InternalError" => ErrorCode::InternalError,
            other => ErrorCode::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for ErrorCode {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(ErrorCode::from(s))
    }
}
impl ErrorCode {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ErrorCode::ClientError => "ClientError",
            ErrorCode::InternalError => "InternalError",
            ErrorCode::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["ClientError", "InternalError"]
    }
}
impl AsRef<str> for ErrorCode {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>Specifies the details of an account to associate with an Amazon Macie administrator account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccountDetail {
    /// <p>The Amazon Web Services account ID for the account.</p>
    pub account_id: std::option::Option<std::string::String>,
    /// <p>The email address for the account.</p>
    pub email: std::option::Option<std::string::String>,
}
impl AccountDetail {
    /// <p>The Amazon Web Services account ID for the account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
    /// <p>The email address for the account.</p>
    pub fn email(&self) -> std::option::Option<&str> {
        self.email.as_deref()
    }
}
impl std::fmt::Debug for AccountDetail {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccountDetail");
        formatter.field("account_id", &self.account_id);
        formatter.field("email", &self.email);
        formatter.finish()
    }
}
/// See [`AccountDetail`](crate::model::AccountDetail)
pub mod account_detail {
    /// A builder for [`AccountDetail`](crate::model::AccountDetail)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
        pub(crate) email: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// <p>The email address for the account.</p>
        pub fn email(mut self, input: impl Into<std::string::String>) -> Self {
            self.email = Some(input.into());
            self
        }
        /// <p>The email address for the account.</p>
        pub fn set_email(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.email = input;
            self
        }
        /// Consumes the builder and constructs a [`AccountDetail`](crate::model::AccountDetail)
        pub fn build(self) -> crate::model::AccountDetail {
            crate::model::AccountDetail {
                account_id: self.account_id,
                email: self.email,
            }
        }
    }
}
impl AccountDetail {
    /// Creates a new builder-style object to manufacture [`AccountDetail`](crate::model::AccountDetail)
    pub fn builder() -> crate::model::account_detail::Builder {
        crate::model::account_detail::Builder::default()
    }
}

/// <p>Provides information about a custom data identifier.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetCustomDataIdentifierSummary {
    /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    pub arn: std::option::Option<std::string::String>,
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
    pub created_at: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.</p>
    pub deleted: bool,
    /// <p>The custom description of the custom data identifier.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the custom data identifier.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>The custom name of the custom data identifier.</p>
    pub name: std::option::Option<std::string::String>,
}
impl BatchGetCustomDataIdentifierSummary {
    /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    pub fn arn(&self) -> std::option::Option<&str> {
        self.arn.as_deref()
    }
    /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.created_at.as_ref()
    }
    /// <p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.</p>
    pub fn deleted(&self) -> bool {
        self.deleted
    }
    /// <p>The custom description of the custom data identifier.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The unique identifier for the custom data identifier.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>The custom name of the custom data identifier.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
}
impl std::fmt::Debug for BatchGetCustomDataIdentifierSummary {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetCustomDataIdentifierSummary");
        formatter.field("arn", &self.arn);
        formatter.field("created_at", &self.created_at);
        formatter.field("deleted", &self.deleted);
        formatter.field("description", &self.description);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.finish()
    }
}
/// See [`BatchGetCustomDataIdentifierSummary`](crate::model::BatchGetCustomDataIdentifierSummary)
pub mod batch_get_custom_data_identifier_summary {
    /// A builder for [`BatchGetCustomDataIdentifierSummary`](crate::model::BatchGetCustomDataIdentifierSummary)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) arn: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) deleted: std::option::Option<bool>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
        pub fn arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
        pub fn set_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.arn = input;
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
        pub fn created_at(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.</p>
        pub fn deleted(mut self, input: bool) -> Self {
            self.deleted = Some(input);
            self
        }
        /// <p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.</p>
        pub fn set_deleted(mut self, input: std::option::Option<bool>) -> Self {
            self.deleted = input;
            self
        }
        /// <p>The custom description of the custom data identifier.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>The custom description of the custom data identifier.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The unique identifier for the custom data identifier.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the custom data identifier.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>The custom name of the custom data identifier.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>The custom name of the custom data identifier.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetCustomDataIdentifierSummary`](crate::model::BatchGetCustomDataIdentifierSummary)
        pub fn build(self) -> crate::model::BatchGetCustomDataIdentifierSummary {
            crate::model::BatchGetCustomDataIdentifierSummary {
                arn: self.arn,
                created_at: self.created_at,
                deleted: self.deleted.unwrap_or_default(),
                description: self.description,
                id: self.id,
                name: self.name,
            }
        }
    }
}
impl BatchGetCustomDataIdentifierSummary {
    /// Creates a new builder-style object to manufacture [`BatchGetCustomDataIdentifierSummary`](crate::model::BatchGetCustomDataIdentifierSummary)
    pub fn builder() -> crate::model::batch_get_custom_data_identifier_summary::Builder {
        crate::model::batch_get_custom_data_identifier_summary::Builder::default()
    }
}
