// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    pub(crate) client: aws_smithy_client::Client<C, M, R>,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Macie 2
///
/// Client for invoking operations on Amazon Macie 2. Each operation on Amazon Macie 2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_macie2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_macie2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_macie2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = crate::middleware::DefaultMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the [`AcceptInvitation`](crate::client::fluent_builders::AcceptInvitation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`administrator_account_id(impl Into<String>)`](crate::client::fluent_builders::AcceptInvitation::administrator_account_id) / [`set_administrator_account_id(Option<String>)`](crate::client::fluent_builders::AcceptInvitation::set_administrator_account_id): <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
    ///   - [`invitation_id(impl Into<String>)`](crate::client::fluent_builders::AcceptInvitation::invitation_id) / [`set_invitation_id(Option<String>)`](crate::client::fluent_builders::AcceptInvitation::set_invitation_id): <p>The unique identifier for the invitation to accept.</p>
    ///   - [`master_account(impl Into<String>)`](crate::client::fluent_builders::AcceptInvitation::master_account) / [`set_master_account(Option<String>)`](crate::client::fluent_builders::AcceptInvitation::set_master_account): <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
    /// - On success, responds with [`AcceptInvitationOutput`](crate::output::AcceptInvitationOutput)

    /// - On failure, responds with [`SdkError<AcceptInvitationError>`](crate::error::AcceptInvitationError)
    pub fn accept_invitation(&self) -> fluent_builders::AcceptInvitation<C, M, R> {
        fluent_builders::AcceptInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`BatchGetCustomDataIdentifiers`](crate::client::fluent_builders::BatchGetCustomDataIdentifiers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ids(Vec<String>)`](crate::client::fluent_builders::BatchGetCustomDataIdentifiers::ids) / [`set_ids(Option<Vec<String>>)`](crate::client::fluent_builders::BatchGetCustomDataIdentifiers::set_ids): <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
    /// - On success, responds with [`BatchGetCustomDataIdentifiersOutput`](crate::output::BatchGetCustomDataIdentifiersOutput) with field(s):
    ///   - [`custom_data_identifiers(Option<Vec<BatchGetCustomDataIdentifierSummary>>)`](crate::output::BatchGetCustomDataIdentifiersOutput::custom_data_identifiers): <p>An array of objects, one for each custom data identifier that meets the criteria specified in the request.</p>
    ///   - [`not_found_identifier_ids(Option<Vec<String>>)`](crate::output::BatchGetCustomDataIdentifiersOutput::not_found_identifier_ids): <p>An array of custom data identifier IDs, one for each custom data identifier that was specified in the request but doesn't correlate to an existing custom data identifier.</p>
    /// - On failure, responds with [`SdkError<BatchGetCustomDataIdentifiersError>`](crate::error::BatchGetCustomDataIdentifiersError)
    pub fn batch_get_custom_data_identifiers(
        &self,
    ) -> fluent_builders::BatchGetCustomDataIdentifiers<C, M, R> {
        fluent_builders::BatchGetCustomDataIdentifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateClassificationJob`](crate::client::fluent_builders::CreateClassificationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateClassificationJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateClassificationJob::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    ///   - [`custom_data_identifier_ids(Vec<String>)`](crate::client::fluent_builders::CreateClassificationJob::custom_data_identifier_ids) / [`set_custom_data_identifier_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateClassificationJob::set_custom_data_identifier_ids): <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateClassificationJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateClassificationJob::set_description): <p>A custom description of the job. The description can contain as many as 200 characters.</p>
    ///   - [`initial_run(bool)`](crate::client::fluent_builders::CreateClassificationJob::initial_run) / [`set_initial_run(bool)`](crate::client::fluent_builders::CreateClassificationJob::set_initial_run): <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p> <p>If you configure the job to run only once, don't specify a value for this property.</p>
    ///   - [`job_type(JobType)`](crate::client::fluent_builders::CreateClassificationJob::job_type) / [`set_job_type(Option<JobType>)`](crate::client::fluent_builders::CreateClassificationJob::set_job_type): <p>The schedule for running the job. Valid values are:</p>  <ul>  <li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li>   <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li> </ul>
    ///   - [`managed_data_identifier_ids(Vec<String>)`](crate::client::fluent_builders::CreateClassificationJob::managed_data_identifier_ids) / [`set_managed_data_identifier_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateClassificationJob::set_managed_data_identifier_ids): <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p> <p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
    ///   - [`managed_data_identifier_selector(ManagedDataIdentifierSelector)`](crate::client::fluent_builders::CreateClassificationJob::managed_data_identifier_selector) / [`set_managed_data_identifier_selector(Option<ManagedDataIdentifierSelector>)`](crate::client::fluent_builders::CreateClassificationJob::set_managed_data_identifier_selector): <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p>  <ul>  <li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li>   <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>   <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>   <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li> </ul>  <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateClassificationJob::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateClassificationJob::set_name): <p>A custom name for the job. The name can contain as many as 500 characters.</p>
    ///   - [`s3_job_definition(S3JobDefinition)`](crate::client::fluent_builders::CreateClassificationJob::s3_job_definition) / [`set_s3_job_definition(Option<S3JobDefinition>)`](crate::client::fluent_builders::CreateClassificationJob::set_s3_job_definition): <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
    ///   - [`sampling_percentage(i32)`](crate::client::fluent_builders::CreateClassificationJob::sampling_percentage) / [`set_sampling_percentage(i32)`](crate::client::fluent_builders::CreateClassificationJob::set_sampling_percentage): <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
    ///   - [`schedule_frequency(JobScheduleFrequency)`](crate::client::fluent_builders::CreateClassificationJob::schedule_frequency) / [`set_schedule_frequency(Option<JobScheduleFrequency>)`](crate::client::fluent_builders::CreateClassificationJob::set_schedule_frequency): <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateClassificationJob::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateClassificationJob::set_tags): <p>A map of key-value pairs that specifies the tags to associate with the job.</p>  <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`CreateClassificationJobOutput`](crate::output::CreateClassificationJobOutput) with field(s):
    ///   - [`job_arn(Option<String>)`](crate::output::CreateClassificationJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the job.</p>
    ///   - [`job_id(Option<String>)`](crate::output::CreateClassificationJobOutput::job_id): <p>The unique identifier for the job.</p>
    /// - On failure, responds with [`SdkError<CreateClassificationJobError>`](crate::error::CreateClassificationJobError)
    pub fn create_classification_job(&self) -> fluent_builders::CreateClassificationJob<C, M, R> {
        fluent_builders::CreateClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateCustomDataIdentifier`](crate::client::fluent_builders::CreateCustomDataIdentifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_description): <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p>  <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    ///   - [`ignore_words(Vec<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::ignore_words) / [`set_ignore_words(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_ignore_words): <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
    ///   - [`keywords(Vec<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::keywords) / [`set_keywords(Option<Vec<String>>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_keywords): <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
    ///   - [`maximum_match_distance(i32)`](crate::client::fluent_builders::CreateCustomDataIdentifier::maximum_match_distance) / [`set_maximum_match_distance(i32)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_maximum_match_distance): <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_name): <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p>  <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    ///   - [`regex(impl Into<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::regex) / [`set_regex(Option<String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_regex): <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
    ///   - [`severity_levels(Vec<SeverityLevel>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::severity_levels) / [`set_severity_levels(Option<Vec<SeverityLevel>>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_severity_levels): <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p>  <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateCustomDataIdentifier::set_tags): <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p>  <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`CreateCustomDataIdentifierOutput`](crate::output::CreateCustomDataIdentifierOutput) with field(s):
    ///   - [`custom_data_identifier_id(Option<String>)`](crate::output::CreateCustomDataIdentifierOutput::custom_data_identifier_id): <p>The unique identifier for the custom data identifier that was created.</p>
    /// - On failure, responds with [`SdkError<CreateCustomDataIdentifierError>`](crate::error::CreateCustomDataIdentifierError)
    pub fn create_custom_data_identifier(
        &self,
    ) -> fluent_builders::CreateCustomDataIdentifier<C, M, R> {
        fluent_builders::CreateCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateFindingsFilter`](crate::client::fluent_builders::CreateFindingsFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(FindingsFilterAction)`](crate::client::fluent_builders::CreateFindingsFilter::action) / [`set_action(Option<FindingsFilterAction>)`](crate::client::fluent_builders::CreateFindingsFilter::set_action): <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateFindingsFilter::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateFindingsFilter::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateFindingsFilter::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateFindingsFilter::set_description): <p>A custom description of the filter. The description can contain as many as 512 characters.</p>  <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    ///   - [`finding_criteria(FindingCriteria)`](crate::client::fluent_builders::CreateFindingsFilter::finding_criteria) / [`set_finding_criteria(Option<FindingCriteria>)`](crate::client::fluent_builders::CreateFindingsFilter::set_finding_criteria): <p>The criteria to use to filter findings.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::CreateFindingsFilter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::CreateFindingsFilter::set_name): <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p>  <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    ///   - [`position(i32)`](crate::client::fluent_builders::CreateFindingsFilter::position) / [`set_position(i32)`](crate::client::fluent_builders::CreateFindingsFilter::set_position): <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateFindingsFilter::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateFindingsFilter::set_tags): <p>A map of key-value pairs that specifies the tags to associate with the filter.</p>  <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`CreateFindingsFilterOutput`](crate::output::CreateFindingsFilterOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateFindingsFilterOutput::arn): <p>The Amazon Resource Name (ARN) of the filter that was created.</p>
    ///   - [`id(Option<String>)`](crate::output::CreateFindingsFilterOutput::id): <p>The unique identifier for the filter that was created.</p>
    /// - On failure, responds with [`SdkError<CreateFindingsFilterError>`](crate::error::CreateFindingsFilterError)
    pub fn create_findings_filter(&self) -> fluent_builders::CreateFindingsFilter<C, M, R> {
        fluent_builders::CreateFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateInvitations`](crate::client::fluent_builders::CreateInvitations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::CreateInvitations::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::CreateInvitations::set_account_ids): <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
    ///   - [`disable_email_notification(bool)`](crate::client::fluent_builders::CreateInvitations::disable_email_notification) / [`set_disable_email_notification(bool)`](crate::client::fluent_builders::CreateInvitations::set_disable_email_notification): <p>Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends the invitation (as an email message) to the email address that you specified for the recipient's account when you associated the account with your account. The default value is false.</p>
    ///   - [`message(impl Into<String>)`](crate::client::fluent_builders::CreateInvitations::message) / [`set_message(Option<String>)`](crate::client::fluent_builders::CreateInvitations::set_message): <p>Custom text to include in the email message that contains the invitation. The text can contain as many as 80 alphanumeric characters.</p>
    /// - On success, responds with [`CreateInvitationsOutput`](crate::output::CreateInvitationsOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<UnprocessedAccount>>)`](crate::output::CreateInvitationsOutput::unprocessed_accounts): <p>An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the account and explains why the invitation hasn't been processed for the account.</p>
    /// - On failure, responds with [`SdkError<CreateInvitationsError>`](crate::error::CreateInvitationsError)
    pub fn create_invitations(&self) -> fluent_builders::CreateInvitations<C, M, R> {
        fluent_builders::CreateInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMember`](crate::client::fluent_builders::CreateMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account(AccountDetail)`](crate::client::fluent_builders::CreateMember::account) / [`set_account(Option<AccountDetail>)`](crate::client::fluent_builders::CreateMember::set_account): <p>The details of the account to associate with the administrator account.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::CreateMember::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateMember::set_tags): <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p>  <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`CreateMemberOutput`](crate::output::CreateMemberOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::CreateMemberOutput::arn): <p>The Amazon Resource Name (ARN) of the account that was associated with the administrator account.</p>
    /// - On failure, responds with [`SdkError<CreateMemberError>`](crate::error::CreateMemberError)
    pub fn create_member(&self) -> fluent_builders::CreateMember<C, M, R> {
        fluent_builders::CreateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateSampleFindings`](crate::client::fluent_builders::CreateSampleFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_types(Vec<FindingType>)`](crate::client::fluent_builders::CreateSampleFindings::finding_types) / [`set_finding_types(Option<Vec<FindingType>>)`](crate::client::fluent_builders::CreateSampleFindings::set_finding_types): <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
    /// - On success, responds with [`CreateSampleFindingsOutput`](crate::output::CreateSampleFindingsOutput)

    /// - On failure, responds with [`SdkError<CreateSampleFindingsError>`](crate::error::CreateSampleFindingsError)
    pub fn create_sample_findings(&self) -> fluent_builders::CreateSampleFindings<C, M, R> {
        fluent_builders::CreateSampleFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeclineInvitations`](crate::client::fluent_builders::DeclineInvitations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DeclineInvitations::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeclineInvitations::set_account_ids): <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
    /// - On success, responds with [`DeclineInvitationsOutput`](crate::output::DeclineInvitationsOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<UnprocessedAccount>>)`](crate::output::DeclineInvitationsOutput::unprocessed_accounts): <p>An array of objects, one for each account whose invitation hasn't been declined. Each object identifies the account and explains why the request hasn't been processed for that account.</p>
    /// - On failure, responds with [`SdkError<DeclineInvitationsError>`](crate::error::DeclineInvitationsError)
    pub fn decline_invitations(&self) -> fluent_builders::DeclineInvitations<C, M, R> {
        fluent_builders::DeclineInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteCustomDataIdentifier`](crate::client::fluent_builders::DeleteCustomDataIdentifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteCustomDataIdentifier::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteCustomDataIdentifier::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`DeleteCustomDataIdentifierOutput`](crate::output::DeleteCustomDataIdentifierOutput)

    /// - On failure, responds with [`SdkError<DeleteCustomDataIdentifierError>`](crate::error::DeleteCustomDataIdentifierError)
    pub fn delete_custom_data_identifier(
        &self,
    ) -> fluent_builders::DeleteCustomDataIdentifier<C, M, R> {
        fluent_builders::DeleteCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteFindingsFilter`](crate::client::fluent_builders::DeleteFindingsFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteFindingsFilter::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteFindingsFilter::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`DeleteFindingsFilterOutput`](crate::output::DeleteFindingsFilterOutput)

    /// - On failure, responds with [`SdkError<DeleteFindingsFilterError>`](crate::error::DeleteFindingsFilterError)
    pub fn delete_findings_filter(&self) -> fluent_builders::DeleteFindingsFilter<C, M, R> {
        fluent_builders::DeleteFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteInvitations`](crate::client::fluent_builders::DeleteInvitations) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_ids(Vec<String>)`](crate::client::fluent_builders::DeleteInvitations::account_ids) / [`set_account_ids(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteInvitations::set_account_ids): <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
    /// - On success, responds with [`DeleteInvitationsOutput`](crate::output::DeleteInvitationsOutput) with field(s):
    ///   - [`unprocessed_accounts(Option<Vec<UnprocessedAccount>>)`](crate::output::DeleteInvitationsOutput::unprocessed_accounts): <p>An array of objects, one for each account whose invitation hasn't been deleted. Each object identifies the account and explains why the request hasn't been processed for that account.</p>
    /// - On failure, responds with [`SdkError<DeleteInvitationsError>`](crate::error::DeleteInvitationsError)
    pub fn delete_invitations(&self) -> fluent_builders::DeleteInvitations<C, M, R> {
        fluent_builders::DeleteInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMember`](crate::client::fluent_builders::DeleteMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DeleteMember::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DeleteMember::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`DeleteMemberOutput`](crate::output::DeleteMemberOutput)

    /// - On failure, responds with [`SdkError<DeleteMemberError>`](crate::error::DeleteMemberError)
    pub fn delete_member(&self) -> fluent_builders::DeleteMember<C, M, R> {
        fluent_builders::DeleteMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBuckets`](crate::client::fluent_builders::DescribeBuckets) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBuckets::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`criteria(HashMap<String, BucketCriteriaAdditionalProperties>)`](crate::client::fluent_builders::DescribeBuckets::criteria) / [`set_criteria(Option<HashMap<String, BucketCriteriaAdditionalProperties>>)`](crate::client::fluent_builders::DescribeBuckets::set_criteria): <p>The criteria to use to filter the query results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::DescribeBuckets::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::DescribeBuckets::set_max_results): <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBuckets::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBuckets::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    ///   - [`sort_criteria(BucketSortCriteria)`](crate::client::fluent_builders::DescribeBuckets::sort_criteria) / [`set_sort_criteria(Option<BucketSortCriteria>)`](crate::client::fluent_builders::DescribeBuckets::set_sort_criteria): <p>The criteria to use to sort the query results.</p>
    /// - On success, responds with [`DescribeBucketsOutput`](crate::output::DescribeBucketsOutput) with field(s):
    ///   - [`buckets(Option<Vec<BucketMetadata>>)`](crate::output::DescribeBucketsOutput::buckets): <p>An array of objects, one for each bucket that meets the filter criteria specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBucketsOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<DescribeBucketsError>`](crate::error::DescribeBucketsError)
    pub fn describe_buckets(&self) -> fluent_builders::DescribeBuckets<C, M, R> {
        fluent_builders::DescribeBuckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeClassificationJob`](crate::client::fluent_builders::DescribeClassificationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::DescribeClassificationJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::DescribeClassificationJob::set_job_id): <p>The unique identifier for the classification job.</p>
    /// - On success, responds with [`DescribeClassificationJobOutput`](crate::output::DescribeClassificationJobOutput) with field(s):
    ///   - [`client_token(Option<String>)`](crate::output::DescribeClassificationJobOutput::client_token): <p>The token that was provided to ensure the idempotency of the request to create the job.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::DescribeClassificationJobOutput::created_at): <p>The date and time, in UTC and extended ISO 8601 format, when the job was created.</p>
    ///   - [`custom_data_identifier_ids(Option<Vec<String>>)`](crate::output::DescribeClassificationJobOutput::custom_data_identifier_ids): <p>An array of unique identifiers, one for each custom data identifier that the job uses to analyze data. This value is null if the job uses only managed data identifiers to analyze data.</p>
    ///   - [`description(Option<String>)`](crate::output::DescribeClassificationJobOutput::description): <p>The custom description of the job.</p>
    ///   - [`initial_run(bool)`](crate::output::DescribeClassificationJobOutput::initial_run): <p>For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects immediately after the job was created (true). If you configured the job to analyze only those objects that were created or changed after the job was created and before the job's first scheduled run, this value is false. This value is also false for a one-time job.</p>
    ///   - [`job_arn(Option<String>)`](crate::output::DescribeClassificationJobOutput::job_arn): <p>The Amazon Resource Name (ARN) of the job.</p>
    ///   - [`job_id(Option<String>)`](crate::output::DescribeClassificationJobOutput::job_id): <p>The unique identifier for the job.</p>
    ///   - [`job_status(Option<JobStatus>)`](crate::output::DescribeClassificationJobOutput::job_status): <p>The current status of the job. Possible values are:</p>  <ul>  <li><p>CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.</p></li>   <li><p>COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.</p></li>   <li><p>IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.</p></li>   <li><p>PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.</p></li>   <li><p>RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.</p></li>   <li><p>USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li> </ul>
    ///   - [`job_type(Option<JobType>)`](crate::output::DescribeClassificationJobOutput::job_type): <p>The schedule for running the job. Possible values are:</p>  <ul>  <li><p>ONE_TIME - The job runs only once.</p></li>   <li><p>SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.</p></li> </ul>
    ///   - [`last_run_error_status(Option<LastRunErrorStatus>)`](crate::output::DescribeClassificationJobOutput::last_run_error_status): <p>Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.</p>
    ///   - [`last_run_time(Option<DateTime>)`](crate::output::DescribeClassificationJobOutput::last_run_time): <p>The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started.</p>
    ///   - [`managed_data_identifier_ids(Option<Vec<String>>)`](crate::output::DescribeClassificationJobOutput::managed_data_identifier_ids): <p>An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type specified for the job (managedDataIdentifierSelector). This value is null if the job's managed data identifier selection type is ALL or the job uses only custom data identifiers (customDataIdentifierIds) to analyze data.</p>
    ///   - [`managed_data_identifier_selector(Option<ManagedDataIdentifierSelector>)`](crate::output::DescribeClassificationJobOutput::managed_data_identifier_selector): <p>The selection type that determines which managed data identifiers the job uses to analyze data. Possible values are:</p>  <ul>  <li><p>ALL - Use all the managed data identifiers that Amazon Macie provides.</p></li>   <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>   <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>   <li><p>NONE - Don't use any managed data identifiers.</p></li> </ul>  <p>If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
    ///   - [`name(Option<String>)`](crate::output::DescribeClassificationJobOutput::name): <p>The custom name of the job.</p>
    ///   - [`s3_job_definition(Option<S3JobDefinition>)`](crate::output::DescribeClassificationJobOutput::s3_job_definition): <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
    ///   - [`sampling_percentage(i32)`](crate::output::DescribeClassificationJobOutput::sampling_percentage): <p>The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.</p>
    ///   - [`schedule_frequency(Option<JobScheduleFrequency>)`](crate::output::DescribeClassificationJobOutput::schedule_frequency): <p>The recurrence pattern for running the job. This value is null if the job is configured to run only once.</p>
    ///   - [`statistics(Option<Statistics>)`](crate::output::DescribeClassificationJobOutput::statistics): <p>The number of times that the job has run and processing statistics for the job's current run.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::DescribeClassificationJobOutput::tags): <p>A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.</p>
    ///   - [`user_paused_details(Option<UserPausedDetails>)`](crate::output::DescribeClassificationJobOutput::user_paused_details): <p>If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.</p>
    /// - On failure, responds with [`SdkError<DescribeClassificationJobError>`](crate::error::DescribeClassificationJobError)
    pub fn describe_classification_job(
        &self,
    ) -> fluent_builders::DescribeClassificationJob<C, M, R> {
        fluent_builders::DescribeClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DescribeOrganizationConfiguration::send) it.

    /// - On success, responds with [`DescribeOrganizationConfigurationOutput`](crate::output::DescribeOrganizationConfigurationOutput) with field(s):
    ///   - [`auto_enable(bool)`](crate::output::DescribeOrganizationConfigurationOutput::auto_enable): <p>Specifies whether Amazon Macie is enabled automatically for accounts that are added to the organization.</p>
    ///   - [`max_account_limit_reached(bool)`](crate::output::DescribeOrganizationConfigurationOutput::max_account_limit_reached): <p>Specifies whether the maximum number of Amazon Macie member accounts are part of the organization.</p>
    /// - On failure, responds with [`SdkError<DescribeOrganizationConfigurationError>`](crate::error::DescribeOrganizationConfigurationError)
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration<C, M, R> {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableMacie`](crate::client::fluent_builders::DisableMacie) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisableMacie::send) it.

    /// - On success, responds with [`DisableMacieOutput`](crate::output::DisableMacieOutput)

    /// - On failure, responds with [`SdkError<DisableMacieError>`](crate::error::DisableMacieError)
    pub fn disable_macie(&self) -> fluent_builders::DisableMacie<C, M, R> {
        fluent_builders::DisableMacie::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisableOrganizationAdminAccount`](crate::client::fluent_builders::DisableOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account_id(impl Into<String>)`](crate::client::fluent_builders::DisableOrganizationAdminAccount::admin_account_id) / [`set_admin_account_id(Option<String>)`](crate::client::fluent_builders::DisableOrganizationAdminAccount::set_admin_account_id): <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
    /// - On success, responds with [`DisableOrganizationAdminAccountOutput`](crate::output::DisableOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<DisableOrganizationAdminAccountError>`](crate::error::DisableOrganizationAdminAccountError)
    pub fn disable_organization_admin_account(
        &self,
    ) -> fluent_builders::DisableOrganizationAdminAccount<C, M, R> {
        fluent_builders::DisableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFromAdministratorAccount`](crate::client::fluent_builders::DisassociateFromAdministratorAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateFromAdministratorAccount::send) it.

    /// - On success, responds with [`DisassociateFromAdministratorAccountOutput`](crate::output::DisassociateFromAdministratorAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateFromAdministratorAccountError>`](crate::error::DisassociateFromAdministratorAccountError)
    pub fn disassociate_from_administrator_account(
        &self,
    ) -> fluent_builders::DisassociateFromAdministratorAccount<C, M, R> {
        fluent_builders::DisassociateFromAdministratorAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateFromMasterAccount`](crate::client::fluent_builders::DisassociateFromMasterAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::DisassociateFromMasterAccount::send) it.

    /// - On success, responds with [`DisassociateFromMasterAccountOutput`](crate::output::DisassociateFromMasterAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateFromMasterAccountError>`](crate::error::DisassociateFromMasterAccountError)
    pub fn disassociate_from_master_account(
        &self,
    ) -> fluent_builders::DisassociateFromMasterAccount<C, M, R> {
        fluent_builders::DisassociateFromMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMember`](crate::client::fluent_builders::DisassociateMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMember::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::DisassociateMember::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`DisassociateMemberOutput`](crate::output::DisassociateMemberOutput)

    /// - On failure, responds with [`SdkError<DisassociateMemberError>`](crate::error::DisassociateMemberError)
    pub fn disassociate_member(&self) -> fluent_builders::DisassociateMember<C, M, R> {
        fluent_builders::DisassociateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableMacie`](crate::client::fluent_builders::EnableMacie) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::EnableMacie::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::EnableMacie::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    ///   - [`finding_publishing_frequency(FindingPublishingFrequency)`](crate::client::fluent_builders::EnableMacie::finding_publishing_frequency) / [`set_finding_publishing_frequency(Option<FindingPublishingFrequency>)`](crate::client::fluent_builders::EnableMacie::set_finding_publishing_frequency): <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    ///   - [`status(MacieStatus)`](crate::client::fluent_builders::EnableMacie::status) / [`set_status(Option<MacieStatus>)`](crate::client::fluent_builders::EnableMacie::set_status): <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
    /// - On success, responds with [`EnableMacieOutput`](crate::output::EnableMacieOutput)

    /// - On failure, responds with [`SdkError<EnableMacieError>`](crate::error::EnableMacieError)
    pub fn enable_macie(&self) -> fluent_builders::EnableMacie<C, M, R> {
        fluent_builders::EnableMacie::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`EnableOrganizationAdminAccount`](crate::client::fluent_builders::EnableOrganizationAdminAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`admin_account_id(impl Into<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::admin_account_id) / [`set_admin_account_id(Option<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::set_admin_account_id): <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::EnableOrganizationAdminAccount::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`EnableOrganizationAdminAccountOutput`](crate::output::EnableOrganizationAdminAccountOutput)

    /// - On failure, responds with [`SdkError<EnableOrganizationAdminAccountError>`](crate::error::EnableOrganizationAdminAccountError)
    pub fn enable_organization_admin_account(
        &self,
    ) -> fluent_builders::EnableOrganizationAdminAccount<C, M, R> {
        fluent_builders::EnableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetAdministratorAccount`](crate::client::fluent_builders::GetAdministratorAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetAdministratorAccount::send) it.

    /// - On success, responds with [`GetAdministratorAccountOutput`](crate::output::GetAdministratorAccountOutput) with field(s):
    ///   - [`administrator(Option<Invitation>)`](crate::output::GetAdministratorAccountOutput::administrator): <p>The Amazon Web Services account ID for the administrator account. If the accounts are associated by an Amazon Macie membership invitation, this object also provides details about the invitation that was sent to establish the relationship between the accounts.</p>
    /// - On failure, responds with [`SdkError<GetAdministratorAccountError>`](crate::error::GetAdministratorAccountError)
    pub fn get_administrator_account(&self) -> fluent_builders::GetAdministratorAccount<C, M, R> {
        fluent_builders::GetAdministratorAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBucketStatistics`](crate::client::fluent_builders::GetBucketStatistics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`account_id(impl Into<String>)`](crate::client::fluent_builders::GetBucketStatistics::account_id) / [`set_account_id(Option<String>)`](crate::client::fluent_builders::GetBucketStatistics::set_account_id): <p>The unique identifier for the Amazon Web Services account.</p>
    /// - On success, responds with [`GetBucketStatisticsOutput`](crate::output::GetBucketStatisticsOutput) with field(s):
    ///   - [`bucket_count(i64)`](crate::output::GetBucketStatisticsOutput::bucket_count): <p>The total number of buckets.</p>
    ///   - [`bucket_count_by_effective_permission(Option<BucketCountByEffectivePermission>)`](crate::output::GetBucketStatisticsOutput::bucket_count_by_effective_permission): <p>The total number of buckets that are publicly accessible based on a combination of permissions settings for each bucket.</p>
    ///   - [`bucket_count_by_encryption_type(Option<BucketCountByEncryptionType>)`](crate::output::GetBucketStatisticsOutput::bucket_count_by_encryption_type): <p>The total number of buckets that use certain types of server-side encryption to encrypt new objects by default. This object also reports the total number of buckets that don't encrypt new objects by default.</p>
    ///   - [`bucket_count_by_object_encryption_requirement(Option<BucketCountPolicyAllowsUnencryptedObjectUploads>)`](crate::output::GetBucketStatisticsOutput::bucket_count_by_object_encryption_requirement): <p>The total number of buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.</p>
    ///   - [`bucket_count_by_shared_access_type(Option<BucketCountBySharedAccessType>)`](crate::output::GetBucketStatisticsOutput::bucket_count_by_shared_access_type): <p>The total number of buckets that are or aren't shared with another Amazon Web Services account.</p>
    ///   - [`classifiable_object_count(i64)`](crate::output::GetBucketStatisticsOutput::classifiable_object_count): <p>The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>
    ///   - [`classifiable_size_in_bytes(i64)`](crate::output::GetBucketStatisticsOutput::classifiable_size_in_bytes): <p>The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.</p>  <p>If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of all applicable objects in the buckets.</p>
    ///   - [`last_updated(Option<DateTime>)`](crate::output::GetBucketStatisticsOutput::last_updated): <p>The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the buckets.</p>
    ///   - [`object_count(i64)`](crate::output::GetBucketStatisticsOutput::object_count): <p>The total number of objects in the buckets.</p>
    ///   - [`size_in_bytes(i64)`](crate::output::GetBucketStatisticsOutput::size_in_bytes): <p>The total storage size, in bytes, of the buckets.</p>  <p>If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.</p>
    ///   - [`size_in_bytes_compressed(i64)`](crate::output::GetBucketStatisticsOutput::size_in_bytes_compressed): <p>The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets.</p>  <p>If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of the applicable objects in the buckets.</p>
    ///   - [`unclassifiable_object_count(Option<ObjectLevelStatistics>)`](crate::output::GetBucketStatisticsOutput::unclassifiable_object_count): <p>The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    ///   - [`unclassifiable_object_size_in_bytes(Option<ObjectLevelStatistics>)`](crate::output::GetBucketStatisticsOutput::unclassifiable_object_size_in_bytes): <p>The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.</p>
    /// - On failure, responds with [`SdkError<GetBucketStatisticsError>`](crate::error::GetBucketStatisticsError)
    pub fn get_bucket_statistics(&self) -> fluent_builders::GetBucketStatistics<C, M, R> {
        fluent_builders::GetBucketStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetClassificationExportConfiguration`](crate::client::fluent_builders::GetClassificationExportConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetClassificationExportConfiguration::send) it.

    /// - On success, responds with [`GetClassificationExportConfigurationOutput`](crate::output::GetClassificationExportConfigurationOutput) with field(s):
    ///   - [`configuration(Option<ClassificationExportConfiguration>)`](crate::output::GetClassificationExportConfigurationOutput::configuration): <p>The location where data classification results are stored, and the encryption settings that are used when storing results in that location.</p>
    /// - On failure, responds with [`SdkError<GetClassificationExportConfigurationError>`](crate::error::GetClassificationExportConfigurationError)
    pub fn get_classification_export_configuration(
        &self,
    ) -> fluent_builders::GetClassificationExportConfiguration<C, M, R> {
        fluent_builders::GetClassificationExportConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetCustomDataIdentifier`](crate::client::fluent_builders::GetCustomDataIdentifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetCustomDataIdentifier::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetCustomDataIdentifier::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`GetCustomDataIdentifierOutput`](crate::output::GetCustomDataIdentifierOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::GetCustomDataIdentifierOutput::arn): <p>The Amazon Resource Name (ARN) of the custom data identifier.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetCustomDataIdentifierOutput::created_at): <p>The date and time, in UTC and extended ISO 8601 format, when the custom data identifier was created.</p>
    ///   - [`deleted(bool)`](crate::output::GetCustomDataIdentifierOutput::deleted): <p>Specifies whether the custom data identifier was deleted. If you delete a custom data identifier, Amazon Macie doesn't delete it permanently. Instead, it soft deletes the identifier.</p>
    ///   - [`description(Option<String>)`](crate::output::GetCustomDataIdentifierOutput::description): <p>The custom description of the custom data identifier.</p>
    ///   - [`id(Option<String>)`](crate::output::GetCustomDataIdentifierOutput::id): <p>The unique identifier for the custom data identifier.</p>
    ///   - [`ignore_words(Option<Vec<String>>)`](crate::output::GetCustomDataIdentifierOutput::ignore_words): <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. Ignore words are case sensitive.</p>
    ///   - [`keywords(Option<Vec<String>>)`](crate::output::GetCustomDataIdentifierOutput::keywords): <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. Keywords aren't case sensitive.</p>
    ///   - [`maximum_match_distance(i32)`](crate::output::GetCustomDataIdentifierOutput::maximum_match_distance): <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression.</p>
    ///   - [`name(Option<String>)`](crate::output::GetCustomDataIdentifierOutput::name): <p>The custom name of the custom data identifier.</p>
    ///   - [`regex(Option<String>)`](crate::output::GetCustomDataIdentifierOutput::regex): <p>The regular expression (<i>regex</i>) that defines the pattern to match.</p>
    ///   - [`severity_levels(Option<Vec<SeverityLevel>>)`](crate::output::GetCustomDataIdentifierOutput::severity_levels): <p>Specifies the severity that's assigned to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. By default, Amazon Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetCustomDataIdentifierOutput::tags): <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the custom data identifier.</p>
    /// - On failure, responds with [`SdkError<GetCustomDataIdentifierError>`](crate::error::GetCustomDataIdentifierError)
    pub fn get_custom_data_identifier(&self) -> fluent_builders::GetCustomDataIdentifier<C, M, R> {
        fluent_builders::GetCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindings`](crate::client::fluent_builders::GetFindings) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_ids(Vec<String>)`](crate::client::fluent_builders::GetFindings::finding_ids) / [`set_finding_ids(Option<Vec<String>>)`](crate::client::fluent_builders::GetFindings::set_finding_ids): <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
    ///   - [`sort_criteria(SortCriteria)`](crate::client::fluent_builders::GetFindings::sort_criteria) / [`set_sort_criteria(Option<SortCriteria>)`](crate::client::fluent_builders::GetFindings::set_sort_criteria): <p>The criteria for sorting the results of the request.</p>
    /// - On success, responds with [`GetFindingsOutput`](crate::output::GetFindingsOutput) with field(s):
    ///   - [`findings(Option<Vec<Finding>>)`](crate::output::GetFindingsOutput::findings): <p>An array of objects, one for each finding that meets the criteria specified in the request.</p>
    /// - On failure, responds with [`SdkError<GetFindingsError>`](crate::error::GetFindingsError)
    pub fn get_findings(&self) -> fluent_builders::GetFindings<C, M, R> {
        fluent_builders::GetFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindingsFilter`](crate::client::fluent_builders::GetFindingsFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetFindingsFilter::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetFindingsFilter::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`GetFindingsFilterOutput`](crate::output::GetFindingsFilterOutput) with field(s):
    ///   - [`action(Option<FindingsFilterAction>)`](crate::output::GetFindingsFilterOutput::action): <p>The action that's performed on findings that meet the filter criteria (findingCriteria). Possible values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetFindingsFilterOutput::arn): <p>The Amazon Resource Name (ARN) of the filter.</p>
    ///   - [`description(Option<String>)`](crate::output::GetFindingsFilterOutput::description): <p>The custom description of the filter.</p>
    ///   - [`finding_criteria(Option<FindingCriteria>)`](crate::output::GetFindingsFilterOutput::finding_criteria): <p>The criteria that's used to filter findings.</p>
    ///   - [`id(Option<String>)`](crate::output::GetFindingsFilterOutput::id): <p>The unique identifier for the filter.</p>
    ///   - [`name(Option<String>)`](crate::output::GetFindingsFilterOutput::name): <p>The custom name of the filter.</p>
    ///   - [`position(i32)`](crate::output::GetFindingsFilterOutput::position): <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetFindingsFilterOutput::tags): <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the filter.</p>
    /// - On failure, responds with [`SdkError<GetFindingsFilterError>`](crate::error::GetFindingsFilterError)
    pub fn get_findings_filter(&self) -> fluent_builders::GetFindingsFilter<C, M, R> {
        fluent_builders::GetFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindingsPublicationConfiguration`](crate::client::fluent_builders::GetFindingsPublicationConfiguration) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetFindingsPublicationConfiguration::send) it.

    /// - On success, responds with [`GetFindingsPublicationConfigurationOutput`](crate::output::GetFindingsPublicationConfigurationOutput) with field(s):
    ///   - [`security_hub_configuration(Option<SecurityHubConfiguration>)`](crate::output::GetFindingsPublicationConfigurationOutput::security_hub_configuration): <p>The configuration settings that determine which findings are published to Security Hub.</p>
    /// - On failure, responds with [`SdkError<GetFindingsPublicationConfigurationError>`](crate::error::GetFindingsPublicationConfigurationError)
    pub fn get_findings_publication_configuration(
        &self,
    ) -> fluent_builders::GetFindingsPublicationConfiguration<C, M, R> {
        fluent_builders::GetFindingsPublicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetFindingStatistics`](crate::client::fluent_builders::GetFindingStatistics) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_criteria(FindingCriteria)`](crate::client::fluent_builders::GetFindingStatistics::finding_criteria) / [`set_finding_criteria(Option<FindingCriteria>)`](crate::client::fluent_builders::GetFindingStatistics::set_finding_criteria): <p>The criteria to use to filter the query results.</p>
    ///   - [`group_by(GroupBy)`](crate::client::fluent_builders::GetFindingStatistics::group_by) / [`set_group_by(Option<GroupBy>)`](crate::client::fluent_builders::GetFindingStatistics::set_group_by): <p>The finding property to use to group the query results. Valid values are:</p>  <ul>  <li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li>   <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li>   <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li>   <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li> </ul>
    ///   - [`size(i32)`](crate::client::fluent_builders::GetFindingStatistics::size) / [`set_size(i32)`](crate::client::fluent_builders::GetFindingStatistics::set_size): <p>The maximum number of items to include in each page of the response.</p>
    ///   - [`sort_criteria(FindingStatisticsSortCriteria)`](crate::client::fluent_builders::GetFindingStatistics::sort_criteria) / [`set_sort_criteria(Option<FindingStatisticsSortCriteria>)`](crate::client::fluent_builders::GetFindingStatistics::set_sort_criteria): <p>The criteria to use to sort the query results.</p>
    /// - On success, responds with [`GetFindingStatisticsOutput`](crate::output::GetFindingStatisticsOutput) with field(s):
    ///   - [`counts_by_group(Option<Vec<GroupCount>>)`](crate::output::GetFindingStatisticsOutput::counts_by_group): <p>An array of objects, one for each group of findings that meet the filter criteria specified in the request.</p>
    /// - On failure, responds with [`SdkError<GetFindingStatisticsError>`](crate::error::GetFindingStatisticsError)
    pub fn get_finding_statistics(&self) -> fluent_builders::GetFindingStatistics<C, M, R> {
        fluent_builders::GetFindingStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetInvitationsCount`](crate::client::fluent_builders::GetInvitationsCount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetInvitationsCount::send) it.

    /// - On success, responds with [`GetInvitationsCountOutput`](crate::output::GetInvitationsCountOutput) with field(s):
    ///   - [`invitations_count(i64)`](crate::output::GetInvitationsCountOutput::invitations_count): <p>The total number of invitations that were received by the account, not including the currently accepted invitation.</p>
    /// - On failure, responds with [`SdkError<GetInvitationsCountError>`](crate::error::GetInvitationsCountError)
    pub fn get_invitations_count(&self) -> fluent_builders::GetInvitationsCount<C, M, R> {
        fluent_builders::GetInvitationsCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMacieSession`](crate::client::fluent_builders::GetMacieSession) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetMacieSession::send) it.

    /// - On success, responds with [`GetMacieSessionOutput`](crate::output::GetMacieSessionOutput) with field(s):
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetMacieSessionOutput::created_at): <p>The date and time, in UTC and extended ISO 8601 format, when the Amazon Macie account was created.</p>
    ///   - [`finding_publishing_frequency(Option<FindingPublishingFrequency>)`](crate::output::GetMacieSessionOutput::finding_publishing_frequency): <p>The frequency with which Amazon Macie publishes updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    ///   - [`service_role(Option<String>)`](crate::output::GetMacieSessionOutput::service_role): <p>The Amazon Resource Name (ARN) of the service-linked role that allows Amazon Macie to monitor and analyze data in Amazon Web Services resources for the account.</p>
    ///   - [`status(Option<MacieStatus>)`](crate::output::GetMacieSessionOutput::status): <p>The current status of the Amazon Macie account. Possible values are: PAUSED, the account is enabled but all Macie activities are suspended (paused) for the account; and, ENABLED, the account is enabled and all Macie activities are enabled for the account.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetMacieSessionOutput::updated_at): <p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the Amazon Macie account.</p>
    /// - On failure, responds with [`SdkError<GetMacieSessionError>`](crate::error::GetMacieSessionError)
    pub fn get_macie_session(&self) -> fluent_builders::GetMacieSession<C, M, R> {
        fluent_builders::GetMacieSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMasterAccount`](crate::client::fluent_builders::GetMasterAccount) operation.
    ///
    /// - The fluent builder takes no input, just [`send`](crate::client::fluent_builders::GetMasterAccount::send) it.

    /// - On success, responds with [`GetMasterAccountOutput`](crate::output::GetMasterAccountOutput) with field(s):
    ///   - [`master(Option<Invitation>)`](crate::output::GetMasterAccountOutput::master): <p>(Deprecated) The Amazon Web Services account ID for the administrator account. If the accounts are associated by a Macie membership invitation, this object also provides details about the invitation that was sent to establish the relationship between the accounts.</p>
    /// - On failure, responds with [`SdkError<GetMasterAccountError>`](crate::error::GetMasterAccountError)
    pub fn get_master_account(&self) -> fluent_builders::GetMasterAccount<C, M, R> {
        fluent_builders::GetMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMember`](crate::client::fluent_builders::GetMember) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::GetMember::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::GetMember::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    /// - On success, responds with [`GetMemberOutput`](crate::output::GetMemberOutput) with field(s):
    ///   - [`account_id(Option<String>)`](crate::output::GetMemberOutput::account_id): <p>The Amazon Web Services account ID for the account.</p>
    ///   - [`administrator_account_id(Option<String>)`](crate::output::GetMemberOutput::administrator_account_id): <p>The Amazon Web Services account ID for the administrator account.</p>
    ///   - [`arn(Option<String>)`](crate::output::GetMemberOutput::arn): <p>The Amazon Resource Name (ARN) of the account.</p>
    ///   - [`email(Option<String>)`](crate::output::GetMemberOutput::email): <p>The email address for the account.</p>
    ///   - [`invited_at(Option<DateTime>)`](crate::output::GetMemberOutput::invited_at): <p>The date and time, in UTC and extended ISO 8601 format, when an Amazon Macie membership invitation was last sent to the account. This value is null if an invitation hasn't been sent to the account.</p>
    ///   - [`master_account_id(Option<String>)`](crate::output::GetMemberOutput::master_account_id): <p>(Deprecated) The Amazon Web Services account ID for the administrator account. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
    ///   - [`relationship_status(Option<RelationshipStatus>)`](crate::output::GetMemberOutput::relationship_status): <p>The current status of the relationship between the account and the administrator account.</p>
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::GetMemberOutput::tags): <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the member account in Amazon Macie.</p>
    ///   - [`updated_at(Option<DateTime>)`](crate::output::GetMemberOutput::updated_at): <p>The date and time, in UTC and extended ISO 8601 format, of the most recent change to the status of the relationship between the account and the administrator account.</p>
    /// - On failure, responds with [`SdkError<GetMemberError>`](crate::error::GetMemberError)
    pub fn get_member(&self) -> fluent_builders::GetMember<C, M, R> {
        fluent_builders::GetMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsageStatistics`](crate::client::fluent_builders::GetUsageStatistics) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::GetUsageStatistics::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_by(Vec<UsageStatisticsFilter>)`](crate::client::fluent_builders::GetUsageStatistics::filter_by) / [`set_filter_by(Option<Vec<UsageStatisticsFilter>>)`](crate::client::fluent_builders::GetUsageStatistics::set_filter_by): <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::GetUsageStatistics::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::GetUsageStatistics::set_max_results): <p>The maximum number of items to include in each page of the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::GetUsageStatistics::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::GetUsageStatistics::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    ///   - [`sort_by(UsageStatisticsSortBy)`](crate::client::fluent_builders::GetUsageStatistics::sort_by) / [`set_sort_by(Option<UsageStatisticsSortBy>)`](crate::client::fluent_builders::GetUsageStatistics::set_sort_by): <p>The criteria to use to sort the query results.</p>
    ///   - [`time_range(TimeRange)`](crate::client::fluent_builders::GetUsageStatistics::time_range) / [`set_time_range(Option<TimeRange>)`](crate::client::fluent_builders::GetUsageStatistics::set_time_range): <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
    /// - On success, responds with [`GetUsageStatisticsOutput`](crate::output::GetUsageStatisticsOutput) with field(s):
    ///   - [`next_token(Option<String>)`](crate::output::GetUsageStatisticsOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    ///   - [`records(Option<Vec<UsageRecord>>)`](crate::output::GetUsageStatisticsOutput::records): <p>An array of objects that contains the results of the query. Each object contains the data for an account that meets the filter criteria specified in the request.</p>
    ///   - [`time_range(Option<TimeRange>)`](crate::output::GetUsageStatisticsOutput::time_range): <p>The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.</p>
    /// - On failure, responds with [`SdkError<GetUsageStatisticsError>`](crate::error::GetUsageStatisticsError)
    pub fn get_usage_statistics(&self) -> fluent_builders::GetUsageStatistics<C, M, R> {
        fluent_builders::GetUsageStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetUsageTotals`](crate::client::fluent_builders::GetUsageTotals) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`time_range(impl Into<String>)`](crate::client::fluent_builders::GetUsageTotals::time_range) / [`set_time_range(Option<String>)`](crate::client::fluent_builders::GetUsageTotals::set_time_range): <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
    /// - On success, responds with [`GetUsageTotalsOutput`](crate::output::GetUsageTotalsOutput) with field(s):
    ///   - [`time_range(Option<TimeRange>)`](crate::output::GetUsageTotalsOutput::time_range): <p>The inclusive time period that the usage data applies to. Possible values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days.</p>
    ///   - [`usage_totals(Option<Vec<UsageTotal>>)`](crate::output::GetUsageTotalsOutput::usage_totals): <p>An array of objects that contains the results of the query. Each object contains the data for a specific usage metric.</p>
    /// - On failure, responds with [`SdkError<GetUsageTotalsError>`](crate::error::GetUsageTotalsError)
    pub fn get_usage_totals(&self) -> fluent_builders::GetUsageTotals<C, M, R> {
        fluent_builders::GetUsageTotals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListClassificationJobs`](crate::client::fluent_builders::ListClassificationJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListClassificationJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_criteria(ListJobsFilterCriteria)`](crate::client::fluent_builders::ListClassificationJobs::filter_criteria) / [`set_filter_criteria(Option<ListJobsFilterCriteria>)`](crate::client::fluent_builders::ListClassificationJobs::set_filter_criteria): <p>The criteria to use to filter the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListClassificationJobs::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListClassificationJobs::set_max_results): <p>The maximum number of items to include in each page of the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListClassificationJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListClassificationJobs::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    ///   - [`sort_criteria(ListJobsSortCriteria)`](crate::client::fluent_builders::ListClassificationJobs::sort_criteria) / [`set_sort_criteria(Option<ListJobsSortCriteria>)`](crate::client::fluent_builders::ListClassificationJobs::set_sort_criteria): <p>The criteria to use to sort the results.</p>
    /// - On success, responds with [`ListClassificationJobsOutput`](crate::output::ListClassificationJobsOutput) with field(s):
    ///   - [`items(Option<Vec<JobSummary>>)`](crate::output::ListClassificationJobsOutput::items): <p>An array of objects, one for each job that meets the filter criteria specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListClassificationJobsOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListClassificationJobsError>`](crate::error::ListClassificationJobsError)
    pub fn list_classification_jobs(&self) -> fluent_builders::ListClassificationJobs<C, M, R> {
        fluent_builders::ListClassificationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListCustomDataIdentifiers`](crate::client::fluent_builders::ListCustomDataIdentifiers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListCustomDataIdentifiers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListCustomDataIdentifiers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListCustomDataIdentifiers::set_max_results): <p>The maximum number of items to include in each page of the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListCustomDataIdentifiers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListCustomDataIdentifiers::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`ListCustomDataIdentifiersOutput`](crate::output::ListCustomDataIdentifiersOutput) with field(s):
    ///   - [`items(Option<Vec<CustomDataIdentifierSummary>>)`](crate::output::ListCustomDataIdentifiersOutput::items): <p>An array of objects, one for each custom data identifier.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListCustomDataIdentifiersOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListCustomDataIdentifiersError>`](crate::error::ListCustomDataIdentifiersError)
    pub fn list_custom_data_identifiers(
        &self,
    ) -> fluent_builders::ListCustomDataIdentifiers<C, M, R> {
        fluent_builders::ListCustomDataIdentifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindings`](crate::client::fluent_builders::ListFindings) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindings::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_criteria(FindingCriteria)`](crate::client::fluent_builders::ListFindings::finding_criteria) / [`set_finding_criteria(Option<FindingCriteria>)`](crate::client::fluent_builders::ListFindings::set_finding_criteria): <p>The criteria to use to filter the results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindings::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListFindings::set_max_results): <p>The maximum number of items to include in each page of the response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindings::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindings::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    ///   - [`sort_criteria(SortCriteria)`](crate::client::fluent_builders::ListFindings::sort_criteria) / [`set_sort_criteria(Option<SortCriteria>)`](crate::client::fluent_builders::ListFindings::set_sort_criteria): <p>The criteria to use to sort the results.</p>
    /// - On success, responds with [`ListFindingsOutput`](crate::output::ListFindingsOutput) with field(s):
    ///   - [`finding_ids(Option<Vec<String>>)`](crate::output::ListFindingsOutput::finding_ids): <p>An array of strings, where each string is the unique identifier for a finding that meets the filter criteria specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingsOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListFindingsError>`](crate::error::ListFindingsError)
    pub fn list_findings(&self) -> fluent_builders::ListFindings<C, M, R> {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListFindingsFilters`](crate::client::fluent_builders::ListFindingsFilters) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListFindingsFilters::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListFindingsFilters::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListFindingsFilters::set_max_results): <p>The maximum number of items to include in each page of a paginated response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListFindingsFilters::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListFindingsFilters::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`ListFindingsFiltersOutput`](crate::output::ListFindingsFiltersOutput) with field(s):
    ///   - [`findings_filter_list_items(Option<Vec<FindingsFilterListItem>>)`](crate::output::ListFindingsFiltersOutput::findings_filter_list_items): <p>An array of objects, one for each filter that's associated with the account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListFindingsFiltersOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListFindingsFiltersError>`](crate::error::ListFindingsFiltersError)
    pub fn list_findings_filters(&self) -> fluent_builders::ListFindingsFilters<C, M, R> {
        fluent_builders::ListFindingsFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListInvitations`](crate::client::fluent_builders::ListInvitations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListInvitations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListInvitations::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListInvitations::set_max_results): <p>The maximum number of items to include in each page of a paginated response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListInvitations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListInvitations::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`ListInvitationsOutput`](crate::output::ListInvitationsOutput) with field(s):
    ///   - [`invitations(Option<Vec<Invitation>>)`](crate::output::ListInvitationsOutput::invitations): <p>An array of objects, one for each invitation that was received by the account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListInvitationsOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListInvitationsError>`](crate::error::ListInvitationsError)
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations<C, M, R> {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListManagedDataIdentifiers`](crate::client::fluent_builders::ListManagedDataIdentifiers) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListManagedDataIdentifiers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListManagedDataIdentifiers::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`ListManagedDataIdentifiersOutput`](crate::output::ListManagedDataIdentifiersOutput) with field(s):
    ///   - [`items(Option<Vec<ManagedDataIdentifierSummary>>)`](crate::output::ListManagedDataIdentifiersOutput::items): <p>An array of objects, one for each managed data identifier.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListManagedDataIdentifiersOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListManagedDataIdentifiersError>`](crate::error::ListManagedDataIdentifiersError)
    pub fn list_managed_data_identifiers(
        &self,
    ) -> fluent_builders::ListManagedDataIdentifiers<C, M, R> {
        fluent_builders::ListManagedDataIdentifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMembers`](crate::client::fluent_builders::ListMembers) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMembers::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMembers::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListMembers::set_max_results): <p>The maximum number of items to include in each page of a paginated response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMembers::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMembers::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    ///   - [`only_associated(impl Into<String>)`](crate::client::fluent_builders::ListMembers::only_associated) / [`set_only_associated(Option<String>)`](crate::client::fluent_builders::ListMembers::set_only_associated): <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
    /// - On success, responds with [`ListMembersOutput`](crate::output::ListMembersOutput) with field(s):
    ///   - [`members(Option<Vec<Member>>)`](crate::output::ListMembersOutput::members): <p>An array of objects, one for each account that's associated with the administrator account and meets the criteria specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMembersOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListMembersError>`](crate::error::ListMembersError)
    pub fn list_members(&self) -> fluent_builders::ListMembers<C, M, R> {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListOrganizationAdminAccounts`](crate::client::fluent_builders::ListOrganizationAdminAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListOrganizationAdminAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::set_max_results): <p>The maximum number of items to include in each page of a paginated response.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListOrganizationAdminAccounts::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    /// - On success, responds with [`ListOrganizationAdminAccountsOutput`](crate::output::ListOrganizationAdminAccountsOutput) with field(s):
    ///   - [`admin_accounts(Option<Vec<AdminAccount>>)`](crate::output::ListOrganizationAdminAccountsOutput::admin_accounts): <p>An array of objects, one for each delegated Amazon Macie administrator account for the organization. Only one of these accounts can have a status of ENABLED.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListOrganizationAdminAccountsOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<ListOrganizationAdminAccountsError>`](crate::error::ListOrganizationAdminAccountsError)
    pub fn list_organization_admin_accounts(
        &self,
    ) -> fluent_builders::ListOrganizationAdminAccounts<C, M, R> {
        fluent_builders::ListOrganizationAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<HashMap<String, String>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A map of key-value pairs that identifies the tags (keys and values) that are associated with the resource.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutClassificationExportConfiguration`](crate::client::fluent_builders::PutClassificationExportConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`configuration(ClassificationExportConfiguration)`](crate::client::fluent_builders::PutClassificationExportConfiguration::configuration) / [`set_configuration(Option<ClassificationExportConfiguration>)`](crate::client::fluent_builders::PutClassificationExportConfiguration::set_configuration): <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
    /// - On success, responds with [`PutClassificationExportConfigurationOutput`](crate::output::PutClassificationExportConfigurationOutput) with field(s):
    ///   - [`configuration(Option<ClassificationExportConfiguration>)`](crate::output::PutClassificationExportConfigurationOutput::configuration): <p>The location where the data classification results are stored, and the encryption settings that are used when storing results in that location.</p>
    /// - On failure, responds with [`SdkError<PutClassificationExportConfigurationError>`](crate::error::PutClassificationExportConfigurationError)
    pub fn put_classification_export_configuration(
        &self,
    ) -> fluent_builders::PutClassificationExportConfiguration<C, M, R> {
        fluent_builders::PutClassificationExportConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`PutFindingsPublicationConfiguration`](crate::client::fluent_builders::PutFindingsPublicationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::PutFindingsPublicationConfiguration::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::PutFindingsPublicationConfiguration::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    ///   - [`security_hub_configuration(SecurityHubConfiguration)`](crate::client::fluent_builders::PutFindingsPublicationConfiguration::security_hub_configuration) / [`set_security_hub_configuration(Option<SecurityHubConfiguration>)`](crate::client::fluent_builders::PutFindingsPublicationConfiguration::set_security_hub_configuration): <p>The configuration settings that determine which findings to publish to Security Hub.</p>
    /// - On success, responds with [`PutFindingsPublicationConfigurationOutput`](crate::output::PutFindingsPublicationConfigurationOutput)

    /// - On failure, responds with [`SdkError<PutFindingsPublicationConfigurationError>`](crate::error::PutFindingsPublicationConfigurationError)
    pub fn put_findings_publication_configuration(
        &self,
    ) -> fluent_builders::PutFindingsPublicationConfiguration<C, M, R> {
        fluent_builders::PutFindingsPublicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`SearchResources`](crate::client::fluent_builders::SearchResources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::SearchResources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket_criteria(SearchResourcesBucketCriteria)`](crate::client::fluent_builders::SearchResources::bucket_criteria) / [`set_bucket_criteria(Option<SearchResourcesBucketCriteria>)`](crate::client::fluent_builders::SearchResources::set_bucket_criteria): <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::SearchResources::max_results) / [`set_max_results(i32)`](crate::client::fluent_builders::SearchResources::set_max_results): <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::SearchResources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::SearchResources::set_next_token): <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    ///   - [`sort_criteria(SearchResourcesSortCriteria)`](crate::client::fluent_builders::SearchResources::sort_criteria) / [`set_sort_criteria(Option<SearchResourcesSortCriteria>)`](crate::client::fluent_builders::SearchResources::set_sort_criteria): <p>The criteria to use to sort the results.</p>
    /// - On success, responds with [`SearchResourcesOutput`](crate::output::SearchResourcesOutput) with field(s):
    ///   - [`matching_resources(Option<Vec<MatchingResource>>)`](crate::output::SearchResourcesOutput::matching_resources): <p>An array of objects, one for each resource that meets the filter criteria specified in the request.</p>
    ///   - [`next_token(Option<String>)`](crate::output::SearchResourcesOutput::next_token): <p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>
    /// - On failure, responds with [`SdkError<SearchResourcesError>`](crate::error::SearchResourcesError)
    pub fn search_resources(&self) -> fluent_builders::SearchResources<C, M, R> {
        fluent_builders::SearchResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    ///   - [`tags(HashMap<String, String>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<HashMap<String, String>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>A map of key-value pairs that specifies the tags to associate with the resource.</p>  <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TestCustomDataIdentifier`](crate::client::fluent_builders::TestCustomDataIdentifier) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ignore_words(Vec<String>)`](crate::client::fluent_builders::TestCustomDataIdentifier::ignore_words) / [`set_ignore_words(Option<Vec<String>>)`](crate::client::fluent_builders::TestCustomDataIdentifier::set_ignore_words): <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
    ///   - [`keywords(Vec<String>)`](crate::client::fluent_builders::TestCustomDataIdentifier::keywords) / [`set_keywords(Option<Vec<String>>)`](crate::client::fluent_builders::TestCustomDataIdentifier::set_keywords): <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
    ///   - [`maximum_match_distance(i32)`](crate::client::fluent_builders::TestCustomDataIdentifier::maximum_match_distance) / [`set_maximum_match_distance(i32)`](crate::client::fluent_builders::TestCustomDataIdentifier::set_maximum_match_distance): <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
    ///   - [`regex(impl Into<String>)`](crate::client::fluent_builders::TestCustomDataIdentifier::regex) / [`set_regex(Option<String>)`](crate::client::fluent_builders::TestCustomDataIdentifier::set_regex): <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
    ///   - [`sample_text(impl Into<String>)`](crate::client::fluent_builders::TestCustomDataIdentifier::sample_text) / [`set_sample_text(Option<String>)`](crate::client::fluent_builders::TestCustomDataIdentifier::set_sample_text): <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
    /// - On success, responds with [`TestCustomDataIdentifierOutput`](crate::output::TestCustomDataIdentifierOutput) with field(s):
    ///   - [`match_count(i32)`](crate::output::TestCustomDataIdentifierOutput::match_count): <p>The number of occurrences of sample text that matched the criteria specified by the custom data identifier.</p>
    /// - On failure, responds with [`SdkError<TestCustomDataIdentifierError>`](crate::error::TestCustomDataIdentifierError)
    pub fn test_custom_data_identifier(
        &self,
    ) -> fluent_builders::TestCustomDataIdentifier<C, M, R> {
        fluent_builders::TestCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateClassificationJob`](crate::client::fluent_builders::UpdateClassificationJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`job_id(impl Into<String>)`](crate::client::fluent_builders::UpdateClassificationJob::job_id) / [`set_job_id(Option<String>)`](crate::client::fluent_builders::UpdateClassificationJob::set_job_id): <p>The unique identifier for the classification job.</p>
    ///   - [`job_status(JobStatus)`](crate::client::fluent_builders::UpdateClassificationJob::job_status) / [`set_job_status(Option<JobStatus>)`](crate::client::fluent_builders::UpdateClassificationJob::set_job_status): <p>The new status for the job. Valid values are:</p>  <ul>  <li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li>   <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li>   <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li> </ul>
    /// - On success, responds with [`UpdateClassificationJobOutput`](crate::output::UpdateClassificationJobOutput)

    /// - On failure, responds with [`SdkError<UpdateClassificationJobError>`](crate::error::UpdateClassificationJobError)
    pub fn update_classification_job(&self) -> fluent_builders::UpdateClassificationJob<C, M, R> {
        fluent_builders::UpdateClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateFindingsFilter`](crate::client::fluent_builders::UpdateFindingsFilter) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`action(FindingsFilterAction)`](crate::client::fluent_builders::UpdateFindingsFilter::action) / [`set_action(Option<FindingsFilterAction>)`](crate::client::fluent_builders::UpdateFindingsFilter::set_action): <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::set_description): <p>A custom description of the filter. The description can contain as many as 512 characters.</p>  <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    ///   - [`finding_criteria(FindingCriteria)`](crate::client::fluent_builders::UpdateFindingsFilter::finding_criteria) / [`set_finding_criteria(Option<FindingCriteria>)`](crate::client::fluent_builders::UpdateFindingsFilter::set_finding_criteria): <p>The criteria to use to filter findings.</p>
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    ///   - [`name(impl Into<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::name) / [`set_name(Option<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::set_name): <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p>  <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    ///   - [`position(i32)`](crate::client::fluent_builders::UpdateFindingsFilter::position) / [`set_position(i32)`](crate::client::fluent_builders::UpdateFindingsFilter::set_position): <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateFindingsFilter::set_client_token): <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    /// - On success, responds with [`UpdateFindingsFilterOutput`](crate::output::UpdateFindingsFilterOutput) with field(s):
    ///   - [`arn(Option<String>)`](crate::output::UpdateFindingsFilterOutput::arn): <p>The Amazon Resource Name (ARN) of the filter that was updated.</p>
    ///   - [`id(Option<String>)`](crate::output::UpdateFindingsFilterOutput::id): <p>The unique identifier for the filter that was updated.</p>
    /// - On failure, responds with [`SdkError<UpdateFindingsFilterError>`](crate::error::UpdateFindingsFilterError)
    pub fn update_findings_filter(&self) -> fluent_builders::UpdateFindingsFilter<C, M, R> {
        fluent_builders::UpdateFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMacieSession`](crate::client::fluent_builders::UpdateMacieSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`finding_publishing_frequency(FindingPublishingFrequency)`](crate::client::fluent_builders::UpdateMacieSession::finding_publishing_frequency) / [`set_finding_publishing_frequency(Option<FindingPublishingFrequency>)`](crate::client::fluent_builders::UpdateMacieSession::set_finding_publishing_frequency): <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    ///   - [`status(MacieStatus)`](crate::client::fluent_builders::UpdateMacieSession::status) / [`set_status(Option<MacieStatus>)`](crate::client::fluent_builders::UpdateMacieSession::set_status): <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
    /// - On success, responds with [`UpdateMacieSessionOutput`](crate::output::UpdateMacieSessionOutput)

    /// - On failure, responds with [`SdkError<UpdateMacieSessionError>`](crate::error::UpdateMacieSessionError)
    pub fn update_macie_session(&self) -> fluent_builders::UpdateMacieSession<C, M, R> {
        fluent_builders::UpdateMacieSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMemberSession`](crate::client::fluent_builders::UpdateMemberSession) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`id(impl Into<String>)`](crate::client::fluent_builders::UpdateMemberSession::id) / [`set_id(Option<String>)`](crate::client::fluent_builders::UpdateMemberSession::set_id): <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    ///   - [`status(MacieStatus)`](crate::client::fluent_builders::UpdateMemberSession::status) / [`set_status(Option<MacieStatus>)`](crate::client::fluent_builders::UpdateMemberSession::set_status): <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
    /// - On success, responds with [`UpdateMemberSessionOutput`](crate::output::UpdateMemberSessionOutput)

    /// - On failure, responds with [`SdkError<UpdateMemberSessionError>`](crate::error::UpdateMemberSessionError)
    pub fn update_member_session(&self) -> fluent_builders::UpdateMemberSession<C, M, R> {
        fluent_builders::UpdateMemberSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`auto_enable(bool)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::auto_enable) / [`set_auto_enable(bool)`](crate::client::fluent_builders::UpdateOrganizationConfiguration::set_auto_enable): <p>Specifies whether to enable Amazon Macie automatically for an account when the account is added to the organization in Organizations.</p>
    /// - On success, responds with [`UpdateOrganizationConfigurationOutput`](crate::output::UpdateOrganizationConfigurationOutput)

    /// - On failure, responds with [`SdkError<UpdateOrganizationConfigurationError>`](crate::error::UpdateOrganizationConfigurationError)
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration<C, M, R> {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInvitation`.
    ///
    /// <p>Accepts an Amazon Macie membership invitation that was received from a specific account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AcceptInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_invitation_input::Builder,
    }
    impl<C, M, R> AcceptInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInvitationInputOperationOutputAlias,
                crate::output::AcceptInvitationOutput,
                crate::error::AcceptInvitationError,
                crate::input::AcceptInvitationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn administrator_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administrator_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn set_administrator_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administrator_account_id(input);
            self
        }
        /// <p>The unique identifier for the invitation to accept.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(input.into());
            self
        }
        /// <p>The unique identifier for the invitation to accept.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn master_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_account(input.into());
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn set_master_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetCustomDataIdentifiers`.
    ///
    /// <p>Retrieves information about one or more custom data identifiers.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct BatchGetCustomDataIdentifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_custom_data_identifiers_input::Builder,
    }
    impl<C, M, R> BatchGetCustomDataIdentifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetCustomDataIdentifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetCustomDataIdentifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetCustomDataIdentifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetCustomDataIdentifiersInputOperationOutputAlias,
                crate::output::BatchGetCustomDataIdentifiersOutput,
                crate::error::BatchGetCustomDataIdentifiersError,
                crate::input::BatchGetCustomDataIdentifiersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(input.into());
            self
        }
        /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClassificationJob`.
    ///
    /// <p>Creates and defines the settings for a classification job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_classification_job_input::Builder,
    }
    impl<C, M, R> CreateClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClassificationJobInputOperationOutputAlias,
                crate::output::CreateClassificationJobOutput,
                crate::error::CreateClassificationJobError,
                crate::input::CreateClassificationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `customDataIdentifierIds`.
        ///
        /// To override the contents of this collection use [`set_custom_data_identifier_ids`](Self::set_custom_data_identifier_ids).
        ///
        /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
        pub fn custom_data_identifier_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_data_identifier_ids(input.into());
            self
        }
        /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
        pub fn set_custom_data_identifier_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_custom_data_identifier_ids(input);
            self
        }
        /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p>
        /// <p>If you configure the job to run only once, don't specify a value for this property.</p>
        pub fn initial_run(mut self, input: bool) -> Self {
            self.inner = self.inner.initial_run(input);
            self
        }
        /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p>
        /// <p>If you configure the job to run only once, don't specify a value for this property.</p>
        pub fn set_initial_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_initial_run(input);
            self
        }
        /// <p>The schedule for running the job. Valid values are:</p>
        /// <ul>
        /// <li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li>
        /// <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li>
        /// </ul>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(input);
            self
        }
        /// <p>The schedule for running the job. Valid values are:</p>
        /// <ul>
        /// <li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li>
        /// <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li>
        /// </ul>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// Appends an item to `managedDataIdentifierIds`.
        ///
        /// To override the contents of this collection use [`set_managed_data_identifier_ids`](Self::set_managed_data_identifier_ids).
        ///
        /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p>
        /// <p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
        pub fn managed_data_identifier_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.managed_data_identifier_ids(input.into());
            self
        }
        /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p>
        /// <p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
        pub fn set_managed_data_identifier_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_managed_data_identifier_ids(input);
            self
        }
        /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p>
        /// <ul>
        /// <li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li>
        /// <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>
        /// <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>
        /// <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li>
        /// </ul>
        /// <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
        pub fn managed_data_identifier_selector(
            mut self,
            input: crate::model::ManagedDataIdentifierSelector,
        ) -> Self {
            self.inner = self.inner.managed_data_identifier_selector(input);
            self
        }
        /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p>
        /// <ul>
        /// <li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li>
        /// <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>
        /// <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li>
        /// <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li>
        /// </ul>
        /// <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
        pub fn set_managed_data_identifier_selector(
            mut self,
            input: std::option::Option<crate::model::ManagedDataIdentifierSelector>,
        ) -> Self {
            self.inner = self.inner.set_managed_data_identifier_selector(input);
            self
        }
        /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
        pub fn s3_job_definition(mut self, input: crate::model::S3JobDefinition) -> Self {
            self.inner = self.inner.s3_job_definition(input);
            self
        }
        /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
        pub fn set_s3_job_definition(
            mut self,
            input: std::option::Option<crate::model::S3JobDefinition>,
        ) -> Self {
            self.inner = self.inner.set_s3_job_definition(input);
            self
        }
        /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
        pub fn sampling_percentage(mut self, input: i32) -> Self {
            self.inner = self.inner.sampling_percentage(input);
            self
        }
        /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
        pub fn set_sampling_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_sampling_percentage(input);
            self
        }
        /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
        pub fn schedule_frequency(mut self, input: crate::model::JobScheduleFrequency) -> Self {
            self.inner = self.inner.schedule_frequency(input);
            self
        }
        /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
        pub fn set_schedule_frequency(
            mut self,
            input: std::option::Option<crate::model::JobScheduleFrequency>,
        ) -> Self {
            self.inner = self.inner.set_schedule_frequency(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p>
        /// <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p>
        /// <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomDataIdentifier`.
    ///
    /// <p>Creates and defines the criteria and other settings for a custom data identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> CreateCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomDataIdentifierInputOperationOutputAlias,
                crate::output::CreateCustomDataIdentifierOutput,
                crate::error::CreateCustomDataIdentifierError,
                crate::input::CreateCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ignoreWords`.
        ///
        /// To override the contents of this collection use [`set_ignore_words`](Self::set_ignore_words).
        ///
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn ignore_words(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ignore_words(input.into());
            self
        }
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn set_ignore_words(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ignore_words(input);
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(input.into());
            self
        }
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn maximum_match_distance(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_match_distance(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn set_maximum_match_distance(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_match_distance(input);
            self
        }
        /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex(input.into());
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_regex(input);
            self
        }
        /// Appends an item to `severityLevels`.
        ///
        /// To override the contents of this collection use [`set_severity_levels`](Self::set_severity_levels).
        ///
        /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p>
        /// <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
        pub fn severity_levels(mut self, input: crate::model::SeverityLevel) -> Self {
            self.inner = self.inner.severity_levels(input);
            self
        }
        /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p>
        /// <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
        pub fn set_severity_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
        ) -> Self {
            self.inner = self.inner.set_severity_levels(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p>
        /// <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p>
        /// <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFindingsFilter`.
    ///
    /// <p>Creates and defines the criteria and other settings for a findings filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_findings_filter_input::Builder,
    }
    impl<C, M, R> CreateFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFindingsFilterInputOperationOutputAlias,
                crate::output::CreateFindingsFilterOutput,
                crate::error::CreateFindingsFilterError,
                crate::input::CreateFindingsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, input: crate::model::FindingsFilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn position(mut self, input: i32) -> Self {
            self.inner = self.inner.position(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn set_position(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p>
        /// <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p>
        /// <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInvitations`.
    ///
    /// <p>Sends an Amazon Macie membership invitation to one or more accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_invitations_input::Builder,
    }
    impl<C, M, R> CreateInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInvitationsInputOperationOutputAlias,
                crate::output::CreateInvitationsOutput,
                crate::error::CreateInvitationsError,
                crate::input::CreateInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p>Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends the invitation (as an email message) to the email address that you specified for the recipient's account when you associated the account with your account. The default value is false.</p>
        pub fn disable_email_notification(mut self, input: bool) -> Self {
            self.inner = self.inner.disable_email_notification(input);
            self
        }
        /// <p>Specifies whether to send the invitation as an email message. If this value is false, Amazon Macie sends the invitation (as an email message) to the email address that you specified for the recipient's account when you associated the account with your account. The default value is false.</p>
        pub fn set_disable_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_email_notification(input);
            self
        }
        /// <p>Custom text to include in the email message that contains the invitation. The text can contain as many as 80 alphanumeric characters.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message(input.into());
            self
        }
        /// <p>Custom text to include in the email message that contains the invitation. The text can contain as many as 80 alphanumeric characters.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMember`.
    ///
    /// <p>Associates an account with an Amazon Macie administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_member_input::Builder,
    }
    impl<C, M, R> CreateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMemberInputOperationOutputAlias,
                crate::output::CreateMemberOutput,
                crate::error::CreateMemberError,
                crate::input::CreateMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details of the account to associate with the administrator account.</p>
        pub fn account(mut self, input: crate::model::AccountDetail) -> Self {
            self.inner = self.inner.account(input);
            self
        }
        /// <p>The details of the account to associate with the administrator account.</p>
        pub fn set_account(
            mut self,
            input: std::option::Option<crate::model::AccountDetail>,
        ) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p>
        /// <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p>
        /// <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSampleFindings`.
    ///
    /// <p>Creates sample findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateSampleFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sample_findings_input::Builder,
    }
    impl<C, M, R> CreateSampleFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSampleFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSampleFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSampleFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSampleFindingsInputOperationOutputAlias,
                crate::output::CreateSampleFindingsOutput,
                crate::error::CreateSampleFindingsError,
                crate::input::CreateSampleFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingTypes`.
        ///
        /// To override the contents of this collection use [`set_finding_types`](Self::set_finding_types).
        ///
        /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
        pub fn finding_types(mut self, input: crate::model::FindingType) -> Self {
            self.inner = self.inner.finding_types(input);
            self
        }
        /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
        pub fn set_finding_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingType>>,
        ) -> Self {
            self.inner = self.inner.set_finding_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeclineInvitations`.
    ///
    /// <p>Declines Amazon Macie membership invitations that were received from specific accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeclineInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::decline_invitations_input::Builder,
    }
    impl<C, M, R> DeclineInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeclineInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeclineInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeclineInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeclineInvitationsInputOperationOutputAlias,
                crate::output::DeclineInvitationsOutput,
                crate::error::DeclineInvitationsError,
                crate::input::DeclineInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomDataIdentifier`.
    ///
    /// <p>Soft deletes a custom data identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> DeleteCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomDataIdentifierInputOperationOutputAlias,
                crate::output::DeleteCustomDataIdentifierOutput,
                crate::error::DeleteCustomDataIdentifierError,
                crate::input::DeleteCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFindingsFilter`.
    ///
    /// <p>Deletes a findings filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_findings_filter_input::Builder,
    }
    impl<C, M, R> DeleteFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFindingsFilterInputOperationOutputAlias,
                crate::output::DeleteFindingsFilterOutput,
                crate::error::DeleteFindingsFilterError,
                crate::input::DeleteFindingsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInvitations`.
    ///
    /// <p>Deletes Amazon Macie membership invitations that were received from specific accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_invitations_input::Builder,
    }
    impl<C, M, R> DeleteInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInvitationsInputOperationOutputAlias,
                crate::output::DeleteInvitationsOutput,
                crate::error::DeleteInvitationsError,
                crate::input::DeleteInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(input.into());
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMember`.
    ///
    /// <p>Deletes the association between an Amazon Macie administrator account and an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_member_input::Builder,
    }
    impl<C, M, R> DeleteMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMemberInputOperationOutputAlias,
                crate::output::DeleteMemberOutput,
                crate::error::DeleteMemberError,
                crate::input::DeleteMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBuckets`.
    ///
    /// <p>Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBuckets<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_buckets_input::Builder,
    }
    impl<C, M, R> DescribeBuckets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBuckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBucketsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBucketsInputOperationOutputAlias,
                crate::output::DescribeBucketsOutput,
                crate::error::DescribeBucketsError,
                crate::input::DescribeBucketsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBucketsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBucketsPaginator<C, M, R> {
            crate::paginator::DescribeBucketsPaginator::new(self.handle, self.inner)
        }
        /// Adds a key-value pair to `criteria`.
        ///
        /// To override the contents of this collection use [`set_criteria`](Self::set_criteria).
        ///
        /// <p>The criteria to use to filter the query results.</p>
        pub fn criteria(
            mut self,
            k: impl Into<std::string::String>,
            v: crate::model::BucketCriteriaAdditionalProperties,
        ) -> Self {
            self.inner = self.inner.criteria(k.into(), v);
            self
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn set_criteria(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BucketCriteriaAdditionalProperties,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_criteria(mut self, input: crate::model::BucketSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::BucketSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClassificationJob`.
    ///
    /// <p>Retrieves the status and settings for a classification job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_classification_job_input::Builder,
    }
    impl<C, M, R> DescribeClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClassificationJobInputOperationOutputAlias,
                crate::output::DescribeClassificationJobOutput,
                crate::error::DescribeClassificationJobError,
                crate::input::DescribeClassificationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Retrieves the Amazon Macie configuration settings for an organization in Organizations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigurationInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigurationOutput,
                crate::error::DescribeOrganizationConfigurationError,
                crate::input::DescribeOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableMacie`.
    ///
    /// <p>Disables Amazon Macie and deletes all settings and resources for a Macie account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableMacie<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_macie_input::Builder,
    }
    impl<C, M, R> DisableMacie<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableMacie`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableMacieOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableMacieError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableMacieInputOperationOutputAlias,
                crate::output::DisableMacieOutput,
                crate::error::DisableMacieError,
                crate::input::DisableMacieInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableOrganizationAdminAccount`.
    ///
    /// <p>Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> DisableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::DisableOrganizationAdminAccountOutput,
                crate::error::DisableOrganizationAdminAccountError,
                crate::input::DisableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromAdministratorAccount`.
    ///
    /// <p>Disassociates a member account from its Amazon Macie administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFromAdministratorAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_administrator_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromAdministratorAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromAdministratorAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromAdministratorAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateFromAdministratorAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromAdministratorAccountInputOperationOutputAlias,
                crate::output::DisassociateFromAdministratorAccountOutput,
                crate::error::DisassociateFromAdministratorAccountError,
                crate::input::DisassociateFromAdministratorAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromMasterAccount`.
    ///
    /// <p>(Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the
    /// <link linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateFromMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_master_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFromMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromMasterAccountInputOperationOutputAlias,
                crate::output::DisassociateFromMasterAccountOutput,
                crate::error::DisassociateFromMasterAccountError,
                crate::input::DisassociateFromMasterAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateMember`.
    ///
    /// <p>Disassociates an Amazon Macie administrator account from a member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_member_input::Builder,
    }
    impl<C, M, R> DisassociateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMemberInputOperationOutputAlias,
                crate::output::DisassociateMemberOutput,
                crate::error::DisassociateMemberError,
                crate::input::DisassociateMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableMacie`.
    ///
    /// <p>Enables Amazon Macie and specifies the configuration settings for a Macie account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableMacie<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_macie_input::Builder,
    }
    impl<C, M, R> EnableMacie<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableMacie`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableMacieOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableMacieError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableMacieInputOperationOutputAlias,
                crate::output::EnableMacieOutput,
                crate::error::EnableMacieError,
                crate::input::EnableMacieInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn finding_publishing_frequency(
            mut self,
            input: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.inner = self.inner.finding_publishing_frequency(input);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.inner = self.inner.set_finding_publishing_frequency(input);
            self
        }
        /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
        pub fn status(mut self, input: crate::model::MacieStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableOrganizationAdminAccount`.
    ///
    /// <p>Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct EnableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> EnableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::EnableOrganizationAdminAccountOutput,
                crate::error::EnableOrganizationAdminAccountError,
                crate::input::EnableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAdministratorAccount`.
    ///
    /// <p>Retrieves information about the Amazon Macie administrator account for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetAdministratorAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_administrator_account_input::Builder,
    }
    impl<C, M, R> GetAdministratorAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAdministratorAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAdministratorAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAdministratorAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAdministratorAccountInputOperationOutputAlias,
                crate::output::GetAdministratorAccountOutput,
                crate::error::GetAdministratorAccountError,
                crate::input::GetAdministratorAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetBucketStatistics`.
    ///
    /// <p>Retrieves (queries) aggregated statistical data about S3 buckets that Amazon Macie monitors and analyzes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBucketStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_statistics_input::Builder,
    }
    impl<C, M, R> GetBucketStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketStatisticsInputOperationOutputAlias,
                crate::output::GetBucketStatisticsOutput,
                crate::error::GetBucketStatisticsError,
                crate::input::GetBucketStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClassificationExportConfiguration`.
    ///
    /// <p>Retrieves the configuration settings for storing data classification results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetClassificationExportConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_classification_export_configuration_input::Builder,
    }
    impl<C, M, R> GetClassificationExportConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClassificationExportConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClassificationExportConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetClassificationExportConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClassificationExportConfigurationInputOperationOutputAlias,
                crate::output::GetClassificationExportConfigurationOutput,
                crate::error::GetClassificationExportConfigurationError,
                crate::input::GetClassificationExportConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetCustomDataIdentifier`.
    ///
    /// <p>Retrieves the criteria and other settings for a custom data identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> GetCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCustomDataIdentifierInputOperationOutputAlias,
                crate::output::GetCustomDataIdentifierOutput,
                crate::error::GetCustomDataIdentifierError,
                crate::input::GetCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindings`.
    ///
    /// <p>Retrieves the details of one or more findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_input::Builder,
    }
    impl<C, M, R> GetFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsInputOperationOutputAlias,
                crate::output::GetFindingsOutput,
                crate::error::GetFindingsError,
                crate::input::GetFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingIds`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_ids(input.into());
            self
        }
        /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_ids(input);
            self
        }
        /// <p>The criteria for sorting the results of the request.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The criteria for sorting the results of the request.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingsFilter`.
    ///
    /// <p>Retrieves the criteria and other settings for a findings filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_filter_input::Builder,
    }
    impl<C, M, R> GetFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsFilterInputOperationOutputAlias,
                crate::output::GetFindingsFilterOutput,
                crate::error::GetFindingsFilterError,
                crate::input::GetFindingsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingsPublicationConfiguration`.
    ///
    /// <p>Retrieves the configuration settings for publishing findings to Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingsPublicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_publication_configuration_input::Builder,
    }
    impl<C, M, R> GetFindingsPublicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsPublicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsPublicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetFindingsPublicationConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsPublicationConfigurationInputOperationOutputAlias,
                crate::output::GetFindingsPublicationConfigurationOutput,
                crate::error::GetFindingsPublicationConfigurationError,
                crate::input::GetFindingsPublicationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetFindingStatistics`.
    ///
    /// <p>Retrieves (queries) aggregated statistical data about findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetFindingStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_finding_statistics_input::Builder,
    }
    impl<C, M, R> GetFindingStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingStatisticsInputOperationOutputAlias,
                crate::output::GetFindingStatisticsOutput,
                crate::error::GetFindingStatisticsError,
                crate::input::GetFindingStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(input);
            self
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The finding property to use to group the query results. Valid values are:</p>
        /// <ul>
        /// <li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li>
        /// <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li>
        /// <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li>
        /// <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li>
        /// </ul>
        pub fn group_by(mut self, input: crate::model::GroupBy) -> Self {
            self.inner = self.inner.group_by(input);
            self
        }
        /// <p>The finding property to use to group the query results. Valid values are:</p>
        /// <ul>
        /// <li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li>
        /// <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li>
        /// <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li>
        /// <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li>
        /// </ul>
        pub fn set_group_by(mut self, input: std::option::Option<crate::model::GroupBy>) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.inner = self.inner.size(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_size(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_criteria(mut self, input: crate::model::FindingStatisticsSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingStatisticsSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvitationsCount`.
    ///
    /// <p>Retrieves the count of Amazon Macie membership invitations that were received by an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetInvitationsCount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_invitations_count_input::Builder,
    }
    impl<C, M, R> GetInvitationsCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInvitationsCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvitationsCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvitationsCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInvitationsCountInputOperationOutputAlias,
                crate::output::GetInvitationsCountOutput,
                crate::error::GetInvitationsCountError,
                crate::input::GetInvitationsCountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMacieSession`.
    ///
    /// <p>Retrieves the current status and configuration settings for an Amazon Macie account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMacieSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_macie_session_input::Builder,
    }
    impl<C, M, R> GetMacieSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMacieSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMacieSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMacieSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMacieSessionInputOperationOutputAlias,
                crate::output::GetMacieSessionOutput,
                crate::error::GetMacieSessionError,
                crate::input::GetMacieSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMasterAccount`.
    ///
    /// <p>(Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the
    /// <link linkend="GetAdministratorAccount">GetAdministratorAccount operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_master_account_input::Builder,
    }
    impl<C, M, R> GetMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMasterAccountInputOperationOutputAlias,
                crate::output::GetMasterAccountOutput,
                crate::error::GetMasterAccountError,
                crate::input::GetMasterAccountInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMember`.
    ///
    /// <p>Retrieves information about an account that's associated with an Amazon Macie administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMember<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_member_input::Builder,
    }
    impl<C, M, R> GetMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMemberInputOperationOutputAlias,
                crate::output::GetMemberOutput,
                crate::error::GetMemberError,
                crate::input::GetMemberInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsageStatistics`.
    ///
    /// <p>Retrieves (queries) quotas and aggregated usage data for one or more accounts.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsageStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_statistics_input::Builder,
    }
    impl<C, M, R> GetUsageStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsageStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageStatisticsInputOperationOutputAlias,
                crate::output::GetUsageStatisticsOutput,
                crate::error::GetUsageStatisticsError,
                crate::input::GetUsageStatisticsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::GetUsageStatisticsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::GetUsageStatisticsPaginator<C, M, R> {
            crate::paginator::GetUsageStatisticsPaginator::new(self.handle, self.inner)
        }
        /// Appends an item to `filterBy`.
        ///
        /// To override the contents of this collection use [`set_filter_by`](Self::set_filter_by).
        ///
        /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
        pub fn filter_by(mut self, input: crate::model::UsageStatisticsFilter) -> Self {
            self.inner = self.inner.filter_by(input);
            self
        }
        /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
        pub fn set_filter_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageStatisticsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filter_by(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_by(mut self, input: crate::model::UsageStatisticsSortBy) -> Self {
            self.inner = self.inner.sort_by(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticsSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
        pub fn time_range(mut self, input: crate::model::TimeRange) -> Self {
            self.inner = self.inner.time_range(input);
            self
        }
        /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
        pub fn set_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_time_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsageTotals`.
    ///
    /// <p>Retrieves (queries) aggregated usage data for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetUsageTotals<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_totals_input::Builder,
    }
    impl<C, M, R> GetUsageTotals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsageTotals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageTotalsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageTotalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageTotalsInputOperationOutputAlias,
                crate::output::GetUsageTotalsOutput,
                crate::error::GetUsageTotalsError,
                crate::input::GetUsageTotalsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
        pub fn time_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_range(input.into());
            self
        }
        /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
        pub fn set_time_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClassificationJobs`.
    ///
    /// <p>Retrieves a subset of information about one or more classification jobs.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListClassificationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_classification_jobs_input::Builder,
    }
    impl<C, M, R> ListClassificationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListClassificationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClassificationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClassificationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListClassificationJobsInputOperationOutputAlias,
                crate::output::ListClassificationJobsOutput,
                crate::error::ListClassificationJobsError,
                crate::input::ListClassificationJobsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListClassificationJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListClassificationJobsPaginator<C, M, R> {
            crate::paginator::ListClassificationJobsPaginator::new(self.handle, self.inner)
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn filter_criteria(mut self, input: crate::model::ListJobsFilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(input);
            self
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::ListJobsFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, input: crate::model::ListJobsSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::ListJobsSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomDataIdentifiers`.
    ///
    /// <p>Retrieves a subset of information about all the custom data identifiers for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListCustomDataIdentifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_data_identifiers_input::Builder,
    }
    impl<C, M, R> ListCustomDataIdentifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomDataIdentifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomDataIdentifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomDataIdentifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomDataIdentifiersInputOperationOutputAlias,
                crate::output::ListCustomDataIdentifiersOutput,
                crate::error::ListCustomDataIdentifiersError,
                crate::input::ListCustomDataIdentifiersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListCustomDataIdentifiersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListCustomDataIdentifiersPaginator<C, M, R> {
            crate::paginator::ListCustomDataIdentifiersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Retrieves a subset of information about one or more findings.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl<C, M, R> ListFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsInputOperationOutputAlias,
                crate::output::ListFindingsOutput,
                crate::error::ListFindingsError,
                crate::input::ListFindingsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsPaginator<C, M, R> {
            crate::paginator::ListFindingsPaginator::new(self.handle, self.inner)
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(input);
            self
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindingsFilters`.
    ///
    /// <p>Retrieves a subset of information about all the findings filters for an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListFindingsFilters<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_filters_input::Builder,
    }
    impl<C, M, R> ListFindingsFilters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindingsFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsFiltersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsFiltersInputOperationOutputAlias,
                crate::output::ListFindingsFiltersOutput,
                crate::error::ListFindingsFiltersError,
                crate::input::ListFindingsFiltersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListFindingsFiltersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListFindingsFiltersPaginator<C, M, R> {
            crate::paginator::ListFindingsFiltersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Retrieves information about the Amazon Macie membership invitations that were received by an account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl<C, M, R> ListInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInvitationsInputOperationOutputAlias,
                crate::output::ListInvitationsOutput,
                crate::error::ListInvitationsError,
                crate::input::ListInvitationsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListInvitationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListInvitationsPaginator<C, M, R> {
            crate::paginator::ListInvitationsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedDataIdentifiers`.
    ///
    /// <p>Retrieves information about all the managed data identifiers that Amazon Macie currently provides.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListManagedDataIdentifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_managed_data_identifiers_input::Builder,
    }
    impl<C, M, R> ListManagedDataIdentifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListManagedDataIdentifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedDataIdentifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedDataIdentifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListManagedDataIdentifiersInputOperationOutputAlias,
                crate::output::ListManagedDataIdentifiersOutput,
                crate::error::ListManagedDataIdentifiersError,
                crate::input::ListManagedDataIdentifiersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Retrieves information about the accounts that are associated with an Amazon Macie administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_members_input::Builder,
    }
    impl<C, M, R> ListMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMembersInputOperationOutputAlias,
                crate::output::ListMembersOutput,
                crate::error::ListMembersError,
                crate::input::ListMembersInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMembersPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMembersPaginator<C, M, R> {
            crate::paginator::ListMembersPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
        pub fn only_associated(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.only_associated(input.into());
            self
        }
        /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
        pub fn set_only_associated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_only_associated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationAdminAccounts`.
    ///
    /// <p>Retrieves information about the delegated Amazon Macie administrator account for an organization in Organizations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListOrganizationAdminAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organization_admin_accounts_input::Builder,
    }
    impl<C, M, R> ListOrganizationAdminAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationAdminAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationAdminAccountsInputOperationOutputAlias,
                crate::output::ListOrganizationAdminAccountsOutput,
                crate::error::ListOrganizationAdminAccountsError,
                crate::input::ListOrganizationAdminAccountsInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListOrganizationAdminAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(
            self,
        ) -> crate::paginator::ListOrganizationAdminAccountsPaginator<C, M, R> {
            crate::paginator::ListOrganizationAdminAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutClassificationExportConfiguration`.
    ///
    /// <p>Creates or updates the configuration settings for storing data classification results.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutClassificationExportConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_classification_export_configuration_input::Builder,
    }
    impl<C, M, R> PutClassificationExportConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutClassificationExportConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutClassificationExportConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutClassificationExportConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutClassificationExportConfigurationInputOperationOutputAlias,
                crate::output::PutClassificationExportConfigurationOutput,
                crate::error::PutClassificationExportConfigurationError,
                crate::input::PutClassificationExportConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
        pub fn configuration(
            mut self,
            input: crate::model::ClassificationExportConfiguration,
        ) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClassificationExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFindingsPublicationConfiguration`.
    ///
    /// <p>Updates the configuration settings for publishing findings to Security Hub.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct PutFindingsPublicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_findings_publication_configuration_input::Builder,
    }
    impl<C, M, R> PutFindingsPublicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFindingsPublicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFindingsPublicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutFindingsPublicationConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFindingsPublicationConfigurationInputOperationOutputAlias,
                crate::output::PutFindingsPublicationConfigurationOutput,
                crate::error::PutFindingsPublicationConfigurationError,
                crate::input::PutFindingsPublicationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
        pub fn security_hub_configuration(
            mut self,
            input: crate::model::SecurityHubConfiguration,
        ) -> Self {
            self.inner = self.inner.security_hub_configuration(input);
            self
        }
        /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
        pub fn set_security_hub_configuration(
            mut self,
            input: std::option::Option<crate::model::SecurityHubConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_security_hub_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchResources`.
    ///
    /// <p>Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct SearchResources<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_resources_input::Builder,
    }
    impl<C, M, R> SearchResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchResourcesInputOperationOutputAlias,
                crate::output::SearchResourcesOutput,
                crate::error::SearchResourcesError,
                crate::input::SearchResourcesInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::SearchResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::SearchResourcesPaginator<C, M, R> {
            crate::paginator::SearchResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
        pub fn bucket_criteria(
            mut self,
            input: crate::model::SearchResourcesBucketCriteria,
        ) -> Self {
            self.inner = self.inner.bucket_criteria(input);
            self
        }
        /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
        pub fn set_bucket_criteria(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesBucketCriteria>,
        ) -> Self {
            self.inner = self.inner.set_bucket_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, input: crate::model::SearchResourcesSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p>
        /// <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k.into(), v.into());
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p>
        /// <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestCustomDataIdentifier`.
    ///
    /// <p>Tests a custom data identifier.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TestCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> TestCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::TestCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestCustomDataIdentifierInputOperationOutputAlias,
                crate::output::TestCustomDataIdentifierOutput,
                crate::error::TestCustomDataIdentifierError,
                crate::input::TestCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ignoreWords`.
        ///
        /// To override the contents of this collection use [`set_ignore_words`](Self::set_ignore_words).
        ///
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn ignore_words(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ignore_words(input.into());
            self
        }
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn set_ignore_words(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ignore_words(input);
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(input.into());
            self
        }
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn maximum_match_distance(mut self, input: i32) -> Self {
            self.inner = self.inner.maximum_match_distance(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn set_maximum_match_distance(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_match_distance(input);
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex(input.into());
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_regex(input);
            self
        }
        /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
        pub fn sample_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_text(input.into());
            self
        }
        /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
        pub fn set_sample_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sample_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClassificationJob`.
    ///
    /// <p>Changes the status of a classification job.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_classification_job_input::Builder,
    }
    impl<C, M, R> UpdateClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClassificationJobInputOperationOutputAlias,
                crate::output::UpdateClassificationJobOutput,
                crate::error::UpdateClassificationJobError,
                crate::input::UpdateClassificationJobInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(input.into());
            self
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The new status for the job. Valid values are:</p>
        /// <ul>
        /// <li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li>
        /// <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li>
        /// <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li>
        /// </ul>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_status(input);
            self
        }
        /// <p>The new status for the job. Valid values are:</p>
        /// <ul>
        /// <li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li>
        /// <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li>
        /// <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li>
        /// </ul>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindingsFilter`.
    ///
    /// <p>Updates the criteria and other settings for a findings filter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_findings_filter_input::Builder,
    }
    impl<C, M, R> UpdateFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFindingsFilterInputOperationOutputAlias,
                crate::output::UpdateFindingsFilterOutput,
                crate::error::UpdateFindingsFilterError,
                crate::input::UpdateFindingsFilterInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, input: crate::model::FindingsFilterAction) -> Self {
            self.inner = self.inner.action(input);
            self
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(input.into());
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p>
        /// <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn position(mut self, input: i32) -> Self {
            self.inner = self.inner.position(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn set_position(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMacieSession`.
    ///
    /// <p>Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMacieSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_macie_session_input::Builder,
    }
    impl<C, M, R> UpdateMacieSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMacieSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMacieSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMacieSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMacieSessionInputOperationOutputAlias,
                crate::output::UpdateMacieSessionOutput,
                crate::error::UpdateMacieSessionError,
                crate::input::UpdateMacieSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn finding_publishing_frequency(
            mut self,
            input: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.inner = self.inner.finding_publishing_frequency(input);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.inner = self.inner.set_finding_publishing_frequency(input);
            self
        }
        /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn status(mut self, input: crate::model::MacieStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMemberSession`.
    ///
    /// <p>Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMemberSession<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_member_session_input::Builder,
    }
    impl<C, M, R> UpdateMemberSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMemberSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMemberSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMemberSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMemberSessionInputOperationOutputAlias,
                crate::output::UpdateMemberSessionOutput,
                crate::error::UpdateMemberSessionError,
                crate::input::UpdateMemberSessionInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn status(mut self, input: crate::model::MacieStatus) -> Self {
            self.inner = self.inner.status(input);
            self
        }
        /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Updates the Amazon Macie configuration settings for an organization in Organizations.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = crate::middleware::DefaultMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl<C, M, R> UpdateOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOrganizationConfigurationInputOperationOutputAlias,
                crate::output::UpdateOrganizationConfigurationOutput,
                crate::error::UpdateOrganizationConfigurationError,
                crate::input::UpdateOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to enable Amazon Macie automatically for an account when the account is added to the organization in Organizations.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.inner = self.inner.auto_enable(input);
            self
        }
        /// <p>Specifies whether to enable Amazon Macie automatically for an account when the account is added to the organization in Organizations.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
    }
}

impl<C> Client<C, crate::middleware::DefaultMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(conn)
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        crate::middleware::DefaultMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https()
            .middleware(crate::middleware::DefaultMiddleware::new());
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
