// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
pub mod accept_invitation_input {
    /// A builder for [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) administrator_account_id: std::option::Option<std::string::String>,
        pub(crate) invitation_id: std::option::Option<std::string::String>,
        pub(crate) master_account: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn administrator_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.administrator_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn set_administrator_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.administrator_account_id = input;
            self
        }
        /// <p>The unique identifier for the invitation to accept.</p>
        pub fn invitation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.invitation_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the invitation to accept.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.invitation_id = input;
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn master_account(mut self, input: impl Into<std::string::String>) -> Self {
            self.master_account = Some(input.into());
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn set_master_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.master_account = input;
            self
        }
        /// Consumes the builder and constructs a [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::AcceptInvitationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::AcceptInvitationInput {
                administrator_account_id: self.administrator_account_id,
                invitation_id: self.invitation_id,
                master_account: self.master_account,
            })
        }
    }
}
#[doc(hidden)]
pub type AcceptInvitationInputOperationOutputAlias = crate::operation::AcceptInvitation;
#[doc(hidden)]
pub type AcceptInvitationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AcceptInvitationInput {
    /// Consumes the builder and constructs an Operation<[`AcceptInvitation`](crate::operation::AcceptInvitation)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AcceptInvitation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AcceptInvitationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/accept").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AcceptInvitationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AcceptInvitationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_accept_invitation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::AcceptInvitation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "AcceptInvitation",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
}

/// See [`BatchGetCustomDataIdentifiersInput`](crate::input::BatchGetCustomDataIdentifiersInput)
pub mod batch_get_custom_data_identifiers_input {
    /// A builder for [`BatchGetCustomDataIdentifiersInput`](crate::input::BatchGetCustomDataIdentifiersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
        pub fn ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ids.unwrap_or_default();
            v.push(input.into());
            self.ids = Some(v);
            self
        }
        /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ids = input;
            self
        }
        /// Consumes the builder and constructs a [`BatchGetCustomDataIdentifiersInput`](crate::input::BatchGetCustomDataIdentifiersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::BatchGetCustomDataIdentifiersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::BatchGetCustomDataIdentifiersInput { ids: self.ids })
        }
    }
}
#[doc(hidden)]
pub type BatchGetCustomDataIdentifiersInputOperationOutputAlias =
    crate::operation::BatchGetCustomDataIdentifiers;
#[doc(hidden)]
pub type BatchGetCustomDataIdentifiersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl BatchGetCustomDataIdentifiersInput {
    /// Consumes the builder and constructs an Operation<[`BatchGetCustomDataIdentifiers`](crate::operation::BatchGetCustomDataIdentifiers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::BatchGetCustomDataIdentifiers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::BatchGetCustomDataIdentifiersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/custom-data-identifiers/get").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::BatchGetCustomDataIdentifiersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::BatchGetCustomDataIdentifiersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_batch_get_custom_data_identifiers(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::BatchGetCustomDataIdentifiers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "BatchGetCustomDataIdentifiers",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`BatchGetCustomDataIdentifiersInput`](crate::input::BatchGetCustomDataIdentifiersInput)
    pub fn builder() -> crate::input::batch_get_custom_data_identifiers_input::Builder {
        crate::input::batch_get_custom_data_identifiers_input::Builder::default()
    }
}

/// See [`CreateClassificationJobInput`](crate::input::CreateClassificationJobInput)
pub mod create_classification_job_input {
    /// A builder for [`CreateClassificationJobInput`](crate::input::CreateClassificationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) custom_data_identifier_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) initial_run: std::option::Option<bool>,
        pub(crate) job_type: std::option::Option<crate::model::JobType>,
        pub(crate) managed_data_identifier_ids:
            std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) managed_data_identifier_selector:
            std::option::Option<crate::model::ManagedDataIdentifierSelector>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) s3_job_definition: std::option::Option<crate::model::S3JobDefinition>,
        pub(crate) sampling_percentage: std::option::Option<i32>,
        pub(crate) schedule_frequency: std::option::Option<crate::model::JobScheduleFrequency>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Appends an item to `custom_data_identifier_ids`.
        ///
        /// To override the contents of this collection use [`set_custom_data_identifier_ids`](Self::set_custom_data_identifier_ids).
        ///
        /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
        pub fn custom_data_identifier_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.custom_data_identifier_ids.unwrap_or_default();
            v.push(input.into());
            self.custom_data_identifier_ids = Some(v);
            self
        }
        /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
        pub fn set_custom_data_identifier_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.custom_data_identifier_ids = input;
            self
        }
        /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p><p>If you configure the job to run only once, don't specify a value for this property.</p>
        pub fn initial_run(mut self, input: bool) -> Self {
            self.initial_run = Some(input);
            self
        }
        /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p><p>If you configure the job to run only once, don't specify a value for this property.</p>
        pub fn set_initial_run(mut self, input: std::option::Option<bool>) -> Self {
            self.initial_run = input;
            self
        }
        /// <p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li></ul>
        pub fn job_type(mut self, input: crate::model::JobType) -> Self {
            self.job_type = Some(input);
            self
        }
        /// <p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li></ul>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.job_type = input;
            self
        }
        /// Appends an item to `managed_data_identifier_ids`.
        ///
        /// To override the contents of this collection use [`set_managed_data_identifier_ids`](Self::set_managed_data_identifier_ids).
        ///
        /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p><p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
        pub fn managed_data_identifier_ids(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            let mut v = self.managed_data_identifier_ids.unwrap_or_default();
            v.push(input.into());
            self.managed_data_identifier_ids = Some(v);
            self
        }
        /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p><p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
        pub fn set_managed_data_identifier_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.managed_data_identifier_ids = input;
            self
        }
        /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
        pub fn managed_data_identifier_selector(
            mut self,
            input: crate::model::ManagedDataIdentifierSelector,
        ) -> Self {
            self.managed_data_identifier_selector = Some(input);
            self
        }
        /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
        pub fn set_managed_data_identifier_selector(
            mut self,
            input: std::option::Option<crate::model::ManagedDataIdentifierSelector>,
        ) -> Self {
            self.managed_data_identifier_selector = input;
            self
        }
        /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
        pub fn s3_job_definition(mut self, input: crate::model::S3JobDefinition) -> Self {
            self.s3_job_definition = Some(input);
            self
        }
        /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
        pub fn set_s3_job_definition(
            mut self,
            input: std::option::Option<crate::model::S3JobDefinition>,
        ) -> Self {
            self.s3_job_definition = input;
            self
        }
        /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
        pub fn sampling_percentage(mut self, input: i32) -> Self {
            self.sampling_percentage = Some(input);
            self
        }
        /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
        pub fn set_sampling_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.sampling_percentage = input;
            self
        }
        /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
        pub fn schedule_frequency(mut self, input: crate::model::JobScheduleFrequency) -> Self {
            self.schedule_frequency = Some(input);
            self
        }
        /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
        pub fn set_schedule_frequency(
            mut self,
            input: std::option::Option<crate::model::JobScheduleFrequency>,
        ) -> Self {
            self.schedule_frequency = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateClassificationJobInput`](crate::input::CreateClassificationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateClassificationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateClassificationJobInput {
                client_token: self.client_token,
                custom_data_identifier_ids: self.custom_data_identifier_ids,
                description: self.description,
                initial_run: self.initial_run.unwrap_or_default(),
                job_type: self.job_type,
                managed_data_identifier_ids: self.managed_data_identifier_ids,
                managed_data_identifier_selector: self.managed_data_identifier_selector,
                name: self.name,
                s3_job_definition: self.s3_job_definition,
                sampling_percentage: self.sampling_percentage.unwrap_or_default(),
                schedule_frequency: self.schedule_frequency,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateClassificationJobInputOperationOutputAlias =
    crate::operation::CreateClassificationJob;
#[doc(hidden)]
pub type CreateClassificationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateClassificationJobInput {
    /// Consumes the builder and constructs an Operation<[`CreateClassificationJob`](crate::operation::CreateClassificationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateClassificationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateClassificationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/jobs").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateClassificationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateClassificationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_classification_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateClassificationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateClassificationJob",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateClassificationJobInput`](crate::input::CreateClassificationJobInput)
    pub fn builder() -> crate::input::create_classification_job_input::Builder {
        crate::input::create_classification_job_input::Builder::default()
    }
}

/// See [`CreateCustomDataIdentifierInput`](crate::input::CreateCustomDataIdentifierInput)
pub mod create_custom_data_identifier_input {
    /// A builder for [`CreateCustomDataIdentifierInput`](crate::input::CreateCustomDataIdentifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) ignore_words: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) keywords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) maximum_match_distance: std::option::Option<i32>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) regex: std::option::Option<std::string::String>,
        pub(crate) severity_levels: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// Appends an item to `ignore_words`.
        ///
        /// To override the contents of this collection use [`set_ignore_words`](Self::set_ignore_words).
        ///
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn ignore_words(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ignore_words.unwrap_or_default();
            v.push(input.into());
            self.ignore_words = Some(v);
            self
        }
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn set_ignore_words(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ignore_words = input;
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keywords.unwrap_or_default();
            v.push(input.into());
            self.keywords = Some(v);
            self
        }
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keywords = input;
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn maximum_match_distance(mut self, input: i32) -> Self {
            self.maximum_match_distance = Some(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn set_maximum_match_distance(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_match_distance = input;
            self
        }
        /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex = Some(input.into());
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.regex = input;
            self
        }
        /// Appends an item to `severity_levels`.
        ///
        /// To override the contents of this collection use [`set_severity_levels`](Self::set_severity_levels).
        ///
        /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p> <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
        pub fn severity_levels(mut self, input: impl Into<crate::model::SeverityLevel>) -> Self {
            let mut v = self.severity_levels.unwrap_or_default();
            v.push(input.into());
            self.severity_levels = Some(v);
            self
        }
        /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p> <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
        pub fn set_severity_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
        ) -> Self {
            self.severity_levels = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateCustomDataIdentifierInput`](crate::input::CreateCustomDataIdentifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateCustomDataIdentifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateCustomDataIdentifierInput {
                client_token: self.client_token,
                description: self.description,
                ignore_words: self.ignore_words,
                keywords: self.keywords,
                maximum_match_distance: self.maximum_match_distance.unwrap_or_default(),
                name: self.name,
                regex: self.regex,
                severity_levels: self.severity_levels,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateCustomDataIdentifierInputOperationOutputAlias =
    crate::operation::CreateCustomDataIdentifier;
#[doc(hidden)]
pub type CreateCustomDataIdentifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateCustomDataIdentifierInput {
    /// Consumes the builder and constructs an Operation<[`CreateCustomDataIdentifier`](crate::operation::CreateCustomDataIdentifier)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateCustomDataIdentifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateCustomDataIdentifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/custom-data-identifiers").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateCustomDataIdentifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateCustomDataIdentifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_custom_data_identifier(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateCustomDataIdentifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateCustomDataIdentifier",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateCustomDataIdentifierInput`](crate::input::CreateCustomDataIdentifierInput)
    pub fn builder() -> crate::input::create_custom_data_identifier_input::Builder {
        crate::input::create_custom_data_identifier_input::Builder::default()
    }
}

/// See [`CreateFindingsFilterInput`](crate::input::CreateFindingsFilterInput)
pub mod create_findings_filter_input {
    /// A builder for [`CreateFindingsFilterInput`](crate::input::CreateFindingsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::FindingsFilterAction>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<i32>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, input: crate::model::FindingsFilterAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn position(mut self, input: i32) -> Self {
            self.position = Some(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn set_position(mut self, input: std::option::Option<i32>) -> Self {
            self.position = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateFindingsFilterInput`](crate::input::CreateFindingsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateFindingsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateFindingsFilterInput {
                action: self.action,
                client_token: self.client_token,
                description: self.description,
                finding_criteria: self.finding_criteria,
                name: self.name,
                position: self.position.unwrap_or_default(),
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateFindingsFilterInputOperationOutputAlias = crate::operation::CreateFindingsFilter;
#[doc(hidden)]
pub type CreateFindingsFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateFindingsFilterInput {
    /// Consumes the builder and constructs an Operation<[`CreateFindingsFilter`](crate::operation::CreateFindingsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateFindingsFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateFindingsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findingsfilters").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateFindingsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateFindingsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_findings_filter(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateFindingsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateFindingsFilter",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateFindingsFilterInput`](crate::input::CreateFindingsFilterInput)
    pub fn builder() -> crate::input::create_findings_filter_input::Builder {
        crate::input::create_findings_filter_input::Builder::default()
    }
}

/// See [`CreateInvitationsInput`](crate::input::CreateInvitationsInput)
pub mod create_invitations_input {
    /// A builder for [`CreateInvitationsInput`](crate::input::CreateInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) disable_email_notification: std::option::Option<bool>,
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// <p>Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true.</p>
        pub fn disable_email_notification(mut self, input: bool) -> Self {
            self.disable_email_notification = Some(input);
            self
        }
        /// <p>Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true.</p>
        pub fn set_disable_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.disable_email_notification = input;
            self
        }
        /// <p>A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateInvitationsInput`](crate::input::CreateInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateInvitationsInput {
                account_ids: self.account_ids,
                disable_email_notification: self.disable_email_notification.unwrap_or_default(),
                message: self.message,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateInvitationsInputOperationOutputAlias = crate::operation::CreateInvitations;
#[doc(hidden)]
pub type CreateInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`CreateInvitations`](crate::operation::CreateInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateInvitations",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateInvitationsInput`](crate::input::CreateInvitationsInput)
    pub fn builder() -> crate::input::create_invitations_input::Builder {
        crate::input::create_invitations_input::Builder::default()
    }
}

/// See [`CreateMemberInput`](crate::input::CreateMemberInput)
pub mod create_member_input {
    /// A builder for [`CreateMemberInput`](crate::input::CreateMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account: std::option::Option<crate::model::AccountDetail>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The details of the account to associate with the administrator account.</p>
        pub fn account(mut self, input: crate::model::AccountDetail) -> Self {
            self.account = Some(input);
            self
        }
        /// <p>The details of the account to associate with the administrator account.</p>
        pub fn set_account(
            mut self,
            input: std::option::Option<crate::model::AccountDetail>,
        ) -> Self {
            self.account = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMemberInput`](crate::input::CreateMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMemberInput {
                account: self.account,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMemberInputOperationOutputAlias = crate::operation::CreateMember;
#[doc(hidden)]
pub type CreateMemberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMemberInput {
    /// Consumes the builder and constructs an Operation<[`CreateMember`](crate::operation::CreateMember)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMember,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMemberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMemberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMemberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_create_member(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMember",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMemberInput`](crate::input::CreateMemberInput)
    pub fn builder() -> crate::input::create_member_input::Builder {
        crate::input::create_member_input::Builder::default()
    }
}

/// See [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
pub mod create_sample_findings_input {
    /// A builder for [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_types: std::option::Option<std::vec::Vec<crate::model::FindingType>>,
    }
    impl Builder {
        /// Appends an item to `finding_types`.
        ///
        /// To override the contents of this collection use [`set_finding_types`](Self::set_finding_types).
        ///
        /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
        pub fn finding_types(mut self, input: impl Into<crate::model::FindingType>) -> Self {
            let mut v = self.finding_types.unwrap_or_default();
            v.push(input.into());
            self.finding_types = Some(v);
            self
        }
        /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
        pub fn set_finding_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingType>>,
        ) -> Self {
            self.finding_types = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateSampleFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateSampleFindingsInput {
                finding_types: self.finding_types,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateSampleFindingsInputOperationOutputAlias = crate::operation::CreateSampleFindings;
#[doc(hidden)]
pub type CreateSampleFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateSampleFindingsInput {
    /// Consumes the builder and constructs an Operation<[`CreateSampleFindings`](crate::operation::CreateSampleFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateSampleFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateSampleFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings/sample").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateSampleFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateSampleFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_sample_findings(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateSampleFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateSampleFindings",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
    pub fn builder() -> crate::input::create_sample_findings_input::Builder {
        crate::input::create_sample_findings_input::Builder::default()
    }
}

/// See [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
pub mod decline_invitations_input {
    /// A builder for [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeclineInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeclineInvitationsInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeclineInvitationsInputOperationOutputAlias = crate::operation::DeclineInvitations;
#[doc(hidden)]
pub type DeclineInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeclineInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`DeclineInvitations`](crate::operation::DeclineInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeclineInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeclineInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/decline").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeclineInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeclineInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_decline_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeclineInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeclineInvitations",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    pub fn builder() -> crate::input::decline_invitations_input::Builder {
        crate::input::decline_invitations_input::Builder::default()
    }
}

/// See [`DeleteCustomDataIdentifierInput`](crate::input::DeleteCustomDataIdentifierInput)
pub mod delete_custom_data_identifier_input {
    /// A builder for [`DeleteCustomDataIdentifierInput`](crate::input::DeleteCustomDataIdentifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteCustomDataIdentifierInput`](crate::input::DeleteCustomDataIdentifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteCustomDataIdentifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteCustomDataIdentifierInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteCustomDataIdentifierInputOperationOutputAlias =
    crate::operation::DeleteCustomDataIdentifier;
#[doc(hidden)]
pub type DeleteCustomDataIdentifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteCustomDataIdentifierInput {
    /// Consumes the builder and constructs an Operation<[`DeleteCustomDataIdentifier`](crate::operation::DeleteCustomDataIdentifier)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteCustomDataIdentifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteCustomDataIdentifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_1 = &_input.id;
            let input_1 =
                input_1
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_1, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/custom-data-identifiers/{id}", id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteCustomDataIdentifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteCustomDataIdentifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteCustomDataIdentifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteCustomDataIdentifier",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteCustomDataIdentifierInput`](crate::input::DeleteCustomDataIdentifierInput)
    pub fn builder() -> crate::input::delete_custom_data_identifier_input::Builder {
        crate::input::delete_custom_data_identifier_input::Builder::default()
    }
}

/// See [`DeleteFindingsFilterInput`](crate::input::DeleteFindingsFilterInput)
pub mod delete_findings_filter_input {
    /// A builder for [`DeleteFindingsFilterInput`](crate::input::DeleteFindingsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteFindingsFilterInput`](crate::input::DeleteFindingsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteFindingsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteFindingsFilterInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteFindingsFilterInputOperationOutputAlias = crate::operation::DeleteFindingsFilter;
#[doc(hidden)]
pub type DeleteFindingsFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteFindingsFilterInput {
    /// Consumes the builder and constructs an Operation<[`DeleteFindingsFilter`](crate::operation::DeleteFindingsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteFindingsFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteFindingsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_2 = &_input.id;
            let input_2 =
                input_2
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_2, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/findingsfilters/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteFindingsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteFindingsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteFindingsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteFindingsFilter",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteFindingsFilterInput`](crate::input::DeleteFindingsFilterInput)
    pub fn builder() -> crate::input::delete_findings_filter_input::Builder {
        crate::input::delete_findings_filter_input::Builder::default()
    }
}

/// See [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
pub mod delete_invitations_input {
    /// A builder for [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// Appends an item to `account_ids`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
        pub fn account_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.account_ids.unwrap_or_default();
            v.push(input.into());
            self.account_ids = Some(v);
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.account_ids = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteInvitationsInput {
                account_ids: self.account_ids,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteInvitationsInputOperationOutputAlias = crate::operation::DeleteInvitations;
#[doc(hidden)]
pub type DeleteInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteInvitations`](crate::operation::DeleteInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/delete").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_invitations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteInvitations",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    pub fn builder() -> crate::input::delete_invitations_input::Builder {
        crate::input::delete_invitations_input::Builder::default()
    }
}

/// See [`DeleteMemberInput`](crate::input::DeleteMemberInput)
pub mod delete_member_input {
    /// A builder for [`DeleteMemberInput`](crate::input::DeleteMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMemberInput`](crate::input::DeleteMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMemberInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DeleteMemberInputOperationOutputAlias = crate::operation::DeleteMember;
#[doc(hidden)]
pub type DeleteMemberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMemberInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMember`](crate::operation::DeleteMember)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMember,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMemberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_3 = &_input.id;
            let input_3 =
                input_3
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_3, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/members/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMemberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMemberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMember",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMemberInput`](crate::input::DeleteMemberInput)
    pub fn builder() -> crate::input::delete_member_input::Builder {
        crate::input::delete_member_input::Builder::default()
    }
}

/// See [`DescribeBucketsInput`](crate::input::DescribeBucketsInput)
pub mod describe_buckets_input {
    /// A builder for [`DescribeBucketsInput`](crate::input::DescribeBucketsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) criteria: std::option::Option<
            std::collections::HashMap<
                std::string::String,
                crate::model::BucketCriteriaAdditionalProperties,
            >,
        >,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sort_criteria: std::option::Option<crate::model::BucketSortCriteria>,
    }
    impl Builder {
        /// Adds a key-value pair to `criteria`.
        ///
        /// To override the contents of this collection use [`set_criteria`](Self::set_criteria).
        ///
        /// <p>The criteria to use to filter the query results.</p>
        pub fn criteria(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::BucketCriteriaAdditionalProperties>,
        ) -> Self {
            let mut hash_map = self.criteria.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.criteria = Some(hash_map);
            self
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn set_criteria(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BucketCriteriaAdditionalProperties,
                >,
            >,
        ) -> Self {
            self.criteria = input;
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_criteria(mut self, input: crate::model::BucketSortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::BucketSortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBucketsInput`](crate::input::DescribeBucketsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBucketsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBucketsInput {
                criteria: self.criteria,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBucketsInputOperationOutputAlias = crate::operation::DescribeBuckets;
#[doc(hidden)]
pub type DescribeBucketsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBucketsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBuckets`](crate::operation::DescribeBuckets)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBuckets,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBucketsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/datasources/s3").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBucketsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBucketsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_buckets(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBuckets::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBuckets",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBucketsInput`](crate::input::DescribeBucketsInput)
    pub fn builder() -> crate::input::describe_buckets_input::Builder {
        crate::input::describe_buckets_input::Builder::default()
    }
}

/// See [`DescribeClassificationJobInput`](crate::input::DescribeClassificationJobInput)
pub mod describe_classification_job_input {
    /// A builder for [`DescribeClassificationJobInput`](crate::input::DescribeClassificationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the classification job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeClassificationJobInput`](crate::input::DescribeClassificationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeClassificationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeClassificationJobInput {
                job_id: self.job_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeClassificationJobInputOperationOutputAlias =
    crate::operation::DescribeClassificationJob;
#[doc(hidden)]
pub type DescribeClassificationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeClassificationJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeClassificationJob`](crate::operation::DescribeClassificationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeClassificationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeClassificationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_4 = &_input.job_id;
            let input_4 =
                input_4
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_4, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{jobId}", jobId = job_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeClassificationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeClassificationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeClassificationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeClassificationJob",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeClassificationJobInput`](crate::input::DescribeClassificationJobInput)
    pub fn builder() -> crate::input::describe_classification_job_input::Builder {
        crate::input::describe_classification_job_input::Builder::default()
    }
}

/// See [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
pub mod describe_organization_configuration_input {
    /// A builder for [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeOrganizationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeOrganizationConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type DescribeOrganizationConfigurationInputOperationOutputAlias =
    crate::operation::DescribeOrganizationConfiguration;
#[doc(hidden)]
pub type DescribeOrganizationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeOrganizationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`DescribeOrganizationConfiguration`](crate::operation::DescribeOrganizationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeOrganizationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeOrganizationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin/configuration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeOrganizationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeOrganizationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeOrganizationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeOrganizationConfiguration",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
}

/// See [`DisableMacieInput`](crate::input::DisableMacieInput)
pub mod disable_macie_input {
    /// A builder for [`DisableMacieInput`](crate::input::DisableMacieInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisableMacieInput`](crate::input::DisableMacieInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableMacieInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableMacieInput {})
        }
    }
}
#[doc(hidden)]
pub type DisableMacieInputOperationOutputAlias = crate::operation::DisableMacie;
#[doc(hidden)]
pub type DisableMacieInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableMacieInput {
    /// Consumes the builder and constructs an Operation<[`DisableMacie`](crate::operation::DisableMacie)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableMacie,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableMacieInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/macie").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableMacieInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableMacieInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableMacie::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableMacie",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableMacieInput`](crate::input::DisableMacieInput)
    pub fn builder() -> crate::input::disable_macie_input::Builder {
        crate::input::disable_macie_input::Builder::default()
    }
}

/// See [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
pub mod disable_organization_admin_account_input {
    /// A builder for [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisableOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisableOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DisableOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::DisableOrganizationAdminAccount;
#[doc(hidden)]
pub type DisableOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisableOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisableOrganizationAdminAccount`](crate::operation::DisableOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisableOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisableOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::DisableOrganizationAdminAccountInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_5) = &_input.admin_account_id {
                query.push_kv(
                    "adminAccountId",
                    &aws_smithy_http::query::fmt_string(&inner_5),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisableOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisableOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisableOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisableOrganizationAdminAccount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
}

/// See [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
pub mod disassociate_from_administrator_account_input {
    /// A builder for [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFromAdministratorAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFromAdministratorAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DisassociateFromAdministratorAccountInputOperationOutputAlias =
    crate::operation::DisassociateFromAdministratorAccount;
#[doc(hidden)]
pub type DisassociateFromAdministratorAccountInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl DisassociateFromAdministratorAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFromAdministratorAccount`](crate::operation::DisassociateFromAdministratorAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFromAdministratorAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFromAdministratorAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/administrator/disassociate").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFromAdministratorAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFromAdministratorAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFromAdministratorAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFromAdministratorAccount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
    pub fn builder() -> crate::input::disassociate_from_administrator_account_input::Builder {
        crate::input::disassociate_from_administrator_account_input::Builder::default()
    }
}

/// See [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
pub mod disassociate_from_master_account_input {
    /// A builder for [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateFromMasterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateFromMasterAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type DisassociateFromMasterAccountInputOperationOutputAlias =
    crate::operation::DisassociateFromMasterAccount;
#[doc(hidden)]
pub type DisassociateFromMasterAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateFromMasterAccountInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateFromMasterAccount`](crate::operation::DisassociateFromMasterAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateFromMasterAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateFromMasterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/master/disassociate").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateFromMasterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateFromMasterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateFromMasterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateFromMasterAccount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    pub fn builder() -> crate::input::disassociate_from_master_account_input::Builder {
        crate::input::disassociate_from_master_account_input::Builder::default()
    }
}

/// See [`DisassociateMemberInput`](crate::input::DisassociateMemberInput)
pub mod disassociate_member_input {
    /// A builder for [`DisassociateMemberInput`](crate::input::DisassociateMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`DisassociateMemberInput`](crate::input::DisassociateMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DisassociateMemberInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DisassociateMemberInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type DisassociateMemberInputOperationOutputAlias = crate::operation::DisassociateMember;
#[doc(hidden)]
pub type DisassociateMemberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DisassociateMemberInput {
    /// Consumes the builder and constructs an Operation<[`DisassociateMember`](crate::operation::DisassociateMember)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DisassociateMember,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DisassociateMemberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_6 = &_input.id;
            let input_6 =
                input_6
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_6, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/members/disassociate/{id}", id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DisassociateMemberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DisassociateMemberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DisassociateMember::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DisassociateMember",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DisassociateMemberInput`](crate::input::DisassociateMemberInput)
    pub fn builder() -> crate::input::disassociate_member_input::Builder {
        crate::input::disassociate_member_input::Builder::default()
    }
}

/// See [`EnableMacieInput`](crate::input::EnableMacieInput)
pub mod enable_macie_input {
    /// A builder for [`EnableMacieInput`](crate::input::EnableMacieInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) finding_publishing_frequency:
            std::option::Option<crate::model::FindingPublishingFrequency>,
        pub(crate) status: std::option::Option<crate::model::MacieStatus>,
    }
    impl Builder {
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn finding_publishing_frequency(
            mut self,
            input: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.finding_publishing_frequency = Some(input);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.finding_publishing_frequency = input;
            self
        }
        /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
        pub fn status(mut self, input: crate::model::MacieStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableMacieInput`](crate::input::EnableMacieInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableMacieInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableMacieInput {
                client_token: self.client_token,
                finding_publishing_frequency: self.finding_publishing_frequency,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableMacieInputOperationOutputAlias = crate::operation::EnableMacie;
#[doc(hidden)]
pub type EnableMacieInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableMacieInput {
    /// Consumes the builder and constructs an Operation<[`EnableMacie`](crate::operation::EnableMacie)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableMacie,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableMacieInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/macie").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableMacieInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableMacieInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_enable_macie(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableMacie::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableMacie",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableMacieInput`](crate::input::EnableMacieInput)
    pub fn builder() -> crate::input::enable_macie_input::Builder {
        crate::input::enable_macie_input::Builder::default()
    }
}

/// See [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
pub mod enable_organization_admin_account_input {
    /// A builder for [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) admin_account_id: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn admin_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.admin_account_id = Some(input.into());
            self
        }
        /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.admin_account_id = input;
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::EnableOrganizationAdminAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::EnableOrganizationAdminAccountInput {
                admin_account_id: self.admin_account_id,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type EnableOrganizationAdminAccountInputOperationOutputAlias =
    crate::operation::EnableOrganizationAdminAccount;
#[doc(hidden)]
pub type EnableOrganizationAdminAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl EnableOrganizationAdminAccountInput {
    /// Consumes the builder and constructs an Operation<[`EnableOrganizationAdminAccount`](crate::operation::EnableOrganizationAdminAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::EnableOrganizationAdminAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::EnableOrganizationAdminAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::EnableOrganizationAdminAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::EnableOrganizationAdminAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_enable_organization_admin_account(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::EnableOrganizationAdminAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "EnableOrganizationAdminAccount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
}

/// See [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
pub mod get_administrator_account_input {
    /// A builder for [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetAdministratorAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetAdministratorAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetAdministratorAccountInputOperationOutputAlias =
    crate::operation::GetAdministratorAccount;
#[doc(hidden)]
pub type GetAdministratorAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetAdministratorAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetAdministratorAccount`](crate::operation::GetAdministratorAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetAdministratorAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetAdministratorAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/administrator").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetAdministratorAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetAdministratorAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetAdministratorAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetAdministratorAccount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
    pub fn builder() -> crate::input::get_administrator_account_input::Builder {
        crate::input::get_administrator_account_input::Builder::default()
    }
}

/// See [`GetBucketStatisticsInput`](crate::input::GetBucketStatisticsInput)
pub mod get_bucket_statistics_input {
    /// A builder for [`GetBucketStatisticsInput`](crate::input::GetBucketStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBucketStatisticsInput`](crate::input::GetBucketStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBucketStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBucketStatisticsInput {
                account_id: self.account_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBucketStatisticsInputOperationOutputAlias = crate::operation::GetBucketStatistics;
#[doc(hidden)]
pub type GetBucketStatisticsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBucketStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetBucketStatistics`](crate::operation::GetBucketStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBucketStatistics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBucketStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/datasources/s3/statistics").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBucketStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBucketStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_bucket_statistics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBucketStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBucketStatistics",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBucketStatisticsInput`](crate::input::GetBucketStatisticsInput)
    pub fn builder() -> crate::input::get_bucket_statistics_input::Builder {
        crate::input::get_bucket_statistics_input::Builder::default()
    }
}

/// See [`GetClassificationExportConfigurationInput`](crate::input::GetClassificationExportConfigurationInput)
pub mod get_classification_export_configuration_input {
    /// A builder for [`GetClassificationExportConfigurationInput`](crate::input::GetClassificationExportConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetClassificationExportConfigurationInput`](crate::input::GetClassificationExportConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetClassificationExportConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetClassificationExportConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type GetClassificationExportConfigurationInputOperationOutputAlias =
    crate::operation::GetClassificationExportConfiguration;
#[doc(hidden)]
pub type GetClassificationExportConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetClassificationExportConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetClassificationExportConfiguration`](crate::operation::GetClassificationExportConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetClassificationExportConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetClassificationExportConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/classification-export-configuration")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetClassificationExportConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetClassificationExportConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetClassificationExportConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetClassificationExportConfiguration",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetClassificationExportConfigurationInput`](crate::input::GetClassificationExportConfigurationInput)
    pub fn builder() -> crate::input::get_classification_export_configuration_input::Builder {
        crate::input::get_classification_export_configuration_input::Builder::default()
    }
}

/// See [`GetCustomDataIdentifierInput`](crate::input::GetCustomDataIdentifierInput)
pub mod get_custom_data_identifier_input {
    /// A builder for [`GetCustomDataIdentifierInput`](crate::input::GetCustomDataIdentifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetCustomDataIdentifierInput`](crate::input::GetCustomDataIdentifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetCustomDataIdentifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetCustomDataIdentifierInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetCustomDataIdentifierInputOperationOutputAlias =
    crate::operation::GetCustomDataIdentifier;
#[doc(hidden)]
pub type GetCustomDataIdentifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetCustomDataIdentifierInput {
    /// Consumes the builder and constructs an Operation<[`GetCustomDataIdentifier`](crate::operation::GetCustomDataIdentifier)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetCustomDataIdentifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetCustomDataIdentifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_7 = &_input.id;
            let input_7 =
                input_7
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_7, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/custom-data-identifiers/{id}", id = id)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetCustomDataIdentifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetCustomDataIdentifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetCustomDataIdentifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetCustomDataIdentifier",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetCustomDataIdentifierInput`](crate::input::GetCustomDataIdentifierInput)
    pub fn builder() -> crate::input::get_custom_data_identifier_input::Builder {
        crate::input::get_custom_data_identifier_input::Builder::default()
    }
}

/// See [`GetFindingsInput`](crate::input::GetFindingsInput)
pub mod get_findings_input {
    /// A builder for [`GetFindingsInput`](crate::input::GetFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) sort_criteria: std::option::Option<crate::model::SortCriteria>,
    }
    impl Builder {
        /// Appends an item to `finding_ids`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
        pub fn finding_ids(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.finding_ids.unwrap_or_default();
            v.push(input.into());
            self.finding_ids = Some(v);
            self
        }
        /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.finding_ids = input;
            self
        }
        /// <p>The criteria for sorting the results of the request.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>The criteria for sorting the results of the request.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsInput`](crate::input::GetFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsInput {
                finding_ids: self.finding_ids,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingsInputOperationOutputAlias = crate::operation::GetFindings;
#[doc(hidden)]
pub type GetFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFindingsInput {
    /// Consumes the builder and constructs an Operation<[`GetFindings`](crate::operation::GetFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings/describe").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindings",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsInput`](crate::input::GetFindingsInput)
    pub fn builder() -> crate::input::get_findings_input::Builder {
        crate::input::get_findings_input::Builder::default()
    }
}

/// See [`GetFindingsFilterInput`](crate::input::GetFindingsFilterInput)
pub mod get_findings_filter_input {
    /// A builder for [`GetFindingsFilterInput`](crate::input::GetFindingsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingsFilterInput`](crate::input::GetFindingsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsFilterInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetFindingsFilterInputOperationOutputAlias = crate::operation::GetFindingsFilter;
#[doc(hidden)]
pub type GetFindingsFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFindingsFilterInput {
    /// Consumes the builder and constructs an Operation<[`GetFindingsFilter`](crate::operation::GetFindingsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindingsFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_8 = &_input.id;
            let input_8 =
                input_8
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_8, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/findingsfilters/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindingsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindingsFilter",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsFilterInput`](crate::input::GetFindingsFilterInput)
    pub fn builder() -> crate::input::get_findings_filter_input::Builder {
        crate::input::get_findings_filter_input::Builder::default()
    }
}

/// See [`GetFindingsPublicationConfigurationInput`](crate::input::GetFindingsPublicationConfigurationInput)
pub mod get_findings_publication_configuration_input {
    /// A builder for [`GetFindingsPublicationConfigurationInput`](crate::input::GetFindingsPublicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetFindingsPublicationConfigurationInput`](crate::input::GetFindingsPublicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingsPublicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingsPublicationConfigurationInput {})
        }
    }
}
#[doc(hidden)]
pub type GetFindingsPublicationConfigurationInputOperationOutputAlias =
    crate::operation::GetFindingsPublicationConfiguration;
#[doc(hidden)]
pub type GetFindingsPublicationConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl GetFindingsPublicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`GetFindingsPublicationConfiguration`](crate::operation::GetFindingsPublicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindingsPublicationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingsPublicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings-publication-configuration")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingsPublicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingsPublicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindingsPublicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindingsPublicationConfiguration",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingsPublicationConfigurationInput`](crate::input::GetFindingsPublicationConfigurationInput)
    pub fn builder() -> crate::input::get_findings_publication_configuration_input::Builder {
        crate::input::get_findings_publication_configuration_input::Builder::default()
    }
}

/// See [`GetFindingStatisticsInput`](crate::input::GetFindingStatisticsInput)
pub mod get_finding_statistics_input {
    /// A builder for [`GetFindingStatisticsInput`](crate::input::GetFindingStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
        pub(crate) group_by: std::option::Option<crate::model::GroupBy>,
        pub(crate) size: std::option::Option<i32>,
        pub(crate) sort_criteria: std::option::Option<crate::model::FindingStatisticsSortCriteria>,
    }
    impl Builder {
        /// <p>The criteria to use to filter the query results.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// <p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>
        pub fn group_by(mut self, input: crate::model::GroupBy) -> Self {
            self.group_by = Some(input);
            self
        }
        /// <p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>
        pub fn set_group_by(mut self, input: std::option::Option<crate::model::GroupBy>) -> Self {
            self.group_by = input;
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn size(mut self, input: i32) -> Self {
            self.size = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.size = input;
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_criteria(mut self, input: crate::model::FindingStatisticsSortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingStatisticsSortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`GetFindingStatisticsInput`](crate::input::GetFindingStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetFindingStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetFindingStatisticsInput {
                finding_criteria: self.finding_criteria,
                group_by: self.group_by,
                size: self.size.unwrap_or_default(),
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type GetFindingStatisticsInputOperationOutputAlias = crate::operation::GetFindingStatistics;
#[doc(hidden)]
pub type GetFindingStatisticsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetFindingStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetFindingStatistics`](crate::operation::GetFindingStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetFindingStatistics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetFindingStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings/statistics").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetFindingStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetFindingStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_finding_statistics(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetFindingStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetFindingStatistics",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetFindingStatisticsInput`](crate::input::GetFindingStatisticsInput)
    pub fn builder() -> crate::input::get_finding_statistics_input::Builder {
        crate::input::get_finding_statistics_input::Builder::default()
    }
}

/// See [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
pub mod get_invitations_count_input {
    /// A builder for [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetInvitationsCountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetInvitationsCountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetInvitationsCountInputOperationOutputAlias = crate::operation::GetInvitationsCount;
#[doc(hidden)]
pub type GetInvitationsCountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetInvitationsCountInput {
    /// Consumes the builder and constructs an Operation<[`GetInvitationsCount`](crate::operation::GetInvitationsCount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetInvitationsCount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetInvitationsCountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations/count").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetInvitationsCountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetInvitationsCountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetInvitationsCount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetInvitationsCount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    pub fn builder() -> crate::input::get_invitations_count_input::Builder {
        crate::input::get_invitations_count_input::Builder::default()
    }
}

/// See [`GetMacieSessionInput`](crate::input::GetMacieSessionInput)
pub mod get_macie_session_input {
    /// A builder for [`GetMacieSessionInput`](crate::input::GetMacieSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetMacieSessionInput`](crate::input::GetMacieSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMacieSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMacieSessionInput {})
        }
    }
}
#[doc(hidden)]
pub type GetMacieSessionInputOperationOutputAlias = crate::operation::GetMacieSession;
#[doc(hidden)]
pub type GetMacieSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMacieSessionInput {
    /// Consumes the builder and constructs an Operation<[`GetMacieSession`](crate::operation::GetMacieSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMacieSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMacieSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/macie").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMacieSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMacieSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMacieSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMacieSession",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMacieSessionInput`](crate::input::GetMacieSessionInput)
    pub fn builder() -> crate::input::get_macie_session_input::Builder {
        crate::input::get_macie_session_input::Builder::default()
    }
}

/// See [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
pub mod get_master_account_input {
    /// A builder for [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMasterAccountInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMasterAccountInput {})
        }
    }
}
#[doc(hidden)]
pub type GetMasterAccountInputOperationOutputAlias = crate::operation::GetMasterAccount;
#[doc(hidden)]
pub type GetMasterAccountInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMasterAccountInput {
    /// Consumes the builder and constructs an Operation<[`GetMasterAccount`](crate::operation::GetMasterAccount)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMasterAccount,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMasterAccountInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/master").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMasterAccountInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMasterAccountInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMasterAccount::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMasterAccount",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    pub fn builder() -> crate::input::get_master_account_input::Builder {
        crate::input::get_master_account_input::Builder::default()
    }
}

/// See [`GetMemberInput`](crate::input::GetMemberInput)
pub mod get_member_input {
    /// A builder for [`GetMemberInput`](crate::input::GetMemberInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMemberInput`](crate::input::GetMemberInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::GetMemberInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::GetMemberInput { id: self.id })
        }
    }
}
#[doc(hidden)]
pub type GetMemberInputOperationOutputAlias = crate::operation::GetMember;
#[doc(hidden)]
pub type GetMemberInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMemberInput {
    /// Consumes the builder and constructs an Operation<[`GetMember`](crate::operation::GetMember)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMember,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMemberInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_9 = &_input.id;
            let input_9 =
                input_9
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_9, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/members/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMemberInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMemberInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::GetMember::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "GetMember",
                    "macie2",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMemberInput`](crate::input::GetMemberInput)
    pub fn builder() -> crate::input::get_member_input::Builder {
        crate::input::get_member_input::Builder::default()
    }
}

/// See [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
pub mod get_usage_statistics_input {
    /// A builder for [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_by:
            std::option::Option<std::vec::Vec<crate::model::UsageStatisticsFilter>>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sort_by: std::option::Option<crate::model::UsageStatisticsSortBy>,
        pub(crate) time_range: std::option::Option<crate::model::TimeRange>,
    }
    impl Builder {
        /// Appends an item to `filter_by`.
        ///
        /// To override the contents of this collection use [`set_filter_by`](Self::set_filter_by).
        ///
        /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
        pub fn filter_by(mut self, input: impl Into<crate::model::UsageStatisticsFilter>) -> Self {
            let mut v = self.filter_by.unwrap_or_default();
            v.push(input.into());
            self.filter_by = Some(v);
            self
        }
        /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
        pub fn set_filter_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageStatisticsFilter>>,
        ) -> Self {
            self.filter_by = input;
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_by(mut self, input: crate::model::UsageStatisticsSortBy) -> Self {
            self.sort_by = Some(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticsSortBy>,
        ) -> Self {
            self.sort_by = input;
            self
        }
        /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
        pub fn time_range(mut self, input: crate::model::TimeRange) -> Self {
            self.time_range = Some(input);
            self
        }
        /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
        pub fn set_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsageStatisticsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsageStatisticsInput {
                filter_by: self.filter_by,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                sort_by: self.sort_by,
                time_range: self.time_range,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsageStatisticsInputOperationOutputAlias = crate::operation::GetUsageStatistics;
#[doc(hidden)]
pub type GetUsageStatisticsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsageStatisticsInput {
    /// Consumes the builder and constructs an Operation<[`GetUsageStatistics`](crate::operation::GetUsageStatistics)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsageStatistics,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsageStatisticsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/usage/statistics").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsageStatisticsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsageStatisticsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_usage_statistics(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsageStatistics::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsageStatistics",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
    pub fn builder() -> crate::input::get_usage_statistics_input::Builder {
        crate::input::get_usage_statistics_input::Builder::default()
    }
}

/// See [`GetUsageTotalsInput`](crate::input::GetUsageTotalsInput)
pub mod get_usage_totals_input {
    /// A builder for [`GetUsageTotalsInput`](crate::input::GetUsageTotalsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) time_range: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
        pub fn time_range(mut self, input: impl Into<std::string::String>) -> Self {
            self.time_range = Some(input.into());
            self
        }
        /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
        pub fn set_time_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.time_range = input;
            self
        }
        /// Consumes the builder and constructs a [`GetUsageTotalsInput`](crate::input::GetUsageTotalsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetUsageTotalsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetUsageTotalsInput {
                time_range: self.time_range,
            })
        }
    }
}
#[doc(hidden)]
pub type GetUsageTotalsInputOperationOutputAlias = crate::operation::GetUsageTotals;
#[doc(hidden)]
pub type GetUsageTotalsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetUsageTotalsInput {
    /// Consumes the builder and constructs an Operation<[`GetUsageTotals`](crate::operation::GetUsageTotals)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetUsageTotals,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetUsageTotalsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/usage").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::GetUsageTotalsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_10) = &_input.time_range {
                query.push_kv("timeRange", &aws_smithy_http::query::fmt_string(&inner_10));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetUsageTotalsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetUsageTotalsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetUsageTotals::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetUsageTotals",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetUsageTotalsInput`](crate::input::GetUsageTotalsInput)
    pub fn builder() -> crate::input::get_usage_totals_input::Builder {
        crate::input::get_usage_totals_input::Builder::default()
    }
}

/// See [`ListClassificationJobsInput`](crate::input::ListClassificationJobsInput)
pub mod list_classification_jobs_input {
    /// A builder for [`ListClassificationJobsInput`](crate::input::ListClassificationJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_criteria: std::option::Option<crate::model::ListJobsFilterCriteria>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sort_criteria: std::option::Option<crate::model::ListJobsSortCriteria>,
    }
    impl Builder {
        /// <p>The criteria to use to filter the results.</p>
        pub fn filter_criteria(mut self, input: crate::model::ListJobsFilterCriteria) -> Self {
            self.filter_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::ListJobsFilterCriteria>,
        ) -> Self {
            self.filter_criteria = input;
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, input: crate::model::ListJobsSortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::ListJobsSortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`ListClassificationJobsInput`](crate::input::ListClassificationJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListClassificationJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListClassificationJobsInput {
                filter_criteria: self.filter_criteria,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type ListClassificationJobsInputOperationOutputAlias = crate::operation::ListClassificationJobs;
#[doc(hidden)]
pub type ListClassificationJobsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListClassificationJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListClassificationJobs`](crate::operation::ListClassificationJobs)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListClassificationJobs,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListClassificationJobsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/jobs/list").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListClassificationJobsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListClassificationJobsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_classification_jobs(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListClassificationJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListClassificationJobs",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListClassificationJobsInput`](crate::input::ListClassificationJobsInput)
    pub fn builder() -> crate::input::list_classification_jobs_input::Builder {
        crate::input::list_classification_jobs_input::Builder::default()
    }
}

/// See [`ListCustomDataIdentifiersInput`](crate::input::ListCustomDataIdentifiersInput)
pub mod list_custom_data_identifiers_input {
    /// A builder for [`ListCustomDataIdentifiersInput`](crate::input::ListCustomDataIdentifiersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListCustomDataIdentifiersInput`](crate::input::ListCustomDataIdentifiersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListCustomDataIdentifiersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListCustomDataIdentifiersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListCustomDataIdentifiersInputOperationOutputAlias =
    crate::operation::ListCustomDataIdentifiers;
#[doc(hidden)]
pub type ListCustomDataIdentifiersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListCustomDataIdentifiersInput {
    /// Consumes the builder and constructs an Operation<[`ListCustomDataIdentifiers`](crate::operation::ListCustomDataIdentifiers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListCustomDataIdentifiers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListCustomDataIdentifiersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/custom-data-identifiers/list").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListCustomDataIdentifiersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListCustomDataIdentifiersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_custom_data_identifiers(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListCustomDataIdentifiers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListCustomDataIdentifiers",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListCustomDataIdentifiersInput`](crate::input::ListCustomDataIdentifiersInput)
    pub fn builder() -> crate::input::list_custom_data_identifiers_input::Builder {
        crate::input::list_custom_data_identifiers_input::Builder::default()
    }
}

/// See [`ListFindingsInput`](crate::input::ListFindingsInput)
pub mod list_findings_input {
    /// A builder for [`ListFindingsInput`](crate::input::ListFindingsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sort_criteria: std::option::Option<crate::model::SortCriteria>,
    }
    impl Builder {
        /// <p>The criteria to use to filter the results.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, input: crate::model::SortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsInput`](crate::input::ListFindingsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingsInput {
                finding_criteria: self.finding_criteria,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingsInputOperationOutputAlias = crate::operation::ListFindings;
#[doc(hidden)]
pub type ListFindingsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFindingsInput {
    /// Consumes the builder and constructs an Operation<[`ListFindings`](crate::operation::ListFindings)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindings,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_list_findings(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindings::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindings",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
}

/// See [`ListFindingsFiltersInput`](crate::input::ListFindingsFiltersInput)
pub mod list_findings_filters_input {
    /// A builder for [`ListFindingsFiltersInput`](crate::input::ListFindingsFiltersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListFindingsFiltersInput`](crate::input::ListFindingsFiltersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListFindingsFiltersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListFindingsFiltersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListFindingsFiltersInputOperationOutputAlias = crate::operation::ListFindingsFilters;
#[doc(hidden)]
pub type ListFindingsFiltersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListFindingsFiltersInput {
    /// Consumes the builder and constructs an Operation<[`ListFindingsFilters`](crate::operation::ListFindingsFilters)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListFindingsFilters,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListFindingsFiltersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findingsfilters").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListFindingsFiltersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_11) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_11));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListFindingsFiltersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListFindingsFiltersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListFindingsFilters::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListFindingsFilters",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListFindingsFiltersInput`](crate::input::ListFindingsFiltersInput)
    pub fn builder() -> crate::input::list_findings_filters_input::Builder {
        crate::input::list_findings_filters_input::Builder::default()
    }
}

/// See [`ListInvitationsInput`](crate::input::ListInvitationsInput)
pub mod list_invitations_input {
    /// A builder for [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListInvitationsInput`](crate::input::ListInvitationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListInvitationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListInvitationsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListInvitationsInputOperationOutputAlias = crate::operation::ListInvitations;
#[doc(hidden)]
pub type ListInvitationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListInvitationsInput {
    /// Consumes the builder and constructs an Operation<[`ListInvitations`](crate::operation::ListInvitations)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListInvitations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListInvitationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/invitations").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListInvitationsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_12) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_12));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListInvitationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListInvitationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListInvitations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListInvitations",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
}

/// See [`ListManagedDataIdentifiersInput`](crate::input::ListManagedDataIdentifiersInput)
pub mod list_managed_data_identifiers_input {
    /// A builder for [`ListManagedDataIdentifiersInput`](crate::input::ListManagedDataIdentifiersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListManagedDataIdentifiersInput`](crate::input::ListManagedDataIdentifiersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListManagedDataIdentifiersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListManagedDataIdentifiersInput {
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListManagedDataIdentifiersInputOperationOutputAlias =
    crate::operation::ListManagedDataIdentifiers;
#[doc(hidden)]
pub type ListManagedDataIdentifiersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListManagedDataIdentifiersInput {
    /// Consumes the builder and constructs an Operation<[`ListManagedDataIdentifiers`](crate::operation::ListManagedDataIdentifiers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListManagedDataIdentifiers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListManagedDataIdentifiersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/managed-data-identifiers/list").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListManagedDataIdentifiersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListManagedDataIdentifiersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_list_managed_data_identifiers(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListManagedDataIdentifiers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListManagedDataIdentifiers",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListManagedDataIdentifiersInput`](crate::input::ListManagedDataIdentifiersInput)
    pub fn builder() -> crate::input::list_managed_data_identifiers_input::Builder {
        crate::input::list_managed_data_identifiers_input::Builder::default()
    }
}

/// See [`ListMembersInput`](crate::input::ListMembersInput)
pub mod list_members_input {
    /// A builder for [`ListMembersInput`](crate::input::ListMembersInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) only_associated: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
        pub fn only_associated(mut self, input: impl Into<std::string::String>) -> Self {
            self.only_associated = Some(input.into());
            self
        }
        /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
        pub fn set_only_associated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.only_associated = input;
            self
        }
        /// Consumes the builder and constructs a [`ListMembersInput`](crate::input::ListMembersInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListMembersInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListMembersInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                only_associated: self.only_associated,
            })
        }
    }
}
#[doc(hidden)]
pub type ListMembersInputOperationOutputAlias = crate::operation::ListMembers;
#[doc(hidden)]
pub type ListMembersInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListMembersInput {
    /// Consumes the builder and constructs an Operation<[`ListMembers`](crate::operation::ListMembers)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListMembers,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListMembersInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/members").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListMembersInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_13) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_13));
            }
            if let Some(inner_14) = &_input.only_associated {
                query.push_kv(
                    "onlyAssociated",
                    &aws_smithy_http::query::fmt_string(&inner_14),
                );
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListMembersInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListMembersInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListMembers::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListMembers",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
}

/// See [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
pub mod list_organization_admin_accounts_input {
    /// A builder for [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListOrganizationAdminAccountsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListOrganizationAdminAccountsInput {
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
            })
        }
    }
}
#[doc(hidden)]
pub type ListOrganizationAdminAccountsInputOperationOutputAlias =
    crate::operation::ListOrganizationAdminAccounts;
#[doc(hidden)]
pub type ListOrganizationAdminAccountsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListOrganizationAdminAccountsInput {
    /// Consumes the builder and constructs an Operation<[`ListOrganizationAdminAccounts`](crate::operation::ListOrganizationAdminAccounts)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListOrganizationAdminAccounts,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListOrganizationAdminAccountsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin").expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::ListOrganizationAdminAccountsInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if _input.max_results != 0 {
                query.push_kv(
                    "maxResults",
                    aws_smithy_types::primitive::Encoder::from(_input.max_results).encode(),
                );
            }
            if let Some(inner_15) = &_input.next_token {
                query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_15));
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListOrganizationAdminAccountsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListOrganizationAdminAccountsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListOrganizationAdminAccounts::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListOrganizationAdminAccounts",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::ListTagsForResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_16 = &_input.resource_arn;
            let input_16 =
                input_16
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_16, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::ListTagsForResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("GET").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::ListTagsForResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`PutClassificationExportConfigurationInput`](crate::input::PutClassificationExportConfigurationInput)
pub mod put_classification_export_configuration_input {
    /// A builder for [`PutClassificationExportConfigurationInput`](crate::input::PutClassificationExportConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) configuration:
            std::option::Option<crate::model::ClassificationExportConfiguration>,
    }
    impl Builder {
        /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
        pub fn configuration(
            mut self,
            input: crate::model::ClassificationExportConfiguration,
        ) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClassificationExportConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutClassificationExportConfigurationInput`](crate::input::PutClassificationExportConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutClassificationExportConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutClassificationExportConfigurationInput {
                configuration: self.configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutClassificationExportConfigurationInputOperationOutputAlias =
    crate::operation::PutClassificationExportConfiguration;
#[doc(hidden)]
pub type PutClassificationExportConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl PutClassificationExportConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutClassificationExportConfiguration`](crate::operation::PutClassificationExportConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutClassificationExportConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutClassificationExportConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/classification-export-configuration")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutClassificationExportConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutClassificationExportConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_classification_export_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutClassificationExportConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutClassificationExportConfiguration",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutClassificationExportConfigurationInput`](crate::input::PutClassificationExportConfigurationInput)
    pub fn builder() -> crate::input::put_classification_export_configuration_input::Builder {
        crate::input::put_classification_export_configuration_input::Builder::default()
    }
}

/// See [`PutFindingsPublicationConfigurationInput`](crate::input::PutFindingsPublicationConfigurationInput)
pub mod put_findings_publication_configuration_input {
    /// A builder for [`PutFindingsPublicationConfigurationInput`](crate::input::PutFindingsPublicationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) security_hub_configuration:
            std::option::Option<crate::model::SecurityHubConfiguration>,
    }
    impl Builder {
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
        pub fn security_hub_configuration(
            mut self,
            input: crate::model::SecurityHubConfiguration,
        ) -> Self {
            self.security_hub_configuration = Some(input);
            self
        }
        /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
        pub fn set_security_hub_configuration(
            mut self,
            input: std::option::Option<crate::model::SecurityHubConfiguration>,
        ) -> Self {
            self.security_hub_configuration = input;
            self
        }
        /// Consumes the builder and constructs a [`PutFindingsPublicationConfigurationInput`](crate::input::PutFindingsPublicationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::PutFindingsPublicationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::PutFindingsPublicationConfigurationInput {
                client_token: self.client_token,
                security_hub_configuration: self.security_hub_configuration,
            })
        }
    }
}
#[doc(hidden)]
pub type PutFindingsPublicationConfigurationInputOperationOutputAlias =
    crate::operation::PutFindingsPublicationConfiguration;
#[doc(hidden)]
pub type PutFindingsPublicationConfigurationInputOperationRetryAlias =
    aws_http::AwsErrorRetryPolicy;
impl PutFindingsPublicationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`PutFindingsPublicationConfiguration`](crate::operation::PutFindingsPublicationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::PutFindingsPublicationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PutFindingsPublicationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/findings-publication-configuration")
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PutFindingsPublicationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PUT").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PutFindingsPublicationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_put_findings_publication_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::PutFindingsPublicationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "PutFindingsPublicationConfiguration",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PutFindingsPublicationConfigurationInput`](crate::input::PutFindingsPublicationConfigurationInput)
    pub fn builder() -> crate::input::put_findings_publication_configuration_input::Builder {
        crate::input::put_findings_publication_configuration_input::Builder::default()
    }
}

/// See [`SearchResourcesInput`](crate::input::SearchResourcesInput)
pub mod search_resources_input {
    /// A builder for [`SearchResourcesInput`](crate::input::SearchResourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_criteria:
            std::option::Option<crate::model::SearchResourcesBucketCriteria>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) sort_criteria: std::option::Option<crate::model::SearchResourcesSortCriteria>,
    }
    impl Builder {
        /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
        pub fn bucket_criteria(
            mut self,
            input: crate::model::SearchResourcesBucketCriteria,
        ) -> Self {
            self.bucket_criteria = Some(input);
            self
        }
        /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
        pub fn set_bucket_criteria(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesBucketCriteria>,
        ) -> Self {
            self.bucket_criteria = input;
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, input: crate::model::SearchResourcesSortCriteria) -> Self {
            self.sort_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesSortCriteria>,
        ) -> Self {
            self.sort_criteria = input;
            self
        }
        /// Consumes the builder and constructs a [`SearchResourcesInput`](crate::input::SearchResourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::SearchResourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::SearchResourcesInput {
                bucket_criteria: self.bucket_criteria,
                max_results: self.max_results.unwrap_or_default(),
                next_token: self.next_token,
                sort_criteria: self.sort_criteria,
            })
        }
    }
}
#[doc(hidden)]
pub type SearchResourcesInputOperationOutputAlias = crate::operation::SearchResources;
#[doc(hidden)]
pub type SearchResourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl SearchResourcesInput {
    /// Consumes the builder and constructs an Operation<[`SearchResources`](crate::operation::SearchResources)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::SearchResources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::SearchResourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/datasources/search-resources").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::SearchResourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::SearchResourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_search_resources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::SearchResources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "SearchResources",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`SearchResourcesInput`](crate::input::SearchResourcesInput)
    pub fn builder() -> crate::input::search_resources_input::Builder {
        crate::input::search_resources_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.tags.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.tags = Some(hash_map);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_17 = &_input.resource_arn;
            let input_17 =
                input_17
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_17, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`TestCustomDataIdentifierInput`](crate::input::TestCustomDataIdentifierInput)
pub mod test_custom_data_identifier_input {
    /// A builder for [`TestCustomDataIdentifierInput`](crate::input::TestCustomDataIdentifierInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ignore_words: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) keywords: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) maximum_match_distance: std::option::Option<i32>,
        pub(crate) regex: std::option::Option<std::string::String>,
        pub(crate) sample_text: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `ignore_words`.
        ///
        /// To override the contents of this collection use [`set_ignore_words`](Self::set_ignore_words).
        ///
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn ignore_words(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.ignore_words.unwrap_or_default();
            v.push(input.into());
            self.ignore_words = Some(v);
            self
        }
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn set_ignore_words(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.ignore_words = input;
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn keywords(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.keywords.unwrap_or_default();
            v.push(input.into());
            self.keywords = Some(v);
            self
        }
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.keywords = input;
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn maximum_match_distance(mut self, input: i32) -> Self {
            self.maximum_match_distance = Some(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn set_maximum_match_distance(mut self, input: std::option::Option<i32>) -> Self {
            self.maximum_match_distance = input;
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn regex(mut self, input: impl Into<std::string::String>) -> Self {
            self.regex = Some(input.into());
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.regex = input;
            self
        }
        /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
        pub fn sample_text(mut self, input: impl Into<std::string::String>) -> Self {
            self.sample_text = Some(input.into());
            self
        }
        /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
        pub fn set_sample_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.sample_text = input;
            self
        }
        /// Consumes the builder and constructs a [`TestCustomDataIdentifierInput`](crate::input::TestCustomDataIdentifierInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TestCustomDataIdentifierInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TestCustomDataIdentifierInput {
                ignore_words: self.ignore_words,
                keywords: self.keywords,
                maximum_match_distance: self.maximum_match_distance.unwrap_or_default(),
                regex: self.regex,
                sample_text: self.sample_text,
            })
        }
    }
}
#[doc(hidden)]
pub type TestCustomDataIdentifierInputOperationOutputAlias =
    crate::operation::TestCustomDataIdentifier;
#[doc(hidden)]
pub type TestCustomDataIdentifierInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl TestCustomDataIdentifierInput {
    /// Consumes the builder and constructs an Operation<[`TestCustomDataIdentifier`](crate::operation::TestCustomDataIdentifier)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TestCustomDataIdentifier,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::TestCustomDataIdentifierInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/custom-data-identifiers/test").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::TestCustomDataIdentifierInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::TestCustomDataIdentifierInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_test_custom_data_identifier(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TestCustomDataIdentifier::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TestCustomDataIdentifier",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`TestCustomDataIdentifierInput`](crate::input::TestCustomDataIdentifierInput)
    pub fn builder() -> crate::input::test_custom_data_identifier_input::Builder {
        crate::input::test_custom_data_identifier_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UntagResourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_18 = &_input.resource_arn;
            let input_18 =
                input_18
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    })?;
            let resource_arn = aws_smithy_http::label::fmt_string(input_18, false);
            if resource_arn.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "resource_arn",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/tags/{resourceArn}", resourceArn = resource_arn)
                .expect("formatting should succeed");
            Ok(())
        }
        fn uri_query(
            _input: &crate::input::UntagResourceInput,
            mut output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let mut query = aws_smithy_http::query::Writer::new(&mut output);
            if let Some(inner_19) = &_input.tag_keys {
                for inner_20 in inner_19 {
                    query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_20));
                }
            }
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UntagResourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            uri_query(input, &mut uri)?;
            Ok(builder.method("DELETE").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UntagResourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateClassificationJobInput`](crate::input::UpdateClassificationJobInput)
pub mod update_classification_job_input {
    /// A builder for [`UpdateClassificationJobInput`](crate::input::UpdateClassificationJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_id: std::option::Option<std::string::String>,
        pub(crate) job_status: std::option::Option<crate::model::JobStatus>,
    }
    impl Builder {
        /// <p>The unique identifier for the classification job.</p>
        pub fn job_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_id = input;
            self
        }
        /// <p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>
        pub fn job_status(mut self, input: crate::model::JobStatus) -> Self {
            self.job_status = Some(input);
            self
        }
        /// <p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.job_status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateClassificationJobInput`](crate::input::UpdateClassificationJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateClassificationJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateClassificationJobInput {
                job_id: self.job_id,
                job_status: self.job_status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateClassificationJobInputOperationOutputAlias =
    crate::operation::UpdateClassificationJob;
#[doc(hidden)]
pub type UpdateClassificationJobInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateClassificationJobInput {
    /// Consumes the builder and constructs an Operation<[`UpdateClassificationJob`](crate::operation::UpdateClassificationJob)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateClassificationJob,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateClassificationJobInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_21 = &_input.job_id;
            let input_21 =
                input_21
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_id",
                        details: "cannot be empty or unset",
                    })?;
            let job_id = aws_smithy_http::label::fmt_string(input_21, false);
            if job_id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "job_id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/jobs/{jobId}", jobId = job_id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateClassificationJobInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateClassificationJobInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_classification_job(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateClassificationJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateClassificationJob",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateClassificationJobInput`](crate::input::UpdateClassificationJobInput)
    pub fn builder() -> crate::input::update_classification_job_input::Builder {
        crate::input::update_classification_job_input::Builder::default()
    }
}

/// See [`UpdateFindingsFilterInput`](crate::input::UpdateFindingsFilterInput)
pub mod update_findings_filter_input {
    /// A builder for [`UpdateFindingsFilterInput`](crate::input::UpdateFindingsFilterInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) action: std::option::Option<crate::model::FindingsFilterAction>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) finding_criteria: std::option::Option<crate::model::FindingCriteria>,
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) position: std::option::Option<i32>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, input: crate::model::FindingsFilterAction) -> Self {
            self.action = Some(input);
            self
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.action = input;
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn finding_criteria(mut self, input: crate::model::FindingCriteria) -> Self {
            self.finding_criteria = Some(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.finding_criteria = input;
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn position(mut self, input: i32) -> Self {
            self.position = Some(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn set_position(mut self, input: std::option::Option<i32>) -> Self {
            self.position = input;
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateFindingsFilterInput`](crate::input::UpdateFindingsFilterInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateFindingsFilterInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateFindingsFilterInput {
                action: self.action,
                description: self.description,
                finding_criteria: self.finding_criteria,
                id: self.id,
                name: self.name,
                position: self.position.unwrap_or_default(),
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateFindingsFilterInputOperationOutputAlias = crate::operation::UpdateFindingsFilter;
#[doc(hidden)]
pub type UpdateFindingsFilterInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateFindingsFilterInput {
    /// Consumes the builder and constructs an Operation<[`UpdateFindingsFilter`](crate::operation::UpdateFindingsFilter)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateFindingsFilter,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateFindingsFilterInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_22 = &_input.id;
            let input_22 =
                input_22
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_22, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/findingsfilters/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateFindingsFilterInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateFindingsFilterInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_findings_filter(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateFindingsFilter::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateFindingsFilter",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateFindingsFilterInput`](crate::input::UpdateFindingsFilterInput)
    pub fn builder() -> crate::input::update_findings_filter_input::Builder {
        crate::input::update_findings_filter_input::Builder::default()
    }
}

/// See [`UpdateMacieSessionInput`](crate::input::UpdateMacieSessionInput)
pub mod update_macie_session_input {
    /// A builder for [`UpdateMacieSessionInput`](crate::input::UpdateMacieSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) finding_publishing_frequency:
            std::option::Option<crate::model::FindingPublishingFrequency>,
        pub(crate) status: std::option::Option<crate::model::MacieStatus>,
    }
    impl Builder {
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn finding_publishing_frequency(
            mut self,
            input: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.finding_publishing_frequency = Some(input);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.finding_publishing_frequency = input;
            self
        }
        /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn status(mut self, input: crate::model::MacieStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMacieSessionInput`](crate::input::UpdateMacieSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMacieSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMacieSessionInput {
                finding_publishing_frequency: self.finding_publishing_frequency,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMacieSessionInputOperationOutputAlias = crate::operation::UpdateMacieSession;
#[doc(hidden)]
pub type UpdateMacieSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateMacieSessionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMacieSession`](crate::operation::UpdateMacieSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMacieSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMacieSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/macie").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMacieSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMacieSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_macie_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMacieSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMacieSession",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMacieSessionInput`](crate::input::UpdateMacieSessionInput)
    pub fn builder() -> crate::input::update_macie_session_input::Builder {
        crate::input::update_macie_session_input::Builder::default()
    }
}

/// See [`UpdateMemberSessionInput`](crate::input::UpdateMemberSessionInput)
pub mod update_member_session_input {
    /// A builder for [`UpdateMemberSessionInput`](crate::input::UpdateMemberSessionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) id: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::MacieStatus>,
    }
    impl Builder {
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, input: impl Into<std::string::String>) -> Self {
            self.id = Some(input.into());
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.id = input;
            self
        }
        /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn status(mut self, input: crate::model::MacieStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMemberSessionInput`](crate::input::UpdateMemberSessionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMemberSessionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMemberSessionInput {
                id: self.id,
                status: self.status,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMemberSessionInputOperationOutputAlias = crate::operation::UpdateMemberSession;
#[doc(hidden)]
pub type UpdateMemberSessionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateMemberSessionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMemberSession`](crate::operation::UpdateMemberSession)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMemberSession,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMemberSessionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            let input_23 = &_input.id;
            let input_23 =
                input_23
                    .as_ref()
                    .ok_or(aws_smithy_http::operation::BuildError::MissingField {
                        field: "id",
                        details: "cannot be empty or unset",
                    })?;
            let id = aws_smithy_http::label::fmt_string(input_23, false);
            if id.is_empty() {
                return Err(aws_smithy_http::operation::BuildError::MissingField {
                    field: "id",
                    details: "cannot be empty or unset",
                });
            }
            write!(output, "/macie/members/{id}", id = id).expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMemberSessionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMemberSessionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_member_session(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMemberSession::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMemberSession",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMemberSessionInput`](crate::input::UpdateMemberSessionInput)
    pub fn builder() -> crate::input::update_member_session_input::Builder {
        crate::input::update_member_session_input::Builder::default()
    }
}

/// See [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
pub mod update_organization_configuration_input {
    /// A builder for [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) auto_enable: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.</p>
        pub fn auto_enable(mut self, input: bool) -> Self {
            self.auto_enable = Some(input);
            self
        }
        /// <p>Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.auto_enable = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateOrganizationConfigurationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateOrganizationConfigurationInput {
                auto_enable: self.auto_enable.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateOrganizationConfigurationInputOperationOutputAlias =
    crate::operation::UpdateOrganizationConfiguration;
#[doc(hidden)]
pub type UpdateOrganizationConfigurationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateOrganizationConfigurationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateOrganizationConfiguration`](crate::operation::UpdateOrganizationConfiguration)>
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateOrganizationConfiguration,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateOrganizationConfigurationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/admin/configuration").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateOrganizationConfigurationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("PATCH").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateOrganizationConfigurationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/json",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_organization_configuration(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateOrganizationConfiguration::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateOrganizationConfiguration",
            "macie2",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateOrganizationConfigurationInput {
    /// <p>Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.</p>
    pub auto_enable: bool,
}
impl UpdateOrganizationConfigurationInput {
    /// <p>Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.</p>
    pub fn auto_enable(&self) -> bool {
        self.auto_enable
    }
}
impl std::fmt::Debug for UpdateOrganizationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateOrganizationConfigurationInput");
        formatter.field("auto_enable", &self.auto_enable);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMemberSessionInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
    pub status: std::option::Option<crate::model::MacieStatus>,
}
impl UpdateMemberSessionInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MacieStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for UpdateMemberSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMemberSessionInput");
        formatter.field("id", &self.id);
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMacieSessionInput {
    /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    pub finding_publishing_frequency: std::option::Option<crate::model::FindingPublishingFrequency>,
    /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
    pub status: std::option::Option<crate::model::MacieStatus>,
}
impl UpdateMacieSessionInput {
    /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    pub fn finding_publishing_frequency(
        &self,
    ) -> std::option::Option<&crate::model::FindingPublishingFrequency> {
        self.finding_publishing_frequency.as_ref()
    }
    /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MacieStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for UpdateMacieSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMacieSessionInput");
        formatter.field(
            "finding_publishing_frequency",
            &self.finding_publishing_frequency,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateFindingsFilterInput {
    /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    pub action: std::option::Option<crate::model::FindingsFilterAction>,
    /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The criteria to use to filter findings.</p>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
    /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    pub position: i32,
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateFindingsFilterInput {
    /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FindingsFilterAction> {
        self.action.as_ref()
    }
    /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The criteria to use to filter findings.</p>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
    /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    pub fn position(&self) -> i32 {
        self.position
    }
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateFindingsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateFindingsFilterInput");
        formatter.field("action", &self.action);
        formatter.field("description", &self.description);
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.field("id", &self.id);
        formatter.field("name", &self.name);
        formatter.field("position", &self.position);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateClassificationJobInput {
    /// <p>The unique identifier for the classification job.</p>
    pub job_id: std::option::Option<std::string::String>,
    /// <p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>
    pub job_status: std::option::Option<crate::model::JobStatus>,
}
impl UpdateClassificationJobInput {
    /// <p>The unique identifier for the classification job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
    /// <p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>
    pub fn job_status(&self) -> std::option::Option<&crate::model::JobStatus> {
        self.job_status.as_ref()
    }
}
impl std::fmt::Debug for UpdateClassificationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateClassificationJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.field("job_status", &self.job_status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TestCustomDataIdentifierInput {
    /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
    pub ignore_words: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
    pub keywords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
    pub maximum_match_distance: i32,
    /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
    pub regex: std::option::Option<std::string::String>,
    /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
    pub sample_text: std::option::Option<std::string::String>,
}
impl TestCustomDataIdentifierInput {
    /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
    pub fn ignore_words(&self) -> std::option::Option<&[std::string::String]> {
        self.ignore_words.as_deref()
    }
    /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
    pub fn keywords(&self) -> std::option::Option<&[std::string::String]> {
        self.keywords.as_deref()
    }
    /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
    pub fn maximum_match_distance(&self) -> i32 {
        self.maximum_match_distance
    }
    /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
    pub fn regex(&self) -> std::option::Option<&str> {
        self.regex.as_deref()
    }
    /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
    pub fn sample_text(&self) -> std::option::Option<&str> {
        self.sample_text.as_deref()
    }
}
impl std::fmt::Debug for TestCustomDataIdentifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TestCustomDataIdentifierInput");
        formatter.field("ignore_words", &self.ignore_words);
        formatter.field("keywords", &self.keywords);
        formatter.field("maximum_match_distance", &self.maximum_match_distance);
        formatter.field("regex", &self.regex);
        formatter.field("sample_text", &self.sample_text);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct SearchResourcesInput {
    /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
    pub bucket_criteria: std::option::Option<crate::model::SearchResourcesBucketCriteria>,
    /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The criteria to use to sort the results.</p>
    pub sort_criteria: std::option::Option<crate::model::SearchResourcesSortCriteria>,
}
impl SearchResourcesInput {
    /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
    pub fn bucket_criteria(
        &self,
    ) -> std::option::Option<&crate::model::SearchResourcesBucketCriteria> {
        self.bucket_criteria.as_ref()
    }
    /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The criteria to use to sort the results.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::SearchResourcesSortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for SearchResourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("SearchResourcesInput");
        formatter.field("bucket_criteria", &self.bucket_criteria);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutFindingsPublicationConfigurationInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
    pub security_hub_configuration: std::option::Option<crate::model::SecurityHubConfiguration>,
}
impl PutFindingsPublicationConfigurationInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
    pub fn security_hub_configuration(
        &self,
    ) -> std::option::Option<&crate::model::SecurityHubConfiguration> {
        self.security_hub_configuration.as_ref()
    }
}
impl std::fmt::Debug for PutFindingsPublicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutFindingsPublicationConfigurationInput");
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "security_hub_configuration",
            &self.security_hub_configuration,
        );
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PutClassificationExportConfigurationInput {
    /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
    pub configuration: std::option::Option<crate::model::ClassificationExportConfiguration>,
}
impl PutClassificationExportConfigurationInput {
    /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
    pub fn configuration(
        &self,
    ) -> std::option::Option<&crate::model::ClassificationExportConfiguration> {
        self.configuration.as_ref()
    }
}
impl std::fmt::Debug for PutClassificationExportConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PutClassificationExportConfigurationInput");
        formatter.field("configuration", &self.configuration);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListOrganizationAdminAccountsInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListOrganizationAdminAccountsInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListOrganizationAdminAccountsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListOrganizationAdminAccountsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListMembersInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
    pub only_associated: std::option::Option<std::string::String>,
}
impl ListMembersInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
    pub fn only_associated(&self) -> std::option::Option<&str> {
        self.only_associated.as_deref()
    }
}
impl std::fmt::Debug for ListMembersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListMembersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("only_associated", &self.only_associated);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListManagedDataIdentifiersInput {
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListManagedDataIdentifiersInput {
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListManagedDataIdentifiersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListManagedDataIdentifiersInput");
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListInvitationsInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListInvitationsInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListInvitationsInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsFiltersInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListFindingsFiltersInput {
    /// <p>The maximum number of items to include in each page of a paginated response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListFindingsFiltersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsFiltersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListFindingsInput {
    /// <p>The criteria to use to filter the results.</p>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The criteria to use to sort the results.</p>
    pub sort_criteria: std::option::Option<crate::model::SortCriteria>,
}
impl ListFindingsInput {
    /// <p>The criteria to use to filter the results.</p>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The criteria to use to sort the results.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::SortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for ListFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListFindingsInput");
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListCustomDataIdentifiersInput {
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListCustomDataIdentifiersInput {
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListCustomDataIdentifiersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListCustomDataIdentifiersInput");
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListClassificationJobsInput {
    /// <p>The criteria to use to filter the results.</p>
    pub filter_criteria: std::option::Option<crate::model::ListJobsFilterCriteria>,
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The criteria to use to sort the results.</p>
    pub sort_criteria: std::option::Option<crate::model::ListJobsSortCriteria>,
}
impl ListClassificationJobsInput {
    /// <p>The criteria to use to filter the results.</p>
    pub fn filter_criteria(&self) -> std::option::Option<&crate::model::ListJobsFilterCriteria> {
        self.filter_criteria.as_ref()
    }
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The criteria to use to sort the results.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::ListJobsSortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for ListClassificationJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListClassificationJobsInput");
        formatter.field("filter_criteria", &self.filter_criteria);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsageTotalsInput {
    /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
    pub time_range: std::option::Option<std::string::String>,
}
impl GetUsageTotalsInput {
    /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
    pub fn time_range(&self) -> std::option::Option<&str> {
        self.time_range.as_deref()
    }
}
impl std::fmt::Debug for GetUsageTotalsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsageTotalsInput");
        formatter.field("time_range", &self.time_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetUsageStatisticsInput {
    /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
    pub filter_by: std::option::Option<std::vec::Vec<crate::model::UsageStatisticsFilter>>,
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The criteria to use to sort the query results.</p>
    pub sort_by: std::option::Option<crate::model::UsageStatisticsSortBy>,
    /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
    pub time_range: std::option::Option<crate::model::TimeRange>,
}
impl GetUsageStatisticsInput {
    /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
    pub fn filter_by(&self) -> std::option::Option<&[crate::model::UsageStatisticsFilter]> {
        self.filter_by.as_deref()
    }
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The criteria to use to sort the query results.</p>
    pub fn sort_by(&self) -> std::option::Option<&crate::model::UsageStatisticsSortBy> {
        self.sort_by.as_ref()
    }
    /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
    pub fn time_range(&self) -> std::option::Option<&crate::model::TimeRange> {
        self.time_range.as_ref()
    }
}
impl std::fmt::Debug for GetUsageStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetUsageStatisticsInput");
        formatter.field("filter_by", &self.filter_by);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("sort_by", &self.sort_by);
        formatter.field("time_range", &self.time_range);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMemberInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetMemberInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMemberInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMasterAccountInput {}
impl std::fmt::Debug for GetMasterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMasterAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMacieSessionInput {}
impl std::fmt::Debug for GetMacieSessionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMacieSessionInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetInvitationsCountInput {}
impl std::fmt::Debug for GetInvitationsCountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetInvitationsCountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingStatisticsInput {
    /// <p>The criteria to use to filter the query results.</p>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    /// <p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>
    pub group_by: std::option::Option<crate::model::GroupBy>,
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub size: i32,
    /// <p>The criteria to use to sort the query results.</p>
    pub sort_criteria: std::option::Option<crate::model::FindingStatisticsSortCriteria>,
}
impl GetFindingStatisticsInput {
    /// <p>The criteria to use to filter the query results.</p>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
    /// <p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>
    pub fn group_by(&self) -> std::option::Option<&crate::model::GroupBy> {
        self.group_by.as_ref()
    }
    /// <p>The maximum number of items to include in each page of the response.</p>
    pub fn size(&self) -> i32 {
        self.size
    }
    /// <p>The criteria to use to sort the query results.</p>
    pub fn sort_criteria(
        &self,
    ) -> std::option::Option<&crate::model::FindingStatisticsSortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for GetFindingStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingStatisticsInput");
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.field("group_by", &self.group_by);
        formatter.field("size", &self.size);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsPublicationConfigurationInput {}
impl std::fmt::Debug for GetFindingsPublicationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsPublicationConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsFilterInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetFindingsFilterInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetFindingsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsFilterInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetFindingsInput {
    /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
    pub finding_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The criteria for sorting the results of the request.</p>
    pub sort_criteria: std::option::Option<crate::model::SortCriteria>,
}
impl GetFindingsInput {
    /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
    pub fn finding_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.finding_ids.as_deref()
    }
    /// <p>The criteria for sorting the results of the request.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::SortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for GetFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetFindingsInput");
        formatter.field("finding_ids", &self.finding_ids);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetCustomDataIdentifierInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl GetCustomDataIdentifierInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for GetCustomDataIdentifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetCustomDataIdentifierInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetClassificationExportConfigurationInput {}
impl std::fmt::Debug for GetClassificationExportConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetClassificationExportConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBucketStatisticsInput {
    /// <p>The unique identifier for the Amazon Web Services account.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl GetBucketStatisticsInput {
    /// <p>The unique identifier for the Amazon Web Services account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for GetBucketStatisticsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBucketStatisticsInput");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetAdministratorAccountInput {}
impl std::fmt::Debug for GetAdministratorAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetAdministratorAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl EnableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for EnableOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct EnableMacieInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    pub finding_publishing_frequency: std::option::Option<crate::model::FindingPublishingFrequency>,
    /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
    pub status: std::option::Option<crate::model::MacieStatus>,
}
impl EnableMacieInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
    pub fn finding_publishing_frequency(
        &self,
    ) -> std::option::Option<&crate::model::FindingPublishingFrequency> {
        self.finding_publishing_frequency.as_ref()
    }
    /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::MacieStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for EnableMacieInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("EnableMacieInput");
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "finding_publishing_frequency",
            &self.finding_publishing_frequency,
        );
        formatter.field("status", &self.status);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateMemberInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DisassociateMemberInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DisassociateMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateMemberInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFromMasterAccountInput {}
impl std::fmt::Debug for DisassociateFromMasterAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFromMasterAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisassociateFromAdministratorAccountInput {}
impl std::fmt::Debug for DisassociateFromAdministratorAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisassociateFromAdministratorAccountInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
    pub admin_account_id: std::option::Option<std::string::String>,
}
impl DisableOrganizationAdminAccountInput {
    /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
    pub fn admin_account_id(&self) -> std::option::Option<&str> {
        self.admin_account_id.as_deref()
    }
}
impl std::fmt::Debug for DisableOrganizationAdminAccountInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableOrganizationAdminAccountInput");
        formatter.field("admin_account_id", &self.admin_account_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DisableMacieInput {}
impl std::fmt::Debug for DisableMacieInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DisableMacieInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeOrganizationConfigurationInput {}
impl std::fmt::Debug for DescribeOrganizationConfigurationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeOrganizationConfigurationInput");
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeClassificationJobInput {
    /// <p>The unique identifier for the classification job.</p>
    pub job_id: std::option::Option<std::string::String>,
}
impl DescribeClassificationJobInput {
    /// <p>The unique identifier for the classification job.</p>
    pub fn job_id(&self) -> std::option::Option<&str> {
        self.job_id.as_deref()
    }
}
impl std::fmt::Debug for DescribeClassificationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeClassificationJobInput");
        formatter.field("job_id", &self.job_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBucketsInput {
    /// <p>The criteria to use to filter the query results.</p>
    pub criteria: std::option::Option<
        std::collections::HashMap<
            std::string::String,
            crate::model::BucketCriteriaAdditionalProperties,
        >,
    >,
    /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
    pub max_results: i32,
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The criteria to use to sort the query results.</p>
    pub sort_criteria: std::option::Option<crate::model::BucketSortCriteria>,
}
impl DescribeBucketsInput {
    /// <p>The criteria to use to filter the query results.</p>
    pub fn criteria(
        &self,
    ) -> std::option::Option<
        &std::collections::HashMap<
            std::string::String,
            crate::model::BucketCriteriaAdditionalProperties,
        >,
    > {
        self.criteria.as_ref()
    }
    /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
    pub fn max_results(&self) -> i32 {
        self.max_results
    }
    /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The criteria to use to sort the query results.</p>
    pub fn sort_criteria(&self) -> std::option::Option<&crate::model::BucketSortCriteria> {
        self.sort_criteria.as_ref()
    }
}
impl std::fmt::Debug for DescribeBucketsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBucketsInput");
        formatter.field("criteria", &self.criteria);
        formatter.field("max_results", &self.max_results);
        formatter.field("next_token", &self.next_token);
        formatter.field("sort_criteria", &self.sort_criteria);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMemberInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteMemberInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMemberInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteInvitationsInput {
    /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeleteInvitationsInput {
    /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeleteInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteFindingsFilterInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteFindingsFilterInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteFindingsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteFindingsFilterInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteCustomDataIdentifierInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub id: std::option::Option<std::string::String>,
}
impl DeleteCustomDataIdentifierInput {
    /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
    pub fn id(&self) -> std::option::Option<&str> {
        self.id.as_deref()
    }
}
impl std::fmt::Debug for DeleteCustomDataIdentifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteCustomDataIdentifierInput");
        formatter.field("id", &self.id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeclineInvitationsInput {
    /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl DeclineInvitationsInput {
    /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
}
impl std::fmt::Debug for DeclineInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeclineInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateSampleFindingsInput {
    /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
    pub finding_types: std::option::Option<std::vec::Vec<crate::model::FindingType>>,
}
impl CreateSampleFindingsInput {
    /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
    pub fn finding_types(&self) -> std::option::Option<&[crate::model::FindingType]> {
        self.finding_types.as_deref()
    }
}
impl std::fmt::Debug for CreateSampleFindingsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateSampleFindingsInput");
        formatter.field("finding_types", &self.finding_types);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMemberInput {
    /// <p>The details of the account to associate with the administrator account.</p>
    pub account: std::option::Option<crate::model::AccountDetail>,
    /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateMemberInput {
    /// <p>The details of the account to associate with the administrator account.</p>
    pub fn account(&self) -> std::option::Option<&crate::model::AccountDetail> {
        self.account.as_ref()
    }
    /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateMemberInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMemberInput");
        formatter.field("account", &self.account);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateInvitationsInput {
    /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
    pub account_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true.</p>
    pub disable_email_notification: bool,
    /// <p>A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.</p>
    pub message: std::option::Option<std::string::String>,
}
impl CreateInvitationsInput {
    /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
    pub fn account_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.account_ids.as_deref()
    }
    /// <p>Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true.</p>
    pub fn disable_email_notification(&self) -> bool {
        self.disable_email_notification
    }
    /// <p>A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Debug for CreateInvitationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateInvitationsInput");
        formatter.field("account_ids", &self.account_ids);
        formatter.field(
            "disable_email_notification",
            &self.disable_email_notification,
        );
        formatter.field("message", &self.message);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateFindingsFilterInput {
    /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    pub action: std::option::Option<crate::model::FindingsFilterAction>,
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>The criteria to use to filter findings.</p>
    pub finding_criteria: std::option::Option<crate::model::FindingCriteria>,
    /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    pub position: i32,
    /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateFindingsFilterInput {
    /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
    pub fn action(&self) -> std::option::Option<&crate::model::FindingsFilterAction> {
        self.action.as_ref()
    }
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The criteria to use to filter findings.</p>
    pub fn finding_criteria(&self) -> std::option::Option<&crate::model::FindingCriteria> {
        self.finding_criteria.as_ref()
    }
    /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
    pub fn position(&self) -> i32 {
        self.position
    }
    /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateFindingsFilterInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateFindingsFilterInput");
        formatter.field("action", &self.action);
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &self.description);
        formatter.field("finding_criteria", &self.finding_criteria);
        formatter.field("name", &self.name);
        formatter.field("position", &self.position);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateCustomDataIdentifierInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
    pub ignore_words: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
    pub keywords: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
    pub maximum_match_distance: i32,
    /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
    pub regex: std::option::Option<std::string::String>,
    /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p> <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
    pub severity_levels: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
    /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateCustomDataIdentifierInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
    pub fn ignore_words(&self) -> std::option::Option<&[std::string::String]> {
        self.ignore_words.as_deref()
    }
    /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
    pub fn keywords(&self) -> std::option::Option<&[std::string::String]> {
        self.keywords.as_deref()
    }
    /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
    pub fn maximum_match_distance(&self) -> i32 {
        self.maximum_match_distance
    }
    /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
    pub fn regex(&self) -> std::option::Option<&str> {
        self.regex.as_deref()
    }
    /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p> <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
    pub fn severity_levels(&self) -> std::option::Option<&[crate::model::SeverityLevel]> {
        self.severity_levels.as_deref()
    }
    /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateCustomDataIdentifierInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateCustomDataIdentifierInput");
        formatter.field("client_token", &self.client_token);
        formatter.field("description", &self.description);
        formatter.field("ignore_words", &self.ignore_words);
        formatter.field("keywords", &self.keywords);
        formatter.field("maximum_match_distance", &self.maximum_match_distance);
        formatter.field("name", &self.name);
        formatter.field("regex", &self.regex);
        formatter.field("severity_levels", &self.severity_levels);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateClassificationJobInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
    pub custom_data_identifier_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p><p>If you configure the job to run only once, don't specify a value for this property.</p>
    pub initial_run: bool,
    /// <p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li></ul>
    pub job_type: std::option::Option<crate::model::JobType>,
    /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p><p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
    pub managed_data_identifier_ids: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
    pub managed_data_identifier_selector:
        std::option::Option<crate::model::ManagedDataIdentifierSelector>,
    /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
    pub s3_job_definition: std::option::Option<crate::model::S3JobDefinition>,
    /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
    pub sampling_percentage: i32,
    /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
    pub schedule_frequency: std::option::Option<crate::model::JobScheduleFrequency>,
    /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub tags:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
}
impl CreateClassificationJobInput {
    /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
    pub fn custom_data_identifier_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.custom_data_identifier_ids.as_deref()
    }
    /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p><p>If you configure the job to run only once, don't specify a value for this property.</p>
    pub fn initial_run(&self) -> bool {
        self.initial_run
    }
    /// <p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li></ul>
    pub fn job_type(&self) -> std::option::Option<&crate::model::JobType> {
        self.job_type.as_ref()
    }
    /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p><p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
    pub fn managed_data_identifier_ids(&self) -> std::option::Option<&[std::string::String]> {
        self.managed_data_identifier_ids.as_deref()
    }
    /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
    pub fn managed_data_identifier_selector(
        &self,
    ) -> std::option::Option<&crate::model::ManagedDataIdentifierSelector> {
        self.managed_data_identifier_selector.as_ref()
    }
    /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
    pub fn s3_job_definition(&self) -> std::option::Option<&crate::model::S3JobDefinition> {
        self.s3_job_definition.as_ref()
    }
    /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
    pub fn sampling_percentage(&self) -> i32 {
        self.sampling_percentage
    }
    /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
    pub fn schedule_frequency(&self) -> std::option::Option<&crate::model::JobScheduleFrequency> {
        self.schedule_frequency.as_ref()
    }
    /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
    pub fn tags(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.tags.as_ref()
    }
}
impl std::fmt::Debug for CreateClassificationJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateClassificationJobInput");
        formatter.field("client_token", &self.client_token);
        formatter.field(
            "custom_data_identifier_ids",
            &self.custom_data_identifier_ids,
        );
        formatter.field("description", &self.description);
        formatter.field("initial_run", &self.initial_run);
        formatter.field("job_type", &self.job_type);
        formatter.field(
            "managed_data_identifier_ids",
            &self.managed_data_identifier_ids,
        );
        formatter.field(
            "managed_data_identifier_selector",
            &self.managed_data_identifier_selector,
        );
        formatter.field("name", &self.name);
        formatter.field("s3_job_definition", &self.s3_job_definition);
        formatter.field("sampling_percentage", &self.sampling_percentage);
        formatter.field("schedule_frequency", &self.schedule_frequency);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct BatchGetCustomDataIdentifiersInput {
    /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
    pub ids: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl BatchGetCustomDataIdentifiersInput {
    /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
    pub fn ids(&self) -> std::option::Option<&[std::string::String]> {
        self.ids.as_deref()
    }
}
impl std::fmt::Debug for BatchGetCustomDataIdentifiersInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("BatchGetCustomDataIdentifiersInput");
        formatter.field("ids", &self.ids);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AcceptInvitationInput {
    /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
    pub administrator_account_id: std::option::Option<std::string::String>,
    /// <p>The unique identifier for the invitation to accept.</p>
    pub invitation_id: std::option::Option<std::string::String>,
    /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
    pub master_account: std::option::Option<std::string::String>,
}
impl AcceptInvitationInput {
    /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
    pub fn administrator_account_id(&self) -> std::option::Option<&str> {
        self.administrator_account_id.as_deref()
    }
    /// <p>The unique identifier for the invitation to accept.</p>
    pub fn invitation_id(&self) -> std::option::Option<&str> {
        self.invitation_id.as_deref()
    }
    /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
    pub fn master_account(&self) -> std::option::Option<&str> {
        self.master_account.as_deref()
    }
}
impl std::fmt::Debug for AcceptInvitationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AcceptInvitationInput");
        formatter.field("administrator_account_id", &self.administrator_account_id);
        formatter.field("invitation_id", &self.invitation_id);
        formatter.field("master_account", &self.master_account);
        formatter.finish()
    }
}
