// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// Client for Amazon Macie 2
///
/// Client for invoking operations on Amazon Macie 2. Each operation on Amazon Macie 2 is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_macie2::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operationname>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_macie2::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_macie2::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AcceptInvitation` operation.
    ///
    /// See [`AcceptInvitation`](crate::client::fluent_builders::AcceptInvitation) for more information about the
    /// operation and its arguments.
    pub fn accept_invitation(&self) -> fluent_builders::AcceptInvitation<C, M, R> {
        fluent_builders::AcceptInvitation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `BatchGetCustomDataIdentifiers` operation.
    ///
    /// See [`BatchGetCustomDataIdentifiers`](crate::client::fluent_builders::BatchGetCustomDataIdentifiers) for more information about the
    /// operation and its arguments.
    pub fn batch_get_custom_data_identifiers(
        &self,
    ) -> fluent_builders::BatchGetCustomDataIdentifiers<C, M, R> {
        fluent_builders::BatchGetCustomDataIdentifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateClassificationJob` operation.
    ///
    /// See [`CreateClassificationJob`](crate::client::fluent_builders::CreateClassificationJob) for more information about the
    /// operation and its arguments.
    pub fn create_classification_job(&self) -> fluent_builders::CreateClassificationJob<C, M, R> {
        fluent_builders::CreateClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateCustomDataIdentifier` operation.
    ///
    /// See [`CreateCustomDataIdentifier`](crate::client::fluent_builders::CreateCustomDataIdentifier) for more information about the
    /// operation and its arguments.
    pub fn create_custom_data_identifier(
        &self,
    ) -> fluent_builders::CreateCustomDataIdentifier<C, M, R> {
        fluent_builders::CreateCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateFindingsFilter` operation.
    ///
    /// See [`CreateFindingsFilter`](crate::client::fluent_builders::CreateFindingsFilter) for more information about the
    /// operation and its arguments.
    pub fn create_findings_filter(&self) -> fluent_builders::CreateFindingsFilter<C, M, R> {
        fluent_builders::CreateFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateInvitations` operation.
    ///
    /// See [`CreateInvitations`](crate::client::fluent_builders::CreateInvitations) for more information about the
    /// operation and its arguments.
    pub fn create_invitations(&self) -> fluent_builders::CreateInvitations<C, M, R> {
        fluent_builders::CreateInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMember` operation.
    ///
    /// See [`CreateMember`](crate::client::fluent_builders::CreateMember) for more information about the
    /// operation and its arguments.
    pub fn create_member(&self) -> fluent_builders::CreateMember<C, M, R> {
        fluent_builders::CreateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateSampleFindings` operation.
    ///
    /// See [`CreateSampleFindings`](crate::client::fluent_builders::CreateSampleFindings) for more information about the
    /// operation and its arguments.
    pub fn create_sample_findings(&self) -> fluent_builders::CreateSampleFindings<C, M, R> {
        fluent_builders::CreateSampleFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeclineInvitations` operation.
    ///
    /// See [`DeclineInvitations`](crate::client::fluent_builders::DeclineInvitations) for more information about the
    /// operation and its arguments.
    pub fn decline_invitations(&self) -> fluent_builders::DeclineInvitations<C, M, R> {
        fluent_builders::DeclineInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteCustomDataIdentifier` operation.
    ///
    /// See [`DeleteCustomDataIdentifier`](crate::client::fluent_builders::DeleteCustomDataIdentifier) for more information about the
    /// operation and its arguments.
    pub fn delete_custom_data_identifier(
        &self,
    ) -> fluent_builders::DeleteCustomDataIdentifier<C, M, R> {
        fluent_builders::DeleteCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteFindingsFilter` operation.
    ///
    /// See [`DeleteFindingsFilter`](crate::client::fluent_builders::DeleteFindingsFilter) for more information about the
    /// operation and its arguments.
    pub fn delete_findings_filter(&self) -> fluent_builders::DeleteFindingsFilter<C, M, R> {
        fluent_builders::DeleteFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteInvitations` operation.
    ///
    /// See [`DeleteInvitations`](crate::client::fluent_builders::DeleteInvitations) for more information about the
    /// operation and its arguments.
    pub fn delete_invitations(&self) -> fluent_builders::DeleteInvitations<C, M, R> {
        fluent_builders::DeleteInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMember` operation.
    ///
    /// See [`DeleteMember`](crate::client::fluent_builders::DeleteMember) for more information about the
    /// operation and its arguments.
    pub fn delete_member(&self) -> fluent_builders::DeleteMember<C, M, R> {
        fluent_builders::DeleteMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBuckets` operation.
    ///
    /// See [`DescribeBuckets`](crate::client::fluent_builders::DescribeBuckets) for more information about the
    /// operation and its arguments.
    pub fn describe_buckets(&self) -> fluent_builders::DescribeBuckets<C, M, R> {
        fluent_builders::DescribeBuckets::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeClassificationJob` operation.
    ///
    /// See [`DescribeClassificationJob`](crate::client::fluent_builders::DescribeClassificationJob) for more information about the
    /// operation and its arguments.
    pub fn describe_classification_job(
        &self,
    ) -> fluent_builders::DescribeClassificationJob<C, M, R> {
        fluent_builders::DescribeClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeOrganizationConfiguration` operation.
    ///
    /// See [`DescribeOrganizationConfiguration`](crate::client::fluent_builders::DescribeOrganizationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn describe_organization_configuration(
        &self,
    ) -> fluent_builders::DescribeOrganizationConfiguration<C, M, R> {
        fluent_builders::DescribeOrganizationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableMacie` operation.
    ///
    /// See [`DisableMacie`](crate::client::fluent_builders::DisableMacie) for more information about the
    /// operation and its arguments.
    pub fn disable_macie(&self) -> fluent_builders::DisableMacie<C, M, R> {
        fluent_builders::DisableMacie::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisableOrganizationAdminAccount` operation.
    ///
    /// See [`DisableOrganizationAdminAccount`](crate::client::fluent_builders::DisableOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn disable_organization_admin_account(
        &self,
    ) -> fluent_builders::DisableOrganizationAdminAccount<C, M, R> {
        fluent_builders::DisableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateFromAdministratorAccount` operation.
    ///
    /// See [`DisassociateFromAdministratorAccount`](crate::client::fluent_builders::DisassociateFromAdministratorAccount) for more information about the
    /// operation and its arguments.
    pub fn disassociate_from_administrator_account(
        &self,
    ) -> fluent_builders::DisassociateFromAdministratorAccount<C, M, R> {
        fluent_builders::DisassociateFromAdministratorAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateFromMasterAccount` operation.
    ///
    /// See [`DisassociateFromMasterAccount`](crate::client::fluent_builders::DisassociateFromMasterAccount) for more information about the
    /// operation and its arguments.
    pub fn disassociate_from_master_account(
        &self,
    ) -> fluent_builders::DisassociateFromMasterAccount<C, M, R> {
        fluent_builders::DisassociateFromMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DisassociateMember` operation.
    ///
    /// See [`DisassociateMember`](crate::client::fluent_builders::DisassociateMember) for more information about the
    /// operation and its arguments.
    pub fn disassociate_member(&self) -> fluent_builders::DisassociateMember<C, M, R> {
        fluent_builders::DisassociateMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableMacie` operation.
    ///
    /// See [`EnableMacie`](crate::client::fluent_builders::EnableMacie) for more information about the
    /// operation and its arguments.
    pub fn enable_macie(&self) -> fluent_builders::EnableMacie<C, M, R> {
        fluent_builders::EnableMacie::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `EnableOrganizationAdminAccount` operation.
    ///
    /// See [`EnableOrganizationAdminAccount`](crate::client::fluent_builders::EnableOrganizationAdminAccount) for more information about the
    /// operation and its arguments.
    pub fn enable_organization_admin_account(
        &self,
    ) -> fluent_builders::EnableOrganizationAdminAccount<C, M, R> {
        fluent_builders::EnableOrganizationAdminAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetAdministratorAccount` operation.
    ///
    /// See [`GetAdministratorAccount`](crate::client::fluent_builders::GetAdministratorAccount) for more information about the
    /// operation and its arguments.
    pub fn get_administrator_account(&self) -> fluent_builders::GetAdministratorAccount<C, M, R> {
        fluent_builders::GetAdministratorAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBucketStatistics` operation.
    ///
    /// See [`GetBucketStatistics`](crate::client::fluent_builders::GetBucketStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_bucket_statistics(&self) -> fluent_builders::GetBucketStatistics<C, M, R> {
        fluent_builders::GetBucketStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetClassificationExportConfiguration` operation.
    ///
    /// See [`GetClassificationExportConfiguration`](crate::client::fluent_builders::GetClassificationExportConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_classification_export_configuration(
        &self,
    ) -> fluent_builders::GetClassificationExportConfiguration<C, M, R> {
        fluent_builders::GetClassificationExportConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetCustomDataIdentifier` operation.
    ///
    /// See [`GetCustomDataIdentifier`](crate::client::fluent_builders::GetCustomDataIdentifier) for more information about the
    /// operation and its arguments.
    pub fn get_custom_data_identifier(&self) -> fluent_builders::GetCustomDataIdentifier<C, M, R> {
        fluent_builders::GetCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindings` operation.
    ///
    /// See [`GetFindings`](crate::client::fluent_builders::GetFindings) for more information about the
    /// operation and its arguments.
    pub fn get_findings(&self) -> fluent_builders::GetFindings<C, M, R> {
        fluent_builders::GetFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindingsFilter` operation.
    ///
    /// See [`GetFindingsFilter`](crate::client::fluent_builders::GetFindingsFilter) for more information about the
    /// operation and its arguments.
    pub fn get_findings_filter(&self) -> fluent_builders::GetFindingsFilter<C, M, R> {
        fluent_builders::GetFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindingsPublicationConfiguration` operation.
    ///
    /// See [`GetFindingsPublicationConfiguration`](crate::client::fluent_builders::GetFindingsPublicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn get_findings_publication_configuration(
        &self,
    ) -> fluent_builders::GetFindingsPublicationConfiguration<C, M, R> {
        fluent_builders::GetFindingsPublicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetFindingStatistics` operation.
    ///
    /// See [`GetFindingStatistics`](crate::client::fluent_builders::GetFindingStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_finding_statistics(&self) -> fluent_builders::GetFindingStatistics<C, M, R> {
        fluent_builders::GetFindingStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetInvitationsCount` operation.
    ///
    /// See [`GetInvitationsCount`](crate::client::fluent_builders::GetInvitationsCount) for more information about the
    /// operation and its arguments.
    pub fn get_invitations_count(&self) -> fluent_builders::GetInvitationsCount<C, M, R> {
        fluent_builders::GetInvitationsCount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMacieSession` operation.
    ///
    /// See [`GetMacieSession`](crate::client::fluent_builders::GetMacieSession) for more information about the
    /// operation and its arguments.
    pub fn get_macie_session(&self) -> fluent_builders::GetMacieSession<C, M, R> {
        fluent_builders::GetMacieSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMasterAccount` operation.
    ///
    /// See [`GetMasterAccount`](crate::client::fluent_builders::GetMasterAccount) for more information about the
    /// operation and its arguments.
    pub fn get_master_account(&self) -> fluent_builders::GetMasterAccount<C, M, R> {
        fluent_builders::GetMasterAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMember` operation.
    ///
    /// See [`GetMember`](crate::client::fluent_builders::GetMember) for more information about the
    /// operation and its arguments.
    pub fn get_member(&self) -> fluent_builders::GetMember<C, M, R> {
        fluent_builders::GetMember::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsageStatistics` operation.
    ///
    /// See [`GetUsageStatistics`](crate::client::fluent_builders::GetUsageStatistics) for more information about the
    /// operation and its arguments.
    pub fn get_usage_statistics(&self) -> fluent_builders::GetUsageStatistics<C, M, R> {
        fluent_builders::GetUsageStatistics::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetUsageTotals` operation.
    ///
    /// See [`GetUsageTotals`](crate::client::fluent_builders::GetUsageTotals) for more information about the
    /// operation and its arguments.
    pub fn get_usage_totals(&self) -> fluent_builders::GetUsageTotals<C, M, R> {
        fluent_builders::GetUsageTotals::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListClassificationJobs` operation.
    ///
    /// See [`ListClassificationJobs`](crate::client::fluent_builders::ListClassificationJobs) for more information about the
    /// operation and its arguments.
    pub fn list_classification_jobs(&self) -> fluent_builders::ListClassificationJobs<C, M, R> {
        fluent_builders::ListClassificationJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListCustomDataIdentifiers` operation.
    ///
    /// See [`ListCustomDataIdentifiers`](crate::client::fluent_builders::ListCustomDataIdentifiers) for more information about the
    /// operation and its arguments.
    pub fn list_custom_data_identifiers(
        &self,
    ) -> fluent_builders::ListCustomDataIdentifiers<C, M, R> {
        fluent_builders::ListCustomDataIdentifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindings` operation.
    ///
    /// See [`ListFindings`](crate::client::fluent_builders::ListFindings) for more information about the
    /// operation and its arguments.
    pub fn list_findings(&self) -> fluent_builders::ListFindings<C, M, R> {
        fluent_builders::ListFindings::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListFindingsFilters` operation.
    ///
    /// See [`ListFindingsFilters`](crate::client::fluent_builders::ListFindingsFilters) for more information about the
    /// operation and its arguments.
    pub fn list_findings_filters(&self) -> fluent_builders::ListFindingsFilters<C, M, R> {
        fluent_builders::ListFindingsFilters::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListInvitations` operation.
    ///
    /// See [`ListInvitations`](crate::client::fluent_builders::ListInvitations) for more information about the
    /// operation and its arguments.
    pub fn list_invitations(&self) -> fluent_builders::ListInvitations<C, M, R> {
        fluent_builders::ListInvitations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListManagedDataIdentifiers` operation.
    ///
    /// See [`ListManagedDataIdentifiers`](crate::client::fluent_builders::ListManagedDataIdentifiers) for more information about the
    /// operation and its arguments.
    pub fn list_managed_data_identifiers(
        &self,
    ) -> fluent_builders::ListManagedDataIdentifiers<C, M, R> {
        fluent_builders::ListManagedDataIdentifiers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListMembers` operation.
    ///
    /// See [`ListMembers`](crate::client::fluent_builders::ListMembers) for more information about the
    /// operation and its arguments.
    pub fn list_members(&self) -> fluent_builders::ListMembers<C, M, R> {
        fluent_builders::ListMembers::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListOrganizationAdminAccounts` operation.
    ///
    /// See [`ListOrganizationAdminAccounts`](crate::client::fluent_builders::ListOrganizationAdminAccounts) for more information about the
    /// operation and its arguments.
    pub fn list_organization_admin_accounts(
        &self,
    ) -> fluent_builders::ListOrganizationAdminAccounts<C, M, R> {
        fluent_builders::ListOrganizationAdminAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutClassificationExportConfiguration` operation.
    ///
    /// See [`PutClassificationExportConfiguration`](crate::client::fluent_builders::PutClassificationExportConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_classification_export_configuration(
        &self,
    ) -> fluent_builders::PutClassificationExportConfiguration<C, M, R> {
        fluent_builders::PutClassificationExportConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `PutFindingsPublicationConfiguration` operation.
    ///
    /// See [`PutFindingsPublicationConfiguration`](crate::client::fluent_builders::PutFindingsPublicationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn put_findings_publication_configuration(
        &self,
    ) -> fluent_builders::PutFindingsPublicationConfiguration<C, M, R> {
        fluent_builders::PutFindingsPublicationConfiguration::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `SearchResources` operation.
    ///
    /// See [`SearchResources`](crate::client::fluent_builders::SearchResources) for more information about the
    /// operation and its arguments.
    pub fn search_resources(&self) -> fluent_builders::SearchResources<C, M, R> {
        fluent_builders::SearchResources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TestCustomDataIdentifier` operation.
    ///
    /// See [`TestCustomDataIdentifier`](crate::client::fluent_builders::TestCustomDataIdentifier) for more information about the
    /// operation and its arguments.
    pub fn test_custom_data_identifier(
        &self,
    ) -> fluent_builders::TestCustomDataIdentifier<C, M, R> {
        fluent_builders::TestCustomDataIdentifier::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateClassificationJob` operation.
    ///
    /// See [`UpdateClassificationJob`](crate::client::fluent_builders::UpdateClassificationJob) for more information about the
    /// operation and its arguments.
    pub fn update_classification_job(&self) -> fluent_builders::UpdateClassificationJob<C, M, R> {
        fluent_builders::UpdateClassificationJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateFindingsFilter` operation.
    ///
    /// See [`UpdateFindingsFilter`](crate::client::fluent_builders::UpdateFindingsFilter) for more information about the
    /// operation and its arguments.
    pub fn update_findings_filter(&self) -> fluent_builders::UpdateFindingsFilter<C, M, R> {
        fluent_builders::UpdateFindingsFilter::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMacieSession` operation.
    ///
    /// See [`UpdateMacieSession`](crate::client::fluent_builders::UpdateMacieSession) for more information about the
    /// operation and its arguments.
    pub fn update_macie_session(&self) -> fluent_builders::UpdateMacieSession<C, M, R> {
        fluent_builders::UpdateMacieSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMemberSession` operation.
    ///
    /// See [`UpdateMemberSession`](crate::client::fluent_builders::UpdateMemberSession) for more information about the
    /// operation and its arguments.
    pub fn update_member_session(&self) -> fluent_builders::UpdateMemberSession<C, M, R> {
        fluent_builders::UpdateMemberSession::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateOrganizationConfiguration` operation.
    ///
    /// See [`UpdateOrganizationConfiguration`](crate::client::fluent_builders::UpdateOrganizationConfiguration) for more information about the
    /// operation and its arguments.
    pub fn update_organization_configuration(
        &self,
    ) -> fluent_builders::UpdateOrganizationConfiguration<C, M, R> {
        fluent_builders::UpdateOrganizationConfiguration::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AcceptInvitation`.
    ///
    /// <p>Accepts an Amazon Macie membership invitation that was received from a specific account.</p>
    #[derive(std::fmt::Debug)]
    pub struct AcceptInvitation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::accept_invitation_input::Builder,
    }
    impl<C, M, R> AcceptInvitation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AcceptInvitation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AcceptInvitationOutput,
            aws_smithy_http::result::SdkError<crate::error::AcceptInvitationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AcceptInvitationInputOperationOutputAlias,
                crate::output::AcceptInvitationOutput,
                crate::error::AcceptInvitationError,
                crate::input::AcceptInvitationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn administrator_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.administrator_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the account that sent the invitation.</p>
        pub fn set_administrator_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_administrator_account_id(input);
            self
        }
        /// <p>The unique identifier for the invitation to accept.</p>
        pub fn invitation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.invitation_id(inp);
            self
        }
        /// <p>The unique identifier for the invitation to accept.</p>
        pub fn set_invitation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_invitation_id(input);
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn master_account(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.master_account(inp);
            self
        }
        /// <p>(Deprecated) The Amazon Web Services account ID for the account that sent the invitation. This property has been replaced by the administratorAccountId property and is retained only for backward compatibility.</p>
        pub fn set_master_account(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_master_account(input);
            self
        }
    }
    /// Fluent builder constructing a request to `BatchGetCustomDataIdentifiers`.
    ///
    /// <p>Retrieves information about one or more custom data identifiers.</p>
    #[derive(std::fmt::Debug)]
    pub struct BatchGetCustomDataIdentifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::batch_get_custom_data_identifiers_input::Builder,
    }
    impl<C, M, R> BatchGetCustomDataIdentifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `BatchGetCustomDataIdentifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::BatchGetCustomDataIdentifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::BatchGetCustomDataIdentifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::BatchGetCustomDataIdentifiersInputOperationOutputAlias,
                crate::output::BatchGetCustomDataIdentifiersOutput,
                crate::error::BatchGetCustomDataIdentifiersError,
                crate::input::BatchGetCustomDataIdentifiersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ids`.
        ///
        /// To override the contents of this collection use [`set_ids`](Self::set_ids).
        ///
        /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
        pub fn ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ids(inp);
            self
        }
        /// <p>An array of custom data identifier IDs, one for each custom data identifier to retrieve information about.</p>
        pub fn set_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateClassificationJob`.
    ///
    /// <p>Creates and defines the settings for a classification job.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_classification_job_input::Builder,
    }
    impl<C, M, R> CreateClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateClassificationJobInputOperationOutputAlias,
                crate::output::CreateClassificationJobOutput,
                crate::error::CreateClassificationJobError,
                crate::input::CreateClassificationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// Appends an item to `customDataIdentifierIds`.
        ///
        /// To override the contents of this collection use [`set_custom_data_identifier_ids`](Self::set_custom_data_identifier_ids).
        ///
        /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
        pub fn custom_data_identifier_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.custom_data_identifier_ids(inp);
            self
        }
        /// <p>An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.</p>
        pub fn set_custom_data_identifier_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_custom_data_identifier_ids(input);
            self
        }
        /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A custom description of the job. The description can contain as many as 200 characters.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p><p>If you configure the job to run only once, don't specify a value for this property.</p>
        pub fn initial_run(mut self, inp: bool) -> Self {
            self.inner = self.inner.initial_run(inp);
            self
        }
        /// <p>For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.</p><p>If you configure the job to run only once, don't specify a value for this property.</p>
        pub fn set_initial_run(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_initial_run(input);
            self
        }
        /// <p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li></ul>
        pub fn job_type(mut self, inp: crate::model::JobType) -> Self {
            self.inner = self.inner.job_type(inp);
            self
        }
        /// <p>The schedule for running the job. Valid values are:</p> <ul><li><p>ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.</p></li> <li><p>SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.</p></li></ul>
        pub fn set_job_type(mut self, input: std::option::Option<crate::model::JobType>) -> Self {
            self.inner = self.inner.set_job_type(input);
            self
        }
        /// Appends an item to `managedDataIdentifierIds`.
        ///
        /// To override the contents of this collection use [`set_managed_data_identifier_ids`](Self::set_managed_data_identifier_ids).
        ///
        /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p><p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
        pub fn managed_data_identifier_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.managed_data_identifier_ids(inp);
            self
        }
        /// <p>An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).</p><p>To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.</p>
        pub fn set_managed_data_identifier_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_managed_data_identifier_ids(input);
            self
        }
        /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
        pub fn managed_data_identifier_selector(
            mut self,
            inp: crate::model::ManagedDataIdentifierSelector,
        ) -> Self {
            self.inner = self.inner.managed_data_identifier_selector(inp);
            self
        }
        /// <p>The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:</p> <ul><li><p>ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.</p></li> <li><p>EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.</p></li> <li><p>NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.</p></li></ul> <p>If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.</p>
        pub fn set_managed_data_identifier_selector(
            mut self,
            input: std::option::Option<crate::model::ManagedDataIdentifierSelector>,
        ) -> Self {
            self.inner = self.inner.set_managed_data_identifier_selector(input);
            self
        }
        /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A custom name for the job. The name can contain as many as 500 characters.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
        pub fn s3_job_definition(mut self, inp: crate::model::S3JobDefinition) -> Self {
            self.inner = self.inner.s3_job_definition(inp);
            self
        }
        /// <p>The S3 buckets that contain the objects to analyze, and the scope of that analysis.</p>
        pub fn set_s3_job_definition(
            mut self,
            input: std::option::Option<crate::model::S3JobDefinition>,
        ) -> Self {
            self.inner = self.inner.set_s3_job_definition(input);
            self
        }
        /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
        pub fn sampling_percentage(mut self, inp: i32) -> Self {
            self.inner = self.inner.sampling_percentage(inp);
            self
        }
        /// <p>The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.</p>
        pub fn set_sampling_percentage(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_sampling_percentage(input);
            self
        }
        /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
        pub fn schedule_frequency(mut self, inp: crate::model::JobScheduleFrequency) -> Self {
            self.inner = self.inner.schedule_frequency(inp);
            self
        }
        /// <p>The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.</p>
        pub fn set_schedule_frequency(
            mut self,
            input: std::option::Option<crate::model::JobScheduleFrequency>,
        ) -> Self {
            self.inner = self.inner.set_schedule_frequency(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the job.</p> <p>A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateCustomDataIdentifier`.
    ///
    /// <p>Creates and defines the criteria and other settings for a custom data identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> CreateCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateCustomDataIdentifierInputOperationOutputAlias,
                crate::output::CreateCustomDataIdentifierOutput,
                crate::error::CreateCustomDataIdentifierError,
                crate::input::CreateCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A custom description of the custom data identifier. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see the identifier's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// Appends an item to `ignoreWords`.
        ///
        /// To override the contents of this collection use [`set_ignore_words`](Self::set_ignore_words).
        ///
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn ignore_words(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ignore_words(inp);
            self
        }
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn set_ignore_words(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ignore_words(input);
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn keywords(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(inp);
            self
        }
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn maximum_match_distance(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_match_distance(inp);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn set_maximum_match_distance(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_match_distance(input);
            self
        }
        /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A custom name for the custom data identifier. The name can contain as many as 128 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see the identifier's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn regex(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex(inp);
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_regex(input);
            self
        }
        /// Appends an item to `severityLevels`.
        ///
        /// To override the contents of this collection use [`set_severity_levels`](Self::set_severity_levels).
        ///
        /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p> <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
        pub fn severity_levels(mut self, inp: impl Into<crate::model::SeverityLevel>) -> Self {
            self.inner = self.inner.severity_levels(inp);
            self
        }
        /// <p>The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.</p> <p>If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.</p>
        pub fn set_severity_levels(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::SeverityLevel>>,
        ) -> Self {
            self.inner = self.inner.set_severity_levels(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the custom data identifier.</p> <p>A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateFindingsFilter`.
    ///
    /// <p>Creates and defines the criteria and other settings for a findings filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_findings_filter_input::Builder,
    }
    impl<C, M, R> CreateFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateFindingsFilterInputOperationOutputAlias,
                crate::output::CreateFindingsFilterOutput,
                crate::error::CreateFindingsFilterError,
                crate::input::CreateFindingsFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, inp: crate::model::FindingsFilterAction) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn position(mut self, inp: i32) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn set_position(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the filter.</p> <p>A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateInvitations`.
    ///
    /// <p>Sends an Amazon Macie membership invitation to one or more accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_invitations_input::Builder,
    }
    impl<C, M, R> CreateInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateInvitationsInputOperationOutputAlias,
                crate::output::CreateInvitationsOutput,
                crate::error::CreateInvitationsError,
                crate::input::CreateInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account to send the invitation to.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
        /// <p>Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true.</p>
        pub fn disable_email_notification(mut self, inp: bool) -> Self {
            self.inner = self.inner.disable_email_notification(inp);
            self
        }
        /// <p>Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in Personal Health Dashboard. To send an email notification to the root user of each account, set this value to true.</p>
        pub fn set_disable_email_notification(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_disable_email_notification(input);
            self
        }
        /// <p>A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.</p>
        pub fn message(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.message(inp);
            self
        }
        /// <p>A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_message(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMember`.
    ///
    /// <p>Associates an account with an Amazon Macie administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_member_input::Builder,
    }
    impl<C, M, R> CreateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMemberInputOperationOutputAlias,
                crate::output::CreateMemberOutput,
                crate::error::CreateMemberError,
                crate::input::CreateMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The details of the account to associate with the administrator account.</p>
        pub fn account(mut self, inp: crate::model::AccountDetail) -> Self {
            self.inner = self.inner.account(inp);
            self
        }
        /// <p>The details of the account to associate with the administrator account.</p>
        pub fn set_account(
            mut self,
            input: std::option::Option<crate::model::AccountDetail>,
        ) -> Self {
            self.inner = self.inner.set_account(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p> <p>An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateSampleFindings`.
    ///
    /// <p>Creates sample findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateSampleFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_sample_findings_input::Builder,
    }
    impl<C, M, R> CreateSampleFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateSampleFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateSampleFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateSampleFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateSampleFindingsInputOperationOutputAlias,
                crate::output::CreateSampleFindingsOutput,
                crate::error::CreateSampleFindingsError,
                crate::input::CreateSampleFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingTypes`.
        ///
        /// To override the contents of this collection use [`set_finding_types`](Self::set_finding_types).
        ///
        /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
        pub fn finding_types(mut self, inp: impl Into<crate::model::FindingType>) -> Self {
            self.inner = self.inner.finding_types(inp);
            self
        }
        /// <p>An array of finding types, one for each type of sample finding to create. To create a sample of every type of finding that Amazon Macie supports, don't include this array in your request.</p>
        pub fn set_finding_types(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::FindingType>>,
        ) -> Self {
            self.inner = self.inner.set_finding_types(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeclineInvitations`.
    ///
    /// <p>Declines Amazon Macie membership invitations that were received from specific accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeclineInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::decline_invitations_input::Builder,
    }
    impl<C, M, R> DeclineInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeclineInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeclineInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeclineInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeclineInvitationsInputOperationOutputAlias,
                crate::output::DeclineInvitationsOutput,
                crate::error::DeclineInvitationsError,
                crate::input::DeclineInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to decline.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteCustomDataIdentifier`.
    ///
    /// <p>Soft deletes a custom data identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> DeleteCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteCustomDataIdentifierInputOperationOutputAlias,
                crate::output::DeleteCustomDataIdentifierOutput,
                crate::error::DeleteCustomDataIdentifierError,
                crate::input::DeleteCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteFindingsFilter`.
    ///
    /// <p>Deletes a findings filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_findings_filter_input::Builder,
    }
    impl<C, M, R> DeleteFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteFindingsFilterInputOperationOutputAlias,
                crate::output::DeleteFindingsFilterOutput,
                crate::error::DeleteFindingsFilterError,
                crate::input::DeleteFindingsFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteInvitations`.
    ///
    /// <p>Deletes Amazon Macie membership invitations that were received from specific accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_invitations_input::Builder,
    }
    impl<C, M, R> DeleteInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteInvitationsInputOperationOutputAlias,
                crate::output::DeleteInvitationsOutput,
                crate::error::DeleteInvitationsError,
                crate::input::DeleteInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `accountIds`.
        ///
        /// To override the contents of this collection use [`set_account_ids`](Self::set_account_ids).
        ///
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
        pub fn account_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_ids(inp);
            self
        }
        /// <p>An array that lists Amazon Web Services account IDs, one for each account that sent an invitation to delete.</p>
        pub fn set_account_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_account_ids(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMember`.
    ///
    /// <p>Deletes the association between an Amazon Macie administrator account and an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_member_input::Builder,
    }
    impl<C, M, R> DeleteMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMemberInputOperationOutputAlias,
                crate::output::DeleteMemberOutput,
                crate::error::DeleteMemberError,
                crate::input::DeleteMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBuckets`.
    ///
    /// <p>Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBuckets<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_buckets_input::Builder,
    }
    impl<C, M, R> DescribeBuckets<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBuckets`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBucketsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBucketsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBucketsInputOperationOutputAlias,
                crate::output::DescribeBucketsOutput,
                crate::error::DescribeBucketsError,
                crate::input::DescribeBucketsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Adds a key-value pair to `criteria`.
        ///
        /// To override the contents of this collection use [`set_criteria`](Self::set_criteria).
        ///
        /// <p>The criteria to use to filter the query results.</p>
        pub fn criteria(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<crate::model::BucketCriteriaAdditionalProperties>,
        ) -> Self {
            self.inner = self.inner.criteria(k, v);
            self
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn set_criteria(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<
                    std::string::String,
                    crate::model::BucketCriteriaAdditionalProperties,
                >,
            >,
        ) -> Self {
            self.inner = self.inner.set_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_criteria(mut self, inp: crate::model::BucketSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::BucketSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeClassificationJob`.
    ///
    /// <p>Retrieves the status and settings for a classification job.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_classification_job_input::Builder,
    }
    impl<C, M, R> DescribeClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeClassificationJobInputOperationOutputAlias,
                crate::output::DescribeClassificationJobOutput,
                crate::error::DescribeClassificationJobError,
                crate::input::DescribeClassificationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeOrganizationConfiguration`.
    ///
    /// <p>Retrieves the Amazon Macie configuration settings for an Amazon Web Services organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_organization_configuration_input::Builder,
    }
    impl<C, M, R> DescribeOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeOrganizationConfigurationInputOperationOutputAlias,
                crate::output::DescribeOrganizationConfigurationOutput,
                crate::error::DescribeOrganizationConfigurationError,
                crate::input::DescribeOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableMacie`.
    ///
    /// <p>Disables an Amazon Macie account and deletes Macie resources for the account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableMacie<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_macie_input::Builder,
    }
    impl<C, M, R> DisableMacie<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableMacie`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableMacieOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableMacieError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableMacieInputOperationOutputAlias,
                crate::output::DisableMacieOutput,
                crate::error::DisableMacieError,
                crate::input::DisableMacieInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisableOrganizationAdminAccount`.
    ///
    /// <p>Disables an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> DisableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::DisableOrganizationAdminAccountOutput,
                crate::error::DisableOrganizationAdminAccountError,
                crate::input::DisableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
        pub fn admin_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID of the delegated Amazon Macie administrator account.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromAdministratorAccount`.
    ///
    /// <p>Disassociates a member account from its Amazon Macie administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateFromAdministratorAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_administrator_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromAdministratorAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromAdministratorAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromAdministratorAccountOutput,
            aws_smithy_http::result::SdkError<
                crate::error::DisassociateFromAdministratorAccountError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromAdministratorAccountInputOperationOutputAlias,
                crate::output::DisassociateFromAdministratorAccountOutput,
                crate::error::DisassociateFromAdministratorAccountError,
                crate::input::DisassociateFromAdministratorAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateFromMasterAccount`.
    ///
    /// <p>(Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link  linkend="DisassociateFromAdministratorAccount">DisassociateFromAdministratorAccount</link> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateFromMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_from_master_account_input::Builder,
    }
    impl<C, M, R> DisassociateFromMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateFromMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateFromMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateFromMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateFromMasterAccountInputOperationOutputAlias,
                crate::output::DisassociateFromMasterAccountOutput,
                crate::error::DisassociateFromMasterAccountError,
                crate::input::DisassociateFromMasterAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `DisassociateMember`.
    ///
    /// <p>Disassociates an Amazon Macie administrator account from a member account.</p>
    #[derive(std::fmt::Debug)]
    pub struct DisassociateMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::disassociate_member_input::Builder,
    }
    impl<C, M, R> DisassociateMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DisassociateMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DisassociateMemberInputOperationOutputAlias,
                crate::output::DisassociateMemberOutput,
                crate::error::DisassociateMemberError,
                crate::input::DisassociateMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableMacie`.
    ///
    /// <p>Enables Amazon Macie and specifies the configuration settings for a Macie account.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableMacie<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_macie_input::Builder,
    }
    impl<C, M, R> EnableMacie<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableMacie`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableMacieOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableMacieError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableMacieInputOperationOutputAlias,
                crate::output::EnableMacieOutput,
                crate::error::EnableMacieError,
                crate::input::EnableMacieInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn finding_publishing_frequency(
            mut self,
            inp: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.inner = self.inner.finding_publishing_frequency(inp);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.inner = self.inner.set_finding_publishing_frequency(input);
            self
        }
        /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
        pub fn status(mut self, inp: crate::model::MacieStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>Specifies the new status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to ENABLED.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `EnableOrganizationAdminAccount`.
    ///
    /// <p>Designates an account as the delegated Amazon Macie administrator account for an Amazon Web Services organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct EnableOrganizationAdminAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::enable_organization_admin_account_input::Builder,
    }
    impl<C, M, R> EnableOrganizationAdminAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `EnableOrganizationAdminAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::EnableOrganizationAdminAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::EnableOrganizationAdminAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::EnableOrganizationAdminAccountInputOperationOutputAlias,
                crate::output::EnableOrganizationAdminAccountOutput,
                crate::error::EnableOrganizationAdminAccountError,
                crate::input::EnableOrganizationAdminAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn admin_account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.admin_account_id(inp);
            self
        }
        /// <p>The Amazon Web Services account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.</p>
        pub fn set_admin_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_admin_account_id(input);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetAdministratorAccount`.
    ///
    /// <p>Retrieves information about the Amazon Macie administrator account for an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetAdministratorAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_administrator_account_input::Builder,
    }
    impl<C, M, R> GetAdministratorAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetAdministratorAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetAdministratorAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetAdministratorAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetAdministratorAccountInputOperationOutputAlias,
                crate::output::GetAdministratorAccountOutput,
                crate::error::GetAdministratorAccountError,
                crate::input::GetAdministratorAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetBucketStatistics`.
    ///
    /// <p>Retrieves (queries) aggregated statistical data for all the S3 buckets that Amazon Macie monitors and analyzes.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBucketStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_bucket_statistics_input::Builder,
    }
    impl<C, M, R> GetBucketStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBucketStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBucketStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBucketStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBucketStatisticsInputOperationOutputAlias,
                crate::output::GetBucketStatisticsOutput,
                crate::error::GetBucketStatisticsError,
                crate::input::GetBucketStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn account_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.account_id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Web Services account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetClassificationExportConfiguration`.
    ///
    /// <p>Retrieves the configuration settings for storing data classification results.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetClassificationExportConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_classification_export_configuration_input::Builder,
    }
    impl<C, M, R> GetClassificationExportConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetClassificationExportConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetClassificationExportConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetClassificationExportConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetClassificationExportConfigurationInputOperationOutputAlias,
                crate::output::GetClassificationExportConfigurationOutput,
                crate::error::GetClassificationExportConfigurationError,
                crate::input::GetClassificationExportConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetCustomDataIdentifier`.
    ///
    /// <p>Retrieves the criteria and other settings for a custom data identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> GetCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::GetCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetCustomDataIdentifierInputOperationOutputAlias,
                crate::output::GetCustomDataIdentifierOutput,
                crate::error::GetCustomDataIdentifierError,
                crate::input::GetCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindings`.
    ///
    /// <p>Retrieves the details of one or more findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_input::Builder,
    }
    impl<C, M, R> GetFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsInputOperationOutputAlias,
                crate::output::GetFindingsOutput,
                crate::error::GetFindingsError,
                crate::input::GetFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `findingIds`.
        ///
        /// To override the contents of this collection use [`set_finding_ids`](Self::set_finding_ids).
        ///
        /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
        pub fn finding_ids(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.finding_ids(inp);
            self
        }
        /// <p>An array of strings that lists the unique identifiers for the findings to retrieve.</p>
        pub fn set_finding_ids(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_finding_ids(input);
            self
        }
        /// <p>The criteria for sorting the results of the request.</p>
        pub fn sort_criteria(mut self, inp: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The criteria for sorting the results of the request.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingsFilter`.
    ///
    /// <p>Retrieves the criteria and other settings for a findings filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_filter_input::Builder,
    }
    impl<C, M, R> GetFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsFilterInputOperationOutputAlias,
                crate::output::GetFindingsFilterOutput,
                crate::error::GetFindingsFilterError,
                crate::input::GetFindingsFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetFindingsPublicationConfiguration`.
    ///
    /// <p>Retrieves the configuration settings for publishing findings to Security Hub.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFindingsPublicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_findings_publication_configuration_input::Builder,
    }
    impl<C, M, R> GetFindingsPublicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingsPublicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingsPublicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::GetFindingsPublicationConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingsPublicationConfigurationInputOperationOutputAlias,
                crate::output::GetFindingsPublicationConfigurationOutput,
                crate::error::GetFindingsPublicationConfigurationError,
                crate::input::GetFindingsPublicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetFindingStatistics`.
    ///
    /// <p>Retrieves (queries) aggregated statistical data about findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetFindingStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_finding_statistics_input::Builder,
    }
    impl<C, M, R> GetFindingStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetFindingStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetFindingStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetFindingStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetFindingStatisticsInputOperationOutputAlias,
                crate::output::GetFindingStatisticsOutput,
                crate::error::GetFindingStatisticsError,
                crate::input::GetFindingStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>The criteria to use to filter the query results.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>
        pub fn group_by(mut self, inp: crate::model::GroupBy) -> Self {
            self.inner = self.inner.group_by(inp);
            self
        }
        /// <p>The finding property to use to group the query results. Valid values are:</p> <ul><li><p>classificationDetails.jobId - The unique identifier for the classification job that produced the finding.</p></li> <li><p>resourcesAffected.s3Bucket.name - The name of the S3 bucket that the finding applies to.</p></li> <li><p>severity.description - The severity level of the finding, such as High or Medium.</p></li> <li><p>type - The type of finding, such as Policy:IAMUser/S3BucketPublic and SensitiveData:S3Object/Personal.</p></li></ul>
        pub fn set_group_by(mut self, input: std::option::Option<crate::model::GroupBy>) -> Self {
            self.inner = self.inner.set_group_by(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn size(mut self, inp: i32) -> Self {
            self.inner = self.inner.size(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_size(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_size(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_criteria(mut self, inp: crate::model::FindingStatisticsSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingStatisticsSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetInvitationsCount`.
    ///
    /// <p>Retrieves the count of Amazon Macie membership invitations that were received by an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetInvitationsCount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_invitations_count_input::Builder,
    }
    impl<C, M, R> GetInvitationsCount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetInvitationsCount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetInvitationsCountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetInvitationsCountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetInvitationsCountInputOperationOutputAlias,
                crate::output::GetInvitationsCountOutput,
                crate::error::GetInvitationsCountError,
                crate::input::GetInvitationsCountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMacieSession`.
    ///
    /// <p>Retrieves the current status and configuration settings for an Amazon Macie account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMacieSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_macie_session_input::Builder,
    }
    impl<C, M, R> GetMacieSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMacieSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMacieSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMacieSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMacieSessionInputOperationOutputAlias,
                crate::output::GetMacieSessionOutput,
                crate::error::GetMacieSessionError,
                crate::input::GetMacieSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMasterAccount`.
    ///
    /// <p>(Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link  linkend="GetAdministratorAccount">GetAdministratorAccount</link> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMasterAccount<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_master_account_input::Builder,
    }
    impl<C, M, R> GetMasterAccount<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMasterAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMasterAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMasterAccountError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMasterAccountInputOperationOutputAlias,
                crate::output::GetMasterAccountOutput,
                crate::error::GetMasterAccountError,
                crate::input::GetMasterAccountInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
    }
    /// Fluent builder constructing a request to `GetMember`.
    ///
    /// <p>Retrieves information about an account that's associated with an Amazon Macie administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetMember<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_member_input::Builder,
    }
    impl<C, M, R> GetMember<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMember`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMemberOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMemberError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMemberInputOperationOutputAlias,
                crate::output::GetMemberOutput,
                crate::error::GetMemberError,
                crate::input::GetMemberInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsageStatistics`.
    ///
    /// <p>Retrieves (queries) quotas and aggregated usage data for one or more accounts.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsageStatistics<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_statistics_input::Builder,
    }
    impl<C, M, R> GetUsageStatistics<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsageStatistics`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageStatisticsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageStatisticsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageStatisticsInputOperationOutputAlias,
                crate::output::GetUsageStatisticsOutput,
                crate::error::GetUsageStatisticsError,
                crate::input::GetUsageStatisticsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `filterBy`.
        ///
        /// To override the contents of this collection use [`set_filter_by`](Self::set_filter_by).
        ///
        /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
        pub fn filter_by(mut self, inp: impl Into<crate::model::UsageStatisticsFilter>) -> Self {
            self.inner = self.inner.filter_by(inp);
            self
        }
        /// <p>An array of objects, one for each condition to use to filter the query results. If you specify more than one condition, Amazon Macie uses an AND operator to join the conditions.</p>
        pub fn set_filter_by(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::UsageStatisticsFilter>>,
        ) -> Self {
            self.inner = self.inner.set_filter_by(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn sort_by(mut self, inp: crate::model::UsageStatisticsSortBy) -> Self {
            self.inner = self.inner.sort_by(inp);
            self
        }
        /// <p>The criteria to use to sort the query results.</p>
        pub fn set_sort_by(
            mut self,
            input: std::option::Option<crate::model::UsageStatisticsSortBy>,
        ) -> Self {
            self.inner = self.inner.set_sort_by(input);
            self
        }
        /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
        pub fn time_range(mut self, inp: crate::model::TimeRange) -> Self {
            self.inner = self.inner.time_range(inp);
            self
        }
        /// <p>The inclusive time period to query usage data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value, Amazon Macie provides usage data for the preceding 30 days.</p>
        pub fn set_time_range(
            mut self,
            input: std::option::Option<crate::model::TimeRange>,
        ) -> Self {
            self.inner = self.inner.set_time_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetUsageTotals`.
    ///
    /// <p>Retrieves (queries) aggregated usage data for an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetUsageTotals<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_usage_totals_input::Builder,
    }
    impl<C, M, R> GetUsageTotals<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetUsageTotals`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetUsageTotalsOutput,
            aws_smithy_http::result::SdkError<crate::error::GetUsageTotalsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetUsageTotalsInputOperationOutputAlias,
                crate::output::GetUsageTotalsOutput,
                crate::error::GetUsageTotalsError,
                crate::input::GetUsageTotalsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
        pub fn time_range(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.time_range(inp);
            self
        }
        /// <p>The inclusive time period to retrieve the data for. Valid values are: MONTH_TO_DATE, for the current calendar month to date; and, PAST_30_DAYS, for the preceding 30 days. If you don't specify a value for this parameter, Amazon Macie provides aggregated usage data for the preceding 30 days.</p>
        pub fn set_time_range(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_time_range(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListClassificationJobs`.
    ///
    /// <p>Retrieves a subset of information about one or more classification jobs.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListClassificationJobs<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_classification_jobs_input::Builder,
    }
    impl<C, M, R> ListClassificationJobs<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListClassificationJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListClassificationJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListClassificationJobsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListClassificationJobsInputOperationOutputAlias,
                crate::output::ListClassificationJobsOutput,
                crate::error::ListClassificationJobsError,
                crate::input::ListClassificationJobsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn filter_criteria(mut self, inp: crate::model::ListJobsFilterCriteria) -> Self {
            self.inner = self.inner.filter_criteria(inp);
            self
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn set_filter_criteria(
            mut self,
            input: std::option::Option<crate::model::ListJobsFilterCriteria>,
        ) -> Self {
            self.inner = self.inner.set_filter_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, inp: crate::model::ListJobsSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::ListJobsSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListCustomDataIdentifiers`.
    ///
    /// <p>Retrieves a subset of information about all the custom data identifiers for an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListCustomDataIdentifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_custom_data_identifiers_input::Builder,
    }
    impl<C, M, R> ListCustomDataIdentifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListCustomDataIdentifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListCustomDataIdentifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListCustomDataIdentifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListCustomDataIdentifiersInputOperationOutputAlias,
                crate::output::ListCustomDataIdentifiersOutput,
                crate::error::ListCustomDataIdentifiersError,
                crate::input::ListCustomDataIdentifiersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindings`.
    ///
    /// <p>Retrieves a subset of information about one or more findings.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFindings<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_input::Builder,
    }
    impl<C, M, R> ListFindings<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindings`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsInputOperationOutputAlias,
                crate::output::ListFindingsOutput,
                crate::error::ListFindingsError,
                crate::input::ListFindingsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>The criteria to use to filter the results.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, inp: crate::model::SortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListFindingsFilters`.
    ///
    /// <p>Retrieves a subset of information about all the findings filters for an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListFindingsFilters<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_findings_filters_input::Builder,
    }
    impl<C, M, R> ListFindingsFilters<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListFindingsFilters`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListFindingsFiltersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListFindingsFiltersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListFindingsFiltersInputOperationOutputAlias,
                crate::output::ListFindingsFiltersOutput,
                crate::error::ListFindingsFiltersError,
                crate::input::ListFindingsFiltersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListInvitations`.
    ///
    /// <p>Retrieves information about the Amazon Macie membership invitations that were received by an account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListInvitations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_invitations_input::Builder,
    }
    impl<C, M, R> ListInvitations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListInvitations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListInvitationsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListInvitationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListInvitationsInputOperationOutputAlias,
                crate::output::ListInvitationsOutput,
                crate::error::ListInvitationsError,
                crate::input::ListInvitationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListManagedDataIdentifiers`.
    ///
    /// <p>Retrieves information about all the managed data identifiers that Amazon Macie currently provides.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListManagedDataIdentifiers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_managed_data_identifiers_input::Builder,
    }
    impl<C, M, R> ListManagedDataIdentifiers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListManagedDataIdentifiers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListManagedDataIdentifiersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListManagedDataIdentifiersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListManagedDataIdentifiersInputOperationOutputAlias,
                crate::output::ListManagedDataIdentifiersOutput,
                crate::error::ListManagedDataIdentifiersError,
                crate::input::ListManagedDataIdentifiersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMembers`.
    ///
    /// <p>Retrieves information about the accounts that are associated with an Amazon Macie administrator account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListMembers<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_members_input::Builder,
    }
    impl<C, M, R> ListMembers<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListMembers`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMembersOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMembersError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListMembersInputOperationOutputAlias,
                crate::output::ListMembersOutput,
                crate::error::ListMembersError,
                crate::input::ListMembersInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
        pub fn only_associated(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.only_associated(inp);
            self
        }
        /// <p>Specifies which accounts to include in the response, based on the status of an account's relationship with the administrator account. By default, the response includes only current member accounts. To include all accounts, set this value to false.</p>
        pub fn set_only_associated(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_only_associated(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListOrganizationAdminAccounts`.
    ///
    /// <p>Retrieves information about the delegated Amazon Macie administrator account for an Amazon Web Services organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListOrganizationAdminAccounts<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_organization_admin_accounts_input::Builder,
    }
    impl<C, M, R> ListOrganizationAdminAccounts<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListOrganizationAdminAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListOrganizationAdminAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListOrganizationAdminAccountsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListOrganizationAdminAccountsInputOperationOutputAlias,
                crate::output::ListOrganizationAdminAccountsOutput,
                crate::error::ListOrganizationAdminAccountsError,
                crate::input::ListOrganizationAdminAccountsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of a paginated response.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Retrieves the tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutClassificationExportConfiguration`.
    ///
    /// <p>Creates or updates the configuration settings for storing data classification results.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutClassificationExportConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_classification_export_configuration_input::Builder,
    }
    impl<C, M, R> PutClassificationExportConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutClassificationExportConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutClassificationExportConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutClassificationExportConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutClassificationExportConfigurationInputOperationOutputAlias,
                crate::output::PutClassificationExportConfigurationOutput,
                crate::error::PutClassificationExportConfigurationError,
                crate::input::PutClassificationExportConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
        pub fn configuration(
            mut self,
            inp: crate::model::ClassificationExportConfiguration,
        ) -> Self {
            self.inner = self.inner.configuration(inp);
            self
        }
        /// <p>The location to store data classification results in, and the encryption settings to use when storing results in that location.</p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ClassificationExportConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `PutFindingsPublicationConfiguration`.
    ///
    /// <p>Updates the configuration settings for publishing findings to Security Hub.</p>
    #[derive(std::fmt::Debug)]
    pub struct PutFindingsPublicationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::put_findings_publication_configuration_input::Builder,
    }
    impl<C, M, R> PutFindingsPublicationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `PutFindingsPublicationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PutFindingsPublicationConfigurationOutput,
            aws_smithy_http::result::SdkError<
                crate::error::PutFindingsPublicationConfigurationError,
            >,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PutFindingsPublicationConfigurationInputOperationOutputAlias,
                crate::output::PutFindingsPublicationConfigurationOutput,
                crate::error::PutFindingsPublicationConfigurationError,
                crate::input::PutFindingsPublicationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
        pub fn security_hub_configuration(
            mut self,
            inp: crate::model::SecurityHubConfiguration,
        ) -> Self {
            self.inner = self.inner.security_hub_configuration(inp);
            self
        }
        /// <p>The configuration settings that determine which findings to publish to Security Hub.</p>
        pub fn set_security_hub_configuration(
            mut self,
            input: std::option::Option<crate::model::SecurityHubConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_security_hub_configuration(input);
            self
        }
    }
    /// Fluent builder constructing a request to `SearchResources`.
    ///
    /// <p>Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.</p>
    #[derive(std::fmt::Debug)]
    pub struct SearchResources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::search_resources_input::Builder,
    }
    impl<C, M, R> SearchResources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `SearchResources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::SearchResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::SearchResourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::SearchResourcesInputOperationOutputAlias,
                crate::output::SearchResourcesOutput,
                crate::error::SearchResourcesError,
                crate::input::SearchResourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
        pub fn bucket_criteria(mut self, inp: crate::model::SearchResourcesBucketCriteria) -> Self {
            self.inner = self.inner.bucket_criteria(inp);
            self
        }
        /// <p>The filter conditions that determine which S3 buckets to include or exclude from the query results.</p>
        pub fn set_bucket_criteria(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesBucketCriteria>,
        ) -> Self {
            self.inner = self.inner.set_bucket_criteria(input);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of items to include in each page of the response. The default value is 50.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The nextToken string that specifies which page of results to return in a paginated response.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn sort_criteria(mut self, inp: crate::model::SearchResourcesSortCriteria) -> Self {
            self.inner = self.inner.sort_criteria(inp);
            self
        }
        /// <p>The criteria to use to sort the results.</p>
        pub fn set_sort_criteria(
            mut self,
            input: std::option::Option<crate::model::SearchResourcesSortCriteria>,
        ) -> Self {
            self.inner = self.inner.set_sort_criteria(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds or updates one or more tags (keys and values) that are associated with a classification job, custom data identifier, findings filter, or member account.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Adds a key-value pair to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn tags(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.tags(k, v);
            self
        }
        /// <p>A map of key-value pairs that specifies the tags to associate with the resource.</p> <p>A resource can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TestCustomDataIdentifier`.
    ///
    /// <p>Tests a custom data identifier.</p>
    #[derive(std::fmt::Debug)]
    pub struct TestCustomDataIdentifier<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::test_custom_data_identifier_input::Builder,
    }
    impl<C, M, R> TestCustomDataIdentifier<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TestCustomDataIdentifier`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TestCustomDataIdentifierOutput,
            aws_smithy_http::result::SdkError<crate::error::TestCustomDataIdentifierError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TestCustomDataIdentifierInputOperationOutputAlias,
                crate::output::TestCustomDataIdentifierOutput,
                crate::error::TestCustomDataIdentifierError,
                crate::input::TestCustomDataIdentifierInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `ignoreWords`.
        ///
        /// To override the contents of this collection use [`set_ignore_words`](Self::set_ignore_words).
        ///
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn ignore_words(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ignore_words(inp);
            self
        }
        /// <p>An array that lists specific character sequences (<i>ignore words</i>) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.</p>
        pub fn set_ignore_words(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_ignore_words(input);
            self
        }
        /// Appends an item to `keywords`.
        ///
        /// To override the contents of this collection use [`set_keywords`](Self::set_keywords).
        ///
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn keywords(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.keywords(inp);
            self
        }
        /// <p>An array that lists specific character sequences (<i>keywords</i>), one of which must be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.</p>
        pub fn set_keywords(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_keywords(input);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn maximum_match_distance(mut self, inp: i32) -> Self {
            self.inner = self.inner.maximum_match_distance(inp);
            self
        }
        /// <p>The maximum number of characters that can exist between text that matches the regular expression and the character sequences specified by the keywords array. Amazon Macie includes or excludes a result based on the proximity of a keyword to text that matches the regular expression. The distance can be 1-300 characters. The default value is 50.</p>
        pub fn set_maximum_match_distance(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_maximum_match_distance(input);
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn regex(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.regex(inp);
            self
        }
        /// <p>The regular expression (<i>regex</i>) that defines the pattern to match. The expression can contain as many as 512 characters.</p>
        pub fn set_regex(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_regex(input);
            self
        }
        /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
        pub fn sample_text(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.sample_text(inp);
            self
        }
        /// <p>The sample text to inspect by using the custom data identifier. The text can contain as many as 1,000 characters.</p>
        pub fn set_sample_text(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_sample_text(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags (keys and values) from a classification job, custom data identifier, findings filter, or member account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the classification job, custom data identifier, findings filter, or member account.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `tagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>The key of the tag to remove from the resource. To remove multiple tags, append the tagKeys parameter and argument for each additional tag to remove, separated by an ampersand (&amp;).</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateClassificationJob`.
    ///
    /// <p>Changes the status of a classification job.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateClassificationJob<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_classification_job_input::Builder,
    }
    impl<C, M, R> UpdateClassificationJob<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateClassificationJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateClassificationJobOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateClassificationJobError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateClassificationJobInputOperationOutputAlias,
                crate::output::UpdateClassificationJobOutput,
                crate::error::UpdateClassificationJobError,
                crate::input::UpdateClassificationJobInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn job_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_id(inp);
            self
        }
        /// <p>The unique identifier for the classification job.</p>
        pub fn set_job_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_id(input);
            self
        }
        /// <p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>
        pub fn job_status(mut self, inp: crate::model::JobStatus) -> Self {
            self.inner = self.inner.job_status(inp);
            self
        }
        /// <p>The new status for the job. Valid values are:</p> <ul><li><p>CANCELLED - Stops the job permanently and cancels it. This value is valid only if the job's current status is IDLE, PAUSED, RUNNING, or USER_PAUSED.</p> <p>If you specify this value and the job's current status is RUNNING, Amazon Macie immediately begins to stop all processing tasks for the job. You can't resume or restart a job after you cancel it.</p></li> <li><p>RUNNING - Resumes the job. This value is valid only if the job's current status is USER_PAUSED.</p> <p>If you paused the job while it was actively running and you specify this value less than 30 days after you paused the job, Macie immediately resumes processing from the point where you paused the job. Otherwise, Macie resumes the job according to the schedule and other settings for the job.</p></li> <li><p>USER_PAUSED - Pauses the job temporarily. This value is valid only if the job's current status is IDLE, PAUSED, or RUNNING. If you specify this value and the job's current status is RUNNING, Macie immediately begins to pause all processing tasks for the job.</p> <p>If you pause a one-time job and you don't resume it within 30 days, the job expires and Macie cancels the job. If you pause a recurring job when its status is RUNNING and you don't resume it within 30 days, the job run expires and Macie cancels the run. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.</p></li></ul>
        pub fn set_job_status(
            mut self,
            input: std::option::Option<crate::model::JobStatus>,
        ) -> Self {
            self.inner = self.inner.set_job_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateFindingsFilter`.
    ///
    /// <p>Updates the criteria and other settings for a findings filter.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateFindingsFilter<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_findings_filter_input::Builder,
    }
    impl<C, M, R> UpdateFindingsFilter<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateFindingsFilter`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateFindingsFilterOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateFindingsFilterError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateFindingsFilterInputOperationOutputAlias,
                crate::output::UpdateFindingsFilterOutput,
                crate::error::UpdateFindingsFilterError,
                crate::input::UpdateFindingsFilterInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn action(mut self, inp: crate::model::FindingsFilterAction) -> Self {
            self.inner = self.inner.action(inp);
            self
        }
        /// <p>The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.</p>
        pub fn set_action(
            mut self,
            input: std::option::Option<crate::model::FindingsFilterAction>,
        ) -> Self {
            self.inner = self.inner.set_action(input);
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A custom description of the filter. The description can contain as many as 512 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users might be able to see the filter's description, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn finding_criteria(mut self, inp: crate::model::FindingCriteria) -> Self {
            self.inner = self.inner.finding_criteria(inp);
            self
        }
        /// <p>The criteria to use to filter findings.</p>
        pub fn set_finding_criteria(
            mut self,
            input: std::option::Option<crate::model::FindingCriteria>,
        ) -> Self {
            self.inner = self.inner.set_finding_criteria(input);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.name(inp);
            self
        }
        /// <p>A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.</p> <p>We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users might be able to see the filter's name, depending on the actions that they're allowed to perform in Amazon Macie.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_name(input);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn position(mut self, inp: i32) -> Self {
            self.inner = self.inner.position(inp);
            self
        }
        /// <p>The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.</p>
        pub fn set_position(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_position(input);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>A unique, case-sensitive token that you provide to ensure the idempotency of the request.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMacieSession`.
    ///
    /// <p>Suspends or re-enables an Amazon Macie account, or updates the configuration settings for a Macie account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMacieSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_macie_session_input::Builder,
    }
    impl<C, M, R> UpdateMacieSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMacieSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMacieSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMacieSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMacieSessionInputOperationOutputAlias,
                crate::output::UpdateMacieSessionOutput,
                crate::error::UpdateMacieSessionError,
                crate::input::UpdateMacieSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn finding_publishing_frequency(
            mut self,
            inp: crate::model::FindingPublishingFrequency,
        ) -> Self {
            self.inner = self.inner.finding_publishing_frequency(inp);
            self
        }
        /// <p>Specifies how often to publish updates to policy findings for the account. This includes publishing updates to Security Hub and Amazon EventBridge (formerly called Amazon CloudWatch Events).</p>
        pub fn set_finding_publishing_frequency(
            mut self,
            input: std::option::Option<crate::model::FindingPublishingFrequency>,
        ) -> Self {
            self.inner = self.inner.set_finding_publishing_frequency(input);
            self
        }
        /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn status(mut self, inp: crate::model::MacieStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>Specifies a new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMemberSession`.
    ///
    /// <p>Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMemberSession<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_member_session_input::Builder,
    }
    impl<C, M, R> UpdateMemberSession<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMemberSession`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMemberSessionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMemberSessionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMemberSessionInputOperationOutputAlias,
                crate::output::UpdateMemberSessionOutput,
                crate::error::UpdateMemberSessionError,
                crate::input::UpdateMemberSessionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.id(inp);
            self
        }
        /// <p>The unique identifier for the Amazon Macie resource or account that the request applies to.</p>
        pub fn set_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_id(input);
            self
        }
        /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn status(mut self, inp: crate::model::MacieStatus) -> Self {
            self.inner = self.inner.status(inp);
            self
        }
        /// <p>Specifies the new status for the account. Valid values are: ENABLED, resume all Amazon Macie activities for the account; and, PAUSED, suspend all Macie activities for the account.</p>
        pub fn set_status(mut self, input: std::option::Option<crate::model::MacieStatus>) -> Self {
            self.inner = self.inner.set_status(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateOrganizationConfiguration`.
    ///
    /// <p>Updates the Amazon Macie configuration settings for an Amazon Web Services organization.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateOrganizationConfiguration<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_organization_configuration_input::Builder,
    }
    impl<C, M, R> UpdateOrganizationConfiguration<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateOrganizationConfiguration`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateOrganizationConfigurationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateOrganizationConfigurationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateOrganizationConfigurationInputOperationOutputAlias,
                crate::output::UpdateOrganizationConfigurationOutput,
                crate::error::UpdateOrganizationConfigurationError,
                crate::input::UpdateOrganizationConfigurationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.</p>
        pub fn auto_enable(mut self, inp: bool) -> Self {
            self.inner = self.inner.auto_enable(inp);
            self
        }
        /// <p>Specifies whether to enable Amazon Macie automatically for each account, when the account is added to the Amazon Web Services organization.</p>
        pub fn set_auto_enable(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_auto_enable(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::new(conn)
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut client = aws_hyper::Client::https()
            .with_retry_config(retry_config.into())
            .with_timeout_config(timeout_config);

        client.set_sleep_impl(sleep_impl);
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
