// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AcceptInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AcceptInvitationError {
    /// Kind of error that occurred.
    pub kind: AcceptInvitationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AcceptInvitation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AcceptInvitationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AcceptInvitationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AcceptInvitationErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            AcceptInvitationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AcceptInvitationError {
    fn code(&self) -> Option<&str> {
        AcceptInvitationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AcceptInvitationError {
    /// Creates a new `AcceptInvitationError`.
    pub fn new(kind: AcceptInvitationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AcceptInvitationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AcceptInvitationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AcceptInvitationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AcceptInvitationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, AcceptInvitationErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `AcceptInvitationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            AcceptInvitationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for AcceptInvitationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AcceptInvitationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::ConflictException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::InternalServerException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::ThrottlingException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::ValidationException(_inner) => Some(_inner),
            AcceptInvitationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `BatchGetCustomDataIdentifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct BatchGetCustomDataIdentifiersError {
    /// Kind of error that occurred.
    pub kind: BatchGetCustomDataIdentifiersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `BatchGetCustomDataIdentifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum BatchGetCustomDataIdentifiersErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for BatchGetCustomDataIdentifiersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            BatchGetCustomDataIdentifiersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            BatchGetCustomDataIdentifiersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            BatchGetCustomDataIdentifiersErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetCustomDataIdentifiersErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetCustomDataIdentifiersErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            BatchGetCustomDataIdentifiersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            BatchGetCustomDataIdentifiersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            BatchGetCustomDataIdentifiersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for BatchGetCustomDataIdentifiersError {
    fn code(&self) -> Option<&str> {
        BatchGetCustomDataIdentifiersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl BatchGetCustomDataIdentifiersError {
    /// Creates a new `BatchGetCustomDataIdentifiersError`.
    pub fn new(
        kind: BatchGetCustomDataIdentifiersErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `BatchGetCustomDataIdentifiersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: BatchGetCustomDataIdentifiersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `BatchGetCustomDataIdentifiersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: BatchGetCustomDataIdentifiersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `BatchGetCustomDataIdentifiersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            BatchGetCustomDataIdentifiersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for BatchGetCustomDataIdentifiersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            BatchGetCustomDataIdentifiersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            BatchGetCustomDataIdentifiersErrorKind::ConflictException(_inner) => Some(_inner),
            BatchGetCustomDataIdentifiersErrorKind::InternalServerException(_inner) => Some(_inner),
            BatchGetCustomDataIdentifiersErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            BatchGetCustomDataIdentifiersErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            BatchGetCustomDataIdentifiersErrorKind::ThrottlingException(_inner) => Some(_inner),
            BatchGetCustomDataIdentifiersErrorKind::ValidationException(_inner) => Some(_inner),
            BatchGetCustomDataIdentifiersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateClassificationJobError {
    /// Kind of error that occurred.
    pub kind: CreateClassificationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateClassificationJobErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateClassificationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateClassificationJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateClassificationJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateClassificationJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateClassificationJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateClassificationJobErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateClassificationJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateClassificationJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateClassificationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateClassificationJobError {
    fn code(&self) -> Option<&str> {
        CreateClassificationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateClassificationJobError {
    /// Creates a new `CreateClassificationJobError`.
    pub fn new(kind: CreateClassificationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateClassificationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateClassificationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateClassificationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateClassificationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateClassificationJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateClassificationJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateClassificationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateClassificationJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::ConflictException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::ValidationException(_inner) => Some(_inner),
            CreateClassificationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateCustomDataIdentifierError {
    /// Kind of error that occurred.
    pub kind: CreateCustomDataIdentifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateCustomDataIdentifierErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateCustomDataIdentifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateCustomDataIdentifierErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateCustomDataIdentifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            CreateCustomDataIdentifierErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateCustomDataIdentifierErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateCustomDataIdentifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateCustomDataIdentifierError {
    fn code(&self) -> Option<&str> {
        CreateCustomDataIdentifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateCustomDataIdentifierError {
    /// Creates a new `CreateCustomDataIdentifierError`.
    pub fn new(kind: CreateCustomDataIdentifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateCustomDataIdentifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateCustomDataIdentifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateCustomDataIdentifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateCustomDataIdentifierErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateCustomDataIdentifierErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateCustomDataIdentifierErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateCustomDataIdentifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateCustomDataIdentifierErrorKind::ConflictException(_inner) => Some(_inner),
            CreateCustomDataIdentifierErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            CreateCustomDataIdentifierErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateCustomDataIdentifierErrorKind::ValidationException(_inner) => Some(_inner),
            CreateCustomDataIdentifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateFindingsFilterError {
    /// Kind of error that occurred.
    pub kind: CreateFindingsFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateFindingsFilterErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateFindingsFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateFindingsFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateFindingsFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateFindingsFilterError {
    fn code(&self) -> Option<&str> {
        CreateFindingsFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateFindingsFilterError {
    /// Creates a new `CreateFindingsFilterError`.
    pub fn new(kind: CreateFindingsFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateFindingsFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateFindingsFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateFindingsFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateFindingsFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateFindingsFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateFindingsFilterErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateFindingsFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateFindingsFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::ConflictException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::ValidationException(_inner) => Some(_inner),
            CreateFindingsFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateInvitationsError {
    /// Kind of error that occurred.
    pub kind: CreateInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateInvitationsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateInvitationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateInvitationsError {
    fn code(&self) -> Option<&str> {
        CreateInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateInvitationsError {
    /// Creates a new `CreateInvitationsError`.
    pub fn new(kind: CreateInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvitationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateInvitationsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvitationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvitationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvitationsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvitationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateInvitationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateInvitationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateInvitationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::ConflictException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::ValidationException(_inner) => Some(_inner),
            CreateInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMemberError {
    /// Kind of error that occurred.
    pub kind: CreateMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMemberErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMemberError {
    fn code(&self) -> Option<&str> {
        CreateMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMemberError {
    /// Creates a new `CreateMemberError`.
    pub fn new(kind: CreateMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `CreateMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateMemberErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateMemberErrorKind::ConflictException(_inner) => Some(_inner),
            CreateMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateMemberErrorKind::ValidationException(_inner) => Some(_inner),
            CreateMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateSampleFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateSampleFindingsError {
    /// Kind of error that occurred.
    pub kind: CreateSampleFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateSampleFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateSampleFindingsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateSampleFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateSampleFindingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateSampleFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateSampleFindingsError {
    fn code(&self) -> Option<&str> {
        CreateSampleFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateSampleFindingsError {
    /// Creates a new `CreateSampleFindingsError`.
    pub fn new(kind: CreateSampleFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateSampleFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateSampleFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateSampleFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateSampleFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateSampleFindingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateSampleFindingsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for CreateSampleFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateSampleFindingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::ConflictException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::ValidationException(_inner) => Some(_inner),
            CreateSampleFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeclineInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeclineInvitationsError {
    /// Kind of error that occurred.
    pub kind: DeclineInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeclineInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeclineInvitationsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeclineInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeclineInvitationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeclineInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeclineInvitationsError {
    fn code(&self) -> Option<&str> {
        DeclineInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeclineInvitationsError {
    /// Creates a new `DeclineInvitationsError`.
    pub fn new(kind: DeclineInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeclineInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeclineInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeclineInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeclineInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeclineInvitationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeclineInvitationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeclineInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeclineInvitationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::ConflictException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::ValidationException(_inner) => Some(_inner),
            DeclineInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteCustomDataIdentifierError {
    /// Kind of error that occurred.
    pub kind: DeleteCustomDataIdentifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteCustomDataIdentifierErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteCustomDataIdentifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteCustomDataIdentifierErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteCustomDataIdentifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DeleteCustomDataIdentifierErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteCustomDataIdentifierErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteCustomDataIdentifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteCustomDataIdentifierError {
    fn code(&self) -> Option<&str> {
        DeleteCustomDataIdentifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteCustomDataIdentifierError {
    /// Creates a new `DeleteCustomDataIdentifierError`.
    pub fn new(kind: DeleteCustomDataIdentifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteCustomDataIdentifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteCustomDataIdentifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteCustomDataIdentifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteCustomDataIdentifierErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteCustomDataIdentifierErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteCustomDataIdentifierErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteCustomDataIdentifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteCustomDataIdentifierErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteCustomDataIdentifierErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DeleteCustomDataIdentifierErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteCustomDataIdentifierErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteCustomDataIdentifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteFindingsFilterError {
    /// Kind of error that occurred.
    pub kind: DeleteFindingsFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteFindingsFilterErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteFindingsFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteFindingsFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteFindingsFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteFindingsFilterError {
    fn code(&self) -> Option<&str> {
        DeleteFindingsFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteFindingsFilterError {
    /// Creates a new `DeleteFindingsFilterError`.
    pub fn new(kind: DeleteFindingsFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteFindingsFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteFindingsFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteFindingsFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteFindingsFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteFindingsFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteFindingsFilterErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteFindingsFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteFindingsFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteFindingsFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteInvitationsError {
    /// Kind of error that occurred.
    pub kind: DeleteInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteInvitationsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteInvitationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteInvitationsError {
    fn code(&self) -> Option<&str> {
        DeleteInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteInvitationsError {
    /// Creates a new `DeleteInvitationsError`.
    pub fn new(kind: DeleteInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteInvitationsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteInvitationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteInvitationsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DeleteInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteInvitationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMemberError {
    /// Kind of error that occurred.
    pub kind: DeleteMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMemberErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMemberError {
    fn code(&self) -> Option<&str> {
        DeleteMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMemberError {
    /// Creates a new `DeleteMemberError`.
    pub fn new(kind: DeleteMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteMemberErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteMemberErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DeleteMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteMemberErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteMemberErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBuckets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBucketsError {
    /// Kind of error that occurred.
    pub kind: DescribeBucketsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBuckets` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBucketsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBucketsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBucketsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeBucketsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBucketsError {
    fn code(&self) -> Option<&str> {
        DescribeBucketsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBucketsError {
    /// Creates a new `DescribeBucketsError`.
    pub fn new(kind: DescribeBucketsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBucketsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBucketsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBucketsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBucketsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBucketsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeBucketsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBucketsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBucketsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBucketsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeBucketsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DescribeBucketsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeBucketsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeBucketsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBucketsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeBucketsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeClassificationJobError {
    /// Kind of error that occurred.
    pub kind: DescribeClassificationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeClassificationJobErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeClassificationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeClassificationJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeClassificationJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeClassificationJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeClassificationJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeClassificationJobErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeClassificationJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeClassificationJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeClassificationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeClassificationJobError {
    fn code(&self) -> Option<&str> {
        DescribeClassificationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeClassificationJobError {
    /// Creates a new `DescribeClassificationJobError`.
    pub fn new(kind: DescribeClassificationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeClassificationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeClassificationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeClassificationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeClassificationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeClassificationJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeClassificationJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeClassificationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeClassificationJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeClassificationJobErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeClassificationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeClassificationJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeClassificationJobErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DescribeClassificationJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeClassificationJobErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeClassificationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeOrganizationConfigurationError {
    /// Kind of error that occurred.
    pub kind: DescribeOrganizationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeOrganizationConfigurationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeOrganizationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DescribeOrganizationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeOrganizationConfigurationError {
    fn code(&self) -> Option<&str> {
        DescribeOrganizationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeOrganizationConfigurationError {
    /// Creates a new `DescribeOrganizationConfigurationError`.
    pub fn new(
        kind: DescribeOrganizationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeOrganizationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeOrganizationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeOrganizationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeOrganizationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeOrganizationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeOrganizationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DescribeOrganizationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DescribeOrganizationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeOrganizationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeOrganizationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableMacie` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableMacieError {
    /// Kind of error that occurred.
    pub kind: DisableMacieErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableMacie` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableMacieErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableMacieError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableMacieErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableMacieErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableMacieError {
    fn code(&self) -> Option<&str> {
        DisableMacieError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableMacieError {
    /// Creates a new `DisableMacieError`.
    pub fn new(kind: DisableMacieErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableMacieError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableMacieErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableMacieError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableMacieErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DisableMacieErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DisableMacieErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableMacieErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableMacieErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableMacieErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DisableMacieErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `DisableMacieErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DisableMacieErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DisableMacieError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableMacieErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableMacieErrorKind::ConflictException(_inner) => Some(_inner),
            DisableMacieErrorKind::InternalServerException(_inner) => Some(_inner),
            DisableMacieErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisableMacieErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DisableMacieErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisableMacieErrorKind::ValidationException(_inner) => Some(_inner),
            DisableMacieErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisableOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: DisableOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisableOrganizationAdminAccountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisableOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisableOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisableOrganizationAdminAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisableOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisableOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DisableOrganizationAdminAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisableOrganizationAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisableOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisableOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        DisableOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisableOrganizationAdminAccountError {
    /// Creates a new `DisableOrganizationAdminAccountError`.
    pub fn new(
        kind: DisableOrganizationAdminAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisableOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisableOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisableOrganizationAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisableOrganizationAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisableOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisableOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisableOrganizationAdminAccountErrorKind::ConflictException(_inner) => Some(_inner),
            DisableOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisableOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DisableOrganizationAdminAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisableOrganizationAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            DisableOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateFromAdministratorAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateFromAdministratorAccountError {
    /// Kind of error that occurred.
    pub kind: DisassociateFromAdministratorAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateFromAdministratorAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateFromAdministratorAccountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateFromAdministratorAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateFromAdministratorAccountErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromAdministratorAccountErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromAdministratorAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromAdministratorAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromAdministratorAccountErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => _inner.fmt(f),
            DisassociateFromAdministratorAccountErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromAdministratorAccountErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromAdministratorAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateFromAdministratorAccountError {
    fn code(&self) -> Option<&str> {
        DisassociateFromAdministratorAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateFromAdministratorAccountError {
    /// Creates a new `DisassociateFromAdministratorAccountError`.
    pub fn new(
        kind: DisassociateFromAdministratorAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateFromAdministratorAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateFromAdministratorAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateFromAdministratorAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateFromAdministratorAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromAdministratorAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromAdministratorAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateFromAdministratorAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateFromAdministratorAccountErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            DisassociateFromAdministratorAccountErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            DisassociateFromAdministratorAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            DisassociateFromAdministratorAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateFromAdministratorAccountErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => Some(_inner),
            DisassociateFromAdministratorAccountErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            DisassociateFromAdministratorAccountErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            DisassociateFromAdministratorAccountErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `DisassociateFromMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateFromMasterAccountError {
    /// Kind of error that occurred.
    pub kind: DisassociateFromMasterAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateFromMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateFromMasterAccountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateFromMasterAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateFromMasterAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateFromMasterAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateFromMasterAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromMasterAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromMasterAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            DisassociateFromMasterAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateFromMasterAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateFromMasterAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateFromMasterAccountError {
    fn code(&self) -> Option<&str> {
        DisassociateFromMasterAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateFromMasterAccountError {
    /// Creates a new `DisassociateFromMasterAccountError`.
    pub fn new(
        kind: DisassociateFromMasterAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateFromMasterAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateFromMasterAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateFromMasterAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateFromMasterAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateFromMasterAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateFromMasterAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateFromMasterAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateFromMasterAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateFromMasterAccountErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateFromMasterAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateFromMasterAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            DisassociateFromMasterAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            DisassociateFromMasterAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateFromMasterAccountErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateFromMasterAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DisassociateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DisassociateMemberError {
    /// Kind of error that occurred.
    pub kind: DisassociateMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DisassociateMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DisassociateMemberErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DisassociateMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DisassociateMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DisassociateMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DisassociateMemberError {
    fn code(&self) -> Option<&str> {
        DisassociateMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DisassociateMemberError {
    /// Creates a new `DisassociateMemberError`.
    pub fn new(kind: DisassociateMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DisassociateMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DisassociateMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DisassociateMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DisassociateMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `DisassociateMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            DisassociateMemberErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for DisassociateMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DisassociateMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ConflictException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::ValidationException(_inner) => Some(_inner),
            DisassociateMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableMacie` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableMacieError {
    /// Kind of error that occurred.
    pub kind: EnableMacieErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableMacie` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableMacieErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableMacieError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableMacieErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::ConflictException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableMacieErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableMacieError {
    fn code(&self) -> Option<&str> {
        EnableMacieError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableMacieError {
    /// Creates a new `EnableMacieError`.
    pub fn new(kind: EnableMacieErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableMacieError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableMacieErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableMacieError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableMacieErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, EnableMacieErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, EnableMacieErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, EnableMacieErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMacieErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableMacieErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, EnableMacieErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `EnableMacieErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, EnableMacieErrorKind::ValidationException(_))
    }
}
impl std::error::Error for EnableMacieError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableMacieErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableMacieErrorKind::ConflictException(_inner) => Some(_inner),
            EnableMacieErrorKind::InternalServerException(_inner) => Some(_inner),
            EnableMacieErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            EnableMacieErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            EnableMacieErrorKind::ThrottlingException(_inner) => Some(_inner),
            EnableMacieErrorKind::ValidationException(_inner) => Some(_inner),
            EnableMacieErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `EnableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct EnableOrganizationAdminAccountError {
    /// Kind of error that occurred.
    pub kind: EnableOrganizationAdminAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `EnableOrganizationAdminAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum EnableOrganizationAdminAccountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for EnableOrganizationAdminAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            EnableOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            EnableOrganizationAdminAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            EnableOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            EnableOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            EnableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            EnableOrganizationAdminAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            EnableOrganizationAdminAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            EnableOrganizationAdminAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for EnableOrganizationAdminAccountError {
    fn code(&self) -> Option<&str> {
        EnableOrganizationAdminAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl EnableOrganizationAdminAccountError {
    /// Creates a new `EnableOrganizationAdminAccountError`.
    pub fn new(
        kind: EnableOrganizationAdminAccountErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `EnableOrganizationAdminAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: EnableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `EnableOrganizationAdminAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: EnableOrganizationAdminAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `EnableOrganizationAdminAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            EnableOrganizationAdminAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for EnableOrganizationAdminAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            EnableOrganizationAdminAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            EnableOrganizationAdminAccountErrorKind::ConflictException(_inner) => Some(_inner),
            EnableOrganizationAdminAccountErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            EnableOrganizationAdminAccountErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            EnableOrganizationAdminAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            EnableOrganizationAdminAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            EnableOrganizationAdminAccountErrorKind::ValidationException(_inner) => Some(_inner),
            EnableOrganizationAdminAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetAdministratorAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetAdministratorAccountError {
    /// Kind of error that occurred.
    pub kind: GetAdministratorAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetAdministratorAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetAdministratorAccountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetAdministratorAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetAdministratorAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetAdministratorAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetAdministratorAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetAdministratorAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetAdministratorAccountErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetAdministratorAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetAdministratorAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetAdministratorAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetAdministratorAccountError {
    fn code(&self) -> Option<&str> {
        GetAdministratorAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetAdministratorAccountError {
    /// Creates a new `GetAdministratorAccountError`.
    pub fn new(kind: GetAdministratorAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetAdministratorAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetAdministratorAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetAdministratorAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetAdministratorAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetAdministratorAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetAdministratorAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetAdministratorAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetAdministratorAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::ConflictException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::ValidationException(_inner) => Some(_inner),
            GetAdministratorAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBucketStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBucketStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetBucketStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBucketStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBucketStatisticsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBucketStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBucketStatisticsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetBucketStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBucketStatisticsError {
    fn code(&self) -> Option<&str> {
        GetBucketStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBucketStatisticsError {
    /// Creates a new `GetBucketStatisticsError`.
    pub fn new(kind: GetBucketStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBucketStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBucketStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBucketStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBucketStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBucketStatisticsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBucketStatisticsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetBucketStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBucketStatisticsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::ConflictException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::ValidationException(_inner) => Some(_inner),
            GetBucketStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetClassificationExportConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetClassificationExportConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetClassificationExportConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetClassificationExportConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetClassificationExportConfigurationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetClassificationExportConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetClassificationExportConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetClassificationExportConfigurationErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            GetClassificationExportConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetClassificationExportConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetClassificationExportConfigurationErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => _inner.fmt(f),
            GetClassificationExportConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetClassificationExportConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetClassificationExportConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetClassificationExportConfigurationError {
    fn code(&self) -> Option<&str> {
        GetClassificationExportConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetClassificationExportConfigurationError {
    /// Creates a new `GetClassificationExportConfigurationError`.
    pub fn new(
        kind: GetClassificationExportConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetClassificationExportConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetClassificationExportConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetClassificationExportConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetClassificationExportConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetClassificationExportConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetClassificationExportConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetClassificationExportConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetClassificationExportConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetClassificationExportConfigurationErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            GetClassificationExportConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetClassificationExportConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetClassificationExportConfigurationErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => Some(_inner),
            GetClassificationExportConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetClassificationExportConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetClassificationExportConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetCustomDataIdentifierError {
    /// Kind of error that occurred.
    pub kind: GetCustomDataIdentifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetCustomDataIdentifierErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetCustomDataIdentifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetCustomDataIdentifierErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetCustomDataIdentifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetCustomDataIdentifierErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetCustomDataIdentifierErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetCustomDataIdentifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetCustomDataIdentifierError {
    fn code(&self) -> Option<&str> {
        GetCustomDataIdentifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetCustomDataIdentifierError {
    /// Creates a new `GetCustomDataIdentifierError`.
    pub fn new(kind: GetCustomDataIdentifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetCustomDataIdentifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetCustomDataIdentifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetCustomDataIdentifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetCustomDataIdentifierErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetCustomDataIdentifierErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetCustomDataIdentifierErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetCustomDataIdentifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::ConflictException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::InternalServerException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::ValidationException(_inner) => Some(_inner),
            GetCustomDataIdentifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsError {
    /// Kind of error that occurred.
    pub kind: GetFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsError {
    fn code(&self) -> Option<&str> {
        GetFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFindingsError {
    /// Creates a new `GetFindingsError`.
    pub fn new(kind: GetFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetFindingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFindingsErrorKind::ConflictException(_inner) => Some(_inner),
            GetFindingsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetFindingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFindingsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetFindingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFindingsErrorKind::ValidationException(_inner) => Some(_inner),
            GetFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsFilterError {
    /// Kind of error that occurred.
    pub kind: GetFindingsFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsFilterErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFindingsFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsFilterError {
    fn code(&self) -> Option<&str> {
        GetFindingsFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFindingsFilterError {
    /// Creates a new `GetFindingsFilterError`.
    pub fn new(kind: GetFindingsFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsFilterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetFindingsFilterErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsFilterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsFilterErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsFilterErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetFindingsFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::ConflictException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::ValidationException(_inner) => Some(_inner),
            GetFindingsFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetFindingsPublicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingsPublicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: GetFindingsPublicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindingsPublicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingsPublicationConfigurationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingsPublicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingsPublicationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            GetFindingsPublicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingsPublicationConfigurationError {
    fn code(&self) -> Option<&str> {
        GetFindingsPublicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFindingsPublicationConfigurationError {
    /// Creates a new `GetFindingsPublicationConfigurationError`.
    pub fn new(
        kind: GetFindingsPublicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingsPublicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingsPublicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingsPublicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingsPublicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingsPublicationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingsPublicationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetFindingsPublicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingsPublicationConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            GetFindingsPublicationConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            GetFindingsPublicationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            GetFindingsPublicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            GetFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            GetFindingsPublicationConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            GetFindingsPublicationConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            GetFindingsPublicationConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `GetFindingStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetFindingStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetFindingStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetFindingStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetFindingStatisticsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetFindingStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetFindingStatisticsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetFindingStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetFindingStatisticsError {
    fn code(&self) -> Option<&str> {
        GetFindingStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetFindingStatisticsError {
    /// Creates a new `GetFindingStatisticsError`.
    pub fn new(kind: GetFindingStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetFindingStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetFindingStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetFindingStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetFindingStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetFindingStatisticsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetFindingStatisticsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetFindingStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetFindingStatisticsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::ConflictException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::ValidationException(_inner) => Some(_inner),
            GetFindingStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetInvitationsCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetInvitationsCountError {
    /// Kind of error that occurred.
    pub kind: GetInvitationsCountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetInvitationsCount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetInvitationsCountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetInvitationsCountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetInvitationsCountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetInvitationsCountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetInvitationsCountError {
    fn code(&self) -> Option<&str> {
        GetInvitationsCountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetInvitationsCountError {
    /// Creates a new `GetInvitationsCountError`.
    pub fn new(kind: GetInvitationsCountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetInvitationsCountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetInvitationsCountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetInvitationsCountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetInvitationsCountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetInvitationsCountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetInvitationsCountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetInvitationsCountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetInvitationsCountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::ConflictException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::InternalServerException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::ValidationException(_inner) => Some(_inner),
            GetInvitationsCountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMacieSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMacieSessionError {
    /// Kind of error that occurred.
    pub kind: GetMacieSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMacieSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMacieSessionErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMacieSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMacieSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMacieSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMacieSessionError {
    fn code(&self) -> Option<&str> {
        GetMacieSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMacieSessionError {
    /// Creates a new `GetMacieSessionError`.
    pub fn new(kind: GetMacieSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMacieSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMacieSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMacieSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMacieSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMacieSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetMacieSessionErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMacieSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMacieSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMacieSessionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMacieSessionErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetMacieSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetMacieSessionErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetMacieSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMacieSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::ConflictException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::ValidationException(_inner) => Some(_inner),
            GetMacieSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMasterAccountError {
    /// Kind of error that occurred.
    pub kind: GetMasterAccountErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMasterAccount` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMasterAccountErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMasterAccountError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMasterAccountErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMasterAccountErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMasterAccountError {
    fn code(&self) -> Option<&str> {
        GetMasterAccountError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMasterAccountError {
    /// Creates a new `GetMasterAccountError`.
    pub fn new(kind: GetMasterAccountErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMasterAccountError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMasterAccountErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMasterAccountError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMasterAccountErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetMasterAccountErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMasterAccountErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMasterAccountErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetMasterAccountError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMasterAccountErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::ConflictException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::ValidationException(_inner) => Some(_inner),
            GetMasterAccountErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMemberError {
    /// Kind of error that occurred.
    pub kind: GetMemberErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMember` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMemberErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMemberError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMemberErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetMemberErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMemberError {
    fn code(&self) -> Option<&str> {
        GetMemberError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMemberError {
    /// Creates a new `GetMemberError`.
    pub fn new(kind: GetMemberErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMemberError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMemberErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMemberError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMemberErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMemberErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetMemberErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetMemberErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetMemberError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMemberErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetMemberErrorKind::ConflictException(_inner) => Some(_inner),
            GetMemberErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMemberErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMemberErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetMemberErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetMemberErrorKind::ValidationException(_inner) => Some(_inner),
            GetMemberErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsageStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsageStatisticsError {
    /// Kind of error that occurred.
    pub kind: GetUsageStatisticsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsageStatistics` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsageStatisticsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsageStatisticsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsageStatisticsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUsageStatisticsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsageStatisticsError {
    fn code(&self) -> Option<&str> {
        GetUsageStatisticsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsageStatisticsError {
    /// Creates a new `GetUsageStatisticsError`.
    pub fn new(kind: GetUsageStatisticsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsageStatisticsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsageStatisticsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsageStatisticsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsageStatisticsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageStatisticsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageStatisticsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for GetUsageStatisticsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsageStatisticsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::ConflictException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::ValidationException(_inner) => Some(_inner),
            GetUsageStatisticsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetUsageTotals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetUsageTotalsError {
    /// Kind of error that occurred.
    pub kind: GetUsageTotalsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetUsageTotals` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetUsageTotalsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetUsageTotalsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetUsageTotalsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            GetUsageTotalsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetUsageTotalsError {
    fn code(&self) -> Option<&str> {
        GetUsageTotalsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetUsageTotalsError {
    /// Creates a new `GetUsageTotalsError`.
    pub fn new(kind: GetUsageTotalsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetUsageTotalsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetUsageTotalsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetUsageTotalsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetUsageTotalsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageTotalsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, GetUsageTotalsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageTotalsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageTotalsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetUsageTotalsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, GetUsageTotalsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `GetUsageTotalsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, GetUsageTotalsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for GetUsageTotalsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetUsageTotalsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::ConflictException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::InternalServerException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::ThrottlingException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::ValidationException(_inner) => Some(_inner),
            GetUsageTotalsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListClassificationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListClassificationJobsError {
    /// Kind of error that occurred.
    pub kind: ListClassificationJobsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListClassificationJobs` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListClassificationJobsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListClassificationJobsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListClassificationJobsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListClassificationJobsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListClassificationJobsError {
    fn code(&self) -> Option<&str> {
        ListClassificationJobsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListClassificationJobsError {
    /// Creates a new `ListClassificationJobsError`.
    pub fn new(kind: ListClassificationJobsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListClassificationJobsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListClassificationJobsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListClassificationJobsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListClassificationJobsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListClassificationJobsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListClassificationJobsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListClassificationJobsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListClassificationJobsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::ConflictException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::ValidationException(_inner) => Some(_inner),
            ListClassificationJobsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListCustomDataIdentifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListCustomDataIdentifiersError {
    /// Kind of error that occurred.
    pub kind: ListCustomDataIdentifiersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListCustomDataIdentifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListCustomDataIdentifiersErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListCustomDataIdentifiersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListCustomDataIdentifiersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListCustomDataIdentifiersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListCustomDataIdentifiersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListCustomDataIdentifiersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListCustomDataIdentifiersErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListCustomDataIdentifiersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListCustomDataIdentifiersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListCustomDataIdentifiersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListCustomDataIdentifiersError {
    fn code(&self) -> Option<&str> {
        ListCustomDataIdentifiersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListCustomDataIdentifiersError {
    /// Creates a new `ListCustomDataIdentifiersError`.
    pub fn new(kind: ListCustomDataIdentifiersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListCustomDataIdentifiersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListCustomDataIdentifiersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListCustomDataIdentifiersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListCustomDataIdentifiersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListCustomDataIdentifiersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListCustomDataIdentifiersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListCustomDataIdentifiersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListCustomDataIdentifiersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListCustomDataIdentifiersErrorKind::ConflictException(_inner) => Some(_inner),
            ListCustomDataIdentifiersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListCustomDataIdentifiersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListCustomDataIdentifiersErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            ListCustomDataIdentifiersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListCustomDataIdentifiersErrorKind::ValidationException(_inner) => Some(_inner),
            ListCustomDataIdentifiersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingsError {
    /// Kind of error that occurred.
    pub kind: ListFindingsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindings` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFindingsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingsError {
    fn code(&self) -> Option<&str> {
        ListFindingsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFindingsError {
    /// Creates a new `ListFindingsError`.
    pub fn new(kind: ListFindingsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListFindingsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListFindingsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListFindingsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFindingsErrorKind::ConflictException(_inner) => Some(_inner),
            ListFindingsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFindingsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFindingsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListFindingsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFindingsErrorKind::ValidationException(_inner) => Some(_inner),
            ListFindingsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListFindingsFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListFindingsFiltersError {
    /// Kind of error that occurred.
    pub kind: ListFindingsFiltersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListFindingsFilters` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListFindingsFiltersErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListFindingsFiltersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListFindingsFiltersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListFindingsFiltersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListFindingsFiltersError {
    fn code(&self) -> Option<&str> {
        ListFindingsFiltersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListFindingsFiltersError {
    /// Creates a new `ListFindingsFiltersError`.
    pub fn new(kind: ListFindingsFiltersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListFindingsFiltersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListFindingsFiltersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListFindingsFiltersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListFindingsFiltersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListFindingsFiltersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListFindingsFiltersErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListFindingsFiltersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListFindingsFiltersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::ConflictException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::ValidationException(_inner) => Some(_inner),
            ListFindingsFiltersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListInvitationsError {
    /// Kind of error that occurred.
    pub kind: ListInvitationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListInvitations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListInvitationsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListInvitationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListInvitationsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListInvitationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListInvitationsError {
    fn code(&self) -> Option<&str> {
        ListInvitationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListInvitationsError {
    /// Creates a new `ListInvitationsError`.
    pub fn new(kind: ListInvitationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListInvitationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListInvitationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListInvitationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListInvitationsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListInvitationsErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListInvitationsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListInvitationsErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListInvitationsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListInvitationsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListInvitationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListInvitationsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ConflictException(_inner) => Some(_inner),
            ListInvitationsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListInvitationsErrorKind::ValidationException(_inner) => Some(_inner),
            ListInvitationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListManagedDataIdentifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListManagedDataIdentifiersError {
    /// Kind of error that occurred.
    pub kind: ListManagedDataIdentifiersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListManagedDataIdentifiers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListManagedDataIdentifiersErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListManagedDataIdentifiersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListManagedDataIdentifiersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListManagedDataIdentifiersError {
    fn code(&self) -> Option<&str> {
        ListManagedDataIdentifiersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListManagedDataIdentifiersError {
    /// Creates a new `ListManagedDataIdentifiersError`.
    pub fn new(kind: ListManagedDataIdentifiersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListManagedDataIdentifiersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListManagedDataIdentifiersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListManagedDataIdentifiersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListManagedDataIdentifiersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListManagedDataIdentifiersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListManagedDataIdentifiersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListMembersError {
    /// Kind of error that occurred.
    pub kind: ListMembersErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListMembers` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListMembersErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListMembersError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListMembersErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListMembersErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListMembersError {
    fn code(&self) -> Option<&str> {
        ListMembersError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListMembersError {
    /// Creates a new `ListMembersError`.
    pub fn new(kind: ListMembersErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListMembersError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListMembersErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListMembersError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListMembersErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::AccessDeniedException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMembersErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListMembersErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `ListMembersErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListMembersErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListMembersError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListMembersErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListMembersErrorKind::ConflictException(_inner) => Some(_inner),
            ListMembersErrorKind::InternalServerException(_inner) => Some(_inner),
            ListMembersErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListMembersErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            ListMembersErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListMembersErrorKind::ValidationException(_inner) => Some(_inner),
            ListMembersErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListOrganizationAdminAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListOrganizationAdminAccountsError {
    /// Kind of error that occurred.
    pub kind: ListOrganizationAdminAccountsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListOrganizationAdminAccounts` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListOrganizationAdminAccountsErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListOrganizationAdminAccountsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListOrganizationAdminAccountsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListOrganizationAdminAccountsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListOrganizationAdminAccountsErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationAdminAccountsErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationAdminAccountsErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            ListOrganizationAdminAccountsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListOrganizationAdminAccountsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListOrganizationAdminAccountsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListOrganizationAdminAccountsError {
    fn code(&self) -> Option<&str> {
        ListOrganizationAdminAccountsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListOrganizationAdminAccountsError {
    /// Creates a new `ListOrganizationAdminAccountsError`.
    pub fn new(
        kind: ListOrganizationAdminAccountsErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListOrganizationAdminAccountsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListOrganizationAdminAccountsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListOrganizationAdminAccountsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListOrganizationAdminAccountsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `ListOrganizationAdminAccountsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListOrganizationAdminAccountsErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListOrganizationAdminAccountsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListOrganizationAdminAccountsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListOrganizationAdminAccountsErrorKind::ConflictException(_inner) => Some(_inner),
            ListOrganizationAdminAccountsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListOrganizationAdminAccountsErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            ListOrganizationAdminAccountsErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            ListOrganizationAdminAccountsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListOrganizationAdminAccountsErrorKind::ValidationException(_inner) => Some(_inner),
            ListOrganizationAdminAccountsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `PutClassificationExportConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutClassificationExportConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutClassificationExportConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutClassificationExportConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutClassificationExportConfigurationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutClassificationExportConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutClassificationExportConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            PutClassificationExportConfigurationErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            PutClassificationExportConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            PutClassificationExportConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutClassificationExportConfigurationErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => _inner.fmt(f),
            PutClassificationExportConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            PutClassificationExportConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            PutClassificationExportConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutClassificationExportConfigurationError {
    fn code(&self) -> Option<&str> {
        PutClassificationExportConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutClassificationExportConfigurationError {
    /// Creates a new `PutClassificationExportConfigurationError`.
    pub fn new(
        kind: PutClassificationExportConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutClassificationExportConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutClassificationExportConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutClassificationExportConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutClassificationExportConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutClassificationExportConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutClassificationExportConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutClassificationExportConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutClassificationExportConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            PutClassificationExportConfigurationErrorKind::ConflictException(_inner) => {
                Some(_inner)
            }
            PutClassificationExportConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            PutClassificationExportConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutClassificationExportConfigurationErrorKind::ServiceQuotaExceededException(
                _inner,
            ) => Some(_inner),
            PutClassificationExportConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            PutClassificationExportConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            PutClassificationExportConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `PutFindingsPublicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PutFindingsPublicationConfigurationError {
    /// Kind of error that occurred.
    pub kind: PutFindingsPublicationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `PutFindingsPublicationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PutFindingsPublicationConfigurationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PutFindingsPublicationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PutFindingsPublicationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::ConflictException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::ThrottlingException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::ValidationException(_inner) => {
                _inner.fmt(f)
            }
            PutFindingsPublicationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PutFindingsPublicationConfigurationError {
    fn code(&self) -> Option<&str> {
        PutFindingsPublicationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PutFindingsPublicationConfigurationError {
    /// Creates a new `PutFindingsPublicationConfigurationError`.
    pub fn new(
        kind: PutFindingsPublicationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PutFindingsPublicationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PutFindingsPublicationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PutFindingsPublicationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PutFindingsPublicationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `PutFindingsPublicationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            PutFindingsPublicationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for PutFindingsPublicationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PutFindingsPublicationConfigurationErrorKind::AccessDeniedException(_inner) => {
                Some(_inner)
            }
            PutFindingsPublicationConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            PutFindingsPublicationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            PutFindingsPublicationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            PutFindingsPublicationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            PutFindingsPublicationConfigurationErrorKind::ThrottlingException(_inner) => {
                Some(_inner)
            }
            PutFindingsPublicationConfigurationErrorKind::ValidationException(_inner) => {
                Some(_inner)
            }
            PutFindingsPublicationConfigurationErrorKind::Unhandled(_inner) => {
                Some(_inner.as_ref())
            }
        }
    }
}

/// Error type for the `SearchResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct SearchResourcesError {
    /// Kind of error that occurred.
    pub kind: SearchResourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `SearchResources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum SearchResourcesErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for SearchResourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            SearchResourcesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            SearchResourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for SearchResourcesError {
    fn code(&self) -> Option<&str> {
        SearchResourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl SearchResourcesError {
    /// Creates a new `SearchResourcesError`.
    pub fn new(kind: SearchResourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `SearchResourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: SearchResourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `SearchResourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: SearchResourcesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, SearchResourcesErrorKind::ConflictException(_))
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            SearchResourcesErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, SearchResourcesErrorKind::ThrottlingException(_))
    }
    /// Returns `true` if the error kind is `SearchResourcesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, SearchResourcesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for SearchResourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            SearchResourcesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            SearchResourcesErrorKind::ConflictException(_inner) => Some(_inner),
            SearchResourcesErrorKind::InternalServerException(_inner) => Some(_inner),
            SearchResourcesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            SearchResourcesErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            SearchResourcesErrorKind::ThrottlingException(_inner) => Some(_inner),
            SearchResourcesErrorKind::ValidationException(_inner) => Some(_inner),
            SearchResourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TestCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TestCustomDataIdentifierError {
    /// Kind of error that occurred.
    pub kind: TestCustomDataIdentifierErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TestCustomDataIdentifier` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TestCustomDataIdentifierErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TestCustomDataIdentifierError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TestCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TestCustomDataIdentifierErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TestCustomDataIdentifierErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TestCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TestCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            TestCustomDataIdentifierErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TestCustomDataIdentifierErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TestCustomDataIdentifierErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TestCustomDataIdentifierError {
    fn code(&self) -> Option<&str> {
        TestCustomDataIdentifierError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TestCustomDataIdentifierError {
    /// Creates a new `TestCustomDataIdentifierError`.
    pub fn new(kind: TestCustomDataIdentifierErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TestCustomDataIdentifierError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TestCustomDataIdentifierErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TestCustomDataIdentifierError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TestCustomDataIdentifierErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `TestCustomDataIdentifierErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            TestCustomDataIdentifierErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for TestCustomDataIdentifierError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TestCustomDataIdentifierErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TestCustomDataIdentifierErrorKind::ConflictException(_inner) => Some(_inner),
            TestCustomDataIdentifierErrorKind::InternalServerException(_inner) => Some(_inner),
            TestCustomDataIdentifierErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TestCustomDataIdentifierErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            TestCustomDataIdentifierErrorKind::ThrottlingException(_inner) => Some(_inner),
            TestCustomDataIdentifierErrorKind::ValidationException(_inner) => Some(_inner),
            TestCustomDataIdentifierErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateClassificationJobError {
    /// Kind of error that occurred.
    pub kind: UpdateClassificationJobErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateClassificationJob` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateClassificationJobErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateClassificationJobError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateClassificationJobErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateClassificationJobErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateClassificationJobErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateClassificationJobErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateClassificationJobErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateClassificationJobErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateClassificationJobErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateClassificationJobErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateClassificationJobError {
    fn code(&self) -> Option<&str> {
        UpdateClassificationJobError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateClassificationJobError {
    /// Creates a new `UpdateClassificationJobError`.
    pub fn new(kind: UpdateClassificationJobErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateClassificationJobError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateClassificationJobErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateClassificationJobError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateClassificationJobErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateClassificationJobErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateClassificationJobErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateClassificationJobError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateClassificationJobErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateClassificationJobErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateFindingsFilterError {
    /// Kind of error that occurred.
    pub kind: UpdateFindingsFilterErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateFindingsFilter` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateFindingsFilterErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateFindingsFilterError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateFindingsFilterErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateFindingsFilterErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateFindingsFilterError {
    fn code(&self) -> Option<&str> {
        UpdateFindingsFilterError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateFindingsFilterError {
    /// Creates a new `UpdateFindingsFilterError`.
    pub fn new(kind: UpdateFindingsFilterErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateFindingsFilterError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateFindingsFilterErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateFindingsFilterError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateFindingsFilterErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateFindingsFilterErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateFindingsFilterErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateFindingsFilterError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateFindingsFilterErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateFindingsFilterErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMacieSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMacieSessionError {
    /// Kind of error that occurred.
    pub kind: UpdateMacieSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMacieSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMacieSessionErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMacieSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMacieSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateMacieSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMacieSessionError {
    fn code(&self) -> Option<&str> {
        UpdateMacieSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMacieSessionError {
    /// Creates a new `UpdateMacieSessionError`.
    pub fn new(kind: UpdateMacieSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMacieSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMacieSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMacieSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMacieSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMacieSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMacieSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateMacieSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMacieSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateMacieSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMemberSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMemberSessionError {
    /// Kind of error that occurred.
    pub kind: UpdateMemberSessionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMemberSession` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMemberSessionErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMemberSessionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMemberSessionErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateMemberSessionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMemberSessionError {
    fn code(&self) -> Option<&str> {
        UpdateMemberSessionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMemberSessionError {
    /// Creates a new `UpdateMemberSessionError`.
    pub fn new(kind: UpdateMemberSessionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMemberSessionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMemberSessionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMemberSessionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMemberSessionErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMemberSessionErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMemberSessionErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateMemberSessionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMemberSessionErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateMemberSessionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateOrganizationConfigurationError {
    /// Kind of error that occurred.
    pub kind: UpdateOrganizationConfigurationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateOrganizationConfiguration` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateOrganizationConfigurationErrorKind {
    /// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateOrganizationConfigurationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                _inner.fmt(f)
            }
            UpdateOrganizationConfigurationErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateOrganizationConfigurationErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateOrganizationConfigurationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateOrganizationConfigurationError {
    fn code(&self) -> Option<&str> {
        UpdateOrganizationConfigurationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateOrganizationConfigurationError {
    /// Creates a new `UpdateOrganizationConfigurationError`.
    pub fn new(
        kind: UpdateOrganizationConfigurationErrorKind,
        meta: aws_smithy_types::Error,
    ) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateOrganizationConfigurationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateOrganizationConfigurationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateOrganizationConfigurationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateOrganizationConfigurationErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ConflictException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ThrottlingException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateOrganizationConfigurationErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateOrganizationConfigurationErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateOrganizationConfigurationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateOrganizationConfigurationErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::InternalServerException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationConfigurationErrorKind::ResourceNotFoundException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationConfigurationErrorKind::ServiceQuotaExceededException(_inner) => {
                Some(_inner)
            }
            UpdateOrganizationConfigurationErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateOrganizationConfigurationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>Provides information about an error that occurred due to a syntax error in a request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Provides information about an error that occurred because too many requests were sent during a certain amount of time.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>Provides information about an error that occurred due to one or more service quotas for an account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}

/// <p>Provides information about an error that occurred because a specified resource wasn't found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Provides information about an error that occurred due to an unknown internal server error, exception, or failure.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>Provides information about an error that occurred due to a versioning conflict for a specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>Provides information about an error that occurred due to insufficient access to a specified resource.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    /// <p>The explanation of the error that occurred.</p>
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The explanation of the error that occurred.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The explanation of the error that occurred.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}
