// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `AcceptInvitation`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`accept_invitation`](crate::client::Client::accept_invitation).
///
/// See [`crate::client::fluent_builders::AcceptInvitation`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct AcceptInvitation {
    _private: (),
}
impl AcceptInvitation {
    /// Creates a new builder-style object to manufacture [`AcceptInvitationInput`](crate::input::AcceptInvitationInput)
    pub fn builder() -> crate::input::accept_invitation_input::Builder {
        crate::input::accept_invitation_input::Builder::default()
    }
    /// Creates a new `AcceptInvitation` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for AcceptInvitation {
    type Output = std::result::Result<
        crate::output::AcceptInvitationOutput,
        crate::error::AcceptInvitationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_accept_invitation_error(response)
        } else {
            crate::operation_deser::parse_accept_invitation_response(response)
        }
    }
}

/// Operation shape for `BatchGetCustomDataIdentifiers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`batch_get_custom_data_identifiers`](crate::client::Client::batch_get_custom_data_identifiers).
///
/// See [`crate::client::fluent_builders::BatchGetCustomDataIdentifiers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct BatchGetCustomDataIdentifiers {
    _private: (),
}
impl BatchGetCustomDataIdentifiers {
    /// Creates a new builder-style object to manufacture [`BatchGetCustomDataIdentifiersInput`](crate::input::BatchGetCustomDataIdentifiersInput)
    pub fn builder() -> crate::input::batch_get_custom_data_identifiers_input::Builder {
        crate::input::batch_get_custom_data_identifiers_input::Builder::default()
    }
    /// Creates a new `BatchGetCustomDataIdentifiers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for BatchGetCustomDataIdentifiers {
    type Output = std::result::Result<
        crate::output::BatchGetCustomDataIdentifiersOutput,
        crate::error::BatchGetCustomDataIdentifiersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_batch_get_custom_data_identifiers_error(response)
        } else {
            crate::operation_deser::parse_batch_get_custom_data_identifiers_response(response)
        }
    }
}

/// Operation shape for `CreateClassificationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_classification_job`](crate::client::Client::create_classification_job).
///
/// See [`crate::client::fluent_builders::CreateClassificationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateClassificationJob {
    _private: (),
}
impl CreateClassificationJob {
    /// Creates a new builder-style object to manufacture [`CreateClassificationJobInput`](crate::input::CreateClassificationJobInput)
    pub fn builder() -> crate::input::create_classification_job_input::Builder {
        crate::input::create_classification_job_input::Builder::default()
    }
    /// Creates a new `CreateClassificationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateClassificationJob {
    type Output = std::result::Result<
        crate::output::CreateClassificationJobOutput,
        crate::error::CreateClassificationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_classification_job_error(response)
        } else {
            crate::operation_deser::parse_create_classification_job_response(response)
        }
    }
}

/// Operation shape for `CreateCustomDataIdentifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_custom_data_identifier`](crate::client::Client::create_custom_data_identifier).
///
/// See [`crate::client::fluent_builders::CreateCustomDataIdentifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateCustomDataIdentifier {
    _private: (),
}
impl CreateCustomDataIdentifier {
    /// Creates a new builder-style object to manufacture [`CreateCustomDataIdentifierInput`](crate::input::CreateCustomDataIdentifierInput)
    pub fn builder() -> crate::input::create_custom_data_identifier_input::Builder {
        crate::input::create_custom_data_identifier_input::Builder::default()
    }
    /// Creates a new `CreateCustomDataIdentifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateCustomDataIdentifier {
    type Output = std::result::Result<
        crate::output::CreateCustomDataIdentifierOutput,
        crate::error::CreateCustomDataIdentifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_custom_data_identifier_error(response)
        } else {
            crate::operation_deser::parse_create_custom_data_identifier_response(response)
        }
    }
}

/// Operation shape for `CreateFindingsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_findings_filter`](crate::client::Client::create_findings_filter).
///
/// See [`crate::client::fluent_builders::CreateFindingsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateFindingsFilter {
    _private: (),
}
impl CreateFindingsFilter {
    /// Creates a new builder-style object to manufacture [`CreateFindingsFilterInput`](crate::input::CreateFindingsFilterInput)
    pub fn builder() -> crate::input::create_findings_filter_input::Builder {
        crate::input::create_findings_filter_input::Builder::default()
    }
    /// Creates a new `CreateFindingsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateFindingsFilter {
    type Output = std::result::Result<
        crate::output::CreateFindingsFilterOutput,
        crate::error::CreateFindingsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_findings_filter_error(response)
        } else {
            crate::operation_deser::parse_create_findings_filter_response(response)
        }
    }
}

/// Operation shape for `CreateInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_invitations`](crate::client::Client::create_invitations).
///
/// See [`crate::client::fluent_builders::CreateInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateInvitations {
    _private: (),
}
impl CreateInvitations {
    /// Creates a new builder-style object to manufacture [`CreateInvitationsInput`](crate::input::CreateInvitationsInput)
    pub fn builder() -> crate::input::create_invitations_input::Builder {
        crate::input::create_invitations_input::Builder::default()
    }
    /// Creates a new `CreateInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateInvitations {
    type Output = std::result::Result<
        crate::output::CreateInvitationsOutput,
        crate::error::CreateInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_invitations_error(response)
        } else {
            crate::operation_deser::parse_create_invitations_response(response)
        }
    }
}

/// Operation shape for `CreateMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_member`](crate::client::Client::create_member).
///
/// See [`crate::client::fluent_builders::CreateMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateMember {
    _private: (),
}
impl CreateMember {
    /// Creates a new builder-style object to manufacture [`CreateMemberInput`](crate::input::CreateMemberInput)
    pub fn builder() -> crate::input::create_member_input::Builder {
        crate::input::create_member_input::Builder::default()
    }
    /// Creates a new `CreateMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateMember {
    type Output =
        std::result::Result<crate::output::CreateMemberOutput, crate::error::CreateMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_member_error(response)
        } else {
            crate::operation_deser::parse_create_member_response(response)
        }
    }
}

/// Operation shape for `CreateSampleFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_sample_findings`](crate::client::Client::create_sample_findings).
///
/// See [`crate::client::fluent_builders::CreateSampleFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateSampleFindings {
    _private: (),
}
impl CreateSampleFindings {
    /// Creates a new builder-style object to manufacture [`CreateSampleFindingsInput`](crate::input::CreateSampleFindingsInput)
    pub fn builder() -> crate::input::create_sample_findings_input::Builder {
        crate::input::create_sample_findings_input::Builder::default()
    }
    /// Creates a new `CreateSampleFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateSampleFindings {
    type Output = std::result::Result<
        crate::output::CreateSampleFindingsOutput,
        crate::error::CreateSampleFindingsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_sample_findings_error(response)
        } else {
            crate::operation_deser::parse_create_sample_findings_response(response)
        }
    }
}

/// Operation shape for `DeclineInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`decline_invitations`](crate::client::Client::decline_invitations).
///
/// See [`crate::client::fluent_builders::DeclineInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeclineInvitations {
    _private: (),
}
impl DeclineInvitations {
    /// Creates a new builder-style object to manufacture [`DeclineInvitationsInput`](crate::input::DeclineInvitationsInput)
    pub fn builder() -> crate::input::decline_invitations_input::Builder {
        crate::input::decline_invitations_input::Builder::default()
    }
    /// Creates a new `DeclineInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeclineInvitations {
    type Output = std::result::Result<
        crate::output::DeclineInvitationsOutput,
        crate::error::DeclineInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_decline_invitations_error(response)
        } else {
            crate::operation_deser::parse_decline_invitations_response(response)
        }
    }
}

/// Operation shape for `DeleteCustomDataIdentifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_custom_data_identifier`](crate::client::Client::delete_custom_data_identifier).
///
/// See [`crate::client::fluent_builders::DeleteCustomDataIdentifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteCustomDataIdentifier {
    _private: (),
}
impl DeleteCustomDataIdentifier {
    /// Creates a new builder-style object to manufacture [`DeleteCustomDataIdentifierInput`](crate::input::DeleteCustomDataIdentifierInput)
    pub fn builder() -> crate::input::delete_custom_data_identifier_input::Builder {
        crate::input::delete_custom_data_identifier_input::Builder::default()
    }
    /// Creates a new `DeleteCustomDataIdentifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteCustomDataIdentifier {
    type Output = std::result::Result<
        crate::output::DeleteCustomDataIdentifierOutput,
        crate::error::DeleteCustomDataIdentifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_custom_data_identifier_error(response)
        } else {
            crate::operation_deser::parse_delete_custom_data_identifier_response(response)
        }
    }
}

/// Operation shape for `DeleteFindingsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_findings_filter`](crate::client::Client::delete_findings_filter).
///
/// See [`crate::client::fluent_builders::DeleteFindingsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteFindingsFilter {
    _private: (),
}
impl DeleteFindingsFilter {
    /// Creates a new builder-style object to manufacture [`DeleteFindingsFilterInput`](crate::input::DeleteFindingsFilterInput)
    pub fn builder() -> crate::input::delete_findings_filter_input::Builder {
        crate::input::delete_findings_filter_input::Builder::default()
    }
    /// Creates a new `DeleteFindingsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteFindingsFilter {
    type Output = std::result::Result<
        crate::output::DeleteFindingsFilterOutput,
        crate::error::DeleteFindingsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_findings_filter_error(response)
        } else {
            crate::operation_deser::parse_delete_findings_filter_response(response)
        }
    }
}

/// Operation shape for `DeleteInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_invitations`](crate::client::Client::delete_invitations).
///
/// See [`crate::client::fluent_builders::DeleteInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteInvitations {
    _private: (),
}
impl DeleteInvitations {
    /// Creates a new builder-style object to manufacture [`DeleteInvitationsInput`](crate::input::DeleteInvitationsInput)
    pub fn builder() -> crate::input::delete_invitations_input::Builder {
        crate::input::delete_invitations_input::Builder::default()
    }
    /// Creates a new `DeleteInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteInvitations {
    type Output = std::result::Result<
        crate::output::DeleteInvitationsOutput,
        crate::error::DeleteInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_invitations_error(response)
        } else {
            crate::operation_deser::parse_delete_invitations_response(response)
        }
    }
}

/// Operation shape for `DeleteMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_member`](crate::client::Client::delete_member).
///
/// See [`crate::client::fluent_builders::DeleteMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteMember {
    _private: (),
}
impl DeleteMember {
    /// Creates a new builder-style object to manufacture [`DeleteMemberInput`](crate::input::DeleteMemberInput)
    pub fn builder() -> crate::input::delete_member_input::Builder {
        crate::input::delete_member_input::Builder::default()
    }
    /// Creates a new `DeleteMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteMember {
    type Output =
        std::result::Result<crate::output::DeleteMemberOutput, crate::error::DeleteMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_member_error(response)
        } else {
            crate::operation_deser::parse_delete_member_response(response)
        }
    }
}

/// Operation shape for `DescribeBuckets`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_buckets`](crate::client::Client::describe_buckets).
///
/// See [`crate::client::fluent_builders::DescribeBuckets`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeBuckets {
    _private: (),
}
impl DescribeBuckets {
    /// Creates a new builder-style object to manufacture [`DescribeBucketsInput`](crate::input::DescribeBucketsInput)
    pub fn builder() -> crate::input::describe_buckets_input::Builder {
        crate::input::describe_buckets_input::Builder::default()
    }
    /// Creates a new `DescribeBuckets` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeBuckets {
    type Output = std::result::Result<
        crate::output::DescribeBucketsOutput,
        crate::error::DescribeBucketsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_buckets_error(response)
        } else {
            crate::operation_deser::parse_describe_buckets_response(response)
        }
    }
}

/// Operation shape for `DescribeClassificationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_classification_job`](crate::client::Client::describe_classification_job).
///
/// See [`crate::client::fluent_builders::DescribeClassificationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeClassificationJob {
    _private: (),
}
impl DescribeClassificationJob {
    /// Creates a new builder-style object to manufacture [`DescribeClassificationJobInput`](crate::input::DescribeClassificationJobInput)
    pub fn builder() -> crate::input::describe_classification_job_input::Builder {
        crate::input::describe_classification_job_input::Builder::default()
    }
    /// Creates a new `DescribeClassificationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeClassificationJob {
    type Output = std::result::Result<
        crate::output::DescribeClassificationJobOutput,
        crate::error::DescribeClassificationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_classification_job_error(response)
        } else {
            crate::operation_deser::parse_describe_classification_job_response(response)
        }
    }
}

/// Operation shape for `DescribeOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_organization_configuration`](crate::client::Client::describe_organization_configuration).
///
/// See [`crate::client::fluent_builders::DescribeOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeOrganizationConfiguration {
    _private: (),
}
impl DescribeOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`DescribeOrganizationConfigurationInput`](crate::input::DescribeOrganizationConfigurationInput)
    pub fn builder() -> crate::input::describe_organization_configuration_input::Builder {
        crate::input::describe_organization_configuration_input::Builder::default()
    }
    /// Creates a new `DescribeOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::DescribeOrganizationConfigurationOutput,
        crate::error::DescribeOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_describe_organization_configuration_response(response)
        }
    }
}

/// Operation shape for `DisableMacie`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_macie`](crate::client::Client::disable_macie).
///
/// See [`crate::client::fluent_builders::DisableMacie`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableMacie {
    _private: (),
}
impl DisableMacie {
    /// Creates a new builder-style object to manufacture [`DisableMacieInput`](crate::input::DisableMacieInput)
    pub fn builder() -> crate::input::disable_macie_input::Builder {
        crate::input::disable_macie_input::Builder::default()
    }
    /// Creates a new `DisableMacie` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableMacie {
    type Output =
        std::result::Result<crate::output::DisableMacieOutput, crate::error::DisableMacieError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_macie_error(response)
        } else {
            crate::operation_deser::parse_disable_macie_response(response)
        }
    }
}

/// Operation shape for `DisableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disable_organization_admin_account`](crate::client::Client::disable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::DisableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisableOrganizationAdminAccount {
    _private: (),
}
impl DisableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`DisableOrganizationAdminAccountInput`](crate::input::DisableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::disable_organization_admin_account_input::Builder {
        crate::input::disable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `DisableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::DisableOrganizationAdminAccountOutput,
        crate::error::DisableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_disable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateFromAdministratorAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_from_administrator_account`](crate::client::Client::disassociate_from_administrator_account).
///
/// See [`crate::client::fluent_builders::DisassociateFromAdministratorAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFromAdministratorAccount {
    _private: (),
}
impl DisassociateFromAdministratorAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateFromAdministratorAccountInput`](crate::input::DisassociateFromAdministratorAccountInput)
    pub fn builder() -> crate::input::disassociate_from_administrator_account_input::Builder {
        crate::input::disassociate_from_administrator_account_input::Builder::default()
    }
    /// Creates a new `DisassociateFromAdministratorAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFromAdministratorAccount {
    type Output = std::result::Result<
        crate::output::DisassociateFromAdministratorAccountOutput,
        crate::error::DisassociateFromAdministratorAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_from_administrator_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_from_administrator_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateFromMasterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_from_master_account`](crate::client::Client::disassociate_from_master_account).
///
/// See [`crate::client::fluent_builders::DisassociateFromMasterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateFromMasterAccount {
    _private: (),
}
impl DisassociateFromMasterAccount {
    /// Creates a new builder-style object to manufacture [`DisassociateFromMasterAccountInput`](crate::input::DisassociateFromMasterAccountInput)
    pub fn builder() -> crate::input::disassociate_from_master_account_input::Builder {
        crate::input::disassociate_from_master_account_input::Builder::default()
    }
    /// Creates a new `DisassociateFromMasterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateFromMasterAccount {
    type Output = std::result::Result<
        crate::output::DisassociateFromMasterAccountOutput,
        crate::error::DisassociateFromMasterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_from_master_account_error(response)
        } else {
            crate::operation_deser::parse_disassociate_from_master_account_response(response)
        }
    }
}

/// Operation shape for `DisassociateMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`disassociate_member`](crate::client::Client::disassociate_member).
///
/// See [`crate::client::fluent_builders::DisassociateMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DisassociateMember {
    _private: (),
}
impl DisassociateMember {
    /// Creates a new builder-style object to manufacture [`DisassociateMemberInput`](crate::input::DisassociateMemberInput)
    pub fn builder() -> crate::input::disassociate_member_input::Builder {
        crate::input::disassociate_member_input::Builder::default()
    }
    /// Creates a new `DisassociateMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DisassociateMember {
    type Output = std::result::Result<
        crate::output::DisassociateMemberOutput,
        crate::error::DisassociateMemberError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_disassociate_member_error(response)
        } else {
            crate::operation_deser::parse_disassociate_member_response(response)
        }
    }
}

/// Operation shape for `EnableMacie`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_macie`](crate::client::Client::enable_macie).
///
/// See [`crate::client::fluent_builders::EnableMacie`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableMacie {
    _private: (),
}
impl EnableMacie {
    /// Creates a new builder-style object to manufacture [`EnableMacieInput`](crate::input::EnableMacieInput)
    pub fn builder() -> crate::input::enable_macie_input::Builder {
        crate::input::enable_macie_input::Builder::default()
    }
    /// Creates a new `EnableMacie` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableMacie {
    type Output =
        std::result::Result<crate::output::EnableMacieOutput, crate::error::EnableMacieError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_macie_error(response)
        } else {
            crate::operation_deser::parse_enable_macie_response(response)
        }
    }
}

/// Operation shape for `EnableOrganizationAdminAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`enable_organization_admin_account`](crate::client::Client::enable_organization_admin_account).
///
/// See [`crate::client::fluent_builders::EnableOrganizationAdminAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct EnableOrganizationAdminAccount {
    _private: (),
}
impl EnableOrganizationAdminAccount {
    /// Creates a new builder-style object to manufacture [`EnableOrganizationAdminAccountInput`](crate::input::EnableOrganizationAdminAccountInput)
    pub fn builder() -> crate::input::enable_organization_admin_account_input::Builder {
        crate::input::enable_organization_admin_account_input::Builder::default()
    }
    /// Creates a new `EnableOrganizationAdminAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for EnableOrganizationAdminAccount {
    type Output = std::result::Result<
        crate::output::EnableOrganizationAdminAccountOutput,
        crate::error::EnableOrganizationAdminAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_enable_organization_admin_account_error(response)
        } else {
            crate::operation_deser::parse_enable_organization_admin_account_response(response)
        }
    }
}

/// Operation shape for `GetAdministratorAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_administrator_account`](crate::client::Client::get_administrator_account).
///
/// See [`crate::client::fluent_builders::GetAdministratorAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetAdministratorAccount {
    _private: (),
}
impl GetAdministratorAccount {
    /// Creates a new builder-style object to manufacture [`GetAdministratorAccountInput`](crate::input::GetAdministratorAccountInput)
    pub fn builder() -> crate::input::get_administrator_account_input::Builder {
        crate::input::get_administrator_account_input::Builder::default()
    }
    /// Creates a new `GetAdministratorAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetAdministratorAccount {
    type Output = std::result::Result<
        crate::output::GetAdministratorAccountOutput,
        crate::error::GetAdministratorAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_administrator_account_error(response)
        } else {
            crate::operation_deser::parse_get_administrator_account_response(response)
        }
    }
}

/// Operation shape for `GetBucketStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_bucket_statistics`](crate::client::Client::get_bucket_statistics).
///
/// See [`crate::client::fluent_builders::GetBucketStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetBucketStatistics {
    _private: (),
}
impl GetBucketStatistics {
    /// Creates a new builder-style object to manufacture [`GetBucketStatisticsInput`](crate::input::GetBucketStatisticsInput)
    pub fn builder() -> crate::input::get_bucket_statistics_input::Builder {
        crate::input::get_bucket_statistics_input::Builder::default()
    }
    /// Creates a new `GetBucketStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetBucketStatistics {
    type Output = std::result::Result<
        crate::output::GetBucketStatisticsOutput,
        crate::error::GetBucketStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_bucket_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_bucket_statistics_response(response)
        }
    }
}

/// Operation shape for `GetClassificationExportConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_classification_export_configuration`](crate::client::Client::get_classification_export_configuration).
///
/// See [`crate::client::fluent_builders::GetClassificationExportConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetClassificationExportConfiguration {
    _private: (),
}
impl GetClassificationExportConfiguration {
    /// Creates a new builder-style object to manufacture [`GetClassificationExportConfigurationInput`](crate::input::GetClassificationExportConfigurationInput)
    pub fn builder() -> crate::input::get_classification_export_configuration_input::Builder {
        crate::input::get_classification_export_configuration_input::Builder::default()
    }
    /// Creates a new `GetClassificationExportConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetClassificationExportConfiguration {
    type Output = std::result::Result<
        crate::output::GetClassificationExportConfigurationOutput,
        crate::error::GetClassificationExportConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_classification_export_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_classification_export_configuration_response(response)
        }
    }
}

/// Operation shape for `GetCustomDataIdentifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_custom_data_identifier`](crate::client::Client::get_custom_data_identifier).
///
/// See [`crate::client::fluent_builders::GetCustomDataIdentifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetCustomDataIdentifier {
    _private: (),
}
impl GetCustomDataIdentifier {
    /// Creates a new builder-style object to manufacture [`GetCustomDataIdentifierInput`](crate::input::GetCustomDataIdentifierInput)
    pub fn builder() -> crate::input::get_custom_data_identifier_input::Builder {
        crate::input::get_custom_data_identifier_input::Builder::default()
    }
    /// Creates a new `GetCustomDataIdentifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetCustomDataIdentifier {
    type Output = std::result::Result<
        crate::output::GetCustomDataIdentifierOutput,
        crate::error::GetCustomDataIdentifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_custom_data_identifier_error(response)
        } else {
            crate::operation_deser::parse_get_custom_data_identifier_response(response)
        }
    }
}

/// Operation shape for `GetFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings`](crate::client::Client::get_findings).
///
/// See [`crate::client::fluent_builders::GetFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindings {
    _private: (),
}
impl GetFindings {
    /// Creates a new builder-style object to manufacture [`GetFindingsInput`](crate::input::GetFindingsInput)
    pub fn builder() -> crate::input::get_findings_input::Builder {
        crate::input::get_findings_input::Builder::default()
    }
    /// Creates a new `GetFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindings {
    type Output =
        std::result::Result<crate::output::GetFindingsOutput, crate::error::GetFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_error(response)
        } else {
            crate::operation_deser::parse_get_findings_response(response)
        }
    }
}

/// Operation shape for `GetFindingsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings_filter`](crate::client::Client::get_findings_filter).
///
/// See [`crate::client::fluent_builders::GetFindingsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindingsFilter {
    _private: (),
}
impl GetFindingsFilter {
    /// Creates a new builder-style object to manufacture [`GetFindingsFilterInput`](crate::input::GetFindingsFilterInput)
    pub fn builder() -> crate::input::get_findings_filter_input::Builder {
        crate::input::get_findings_filter_input::Builder::default()
    }
    /// Creates a new `GetFindingsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindingsFilter {
    type Output = std::result::Result<
        crate::output::GetFindingsFilterOutput,
        crate::error::GetFindingsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_filter_error(response)
        } else {
            crate::operation_deser::parse_get_findings_filter_response(response)
        }
    }
}

/// Operation shape for `GetFindingsPublicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_findings_publication_configuration`](crate::client::Client::get_findings_publication_configuration).
///
/// See [`crate::client::fluent_builders::GetFindingsPublicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindingsPublicationConfiguration {
    _private: (),
}
impl GetFindingsPublicationConfiguration {
    /// Creates a new builder-style object to manufacture [`GetFindingsPublicationConfigurationInput`](crate::input::GetFindingsPublicationConfigurationInput)
    pub fn builder() -> crate::input::get_findings_publication_configuration_input::Builder {
        crate::input::get_findings_publication_configuration_input::Builder::default()
    }
    /// Creates a new `GetFindingsPublicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindingsPublicationConfiguration {
    type Output = std::result::Result<
        crate::output::GetFindingsPublicationConfigurationOutput,
        crate::error::GetFindingsPublicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_findings_publication_configuration_error(response)
        } else {
            crate::operation_deser::parse_get_findings_publication_configuration_response(response)
        }
    }
}

/// Operation shape for `GetFindingStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_finding_statistics`](crate::client::Client::get_finding_statistics).
///
/// See [`crate::client::fluent_builders::GetFindingStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetFindingStatistics {
    _private: (),
}
impl GetFindingStatistics {
    /// Creates a new builder-style object to manufacture [`GetFindingStatisticsInput`](crate::input::GetFindingStatisticsInput)
    pub fn builder() -> crate::input::get_finding_statistics_input::Builder {
        crate::input::get_finding_statistics_input::Builder::default()
    }
    /// Creates a new `GetFindingStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetFindingStatistics {
    type Output = std::result::Result<
        crate::output::GetFindingStatisticsOutput,
        crate::error::GetFindingStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_finding_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_finding_statistics_response(response)
        }
    }
}

/// Operation shape for `GetInvitationsCount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_invitations_count`](crate::client::Client::get_invitations_count).
///
/// See [`crate::client::fluent_builders::GetInvitationsCount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetInvitationsCount {
    _private: (),
}
impl GetInvitationsCount {
    /// Creates a new builder-style object to manufacture [`GetInvitationsCountInput`](crate::input::GetInvitationsCountInput)
    pub fn builder() -> crate::input::get_invitations_count_input::Builder {
        crate::input::get_invitations_count_input::Builder::default()
    }
    /// Creates a new `GetInvitationsCount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetInvitationsCount {
    type Output = std::result::Result<
        crate::output::GetInvitationsCountOutput,
        crate::error::GetInvitationsCountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_invitations_count_error(response)
        } else {
            crate::operation_deser::parse_get_invitations_count_response(response)
        }
    }
}

/// Operation shape for `GetMacieSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_macie_session`](crate::client::Client::get_macie_session).
///
/// See [`crate::client::fluent_builders::GetMacieSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMacieSession {
    _private: (),
}
impl GetMacieSession {
    /// Creates a new builder-style object to manufacture [`GetMacieSessionInput`](crate::input::GetMacieSessionInput)
    pub fn builder() -> crate::input::get_macie_session_input::Builder {
        crate::input::get_macie_session_input::Builder::default()
    }
    /// Creates a new `GetMacieSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMacieSession {
    type Output = std::result::Result<
        crate::output::GetMacieSessionOutput,
        crate::error::GetMacieSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_macie_session_error(response)
        } else {
            crate::operation_deser::parse_get_macie_session_response(response)
        }
    }
}

/// Operation shape for `GetMasterAccount`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_master_account`](crate::client::Client::get_master_account).
///
/// See [`crate::client::fluent_builders::GetMasterAccount`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMasterAccount {
    _private: (),
}
impl GetMasterAccount {
    /// Creates a new builder-style object to manufacture [`GetMasterAccountInput`](crate::input::GetMasterAccountInput)
    pub fn builder() -> crate::input::get_master_account_input::Builder {
        crate::input::get_master_account_input::Builder::default()
    }
    /// Creates a new `GetMasterAccount` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMasterAccount {
    type Output = std::result::Result<
        crate::output::GetMasterAccountOutput,
        crate::error::GetMasterAccountError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_master_account_error(response)
        } else {
            crate::operation_deser::parse_get_master_account_response(response)
        }
    }
}

/// Operation shape for `GetMember`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_member`](crate::client::Client::get_member).
///
/// See [`crate::client::fluent_builders::GetMember`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetMember {
    _private: (),
}
impl GetMember {
    /// Creates a new builder-style object to manufacture [`GetMemberInput`](crate::input::GetMemberInput)
    pub fn builder() -> crate::input::get_member_input::Builder {
        crate::input::get_member_input::Builder::default()
    }
    /// Creates a new `GetMember` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetMember {
    type Output = std::result::Result<crate::output::GetMemberOutput, crate::error::GetMemberError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_member_error(response)
        } else {
            crate::operation_deser::parse_get_member_response(response)
        }
    }
}

/// Operation shape for `GetUsageStatistics`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_statistics`](crate::client::Client::get_usage_statistics).
///
/// See [`crate::client::fluent_builders::GetUsageStatistics`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsageStatistics {
    _private: (),
}
impl GetUsageStatistics {
    /// Creates a new builder-style object to manufacture [`GetUsageStatisticsInput`](crate::input::GetUsageStatisticsInput)
    pub fn builder() -> crate::input::get_usage_statistics_input::Builder {
        crate::input::get_usage_statistics_input::Builder::default()
    }
    /// Creates a new `GetUsageStatistics` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsageStatistics {
    type Output = std::result::Result<
        crate::output::GetUsageStatisticsOutput,
        crate::error::GetUsageStatisticsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_statistics_error(response)
        } else {
            crate::operation_deser::parse_get_usage_statistics_response(response)
        }
    }
}

/// Operation shape for `GetUsageTotals`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`get_usage_totals`](crate::client::Client::get_usage_totals).
///
/// See [`crate::client::fluent_builders::GetUsageTotals`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct GetUsageTotals {
    _private: (),
}
impl GetUsageTotals {
    /// Creates a new builder-style object to manufacture [`GetUsageTotalsInput`](crate::input::GetUsageTotalsInput)
    pub fn builder() -> crate::input::get_usage_totals_input::Builder {
        crate::input::get_usage_totals_input::Builder::default()
    }
    /// Creates a new `GetUsageTotals` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for GetUsageTotals {
    type Output =
        std::result::Result<crate::output::GetUsageTotalsOutput, crate::error::GetUsageTotalsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_get_usage_totals_error(response)
        } else {
            crate::operation_deser::parse_get_usage_totals_response(response)
        }
    }
}

/// Operation shape for `ListClassificationJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_classification_jobs`](crate::client::Client::list_classification_jobs).
///
/// See [`crate::client::fluent_builders::ListClassificationJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListClassificationJobs {
    _private: (),
}
impl ListClassificationJobs {
    /// Creates a new builder-style object to manufacture [`ListClassificationJobsInput`](crate::input::ListClassificationJobsInput)
    pub fn builder() -> crate::input::list_classification_jobs_input::Builder {
        crate::input::list_classification_jobs_input::Builder::default()
    }
    /// Creates a new `ListClassificationJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListClassificationJobs {
    type Output = std::result::Result<
        crate::output::ListClassificationJobsOutput,
        crate::error::ListClassificationJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_classification_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_classification_jobs_response(response)
        }
    }
}

/// Operation shape for `ListCustomDataIdentifiers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_custom_data_identifiers`](crate::client::Client::list_custom_data_identifiers).
///
/// See [`crate::client::fluent_builders::ListCustomDataIdentifiers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListCustomDataIdentifiers {
    _private: (),
}
impl ListCustomDataIdentifiers {
    /// Creates a new builder-style object to manufacture [`ListCustomDataIdentifiersInput`](crate::input::ListCustomDataIdentifiersInput)
    pub fn builder() -> crate::input::list_custom_data_identifiers_input::Builder {
        crate::input::list_custom_data_identifiers_input::Builder::default()
    }
    /// Creates a new `ListCustomDataIdentifiers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListCustomDataIdentifiers {
    type Output = std::result::Result<
        crate::output::ListCustomDataIdentifiersOutput,
        crate::error::ListCustomDataIdentifiersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_custom_data_identifiers_error(response)
        } else {
            crate::operation_deser::parse_list_custom_data_identifiers_response(response)
        }
    }
}

/// Operation shape for `ListFindings`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings`](crate::client::Client::list_findings).
///
/// See [`crate::client::fluent_builders::ListFindings`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindings {
    _private: (),
}
impl ListFindings {
    /// Creates a new builder-style object to manufacture [`ListFindingsInput`](crate::input::ListFindingsInput)
    pub fn builder() -> crate::input::list_findings_input::Builder {
        crate::input::list_findings_input::Builder::default()
    }
    /// Creates a new `ListFindings` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindings {
    type Output =
        std::result::Result<crate::output::ListFindingsOutput, crate::error::ListFindingsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_error(response)
        } else {
            crate::operation_deser::parse_list_findings_response(response)
        }
    }
}

/// Operation shape for `ListFindingsFilters`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_findings_filters`](crate::client::Client::list_findings_filters).
///
/// See [`crate::client::fluent_builders::ListFindingsFilters`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListFindingsFilters {
    _private: (),
}
impl ListFindingsFilters {
    /// Creates a new builder-style object to manufacture [`ListFindingsFiltersInput`](crate::input::ListFindingsFiltersInput)
    pub fn builder() -> crate::input::list_findings_filters_input::Builder {
        crate::input::list_findings_filters_input::Builder::default()
    }
    /// Creates a new `ListFindingsFilters` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListFindingsFilters {
    type Output = std::result::Result<
        crate::output::ListFindingsFiltersOutput,
        crate::error::ListFindingsFiltersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_findings_filters_error(response)
        } else {
            crate::operation_deser::parse_list_findings_filters_response(response)
        }
    }
}

/// Operation shape for `ListInvitations`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_invitations`](crate::client::Client::list_invitations).
///
/// See [`crate::client::fluent_builders::ListInvitations`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListInvitations {
    _private: (),
}
impl ListInvitations {
    /// Creates a new builder-style object to manufacture [`ListInvitationsInput`](crate::input::ListInvitationsInput)
    pub fn builder() -> crate::input::list_invitations_input::Builder {
        crate::input::list_invitations_input::Builder::default()
    }
    /// Creates a new `ListInvitations` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListInvitations {
    type Output = std::result::Result<
        crate::output::ListInvitationsOutput,
        crate::error::ListInvitationsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_invitations_error(response)
        } else {
            crate::operation_deser::parse_list_invitations_response(response)
        }
    }
}

/// Operation shape for `ListManagedDataIdentifiers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_managed_data_identifiers`](crate::client::Client::list_managed_data_identifiers).
///
/// See [`crate::client::fluent_builders::ListManagedDataIdentifiers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListManagedDataIdentifiers {
    _private: (),
}
impl ListManagedDataIdentifiers {
    /// Creates a new builder-style object to manufacture [`ListManagedDataIdentifiersInput`](crate::input::ListManagedDataIdentifiersInput)
    pub fn builder() -> crate::input::list_managed_data_identifiers_input::Builder {
        crate::input::list_managed_data_identifiers_input::Builder::default()
    }
    /// Creates a new `ListManagedDataIdentifiers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListManagedDataIdentifiers {
    type Output = std::result::Result<
        crate::output::ListManagedDataIdentifiersOutput,
        crate::error::ListManagedDataIdentifiersError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_managed_data_identifiers_error(response)
        } else {
            crate::operation_deser::parse_list_managed_data_identifiers_response(response)
        }
    }
}

/// Operation shape for `ListMembers`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_members`](crate::client::Client::list_members).
///
/// See [`crate::client::fluent_builders::ListMembers`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListMembers {
    _private: (),
}
impl ListMembers {
    /// Creates a new builder-style object to manufacture [`ListMembersInput`](crate::input::ListMembersInput)
    pub fn builder() -> crate::input::list_members_input::Builder {
        crate::input::list_members_input::Builder::default()
    }
    /// Creates a new `ListMembers` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListMembers {
    type Output =
        std::result::Result<crate::output::ListMembersOutput, crate::error::ListMembersError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_members_error(response)
        } else {
            crate::operation_deser::parse_list_members_response(response)
        }
    }
}

/// Operation shape for `ListOrganizationAdminAccounts`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_organization_admin_accounts`](crate::client::Client::list_organization_admin_accounts).
///
/// See [`crate::client::fluent_builders::ListOrganizationAdminAccounts`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListOrganizationAdminAccounts {
    _private: (),
}
impl ListOrganizationAdminAccounts {
    /// Creates a new builder-style object to manufacture [`ListOrganizationAdminAccountsInput`](crate::input::ListOrganizationAdminAccountsInput)
    pub fn builder() -> crate::input::list_organization_admin_accounts_input::Builder {
        crate::input::list_organization_admin_accounts_input::Builder::default()
    }
    /// Creates a new `ListOrganizationAdminAccounts` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListOrganizationAdminAccounts {
    type Output = std::result::Result<
        crate::output::ListOrganizationAdminAccountsOutput,
        crate::error::ListOrganizationAdminAccountsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_organization_admin_accounts_error(response)
        } else {
            crate::operation_deser::parse_list_organization_admin_accounts_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `PutClassificationExportConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_classification_export_configuration`](crate::client::Client::put_classification_export_configuration).
///
/// See [`crate::client::fluent_builders::PutClassificationExportConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutClassificationExportConfiguration {
    _private: (),
}
impl PutClassificationExportConfiguration {
    /// Creates a new builder-style object to manufacture [`PutClassificationExportConfigurationInput`](crate::input::PutClassificationExportConfigurationInput)
    pub fn builder() -> crate::input::put_classification_export_configuration_input::Builder {
        crate::input::put_classification_export_configuration_input::Builder::default()
    }
    /// Creates a new `PutClassificationExportConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutClassificationExportConfiguration {
    type Output = std::result::Result<
        crate::output::PutClassificationExportConfigurationOutput,
        crate::error::PutClassificationExportConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_classification_export_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_classification_export_configuration_response(response)
        }
    }
}

/// Operation shape for `PutFindingsPublicationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`put_findings_publication_configuration`](crate::client::Client::put_findings_publication_configuration).
///
/// See [`crate::client::fluent_builders::PutFindingsPublicationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct PutFindingsPublicationConfiguration {
    _private: (),
}
impl PutFindingsPublicationConfiguration {
    /// Creates a new builder-style object to manufacture [`PutFindingsPublicationConfigurationInput`](crate::input::PutFindingsPublicationConfigurationInput)
    pub fn builder() -> crate::input::put_findings_publication_configuration_input::Builder {
        crate::input::put_findings_publication_configuration_input::Builder::default()
    }
    /// Creates a new `PutFindingsPublicationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for PutFindingsPublicationConfiguration {
    type Output = std::result::Result<
        crate::output::PutFindingsPublicationConfigurationOutput,
        crate::error::PutFindingsPublicationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_put_findings_publication_configuration_error(response)
        } else {
            crate::operation_deser::parse_put_findings_publication_configuration_response(response)
        }
    }
}

/// Operation shape for `SearchResources`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`search_resources`](crate::client::Client::search_resources).
///
/// See [`crate::client::fluent_builders::SearchResources`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct SearchResources {
    _private: (),
}
impl SearchResources {
    /// Creates a new builder-style object to manufacture [`SearchResourcesInput`](crate::input::SearchResourcesInput)
    pub fn builder() -> crate::input::search_resources_input::Builder {
        crate::input::search_resources_input::Builder::default()
    }
    /// Creates a new `SearchResources` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for SearchResources {
    type Output = std::result::Result<
        crate::output::SearchResourcesOutput,
        crate::error::SearchResourcesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_search_resources_error(response)
        } else {
            crate::operation_deser::parse_search_resources_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `TestCustomDataIdentifier`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`test_custom_data_identifier`](crate::client::Client::test_custom_data_identifier).
///
/// See [`crate::client::fluent_builders::TestCustomDataIdentifier`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TestCustomDataIdentifier {
    _private: (),
}
impl TestCustomDataIdentifier {
    /// Creates a new builder-style object to manufacture [`TestCustomDataIdentifierInput`](crate::input::TestCustomDataIdentifierInput)
    pub fn builder() -> crate::input::test_custom_data_identifier_input::Builder {
        crate::input::test_custom_data_identifier_input::Builder::default()
    }
    /// Creates a new `TestCustomDataIdentifier` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TestCustomDataIdentifier {
    type Output = std::result::Result<
        crate::output::TestCustomDataIdentifierOutput,
        crate::error::TestCustomDataIdentifierError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_test_custom_data_identifier_error(response)
        } else {
            crate::operation_deser::parse_test_custom_data_identifier_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 204 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateClassificationJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_classification_job`](crate::client::Client::update_classification_job).
///
/// See [`crate::client::fluent_builders::UpdateClassificationJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateClassificationJob {
    _private: (),
}
impl UpdateClassificationJob {
    /// Creates a new builder-style object to manufacture [`UpdateClassificationJobInput`](crate::input::UpdateClassificationJobInput)
    pub fn builder() -> crate::input::update_classification_job_input::Builder {
        crate::input::update_classification_job_input::Builder::default()
    }
    /// Creates a new `UpdateClassificationJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateClassificationJob {
    type Output = std::result::Result<
        crate::output::UpdateClassificationJobOutput,
        crate::error::UpdateClassificationJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_classification_job_error(response)
        } else {
            crate::operation_deser::parse_update_classification_job_response(response)
        }
    }
}

/// Operation shape for `UpdateFindingsFilter`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_findings_filter`](crate::client::Client::update_findings_filter).
///
/// See [`crate::client::fluent_builders::UpdateFindingsFilter`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateFindingsFilter {
    _private: (),
}
impl UpdateFindingsFilter {
    /// Creates a new builder-style object to manufacture [`UpdateFindingsFilterInput`](crate::input::UpdateFindingsFilterInput)
    pub fn builder() -> crate::input::update_findings_filter_input::Builder {
        crate::input::update_findings_filter_input::Builder::default()
    }
    /// Creates a new `UpdateFindingsFilter` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateFindingsFilter {
    type Output = std::result::Result<
        crate::output::UpdateFindingsFilterOutput,
        crate::error::UpdateFindingsFilterError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_findings_filter_error(response)
        } else {
            crate::operation_deser::parse_update_findings_filter_response(response)
        }
    }
}

/// Operation shape for `UpdateMacieSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_macie_session`](crate::client::Client::update_macie_session).
///
/// See [`crate::client::fluent_builders::UpdateMacieSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMacieSession {
    _private: (),
}
impl UpdateMacieSession {
    /// Creates a new builder-style object to manufacture [`UpdateMacieSessionInput`](crate::input::UpdateMacieSessionInput)
    pub fn builder() -> crate::input::update_macie_session_input::Builder {
        crate::input::update_macie_session_input::Builder::default()
    }
    /// Creates a new `UpdateMacieSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMacieSession {
    type Output = std::result::Result<
        crate::output::UpdateMacieSessionOutput,
        crate::error::UpdateMacieSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_macie_session_error(response)
        } else {
            crate::operation_deser::parse_update_macie_session_response(response)
        }
    }
}

/// Operation shape for `UpdateMemberSession`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_member_session`](crate::client::Client::update_member_session).
///
/// See [`crate::client::fluent_builders::UpdateMemberSession`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateMemberSession {
    _private: (),
}
impl UpdateMemberSession {
    /// Creates a new builder-style object to manufacture [`UpdateMemberSessionInput`](crate::input::UpdateMemberSessionInput)
    pub fn builder() -> crate::input::update_member_session_input::Builder {
        crate::input::update_member_session_input::Builder::default()
    }
    /// Creates a new `UpdateMemberSession` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateMemberSession {
    type Output = std::result::Result<
        crate::output::UpdateMemberSessionOutput,
        crate::error::UpdateMemberSessionError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_member_session_error(response)
        } else {
            crate::operation_deser::parse_update_member_session_response(response)
        }
    }
}

/// Operation shape for `UpdateOrganizationConfiguration`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_organization_configuration`](crate::client::Client::update_organization_configuration).
///
/// See [`crate::client::fluent_builders::UpdateOrganizationConfiguration`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateOrganizationConfiguration {
    _private: (),
}
impl UpdateOrganizationConfiguration {
    /// Creates a new builder-style object to manufacture [`UpdateOrganizationConfigurationInput`](crate::input::UpdateOrganizationConfigurationInput)
    pub fn builder() -> crate::input::update_organization_configuration_input::Builder {
        crate::input::update_organization_configuration_input::Builder::default()
    }
    /// Creates a new `UpdateOrganizationConfiguration` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateOrganizationConfiguration {
    type Output = std::result::Result<
        crate::output::UpdateOrganizationConfigurationOutput,
        crate::error::UpdateOrganizationConfigurationError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_update_organization_configuration_error(response)
        } else {
            crate::operation_deser::parse_update_organization_configuration_response(response)
        }
    }
}
