// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Macie
///
/// Client for invoking operations on Amazon Macie. Each operation on Amazon Macie is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_macie::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_macie::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_macie::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AssociateMemberAccount`](crate::client::fluent_builders::AssociateMemberAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::AssociateMemberAccount::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::AssociateMemberAccount::set_member_account_id): <p>The ID of the AWS account that you want to associate with Amazon Macie Classic as a member account.</p>
    /// - On success, responds with [`AssociateMemberAccountOutput`](crate::output::AssociateMemberAccountOutput)

    /// - On failure, responds with [`SdkError<AssociateMemberAccountError>`](crate::error::AssociateMemberAccountError)
    pub fn associate_member_account(&self) -> fluent_builders::AssociateMemberAccount {
        fluent_builders::AssociateMemberAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`AssociateS3Resources`](crate::client::fluent_builders::AssociateS3Resources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::AssociateS3Resources::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::AssociateS3Resources::set_member_account_id): <p>The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie Classic. </p>
    ///   - [`s3_resources(Vec<S3ResourceClassification>)`](crate::client::fluent_builders::AssociateS3Resources::s3_resources) / [`set_s3_resources(Option<Vec<S3ResourceClassification>>)`](crate::client::fluent_builders::AssociateS3Resources::set_s3_resources): <p>The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification. </p>
    /// - On success, responds with [`AssociateS3ResourcesOutput`](crate::output::AssociateS3ResourcesOutput) with field(s):
    ///   - [`failed_s3_resources(Option<Vec<FailedS3Resource>>)`](crate::output::AssociateS3ResourcesOutput::failed_s3_resources): <p>S3 resources that couldn't be associated with Amazon Macie Classic. An error code and an error message are provided for each failed item. </p>
    /// - On failure, responds with [`SdkError<AssociateS3ResourcesError>`](crate::error::AssociateS3ResourcesError)
    pub fn associate_s3_resources(&self) -> fluent_builders::AssociateS3Resources {
        fluent_builders::AssociateS3Resources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateMemberAccount`](crate::client::fluent_builders::DisassociateMemberAccount) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateMemberAccount::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::DisassociateMemberAccount::set_member_account_id): <p>The ID of the member account that you want to remove from Amazon Macie Classic.</p>
    /// - On success, responds with [`DisassociateMemberAccountOutput`](crate::output::DisassociateMemberAccountOutput)

    /// - On failure, responds with [`SdkError<DisassociateMemberAccountError>`](crate::error::DisassociateMemberAccountError)
    pub fn disassociate_member_account(&self) -> fluent_builders::DisassociateMemberAccount {
        fluent_builders::DisassociateMemberAccount::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DisassociateS3Resources`](crate::client::fluent_builders::DisassociateS3Resources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::DisassociateS3Resources::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::DisassociateS3Resources::set_member_account_id): <p>The ID of the Amazon Macie Classic member account whose resources you want to remove from being monitored by Macie Classic. </p>
    ///   - [`associated_s3_resources(Vec<S3Resource>)`](crate::client::fluent_builders::DisassociateS3Resources::associated_s3_resources) / [`set_associated_s3_resources(Option<Vec<S3Resource>>)`](crate::client::fluent_builders::DisassociateS3Resources::set_associated_s3_resources): <p>The S3 resources (buckets or prefixes) that you want to remove from being monitored and classified by Amazon Macie Classic. </p>
    /// - On success, responds with [`DisassociateS3ResourcesOutput`](crate::output::DisassociateS3ResourcesOutput) with field(s):
    ///   - [`failed_s3_resources(Option<Vec<FailedS3Resource>>)`](crate::output::DisassociateS3ResourcesOutput::failed_s3_resources): <p>S3 resources that couldn't be removed from being monitored and classified by Amazon Macie Classic. An error code and an error message are provided for each failed item. </p>
    /// - On failure, responds with [`SdkError<DisassociateS3ResourcesError>`](crate::error::DisassociateS3ResourcesError)
    pub fn disassociate_s3_resources(&self) -> fluent_builders::DisassociateS3Resources {
        fluent_builders::DisassociateS3Resources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListMemberAccounts`](crate::client::fluent_builders::ListMemberAccounts) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListMemberAccounts::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListMemberAccounts::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListMemberAccounts::set_next_token): <p>Use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListMemberAccounts action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListMemberAccounts::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListMemberAccounts::set_max_results): <p>Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. </p>
    /// - On success, responds with [`ListMemberAccountsOutput`](crate::output::ListMemberAccountsOutput) with field(s):
    ///   - [`member_accounts(Option<Vec<MemberAccount>>)`](crate::output::ListMemberAccountsOutput::member_accounts): <p>A list of the Amazon Macie Classic member accounts returned by the action. The current Macie Classic administrator account is also included in this list. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListMemberAccountsOutput::next_token): <p>When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null. </p>
    /// - On failure, responds with [`SdkError<ListMemberAccountsError>`](crate::error::ListMemberAccountsError)
    pub fn list_member_accounts(&self) -> fluent_builders::ListMemberAccounts {
        fluent_builders::ListMemberAccounts::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListS3Resources`](crate::client::fluent_builders::ListS3Resources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListS3Resources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::ListS3Resources::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::ListS3Resources::set_member_account_id): <p>The Amazon Macie Classic member account ID whose associated S3 resources you want to list. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListS3Resources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListS3Resources::set_next_token): <p>Use this parameter when paginating results. Set its value to null on your first call to the ListS3Resources action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListS3Resources::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListS3Resources::set_max_results): <p>Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. </p>
    /// - On success, responds with [`ListS3ResourcesOutput`](crate::output::ListS3ResourcesOutput) with field(s):
    ///   - [`s3_resources(Option<Vec<S3ResourceClassification>>)`](crate::output::ListS3ResourcesOutput::s3_resources): <p>A list of the associated S3 resources returned by the action.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListS3ResourcesOutput::next_token): <p>When a response is generated, if there is more data to be listed, this parameter is present in the response and contains the value to use for the nextToken parameter in a subsequent pagination request. If there is no more data to be listed, this parameter is set to null. </p>
    /// - On failure, responds with [`SdkError<ListS3ResourcesError>`](crate::error::ListS3ResourcesError)
    pub fn list_s3_resources(&self) -> fluent_builders::ListS3Resources {
        fluent_builders::ListS3Resources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateS3Resources`](crate::client::fluent_builders::UpdateS3Resources) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`member_account_id(impl Into<String>)`](crate::client::fluent_builders::UpdateS3Resources::member_account_id) / [`set_member_account_id(Option<String>)`](crate::client::fluent_builders::UpdateS3Resources::set_member_account_id): <p>The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want to update. </p>
    ///   - [`s3_resources_update(Vec<S3ResourceClassificationUpdate>)`](crate::client::fluent_builders::UpdateS3Resources::s3_resources_update) / [`set_s3_resources_update(Option<Vec<S3ResourceClassificationUpdate>>)`](crate::client::fluent_builders::UpdateS3Resources::set_s3_resources_update): <p>The S3 resources whose classification types you want to update.</p>
    /// - On success, responds with [`UpdateS3ResourcesOutput`](crate::output::UpdateS3ResourcesOutput) with field(s):
    ///   - [`failed_s3_resources(Option<Vec<FailedS3Resource>>)`](crate::output::UpdateS3ResourcesOutput::failed_s3_resources): <p>The S3 resources whose classification types can't be updated. An error code and an error message are provided for each failed item. </p>
    /// - On failure, responds with [`SdkError<UpdateS3ResourcesError>`](crate::error::UpdateS3ResourcesError)
    pub fn update_s3_resources(&self) -> fluent_builders::UpdateS3Resources {
        fluent_builders::UpdateS3Resources::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AssociateMemberAccount`.
    ///
    /// <p>Associates a specified AWS account with Amazon Macie Classic as a member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateMemberAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_member_account_input::Builder,
    }
    impl AssociateMemberAccount {
        /// Creates a new `AssociateMemberAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateMemberAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateMemberAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the AWS account that you want to associate with Amazon Macie Classic as a member account.</p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The ID of the AWS account that you want to associate with Amazon Macie Classic as a member account.</p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `AssociateS3Resources`.
    ///
    /// <p>Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification. If memberAccountId isn't specified, the action associates specified S3 resources with Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action associates specified S3 resources with Macie Classic for the specified member account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AssociateS3Resources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::associate_s3_resources_input::Builder,
    }
    impl AssociateS3Resources {
        /// Creates a new `AssociateS3Resources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AssociateS3ResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::AssociateS3ResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie Classic. </p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Macie Classic member account whose resources you want to associate with Macie Classic. </p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
        /// Appends an item to `s3Resources`.
        ///
        /// To override the contents of this collection use [`set_s3_resources`](Self::set_s3_resources).
        ///
        /// <p>The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification. </p>
        pub fn s3_resources(mut self, input: crate::model::S3ResourceClassification) -> Self {
            self.inner = self.inner.s3_resources(input);
            self
        }
        /// <p>The S3 resources that you want to associate with Amazon Macie Classic for monitoring and data classification. </p>
        pub fn set_s3_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3ResourceClassification>>,
        ) -> Self {
            self.inner = self.inner.set_s3_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateMemberAccount`.
    ///
    /// <p>Removes the specified member account from Amazon Macie Classic.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateMemberAccount {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_member_account_input::Builder,
    }
    impl DisassociateMemberAccount {
        /// Creates a new `DisassociateMemberAccount`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateMemberAccountOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateMemberAccountError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the member account that you want to remove from Amazon Macie Classic.</p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The ID of the member account that you want to remove from Amazon Macie Classic.</p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DisassociateS3Resources`.
    ///
    /// <p>Removes specified S3 resources from being monitored by Amazon Macie Classic. If memberAccountId isn't specified, the action removes specified S3 resources from Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action removes specified S3 resources from Macie Classic for the specified member account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DisassociateS3Resources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::disassociate_s3_resources_input::Builder,
    }
    impl DisassociateS3Resources {
        /// Creates a new `DisassociateS3Resources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DisassociateS3ResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DisassociateS3ResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the Amazon Macie Classic member account whose resources you want to remove from being monitored by Macie Classic. </p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The ID of the Amazon Macie Classic member account whose resources you want to remove from being monitored by Macie Classic. </p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
        /// Appends an item to `associatedS3Resources`.
        ///
        /// To override the contents of this collection use [`set_associated_s3_resources`](Self::set_associated_s3_resources).
        ///
        /// <p>The S3 resources (buckets or prefixes) that you want to remove from being monitored and classified by Amazon Macie Classic. </p>
        pub fn associated_s3_resources(mut self, input: crate::model::S3Resource) -> Self {
            self.inner = self.inner.associated_s3_resources(input);
            self
        }
        /// <p>The S3 resources (buckets or prefixes) that you want to remove from being monitored and classified by Amazon Macie Classic. </p>
        pub fn set_associated_s3_resources(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3Resource>>,
        ) -> Self {
            self.inner = self.inner.set_associated_s3_resources(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListMemberAccounts`.
    ///
    /// <p>Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListMemberAccounts {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_member_accounts_input::Builder,
    }
    impl ListMemberAccounts {
        /// Creates a new `ListMemberAccounts`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListMemberAccountsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListMemberAccountsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListMemberAccountsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListMemberAccountsPaginator {
            crate::paginator::ListMemberAccountsPaginator::new(self.handle, self.inner)
        }
        /// <p>Use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListMemberAccounts action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListMemberAccounts action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListS3Resources`.
    ///
    /// <p>Lists all the S3 resources associated with Amazon Macie Classic. If memberAccountId isn't specified, the action lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action lists the S3 resources associated with Macie Classic for the specified member account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListS3Resources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_s3_resources_input::Builder,
    }
    impl ListS3Resources {
        /// Creates a new `ListS3Resources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListS3ResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListS3ResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListS3ResourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListS3ResourcesPaginator {
            crate::paginator::ListS3ResourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>The Amazon Macie Classic member account ID whose associated S3 resources you want to list. </p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The Amazon Macie Classic member account ID whose associated S3 resources you want to list. </p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
        /// <p>Use this parameter when paginating results. Set its value to null on your first call to the ListS3Resources action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>Use this parameter when paginating results. Set its value to null on your first call to the ListS3Resources action. Subsequent calls to the action fill nextToken in the request with the value of nextToken from the previous response to continue listing data. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>Use this parameter to indicate the maximum number of items that you want in the response. The default value is 250. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateS3Resources`.
    ///
    /// <p>Updates the classification types for the specified S3 resources. If memberAccountId isn't specified, the action updates the classification types of the S3 resources associated with Amazon Macie Classic for the current Macie Classic administrator account. If memberAccountId is specified, the action updates the classification types of the S3 resources associated with Macie Classic for the specified member account. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateS3Resources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_s3_resources_input::Builder,
    }
    impl UpdateS3Resources {
        /// Creates a new `UpdateS3Resources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateS3ResourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateS3ResourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want to update. </p>
        pub fn member_account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.member_account_id(input.into());
            self
        }
        /// <p>The AWS ID of the Amazon Macie Classic member account whose S3 resources' classification types you want to update. </p>
        pub fn set_member_account_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_member_account_id(input);
            self
        }
        /// Appends an item to `s3ResourcesUpdate`.
        ///
        /// To override the contents of this collection use [`set_s3_resources_update`](Self::set_s3_resources_update).
        ///
        /// <p>The S3 resources whose classification types you want to update.</p>
        pub fn s3_resources_update(
            mut self,
            input: crate::model::S3ResourceClassificationUpdate,
        ) -> Self {
            self.inner = self.inner.s3_resources_update(input);
            self
        }
        /// <p>The S3 resources whose classification types you want to update.</p>
        pub fn set_s3_resources_update(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::S3ResourceClassificationUpdate>>,
        ) -> Self {
            self.inner = self.inner.set_s3_resources_update(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
