// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Includes details about the failed S3 resources.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct FailedS3Resource {
    /// <p>The failed S3 resources.</p>
    pub failed_item: std::option::Option<crate::model::S3Resource>,
    /// <p>The status code of a failed item.</p>
    pub error_code: std::option::Option<std::string::String>,
    /// <p>The error message of a failed item.</p>
    pub error_message: std::option::Option<std::string::String>,
}
impl FailedS3Resource {
    /// <p>The failed S3 resources.</p>
    pub fn failed_item(&self) -> std::option::Option<&crate::model::S3Resource> {
        self.failed_item.as_ref()
    }
    /// <p>The status code of a failed item.</p>
    pub fn error_code(&self) -> std::option::Option<&str> {
        self.error_code.as_deref()
    }
    /// <p>The error message of a failed item.</p>
    pub fn error_message(&self) -> std::option::Option<&str> {
        self.error_message.as_deref()
    }
}
impl std::fmt::Debug for FailedS3Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("FailedS3Resource");
        formatter.field("failed_item", &self.failed_item);
        formatter.field("error_code", &self.error_code);
        formatter.field("error_message", &self.error_message);
        formatter.finish()
    }
}
/// See [`FailedS3Resource`](crate::model::FailedS3Resource)
pub mod failed_s3_resource {
    /// A builder for [`FailedS3Resource`](crate::model::FailedS3Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) failed_item: std::option::Option<crate::model::S3Resource>,
        pub(crate) error_code: std::option::Option<std::string::String>,
        pub(crate) error_message: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The failed S3 resources.</p>
        pub fn failed_item(mut self, input: crate::model::S3Resource) -> Self {
            self.failed_item = Some(input);
            self
        }
        /// <p>The failed S3 resources.</p>
        pub fn set_failed_item(
            mut self,
            input: std::option::Option<crate::model::S3Resource>,
        ) -> Self {
            self.failed_item = input;
            self
        }
        /// <p>The status code of a failed item.</p>
        pub fn error_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_code = Some(input.into());
            self
        }
        /// <p>The status code of a failed item.</p>
        pub fn set_error_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.error_code = input;
            self
        }
        /// <p>The error message of a failed item.</p>
        pub fn error_message(mut self, input: impl Into<std::string::String>) -> Self {
            self.error_message = Some(input.into());
            self
        }
        /// <p>The error message of a failed item.</p>
        pub fn set_error_message(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.error_message = input;
            self
        }
        /// Consumes the builder and constructs a [`FailedS3Resource`](crate::model::FailedS3Resource)
        pub fn build(self) -> crate::model::FailedS3Resource {
            crate::model::FailedS3Resource {
                failed_item: self.failed_item,
                error_code: self.error_code,
                error_message: self.error_message,
            }
        }
    }
}
impl FailedS3Resource {
    /// Creates a new builder-style object to manufacture [`FailedS3Resource`](crate::model::FailedS3Resource)
    pub fn builder() -> crate::model::failed_s3_resource::Builder {
        crate::model::failed_s3_resource::Builder::default()
    }
}

/// <p>Contains information about the S3 resource. This data type is used as a request
/// parameter in the DisassociateS3Resources action and can be used as a response parameter in the
/// AssociateS3Resources and UpdateS3Resources actions. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3Resource {
    /// <p>The name of the S3 bucket.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix of the S3 bucket. </p>
    pub prefix: std::option::Option<std::string::String>,
}
impl S3Resource {
    /// <p>The name of the S3 bucket.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix of the S3 bucket. </p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
}
impl std::fmt::Debug for S3Resource {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3Resource");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.finish()
    }
}
/// See [`S3Resource`](crate::model::S3Resource)
pub mod s3_resource {
    /// A builder for [`S3Resource`](crate::model::S3Resource)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix of the S3 bucket. </p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the S3 bucket. </p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// Consumes the builder and constructs a [`S3Resource`](crate::model::S3Resource)
        pub fn build(self) -> crate::model::S3Resource {
            crate::model::S3Resource {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
            }
        }
    }
}
impl S3Resource {
    /// Creates a new builder-style object to manufacture [`S3Resource`](crate::model::S3Resource)
    pub fn builder() -> crate::model::s3_resource::Builder {
        crate::model::s3_resource::Builder::default()
    }
}

/// <p>The S3 resources whose classification types you want to update. This data type is used
/// as a request parameter in the UpdateS3Resources action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ResourceClassificationUpdate {
    /// <p>The name of the S3 bucket whose classification types you want to update.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix of the S3 bucket whose classification types you want to update.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The classification type that you want to update for the resource associated with Amazon
    /// Macie Classic. </p>
    pub classification_type_update: std::option::Option<crate::model::ClassificationTypeUpdate>,
}
impl S3ResourceClassificationUpdate {
    /// <p>The name of the S3 bucket whose classification types you want to update.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix of the S3 bucket whose classification types you want to update.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The classification type that you want to update for the resource associated with Amazon
    /// Macie Classic. </p>
    pub fn classification_type_update(
        &self,
    ) -> std::option::Option<&crate::model::ClassificationTypeUpdate> {
        self.classification_type_update.as_ref()
    }
}
impl std::fmt::Debug for S3ResourceClassificationUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ResourceClassificationUpdate");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.field(
            "classification_type_update",
            &self.classification_type_update,
        );
        formatter.finish()
    }
}
/// See [`S3ResourceClassificationUpdate`](crate::model::S3ResourceClassificationUpdate)
pub mod s3_resource_classification_update {
    /// A builder for [`S3ResourceClassificationUpdate`](crate::model::S3ResourceClassificationUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) classification_type_update:
            std::option::Option<crate::model::ClassificationTypeUpdate>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket whose classification types you want to update.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket whose classification types you want to update.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix of the S3 bucket whose classification types you want to update.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the S3 bucket whose classification types you want to update.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The classification type that you want to update for the resource associated with Amazon
        /// Macie Classic. </p>
        pub fn classification_type_update(
            mut self,
            input: crate::model::ClassificationTypeUpdate,
        ) -> Self {
            self.classification_type_update = Some(input);
            self
        }
        /// <p>The classification type that you want to update for the resource associated with Amazon
        /// Macie Classic. </p>
        pub fn set_classification_type_update(
            mut self,
            input: std::option::Option<crate::model::ClassificationTypeUpdate>,
        ) -> Self {
            self.classification_type_update = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ResourceClassificationUpdate`](crate::model::S3ResourceClassificationUpdate)
        pub fn build(self) -> crate::model::S3ResourceClassificationUpdate {
            crate::model::S3ResourceClassificationUpdate {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
                classification_type_update: self.classification_type_update,
            }
        }
    }
}
impl S3ResourceClassificationUpdate {
    /// Creates a new builder-style object to manufacture [`S3ResourceClassificationUpdate`](crate::model::S3ResourceClassificationUpdate)
    pub fn builder() -> crate::model::s3_resource_classification_update::Builder {
        crate::model::s3_resource_classification_update::Builder::default()
    }
}

/// <p>The classification type that Amazon Macie Classic applies to the associated S3
/// resources. At least one of the classification types (oneTime or continuous) must be specified.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassificationTypeUpdate {
    /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
    /// </p>
    pub one_time: std::option::Option<crate::model::S3OneTimeClassificationType>,
    /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
    /// Amazon Macie Classic begins performing continuous classification after a bucket is
    /// successfully associated with Macie Classic. </p>
    pub continuous: std::option::Option<crate::model::S3ContinuousClassificationType>,
}
impl ClassificationTypeUpdate {
    /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
    /// </p>
    pub fn one_time(&self) -> std::option::Option<&crate::model::S3OneTimeClassificationType> {
        self.one_time.as_ref()
    }
    /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
    /// Amazon Macie Classic begins performing continuous classification after a bucket is
    /// successfully associated with Macie Classic. </p>
    pub fn continuous(&self) -> std::option::Option<&crate::model::S3ContinuousClassificationType> {
        self.continuous.as_ref()
    }
}
impl std::fmt::Debug for ClassificationTypeUpdate {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassificationTypeUpdate");
        formatter.field("one_time", &self.one_time);
        formatter.field("continuous", &self.continuous);
        formatter.finish()
    }
}
/// See [`ClassificationTypeUpdate`](crate::model::ClassificationTypeUpdate)
pub mod classification_type_update {
    /// A builder for [`ClassificationTypeUpdate`](crate::model::ClassificationTypeUpdate)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) one_time: std::option::Option<crate::model::S3OneTimeClassificationType>,
        pub(crate) continuous: std::option::Option<crate::model::S3ContinuousClassificationType>,
    }
    impl Builder {
        /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
        /// </p>
        pub fn one_time(mut self, input: crate::model::S3OneTimeClassificationType) -> Self {
            self.one_time = Some(input);
            self
        }
        /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
        /// </p>
        pub fn set_one_time(
            mut self,
            input: std::option::Option<crate::model::S3OneTimeClassificationType>,
        ) -> Self {
            self.one_time = input;
            self
        }
        /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
        /// Amazon Macie Classic begins performing continuous classification after a bucket is
        /// successfully associated with Macie Classic. </p>
        pub fn continuous(mut self, input: crate::model::S3ContinuousClassificationType) -> Self {
            self.continuous = Some(input);
            self
        }
        /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
        /// Amazon Macie Classic begins performing continuous classification after a bucket is
        /// successfully associated with Macie Classic. </p>
        pub fn set_continuous(
            mut self,
            input: std::option::Option<crate::model::S3ContinuousClassificationType>,
        ) -> Self {
            self.continuous = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassificationTypeUpdate`](crate::model::ClassificationTypeUpdate)
        pub fn build(self) -> crate::model::ClassificationTypeUpdate {
            crate::model::ClassificationTypeUpdate {
                one_time: self.one_time,
                continuous: self.continuous,
            }
        }
    }
}
impl ClassificationTypeUpdate {
    /// Creates a new builder-style object to manufacture [`ClassificationTypeUpdate`](crate::model::ClassificationTypeUpdate)
    pub fn builder() -> crate::model::classification_type_update::Builder {
        crate::model::classification_type_update::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3ContinuousClassificationType {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3ContinuousClassificationType {
    fn from(s: &str) -> Self {
        match s {
            "FULL" => S3ContinuousClassificationType::Full,
            other => S3ContinuousClassificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3ContinuousClassificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3ContinuousClassificationType::from(s))
    }
}
impl S3ContinuousClassificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3ContinuousClassificationType::Full => "FULL",
            S3ContinuousClassificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL"]
    }
}
impl AsRef<str> for S3ContinuousClassificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    std::clone::Clone,
    std::cmp::Eq,
    std::cmp::Ord,
    std::cmp::PartialEq,
    std::cmp::PartialOrd,
    std::fmt::Debug,
    std::hash::Hash,
)]
pub enum S3OneTimeClassificationType {
    #[allow(missing_docs)] // documentation missing in model
    Full,
    #[allow(missing_docs)] // documentation missing in model
    None,
    /// Unknown contains new variants that have been added since this code was generated.
    Unknown(String),
}
impl std::convert::From<&str> for S3OneTimeClassificationType {
    fn from(s: &str) -> Self {
        match s {
            "FULL" => S3OneTimeClassificationType::Full,
            "NONE" => S3OneTimeClassificationType::None,
            other => S3OneTimeClassificationType::Unknown(other.to_owned()),
        }
    }
}
impl std::str::FromStr for S3OneTimeClassificationType {
    type Err = std::convert::Infallible;

    fn from_str(s: &str) -> std::result::Result<Self, Self::Err> {
        Ok(S3OneTimeClassificationType::from(s))
    }
}
impl S3OneTimeClassificationType {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            S3OneTimeClassificationType::Full => "FULL",
            S3OneTimeClassificationType::None => "NONE",
            S3OneTimeClassificationType::Unknown(s) => s.as_ref(),
        }
    }
    /// Returns all the `&str` values of the enum members.
    pub fn values() -> &'static [&'static str] {
        &["FULL", "NONE"]
    }
}
impl AsRef<str> for S3OneTimeClassificationType {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}

/// <p>The S3 resources that you want to associate with Amazon Macie Classic for monitoring
/// and data classification. This data type is used as a request parameter in the
/// AssociateS3Resources action and a response parameter in the ListS3Resources action. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct S3ResourceClassification {
    /// <p>The name of the S3 bucket that you want to associate with Amazon Macie
    /// Classic.</p>
    pub bucket_name: std::option::Option<std::string::String>,
    /// <p>The prefix of the S3 bucket that you want to associate with Amazon Macie
    /// Classic.</p>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>The classification type that you want to specify for the resource associated with
    /// Amazon Macie Classic. </p>
    pub classification_type: std::option::Option<crate::model::ClassificationType>,
}
impl S3ResourceClassification {
    /// <p>The name of the S3 bucket that you want to associate with Amazon Macie
    /// Classic.</p>
    pub fn bucket_name(&self) -> std::option::Option<&str> {
        self.bucket_name.as_deref()
    }
    /// <p>The prefix of the S3 bucket that you want to associate with Amazon Macie
    /// Classic.</p>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>The classification type that you want to specify for the resource associated with
    /// Amazon Macie Classic. </p>
    pub fn classification_type(&self) -> std::option::Option<&crate::model::ClassificationType> {
        self.classification_type.as_ref()
    }
}
impl std::fmt::Debug for S3ResourceClassification {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("S3ResourceClassification");
        formatter.field("bucket_name", &self.bucket_name);
        formatter.field("prefix", &self.prefix);
        formatter.field("classification_type", &self.classification_type);
        formatter.finish()
    }
}
/// See [`S3ResourceClassification`](crate::model::S3ResourceClassification)
pub mod s3_resource_classification {
    /// A builder for [`S3ResourceClassification`](crate::model::S3ResourceClassification)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) bucket_name: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) classification_type: std::option::Option<crate::model::ClassificationType>,
    }
    impl Builder {
        /// <p>The name of the S3 bucket that you want to associate with Amazon Macie
        /// Classic.</p>
        pub fn bucket_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.bucket_name = Some(input.into());
            self
        }
        /// <p>The name of the S3 bucket that you want to associate with Amazon Macie
        /// Classic.</p>
        pub fn set_bucket_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.bucket_name = input;
            self
        }
        /// <p>The prefix of the S3 bucket that you want to associate with Amazon Macie
        /// Classic.</p>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>The prefix of the S3 bucket that you want to associate with Amazon Macie
        /// Classic.</p>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>The classification type that you want to specify for the resource associated with
        /// Amazon Macie Classic. </p>
        pub fn classification_type(mut self, input: crate::model::ClassificationType) -> Self {
            self.classification_type = Some(input);
            self
        }
        /// <p>The classification type that you want to specify for the resource associated with
        /// Amazon Macie Classic. </p>
        pub fn set_classification_type(
            mut self,
            input: std::option::Option<crate::model::ClassificationType>,
        ) -> Self {
            self.classification_type = input;
            self
        }
        /// Consumes the builder and constructs a [`S3ResourceClassification`](crate::model::S3ResourceClassification)
        pub fn build(self) -> crate::model::S3ResourceClassification {
            crate::model::S3ResourceClassification {
                bucket_name: self.bucket_name,
                prefix: self.prefix,
                classification_type: self.classification_type,
            }
        }
    }
}
impl S3ResourceClassification {
    /// Creates a new builder-style object to manufacture [`S3ResourceClassification`](crate::model::S3ResourceClassification)
    pub fn builder() -> crate::model::s3_resource_classification::Builder {
        crate::model::s3_resource_classification::Builder::default()
    }
}

/// <p>The classification type that Amazon Macie Classic applies to the associated S3
/// resources. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ClassificationType {
    /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
    /// </p>
    pub one_time: std::option::Option<crate::model::S3OneTimeClassificationType>,
    /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
    /// Amazon Macie Classic begins performing continuous classification after a bucket is
    /// successfully associated with Macie Classic. </p>
    pub continuous: std::option::Option<crate::model::S3ContinuousClassificationType>,
}
impl ClassificationType {
    /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
    /// </p>
    pub fn one_time(&self) -> std::option::Option<&crate::model::S3OneTimeClassificationType> {
        self.one_time.as_ref()
    }
    /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
    /// Amazon Macie Classic begins performing continuous classification after a bucket is
    /// successfully associated with Macie Classic. </p>
    pub fn continuous(&self) -> std::option::Option<&crate::model::S3ContinuousClassificationType> {
        self.continuous.as_ref()
    }
}
impl std::fmt::Debug for ClassificationType {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ClassificationType");
        formatter.field("one_time", &self.one_time);
        formatter.field("continuous", &self.continuous);
        formatter.finish()
    }
}
/// See [`ClassificationType`](crate::model::ClassificationType)
pub mod classification_type {
    /// A builder for [`ClassificationType`](crate::model::ClassificationType)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) one_time: std::option::Option<crate::model::S3OneTimeClassificationType>,
        pub(crate) continuous: std::option::Option<crate::model::S3ContinuousClassificationType>,
    }
    impl Builder {
        /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
        /// </p>
        pub fn one_time(mut self, input: crate::model::S3OneTimeClassificationType) -> Self {
            self.one_time = Some(input);
            self
        }
        /// <p>A one-time classification of all of the existing objects in a specified S3 bucket.
        /// </p>
        pub fn set_one_time(
            mut self,
            input: std::option::Option<crate::model::S3OneTimeClassificationType>,
        ) -> Self {
            self.one_time = input;
            self
        }
        /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
        /// Amazon Macie Classic begins performing continuous classification after a bucket is
        /// successfully associated with Macie Classic. </p>
        pub fn continuous(mut self, input: crate::model::S3ContinuousClassificationType) -> Self {
            self.continuous = Some(input);
            self
        }
        /// <p>A continuous classification of the objects that are added to a specified S3 bucket.
        /// Amazon Macie Classic begins performing continuous classification after a bucket is
        /// successfully associated with Macie Classic. </p>
        pub fn set_continuous(
            mut self,
            input: std::option::Option<crate::model::S3ContinuousClassificationType>,
        ) -> Self {
            self.continuous = input;
            self
        }
        /// Consumes the builder and constructs a [`ClassificationType`](crate::model::ClassificationType)
        pub fn build(self) -> crate::model::ClassificationType {
            crate::model::ClassificationType {
                one_time: self.one_time,
                continuous: self.continuous,
            }
        }
    }
}
impl ClassificationType {
    /// Creates a new builder-style object to manufacture [`ClassificationType`](crate::model::ClassificationType)
    pub fn builder() -> crate::model::classification_type::Builder {
        crate::model::classification_type::Builder::default()
    }
}

/// <p>Contains information about the Amazon Macie Classic member account.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct MemberAccount {
    /// <p>The AWS account ID of the Amazon Macie Classic member account.</p>
    pub account_id: std::option::Option<std::string::String>,
}
impl MemberAccount {
    /// <p>The AWS account ID of the Amazon Macie Classic member account.</p>
    pub fn account_id(&self) -> std::option::Option<&str> {
        self.account_id.as_deref()
    }
}
impl std::fmt::Debug for MemberAccount {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("MemberAccount");
        formatter.field("account_id", &self.account_id);
        formatter.finish()
    }
}
/// See [`MemberAccount`](crate::model::MemberAccount)
pub mod member_account {
    /// A builder for [`MemberAccount`](crate::model::MemberAccount)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) account_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The AWS account ID of the Amazon Macie Classic member account.</p>
        pub fn account_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.account_id = Some(input.into());
            self
        }
        /// <p>The AWS account ID of the Amazon Macie Classic member account.</p>
        pub fn set_account_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.account_id = input;
            self
        }
        /// Consumes the builder and constructs a [`MemberAccount`](crate::model::MemberAccount)
        pub fn build(self) -> crate::model::MemberAccount {
            crate::model::MemberAccount {
                account_id: self.account_id,
            }
        }
    }
}
impl MemberAccount {
    /// Creates a new builder-style object to manufacture [`MemberAccount`](crate::model::MemberAccount)
    pub fn builder() -> crate::model::member_account::Builder {
        crate::model::member_account::Builder::default()
    }
}
