// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::AddTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::AddTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::InvalidTagException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tag_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "TagLimitExceededException" => crate::error::AddTagsError {
            meta: generic,
            kind: crate::error::AddTagsErrorKind::TagLimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::tag_limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_tag_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::AddTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::AddTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_add_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::AddTagsOutput, crate::error::AddTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::add_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_add_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::AddTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_batch_prediction_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBatchPredictionOutput,
    crate::error::CreateBatchPredictionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateBatchPredictionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateBatchPredictionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => crate::error::CreateBatchPredictionError {
            meta: generic,
            kind:
                crate::error::CreateBatchPredictionErrorKind::IdempotentParameterMismatchException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBatchPredictionError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServerException" => crate::error::CreateBatchPredictionError {
            meta: generic,
            kind: crate::error::CreateBatchPredictionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateBatchPredictionError {
            meta: generic,
            kind: crate::error::CreateBatchPredictionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateBatchPredictionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_batch_prediction_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateBatchPredictionOutput,
    crate::error::CreateBatchPredictionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_batch_prediction_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_batch_prediction(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateBatchPredictionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_source_from_rds_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataSourceFromRdsOutput,
    crate::error::CreateDataSourceFromRDSError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDataSourceFromRDSError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDataSourceFromRDSError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => crate::error::CreateDataSourceFromRDSError {
            meta: generic,
            kind:
                crate::error::CreateDataSourceFromRDSErrorKind::IdempotentParameterMismatchException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromRDSError::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServerException" => crate::error::CreateDataSourceFromRDSError {
            meta: generic,
            kind: crate::error::CreateDataSourceFromRDSErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromRDSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDataSourceFromRDSError {
            meta: generic,
            kind: crate::error::CreateDataSourceFromRDSErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromRDSError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDataSourceFromRDSError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_source_from_rds_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataSourceFromRdsOutput,
    crate::error::CreateDataSourceFromRDSError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_data_source_from_rds_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_data_source_from_rds(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDataSourceFromRDSError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_source_from_redshift_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataSourceFromRedshiftOutput,
    crate::error::CreateDataSourceFromRedshiftError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDataSourceFromRedshiftError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDataSourceFromRedshiftError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => crate::error::CreateDataSourceFromRedshiftError { meta: generic, kind: crate::error::CreateDataSourceFromRedshiftErrorKind::IdempotentParameterMismatchException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromRedshiftError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InternalServerException" => crate::error::CreateDataSourceFromRedshiftError { meta: generic, kind: crate::error::CreateDataSourceFromRedshiftErrorKind::InternalServerException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromRedshiftError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        "InvalidInputException" => crate::error::CreateDataSourceFromRedshiftError { meta: generic, kind: crate::error::CreateDataSourceFromRedshiftErrorKind::InvalidInputException({
            #[allow(unused_mut)]let mut tmp =
                 {
                    #[allow(unused_mut)]let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromRedshiftError::unhandled)?;
                    output.build()
                }
            ;
            if (&tmp.message).is_none() {
                                                        tmp.message = _error_message;
                                                    }
            tmp
        })},
        _ => crate::error::CreateDataSourceFromRedshiftError::generic(generic)
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_source_from_redshift_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataSourceFromRedshiftOutput,
    crate::error::CreateDataSourceFromRedshiftError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_data_source_from_redshift_output::Builder::default();
        let _ = response;
        output =
            crate::json_deser::deser_operation_crate_operation_create_data_source_from_redshift(
                response.body().as_ref(),
                output,
            )
            .map_err(crate::error::CreateDataSourceFromRedshiftError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_source_from_s3_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataSourceFromS3Output,
    crate::error::CreateDataSourceFromS3Error,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateDataSourceFromS3Error::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateDataSourceFromS3Error::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => crate::error::CreateDataSourceFromS3Error {
            meta: generic,
            kind:
                crate::error::CreateDataSourceFromS3ErrorKind::IdempotentParameterMismatchException(
                    {
                        #[allow(unused_mut)]
                        let mut tmp = {
                            #[allow(unused_mut)]let mut output = crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                            let _ = response;
                            output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromS3Error::unhandled)?;
                            output.build()
                        };
                        if (&tmp.message).is_none() {
                            tmp.message = _error_message;
                        }
                        tmp
                    },
                ),
        },
        "InternalServerException" => crate::error::CreateDataSourceFromS3Error {
            meta: generic,
            kind: crate::error::CreateDataSourceFromS3ErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateDataSourceFromS3Error {
            meta: generic,
            kind: crate::error::CreateDataSourceFromS3ErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateDataSourceFromS3Error::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateDataSourceFromS3Error::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_data_source_from_s3_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateDataSourceFromS3Output,
    crate::error::CreateDataSourceFromS3Error,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_data_source_from_s3_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_data_source_from_s3(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateDataSourceFromS3Error::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_evaluation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEvaluationOutput, crate::error::CreateEvaluationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateEvaluationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateEvaluationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => crate::error::CreateEvaluationError {
            meta: generic,
            kind: crate::error::CreateEvaluationErrorKind::IdempotentParameterMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::CreateEvaluationError {
            meta: generic,
            kind: crate::error::CreateEvaluationErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateEvaluationError {
            meta: generic,
            kind: crate::error::CreateEvaluationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateEvaluationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_evaluation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateEvaluationOutput, crate::error::CreateEvaluationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_evaluation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_evaluation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateEvaluationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ml_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateMlModelOutput, crate::error::CreateMLModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateMLModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::CreateMLModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "IdempotentParameterMismatchException" => crate::error::CreateMLModelError {
            meta: generic,
            kind: crate::error::CreateMLModelErrorKind::IdempotentParameterMismatchException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::idempotent_parameter_mismatch_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_idempotent_parameter_mismatch_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InternalServerException" => crate::error::CreateMLModelError {
            meta: generic,
            kind: crate::error::CreateMLModelErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateMLModelError {
            meta: generic,
            kind: crate::error::CreateMLModelErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateMLModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_ml_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::CreateMlModelOutput, crate::error::CreateMLModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_ml_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_ml_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateMLModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_realtime_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRealtimeEndpointOutput,
    crate::error::CreateRealtimeEndpointError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::CreateRealtimeEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::CreateRealtimeEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::CreateRealtimeEndpointError {
            meta: generic,
            kind: crate::error::CreateRealtimeEndpointErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRealtimeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::CreateRealtimeEndpointError {
            meta: generic,
            kind: crate::error::CreateRealtimeEndpointErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRealtimeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::CreateRealtimeEndpointError {
            meta: generic,
            kind: crate::error::CreateRealtimeEndpointErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::CreateRealtimeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::CreateRealtimeEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_create_realtime_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::CreateRealtimeEndpointOutput,
    crate::error::CreateRealtimeEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::create_realtime_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_create_realtime_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::CreateRealtimeEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_batch_prediction_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBatchPredictionOutput,
    crate::error::DeleteBatchPredictionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteBatchPredictionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteBatchPredictionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteBatchPredictionError {
            meta: generic,
            kind: crate::error::DeleteBatchPredictionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteBatchPredictionError {
            meta: generic,
            kind: crate::error::DeleteBatchPredictionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteBatchPredictionError {
            meta: generic,
            kind: crate::error::DeleteBatchPredictionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteBatchPredictionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_batch_prediction_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteBatchPredictionOutput,
    crate::error::DeleteBatchPredictionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_batch_prediction_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_batch_prediction(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteBatchPredictionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_data_source_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDataSourceOutput, crate::error::DeleteDataSourceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteDataSourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteDataSourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteDataSourceError {
            meta: generic,
            kind: crate::error::DeleteDataSourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteDataSourceError {
            meta: generic,
            kind: crate::error::DeleteDataSourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteDataSourceError {
            meta: generic,
            kind: crate::error::DeleteDataSourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteDataSourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_data_source_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteDataSourceOutput, crate::error::DeleteDataSourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_data_source_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_data_source(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteDataSourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_evaluation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEvaluationOutput, crate::error::DeleteEvaluationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteEvaluationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteEvaluationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteEvaluationError {
            meta: generic,
            kind: crate::error::DeleteEvaluationErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteEvaluationError {
            meta: generic,
            kind: crate::error::DeleteEvaluationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteEvaluationError {
            meta: generic,
            kind: crate::error::DeleteEvaluationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteEvaluationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_evaluation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteEvaluationOutput, crate::error::DeleteEvaluationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_evaluation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_evaluation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteEvaluationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ml_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteMlModelOutput, crate::error::DeleteMLModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteMLModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteMLModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteMLModelError {
            meta: generic,
            kind: crate::error::DeleteMLModelErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteMLModelError {
            meta: generic,
            kind: crate::error::DeleteMLModelErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteMLModelError {
            meta: generic,
            kind: crate::error::DeleteMLModelErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteMLModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_ml_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteMlModelOutput, crate::error::DeleteMLModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_ml_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_ml_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteMLModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_realtime_endpoint_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRealtimeEndpointOutput,
    crate::error::DeleteRealtimeEndpointError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteRealtimeEndpointError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DeleteRealtimeEndpointError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteRealtimeEndpointError {
            meta: generic,
            kind: crate::error::DeleteRealtimeEndpointErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRealtimeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteRealtimeEndpointError {
            meta: generic,
            kind: crate::error::DeleteRealtimeEndpointErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRealtimeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteRealtimeEndpointError {
            meta: generic,
            kind: crate::error::DeleteRealtimeEndpointErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteRealtimeEndpointError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteRealtimeEndpointError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_realtime_endpoint_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DeleteRealtimeEndpointOutput,
    crate::error::DeleteRealtimeEndpointError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_realtime_endpoint_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_realtime_endpoint(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteRealtimeEndpointError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DeleteTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DeleteTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidTagException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::InvalidTagException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_tag_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_tag_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DeleteTagsError {
            meta: generic,
            kind: crate::error::DeleteTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DeleteTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DeleteTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_delete_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DeleteTagsOutput, crate::error::DeleteTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::delete_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_delete_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DeleteTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_batch_predictions_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBatchPredictionsOutput,
    crate::error::DescribeBatchPredictionsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeBatchPredictionsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => {
            return Err(crate::error::DescribeBatchPredictionsError::unhandled(
                generic,
            ))
        }
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeBatchPredictionsError {
            meta: generic,
            kind: crate::error::DescribeBatchPredictionsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBatchPredictionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeBatchPredictionsError {
            meta: generic,
            kind: crate::error::DescribeBatchPredictionsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeBatchPredictionsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeBatchPredictionsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_batch_predictions_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeBatchPredictionsOutput,
    crate::error::DescribeBatchPredictionsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_batch_predictions_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_batch_predictions(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeBatchPredictionsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_sources_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSourcesOutput,
    crate::error::DescribeDataSourcesError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeDataSourcesError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeDataSourcesError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeDataSourcesError {
            meta: generic,
            kind: crate::error::DescribeDataSourcesErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataSourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeDataSourcesError {
            meta: generic,
            kind: crate::error::DescribeDataSourcesErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeDataSourcesError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeDataSourcesError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_data_sources_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeDataSourcesOutput,
    crate::error::DescribeDataSourcesError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_data_sources_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_data_sources(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeDataSourcesError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_evaluations_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEvaluationsOutput,
    crate::error::DescribeEvaluationsError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeEvaluationsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeEvaluationsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeEvaluationsError {
            meta: generic,
            kind: crate::error::DescribeEvaluationsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEvaluationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeEvaluationsError {
            meta: generic,
            kind: crate::error::DescribeEvaluationsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeEvaluationsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeEvaluationsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_evaluations_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::DescribeEvaluationsOutput,
    crate::error::DescribeEvaluationsError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_evaluations_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_evaluations(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeEvaluationsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ml_models_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeMlModelsOutput, crate::error::DescribeMLModelsError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeMLModelsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeMLModelsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeMLModelsError {
            meta: generic,
            kind: crate::error::DescribeMLModelsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMLModelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeMLModelsError {
            meta: generic,
            kind: crate::error::DescribeMLModelsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeMLModelsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeMLModelsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_ml_models_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeMlModelsOutput, crate::error::DescribeMLModelsError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_ml_models_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_ml_models(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeMLModelsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::DescribeTagsError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::DescribeTagsError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::DescribeTagsError {
            meta: generic,
            kind: crate::error::DescribeTagsErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::DescribeTagsError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::DescribeTagsError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_describe_tags_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::DescribeTagsOutput, crate::error::DescribeTagsError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::describe_tags_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_describe_tags(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::DescribeTagsError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_batch_prediction_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBatchPredictionOutput,
    crate::error::GetBatchPredictionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetBatchPredictionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetBatchPredictionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::GetBatchPredictionError {
            meta: generic,
            kind: crate::error::GetBatchPredictionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetBatchPredictionError {
            meta: generic,
            kind: crate::error::GetBatchPredictionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetBatchPredictionError {
            meta: generic,
            kind: crate::error::GetBatchPredictionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetBatchPredictionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_batch_prediction_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::GetBatchPredictionOutput,
    crate::error::GetBatchPredictionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_batch_prediction_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_batch_prediction(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetBatchPredictionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_data_source_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDataSourceOutput, crate::error::GetDataSourceError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetDataSourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetDataSourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::GetDataSourceError {
            meta: generic,
            kind: crate::error::GetDataSourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetDataSourceError {
            meta: generic,
            kind: crate::error::GetDataSourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetDataSourceError {
            meta: generic,
            kind: crate::error::GetDataSourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetDataSourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_data_source_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetDataSourceOutput, crate::error::GetDataSourceError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_data_source_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_data_source(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetDataSourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_evaluation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetEvaluationOutput, crate::error::GetEvaluationError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetEvaluationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetEvaluationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::GetEvaluationError {
            meta: generic,
            kind: crate::error::GetEvaluationErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetEvaluationError {
            meta: generic,
            kind: crate::error::GetEvaluationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetEvaluationError {
            meta: generic,
            kind: crate::error::GetEvaluationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetEvaluationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_evaluation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetEvaluationOutput, crate::error::GetEvaluationError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_evaluation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_evaluation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetEvaluationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ml_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetMlModelOutput, crate::error::GetMLModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::GetMLModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::GetMLModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::GetMLModelError {
            meta: generic,
            kind: crate::error::GetMLModelErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::GetMLModelError {
            meta: generic,
            kind: crate::error::GetMLModelErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::GetMLModelError {
            meta: generic,
            kind: crate::error::GetMLModelErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::GetMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::GetMLModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_get_ml_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::GetMlModelOutput, crate::error::GetMLModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::get_ml_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_get_ml_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::GetMLModelError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_predict_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PredictOutput, crate::error::PredictError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::PredictError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::PredictError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::PredictError {
            meta: generic,
            kind: crate::error::PredictErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PredictError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::PredictError {
            meta: generic,
            kind: crate::error::PredictErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PredictError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "LimitExceededException" => crate::error::PredictError {
            meta: generic,
            kind: crate::error::PredictErrorKind::LimitExceededException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::limit_exceeded_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_limit_exceeded_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PredictError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "PredictorNotMountedException" => crate::error::PredictError {
            meta: generic,
            kind: crate::error::PredictErrorKind::PredictorNotMountedException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output =
                        crate::error::predictor_not_mounted_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_predictor_not_mounted_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PredictError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::PredictError {
            meta: generic,
            kind: crate::error::PredictErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::PredictError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::PredictError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_predict_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::PredictOutput, crate::error::PredictError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::predict_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_predict(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::PredictError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_batch_prediction_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBatchPredictionOutput,
    crate::error::UpdateBatchPredictionError,
> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateBatchPredictionError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateBatchPredictionError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::UpdateBatchPredictionError {
            meta: generic,
            kind: crate::error::UpdateBatchPredictionErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::UpdateBatchPredictionError {
            meta: generic,
            kind: crate::error::UpdateBatchPredictionErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateBatchPredictionError {
            meta: generic,
            kind: crate::error::UpdateBatchPredictionErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateBatchPredictionError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateBatchPredictionError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_batch_prediction_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<
    crate::output::UpdateBatchPredictionOutput,
    crate::error::UpdateBatchPredictionError,
> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_batch_prediction_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_batch_prediction(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateBatchPredictionError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_data_source_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDataSourceOutput, crate::error::UpdateDataSourceError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateDataSourceError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateDataSourceError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::UpdateDataSourceError {
            meta: generic,
            kind: crate::error::UpdateDataSourceErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::UpdateDataSourceError {
            meta: generic,
            kind: crate::error::UpdateDataSourceErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateDataSourceError {
            meta: generic,
            kind: crate::error::UpdateDataSourceErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateDataSourceError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateDataSourceError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_data_source_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateDataSourceOutput, crate::error::UpdateDataSourceError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_data_source_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_data_source(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateDataSourceError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_evaluation_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEvaluationOutput, crate::error::UpdateEvaluationError>
{
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateEvaluationError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateEvaluationError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::UpdateEvaluationError {
            meta: generic,
            kind: crate::error::UpdateEvaluationErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::UpdateEvaluationError {
            meta: generic,
            kind: crate::error::UpdateEvaluationErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateEvaluationError {
            meta: generic,
            kind: crate::error::UpdateEvaluationErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateEvaluationError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateEvaluationError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_evaluation_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateEvaluationOutput, crate::error::UpdateEvaluationError>
{
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_evaluation_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_evaluation(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateEvaluationError::unhandled)?;
        output.build()
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ml_model_error(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateMlModelOutput, crate::error::UpdateMLModelError> {
    let generic = crate::json_deser::parse_http_generic_error(response)
        .map_err(crate::error::UpdateMLModelError::unhandled)?;
    let error_code = match generic.code() {
        Some(code) => code,
        None => return Err(crate::error::UpdateMLModelError::unhandled(generic)),
    };

    let _error_message = generic.message().map(|msg| msg.to_owned());
    Err(match error_code {
        "InternalServerException" => crate::error::UpdateMLModelError {
            meta: generic,
            kind: crate::error::UpdateMLModelErrorKind::InternalServerException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::internal_server_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_internal_server_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "InvalidInputException" => crate::error::UpdateMLModelError {
            meta: generic,
            kind: crate::error::UpdateMLModelErrorKind::InvalidInputException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::invalid_input_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_invalid_input_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        "ResourceNotFoundException" => crate::error::UpdateMLModelError {
            meta: generic,
            kind: crate::error::UpdateMLModelErrorKind::ResourceNotFoundException({
                #[allow(unused_mut)]
                let mut tmp = {
                    #[allow(unused_mut)]
                    let mut output = crate::error::resource_not_found_exception::Builder::default();
                    let _ = response;
                    output = crate::json_deser::deser_structure_crate_error_resource_not_found_exception_json_err(response.body().as_ref(), output).map_err(crate::error::UpdateMLModelError::unhandled)?;
                    output.build()
                };
                if (&tmp.message).is_none() {
                    tmp.message = _error_message;
                }
                tmp
            }),
        },
        _ => crate::error::UpdateMLModelError::generic(generic),
    })
}

#[allow(clippy::unnecessary_wraps)]
pub fn parse_update_ml_model_response(
    response: &http::Response<bytes::Bytes>,
) -> std::result::Result<crate::output::UpdateMlModelOutput, crate::error::UpdateMLModelError> {
    Ok({
        #[allow(unused_mut)]
        let mut output = crate::output::update_ml_model_output::Builder::default();
        let _ = response;
        output = crate::json_deser::deser_operation_crate_operation_update_ml_model(
            response.body().as_ref(),
            output,
        )
        .map_err(crate::error::UpdateMLModelError::unhandled)?;
        output.build()
    })
}
