// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct AddTagsError {
    /// Kind of error that occurred.
    pub kind: AddTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `AddTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum AddTagsErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    #[allow(missing_docs)] // documentation missing in model
    TagLimitExceededException(crate::error::TagLimitExceededException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for AddTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            AddTagsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::TagLimitExceededException(_inner) => _inner.fmt(f),
            AddTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for AddTagsError {
    fn code(&self) -> Option<&str> {
        AddTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl AddTagsError {
    /// Creates a new `AddTagsError`.
    pub fn new(kind: AddTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `AddTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: AddTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `AddTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: AddTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::InvalidTagException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::ResourceNotFoundException(_))
    }
    /// Returns `true` if the error kind is `AddTagsErrorKind::TagLimitExceededException`.
    pub fn is_tag_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, AddTagsErrorKind::TagLimitExceededException(_))
    }
}
impl std::error::Error for AddTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            AddTagsErrorKind::InternalServerException(_inner) => Some(_inner),
            AddTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            AddTagsErrorKind::InvalidTagException(_inner) => Some(_inner),
            AddTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            AddTagsErrorKind::TagLimitExceededException(_inner) => Some(_inner),
            AddTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateBatchPredictionError {
    /// Kind of error that occurred.
    pub kind: CreateBatchPredictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateBatchPredictionErrorKind {
    /// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateBatchPredictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateBatchPredictionErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateBatchPredictionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateBatchPredictionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateBatchPredictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateBatchPredictionError {
    fn code(&self) -> Option<&str> {
        CreateBatchPredictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateBatchPredictionError {
    /// Creates a new `CreateBatchPredictionError`.
    pub fn new(kind: CreateBatchPredictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateBatchPredictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateBatchPredictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateBatchPredictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateBatchPredictionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateBatchPredictionErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchPredictionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateBatchPredictionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateBatchPredictionErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for CreateBatchPredictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateBatchPredictionErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateBatchPredictionErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateBatchPredictionErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateBatchPredictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSourceFromRDS` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSourceFromRDSError {
    /// Kind of error that occurred.
    pub kind: CreateDataSourceFromRDSErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSourceFromRDS` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSourceFromRDSErrorKind {
    /// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSourceFromRDSError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSourceFromRDSErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateDataSourceFromRDSErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataSourceFromRDSErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDataSourceFromRDSErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSourceFromRDSError {
    fn code(&self) -> Option<&str> {
        CreateDataSourceFromRDSError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSourceFromRDSError {
    /// Creates a new `CreateDataSourceFromRDSError`.
    pub fn new(kind: CreateDataSourceFromRDSErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSourceFromRDSError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSourceFromRDSErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSourceFromRDSError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSourceFromRDSErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromRDSErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromRDSErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromRDSErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromRDSErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromRDSErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromRDSErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for CreateDataSourceFromRDSError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSourceFromRDSErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateDataSourceFromRDSErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataSourceFromRDSErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDataSourceFromRDSErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSourceFromRedshift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSourceFromRedshiftError {
    /// Kind of error that occurred.
    pub kind: CreateDataSourceFromRedshiftErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSourceFromRedshift` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSourceFromRedshiftErrorKind {
    /// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSourceFromRedshiftError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSourceFromRedshiftErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateDataSourceFromRedshiftErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataSourceFromRedshiftErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDataSourceFromRedshiftErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSourceFromRedshiftError {
    fn code(&self) -> Option<&str> {
        CreateDataSourceFromRedshiftError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSourceFromRedshiftError {
    /// Creates a new `CreateDataSourceFromRedshiftError`.
    pub fn new(kind: CreateDataSourceFromRedshiftErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSourceFromRedshiftError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSourceFromRedshiftErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSourceFromRedshiftError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSourceFromRedshiftErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromRedshiftErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromRedshiftErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromRedshiftErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromRedshiftErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromRedshiftErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromRedshiftErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for CreateDataSourceFromRedshiftError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSourceFromRedshiftErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateDataSourceFromRedshiftErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataSourceFromRedshiftErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDataSourceFromRedshiftErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateDataSourceFromS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDataSourceFromS3Error {
    /// Kind of error that occurred.
    pub kind: CreateDataSourceFromS3ErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataSourceFromS3` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDataSourceFromS3ErrorKind {
    /// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDataSourceFromS3Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDataSourceFromS3ErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateDataSourceFromS3ErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDataSourceFromS3ErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateDataSourceFromS3ErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDataSourceFromS3Error {
    fn code(&self) -> Option<&str> {
        CreateDataSourceFromS3Error::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDataSourceFromS3Error {
    /// Creates a new `CreateDataSourceFromS3Error`.
    pub fn new(kind: CreateDataSourceFromS3ErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDataSourceFromS3Error::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDataSourceFromS3ErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDataSourceFromS3Error::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDataSourceFromS3ErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromS3ErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromS3ErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromS3ErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromS3ErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateDataSourceFromS3ErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDataSourceFromS3ErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for CreateDataSourceFromS3Error {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDataSourceFromS3ErrorKind::IdempotentParameterMismatchException(_inner) => {
                Some(_inner)
            }
            CreateDataSourceFromS3ErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDataSourceFromS3ErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateDataSourceFromS3ErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateEvaluationError {
    /// Kind of error that occurred.
    pub kind: CreateEvaluationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateEvaluationErrorKind {
    /// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateEvaluationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateEvaluationErrorKind::IdempotentParameterMismatchException(_inner) => {
                _inner.fmt(f)
            }
            CreateEvaluationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateEvaluationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateEvaluationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateEvaluationError {
    fn code(&self) -> Option<&str> {
        CreateEvaluationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateEvaluationError {
    /// Creates a new `CreateEvaluationError`.
    pub fn new(kind: CreateEvaluationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateEvaluationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateEvaluationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateEvaluationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateEvaluationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateEvaluationErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEvaluationErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEvaluationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEvaluationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateEvaluationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateEvaluationErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for CreateEvaluationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateEvaluationErrorKind::IdempotentParameterMismatchException(_inner) => Some(_inner),
            CreateEvaluationErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateEvaluationErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateEvaluationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateMLModelError {
    /// Kind of error that occurred.
    pub kind: CreateMLModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateMLModelErrorKind {
    /// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
    IdempotentParameterMismatchException(crate::error::IdempotentParameterMismatchException),
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateMLModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateMLModelErrorKind::IdempotentParameterMismatchException(_inner) => _inner.fmt(f),
            CreateMLModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateMLModelErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateMLModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateMLModelError {
    fn code(&self) -> Option<&str> {
        CreateMLModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateMLModelError {
    /// Creates a new `CreateMLModelError`.
    pub fn new(kind: CreateMLModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateMLModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateMLModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateMLModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateMLModelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateMLModelErrorKind::IdempotentParameterMismatchException`.
    pub fn is_idempotent_parameter_mismatch_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLModelErrorKind::IdempotentParameterMismatchException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateMLModelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateMLModelErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, CreateMLModelErrorKind::InvalidInputException(_))
    }
}
impl std::error::Error for CreateMLModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateMLModelErrorKind::IdempotentParameterMismatchException(_inner) => Some(_inner),
            CreateMLModelErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateMLModelErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateMLModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateRealtimeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateRealtimeEndpointError {
    /// Kind of error that occurred.
    pub kind: CreateRealtimeEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateRealtimeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateRealtimeEndpointErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateRealtimeEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateRealtimeEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateRealtimeEndpointErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            CreateRealtimeEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateRealtimeEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateRealtimeEndpointError {
    fn code(&self) -> Option<&str> {
        CreateRealtimeEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateRealtimeEndpointError {
    /// Creates a new `CreateRealtimeEndpointError`.
    pub fn new(kind: CreateRealtimeEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateRealtimeEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateRealtimeEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateRealtimeEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateRealtimeEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `CreateRealtimeEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRealtimeEndpointErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeEndpointErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `CreateRealtimeEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateRealtimeEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for CreateRealtimeEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateRealtimeEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateRealtimeEndpointErrorKind::InvalidInputException(_inner) => Some(_inner),
            CreateRealtimeEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateRealtimeEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteBatchPredictionError {
    /// Kind of error that occurred.
    pub kind: DeleteBatchPredictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteBatchPredictionErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteBatchPredictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteBatchPredictionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteBatchPredictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteBatchPredictionError {
    fn code(&self) -> Option<&str> {
        DeleteBatchPredictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteBatchPredictionError {
    /// Creates a new `DeleteBatchPredictionError`.
    pub fn new(kind: DeleteBatchPredictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteBatchPredictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteBatchPredictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteBatchPredictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteBatchPredictionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteBatchPredictionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBatchPredictionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteBatchPredictionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteBatchPredictionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteBatchPredictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteBatchPredictionErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteBatchPredictionErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteBatchPredictionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteBatchPredictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDataSourceError {
    /// Kind of error that occurred.
    pub kind: DeleteDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDataSourceErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDataSourceError {
    fn code(&self) -> Option<&str> {
        DeleteDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDataSourceError {
    /// Creates a new `DeleteDataSourceError`.
    pub fn new(kind: DeleteDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteEvaluationError {
    /// Kind of error that occurred.
    pub kind: DeleteEvaluationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteEvaluationErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteEvaluationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteEvaluationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteEvaluationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteEvaluationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteEvaluationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteEvaluationError {
    fn code(&self) -> Option<&str> {
        DeleteEvaluationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteEvaluationError {
    /// Creates a new `DeleteEvaluationError`.
    pub fn new(kind: DeleteEvaluationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteEvaluationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteEvaluationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteEvaluationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteEvaluationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteEvaluationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEvaluationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEvaluationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEvaluationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteEvaluationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteEvaluationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteEvaluationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteEvaluationErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteEvaluationErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteEvaluationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteEvaluationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteMLModelError {
    /// Kind of error that occurred.
    pub kind: DeleteMLModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteMLModelErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteMLModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteMLModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteMLModelErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteMLModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteMLModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteMLModelError {
    fn code(&self) -> Option<&str> {
        DeleteMLModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteMLModelError {
    /// Creates a new `DeleteMLModelError`.
    pub fn new(kind: DeleteMLModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteMLModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteMLModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteMLModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteMLModelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteMLModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMLModelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteMLModelErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteMLModelErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteMLModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteMLModelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteMLModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteMLModelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteMLModelErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteMLModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteMLModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteRealtimeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteRealtimeEndpointError {
    /// Kind of error that occurred.
    pub kind: DeleteRealtimeEndpointErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteRealtimeEndpoint` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteRealtimeEndpointErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteRealtimeEndpointError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteRealtimeEndpointErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteRealtimeEndpointErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteRealtimeEndpointErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteRealtimeEndpointErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteRealtimeEndpointError {
    fn code(&self) -> Option<&str> {
        DeleteRealtimeEndpointError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteRealtimeEndpointError {
    /// Creates a new `DeleteRealtimeEndpointError`.
    pub fn new(kind: DeleteRealtimeEndpointErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteRealtimeEndpointError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteRealtimeEndpointErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteRealtimeEndpointError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteRealtimeEndpointErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteRealtimeEndpointErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeEndpointErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRealtimeEndpointErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeEndpointErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `DeleteRealtimeEndpointErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteRealtimeEndpointErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteRealtimeEndpointError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteRealtimeEndpointErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteRealtimeEndpointErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteRealtimeEndpointErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteRealtimeEndpointErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteTagsError {
    /// Kind of error that occurred.
    pub kind: DeleteTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteTagsErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    #[allow(missing_docs)] // documentation missing in model
    InvalidTagException(crate::error::InvalidTagException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteTagsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::InvalidTagException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteTagsError {
    fn code(&self) -> Option<&str> {
        DeleteTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteTagsError {
    /// Creates a new `DeleteTagsError`.
    pub fn new(kind: DeleteTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::InvalidTagException`.
    pub fn is_invalid_tag_exception(&self) -> bool {
        matches!(&self.kind, DeleteTagsErrorKind::InvalidTagException(_))
    }
    /// Returns `true` if the error kind is `DeleteTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteTagsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DeleteTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteTagsErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DeleteTagsErrorKind::InvalidTagException(_inner) => Some(_inner),
            DeleteTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeBatchPredictions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeBatchPredictionsError {
    /// Kind of error that occurred.
    pub kind: DescribeBatchPredictionsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeBatchPredictions` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeBatchPredictionsErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeBatchPredictionsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeBatchPredictionsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeBatchPredictionsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeBatchPredictionsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeBatchPredictionsError {
    fn code(&self) -> Option<&str> {
        DescribeBatchPredictionsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeBatchPredictionsError {
    /// Creates a new `DescribeBatchPredictionsError`.
    pub fn new(kind: DescribeBatchPredictionsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeBatchPredictionsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeBatchPredictionsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeBatchPredictionsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeBatchPredictionsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeBatchPredictionsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBatchPredictionsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeBatchPredictionsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeBatchPredictionsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeBatchPredictionsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeBatchPredictionsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeBatchPredictionsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeBatchPredictionsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDataSourcesError {
    /// Kind of error that occurred.
    pub kind: DescribeDataSourcesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataSources` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDataSourcesErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDataSourcesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDataSourcesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDataSourcesErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeDataSourcesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDataSourcesError {
    fn code(&self) -> Option<&str> {
        DescribeDataSourcesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDataSourcesError {
    /// Creates a new `DescribeDataSourcesError`.
    pub fn new(kind: DescribeDataSourcesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDataSourcesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDataSourcesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDataSourcesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDataSourcesErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeDataSourcesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcesErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeDataSourcesErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDataSourcesErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeDataSourcesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDataSourcesErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDataSourcesErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeDataSourcesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeEvaluations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeEvaluationsError {
    /// Kind of error that occurred.
    pub kind: DescribeEvaluationsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeEvaluations` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeEvaluationsErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeEvaluationsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeEvaluationsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeEvaluationsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeEvaluationsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeEvaluationsError {
    fn code(&self) -> Option<&str> {
        DescribeEvaluationsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeEvaluationsError {
    /// Creates a new `DescribeEvaluationsError`.
    pub fn new(kind: DescribeEvaluationsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeEvaluationsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeEvaluationsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeEvaluationsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeEvaluationsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeEvaluationsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEvaluationsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeEvaluationsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeEvaluationsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeEvaluationsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeEvaluationsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeEvaluationsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeEvaluationsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeMLModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeMLModelsError {
    /// Kind of error that occurred.
    pub kind: DescribeMLModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeMLModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeMLModelsErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeMLModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeMLModelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeMLModelsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeMLModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeMLModelsError {
    fn code(&self) -> Option<&str> {
        DescribeMLModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeMLModelsError {
    /// Creates a new `DescribeMLModelsError`.
    pub fn new(kind: DescribeMLModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeMLModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeMLModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeMLModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeMLModelsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeMLModelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMLModelsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeMLModelsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeMLModelsErrorKind::InvalidInputException(_)
        )
    }
}
impl std::error::Error for DescribeMLModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeMLModelsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeMLModelsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeMLModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeTagsError {
    /// Kind of error that occurred.
    pub kind: DescribeTagsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeTags` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeTagsErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeTagsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeTagsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeTagsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeTagsError {
    fn code(&self) -> Option<&str> {
        DescribeTagsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeTagsError {
    /// Creates a new `DescribeTagsError`.
    pub fn new(kind: DescribeTagsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeTagsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeTagsErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, DescribeTagsErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `DescribeTagsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeTagsErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for DescribeTagsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeTagsErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeTagsErrorKind::InvalidInputException(_inner) => Some(_inner),
            DescribeTagsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeTagsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetBatchPredictionError {
    /// Kind of error that occurred.
    pub kind: GetBatchPredictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetBatchPredictionErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetBatchPredictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetBatchPredictionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetBatchPredictionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetBatchPredictionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetBatchPredictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetBatchPredictionError {
    fn code(&self) -> Option<&str> {
        GetBatchPredictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetBatchPredictionError {
    /// Creates a new `GetBatchPredictionError`.
    pub fn new(kind: GetBatchPredictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetBatchPredictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetBatchPredictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetBatchPredictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetBatchPredictionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetBatchPredictionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBatchPredictionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `GetBatchPredictionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetBatchPredictionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetBatchPredictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetBatchPredictionErrorKind::InternalServerException(_inner) => Some(_inner),
            GetBatchPredictionErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetBatchPredictionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetBatchPredictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetDataSourceError {
    /// Kind of error that occurred.
    pub kind: GetDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetDataSourceErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetDataSourceError {
    fn code(&self) -> Option<&str> {
        GetDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetDataSourceError {
    /// Creates a new `GetDataSourceError`.
    pub fn new(kind: GetDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetDataSourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetDataSourceErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            GetDataSourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetEvaluationError {
    /// Kind of error that occurred.
    pub kind: GetEvaluationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetEvaluationErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetEvaluationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetEvaluationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetEvaluationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetEvaluationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetEvaluationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetEvaluationError {
    fn code(&self) -> Option<&str> {
        GetEvaluationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetEvaluationError {
    /// Creates a new `GetEvaluationError`.
    pub fn new(kind: GetEvaluationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetEvaluationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetEvaluationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetEvaluationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetEvaluationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetEvaluationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvaluationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `GetEvaluationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetEvaluationErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetEvaluationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetEvaluationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetEvaluationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetEvaluationErrorKind::InternalServerException(_inner) => Some(_inner),
            GetEvaluationErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetEvaluationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetEvaluationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `GetMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct GetMLModelError {
    /// Kind of error that occurred.
    pub kind: GetMLModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `GetMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum GetMLModelErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for GetMLModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            GetMLModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            GetMLModelErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            GetMLModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            GetMLModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for GetMLModelError {
    fn code(&self) -> Option<&str> {
        GetMLModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl GetMLModelError {
    /// Creates a new `GetMLModelError`.
    pub fn new(kind: GetMLModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `GetMLModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: GetMLModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `GetMLModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: GetMLModelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `GetMLModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, GetMLModelErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `GetMLModelErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, GetMLModelErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `GetMLModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            GetMLModelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for GetMLModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            GetMLModelErrorKind::InternalServerException(_inner) => Some(_inner),
            GetMLModelErrorKind::InvalidInputException(_inner) => Some(_inner),
            GetMLModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            GetMLModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `Predict` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct PredictError {
    /// Kind of error that occurred.
    pub kind: PredictErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `Predict` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum PredictErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>The subscriber exceeded the maximum number of operations. This exception can occur when listing objects such as <code>DataSource</code>.</p>
    LimitExceededException(crate::error::LimitExceededException),
    /// <p>The exception is thrown when a predict request is made to an unmounted <code>MLModel</code>.</p>
    PredictorNotMountedException(crate::error::PredictorNotMountedException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for PredictError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            PredictErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            PredictErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            PredictErrorKind::LimitExceededException(_inner) => _inner.fmt(f),
            PredictErrorKind::PredictorNotMountedException(_inner) => _inner.fmt(f),
            PredictErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            PredictErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for PredictError {
    fn code(&self) -> Option<&str> {
        PredictError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl PredictError {
    /// Creates a new `PredictError`.
    pub fn new(kind: PredictErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `PredictError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: PredictErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `PredictError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: PredictErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `PredictErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, PredictErrorKind::InternalServerException(_))
    }
    /// Returns `true` if the error kind is `PredictErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, PredictErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `PredictErrorKind::LimitExceededException`.
    pub fn is_limit_exceeded_exception(&self) -> bool {
        matches!(&self.kind, PredictErrorKind::LimitExceededException(_))
    }
    /// Returns `true` if the error kind is `PredictErrorKind::PredictorNotMountedException`.
    pub fn is_predictor_not_mounted_exception(&self) -> bool {
        matches!(
            &self.kind,
            PredictErrorKind::PredictorNotMountedException(_)
        )
    }
    /// Returns `true` if the error kind is `PredictErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, PredictErrorKind::ResourceNotFoundException(_))
    }
}
impl std::error::Error for PredictError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            PredictErrorKind::InternalServerException(_inner) => Some(_inner),
            PredictErrorKind::InvalidInputException(_inner) => Some(_inner),
            PredictErrorKind::LimitExceededException(_inner) => Some(_inner),
            PredictErrorKind::PredictorNotMountedException(_inner) => Some(_inner),
            PredictErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            PredictErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateBatchPredictionError {
    /// Kind of error that occurred.
    pub kind: UpdateBatchPredictionErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateBatchPrediction` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateBatchPredictionErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateBatchPredictionError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateBatchPredictionErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateBatchPredictionErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateBatchPredictionErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateBatchPredictionErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateBatchPredictionError {
    fn code(&self) -> Option<&str> {
        UpdateBatchPredictionError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateBatchPredictionError {
    /// Creates a new `UpdateBatchPredictionError`.
    pub fn new(kind: UpdateBatchPredictionErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateBatchPredictionError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateBatchPredictionErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateBatchPredictionError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateBatchPredictionErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateBatchPredictionErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBatchPredictionErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBatchPredictionErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBatchPredictionErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateBatchPredictionErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateBatchPredictionErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateBatchPredictionError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateBatchPredictionErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateBatchPredictionErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateBatchPredictionErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateBatchPredictionErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDataSourceError {
    /// Kind of error that occurred.
    pub kind: UpdateDataSourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDataSource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDataSourceErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDataSourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDataSourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDataSourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDataSourceError {
    fn code(&self) -> Option<&str> {
        UpdateDataSourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDataSourceError {
    /// Creates a new `UpdateDataSourceError`.
    pub fn new(kind: UpdateDataSourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDataSourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDataSourceErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateDataSourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDataSourceErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateDataSourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDataSourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDataSourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateEvaluationError {
    /// Kind of error that occurred.
    pub kind: UpdateEvaluationErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateEvaluation` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateEvaluationErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateEvaluationError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateEvaluationErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateEvaluationErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateEvaluationErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateEvaluationErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateEvaluationError {
    fn code(&self) -> Option<&str> {
        UpdateEvaluationError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateEvaluationError {
    /// Creates a new `UpdateEvaluationError`.
    pub fn new(kind: UpdateEvaluationErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateEvaluationError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateEvaluationErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateEvaluationError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateEvaluationErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateEvaluationErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEvaluationErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEvaluationErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEvaluationErrorKind::InvalidInputException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateEvaluationErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateEvaluationErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateEvaluationError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateEvaluationErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateEvaluationErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateEvaluationErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateEvaluationErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateMLModelError {
    /// Kind of error that occurred.
    pub kind: UpdateMLModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateMLModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateMLModelErrorKind {
    /// <p>An error on the server occurred when trying to process a request.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
    InvalidInputException(crate::error::InvalidInputException),
    /// <p>A specified resource cannot be located.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// An unexpected error, e.g. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateMLModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateMLModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateMLModelErrorKind::InvalidInputException(_inner) => _inner.fmt(f),
            UpdateMLModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateMLModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateMLModelError {
    fn code(&self) -> Option<&str> {
        UpdateMLModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateMLModelError {
    /// Creates a new `UpdateMLModelError`.
    pub fn new(kind: UpdateMLModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateMLModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateMLModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateMLModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateMLModelErrorKind::Unhandled(err.into()),
        }
    }

    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns `true` if the error kind is `UpdateMLModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLModelErrorKind::InternalServerException(_)
        )
    }
    /// Returns `true` if the error kind is `UpdateMLModelErrorKind::InvalidInputException`.
    pub fn is_invalid_input_exception(&self) -> bool {
        matches!(&self.kind, UpdateMLModelErrorKind::InvalidInputException(_))
    }
    /// Returns `true` if the error kind is `UpdateMLModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateMLModelErrorKind::ResourceNotFoundException(_)
        )
    }
}
impl std::error::Error for UpdateMLModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateMLModelErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateMLModelErrorKind::InvalidInputException(_inner) => Some(_inner),
            UpdateMLModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateMLModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>A specified resource cannot be located.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>An error on the client occurred. Typically, the cause is an invalid input value.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl InvalidInputException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidInputException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InvalidInputException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidInputException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidInputException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidInputException {}
/// See [`InvalidInputException`](crate::error::InvalidInputException)
pub mod invalid_input_exception {
    /// A builder for [`InvalidInputException`](crate::error::InvalidInputException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidInputException`](crate::error::InvalidInputException)
        pub fn build(self) -> crate::error::InvalidInputException {
            crate::error::InvalidInputException {
                message: self.message,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl InvalidInputException {
    /// Creates a new builder-style object to manufacture [`InvalidInputException`](crate::error::InvalidInputException)
    pub fn builder() -> crate::error::invalid_input_exception::Builder {
        crate::error::invalid_input_exception::Builder::default()
    }
}

/// <p>An error on the server occurred when trying to process a request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The exception is thrown when a predict request is made to an unmounted <code>MLModel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictorNotMountedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for PredictorNotMountedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictorNotMountedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl PredictorNotMountedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for PredictorNotMountedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "PredictorNotMountedException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for PredictorNotMountedException {}
/// See [`PredictorNotMountedException`](crate::error::PredictorNotMountedException)
pub mod predictor_not_mounted_exception {
    /// A builder for [`PredictorNotMountedException`](crate::error::PredictorNotMountedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictorNotMountedException`](crate::error::PredictorNotMountedException)
        pub fn build(self) -> crate::error::PredictorNotMountedException {
            crate::error::PredictorNotMountedException {
                message: self.message,
            }
        }
    }
}
impl PredictorNotMountedException {
    /// Creates a new builder-style object to manufacture [`PredictorNotMountedException`](crate::error::PredictorNotMountedException)
    pub fn builder() -> crate::error::predictor_not_mounted_exception::Builder {
        crate::error::predictor_not_mounted_exception::Builder::default()
    }
}

/// <p>The subscriber exceeded the maximum number of operations. This exception can occur when listing objects such as <code>DataSource</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl LimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("LimitExceededException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl LimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for LimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "LimitExceededException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for LimitExceededException {}
/// See [`LimitExceededException`](crate::error::LimitExceededException)
pub mod limit_exceeded_exception {
    /// A builder for [`LimitExceededException`](crate::error::LimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`LimitExceededException`](crate::error::LimitExceededException)
        pub fn build(self) -> crate::error::LimitExceededException {
            crate::error::LimitExceededException {
                message: self.message,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl LimitExceededException {
    /// Creates a new builder-style object to manufacture [`LimitExceededException`](crate::error::LimitExceededException)
    pub fn builder() -> crate::error::limit_exceeded_exception::Builder {
        crate::error::limit_exceeded_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InvalidTagException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for InvalidTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InvalidTagException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl InvalidTagException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InvalidTagException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InvalidTagException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for InvalidTagException {}
/// See [`InvalidTagException`](crate::error::InvalidTagException)
pub mod invalid_tag_exception {
    /// A builder for [`InvalidTagException`](crate::error::InvalidTagException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`InvalidTagException`](crate::error::InvalidTagException)
        pub fn build(self) -> crate::error::InvalidTagException {
            crate::error::InvalidTagException {
                message: self.message,
            }
        }
    }
}
impl InvalidTagException {
    /// Creates a new builder-style object to manufacture [`InvalidTagException`](crate::error::InvalidTagException)
    pub fn builder() -> crate::error::invalid_tag_exception::Builder {
        crate::error::invalid_tag_exception::Builder::default()
    }
}

/// <p>A second request to use or change an object was not allowed. This can result from retrying a request using a parameter that was not present in the original request.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    #[allow(missing_docs)] // documentation missing in model
    pub code: i32,
}
impl IdempotentParameterMismatchException {
    #[allow(missing_docs)] // documentation missing in model
    pub fn code(&self) -> i32 {
        self.code
    }
}
impl std::fmt::Debug for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("IdempotentParameterMismatchException");
        formatter.field("message", &self.message);
        formatter.field("code", &self.code);
        formatter.finish()
    }
}
impl IdempotentParameterMismatchException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for IdempotentParameterMismatchException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "IdempotentParameterMismatchException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for IdempotentParameterMismatchException {}
/// See [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
pub mod idempotent_parameter_mismatch_exception {
    /// A builder for [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) code: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn code(mut self, input: i32) -> Self {
            self.code = Some(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_code(mut self, input: std::option::Option<i32>) -> Self {
            self.code = input;
            self
        }
        /// Consumes the builder and constructs a [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
        pub fn build(self) -> crate::error::IdempotentParameterMismatchException {
            crate::error::IdempotentParameterMismatchException {
                message: self.message,
                code: self.code.unwrap_or_default(),
            }
        }
    }
}
impl IdempotentParameterMismatchException {
    /// Creates a new builder-style object to manufacture [`IdempotentParameterMismatchException`](crate::error::IdempotentParameterMismatchException)
    pub fn builder() -> crate::error::idempotent_parameter_mismatch_exception::Builder {
        crate::error::idempotent_parameter_mismatch_exception::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagLimitExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagLimitExceededException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl TagLimitExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for TagLimitExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "TagLimitExceededException")?;
        if let Some(inner_8) = &self.message {
            write!(f, ": {}", inner_8)?;
        }
        Ok(())
    }
}
impl std::error::Error for TagLimitExceededException {}
/// See [`TagLimitExceededException`](crate::error::TagLimitExceededException)
pub mod tag_limit_exceeded_exception {
    /// A builder for [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`TagLimitExceededException`](crate::error::TagLimitExceededException)
        pub fn build(self) -> crate::error::TagLimitExceededException {
            crate::error::TagLimitExceededException {
                message: self.message,
            }
        }
    }
}
impl TagLimitExceededException {
    /// Creates a new builder-style object to manufacture [`TagLimitExceededException`](crate::error::TagLimitExceededException)
    pub fn builder() -> crate::error::tag_limit_exceeded_exception::Builder {
        crate::error::tag_limit_exceeded_exception::Builder::default()
    }
}
