// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Machine Learning
///
/// Client for invoking operations on Amazon Machine Learning. Each operation on Amazon Machine Learning is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_machinelearning::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
/// let shared_config = aws_config::load_from_env().await;
/// let config = aws_sdk_machinelearning::config::Builder::from(&shared_config)
///   .retry_config(RetryConfig::disabled())
///   .build();
/// let client = aws_sdk_machinelearning::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`AddTags`](crate::client::fluent_builders::AddTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::AddTags::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::AddTags::set_tags): <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::AddTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::AddTags::set_resource_id): <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
    ///   - [`resource_type(TaggableResourceType)`](crate::client::fluent_builders::AddTags::resource_type) / [`set_resource_type(Option<TaggableResourceType>)`](crate::client::fluent_builders::AddTags::set_resource_type): <p>The type of the ML object to tag.</p>
    /// - On success, responds with [`AddTagsOutput`](crate::output::AddTagsOutput) with field(s):
    ///   - [`resource_id(Option<String>)`](crate::output::AddTagsOutput::resource_id): <p>The ID of the ML object that was tagged.</p>
    ///   - [`resource_type(Option<TaggableResourceType>)`](crate::output::AddTagsOutput::resource_type): <p>The type of the ML object that was tagged.</p>
    /// - On failure, responds with [`SdkError<AddTagsError>`](crate::error::AddTagsError)
    pub fn add_tags(&self) -> fluent_builders::AddTags {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateBatchPrediction`](crate::client::fluent_builders::CreateBatchPrediction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`batch_prediction_id(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPrediction::batch_prediction_id) / [`set_batch_prediction_id(Option<String>)`](crate::client::fluent_builders::CreateBatchPrediction::set_batch_prediction_id): <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
    ///   - [`batch_prediction_name(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPrediction::batch_prediction_name) / [`set_batch_prediction_name(Option<String>)`](crate::client::fluent_builders::CreateBatchPrediction::set_batch_prediction_name): <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPrediction::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::CreateBatchPrediction::set_ml_model_id): <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
    ///   - [`batch_prediction_data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPrediction::batch_prediction_data_source_id) / [`set_batch_prediction_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateBatchPrediction::set_batch_prediction_data_source_id): <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
    ///   - [`output_uri(impl Into<String>)`](crate::client::fluent_builders::CreateBatchPrediction::output_uri) / [`set_output_uri(Option<String>)`](crate::client::fluent_builders::CreateBatchPrediction::set_output_uri): <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>  <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
    /// - On success, responds with [`CreateBatchPredictionOutput`](crate::output::CreateBatchPredictionOutput) with field(s):
    ///   - [`batch_prediction_id(Option<String>)`](crate::output::CreateBatchPredictionOutput::batch_prediction_id): <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the value of the <code>BatchPredictionId</code> in the request.</p>
    /// - On failure, responds with [`SdkError<CreateBatchPredictionError>`](crate::error::CreateBatchPredictionError)
    pub fn create_batch_prediction(&self) -> fluent_builders::CreateBatchPrediction {
        fluent_builders::CreateBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSourceFromRDS`](crate::client::fluent_builders::CreateDataSourceFromRDS) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::set_data_source_id): <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN) becomes the ID for a <code>DataSource</code>.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::set_data_source_name): <p>A user-supplied name or description of the <code>DataSource</code>.</p>
    ///   - [`rds_data(RdsDataSpec)`](crate::client::fluent_builders::CreateDataSourceFromRDS::rds_data) / [`set_rds_data(Option<RdsDataSpec>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::set_rds_data): <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>  <ul>   <li> <p>DatabaseInformation -</p>    <ul>     <li> <p> <code>DatabaseName</code> - The name of the Amazon RDS database.</p> </li>     <li> <p> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p> </li>    </ul> </li>   <li> <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p> </li>   <li> <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p> </li>   <li> <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p> </li>   <li> <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p> </li>   <li> <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p> </li>   <li> <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p> </li>   <li> <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>   <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>   <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>  </ul>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromRDS::set_role_arn): <p>The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>  <p></p>
    ///   - [`compute_statistics(bool)`](crate::client::fluent_builders::CreateDataSourceFromRDS::compute_statistics) / [`set_compute_statistics(bool)`](crate::client::fluent_builders::CreateDataSourceFromRDS::set_compute_statistics): <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training. </p>
    /// - On success, responds with [`CreateDataSourceFromRdsOutput`](crate::output::CreateDataSourceFromRdsOutput) with field(s):
    ///   - [`data_source_id(Option<String>)`](crate::output::CreateDataSourceFromRdsOutput::data_source_id): <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the <code>DataSourceID</code> in the request. </p>
    /// - On failure, responds with [`SdkError<CreateDataSourceFromRDSError>`](crate::error::CreateDataSourceFromRDSError)
    pub fn create_data_source_from_rds(&self) -> fluent_builders::CreateDataSourceFromRDS {
        fluent_builders::CreateDataSourceFromRDS::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSourceFromRedshift`](crate::client::fluent_builders::CreateDataSourceFromRedshift) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::set_data_source_id): <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::set_data_source_name): <p>A user-supplied name or description of the <code>DataSource</code>. </p>
    ///   - [`data_spec(RedshiftDataSpec)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::data_spec) / [`set_data_spec(Option<RedshiftDataSpec>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::set_data_spec): <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>  <ul>   <li> <p>DatabaseInformation -</p>    <ul>     <li> <p> <code>DatabaseName</code> - The name of the Amazon Redshift database.</p> </li>     <li> <p> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p> </li>    </ul> </li>   <li> <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p> </li>   <li> <p>SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.</p> </li>   <li> <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this location.</p> </li>   <li> <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>   <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>   <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>  </ul>
    ///   - [`role_arn(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::role_arn) / [`set_role_arn(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::set_role_arn): <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>  <ul>   <li> <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p> </li>   <li> <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code> </p> </li>  </ul>
    ///   - [`compute_statistics(bool)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::compute_statistics) / [`set_compute_statistics(bool)`](crate::client::fluent_builders::CreateDataSourceFromRedshift::set_compute_statistics): <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for <code>MLModel</code> training.</p>
    /// - On success, responds with [`CreateDataSourceFromRedshiftOutput`](crate::output::CreateDataSourceFromRedshiftOutput) with field(s):
    ///   - [`data_source_id(Option<String>)`](crate::output::CreateDataSourceFromRedshiftOutput::data_source_id): <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the <code>DataSourceID</code> in the request. </p>
    /// - On failure, responds with [`SdkError<CreateDataSourceFromRedshiftError>`](crate::error::CreateDataSourceFromRedshiftError)
    pub fn create_data_source_from_redshift(
        &self,
    ) -> fluent_builders::CreateDataSourceFromRedshift {
        fluent_builders::CreateDataSourceFromRedshift::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateDataSourceFromS3`](crate::client::fluent_builders::CreateDataSourceFromS3) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromS3::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromS3::set_data_source_id): <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::CreateDataSourceFromS3::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::CreateDataSourceFromS3::set_data_source_name): <p>A user-supplied name or description of the <code>DataSource</code>. </p>
    ///   - [`data_spec(S3DataSpec)`](crate::client::fluent_builders::CreateDataSourceFromS3::data_spec) / [`set_data_spec(Option<S3DataSpec>)`](crate::client::fluent_builders::CreateDataSourceFromS3::set_data_spec): <p>The data specification of a <code>DataSource</code>:</p>  <ul>   <li> <p>DataLocationS3 - The Amazon S3 location of the observation data.</p> </li>   <li> <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>   <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>   <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>  </ul>
    ///   - [`compute_statistics(bool)`](crate::client::fluent_builders::CreateDataSourceFromS3::compute_statistics) / [`set_compute_statistics(bool)`](crate::client::fluent_builders::CreateDataSourceFromS3::set_compute_statistics): <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
    /// - On success, responds with [`CreateDataSourceFromS3Output`](crate::output::CreateDataSourceFromS3Output) with field(s):
    ///   - [`data_source_id(Option<String>)`](crate::output::CreateDataSourceFromS3Output::data_source_id): <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request. </p>
    /// - On failure, responds with [`SdkError<CreateDataSourceFromS3Error>`](crate::error::CreateDataSourceFromS3Error)
    pub fn create_data_source_from_s3(&self) -> fluent_builders::CreateDataSourceFromS3 {
        fluent_builders::CreateDataSourceFromS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateEvaluation`](crate::client::fluent_builders::CreateEvaluation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`evaluation_id(impl Into<String>)`](crate::client::fluent_builders::CreateEvaluation::evaluation_id) / [`set_evaluation_id(Option<String>)`](crate::client::fluent_builders::CreateEvaluation::set_evaluation_id): <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
    ///   - [`evaluation_name(impl Into<String>)`](crate::client::fluent_builders::CreateEvaluation::evaluation_name) / [`set_evaluation_name(Option<String>)`](crate::client::fluent_builders::CreateEvaluation::set_evaluation_name): <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::CreateEvaluation::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::CreateEvaluation::set_ml_model_id): <p>The ID of the <code>MLModel</code> to evaluate.</p>  <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
    ///   - [`evaluation_data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateEvaluation::evaluation_data_source_id) / [`set_evaluation_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateEvaluation::set_evaluation_data_source_id): <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must match the schema used to create the <code>MLModel</code>.</p>
    /// - On success, responds with [`CreateEvaluationOutput`](crate::output::CreateEvaluationOutput) with field(s):
    ///   - [`evaluation_id(Option<String>)`](crate::output::CreateEvaluationOutput::evaluation_id): <p>The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>
    /// - On failure, responds with [`SdkError<CreateEvaluationError>`](crate::error::CreateEvaluationError)
    pub fn create_evaluation(&self) -> fluent_builders::CreateEvaluation {
        fluent_builders::CreateEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateMLModel`](crate::client::fluent_builders::CreateMLModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::CreateMLModel::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::CreateMLModel::set_ml_model_id): <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
    ///   - [`ml_model_name(impl Into<String>)`](crate::client::fluent_builders::CreateMLModel::ml_model_name) / [`set_ml_model_name(Option<String>)`](crate::client::fluent_builders::CreateMLModel::set_ml_model_name): <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    ///   - [`ml_model_type(MlModelType)`](crate::client::fluent_builders::CreateMLModel::ml_model_type) / [`set_ml_model_type(Option<MlModelType>)`](crate::client::fluent_builders::CreateMLModel::set_ml_model_type): <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>  <ul>   <li> <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p> </li>   <li> <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p> </li>   <li> <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p> </li>  </ul>  <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
    ///   - [`parameters(HashMap<String, String>)`](crate::client::fluent_builders::CreateMLModel::parameters) / [`set_parameters(Option<HashMap<String, String>>)`](crate::client::fluent_builders::CreateMLModel::set_parameters): <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p>  <p>The following is the current set of training parameters:</p>  <ul>   <li> <p> <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li>   <li> <p> <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p> </li>   <li> <p> <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.</p> </li>   <li> <p> <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li>   <li> <p> <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li>  </ul>
    ///   - [`training_data_source_id(impl Into<String>)`](crate::client::fluent_builders::CreateMLModel::training_data_source_id) / [`set_training_data_source_id(Option<String>)`](crate::client::fluent_builders::CreateMLModel::set_training_data_source_id): <p>The <code>DataSource</code> that points to the training data.</p>
    ///   - [`recipe(impl Into<String>)`](crate::client::fluent_builders::CreateMLModel::recipe) / [`set_recipe(Option<String>)`](crate::client::fluent_builders::CreateMLModel::set_recipe): <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
    ///   - [`recipe_uri(impl Into<String>)`](crate::client::fluent_builders::CreateMLModel::recipe_uri) / [`set_recipe_uri(Option<String>)`](crate::client::fluent_builders::CreateMLModel::set_recipe_uri): <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
    /// - On success, responds with [`CreateMlModelOutput`](crate::output::CreateMlModelOutput) with field(s):
    ///   - [`ml_model_id(Option<String>)`](crate::output::CreateMlModelOutput::ml_model_id): <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelId</code> in the request. </p>
    /// - On failure, responds with [`SdkError<CreateMLModelError>`](crate::error::CreateMLModelError)
    pub fn create_ml_model(&self) -> fluent_builders::CreateMLModel {
        fluent_builders::CreateMLModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateRealtimeEndpoint`](crate::client::fluent_builders::CreateRealtimeEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::CreateRealtimeEndpoint::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::CreateRealtimeEndpoint::set_ml_model_id): <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    /// - On success, responds with [`CreateRealtimeEndpointOutput`](crate::output::CreateRealtimeEndpointOutput) with field(s):
    ///   - [`ml_model_id(Option<String>)`](crate::output::CreateRealtimeEndpointOutput::ml_model_id): <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelId</code> in the request.</p>
    ///   - [`realtime_endpoint_info(Option<RealtimeEndpointInfo>)`](crate::output::CreateRealtimeEndpointOutput::realtime_endpoint_info): <p>The endpoint information of the <code>MLModel</code> </p>
    /// - On failure, responds with [`SdkError<CreateRealtimeEndpointError>`](crate::error::CreateRealtimeEndpointError)
    pub fn create_realtime_endpoint(&self) -> fluent_builders::CreateRealtimeEndpoint {
        fluent_builders::CreateRealtimeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteBatchPrediction`](crate::client::fluent_builders::DeleteBatchPrediction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`batch_prediction_id(impl Into<String>)`](crate::client::fluent_builders::DeleteBatchPrediction::batch_prediction_id) / [`set_batch_prediction_id(Option<String>)`](crate::client::fluent_builders::DeleteBatchPrediction::set_batch_prediction_id): <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
    /// - On success, responds with [`DeleteBatchPredictionOutput`](crate::output::DeleteBatchPredictionOutput) with field(s):
    ///   - [`batch_prediction_id(Option<String>)`](crate::output::DeleteBatchPredictionOutput::batch_prediction_id): <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>
    /// - On failure, responds with [`SdkError<DeleteBatchPredictionError>`](crate::error::DeleteBatchPredictionError)
    pub fn delete_batch_prediction(&self) -> fluent_builders::DeleteBatchPrediction {
        fluent_builders::DeleteBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::DeleteDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::DeleteDataSource::set_data_source_id): <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
    /// - On success, responds with [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput) with field(s):
    ///   - [`data_source_id(Option<String>)`](crate::output::DeleteDataSourceOutput::data_source_id): <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>
    /// - On failure, responds with [`SdkError<DeleteDataSourceError>`](crate::error::DeleteDataSourceError)
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteEvaluation`](crate::client::fluent_builders::DeleteEvaluation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`evaluation_id(impl Into<String>)`](crate::client::fluent_builders::DeleteEvaluation::evaluation_id) / [`set_evaluation_id(Option<String>)`](crate::client::fluent_builders::DeleteEvaluation::set_evaluation_id): <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
    /// - On success, responds with [`DeleteEvaluationOutput`](crate::output::DeleteEvaluationOutput) with field(s):
    ///   - [`evaluation_id(Option<String>)`](crate::output::DeleteEvaluationOutput::evaluation_id): <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>
    /// - On failure, responds with [`SdkError<DeleteEvaluationError>`](crate::error::DeleteEvaluationError)
    pub fn delete_evaluation(&self) -> fluent_builders::DeleteEvaluation {
        fluent_builders::DeleteEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteMLModel`](crate::client::fluent_builders::DeleteMLModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::DeleteMLModel::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::DeleteMLModel::set_ml_model_id): <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
    /// - On success, responds with [`DeleteMlModelOutput`](crate::output::DeleteMlModelOutput) with field(s):
    ///   - [`ml_model_id(Option<String>)`](crate::output::DeleteMlModelOutput::ml_model_id): <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>
    /// - On failure, responds with [`SdkError<DeleteMLModelError>`](crate::error::DeleteMLModelError)
    pub fn delete_ml_model(&self) -> fluent_builders::DeleteMLModel {
        fluent_builders::DeleteMLModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteRealtimeEndpoint`](crate::client::fluent_builders::DeleteRealtimeEndpoint) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::DeleteRealtimeEndpoint::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::DeleteRealtimeEndpoint::set_ml_model_id): <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    /// - On success, responds with [`DeleteRealtimeEndpointOutput`](crate::output::DeleteRealtimeEndpointOutput) with field(s):
    ///   - [`ml_model_id(Option<String>)`](crate::output::DeleteRealtimeEndpointOutput::ml_model_id): <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelId</code> in the request.</p>
    ///   - [`realtime_endpoint_info(Option<RealtimeEndpointInfo>)`](crate::output::DeleteRealtimeEndpointOutput::realtime_endpoint_info): <p>The endpoint information of the <code>MLModel</code> </p>
    /// - On failure, responds with [`SdkError<DeleteRealtimeEndpointError>`](crate::error::DeleteRealtimeEndpointError)
    pub fn delete_realtime_endpoint(&self) -> fluent_builders::DeleteRealtimeEndpoint {
        fluent_builders::DeleteRealtimeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteTags`](crate::client::fluent_builders::DeleteTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::DeleteTags::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::DeleteTags::set_tag_keys): <p>One or more tags to delete.</p>
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DeleteTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DeleteTags::set_resource_id): <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
    ///   - [`resource_type(TaggableResourceType)`](crate::client::fluent_builders::DeleteTags::resource_type) / [`set_resource_type(Option<TaggableResourceType>)`](crate::client::fluent_builders::DeleteTags::set_resource_type): <p>The type of the tagged ML object.</p>
    /// - On success, responds with [`DeleteTagsOutput`](crate::output::DeleteTagsOutput) with field(s):
    ///   - [`resource_id(Option<String>)`](crate::output::DeleteTagsOutput::resource_id): <p>The ID of the ML object from which tags were deleted.</p>
    ///   - [`resource_type(Option<TaggableResourceType>)`](crate::output::DeleteTagsOutput::resource_type): <p>The type of the ML object from which tags were deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteTagsError>`](crate::error::DeleteTagsError)
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeBatchPredictions`](crate::client::fluent_builders::DescribeBatchPredictions) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeBatchPredictions::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_variable(BatchPredictionFilterVariable)`](crate::client::fluent_builders::DescribeBatchPredictions::filter_variable) / [`set_filter_variable(Option<BatchPredictionFilterVariable>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_filter_variable): <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>  <ul>   <li> <p> <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p> </li>   <li> <p> <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p> </li>   <li> <p> <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code> <b> </b> <code>Name</code>.</p> </li>   <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p> </li>   <li> <p> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p> </li>   <li> <p> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p> </li>   <li> <p> <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p> </li>  </ul>
    ///   - [`eq(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::eq) / [`set_eq(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_eq): <p>The equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    ///   - [`gt(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::gt) / [`set_gt(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_gt): <p>The greater than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    ///   - [`lt(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::lt) / [`set_lt(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_lt): <p>The less than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    ///   - [`ge(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::ge) / [`set_ge(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_ge): <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
    ///   - [`le(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::le) / [`set_le(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_le): <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    ///   - [`ne(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::ne) / [`set_ne(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_ne): <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_prefix): <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>  <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>  <ul>   <li> <p>2014-09</p> </li>   <li> <p>2014-09-09</p> </li>   <li> <p>2014-09-09-Holiday</p> </li>  </ul>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::DescribeBatchPredictions::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_sort_order): <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>  <ul>   <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>   <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>  </ul>  <p>Results are sorted by <code>FilterVariable</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_next_token): <p>An ID of the page in the paginated results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeBatchPredictions::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeBatchPredictions::set_limit): <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
    /// - On success, responds with [`DescribeBatchPredictionsOutput`](crate::output::DescribeBatchPredictionsOutput) with field(s):
    ///   - [`results(Option<Vec<BatchPrediction>>)`](crate::output::DescribeBatchPredictionsOutput::results): <p>A list of <code>BatchPrediction</code> objects that meet the search criteria. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeBatchPredictionsOutput::next_token): <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    /// - On failure, responds with [`SdkError<DescribeBatchPredictionsError>`](crate::error::DescribeBatchPredictionsError)
    pub fn describe_batch_predictions(&self) -> fluent_builders::DescribeBatchPredictions {
        fluent_builders::DescribeBatchPredictions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataSources`](crate::client::fluent_builders::DescribeDataSources) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeDataSources::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_variable(DataSourceFilterVariable)`](crate::client::fluent_builders::DescribeDataSources::filter_variable) / [`set_filter_variable(Option<DataSourceFilterVariable>)`](crate::client::fluent_builders::DescribeDataSources::set_filter_variable): <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>  <ul>   <li> <p> <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p> </li>   <li> <p> <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p> </li>   <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.</p> </li>   <li> <p> <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p> </li>   <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p> </li>  </ul>
    ///   - [`eq(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::eq) / [`set_eq(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_eq): <p>The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    ///   - [`gt(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::gt) / [`set_gt(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_gt): <p>The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    ///   - [`lt(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::lt) / [`set_lt(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_lt): <p>The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    ///   - [`ge(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::ge) / [`set_ge(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_ge): <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
    ///   - [`le(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::le) / [`set_le(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_le): <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    ///   - [`ne(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::ne) / [`set_ne(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_ne): <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_prefix): <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>  <p>For example, a <code>DataSource</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>  <ul>   <li> <p>2014-09</p> </li>   <li> <p>2014-09-09</p> </li>   <li> <p>2014-09-09-Holiday</p> </li>  </ul>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::DescribeDataSources::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::DescribeDataSources::set_sort_order): <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>  <ul>   <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>   <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>  </ul>  <p>Results are sorted by <code>FilterVariable</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeDataSources::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeDataSources::set_next_token): <p>The ID of the page in the paginated results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeDataSources::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeDataSources::set_limit): <p> The maximum number of <code>DataSource</code> to include in the result.</p>
    /// - On success, responds with [`DescribeDataSourcesOutput`](crate::output::DescribeDataSourcesOutput) with field(s):
    ///   - [`results(Option<Vec<DataSource>>)`](crate::output::DescribeDataSourcesOutput::results): <p>A list of <code>DataSource</code> that meet the search criteria. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeDataSourcesOutput::next_token): <p>An ID of the next page in the paginated results that indicates at least one more page follows.</p>
    /// - On failure, responds with [`SdkError<DescribeDataSourcesError>`](crate::error::DescribeDataSourcesError)
    pub fn describe_data_sources(&self) -> fluent_builders::DescribeDataSources {
        fluent_builders::DescribeDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeEvaluations`](crate::client::fluent_builders::DescribeEvaluations) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeEvaluations::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_variable(EvaluationFilterVariable)`](crate::client::fluent_builders::DescribeEvaluations::filter_variable) / [`set_filter_variable(Option<EvaluationFilterVariable>)`](crate::client::fluent_builders::DescribeEvaluations::set_filter_variable): <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>  <ul>   <li> <p> <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p> </li>   <li> <p> <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p> </li>   <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b> <code>Name</code>.</p> </li>   <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p> </li>   <li> <p> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p> </li>   <li> <p> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p> </li>   <li> <p> <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p> </li>  </ul>
    ///   - [`eq(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::eq) / [`set_eq(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_eq): <p>The equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    ///   - [`gt(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::gt) / [`set_gt(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_gt): <p>The greater than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    ///   - [`lt(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::lt) / [`set_lt(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_lt): <p>The less than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    ///   - [`ge(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::ge) / [`set_ge(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_ge): <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
    ///   - [`le(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::le) / [`set_le(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_le): <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    ///   - [`ne(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::ne) / [`set_ne(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_ne): <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_prefix): <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>  <p>For example, an <code>Evaluation</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>  <ul>   <li> <p>2014-09</p> </li>   <li> <p>2014-09-09</p> </li>   <li> <p>2014-09-09-Holiday</p> </li>  </ul>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::DescribeEvaluations::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::DescribeEvaluations::set_sort_order): <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>  <ul>   <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>   <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>  </ul>  <p>Results are sorted by <code>FilterVariable</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeEvaluations::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeEvaluations::set_next_token): <p>The ID of the page in the paginated results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeEvaluations::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeEvaluations::set_limit): <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
    /// - On success, responds with [`DescribeEvaluationsOutput`](crate::output::DescribeEvaluationsOutput) with field(s):
    ///   - [`results(Option<Vec<Evaluation>>)`](crate::output::DescribeEvaluationsOutput::results): <p>A list of <code>Evaluation</code> that meet the search criteria. </p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeEvaluationsOutput::next_token): <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    /// - On failure, responds with [`SdkError<DescribeEvaluationsError>`](crate::error::DescribeEvaluationsError)
    pub fn describe_evaluations(&self) -> fluent_builders::DescribeEvaluations {
        fluent_builders::DescribeEvaluations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeMLModels`](crate::client::fluent_builders::DescribeMLModels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::DescribeMLModels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`filter_variable(MlModelFilterVariable)`](crate::client::fluent_builders::DescribeMLModels::filter_variable) / [`set_filter_variable(Option<MlModelFilterVariable>)`](crate::client::fluent_builders::DescribeMLModels::set_filter_variable): <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>  <ul>   <li> <p> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p> </li>   <li> <p> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p> </li>   <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code> <b> </b> <code>Name</code>.</p> </li>   <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p> </li>   <li> <p> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p> </li>   <li> <p> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p> </li>   <li> <p> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p> </li>   <li> <p> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p> </li>   <li> <p> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p> </li>  </ul>
    ///   - [`eq(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::eq) / [`set_eq(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_eq): <p>The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    ///   - [`gt(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::gt) / [`set_gt(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_gt): <p>The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    ///   - [`lt(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::lt) / [`set_lt(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_lt): <p>The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    ///   - [`ge(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::ge) / [`set_ge(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_ge): <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
    ///   - [`le(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::le) / [`set_le(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_le): <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    ///   - [`ne(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::ne) / [`set_ne(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_ne): <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    ///   - [`prefix(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::prefix) / [`set_prefix(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_prefix): <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>  <p>For example, an <code>MLModel</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>  <ul>   <li> <p>2014-09</p> </li>   <li> <p>2014-09-09</p> </li>   <li> <p>2014-09-09-Holiday</p> </li>  </ul>
    ///   - [`sort_order(SortOrder)`](crate::client::fluent_builders::DescribeMLModels::sort_order) / [`set_sort_order(Option<SortOrder>)`](crate::client::fluent_builders::DescribeMLModels::set_sort_order): <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>  <ul>   <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>   <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>  </ul>  <p>Results are sorted by <code>FilterVariable</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::DescribeMLModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::DescribeMLModels::set_next_token): <p>The ID of the page in the paginated results.</p>
    ///   - [`limit(i32)`](crate::client::fluent_builders::DescribeMLModels::limit) / [`set_limit(Option<i32>)`](crate::client::fluent_builders::DescribeMLModels::set_limit): <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
    /// - On success, responds with [`DescribeMlModelsOutput`](crate::output::DescribeMlModelsOutput) with field(s):
    ///   - [`results(Option<Vec<MlModel>>)`](crate::output::DescribeMlModelsOutput::results): <p>A list of <code>MLModel</code> that meet the search criteria.</p>
    ///   - [`next_token(Option<String>)`](crate::output::DescribeMlModelsOutput::next_token): <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    /// - On failure, responds with [`SdkError<DescribeMLModelsError>`](crate::error::DescribeMLModelsError)
    pub fn describe_ml_models(&self) -> fluent_builders::DescribeMLModels {
        fluent_builders::DescribeMLModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeTags`](crate::client::fluent_builders::DescribeTags) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_id(impl Into<String>)`](crate::client::fluent_builders::DescribeTags::resource_id) / [`set_resource_id(Option<String>)`](crate::client::fluent_builders::DescribeTags::set_resource_id): <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
    ///   - [`resource_type(TaggableResourceType)`](crate::client::fluent_builders::DescribeTags::resource_type) / [`set_resource_type(Option<TaggableResourceType>)`](crate::client::fluent_builders::DescribeTags::set_resource_type): <p>The type of the ML object.</p>
    /// - On success, responds with [`DescribeTagsOutput`](crate::output::DescribeTagsOutput) with field(s):
    ///   - [`resource_id(Option<String>)`](crate::output::DescribeTagsOutput::resource_id): <p>The ID of the tagged ML object.</p>
    ///   - [`resource_type(Option<TaggableResourceType>)`](crate::output::DescribeTagsOutput::resource_type): <p>The type of the tagged ML object.</p>
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::DescribeTagsOutput::tags): <p>A list of tags associated with the ML object.</p>
    /// - On failure, responds with [`SdkError<DescribeTagsError>`](crate::error::DescribeTagsError)
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetBatchPrediction`](crate::client::fluent_builders::GetBatchPrediction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`batch_prediction_id(impl Into<String>)`](crate::client::fluent_builders::GetBatchPrediction::batch_prediction_id) / [`set_batch_prediction_id(Option<String>)`](crate::client::fluent_builders::GetBatchPrediction::set_batch_prediction_id): <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
    /// - On success, responds with [`GetBatchPredictionOutput`](crate::output::GetBatchPredictionOutput) with field(s):
    ///   - [`batch_prediction_id(Option<String>)`](crate::output::GetBatchPredictionOutput::batch_prediction_id): <p>An ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>
    ///   - [`ml_model_id(Option<String>)`](crate::output::GetBatchPredictionOutput::ml_model_id): <p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>
    ///   - [`batch_prediction_data_source_id(Option<String>)`](crate::output::GetBatchPredictionOutput::batch_prediction_data_source_id): <p>The ID of the <code>DataSource</code> that was used to create the <code>BatchPrediction</code>. </p>
    ///   - [`input_data_location_s3(Option<String>)`](crate::output::GetBatchPredictionOutput::input_data_location_s3): <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    ///   - [`created_by_iam_user(Option<String>)`](crate::output::GetBatchPredictionOutput::created_by_iam_user): <p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetBatchPredictionOutput::created_at): <p>The time when the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetBatchPredictionOutput::last_updated_at): <p>The time of the most recent edit to <code>BatchPrediction</code>. The time is expressed in epoch time.</p>
    ///   - [`name(Option<String>)`](crate::output::GetBatchPredictionOutput::name): <p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>
    ///   - [`status(Option<EntityStatus>)`](crate::output::GetBatchPredictionOutput::status): <p>The status of the <code>BatchPrediction</code>, which can be one of the following values:</p>  <ul>   <li> <p> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.</p> </li>   <li> <p> <code>INPROGRESS</code> - The batch predictions are in progress.</p> </li>   <li> <p> <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</p> </li>   <li> <p> <code>COMPLETED</code> - The batch prediction process completed successfully.</p> </li>   <li> <p> <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</p> </li>  </ul>
    ///   - [`output_uri(Option<String>)`](crate::output::GetBatchPredictionOutput::output_uri): <p>The location of an Amazon S3 bucket or directory to receive the operation results.</p>
    ///   - [`log_uri(Option<String>)`](crate::output::GetBatchPredictionOutput::log_uri): <p>A link to the file that contains logs of the <code>CreateBatchPrediction</code> operation.</p>
    ///   - [`message(Option<String>)`](crate::output::GetBatchPredictionOutput::message): <p>A description of the most recent details about processing the batch prediction request.</p>
    ///   - [`compute_time(Option<i64>)`](crate::output::GetBatchPredictionOutput::compute_time): <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>BatchPrediction</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>BatchPrediction</code> is in the <code>COMPLETED</code> state.</p>
    ///   - [`finished_at(Option<DateTime>)`](crate::output::GetBatchPredictionOutput::finished_at): <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>BatchPrediction</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::GetBatchPredictionOutput::started_at): <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>BatchPrediction</code> is in the <code>PENDING</code> state.</p>
    ///   - [`total_record_count(Option<i64>)`](crate::output::GetBatchPredictionOutput::total_record_count): <p>The number of total records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
    ///   - [`invalid_record_count(Option<i64>)`](crate::output::GetBatchPredictionOutput::invalid_record_count): <p>The number of invalid records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
    /// - On failure, responds with [`SdkError<GetBatchPredictionError>`](crate::error::GetBatchPredictionError)
    pub fn get_batch_prediction(&self) -> fluent_builders::GetBatchPrediction {
        fluent_builders::GetBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetDataSource`](crate::client::fluent_builders::GetDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::GetDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::GetDataSource::set_data_source_id): <p>The ID assigned to the <code>DataSource</code> at creation.</p>
    ///   - [`verbose(bool)`](crate::client::fluent_builders::GetDataSource::verbose) / [`set_verbose(bool)`](crate::client::fluent_builders::GetDataSource::set_verbose): <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>  <p>If true, <code>DataSourceSchema</code> is returned.</p>  <p>If false, <code>DataSourceSchema</code> is not returned.</p>
    /// - On success, responds with [`GetDataSourceOutput`](crate::output::GetDataSourceOutput) with field(s):
    ///   - [`data_source_id(Option<String>)`](crate::output::GetDataSourceOutput::data_source_id): <p>The ID assigned to the <code>DataSource</code> at creation. This value should be identical to the value of the <code>DataSourceId</code> in the request.</p>
    ///   - [`data_location_s3(Option<String>)`](crate::output::GetDataSourceOutput::data_location_s3): <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    ///   - [`data_rearrangement(Option<String>)`](crate::output::GetDataSourceOutput::data_rearrangement): <p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code> was created.</p>
    ///   - [`created_by_iam_user(Option<String>)`](crate::output::GetDataSourceOutput::created_by_iam_user): <p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetDataSourceOutput::created_at): <p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetDataSourceOutput::last_updated_at): <p>The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.</p>
    ///   - [`data_size_in_bytes(Option<i64>)`](crate::output::GetDataSourceOutput::data_size_in_bytes): <p>The total size of observations in the data files.</p>
    ///   - [`number_of_files(Option<i64>)`](crate::output::GetDataSourceOutput::number_of_files): <p>The number of data files referenced by the <code>DataSource</code>.</p>
    ///   - [`name(Option<String>)`](crate::output::GetDataSourceOutput::name): <p>A user-supplied name or description of the <code>DataSource</code>.</p>
    ///   - [`status(Option<EntityStatus>)`](crate::output::GetDataSourceOutput::status): <p>The current status of the <code>DataSource</code>. This element can have one of the following values:</p>  <ul>   <li> <p> <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</p> </li>   <li> <p> <code>INPROGRESS</code> - The creation process is underway.</p> </li>   <li> <p> <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</p> </li>   <li> <p> <code>COMPLETED</code> - The creation process completed successfully.</p> </li>   <li> <p> <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</p> </li>  </ul>
    ///   - [`log_uri(Option<String>)`](crate::output::GetDataSourceOutput::log_uri): <p>A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.</p>
    ///   - [`message(Option<String>)`](crate::output::GetDataSourceOutput::message): <p>The user-supplied description of the most recent details about creating the <code>DataSource</code>.</p>
    ///   - [`redshift_metadata(Option<RedshiftMetadata>)`](crate::output::GetDataSourceOutput::redshift_metadata): <p>Describes the <code>DataSource</code> details specific to Amazon Redshift.</p>
    ///   - [`rds_metadata(Option<RdsMetadata>)`](crate::output::GetDataSourceOutput::rds_metadata): <p>The datasource details that are specific to Amazon RDS.</p>
    ///   - [`role_arn(Option<String>)`](crate::output::GetDataSourceOutput::role_arn): <p>The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role</a>, such as the following: arn:aws:iam::account:role/rolename. </p>
    ///   - [`compute_statistics(bool)`](crate::output::GetDataSourceOutput::compute_statistics): <p> The parameter is <code>true</code> if statistics need to be generated from the observation data. </p>
    ///   - [`compute_time(Option<i64>)`](crate::output::GetDataSourceOutput::compute_time): <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the <code>ComputeStatistics</code> is set to true.</p>
    ///   - [`finished_at(Option<DateTime>)`](crate::output::GetDataSourceOutput::finished_at): <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::GetDataSourceOutput::started_at): <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.</p>
    ///   - [`data_source_schema(Option<String>)`](crate::output::GetDataSourceOutput::data_source_schema): <p>The schema used by all of the data files of this <code>DataSource</code>.</p>  <p> <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    /// - On failure, responds with [`SdkError<GetDataSourceError>`](crate::error::GetDataSourceError)
    pub fn get_data_source(&self) -> fluent_builders::GetDataSource {
        fluent_builders::GetDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetEvaluation`](crate::client::fluent_builders::GetEvaluation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`evaluation_id(impl Into<String>)`](crate::client::fluent_builders::GetEvaluation::evaluation_id) / [`set_evaluation_id(Option<String>)`](crate::client::fluent_builders::GetEvaluation::set_evaluation_id): <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
    /// - On success, responds with [`GetEvaluationOutput`](crate::output::GetEvaluationOutput) with field(s):
    ///   - [`evaluation_id(Option<String>)`](crate::output::GetEvaluationOutput::evaluation_id): <p>The evaluation ID which is same as the <code>EvaluationId</code> in the request.</p>
    ///   - [`ml_model_id(Option<String>)`](crate::output::GetEvaluationOutput::ml_model_id): <p>The ID of the <code>MLModel</code> that was the focus of the evaluation.</p>
    ///   - [`evaluation_data_source_id(Option<String>)`](crate::output::GetEvaluationOutput::evaluation_data_source_id): <p>The <code>DataSource</code> used for this evaluation.</p>
    ///   - [`input_data_location_s3(Option<String>)`](crate::output::GetEvaluationOutput::input_data_location_s3): <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    ///   - [`created_by_iam_user(Option<String>)`](crate::output::GetEvaluationOutput::created_by_iam_user): <p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetEvaluationOutput::created_at): <p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetEvaluationOutput::last_updated_at): <p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>
    ///   - [`name(Option<String>)`](crate::output::GetEvaluationOutput::name): <p>A user-supplied name or description of the <code>Evaluation</code>. </p>
    ///   - [`status(Option<EntityStatus>)`](crate::output::GetEvaluationOutput::status): <p>The status of the evaluation. This element can have one of the following values:</p>  <ul>   <li> <p> <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</p> </li>   <li> <p> <code>INPROGRESS</code> - The evaluation is underway.</p> </li>   <li> <p> <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</p> </li>   <li> <p> <code>COMPLETED</code> - The evaluation process completed successfully.</p> </li>   <li> <p> <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</p> </li>  </ul>
    ///   - [`performance_metrics(Option<PerformanceMetrics>)`](crate::output::GetEvaluationOutput::performance_metrics): <p>Measurements of how well the <code>MLModel</code> performed using observations referenced by the <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>: </p>  <ul>   <li> <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p> </li>   <li> <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p> </li>   <li> <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p> </li>  </ul>  <p> For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>. </p>
    ///   - [`log_uri(Option<String>)`](crate::output::GetEvaluationOutput::log_uri): <p>A link to the file that contains logs of the <code>CreateEvaluation</code> operation.</p>
    ///   - [`message(Option<String>)`](crate::output::GetEvaluationOutput::message): <p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>
    ///   - [`compute_time(Option<i64>)`](crate::output::GetEvaluationOutput::compute_time): <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.</p>
    ///   - [`finished_at(Option<DateTime>)`](crate::output::GetEvaluationOutput::finished_at): <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::GetEvaluationOutput::started_at): <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.</p>
    /// - On failure, responds with [`SdkError<GetEvaluationError>`](crate::error::GetEvaluationError)
    pub fn get_evaluation(&self) -> fluent_builders::GetEvaluation {
        fluent_builders::GetEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`GetMLModel`](crate::client::fluent_builders::GetMLModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::GetMLModel::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::GetMLModel::set_ml_model_id): <p>The ID assigned to the <code>MLModel</code> at creation.</p>
    ///   - [`verbose(bool)`](crate::client::fluent_builders::GetMLModel::verbose) / [`set_verbose(bool)`](crate::client::fluent_builders::GetMLModel::set_verbose): <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>  <p>If true, <code>Recipe</code> is returned.</p>  <p>If false, <code>Recipe</code> is not returned.</p>
    /// - On success, responds with [`GetMlModelOutput`](crate::output::GetMlModelOutput) with field(s):
    ///   - [`ml_model_id(Option<String>)`](crate::output::GetMlModelOutput::ml_model_id): <p>The MLModel ID, which is same as the <code>MLModelId</code> in the request.</p>
    ///   - [`training_data_source_id(Option<String>)`](crate::output::GetMlModelOutput::training_data_source_id): <p>The ID of the training <code>DataSource</code>.</p>
    ///   - [`created_by_iam_user(Option<String>)`](crate::output::GetMlModelOutput::created_by_iam_user): <p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    ///   - [`created_at(Option<DateTime>)`](crate::output::GetMlModelOutput::created_at): <p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>
    ///   - [`last_updated_at(Option<DateTime>)`](crate::output::GetMlModelOutput::last_updated_at): <p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>
    ///   - [`name(Option<String>)`](crate::output::GetMlModelOutput::name): <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    ///   - [`status(Option<EntityStatus>)`](crate::output::GetMlModelOutput::status): <p>The current status of the <code>MLModel</code>. This element can have one of the following values:</p>  <ul>   <li> <p> <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>.</p> </li>   <li> <p> <code>INPROGRESS</code> - The request is processing.</p> </li>   <li> <p> <code>FAILED</code> - The request did not run to completion. The ML model isn't usable.</p> </li>   <li> <p> <code>COMPLETED</code> - The request completed successfully.</p> </li>   <li> <p> <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't usable.</p> </li>  </ul>
    ///   - [`size_in_bytes(Option<i64>)`](crate::output::GetMlModelOutput::size_in_bytes): <p>Long integer type that is a 64-bit signed number.</p>
    ///   - [`endpoint_info(Option<RealtimeEndpointInfo>)`](crate::output::GetMlModelOutput::endpoint_info): <p>The current endpoint of the <code>MLModel</code> </p>
    ///   - [`training_parameters(Option<HashMap<String, String>>)`](crate::output::GetMlModelOutput::training_parameters): <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p>  <p>The following is the current set of training parameters:</p>  <ul>   <li> <p> <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li>   <li> <p> <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p> </li>   <li> <p> <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.</p> </li>   <li> <p> <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li>   <li> <p> <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li>  </ul>
    ///   - [`input_data_location_s3(Option<String>)`](crate::output::GetMlModelOutput::input_data_location_s3): <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    ///   - [`ml_model_type(Option<MlModelType>)`](crate::output::GetMlModelOutput::ml_model_type): <p>Identifies the <code>MLModel</code> category. The following are the available types: </p>  <ul>   <li> <p>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</p> </li>   <li> <p>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</p> </li>   <li> <p>MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"</p> </li>  </ul>
    ///   - [`score_threshold(Option<f32>)`](crate::output::GetMlModelOutput::score_threshold): <p>The scoring threshold is used in binary classification <code>MLModel</code> models. It marks the boundary between a positive prediction and a negative prediction.</p>  <p>Output values greater than or equal to the threshold receive a positive result from the MLModel, such as <code>true</code>. Output values less than the threshold receive a negative response from the MLModel, such as <code>false</code>.</p>
    ///   - [`score_threshold_last_updated_at(Option<DateTime>)`](crate::output::GetMlModelOutput::score_threshold_last_updated_at): <p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>
    ///   - [`log_uri(Option<String>)`](crate::output::GetMlModelOutput::log_uri): <p>A link to the file that contains logs of the <code>CreateMLModel</code> operation.</p>
    ///   - [`message(Option<String>)`](crate::output::GetMlModelOutput::message): <p>A description of the most recent details about accessing the <code>MLModel</code>.</p>
    ///   - [`compute_time(Option<i64>)`](crate::output::GetMlModelOutput::compute_time): <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.</p>
    ///   - [`finished_at(Option<DateTime>)`](crate::output::GetMlModelOutput::finished_at): <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    ///   - [`started_at(Option<DateTime>)`](crate::output::GetMlModelOutput::started_at): <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.</p>
    ///   - [`recipe(Option<String>)`](crate::output::GetMlModelOutput::recipe): <p>The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code> provides detailed information about the observation data to use during training, and manipulations to perform on the observation data during training.</p>  <p> <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    ///   - [`schema(Option<String>)`](crate::output::GetMlModelOutput::schema): <p>The schema used by all of the data files referenced by the <code>DataSource</code>.</p>  <p> <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    /// - On failure, responds with [`SdkError<GetMLModelError>`](crate::error::GetMLModelError)
    pub fn get_ml_model(&self) -> fluent_builders::GetMLModel {
        fluent_builders::GetMLModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`Predict`](crate::client::fluent_builders::Predict) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::Predict::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::Predict::set_ml_model_id): <p>A unique identifier of the <code>MLModel</code>.</p>
    ///   - [`record(HashMap<String, String>)`](crate::client::fluent_builders::Predict::record) / [`set_record(Option<HashMap<String, String>>)`](crate::client::fluent_builders::Predict::set_record): <p>A map of variable name-value pairs that represent an observation.</p>
    ///   - [`predict_endpoint(impl Into<String>)`](crate::client::fluent_builders::Predict::predict_endpoint) / [`set_predict_endpoint(Option<String>)`](crate::client::fluent_builders::Predict::set_predict_endpoint): (undocumented)
    /// - On success, responds with [`PredictOutput`](crate::output::PredictOutput) with field(s):
    ///   - [`prediction(Option<Prediction>)`](crate::output::PredictOutput::prediction): <p>The output from a <code>Predict</code> operation: </p>  <ul>   <li> <p> <code>Details</code> - Contains the following attributes: <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code> <code>DetailsAttributes.ALGORITHM - SGD</code> </p> </li>   <li> <p> <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code> <code>MLModel</code> request. </p> </li>   <li> <p> <code>PredictedScores</code> - Contains the raw classification score corresponding to each label. </p> </li>   <li> <p> <code>PredictedValue</code> - Present for a <code>REGRESSION</code> <code>MLModel</code> request. </p> </li>  </ul>
    /// - On failure, responds with [`SdkError<PredictError>`](crate::error::PredictError)
    pub fn predict(&self) -> fluent_builders::Predict {
        fluent_builders::Predict::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateBatchPrediction`](crate::client::fluent_builders::UpdateBatchPrediction) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`batch_prediction_id(impl Into<String>)`](crate::client::fluent_builders::UpdateBatchPrediction::batch_prediction_id) / [`set_batch_prediction_id(Option<String>)`](crate::client::fluent_builders::UpdateBatchPrediction::set_batch_prediction_id): <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
    ///   - [`batch_prediction_name(impl Into<String>)`](crate::client::fluent_builders::UpdateBatchPrediction::batch_prediction_name) / [`set_batch_prediction_name(Option<String>)`](crate::client::fluent_builders::UpdateBatchPrediction::set_batch_prediction_name): <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
    /// - On success, responds with [`UpdateBatchPredictionOutput`](crate::output::UpdateBatchPredictionOutput) with field(s):
    ///   - [`batch_prediction_id(Option<String>)`](crate::output::UpdateBatchPredictionOutput::batch_prediction_id): <p>The ID assigned to the <code>BatchPrediction</code> during creation. This value should be identical to the value of the <code>BatchPredictionId</code> in the request.</p>
    /// - On failure, responds with [`SdkError<UpdateBatchPredictionError>`](crate::error::UpdateBatchPredictionError)
    pub fn update_batch_prediction(&self) -> fluent_builders::UpdateBatchPrediction {
        fluent_builders::UpdateBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`data_source_id(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::data_source_id) / [`set_data_source_id(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_data_source_id): <p>The ID assigned to the <code>DataSource</code> during creation.</p>
    ///   - [`data_source_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDataSource::data_source_name) / [`set_data_source_name(Option<String>)`](crate::client::fluent_builders::UpdateDataSource::set_data_source_name): <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
    /// - On success, responds with [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput) with field(s):
    ///   - [`data_source_id(Option<String>)`](crate::output::UpdateDataSourceOutput::data_source_id): <p>The ID assigned to the <code>DataSource</code> during creation. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>
    /// - On failure, responds with [`SdkError<UpdateDataSourceError>`](crate::error::UpdateDataSourceError)
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateEvaluation`](crate::client::fluent_builders::UpdateEvaluation) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`evaluation_id(impl Into<String>)`](crate::client::fluent_builders::UpdateEvaluation::evaluation_id) / [`set_evaluation_id(Option<String>)`](crate::client::fluent_builders::UpdateEvaluation::set_evaluation_id): <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
    ///   - [`evaluation_name(impl Into<String>)`](crate::client::fluent_builders::UpdateEvaluation::evaluation_name) / [`set_evaluation_name(Option<String>)`](crate::client::fluent_builders::UpdateEvaluation::set_evaluation_name): <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
    /// - On success, responds with [`UpdateEvaluationOutput`](crate::output::UpdateEvaluationOutput) with field(s):
    ///   - [`evaluation_id(Option<String>)`](crate::output::UpdateEvaluationOutput::evaluation_id): <p>The ID assigned to the <code>Evaluation</code> during creation. This value should be identical to the value of the <code>Evaluation</code> in the request.</p>
    /// - On failure, responds with [`SdkError<UpdateEvaluationError>`](crate::error::UpdateEvaluationError)
    pub fn update_evaluation(&self) -> fluent_builders::UpdateEvaluation {
        fluent_builders::UpdateEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateMLModel`](crate::client::fluent_builders::UpdateMLModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ml_model_id(impl Into<String>)`](crate::client::fluent_builders::UpdateMLModel::ml_model_id) / [`set_ml_model_id(Option<String>)`](crate::client::fluent_builders::UpdateMLModel::set_ml_model_id): <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    ///   - [`ml_model_name(impl Into<String>)`](crate::client::fluent_builders::UpdateMLModel::ml_model_name) / [`set_ml_model_name(Option<String>)`](crate::client::fluent_builders::UpdateMLModel::set_ml_model_name): <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    ///   - [`score_threshold(f32)`](crate::client::fluent_builders::UpdateMLModel::score_threshold) / [`set_score_threshold(Option<f32>)`](crate::client::fluent_builders::UpdateMLModel::set_score_threshold): <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>  <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
    /// - On success, responds with [`UpdateMlModelOutput`](crate::output::UpdateMlModelOutput) with field(s):
    ///   - [`ml_model_id(Option<String>)`](crate::output::UpdateMlModelOutput::ml_model_id): <p>The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>
    /// - On failure, responds with [`SdkError<UpdateMLModelError>`](crate::error::UpdateMLModelError)
    pub fn update_ml_model(&self) -> fluent_builders::UpdateMLModel {
        fluent_builders::UpdateMLModel::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, <code>AddTags</code> updates the tag's value.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct AddTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl AddTags {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The type of the ML object to tag.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the ML object to tag.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchPrediction`.
    ///
    /// <p>Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a <code>DataSource</code>. This operation creates a new <code>BatchPrediction</code>, and uses an <code>MLModel</code> and the data files referenced by the <code>DataSource</code> as information sources. </p>
    /// <p> <code>CreateBatchPrediction</code> is an asynchronous operation. In response to <code>CreateBatchPrediction</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>BatchPrediction</code> status to <code>PENDING</code>. After the <code>BatchPrediction</code> completes, Amazon ML sets the status to <code>COMPLETED</code>. </p>
    /// <p>You can poll for status updates by using the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter of the result. After the <code>COMPLETED</code> status appears, the results are available in the location specified by the <code>OutputUri</code> parameter.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateBatchPrediction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_batch_prediction_input::Builder,
    }
    impl CreateBatchPrediction {
        /// Creates a new `CreateBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchPredictionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
        pub fn batch_prediction_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
        pub fn set_batch_prediction_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_name(input);
            self
        }
        /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
        pub fn batch_prediction_data_source_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.batch_prediction_data_source_id(input.into());
            self
        }
        /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
        pub fn set_batch_prediction_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_data_source_id(input);
            self
        }
        /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
        /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn output_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_uri(input.into());
            self
        }
        /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
        /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn set_output_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSourceFromRDS`.
    ///
    /// <p>Creates a <code>DataSource</code> object from an <a href="http://aws.amazon.com/rds/"> Amazon Relational Database Service</a> (Amazon RDS). A <code>DataSource</code> references data that can be used to perform <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p>
    /// <p> <code>CreateDataSourceFromRDS</code> is an asynchronous operation. In response to <code>CreateDataSourceFromRDS</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used only to perform <code>&gt;CreateMLModel</code>&gt;, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations. </p>
    /// <p> If Amazon ML cannot accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSourceFromRDS {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_source_from_rds_input::Builder,
    }
    impl CreateDataSourceFromRDS {
        /// Creates a new `CreateDataSourceFromRDS`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceFromRdsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceFromRDSError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN) becomes the ID for a <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN) becomes the ID for a <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p>DatabaseInformation -</p>
        /// <ul>
        /// <li> <p> <code>DatabaseName</code> - The name of the Amazon RDS database.</p> </li>
        /// <li> <p> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p> </li>
        /// </ul> </li>
        /// <li> <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p> </li>
        /// <li> <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p> </li>
        /// <li> <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p> </li>
        /// <li> <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p> </li>
        /// <li> <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p> </li>
        /// <li> <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p> </li>
        /// <li> <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>
        /// <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>
        /// <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>
        /// </ul>
        pub fn rds_data(mut self, input: crate::model::RdsDataSpec) -> Self {
            self.inner = self.inner.rds_data(input);
            self
        }
        /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p>DatabaseInformation -</p>
        /// <ul>
        /// <li> <p> <code>DatabaseName</code> - The name of the Amazon RDS database.</p> </li>
        /// <li> <p> <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p> </li>
        /// </ul> </li>
        /// <li> <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p> </li>
        /// <li> <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p> </li>
        /// <li> <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p> </li>
        /// <li> <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p> </li>
        /// <li> <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p> </li>
        /// <li> <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p> </li>
        /// <li> <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>
        /// <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>
        /// <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>
        /// </ul>
        pub fn set_rds_data(
            mut self,
            input: std::option::Option<crate::model::RdsDataSpec>,
        ) -> Self {
            self.inner = self.inner.set_rds_data(input);
            self
        }
        /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
        /// <p></p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
        /// <p></p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training. </p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.inner = self.inner.compute_statistics(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training. </p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_compute_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSourceFromRedshift`.
    ///
    /// <p>Creates a <code>DataSource</code> from a database hosted on an Amazon Redshift cluster. A <code>DataSource</code> references data that can be used to perform either <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p>
    /// <p> <code>CreateDataSourceFromRedshift</code> is an asynchronous operation. In response to <code>CreateDataSourceFromRedshift</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> is created and ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in <code>COMPLETED</code> or <code>PENDING</code> states can be used to perform only <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations. </p>
    /// <p> If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response. </p>
    /// <p>The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a <code>SelectSqlQuery</code> query. Amazon ML executes an <code>Unload</code> command in Amazon Redshift to transfer the result set of the <code>SelectSqlQuery</code> query to <code>S3StagingLocation</code>.</p>
    /// <p>After the <code>DataSource</code> has been created, it's ready for use in evaluations and batch predictions. If you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also requires a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.</p>
    /// <p>You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call <code>GetDataSource</code> for an existing datasource and copy the values to a <code>CreateDataSource</code> call. Change the settings that you want to change and make sure that all required fields have the appropriate values.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSourceFromRedshift {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_source_from_redshift_input::Builder,
    }
    impl CreateDataSourceFromRedshift {
        /// Creates a new `CreateDataSourceFromRedshift`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceFromRedshiftOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceFromRedshiftError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p>DatabaseInformation -</p>
        /// <ul>
        /// <li> <p> <code>DatabaseName</code> - The name of the Amazon Redshift database.</p> </li>
        /// <li> <p> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p> </li>
        /// </ul> </li>
        /// <li> <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p> </li>
        /// <li> <p>SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.</p> </li>
        /// <li> <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this location.</p> </li>
        /// <li> <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>
        /// <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>
        /// <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>
        /// </ul>
        pub fn data_spec(mut self, input: crate::model::RedshiftDataSpec) -> Self {
            self.inner = self.inner.data_spec(input);
            self
        }
        /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p>DatabaseInformation -</p>
        /// <ul>
        /// <li> <p> <code>DatabaseName</code> - The name of the Amazon Redshift database.</p> </li>
        /// <li> <p> <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p> </li>
        /// </ul> </li>
        /// <li> <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p> </li>
        /// <li> <p>SelectSqlQuery - The query that is used to retrieve the observation data for the <code>Datasource</code>.</p> </li>
        /// <li> <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon Redshift data. The data retrieved from Amazon Redshift using the <code>SelectSqlQuery</code> query is stored in this location.</p> </li>
        /// <li> <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>
        /// <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>
        /// <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>
        /// </ul>
        pub fn set_data_spec(
            mut self,
            input: std::option::Option<crate::model::RedshiftDataSpec>,
        ) -> Self {
            self.inner = self.inner.set_data_spec(input);
            self
        }
        /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
        /// <ul>
        /// <li> <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p> </li>
        /// <li> <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code> </p> </li>
        /// </ul>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(input.into());
            self
        }
        /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
        /// <ul>
        /// <li> <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p> </li>
        /// <li> <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code> </p> </li>
        /// </ul>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for <code>MLModel</code> training.</p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.inner = self.inner.compute_statistics(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to be used for <code>MLModel</code> training.</p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_compute_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSourceFromS3`.
    ///
    /// <p>Creates a <code>DataSource</code> object. A <code>DataSource</code> references data that can be used to perform <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p>
    /// <p> <code>CreateDataSourceFromS3</code> is an asynchronous operation. In response to <code>CreateDataSourceFromS3</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the <code>DataSource</code> has been created and is ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can be used to perform only <code>CreateMLModel</code>, <code>CreateEvaluation</code> or <code>CreateBatchPrediction</code> operations. </p>
    /// <p> If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response. </p>
    /// <p>The observation data used in a <code>DataSource</code> should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the <code>DataSource</code>. </p>
    /// <p>After the <code>DataSource</code> has been created, it's ready to use in evaluations and batch predictions. If you plan to use the <code>DataSource</code> to train an <code>MLModel</code>, the <code>DataSource</code> also needs a recipe. A recipe describes how each input variable will be used in training an <code>MLModel</code>. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataSourceFromS3 {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_data_source_from_s3_input::Builder,
    }
    impl CreateDataSourceFromS3 {
        /// Creates a new `CreateDataSourceFromS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceFromS3Output,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceFromS3Error>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The data specification of a <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p>DataLocationS3 - The Amazon S3 location of the observation data.</p> </li>
        /// <li> <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>
        /// <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>
        /// <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>
        /// </ul>
        pub fn data_spec(mut self, input: crate::model::S3DataSpec) -> Self {
            self.inner = self.inner.data_spec(input);
            self
        }
        /// <p>The data specification of a <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p>DataLocationS3 - The Amazon S3 location of the observation data.</p> </li>
        /// <li> <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p> </li>
        /// <li> <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p> </li>
        /// <li> <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p> <p> Sample - <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code> </p> </li>
        /// </ul>
        pub fn set_data_spec(
            mut self,
            input: std::option::Option<crate::model::S3DataSpec>,
        ) -> Self {
            self.inner = self.inner.set_data_spec(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.inner = self.inner.compute_statistics(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training. This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_compute_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEvaluation`.
    ///
    /// <p>Creates a new <code>Evaluation</code> of an <code>MLModel</code>. An <code>MLModel</code> is evaluated on a set of observations associated to a <code>DataSource</code>. Like a <code>DataSource</code> for an <code>MLModel</code>, the <code>DataSource</code> for an <code>Evaluation</code> contains values for the <code>Target Variable</code>. The <code>Evaluation</code> compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the <code>MLModel</code> functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding <code>MLModelType</code>: <code>BINARY</code>, <code>REGRESSION</code> or <code>MULTICLASS</code>. </p>
    /// <p> <code>CreateEvaluation</code> is an asynchronous operation. In response to <code>CreateEvaluation</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to <code>PENDING</code>. After the <code>Evaluation</code> is created and ready for use, Amazon ML sets the status to <code>COMPLETED</code>. </p>
    /// <p>You can use the <code>GetEvaluation</code> operation to check progress of the evaluation during the creation operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateEvaluation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_evaluation_input::Builder,
    }
    impl CreateEvaluation {
        /// Creates a new `CreateEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEvaluationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
        pub fn evaluation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
        pub fn set_evaluation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_name(input);
            self
        }
        /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
        /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
        /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must match the schema used to create the <code>MLModel</code>.</p>
        pub fn evaluation_data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_data_source_id(input.into());
            self
        }
        /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code> must match the schema used to create the <code>MLModel</code>.</p>
        pub fn set_evaluation_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMLModel`.
    ///
    /// <p>Creates a new <code>MLModel</code> using the <code>DataSource</code> and the recipe as information sources. </p>
    /// <p>An <code>MLModel</code> is nearly immutable. Users can update only the <code>MLModelName</code> and the <code>ScoreThreshold</code> in an <code>MLModel</code> without creating a new <code>MLModel</code>. </p>
    /// <p> <code>CreateMLModel</code> is an asynchronous operation. In response to <code>CreateMLModel</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>MLModel</code> status to <code>PENDING</code>. After the <code>MLModel</code> has been created and ready is for use, Amazon ML sets the status to <code>COMPLETED</code>. </p>
    /// <p>You can use the <code>GetMLModel</code> operation to check the progress of the <code>MLModel</code> during the creation operation.</p>
    /// <p> <code>CreateMLModel</code> requires a <code>DataSource</code> with computed statistics, which can be created by setting <code>ComputeStatistics</code> to <code>true</code> in <code>CreateDataSourceFromRDS</code>, <code>CreateDataSourceFromS3</code>, or <code>CreateDataSourceFromRedshift</code> operations. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateMLModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_ml_model_input::Builder,
    }
    impl CreateMLModel {
        /// Creates a new `CreateMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMLModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn ml_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_ml_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ml_model_name(input);
            self
        }
        /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
        /// <ul>
        /// <li> <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p> </li>
        /// <li> <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p> </li>
        /// <li> <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p> </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn ml_model_type(mut self, input: crate::model::MlModelType) -> Self {
            self.inner = self.inner.ml_model_type(input);
            self
        }
        /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
        /// <ul>
        /// <li> <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p> </li>
        /// <li> <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p> </li>
        /// <li> <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p> </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn set_ml_model_type(
            mut self,
            input: std::option::Option<crate::model::MlModelType>,
        ) -> Self {
            self.inner = self.inner.set_ml_model_type(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li> <p> <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li>
        /// <li> <p> <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p> </li>
        /// <li> <p> <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.</p> </li>
        /// <li> <p> <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li>
        /// <li> <p> <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k.into(), v.into());
            self
        }
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li> <p> <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the input data, the size of the model might affect its performance.</p> <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p> </li>
        /// <li> <p> <code>sgd.maxPasses</code> - The number of times that the training process traverses the observations to build the <code>MLModel</code>. The value is an integer that ranges from <code>1</code> to <code>10000</code>. The default value is <code>10</code>.</p> </li>
        /// <li> <p> <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling the data improves a model's ability to find the optimal solution for a variety of data types. The valid values are <code>auto</code> and <code>none</code>. The default value is <code>none</code>. We strongly recommend that you shuffle your data.</p> </li>
        /// <li> <p> <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to zero, resulting in a sparse feature set. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L1 normalization. This parameter can't be used when <code>L2</code> is specified. Use this parameter sparingly.</p> </li>
        /// <li> <p> <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls overfitting the data by penalizing large coefficients. This tends to drive coefficients to small, nonzero values. If you use this parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p> <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>. The default is to not use L2 normalization. This parameter can't be used when <code>L1</code> is specified. Use this parameter sparingly.</p> </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The <code>DataSource</code> that points to the training data.</p>
        pub fn training_data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.training_data_source_id(input.into());
            self
        }
        /// <p>The <code>DataSource</code> that points to the training data.</p>
        pub fn set_training_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_training_data_source_id(input);
            self
        }
        /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn recipe(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe(input.into());
            self
        }
        /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn set_recipe(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe(input);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn recipe_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_uri(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn set_recipe_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRealtimeEndpoint`.
    ///
    /// <p>Creates a real-time endpoint for the <code>MLModel</code>. The endpoint contains the URI of the <code>MLModel</code>; that is, the location to send real-time prediction requests for the specified <code>MLModel</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateRealtimeEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_realtime_endpoint_input::Builder,
    }
    impl CreateRealtimeEndpoint {
        /// Creates a new `CreateRealtimeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRealtimeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRealtimeEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBatchPrediction`.
    ///
    /// <p>Assigns the DELETED status to a <code>BatchPrediction</code>, rendering it unusable.</p>
    /// <p>After using the <code>DeleteBatchPrediction</code> operation, you can use the <code>GetBatchPrediction</code> operation to verify that the status of the <code>BatchPrediction</code> changed to DELETED.</p>
    /// <p> <b>Caution:</b> The result of the <code>DeleteBatchPrediction</code> operation is irreversible.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteBatchPrediction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_batch_prediction_input::Builder,
    }
    impl DeleteBatchPrediction {
        /// Creates a new `DeleteBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBatchPredictionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Assigns the DELETED status to a <code>DataSource</code>, rendering it unusable.</p>
    /// <p>After using the <code>DeleteDataSource</code> operation, you can use the <code>GetDataSource</code> operation to verify that the status of the <code>DataSource</code> changed to DELETED.</p>
    /// <p> <b>Caution:</b> The results of the <code>DeleteDataSource</code> operation are irreversible.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl DeleteDataSource {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEvaluation`.
    ///
    /// <p>Assigns the <code>DELETED</code> status to an <code>Evaluation</code>, rendering it unusable.</p>
    /// <p>After invoking the <code>DeleteEvaluation</code> operation, you can use the <code>GetEvaluation</code> operation to verify that the status of the <code>Evaluation</code> changed to <code>DELETED</code>.</p>
    /// <p> <b>Caution:</b> The results of the <code>DeleteEvaluation</code> operation are irreversible.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteEvaluation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_evaluation_input::Builder,
    }
    impl DeleteEvaluation {
        /// Creates a new `DeleteEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEvaluationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMLModel`.
    ///
    /// <p>Assigns the <code>DELETED</code> status to an <code>MLModel</code>, rendering it unusable.</p>
    /// <p>After using the <code>DeleteMLModel</code> operation, you can use the <code>GetMLModel</code> operation to verify that the status of the <code>MLModel</code> changed to DELETED.</p>
    /// <p> <b>Caution:</b> The result of the <code>DeleteMLModel</code> operation is irreversible.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteMLModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_ml_model_input::Builder,
    }
    impl DeleteMLModel {
        /// Creates a new `DeleteMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMLModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRealtimeEndpoint`.
    ///
    /// <p>Deletes a real time endpoint of an <code>MLModel</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteRealtimeEndpoint {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_realtime_endpoint_input::Builder,
    }
    impl DeleteRealtimeEndpoint {
        /// Creates a new `DeleteRealtimeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRealtimeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRealtimeEndpointError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.</p>
    /// <p>If you specify a tag that doesn't exist, Amazon ML ignores it.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl DeleteTags {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tags to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>One or more tags to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBatchPredictions`.
    ///
    /// <p>Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeBatchPredictions {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_batch_predictions_input::Builder,
    }
    impl DescribeBatchPredictions {
        /// Creates a new `DescribeBatchPredictions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBatchPredictionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBatchPredictionsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeBatchPredictionsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeBatchPredictionsPaginator {
            crate::paginator::DescribeBatchPredictionsPaginator::new(self.handle, self.inner)
        }
        /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code> <b> </b> <code>Name</code>.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p> </li>
        /// <li> <p> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p> </li>
        /// <li> <p> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p> </li>
        /// <li> <p> <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p> </li>
        /// </ul>
        pub fn filter_variable(
            mut self,
            input: crate::model::BatchPredictionFilterVariable,
        ) -> Self {
            self.inner = self.inner.filter_variable(input);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code> <b> </b> <code>Name</code>.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p> </li>
        /// <li> <p> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p> </li>
        /// <li> <p> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p> </li>
        /// <li> <p> <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p> </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::BatchPredictionFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(input.into());
            self
        }
        /// <p>The equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(input.into());
            self
        }
        /// <p>The greater than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(input.into());
            self
        }
        /// <p>The less than operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>An ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>An ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSources`.
    ///
    /// <p>Returns a list of <code>DataSource</code> that match the search criteria in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataSources {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_data_sources_input::Builder,
    }
    impl DescribeDataSources {
        /// Creates a new `DescribeDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourcesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeDataSourcesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeDataSourcesPaginator {
            crate::paginator::DescribeDataSourcesPaginator::new(self.handle, self.inner)
        }
        /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.</p> </li>
        /// <li> <p> <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p> </li>
        /// </ul>
        pub fn filter_variable(mut self, input: crate::model::DataSourceFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(input);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code> <code>Name</code>.</p> </li>
        /// <li> <p> <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p> </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::DataSourceFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(input.into());
            self
        }
        /// <p>The equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(input.into());
            self
        }
        /// <p>The greater than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(input.into());
            self
        }
        /// <p>The less than operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>DataSource</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>DataSource</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvaluations`.
    ///
    /// <p>Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeEvaluations {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_evaluations_input::Builder,
    }
    impl DescribeEvaluations {
        /// Creates a new `DescribeEvaluations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEvaluationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEvaluationsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeEvaluationsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeEvaluationsPaginator {
            crate::paginator::DescribeEvaluationsPaginator::new(self.handle, self.inner)
        }
        /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b> <code>Name</code>.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p> </li>
        /// <li> <p> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p> </li>
        /// <li> <p> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p> </li>
        /// <li> <p> <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p> </li>
        /// </ul>
        pub fn filter_variable(mut self, input: crate::model::EvaluationFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(input);
            self
        }
        /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code> <b> </b> <code>Name</code>.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p> </li>
        /// <li> <p> <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p> </li>
        /// <li> <p> <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p> </li>
        /// <li> <p> <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p> </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::EvaluationFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(input.into());
            self
        }
        /// <p>The equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(input.into());
            self
        }
        /// <p>The greater than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(input.into());
            self
        }
        /// <p>The less than operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMLModels`.
    ///
    /// <p>Returns a list of <code>MLModel</code> that match the search criteria in the request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeMLModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_ml_models_input::Builder,
    }
    impl DescribeMLModels {
        /// Creates a new `DescribeMLModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMlModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMLModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::DescribeMlModelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::DescribeMlModelsPaginator {
            crate::paginator::DescribeMlModelsPaginator::new(self.handle, self.inner)
        }
        /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code> <b> </b> <code>Name</code>.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p> </li>
        /// <li> <p> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p> </li>
        /// <li> <p> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p> </li>
        /// <li> <p> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p> </li>
        /// <li> <p> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p> </li>
        /// <li> <p> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p> </li>
        /// </ul>
        pub fn filter_variable(mut self, input: crate::model::MlModelFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(input);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
        /// <ul>
        /// <li> <p> <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p> </li>
        /// <li> <p> <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p> </li>
        /// <li> <p> <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code> <b> </b> <code>Name</code>.</p> </li>
        /// <li> <p> <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p> </li>
        /// <li> <p> <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p> </li>
        /// <li> <p> <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p> </li>
        /// <li> <p> <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p> </li>
        /// <li> <p> <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p> </li>
        /// <li> <p> <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p> </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::MlModelFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(input.into());
            self
        }
        /// <p>The equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(input.into());
            self
        }
        /// <p>The greater than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(input.into());
            self
        }
        /// <p>The less than operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>. </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>MLModel</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>MLModel</code> could have the <code>Name</code> <code>2014-09-09-HolidayGiftMailer</code>. To search for this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the <code>Prefix</code>: </p>
        /// <ul>
        /// <li> <p>2014-09</p> </li>
        /// <li> <p>2014-09-09</p> </li>
        /// <li> <p>2014-09-09-Holiday</p> </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
        /// <ul>
        /// <li> <p> <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p> </li>
        /// <li> <p> <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p> </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.inner = self.inner.limit(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes one or more of the tags for your Amazon ML object.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeTags {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl DescribeTags {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(input.into());
            self
        }
        /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The type of the ML object.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.inner = self.inner.resource_type(input);
            self
        }
        /// <p>The type of the ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBatchPrediction`.
    ///
    /// <p>Returns a <code>BatchPrediction</code> that includes detailed metadata, status, and data file information for a <code>Batch Prediction</code> request.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetBatchPrediction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_batch_prediction_input::Builder,
    }
    impl GetBatchPrediction {
        /// Creates a new `GetBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBatchPredictionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(input.into());
            self
        }
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataSource`.
    ///
    /// <p>Returns a <code>DataSource</code> that includes metadata and data file information, as well as the current status of the <code>DataSource</code>.</p>
    /// <p> <code>GetDataSource</code> provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_data_source_input::Builder,
    }
    impl GetDataSource {
        /// Creates a new `GetDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
        /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
        /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
        pub fn verbose(mut self, input: bool) -> Self {
            self.inner = self.inner.verbose(input);
            self
        }
        /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
        /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
        /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_verbose(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvaluation`.
    ///
    /// <p>Returns an <code>Evaluation</code> that includes metadata as well as the current status of the <code>Evaluation</code>.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetEvaluation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_evaluation_input::Builder,
    }
    impl GetEvaluation {
        /// Creates a new `GetEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvaluationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(input.into());
            self
        }
        /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMLModel`.
    ///
    /// <p>Returns an <code>MLModel</code> that includes detailed metadata, data source information, and the current status of the <code>MLModel</code>.</p>
    /// <p> <code>GetMLModel</code> provides results in normal or verbose format. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct GetMLModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::get_ml_model_input::Builder,
    }
    impl GetMLModel {
        /// Creates a new `GetMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMLModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
        /// <p>If true, <code>Recipe</code> is returned.</p>
        /// <p>If false, <code>Recipe</code> is not returned.</p>
        pub fn verbose(mut self, input: bool) -> Self {
            self.inner = self.inner.verbose(input);
            self
        }
        /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
        /// <p>If true, <code>Recipe</code> is returned.</p>
        /// <p>If false, <code>Recipe</code> is not returned.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_verbose(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Predict`.
    ///
    /// <p>Generates a prediction for the observation using the specified <code>ML Model</code>.</p>
    /// <p> <b>Note:</b> Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct Predict {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::predict_input::Builder,
    }
    impl Predict {
        /// Creates a new `Predict`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PredictOutput,
            aws_smithy_http::result::SdkError<crate::error::PredictError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier of the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>A unique identifier of the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// Adds a key-value pair to `Record`.
        ///
        /// To override the contents of this collection use [`set_record`](Self::set_record).
        ///
        /// <p>A map of variable name-value pairs that represent an observation.</p>
        pub fn record(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.record(k.into(), v.into());
            self
        }
        /// <p>A map of variable name-value pairs that represent an observation.</p>
        pub fn set_record(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_record(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn predict_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predict_endpoint(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_predict_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predict_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBatchPrediction`.
    ///
    /// <p>Updates the <code>BatchPredictionName</code> of a <code>BatchPrediction</code>.</p>
    /// <p>You can use the <code>GetBatchPrediction</code> operation to view the contents of the updated data element.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateBatchPrediction {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_batch_prediction_input::Builder,
    }
    impl UpdateBatchPrediction {
        /// Creates a new `UpdateBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBatchPredictionError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
        /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_name(input.into());
            self
        }
        /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates the <code>DataSourceName</code> of a <code>DataSource</code>.</p>
    /// <p>You can use the <code>GetDataSource</code> operation to view the contents of the updated data element.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDataSource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl UpdateDataSource {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(input.into());
            self
        }
        /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEvaluation`.
    ///
    /// <p>Updates the <code>EvaluationName</code> of an <code>Evaluation</code>.</p>
    /// <p>You can use the <code>GetEvaluation</code> operation to view the contents of the updated data element.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateEvaluation {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_evaluation_input::Builder,
    }
    impl UpdateEvaluation {
        /// Creates a new `UpdateEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEvaluationError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
        /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
        pub fn evaluation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_name(input.into());
            self
        }
        /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
        pub fn set_evaluation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMLModel`.
    ///
    /// <p>Updates the <code>MLModelName</code> and the <code>ScoreThreshold</code> of an <code>MLModel</code>.</p>
    /// <p>You can use the <code>GetMLModel</code> operation to view the contents of the updated data element.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateMLModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_ml_model_input::Builder,
    }
    impl UpdateMLModel {
        /// Creates a new `UpdateMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMLModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn ml_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_name(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_ml_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ml_model_name(input);
            self
        }
        /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
        /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
        pub fn score_threshold(mut self, input: f32) -> Self {
            self.inner = self.inner.score_threshold(input);
            self
        }
        /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
        /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
        pub fn set_score_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_score_threshold(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(sdk_config: &aws_types::sdk_config::SdkConfig) -> Self {
        Self::from_conf(sdk_config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
