// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// <p>Represents the output of an <code>UpdateMLModel</code> operation.</p>
/// <p>You can see the updated content by using the <code>GetMLModel</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMlModelOutput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.  This value should be identical to the value
    /// of the <code>MLModelID</code> in the request.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
}
impl UpdateMlModelOutput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.  This value should be identical to the value
    /// of the <code>MLModelID</code> in the request.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateMlModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMlModelOutput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.finish()
    }
}
/// See [`UpdateMlModelOutput`](crate::output::UpdateMlModelOutput)
pub mod update_ml_model_output {
    /// A builder for [`UpdateMlModelOutput`](crate::output::UpdateMlModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>MLModel</code> during creation.  This value should be identical to the value
        /// of the <code>MLModelID</code> in the request.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.  This value should be identical to the value
        /// of the <code>MLModelID</code> in the request.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMlModelOutput`](crate::output::UpdateMlModelOutput)
        pub fn build(self) -> crate::output::UpdateMlModelOutput {
            crate::output::UpdateMlModelOutput {
                ml_model_id: self.ml_model_id,
            }
        }
    }
}
impl UpdateMlModelOutput {
    /// Creates a new builder-style object to manufacture [`UpdateMlModelOutput`](crate::output::UpdateMlModelOutput)
    pub fn builder() -> crate::output::update_ml_model_output::Builder {
        crate::output::update_ml_model_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>UpdateEvaluation</code> operation.</p>
/// <p>You can see the updated content by using the <code>GetEvaluation</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEvaluationOutput {
    /// <p>The ID assigned to the <code>Evaluation</code> during creation.  This value should be identical to the value
    /// of the <code>Evaluation</code> in the request.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
}
impl UpdateEvaluationOutput {
    /// <p>The ID assigned to the <code>Evaluation</code> during creation.  This value should be identical to the value
    /// of the <code>Evaluation</code> in the request.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateEvaluationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEvaluationOutput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.finish()
    }
}
/// See [`UpdateEvaluationOutput`](crate::output::UpdateEvaluationOutput)
pub mod update_evaluation_output {
    /// A builder for [`UpdateEvaluationOutput`](crate::output::UpdateEvaluationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.  This value should be identical to the value
        /// of the <code>Evaluation</code> in the request.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.  This value should be identical to the value
        /// of the <code>Evaluation</code> in the request.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEvaluationOutput`](crate::output::UpdateEvaluationOutput)
        pub fn build(self) -> crate::output::UpdateEvaluationOutput {
            crate::output::UpdateEvaluationOutput {
                evaluation_id: self.evaluation_id,
            }
        }
    }
}
impl UpdateEvaluationOutput {
    /// Creates a new builder-style object to manufacture [`UpdateEvaluationOutput`](crate::output::UpdateEvaluationOutput)
    pub fn builder() -> crate::output::update_evaluation_output::Builder {
        crate::output::update_evaluation_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>UpdateDataSource</code> operation.</p>
/// <p>You can see the updated content by using the <code>GetBatchPrediction</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSourceOutput {
    /// <p>The ID assigned to the <code>DataSource</code> during creation.  This value should be identical to the value
    /// of the <code>DataSourceID</code> in the request.</p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl UpdateDataSourceOutput {
    /// <p>The ID assigned to the <code>DataSource</code> during creation.  This value should be identical to the value
    /// of the <code>DataSourceID</code> in the request.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSourceOutput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
pub mod update_data_source_output {
    /// A builder for [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>DataSource</code> during creation.  This value should be identical to the value
        /// of the <code>DataSourceID</code> in the request.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> during creation.  This value should be identical to the value
        /// of the <code>DataSourceID</code> in the request.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
        pub fn build(self) -> crate::output::UpdateDataSourceOutput {
            crate::output::UpdateDataSourceOutput {
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl UpdateDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceOutput`](crate::output::UpdateDataSourceOutput)
    pub fn builder() -> crate::output::update_data_source_output::Builder {
        crate::output::update_data_source_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>UpdateBatchPrediction</code> operation.</p>
/// <p>You can see the updated content by using the <code>GetBatchPrediction</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBatchPredictionOutput {
    /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.  This value should be identical to the value
    /// of the <code>BatchPredictionId</code> in the request.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
}
impl UpdateBatchPredictionOutput {
    /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.  This value should be identical to the value
    /// of the <code>BatchPredictionId</code> in the request.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
}
impl std::fmt::Debug for UpdateBatchPredictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBatchPredictionOutput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.finish()
    }
}
/// See [`UpdateBatchPredictionOutput`](crate::output::UpdateBatchPredictionOutput)
pub mod update_batch_prediction_output {
    /// A builder for [`UpdateBatchPredictionOutput`](crate::output::UpdateBatchPredictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.  This value should be identical to the value
        /// of the <code>BatchPredictionId</code> in the request.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.  This value should be identical to the value
        /// of the <code>BatchPredictionId</code> in the request.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBatchPredictionOutput`](crate::output::UpdateBatchPredictionOutput)
        pub fn build(self) -> crate::output::UpdateBatchPredictionOutput {
            crate::output::UpdateBatchPredictionOutput {
                batch_prediction_id: self.batch_prediction_id,
            }
        }
    }
}
impl UpdateBatchPredictionOutput {
    /// Creates a new builder-style object to manufacture [`UpdateBatchPredictionOutput`](crate::output::UpdateBatchPredictionOutput)
    pub fn builder() -> crate::output::update_batch_prediction_output::Builder {
        crate::output::update_batch_prediction_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictOutput {
    /// <p>The output from a <code>Predict</code> operation: </p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Details</code> - Contains the following attributes:
    /// <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code>
    /// <code>DetailsAttributes.ALGORITHM - SGD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code>
    /// <code>MLModel</code> request.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictedScores</code> - Contains the raw classification score corresponding to each label.
    /// </p>        
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictedValue</code> - Present for a <code>REGRESSION</code>
    /// <code>MLModel</code> request.
    /// </p>        
    /// </li>
    /// </ul>
    pub prediction: std::option::Option<crate::model::Prediction>,
}
impl PredictOutput {
    /// <p>The output from a <code>Predict</code> operation: </p>
    ///
    /// <ul>
    /// <li>
    /// <p>
    /// <code>Details</code> - Contains the following attributes:
    /// <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code>
    /// <code>DetailsAttributes.ALGORITHM - SGD</code>
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code>
    /// <code>MLModel</code> request.
    /// </p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictedScores</code> - Contains the raw classification score corresponding to each label.
    /// </p>        
    /// </li>
    /// <li>
    /// <p>
    /// <code>PredictedValue</code> - Present for a <code>REGRESSION</code>
    /// <code>MLModel</code> request.
    /// </p>        
    /// </li>
    /// </ul>
    pub fn prediction(&self) -> std::option::Option<&crate::model::Prediction> {
        self.prediction.as_ref()
    }
}
impl std::fmt::Debug for PredictOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictOutput");
        formatter.field("prediction", &self.prediction);
        formatter.finish()
    }
}
/// See [`PredictOutput`](crate::output::PredictOutput)
pub mod predict_output {
    /// A builder for [`PredictOutput`](crate::output::PredictOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) prediction: std::option::Option<crate::model::Prediction>,
    }
    impl Builder {
        /// <p>The output from a <code>Predict</code> operation: </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Details</code> - Contains the following attributes:
        /// <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code>
        /// <code>DetailsAttributes.ALGORITHM - SGD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code>
        /// <code>MLModel</code> request.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictedScores</code> - Contains the raw classification score corresponding to each label.
        /// </p>        
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictedValue</code> - Present for a <code>REGRESSION</code>
        /// <code>MLModel</code> request.
        /// </p>        
        /// </li>
        /// </ul>
        pub fn prediction(mut self, input: crate::model::Prediction) -> Self {
            self.prediction = Some(input);
            self
        }
        /// <p>The output from a <code>Predict</code> operation: </p>
        ///
        /// <ul>
        /// <li>
        /// <p>
        /// <code>Details</code> - Contains the following attributes:
        /// <code>DetailsAttributes.PREDICTIVE_MODEL_TYPE - REGRESSION | BINARY | MULTICLASS</code>
        /// <code>DetailsAttributes.ALGORITHM - SGD</code>
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictedLabel</code> - Present for either a <code>BINARY</code> or <code>MULTICLASS</code>
        /// <code>MLModel</code> request.
        /// </p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictedScores</code> - Contains the raw classification score corresponding to each label.
        /// </p>        
        /// </li>
        /// <li>
        /// <p>
        /// <code>PredictedValue</code> - Present for a <code>REGRESSION</code>
        /// <code>MLModel</code> request.
        /// </p>        
        /// </li>
        /// </ul>
        pub fn set_prediction(
            mut self,
            input: std::option::Option<crate::model::Prediction>,
        ) -> Self {
            self.prediction = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictOutput`](crate::output::PredictOutput)
        pub fn build(self) -> crate::output::PredictOutput {
            crate::output::PredictOutput {
                prediction: self.prediction,
            }
        }
    }
}
impl PredictOutput {
    /// Creates a new builder-style object to manufacture [`PredictOutput`](crate::output::PredictOutput)
    pub fn builder() -> crate::output::predict_output::Builder {
        crate::output::predict_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetMLModel</code> operation, and provides detailed information about a <code>MLModel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMlModelOutput {
    /// <p>The MLModel ID,
    /// which is same as the <code>MLModelId</code> in the request.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The ID of the training <code>DataSource</code>.</p>
    pub training_data_source_id: std::option::Option<std::string::String>,
    /// <p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub created_by_iam_user: std::option::Option<std::string::String>,
    /// <p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The request is processing.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request did not run to completion. The ML model isn't
    /// usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The request completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't
    /// usable.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EntityStatus>,
    /// <p>Long integer type that is a 64-bit signed number.</p>
    pub size_in_bytes: std::option::Option<i64>,
    /// <p>The current endpoint of the <code>MLModel</code>
    /// </p>
    pub endpoint_info: std::option::Option<crate::model::RealtimeEndpointInfo>,
    /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
    /// a map of key-value pairs.</p>
    /// <p>The following is the current set of training parameters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
    /// input data, the size of the model might affect its performance.</p>
    /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
    /// observations to build the <code>MLModel</code>. The value is an integer that
    /// ranges from <code>1</code> to <code>10000</code>. The default value is
    /// <code>10</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
    /// model's ability to find the optimal solution for a variety of data types. The
    /// valid values are <code>auto</code> and <code>none</code>. The default value is
    /// <code>none</code>. We strongly recommend that you shuffle your data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to zero, resulting in a sparse feature set. If you use this
    /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L1 normalization. This parameter can't be used when
    /// <code>L2</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to small, nonzero values. If you use this parameter, start by
    /// specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L2 normalization. This parameter can't be used when
    /// <code>L1</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// </ul>
    pub training_parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub input_data_location_s3: std::option::Option<std::string::String>,
    /// <p>Identifies the <code>MLModel</code> category. The following are the available types: </p>
    /// <ul>
    /// <li>
    /// <p>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</p>
    /// </li>
    /// <li>
    /// <p>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</p>
    /// </li>
    /// <li>
    /// <p>MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"</p>
    /// </li>
    /// </ul>
    pub ml_model_type: std::option::Option<crate::model::MlModelType>,
    /// <p>The scoring threshold is used in binary classification <code>MLModel</code>
    /// models. It marks the boundary between a positive prediction and a
    /// negative prediction.</p>
    /// <p>Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
    /// <code>true</code>. Output values less than the threshold receive a negative response from the MLModel,
    /// such as <code>false</code>.</p>
    pub score_threshold: std::option::Option<f32>,
    /// <p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>
    pub score_threshold_last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A link to the file that contains logs of the <code>CreateMLModel</code> operation.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>A description of the most recent details about accessing the <code>MLModel</code>.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.</p>
    pub compute_time: std::option::Option<i64>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub finished_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code>
    /// provides detailed information about the observation data to use during training, and
    /// manipulations to perform on the observation data during training.</p>
    /// <p>
    /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    pub recipe: std::option::Option<std::string::String>,
    /// <p>The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
    /// <p>
    /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    pub schema: std::option::Option<std::string::String>,
}
impl GetMlModelOutput {
    /// <p>The MLModel ID,
    /// which is same as the <code>MLModelId</code> in the request.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The ID of the training <code>DataSource</code>.</p>
    pub fn training_data_source_id(&self) -> std::option::Option<&str> {
        self.training_data_source_id.as_deref()
    }
    /// <p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub fn created_by_iam_user(&self) -> std::option::Option<&str> {
        self.created_by_iam_user.as_deref()
    }
    /// <p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The request is processing.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request did not run to completion. The ML model isn't
    /// usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The request completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't
    /// usable.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EntityStatus> {
        self.status.as_ref()
    }
    /// <p>Long integer type that is a 64-bit signed number.</p>
    pub fn size_in_bytes(&self) -> std::option::Option<i64> {
        self.size_in_bytes
    }
    /// <p>The current endpoint of the <code>MLModel</code>
    /// </p>
    pub fn endpoint_info(&self) -> std::option::Option<&crate::model::RealtimeEndpointInfo> {
        self.endpoint_info.as_ref()
    }
    /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
    /// a map of key-value pairs.</p>
    /// <p>The following is the current set of training parameters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
    /// input data, the size of the model might affect its performance.</p>
    /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
    /// observations to build the <code>MLModel</code>. The value is an integer that
    /// ranges from <code>1</code> to <code>10000</code>. The default value is
    /// <code>10</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
    /// model's ability to find the optimal solution for a variety of data types. The
    /// valid values are <code>auto</code> and <code>none</code>. The default value is
    /// <code>none</code>. We strongly recommend that you shuffle your data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to zero, resulting in a sparse feature set. If you use this
    /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L1 normalization. This parameter can't be used when
    /// <code>L2</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to small, nonzero values. If you use this parameter, start by
    /// specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L2 normalization. This parameter can't be used when
    /// <code>L1</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// </ul>
    pub fn training_parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.training_parameters.as_ref()
    }
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub fn input_data_location_s3(&self) -> std::option::Option<&str> {
        self.input_data_location_s3.as_deref()
    }
    /// <p>Identifies the <code>MLModel</code> category. The following are the available types: </p>
    /// <ul>
    /// <li>
    /// <p>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</p>
    /// </li>
    /// <li>
    /// <p>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</p>
    /// </li>
    /// <li>
    /// <p>MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"</p>
    /// </li>
    /// </ul>
    pub fn ml_model_type(&self) -> std::option::Option<&crate::model::MlModelType> {
        self.ml_model_type.as_ref()
    }
    /// <p>The scoring threshold is used in binary classification <code>MLModel</code>
    /// models. It marks the boundary between a positive prediction and a
    /// negative prediction.</p>
    /// <p>Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
    /// <code>true</code>. Output values less than the threshold receive a negative response from the MLModel,
    /// such as <code>false</code>.</p>
    pub fn score_threshold(&self) -> std::option::Option<f32> {
        self.score_threshold
    }
    /// <p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>
    pub fn score_threshold_last_updated_at(
        &self,
    ) -> std::option::Option<&aws_smithy_types::Instant> {
        self.score_threshold_last_updated_at.as_ref()
    }
    /// <p>A link to the file that contains logs of the <code>CreateMLModel</code> operation.</p>
    pub fn log_uri(&self) -> std::option::Option<&str> {
        self.log_uri.as_deref()
    }
    /// <p>A description of the most recent details about accessing the <code>MLModel</code>.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.</p>
    pub fn compute_time(&self) -> std::option::Option<i64> {
        self.compute_time
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub fn finished_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.finished_at.as_ref()
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started_at.as_ref()
    }
    /// <p>The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code>
    /// provides detailed information about the observation data to use during training, and
    /// manipulations to perform on the observation data during training.</p>
    /// <p>
    /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    pub fn recipe(&self) -> std::option::Option<&str> {
        self.recipe.as_deref()
    }
    /// <p>The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
    /// <p>
    /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    pub fn schema(&self) -> std::option::Option<&str> {
        self.schema.as_deref()
    }
}
impl std::fmt::Debug for GetMlModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMlModelOutput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("training_data_source_id", &self.training_data_source_id);
        formatter.field("created_by_iam_user", &self.created_by_iam_user);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("size_in_bytes", &self.size_in_bytes);
        formatter.field("endpoint_info", &self.endpoint_info);
        formatter.field("training_parameters", &self.training_parameters);
        formatter.field("input_data_location_s3", &self.input_data_location_s3);
        formatter.field("ml_model_type", &self.ml_model_type);
        formatter.field("score_threshold", &self.score_threshold);
        formatter.field(
            "score_threshold_last_updated_at",
            &self.score_threshold_last_updated_at,
        );
        formatter.field("log_uri", &self.log_uri);
        formatter.field("message", &self.message);
        formatter.field("compute_time", &self.compute_time);
        formatter.field("finished_at", &self.finished_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("recipe", &self.recipe);
        formatter.field("schema", &self.schema);
        formatter.finish()
    }
}
/// See [`GetMlModelOutput`](crate::output::GetMlModelOutput)
pub mod get_ml_model_output {
    /// A builder for [`GetMlModelOutput`](crate::output::GetMlModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) training_data_source_id: std::option::Option<std::string::String>,
        pub(crate) created_by_iam_user: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EntityStatus>,
        pub(crate) size_in_bytes: std::option::Option<i64>,
        pub(crate) endpoint_info: std::option::Option<crate::model::RealtimeEndpointInfo>,
        pub(crate) training_parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) input_data_location_s3: std::option::Option<std::string::String>,
        pub(crate) ml_model_type: std::option::Option<crate::model::MlModelType>,
        pub(crate) score_threshold: std::option::Option<f32>,
        pub(crate) score_threshold_last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) compute_time: std::option::Option<i64>,
        pub(crate) finished_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) recipe: std::option::Option<std::string::String>,
        pub(crate) schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The MLModel ID,
        /// which is same as the <code>MLModelId</code> in the request.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The MLModel ID,
        /// which is same as the <code>MLModelId</code> in the request.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The ID of the training <code>DataSource</code>.</p>
        pub fn training_data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the training <code>DataSource</code>.</p>
        pub fn set_training_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_data_source_id = input;
            self
        }
        /// <p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn created_by_iam_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_iam_user = Some(input.into());
            self
        }
        /// <p>The AWS user account from which the <code>MLModel</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn set_created_by_iam_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_iam_user = input;
            self
        }
        /// <p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time that the <code>MLModel</code> was created. The time is expressed in epoch time.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time of the most recent edit to the <code>MLModel</code>. The time is expressed in epoch time.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The request is processing.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request did not run to completion. The ML model isn't
        /// usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The request completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't
        /// usable.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EntityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the <code>MLModel</code>. This element can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to describe a <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The request is processing.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request did not run to completion. The ML model isn't
        /// usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The request completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>MLModel</code> is marked as deleted. It isn't
        /// usable.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EntityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Long integer type that is a 64-bit signed number.</p>
        pub fn size_in_bytes(mut self, input: i64) -> Self {
            self.size_in_bytes = Some(input);
            self
        }
        /// <p>Long integer type that is a 64-bit signed number.</p>
        pub fn set_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.size_in_bytes = input;
            self
        }
        /// <p>The current endpoint of the <code>MLModel</code>
        /// </p>
        pub fn endpoint_info(mut self, input: crate::model::RealtimeEndpointInfo) -> Self {
            self.endpoint_info = Some(input);
            self
        }
        /// <p>The current endpoint of the <code>MLModel</code>
        /// </p>
        pub fn set_endpoint_info(
            mut self,
            input: std::option::Option<crate::model::RealtimeEndpointInfo>,
        ) -> Self {
            self.endpoint_info = input;
            self
        }
        /// Adds a key-value pair to `training_parameters`.
        ///
        /// To override the contents of this collection use [`set_training_parameters`](Self::set_training_parameters).
        ///
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
        /// a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
        /// input data, the size of the model might affect its performance.</p>
        /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
        /// observations to build the <code>MLModel</code>. The value is an integer that
        /// ranges from <code>1</code> to <code>10000</code>. The default value is
        /// <code>10</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
        /// model's ability to find the optimal solution for a variety of data types. The
        /// valid values are <code>auto</code> and <code>none</code>. The default value is
        /// <code>none</code>. We strongly recommend that you shuffle your data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to zero, resulting in a sparse feature set. If you use this
        /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L1 normalization. This parameter can't be used when
        /// <code>L2</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to small, nonzero values. If you use this parameter, start by
        /// specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L2 normalization. This parameter can't be used when
        /// <code>L1</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// </ul>
        pub fn training_parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.training_parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.training_parameters = Some(hash_map);
            self
        }
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
        /// a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
        /// input data, the size of the model might affect its performance.</p>
        /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
        /// observations to build the <code>MLModel</code>. The value is an integer that
        /// ranges from <code>1</code> to <code>10000</code>. The default value is
        /// <code>10</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling data improves a
        /// model's ability to find the optimal solution for a variety of data types. The
        /// valid values are <code>auto</code> and <code>none</code>. The default value is
        /// <code>none</code>. We strongly recommend that you shuffle your data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to zero, resulting in a sparse feature set. If you use this
        /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L1 normalization. This parameter can't be used when
        /// <code>L2</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to small, nonzero values. If you use this parameter, start by
        /// specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L2 normalization. This parameter can't be used when
        /// <code>L1</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// </ul>
        pub fn set_training_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.training_parameters = input;
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn input_data_location_s3(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_data_location_s3 = Some(input.into());
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn set_input_data_location_s3(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_data_location_s3 = input;
            self
        }
        /// <p>Identifies the <code>MLModel</code> category. The following are the available types: </p>
        /// <ul>
        /// <li>
        /// <p>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</p>
        /// </li>
        /// <li>
        /// <p>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</p>
        /// </li>
        /// <li>
        /// <p>MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"</p>
        /// </li>
        /// </ul>
        pub fn ml_model_type(mut self, input: crate::model::MlModelType) -> Self {
            self.ml_model_type = Some(input);
            self
        }
        /// <p>Identifies the <code>MLModel</code> category. The following are the available types: </p>
        /// <ul>
        /// <li>
        /// <p>REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"</p>
        /// </li>
        /// <li>
        /// <p>BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"</p>
        /// </li>
        /// <li>
        /// <p>MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"</p>
        /// </li>
        /// </ul>
        pub fn set_ml_model_type(
            mut self,
            input: std::option::Option<crate::model::MlModelType>,
        ) -> Self {
            self.ml_model_type = input;
            self
        }
        /// <p>The scoring threshold is used in binary classification <code>MLModel</code>
        /// models. It marks the boundary between a positive prediction and a
        /// negative prediction.</p>
        /// <p>Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
        /// <code>true</code>. Output values less than the threshold receive a negative response from the MLModel,
        /// such as <code>false</code>.</p>
        pub fn score_threshold(mut self, input: f32) -> Self {
            self.score_threshold = Some(input);
            self
        }
        /// <p>The scoring threshold is used in binary classification <code>MLModel</code>
        /// models. It marks the boundary between a positive prediction and a
        /// negative prediction.</p>
        /// <p>Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
        /// <code>true</code>. Output values less than the threshold receive a negative response from the MLModel,
        /// such as <code>false</code>.</p>
        pub fn set_score_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.score_threshold = input;
            self
        }
        /// <p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>
        pub fn score_threshold_last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.score_threshold_last_updated_at = Some(input);
            self
        }
        /// <p>The time of the most recent edit to the <code>ScoreThreshold</code>. The time is expressed in epoch time.</p>
        pub fn set_score_threshold_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.score_threshold_last_updated_at = input;
            self
        }
        /// <p>A link to the file that contains logs of the <code>CreateMLModel</code> operation.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>A link to the file that contains logs of the <code>CreateMLModel</code> operation.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>A description of the most recent details about accessing the <code>MLModel</code>.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the most recent details about accessing the <code>MLModel</code>.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.</p>
        pub fn compute_time(mut self, input: i64) -> Self {
            self.compute_time = Some(input);
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>MLModel</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>MLModel</code> is in the <code>COMPLETED</code> state.</p>
        pub fn set_compute_time(mut self, input: std::option::Option<i64>) -> Self {
            self.compute_time = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn finished_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finished_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>MLModel</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn set_finished_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finished_at = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>MLModel</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>MLModel</code> is in the <code>PENDING</code> state.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code>
        /// provides detailed information about the observation data to use during training, and
        /// manipulations to perform on the observation data during training.</p>
        /// <p>
        /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
        pub fn recipe(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe = Some(input.into());
            self
        }
        /// <p>The recipe to use when training the <code>MLModel</code>. The <code>Recipe</code>
        /// provides detailed information about the observation data to use during training, and
        /// manipulations to perform on the observation data during training.</p>
        /// <p>
        /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
        pub fn set_recipe(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe = input;
            self
        }
        /// <p>The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
        /// <p>
        /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
        pub fn schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.schema = Some(input.into());
            self
        }
        /// <p>The schema used by all of the data files referenced by the <code>DataSource</code>.</p>
        /// <p>
        /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
        pub fn set_schema(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.schema = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMlModelOutput`](crate::output::GetMlModelOutput)
        pub fn build(self) -> crate::output::GetMlModelOutput {
            crate::output::GetMlModelOutput {
                ml_model_id: self.ml_model_id,
                training_data_source_id: self.training_data_source_id,
                created_by_iam_user: self.created_by_iam_user,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                name: self.name,
                status: self.status,
                size_in_bytes: self.size_in_bytes,
                endpoint_info: self.endpoint_info,
                training_parameters: self.training_parameters,
                input_data_location_s3: self.input_data_location_s3,
                ml_model_type: self.ml_model_type,
                score_threshold: self.score_threshold,
                score_threshold_last_updated_at: self.score_threshold_last_updated_at,
                log_uri: self.log_uri,
                message: self.message,
                compute_time: self.compute_time,
                finished_at: self.finished_at,
                started_at: self.started_at,
                recipe: self.recipe,
                schema: self.schema,
            }
        }
    }
}
impl GetMlModelOutput {
    /// Creates a new builder-style object to manufacture [`GetMlModelOutput`](crate::output::GetMlModelOutput)
    pub fn builder() -> crate::output::get_ml_model_output::Builder {
        crate::output::get_ml_model_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetEvaluation</code> operation and describes an <code>Evaluation</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvaluationOutput {
    /// <p>The evaluation ID which is same as the <code>EvaluationId</code> in the request.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>MLModel</code> that was the focus of the evaluation.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The <code>DataSource</code> used for this evaluation.</p>
    pub evaluation_data_source_id: std::option::Option<std::string::String>,
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub input_data_location_s3: std::option::Option<std::string::String>,
    /// <p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub created_by_iam_user: std::option::Option<std::string::String>,
    /// <p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A user-supplied name or description of the <code>Evaluation</code>. </p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the evaluation. This element can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The evaluation is underway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The evaluation process completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EntityStatus>,
    /// <p>Measurements of how well the <code>MLModel</code> performed using observations referenced by the <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p>
    /// </li>
    /// <li>
    /// <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p>
    /// </li>
    /// <li>
    /// <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p>
    /// </li>
    /// </ul>
    /// <p>
    /// For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
    /// </p>
    pub performance_metrics: std::option::Option<crate::model::PerformanceMetrics>,
    /// <p>A link to the file that contains logs of the <code>CreateEvaluation</code> operation.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.</p>
    pub compute_time: std::option::Option<i64>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub finished_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
}
impl GetEvaluationOutput {
    /// <p>The evaluation ID which is same as the <code>EvaluationId</code> in the request.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
    /// <p>The ID of the <code>MLModel</code> that was the focus of the evaluation.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The <code>DataSource</code> used for this evaluation.</p>
    pub fn evaluation_data_source_id(&self) -> std::option::Option<&str> {
        self.evaluation_data_source_id.as_deref()
    }
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub fn input_data_location_s3(&self) -> std::option::Option<&str> {
        self.input_data_location_s3.as_deref()
    }
    /// <p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub fn created_by_iam_user(&self) -> std::option::Option<&str> {
        self.created_by_iam_user.as_deref()
    }
    /// <p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>A user-supplied name or description of the <code>Evaluation</code>. </p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the evaluation. This element can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The evaluation is underway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The evaluation process completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EntityStatus> {
        self.status.as_ref()
    }
    /// <p>Measurements of how well the <code>MLModel</code> performed using observations referenced by the <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>:
    /// </p>
    /// <ul>
    /// <li>
    /// <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p>
    /// </li>
    /// <li>
    /// <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p>
    /// </li>
    /// <li>
    /// <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p>
    /// </li>
    /// </ul>
    /// <p>
    /// For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
    /// </p>
    pub fn performance_metrics(&self) -> std::option::Option<&crate::model::PerformanceMetrics> {
        self.performance_metrics.as_ref()
    }
    /// <p>A link to the file that contains logs of the <code>CreateEvaluation</code> operation.</p>
    pub fn log_uri(&self) -> std::option::Option<&str> {
        self.log_uri.as_deref()
    }
    /// <p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.</p>
    pub fn compute_time(&self) -> std::option::Option<i64> {
        self.compute_time
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub fn finished_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.finished_at.as_ref()
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started_at.as_ref()
    }
}
impl std::fmt::Debug for GetEvaluationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvaluationOutput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("evaluation_data_source_id", &self.evaluation_data_source_id);
        formatter.field("input_data_location_s3", &self.input_data_location_s3);
        formatter.field("created_by_iam_user", &self.created_by_iam_user);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("performance_metrics", &self.performance_metrics);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("message", &self.message);
        formatter.field("compute_time", &self.compute_time);
        formatter.field("finished_at", &self.finished_at);
        formatter.field("started_at", &self.started_at);
        formatter.finish()
    }
}
/// See [`GetEvaluationOutput`](crate::output::GetEvaluationOutput)
pub mod get_evaluation_output {
    /// A builder for [`GetEvaluationOutput`](crate::output::GetEvaluationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) evaluation_data_source_id: std::option::Option<std::string::String>,
        pub(crate) input_data_location_s3: std::option::Option<std::string::String>,
        pub(crate) created_by_iam_user: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EntityStatus>,
        pub(crate) performance_metrics: std::option::Option<crate::model::PerformanceMetrics>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) compute_time: std::option::Option<i64>,
        pub(crate) finished_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
    }
    impl Builder {
        /// <p>The evaluation ID which is same as the <code>EvaluationId</code> in the request.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>The evaluation ID which is same as the <code>EvaluationId</code> in the request.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// <p>The ID of the <code>MLModel</code> that was the focus of the evaluation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>MLModel</code> that was the focus of the evaluation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The <code>DataSource</code> used for this evaluation.</p>
        pub fn evaluation_data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_data_source_id = Some(input.into());
            self
        }
        /// <p>The <code>DataSource</code> used for this evaluation.</p>
        pub fn set_evaluation_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_data_source_id = input;
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn input_data_location_s3(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_data_location_s3 = Some(input.into());
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn set_input_data_location_s3(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_data_location_s3 = input;
            self
        }
        /// <p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn created_by_iam_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_iam_user = Some(input.into());
            self
        }
        /// <p>The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn set_created_by_iam_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_iam_user = input;
            self
        }
        /// <p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time that the <code>Evaluation</code> was created. The time is expressed in epoch time.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time of the most recent edit to the <code>Evaluation</code>. The time is expressed in epoch time.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>. </p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>. </p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the evaluation. This element can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The evaluation is underway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The evaluation process completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EntityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the evaluation. This element can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon Machine Language (Amazon ML) submitted a request to evaluate an <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The evaluation is underway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request to evaluate an <code>MLModel</code> did not run to completion. It is not usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The evaluation process completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>Evaluation</code> is marked as deleted. It is not usable.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EntityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>Measurements of how well the <code>MLModel</code> performed using observations referenced by the <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p>
        /// </li>
        /// <li>
        /// <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p>
        /// </li>
        /// <li>
        /// <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p>
        /// </li>
        /// </ul>
        /// <p>
        /// For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
        /// </p>
        pub fn performance_metrics(mut self, input: crate::model::PerformanceMetrics) -> Self {
            self.performance_metrics = Some(input);
            self
        }
        /// <p>Measurements of how well the <code>MLModel</code> performed using observations referenced by the <code>DataSource</code>. One of the following metric is returned based on the type of the <code>MLModel</code>:
        /// </p>
        /// <ul>
        /// <li>
        /// <p>BinaryAUC: A binary <code>MLModel</code> uses the Area Under the Curve (AUC) technique to measure performance. </p>
        /// </li>
        /// <li>
        /// <p>RegressionRMSE: A regression <code>MLModel</code> uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.</p>
        /// </li>
        /// <li>
        /// <p>MulticlassAvgFScore: A multiclass <code>MLModel</code> uses the F1 score technique to measure performance. </p>
        /// </li>
        /// </ul>
        /// <p>
        /// For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.
        /// </p>
        pub fn set_performance_metrics(
            mut self,
            input: std::option::Option<crate::model::PerformanceMetrics>,
        ) -> Self {
            self.performance_metrics = input;
            self
        }
        /// <p>A link to the file that contains logs of the <code>CreateEvaluation</code> operation.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>A link to the file that contains logs of the <code>CreateEvaluation</code> operation.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the most recent details about evaluating the <code>MLModel</code>.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.</p>
        pub fn compute_time(mut self, input: i64) -> Self {
            self.compute_time = Some(input);
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>Evaluation</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>Evaluation</code> is in the <code>COMPLETED</code> state.</p>
        pub fn set_compute_time(mut self, input: std::option::Option<i64>) -> Self {
            self.compute_time = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn finished_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finished_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>Evaluation</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn set_finished_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finished_at = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>Evaluation</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>Evaluation</code> is in the <code>PENDING</code> state.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvaluationOutput`](crate::output::GetEvaluationOutput)
        pub fn build(self) -> crate::output::GetEvaluationOutput {
            crate::output::GetEvaluationOutput {
                evaluation_id: self.evaluation_id,
                ml_model_id: self.ml_model_id,
                evaluation_data_source_id: self.evaluation_data_source_id,
                input_data_location_s3: self.input_data_location_s3,
                created_by_iam_user: self.created_by_iam_user,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                name: self.name,
                status: self.status,
                performance_metrics: self.performance_metrics,
                log_uri: self.log_uri,
                message: self.message,
                compute_time: self.compute_time,
                finished_at: self.finished_at,
                started_at: self.started_at,
            }
        }
    }
}
impl GetEvaluationOutput {
    /// Creates a new builder-style object to manufacture [`GetEvaluationOutput`](crate::output::GetEvaluationOutput)
    pub fn builder() -> crate::output::get_evaluation_output::Builder {
        crate::output::get_evaluation_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetDataSource</code> operation and describes a <code>DataSource</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataSourceOutput {
    /// <p>The ID assigned to the <code>DataSource</code> at creation.  This value should be identical to the value of the <code>DataSourceId</code> in the request.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub data_location_s3: std::option::Option<std::string::String>,
    /// <p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code>
    /// was created.</p>
    pub data_rearrangement: std::option::Option<std::string::String>,
    /// <p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub created_by_iam_user: std::option::Option<std::string::String>,
    /// <p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The total size of observations in the data files.</p>
    pub data_size_in_bytes: std::option::Option<i64>,
    /// <p>The number of data files referenced by the <code>DataSource</code>.</p>
    pub number_of_files: std::option::Option<i64>,
    /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The current status of the <code>DataSource</code>. This element can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The creation process is underway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The creation process completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EntityStatus>,
    /// <p>A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>The user-supplied description of the most recent details about creating the <code>DataSource</code>.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>Describes the <code>DataSource</code> details specific to Amazon Redshift.</p>
    pub redshift_metadata: std::option::Option<crate::model::RedshiftMetadata>,
    /// <p>The datasource details that are specific to Amazon RDS.</p>
    pub rds_metadata: std::option::Option<crate::model::RdsMetadata>,
    /// <p>The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role</a>, such as the following: arn:aws:iam::account:role/rolename. </p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>
    /// The parameter is <code>true</code> if statistics need to be generated from the observation data.
    /// </p>
    pub compute_statistics: bool,
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the <code>ComputeStatistics</code> is set to true.</p>
    pub compute_time: std::option::Option<i64>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub finished_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The schema used by all of the data files of this <code>DataSource</code>.</p>
    /// <p>
    /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    pub data_source_schema: std::option::Option<std::string::String>,
}
impl GetDataSourceOutput {
    /// <p>The ID assigned to the <code>DataSource</code> at creation.  This value should be identical to the value of the <code>DataSourceId</code> in the request.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub fn data_location_s3(&self) -> std::option::Option<&str> {
        self.data_location_s3.as_deref()
    }
    /// <p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code>
    /// was created.</p>
    pub fn data_rearrangement(&self) -> std::option::Option<&str> {
        self.data_rearrangement.as_deref()
    }
    /// <p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub fn created_by_iam_user(&self) -> std::option::Option<&str> {
        self.created_by_iam_user.as_deref()
    }
    /// <p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>The total size of observations in the data files.</p>
    pub fn data_size_in_bytes(&self) -> std::option::Option<i64> {
        self.data_size_in_bytes
    }
    /// <p>The number of data files referenced by the <code>DataSource</code>.</p>
    pub fn number_of_files(&self) -> std::option::Option<i64> {
        self.number_of_files
    }
    /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The current status of the <code>DataSource</code>. This element can have one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The creation process is underway.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The creation process completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EntityStatus> {
        self.status.as_ref()
    }
    /// <p>A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.</p>
    pub fn log_uri(&self) -> std::option::Option<&str> {
        self.log_uri.as_deref()
    }
    /// <p>The user-supplied description of the most recent details about creating the <code>DataSource</code>.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>Describes the <code>DataSource</code> details specific to Amazon Redshift.</p>
    pub fn redshift_metadata(&self) -> std::option::Option<&crate::model::RedshiftMetadata> {
        self.redshift_metadata.as_ref()
    }
    /// <p>The datasource details that are specific to Amazon RDS.</p>
    pub fn rds_metadata(&self) -> std::option::Option<&crate::model::RdsMetadata> {
        self.rds_metadata.as_ref()
    }
    /// <p>The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role</a>, such as the following: arn:aws:iam::account:role/rolename. </p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>
    /// The parameter is <code>true</code> if statistics need to be generated from the observation data.
    /// </p>
    pub fn compute_statistics(&self) -> bool {
        self.compute_statistics
    }
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the <code>ComputeStatistics</code> is set to true.</p>
    pub fn compute_time(&self) -> std::option::Option<i64> {
        self.compute_time
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub fn finished_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.finished_at.as_ref()
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started_at.as_ref()
    }
    /// <p>The schema used by all of the data files of this <code>DataSource</code>.</p>
    /// <p>
    /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
    pub fn data_source_schema(&self) -> std::option::Option<&str> {
        self.data_source_schema.as_deref()
    }
}
impl std::fmt::Debug for GetDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataSourceOutput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("data_location_s3", &self.data_location_s3);
        formatter.field("data_rearrangement", &self.data_rearrangement);
        formatter.field("created_by_iam_user", &self.created_by_iam_user);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("data_size_in_bytes", &self.data_size_in_bytes);
        formatter.field("number_of_files", &self.number_of_files);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("message", &self.message);
        formatter.field("redshift_metadata", &self.redshift_metadata);
        formatter.field("rds_metadata", &self.rds_metadata);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("compute_statistics", &self.compute_statistics);
        formatter.field("compute_time", &self.compute_time);
        formatter.field("finished_at", &self.finished_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("data_source_schema", &self.data_source_schema);
        formatter.finish()
    }
}
/// See [`GetDataSourceOutput`](crate::output::GetDataSourceOutput)
pub mod get_data_source_output {
    /// A builder for [`GetDataSourceOutput`](crate::output::GetDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) data_location_s3: std::option::Option<std::string::String>,
        pub(crate) data_rearrangement: std::option::Option<std::string::String>,
        pub(crate) created_by_iam_user: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_size_in_bytes: std::option::Option<i64>,
        pub(crate) number_of_files: std::option::Option<i64>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EntityStatus>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) redshift_metadata: std::option::Option<crate::model::RedshiftMetadata>,
        pub(crate) rds_metadata: std::option::Option<crate::model::RdsMetadata>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) compute_statistics: std::option::Option<bool>,
        pub(crate) compute_time: std::option::Option<i64>,
        pub(crate) finished_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) data_source_schema: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>DataSource</code> at creation.  This value should be identical to the value of the <code>DataSourceId</code> in the request.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> at creation.  This value should be identical to the value of the <code>DataSourceId</code> in the request.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn data_location_s3(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_location_s3 = Some(input.into());
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn set_data_location_s3(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_location_s3 = input;
            self
        }
        /// <p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code>
        /// was created.</p>
        pub fn data_rearrangement(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_rearrangement = Some(input.into());
            self
        }
        /// <p>A JSON string that represents the splitting and rearrangement requirement used when this <code>DataSource</code>
        /// was created.</p>
        pub fn set_data_rearrangement(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_rearrangement = input;
            self
        }
        /// <p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn created_by_iam_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_iam_user = Some(input.into());
            self
        }
        /// <p>The AWS user account from which the <code>DataSource</code> was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn set_created_by_iam_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_iam_user = input;
            self
        }
        /// <p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time that the <code>DataSource</code> was created. The time is expressed in epoch time.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time of the most recent edit to the <code>DataSource</code>. The time is expressed in epoch time.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>The total size of observations in the data files.</p>
        pub fn data_size_in_bytes(mut self, input: i64) -> Self {
            self.data_size_in_bytes = Some(input);
            self
        }
        /// <p>The total size of observations in the data files.</p>
        pub fn set_data_size_in_bytes(mut self, input: std::option::Option<i64>) -> Self {
            self.data_size_in_bytes = input;
            self
        }
        /// <p>The number of data files referenced by the <code>DataSource</code>.</p>
        pub fn number_of_files(mut self, input: i64) -> Self {
            self.number_of_files = Some(input);
            self
        }
        /// <p>The number of data files referenced by the <code>DataSource</code>.</p>
        pub fn set_number_of_files(mut self, input: std::option::Option<i64>) -> Self {
            self.number_of_files = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The current status of the <code>DataSource</code>. This element can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The creation process is underway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The creation process completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EntityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current status of the <code>DataSource</code>. This element can have one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon ML submitted a request to create a <code>DataSource</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The creation process is underway.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request to create a <code>DataSource</code> did not run to completion. It is not usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The creation process completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>DataSource</code> is marked as deleted. It is not usable.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EntityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>A link to the file containing logs of <code>CreateDataSourceFrom*</code> operations.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>The user-supplied description of the most recent details about creating the <code>DataSource</code>.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>The user-supplied description of the most recent details about creating the <code>DataSource</code>.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>Describes the <code>DataSource</code> details specific to Amazon Redshift.</p>
        pub fn redshift_metadata(mut self, input: crate::model::RedshiftMetadata) -> Self {
            self.redshift_metadata = Some(input);
            self
        }
        /// <p>Describes the <code>DataSource</code> details specific to Amazon Redshift.</p>
        pub fn set_redshift_metadata(
            mut self,
            input: std::option::Option<crate::model::RedshiftMetadata>,
        ) -> Self {
            self.redshift_metadata = input;
            self
        }
        /// <p>The datasource details that are specific to Amazon RDS.</p>
        pub fn rds_metadata(mut self, input: crate::model::RdsMetadata) -> Self {
            self.rds_metadata = Some(input);
            self
        }
        /// <p>The datasource details that are specific to Amazon RDS.</p>
        pub fn set_rds_metadata(
            mut self,
            input: std::option::Option<crate::model::RdsMetadata>,
        ) -> Self {
            self.rds_metadata = input;
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role</a>, such as the following: arn:aws:iam::account:role/rolename. </p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role</a>, such as the following: arn:aws:iam::account:role/rolename. </p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>
        /// The parameter is <code>true</code> if statistics need to be generated from the observation data.
        /// </p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.compute_statistics = Some(input);
            self
        }
        /// <p>
        /// The parameter is <code>true</code> if statistics need to be generated from the observation data.
        /// </p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.compute_statistics = input;
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the <code>ComputeStatistics</code> is set to true.</p>
        pub fn compute_time(mut self, input: i64) -> Self {
            self.compute_time = Some(input);
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>DataSource</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>DataSource</code> is in the <code>COMPLETED</code> state and the <code>ComputeStatistics</code> is set to true.</p>
        pub fn set_compute_time(mut self, input: std::option::Option<i64>) -> Self {
            self.compute_time = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn finished_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finished_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>DataSource</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn set_finished_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finished_at = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>DataSource</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>DataSource</code> is in the <code>PENDING</code> state.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The schema used by all of the data files of this <code>DataSource</code>.</p>
        /// <p>
        /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
        pub fn data_source_schema(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_schema = Some(input.into());
            self
        }
        /// <p>The schema used by all of the data files of this <code>DataSource</code>.</p>
        /// <p>
        /// <b>Note:</b> This parameter is provided as part of the verbose format.</p>
        pub fn set_data_source_schema(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_schema = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataSourceOutput`](crate::output::GetDataSourceOutput)
        pub fn build(self) -> crate::output::GetDataSourceOutput {
            crate::output::GetDataSourceOutput {
                data_source_id: self.data_source_id,
                data_location_s3: self.data_location_s3,
                data_rearrangement: self.data_rearrangement,
                created_by_iam_user: self.created_by_iam_user,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                data_size_in_bytes: self.data_size_in_bytes,
                number_of_files: self.number_of_files,
                name: self.name,
                status: self.status,
                log_uri: self.log_uri,
                message: self.message,
                redshift_metadata: self.redshift_metadata,
                rds_metadata: self.rds_metadata,
                role_arn: self.role_arn,
                compute_statistics: self.compute_statistics.unwrap_or_default(),
                compute_time: self.compute_time,
                finished_at: self.finished_at,
                started_at: self.started_at,
                data_source_schema: self.data_source_schema,
            }
        }
    }
}
impl GetDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`GetDataSourceOutput`](crate::output::GetDataSourceOutput)
    pub fn builder() -> crate::output::get_data_source_output::Builder {
        crate::output::get_data_source_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>GetBatchPrediction</code> operation and describes a <code>BatchPrediction</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBatchPredictionOutput {
    /// <p>An ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code>
    /// in the request.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DataSource</code> that was used to create the <code>BatchPrediction</code>.
    /// </p>
    pub batch_prediction_data_source_id: std::option::Option<std::string::String>,
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub input_data_location_s3: std::option::Option<std::string::String>,
    /// <p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub created_by_iam_user: std::option::Option<std::string::String>,
    /// <p>The time when the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>
    pub created_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The time of the most recent edit to <code>BatchPrediction</code>. The time is expressed in epoch time.</p>
    pub last_updated_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>
    pub name: std::option::Option<std::string::String>,
    /// <p>The status of the <code>BatchPrediction</code>, which can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The batch predictions are in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The batch prediction process completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</p>
    /// </li>
    /// </ul>
    pub status: std::option::Option<crate::model::EntityStatus>,
    /// <p>The location of an Amazon S3 bucket or directory to receive the operation results.</p>
    pub output_uri: std::option::Option<std::string::String>,
    /// <p>A link to the file that contains logs of the <code>CreateBatchPrediction</code> operation.</p>
    pub log_uri: std::option::Option<std::string::String>,
    /// <p>A description of the most recent details about processing the batch prediction request.</p>
    pub message: std::option::Option<std::string::String>,
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>BatchPrediction</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>BatchPrediction</code> is in the <code>COMPLETED</code> state.</p>
    pub compute_time: std::option::Option<i64>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>BatchPrediction</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub finished_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>BatchPrediction</code> is in the <code>PENDING</code> state.</p>
    pub started_at: std::option::Option<aws_smithy_types::Instant>,
    /// <p>The number of total records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
    pub total_record_count: std::option::Option<i64>,
    /// <p>The number of invalid records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
    pub invalid_record_count: std::option::Option<i64>,
}
impl GetBatchPredictionOutput {
    /// <p>An ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code>
    /// in the request.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
    /// <p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The ID of the <code>DataSource</code> that was used to create the <code>BatchPrediction</code>.
    /// </p>
    pub fn batch_prediction_data_source_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_data_source_id.as_deref()
    }
    /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
    pub fn input_data_location_s3(&self) -> std::option::Option<&str> {
        self.input_data_location_s3.as_deref()
    }
    /// <p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
    pub fn created_by_iam_user(&self) -> std::option::Option<&str> {
        self.created_by_iam_user.as_deref()
    }
    /// <p>The time when the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>
    pub fn created_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.created_at.as_ref()
    }
    /// <p>The time of the most recent edit to <code>BatchPrediction</code>. The time is expressed in epoch time.</p>
    pub fn last_updated_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.last_updated_at.as_ref()
    }
    /// <p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>
    pub fn name(&self) -> std::option::Option<&str> {
        self.name.as_deref()
    }
    /// <p>The status of the <code>BatchPrediction</code>, which can be one of the following values:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>INPROGRESS</code> - The batch predictions are in progress.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>COMPLETED</code> - The batch prediction process completed successfully.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</p>
    /// </li>
    /// </ul>
    pub fn status(&self) -> std::option::Option<&crate::model::EntityStatus> {
        self.status.as_ref()
    }
    /// <p>The location of an Amazon S3 bucket or directory to receive the operation results.</p>
    pub fn output_uri(&self) -> std::option::Option<&str> {
        self.output_uri.as_deref()
    }
    /// <p>A link to the file that contains logs of the <code>CreateBatchPrediction</code> operation.</p>
    pub fn log_uri(&self) -> std::option::Option<&str> {
        self.log_uri.as_deref()
    }
    /// <p>A description of the most recent details about processing the batch prediction request.</p>
    pub fn message(&self) -> std::option::Option<&str> {
        self.message.as_deref()
    }
    /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>BatchPrediction</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>BatchPrediction</code> is in the <code>COMPLETED</code> state.</p>
    pub fn compute_time(&self) -> std::option::Option<i64> {
        self.compute_time
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>BatchPrediction</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
    pub fn finished_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.finished_at.as_ref()
    }
    /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>BatchPrediction</code> is in the <code>PENDING</code> state.</p>
    pub fn started_at(&self) -> std::option::Option<&aws_smithy_types::Instant> {
        self.started_at.as_ref()
    }
    /// <p>The number of total records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
    pub fn total_record_count(&self) -> std::option::Option<i64> {
        self.total_record_count
    }
    /// <p>The number of invalid records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
    pub fn invalid_record_count(&self) -> std::option::Option<i64> {
        self.invalid_record_count
    }
}
impl std::fmt::Debug for GetBatchPredictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBatchPredictionOutput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field(
            "batch_prediction_data_source_id",
            &self.batch_prediction_data_source_id,
        );
        formatter.field("input_data_location_s3", &self.input_data_location_s3);
        formatter.field("created_by_iam_user", &self.created_by_iam_user);
        formatter.field("created_at", &self.created_at);
        formatter.field("last_updated_at", &self.last_updated_at);
        formatter.field("name", &self.name);
        formatter.field("status", &self.status);
        formatter.field("output_uri", &self.output_uri);
        formatter.field("log_uri", &self.log_uri);
        formatter.field("message", &self.message);
        formatter.field("compute_time", &self.compute_time);
        formatter.field("finished_at", &self.finished_at);
        formatter.field("started_at", &self.started_at);
        formatter.field("total_record_count", &self.total_record_count);
        formatter.field("invalid_record_count", &self.invalid_record_count);
        formatter.finish()
    }
}
/// See [`GetBatchPredictionOutput`](crate::output::GetBatchPredictionOutput)
pub mod get_batch_prediction_output {
    /// A builder for [`GetBatchPredictionOutput`](crate::output::GetBatchPredictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) batch_prediction_data_source_id: std::option::Option<std::string::String>,
        pub(crate) input_data_location_s3: std::option::Option<std::string::String>,
        pub(crate) created_by_iam_user: std::option::Option<std::string::String>,
        pub(crate) created_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) last_updated_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) name: std::option::Option<std::string::String>,
        pub(crate) status: std::option::Option<crate::model::EntityStatus>,
        pub(crate) output_uri: std::option::Option<std::string::String>,
        pub(crate) log_uri: std::option::Option<std::string::String>,
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) compute_time: std::option::Option<i64>,
        pub(crate) finished_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) started_at: std::option::Option<aws_smithy_types::Instant>,
        pub(crate) total_record_count: std::option::Option<i64>,
        pub(crate) invalid_record_count: std::option::Option<i64>,
    }
    impl Builder {
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code>
        /// in the request.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation. This value should be identical to the value of the <code>BatchPredictionID</code>
        /// in the request.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// <p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>MLModel</code> that generated predictions for the <code>BatchPrediction</code> request.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The ID of the <code>DataSource</code> that was used to create the <code>BatchPrediction</code>.
        /// </p>
        pub fn batch_prediction_data_source_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.batch_prediction_data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>DataSource</code> that was used to create the <code>BatchPrediction</code>.
        /// </p>
        pub fn set_batch_prediction_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_data_source_id = input;
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn input_data_location_s3(mut self, input: impl Into<std::string::String>) -> Self {
            self.input_data_location_s3 = Some(input.into());
            self
        }
        /// <p>The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).</p>
        pub fn set_input_data_location_s3(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.input_data_location_s3 = input;
            self
        }
        /// <p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn created_by_iam_user(mut self, input: impl Into<std::string::String>) -> Self {
            self.created_by_iam_user = Some(input.into());
            self
        }
        /// <p>The AWS user account that invoked the <code>BatchPrediction</code>. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.</p>
        pub fn set_created_by_iam_user(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.created_by_iam_user = input;
            self
        }
        /// <p>The time when the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>
        pub fn created_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.created_at = Some(input);
            self
        }
        /// <p>The time when the <code>BatchPrediction</code> was created. The time is expressed in epoch time.</p>
        pub fn set_created_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.created_at = input;
            self
        }
        /// <p>The time of the most recent edit to <code>BatchPrediction</code>. The time is expressed in epoch time.</p>
        pub fn last_updated_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.last_updated_at = Some(input);
            self
        }
        /// <p>The time of the most recent edit to <code>BatchPrediction</code>. The time is expressed in epoch time.</p>
        pub fn set_last_updated_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.last_updated_at = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn name(mut self, input: impl Into<std::string::String>) -> Self {
            self.name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn set_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.name = input;
            self
        }
        /// <p>The status of the <code>BatchPrediction</code>, which can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The batch predictions are in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The batch prediction process completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</p>
        /// </li>
        /// </ul>
        pub fn status(mut self, input: crate::model::EntityStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the <code>BatchPrediction</code>, which can be one of the following values:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>PENDING</code> - Amazon Machine Learning (Amazon ML) submitted a request to generate batch predictions.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>INPROGRESS</code> - The batch predictions are in progress.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>FAILED</code> - The request to perform a batch prediction did not run to completion. It is not usable.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>COMPLETED</code> - The batch prediction process completed successfully.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DELETED</code> - The <code>BatchPrediction</code> is marked as deleted. It is not usable.</p>
        /// </li>
        /// </ul>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::EntityStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// <p>The location of an Amazon S3 bucket or directory to receive the operation results.</p>
        pub fn output_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_uri = Some(input.into());
            self
        }
        /// <p>The location of an Amazon S3 bucket or directory to receive the operation results.</p>
        pub fn set_output_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_uri = input;
            self
        }
        /// <p>A link to the file that contains logs of the <code>CreateBatchPrediction</code> operation.</p>
        pub fn log_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.log_uri = Some(input.into());
            self
        }
        /// <p>A link to the file that contains logs of the <code>CreateBatchPrediction</code> operation.</p>
        pub fn set_log_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.log_uri = input;
            self
        }
        /// <p>A description of the most recent details about processing the batch prediction request.</p>
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        /// <p>A description of the most recent details about processing the batch prediction request.</p>
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>BatchPrediction</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>BatchPrediction</code> is in the <code>COMPLETED</code> state.</p>
        pub fn compute_time(mut self, input: i64) -> Self {
            self.compute_time = Some(input);
            self
        }
        /// <p>The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the <code>BatchPrediction</code>, normalized and scaled on computation resources. <code>ComputeTime</code> is only available if the <code>BatchPrediction</code> is in the <code>COMPLETED</code> state.</p>
        pub fn set_compute_time(mut self, input: std::option::Option<i64>) -> Self {
            self.compute_time = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>BatchPrediction</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn finished_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.finished_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>COMPLETED</code> or <code>FAILED</code>. <code>FinishedAt</code> is only available when the <code>BatchPrediction</code> is in the <code>COMPLETED</code> or <code>FAILED</code> state.</p>
        pub fn set_finished_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.finished_at = input;
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>BatchPrediction</code> is in the <code>PENDING</code> state.</p>
        pub fn started_at(mut self, input: aws_smithy_types::Instant) -> Self {
            self.started_at = Some(input);
            self
        }
        /// <p>The epoch time when Amazon Machine Learning marked the <code>BatchPrediction</code> as <code>INPROGRESS</code>. <code>StartedAt</code> isn't available if the <code>BatchPrediction</code> is in the <code>PENDING</code> state.</p>
        pub fn set_started_at(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.started_at = input;
            self
        }
        /// <p>The number of total records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
        pub fn total_record_count(mut self, input: i64) -> Self {
            self.total_record_count = Some(input);
            self
        }
        /// <p>The number of total records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
        pub fn set_total_record_count(mut self, input: std::option::Option<i64>) -> Self {
            self.total_record_count = input;
            self
        }
        /// <p>The number of invalid records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
        pub fn invalid_record_count(mut self, input: i64) -> Self {
            self.invalid_record_count = Some(input);
            self
        }
        /// <p>The number of invalid records that Amazon Machine Learning saw while processing the <code>BatchPrediction</code>.</p>
        pub fn set_invalid_record_count(mut self, input: std::option::Option<i64>) -> Self {
            self.invalid_record_count = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBatchPredictionOutput`](crate::output::GetBatchPredictionOutput)
        pub fn build(self) -> crate::output::GetBatchPredictionOutput {
            crate::output::GetBatchPredictionOutput {
                batch_prediction_id: self.batch_prediction_id,
                ml_model_id: self.ml_model_id,
                batch_prediction_data_source_id: self.batch_prediction_data_source_id,
                input_data_location_s3: self.input_data_location_s3,
                created_by_iam_user: self.created_by_iam_user,
                created_at: self.created_at,
                last_updated_at: self.last_updated_at,
                name: self.name,
                status: self.status,
                output_uri: self.output_uri,
                log_uri: self.log_uri,
                message: self.message,
                compute_time: self.compute_time,
                finished_at: self.finished_at,
                started_at: self.started_at,
                total_record_count: self.total_record_count,
                invalid_record_count: self.invalid_record_count,
            }
        }
    }
}
impl GetBatchPredictionOutput {
    /// Creates a new builder-style object to manufacture [`GetBatchPredictionOutput`](crate::output::GetBatchPredictionOutput)
    pub fn builder() -> crate::output::get_batch_prediction_output::Builder {
        crate::output::get_batch_prediction_output::Builder::default()
    }
}

/// <p>Amazon ML returns the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsOutput {
    /// <p>The ID of the tagged ML object.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the tagged ML object.</p>
    pub resource_type: std::option::Option<crate::model::TaggableResourceType>,
    /// <p>A list of tags associated with the ML object.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl DescribeTagsOutput {
    /// <p>The ID of the tagged ML object.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the tagged ML object.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TaggableResourceType> {
        self.resource_type.as_ref()
    }
    /// <p>A list of tags associated with the ML object.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for DescribeTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsOutput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
pub mod describe_tags_output {
    /// A builder for [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::TaggableResourceType>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The ID of the tagged ML object.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the tagged ML object.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A list of tags associated with the ML object.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>A list of tags associated with the ML object.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
        pub fn build(self) -> crate::output::DescribeTagsOutput {
            crate::output::DescribeTagsOutput {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                tags: self.tags,
            }
        }
    }
}
impl DescribeTagsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeTagsOutput`](crate::output::DescribeTagsOutput)
    pub fn builder() -> crate::output::describe_tags_output::Builder {
        crate::output::describe_tags_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeMLModels</code> operation. The content is essentially a list of <code>MLModel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMlModelsOutput {
    /// <p>A list of <code>MLModel</code> that meet the search criteria.</p>
    pub results: std::option::Option<std::vec::Vec<crate::model::MlModel>>,
    /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeMlModelsOutput {
    /// <p>A list of <code>MLModel</code> that meet the search criteria.</p>
    pub fn results(&self) -> std::option::Option<&[crate::model::MlModel]> {
        self.results.as_deref()
    }
    /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeMlModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMlModelsOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeMlModelsOutput`](crate::output::DescribeMlModelsOutput)
pub mod describe_ml_models_output {
    /// A builder for [`DescribeMlModelsOutput`](crate::output::DescribeMlModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::MlModel>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of <code>MLModel</code> that meet the search criteria.</p>
        pub fn results(mut self, input: impl Into<crate::model::MlModel>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>A list of <code>MLModel</code> that meet the search criteria.</p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::MlModel>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMlModelsOutput`](crate::output::DescribeMlModelsOutput)
        pub fn build(self) -> crate::output::DescribeMlModelsOutput {
            crate::output::DescribeMlModelsOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeMlModelsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeMlModelsOutput`](crate::output::DescribeMlModelsOutput)
    pub fn builder() -> crate::output::describe_ml_models_output::Builder {
        crate::output::describe_ml_models_output::Builder::default()
    }
}

/// <p>Represents the query results from a <code>DescribeEvaluations</code> operation. The content is essentially a list of <code>Evaluation</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEvaluationsOutput {
    /// <p>A list of <code>Evaluation</code> that meet the search criteria.
    /// </p>
    pub results: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
    /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeEvaluationsOutput {
    /// <p>A list of <code>Evaluation</code> that meet the search criteria.
    /// </p>
    pub fn results(&self) -> std::option::Option<&[crate::model::Evaluation]> {
        self.results.as_deref()
    }
    /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeEvaluationsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEvaluationsOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeEvaluationsOutput`](crate::output::DescribeEvaluationsOutput)
pub mod describe_evaluations_output {
    /// A builder for [`DescribeEvaluationsOutput`](crate::output::DescribeEvaluationsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of <code>Evaluation</code> that meet the search criteria.
        /// </p>
        pub fn results(mut self, input: impl Into<crate::model::Evaluation>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>A list of <code>Evaluation</code> that meet the search criteria.
        /// </p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Evaluation>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEvaluationsOutput`](crate::output::DescribeEvaluationsOutput)
        pub fn build(self) -> crate::output::DescribeEvaluationsOutput {
            crate::output::DescribeEvaluationsOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeEvaluationsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeEvaluationsOutput`](crate::output::DescribeEvaluationsOutput)
    pub fn builder() -> crate::output::describe_evaluations_output::Builder {
        crate::output::describe_evaluations_output::Builder::default()
    }
}

/// <p>Represents the query results from a <a>DescribeDataSources</a> operation. The content is essentially a list of <code>DataSource</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSourcesOutput {
    /// <p>A list of <code>DataSource</code> that meet the search criteria.
    /// </p>
    pub results: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
    /// <p>An ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeDataSourcesOutput {
    /// <p>A list of <code>DataSource</code> that meet the search criteria.
    /// </p>
    pub fn results(&self) -> std::option::Option<&[crate::model::DataSource]> {
        self.results.as_deref()
    }
    /// <p>An ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeDataSourcesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSourcesOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeDataSourcesOutput`](crate::output::DescribeDataSourcesOutput)
pub mod describe_data_sources_output {
    /// A builder for [`DescribeDataSourcesOutput`](crate::output::DescribeDataSourcesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of <code>DataSource</code> that meet the search criteria.
        /// </p>
        pub fn results(mut self, input: impl Into<crate::model::DataSource>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>A list of <code>DataSource</code> that meet the search criteria.
        /// </p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::DataSource>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>An ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourcesOutput`](crate::output::DescribeDataSourcesOutput)
        pub fn build(self) -> crate::output::DescribeDataSourcesOutput {
            crate::output::DescribeDataSourcesOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeDataSourcesOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDataSourcesOutput`](crate::output::DescribeDataSourcesOutput)
    pub fn builder() -> crate::output::describe_data_sources_output::Builder {
        crate::output::describe_data_sources_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DescribeBatchPredictions</code> operation. The content is essentially a list of <code>BatchPrediction</code>s.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBatchPredictionsOutput {
    /// <p>A list of <code>BatchPrediction</code> objects that meet the search criteria.
    /// </p>
    pub results: std::option::Option<std::vec::Vec<crate::model::BatchPrediction>>,
    /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl DescribeBatchPredictionsOutput {
    /// <p>A list of <code>BatchPrediction</code> objects that meet the search criteria.
    /// </p>
    pub fn results(&self) -> std::option::Option<&[crate::model::BatchPrediction]> {
        self.results.as_deref()
    }
    /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for DescribeBatchPredictionsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBatchPredictionsOutput");
        formatter.field("results", &self.results);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`DescribeBatchPredictionsOutput`](crate::output::DescribeBatchPredictionsOutput)
pub mod describe_batch_predictions_output {
    /// A builder for [`DescribeBatchPredictionsOutput`](crate::output::DescribeBatchPredictionsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) results: std::option::Option<std::vec::Vec<crate::model::BatchPrediction>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `results`.
        ///
        /// To override the contents of this collection use [`set_results`](Self::set_results).
        ///
        /// <p>A list of <code>BatchPrediction</code> objects that meet the search criteria.
        /// </p>
        pub fn results(mut self, input: impl Into<crate::model::BatchPrediction>) -> Self {
            let mut v = self.results.unwrap_or_default();
            v.push(input.into());
            self.results = Some(v);
            self
        }
        /// <p>A list of <code>BatchPrediction</code> objects that meet the search criteria.
        /// </p>
        pub fn set_results(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::BatchPrediction>>,
        ) -> Self {
            self.results = input;
            self
        }
        /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The ID of the next page in the paginated results that indicates at least one more page follows.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBatchPredictionsOutput`](crate::output::DescribeBatchPredictionsOutput)
        pub fn build(self) -> crate::output::DescribeBatchPredictionsOutput {
            crate::output::DescribeBatchPredictionsOutput {
                results: self.results,
                next_token: self.next_token,
            }
        }
    }
}
impl DescribeBatchPredictionsOutput {
    /// Creates a new builder-style object to manufacture [`DescribeBatchPredictionsOutput`](crate::output::DescribeBatchPredictionsOutput)
    pub fn builder() -> crate::output::describe_batch_predictions_output::Builder {
        crate::output::describe_batch_predictions_output::Builder::default()
    }
}

/// <p>Amazon ML returns the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsOutput {
    /// <p>The ID of the ML object from which tags were deleted.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the ML object from which tags were deleted.</p>
    pub resource_type: std::option::Option<crate::model::TaggableResourceType>,
}
impl DeleteTagsOutput {
    /// <p>The ID of the ML object from which tags were deleted.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the ML object from which tags were deleted.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TaggableResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for DeleteTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsOutput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
pub mod delete_tags_output {
    /// A builder for [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::TaggableResourceType>,
    }
    impl Builder {
        /// <p>The ID of the ML object from which tags were deleted.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the ML object from which tags were deleted.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the ML object from which tags were deleted.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the ML object from which tags were deleted.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
        pub fn build(self) -> crate::output::DeleteTagsOutput {
            crate::output::DeleteTagsOutput {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl DeleteTagsOutput {
    /// Creates a new builder-style object to manufacture [`DeleteTagsOutput`](crate::output::DeleteTagsOutput)
    pub fn builder() -> crate::output::delete_tags_output::Builder {
        crate::output::delete_tags_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>DeleteRealtimeEndpoint</code> operation.</p>
/// <p>The result contains the <code>MLModelId</code> and the endpoint information for the <code>MLModel</code>. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRealtimeEndpointOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
    /// <code>MLModelId</code> in the request.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The endpoint information of the <code>MLModel</code>
    /// </p>
    pub realtime_endpoint_info: std::option::Option<crate::model::RealtimeEndpointInfo>,
}
impl DeleteRealtimeEndpointOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
    /// <code>MLModelId</code> in the request.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The endpoint information of the <code>MLModel</code>
    /// </p>
    pub fn realtime_endpoint_info(
        &self,
    ) -> std::option::Option<&crate::model::RealtimeEndpointInfo> {
        self.realtime_endpoint_info.as_ref()
    }
}
impl std::fmt::Debug for DeleteRealtimeEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRealtimeEndpointOutput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("realtime_endpoint_info", &self.realtime_endpoint_info);
        formatter.finish()
    }
}
/// See [`DeleteRealtimeEndpointOutput`](crate::output::DeleteRealtimeEndpointOutput)
pub mod delete_realtime_endpoint_output {
    /// A builder for [`DeleteRealtimeEndpointOutput`](crate::output::DeleteRealtimeEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) realtime_endpoint_info: std::option::Option<crate::model::RealtimeEndpointInfo>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
        /// <code>MLModelId</code> in the request.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
        /// <code>MLModelId</code> in the request.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The endpoint information of the <code>MLModel</code>
        /// </p>
        pub fn realtime_endpoint_info(mut self, input: crate::model::RealtimeEndpointInfo) -> Self {
            self.realtime_endpoint_info = Some(input);
            self
        }
        /// <p>The endpoint information of the <code>MLModel</code>
        /// </p>
        pub fn set_realtime_endpoint_info(
            mut self,
            input: std::option::Option<crate::model::RealtimeEndpointInfo>,
        ) -> Self {
            self.realtime_endpoint_info = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRealtimeEndpointOutput`](crate::output::DeleteRealtimeEndpointOutput)
        pub fn build(self) -> crate::output::DeleteRealtimeEndpointOutput {
            crate::output::DeleteRealtimeEndpointOutput {
                ml_model_id: self.ml_model_id,
                realtime_endpoint_info: self.realtime_endpoint_info,
            }
        }
    }
}
impl DeleteRealtimeEndpointOutput {
    /// Creates a new builder-style object to manufacture [`DeleteRealtimeEndpointOutput`](crate::output::DeleteRealtimeEndpointOutput)
    pub fn builder() -> crate::output::delete_realtime_endpoint_output::Builder {
        crate::output::delete_realtime_endpoint_output::Builder::default()
    }
}

/// <p>Represents the output of a <code>DeleteMLModel</code> operation.</p>
/// <p>You can use the <code>GetMLModel</code> operation and check the value of the <code>Status</code> parameter to see whether an
/// <code>MLModel</code> is marked as <code>DELETED</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMlModelOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
}
impl DeleteMlModelOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMlModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMlModelOutput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.finish()
    }
}
/// See [`DeleteMlModelOutput`](crate::output::DeleteMlModelOutput)
pub mod delete_ml_model_output {
    /// A builder for [`DeleteMlModelOutput`](crate::output::DeleteMlModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the <code>MLModelID</code> in the request.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMlModelOutput`](crate::output::DeleteMlModelOutput)
        pub fn build(self) -> crate::output::DeleteMlModelOutput {
            crate::output::DeleteMlModelOutput {
                ml_model_id: self.ml_model_id,
            }
        }
    }
}
impl DeleteMlModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteMlModelOutput`](crate::output::DeleteMlModelOutput)
    pub fn builder() -> crate::output::delete_ml_model_output::Builder {
        crate::output::delete_ml_model_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>DeleteEvaluation</code> operation. The output indicates that Amazon Machine Learning (Amazon ML) received the request.</p>
/// <p>You can use the <code>GetEvaluation</code> operation and check the value of the <code>Status</code> parameter to see whether an
/// <code>Evaluation</code> is marked as <code>DELETED</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEvaluationOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
}
impl DeleteEvaluationOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteEvaluationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEvaluationOutput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.finish()
    }
}
/// See [`DeleteEvaluationOutput`](crate::output::DeleteEvaluationOutput)
pub mod delete_evaluation_output {
    /// A builder for [`DeleteEvaluationOutput`](crate::output::DeleteEvaluationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the <code>EvaluationId</code> in the request.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEvaluationOutput`](crate::output::DeleteEvaluationOutput)
        pub fn build(self) -> crate::output::DeleteEvaluationOutput {
            crate::output::DeleteEvaluationOutput {
                evaluation_id: self.evaluation_id,
            }
        }
    }
}
impl DeleteEvaluationOutput {
    /// Creates a new builder-style object to manufacture [`DeleteEvaluationOutput`](crate::output::DeleteEvaluationOutput)
    pub fn builder() -> crate::output::delete_evaluation_output::Builder {
        crate::output::delete_evaluation_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>DeleteDataSource</code> operation.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSourceOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl DeleteDataSourceOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataSourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSourceOutput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
pub mod delete_data_source_output {
    /// A builder for [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the <code>DataSourceID</code> in the request.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
        pub fn build(self) -> crate::output::DeleteDataSourceOutput {
            crate::output::DeleteDataSourceOutput {
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl DeleteDataSourceOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceOutput`](crate::output::DeleteDataSourceOutput)
    pub fn builder() -> crate::output::delete_data_source_output::Builder {
        crate::output::delete_data_source_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>DeleteBatchPrediction</code> operation.</p>        
/// <p>You can use the <code>GetBatchPrediction</code> operation and check the value of the <code>Status</code> parameter to see whether a
/// <code>BatchPrediction</code> is marked as <code>DELETED</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBatchPredictionOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
}
impl DeleteBatchPredictionOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBatchPredictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBatchPredictionOutput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.finish()
    }
}
/// See [`DeleteBatchPredictionOutput`](crate::output::DeleteBatchPredictionOutput)
pub mod delete_batch_prediction_output {
    /// A builder for [`DeleteBatchPredictionOutput`](crate::output::DeleteBatchPredictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value should be identical to the value of the <code>BatchPredictionID</code> in the request.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBatchPredictionOutput`](crate::output::DeleteBatchPredictionOutput)
        pub fn build(self) -> crate::output::DeleteBatchPredictionOutput {
            crate::output::DeleteBatchPredictionOutput {
                batch_prediction_id: self.batch_prediction_id,
            }
        }
    }
}
impl DeleteBatchPredictionOutput {
    /// Creates a new builder-style object to manufacture [`DeleteBatchPredictionOutput`](crate::output::DeleteBatchPredictionOutput)
    pub fn builder() -> crate::output::delete_batch_prediction_output::Builder {
        crate::output::delete_batch_prediction_output::Builder::default()
    }
}

/// <p>Represents the output of an <code>CreateRealtimeEndpoint</code> operation.</p>
/// <p>The result contains the <code>MLModelId</code> and the endpoint information for the <code>MLModel</code>.</p>
/// <p>
/// <b>Note:</b> The endpoint information includes the URI of the <code>MLModel</code>; that is, the location to send online prediction requests for the specified <code>MLModel</code>.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRealtimeEndpointOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
    /// <code>MLModelId</code> in the request.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The endpoint information of the <code>MLModel</code>
    /// </p>
    pub realtime_endpoint_info: std::option::Option<crate::model::RealtimeEndpointInfo>,
}
impl CreateRealtimeEndpointOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
    /// <code>MLModelId</code> in the request.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The endpoint information of the <code>MLModel</code>
    /// </p>
    pub fn realtime_endpoint_info(
        &self,
    ) -> std::option::Option<&crate::model::RealtimeEndpointInfo> {
        self.realtime_endpoint_info.as_ref()
    }
}
impl std::fmt::Debug for CreateRealtimeEndpointOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRealtimeEndpointOutput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("realtime_endpoint_info", &self.realtime_endpoint_info);
        formatter.finish()
    }
}
/// See [`CreateRealtimeEndpointOutput`](crate::output::CreateRealtimeEndpointOutput)
pub mod create_realtime_endpoint_output {
    /// A builder for [`CreateRealtimeEndpointOutput`](crate::output::CreateRealtimeEndpointOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) realtime_endpoint_info: std::option::Option<crate::model::RealtimeEndpointInfo>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
        /// <code>MLModelId</code> in the request.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
        /// <code>MLModelId</code> in the request.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The endpoint information of the <code>MLModel</code>
        /// </p>
        pub fn realtime_endpoint_info(mut self, input: crate::model::RealtimeEndpointInfo) -> Self {
            self.realtime_endpoint_info = Some(input);
            self
        }
        /// <p>The endpoint information of the <code>MLModel</code>
        /// </p>
        pub fn set_realtime_endpoint_info(
            mut self,
            input: std::option::Option<crate::model::RealtimeEndpointInfo>,
        ) -> Self {
            self.realtime_endpoint_info = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRealtimeEndpointOutput`](crate::output::CreateRealtimeEndpointOutput)
        pub fn build(self) -> crate::output::CreateRealtimeEndpointOutput {
            crate::output::CreateRealtimeEndpointOutput {
                ml_model_id: self.ml_model_id,
                realtime_endpoint_info: self.realtime_endpoint_info,
            }
        }
    }
}
impl CreateRealtimeEndpointOutput {
    /// Creates a new builder-style object to manufacture [`CreateRealtimeEndpointOutput`](crate::output::CreateRealtimeEndpointOutput)
    pub fn builder() -> crate::output::create_realtime_endpoint_output::Builder {
        crate::output::create_realtime_endpoint_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateMLModel</code> operation, and is an acknowledgement that Amazon ML received the request.</p>
/// <p>The <code>CreateMLModel</code> operation is asynchronous. You can poll for status updates by using the
/// <code>GetMLModel</code> operation and checking the <code>Status</code> parameter.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMlModelOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
    /// <code>MLModelId</code> in the request.
    /// </p>
    pub ml_model_id: std::option::Option<std::string::String>,
}
impl CreateMlModelOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
    /// <code>MLModelId</code> in the request.
    /// </p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
}
impl std::fmt::Debug for CreateMlModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMlModelOutput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.finish()
    }
}
/// See [`CreateMlModelOutput`](crate::output::CreateMlModelOutput)
pub mod create_ml_model_output {
    /// A builder for [`CreateMlModelOutput`](crate::output::CreateMlModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
        /// <code>MLModelId</code> in the request.
        /// </p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>. This value should be identical to the value of the
        /// <code>MLModelId</code> in the request.
        /// </p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMlModelOutput`](crate::output::CreateMlModelOutput)
        pub fn build(self) -> crate::output::CreateMlModelOutput {
            crate::output::CreateMlModelOutput {
                ml_model_id: self.ml_model_id,
            }
        }
    }
}
impl CreateMlModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateMlModelOutput`](crate::output::CreateMlModelOutput)
    pub fn builder() -> crate::output::create_ml_model_output::Builder {
        crate::output::create_ml_model_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateEvaluation</code> operation, and is an acknowledgement that Amazon ML received the request.</p>
/// <p>
/// <code>CreateEvaluation</code> operation is asynchronous. You can poll for status updates
/// by using the <code>GetEvcaluation</code> operation
/// and checking the <code>Status</code> parameter.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEvaluationOutput {
    /// <p>The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the
    /// <code>EvaluationId</code> in the request.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
}
impl CreateEvaluationOutput {
    /// <p>The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the
    /// <code>EvaluationId</code> in the request.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
}
impl std::fmt::Debug for CreateEvaluationOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEvaluationOutput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.finish()
    }
}
/// See [`CreateEvaluationOutput`](crate::output::CreateEvaluationOutput)
pub mod create_evaluation_output {
    /// A builder for [`CreateEvaluationOutput`](crate::output::CreateEvaluationOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the
        /// <code>EvaluationId</code> in the request.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>The user-supplied ID that uniquely identifies the <code>Evaluation</code>. This value should be identical to the value of the
        /// <code>EvaluationId</code> in the request.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEvaluationOutput`](crate::output::CreateEvaluationOutput)
        pub fn build(self) -> crate::output::CreateEvaluationOutput {
            crate::output::CreateEvaluationOutput {
                evaluation_id: self.evaluation_id,
            }
        }
    }
}
impl CreateEvaluationOutput {
    /// Creates a new builder-style object to manufacture [`CreateEvaluationOutput`](crate::output::CreateEvaluationOutput)
    pub fn builder() -> crate::output::create_evaluation_output::Builder {
        crate::output::create_evaluation_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateDataSourceFromS3</code> operation, and is an acknowledgement that Amazon ML received the request.</p>
/// <p>The <code>CreateDataSourceFromS3</code> operation is asynchronous. You can poll for updates by using
/// the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceFromS3Output {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the
    /// <code>DataSourceID</code> in the request.
    /// </p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl CreateDataSourceFromS3Output {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the
    /// <code>DataSourceID</code> in the request.
    /// </p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDataSourceFromS3Output {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceFromS3Output");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`CreateDataSourceFromS3Output`](crate::output::CreateDataSourceFromS3Output)
pub mod create_data_source_from_s3_output {
    /// A builder for [`CreateDataSourceFromS3Output`](crate::output::CreateDataSourceFromS3Output)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the
        /// <code>DataSourceID</code> in the request.
        /// </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. This value should be identical to the value of the
        /// <code>DataSourceID</code> in the request.
        /// </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceFromS3Output`](crate::output::CreateDataSourceFromS3Output)
        pub fn build(self) -> crate::output::CreateDataSourceFromS3Output {
            crate::output::CreateDataSourceFromS3Output {
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl CreateDataSourceFromS3Output {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceFromS3Output`](crate::output::CreateDataSourceFromS3Output)
    pub fn builder() -> crate::output::create_data_source_from_s3_output::Builder {
        crate::output::create_data_source_from_s3_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateDataSourceFromRedshift</code> operation, and is an acknowledgement that Amazon ML received the request.</p>
/// <p>The <code>CreateDataSourceFromRedshift</code> operation is asynchronous. You can poll for updates by using
/// the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceFromRedshiftOutput {
    /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
    /// <code>DataSourceID</code> in the request.
    /// </p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl CreateDataSourceFromRedshiftOutput {
    /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
    /// <code>DataSourceID</code> in the request.
    /// </p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDataSourceFromRedshiftOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceFromRedshiftOutput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`CreateDataSourceFromRedshiftOutput`](crate::output::CreateDataSourceFromRedshiftOutput)
pub mod create_data_source_from_redshift_output {
    /// A builder for [`CreateDataSourceFromRedshiftOutput`](crate::output::CreateDataSourceFromRedshiftOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
        /// <code>DataSourceID</code> in the request.
        /// </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
        /// <code>DataSourceID</code> in the request.
        /// </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceFromRedshiftOutput`](crate::output::CreateDataSourceFromRedshiftOutput)
        pub fn build(self) -> crate::output::CreateDataSourceFromRedshiftOutput {
            crate::output::CreateDataSourceFromRedshiftOutput {
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl CreateDataSourceFromRedshiftOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceFromRedshiftOutput`](crate::output::CreateDataSourceFromRedshiftOutput)
    pub fn builder() -> crate::output::create_data_source_from_redshift_output::Builder {
        crate::output::create_data_source_from_redshift_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateDataSourceFromRDS</code> operation, and is an acknowledgement that Amazon ML received the request.</p>
/// <p>The <code>CreateDataSourceFromRDS</code>> operation is asynchronous. You can poll for updates by using
/// the <code>GetBatchPrediction</code> operation and checking the <code>Status</code> parameter. You can
/// inspect the <code>Message</code> when <code>Status</code> shows up as <code>FAILED</code>. You can
/// also check the progress of the copy operation by going to the <code>DataPipeline</code> console and looking up
/// the pipeline using the <code>pipelineId </code> from the describe call.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceFromRdsOutput {
    /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
    /// <code>DataSourceID</code> in the request.
    /// </p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl CreateDataSourceFromRdsOutput {
    /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
    /// <code>DataSourceID</code> in the request.
    /// </p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for CreateDataSourceFromRdsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceFromRdsOutput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}
/// See [`CreateDataSourceFromRdsOutput`](crate::output::CreateDataSourceFromRdsOutput)
pub mod create_data_source_from_rds_output {
    /// A builder for [`CreateDataSourceFromRdsOutput`](crate::output::CreateDataSourceFromRdsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
        /// <code>DataSourceID</code> in the request.
        /// </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the datasource. This value should be identical to the value of the
        /// <code>DataSourceID</code> in the request.
        /// </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceFromRdsOutput`](crate::output::CreateDataSourceFromRdsOutput)
        pub fn build(self) -> crate::output::CreateDataSourceFromRdsOutput {
            crate::output::CreateDataSourceFromRdsOutput {
                data_source_id: self.data_source_id,
            }
        }
    }
}
impl CreateDataSourceFromRdsOutput {
    /// Creates a new builder-style object to manufacture [`CreateDataSourceFromRdsOutput`](crate::output::CreateDataSourceFromRdsOutput)
    pub fn builder() -> crate::output::create_data_source_from_rds_output::Builder {
        crate::output::create_data_source_from_rds_output::Builder::default()
    }
}

/// <p> Represents the output of a <code>CreateBatchPrediction</code> operation, and is an acknowledgement that Amazon ML received the request.</p>
/// <p>The <code>CreateBatchPrediction</code> operation is asynchronous. You can poll for status updates by using the <code>>GetBatchPrediction</code>
/// operation and checking the <code>Status</code> parameter of the result.
/// </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchPredictionOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the value of the
    /// <code>BatchPredictionId</code> in the request.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
}
impl CreateBatchPredictionOutput {
    /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the value of the
    /// <code>BatchPredictionId</code> in the request.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
}
impl std::fmt::Debug for CreateBatchPredictionOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchPredictionOutput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.finish()
    }
}
/// See [`CreateBatchPredictionOutput`](crate::output::CreateBatchPredictionOutput)
pub mod create_batch_prediction_output {
    /// A builder for [`CreateBatchPredictionOutput`](crate::output::CreateBatchPredictionOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the value of the
        /// <code>BatchPredictionId</code> in the request.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>. This value is identical to the value of the
        /// <code>BatchPredictionId</code> in the request.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchPredictionOutput`](crate::output::CreateBatchPredictionOutput)
        pub fn build(self) -> crate::output::CreateBatchPredictionOutput {
            crate::output::CreateBatchPredictionOutput {
                batch_prediction_id: self.batch_prediction_id,
            }
        }
    }
}
impl CreateBatchPredictionOutput {
    /// Creates a new builder-style object to manufacture [`CreateBatchPredictionOutput`](crate::output::CreateBatchPredictionOutput)
    pub fn builder() -> crate::output::create_batch_prediction_output::Builder {
        crate::output::create_batch_prediction_output::Builder::default()
    }
}

/// <p>Amazon ML returns the following elements.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsOutput {
    /// <p>The ID of the ML object that was tagged.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the ML object that was tagged.</p>
    pub resource_type: std::option::Option<crate::model::TaggableResourceType>,
}
impl AddTagsOutput {
    /// <p>The ID of the ML object that was tagged.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the ML object that was tagged.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TaggableResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for AddTagsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsOutput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
/// See [`AddTagsOutput`](crate::output::AddTagsOutput)
pub mod add_tags_output {
    /// A builder for [`AddTagsOutput`](crate::output::AddTagsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::TaggableResourceType>,
    }
    impl Builder {
        /// <p>The ID of the ML object that was tagged.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the ML object that was tagged.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the ML object that was tagged.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the ML object that was tagged.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsOutput`](crate::output::AddTagsOutput)
        pub fn build(self) -> crate::output::AddTagsOutput {
            crate::output::AddTagsOutput {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl AddTagsOutput {
    /// Creates a new builder-style object to manufacture [`AddTagsOutput`](crate::output::AddTagsOutput)
    pub fn builder() -> crate::output::add_tags_output::Builder {
        crate::output::add_tags_output::Builder::default()
    }
}
