// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`AddTagsInput`](crate::input::AddTagsInput)
pub mod add_tags_input {
    /// A builder for [`AddTagsInput`](crate::input::AddTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::TaggableResourceType>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
        pub fn tags(mut self, input: impl Into<crate::model::Tag>) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input.into());
            self.tags = Some(v);
            self
        }
        /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the ML object to tag.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the ML object to tag.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`AddTagsInput`](crate::input::AddTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::AddTagsInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::AddTagsInput {
                tags: self.tags,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type AddTagsInputOperationOutputAlias = crate::operation::AddTags;
#[doc(hidden)]
pub type AddTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl AddTagsInput {
    /// Consumes the builder and constructs an Operation<[`AddTags`](crate::operation::AddTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::AddTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::AddTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::AddTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::AddTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.AddTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_add_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::AddTags::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "AddTags",
                    "machinelearning",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`AddTagsInput`](crate::input::AddTagsInput)
    pub fn builder() -> crate::input::add_tags_input::Builder {
        crate::input::add_tags_input::Builder::default()
    }
}

/// See [`CreateBatchPredictionInput`](crate::input::CreateBatchPredictionInput)
pub mod create_batch_prediction_input {
    /// A builder for [`CreateBatchPredictionInput`](crate::input::CreateBatchPredictionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
        pub(crate) batch_prediction_name: std::option::Option<std::string::String>,
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) batch_prediction_data_source_id: std::option::Option<std::string::String>,
        pub(crate) output_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the
        /// <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the
        /// <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
        pub fn batch_prediction_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
        pub fn set_batch_prediction_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_name = input;
            self
        }
        /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
        pub fn batch_prediction_data_source_id(
            mut self,
            input: impl Into<std::string::String>,
        ) -> Self {
            self.batch_prediction_data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
        pub fn set_batch_prediction_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_data_source_id = input;
            self
        }
        /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
        /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn output_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.output_uri = Some(input.into());
            self
        }
        /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
        /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn set_output_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.output_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateBatchPredictionInput`](crate::input::CreateBatchPredictionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateBatchPredictionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateBatchPredictionInput {
                batch_prediction_id: self.batch_prediction_id,
                batch_prediction_name: self.batch_prediction_name,
                ml_model_id: self.ml_model_id,
                batch_prediction_data_source_id: self.batch_prediction_data_source_id,
                output_uri: self.output_uri,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateBatchPredictionInputOperationOutputAlias = crate::operation::CreateBatchPrediction;
#[doc(hidden)]
pub type CreateBatchPredictionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateBatchPredictionInput {
    /// Consumes the builder and constructs an Operation<[`CreateBatchPrediction`](crate::operation::CreateBatchPrediction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateBatchPrediction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateBatchPredictionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateBatchPredictionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateBatchPredictionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateBatchPrediction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_batch_prediction(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateBatchPrediction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateBatchPrediction",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateBatchPredictionInput`](crate::input::CreateBatchPredictionInput)
    pub fn builder() -> crate::input::create_batch_prediction_input::Builder {
        crate::input::create_batch_prediction_input::Builder::default()
    }
}

/// See [`CreateDataSourceFromRdsInput`](crate::input::CreateDataSourceFromRdsInput)
pub mod create_data_source_from_rds_input {
    /// A builder for [`CreateDataSourceFromRdsInput`](crate::input::CreateDataSourceFromRdsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) rds_data: std::option::Option<crate::model::RdsDataSpec>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) compute_statistics: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN)
        /// becomes the ID for a <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN)
        /// becomes the ID for a <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon
        /// Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS
        /// to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn rds_data(mut self, input: crate::model::RdsDataSpec) -> Self {
            self.rds_data = Some(input);
            self
        }
        /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon
        /// Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS
        /// to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_rds_data(
            mut self,
            input: std::option::Option<crate::model::RdsDataSpec>,
        ) -> Self {
            self.rds_data = input;
            self
        }
        /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data
        /// pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
        /// <p></p>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data
        /// pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
        /// <p></p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
        /// </p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.compute_statistics = Some(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
        /// </p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.compute_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceFromRdsInput`](crate::input::CreateDataSourceFromRdsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSourceFromRdsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSourceFromRdsInput {
                data_source_id: self.data_source_id,
                data_source_name: self.data_source_name,
                rds_data: self.rds_data,
                role_arn: self.role_arn,
                compute_statistics: self.compute_statistics.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSourceFromRdsInputOperationOutputAlias =
    crate::operation::CreateDataSourceFromRDS;
#[doc(hidden)]
pub type CreateDataSourceFromRdsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataSourceFromRdsInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSourceFromRDS`](crate::operation::CreateDataSourceFromRDS)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSourceFromRDS,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSourceFromRdsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSourceFromRdsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSourceFromRdsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateDataSourceFromRDS",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_source_from_rds(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSourceFromRDS::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSourceFromRDS",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSourceFromRdsInput`](crate::input::CreateDataSourceFromRdsInput)
    pub fn builder() -> crate::input::create_data_source_from_rds_input::Builder {
        crate::input::create_data_source_from_rds_input::Builder::default()
    }
}

/// See [`CreateDataSourceFromRedshiftInput`](crate::input::CreateDataSourceFromRedshiftInput)
pub mod create_data_source_from_redshift_input {
    /// A builder for [`CreateDataSourceFromRedshiftInput`](crate::input::CreateDataSourceFromRedshiftInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) data_spec: std::option::Option<crate::model::RedshiftDataSpec>,
        pub(crate) role_arn: std::option::Option<std::string::String>,
        pub(crate) compute_statistics: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - The query that is used to retrieve the observation data for the
        /// <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
        /// Redshift data. The data retrieved from Amazon Redshift using
        /// the <code>SelectSqlQuery</code> query is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn data_spec(mut self, input: crate::model::RedshiftDataSpec) -> Self {
            self.data_spec = Some(input);
            self
        }
        /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - The query that is used to retrieve the observation data for the
        /// <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
        /// Redshift data. The data retrieved from Amazon Redshift using
        /// the <code>SelectSqlQuery</code> query is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_data_spec(
            mut self,
            input: std::option::Option<crate::model::RedshiftDataSpec>,
        ) -> Self {
            self.data_spec = input;
            self
        }
        /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p>
        /// </li>
        /// <li>
        /// <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn role_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.role_arn = Some(input.into());
            self
        }
        /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p>
        /// </li>
        /// <li>
        /// <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.role_arn = input;
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to
        /// be used for <code>MLModel</code> training.</p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.compute_statistics = Some(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to
        /// be used for <code>MLModel</code> training.</p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.compute_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceFromRedshiftInput`](crate::input::CreateDataSourceFromRedshiftInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSourceFromRedshiftInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSourceFromRedshiftInput {
                data_source_id: self.data_source_id,
                data_source_name: self.data_source_name,
                data_spec: self.data_spec,
                role_arn: self.role_arn,
                compute_statistics: self.compute_statistics.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSourceFromRedshiftInputOperationOutputAlias =
    crate::operation::CreateDataSourceFromRedshift;
#[doc(hidden)]
pub type CreateDataSourceFromRedshiftInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataSourceFromRedshiftInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataSourceFromRedshift`](crate::operation::CreateDataSourceFromRedshift)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSourceFromRedshift,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSourceFromRedshiftInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSourceFromRedshiftInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSourceFromRedshiftInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateDataSourceFromRedshift",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_source_from_redshift(&self)?
        ;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSourceFromRedshift::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSourceFromRedshift",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSourceFromRedshiftInput`](crate::input::CreateDataSourceFromRedshiftInput)
    pub fn builder() -> crate::input::create_data_source_from_redshift_input::Builder {
        crate::input::create_data_source_from_redshift_input::Builder::default()
    }
}

/// See [`CreateDataSourceFromS3Input`](crate::input::CreateDataSourceFromS3Input)
pub mod create_data_source_from_s3_input {
    /// A builder for [`CreateDataSourceFromS3Input`](crate::input::CreateDataSourceFromS3Input)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
        pub(crate) data_spec: std::option::Option<crate::model::S3DataSpec>,
        pub(crate) compute_statistics: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// <p>The data specification of a <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DataLocationS3 - The Amazon S3 location of the observation data.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn data_spec(mut self, input: crate::model::S3DataSpec) -> Self {
            self.data_spec = Some(input);
            self
        }
        /// <p>The data specification of a <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DataLocationS3 - The Amazon S3 location of the observation data.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_data_spec(
            mut self,
            input: std::option::Option<crate::model::S3DataSpec>,
        ) -> Self {
            self.data_spec = input;
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
        pub fn compute_statistics(mut self, input: bool) -> Self {
            self.compute_statistics = Some(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.compute_statistics = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDataSourceFromS3Input`](crate::input::CreateDataSourceFromS3Input)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDataSourceFromS3Input,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDataSourceFromS3Input {
                data_source_id: self.data_source_id,
                data_source_name: self.data_source_name,
                data_spec: self.data_spec,
                compute_statistics: self.compute_statistics.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDataSourceFromS3InputOperationOutputAlias = crate::operation::CreateDataSourceFromS3;
#[doc(hidden)]
pub type CreateDataSourceFromS3InputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateDataSourceFromS3Input {
    /// Consumes the builder and constructs an Operation<[`CreateDataSourceFromS3`](crate::operation::CreateDataSourceFromS3)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataSourceFromS3,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateDataSourceFromS3Input,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateDataSourceFromS3Input,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateDataSourceFromS3Input,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateDataSourceFromS3",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_data_source_from_s3(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataSourceFromS3::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataSourceFromS3",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateDataSourceFromS3Input`](crate::input::CreateDataSourceFromS3Input)
    pub fn builder() -> crate::input::create_data_source_from_s3_input::Builder {
        crate::input::create_data_source_from_s3_input::Builder::default()
    }
}

/// See [`CreateEvaluationInput`](crate::input::CreateEvaluationInput)
pub mod create_evaluation_input {
    /// A builder for [`CreateEvaluationInput`](crate::input::CreateEvaluationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
        pub(crate) evaluation_name: std::option::Option<std::string::String>,
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) evaluation_data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
        pub fn evaluation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
        pub fn set_evaluation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_name = input;
            self
        }
        /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
        /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
        /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
        /// must match the schema used to create the <code>MLModel</code>.</p>
        pub fn evaluation_data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_data_source_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
        /// must match the schema used to create the <code>MLModel</code>.</p>
        pub fn set_evaluation_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateEvaluationInput`](crate::input::CreateEvaluationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateEvaluationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateEvaluationInput {
                evaluation_id: self.evaluation_id,
                evaluation_name: self.evaluation_name,
                ml_model_id: self.ml_model_id,
                evaluation_data_source_id: self.evaluation_data_source_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateEvaluationInputOperationOutputAlias = crate::operation::CreateEvaluation;
#[doc(hidden)]
pub type CreateEvaluationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateEvaluationInput {
    /// Consumes the builder and constructs an Operation<[`CreateEvaluation`](crate::operation::CreateEvaluation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateEvaluation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateEvaluationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateEvaluationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateEvaluationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateEvaluation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_evaluation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateEvaluation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateEvaluation",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateEvaluationInput`](crate::input::CreateEvaluationInput)
    pub fn builder() -> crate::input::create_evaluation_input::Builder {
        crate::input::create_evaluation_input::Builder::default()
    }
}

/// See [`CreateMlModelInput`](crate::input::CreateMlModelInput)
pub mod create_ml_model_input {
    /// A builder for [`CreateMlModelInput`](crate::input::CreateMlModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) ml_model_name: std::option::Option<std::string::String>,
        pub(crate) ml_model_type: std::option::Option<crate::model::MlModelType>,
        pub(crate) parameters: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) training_data_source_id: std::option::Option<std::string::String>,
        pub(crate) recipe: std::option::Option<std::string::String>,
        pub(crate) recipe_uri: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn ml_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_ml_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ml_model_name = input;
            self
        }
        /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
        /// <ul>
        /// <li>
        /// <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn ml_model_type(mut self, input: crate::model::MlModelType) -> Self {
            self.ml_model_type = Some(input);
            self
        }
        /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
        /// <ul>
        /// <li>
        /// <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn set_ml_model_type(
            mut self,
            input: std::option::Option<crate::model::MlModelType>,
        ) -> Self {
            self.ml_model_type = input;
            self
        }
        /// Adds a key-value pair to `parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
        /// a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
        /// input data, the size of the model might affect its performance.</p>
        /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
        /// observations to build the <code>MLModel</code>. The value is an integer that
        /// ranges from <code>1</code> to <code>10000</code>. The default value is
        /// <code>10</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling
        /// the data improves a model's ability to find the optimal solution for a variety
        /// of data types. The valid values are <code>auto</code> and <code>none</code>. The
        /// default value is <code>none</code>. We strongly recommend that you shuffle your data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to zero, resulting in a sparse feature set. If you use this
        /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L1 normalization. This parameter can't be used when
        /// <code>L2</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to small, nonzero values. If you use this parameter, start by
        /// specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L2 normalization. This parameter can't be used when
        /// <code>L1</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.parameters.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.parameters = Some(hash_map);
            self
        }
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
        /// a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
        /// input data, the size of the model might affect its performance.</p>
        /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
        /// observations to build the <code>MLModel</code>. The value is an integer that
        /// ranges from <code>1</code> to <code>10000</code>. The default value is
        /// <code>10</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling
        /// the data improves a model's ability to find the optimal solution for a variety
        /// of data types. The valid values are <code>auto</code> and <code>none</code>. The
        /// default value is <code>none</code>. We strongly recommend that you shuffle your data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to zero, resulting in a sparse feature set. If you use this
        /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L1 normalization. This parameter can't be used when
        /// <code>L2</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to small, nonzero values. If you use this parameter, start by
        /// specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L2 normalization. This parameter can't be used when
        /// <code>L1</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.parameters = input;
            self
        }
        /// <p>The <code>DataSource</code> that points to the training data.</p>
        pub fn training_data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.training_data_source_id = Some(input.into());
            self
        }
        /// <p>The <code>DataSource</code> that points to the training data.</p>
        pub fn set_training_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.training_data_source_id = input;
            self
        }
        /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe
        /// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn recipe(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe = Some(input.into());
            self
        }
        /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe
        /// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn set_recipe(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe = input;
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn recipe_uri(mut self, input: impl Into<std::string::String>) -> Self {
            self.recipe_uri = Some(input.into());
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn set_recipe_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.recipe_uri = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateMlModelInput`](crate::input::CreateMlModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateMlModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateMlModelInput {
                ml_model_id: self.ml_model_id,
                ml_model_name: self.ml_model_name,
                ml_model_type: self.ml_model_type,
                parameters: self.parameters,
                training_data_source_id: self.training_data_source_id,
                recipe: self.recipe,
                recipe_uri: self.recipe_uri,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateMlModelInputOperationOutputAlias = crate::operation::CreateMLModel;
#[doc(hidden)]
pub type CreateMlModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateMlModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateMLModel`](crate::operation::CreateMLModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateMLModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateMlModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateMlModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateMlModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateMLModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_ml_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateMLModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateMLModel",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateMlModelInput`](crate::input::CreateMlModelInput)
    pub fn builder() -> crate::input::create_ml_model_input::Builder {
        crate::input::create_ml_model_input::Builder::default()
    }
}

/// See [`CreateRealtimeEndpointInput`](crate::input::CreateRealtimeEndpointInput)
pub mod create_realtime_endpoint_input {
    /// A builder for [`CreateRealtimeEndpointInput`](crate::input::CreateRealtimeEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateRealtimeEndpointInput`](crate::input::CreateRealtimeEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateRealtimeEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateRealtimeEndpointInput {
                ml_model_id: self.ml_model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateRealtimeEndpointInputOperationOutputAlias = crate::operation::CreateRealtimeEndpoint;
#[doc(hidden)]
pub type CreateRealtimeEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl CreateRealtimeEndpointInput {
    /// Consumes the builder and constructs an Operation<[`CreateRealtimeEndpoint`](crate::operation::CreateRealtimeEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateRealtimeEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::CreateRealtimeEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::CreateRealtimeEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::CreateRealtimeEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.CreateRealtimeEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_create_realtime_endpoint(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateRealtimeEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateRealtimeEndpoint",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`CreateRealtimeEndpointInput`](crate::input::CreateRealtimeEndpointInput)
    pub fn builder() -> crate::input::create_realtime_endpoint_input::Builder {
        crate::input::create_realtime_endpoint_input::Builder::default()
    }
}

/// See [`DeleteBatchPredictionInput`](crate::input::DeleteBatchPredictionInput)
pub mod delete_batch_prediction_input {
    /// A builder for [`DeleteBatchPredictionInput`](crate::input::DeleteBatchPredictionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteBatchPredictionInput`](crate::input::DeleteBatchPredictionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteBatchPredictionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteBatchPredictionInput {
                batch_prediction_id: self.batch_prediction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteBatchPredictionInputOperationOutputAlias = crate::operation::DeleteBatchPrediction;
#[doc(hidden)]
pub type DeleteBatchPredictionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteBatchPredictionInput {
    /// Consumes the builder and constructs an Operation<[`DeleteBatchPrediction`](crate::operation::DeleteBatchPrediction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteBatchPrediction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteBatchPredictionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteBatchPredictionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteBatchPredictionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DeleteBatchPrediction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_batch_prediction(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteBatchPrediction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteBatchPrediction",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteBatchPredictionInput`](crate::input::DeleteBatchPredictionInput)
    pub fn builder() -> crate::input::delete_batch_prediction_input::Builder {
        crate::input::delete_batch_prediction_input::Builder::default()
    }
}

/// See [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
pub mod delete_data_source_input {
    /// A builder for [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDataSourceInput {
                data_source_id: self.data_source_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDataSourceInputOperationOutputAlias = crate::operation::DeleteDataSource;
#[doc(hidden)]
pub type DeleteDataSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataSource`](crate::operation::DeleteDataSource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DeleteDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataSource",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteDataSourceInput`](crate::input::DeleteDataSourceInput)
    pub fn builder() -> crate::input::delete_data_source_input::Builder {
        crate::input::delete_data_source_input::Builder::default()
    }
}

/// See [`DeleteEvaluationInput`](crate::input::DeleteEvaluationInput)
pub mod delete_evaluation_input {
    /// A builder for [`DeleteEvaluationInput`](crate::input::DeleteEvaluationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteEvaluationInput`](crate::input::DeleteEvaluationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteEvaluationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteEvaluationInput {
                evaluation_id: self.evaluation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteEvaluationInputOperationOutputAlias = crate::operation::DeleteEvaluation;
#[doc(hidden)]
pub type DeleteEvaluationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteEvaluationInput {
    /// Consumes the builder and constructs an Operation<[`DeleteEvaluation`](crate::operation::DeleteEvaluation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteEvaluation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteEvaluationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteEvaluationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteEvaluationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DeleteEvaluation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_evaluation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteEvaluation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteEvaluation",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteEvaluationInput`](crate::input::DeleteEvaluationInput)
    pub fn builder() -> crate::input::delete_evaluation_input::Builder {
        crate::input::delete_evaluation_input::Builder::default()
    }
}

/// See [`DeleteMlModelInput`](crate::input::DeleteMlModelInput)
pub mod delete_ml_model_input {
    /// A builder for [`DeleteMlModelInput`](crate::input::DeleteMlModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteMlModelInput`](crate::input::DeleteMlModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteMlModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteMlModelInput {
                ml_model_id: self.ml_model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteMlModelInputOperationOutputAlias = crate::operation::DeleteMLModel;
#[doc(hidden)]
pub type DeleteMlModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteMlModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteMLModel`](crate::operation::DeleteMLModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteMLModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteMlModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteMlModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteMlModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DeleteMLModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_ml_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteMLModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteMLModel",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteMlModelInput`](crate::input::DeleteMlModelInput)
    pub fn builder() -> crate::input::delete_ml_model_input::Builder {
        crate::input::delete_ml_model_input::Builder::default()
    }
}

/// See [`DeleteRealtimeEndpointInput`](crate::input::DeleteRealtimeEndpointInput)
pub mod delete_realtime_endpoint_input {
    /// A builder for [`DeleteRealtimeEndpointInput`](crate::input::DeleteRealtimeEndpointInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteRealtimeEndpointInput`](crate::input::DeleteRealtimeEndpointInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteRealtimeEndpointInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteRealtimeEndpointInput {
                ml_model_id: self.ml_model_id,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteRealtimeEndpointInputOperationOutputAlias = crate::operation::DeleteRealtimeEndpoint;
#[doc(hidden)]
pub type DeleteRealtimeEndpointInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteRealtimeEndpointInput {
    /// Consumes the builder and constructs an Operation<[`DeleteRealtimeEndpoint`](crate::operation::DeleteRealtimeEndpoint)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteRealtimeEndpoint,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteRealtimeEndpointInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteRealtimeEndpointInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteRealtimeEndpointInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DeleteRealtimeEndpoint",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_delete_realtime_endpoint(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteRealtimeEndpoint::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteRealtimeEndpoint",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteRealtimeEndpointInput`](crate::input::DeleteRealtimeEndpointInput)
    pub fn builder() -> crate::input::delete_realtime_endpoint_input::Builder {
        crate::input::delete_realtime_endpoint_input::Builder::default()
    }
}

/// See [`DeleteTagsInput`](crate::input::DeleteTagsInput)
pub mod delete_tags_input {
    /// A builder for [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::TaggableResourceType>,
    }
    impl Builder {
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tags to delete.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>One or more tags to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteTagsInput`](crate::input::DeleteTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteTagsInput {
                tag_keys: self.tag_keys,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteTagsInputOperationOutputAlias = crate::operation::DeleteTags;
#[doc(hidden)]
pub type DeleteTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DeleteTagsInput {
    /// Consumes the builder and constructs an Operation<[`DeleteTags`](crate::operation::DeleteTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DeleteTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DeleteTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DeleteTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DeleteTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_delete_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteTags",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DeleteTagsInput`](crate::input::DeleteTagsInput)
    pub fn builder() -> crate::input::delete_tags_input::Builder {
        crate::input::delete_tags_input::Builder::default()
    }
}

/// See [`DescribeBatchPredictionsInput`](crate::input::DescribeBatchPredictionsInput)
pub mod describe_batch_predictions_input {
    /// A builder for [`DescribeBatchPredictionsInput`](crate::input::DescribeBatchPredictionsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_variable:
            std::option::Option<crate::model::BatchPredictionFilterVariable>,
        pub(crate) eq: std::option::Option<std::string::String>,
        pub(crate) gt: std::option::Option<std::string::String>,
        pub(crate) lt: std::option::Option<std::string::String>,
        pub(crate) ge: std::option::Option<std::string::String>,
        pub(crate) le: std::option::Option<std::string::String>,
        pub(crate) ne: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(
            mut self,
            input: crate::model::BatchPredictionFilterVariable,
        ) -> Self {
            self.filter_variable = Some(input);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::BatchPredictionFilterVariable>,
        ) -> Self {
            self.filter_variable = input;
            self
        }
        /// <p>The equal to operator. The <code>BatchPrediction</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.eq = Some(input.into());
            self
        }
        /// <p>The equal to operator. The <code>BatchPrediction</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eq = input;
            self
        }
        /// <p>The greater than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.gt = Some(input.into());
            self
        }
        /// <p>The greater than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gt = input;
            self
        }
        /// <p>The less than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.lt = Some(input.into());
            self
        }
        /// <p>The less than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lt = input;
            self
        }
        /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.ge = Some(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ge = input;
            self
        }
        /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.le = Some(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.le = input;
            self
        }
        /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.ne = Some(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ne = input;
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>An ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>An ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeBatchPredictionsInput`](crate::input::DescribeBatchPredictionsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeBatchPredictionsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeBatchPredictionsInput {
                filter_variable: self.filter_variable,
                eq: self.eq,
                gt: self.gt,
                lt: self.lt,
                ge: self.ge,
                le: self.le,
                ne: self.ne,
                prefix: self.prefix,
                sort_order: self.sort_order,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeBatchPredictionsInputOperationOutputAlias =
    crate::operation::DescribeBatchPredictions;
#[doc(hidden)]
pub type DescribeBatchPredictionsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeBatchPredictionsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeBatchPredictions`](crate::operation::DescribeBatchPredictions)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeBatchPredictions,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeBatchPredictionsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeBatchPredictionsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeBatchPredictionsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DescribeBatchPredictions",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_batch_predictions(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeBatchPredictions::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeBatchPredictions",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeBatchPredictionsInput`](crate::input::DescribeBatchPredictionsInput)
    pub fn builder() -> crate::input::describe_batch_predictions_input::Builder {
        crate::input::describe_batch_predictions_input::Builder::default()
    }
}

/// See [`DescribeDataSourcesInput`](crate::input::DescribeDataSourcesInput)
pub mod describe_data_sources_input {
    /// A builder for [`DescribeDataSourcesInput`](crate::input::DescribeDataSourcesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_variable: std::option::Option<crate::model::DataSourceFilterVariable>,
        pub(crate) eq: std::option::Option<std::string::String>,
        pub(crate) gt: std::option::Option<std::string::String>,
        pub(crate) lt: std::option::Option<std::string::String>,
        pub(crate) ge: std::option::Option<std::string::String>,
        pub(crate) le: std::option::Option<std::string::String>,
        pub(crate) ne: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, input: crate::model::DataSourceFilterVariable) -> Self {
            self.filter_variable = Some(input);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::DataSourceFilterVariable>,
        ) -> Self {
            self.filter_variable = input;
            self
        }
        /// <p>The equal to operator. The <code>DataSource</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.eq = Some(input.into());
            self
        }
        /// <p>The equal to operator. The <code>DataSource</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eq = input;
            self
        }
        /// <p>The greater than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.gt = Some(input.into());
            self
        }
        /// <p>The greater than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gt = input;
            self
        }
        /// <p>The less than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.lt = Some(input.into());
            self
        }
        /// <p>The less than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lt = input;
            self
        }
        /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.ge = Some(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ge = input;
            self
        }
        /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.le = Some(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.le = input;
            self
        }
        /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.ne = Some(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ne = input;
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>DataSource</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>DataSource</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDataSourcesInput`](crate::input::DescribeDataSourcesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDataSourcesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDataSourcesInput {
                filter_variable: self.filter_variable,
                eq: self.eq,
                gt: self.gt,
                lt: self.lt,
                ge: self.ge,
                le: self.le,
                ne: self.ne,
                prefix: self.prefix,
                sort_order: self.sort_order,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDataSourcesInputOperationOutputAlias = crate::operation::DescribeDataSources;
#[doc(hidden)]
pub type DescribeDataSourcesInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeDataSourcesInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataSources`](crate::operation::DescribeDataSources)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataSources,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeDataSourcesInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeDataSourcesInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeDataSourcesInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DescribeDataSources",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_data_sources(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataSources::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataSources",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeDataSourcesInput`](crate::input::DescribeDataSourcesInput)
    pub fn builder() -> crate::input::describe_data_sources_input::Builder {
        crate::input::describe_data_sources_input::Builder::default()
    }
}

/// See [`DescribeEvaluationsInput`](crate::input::DescribeEvaluationsInput)
pub mod describe_evaluations_input {
    /// A builder for [`DescribeEvaluationsInput`](crate::input::DescribeEvaluationsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_variable: std::option::Option<crate::model::EvaluationFilterVariable>,
        pub(crate) eq: std::option::Option<std::string::String>,
        pub(crate) gt: std::option::Option<std::string::String>,
        pub(crate) lt: std::option::Option<std::string::String>,
        pub(crate) ge: std::option::Option<std::string::String>,
        pub(crate) le: std::option::Option<std::string::String>,
        pub(crate) ne: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>   
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, input: crate::model::EvaluationFilterVariable) -> Self {
            self.filter_variable = Some(input);
            self
        }
        /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>   
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::EvaluationFilterVariable>,
        ) -> Self {
            self.filter_variable = input;
            self
        }
        /// <p>The equal to operator. The <code>Evaluation</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.eq = Some(input.into());
            self
        }
        /// <p>The equal to operator. The <code>Evaluation</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eq = input;
            self
        }
        /// <p>The greater than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.gt = Some(input.into());
            self
        }
        /// <p>The greater than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gt = input;
            self
        }
        /// <p>The less than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.lt = Some(input.into());
            self
        }
        /// <p>The less than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lt = input;
            self
        }
        /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.ge = Some(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ge = input;
            self
        }
        /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.le = Some(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.le = input;
            self
        }
        /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.ne = Some(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ne = input;
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeEvaluationsInput`](crate::input::DescribeEvaluationsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeEvaluationsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeEvaluationsInput {
                filter_variable: self.filter_variable,
                eq: self.eq,
                gt: self.gt,
                lt: self.lt,
                ge: self.ge,
                le: self.le,
                ne: self.ne,
                prefix: self.prefix,
                sort_order: self.sort_order,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeEvaluationsInputOperationOutputAlias = crate::operation::DescribeEvaluations;
#[doc(hidden)]
pub type DescribeEvaluationsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeEvaluationsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeEvaluations`](crate::operation::DescribeEvaluations)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeEvaluations,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeEvaluationsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeEvaluationsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeEvaluationsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DescribeEvaluations",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_evaluations(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeEvaluations::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeEvaluations",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeEvaluationsInput`](crate::input::DescribeEvaluationsInput)
    pub fn builder() -> crate::input::describe_evaluations_input::Builder {
        crate::input::describe_evaluations_input::Builder::default()
    }
}

/// See [`DescribeMlModelsInput`](crate::input::DescribeMlModelsInput)
pub mod describe_ml_models_input {
    /// A builder for [`DescribeMlModelsInput`](crate::input::DescribeMlModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) filter_variable: std::option::Option<crate::model::MlModelFilterVariable>,
        pub(crate) eq: std::option::Option<std::string::String>,
        pub(crate) gt: std::option::Option<std::string::String>,
        pub(crate) lt: std::option::Option<std::string::String>,
        pub(crate) ge: std::option::Option<std::string::String>,
        pub(crate) le: std::option::Option<std::string::String>,
        pub(crate) ne: std::option::Option<std::string::String>,
        pub(crate) prefix: std::option::Option<std::string::String>,
        pub(crate) sort_order: std::option::Option<crate::model::SortOrder>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) limit: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, input: crate::model::MlModelFilterVariable) -> Self {
            self.filter_variable = Some(input);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::MlModelFilterVariable>,
        ) -> Self {
            self.filter_variable = input;
            self
        }
        /// <p>The equal to operator. The <code>MLModel</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, input: impl Into<std::string::String>) -> Self {
            self.eq = Some(input.into());
            self
        }
        /// <p>The equal to operator. The <code>MLModel</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.eq = input;
            self
        }
        /// <p>The greater than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, input: impl Into<std::string::String>) -> Self {
            self.gt = Some(input.into());
            self
        }
        /// <p>The greater than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.gt = input;
            self
        }
        /// <p>The less than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, input: impl Into<std::string::String>) -> Self {
            self.lt = Some(input.into());
            self
        }
        /// <p>The less than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.lt = input;
            self
        }
        /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, input: impl Into<std::string::String>) -> Self {
            self.ge = Some(input.into());
            self
        }
        /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ge = input;
            self
        }
        /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, input: impl Into<std::string::String>) -> Self {
            self.le = Some(input.into());
            self
        }
        /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.le = input;
            self
        }
        /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, input: impl Into<std::string::String>) -> Self {
            self.ne = Some(input.into());
            self
        }
        /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ne = input;
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>MLModel</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, input: impl Into<std::string::String>) -> Self {
            self.prefix = Some(input.into());
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>MLModel</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.prefix = input;
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, input: crate::model::SortOrder) -> Self {
            self.sort_order = Some(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.sort_order = input;
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn limit(mut self, input: i32) -> Self {
            self.limit = Some(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.limit = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeMlModelsInput`](crate::input::DescribeMlModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeMlModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeMlModelsInput {
                filter_variable: self.filter_variable,
                eq: self.eq,
                gt: self.gt,
                lt: self.lt,
                ge: self.ge,
                le: self.le,
                ne: self.ne,
                prefix: self.prefix,
                sort_order: self.sort_order,
                next_token: self.next_token,
                limit: self.limit,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeMlModelsInputOperationOutputAlias = crate::operation::DescribeMLModels;
#[doc(hidden)]
pub type DescribeMlModelsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeMlModelsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeMLModels`](crate::operation::DescribeMLModels)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeMLModels,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeMlModelsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeMlModelsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeMlModelsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DescribeMLModels",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_describe_ml_models(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeMLModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeMLModels",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeMlModelsInput`](crate::input::DescribeMlModelsInput)
    pub fn builder() -> crate::input::describe_ml_models_input::Builder {
        crate::input::describe_ml_models_input::Builder::default()
    }
}

/// See [`DescribeTagsInput`](crate::input::DescribeTagsInput)
pub mod describe_tags_input {
    /// A builder for [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::TaggableResourceType>,
    }
    impl Builder {
        /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the ML object.</p>
        pub fn resource_type(mut self, input: crate::model::TaggableResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeTagsInput`](crate::input::DescribeTagsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeTagsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeTagsInput {
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeTagsInputOperationOutputAlias = crate::operation::DescribeTags;
#[doc(hidden)]
pub type DescribeTagsInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl DescribeTagsInput {
    /// Consumes the builder and constructs an Operation<[`DescribeTags`](crate::operation::DescribeTags)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeTags,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::DescribeTagsInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::DescribeTagsInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::DescribeTagsInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.DescribeTags",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_describe_tags(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeTags::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeTags",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`DescribeTagsInput`](crate::input::DescribeTagsInput)
    pub fn builder() -> crate::input::describe_tags_input::Builder {
        crate::input::describe_tags_input::Builder::default()
    }
}

/// See [`GetBatchPredictionInput`](crate::input::GetBatchPredictionInput)
pub mod get_batch_prediction_input {
    /// A builder for [`GetBatchPredictionInput`](crate::input::GetBatchPredictionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetBatchPredictionInput`](crate::input::GetBatchPredictionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetBatchPredictionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetBatchPredictionInput {
                batch_prediction_id: self.batch_prediction_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetBatchPredictionInputOperationOutputAlias = crate::operation::GetBatchPrediction;
#[doc(hidden)]
pub type GetBatchPredictionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetBatchPredictionInput {
    /// Consumes the builder and constructs an Operation<[`GetBatchPrediction`](crate::operation::GetBatchPrediction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetBatchPrediction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetBatchPredictionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetBatchPredictionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetBatchPredictionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.GetBatchPrediction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_batch_prediction(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetBatchPrediction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetBatchPrediction",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetBatchPredictionInput`](crate::input::GetBatchPredictionInput)
    pub fn builder() -> crate::input::get_batch_prediction_input::Builder {
        crate::input::get_batch_prediction_input::Builder::default()
    }
}

/// See [`GetDataSourceInput`](crate::input::GetDataSourceInput)
pub mod get_data_source_input {
    /// A builder for [`GetDataSourceInput`](crate::input::GetDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) verbose: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
        /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
        /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
        pub fn verbose(mut self, input: bool) -> Self {
            self.verbose = Some(input);
            self
        }
        /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
        /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
        /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.verbose = input;
            self
        }
        /// Consumes the builder and constructs a [`GetDataSourceInput`](crate::input::GetDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetDataSourceInput {
                data_source_id: self.data_source_id,
                verbose: self.verbose.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetDataSourceInputOperationOutputAlias = crate::operation::GetDataSource;
#[doc(hidden)]
pub type GetDataSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`GetDataSource`](crate::operation::GetDataSource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetDataSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.GetDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_get_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetDataSource",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetDataSourceInput`](crate::input::GetDataSourceInput)
    pub fn builder() -> crate::input::get_data_source_input::Builder {
        crate::input::get_data_source_input::Builder::default()
    }
}

/// See [`GetEvaluationInput`](crate::input::GetEvaluationInput)
pub mod get_evaluation_input {
    /// A builder for [`GetEvaluationInput`](crate::input::GetEvaluationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// Consumes the builder and constructs a [`GetEvaluationInput`](crate::input::GetEvaluationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetEvaluationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetEvaluationInput {
                evaluation_id: self.evaluation_id,
            })
        }
    }
}
#[doc(hidden)]
pub type GetEvaluationInputOperationOutputAlias = crate::operation::GetEvaluation;
#[doc(hidden)]
pub type GetEvaluationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetEvaluationInput {
    /// Consumes the builder and constructs an Operation<[`GetEvaluation`](crate::operation::GetEvaluation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetEvaluation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetEvaluationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetEvaluationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetEvaluationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.GetEvaluation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_evaluation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetEvaluation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetEvaluation",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetEvaluationInput`](crate::input::GetEvaluationInput)
    pub fn builder() -> crate::input::get_evaluation_input::Builder {
        crate::input::get_evaluation_input::Builder::default()
    }
}

/// See [`GetMlModelInput`](crate::input::GetMlModelInput)
pub mod get_ml_model_input {
    /// A builder for [`GetMlModelInput`](crate::input::GetMlModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) verbose: std::option::Option<bool>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
        /// <p>If true, <code>Recipe</code> is returned.</p>
        /// <p>If false, <code>Recipe</code> is not returned.</p>
        pub fn verbose(mut self, input: bool) -> Self {
            self.verbose = Some(input);
            self
        }
        /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
        /// <p>If true, <code>Recipe</code> is returned.</p>
        /// <p>If false, <code>Recipe</code> is not returned.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.verbose = input;
            self
        }
        /// Consumes the builder and constructs a [`GetMlModelInput`](crate::input::GetMlModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::GetMlModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::GetMlModelInput {
                ml_model_id: self.ml_model_id,
                verbose: self.verbose.unwrap_or_default(),
            })
        }
    }
}
#[doc(hidden)]
pub type GetMlModelInputOperationOutputAlias = crate::operation::GetMLModel;
#[doc(hidden)]
pub type GetMlModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl GetMlModelInput {
    /// Consumes the builder and constructs an Operation<[`GetMLModel`](crate::operation::GetMLModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::GetMLModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::GetMlModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::GetMlModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::GetMlModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.GetMLModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_get_ml_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::GetMLModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "GetMLModel",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`GetMlModelInput`](crate::input::GetMlModelInput)
    pub fn builder() -> crate::input::get_ml_model_input::Builder {
        crate::input::get_ml_model_input::Builder::default()
    }
}

/// See [`PredictInput`](crate::input::PredictInput)
pub mod predict_input {
    /// A builder for [`PredictInput`](crate::input::PredictInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) record: std::option::Option<
            std::collections::HashMap<std::string::String, std::string::String>,
        >,
        pub(crate) predict_endpoint: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>A unique identifier of the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>A unique identifier of the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// Adds a key-value pair to `record`.
        ///
        /// To override the contents of this collection use [`set_record`](Self::set_record).
        ///
        /// <p>A map of variable name-value pairs that represent an observation.</p>
        pub fn record(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            let mut hash_map = self.record.unwrap_or_default();
            hash_map.insert(k.into(), v.into());
            self.record = Some(hash_map);
            self
        }
        /// <p>A map of variable name-value pairs that represent an observation.</p>
        pub fn set_record(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.record = input;
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn predict_endpoint(mut self, input: impl Into<std::string::String>) -> Self {
            self.predict_endpoint = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_predict_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.predict_endpoint = input;
            self
        }
        /// Consumes the builder and constructs a [`PredictInput`](crate::input::PredictInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::PredictInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::PredictInput {
                ml_model_id: self.ml_model_id,
                record: self.record,
                predict_endpoint: self.predict_endpoint,
            })
        }
    }
}
#[doc(hidden)]
pub type PredictInputOperationOutputAlias = crate::operation::Predict;
#[doc(hidden)]
pub type PredictInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl PredictInput {
    /// Consumes the builder and constructs an Operation<[`Predict`](crate::operation::Predict)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::Predict,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::PredictInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::PredictInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::PredictInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.Predict",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body = crate::operation_ser::serialize_operation_crate_operation_predict(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::Predict::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "Predict",
                    "machinelearning",
                ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`PredictInput`](crate::input::PredictInput)
    pub fn builder() -> crate::input::predict_input::Builder {
        crate::input::predict_input::Builder::default()
    }
}

/// See [`UpdateBatchPredictionInput`](crate::input::UpdateBatchPredictionInput)
pub mod update_batch_prediction_input {
    /// A builder for [`UpdateBatchPredictionInput`](crate::input::UpdateBatchPredictionInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) batch_prediction_id: std::option::Option<std::string::String>,
        pub(crate) batch_prediction_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
        pub fn batch_prediction_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_id = input;
            self
        }
        /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.batch_prediction_name = Some(input.into());
            self
        }
        /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.batch_prediction_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateBatchPredictionInput`](crate::input::UpdateBatchPredictionInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateBatchPredictionInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateBatchPredictionInput {
                batch_prediction_id: self.batch_prediction_id,
                batch_prediction_name: self.batch_prediction_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateBatchPredictionInputOperationOutputAlias = crate::operation::UpdateBatchPrediction;
#[doc(hidden)]
pub type UpdateBatchPredictionInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateBatchPredictionInput {
    /// Consumes the builder and constructs an Operation<[`UpdateBatchPrediction`](crate::operation::UpdateBatchPrediction)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateBatchPrediction,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateBatchPredictionInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateBatchPredictionInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateBatchPredictionInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.UpdateBatchPrediction",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_batch_prediction(
                &self,
            )?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateBatchPrediction::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateBatchPrediction",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateBatchPredictionInput`](crate::input::UpdateBatchPredictionInput)
    pub fn builder() -> crate::input::update_batch_prediction_input::Builder {
        crate::input::update_batch_prediction_input::Builder::default()
    }
}

/// See [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
pub mod update_data_source_input {
    /// A builder for [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) data_source_id: std::option::Option<std::string::String>,
        pub(crate) data_source_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
        pub fn data_source_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_id = input;
            self
        }
        /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
        pub fn data_source_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.data_source_name = Some(input.into());
            self
        }
        /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.data_source_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDataSourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDataSourceInput {
                data_source_id: self.data_source_id,
                data_source_name: self.data_source_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDataSourceInputOperationOutputAlias = crate::operation::UpdateDataSource;
#[doc(hidden)]
pub type UpdateDataSourceInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateDataSourceInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDataSource`](crate::operation::UpdateDataSource)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDataSource,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateDataSourceInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateDataSourceInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateDataSourceInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.UpdateDataSource",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_data_source(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDataSource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDataSource",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateDataSourceInput`](crate::input::UpdateDataSourceInput)
    pub fn builder() -> crate::input::update_data_source_input::Builder {
        crate::input::update_data_source_input::Builder::default()
    }
}

/// See [`UpdateEvaluationInput`](crate::input::UpdateEvaluationInput)
pub mod update_evaluation_input {
    /// A builder for [`UpdateEvaluationInput`](crate::input::UpdateEvaluationInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) evaluation_id: std::option::Option<std::string::String>,
        pub(crate) evaluation_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
        pub fn evaluation_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_id = input;
            self
        }
        /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
        pub fn evaluation_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.evaluation_name = Some(input.into());
            self
        }
        /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
        pub fn set_evaluation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.evaluation_name = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateEvaluationInput`](crate::input::UpdateEvaluationInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateEvaluationInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateEvaluationInput {
                evaluation_id: self.evaluation_id,
                evaluation_name: self.evaluation_name,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateEvaluationInputOperationOutputAlias = crate::operation::UpdateEvaluation;
#[doc(hidden)]
pub type UpdateEvaluationInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateEvaluationInput {
    /// Consumes the builder and constructs an Operation<[`UpdateEvaluation`](crate::operation::UpdateEvaluation)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateEvaluation,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateEvaluationInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateEvaluationInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateEvaluationInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.UpdateEvaluation",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_evaluation(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateEvaluation::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateEvaluation",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateEvaluationInput`](crate::input::UpdateEvaluationInput)
    pub fn builder() -> crate::input::update_evaluation_input::Builder {
        crate::input::update_evaluation_input::Builder::default()
    }
}

/// See [`UpdateMlModelInput`](crate::input::UpdateMlModelInput)
pub mod update_ml_model_input {
    /// A builder for [`UpdateMlModelInput`](crate::input::UpdateMlModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) ml_model_id: std::option::Option<std::string::String>,
        pub(crate) ml_model_name: std::option::Option<std::string::String>,
        pub(crate) score_threshold: std::option::Option<f32>,
    }
    impl Builder {
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_id = Some(input.into());
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.ml_model_id = input;
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn ml_model_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.ml_model_name = Some(input.into());
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_ml_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.ml_model_name = input;
            self
        }
        /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
        /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
        pub fn score_threshold(mut self, input: f32) -> Self {
            self.score_threshold = Some(input);
            self
        }
        /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
        /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
        pub fn set_score_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.score_threshold = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateMlModelInput`](crate::input::UpdateMlModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateMlModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateMlModelInput {
                ml_model_id: self.ml_model_id,
                ml_model_name: self.ml_model_name,
                score_threshold: self.score_threshold,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateMlModelInputOperationOutputAlias = crate::operation::UpdateMLModel;
#[doc(hidden)]
pub type UpdateMlModelInputOperationRetryAlias = aws_http::AwsErrorRetryPolicy;
impl UpdateMlModelInput {
    /// Consumes the builder and constructs an Operation<[`UpdateMLModel`](crate::operation::UpdateMLModel)>
    #[allow(clippy::let_and_return)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateMLModel,
            aws_http::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        fn uri_base(
            _input: &crate::input::UpdateMlModelInput,
            output: &mut String,
        ) -> Result<(), aws_smithy_http::operation::BuildError> {
            write!(output, "/").expect("formatting should succeed");
            Ok(())
        }
        #[allow(clippy::unnecessary_wraps)]
        fn update_http_builder(
            input: &crate::input::UpdateMlModelInput,
            builder: http::request::Builder,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            let mut uri = String::new();
            uri_base(input, &mut uri)?;
            Ok(builder.method("POST").uri(uri))
        }
        #[allow(clippy::unnecessary_wraps)]
        fn request_builder_base(
            input: &crate::input::UpdateMlModelInput,
        ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
        {
            #[allow(unused_mut)]
            let mut builder = update_http_builder(input, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("content-type"),
                "application/x-amz-json-1.1",
            );
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::HeaderName::from_static("x-amz-target"),
                "AmazonML_20141212.UpdateMLModel",
            );
            Ok(builder)
        }
        let properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        let request = request_builder_base(&self)?;
        let body =
            crate::operation_ser::serialize_operation_crate_operation_update_ml_model(&self)?;
        let request = Self::assemble(request, body);
        #[allow(unused_mut)]
        let mut request = aws_smithy_http::operation::Request::from_parts(
            request.map(aws_smithy_http::body::SdkBody::from),
            properties,
        );
        request
            .properties_mut()
            .insert(aws_http::user_agent::AwsUserAgent::new_from_environment(
                crate::API_METADATA.clone(),
            ));
        #[allow(unused_mut)]
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateMLModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateMLModel",
            "machinelearning",
        ));
        let op = op.with_retry_policy(aws_http::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    fn assemble(
        builder: http::request::Builder,
        body: aws_smithy_http::body::SdkBody,
    ) -> http::request::Request<aws_smithy_http::body::SdkBody> {
        let mut builder = builder;
        if let Some(content_length) = body.content_length() {
            builder = aws_smithy_http::header::set_header_if_absent(
                builder,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        builder.body(body).expect("should be valid request")
    }
    /// Creates a new builder-style object to manufacture [`UpdateMlModelInput`](crate::input::UpdateMlModelInput)
    pub fn builder() -> crate::input::update_ml_model_input::Builder {
        crate::input::update_ml_model_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateMlModelInput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    pub ml_model_name: std::option::Option<std::string::String>,
    /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
    /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
    pub score_threshold: std::option::Option<f32>,
}
impl UpdateMlModelInput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    pub fn ml_model_name(&self) -> std::option::Option<&str> {
        self.ml_model_name.as_deref()
    }
    /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
    /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
    pub fn score_threshold(&self) -> std::option::Option<f32> {
        self.score_threshold
    }
}
impl std::fmt::Debug for UpdateMlModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateMlModelInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("ml_model_name", &self.ml_model_name);
        formatter.field("score_threshold", &self.score_threshold);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateEvaluationInput {
    /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
    /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
    pub evaluation_name: std::option::Option<std::string::String>,
}
impl UpdateEvaluationInput {
    /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
    /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
    pub fn evaluation_name(&self) -> std::option::Option<&str> {
        self.evaluation_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateEvaluationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateEvaluationInput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.field("evaluation_name", &self.evaluation_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDataSourceInput {
    /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
    pub data_source_name: std::option::Option<std::string::String>,
}
impl UpdateDataSourceInput {
    /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDataSourceInput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateBatchPredictionInput {
    /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
    /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
    pub batch_prediction_name: std::option::Option<std::string::String>,
}
impl UpdateBatchPredictionInput {
    /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
    /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
    pub fn batch_prediction_name(&self) -> std::option::Option<&str> {
        self.batch_prediction_name.as_deref()
    }
}
impl std::fmt::Debug for UpdateBatchPredictionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateBatchPredictionInput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.field("batch_prediction_name", &self.batch_prediction_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct PredictInput {
    /// <p>A unique identifier of the <code>MLModel</code>.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>A map of variable name-value pairs that represent an observation.</p>
    pub record:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    #[allow(missing_docs)] // documentation missing in model
    pub predict_endpoint: std::option::Option<std::string::String>,
}
impl PredictInput {
    /// <p>A unique identifier of the <code>MLModel</code>.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>A map of variable name-value pairs that represent an observation.</p>
    pub fn record(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.record.as_ref()
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn predict_endpoint(&self) -> std::option::Option<&str> {
        self.predict_endpoint.as_deref()
    }
}
impl std::fmt::Debug for PredictInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("PredictInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("record", &self.record);
        formatter.field("predict_endpoint", &self.predict_endpoint);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetMlModelInput {
    /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
    /// <p>If true, <code>Recipe</code> is returned.</p>
    /// <p>If false, <code>Recipe</code> is not returned.</p>
    pub verbose: bool,
}
impl GetMlModelInput {
    /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
    /// <p>If true, <code>Recipe</code> is returned.</p>
    /// <p>If false, <code>Recipe</code> is not returned.</p>
    pub fn verbose(&self) -> bool {
        self.verbose
    }
}
impl std::fmt::Debug for GetMlModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetMlModelInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("verbose", &self.verbose);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetEvaluationInput {
    /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
    pub evaluation_id: std::option::Option<std::string::String>,
}
impl GetEvaluationInput {
    /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
}
impl std::fmt::Debug for GetEvaluationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetEvaluationInput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetDataSourceInput {
    /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
    /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
    /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
    pub verbose: bool,
}
impl GetDataSourceInput {
    /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
    /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
    /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
    pub fn verbose(&self) -> bool {
        self.verbose
    }
}
impl std::fmt::Debug for GetDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetDataSourceInput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("verbose", &self.verbose);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct GetBatchPredictionInput {
    /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
}
impl GetBatchPredictionInput {
    /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
}
impl std::fmt::Debug for GetBatchPredictionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("GetBatchPredictionInput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeTagsInput {
    /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the ML object.</p>
    pub resource_type: std::option::Option<crate::model::TaggableResourceType>,
}
impl DescribeTagsInput {
    /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the ML object.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TaggableResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for DescribeTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeTagsInput");
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeMlModelsInput {
    /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code>
    /// <b> </b>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
    /// </li>
    /// </ul>
    pub filter_variable: std::option::Option<crate::model::MlModelFilterVariable>,
    /// <p>The equal to operator. The <code>MLModel</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub eq: std::option::Option<std::string::String>,
    /// <p>The greater than operator. The <code>MLModel</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub gt: std::option::Option<std::string::String>,
    /// <p>The less than operator. The <code>MLModel</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub lt: std::option::Option<std::string::String>,
    /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub ge: std::option::Option<std::string::String>,
    /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub le: std::option::Option<std::string::String>,
    /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub ne: std::option::Option<std::string::String>,
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, an <code>MLModel</code> could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The ID of the page in the paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeMlModelsInput {
    /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code>
    /// <b> </b>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
    /// </li>
    /// </ul>
    pub fn filter_variable(&self) -> std::option::Option<&crate::model::MlModelFilterVariable> {
        self.filter_variable.as_ref()
    }
    /// <p>The equal to operator. The <code>MLModel</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub fn eq(&self) -> std::option::Option<&str> {
        self.eq.as_deref()
    }
    /// <p>The greater than operator. The <code>MLModel</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub fn gt(&self) -> std::option::Option<&str> {
        self.gt.as_deref()
    }
    /// <p>The less than operator. The <code>MLModel</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub fn lt(&self) -> std::option::Option<&str> {
        self.lt.as_deref()
    }
    /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub fn ge(&self) -> std::option::Option<&str> {
        self.ge.as_deref()
    }
    /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub fn le(&self) -> std::option::Option<&str> {
        self.le.as_deref()
    }
    /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub fn ne(&self) -> std::option::Option<&str> {
        self.ne.as_deref()
    }
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, an <code>MLModel</code> could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The ID of the page in the paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeMlModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeMlModelsInput");
        formatter.field("filter_variable", &self.filter_variable);
        formatter.field("eq", &self.eq);
        formatter.field("gt", &self.gt);
        formatter.field("lt", &self.lt);
        formatter.field("ge", &self.ge);
        formatter.field("le", &self.le);
        formatter.field("ne", &self.ne);
        formatter.field("prefix", &self.prefix);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeEvaluationsInput {
    /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>   
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code>
    /// <b> </b>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
    /// </li>
    /// </ul>
    pub filter_variable: std::option::Option<crate::model::EvaluationFilterVariable>,
    /// <p>The equal to operator. The <code>Evaluation</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub eq: std::option::Option<std::string::String>,
    /// <p>The greater than operator. The <code>Evaluation</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub gt: std::option::Option<std::string::String>,
    /// <p>The less than operator. The <code>Evaluation</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub lt: std::option::Option<std::string::String>,
    /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub ge: std::option::Option<std::string::String>,
    /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub le: std::option::Option<std::string::String>,
    /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub ne: std::option::Option<std::string::String>,
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The ID of the page in the paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeEvaluationsInput {
    /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>   
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code>
    /// <b> </b>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
    /// </li>
    /// </ul>
    pub fn filter_variable(&self) -> std::option::Option<&crate::model::EvaluationFilterVariable> {
        self.filter_variable.as_ref()
    }
    /// <p>The equal to operator. The <code>Evaluation</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub fn eq(&self) -> std::option::Option<&str> {
        self.eq.as_deref()
    }
    /// <p>The greater than operator. The <code>Evaluation</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub fn gt(&self) -> std::option::Option<&str> {
        self.gt.as_deref()
    }
    /// <p>The less than operator. The <code>Evaluation</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub fn lt(&self) -> std::option::Option<&str> {
        self.lt.as_deref()
    }
    /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub fn ge(&self) -> std::option::Option<&str> {
        self.ge.as_deref()
    }
    /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub fn le(&self) -> std::option::Option<&str> {
        self.le.as_deref()
    }
    /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub fn ne(&self) -> std::option::Option<&str> {
        self.ne.as_deref()
    }
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The ID of the page in the paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeEvaluationsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeEvaluationsInput");
        formatter.field("filter_variable", &self.filter_variable);
        formatter.field("eq", &self.eq);
        formatter.field("gt", &self.gt);
        formatter.field("lt", &self.lt);
        formatter.field("ge", &self.ge);
        formatter.field("le", &self.le);
        formatter.field("ne", &self.ne);
        formatter.field("prefix", &self.prefix);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDataSourcesInput {
    /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p>
    /// </li>
    /// </ul>
    pub filter_variable: std::option::Option<crate::model::DataSourceFilterVariable>,
    /// <p>The equal to operator. The <code>DataSource</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub eq: std::option::Option<std::string::String>,
    /// <p>The greater than operator. The <code>DataSource</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub gt: std::option::Option<std::string::String>,
    /// <p>The less than operator. The <code>DataSource</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub lt: std::option::Option<std::string::String>,
    /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub ge: std::option::Option<std::string::String>,
    /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub le: std::option::Option<std::string::String>,
    /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub ne: std::option::Option<std::string::String>,
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, a <code>DataSource</code> could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>The ID of the page in the paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeDataSourcesInput {
    /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p>
    /// </li>
    /// </ul>
    pub fn filter_variable(&self) -> std::option::Option<&crate::model::DataSourceFilterVariable> {
        self.filter_variable.as_ref()
    }
    /// <p>The equal to operator. The <code>DataSource</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub fn eq(&self) -> std::option::Option<&str> {
        self.eq.as_deref()
    }
    /// <p>The greater than operator. The <code>DataSource</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub fn gt(&self) -> std::option::Option<&str> {
        self.gt.as_deref()
    }
    /// <p>The less than operator. The <code>DataSource</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub fn lt(&self) -> std::option::Option<&str> {
        self.lt.as_deref()
    }
    /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub fn ge(&self) -> std::option::Option<&str> {
        self.ge.as_deref()
    }
    /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub fn le(&self) -> std::option::Option<&str> {
        self.le.as_deref()
    }
    /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub fn ne(&self) -> std::option::Option<&str> {
        self.ne.as_deref()
    }
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, a <code>DataSource</code> could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>The ID of the page in the paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeDataSourcesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDataSourcesInput");
        formatter.field("filter_variable", &self.filter_variable);
        formatter.field("eq", &self.eq);
        formatter.field("gt", &self.gt);
        formatter.field("lt", &self.lt);
        formatter.field("ge", &self.ge);
        formatter.field("le", &self.le);
        formatter.field("ne", &self.ne);
        formatter.field("prefix", &self.prefix);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeBatchPredictionsInput {
    /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code>
    /// <b> </b>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
    /// </li>
    /// </ul>
    pub filter_variable: std::option::Option<crate::model::BatchPredictionFilterVariable>,
    /// <p>The equal to operator. The <code>BatchPrediction</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub eq: std::option::Option<std::string::String>,
    /// <p>The greater than operator. The <code>BatchPrediction</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub gt: std::option::Option<std::string::String>,
    /// <p>The less than operator. The <code>BatchPrediction</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub lt: std::option::Option<std::string::String>,
    /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub ge: std::option::Option<std::string::String>,
    /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub le: std::option::Option<std::string::String>,
    /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub ne: std::option::Option<std::string::String>,
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub prefix: std::option::Option<std::string::String>,
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub sort_order: std::option::Option<crate::model::SortOrder>,
    /// <p>An ID of the page in the paginated results.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
    pub limit: std::option::Option<i32>,
}
impl DescribeBatchPredictionsInput {
    /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code>
    /// <b> </b>
    /// <code>Name</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
    /// </li>
    /// </ul>
    pub fn filter_variable(
        &self,
    ) -> std::option::Option<&crate::model::BatchPredictionFilterVariable> {
        self.filter_variable.as_ref()
    }
    /// <p>The equal to operator. The <code>BatchPrediction</code> results will have
    /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
    pub fn eq(&self) -> std::option::Option<&str> {
        self.eq.as_deref()
    }
    /// <p>The greater than operator. The <code>BatchPrediction</code> results will
    /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
    pub fn gt(&self) -> std::option::Option<&str> {
        self.gt.as_deref()
    }
    /// <p>The less than operator. The <code>BatchPrediction</code> results will
    /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
    pub fn lt(&self) -> std::option::Option<&str> {
        self.lt.as_deref()
    }
    /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
    /// </p>
    pub fn ge(&self) -> std::option::Option<&str> {
        self.ge.as_deref()
    }
    /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
    pub fn le(&self) -> std::option::Option<&str> {
        self.le.as_deref()
    }
    /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
    pub fn ne(&self) -> std::option::Option<&str> {
        self.ne.as_deref()
    }
    /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
    /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code>
    /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
    /// this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
    /// <code>Prefix</code>:
    /// </p>
    ///
    /// <ul>
    /// <li>
    /// <p>2014-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09</p>
    /// </li>
    /// <li>
    /// <p>2014-09-09-Holiday</p>
    /// </li>
    /// </ul>
    pub fn prefix(&self) -> std::option::Option<&str> {
        self.prefix.as_deref()
    }
    /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
    /// </li>
    /// </ul>
    /// <p>Results are sorted by <code>FilterVariable</code>.</p>
    pub fn sort_order(&self) -> std::option::Option<&crate::model::SortOrder> {
        self.sort_order.as_ref()
    }
    /// <p>An ID of the page in the paginated results.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
    pub fn limit(&self) -> std::option::Option<i32> {
        self.limit
    }
}
impl std::fmt::Debug for DescribeBatchPredictionsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeBatchPredictionsInput");
        formatter.field("filter_variable", &self.filter_variable);
        formatter.field("eq", &self.eq);
        formatter.field("gt", &self.gt);
        formatter.field("lt", &self.lt);
        formatter.field("ge", &self.ge);
        formatter.field("le", &self.le);
        formatter.field("ne", &self.ne);
        formatter.field("prefix", &self.prefix);
        formatter.field("sort_order", &self.sort_order);
        formatter.field("next_token", &self.next_token);
        formatter.field("limit", &self.limit);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteTagsInput {
    /// <p>One or more tags to delete.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the tagged ML object.</p>
    pub resource_type: std::option::Option<crate::model::TaggableResourceType>,
}
impl DeleteTagsInput {
    /// <p>One or more tags to delete.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
    /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the tagged ML object.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TaggableResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for DeleteTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteTagsInput");
        formatter.field("tag_keys", &self.tag_keys);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteRealtimeEndpointInput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
}
impl DeleteRealtimeEndpointInput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteRealtimeEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteRealtimeEndpointInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteMlModelInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
}
impl DeleteMlModelInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteMlModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteMlModelInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteEvaluationInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
}
impl DeleteEvaluationInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteEvaluationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteEvaluationInput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDataSourceInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
    pub data_source_id: std::option::Option<std::string::String>,
}
impl DeleteDataSourceInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteDataSourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDataSourceInput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteBatchPredictionInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
}
impl DeleteBatchPredictionInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
}
impl std::fmt::Debug for DeleteBatchPredictionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteBatchPredictionInput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateRealtimeEndpointInput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
}
impl CreateRealtimeEndpointInput {
    /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
}
impl std::fmt::Debug for CreateRealtimeEndpointInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateRealtimeEndpointInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateMlModelInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    pub ml_model_name: std::option::Option<std::string::String>,
    /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
    /// <ul>
    /// <li>
    /// <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p>
    /// </li>
    /// <li>
    /// <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p>
    /// </li>
    /// <li>
    /// <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p>
    /// </li>
    /// </ul>
    /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
    pub ml_model_type: std::option::Option<crate::model::MlModelType>,
    /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
    /// a map of key-value pairs.</p>
    /// <p>The following is the current set of training parameters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
    /// input data, the size of the model might affect its performance.</p>
    /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
    /// observations to build the <code>MLModel</code>. The value is an integer that
    /// ranges from <code>1</code> to <code>10000</code>. The default value is
    /// <code>10</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling
    /// the data improves a model's ability to find the optimal solution for a variety
    /// of data types. The valid values are <code>auto</code> and <code>none</code>. The
    /// default value is <code>none</code>. We strongly recommend that you shuffle your data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to zero, resulting in a sparse feature set. If you use this
    /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L1 normalization. This parameter can't be used when
    /// <code>L2</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to small, nonzero values. If you use this parameter, start by
    /// specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L2 normalization. This parameter can't be used when
    /// <code>L1</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// </ul>
    pub parameters:
        std::option::Option<std::collections::HashMap<std::string::String, std::string::String>>,
    /// <p>The <code>DataSource</code> that points to the training data.</p>
    pub training_data_source_id: std::option::Option<std::string::String>,
    /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe
    /// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
    pub recipe: std::option::Option<std::string::String>,
    /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
    pub recipe_uri: std::option::Option<std::string::String>,
}
impl CreateMlModelInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
    pub fn ml_model_name(&self) -> std::option::Option<&str> {
        self.ml_model_name.as_deref()
    }
    /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
    /// <ul>
    /// <li>
    /// <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p>
    /// </li>
    /// <li>
    /// <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p>
    /// </li>
    /// <li>
    /// <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p>
    /// </li>
    /// </ul>
    /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
    pub fn ml_model_type(&self) -> std::option::Option<&crate::model::MlModelType> {
        self.ml_model_type.as_ref()
    }
    /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
    /// a map of key-value pairs.</p>
    /// <p>The following is the current set of training parameters:</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
    /// input data, the size of the model might affect its performance.</p>
    /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
    /// observations to build the <code>MLModel</code>. The value is an integer that
    /// ranges from <code>1</code> to <code>10000</code>. The default value is
    /// <code>10</code>.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling
    /// the data improves a model's ability to find the optimal solution for a variety
    /// of data types. The valid values are <code>auto</code> and <code>none</code>. The
    /// default value is <code>none</code>. We strongly recommend that you shuffle your data.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to zero, resulting in a sparse feature set. If you use this
    /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L1 normalization. This parameter can't be used when
    /// <code>L2</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
    /// overfitting the data by penalizing large coefficients. This tends to drive
    /// coefficients to small, nonzero values. If you use this parameter, start by
    /// specifying a small value, such as <code>1.0E-08</code>.</p>
    /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
    /// The default is to not use L2 normalization. This parameter can't be used when
    /// <code>L1</code> is specified. Use this parameter sparingly.</p>
    /// </li>
    /// </ul>
    pub fn parameters(
        &self,
    ) -> std::option::Option<&std::collections::HashMap<std::string::String, std::string::String>>
    {
        self.parameters.as_ref()
    }
    /// <p>The <code>DataSource</code> that points to the training data.</p>
    pub fn training_data_source_id(&self) -> std::option::Option<&str> {
        self.training_data_source_id.as_deref()
    }
    /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe
    /// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
    pub fn recipe(&self) -> std::option::Option<&str> {
        self.recipe.as_deref()
    }
    /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
    pub fn recipe_uri(&self) -> std::option::Option<&str> {
        self.recipe_uri.as_deref()
    }
}
impl std::fmt::Debug for CreateMlModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateMlModelInput");
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("ml_model_name", &self.ml_model_name);
        formatter.field("ml_model_type", &self.ml_model_type);
        formatter.field("parameters", &self.parameters);
        formatter.field("training_data_source_id", &self.training_data_source_id);
        formatter.field("recipe", &self.recipe);
        formatter.field("recipe_uri", &self.recipe_uri);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateEvaluationInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
    pub evaluation_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
    pub evaluation_name: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
    /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
    /// must match the schema used to create the <code>MLModel</code>.</p>
    pub evaluation_data_source_id: std::option::Option<std::string::String>,
}
impl CreateEvaluationInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
    pub fn evaluation_id(&self) -> std::option::Option<&str> {
        self.evaluation_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
    pub fn evaluation_name(&self) -> std::option::Option<&str> {
        self.evaluation_name.as_deref()
    }
    /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
    /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
    /// must match the schema used to create the <code>MLModel</code>.</p>
    pub fn evaluation_data_source_id(&self) -> std::option::Option<&str> {
        self.evaluation_data_source_id.as_deref()
    }
}
impl std::fmt::Debug for CreateEvaluationInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateEvaluationInput");
        formatter.field("evaluation_id", &self.evaluation_id);
        formatter.field("evaluation_name", &self.evaluation_name);
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field("evaluation_data_source_id", &self.evaluation_data_source_id);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceFromS3Input {
    /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The data specification of a <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>DataLocationS3 - The Amazon S3 location of the observation data.</p>
    /// </li>
    /// <li>
    /// <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p>
    /// </li>
    /// <li>
    /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
    /// </li>
    /// <li>
    /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
    /// <p> Sample -
    /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub data_spec: std::option::Option<crate::model::S3DataSpec>,
    /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
    /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
    /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
    pub compute_statistics: bool,
}
impl CreateDataSourceFromS3Input {
    /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The data specification of a <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>DataLocationS3 - The Amazon S3 location of the observation data.</p>
    /// </li>
    /// <li>
    /// <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p>
    /// </li>
    /// <li>
    /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
    /// </li>
    /// <li>
    /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
    /// <p> Sample -
    /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn data_spec(&self) -> std::option::Option<&crate::model::S3DataSpec> {
        self.data_spec.as_ref()
    }
    /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
    /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
    /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
    pub fn compute_statistics(&self) -> bool {
        self.compute_statistics
    }
}
impl std::fmt::Debug for CreateDataSourceFromS3Input {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceFromS3Input");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("data_spec", &self.data_spec);
        formatter.field("compute_statistics", &self.compute_statistics);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceFromRedshiftInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>DatabaseInformation -</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatabaseName</code> - The name of the Amazon Redshift database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p>
    /// </li>
    /// <li>
    /// <p>SelectSqlQuery - The query that is used to retrieve the observation data for the
    /// <code>Datasource</code>.</p>
    /// </li>
    /// <li>
    /// <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
    /// Redshift data. The data retrieved from Amazon Redshift using
    /// the <code>SelectSqlQuery</code> query is stored in this location.</p>
    /// </li>
    /// <li>
    /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
    /// </li>
    /// <li>
    /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
    /// </li>
    /// <li>
    /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p>
    /// <p> Sample -
    /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub data_spec: std::option::Option<crate::model::RedshiftDataSpec>,
    /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p>
    /// </li>
    /// <li>
    /// <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
    /// </p>
    /// </li>
    /// </ul>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
    /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
    /// This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to
    /// be used for <code>MLModel</code> training.</p>
    pub compute_statistics: bool,
}
impl CreateDataSourceFromRedshiftInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>DatabaseInformation -</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatabaseName</code> - The name of the Amazon Redshift database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p>
    /// </li>
    /// <li>
    /// <p>SelectSqlQuery - The query that is used to retrieve the observation data for the
    /// <code>Datasource</code>.</p>
    /// </li>
    /// <li>
    /// <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
    /// Redshift data. The data retrieved from Amazon Redshift using
    /// the <code>SelectSqlQuery</code> query is stored in this location.</p>
    /// </li>
    /// <li>
    /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
    /// </li>
    /// <li>
    /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
    /// </li>
    /// <li>
    /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p>
    /// <p> Sample -
    /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn data_spec(&self) -> std::option::Option<&crate::model::RedshiftDataSpec> {
        self.data_spec.as_ref()
    }
    /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
    ///
    /// <ul>
    /// <li>
    /// <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p>
    /// </li>
    /// <li>
    /// <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
    /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
    /// This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to
    /// be used for <code>MLModel</code> training.</p>
    pub fn compute_statistics(&self) -> bool {
        self.compute_statistics
    }
}
impl std::fmt::Debug for CreateDataSourceFromRedshiftInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceFromRedshiftInput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("data_spec", &self.data_spec);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("compute_statistics", &self.compute_statistics);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDataSourceFromRdsInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN)
    /// becomes the ID for a <code>DataSource</code>.</p>
    pub data_source_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
    pub data_source_name: std::option::Option<std::string::String>,
    /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>DatabaseInformation -</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatabaseName</code> - The name of the Amazon RDS database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p>
    /// </li>
    /// <li>
    /// <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon
    /// Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
    /// </li>
    /// <li>
    /// <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS
    /// to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
    /// </li>
    /// <li>
    /// <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p>
    /// </li>
    /// <li>
    /// <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p>
    /// </li>
    /// <li>
    /// <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>
    /// </li>
    /// <li>
    /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
    /// </li>
    /// <li>
    /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
    /// </li>
    /// <li>
    /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
    /// <p> Sample -
    /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub rds_data: std::option::Option<crate::model::RdsDataSpec>,
    /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data
    /// pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
    /// <p></p>
    pub role_arn: std::option::Option<std::string::String>,
    /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
    /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
    /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
    /// </p>
    pub compute_statistics: bool,
}
impl CreateDataSourceFromRdsInput {
    /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN)
    /// becomes the ID for a <code>DataSource</code>.</p>
    pub fn data_source_id(&self) -> std::option::Option<&str> {
        self.data_source_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
    pub fn data_source_name(&self) -> std::option::Option<&str> {
        self.data_source_name.as_deref()
    }
    /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
    /// <ul>
    /// <li>
    /// <p>DatabaseInformation -</p>
    /// <ul>
    /// <li>
    /// <p>
    /// <code>DatabaseName</code> - The name of the Amazon RDS database.</p>
    /// </li>
    /// <li>
    /// <p>
    /// <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p>
    /// </li>
    /// </ul>
    /// </li>
    /// <li>
    /// <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p>
    /// </li>
    /// <li>
    /// <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon
    /// Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
    /// </li>
    /// <li>
    /// <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS
    /// to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
    /// </li>
    /// <li>
    /// <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p>
    /// </li>
    /// <li>
    /// <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p>
    /// </li>
    /// <li>
    /// <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>
    /// </li>
    /// <li>
    /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
    /// </li>
    /// <li>
    /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
    /// </li>
    /// <li>
    /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
    /// <p> Sample -
    /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
    /// </p>
    /// </li>
    /// </ul>
    pub fn rds_data(&self) -> std::option::Option<&crate::model::RdsDataSpec> {
        self.rds_data.as_ref()
    }
    /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data
    /// pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
    /// <p></p>
    pub fn role_arn(&self) -> std::option::Option<&str> {
        self.role_arn.as_deref()
    }
    /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
    /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
    /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
    /// </p>
    pub fn compute_statistics(&self) -> bool {
        self.compute_statistics
    }
}
impl std::fmt::Debug for CreateDataSourceFromRdsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDataSourceFromRdsInput");
        formatter.field("data_source_id", &self.data_source_id);
        formatter.field("data_source_name", &self.data_source_name);
        formatter.field("rds_data", &self.rds_data);
        formatter.field("role_arn", &self.role_arn);
        formatter.field("compute_statistics", &self.compute_statistics);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateBatchPredictionInput {
    /// <p>A user-supplied ID that uniquely identifies the
    /// <code>BatchPrediction</code>.</p>
    pub batch_prediction_id: std::option::Option<std::string::String>,
    /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
    pub batch_prediction_name: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
    pub ml_model_id: std::option::Option<std::string::String>,
    /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
    pub batch_prediction_data_source_id: std::option::Option<std::string::String>,
    /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
    /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
    pub output_uri: std::option::Option<std::string::String>,
}
impl CreateBatchPredictionInput {
    /// <p>A user-supplied ID that uniquely identifies the
    /// <code>BatchPrediction</code>.</p>
    pub fn batch_prediction_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_id.as_deref()
    }
    /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
    pub fn batch_prediction_name(&self) -> std::option::Option<&str> {
        self.batch_prediction_name.as_deref()
    }
    /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
    pub fn ml_model_id(&self) -> std::option::Option<&str> {
        self.ml_model_id.as_deref()
    }
    /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
    pub fn batch_prediction_data_source_id(&self) -> std::option::Option<&str> {
        self.batch_prediction_data_source_id.as_deref()
    }
    /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
    /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
    pub fn output_uri(&self) -> std::option::Option<&str> {
        self.output_uri.as_deref()
    }
}
impl std::fmt::Debug for CreateBatchPredictionInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateBatchPredictionInput");
        formatter.field("batch_prediction_id", &self.batch_prediction_id);
        formatter.field("batch_prediction_name", &self.batch_prediction_name);
        formatter.field("ml_model_id", &self.ml_model_id);
        formatter.field(
            "batch_prediction_data_source_id",
            &self.batch_prediction_data_source_id,
        );
        formatter.field("output_uri", &self.output_uri);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AddTagsInput {
    /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the ML object to tag.</p>
    pub resource_type: std::option::Option<crate::model::TaggableResourceType>,
}
impl AddTagsInput {
    /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
    /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
    pub fn resource_id(&self) -> std::option::Option<&str> {
        self.resource_id.as_deref()
    }
    /// <p>The type of the ML object to tag.</p>
    pub fn resource_type(&self) -> std::option::Option<&crate::model::TaggableResourceType> {
        self.resource_type.as_ref()
    }
}
impl std::fmt::Debug for AddTagsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AddTagsInput");
        formatter.field("tags", &self.tags);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
