// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `AmazonML_20141212`.
///
/// This client allows ergonomic access to a `AmazonML_20141212`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `AddTags` operation.
    ///
    /// See [`AddTags`](crate::client::fluent_builders::AddTags) for more information about the
    /// operation and its arguments.
    pub fn add_tags(&self) -> fluent_builders::AddTags<C, M, R> {
        fluent_builders::AddTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateBatchPrediction` operation.
    ///
    /// See [`CreateBatchPrediction`](crate::client::fluent_builders::CreateBatchPrediction) for more information about the
    /// operation and its arguments.
    pub fn create_batch_prediction(&self) -> fluent_builders::CreateBatchPrediction<C, M, R> {
        fluent_builders::CreateBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSourceFromRDS` operation.
    ///
    /// See [`CreateDataSourceFromRDS`](crate::client::fluent_builders::CreateDataSourceFromRDS) for more information about the
    /// operation and its arguments.
    pub fn create_data_source_from_rds(&self) -> fluent_builders::CreateDataSourceFromRDS<C, M, R> {
        fluent_builders::CreateDataSourceFromRDS::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSourceFromRedshift` operation.
    ///
    /// See [`CreateDataSourceFromRedshift`](crate::client::fluent_builders::CreateDataSourceFromRedshift) for more information about the
    /// operation and its arguments.
    pub fn create_data_source_from_redshift(
        &self,
    ) -> fluent_builders::CreateDataSourceFromRedshift<C, M, R> {
        fluent_builders::CreateDataSourceFromRedshift::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateDataSourceFromS3` operation.
    ///
    /// See [`CreateDataSourceFromS3`](crate::client::fluent_builders::CreateDataSourceFromS3) for more information about the
    /// operation and its arguments.
    pub fn create_data_source_from_s3(&self) -> fluent_builders::CreateDataSourceFromS3<C, M, R> {
        fluent_builders::CreateDataSourceFromS3::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateEvaluation` operation.
    ///
    /// See [`CreateEvaluation`](crate::client::fluent_builders::CreateEvaluation) for more information about the
    /// operation and its arguments.
    pub fn create_evaluation(&self) -> fluent_builders::CreateEvaluation<C, M, R> {
        fluent_builders::CreateEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateMLModel` operation.
    ///
    /// See [`CreateMLModel`](crate::client::fluent_builders::CreateMLModel) for more information about the
    /// operation and its arguments.
    pub fn create_ml_model(&self) -> fluent_builders::CreateMLModel<C, M, R> {
        fluent_builders::CreateMLModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateRealtimeEndpoint` operation.
    ///
    /// See [`CreateRealtimeEndpoint`](crate::client::fluent_builders::CreateRealtimeEndpoint) for more information about the
    /// operation and its arguments.
    pub fn create_realtime_endpoint(&self) -> fluent_builders::CreateRealtimeEndpoint<C, M, R> {
        fluent_builders::CreateRealtimeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteBatchPrediction` operation.
    ///
    /// See [`DeleteBatchPrediction`](crate::client::fluent_builders::DeleteBatchPrediction) for more information about the
    /// operation and its arguments.
    pub fn delete_batch_prediction(&self) -> fluent_builders::DeleteBatchPrediction<C, M, R> {
        fluent_builders::DeleteBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataSource` operation.
    ///
    /// See [`DeleteDataSource`](crate::client::fluent_builders::DeleteDataSource) for more information about the
    /// operation and its arguments.
    pub fn delete_data_source(&self) -> fluent_builders::DeleteDataSource<C, M, R> {
        fluent_builders::DeleteDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteEvaluation` operation.
    ///
    /// See [`DeleteEvaluation`](crate::client::fluent_builders::DeleteEvaluation) for more information about the
    /// operation and its arguments.
    pub fn delete_evaluation(&self) -> fluent_builders::DeleteEvaluation<C, M, R> {
        fluent_builders::DeleteEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteMLModel` operation.
    ///
    /// See [`DeleteMLModel`](crate::client::fluent_builders::DeleteMLModel) for more information about the
    /// operation and its arguments.
    pub fn delete_ml_model(&self) -> fluent_builders::DeleteMLModel<C, M, R> {
        fluent_builders::DeleteMLModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteRealtimeEndpoint` operation.
    ///
    /// See [`DeleteRealtimeEndpoint`](crate::client::fluent_builders::DeleteRealtimeEndpoint) for more information about the
    /// operation and its arguments.
    pub fn delete_realtime_endpoint(&self) -> fluent_builders::DeleteRealtimeEndpoint<C, M, R> {
        fluent_builders::DeleteRealtimeEndpoint::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteTags` operation.
    ///
    /// See [`DeleteTags`](crate::client::fluent_builders::DeleteTags) for more information about the
    /// operation and its arguments.
    pub fn delete_tags(&self) -> fluent_builders::DeleteTags<C, M, R> {
        fluent_builders::DeleteTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeBatchPredictions` operation.
    ///
    /// See [`DescribeBatchPredictions`](crate::client::fluent_builders::DescribeBatchPredictions) for more information about the
    /// operation and its arguments.
    pub fn describe_batch_predictions(&self) -> fluent_builders::DescribeBatchPredictions<C, M, R> {
        fluent_builders::DescribeBatchPredictions::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataSources` operation.
    ///
    /// See [`DescribeDataSources`](crate::client::fluent_builders::DescribeDataSources) for more information about the
    /// operation and its arguments.
    pub fn describe_data_sources(&self) -> fluent_builders::DescribeDataSources<C, M, R> {
        fluent_builders::DescribeDataSources::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeEvaluations` operation.
    ///
    /// See [`DescribeEvaluations`](crate::client::fluent_builders::DescribeEvaluations) for more information about the
    /// operation and its arguments.
    pub fn describe_evaluations(&self) -> fluent_builders::DescribeEvaluations<C, M, R> {
        fluent_builders::DescribeEvaluations::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeMLModels` operation.
    ///
    /// See [`DescribeMLModels`](crate::client::fluent_builders::DescribeMLModels) for more information about the
    /// operation and its arguments.
    pub fn describe_ml_models(&self) -> fluent_builders::DescribeMLModels<C, M, R> {
        fluent_builders::DescribeMLModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeTags` operation.
    ///
    /// See [`DescribeTags`](crate::client::fluent_builders::DescribeTags) for more information about the
    /// operation and its arguments.
    pub fn describe_tags(&self) -> fluent_builders::DescribeTags<C, M, R> {
        fluent_builders::DescribeTags::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetBatchPrediction` operation.
    ///
    /// See [`GetBatchPrediction`](crate::client::fluent_builders::GetBatchPrediction) for more information about the
    /// operation and its arguments.
    pub fn get_batch_prediction(&self) -> fluent_builders::GetBatchPrediction<C, M, R> {
        fluent_builders::GetBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetDataSource` operation.
    ///
    /// See [`GetDataSource`](crate::client::fluent_builders::GetDataSource) for more information about the
    /// operation and its arguments.
    pub fn get_data_source(&self) -> fluent_builders::GetDataSource<C, M, R> {
        fluent_builders::GetDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetEvaluation` operation.
    ///
    /// See [`GetEvaluation`](crate::client::fluent_builders::GetEvaluation) for more information about the
    /// operation and its arguments.
    pub fn get_evaluation(&self) -> fluent_builders::GetEvaluation<C, M, R> {
        fluent_builders::GetEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `GetMLModel` operation.
    ///
    /// See [`GetMLModel`](crate::client::fluent_builders::GetMLModel) for more information about the
    /// operation and its arguments.
    pub fn get_ml_model(&self) -> fluent_builders::GetMLModel<C, M, R> {
        fluent_builders::GetMLModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `Predict` operation.
    ///
    /// See [`Predict`](crate::client::fluent_builders::Predict) for more information about the
    /// operation and its arguments.
    pub fn predict(&self) -> fluent_builders::Predict<C, M, R> {
        fluent_builders::Predict::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateBatchPrediction` operation.
    ///
    /// See [`UpdateBatchPrediction`](crate::client::fluent_builders::UpdateBatchPrediction) for more information about the
    /// operation and its arguments.
    pub fn update_batch_prediction(&self) -> fluent_builders::UpdateBatchPrediction<C, M, R> {
        fluent_builders::UpdateBatchPrediction::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDataSource` operation.
    ///
    /// See [`UpdateDataSource`](crate::client::fluent_builders::UpdateDataSource) for more information about the
    /// operation and its arguments.
    pub fn update_data_source(&self) -> fluent_builders::UpdateDataSource<C, M, R> {
        fluent_builders::UpdateDataSource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateEvaluation` operation.
    ///
    /// See [`UpdateEvaluation`](crate::client::fluent_builders::UpdateEvaluation) for more information about the
    /// operation and its arguments.
    pub fn update_evaluation(&self) -> fluent_builders::UpdateEvaluation<C, M, R> {
        fluent_builders::UpdateEvaluation::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateMLModel` operation.
    ///
    /// See [`UpdateMLModel`](crate::client::fluent_builders::UpdateMLModel) for more information about the
    /// operation and its arguments.
    pub fn update_ml_model(&self) -> fluent_builders::UpdateMLModel<C, M, R> {
        fluent_builders::UpdateMLModel::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `AddTags`.
    ///
    /// <p>Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key
    /// and an optional value. If you add a tag using a key that is already associated with the ML object,
    /// <code>AddTags</code> updates the tag's value.</p>
    #[derive(std::fmt::Debug)]
    pub struct AddTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::add_tags_input::Builder,
    }
    impl<C, M, R> AddTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `AddTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::AddTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::AddTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::AddTagsInputOperationOutputAlias,
                crate::output::AddTagsOutput,
                crate::error::AddTagsError,
                crate::input::AddTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value pairs to use to create tags. If you specify a key without specifying a value, Amazon ML creates a tag with the specified key and a value of null.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
        /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the ML object to tag. For example, <code>exampleModelId</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The type of the ML object to tag.</p>
        pub fn resource_type(mut self, inp: crate::model::TaggableResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of the ML object to tag.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateBatchPrediction`.
    ///
    /// <p>Generates predictions for a group of observations. The observations to process exist in one or more data files referenced
    /// by a <code>DataSource</code>. This operation creates a new <code>BatchPrediction</code>, and uses an <code>MLModel</code> and the data
    /// files referenced by the <code>DataSource</code> as information sources.
    /// </p>
    ///
    /// <p>
    /// <code>CreateBatchPrediction</code> is an asynchronous operation. In response to <code>CreateBatchPrediction</code>,
    /// Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>BatchPrediction</code> status to <code>PENDING</code>.
    /// After the <code>BatchPrediction</code> completes, Amazon ML sets the status to <code>COMPLETED</code>.
    /// </p>
    /// <p>You can poll for status updates by using the <a>GetBatchPrediction</a> operation and checking the <code>Status</code> parameter of the result. After the <code>COMPLETED</code> status appears,
    /// the results are available in the location specified by the <code>OutputUri</code> parameter.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateBatchPrediction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_batch_prediction_input::Builder,
    }
    impl<C, M, R> CreateBatchPrediction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateBatchPredictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateBatchPredictionInputOperationOutputAlias,
                crate::output::CreateBatchPredictionOutput,
                crate::error::CreateBatchPredictionError,
                crate::input::CreateBatchPredictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the
        /// <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the
        /// <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
        pub fn batch_prediction_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>BatchPrediction</code>. <code>BatchPredictionName</code> can only use the UTF-8 character set.</p>
        pub fn set_batch_prediction_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_name(input);
            self
        }
        /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>The ID of the <code>MLModel</code> that will generate predictions for the group of observations. </p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
        pub fn batch_prediction_data_source_id(
            mut self,
            inp: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.batch_prediction_data_source_id(inp);
            self
        }
        /// <p>The ID of the <code>DataSource</code> that points to the group of observations to predict.</p>
        pub fn set_batch_prediction_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_data_source_id(input);
            self
        }
        /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
        /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn output_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.output_uri(inp);
            self
        }
        /// <p>The location of an Amazon Simple Storage Service (Amazon S3) bucket or directory to store the batch prediction results. The following substrings are not allowed in the <code>s3 key</code> portion of the <code>outputURI</code> field: ':', '//', '/./', '/../'.</p>
        /// <p>Amazon ML needs permissions to store and retrieve the logs on your behalf. For information about how to set permissions, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn set_output_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_output_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSourceFromRDS`.
    ///
    /// <p>Creates a <code>DataSource</code> object from an <a href="http://aws.amazon.com/rds/"> Amazon Relational Database Service</a> (Amazon RDS). A <code>DataSource</code> references data that can be used to perform <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.</p>
    ///
    /// <p>
    /// <code>CreateDataSourceFromRDS</code> is an asynchronous operation. In response to <code>CreateDataSourceFromRDS</code>,
    /// Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>.
    /// After the <code>DataSource</code> is created and ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>.
    /// <code>DataSource</code> in the <code>COMPLETED</code> or <code>PENDING</code> state can
    /// be used only to perform <code>>CreateMLModel</code>>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
    /// </p>
    /// <p>
    /// If Amazon ML cannot accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code> attribute of the <code>GetDataSource</code> operation response.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSourceFromRDS<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_from_rds_input::Builder,
    }
    impl<C, M, R> CreateDataSourceFromRDS<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSourceFromRDS`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceFromRdsOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceFromRDSError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceFromRdsInputOperationOutputAlias,
                crate::output::CreateDataSourceFromRdsOutput,
                crate::error::CreateDataSourceFromRDSError,
                crate::input::CreateDataSourceFromRdsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN)
        /// becomes the ID for a <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>. Typically, an Amazon Resource Number (ARN)
        /// becomes the ID for a <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>.</p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon
        /// Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS
        /// to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn rds_data(mut self, inp: crate::model::RdsDataSpec) -> Self {
            self.inner = self.inner.rds_data(inp);
            self
        }
        /// <p>The data specification of an Amazon RDS <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>InstanceIdentifier </code> - A unique identifier for the Amazon RDS database instance.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon RDS database.</p>
        /// </li>
        /// <li>
        /// <p>ResourceRole - A role (DataPipelineDefaultResourceRole) assumed by an EC2 instance to carry out the copy task from Amazon RDS to Amazon
        /// Simple Storage Service (Amazon S3). For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>ServiceRole - A role (DataPipelineDefaultRole) assumed by the AWS Data Pipeline service to monitor the progress of the copy task from Amazon RDS
        /// to Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/datapipeline/latest/DeveloperGuide/dp-iam-roles.html">Role templates</a> for data pipelines.</p>
        /// </li>
        /// <li>
        /// <p>SecurityInfo - The security information to use to access an RDS DB instance. You need to set up appropriate ingress rules for the security entity IDs provided to allow access to the Amazon RDS instance. Specify a [<code>SubnetId</code>, <code>SecurityGroupIds</code>] pair for a VPC-based RDS DB instance.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - A query that is used to retrieve the observation data for the <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon S3 location for staging Amazon RDS data. The data retrieved from Amazon RDS using <code>SelectSqlQuery</code> is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_rds_data(
            mut self,
            input: std::option::Option<crate::model::RdsDataSpec>,
        ) -> Self {
            self.inner = self.inner.set_rds_data(input);
            self
        }
        /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data
        /// pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
        /// <p></p>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>The role that Amazon ML assumes on behalf of the user to create and activate a data
        /// pipeline in the user's account and copy data using the <code>SelectSqlQuery</code> query from Amazon RDS to Amazon S3.</p>
        /// <p></p>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
        /// </p>
        pub fn compute_statistics(mut self, inp: bool) -> Self {
            self.inner = self.inner.compute_statistics(inp);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.
        /// </p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_compute_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSourceFromRedshift`.
    ///
    /// <p>Creates a <code>DataSource</code> from a database hosted on an Amazon Redshift cluster. A
    /// <code>DataSource</code> references data that can be used to perform either <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code>
    /// operations.</p>
    ///
    /// <p>
    /// <code>CreateDataSourceFromRedshift</code> is an asynchronous operation. In response to <code>CreateDataSourceFromRedshift</code>, Amazon Machine Learning (Amazon ML) immediately returns and sets the <code>DataSource</code> status to <code>PENDING</code>.
    /// After the <code>DataSource</code> is created and ready for use, Amazon ML sets the <code>Status</code> parameter to <code>COMPLETED</code>.
    /// <code>DataSource</code> in <code>COMPLETED</code> or <code>PENDING</code> states can be
    /// used to perform only <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or <code>CreateBatchPrediction</code> operations.
    /// </p>
    ///
    /// <p>
    /// If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to <code>FAILED</code> and includes an error message in the <code>Message</code>
    /// attribute of the <code>GetDataSource</code> operation response.
    /// </p>
    ///
    /// <p>The observations should be contained in the database hosted on an Amazon Redshift cluster
    /// and should be specified by a <code>SelectSqlQuery</code> query. Amazon ML executes an
    /// <code>Unload</code> command in Amazon Redshift to transfer the result set of
    /// the <code>SelectSqlQuery</code> query to <code>S3StagingLocation</code>.</p>
    ///
    /// <p>After the <code>DataSource</code> has been created, it's ready for use in evaluations and
    /// batch predictions. If you plan to use the <code>DataSource</code> to train an
    /// <code>MLModel</code>, the <code>DataSource</code> also requires a recipe. A recipe
    /// describes how each input variable will be used in training an <code>MLModel</code>. Will
    /// the variable be included or excluded from training? Will the variable be manipulated;
    /// for example, will it be combined with another variable or will it be split apart into
    /// word combinations? The recipe provides answers to these questions.</p>
    /// <p>You can't change an existing datasource, but you can copy and modify the settings from an
    /// existing Amazon Redshift datasource to create a new datasource. To do so, call
    /// <code>GetDataSource</code> for an existing datasource and copy the values to a
    /// <code>CreateDataSource</code> call. Change the settings that you want to change and
    /// make sure that all required fields have the appropriate values.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSourceFromRedshift<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_from_redshift_input::Builder,
    }
    impl<C, M, R> CreateDataSourceFromRedshift<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSourceFromRedshift`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceFromRedshiftOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceFromRedshiftError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceFromRedshiftInputOperationOutputAlias,
                crate::output::CreateDataSourceFromRedshiftOutput,
                crate::error::CreateDataSourceFromRedshiftError,
                crate::input::CreateDataSourceFromRedshiftInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - The query that is used to retrieve the observation data for the
        /// <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
        /// Redshift data. The data retrieved from Amazon Redshift using
        /// the <code>SelectSqlQuery</code> query is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn data_spec(mut self, inp: crate::model::RedshiftDataSpec) -> Self {
            self.inner = self.inner.data_spec(inp);
            self
        }
        /// <p>The data specification of an Amazon Redshift <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DatabaseInformation -</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>DatabaseName</code> - The name of the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code> ClusterIdentifier</code> - The unique ID for the Amazon Redshift cluster.</p>
        /// </li>
        /// </ul>
        /// </li>
        /// <li>
        /// <p>DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.</p>
        /// </li>
        /// <li>
        /// <p>SelectSqlQuery - The query that is used to retrieve the observation data for the
        /// <code>Datasource</code>.</p>
        /// </li>
        /// <li>
        /// <p>S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
        /// Redshift data. The data retrieved from Amazon Redshift using
        /// the <code>SelectSqlQuery</code> query is stored in this location.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaUri - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>DataSource</code>.</p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_data_spec(
            mut self,
            input: std::option::Option<crate::model::RedshiftDataSpec>,
        ) -> Self {
            self.inner = self.inner.set_data_spec(input);
            self
        }
        /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p>
        /// </li>
        /// <li>
        /// <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn role_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.role_arn(inp);
            self
        }
        /// <p>A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:</p>
        ///
        /// <ul>
        /// <li>
        /// <p>A security group to allow Amazon ML to execute the <code>SelectSqlQuery</code> query on an Amazon Redshift cluster</p>
        /// </li>
        /// <li>
        /// <p>An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the <code>S3StagingLocation</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_role_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_role_arn(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to
        /// be used for <code>MLModel</code> training.</p>
        pub fn compute_statistics(mut self, inp: bool) -> Self {
            self.inner = self.inner.compute_statistics(inp);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code>DataSource</code> needs to
        /// be used for <code>MLModel</code> training.</p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_compute_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateDataSourceFromS3`.
    ///
    /// <p>Creates a <code>DataSource</code> object. A <code>DataSource</code> references data that
    /// can be used to perform  <code>CreateMLModel</code>, <code>CreateEvaluation</code>, or
    /// <code>CreateBatchPrediction</code> operations.</p>
    ///
    /// <p>
    /// <code>CreateDataSourceFromS3</code> is an asynchronous operation. In response to
    /// <code>CreateDataSourceFromS3</code>, Amazon Machine Learning (Amazon ML) immediately
    /// returns and sets the <code>DataSource</code> status to <code>PENDING</code>. After the
    /// <code>DataSource</code> has been created and is ready for use, Amazon ML sets the
    /// <code>Status</code> parameter to <code>COMPLETED</code>. <code>DataSource</code> in
    /// the <code>COMPLETED</code> or <code>PENDING</code> state can be used to perform only
    /// <code>CreateMLModel</code>, <code>CreateEvaluation</code> or
    /// <code>CreateBatchPrediction</code> operations. </p>
    ///
    /// <p> If Amazon ML can't accept the input source, it sets the <code>Status</code> parameter to
    /// <code>FAILED</code> and includes an error message in the <code>Message</code>
    /// attribute of the <code>GetDataSource</code> operation response. </p>
    ///
    /// <p>The observation data used in a <code>DataSource</code> should be ready to use; that is,
    /// it should have a consistent structure, and missing data values should be kept to a
    /// minimum. The observation data must reside in one or more .csv files in an Amazon Simple
    /// Storage Service (Amazon S3) location, along with a schema that describes the data items
    /// by name and type. The same schema must be used for all of the data files referenced by
    /// the <code>DataSource</code>. </p>
    /// <p>After the <code>DataSource</code> has been created, it's ready to use in evaluations and
    /// batch predictions. If you plan to use the <code>DataSource</code> to train an
    /// <code>MLModel</code>, the <code>DataSource</code> also needs a recipe. A recipe
    /// describes how each input variable will be used in training an <code>MLModel</code>. Will
    /// the variable be included or excluded from training? Will the variable be manipulated;
    /// for example, will it be combined with another variable or will it be split apart into
    /// word combinations? The recipe provides answers to these questions.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataSourceFromS3<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_data_source_from_s3_input::Builder,
    }
    impl<C, M, R> CreateDataSourceFromS3<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataSourceFromS3`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDataSourceFromS3Output,
            aws_smithy_http::result::SdkError<crate::error::CreateDataSourceFromS3Error>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDataSourceFromS3InputOperationOutputAlias,
                crate::output::CreateDataSourceFromS3Output,
                crate::error::CreateDataSourceFromS3Error,
                crate::input::CreateDataSourceFromS3InputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>A user-supplied identifier that uniquely identifies the <code>DataSource</code>. </p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>DataSource</code>. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
        /// <p>The data specification of a <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DataLocationS3 - The Amazon S3 location of the observation data.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn data_spec(mut self, inp: crate::model::S3DataSpec) -> Self {
            self.inner = self.inner.data_spec(inp);
            self
        }
        /// <p>The data specification of a <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>DataLocationS3 - The Amazon S3 location of the observation data.</p>
        /// </li>
        /// <li>
        /// <p>DataSchemaLocationS3 - The Amazon S3 location of the <code>DataSchema</code>.</p>
        /// </li>
        /// <li>
        /// <p>DataSchema - A JSON string representing the schema. This is not required if <code>DataSchemaUri</code> is specified. </p>
        /// </li>
        /// <li>
        /// <p>DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the <code>Datasource</code>. </p>
        /// <p> Sample -
        /// <code> "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"</code>
        /// </p>
        /// </li>
        /// </ul>
        pub fn set_data_spec(
            mut self,
            input: std::option::Option<crate::model::S3DataSpec>,
        ) -> Self {
            self.inner = self.inner.set_data_spec(input);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
        pub fn compute_statistics(mut self, inp: bool) -> Self {
            self.inner = self.inner.compute_statistics(inp);
            self
        }
        /// <p>The compute statistics for a <code>DataSource</code>. The statistics are generated from the observation data referenced by
        /// a <code>DataSource</code>. Amazon ML uses the statistics internally during <code>MLModel</code> training.
        /// This parameter must be set to <code>true</code> if the <code></code>DataSource<code></code> needs to be used for <code>MLModel</code> training.</p>
        pub fn set_compute_statistics(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_compute_statistics(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateEvaluation`.
    ///
    /// <p>Creates a new <code>Evaluation</code> of an <code>MLModel</code>. An <code>MLModel</code> is evaluated on a set of observations associated to a <code>DataSource</code>. Like a <code>DataSource</code>
    /// for an <code>MLModel</code>, the <code>DataSource</code> for an <code>Evaluation</code> contains values for the <code>Target Variable</code>. The <code>Evaluation</code> compares the predicted result for each observation to the actual outcome and provides a
    /// summary so that you know how effective the <code>MLModel</code> functions on the test
    /// data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding <code>MLModelType</code>: <code>BINARY</code>, <code>REGRESSION</code> or <code>MULTICLASS</code>.
    ///
    /// </p>
    /// <p>
    /// <code>CreateEvaluation</code> is an asynchronous operation. In response to <code>CreateEvaluation</code>, Amazon Machine Learning (Amazon ML) immediately
    /// returns and sets the evaluation status to <code>PENDING</code>. After the <code>Evaluation</code> is created and ready for use,
    /// Amazon ML sets the status to <code>COMPLETED</code>.
    /// </p>
    /// <p>You can use the <code>GetEvaluation</code> operation to check progress of the evaluation during the creation operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateEvaluation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_evaluation_input::Builder,
    }
    impl<C, M, R> CreateEvaluation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateEvaluationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateEvaluationInputOperationOutputAlias,
                crate::output::CreateEvaluationOutput,
                crate::error::CreateEvaluationError,
                crate::input::CreateEvaluationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
        pub fn evaluation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code>.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
        pub fn evaluation_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>Evaluation</code>.</p>
        pub fn set_evaluation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_name(input);
            self
        }
        /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
        /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>The ID of the <code>MLModel</code> to evaluate.</p>
        /// <p>The schema used in creating the <code>MLModel</code> must match the schema of the <code>DataSource</code> used in the <code>Evaluation</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
        /// must match the schema used to create the <code>MLModel</code>.</p>
        pub fn evaluation_data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_data_source_id(inp);
            self
        }
        /// <p>The ID of the <code>DataSource</code> for the evaluation. The schema of the <code>DataSource</code>
        /// must match the schema used to create the <code>MLModel</code>.</p>
        pub fn set_evaluation_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateMLModel`.
    ///
    /// <p>Creates a new <code>MLModel</code> using the <code>DataSource</code> and the recipe as
    /// information sources. </p>
    /// <p>An <code>MLModel</code> is nearly immutable. Users can update only the
    /// <code>MLModelName</code> and the <code>ScoreThreshold</code> in an
    /// <code>MLModel</code> without creating a new <code>MLModel</code>. </p>
    /// <p>
    /// <code>CreateMLModel</code> is an asynchronous operation. In response to
    /// <code>CreateMLModel</code>, Amazon Machine Learning (Amazon ML) immediately returns
    /// and sets the <code>MLModel</code> status to <code>PENDING</code>. After the
    /// <code>MLModel</code> has been created and ready is for use, Amazon ML sets the
    /// status to <code>COMPLETED</code>. </p>
    /// <p>You can use the <code>GetMLModel</code> operation to check the progress of the
    /// <code>MLModel</code> during the creation operation.</p>
    ///
    /// <p>
    /// <code>CreateMLModel</code> requires a <code>DataSource</code> with computed statistics,
    /// which can be created by setting <code>ComputeStatistics</code> to <code>true</code> in
    /// <code>CreateDataSourceFromRDS</code>, <code>CreateDataSourceFromS3</code>, or
    /// <code>CreateDataSourceFromRedshift</code> operations.
    /// </p>
    #[derive(std::fmt::Debug)]
    pub struct CreateMLModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_ml_model_input::Builder,
    }
    impl<C, M, R> CreateMLModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateMLModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateMlModelInputOperationOutputAlias,
                crate::output::CreateMlModelOutput,
                crate::error::CreateMLModelError,
                crate::input::CreateMlModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn ml_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_ml_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ml_model_name(input);
            self
        }
        /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
        /// <ul>
        /// <li>
        /// <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn ml_model_type(mut self, inp: crate::model::MlModelType) -> Self {
            self.inner = self.inner.ml_model_type(inp);
            self
        }
        /// <p>The category of supervised learning that this <code>MLModel</code> will address. Choose from the following types:</p>
        /// <ul>
        /// <li>
        /// <p>Choose <code>REGRESSION</code> if the <code>MLModel</code> will be used to predict a numeric value.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>BINARY</code> if the <code>MLModel</code> result has two possible values.</p>
        /// </li>
        /// <li>
        /// <p>Choose <code>MULTICLASS</code> if the <code>MLModel</code> result has a limited number of values.</p>
        /// </li>
        /// </ul>
        /// <p> For more information, see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide</a>.</p>
        pub fn set_ml_model_type(
            mut self,
            input: std::option::Option<crate::model::MlModelType>,
        ) -> Self {
            self.inner = self.inner.set_ml_model_type(input);
            self
        }
        /// Adds a key-value pair to `Parameters`.
        ///
        /// To override the contents of this collection use [`set_parameters`](Self::set_parameters).
        ///
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
        /// a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
        /// input data, the size of the model might affect its performance.</p>
        /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
        /// observations to build the <code>MLModel</code>. The value is an integer that
        /// ranges from <code>1</code> to <code>10000</code>. The default value is
        /// <code>10</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling
        /// the data improves a model's ability to find the optimal solution for a variety
        /// of data types. The valid values are <code>auto</code> and <code>none</code>. The
        /// default value is <code>none</code>. We strongly recommend that you shuffle your data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to zero, resulting in a sparse feature set. If you use this
        /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L1 normalization. This parameter can't be used when
        /// <code>L2</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to small, nonzero values. If you use this parameter, start by
        /// specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L2 normalization. This parameter can't be used when
        /// <code>L1</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// </ul>
        pub fn parameters(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.parameters(k, v);
            self
        }
        /// <p>A list of the training parameters in the <code>MLModel</code>. The list is implemented as
        /// a map of key-value pairs.</p>
        /// <p>The following is the current set of training parameters:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>sgd.maxMLModelSizeInBytes</code> - The maximum allowed size of the model. Depending on the
        /// input data, the size of the model might affect its performance.</p>
        /// <p> The value is an integer that ranges from <code>100000</code> to <code>2147483648</code>. The default value is <code>33554432</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.maxPasses</code> - The number of times that the training process traverses the
        /// observations to build the <code>MLModel</code>. The value is an integer that
        /// ranges from <code>1</code> to <code>10000</code>. The default value is
        /// <code>10</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.shuffleType</code> - Whether Amazon ML shuffles the training data. Shuffling
        /// the data improves a model's ability to find the optimal solution for a variety
        /// of data types. The valid values are <code>auto</code> and <code>none</code>. The
        /// default value is <code>none</code>. We strongly recommend that you shuffle your data.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l1RegularizationAmount</code> - The coefficient regularization L1 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to zero, resulting in a sparse feature set. If you use this
        /// parameter, start by specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L1 normalization. This parameter can't be used when
        /// <code>L2</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>sgd.l2RegularizationAmount</code> - The coefficient regularization L2 norm. It controls
        /// overfitting the data by penalizing large coefficients. This tends to drive
        /// coefficients to small, nonzero values. If you use this parameter, start by
        /// specifying a small value, such as <code>1.0E-08</code>.</p>
        /// <p>The value is a double that ranges from <code>0</code> to <code>MAX_DOUBLE</code>.
        /// The default is to not use L2 normalization. This parameter can't be used when
        /// <code>L1</code> is specified. Use this parameter sparingly.</p>
        /// </li>
        /// </ul>
        pub fn set_parameters(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_parameters(input);
            self
        }
        /// <p>The <code>DataSource</code> that points to the training data.</p>
        pub fn training_data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.training_data_source_id(inp);
            self
        }
        /// <p>The <code>DataSource</code> that points to the training data.</p>
        pub fn set_training_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_training_data_source_id(input);
            self
        }
        /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe
        /// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn recipe(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe(inp);
            self
        }
        /// <p>The data recipe for creating the <code>MLModel</code>. You must specify either the recipe
        /// or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn set_recipe(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe(input);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn recipe_uri(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.recipe_uri(inp);
            self
        }
        /// <p>The Amazon Simple Storage Service (Amazon S3) location and file name that contains the <code>MLModel</code> recipe. You must specify either the recipe or its URI. If you don't specify a recipe or its URI, Amazon ML creates a default.</p>
        pub fn set_recipe_uri(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_recipe_uri(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateRealtimeEndpoint`.
    ///
    /// <p>Creates a real-time endpoint for the <code>MLModel</code>. The endpoint contains the URI of the <code>MLModel</code>; that is, the location to send real-time prediction requests for the specified <code>MLModel</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateRealtimeEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_realtime_endpoint_input::Builder,
    }
    impl<C, M, R> CreateRealtimeEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateRealtimeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateRealtimeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateRealtimeEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateRealtimeEndpointInputOperationOutputAlias,
                crate::output::CreateRealtimeEndpointOutput,
                crate::error::CreateRealtimeEndpointError,
                crate::input::CreateRealtimeEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteBatchPrediction`.
    ///
    /// <p>Assigns the DELETED status to a <code>BatchPrediction</code>, rendering it unusable.</p>
    /// <p>After using the <code>DeleteBatchPrediction</code> operation, you can use the <a>GetBatchPrediction</a>
    /// operation to verify that the status of the <code>BatchPrediction</code> changed to DELETED.</p>
    ///
    /// <p>
    /// <b>Caution:</b> The result of the <code>DeleteBatchPrediction</code> operation is irreversible.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteBatchPrediction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_batch_prediction_input::Builder,
    }
    impl<C, M, R> DeleteBatchPrediction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteBatchPredictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteBatchPredictionInputOperationOutputAlias,
                crate::output::DeleteBatchPredictionOutput,
                crate::error::DeleteBatchPredictionError,
                crate::input::DeleteBatchPredictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataSource`.
    ///
    /// <p>Assigns the DELETED status to a <code>DataSource</code>, rendering it unusable.</p>
    /// <p>After using the <code>DeleteDataSource</code> operation, you can use the <a>GetDataSource</a> operation to verify that the status of the <code>DataSource</code> changed to DELETED.</p>
    /// <p>
    /// <b>Caution:</b> The results of the <code>DeleteDataSource</code> operation are irreversible.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_data_source_input::Builder,
    }
    impl<C, M, R> DeleteDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDataSourceInputOperationOutputAlias,
                crate::output::DeleteDataSourceOutput,
                crate::error::DeleteDataSourceError,
                crate::input::DeleteDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>DataSource</code>.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteEvaluation`.
    ///
    /// <p>Assigns the <code>DELETED</code> status to an <code>Evaluation</code>, rendering it unusable.</p>
    ///
    /// <p>After invoking the <code>DeleteEvaluation</code> operation, you can use the
    /// <code>GetEvaluation</code> operation to verify that the status of the <code>Evaluation</code> changed to <code>DELETED</code>.</p>
    /// <p>
    /// <b>Caution:</b> The results of the <code>DeleteEvaluation</code> operation are irreversible.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteEvaluation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_evaluation_input::Builder,
    }
    impl<C, M, R> DeleteEvaluation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteEvaluationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteEvaluationInputOperationOutputAlias,
                crate::output::DeleteEvaluationOutput,
                crate::error::DeleteEvaluationError,
                crate::input::DeleteEvaluationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
        pub fn evaluation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>Evaluation</code> to delete.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteMLModel`.
    ///
    /// <p>Assigns the <code>DELETED</code> status to an <code>MLModel</code>, rendering it unusable.</p>
    /// <p>After using the <code>DeleteMLModel</code> operation, you can use the
    /// <code>GetMLModel</code> operation to verify that the status of the <code>MLModel</code> changed to DELETED.</p>
    ///
    /// <p>
    /// <b>Caution:</b> The result of the <code>DeleteMLModel</code> operation is irreversible.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteMLModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_ml_model_input::Builder,
    }
    impl<C, M, R> DeleteMLModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteMLModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteMlModelInputOperationOutputAlias,
                crate::output::DeleteMlModelOutput,
                crate::error::DeleteMLModelError,
                crate::input::DeleteMlModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>A user-supplied ID that uniquely identifies the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteRealtimeEndpoint`.
    ///
    /// <p>Deletes a real time endpoint of an <code>MLModel</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteRealtimeEndpoint<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_realtime_endpoint_input::Builder,
    }
    impl<C, M, R> DeleteRealtimeEndpoint<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteRealtimeEndpoint`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteRealtimeEndpointOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteRealtimeEndpointError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteRealtimeEndpointInputOperationOutputAlias,
                crate::output::DeleteRealtimeEndpointOutput,
                crate::error::DeleteRealtimeEndpointError,
                crate::input::DeleteRealtimeEndpointInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteTags`.
    ///
    /// <p>Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.</p>
    /// <p>If you specify a tag that doesn't exist, Amazon ML ignores it.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_tags_input::Builder,
    }
    impl<C, M, R> DeleteTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteTagsInputOperationOutputAlias,
                crate::output::DeleteTagsOutput,
                crate::error::DeleteTagsError,
                crate::input::DeleteTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>One or more tags to delete.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>One or more tags to delete.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
        /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the tagged ML object. For example, <code>exampleModelId</code>.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn resource_type(mut self, inp: crate::model::TaggableResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of the tagged ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeBatchPredictions`.
    ///
    /// <p>Returns a list of <code>BatchPrediction</code> operations that match the search criteria in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeBatchPredictions<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_batch_predictions_input::Builder,
    }
    impl<C, M, R> DescribeBatchPredictions<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeBatchPredictions`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeBatchPredictionsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeBatchPredictionsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeBatchPredictionsInputOperationOutputAlias,
                crate::output::DescribeBatchPredictionsOutput,
                crate::error::DescribeBatchPredictionsError,
                crate::input::DescribeBatchPredictionsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, inp: crate::model::BatchPredictionFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(inp);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>BatchPrediction</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>BatchPrediction</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>BatchPrediction</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of the <code>BatchPrediction</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>BatchPrediction</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in the <code>BatchPrediction</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataURI</code> - Sets the search criteria to the data file(s) used in the <code>BatchPrediction</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::BatchPredictionFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>BatchPrediction</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(inp);
            self
        }
        /// <p>The equal to operator. The <code>BatchPrediction</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(inp);
            self
        }
        /// <p>The greater than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(inp);
            self
        }
        /// <p>The less than operator. The <code>BatchPrediction</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(inp);
            self
        }
        /// <p>The greater than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(inp);
            self
        }
        /// <p>The less than or equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(inp);
            self
        }
        /// <p>The not equal to operator. The <code>BatchPrediction</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(inp);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>Batch Prediction</code> operation could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>BatchPrediction</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>s.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>An ID of the page in the paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>An ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataSources`.
    ///
    /// <p>Returns a list of <code>DataSource</code> that match the search criteria in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataSources<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_data_sources_input::Builder,
    }
    impl<C, M, R> DescribeDataSources<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataSources`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDataSourcesOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDataSourcesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDataSourcesInputOperationOutputAlias,
                crate::output::DescribeDataSourcesOutput,
                crate::error::DescribeDataSourcesError,
                crate::input::DescribeDataSourcesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, inp: crate::model::DataSourceFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(inp);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>DataSource</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>DataSource</code> creation dates.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>DataSource</code> statuses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>DataSource</code>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the URI of data files used to create the <code>DataSource</code>. The URI can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>DataSource</code> creation.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::DataSourceFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>DataSource</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(inp);
            self
        }
        /// <p>The equal to operator. The <code>DataSource</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(inp);
            self
        }
        /// <p>The greater than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(inp);
            self
        }
        /// <p>The less than operator. The <code>DataSource</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(inp);
            self
        }
        /// <p>The greater than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(inp);
            self
        }
        /// <p>The less than or equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(inp);
            self
        }
        /// <p>The not equal to operator. The <code>DataSource</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>DataSource</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(inp);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, a <code>DataSource</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>DataSource</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>DataSource</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p> The maximum number of <code>DataSource</code> to include in the result.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeEvaluations`.
    ///
    /// <p>Returns a list of <code>DescribeEvaluations</code> that match the search criteria in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeEvaluations<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_evaluations_input::Builder,
    }
    impl<C, M, R> DescribeEvaluations<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeEvaluations`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeEvaluationsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeEvaluationsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeEvaluationsInputOperationOutputAlias,
                crate::output::DescribeEvaluationsOutput,
                crate::error::DescribeEvaluationsError,
                crate::input::DescribeEvaluationsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>   
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, inp: crate::model::EvaluationFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(inp);
            self
        }
        /// <p>Use one of the following variable to filter a list of <code>Evaluation</code> objects:</p>   
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to the <code>Evaluation</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to the <code>Evaluation</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>Evaluation</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked an <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelId</code> - Sets the search criteria to the <code>MLModel</code> that was evaluated.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used in <code>Evaluation</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>DataUri</code> - Sets the search criteria to the data file(s) used in <code>Evaluation</code>. The URL can identify either a file or an Amazon Simple Storage Solution (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::EvaluationFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>Evaluation</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(inp);
            self
        }
        /// <p>The equal to operator. The <code>Evaluation</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(inp);
            self
        }
        /// <p>The greater than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(inp);
            self
        }
        /// <p>The less than operator. The <code>Evaluation</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(inp);
            self
        }
        /// <p>The greater than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(inp);
            self
        }
        /// <p>The less than or equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(inp);
            self
        }
        /// <p>The not equal to operator. The <code>Evaluation</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(inp);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>Evaluation</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>Evaluation</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>Evaluation</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p> The maximum number of <code>Evaluation</code> to include in the result.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeMLModels`.
    ///
    /// <p>Returns a list of <code>MLModel</code> that match the search criteria in the request.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeMLModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_ml_models_input::Builder,
    }
    impl<C, M, R> DescribeMLModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeMLModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeMlModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeMLModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeMlModelsInputOperationOutputAlias,
                crate::output::DescribeMlModelsOutput,
                crate::error::DescribeMLModelsError,
                crate::input::DescribeMlModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn filter_variable(mut self, inp: crate::model::MlModelFilterVariable) -> Self {
            self.inner = self.inner.filter_variable(inp);
            self
        }
        /// <p>Use one of the following variables to filter a list of <code>MLModel</code>:</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>CreatedAt</code> - Sets the search criteria to <code>MLModel</code> creation date.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Status</code> - Sets the search criteria to <code>MLModel</code> status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Name</code> - Sets the search criteria to the contents of <code>MLModel</code>
        /// <b> </b>
        /// <code>Name</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>IAMUser</code> - Sets the search criteria to the user account that invoked the <code>MLModel</code> creation.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataSourceId</code> - Sets the search criteria to the <code>DataSource</code> used to train one or more <code>MLModel</code>.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>RealtimeEndpointStatus</code> - Sets the search criteria to the <code>MLModel</code> real-time endpoint status.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>MLModelType</code> - Sets the search criteria to <code>MLModel</code> type: binary, regression, or multi-class.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>Algorithm</code> - Sets the search criteria to the algorithm that the <code>MLModel</code> uses.</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>TrainingDataURI</code> - Sets the search criteria to the data file(s) used in training a <code>MLModel</code>. The URL can identify either a file or an Amazon Simple Storage Service (Amazon S3) bucket or directory.</p>
        /// </li>
        /// </ul>
        pub fn set_filter_variable(
            mut self,
            input: std::option::Option<crate::model::MlModelFilterVariable>,
        ) -> Self {
            self.inner = self.inner.set_filter_variable(input);
            self
        }
        /// <p>The equal to operator. The <code>MLModel</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn eq(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.eq(inp);
            self
        }
        /// <p>The equal to operator. The <code>MLModel</code> results will have
        /// <code>FilterVariable</code> values that exactly match the value specified with <code>EQ</code>.</p>
        pub fn set_eq(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_eq(input);
            self
        }
        /// <p>The greater than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn gt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.gt(inp);
            self
        }
        /// <p>The greater than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are greater than the value specified with <code>GT</code>.</p>
        pub fn set_gt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_gt(input);
            self
        }
        /// <p>The less than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn lt(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.lt(inp);
            self
        }
        /// <p>The less than operator. The <code>MLModel</code> results will
        /// have <code>FilterVariable</code> values that are less than the value specified with <code>LT</code>.</p>
        pub fn set_lt(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_lt(input);
            self
        }
        /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn ge(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ge(inp);
            self
        }
        /// <p>The greater than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are greater than or equal to the value specified with <code>GE</code>.
        /// </p>
        pub fn set_ge(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ge(input);
            self
        }
        /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn le(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.le(inp);
            self
        }
        /// <p>The less than or equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values that are less than or equal to the value specified with <code>LE</code>.</p>
        pub fn set_le(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_le(input);
            self
        }
        /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn ne(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ne(inp);
            self
        }
        /// <p>The not equal to operator. The <code>MLModel</code> results will have <code>FilterVariable</code> values not equal to the value specified with <code>NE</code>.</p>
        pub fn set_ne(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ne(input);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>MLModel</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn prefix(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.prefix(inp);
            self
        }
        /// <p>A string that is found at the beginning of a variable, such as <code>Name</code> or <code>Id</code>.</p>
        /// <p>For example, an <code>MLModel</code> could have the <code>Name</code>
        /// <code>2014-09-09-HolidayGiftMailer</code>. To search for
        /// this <code>MLModel</code>, select <code>Name</code> for the <code>FilterVariable</code> and any of the following strings for the
        /// <code>Prefix</code>:
        /// </p>
        ///
        /// <ul>
        /// <li>
        /// <p>2014-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09</p>
        /// </li>
        /// <li>
        /// <p>2014-09-09-Holiday</p>
        /// </li>
        /// </ul>
        pub fn set_prefix(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_prefix(input);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn sort_order(mut self, inp: crate::model::SortOrder) -> Self {
            self.inner = self.inner.sort_order(inp);
            self
        }
        /// <p>A two-value parameter that determines the sequence of the resulting list of <code>MLModel</code>.</p>
        /// <ul>
        /// <li>
        /// <p>
        /// <code>asc</code> - Arranges the list in ascending order (A-Z, 0-9).</p>
        /// </li>
        /// <li>
        /// <p>
        /// <code>dsc</code> - Arranges the list in descending order (Z-A, 9-0).</p>
        /// </li>
        /// </ul>
        /// <p>Results are sorted by <code>FilterVariable</code>.</p>
        pub fn set_sort_order(
            mut self,
            input: std::option::Option<crate::model::SortOrder>,
        ) -> Self {
            self.inner = self.inner.set_sort_order(input);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>The ID of the page in the paginated results.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn limit(mut self, inp: i32) -> Self {
            self.inner = self.inner.limit(inp);
            self
        }
        /// <p>The number of pages of information to include in the result. The range of acceptable values is <code>1</code> through <code>100</code>. The default value is <code>100</code>.</p>
        pub fn set_limit(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_limit(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeTags`.
    ///
    /// <p>Describes one or more of the tags for your Amazon ML object.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeTags<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_tags_input::Builder,
    }
    impl<C, M, R> DescribeTags<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeTags`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeTagsOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeTagsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeTagsInputOperationOutputAlias,
                crate::output::DescribeTagsOutput,
                crate::error::DescribeTagsError,
                crate::input::DescribeTagsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
        pub fn resource_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_id(inp);
            self
        }
        /// <p>The ID of the ML object. For example, <code>exampleModelId</code>. </p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_id(input);
            self
        }
        /// <p>The type of the ML object.</p>
        pub fn resource_type(mut self, inp: crate::model::TaggableResourceType) -> Self {
            self.inner = self.inner.resource_type(inp);
            self
        }
        /// <p>The type of the ML object.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::TaggableResourceType>,
        ) -> Self {
            self.inner = self.inner.set_resource_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetBatchPrediction`.
    ///
    /// <p>Returns a <code>BatchPrediction</code> that includes detailed metadata, status, and data file information for a
    /// <code>Batch Prediction</code> request.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetBatchPrediction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_batch_prediction_input::Builder,
    }
    impl<C, M, R> GetBatchPrediction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::GetBatchPredictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetBatchPredictionInputOperationOutputAlias,
                crate::output::GetBatchPredictionOutput,
                crate::error::GetBatchPredictionError,
                crate::input::GetBatchPredictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
        pub fn batch_prediction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(inp);
            self
        }
        /// <p>An ID assigned to the <code>BatchPrediction</code> at creation.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetDataSource`.
    ///
    /// <p>Returns a <code>DataSource</code> that includes metadata and data file information, as well as the current status of the <code>DataSource</code>.</p>
    /// <p>
    /// <code>GetDataSource</code> provides results in normal or verbose format. The verbose format
    /// adds the schema description and the list of files pointed to by the DataSource to the normal format.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_data_source_input::Builder,
    }
    impl<C, M, R> GetDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::GetDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetDataSourceInputOperationOutputAlias,
                crate::output::GetDataSourceOutput,
                crate::error::GetDataSourceError,
                crate::input::GetDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> at creation.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
        /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
        /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
        pub fn verbose(mut self, inp: bool) -> Self {
            self.inner = self.inner.verbose(inp);
            self
        }
        /// <p>Specifies whether the <code>GetDataSource</code> operation should return <code>DataSourceSchema</code>.</p>
        /// <p>If true, <code>DataSourceSchema</code> is returned.</p>
        /// <p>If false, <code>DataSourceSchema</code> is not returned.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_verbose(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetEvaluation`.
    ///
    /// <p>Returns an <code>Evaluation</code> that includes metadata as well as the current status of the <code>Evaluation</code>.</p>
    #[derive(std::fmt::Debug)]
    pub struct GetEvaluation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_evaluation_input::Builder,
    }
    impl<C, M, R> GetEvaluation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::GetEvaluationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetEvaluationInputOperationOutputAlias,
                crate::output::GetEvaluationOutput,
                crate::error::GetEvaluationError,
                crate::input::GetEvaluationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
        pub fn evaluation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(inp);
            self
        }
        /// <p>The ID of the <code>Evaluation</code> to retrieve. The evaluation of each <code>MLModel</code> is recorded and cataloged. The ID provides the means to access the information. </p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
    }
    /// Fluent builder constructing a request to `GetMLModel`.
    ///
    /// <p>Returns an <code>MLModel</code> that includes detailed metadata, data source information, and the current status of the <code>MLModel</code>.</p>
    /// <p>
    /// <code>GetMLModel</code> provides results in normal or verbose format. </p>
    #[derive(std::fmt::Debug)]
    pub struct GetMLModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::get_ml_model_input::Builder,
    }
    impl<C, M, R> GetMLModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `GetMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::GetMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::GetMLModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::GetMlModelInputOperationOutputAlias,
                crate::output::GetMlModelOutput,
                crate::error::GetMLModelError,
                crate::input::GetMlModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> at creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
        /// <p>If true, <code>Recipe</code> is returned.</p>
        /// <p>If false, <code>Recipe</code> is not returned.</p>
        pub fn verbose(mut self, inp: bool) -> Self {
            self.inner = self.inner.verbose(inp);
            self
        }
        /// <p>Specifies whether the <code>GetMLModel</code> operation should return <code>Recipe</code>.</p>
        /// <p>If true, <code>Recipe</code> is returned.</p>
        /// <p>If false, <code>Recipe</code> is not returned.</p>
        pub fn set_verbose(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_verbose(input);
            self
        }
    }
    /// Fluent builder constructing a request to `Predict`.
    ///
    /// <p>Generates a prediction for the observation using the specified <code>ML Model</code>.</p>
    /// <p>
    /// <b>Note:</b> Not all response parameters will be populated. Whether a
    /// response parameter is populated depends on the type of model requested.</p>
    #[derive(std::fmt::Debug)]
    pub struct Predict<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::predict_input::Builder,
    }
    impl<C, M, R> Predict<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `Predict`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::PredictOutput,
            aws_smithy_http::result::SdkError<crate::error::PredictError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::PredictInputOperationOutputAlias,
                crate::output::PredictOutput,
                crate::error::PredictError,
                crate::input::PredictInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>A unique identifier of the <code>MLModel</code>.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>A unique identifier of the <code>MLModel</code>.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// Adds a key-value pair to `Record`.
        ///
        /// To override the contents of this collection use [`set_record`](Self::set_record).
        ///
        /// <p>A map of variable name-value pairs that represent an observation.</p>
        pub fn record(
            mut self,
            k: impl Into<std::string::String>,
            v: impl Into<std::string::String>,
        ) -> Self {
            self.inner = self.inner.record(k, v);
            self
        }
        /// <p>A map of variable name-value pairs that represent an observation.</p>
        pub fn set_record(
            mut self,
            input: std::option::Option<
                std::collections::HashMap<std::string::String, std::string::String>,
            >,
        ) -> Self {
            self.inner = self.inner.set_record(input);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn predict_endpoint(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.predict_endpoint(inp);
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_predict_endpoint(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_predict_endpoint(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateBatchPrediction`.
    ///
    /// <p>Updates the <code>BatchPredictionName</code> of a <code>BatchPrediction</code>.</p>
    /// <p>You can use the <code>GetBatchPrediction</code> operation to view the contents of the updated data element.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateBatchPrediction<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_batch_prediction_input::Builder,
    }
    impl<C, M, R> UpdateBatchPrediction<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateBatchPrediction`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateBatchPredictionOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateBatchPredictionError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateBatchPredictionInputOperationOutputAlias,
                crate::output::UpdateBatchPredictionOutput,
                crate::error::UpdateBatchPredictionError,
                crate::input::UpdateBatchPredictionInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
        pub fn batch_prediction_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>BatchPrediction</code> during creation.</p>
        pub fn set_batch_prediction_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_id(input);
            self
        }
        /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn batch_prediction_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.batch_prediction_name(inp);
            self
        }
        /// <p>A new user-supplied name or description of the <code>BatchPrediction</code>.</p>
        pub fn set_batch_prediction_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_batch_prediction_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDataSource`.
    ///
    /// <p>Updates the <code>DataSourceName</code> of a <code>DataSource</code>.</p>
    /// <p>You can use the <code>GetDataSource</code> operation to view the contents of the updated data element.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDataSource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_data_source_input::Builder,
    }
    impl<C, M, R> UpdateDataSource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDataSource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDataSourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDataSourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDataSourceInputOperationOutputAlias,
                crate::output::UpdateDataSourceOutput,
                crate::error::UpdateDataSourceError,
                crate::input::UpdateDataSourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
        pub fn data_source_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>DataSource</code> during creation.</p>
        pub fn set_data_source_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_id(input);
            self
        }
        /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
        pub fn data_source_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.data_source_name(inp);
            self
        }
        /// <p>A new user-supplied name or description of the <code>DataSource</code> that will replace the current description. </p>
        pub fn set_data_source_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_data_source_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateEvaluation`.
    ///
    /// <p>Updates the <code>EvaluationName</code> of an <code>Evaluation</code>.</p>
    /// <p>You can use the <code>GetEvaluation</code> operation to view the contents of the updated data element.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateEvaluation<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_evaluation_input::Builder,
    }
    impl<C, M, R> UpdateEvaluation<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateEvaluation`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateEvaluationOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateEvaluationError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateEvaluationInputOperationOutputAlias,
                crate::output::UpdateEvaluationOutput,
                crate::error::UpdateEvaluationError,
                crate::input::UpdateEvaluationInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
        pub fn evaluation_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>Evaluation</code> during creation.</p>
        pub fn set_evaluation_id(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_id(input);
            self
        }
        /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
        pub fn evaluation_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.evaluation_name(inp);
            self
        }
        /// <p>A new user-supplied name or description of the <code>Evaluation</code> that will replace the current content. </p>
        pub fn set_evaluation_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_evaluation_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateMLModel`.
    ///
    /// <p>Updates the <code>MLModelName</code> and the <code>ScoreThreshold</code> of an <code>MLModel</code>.</p>
    /// <p>You can use the <code>GetMLModel</code> operation to view the contents of the updated data element.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateMLModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_ml_model_input::Builder,
    }
    impl<C, M, R> UpdateMLModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateMLModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateMlModelOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateMLModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateMlModelInputOperationOutputAlias,
                crate::output::UpdateMlModelOutput,
                crate::error::UpdateMLModelError,
                crate::input::UpdateMlModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn ml_model_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_id(inp);
            self
        }
        /// <p>The ID assigned to the <code>MLModel</code> during creation.</p>
        pub fn set_ml_model_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_ml_model_id(input);
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn ml_model_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.ml_model_name(inp);
            self
        }
        /// <p>A user-supplied name or description of the <code>MLModel</code>.</p>
        pub fn set_ml_model_name(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_ml_model_name(input);
            self
        }
        /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
        /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
        pub fn score_threshold(mut self, inp: f32) -> Self {
            self.inner = self.inner.score_threshold(inp);
            self
        }
        /// <p>The <code>ScoreThreshold</code> used in binary classification <code>MLModel</code> that marks the boundary between a positive prediction and a negative prediction.</p>
        /// <p>Output values greater than or equal to the <code>ScoreThreshold</code> receive a positive result from the <code>MLModel</code>, such as <code>true</code>. Output values less than the <code>ScoreThreshold</code> receive a negative response from the <code>MLModel</code>, such as <code>false</code>.</p>
        pub fn set_score_threshold(mut self, input: std::option::Option<f32>) -> Self {
            self.inner = self.inner.set_score_threshold(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
