// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetEntriesOutput {
    /// <p>The status of the dataset update.</p>
    pub status: std::option::Option<crate::model::DatasetStatus>,
}
impl UpdateDatasetEntriesOutput {
    /// <p>The status of the dataset update.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::DatasetStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for UpdateDatasetEntriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetEntriesOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`UpdateDatasetEntriesOutput`](crate::output::UpdateDatasetEntriesOutput)
pub mod update_dataset_entries_output {
    /// A builder for [`UpdateDatasetEntriesOutput`](crate::output::UpdateDatasetEntriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::DatasetStatus>,
    }
    impl Builder {
        /// <p>The status of the dataset update.</p>
        pub fn status(mut self, input: crate::model::DatasetStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the dataset update.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::DatasetStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDatasetEntriesOutput`](crate::output::UpdateDatasetEntriesOutput)
        pub fn build(self) -> crate::output::UpdateDatasetEntriesOutput {
            crate::output::UpdateDatasetEntriesOutput {
                status: self.status,
            }
        }
    }
}
impl UpdateDatasetEntriesOutput {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetEntriesOutput`](crate::output::UpdateDatasetEntriesOutput)
    pub fn builder() -> crate::output::update_dataset_entries_output::Builder {
        crate::output::update_dataset_entries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceOutput {}
impl std::fmt::Debug for UntagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceOutput");
        formatter.finish()
    }
}
/// See [`UntagResourceOutput`](crate::output::UntagResourceOutput)
pub mod untag_resource_output {
    /// A builder for [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`UntagResourceOutput`](crate::output::UntagResourceOutput)
        pub fn build(self) -> crate::output::UntagResourceOutput {
            crate::output::UntagResourceOutput {}
        }
    }
}
impl UntagResourceOutput {
    /// Creates a new builder-style object to manufacture [`UntagResourceOutput`](crate::output::UntagResourceOutput)
    pub fn builder() -> crate::output::untag_resource_output::Builder {
        crate::output::untag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceOutput {}
impl std::fmt::Debug for TagResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceOutput");
        formatter.finish()
    }
}
/// See [`TagResourceOutput`](crate::output::TagResourceOutput)
pub mod tag_resource_output {
    /// A builder for [`TagResourceOutput`](crate::output::TagResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`TagResourceOutput`](crate::output::TagResourceOutput)
        pub fn build(self) -> crate::output::TagResourceOutput {
            crate::output::TagResourceOutput {}
        }
    }
}
impl TagResourceOutput {
    /// Creates a new builder-style object to manufacture [`TagResourceOutput`](crate::output::TagResourceOutput)
    pub fn builder() -> crate::output::tag_resource_output::Builder {
        crate::output::tag_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopModelOutput {
    /// <p>The status of the model.</p>
    pub status: std::option::Option<crate::model::ModelHostingStatus>,
}
impl StopModelOutput {
    /// <p>The status of the model.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ModelHostingStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StopModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopModelOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StopModelOutput`](crate::output::StopModelOutput)
pub mod stop_model_output {
    /// A builder for [`StopModelOutput`](crate::output::StopModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ModelHostingStatus>,
    }
    impl Builder {
        /// <p>The status of the model.</p>
        pub fn status(mut self, input: crate::model::ModelHostingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The status of the model.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ModelHostingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StopModelOutput`](crate::output::StopModelOutput)
        pub fn build(self) -> crate::output::StopModelOutput {
            crate::output::StopModelOutput {
                status: self.status,
            }
        }
    }
}
impl StopModelOutput {
    /// Creates a new builder-style object to manufacture [`StopModelOutput`](crate::output::StopModelOutput)
    pub fn builder() -> crate::output::stop_model_output::Builder {
        crate::output::stop_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartModelPackagingJobOutput {
    /// <p>The job name for the model packaging job. If you don't supply a job name in the <code>JobName</code> input parameter, the service creates a job name for you. </p>
    pub job_name: std::option::Option<std::string::String>,
}
impl StartModelPackagingJobOutput {
    /// <p>The job name for the model packaging job. If you don't supply a job name in the <code>JobName</code> input parameter, the service creates a job name for you. </p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
}
impl std::fmt::Debug for StartModelPackagingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartModelPackagingJobOutput");
        formatter.field("job_name", &self.job_name);
        formatter.finish()
    }
}
/// See [`StartModelPackagingJobOutput`](crate::output::StartModelPackagingJobOutput)
pub mod start_model_packaging_job_output {
    /// A builder for [`StartModelPackagingJobOutput`](crate::output::StartModelPackagingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The job name for the model packaging job. If you don't supply a job name in the <code>JobName</code> input parameter, the service creates a job name for you. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The job name for the model packaging job. If you don't supply a job name in the <code>JobName</code> input parameter, the service creates a job name for you. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`StartModelPackagingJobOutput`](crate::output::StartModelPackagingJobOutput)
        pub fn build(self) -> crate::output::StartModelPackagingJobOutput {
            crate::output::StartModelPackagingJobOutput {
                job_name: self.job_name,
            }
        }
    }
}
impl StartModelPackagingJobOutput {
    /// Creates a new builder-style object to manufacture [`StartModelPackagingJobOutput`](crate::output::StartModelPackagingJobOutput)
    pub fn builder() -> crate::output::start_model_packaging_job_output::Builder {
        crate::output::start_model_packaging_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartModelOutput {
    /// <p>The current running status of the model.</p>
    pub status: std::option::Option<crate::model::ModelHostingStatus>,
}
impl StartModelOutput {
    /// <p>The current running status of the model.</p>
    pub fn status(&self) -> std::option::Option<&crate::model::ModelHostingStatus> {
        self.status.as_ref()
    }
}
impl std::fmt::Debug for StartModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartModelOutput");
        formatter.field("status", &self.status);
        formatter.finish()
    }
}
/// See [`StartModelOutput`](crate::output::StartModelOutput)
pub mod start_model_output {
    /// A builder for [`StartModelOutput`](crate::output::StartModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) status: std::option::Option<crate::model::ModelHostingStatus>,
    }
    impl Builder {
        /// <p>The current running status of the model.</p>
        pub fn status(mut self, input: crate::model::ModelHostingStatus) -> Self {
            self.status = Some(input);
            self
        }
        /// <p>The current running status of the model.</p>
        pub fn set_status(
            mut self,
            input: std::option::Option<crate::model::ModelHostingStatus>,
        ) -> Self {
            self.status = input;
            self
        }
        /// Consumes the builder and constructs a [`StartModelOutput`](crate::output::StartModelOutput)
        pub fn build(self) -> crate::output::StartModelOutput {
            crate::output::StartModelOutput {
                status: self.status,
            }
        }
    }
}
impl StartModelOutput {
    /// Creates a new builder-style object to manufacture [`StartModelOutput`](crate::output::StartModelOutput)
    pub fn builder() -> crate::output::start_model_output::Builder {
        crate::output::start_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceOutput {
    /// <p>A map of tag keys and values attached to the specified model.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl ListTagsForResourceOutput {
    /// <p>A map of tag keys and values attached to the specified model.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceOutput");
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}
/// See [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
pub mod list_tags_for_resource_output {
    /// A builder for [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A map of tag keys and values attached to the specified model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A map of tag keys and values attached to the specified model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
        pub fn build(self) -> crate::output::ListTagsForResourceOutput {
            crate::output::ListTagsForResourceOutput { tags: self.tags }
        }
    }
}
impl ListTagsForResourceOutput {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput)
    pub fn builder() -> crate::output::list_tags_for_resource_output::Builder {
        crate::output::list_tags_for_resource_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsOutput {
    /// <p>A list of projects in your AWS account.</p>
    pub projects: std::option::Option<std::vec::Vec<crate::model::ProjectMetadata>>,
    /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of projects.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListProjectsOutput {
    /// <p>A list of projects in your AWS account.</p>
    pub fn projects(&self) -> std::option::Option<&[crate::model::ProjectMetadata]> {
        self.projects.as_deref()
    }
    /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of projects.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListProjectsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsOutput");
        formatter.field("projects", &self.projects);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListProjectsOutput`](crate::output::ListProjectsOutput)
pub mod list_projects_output {
    /// A builder for [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) projects: std::option::Option<std::vec::Vec<crate::model::ProjectMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `projects`.
        ///
        /// To override the contents of this collection use [`set_projects`](Self::set_projects).
        ///
        /// <p>A list of projects in your AWS account.</p>
        pub fn projects(mut self, input: crate::model::ProjectMetadata) -> Self {
            let mut v = self.projects.unwrap_or_default();
            v.push(input);
            self.projects = Some(v);
            self
        }
        /// <p>A list of projects in your AWS account.</p>
        pub fn set_projects(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ProjectMetadata>>,
        ) -> Self {
            self.projects = input;
            self
        }
        /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of projects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of projects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsOutput`](crate::output::ListProjectsOutput)
        pub fn build(self) -> crate::output::ListProjectsOutput {
            crate::output::ListProjectsOutput {
                projects: self.projects,
                next_token: self.next_token,
            }
        }
    }
}
impl ListProjectsOutput {
    /// Creates a new builder-style object to manufacture [`ListProjectsOutput`](crate::output::ListProjectsOutput)
    pub fn builder() -> crate::output::list_projects_output::Builder {
        crate::output::list_projects_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelsOutput {
    /// <p>A list of model versions in the specified project. </p>
    pub models: std::option::Option<std::vec::Vec<crate::model::ModelMetadata>>,
    /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of models. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelsOutput {
    /// <p>A list of model versions in the specified project. </p>
    pub fn models(&self) -> std::option::Option<&[crate::model::ModelMetadata]> {
        self.models.as_deref()
    }
    /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of models. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelsOutput");
        formatter.field("models", &self.models);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelsOutput`](crate::output::ListModelsOutput)
pub mod list_models_output {
    /// A builder for [`ListModelsOutput`](crate::output::ListModelsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) models: std::option::Option<std::vec::Vec<crate::model::ModelMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `models`.
        ///
        /// To override the contents of this collection use [`set_models`](Self::set_models).
        ///
        /// <p>A list of model versions in the specified project. </p>
        pub fn models(mut self, input: crate::model::ModelMetadata) -> Self {
            let mut v = self.models.unwrap_or_default();
            v.push(input);
            self.models = Some(v);
            self
        }
        /// <p>A list of model versions in the specified project. </p>
        pub fn set_models(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelMetadata>>,
        ) -> Self {
            self.models = input;
            self
        }
        /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of models. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of models. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelsOutput`](crate::output::ListModelsOutput)
        pub fn build(self) -> crate::output::ListModelsOutput {
            crate::output::ListModelsOutput {
                models: self.models,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelsOutput`](crate::output::ListModelsOutput)
    pub fn builder() -> crate::output::list_models_output::Builder {
        crate::output::list_models_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelPackagingJobsOutput {
    /// <p> A list of the model packaging jobs created for the specified Amazon Lookout for Vision project. </p>
    pub model_packaging_jobs:
        std::option::Option<std::vec::Vec<crate::model::ModelPackagingJobMetadata>>,
    /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListModelPackagingJobsOutput {
    /// <p> A list of the model packaging jobs created for the specified Amazon Lookout for Vision project. </p>
    pub fn model_packaging_jobs(
        &self,
    ) -> std::option::Option<&[crate::model::ModelPackagingJobMetadata]> {
        self.model_packaging_jobs.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListModelPackagingJobsOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelPackagingJobsOutput");
        formatter.field("model_packaging_jobs", &self.model_packaging_jobs);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListModelPackagingJobsOutput`](crate::output::ListModelPackagingJobsOutput)
pub mod list_model_packaging_jobs_output {
    /// A builder for [`ListModelPackagingJobsOutput`](crate::output::ListModelPackagingJobsOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_packaging_jobs:
            std::option::Option<std::vec::Vec<crate::model::ModelPackagingJobMetadata>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `model_packaging_jobs`.
        ///
        /// To override the contents of this collection use [`set_model_packaging_jobs`](Self::set_model_packaging_jobs).
        ///
        /// <p> A list of the model packaging jobs created for the specified Amazon Lookout for Vision project. </p>
        pub fn model_packaging_jobs(
            mut self,
            input: crate::model::ModelPackagingJobMetadata,
        ) -> Self {
            let mut v = self.model_packaging_jobs.unwrap_or_default();
            v.push(input);
            self.model_packaging_jobs = Some(v);
            self
        }
        /// <p> A list of the model packaging jobs created for the specified Amazon Lookout for Vision project. </p>
        pub fn set_model_packaging_jobs(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::ModelPackagingJobMetadata>>,
        ) -> Self {
            self.model_packaging_jobs = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelPackagingJobsOutput`](crate::output::ListModelPackagingJobsOutput)
        pub fn build(self) -> crate::output::ListModelPackagingJobsOutput {
            crate::output::ListModelPackagingJobsOutput {
                model_packaging_jobs: self.model_packaging_jobs,
                next_token: self.next_token,
            }
        }
    }
}
impl ListModelPackagingJobsOutput {
    /// Creates a new builder-style object to manufacture [`ListModelPackagingJobsOutput`](crate::output::ListModelPackagingJobsOutput)
    pub fn builder() -> crate::output::list_model_packaging_jobs_output::Builder {
        crate::output::list_model_packaging_jobs_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetEntriesOutput {
    /// <p>A list of the entries (JSON Lines) within the dataset.</p>
    pub dataset_entries: std::option::Option<std::vec::Vec<std::string::String>>,
    /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set ofdataset entries.</p>
    pub next_token: std::option::Option<std::string::String>,
}
impl ListDatasetEntriesOutput {
    /// <p>A list of the entries (JSON Lines) within the dataset.</p>
    pub fn dataset_entries(&self) -> std::option::Option<&[std::string::String]> {
        self.dataset_entries.as_deref()
    }
    /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set ofdataset entries.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetEntriesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetEntriesOutput");
        formatter.field("dataset_entries", &self.dataset_entries);
        formatter.field("next_token", &self.next_token);
        formatter.finish()
    }
}
/// See [`ListDatasetEntriesOutput`](crate::output::ListDatasetEntriesOutput)
pub mod list_dataset_entries_output {
    /// A builder for [`ListDatasetEntriesOutput`](crate::output::ListDatasetEntriesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_entries: std::option::Option<std::vec::Vec<std::string::String>>,
        pub(crate) next_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// Appends an item to `dataset_entries`.
        ///
        /// To override the contents of this collection use [`set_dataset_entries`](Self::set_dataset_entries).
        ///
        /// <p>A list of the entries (JSON Lines) within the dataset.</p>
        pub fn dataset_entries(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.dataset_entries.unwrap_or_default();
            v.push(input.into());
            self.dataset_entries = Some(v);
            self
        }
        /// <p>A list of the entries (JSON Lines) within the dataset.</p>
        pub fn set_dataset_entries(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.dataset_entries = input;
            self
        }
        /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set ofdataset entries.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set ofdataset entries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetEntriesOutput`](crate::output::ListDatasetEntriesOutput)
        pub fn build(self) -> crate::output::ListDatasetEntriesOutput {
            crate::output::ListDatasetEntriesOutput {
                dataset_entries: self.dataset_entries,
                next_token: self.next_token,
            }
        }
    }
}
impl ListDatasetEntriesOutput {
    /// Creates a new builder-style object to manufacture [`ListDatasetEntriesOutput`](crate::output::ListDatasetEntriesOutput)
    pub fn builder() -> crate::output::list_dataset_entries_output::Builder {
        crate::output::list_dataset_entries_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DetectAnomaliesOutput {
    /// <p>The results of the <code>DetectAnomalies</code> operation.</p>
    pub detect_anomaly_result: std::option::Option<crate::model::DetectAnomalyResult>,
}
impl DetectAnomaliesOutput {
    /// <p>The results of the <code>DetectAnomalies</code> operation.</p>
    pub fn detect_anomaly_result(&self) -> std::option::Option<&crate::model::DetectAnomalyResult> {
        self.detect_anomaly_result.as_ref()
    }
}
impl std::fmt::Debug for DetectAnomaliesOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectAnomaliesOutput");
        formatter.field("detect_anomaly_result", &self.detect_anomaly_result);
        formatter.finish()
    }
}
/// See [`DetectAnomaliesOutput`](crate::output::DetectAnomaliesOutput)
pub mod detect_anomalies_output {
    /// A builder for [`DetectAnomaliesOutput`](crate::output::DetectAnomaliesOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) detect_anomaly_result: std::option::Option<crate::model::DetectAnomalyResult>,
    }
    impl Builder {
        /// <p>The results of the <code>DetectAnomalies</code> operation.</p>
        pub fn detect_anomaly_result(mut self, input: crate::model::DetectAnomalyResult) -> Self {
            self.detect_anomaly_result = Some(input);
            self
        }
        /// <p>The results of the <code>DetectAnomalies</code> operation.</p>
        pub fn set_detect_anomaly_result(
            mut self,
            input: std::option::Option<crate::model::DetectAnomalyResult>,
        ) -> Self {
            self.detect_anomaly_result = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectAnomaliesOutput`](crate::output::DetectAnomaliesOutput)
        pub fn build(self) -> crate::output::DetectAnomaliesOutput {
            crate::output::DetectAnomaliesOutput {
                detect_anomaly_result: self.detect_anomaly_result,
            }
        }
    }
}
impl DetectAnomaliesOutput {
    /// Creates a new builder-style object to manufacture [`DetectAnomaliesOutput`](crate::output::DetectAnomaliesOutput)
    pub fn builder() -> crate::output::detect_anomalies_output::Builder {
        crate::output::detect_anomalies_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectOutput {
    /// <p>The description of the project.</p>
    pub project_description: std::option::Option<crate::model::ProjectDescription>,
}
impl DescribeProjectOutput {
    /// <p>The description of the project.</p>
    pub fn project_description(&self) -> std::option::Option<&crate::model::ProjectDescription> {
        self.project_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectOutput");
        formatter.field("project_description", &self.project_description);
        formatter.finish()
    }
}
/// See [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
pub mod describe_project_output {
    /// A builder for [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_description: std::option::Option<crate::model::ProjectDescription>,
    }
    impl Builder {
        /// <p>The description of the project.</p>
        pub fn project_description(mut self, input: crate::model::ProjectDescription) -> Self {
            self.project_description = Some(input);
            self
        }
        /// <p>The description of the project.</p>
        pub fn set_project_description(
            mut self,
            input: std::option::Option<crate::model::ProjectDescription>,
        ) -> Self {
            self.project_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
        pub fn build(self) -> crate::output::DescribeProjectOutput {
            crate::output::DescribeProjectOutput {
                project_description: self.project_description,
            }
        }
    }
}
impl DescribeProjectOutput {
    /// Creates a new builder-style object to manufacture [`DescribeProjectOutput`](crate::output::DescribeProjectOutput)
    pub fn builder() -> crate::output::describe_project_output::Builder {
        crate::output::describe_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelPackagingJobOutput {
    /// <p>The description of the model packaging job. </p>
    pub model_packaging_description: std::option::Option<crate::model::ModelPackagingDescription>,
}
impl DescribeModelPackagingJobOutput {
    /// <p>The description of the model packaging job. </p>
    pub fn model_packaging_description(
        &self,
    ) -> std::option::Option<&crate::model::ModelPackagingDescription> {
        self.model_packaging_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeModelPackagingJobOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelPackagingJobOutput");
        formatter.field(
            "model_packaging_description",
            &self.model_packaging_description,
        );
        formatter.finish()
    }
}
/// See [`DescribeModelPackagingJobOutput`](crate::output::DescribeModelPackagingJobOutput)
pub mod describe_model_packaging_job_output {
    /// A builder for [`DescribeModelPackagingJobOutput`](crate::output::DescribeModelPackagingJobOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_packaging_description:
            std::option::Option<crate::model::ModelPackagingDescription>,
    }
    impl Builder {
        /// <p>The description of the model packaging job. </p>
        pub fn model_packaging_description(
            mut self,
            input: crate::model::ModelPackagingDescription,
        ) -> Self {
            self.model_packaging_description = Some(input);
            self
        }
        /// <p>The description of the model packaging job. </p>
        pub fn set_model_packaging_description(
            mut self,
            input: std::option::Option<crate::model::ModelPackagingDescription>,
        ) -> Self {
            self.model_packaging_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelPackagingJobOutput`](crate::output::DescribeModelPackagingJobOutput)
        pub fn build(self) -> crate::output::DescribeModelPackagingJobOutput {
            crate::output::DescribeModelPackagingJobOutput {
                model_packaging_description: self.model_packaging_description,
            }
        }
    }
}
impl DescribeModelPackagingJobOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelPackagingJobOutput`](crate::output::DescribeModelPackagingJobOutput)
    pub fn builder() -> crate::output::describe_model_packaging_job_output::Builder {
        crate::output::describe_model_packaging_job_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelOutput {
    /// <p>Contains the description of the model.</p>
    pub model_description: std::option::Option<crate::model::ModelDescription>,
}
impl DescribeModelOutput {
    /// <p>Contains the description of the model.</p>
    pub fn model_description(&self) -> std::option::Option<&crate::model::ModelDescription> {
        self.model_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelOutput");
        formatter.field("model_description", &self.model_description);
        formatter.finish()
    }
}
/// See [`DescribeModelOutput`](crate::output::DescribeModelOutput)
pub mod describe_model_output {
    /// A builder for [`DescribeModelOutput`](crate::output::DescribeModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_description: std::option::Option<crate::model::ModelDescription>,
    }
    impl Builder {
        /// <p>Contains the description of the model.</p>
        pub fn model_description(mut self, input: crate::model::ModelDescription) -> Self {
            self.model_description = Some(input);
            self
        }
        /// <p>Contains the description of the model.</p>
        pub fn set_model_description(
            mut self,
            input: std::option::Option<crate::model::ModelDescription>,
        ) -> Self {
            self.model_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelOutput`](crate::output::DescribeModelOutput)
        pub fn build(self) -> crate::output::DescribeModelOutput {
            crate::output::DescribeModelOutput {
                model_description: self.model_description,
            }
        }
    }
}
impl DescribeModelOutput {
    /// Creates a new builder-style object to manufacture [`DescribeModelOutput`](crate::output::DescribeModelOutput)
    pub fn builder() -> crate::output::describe_model_output::Builder {
        crate::output::describe_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetOutput {
    /// <p>The description of the requested dataset. </p>
    pub dataset_description: std::option::Option<crate::model::DatasetDescription>,
}
impl DescribeDatasetOutput {
    /// <p>The description of the requested dataset. </p>
    pub fn dataset_description(&self) -> std::option::Option<&crate::model::DatasetDescription> {
        self.dataset_description.as_ref()
    }
}
impl std::fmt::Debug for DescribeDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetOutput");
        formatter.field("dataset_description", &self.dataset_description);
        formatter.finish()
    }
}
/// See [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
pub mod describe_dataset_output {
    /// A builder for [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_description: std::option::Option<crate::model::DatasetDescription>,
    }
    impl Builder {
        /// <p>The description of the requested dataset. </p>
        pub fn dataset_description(mut self, input: crate::model::DatasetDescription) -> Self {
            self.dataset_description = Some(input);
            self
        }
        /// <p>The description of the requested dataset. </p>
        pub fn set_dataset_description(
            mut self,
            input: std::option::Option<crate::model::DatasetDescription>,
        ) -> Self {
            self.dataset_description = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
        pub fn build(self) -> crate::output::DescribeDatasetOutput {
            crate::output::DescribeDatasetOutput {
                dataset_description: self.dataset_description,
            }
        }
    }
}
impl DescribeDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput)
    pub fn builder() -> crate::output::describe_dataset_output::Builder {
        crate::output::describe_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project that was deleted.</p>
    pub project_arn: std::option::Option<std::string::String>,
}
impl DeleteProjectOutput {
    /// <p>The Amazon Resource Name (ARN) of the project that was deleted.</p>
    pub fn project_arn(&self) -> std::option::Option<&str> {
        self.project_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectOutput");
        formatter.field("project_arn", &self.project_arn);
        formatter.finish()
    }
}
/// See [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
pub mod delete_project_output {
    /// A builder for [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the project that was deleted.</p>
        pub fn project_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the project that was deleted.</p>
        pub fn set_project_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
        pub fn build(self) -> crate::output::DeleteProjectOutput {
            crate::output::DeleteProjectOutput {
                project_arn: self.project_arn,
            }
        }
    }
}
impl DeleteProjectOutput {
    /// Creates a new builder-style object to manufacture [`DeleteProjectOutput`](crate::output::DeleteProjectOutput)
    pub fn builder() -> crate::output::delete_project_output::Builder {
        crate::output::delete_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelOutput {
    /// <p>The Amazon Resource Name (ARN) of the model that was deleted.</p>
    pub model_arn: std::option::Option<std::string::String>,
}
impl DeleteModelOutput {
    /// <p>The Amazon Resource Name (ARN) of the model that was deleted.</p>
    pub fn model_arn(&self) -> std::option::Option<&str> {
        self.model_arn.as_deref()
    }
}
impl std::fmt::Debug for DeleteModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelOutput");
        formatter.field("model_arn", &self.model_arn);
        formatter.finish()
    }
}
/// See [`DeleteModelOutput`](crate::output::DeleteModelOutput)
pub mod delete_model_output {
    /// A builder for [`DeleteModelOutput`](crate::output::DeleteModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model that was deleted.</p>
        pub fn model_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model that was deleted.</p>
        pub fn set_model_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.model_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelOutput`](crate::output::DeleteModelOutput)
        pub fn build(self) -> crate::output::DeleteModelOutput {
            crate::output::DeleteModelOutput {
                model_arn: self.model_arn,
            }
        }
    }
}
impl DeleteModelOutput {
    /// Creates a new builder-style object to manufacture [`DeleteModelOutput`](crate::output::DeleteModelOutput)
    pub fn builder() -> crate::output::delete_model_output::Builder {
        crate::output::delete_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetOutput {}
impl std::fmt::Debug for DeleteDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetOutput");
        formatter.finish()
    }
}
/// See [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
pub mod delete_dataset_output {
    /// A builder for [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {}
    impl Builder {
        /// Consumes the builder and constructs a [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
        pub fn build(self) -> crate::output::DeleteDatasetOutput {
            crate::output::DeleteDatasetOutput {}
        }
    }
}
impl DeleteDatasetOutput {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)
    pub fn builder() -> crate::output::delete_dataset_output::Builder {
        crate::output::delete_dataset_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectOutput {
    /// <p>Information about the project.</p>
    pub project_metadata: std::option::Option<crate::model::ProjectMetadata>,
}
impl CreateProjectOutput {
    /// <p>Information about the project.</p>
    pub fn project_metadata(&self) -> std::option::Option<&crate::model::ProjectMetadata> {
        self.project_metadata.as_ref()
    }
}
impl std::fmt::Debug for CreateProjectOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectOutput");
        formatter.field("project_metadata", &self.project_metadata);
        formatter.finish()
    }
}
/// See [`CreateProjectOutput`](crate::output::CreateProjectOutput)
pub mod create_project_output {
    /// A builder for [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_metadata: std::option::Option<crate::model::ProjectMetadata>,
    }
    impl Builder {
        /// <p>Information about the project.</p>
        pub fn project_metadata(mut self, input: crate::model::ProjectMetadata) -> Self {
            self.project_metadata = Some(input);
            self
        }
        /// <p>Information about the project.</p>
        pub fn set_project_metadata(
            mut self,
            input: std::option::Option<crate::model::ProjectMetadata>,
        ) -> Self {
            self.project_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectOutput`](crate::output::CreateProjectOutput)
        pub fn build(self) -> crate::output::CreateProjectOutput {
            crate::output::CreateProjectOutput {
                project_metadata: self.project_metadata,
            }
        }
    }
}
impl CreateProjectOutput {
    /// Creates a new builder-style object to manufacture [`CreateProjectOutput`](crate::output::CreateProjectOutput)
    pub fn builder() -> crate::output::create_project_output::Builder {
        crate::output::create_project_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelOutput {
    /// <p>The response from a call to <code>CreateModel</code>.</p>
    pub model_metadata: std::option::Option<crate::model::ModelMetadata>,
}
impl CreateModelOutput {
    /// <p>The response from a call to <code>CreateModel</code>.</p>
    pub fn model_metadata(&self) -> std::option::Option<&crate::model::ModelMetadata> {
        self.model_metadata.as_ref()
    }
}
impl std::fmt::Debug for CreateModelOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelOutput");
        formatter.field("model_metadata", &self.model_metadata);
        formatter.finish()
    }
}
/// See [`CreateModelOutput`](crate::output::CreateModelOutput)
pub mod create_model_output {
    /// A builder for [`CreateModelOutput`](crate::output::CreateModelOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) model_metadata: std::option::Option<crate::model::ModelMetadata>,
    }
    impl Builder {
        /// <p>The response from a call to <code>CreateModel</code>.</p>
        pub fn model_metadata(mut self, input: crate::model::ModelMetadata) -> Self {
            self.model_metadata = Some(input);
            self
        }
        /// <p>The response from a call to <code>CreateModel</code>.</p>
        pub fn set_model_metadata(
            mut self,
            input: std::option::Option<crate::model::ModelMetadata>,
        ) -> Self {
            self.model_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelOutput`](crate::output::CreateModelOutput)
        pub fn build(self) -> crate::output::CreateModelOutput {
            crate::output::CreateModelOutput {
                model_metadata: self.model_metadata,
            }
        }
    }
}
impl CreateModelOutput {
    /// Creates a new builder-style object to manufacture [`CreateModelOutput`](crate::output::CreateModelOutput)
    pub fn builder() -> crate::output::create_model_output::Builder {
        crate::output::create_model_output::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetOutput {
    /// <p>Information about the dataset.</p>
    pub dataset_metadata: std::option::Option<crate::model::DatasetMetadata>,
}
impl CreateDatasetOutput {
    /// <p>Information about the dataset.</p>
    pub fn dataset_metadata(&self) -> std::option::Option<&crate::model::DatasetMetadata> {
        self.dataset_metadata.as_ref()
    }
}
impl std::fmt::Debug for CreateDatasetOutput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetOutput");
        formatter.field("dataset_metadata", &self.dataset_metadata);
        formatter.finish()
    }
}
/// See [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
pub mod create_dataset_output {
    /// A builder for [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) dataset_metadata: std::option::Option<crate::model::DatasetMetadata>,
    }
    impl Builder {
        /// <p>Information about the dataset.</p>
        pub fn dataset_metadata(mut self, input: crate::model::DatasetMetadata) -> Self {
            self.dataset_metadata = Some(input);
            self
        }
        /// <p>Information about the dataset.</p>
        pub fn set_dataset_metadata(
            mut self,
            input: std::option::Option<crate::model::DatasetMetadata>,
        ) -> Self {
            self.dataset_metadata = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
        pub fn build(self) -> crate::output::CreateDatasetOutput {
            crate::output::CreateDatasetOutput {
                dataset_metadata: self.dataset_metadata,
            }
        }
    }
}
impl CreateDatasetOutput {
    /// Creates a new builder-style object to manufacture [`CreateDatasetOutput`](crate::output::CreateDatasetOutput)
    pub fn builder() -> crate::output::create_dataset_output::Builder {
        crate::output::create_dataset_output::Builder::default()
    }
}
