// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle {
    pub(crate) client: aws_smithy_client::Client<
        aws_smithy_client::erase::DynConnector,
        aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
    >,
    pub(crate) conf: crate::Config,
}

/// Client for Amazon Lookout for Vision
///
/// Client for invoking operations on Amazon Lookout for Vision. Each operation on Amazon Lookout for Vision is a method on this
/// this struct. `.send()` MUST be invoked on the generated operations to dispatch the request to the service.
///
/// # Examples
/// **Constructing a client and invoking an operation**
/// ```rust,no_run
/// # async fn docs() {
///     // create a shared configuration. This can be used & shared between multiple service clients.
///     let shared_config = aws_config::load_from_env().await;
///     let client = aws_sdk_lookoutvision::Client::new(&shared_config);
///     // invoke an operation
///     /* let rsp = client
///         .<operation_name>().
///         .<param>("some value")
///         .send().await; */
/// # }
/// ```
/// **Constructing a client with custom configuration**
/// ```rust,no_run
/// use aws_config::RetryConfig;
/// # async fn docs() {
///     let shared_config = aws_config::load_from_env().await;
///     let config = aws_sdk_lookoutvision::config::Builder::from(&shared_config)
///         .retry_config(RetryConfig::disabled())
///         .build();
///     let client = aws_sdk_lookoutvision::Client::from_conf(config);
/// # }
#[derive(std::fmt::Debug)]
pub struct Client {
    handle: std::sync::Arc<Handle>,
}

impl std::clone::Clone for Client {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl
    From<
        aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    > for Client
{
    fn from(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
    ) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl Client {
    /// Creates a client with the given service configuration.
    pub fn with_config(
        client: aws_smithy_client::Client<
            aws_smithy_client::erase::DynConnector,
            aws_smithy_client::erase::DynMiddleware<aws_smithy_client::erase::DynConnector>,
        >,
        conf: crate::Config,
    ) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl Client {
    /// Constructs a fluent builder for the [`CreateDataset`](crate::client::fluent_builders::CreateDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateDataset::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateDataset::set_project_name): <p>The name of the project in which you want to create a dataset.</p>
    ///   - [`dataset_type(impl Into<String>)`](crate::client::fluent_builders::CreateDataset::dataset_type) / [`set_dataset_type(Option<String>)`](crate::client::fluent_builders::CreateDataset::set_dataset_type): <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
    ///   - [`dataset_source(DatasetSource)`](crate::client::fluent_builders::CreateDataset::dataset_source) / [`set_dataset_source(Option<DatasetSource>)`](crate::client::fluent_builders::CreateDataset::set_dataset_source): <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>  <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>  <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateDataset::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateDataset::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
    /// - On success, responds with [`CreateDatasetOutput`](crate::output::CreateDatasetOutput) with field(s):
    ///   - [`dataset_metadata(Option<DatasetMetadata>)`](crate::output::CreateDatasetOutput::dataset_metadata): <p>Information about the dataset.</p>
    /// - On failure, responds with [`SdkError<CreateDatasetError>`](crate::error::CreateDatasetError)
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateModel`](crate::client::fluent_builders::CreateModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateModel::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateModel::set_project_name): <p>The name of the project in which you want to create a model version.</p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::CreateModel::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::CreateModel::set_description): <p>A description for the version of the model.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateModel::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
    ///   - [`output_config(OutputConfig)`](crate::client::fluent_builders::CreateModel::output_config) / [`set_output_config(Option<OutputConfig>)`](crate::client::fluent_builders::CreateModel::set_output_config): <p>The location where Amazon Lookout for Vision saves the training results.</p>
    ///   - [`kms_key_id(impl Into<String>)`](crate::client::fluent_builders::CreateModel::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::client::fluent_builders::CreateModel::set_kms_key_id): <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::CreateModel::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::CreateModel::set_tags): <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
    /// - On success, responds with [`CreateModelOutput`](crate::output::CreateModelOutput) with field(s):
    ///   - [`model_metadata(Option<ModelMetadata>)`](crate::output::CreateModelOutput::model_metadata): <p>The response from a call to <code>CreateModel</code>.</p>
    /// - On failure, responds with [`SdkError<CreateModelError>`](crate::error::CreateModelError)
    pub fn create_model(&self) -> fluent_builders::CreateModel {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`CreateProject`](crate::client::fluent_builders::CreateProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::CreateProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::CreateProject::set_project_name): <p>The name for the project.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::CreateProject::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::CreateProject::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
    /// - On success, responds with [`CreateProjectOutput`](crate::output::CreateProjectOutput) with field(s):
    ///   - [`project_metadata(Option<ProjectMetadata>)`](crate::output::CreateProjectOutput::project_metadata): <p>Information about the project.</p>
    /// - On failure, responds with [`SdkError<CreateProjectError>`](crate::error::CreateProjectError)
    pub fn create_project(&self) -> fluent_builders::CreateProject {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_project_name): <p>The name of the project that contains the dataset that you want to delete.</p>
    ///   - [`dataset_type(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::dataset_type) / [`set_dataset_type(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_dataset_type): <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteDataset::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteDataset::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
    /// - On success, responds with [`DeleteDatasetOutput`](crate::output::DeleteDatasetOutput)

    /// - On failure, responds with [`SdkError<DeleteDatasetError>`](crate::error::DeleteDatasetError)
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteModel`](crate::client::fluent_builders::DeleteModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_project_name): <p>The name of the project that contains the model that you want to delete.</p>
    ///   - [`model_version(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::model_version) / [`set_model_version(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_model_version): <p>The version of the model that you want to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteModel::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>  <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
    /// - On success, responds with [`DeleteModelOutput`](crate::output::DeleteModelOutput) with field(s):
    ///   - [`model_arn(Option<String>)`](crate::output::DeleteModelOutput::model_arn): <p>The Amazon Resource Name (ARN) of the model that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteModelError>`](crate::error::DeleteModelError)
    pub fn delete_model(&self) -> fluent_builders::DeleteModel {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DeleteProject`](crate::client::fluent_builders::DeleteProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_project_name): <p>The name of the project to delete.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::DeleteProject::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::DeleteProject::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
    /// - On success, responds with [`DeleteProjectOutput`](crate::output::DeleteProjectOutput) with field(s):
    ///   - [`project_arn(Option<String>)`](crate::output::DeleteProjectOutput::project_arn): <p>The Amazon Resource Name (ARN) of the project that was deleted.</p>
    /// - On failure, responds with [`SdkError<DeleteProjectError>`](crate::error::DeleteProjectError)
    pub fn delete_project(&self) -> fluent_builders::DeleteProject {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_project_name): <p>The name of the project that contains the dataset that you want to describe.</p>
    ///   - [`dataset_type(impl Into<String>)`](crate::client::fluent_builders::DescribeDataset::dataset_type) / [`set_dataset_type(Option<String>)`](crate::client::fluent_builders::DescribeDataset::set_dataset_type): <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
    /// - On success, responds with [`DescribeDatasetOutput`](crate::output::DescribeDatasetOutput) with field(s):
    ///   - [`dataset_description(Option<DatasetDescription>)`](crate::output::DescribeDatasetOutput::dataset_description): <p>The description of the requested dataset. </p>
    /// - On failure, responds with [`SdkError<DescribeDatasetError>`](crate::error::DescribeDatasetError)
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeModel`](crate::client::fluent_builders::DescribeModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DescribeModel::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DescribeModel::set_project_name): <p>The project that contains the version of a model that you want to describe.</p>
    ///   - [`model_version(impl Into<String>)`](crate::client::fluent_builders::DescribeModel::model_version) / [`set_model_version(Option<String>)`](crate::client::fluent_builders::DescribeModel::set_model_version): <p>The version of the model that you want to describe.</p>
    /// - On success, responds with [`DescribeModelOutput`](crate::output::DescribeModelOutput) with field(s):
    ///   - [`model_description(Option<ModelDescription>)`](crate::output::DescribeModelOutput::model_description): <p>Contains the description of the model.</p>
    /// - On failure, responds with [`SdkError<DescribeModelError>`](crate::error::DescribeModelError)
    pub fn describe_model(&self) -> fluent_builders::DescribeModel {
        fluent_builders::DescribeModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeModelPackagingJob`](crate::client::fluent_builders::DescribeModelPackagingJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DescribeModelPackagingJob::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DescribeModelPackagingJob::set_project_name): <p>The name of the project that contains the model packaging job that you want to describe. </p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::DescribeModelPackagingJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::DescribeModelPackagingJob::set_job_name): <p>The job name for the model packaging job. </p>
    /// - On success, responds with [`DescribeModelPackagingJobOutput`](crate::output::DescribeModelPackagingJobOutput) with field(s):
    ///   - [`model_packaging_description(Option<ModelPackagingDescription>)`](crate::output::DescribeModelPackagingJobOutput::model_packaging_description): <p>The description of the model packaging job. </p>
    /// - On failure, responds with [`SdkError<DescribeModelPackagingJobError>`](crate::error::DescribeModelPackagingJobError)
    pub fn describe_model_packaging_job(&self) -> fluent_builders::DescribeModelPackagingJob {
        fluent_builders::DescribeModelPackagingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DescribeProject`](crate::client::fluent_builders::DescribeProject) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DescribeProject::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DescribeProject::set_project_name): <p>The name of the project that you want to describe.</p>
    /// - On success, responds with [`DescribeProjectOutput`](crate::output::DescribeProjectOutput) with field(s):
    ///   - [`project_description(Option<ProjectDescription>)`](crate::output::DescribeProjectOutput::project_description): <p>The description of the project.</p>
    /// - On failure, responds with [`SdkError<DescribeProjectError>`](crate::error::DescribeProjectError)
    pub fn describe_project(&self) -> fluent_builders::DescribeProject {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`DetectAnomalies`](crate::client::fluent_builders::DetectAnomalies) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::DetectAnomalies::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::DetectAnomalies::set_project_name): <p>The name of the project that contains the model version that you want to use.</p>
    ///   - [`model_version(impl Into<String>)`](crate::client::fluent_builders::DetectAnomalies::model_version) / [`set_model_version(Option<String>)`](crate::client::fluent_builders::DetectAnomalies::set_model_version): <p>The version of the model that you want to use.</p>
    ///   - [`body(byte_stream::ByteStream)`](crate::client::fluent_builders::DetectAnomalies::body) / [`set_body(byte_stream::ByteStream)`](crate::client::fluent_builders::DetectAnomalies::set_body): <p>The unencrypted image bytes that you want to analyze. </p>
    ///   - [`content_type(impl Into<String>)`](crate::client::fluent_builders::DetectAnomalies::content_type) / [`set_content_type(Option<String>)`](crate::client::fluent_builders::DetectAnomalies::set_content_type): <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
    /// - On success, responds with [`DetectAnomaliesOutput`](crate::output::DetectAnomaliesOutput) with field(s):
    ///   - [`detect_anomaly_result(Option<DetectAnomalyResult>)`](crate::output::DetectAnomaliesOutput::detect_anomaly_result): <p>The results of the <code>DetectAnomalies</code> operation.</p>
    /// - On failure, responds with [`SdkError<DetectAnomaliesError>`](crate::error::DetectAnomaliesError)
    pub fn detect_anomalies(&self) -> fluent_builders::DetectAnomalies {
        fluent_builders::DetectAnomalies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListDatasetEntries`](crate::client::fluent_builders::ListDatasetEntries) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListDatasetEntries::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_project_name): <p>The name of the project that contains the dataset that you want to list.</p>
    ///   - [`dataset_type(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::dataset_type) / [`set_dataset_type(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_dataset_type): <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
    ///   - [`labeled(bool)`](crate::client::fluent_builders::ListDatasetEntries::labeled) / [`set_labeled(Option<bool>)`](crate::client::fluent_builders::ListDatasetEntries::set_labeled): <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
    ///   - [`anomaly_class(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::anomaly_class) / [`set_anomaly_class(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_anomaly_class): <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
    ///   - [`before_creation_date(DateTime)`](crate::client::fluent_builders::ListDatasetEntries::before_creation_date) / [`set_before_creation_date(Option<DateTime>)`](crate::client::fluent_builders::ListDatasetEntries::set_before_creation_date): <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
    ///   - [`after_creation_date(DateTime)`](crate::client::fluent_builders::ListDatasetEntries::after_creation_date) / [`set_after_creation_date(Option<DateTime>)`](crate::client::fluent_builders::ListDatasetEntries::set_after_creation_date): <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListDatasetEntries::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListDatasetEntries::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    ///   - [`source_ref_contains(impl Into<String>)`](crate::client::fluent_builders::ListDatasetEntries::source_ref_contains) / [`set_source_ref_contains(Option<String>)`](crate::client::fluent_builders::ListDatasetEntries::set_source_ref_contains): <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
    /// - On success, responds with [`ListDatasetEntriesOutput`](crate::output::ListDatasetEntriesOutput) with field(s):
    ///   - [`dataset_entries(Option<Vec<String>>)`](crate::output::ListDatasetEntriesOutput::dataset_entries): <p>A list of the entries (JSON Lines) within the dataset.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListDatasetEntriesOutput::next_token): <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set ofdataset entries.</p>
    /// - On failure, responds with [`SdkError<ListDatasetEntriesError>`](crate::error::ListDatasetEntriesError)
    pub fn list_dataset_entries(&self) -> fluent_builders::ListDatasetEntries {
        fluent_builders::ListDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListModelPackagingJobs`](crate::client::fluent_builders::ListModelPackagingJobs) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListModelPackagingJobs::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::ListModelPackagingJobs::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::ListModelPackagingJobs::set_project_name): <p> The name of the project for which you want to list the model packaging jobs. </p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListModelPackagingJobs::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListModelPackagingJobs::set_next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListModelPackagingJobs::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListModelPackagingJobs::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    /// - On success, responds with [`ListModelPackagingJobsOutput`](crate::output::ListModelPackagingJobsOutput) with field(s):
    ///   - [`model_packaging_jobs(Option<Vec<ModelPackagingJobMetadata>>)`](crate::output::ListModelPackagingJobsOutput::model_packaging_jobs): <p> A list of the model packaging jobs created for the specified Amazon Lookout for Vision project. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListModelPackagingJobsOutput::next_token): <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    /// - On failure, responds with [`SdkError<ListModelPackagingJobsError>`](crate::error::ListModelPackagingJobsError)
    pub fn list_model_packaging_jobs(&self) -> fluent_builders::ListModelPackagingJobs {
        fluent_builders::ListModelPackagingJobs::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListModels`](crate::client::fluent_builders::ListModels) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListModels::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::ListModels::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::ListModels::set_project_name): <p>The name of the project that contains the model versions that you want to list.</p>
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListModels::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListModels::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListModels::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListModels::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    /// - On success, responds with [`ListModelsOutput`](crate::output::ListModelsOutput) with field(s):
    ///   - [`models(Option<Vec<ModelMetadata>>)`](crate::output::ListModelsOutput::models): <p>A list of model versions in the specified project. </p>
    ///   - [`next_token(Option<String>)`](crate::output::ListModelsOutput::next_token): <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of models. </p>
    /// - On failure, responds with [`SdkError<ListModelsError>`](crate::error::ListModelsError)
    pub fn list_models(&self) -> fluent_builders::ListModels {
        fluent_builders::ListModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListProjects`](crate::client::fluent_builders::ListProjects) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::client::fluent_builders::ListProjects::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`next_token(impl Into<String>)`](crate::client::fluent_builders::ListProjects::next_token) / [`set_next_token(Option<String>)`](crate::client::fluent_builders::ListProjects::set_next_token): <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
    ///   - [`max_results(i32)`](crate::client::fluent_builders::ListProjects::max_results) / [`set_max_results(Option<i32>)`](crate::client::fluent_builders::ListProjects::set_max_results): <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    /// - On success, responds with [`ListProjectsOutput`](crate::output::ListProjectsOutput) with field(s):
    ///   - [`projects(Option<Vec<ProjectMetadata>>)`](crate::output::ListProjectsOutput::projects): <p>A list of projects in your AWS account.</p>
    ///   - [`next_token(Option<String>)`](crate::output::ListProjectsOutput::next_token): <p>If the response is truncated, Amazon Lookout for Vision returns this token that you can use in the subsequent request to retrieve the next set of projects.</p>
    /// - On failure, responds with [`SdkError<ListProjectsError>`](crate::error::ListProjectsError)
    pub fn list_projects(&self) -> fluent_builders::ListProjects {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::ListTagsForResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::ListTagsForResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
    /// - On success, responds with [`ListTagsForResourceOutput`](crate::output::ListTagsForResourceOutput) with field(s):
    ///   - [`tags(Option<Vec<Tag>>)`](crate::output::ListTagsForResourceOutput::tags): <p>A map of tag keys and values attached to the specified model.</p>
    /// - On failure, responds with [`SdkError<ListTagsForResourceError>`](crate::error::ListTagsForResourceError)
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartModel`](crate::client::fluent_builders::StartModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::StartModel::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::StartModel::set_project_name): <p>The name of the project that contains the model that you want to start.</p>
    ///   - [`model_version(impl Into<String>)`](crate::client::fluent_builders::StartModel::model_version) / [`set_model_version(Option<String>)`](crate::client::fluent_builders::StartModel::set_model_version): <p>The version of the model that you want to start.</p>
    ///   - [`min_inference_units(i32)`](crate::client::fluent_builders::StartModel::min_inference_units) / [`set_min_inference_units(Option<i32>)`](crate::client::fluent_builders::StartModel::set_min_inference_units): <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartModel::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
    /// - On success, responds with [`StartModelOutput`](crate::output::StartModelOutput) with field(s):
    ///   - [`status(Option<ModelHostingStatus>)`](crate::output::StartModelOutput::status): <p>The current running status of the model.</p>
    /// - On failure, responds with [`SdkError<StartModelError>`](crate::error::StartModelError)
    pub fn start_model(&self) -> fluent_builders::StartModel {
        fluent_builders::StartModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StartModelPackagingJob`](crate::client::fluent_builders::StartModelPackagingJob) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::StartModelPackagingJob::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::StartModelPackagingJob::set_project_name): <p> The name of the project which contains the version of the model that you want to package. </p>
    ///   - [`model_version(impl Into<String>)`](crate::client::fluent_builders::StartModelPackagingJob::model_version) / [`set_model_version(Option<String>)`](crate::client::fluent_builders::StartModelPackagingJob::set_model_version): <p> The version of the model within the project that you want to package. </p>
    ///   - [`job_name(impl Into<String>)`](crate::client::fluent_builders::StartModelPackagingJob::job_name) / [`set_job_name(Option<String>)`](crate::client::fluent_builders::StartModelPackagingJob::set_job_name): <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
    ///   - [`configuration(ModelPackagingConfiguration)`](crate::client::fluent_builders::StartModelPackagingJob::configuration) / [`set_configuration(Option<ModelPackagingConfiguration>)`](crate::client::fluent_builders::StartModelPackagingJob::set_configuration): <p>The configuration for the model packaging job. </p>
    ///   - [`description(impl Into<String>)`](crate::client::fluent_builders::StartModelPackagingJob::description) / [`set_description(Option<String>)`](crate::client::fluent_builders::StartModelPackagingJob::set_description): <p>A description for the model packaging job. </p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StartModelPackagingJob::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StartModelPackagingJob::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
    /// - On success, responds with [`StartModelPackagingJobOutput`](crate::output::StartModelPackagingJobOutput) with field(s):
    ///   - [`job_name(Option<String>)`](crate::output::StartModelPackagingJobOutput::job_name): <p>The job name for the model packaging job. If you don't supply a job name in the <code>JobName</code> input parameter, the service creates a job name for you. </p>
    /// - On failure, responds with [`SdkError<StartModelPackagingJobError>`](crate::error::StartModelPackagingJobError)
    pub fn start_model_packaging_job(&self) -> fluent_builders::StartModelPackagingJob {
        fluent_builders::StartModelPackagingJob::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`StopModel`](crate::client::fluent_builders::StopModel) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::StopModel::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::StopModel::set_project_name): <p>The name of the project that contains the model that you want to stop.</p>
    ///   - [`model_version(impl Into<String>)`](crate::client::fluent_builders::StopModel::model_version) / [`set_model_version(Option<String>)`](crate::client::fluent_builders::StopModel::set_model_version): <p>The version of the model that you want to stop.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::StopModel::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::StopModel::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
    /// - On success, responds with [`StopModelOutput`](crate::output::StopModelOutput) with field(s):
    ///   - [`status(Option<ModelHostingStatus>)`](crate::output::StopModelOutput::status): <p>The status of the model.</p>
    /// - On failure, responds with [`SdkError<StopModelError>`](crate::error::StopModelError)
    pub fn stop_model(&self) -> fluent_builders::StopModel {
        fluent_builders::StopModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`TagResource`](crate::client::fluent_builders::TagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::TagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::TagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
    ///   - [`tags(Vec<Tag>)`](crate::client::fluent_builders::TagResource::tags) / [`set_tags(Option<Vec<Tag>>)`](crate::client::fluent_builders::TagResource::set_tags): <p>The key-value tags to assign to the model.</p>
    /// - On success, responds with [`TagResourceOutput`](crate::output::TagResourceOutput)

    /// - On failure, responds with [`SdkError<TagResourceError>`](crate::error::TagResourceError)
    pub fn tag_resource(&self) -> fluent_builders::TagResource {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UntagResource`](crate::client::fluent_builders::UntagResource) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`resource_arn(impl Into<String>)`](crate::client::fluent_builders::UntagResource::resource_arn) / [`set_resource_arn(Option<String>)`](crate::client::fluent_builders::UntagResource::set_resource_arn): <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
    ///   - [`tag_keys(Vec<String>)`](crate::client::fluent_builders::UntagResource::tag_keys) / [`set_tag_keys(Option<Vec<String>>)`](crate::client::fluent_builders::UntagResource::set_tag_keys): <p>A list of the keys of the tags that you want to remove.</p>
    /// - On success, responds with [`UntagResourceOutput`](crate::output::UntagResourceOutput)

    /// - On failure, responds with [`SdkError<UntagResourceError>`](crate::error::UntagResourceError)
    pub fn untag_resource(&self) -> fluent_builders::UntagResource {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the [`UpdateDatasetEntries`](crate::client::fluent_builders::UpdateDatasetEntries) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`project_name(impl Into<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::project_name) / [`set_project_name(Option<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::set_project_name): <p>The name of the project that contains the dataset that you want to update.</p>
    ///   - [`dataset_type(impl Into<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::dataset_type) / [`set_dataset_type(Option<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::set_dataset_type): <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
    ///   - [`changes(Blob)`](crate::client::fluent_builders::UpdateDatasetEntries::changes) / [`set_changes(Option<Blob>)`](crate::client::fluent_builders::UpdateDatasetEntries::set_changes): <p>The entries to add to the dataset.</p>
    ///   - [`client_token(impl Into<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::client_token) / [`set_client_token(Option<String>)`](crate::client::fluent_builders::UpdateDatasetEntries::set_client_token): <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>  <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>  <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
    /// - On success, responds with [`UpdateDatasetEntriesOutput`](crate::output::UpdateDatasetEntriesOutput) with field(s):
    ///   - [`status(Option<DatasetStatus>)`](crate::output::UpdateDatasetEntriesOutput::status): <p>The status of the dataset update.</p>
    /// - On failure, responds with [`SdkError<UpdateDatasetEntriesError>`](crate::error::UpdateDatasetEntriesError)
    pub fn update_dataset_entries(&self) -> fluent_builders::UpdateDatasetEntries {
        fluent_builders::UpdateDatasetEntries::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates a new dataset in an Amazon Lookout for Vision project. <code>CreateDataset</code> can create a training or a test dataset from a valid dataset source (<code>DatasetSource</code>).</p>
    /// <p>If you want a single dataset project, specify <code>train</code> for the value of <code>DatasetType</code>.</p>
    /// <p>To have a project with separate training and test datasets, call <code>CreateDataset</code> twice. On the first call, specify <code>train</code> for the value of <code>DatasetType</code>. On the second call, specify <code>test</code> for the value of <code>DatasetType</code>. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:CreateDataset</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl CreateDataset {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project in which you want to create a dataset.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project in which you want to create a dataset.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(input.into());
            self
        }
        /// <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
        /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>
        /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
        pub fn dataset_source(mut self, input: crate::model::DatasetSource) -> Self {
            self.inner = self.inner.dataset_source(input);
            self
        }
        /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
        /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>
        /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
        pub fn set_dataset_source(
            mut self,
            input: std::option::Option<crate::model::DatasetSource>,
        ) -> Self {
            self.inner = self.inner.set_dataset_source(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a new version of a model within an an Amazon Lookout for Vision project. <code>CreateModel</code> is an asynchronous operation in which Amazon Lookout for Vision trains, tests, and evaluates a new version of a model. </p>
    /// <p>To get the current status, check the <code>Status</code> field returned in the response from <code>DescribeModel</code>.</p>
    /// <p>If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset to create a training and a test dataset. If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test the model. </p>
    /// <p>After training completes, the evaluation metrics are stored at the location specified in <code>OutputConfig</code>. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:CreateModel</code> operation. If you want to tag your model, you also require permission to the <code>lookoutvision:TagResource</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_model_input::Builder,
    }
    impl CreateModel {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project in which you want to create a model version.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project in which you want to create a model version.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A description for the version of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the version of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(input);
            self
        }
        /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(input.into());
            self
        }
        /// <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling <code>CreateDataset</code>.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:CreateProject</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct CreateProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::create_project_input::Builder,
    }
    impl CreateProject {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes an existing Amazon Lookout for Vision <code>dataset</code>. </p>
    /// <p>If your the project has a single dataset, you must create a new dataset before you can create a model.</p>
    /// <p>If you project has a training dataset and a test dataset consider the following. </p>
    /// <ul>
    /// <li> <p>If you delete the test dataset, your project reverts to a single dataset project. If you then train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.</p> </li>
    /// <li> <p>If you delete the training dataset, you must create a training dataset before you can create a model.</p> </li>
    /// </ul>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DeleteDataset</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl DeleteDataset {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(input.into());
            self
        }
        /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model, use the <code>StopModel</code> operation.</p>
    /// <p>It might take a few seconds to delete a model. To determine if a model has been deleted, call <code>ListModels</code> and check if the version of the model (<code>ModelVersion</code>) is in the <code>Models</code> array. </p>
    /// <p></p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DeleteModel</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl DeleteModel {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model that you want to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the model that you want to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to delete.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p>The version of the model that you want to delete.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an Amazon Lookout for Vision project.</p>
    /// <p>To delete a project, you must first delete each version of the model associated with the project. To delete a model use the <code>DeleteModel</code> operation.</p>
    /// <p>You also have to delete the dataset(s) associated with the model. For more information, see <code>DeleteDataset</code>. The images referenced by the training and test datasets aren't deleted. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DeleteProject</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DeleteProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl DeleteProject {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Describe an Amazon Lookout for Vision dataset.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DescribeDataset</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeDataset {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl DescribeDataset {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(input.into());
            self
        }
        /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModel`.
    ///
    /// <p>Describes a version of an Amazon Lookout for Vision model.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DescribeModel</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_model_input::Builder,
    }
    impl DescribeModel {
        /// Creates a new `DescribeModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The project that contains the version of a model that you want to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The project that contains the version of a model that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to describe.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p>The version of the model that you want to describe.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModelPackagingJob`.
    ///
    /// <p>Describes an Amazon Lookout for Vision model packaging job. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DescribeModelPackagingJob</code> operation.</p>
    /// <p>For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon Lookout for Vision Developer Guide. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeModelPackagingJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_model_packaging_job_input::Builder,
    }
    impl DescribeModelPackagingJob {
        /// Creates a new `DescribeModelPackagingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelPackagingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelPackagingJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model packaging job that you want to describe. </p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the model packaging job that you want to describe. </p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The job name for the model packaging job. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>The job name for the model packaging job. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Describes an Amazon Lookout for Vision project.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DescribeProject</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct DescribeProject {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl DescribeProject {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that you want to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectAnomalies`.
    ///
    /// <p>Detects anomalies in an image that you supply. </p>
    /// <p>The response from <code>DetectAnomalies</code> includes a boolean prediction that the image contains one or more anomalies and a confidence value for the prediction.</p> <note>
    /// <p>Before calling <code>DetectAnomalies</code>, you must first start your model with the <code>StartModel</code> operation. You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your model uses. If you are not using a model, use the <code>StopModel</code> operation to stop your model. </p>
    /// </note>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:DetectAnomalies</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectAnomalies {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::detect_anomalies_input::Builder,
    }
    impl DetectAnomalies {
        /// Creates a new `DetectAnomalies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectAnomaliesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectAnomaliesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model version that you want to use.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the model version that you want to use.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to use.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p>The version of the model that you want to use.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>The unencrypted image bytes that you want to analyze. </p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.body(input);
            self
        }
        /// <p>The unencrypted image bytes that you want to analyze. </p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(input.into());
            self
        }
        /// <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetEntries`.
    ///
    /// <p>Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly information for a single image, including the image location and the assigned label.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:ListDatasetEntries</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListDatasetEntries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_dataset_entries_input::Builder,
    }
    impl ListDatasetEntries {
        /// Creates a new `ListDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetEntriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListDatasetEntriesPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListDatasetEntriesPaginator {
            crate::paginator::ListDatasetEntriesPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the project that contains the dataset that you want to list.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to list.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(input.into());
            self
        }
        /// <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
        pub fn labeled(mut self, input: bool) -> Self {
            self.inner = self.inner.labeled(input);
            self
        }
        /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
        pub fn set_labeled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_labeled(input);
            self
        }
        /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
        pub fn anomaly_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_class(input.into());
            self
        }
        /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
        pub fn set_anomaly_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_class(input);
            self
        }
        /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn before_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.before_creation_date(input);
            self
        }
        /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn set_before_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_before_creation_date(input);
            self
        }
        /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn after_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.inner = self.inner.after_creation_date(input);
            self
        }
        /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn set_after_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.inner = self.inner.set_after_creation_date(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
        pub fn source_ref_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ref_contains(input.into());
            self
        }
        /// <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
        pub fn set_source_ref_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_ref_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListModelPackagingJobs`.
    ///
    /// <p> Lists the model packaging jobs created for an Amazon Lookout for Vision project. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:ListModelPackagingJobs</code> operation. </p>
    /// <p>For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon Lookout for Vision Developer Guide. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListModelPackagingJobs {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_model_packaging_jobs_input::Builder,
    }
    impl ListModelPackagingJobs {
        /// Creates a new `ListModelPackagingJobs`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListModelPackagingJobsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListModelPackagingJobsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListModelPackagingJobsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListModelPackagingJobsPaginator {
            crate::paginator::ListModelPackagingJobsPaginator::new(self.handle, self.inner)
        }
        /// <p> The name of the project for which you want to list the model packaging jobs. </p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p> The name of the project for which you want to list the model packaging jobs. </p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListModels`.
    ///
    /// <p>Lists the versions of a model in an Amazon Lookout for Vision project.</p>
    /// <p>The <code>ListModels</code> operation is eventually consistent. Recent calls to <code>CreateModel</code> might take a while to appear in the response from <code>ListProjects</code>.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:ListModels</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListModels {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_models_input::Builder,
    }
    impl ListModels {
        /// Creates a new `ListModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListModelsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListModelsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListModelsPaginator {
            crate::paginator::ListModelsPaginator::new(self.handle, self.inner)
        }
        /// <p>The name of the project that contains the model versions that you want to list.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the model versions that you want to list.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Lists the Amazon Lookout for Vision projects in your AWS account.</p>
    /// <p>The <code>ListProjects</code> operation is eventually consistent. Recent calls to <code>CreateProject</code> and <code>DeleteProject</code> might take a while to appear in the response from <code>ListProjects</code>.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:ListProjects</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListProjects {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl ListProjects {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// Create a paginator for this request
        ///
        /// Paginators are used by calling [`send().await`](crate::paginator::ListProjectsPaginator::send) which returns a [`Stream`](tokio_stream::Stream).
        pub fn into_paginator(self) -> crate::paginator::ListProjectsPaginator {
            crate::paginator::ListProjectsPaginator::new(self.handle, self.inner)
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.inner = self.inner.max_results(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags attached to the specified Amazon Lookout for Vision model.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:ListTagsForResource</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct ListTagsForResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl ListTagsForResource {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartModel`.
    ///
    /// <p>Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while to complete. To check the current state of the model, use <code>DescribeModel</code>.</p>
    /// <p>A model is ready to use when its status is <code>HOSTED</code>.</p>
    /// <p>Once the model is running, you can detect custom labels in new images by calling <code>DetectAnomalies</code>.</p> <note>
    /// <p>You are charged for the amount of time that the model is running. To stop a running model, call <code>StopModel</code>.</p>
    /// </note>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:StartModel</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_model_input::Builder,
    }
    impl StartModel {
        /// Creates a new `StartModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartModelOutput,
            aws_smithy_http::result::SdkError<crate::error::StartModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model that you want to start.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the model that you want to start.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to start.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p>The version of the model that you want to start.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
        pub fn min_inference_units(mut self, input: i32) -> Self {
            self.inner = self.inner.min_inference_units(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
        pub fn set_min_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_inference_units(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartModelPackagingJob`.
    ///
    /// <p>Starts an Amazon Lookout for Vision model packaging job. A model packaging job creates an AWS IoT Greengrass component for a Lookout for Vision model. You can use the component to deploy your model to an edge device managed by Greengrass. </p>
    /// <p>Use the <code>DescribeModelPackagingJob</code> API to determine the current status of the job. The model packaging job is complete if the value of <code>Status</code> is <code>SUCCEEDED</code>.</p>
    /// <p>To deploy the component to the target device, use the component name and component version with the AWS IoT Greengrass <a href="https://docs.aws.amazon.com/greengrass/v2/APIReference/API_CreateDeployment.html">CreateDeployment</a> API.</p>
    /// <p>This operation requires the following permissions:</p>
    /// <ul>
    /// <li> <p> <code>lookoutvision:StartModelPackagingJob</code> </p> </li>
    /// <li> <p> <code>s3:PutObject</code> </p> </li>
    /// <li> <p> <code>s3:GetBucketLocation</code> </p> </li>
    /// <li> <p> <code>greengrass:CreateComponentVersion</code> </p> </li>
    /// <li> <p> <code>greengrass:DescribeComponent</code> </p> </li>
    /// <li> <p>(Optional) <code>greengrass:TagResource</code>. Only required if you want to tag the component.</p> </li>
    /// </ul>
    /// <p>For more information, see <i>Using your Amazon Lookout for Vision model on an edge device</i> in the Amazon Lookout for Vision Developer Guide. </p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StartModelPackagingJob {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::start_model_packaging_job_input::Builder,
    }
    impl StartModelPackagingJob {
        /// Creates a new `StartModelPackagingJob`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartModelPackagingJobOutput,
            aws_smithy_http::result::SdkError<crate::error::StartModelPackagingJobError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p> The name of the project which contains the version of the model that you want to package. </p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p> The name of the project which contains the version of the model that you want to package. </p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p> The version of the model within the project that you want to package. </p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p> The version of the model within the project that you want to package. </p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.job_name(input.into());
            self
        }
        /// <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_job_name(input);
            self
        }
        /// <p>The configuration for the model packaging job. </p>
        pub fn configuration(mut self, input: crate::model::ModelPackagingConfiguration) -> Self {
            self.inner = self.inner.configuration(input);
            self
        }
        /// <p>The configuration for the model packaging job. </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelPackagingConfiguration>,
        ) -> Self {
            self.inner = self.inner.set_configuration(input);
            self
        }
        /// <p>A description for the model packaging job. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(input.into());
            self
        }
        /// <p>A description for the model packaging job. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopModel`.
    ///
    /// <p>Stops the hosting of a running model. The operation might take a while to complete. To check the current status, call <code>DescribeModel</code>. </p>
    /// <p>After the model hosting stops, the <code>Status</code> of the model is <code>TRAINED</code>.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:StopModel</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct StopModel {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::stop_model_input::Builder,
    }
    impl StopModel {
        /// Creates a new `StopModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopModelOutput,
            aws_smithy_http::result::SdkError<crate::error::StopModelError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model that you want to stop.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the model that you want to stop.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to stop.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(input.into());
            self
        }
        /// <p>The version of the model that you want to stop.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more key-value tags to an Amazon Lookout for Vision model. For more information, see <i>Tagging a model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:TagResource</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct TagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl TagResource {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags to assign to the model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            self.inner = self.inner.tags(input);
            self
        }
        /// <p>The key-value tags to assign to the model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from an Amazon Lookout for Vision model. For more information, see <i>Tagging a model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>. </p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:UntagResource</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UntagResource {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl UntagResource {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(input.into());
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatasetEntries`.
    ///
    /// <p>Adds or updates one or more JSON Line entries in a dataset. A JSON Line includes information about an image used for training or testing an Amazon Lookout for Vision model.</p>
    /// <p>To update an existing JSON Line, use the <code>source-ref</code> field to identify the JSON Line. The JSON line that you supply replaces the existing JSON line. Any existing annotations that are not in the new JSON line are removed from the dataset. </p>
    /// <p>For more information, see <i>Defining JSON lines for anomaly classification</i> in the Amazon Lookout for Vision Developer Guide. </p> <note>
    /// <p>The images you reference in the <code>source-ref</code> field of a JSON line, must be in the same S3 bucket as the existing images in the dataset. </p>
    /// </note>
    /// <p>Updating a dataset might take a while to complete. To check the current status, call <code>DescribeDataset</code> and check the <code>Status</code> field in the response.</p>
    /// <p>This operation requires permissions to perform the <code>lookoutvision:UpdateDatasetEntries</code> operation.</p>
    #[derive(std::clone::Clone, std::fmt::Debug)]
    pub struct UpdateDatasetEntries {
        handle: std::sync::Arc<super::Handle>,
        inner: crate::input::update_dataset_entries_input::Builder,
    }
    impl UpdateDatasetEntries {
        /// Creates a new `UpdateDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetEntriesError>,
        > {
            let op = self
                .inner
                .build()
                .map_err(|err| aws_smithy_http::result::SdkError::ConstructionFailure(err.into()))?
                .make_operation(&self.handle.conf)
                .await
                .map_err(|err| {
                    aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
                })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to update.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to update.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(input.into());
            self
        }
        /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>The entries to add to the dataset.</p>
        pub fn changes(mut self, input: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.changes(input);
            self
        }
        /// <p>The entries to add to the dataset.</p>
        pub fn set_changes(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_changes(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}

impl Client {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn<C, E>(conf: crate::Config, conn: C) -> Self
    where
        C: aws_smithy_client::bounds::SmithyConnector<Error = E> + Send + 'static,
        E: Into<aws_smithy_http::result::ConnectorError>,
    {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::new()
            .connector(aws_smithy_client::erase::DynConnector::new(conn))
            .middleware(aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ));
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let timeout_config = conf.timeout_config.as_ref().cloned().unwrap_or_default();
        let sleep_impl = conf.sleep_impl.clone();
        let mut builder = aws_smithy_client::Builder::dyn_https().middleware(
            aws_smithy_client::erase::DynMiddleware::new(
                crate::middleware::DefaultMiddleware::new(),
            ),
        );
        builder.set_retry_config(retry_config.into());
        builder.set_timeout_config(timeout_config);
        // the builder maintains a try-state. To avoid suppressing the warning when sleep is unset,
        // only set it if we actually have a sleep impl.
        if let Some(sleep_impl) = sleep_impl {
            builder.set_sleep_impl(Some(sleep_impl));
        }
        let client = builder.build();

        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
