// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Operation shape for `CreateDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_dataset`](crate::client::Client::create_dataset).
///
/// See [`crate::client::fluent_builders::CreateDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateDataset {
    _private: (),
}
impl CreateDataset {
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
    /// Creates a new `CreateDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateDataset {
    type Output =
        std::result::Result<crate::output::CreateDatasetOutput, crate::error::CreateDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_dataset_error(response)
        } else {
            crate::operation_deser::parse_create_dataset_response(response)
        }
    }
}

/// Operation shape for `CreateModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_model`](crate::client::Client::create_model).
///
/// See [`crate::client::fluent_builders::CreateModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateModel {
    _private: (),
}
impl CreateModel {
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
    /// Creates a new `CreateModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateModel {
    type Output =
        std::result::Result<crate::output::CreateModelOutput, crate::error::CreateModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_create_model_error(response)
        } else {
            crate::operation_deser::parse_create_model_response(response)
        }
    }
}

/// Operation shape for `CreateProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`create_project`](crate::client::Client::create_project).
///
/// See [`crate::client::fluent_builders::CreateProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct CreateProject {
    _private: (),
}
impl CreateProject {
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
    /// Creates a new `CreateProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for CreateProject {
    type Output =
        std::result::Result<crate::output::CreateProjectOutput, crate::error::CreateProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_create_project_error(response)
        } else {
            crate::operation_deser::parse_create_project_response(response)
        }
    }
}

/// Operation shape for `DeleteDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_dataset`](crate::client::Client::delete_dataset).
///
/// See [`crate::client::fluent_builders::DeleteDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteDataset {
    _private: (),
}
impl DeleteDataset {
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
    /// Creates a new `DeleteDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteDataset {
    type Output =
        std::result::Result<crate::output::DeleteDatasetOutput, crate::error::DeleteDatasetError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_dataset_error(response)
        } else {
            crate::operation_deser::parse_delete_dataset_response(response)
        }
    }
}

/// Operation shape for `DeleteModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_model`](crate::client::Client::delete_model).
///
/// See [`crate::client::fluent_builders::DeleteModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteModel {
    _private: (),
}
impl DeleteModel {
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
    /// Creates a new `DeleteModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteModel {
    type Output =
        std::result::Result<crate::output::DeleteModelOutput, crate::error::DeleteModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_delete_model_error(response)
        } else {
            crate::operation_deser::parse_delete_model_response(response)
        }
    }
}

/// Operation shape for `DeleteProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`delete_project`](crate::client::Client::delete_project).
///
/// See [`crate::client::fluent_builders::DeleteProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DeleteProject {
    _private: (),
}
impl DeleteProject {
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
    /// Creates a new `DeleteProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DeleteProject {
    type Output =
        std::result::Result<crate::output::DeleteProjectOutput, crate::error::DeleteProjectError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_delete_project_error(response)
        } else {
            crate::operation_deser::parse_delete_project_response(response)
        }
    }
}

/// Operation shape for `DescribeDataset`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_dataset`](crate::client::Client::describe_dataset).
///
/// See [`crate::client::fluent_builders::DescribeDataset`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeDataset {
    _private: (),
}
impl DescribeDataset {
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
    /// Creates a new `DescribeDataset` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeDataset {
    type Output = std::result::Result<
        crate::output::DescribeDatasetOutput,
        crate::error::DescribeDatasetError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_dataset_error(response)
        } else {
            crate::operation_deser::parse_describe_dataset_response(response)
        }
    }
}

/// Operation shape for `DescribeModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model`](crate::client::Client::describe_model).
///
/// See [`crate::client::fluent_builders::DescribeModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModel {
    _private: (),
}
impl DescribeModel {
    /// Creates a new builder-style object to manufacture [`DescribeModelInput`](crate::input::DescribeModelInput)
    pub fn builder() -> crate::input::describe_model_input::Builder {
        crate::input::describe_model_input::Builder::default()
    }
    /// Creates a new `DescribeModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModel {
    type Output =
        std::result::Result<crate::output::DescribeModelOutput, crate::error::DescribeModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_error(response)
        } else {
            crate::operation_deser::parse_describe_model_response(response)
        }
    }
}

/// Operation shape for `DescribeModelPackagingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_model_packaging_job`](crate::client::Client::describe_model_packaging_job).
///
/// See [`crate::client::fluent_builders::DescribeModelPackagingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeModelPackagingJob {
    _private: (),
}
impl DescribeModelPackagingJob {
    /// Creates a new builder-style object to manufacture [`DescribeModelPackagingJobInput`](crate::input::DescribeModelPackagingJobInput)
    pub fn builder() -> crate::input::describe_model_packaging_job_input::Builder {
        crate::input::describe_model_packaging_job_input::Builder::default()
    }
    /// Creates a new `DescribeModelPackagingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeModelPackagingJob {
    type Output = std::result::Result<
        crate::output::DescribeModelPackagingJobOutput,
        crate::error::DescribeModelPackagingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_model_packaging_job_error(response)
        } else {
            crate::operation_deser::parse_describe_model_packaging_job_response(response)
        }
    }
}

/// Operation shape for `DescribeProject`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`describe_project`](crate::client::Client::describe_project).
///
/// See [`crate::client::fluent_builders::DescribeProject`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DescribeProject {
    _private: (),
}
impl DescribeProject {
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
    /// Creates a new `DescribeProject` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DescribeProject {
    type Output = std::result::Result<
        crate::output::DescribeProjectOutput,
        crate::error::DescribeProjectError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_describe_project_error(response)
        } else {
            crate::operation_deser::parse_describe_project_response(response)
        }
    }
}

/// Operation shape for `DetectAnomalies`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`detect_anomalies`](crate::client::Client::detect_anomalies).
///
/// See [`crate::client::fluent_builders::DetectAnomalies`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct DetectAnomalies {
    _private: (),
}
impl DetectAnomalies {
    /// Creates a new builder-style object to manufacture [`DetectAnomaliesInput`](crate::input::DetectAnomaliesInput)
    pub fn builder() -> crate::input::detect_anomalies_input::Builder {
        crate::input::detect_anomalies_input::Builder::default()
    }
    /// Creates a new `DetectAnomalies` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for DetectAnomalies {
    type Output = std::result::Result<
        crate::output::DetectAnomaliesOutput,
        crate::error::DetectAnomaliesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_detect_anomalies_error(response)
        } else {
            crate::operation_deser::parse_detect_anomalies_response(response)
        }
    }
}

/// Operation shape for `ListDatasetEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_dataset_entries`](crate::client::Client::list_dataset_entries).
///
/// See [`crate::client::fluent_builders::ListDatasetEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListDatasetEntries {
    _private: (),
}
impl ListDatasetEntries {
    /// Creates a new builder-style object to manufacture [`ListDatasetEntriesInput`](crate::input::ListDatasetEntriesInput)
    pub fn builder() -> crate::input::list_dataset_entries_input::Builder {
        crate::input::list_dataset_entries_input::Builder::default()
    }
    /// Creates a new `ListDatasetEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListDatasetEntries {
    type Output = std::result::Result<
        crate::output::ListDatasetEntriesOutput,
        crate::error::ListDatasetEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_dataset_entries_error(response)
        } else {
            crate::operation_deser::parse_list_dataset_entries_response(response)
        }
    }
}

/// Operation shape for `ListModelPackagingJobs`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_model_packaging_jobs`](crate::client::Client::list_model_packaging_jobs).
///
/// See [`crate::client::fluent_builders::ListModelPackagingJobs`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModelPackagingJobs {
    _private: (),
}
impl ListModelPackagingJobs {
    /// Creates a new builder-style object to manufacture [`ListModelPackagingJobsInput`](crate::input::ListModelPackagingJobsInput)
    pub fn builder() -> crate::input::list_model_packaging_jobs_input::Builder {
        crate::input::list_model_packaging_jobs_input::Builder::default()
    }
    /// Creates a new `ListModelPackagingJobs` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModelPackagingJobs {
    type Output = std::result::Result<
        crate::output::ListModelPackagingJobsOutput,
        crate::error::ListModelPackagingJobsError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_model_packaging_jobs_error(response)
        } else {
            crate::operation_deser::parse_list_model_packaging_jobs_response(response)
        }
    }
}

/// Operation shape for `ListModels`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_models`](crate::client::Client::list_models).
///
/// See [`crate::client::fluent_builders::ListModels`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListModels {
    _private: (),
}
impl ListModels {
    /// Creates a new builder-style object to manufacture [`ListModelsInput`](crate::input::ListModelsInput)
    pub fn builder() -> crate::input::list_models_input::Builder {
        crate::input::list_models_input::Builder::default()
    }
    /// Creates a new `ListModels` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListModels {
    type Output =
        std::result::Result<crate::output::ListModelsOutput, crate::error::ListModelsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_models_error(response)
        } else {
            crate::operation_deser::parse_list_models_response(response)
        }
    }
}

/// Operation shape for `ListProjects`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_projects`](crate::client::Client::list_projects).
///
/// See [`crate::client::fluent_builders::ListProjects`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListProjects {
    _private: (),
}
impl ListProjects {
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
    /// Creates a new `ListProjects` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListProjects {
    type Output =
        std::result::Result<crate::output::ListProjectsOutput, crate::error::ListProjectsError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_projects_error(response)
        } else {
            crate::operation_deser::parse_list_projects_response(response)
        }
    }
}

/// Operation shape for `ListTagsForResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`list_tags_for_resource`](crate::client::Client::list_tags_for_resource).
///
/// See [`crate::client::fluent_builders::ListTagsForResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct ListTagsForResource {
    _private: (),
}
impl ListTagsForResource {
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
    /// Creates a new `ListTagsForResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for ListTagsForResource {
    type Output = std::result::Result<
        crate::output::ListTagsForResourceOutput,
        crate::error::ListTagsForResourceError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_list_tags_for_resource_error(response)
        } else {
            crate::operation_deser::parse_list_tags_for_resource_response(response)
        }
    }
}

/// Operation shape for `StartModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_model`](crate::client::Client::start_model).
///
/// See [`crate::client::fluent_builders::StartModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartModel {
    _private: (),
}
impl StartModel {
    /// Creates a new builder-style object to manufacture [`StartModelInput`](crate::input::StartModelInput)
    pub fn builder() -> crate::input::start_model_input::Builder {
        crate::input::start_model_input::Builder::default()
    }
    /// Creates a new `StartModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartModel {
    type Output =
        std::result::Result<crate::output::StartModelOutput, crate::error::StartModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_start_model_error(response)
        } else {
            crate::operation_deser::parse_start_model_response(response)
        }
    }
}

/// Operation shape for `StartModelPackagingJob`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`start_model_packaging_job`](crate::client::Client::start_model_packaging_job).
///
/// See [`crate::client::fluent_builders::StartModelPackagingJob`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StartModelPackagingJob {
    _private: (),
}
impl StartModelPackagingJob {
    /// Creates a new builder-style object to manufacture [`StartModelPackagingJobInput`](crate::input::StartModelPackagingJobInput)
    pub fn builder() -> crate::input::start_model_packaging_job_input::Builder {
        crate::input::start_model_packaging_job_input::Builder::default()
    }
    /// Creates a new `StartModelPackagingJob` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StartModelPackagingJob {
    type Output = std::result::Result<
        crate::output::StartModelPackagingJobOutput,
        crate::error::StartModelPackagingJobError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_start_model_packaging_job_error(response)
        } else {
            crate::operation_deser::parse_start_model_packaging_job_response(response)
        }
    }
}

/// Operation shape for `StopModel`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`stop_model`](crate::client::Client::stop_model).
///
/// See [`crate::client::fluent_builders::StopModel`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct StopModel {
    _private: (),
}
impl StopModel {
    /// Creates a new builder-style object to manufacture [`StopModelInput`](crate::input::StopModelInput)
    pub fn builder() -> crate::input::stop_model_input::Builder {
        crate::input::stop_model_input::Builder::default()
    }
    /// Creates a new `StopModel` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for StopModel {
    type Output = std::result::Result<crate::output::StopModelOutput, crate::error::StopModelError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_stop_model_error(response)
        } else {
            crate::operation_deser::parse_stop_model_response(response)
        }
    }
}

/// Operation shape for `TagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`tag_resource`](crate::client::Client::tag_resource).
///
/// See [`crate::client::fluent_builders::TagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct TagResource {
    _private: (),
}
impl TagResource {
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
    /// Creates a new `TagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for TagResource {
    type Output =
        std::result::Result<crate::output::TagResourceOutput, crate::error::TagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_tag_resource_error(response)
        } else {
            crate::operation_deser::parse_tag_resource_response(response)
        }
    }
}

/// Operation shape for `UntagResource`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`untag_resource`](crate::client::Client::untag_resource).
///
/// See [`crate::client::fluent_builders::UntagResource`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UntagResource {
    _private: (),
}
impl UntagResource {
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
    /// Creates a new `UntagResource` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UntagResource {
    type Output =
        std::result::Result<crate::output::UntagResourceOutput, crate::error::UntagResourceError>;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 200 {
            crate::operation_deser::parse_untag_resource_error(response)
        } else {
            crate::operation_deser::parse_untag_resource_response(response)
        }
    }
}

/// Operation shape for `UpdateDatasetEntries`.
///
/// This is usually constructed for you using the the fluent builder returned by
/// [`update_dataset_entries`](crate::client::Client::update_dataset_entries).
///
/// See [`crate::client::fluent_builders::UpdateDatasetEntries`] for more details about the operation.
#[derive(std::default::Default, std::clone::Clone, std::fmt::Debug)]
pub struct UpdateDatasetEntries {
    _private: (),
}
impl UpdateDatasetEntries {
    /// Creates a new builder-style object to manufacture [`UpdateDatasetEntriesInput`](crate::input::UpdateDatasetEntriesInput)
    pub fn builder() -> crate::input::update_dataset_entries_input::Builder {
        crate::input::update_dataset_entries_input::Builder::default()
    }
    /// Creates a new `UpdateDatasetEntries` operation.
    pub fn new() -> Self {
        Self { _private: () }
    }
}
impl aws_smithy_http::response::ParseStrictResponse for UpdateDatasetEntries {
    type Output = std::result::Result<
        crate::output::UpdateDatasetEntriesOutput,
        crate::error::UpdateDatasetEntriesError,
    >;
    fn parse(&self, response: &http::Response<bytes::Bytes>) -> Self::Output {
        if !response.status().is_success() && response.status().as_u16() != 202 {
            crate::operation_deser::parse_update_dataset_entries_error(response)
        } else {
            crate::operation_deser::parse_update_dataset_entries_response(response)
        }
    }
}
