// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
use std::fmt::Write;
/// See [`CreateDatasetInput`](crate::input::CreateDatasetInput)
pub mod create_dataset_input {
    /// A builder for [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
        pub(crate) dataset_source: std::option::Option<crate::model::DatasetSource>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project in which you want to create a dataset.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project in which you want to create a dataset.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
        /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>
        /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
        pub fn dataset_source(mut self, input: crate::model::DatasetSource) -> Self {
            self.dataset_source = Some(input);
            self
        }
        /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
        /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>
        /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
        pub fn set_dataset_source(
            mut self,
            input: std::option::Option<crate::model::DatasetSource>,
        ) -> Self {
            self.dataset_source = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateDatasetInput`](crate::input::CreateDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateDatasetInput {
                project_name: self.project_name,
                dataset_type: self.dataset_type,
                dataset_source: self.dataset_source,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateDatasetInputOperationOutputAlias = crate::operation::CreateDataset;
#[doc(hidden)]
pub type CreateDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateDatasetInput {
    /// Consumes the builder and constructs an Operation<[`CreateDataset`](crate::operation::CreateDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_1 = &_input.project_name;
                let input_1 = input_1.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_1, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/datasets",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_dataset(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_dataset(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateDataset",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateDatasetInput`](crate::input::CreateDatasetInput)
    pub fn builder() -> crate::input::create_dataset_input::Builder {
        crate::input::create_dataset_input::Builder::default()
    }
}

/// See [`CreateModelInput`](crate::input::CreateModelInput)
pub mod create_model_input {
    /// A builder for [`CreateModelInput`](crate::input::CreateModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
        pub(crate) output_config: std::option::Option<crate::model::OutputConfig>,
        pub(crate) kms_key_id: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The name of the project in which you want to create a model version.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project in which you want to create a model version.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>A description for the version of the model.</p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the version of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
        pub fn output_config(mut self, input: crate::model::OutputConfig) -> Self {
            self.output_config = Some(input);
            self
        }
        /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.output_config = input;
            self
        }
        /// <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
        pub fn kms_key_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.kms_key_id = Some(input.into());
            self
        }
        /// <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.kms_key_id = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateModelInput`](crate::input::CreateModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateModelInput {
                project_name: self.project_name,
                description: self.description,
                client_token: self.client_token,
                output_config: self.output_config,
                kms_key_id: self.kms_key_id,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateModelInputOperationOutputAlias = crate::operation::CreateModel;
#[doc(hidden)]
pub type CreateModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateModelInput {
    /// Consumes the builder and constructs an Operation<[`CreateModel`](crate::operation::CreateModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_2 = &_input.project_name;
                let input_2 = input_2.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_2, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_model(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_model(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateModel",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateModelInput`](crate::input::CreateModelInput)
    pub fn builder() -> crate::input::create_model_input::Builder {
        crate::input::create_model_input::Builder::default()
    }
}

/// See [`CreateProjectInput`](crate::input::CreateProjectInput)
pub mod create_project_input {
    /// A builder for [`CreateProjectInput`](crate::input::CreateProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name for the project.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`CreateProjectInput`](crate::input::CreateProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::CreateProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::CreateProjectInput {
                project_name: self.project_name,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type CreateProjectInputOperationOutputAlias = crate::operation::CreateProject;
#[doc(hidden)]
pub type CreateProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl CreateProjectInput {
    /// Consumes the builder and constructs an Operation<[`CreateProject`](crate::operation::CreateProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::CreateProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::CreateProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-11-20/projects").expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::CreateProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_create_project(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_create_project(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::CreateProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "CreateProject",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`CreateProjectInput`](crate::input::CreateProjectInput)
    pub fn builder() -> crate::input::create_project_input::Builder {
        crate::input::create_project_input::Builder::default()
    }
}

/// See [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
pub mod delete_dataset_input {
    /// A builder for [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the dataset that you want to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteDatasetInput {
                project_name: self.project_name,
                dataset_type: self.dataset_type,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteDatasetInputOperationOutputAlias = crate::operation::DeleteDataset;
#[doc(hidden)]
pub type DeleteDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DeleteDataset`](crate::operation::DeleteDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_3 = &_input.project_name;
                let input_3 = input_3.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_3, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_4 = &_input.dataset_type;
                let input_4 = input_4.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_type = aws_smithy_http::label::fmt_string(input_4, false);
                if dataset_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/datasets/{DatasetType}",
                    ProjectName = project_name,
                    DatasetType = dataset_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_dataset(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteDataset",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteDatasetInput`](crate::input::DeleteDatasetInput)
    pub fn builder() -> crate::input::delete_dataset_input::Builder {
        crate::input::delete_dataset_input::Builder::default()
    }
}

/// See [`DeleteModelInput`](crate::input::DeleteModelInput)
pub mod delete_model_input {
    /// A builder for [`DeleteModelInput`](crate::input::DeleteModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the model that you want to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the model that you want to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The version of the model that you want to delete.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model that you want to delete.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteModelInput`](crate::input::DeleteModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteModelInput {
                project_name: self.project_name,
                model_version: self.model_version,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteModelInputOperationOutputAlias = crate::operation::DeleteModel;
#[doc(hidden)]
pub type DeleteModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteModelInput {
    /// Consumes the builder and constructs an Operation<[`DeleteModel`](crate::operation::DeleteModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_5 = &_input.project_name;
                let input_5 = input_5.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_5, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_6 = &_input.model_version;
                let input_6 = input_6.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_version = aws_smithy_http::label::fmt_string(input_6, false);
                if model_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models/{ModelVersion}",
                    ProjectName = project_name,
                    ModelVersion = model_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_model(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteModel",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteModelInput`](crate::input::DeleteModelInput)
    pub fn builder() -> crate::input::delete_model_input::Builder {
        crate::input::delete_model_input::Builder::default()
    }
}

/// See [`DeleteProjectInput`](crate::input::DeleteProjectInput)
pub mod delete_project_input {
    /// A builder for [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project to delete.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`DeleteProjectInput`](crate::input::DeleteProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DeleteProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DeleteProjectInput {
                project_name: self.project_name,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type DeleteProjectInputOperationOutputAlias = crate::operation::DeleteProject;
#[doc(hidden)]
pub type DeleteProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DeleteProjectInput {
    /// Consumes the builder and constructs an Operation<[`DeleteProject`](crate::operation::DeleteProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DeleteProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::DeleteProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_7 = &_input.project_name;
                let input_7 = input_7.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_7, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DeleteProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_delete_project(input, builder)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DeleteProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DeleteProject",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DeleteProjectInput`](crate::input::DeleteProjectInput)
    pub fn builder() -> crate::input::delete_project_input::Builder {
        crate::input::delete_project_input::Builder::default()
    }
}

/// See [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
pub mod describe_dataset_input {
    /// A builder for [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the dataset that you want to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeDatasetInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeDatasetInput {
                project_name: self.project_name,
                dataset_type: self.dataset_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeDatasetInputOperationOutputAlias = crate::operation::DescribeDataset;
#[doc(hidden)]
pub type DescribeDatasetInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeDatasetInput {
    /// Consumes the builder and constructs an Operation<[`DescribeDataset`](crate::operation::DescribeDataset)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeDataset,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeDatasetInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_8 = &_input.project_name;
                let input_8 = input_8.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_8, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_9 = &_input.dataset_type;
                let input_9 = input_9.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_type = aws_smithy_http::label::fmt_string(input_9, false);
                if dataset_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/datasets/{DatasetType}",
                    ProjectName = project_name,
                    DatasetType = dataset_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeDatasetInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeDataset::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeDataset",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeDatasetInput`](crate::input::DescribeDatasetInput)
    pub fn builder() -> crate::input::describe_dataset_input::Builder {
        crate::input::describe_dataset_input::Builder::default()
    }
}

/// See [`DescribeModelInput`](crate::input::DescribeModelInput)
pub mod describe_model_input {
    /// A builder for [`DescribeModelInput`](crate::input::DescribeModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The project that contains the version of a model that you want to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The project that contains the version of a model that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The version of the model that you want to describe.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model that you want to describe.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelInput`](crate::input::DescribeModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeModelInput {
                project_name: self.project_name,
                model_version: self.model_version,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeModelInputOperationOutputAlias = crate::operation::DescribeModel;
#[doc(hidden)]
pub type DescribeModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeModelInput {
    /// Consumes the builder and constructs an Operation<[`DescribeModel`](crate::operation::DescribeModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_10 = &_input.project_name;
                let input_10 = input_10.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_10, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_11 = &_input.model_version;
                let input_11 = input_11.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_version = aws_smithy_http::label::fmt_string(input_11, false);
                if model_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models/{ModelVersion}",
                    ProjectName = project_name,
                    ModelVersion = model_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeModel",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeModelInput`](crate::input::DescribeModelInput)
    pub fn builder() -> crate::input::describe_model_input::Builder {
        crate::input::describe_model_input::Builder::default()
    }
}

/// See [`DescribeModelPackagingJobInput`](crate::input::DescribeModelPackagingJobInput)
pub mod describe_model_packaging_job_input {
    /// A builder for [`DescribeModelPackagingJobInput`](crate::input::DescribeModelPackagingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the model packaging job that you want to describe. </p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the model packaging job that you want to describe. </p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The job name for the model packaging job. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>The job name for the model packaging job. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeModelPackagingJobInput`](crate::input::DescribeModelPackagingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeModelPackagingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeModelPackagingJobInput {
                project_name: self.project_name,
                job_name: self.job_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeModelPackagingJobInputOperationOutputAlias =
    crate::operation::DescribeModelPackagingJob;
#[doc(hidden)]
pub type DescribeModelPackagingJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeModelPackagingJobInput {
    /// Consumes the builder and constructs an Operation<[`DescribeModelPackagingJob`](crate::operation::DescribeModelPackagingJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeModelPackagingJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeModelPackagingJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_12 = &_input.project_name;
                let input_12 = input_12.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_12, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_13 = &_input.job_name;
                let input_13 = input_13.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let job_name = aws_smithy_http::label::fmt_string(input_13, false);
                if job_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "job_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/modelpackagingjobs/{JobName}",
                    ProjectName = project_name,
                    JobName = job_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeModelPackagingJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeModelPackagingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeModelPackagingJob",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeModelPackagingJobInput`](crate::input::DescribeModelPackagingJobInput)
    pub fn builder() -> crate::input::describe_model_packaging_job_input::Builder {
        crate::input::describe_model_packaging_job_input::Builder::default()
    }
}

/// See [`DescribeProjectInput`](crate::input::DescribeProjectInput)
pub mod describe_project_input {
    /// A builder for [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that you want to describe.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// Consumes the builder and constructs a [`DescribeProjectInput`](crate::input::DescribeProjectInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DescribeProjectInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DescribeProjectInput {
                project_name: self.project_name,
            })
        }
    }
}
#[doc(hidden)]
pub type DescribeProjectInputOperationOutputAlias = crate::operation::DescribeProject;
#[doc(hidden)]
pub type DescribeProjectInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DescribeProjectInput {
    /// Consumes the builder and constructs an Operation<[`DescribeProject`](crate::operation::DescribeProject)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DescribeProject,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DescribeProjectInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_14 = &_input.project_name;
                let input_14 = input_14.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_14, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DescribeProjectInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DescribeProject::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DescribeProject",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DescribeProjectInput`](crate::input::DescribeProjectInput)
    pub fn builder() -> crate::input::describe_project_input::Builder {
        crate::input::describe_project_input::Builder::default()
    }
}

/// See [`DetectAnomaliesInput`](crate::input::DetectAnomaliesInput)
pub mod detect_anomalies_input {
    /// A builder for [`DetectAnomaliesInput`](crate::input::DetectAnomaliesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) body: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        pub(crate) content_type: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the model version that you want to use.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the model version that you want to use.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The version of the model that you want to use.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model that you want to use.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>The unencrypted image bytes that you want to analyze. </p>
        pub fn body(mut self, input: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.body = Some(input);
            self
        }
        /// <p>The unencrypted image bytes that you want to analyze. </p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.body = input;
            self
        }
        /// <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
        pub fn content_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.content_type = Some(input.into());
            self
        }
        /// <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.content_type = input;
            self
        }
        /// Consumes the builder and constructs a [`DetectAnomaliesInput`](crate::input::DetectAnomaliesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::DetectAnomaliesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::DetectAnomaliesInput {
                project_name: self.project_name,
                model_version: self.model_version,
                body: self.body.unwrap_or_default(),
                content_type: self.content_type,
            })
        }
    }
}
#[doc(hidden)]
pub type DetectAnomaliesInputOperationOutputAlias = crate::operation::DetectAnomalies;
#[doc(hidden)]
pub type DetectAnomaliesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl DetectAnomaliesInput {
    /// Consumes the builder and constructs an Operation<[`DetectAnomalies`](crate::operation::DetectAnomalies)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::DetectAnomalies,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::DetectAnomaliesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_15 = &_input.project_name;
                let input_15 = input_15.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_15, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_16 = &_input.model_version;
                let input_16 = input_16.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_version = aws_smithy_http::label::fmt_string(input_16, false);
                if model_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models/{ModelVersion}/detect",
                    ProjectName = project_name,
                    ModelVersion = model_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::DetectAnomaliesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_detect_anomalies(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/octet-stream",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_payload_detect_anomalies_input(self.body)?.into_inner(),
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::DetectAnomalies::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "DetectAnomalies",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`DetectAnomaliesInput`](crate::input::DetectAnomaliesInput)
    pub fn builder() -> crate::input::detect_anomalies_input::Builder {
        crate::input::detect_anomalies_input::Builder::default()
    }
}

/// See [`ListDatasetEntriesInput`](crate::input::ListDatasetEntriesInput)
pub mod list_dataset_entries_input {
    /// A builder for [`ListDatasetEntriesInput`](crate::input::ListDatasetEntriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
        pub(crate) labeled: std::option::Option<bool>,
        pub(crate) anomaly_class: std::option::Option<std::string::String>,
        pub(crate) before_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) after_creation_date: std::option::Option<aws_smithy_types::DateTime>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
        pub(crate) source_ref_contains: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the dataset that you want to list.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to list.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
        pub fn labeled(mut self, input: bool) -> Self {
            self.labeled = Some(input);
            self
        }
        /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
        pub fn set_labeled(mut self, input: std::option::Option<bool>) -> Self {
            self.labeled = input;
            self
        }
        /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
        pub fn anomaly_class(mut self, input: impl Into<std::string::String>) -> Self {
            self.anomaly_class = Some(input.into());
            self
        }
        /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
        pub fn set_anomaly_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.anomaly_class = input;
            self
        }
        /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn before_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.before_creation_date = Some(input);
            self
        }
        /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn set_before_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.before_creation_date = input;
            self
        }
        /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn after_creation_date(mut self, input: aws_smithy_types::DateTime) -> Self {
            self.after_creation_date = Some(input);
            self
        }
        /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn set_after_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::DateTime>,
        ) -> Self {
            self.after_creation_date = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
        pub fn source_ref_contains(mut self, input: impl Into<std::string::String>) -> Self {
            self.source_ref_contains = Some(input.into());
            self
        }
        /// <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
        pub fn set_source_ref_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.source_ref_contains = input;
            self
        }
        /// Consumes the builder and constructs a [`ListDatasetEntriesInput`](crate::input::ListDatasetEntriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListDatasetEntriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListDatasetEntriesInput {
                project_name: self.project_name,
                dataset_type: self.dataset_type,
                labeled: self.labeled,
                anomaly_class: self.anomaly_class,
                before_creation_date: self.before_creation_date,
                after_creation_date: self.after_creation_date,
                next_token: self.next_token,
                max_results: self.max_results,
                source_ref_contains: self.source_ref_contains,
            })
        }
    }
}
#[doc(hidden)]
pub type ListDatasetEntriesInputOperationOutputAlias = crate::operation::ListDatasetEntries;
#[doc(hidden)]
pub type ListDatasetEntriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListDatasetEntriesInput {
    /// Consumes the builder and constructs an Operation<[`ListDatasetEntries`](crate::operation::ListDatasetEntries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListDatasetEntries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListDatasetEntriesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_17 = &_input.project_name;
                let input_17 = input_17.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_17, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_18 = &_input.dataset_type;
                let input_18 = input_18.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_type = aws_smithy_http::label::fmt_string(input_18, false);
                if dataset_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/datasets/{DatasetType}/entries",
                    ProjectName = project_name,
                    DatasetType = dataset_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListDatasetEntriesInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_19) = &_input.labeled {
                    query.push_kv(
                        "labeled",
                        aws_smithy_types::primitive::Encoder::from(*inner_19).encode(),
                    );
                }
                if let Some(inner_20) = &_input.anomaly_class {
                    query.push_kv(
                        "anomalyClass",
                        &aws_smithy_http::query::fmt_string(&inner_20),
                    );
                }
                if let Some(inner_21) = &_input.before_creation_date {
                    query.push_kv(
                        "createdBefore",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_21,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_22) = &_input.after_creation_date {
                    query.push_kv(
                        "createdAfter",
                        &aws_smithy_http::query::fmt_timestamp(
                            inner_22,
                            aws_smithy_types::date_time::Format::DateTime,
                        )?,
                    );
                }
                if let Some(inner_23) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_23));
                }
                if let Some(inner_24) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_24).encode(),
                    );
                }
                if let Some(inner_25) = &_input.source_ref_contains {
                    query.push_kv(
                        "sourceRefContains",
                        &aws_smithy_http::query::fmt_string(&inner_25),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListDatasetEntriesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListDatasetEntries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListDatasetEntries",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListDatasetEntriesInput`](crate::input::ListDatasetEntriesInput)
    pub fn builder() -> crate::input::list_dataset_entries_input::Builder {
        crate::input::list_dataset_entries_input::Builder::default()
    }
}

/// See [`ListModelPackagingJobsInput`](crate::input::ListModelPackagingJobsInput)
pub mod list_model_packaging_jobs_input {
    /// A builder for [`ListModelPackagingJobsInput`](crate::input::ListModelPackagingJobsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p> The name of the project for which you want to list the model packaging jobs. </p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p> The name of the project for which you want to list the model packaging jobs. </p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelPackagingJobsInput`](crate::input::ListModelPackagingJobsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListModelPackagingJobsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListModelPackagingJobsInput {
                project_name: self.project_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListModelPackagingJobsInputOperationOutputAlias = crate::operation::ListModelPackagingJobs;
#[doc(hidden)]
pub type ListModelPackagingJobsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListModelPackagingJobsInput {
    /// Consumes the builder and constructs an Operation<[`ListModelPackagingJobs`](crate::operation::ListModelPackagingJobs)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListModelPackagingJobs,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListModelPackagingJobsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_26 = &_input.project_name;
                let input_26 = input_26.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_26, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/modelpackagingjobs",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListModelPackagingJobsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_27) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_27));
                }
                if let Some(inner_28) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_28).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListModelPackagingJobsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListModelPackagingJobs::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListModelPackagingJobs",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListModelPackagingJobsInput`](crate::input::ListModelPackagingJobsInput)
    pub fn builder() -> crate::input::list_model_packaging_jobs_input::Builder {
        crate::input::list_model_packaging_jobs_input::Builder::default()
    }
}

/// See [`ListModelsInput`](crate::input::ListModelsInput)
pub mod list_models_input {
    /// A builder for [`ListModelsInput`](crate::input::ListModelsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>The name of the project that contains the model versions that you want to list.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the model versions that you want to list.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListModelsInput`](crate::input::ListModelsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListModelsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListModelsInput {
                project_name: self.project_name,
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListModelsInputOperationOutputAlias = crate::operation::ListModels;
#[doc(hidden)]
pub type ListModelsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListModelsInput {
    /// Consumes the builder and constructs an Operation<[`ListModels`](crate::operation::ListModels)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListModels,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListModelsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_29 = &_input.project_name;
                let input_29 = input_29.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_29, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListModelsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_30) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_30));
                }
                if let Some(inner_31) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_31).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListModelsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListModels::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListModels",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListModelsInput`](crate::input::ListModelsInput)
    pub fn builder() -> crate::input::list_models_input::Builder {
        crate::input::list_models_input::Builder::default()
    }
}

/// See [`ListProjectsInput`](crate::input::ListProjectsInput)
pub mod list_projects_input {
    /// A builder for [`ListProjectsInput`](crate::input::ListProjectsInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) next_token: std::option::Option<std::string::String>,
        pub(crate) max_results: std::option::Option<i32>,
    }
    impl Builder {
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
        pub fn next_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.next_token = Some(input.into());
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.next_token = input;
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn max_results(mut self, input: i32) -> Self {
            self.max_results = Some(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.max_results = input;
            self
        }
        /// Consumes the builder and constructs a [`ListProjectsInput`](crate::input::ListProjectsInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListProjectsInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListProjectsInput {
                next_token: self.next_token,
                max_results: self.max_results,
            })
        }
    }
}
#[doc(hidden)]
pub type ListProjectsInputOperationOutputAlias = crate::operation::ListProjects;
#[doc(hidden)]
pub type ListProjectsInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListProjectsInput {
    /// Consumes the builder and constructs an Operation<[`ListProjects`](crate::operation::ListProjects)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListProjects,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListProjectsInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                write!(output, "/2020-11-20/projects").expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::ListProjectsInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_32) = &_input.next_token {
                    query.push_kv("nextToken", &aws_smithy_http::query::fmt_string(&inner_32));
                }
                if let Some(inner_33) = &_input.max_results {
                    query.push_kv(
                        "maxResults",
                        aws_smithy_types::primitive::Encoder::from(*inner_33).encode(),
                    );
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListProjectsInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListProjects::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListProjects",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListProjectsInput`](crate::input::ListProjectsInput)
    pub fn builder() -> crate::input::list_projects_input::Builder {
        crate::input::list_projects_input::Builder::default()
    }
}

/// See [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
pub mod list_tags_for_resource_input {
    /// A builder for [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Consumes the builder and constructs a [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::ListTagsForResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::ListTagsForResourceInput {
                resource_arn: self.resource_arn,
            })
        }
    }
}
#[doc(hidden)]
pub type ListTagsForResourceInputOperationOutputAlias = crate::operation::ListTagsForResource;
#[doc(hidden)]
pub type ListTagsForResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl ListTagsForResourceInput {
    /// Consumes the builder and constructs an Operation<[`ListTagsForResource`](crate::operation::ListTagsForResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::ListTagsForResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::ListTagsForResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_34 = &_input.resource_arn;
                let input_34 = input_34.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_34, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/tags/{ResourceArn}",
                    ResourceArn = resource_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::ListTagsForResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("GET").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::ListTagsForResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "ListTagsForResource",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`ListTagsForResourceInput`](crate::input::ListTagsForResourceInput)
    pub fn builder() -> crate::input::list_tags_for_resource_input::Builder {
        crate::input::list_tags_for_resource_input::Builder::default()
    }
}

/// See [`StartModelInput`](crate::input::StartModelInput)
pub mod start_model_input {
    /// A builder for [`StartModelInput`](crate::input::StartModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) min_inference_units: std::option::Option<i32>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the model that you want to start.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the model that you want to start.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The version of the model that you want to start.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model that you want to start.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
        pub fn min_inference_units(mut self, input: i32) -> Self {
            self.min_inference_units = Some(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
        pub fn set_min_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.min_inference_units = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartModelInput`](crate::input::StartModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartModelInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartModelInput {
                project_name: self.project_name,
                model_version: self.model_version,
                min_inference_units: self.min_inference_units,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartModelInputOperationOutputAlias = crate::operation::StartModel;
#[doc(hidden)]
pub type StartModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartModelInput {
    /// Consumes the builder and constructs an Operation<[`StartModel`](crate::operation::StartModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_35 = &_input.project_name;
                let input_35 = input_35.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_35, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_36 = &_input.model_version;
                let input_36 = input_36.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_version = aws_smithy_http::label::fmt_string(input_36, false);
                if model_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models/{ModelVersion}/start",
                    ProjectName = project_name,
                    ModelVersion = model_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_start_model(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_model(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartModel::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartModel",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartModelInput`](crate::input::StartModelInput)
    pub fn builder() -> crate::input::start_model_input::Builder {
        crate::input::start_model_input::Builder::default()
    }
}

/// See [`StartModelPackagingJobInput`](crate::input::StartModelPackagingJobInput)
pub mod start_model_packaging_job_input {
    /// A builder for [`StartModelPackagingJobInput`](crate::input::StartModelPackagingJobInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) job_name: std::option::Option<std::string::String>,
        pub(crate) configuration: std::option::Option<crate::model::ModelPackagingConfiguration>,
        pub(crate) description: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p> The name of the project which contains the version of the model that you want to package. </p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p> The name of the project which contains the version of the model that you want to package. </p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p> The version of the model within the project that you want to package. </p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p> The version of the model within the project that you want to package. </p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
        pub fn job_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.job_name = Some(input.into());
            self
        }
        /// <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
        pub fn set_job_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.job_name = input;
            self
        }
        /// <p>The configuration for the model packaging job. </p>
        pub fn configuration(mut self, input: crate::model::ModelPackagingConfiguration) -> Self {
            self.configuration = Some(input);
            self
        }
        /// <p>The configuration for the model packaging job. </p>
        pub fn set_configuration(
            mut self,
            input: std::option::Option<crate::model::ModelPackagingConfiguration>,
        ) -> Self {
            self.configuration = input;
            self
        }
        /// <p>A description for the model packaging job. </p>
        pub fn description(mut self, input: impl Into<std::string::String>) -> Self {
            self.description = Some(input.into());
            self
        }
        /// <p>A description for the model packaging job. </p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.description = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StartModelPackagingJobInput`](crate::input::StartModelPackagingJobInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::StartModelPackagingJobInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::StartModelPackagingJobInput {
                project_name: self.project_name,
                model_version: self.model_version,
                job_name: self.job_name,
                configuration: self.configuration,
                description: self.description,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StartModelPackagingJobInputOperationOutputAlias = crate::operation::StartModelPackagingJob;
#[doc(hidden)]
pub type StartModelPackagingJobInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StartModelPackagingJobInput {
    /// Consumes the builder and constructs an Operation<[`StartModelPackagingJob`](crate::operation::StartModelPackagingJob)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StartModelPackagingJob,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StartModelPackagingJobInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_37 = &_input.project_name;
                let input_37 = input_37.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_37, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/modelpackagingjobs",
                    ProjectName = project_name
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StartModelPackagingJobInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_start_model_packaging_job(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_start_model_packaging_job(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::StartModelPackagingJob::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "StartModelPackagingJob",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StartModelPackagingJobInput`](crate::input::StartModelPackagingJobInput)
    pub fn builder() -> crate::input::start_model_packaging_job_input::Builder {
        crate::input::start_model_packaging_job_input::Builder::default()
    }
}

/// See [`StopModelInput`](crate::input::StopModelInput)
pub mod stop_model_input {
    /// A builder for [`StopModelInput`](crate::input::StopModelInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) model_version: std::option::Option<std::string::String>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the model that you want to stop.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the model that you want to stop.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The version of the model that you want to stop.</p>
        pub fn model_version(mut self, input: impl Into<std::string::String>) -> Self {
            self.model_version = Some(input.into());
            self
        }
        /// <p>The version of the model that you want to stop.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.model_version = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`StopModelInput`](crate::input::StopModelInput)
        pub fn build(
            self,
        ) -> std::result::Result<crate::input::StopModelInput, aws_smithy_http::operation::BuildError>
        {
            Ok(crate::input::StopModelInput {
                project_name: self.project_name,
                model_version: self.model_version,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type StopModelInputOperationOutputAlias = crate::operation::StopModel;
#[doc(hidden)]
pub type StopModelInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl StopModelInput {
    /// Consumes the builder and constructs an Operation<[`StopModel`](crate::operation::StopModel)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::StopModel,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::StopModelInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_38 = &_input.project_name;
                let input_38 = input_38.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_38, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_39 = &_input.model_version;
                let input_39 = input_39.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    },
                )?;
                let model_version = aws_smithy_http::label::fmt_string(input_39, false);
                if model_version.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "model_version",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/models/{ModelVersion}/stop",
                    ProjectName = project_name,
                    ModelVersion = model_version
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::StopModelInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder = crate::http_serde::add_headers_stop_model(input, builder)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op =
            aws_smithy_http::operation::Operation::new(request, crate::operation::StopModel::new())
                .with_metadata(aws_smithy_http::operation::Metadata::new(
                    "StopModel",
                    "lookoutvision",
                ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`StopModelInput`](crate::input::StopModelInput)
    pub fn builder() -> crate::input::stop_model_input::Builder {
        crate::input::stop_model_input::Builder::default()
    }
}

/// See [`TagResourceInput`](crate::input::TagResourceInput)
pub mod tag_resource_input {
    /// A builder for [`TagResourceInput`](crate::input::TagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags to assign to the model.</p>
        pub fn tags(mut self, input: crate::model::Tag) -> Self {
            let mut v = self.tags.unwrap_or_default();
            v.push(input);
            self.tags = Some(v);
            self
        }
        /// <p>The key-value tags to assign to the model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.tags = input;
            self
        }
        /// Consumes the builder and constructs a [`TagResourceInput`](crate::input::TagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::TagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::TagResourceInput {
                resource_arn: self.resource_arn,
                tags: self.tags,
            })
        }
    }
}
#[doc(hidden)]
pub type TagResourceInputOperationOutputAlias = crate::operation::TagResource;
#[doc(hidden)]
pub type TagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl TagResourceInput {
    /// Consumes the builder and constructs an Operation<[`TagResource`](crate::operation::TagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::TagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::TagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_40 = &_input.resource_arn;
                let input_40 = input_40.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_40, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/tags/{ResourceArn}",
                    ResourceArn = resource_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::TagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_tag_resource(&self)?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::TagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "TagResource",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`TagResourceInput`](crate::input::TagResourceInput)
    pub fn builder() -> crate::input::tag_resource_input::Builder {
        crate::input::tag_resource_input::Builder::default()
    }
}

/// See [`UntagResourceInput`](crate::input::UntagResourceInput)
pub mod untag_resource_input {
    /// A builder for [`UntagResourceInput`](crate::input::UntagResourceInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) resource_arn: std::option::Option<std::string::String>,
        pub(crate) tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
    }
    impl Builder {
        /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
        pub fn resource_arn(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_arn = Some(input.into());
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_arn = input;
            self
        }
        /// Appends an item to `tag_keys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_keys(mut self, input: impl Into<std::string::String>) -> Self {
            let mut v = self.tag_keys.unwrap_or_default();
            v.push(input.into());
            self.tag_keys = Some(v);
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.tag_keys = input;
            self
        }
        /// Consumes the builder and constructs a [`UntagResourceInput`](crate::input::UntagResourceInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UntagResourceInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UntagResourceInput {
                resource_arn: self.resource_arn,
                tag_keys: self.tag_keys,
            })
        }
    }
}
#[doc(hidden)]
pub type UntagResourceInputOperationOutputAlias = crate::operation::UntagResource;
#[doc(hidden)]
pub type UntagResourceInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UntagResourceInput {
    /// Consumes the builder and constructs an Operation<[`UntagResource`](crate::operation::UntagResource)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        &self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UntagResource,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        let mut request = {
            fn uri_base(
                _input: &crate::input::UntagResourceInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_41 = &_input.resource_arn;
                let input_41 = input_41.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    },
                )?;
                let resource_arn = aws_smithy_http::label::fmt_string(input_41, false);
                if resource_arn.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "resource_arn",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/tags/{ResourceArn}",
                    ResourceArn = resource_arn
                )
                .expect("formatting should succeed");
                Ok(())
            }
            fn uri_query(
                _input: &crate::input::UntagResourceInput,
                mut output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let mut query = aws_smithy_http::query::Writer::new(&mut output);
                if let Some(inner_42) = &_input.tag_keys {
                    for inner_43 in inner_42 {
                        query.push_kv("tagKeys", &aws_smithy_http::query::fmt_string(&inner_43));
                    }
                }
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UntagResourceInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                uri_query(input, &mut uri)?;
                Ok(builder.method("DELETE").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from("");
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UntagResource::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UntagResource",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UntagResourceInput`](crate::input::UntagResourceInput)
    pub fn builder() -> crate::input::untag_resource_input::Builder {
        crate::input::untag_resource_input::Builder::default()
    }
}

/// See [`UpdateDatasetEntriesInput`](crate::input::UpdateDatasetEntriesInput)
pub mod update_dataset_entries_input {
    /// A builder for [`UpdateDatasetEntriesInput`](crate::input::UpdateDatasetEntriesInput)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) project_name: std::option::Option<std::string::String>,
        pub(crate) dataset_type: std::option::Option<std::string::String>,
        pub(crate) changes: std::option::Option<aws_smithy_types::Blob>,
        pub(crate) client_token: std::option::Option<std::string::String>,
    }
    impl Builder {
        /// <p>The name of the project that contains the dataset that you want to update.</p>
        pub fn project_name(mut self, input: impl Into<std::string::String>) -> Self {
            self.project_name = Some(input.into());
            self
        }
        /// <p>The name of the project that contains the dataset that you want to update.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.project_name = input;
            self
        }
        /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, input: impl Into<std::string::String>) -> Self {
            self.dataset_type = Some(input.into());
            self
        }
        /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.dataset_type = input;
            self
        }
        /// <p>The entries to add to the dataset.</p>
        pub fn changes(mut self, input: aws_smithy_types::Blob) -> Self {
            self.changes = Some(input);
            self
        }
        /// <p>The entries to add to the dataset.</p>
        pub fn set_changes(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.changes = input;
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
        pub fn client_token(mut self, input: impl Into<std::string::String>) -> Self {
            self.client_token = Some(input.into());
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
        /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>
        /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.client_token = input;
            self
        }
        /// Consumes the builder and constructs a [`UpdateDatasetEntriesInput`](crate::input::UpdateDatasetEntriesInput)
        pub fn build(
            self,
        ) -> std::result::Result<
            crate::input::UpdateDatasetEntriesInput,
            aws_smithy_http::operation::BuildError,
        > {
            Ok(crate::input::UpdateDatasetEntriesInput {
                project_name: self.project_name,
                dataset_type: self.dataset_type,
                changes: self.changes,
                client_token: self.client_token,
            })
        }
    }
}
#[doc(hidden)]
pub type UpdateDatasetEntriesInputOperationOutputAlias = crate::operation::UpdateDatasetEntries;
#[doc(hidden)]
pub type UpdateDatasetEntriesInputOperationRetryAlias = aws_http::retry::AwsErrorRetryPolicy;
impl UpdateDatasetEntriesInput {
    /// Consumes the builder and constructs an Operation<[`UpdateDatasetEntries`](crate::operation::UpdateDatasetEntries)>
    #[allow(unused_mut)]
    #[allow(clippy::let_and_return)]
    #[allow(clippy::needless_borrow)]
    pub async fn make_operation(
        mut self,
        _config: &crate::config::Config,
    ) -> std::result::Result<
        aws_smithy_http::operation::Operation<
            crate::operation::UpdateDatasetEntries,
            aws_http::retry::AwsErrorRetryPolicy,
        >,
        aws_smithy_http::operation::BuildError,
    > {
        if self.client_token.is_none() {
            self.client_token = Some(_config.make_token.make_idempotency_token());
        }
        let mut request = {
            fn uri_base(
                _input: &crate::input::UpdateDatasetEntriesInput,
                output: &mut String,
            ) -> Result<(), aws_smithy_http::operation::BuildError> {
                let input_44 = &_input.project_name;
                let input_44 = input_44.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    },
                )?;
                let project_name = aws_smithy_http::label::fmt_string(input_44, false);
                if project_name.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "project_name",
                        details: "cannot be empty or unset",
                    });
                }
                let input_45 = &_input.dataset_type;
                let input_45 = input_45.as_ref().ok_or(
                    aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    },
                )?;
                let dataset_type = aws_smithy_http::label::fmt_string(input_45, false);
                if dataset_type.is_empty() {
                    return Err(aws_smithy_http::operation::BuildError::MissingField {
                        field: "dataset_type",
                        details: "cannot be empty or unset",
                    });
                }
                write!(
                    output,
                    "/2020-11-20/projects/{ProjectName}/datasets/{DatasetType}/entries",
                    ProjectName = project_name,
                    DatasetType = dataset_type
                )
                .expect("formatting should succeed");
                Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::input::UpdateDatasetEntriesInput,
                builder: http::request::Builder,
            ) -> std::result::Result<http::request::Builder, aws_smithy_http::operation::BuildError>
            {
                let mut uri = String::new();
                uri_base(input, &mut uri)?;
                let builder =
                    crate::http_serde::add_headers_update_dataset_entries(input, builder)?;
                Ok(builder.method("PATCH").uri(uri))
            }
            let mut builder = update_http_builder(&self, http::request::Builder::new())?;
            builder = aws_smithy_http::header::set_request_header_if_absent(
                builder,
                http::header::CONTENT_TYPE,
                "application/json",
            );
            builder
        };
        let mut properties = aws_smithy_http::property_bag::SharedPropertyBag::new();
        #[allow(clippy::useless_conversion)]
        let body = aws_smithy_http::body::SdkBody::from(
            crate::operation_ser::serialize_operation_crate_operation_update_dataset_entries(
                &self,
            )?,
        );
        if let Some(content_length) = body.content_length() {
            request = aws_smithy_http::header::set_request_header_if_absent(
                request,
                http::header::CONTENT_LENGTH,
                content_length,
            );
        }
        let request = request.body(body).expect("should be valid request");
        let mut request = aws_smithy_http::operation::Request::from_parts(request, properties);
        request
            .properties_mut()
            .insert(aws_smithy_http::http_versions::DEFAULT_HTTP_VERSION_LIST.clone());
        let mut user_agent = aws_http::user_agent::AwsUserAgent::new_from_environment(
            aws_types::os_shim_internal::Env::real(),
            crate::API_METADATA.clone(),
        );
        if let Some(app_name) = _config.app_name() {
            user_agent = user_agent.with_app_name(app_name.clone());
        }
        request.properties_mut().insert(user_agent);
        let mut signing_config = aws_sig_auth::signer::OperationSigningConfig::default_config();
        request.properties_mut().insert(signing_config);
        request
            .properties_mut()
            .insert(aws_types::SigningService::from_static(
                _config.signing_service(),
            ));
        aws_endpoint::set_endpoint_resolver(
            &mut request.properties_mut(),
            _config.endpoint_resolver.clone(),
        );
        if let Some(region) = &_config.region {
            request.properties_mut().insert(region.clone());
        }
        aws_http::auth::set_provider(
            &mut request.properties_mut(),
            _config.credentials_provider.clone(),
        );
        let op = aws_smithy_http::operation::Operation::new(
            request,
            crate::operation::UpdateDatasetEntries::new(),
        )
        .with_metadata(aws_smithy_http::operation::Metadata::new(
            "UpdateDatasetEntries",
            "lookoutvision",
        ));
        let op = op.with_retry_policy(aws_http::retry::AwsErrorRetryPolicy::new());
        Ok(op)
    }
    /// Creates a new builder-style object to manufacture [`UpdateDatasetEntriesInput`](crate::input::UpdateDatasetEntriesInput)
    pub fn builder() -> crate::input::update_dataset_entries_input::Builder {
        crate::input::update_dataset_entries_input::Builder::default()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UpdateDatasetEntriesInput {
    /// <p>The name of the project that contains the dataset that you want to update.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
    pub dataset_type: std::option::Option<std::string::String>,
    /// <p>The entries to add to the dataset.</p>
    pub changes: std::option::Option<aws_smithy_types::Blob>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl UpdateDatasetEntriesInput {
    /// <p>The name of the project that contains the dataset that you want to update.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update the training dataset. Specify <code>test</code> to update the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
    /// <p>The entries to add to the dataset.</p>
    pub fn changes(&self) -> std::option::Option<&aws_smithy_types::Blob> {
        self.changes.as_ref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>UpdateDatasetEntries</code>. In this case, safely retry your call to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple updates with the same dataset entries. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency token is active for 8 hours. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for UpdateDatasetEntriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateDatasetEntriesInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("changes", &self.changes);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>A list of the keys of the tags that you want to remove.</p>
    pub tag_keys: std::option::Option<std::vec::Vec<std::string::String>>,
}
impl UntagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>A list of the keys of the tags that you want to remove.</p>
    pub fn tag_keys(&self) -> std::option::Option<&[std::string::String]> {
        self.tag_keys.as_deref()
    }
}
impl std::fmt::Debug for UntagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("UntagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tag_keys", &self.tag_keys);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
    pub resource_arn: std::option::Option<std::string::String>,
    /// <p>The key-value tags to assign to the model.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl TagResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
    /// <p>The key-value tags to assign to the model.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for TagResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("TagResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StopModelInput {
    /// <p>The name of the project that contains the model that you want to stop.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The version of the model that you want to stop.</p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StopModelInput {
    /// <p>The name of the project that contains the model that you want to stop.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The version of the model that you want to stop.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StopModel</code>. In this case, safely retry your call to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple stop requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency token is active for 8 hours. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StopModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StopModelInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("model_version", &self.model_version);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartModelPackagingJobInput {
    /// <p> The name of the project which contains the version of the model that you want to package. </p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p> The version of the model within the project that you want to package. </p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
    pub job_name: std::option::Option<std::string::String>,
    /// <p>The configuration for the model packaging job. </p>
    pub configuration: std::option::Option<crate::model::ModelPackagingConfiguration>,
    /// <p>A description for the model packaging job. </p>
    pub description: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartModelPackagingJobInput {
    /// <p> The name of the project which contains the version of the model that you want to package. </p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p> The version of the model within the project that you want to package. </p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>A name for the model packaging job. If you don't supply a value, the service creates a job name for you. </p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
    /// <p>The configuration for the model packaging job. </p>
    pub fn configuration(&self) -> std::option::Option<&crate::model::ModelPackagingConfiguration> {
        self.configuration.as_ref()
    }
    /// <p>A description for the model packaging job. </p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModelPackagingJob</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModelPackagingJob</code>. In this case, safely retry your call to <code>StartModelPackagingJob</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModelPackagingJob</code>. An idempotency token is active for 8 hours. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartModelPackagingJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartModelPackagingJobInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("model_version", &self.model_version);
        formatter.field("job_name", &self.job_name);
        formatter.field("configuration", &self.configuration);
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct StartModelInput {
    /// <p>The name of the project that contains the model that you want to start.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The version of the model that you want to start.</p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
    pub min_inference_units: std::option::Option<i32>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl StartModelInput {
    /// <p>The name of the project that contains the model that you want to start.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The version of the model that you want to start.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>The minimum number of inference units to use. A single inference unit represents 1 hour of processing. Use a higher number to increase the TPS throughput of your model. You are charged for the number of inference units that you use. </p>
    pub fn min_inference_units(&self) -> std::option::Option<i32> {
        self.min_inference_units
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>StartModel</code>. In this case, safely retry your call to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple start requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency token is active for 8 hours. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for StartModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("StartModelInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("model_version", &self.model_version);
        formatter.field("min_inference_units", &self.min_inference_units);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
    pub resource_arn: std::option::Option<std::string::String>,
}
impl ListTagsForResourceInput {
    /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
    pub fn resource_arn(&self) -> std::option::Option<&str> {
        self.resource_arn.as_deref()
    }
}
impl std::fmt::Debug for ListTagsForResourceInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListTagsForResourceInput");
        formatter.field("resource_arn", &self.resource_arn);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListProjectsInput {
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListProjectsInput {
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of projects.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListProjectsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListProjectsInput");
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelsInput {
    /// <p>The name of the project that contains the model versions that you want to list.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    pub max_results: std::option::Option<i32>,
}
impl ListModelsInput {
    /// <p>The name of the project that contains the model versions that you want to list.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of models.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListModelsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelsInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListModelPackagingJobsInput {
    /// <p> The name of the project for which you want to list the model packaging jobs. </p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    pub max_results: std::option::Option<i32>,
}
impl ListModelPackagingJobsInput {
    /// <p> The name of the project for which you want to list the model packaging jobs. </p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>If the previous response was incomplete (because there is more results to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of results. </p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100. </p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
}
impl std::fmt::Debug for ListModelPackagingJobsInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListModelPackagingJobsInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ListDatasetEntriesInput {
    /// <p>The name of the project that contains the dataset that you want to list.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
    pub dataset_type: std::option::Option<std::string::String>,
    /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
    pub labeled: std::option::Option<bool>,
    /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
    pub anomaly_class: std::option::Option<std::string::String>,
    /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
    pub before_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
    pub after_creation_date: std::option::Option<aws_smithy_types::DateTime>,
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
    pub next_token: std::option::Option<std::string::String>,
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    pub max_results: std::option::Option<i32>,
    /// <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
    pub source_ref_contains: std::option::Option<std::string::String>,
}
impl ListDatasetEntriesInput {
    /// <p>The name of the project that contains the dataset that you want to list.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The type of the dataset that you want to list. Specify <code>train</code> to list the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset project, specify <code>train</code>.</p>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
    /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you don't specify a value, Lookout for Vision returns all entries.</p>
    pub fn labeled(&self) -> std::option::Option<bool> {
        self.labeled
    }
    /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
    pub fn anomaly_class(&self) -> std::option::Option<&str> {
        self.anomaly_class.as_deref()
    }
    /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
    pub fn before_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.before_creation_date.as_ref()
    }
    /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
    pub fn after_creation_date(&self) -> std::option::Option<&aws_smithy_types::DateTime> {
        self.after_creation_date.as_ref()
    }
    /// <p>If the previous response was incomplete (because there is more data to retrieve), Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to retrieve the next set of dataset entries.</p>
    pub fn next_token(&self) -> std::option::Option<&str> {
        self.next_token.as_deref()
    }
    /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100. If you specify a value greater than 100, a ValidationException error occurs. The default value is 100.</p>
    pub fn max_results(&self) -> std::option::Option<i32> {
        self.max_results
    }
    /// <p>Perform a "contains" search on the values of the <code>source-ref</code> key within the dataset. For example a value of "IMG_17" returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
    pub fn source_ref_contains(&self) -> std::option::Option<&str> {
        self.source_ref_contains.as_deref()
    }
}
impl std::fmt::Debug for ListDatasetEntriesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ListDatasetEntriesInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("labeled", &self.labeled);
        formatter.field("anomaly_class", &self.anomaly_class);
        formatter.field("before_creation_date", &self.before_creation_date);
        formatter.field("after_creation_date", &self.after_creation_date);
        formatter.field("next_token", &self.next_token);
        formatter.field("max_results", &self.max_results);
        formatter.field("source_ref_contains", &self.source_ref_contains);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
pub struct DetectAnomaliesInput {
    /// <p>The name of the project that contains the model version that you want to use.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The version of the model that you want to use.</p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>The unencrypted image bytes that you want to analyze. </p>
    pub body: aws_smithy_http::byte_stream::ByteStream,
    /// <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
    pub content_type: std::option::Option<std::string::String>,
}
impl DetectAnomaliesInput {
    /// <p>The name of the project that contains the model version that you want to use.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The version of the model that you want to use.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>The unencrypted image bytes that you want to analyze. </p>
    pub fn body(&self) -> &aws_smithy_http::byte_stream::ByteStream {
        &self.body
    }
    /// <p>The type of the image passed in <code>Body</code>. Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
    pub fn content_type(&self) -> std::option::Option<&str> {
        self.content_type.as_deref()
    }
}
impl std::fmt::Debug for DetectAnomaliesInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DetectAnomaliesInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("model_version", &self.model_version);
        formatter.field("body", &self.body);
        formatter.field("content_type", &self.content_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeProjectInput {
    /// <p>The name of the project that you want to describe.</p>
    pub project_name: std::option::Option<std::string::String>,
}
impl DescribeProjectInput {
    /// <p>The name of the project that you want to describe.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelPackagingJobInput {
    /// <p>The name of the project that contains the model packaging job that you want to describe. </p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The job name for the model packaging job. </p>
    pub job_name: std::option::Option<std::string::String>,
}
impl DescribeModelPackagingJobInput {
    /// <p>The name of the project that contains the model packaging job that you want to describe. </p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The job name for the model packaging job. </p>
    pub fn job_name(&self) -> std::option::Option<&str> {
        self.job_name.as_deref()
    }
}
impl std::fmt::Debug for DescribeModelPackagingJobInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelPackagingJobInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("job_name", &self.job_name);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeModelInput {
    /// <p>The project that contains the version of a model that you want to describe.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The version of the model that you want to describe.</p>
    pub model_version: std::option::Option<std::string::String>,
}
impl DescribeModelInput {
    /// <p>The project that contains the version of a model that you want to describe.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The version of the model that you want to describe.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
}
impl std::fmt::Debug for DescribeModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeModelInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("model_version", &self.model_version);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DescribeDatasetInput {
    /// <p>The name of the project that contains the dataset that you want to describe.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
    pub dataset_type: std::option::Option<std::string::String>,
}
impl DescribeDatasetInput {
    /// <p>The name of the project that contains the dataset that you want to describe.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the training dataset. Specify <code>test</code> to describe the test dataset. If you have a single dataset project, specify <code>train</code> </p>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
}
impl std::fmt::Debug for DescribeDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DescribeDatasetInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteProjectInput {
    /// <p>The name of the project to delete.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteProjectInput {
    /// <p>The name of the project to delete.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteProject</code>. In this case, safely retry your call to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project deletion requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency token is active for 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteModelInput {
    /// <p>The name of the project that contains the model that you want to delete.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The version of the model that you want to delete.</p>
    pub model_version: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteModelInput {
    /// <p>The name of the project that contains the model that you want to delete.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The version of the model that you want to delete.</p>
    pub fn model_version(&self) -> std::option::Option<&str> {
        self.model_version.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code> completes only once. You choose the value to pass. For example, an issue might prevent you from getting a response from <code>DeleteModel</code>. In this case, safely retry your call to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for ClientToken, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple model deletion requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency token is active for 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteModelInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("model_version", &self.model_version);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct DeleteDatasetInput {
    /// <p>The name of the project that contains the dataset that you want to delete.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
    pub dataset_type: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl DeleteDatasetInput {
    /// <p>The name of the project that contains the dataset that you want to delete.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset. Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project, specify <code>train</code>.</p>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>DeleteDataset</code>. In this case, safely retry your call to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple deletetion requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency token is active for 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for DeleteDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("DeleteDatasetInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateProjectInput {
    /// <p>The name for the project.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateProjectInput {
    /// <p>The name for the project.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateProject</code>. In this case, safely retry your call to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple project creation requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency token is active for 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateProjectInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateProjectInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateModelInput {
    /// <p>The name of the project in which you want to create a model version.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>A description for the version of the model.</p>
    pub description: std::option::Option<std::string::String>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
    pub client_token: std::option::Option<std::string::String>,
    /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
    pub output_config: std::option::Option<crate::model::OutputConfig>,
    /// <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
    pub kms_key_id: std::option::Option<std::string::String>,
    /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
    pub tags: std::option::Option<std::vec::Vec<crate::model::Tag>>,
}
impl CreateModelInput {
    /// <p>The name of the project in which you want to create a model version.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>A description for the version of the model.</p>
    pub fn description(&self) -> std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateModel</code>. In this case, safely retry your call to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. </p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from starting multiple training jobs. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency token is active for 8 hours.</p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
    /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
    pub fn output_config(&self) -> std::option::Option<&crate::model::OutputConfig> {
        self.output_config.as_ref()
    }
    /// <p>The identifier for your AWS KMS key. The key is used to encrypt training and test images copied into the service for model training. Your source images are unaffected. If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
    pub fn kms_key_id(&self) -> std::option::Option<&str> {
        self.kms_key_id.as_deref()
    }
    /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
    pub fn tags(&self) -> std::option::Option<&[crate::model::Tag]> {
        self.tags.as_deref()
    }
}
impl std::fmt::Debug for CreateModelInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateModelInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("description", &self.description);
        formatter.field("client_token", &self.client_token);
        formatter.field("output_config", &self.output_config);
        formatter.field("kms_key_id", &self.kms_key_id);
        formatter.field("tags", &self.tags);
        formatter.finish()
    }
}

#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct CreateDatasetInput {
    /// <p>The name of the project in which you want to create a dataset.</p>
    pub project_name: std::option::Option<std::string::String>,
    /// <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
    pub dataset_type: std::option::Option<std::string::String>,
    /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
    /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>
    /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
    pub dataset_source: std::option::Option<crate::model::DatasetSource>,
    /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
    pub client_token: std::option::Option<std::string::String>,
}
impl CreateDatasetInput {
    /// <p>The name of the project in which you want to create a dataset.</p>
    pub fn project_name(&self) -> std::option::Option<&str> {
        self.project_name.as_deref()
    }
    /// <p>The type of the dataset. Specify <code>train</code> for a training dataset. Specify <code>test</code> for a test dataset.</p>
    pub fn dataset_type(&self) -> std::option::Option<&str> {
        self.dataset_type.as_deref()
    }
    /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
    /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation synchronously returns. Later, you can add JSON Lines by calling <code>UpdateDatasetEntries</code>. </p>
    /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous and might take a while to complete. To find out the current status, Check the value of <code>Status</code> returned in a call to <code>DescribeDataset</code>.</p>
    pub fn dataset_source(&self) -> std::option::Option<&crate::model::DatasetSource> {
        self.dataset_source.as_ref()
    }
    /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code> completes only once. You choose the value to pass. For example, An issue might prevent you from getting a response from <code>CreateDataset</code>. In this case, safely retry your call to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value.</p>
    /// <p>If you don't supply a value for <code>ClientToken</code>, the AWS SDK you are using inserts a value for you. This prevents retries after a network error from making multiple dataset creation requests. You'll need to provide your own value for other use cases. </p>
    /// <p>An error occurs if the other input parameters are not the same as in the first request. Using a different value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency token is active for 8 hours. </p>
    pub fn client_token(&self) -> std::option::Option<&str> {
        self.client_token.as_deref()
    }
}
impl std::fmt::Debug for CreateDatasetInput {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("CreateDatasetInput");
        formatter.field("project_name", &self.project_name);
        formatter.field("dataset_type", &self.dataset_type);
        formatter.field("dataset_source", &self.dataset_source);
        formatter.field("client_token", &self.client_token);
        formatter.finish()
    }
}
