// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Error type for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateDatasetError {
    /// Kind of error that occurred.
    pub kind: CreateDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateDatasetErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service quota was exceeded the allowed limit. For more information, see
    /// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateDatasetError {
    fn code(&self) -> Option<&str> {
        CreateDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateDatasetError {
    /// Creates a new `CreateDatasetError`.
    pub fn new(kind: CreateDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateDatasetErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            CreateDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            CreateDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateModelError {
    /// Kind of error that occurred.
    pub kind: CreateModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateModelErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service quota was exceeded the allowed limit. For more information, see
    /// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateModelError {
    fn code(&self) -> Option<&str> {
        CreateModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateModelError {
    /// Creates a new `CreateModelError`.
    pub fn new(kind: CreateModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateModelErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateModelErrorKind::ConflictException(_inner) => Some(_inner),
            CreateModelErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateModelErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateModelErrorKind::ValidationException(_inner) => Some(_inner),
            CreateModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct CreateProjectError {
    /// Kind of error that occurred.
    pub kind: CreateProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `CreateProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum CreateProjectErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service quota was exceeded the allowed limit. For more information, see
    /// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for CreateProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            CreateProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ConflictException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            CreateProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for CreateProjectError {
    fn code(&self) -> Option<&str> {
        CreateProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl CreateProjectError {
    /// Creates a new `CreateProjectError`.
    pub fn new(kind: CreateProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: CreateProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `CreateProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: CreateProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            CreateProjectErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `CreateProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, CreateProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for CreateProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            CreateProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            CreateProjectErrorKind::ConflictException(_inner) => Some(_inner),
            CreateProjectErrorKind::InternalServerException(_inner) => Some(_inner),
            CreateProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            CreateProjectErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            CreateProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            CreateProjectErrorKind::ValidationException(_inner) => Some(_inner),
            CreateProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteDatasetError {
    /// Kind of error that occurred.
    pub kind: DeleteDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteDatasetErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteDatasetError {
    fn code(&self) -> Option<&str> {
        DeleteDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteDatasetError {
    /// Creates a new `DeleteDatasetError`.
    pub fn new(kind: DeleteDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteModelError {
    /// Kind of error that occurred.
    pub kind: DeleteModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteModelErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteModelError {
    fn code(&self) -> Option<&str> {
        DeleteModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteModelError {
    /// Creates a new `DeleteModelError`.
    pub fn new(kind: DeleteModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteModelErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteModelErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteModelErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DeleteProjectError {
    /// Kind of error that occurred.
    pub kind: DeleteProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DeleteProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DeleteProjectErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DeleteProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DeleteProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DeleteProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DeleteProjectError {
    fn code(&self) -> Option<&str> {
        DeleteProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DeleteProjectError {
    /// Creates a new `DeleteProjectError`.
    pub fn new(kind: DeleteProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DeleteProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DeleteProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DeleteProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DeleteProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DeleteProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DeleteProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DeleteProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ConflictException(_inner) => Some(_inner),
            DeleteProjectErrorKind::InternalServerException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DeleteProjectErrorKind::ValidationException(_inner) => Some(_inner),
            DeleteProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeDatasetError {
    /// Kind of error that occurred.
    pub kind: DescribeDatasetErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeDataset` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeDatasetErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeDatasetError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeDatasetErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeDatasetErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeDatasetError {
    fn code(&self) -> Option<&str> {
        DescribeDatasetError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeDatasetError {
    /// Creates a new `DescribeDatasetError`.
    pub fn new(kind: DescribeDatasetErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeDatasetError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeDatasetErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeDatasetErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDatasetErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeDatasetErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DescribeDatasetErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDatasetErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeDatasetErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeDatasetErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeDatasetErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DescribeDatasetErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeDatasetErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeDatasetError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeDatasetErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeDatasetErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeModelError {
    /// Kind of error that occurred.
    pub kind: DescribeModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeModelErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeModelError {
    fn code(&self) -> Option<&str> {
        DescribeModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeModelError {
    /// Creates a new `DescribeModelError`.
    pub fn new(kind: DescribeModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, DescribeModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `DescribeModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DescribeModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DescribeModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DescribeModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeModelErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeModelErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeModelErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DescribeProjectError {
    /// Kind of error that occurred.
    pub kind: DescribeProjectErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DescribeProject` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DescribeProjectErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DescribeProjectError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DescribeProjectErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DescribeProjectErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DescribeProjectError {
    fn code(&self) -> Option<&str> {
        DescribeProjectError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DescribeProjectError {
    /// Creates a new `DescribeProjectError`.
    pub fn new(kind: DescribeProjectErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DescribeProjectError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DescribeProjectErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DescribeProjectErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DescribeProjectErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DescribeProjectErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DescribeProjectError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DescribeProjectErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ConflictException(_inner) => Some(_inner),
            DescribeProjectErrorKind::InternalServerException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ThrottlingException(_inner) => Some(_inner),
            DescribeProjectErrorKind::ValidationException(_inner) => Some(_inner),
            DescribeProjectErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `DetectAnomalies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct DetectAnomaliesError {
    /// Kind of error that occurred.
    pub kind: DetectAnomaliesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `DetectAnomalies` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum DetectAnomaliesErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for DetectAnomaliesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            DetectAnomaliesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            DetectAnomaliesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            DetectAnomaliesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            DetectAnomaliesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            DetectAnomaliesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            DetectAnomaliesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            DetectAnomaliesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for DetectAnomaliesError {
    fn code(&self) -> Option<&str> {
        DetectAnomaliesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl DetectAnomaliesError {
    /// Creates a new `DetectAnomaliesError`.
    pub fn new(kind: DetectAnomaliesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `DetectAnomaliesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: DetectAnomaliesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `DetectAnomaliesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: DetectAnomaliesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `DetectAnomaliesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectAnomaliesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `DetectAnomaliesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, DetectAnomaliesErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `DetectAnomaliesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectAnomaliesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `DetectAnomaliesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            DetectAnomaliesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `DetectAnomaliesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, DetectAnomaliesErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `DetectAnomaliesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, DetectAnomaliesErrorKind::ValidationException(_))
    }
}
impl std::error::Error for DetectAnomaliesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            DetectAnomaliesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            DetectAnomaliesErrorKind::ConflictException(_inner) => Some(_inner),
            DetectAnomaliesErrorKind::InternalServerException(_inner) => Some(_inner),
            DetectAnomaliesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            DetectAnomaliesErrorKind::ThrottlingException(_inner) => Some(_inner),
            DetectAnomaliesErrorKind::ValidationException(_inner) => Some(_inner),
            DetectAnomaliesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListDatasetEntries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListDatasetEntriesError {
    /// Kind of error that occurred.
    pub kind: ListDatasetEntriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListDatasetEntries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListDatasetEntriesErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListDatasetEntriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListDatasetEntriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListDatasetEntriesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListDatasetEntriesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListDatasetEntriesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListDatasetEntriesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListDatasetEntriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListDatasetEntriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListDatasetEntriesError {
    fn code(&self) -> Option<&str> {
        ListDatasetEntriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListDatasetEntriesError {
    /// Creates a new `ListDatasetEntriesError`.
    pub fn new(kind: ListDatasetEntriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListDatasetEntriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListDatasetEntriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListDatasetEntriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListDatasetEntriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListDatasetEntriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetEntriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListDatasetEntriesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetEntriesErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListDatasetEntriesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetEntriesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListDatasetEntriesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetEntriesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListDatasetEntriesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetEntriesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListDatasetEntriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListDatasetEntriesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListDatasetEntriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListDatasetEntriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListDatasetEntriesErrorKind::ConflictException(_inner) => Some(_inner),
            ListDatasetEntriesErrorKind::InternalServerException(_inner) => Some(_inner),
            ListDatasetEntriesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListDatasetEntriesErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListDatasetEntriesErrorKind::ValidationException(_inner) => Some(_inner),
            ListDatasetEntriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListModelsError {
    /// Kind of error that occurred.
    pub kind: ListModelsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListModels` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListModelsErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListModelsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListModelsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListModelsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListModelsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListModelsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListModelsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListModelsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListModelsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListModelsError {
    fn code(&self) -> Option<&str> {
        ListModelsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListModelsError {
    /// Creates a new `ListModelsError`.
    pub fn new(kind: ListModelsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListModelsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListModelsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListModelsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListModelsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListModelsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListModelsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListModelsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListModelsErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ListModelsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, ListModelsErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `ListModelsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListModelsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListModelsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListModelsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListModelsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListModelsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListModelsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListModelsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListModelsErrorKind::ConflictException(_inner) => Some(_inner),
            ListModelsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListModelsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListModelsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListModelsErrorKind::ValidationException(_inner) => Some(_inner),
            ListModelsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListProjectsError {
    /// Kind of error that occurred.
    pub kind: ListProjectsErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListProjects` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListProjectsErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListProjectsError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListProjectsErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListProjectsErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListProjectsError {
    fn code(&self) -> Option<&str> {
        ListProjectsError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListProjectsError {
    /// Creates a new `ListProjectsError`.
    pub fn new(kind: ListProjectsErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListProjectsErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListProjectsError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListProjectsErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListProjectsErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `ListProjectsErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, ListProjectsErrorKind::ValidationException(_))
    }
}
impl std::error::Error for ListProjectsError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListProjectsErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListProjectsErrorKind::ConflictException(_inner) => Some(_inner),
            ListProjectsErrorKind::InternalServerException(_inner) => Some(_inner),
            ListProjectsErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListProjectsErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListProjectsErrorKind::ValidationException(_inner) => Some(_inner),
            ListProjectsErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct ListTagsForResourceError {
    /// Kind of error that occurred.
    pub kind: ListTagsForResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `ListTagsForResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum ListTagsForResourceErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for ListTagsForResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            ListTagsForResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for ListTagsForResourceError {
    fn code(&self) -> Option<&str> {
        ListTagsForResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl ListTagsForResourceError {
    /// Creates a new `ListTagsForResourceError`.
    pub fn new(kind: ListTagsForResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `ListTagsForResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: ListTagsForResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `ListTagsForResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            ListTagsForResourceErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for ListTagsForResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            ListTagsForResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ConflictException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::ValidationException(_inner) => Some(_inner),
            ListTagsForResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StartModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StartModelError {
    /// Kind of error that occurred.
    pub kind: StartModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StartModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StartModelErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service quota was exceeded the allowed limit. For more information, see
    /// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StartModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StartModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StartModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StartModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StartModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StartModelErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            StartModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StartModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StartModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StartModelError {
    fn code(&self) -> Option<&str> {
        StartModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StartModelError {
    /// Creates a new `StartModelError`.
    pub fn new(kind: StartModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StartModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StartModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StartModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StartModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StartModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StartModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `StartModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StartModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `StartModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, StartModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `StartModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartModelErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `StartModelErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            StartModelErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `StartModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StartModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `StartModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StartModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StartModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StartModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StartModelErrorKind::ConflictException(_inner) => Some(_inner),
            StartModelErrorKind::InternalServerException(_inner) => Some(_inner),
            StartModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StartModelErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            StartModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            StartModelErrorKind::ValidationException(_inner) => Some(_inner),
            StartModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `StopModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct StopModelError {
    /// Kind of error that occurred.
    pub kind: StopModelErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `StopModel` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum StopModelErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for StopModelError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            StopModelErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            StopModelErrorKind::ConflictException(_inner) => _inner.fmt(f),
            StopModelErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            StopModelErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            StopModelErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            StopModelErrorKind::ValidationException(_inner) => _inner.fmt(f),
            StopModelErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for StopModelError {
    fn code(&self) -> Option<&str> {
        StopModelError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl StopModelError {
    /// Creates a new `StopModelError`.
    pub fn new(kind: StopModelErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `StopModelError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: StopModelErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `StopModelError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: StopModelErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `StopModelErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, StopModelErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `StopModelErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, StopModelErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `StopModelErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, StopModelErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `StopModelErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(&self.kind, StopModelErrorKind::ResourceNotFoundException(_))
    }
    /// Returns true if the error kind is `StopModelErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, StopModelErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `StopModelErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, StopModelErrorKind::ValidationException(_))
    }
}
impl std::error::Error for StopModelError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            StopModelErrorKind::AccessDeniedException(_inner) => Some(_inner),
            StopModelErrorKind::ConflictException(_inner) => Some(_inner),
            StopModelErrorKind::InternalServerException(_inner) => Some(_inner),
            StopModelErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            StopModelErrorKind::ThrottlingException(_inner) => Some(_inner),
            StopModelErrorKind::ValidationException(_inner) => Some(_inner),
            StopModelErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct TagResourceError {
    /// Kind of error that occurred.
    pub kind: TagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `TagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum TagResourceErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>A service quota was exceeded the allowed limit. For more information, see
    /// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>
    ServiceQuotaExceededException(crate::error::ServiceQuotaExceededException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for TagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            TagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for TagResourceError {
    fn code(&self) -> Option<&str> {
        TagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl TagResourceError {
    /// Creates a new `TagResourceError`.
    pub fn new(kind: TagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `TagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: TagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `TagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: TagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `TagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::InternalServerException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ServiceQuotaExceededException`.
    pub fn is_service_quota_exceeded_exception(&self) -> bool {
        matches!(
            &self.kind,
            TagResourceErrorKind::ServiceQuotaExceededException(_)
        )
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `TagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, TagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for TagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            TagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            TagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            TagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            TagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            TagResourceErrorKind::ServiceQuotaExceededException(_inner) => Some(_inner),
            TagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            TagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            TagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UntagResourceError {
    /// Kind of error that occurred.
    pub kind: UntagResourceErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UntagResource` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UntagResourceErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UntagResourceError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UntagResourceErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UntagResourceError {
    fn code(&self) -> Option<&str> {
        UntagResourceError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UntagResourceError {
    /// Creates a new `UntagResourceError`.
    pub fn new(kind: UntagResourceErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UntagResourceErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UntagResourceError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UntagResourceErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::AccessDeniedException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ConflictException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UntagResourceErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ThrottlingException(_))
    }
    /// Returns true if the error kind is `UntagResourceErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(&self.kind, UntagResourceErrorKind::ValidationException(_))
    }
}
impl std::error::Error for UntagResourceError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UntagResourceErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UntagResourceErrorKind::ConflictException(_inner) => Some(_inner),
            UntagResourceErrorKind::InternalServerException(_inner) => Some(_inner),
            UntagResourceErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UntagResourceErrorKind::ThrottlingException(_inner) => Some(_inner),
            UntagResourceErrorKind::ValidationException(_inner) => Some(_inner),
            UntagResourceErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// Error type for the `UpdateDatasetEntries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub struct UpdateDatasetEntriesError {
    /// Kind of error that occurred.
    pub kind: UpdateDatasetEntriesErrorKind,
    /// Additional metadata about the error, including error code, message, and request ID.
    pub(crate) meta: aws_smithy_types::Error,
}
/// Types of errors that can occur for the `UpdateDatasetEntries` operation.
#[non_exhaustive]
#[derive(std::fmt::Debug)]
pub enum UpdateDatasetEntriesErrorKind {
    /// <p>You are not authorized to perform the action.</p>
    AccessDeniedException(crate::error::AccessDeniedException),
    /// <p>The update or deletion of a resource caused an inconsistent state.</p>
    ConflictException(crate::error::ConflictException),
    /// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
    InternalServerException(crate::error::InternalServerException),
    /// <p>The resource could not be found.</p>
    ResourceNotFoundException(crate::error::ResourceNotFoundException),
    /// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
    ThrottlingException(crate::error::ThrottlingException),
    /// <p>An input validation error occured. For example, invalid characters in a project name,
    /// or if a pagination token is invalid.</p>
    ValidationException(crate::error::ValidationException),
    /// An unexpected error, eg. invalid JSON returned by the service or an unknown error code
    Unhandled(Box<dyn std::error::Error + Send + Sync + 'static>),
}
impl std::fmt::Display for UpdateDatasetEntriesError {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match &self.kind {
            UpdateDatasetEntriesErrorKind::AccessDeniedException(_inner) => _inner.fmt(f),
            UpdateDatasetEntriesErrorKind::ConflictException(_inner) => _inner.fmt(f),
            UpdateDatasetEntriesErrorKind::InternalServerException(_inner) => _inner.fmt(f),
            UpdateDatasetEntriesErrorKind::ResourceNotFoundException(_inner) => _inner.fmt(f),
            UpdateDatasetEntriesErrorKind::ThrottlingException(_inner) => _inner.fmt(f),
            UpdateDatasetEntriesErrorKind::ValidationException(_inner) => _inner.fmt(f),
            UpdateDatasetEntriesErrorKind::Unhandled(_inner) => _inner.fmt(f),
        }
    }
}
impl aws_smithy_types::retry::ProvideErrorKind for UpdateDatasetEntriesError {
    fn code(&self) -> Option<&str> {
        UpdateDatasetEntriesError::code(self)
    }
    fn retryable_error_kind(&self) -> Option<aws_smithy_types::retry::ErrorKind> {
        None
    }
}
impl UpdateDatasetEntriesError {
    /// Creates a new `UpdateDatasetEntriesError`.
    pub fn new(kind: UpdateDatasetEntriesErrorKind, meta: aws_smithy_types::Error) -> Self {
        Self { kind, meta }
    }

    /// Creates the `UpdateDatasetEntriesError::Unhandled` variant from any error type.
    pub fn unhandled(err: impl Into<Box<dyn std::error::Error + Send + Sync + 'static>>) -> Self {
        Self {
            kind: UpdateDatasetEntriesErrorKind::Unhandled(err.into()),
            meta: Default::default(),
        }
    }

    /// Creates the `UpdateDatasetEntriesError::Unhandled` variant from a `aws_smithy_types::Error`.
    pub fn generic(err: aws_smithy_types::Error) -> Self {
        Self {
            meta: err.clone(),
            kind: UpdateDatasetEntriesErrorKind::Unhandled(err.into()),
        }
    }

    // TODO: Consider if this should actually be `Option<Cow<&str>>`. This would enable us to use display
    // as implemented by std::Error to generate a message in that case.
    /// Returns the error message if one is available.
    pub fn message(&self) -> Option<&str> {
        self.meta.message()
    }

    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    pub fn meta(&self) -> &aws_smithy_types::Error {
        &self.meta
    }

    /// Returns the request ID if it's available.
    pub fn request_id(&self) -> Option<&str> {
        self.meta.request_id()
    }

    /// Returns the error code if it's available.
    pub fn code(&self) -> Option<&str> {
        self.meta.code()
    }
    /// Returns true if the error kind is `UpdateDatasetEntriesErrorKind::AccessDeniedException`.
    pub fn is_access_denied_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetEntriesErrorKind::AccessDeniedException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDatasetEntriesErrorKind::ConflictException`.
    pub fn is_conflict_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetEntriesErrorKind::ConflictException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDatasetEntriesErrorKind::InternalServerException`.
    pub fn is_internal_server_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetEntriesErrorKind::InternalServerException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDatasetEntriesErrorKind::ResourceNotFoundException`.
    pub fn is_resource_not_found_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetEntriesErrorKind::ResourceNotFoundException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDatasetEntriesErrorKind::ThrottlingException`.
    pub fn is_throttling_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetEntriesErrorKind::ThrottlingException(_)
        )
    }
    /// Returns true if the error kind is `UpdateDatasetEntriesErrorKind::ValidationException`.
    pub fn is_validation_exception(&self) -> bool {
        matches!(
            &self.kind,
            UpdateDatasetEntriesErrorKind::ValidationException(_)
        )
    }
}
impl std::error::Error for UpdateDatasetEntriesError {
    fn source(&self) -> Option<&(dyn std::error::Error + 'static)> {
        match &self.kind {
            UpdateDatasetEntriesErrorKind::AccessDeniedException(_inner) => Some(_inner),
            UpdateDatasetEntriesErrorKind::ConflictException(_inner) => Some(_inner),
            UpdateDatasetEntriesErrorKind::InternalServerException(_inner) => Some(_inner),
            UpdateDatasetEntriesErrorKind::ResourceNotFoundException(_inner) => Some(_inner),
            UpdateDatasetEntriesErrorKind::ThrottlingException(_inner) => Some(_inner),
            UpdateDatasetEntriesErrorKind::ValidationException(_inner) => Some(_inner),
            UpdateDatasetEntriesErrorKind::Unhandled(_inner) => Some(_inner.as_ref()),
        }
    }
}

/// <p>An input validation error occured. For example, invalid characters in a project name,
/// or if a pagination token is invalid.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ValidationException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ValidationException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl ValidationException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ValidationException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ValidationException")?;
        if let Some(inner_1) = &self.message {
            write!(f, ": {}", inner_1)?;
        }
        Ok(())
    }
}
impl std::error::Error for ValidationException {}
/// See [`ValidationException`](crate::error::ValidationException)
pub mod validation_exception {
    /// A builder for [`ValidationException`](crate::error::ValidationException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`ValidationException`](crate::error::ValidationException)
        pub fn build(self) -> crate::error::ValidationException {
            crate::error::ValidationException {
                message: self.message,
            }
        }
    }
}
impl ValidationException {
    /// Creates a new builder-style object to manufacture [`ValidationException`](crate::error::ValidationException)
    pub fn builder() -> crate::error::validation_exception::Builder {
        crate::error::validation_exception::Builder::default()
    }
}

/// <p>Amazon Lookout for Vision is temporarily unable to process the request. Try your call again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ThrottlingException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The quota code. </p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The service code. </p>
    pub service_code: std::option::Option<std::string::String>,
    /// <p>The period of time, in seconds, before the operation can be retried. </p>
    pub retry_after_seconds: i32,
}
impl std::fmt::Debug for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ThrottlingException");
        formatter.field("message", &self.message);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl ThrottlingException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ThrottlingException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ThrottlingException")?;
        if let Some(inner_2) = &self.message {
            write!(f, ": {}", inner_2)?;
        }
        Ok(())
    }
}
impl std::error::Error for ThrottlingException {}
/// See [`ThrottlingException`](crate::error::ThrottlingException)
pub mod throttling_exception {
    /// A builder for [`ThrottlingException`](crate::error::ThrottlingException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The quota code. </p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota code. </p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The service code. </p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service code. </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// <p>The period of time, in seconds, before the operation can be retried. </p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The period of time, in seconds, before the operation can be retried. </p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`ThrottlingException`](crate::error::ThrottlingException)
        pub fn build(self) -> crate::error::ThrottlingException {
            crate::error::ThrottlingException {
                message: self.message,
                quota_code: self.quota_code,
                service_code: self.service_code,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl ThrottlingException {
    /// Creates a new builder-style object to manufacture [`ThrottlingException`](crate::error::ThrottlingException)
    pub fn builder() -> crate::error::throttling_exception::Builder {
        crate::error::throttling_exception::Builder::default()
    }
}

/// <p>The resource could not be found.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ResourceNotFoundException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl std::fmt::Debug for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ResourceNotFoundException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ResourceNotFoundException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ResourceNotFoundException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ResourceNotFoundException")?;
        if let Some(inner_3) = &self.message {
            write!(f, ": {}", inner_3)?;
        }
        Ok(())
    }
}
impl std::error::Error for ResourceNotFoundException {}
/// See [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
pub mod resource_not_found_exception {
    /// A builder for [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
        pub fn build(self) -> crate::error::ResourceNotFoundException {
            crate::error::ResourceNotFoundException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ResourceNotFoundException {
    /// Creates a new builder-style object to manufacture [`ResourceNotFoundException`](crate::error::ResourceNotFoundException)
    pub fn builder() -> crate::error::resource_not_found_exception::Builder {
        crate::error::resource_not_found_exception::Builder::default()
    }
}

/// <p>Amazon Lookout for Vision experienced a service issue. Try your call again.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct InternalServerException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The period of time, in seconds, before the operation can be retried.</p>
    pub retry_after_seconds: i32,
}
impl std::fmt::Debug for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("InternalServerException");
        formatter.field("message", &self.message);
        formatter.field("retry_after_seconds", &self.retry_after_seconds);
        formatter.finish()
    }
}
impl InternalServerException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for InternalServerException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "InternalServerException")?;
        if let Some(inner_4) = &self.message {
            write!(f, ": {}", inner_4)?;
        }
        Ok(())
    }
}
impl std::error::Error for InternalServerException {}
/// See [`InternalServerException`](crate::error::InternalServerException)
pub mod internal_server_exception {
    /// A builder for [`InternalServerException`](crate::error::InternalServerException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) retry_after_seconds: std::option::Option<i32>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The period of time, in seconds, before the operation can be retried.</p>
        pub fn retry_after_seconds(mut self, input: i32) -> Self {
            self.retry_after_seconds = Some(input);
            self
        }
        /// <p>The period of time, in seconds, before the operation can be retried.</p>
        pub fn set_retry_after_seconds(mut self, input: std::option::Option<i32>) -> Self {
            self.retry_after_seconds = input;
            self
        }
        /// Consumes the builder and constructs a [`InternalServerException`](crate::error::InternalServerException)
        pub fn build(self) -> crate::error::InternalServerException {
            crate::error::InternalServerException {
                message: self.message,
                retry_after_seconds: self.retry_after_seconds.unwrap_or_default(),
            }
        }
    }
}
impl InternalServerException {
    /// Creates a new builder-style object to manufacture [`InternalServerException`](crate::error::InternalServerException)
    pub fn builder() -> crate::error::internal_server_exception::Builder {
        crate::error::internal_server_exception::Builder::default()
    }
}

/// <p>The update or deletion of a resource caused an inconsistent state.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ConflictException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
}
impl std::fmt::Debug for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ConflictException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.finish()
    }
}
impl ConflictException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ConflictException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ConflictException")?;
        if let Some(inner_5) = &self.message {
            write!(f, ": {}", inner_5)?;
        }
        Ok(())
    }
}
impl std::error::Error for ConflictException {}
/// See [`ConflictException`](crate::error::ConflictException)
pub mod conflict_exception {
    /// A builder for [`ConflictException`](crate::error::ConflictException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// Consumes the builder and constructs a [`ConflictException`](crate::error::ConflictException)
        pub fn build(self) -> crate::error::ConflictException {
            crate::error::ConflictException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
            }
        }
    }
}
impl ConflictException {
    /// Creates a new builder-style object to manufacture [`ConflictException`](crate::error::ConflictException)
    pub fn builder() -> crate::error::conflict_exception::Builder {
        crate::error::conflict_exception::Builder::default()
    }
}

/// <p>You are not authorized to perform the action.</p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct AccessDeniedException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("AccessDeniedException");
        formatter.field("message", &self.message);
        formatter.finish()
    }
}
impl AccessDeniedException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for AccessDeniedException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "AccessDeniedException")?;
        if let Some(inner_6) = &self.message {
            write!(f, ": {}", inner_6)?;
        }
        Ok(())
    }
}
impl std::error::Error for AccessDeniedException {}
/// See [`AccessDeniedException`](crate::error::AccessDeniedException)
pub mod access_denied_exception {
    /// A builder for [`AccessDeniedException`](crate::error::AccessDeniedException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// Consumes the builder and constructs a [`AccessDeniedException`](crate::error::AccessDeniedException)
        pub fn build(self) -> crate::error::AccessDeniedException {
            crate::error::AccessDeniedException {
                message: self.message,
            }
        }
    }
}
impl AccessDeniedException {
    /// Creates a new builder-style object to manufacture [`AccessDeniedException`](crate::error::AccessDeniedException)
    pub fn builder() -> crate::error::access_denied_exception::Builder {
        crate::error::access_denied_exception::Builder::default()
    }
}

/// <p>A service quota was exceeded the allowed limit. For more information, see
/// Limits in Amazon Lookout for Vision in the Amazon Lookout for Vision Developer Guide. </p>
#[non_exhaustive]
#[derive(std::clone::Clone, std::cmp::PartialEq)]
pub struct ServiceQuotaExceededException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: std::option::Option<std::string::String>,
    /// <p>The ID of the resource.</p>
    pub resource_id: std::option::Option<std::string::String>,
    /// <p>The type of the resource.</p>
    pub resource_type: std::option::Option<crate::model::ResourceType>,
    /// <p>The quota code. </p>
    pub quota_code: std::option::Option<std::string::String>,
    /// <p>The service code. </p>
    pub service_code: std::option::Option<std::string::String>,
}
impl std::fmt::Debug for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        let mut formatter = f.debug_struct("ServiceQuotaExceededException");
        formatter.field("message", &self.message);
        formatter.field("resource_id", &self.resource_id);
        formatter.field("resource_type", &self.resource_type);
        formatter.field("quota_code", &self.quota_code);
        formatter.field("service_code", &self.service_code);
        formatter.finish()
    }
}
impl ServiceQuotaExceededException {
    /// Returns the error message.
    pub fn message(&self) -> Option<&str> {
        self.message.as_deref()
    }
}
impl std::fmt::Display for ServiceQuotaExceededException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        write!(f, "ServiceQuotaExceededException")?;
        if let Some(inner_7) = &self.message {
            write!(f, ": {}", inner_7)?;
        }
        Ok(())
    }
}
impl std::error::Error for ServiceQuotaExceededException {}
/// See [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
pub mod service_quota_exceeded_exception {
    /// A builder for [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    #[non_exhaustive]
    #[derive(std::default::Default, std::clone::Clone, std::cmp::PartialEq, std::fmt::Debug)]
    pub struct Builder {
        pub(crate) message: std::option::Option<std::string::String>,
        pub(crate) resource_id: std::option::Option<std::string::String>,
        pub(crate) resource_type: std::option::Option<crate::model::ResourceType>,
        pub(crate) quota_code: std::option::Option<std::string::String>,
        pub(crate) service_code: std::option::Option<std::string::String>,
    }
    impl Builder {
        #[allow(missing_docs)] // documentation missing in model
        pub fn message(mut self, input: impl Into<std::string::String>) -> Self {
            self.message = Some(input.into());
            self
        }
        #[allow(missing_docs)] // documentation missing in model
        pub fn set_message(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.message = input;
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn resource_id(mut self, input: impl Into<std::string::String>) -> Self {
            self.resource_id = Some(input.into());
            self
        }
        /// <p>The ID of the resource.</p>
        pub fn set_resource_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.resource_id = input;
            self
        }
        /// <p>The type of the resource.</p>
        pub fn resource_type(mut self, input: crate::model::ResourceType) -> Self {
            self.resource_type = Some(input);
            self
        }
        /// <p>The type of the resource.</p>
        pub fn set_resource_type(
            mut self,
            input: std::option::Option<crate::model::ResourceType>,
        ) -> Self {
            self.resource_type = input;
            self
        }
        /// <p>The quota code. </p>
        pub fn quota_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.quota_code = Some(input.into());
            self
        }
        /// <p>The quota code. </p>
        pub fn set_quota_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.quota_code = input;
            self
        }
        /// <p>The service code. </p>
        pub fn service_code(mut self, input: impl Into<std::string::String>) -> Self {
            self.service_code = Some(input.into());
            self
        }
        /// <p>The service code. </p>
        pub fn set_service_code(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.service_code = input;
            self
        }
        /// Consumes the builder and constructs a [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
        pub fn build(self) -> crate::error::ServiceQuotaExceededException {
            crate::error::ServiceQuotaExceededException {
                message: self.message,
                resource_id: self.resource_id,
                resource_type: self.resource_type,
                quota_code: self.quota_code,
                service_code: self.service_code,
            }
        }
    }
}
impl ServiceQuotaExceededException {
    /// Creates a new builder-style object to manufacture [`ServiceQuotaExceededException`](crate::error::ServiceQuotaExceededException)
    pub fn builder() -> crate::error::service_quota_exceeded_exception::Builder {
        crate::error::service_quota_exceeded_exception::Builder::default()
    }
}
