// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[derive(Debug)]
pub(crate) struct Handle<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    client: aws_smithy_client::Client<C, M, R>,
    conf: crate::Config,
}

/// An ergonomic service client for `LookoutVisionService`.
///
/// This client allows ergonomic access to a `LookoutVisionService`-shaped service.
/// Each method corresponds to an endpoint defined in the service's Smithy model,
/// and the request and response shapes are auto-generated from that same model.
///
/// # Using a Client
///
/// Once you have a client set up, you can access the service's endpoints
/// by calling the appropriate method on [`Client`]. Each such method
/// returns a request builder for that endpoint, with methods for setting
/// the various fields of the request. Once your request is complete, use
/// the `send` method to send the request. `send` returns a future, which
/// you then have to `.await` to get the service's response.
///
/// [builder pattern]: https://rust-lang.github.io/api-guidelines/type-safety.html#c-builder
/// [SigV4-signed requests]: https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
#[derive(std::fmt::Debug)]
pub struct Client<
    C = aws_smithy_client::erase::DynConnector,
    M = aws_hyper::AwsMiddleware,
    R = aws_smithy_client::retry::Standard,
> {
    handle: std::sync::Arc<Handle<C, M, R>>,
}

impl<C, M, R> std::clone::Clone for Client<C, M, R> {
    fn clone(&self) -> Self {
        Self {
            handle: self.handle.clone(),
        }
    }
}

#[doc(inline)]
pub use aws_smithy_client::Builder;

impl<C, M, R> From<aws_smithy_client::Client<C, M, R>> for Client<C, M, R> {
    fn from(client: aws_smithy_client::Client<C, M, R>) -> Self {
        Self::with_config(client, crate::Config::builder().build())
    }
}

impl<C, M, R> Client<C, M, R> {
    /// Creates a client with the given service configuration.
    pub fn with_config(client: aws_smithy_client::Client<C, M, R>, conf: crate::Config) -> Self {
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }

    /// Returns the client's configuration.
    pub fn conf(&self) -> &crate::Config {
        &self.handle.conf
    }
}
impl<C, M, R> Client<C, M, R>
where
    C: aws_smithy_client::bounds::SmithyConnector,
    M: aws_smithy_client::bounds::SmithyMiddleware<C>,
    R: aws_smithy_client::retry::NewRequestPolicy,
{
    /// Constructs a fluent builder for the `CreateDataset` operation.
    ///
    /// See [`CreateDataset`](crate::client::fluent_builders::CreateDataset) for more information about the
    /// operation and its arguments.
    pub fn create_dataset(&self) -> fluent_builders::CreateDataset<C, M, R> {
        fluent_builders::CreateDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateModel` operation.
    ///
    /// See [`CreateModel`](crate::client::fluent_builders::CreateModel) for more information about the
    /// operation and its arguments.
    pub fn create_model(&self) -> fluent_builders::CreateModel<C, M, R> {
        fluent_builders::CreateModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `CreateProject` operation.
    ///
    /// See [`CreateProject`](crate::client::fluent_builders::CreateProject) for more information about the
    /// operation and its arguments.
    pub fn create_project(&self) -> fluent_builders::CreateProject<C, M, R> {
        fluent_builders::CreateProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteDataset` operation.
    ///
    /// See [`DeleteDataset`](crate::client::fluent_builders::DeleteDataset) for more information about the
    /// operation and its arguments.
    pub fn delete_dataset(&self) -> fluent_builders::DeleteDataset<C, M, R> {
        fluent_builders::DeleteDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteModel` operation.
    ///
    /// See [`DeleteModel`](crate::client::fluent_builders::DeleteModel) for more information about the
    /// operation and its arguments.
    pub fn delete_model(&self) -> fluent_builders::DeleteModel<C, M, R> {
        fluent_builders::DeleteModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DeleteProject` operation.
    ///
    /// See [`DeleteProject`](crate::client::fluent_builders::DeleteProject) for more information about the
    /// operation and its arguments.
    pub fn delete_project(&self) -> fluent_builders::DeleteProject<C, M, R> {
        fluent_builders::DeleteProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeDataset` operation.
    ///
    /// See [`DescribeDataset`](crate::client::fluent_builders::DescribeDataset) for more information about the
    /// operation and its arguments.
    pub fn describe_dataset(&self) -> fluent_builders::DescribeDataset<C, M, R> {
        fluent_builders::DescribeDataset::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeModel` operation.
    ///
    /// See [`DescribeModel`](crate::client::fluent_builders::DescribeModel) for more information about the
    /// operation and its arguments.
    pub fn describe_model(&self) -> fluent_builders::DescribeModel<C, M, R> {
        fluent_builders::DescribeModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DescribeProject` operation.
    ///
    /// See [`DescribeProject`](crate::client::fluent_builders::DescribeProject) for more information about the
    /// operation and its arguments.
    pub fn describe_project(&self) -> fluent_builders::DescribeProject<C, M, R> {
        fluent_builders::DescribeProject::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `DetectAnomalies` operation.
    ///
    /// See [`DetectAnomalies`](crate::client::fluent_builders::DetectAnomalies) for more information about the
    /// operation and its arguments.
    pub fn detect_anomalies(&self) -> fluent_builders::DetectAnomalies<C, M, R> {
        fluent_builders::DetectAnomalies::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListDatasetEntries` operation.
    ///
    /// See [`ListDatasetEntries`](crate::client::fluent_builders::ListDatasetEntries) for more information about the
    /// operation and its arguments.
    pub fn list_dataset_entries(&self) -> fluent_builders::ListDatasetEntries<C, M, R> {
        fluent_builders::ListDatasetEntries::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListModels` operation.
    ///
    /// See [`ListModels`](crate::client::fluent_builders::ListModels) for more information about the
    /// operation and its arguments.
    pub fn list_models(&self) -> fluent_builders::ListModels<C, M, R> {
        fluent_builders::ListModels::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListProjects` operation.
    ///
    /// See [`ListProjects`](crate::client::fluent_builders::ListProjects) for more information about the
    /// operation and its arguments.
    pub fn list_projects(&self) -> fluent_builders::ListProjects<C, M, R> {
        fluent_builders::ListProjects::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `ListTagsForResource` operation.
    ///
    /// See [`ListTagsForResource`](crate::client::fluent_builders::ListTagsForResource) for more information about the
    /// operation and its arguments.
    pub fn list_tags_for_resource(&self) -> fluent_builders::ListTagsForResource<C, M, R> {
        fluent_builders::ListTagsForResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StartModel` operation.
    ///
    /// See [`StartModel`](crate::client::fluent_builders::StartModel) for more information about the
    /// operation and its arguments.
    pub fn start_model(&self) -> fluent_builders::StartModel<C, M, R> {
        fluent_builders::StartModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `StopModel` operation.
    ///
    /// See [`StopModel`](crate::client::fluent_builders::StopModel) for more information about the
    /// operation and its arguments.
    pub fn stop_model(&self) -> fluent_builders::StopModel<C, M, R> {
        fluent_builders::StopModel::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `TagResource` operation.
    ///
    /// See [`TagResource`](crate::client::fluent_builders::TagResource) for more information about the
    /// operation and its arguments.
    pub fn tag_resource(&self) -> fluent_builders::TagResource<C, M, R> {
        fluent_builders::TagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UntagResource` operation.
    ///
    /// See [`UntagResource`](crate::client::fluent_builders::UntagResource) for more information about the
    /// operation and its arguments.
    pub fn untag_resource(&self) -> fluent_builders::UntagResource<C, M, R> {
        fluent_builders::UntagResource::new(self.handle.clone())
    }
    /// Constructs a fluent builder for the `UpdateDatasetEntries` operation.
    ///
    /// See [`UpdateDatasetEntries`](crate::client::fluent_builders::UpdateDatasetEntries) for more information about the
    /// operation and its arguments.
    pub fn update_dataset_entries(&self) -> fluent_builders::UpdateDatasetEntries<C, M, R> {
        fluent_builders::UpdateDatasetEntries::new(self.handle.clone())
    }
}
pub mod fluent_builders {
    //!
    //! Utilities to ergonomically construct a request to the service.
    //!
    //! Fluent builders are created through the [`Client`](crate::client::Client) by calling
    //! one if its operation methods. After parameters are set using the builder methods,
    //! the `send` method can be called to initiate the request.
    //!
    /// Fluent builder constructing a request to `CreateDataset`.
    ///
    /// <p>Creates a new dataset  in an Amazon Lookout for Vision project. <code>CreateDataset</code> can create a
    /// training or a test dataset from a valid dataset source (<code>DatasetSource</code>).</p>
    /// <p>If you want a single dataset project, specify <code>train</code> for the value of
    /// <code>DatasetType</code>.</p>
    /// <p>To have a project with separate training and test datasets, call <code>CreateDataset</code> twice.
    /// On the first call, specify <code>train</code> for the value of
    /// <code>DatasetType</code>. On the second call, specify <code>test</code> for the value of
    /// <code>DatasetType</code>. </p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:CreateDataset</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_dataset_input::Builder,
    }
    impl<C, M, R> CreateDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateDatasetInputOperationOutputAlias,
                crate::output::CreateDatasetOutput,
                crate::error::CreateDatasetError,
                crate::input::CreateDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project in which you want to create a dataset.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project in which you want to create a dataset.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset. Specify <code>train</code> for a training dataset.
        /// Specify <code>test</code> for a test dataset.</p>
        pub fn dataset_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The type of the dataset. Specify <code>train</code> for a training dataset.
        /// Specify <code>test</code> for a test dataset.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
        /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation
        /// synchronously returns. Later, you can add JSON Lines by calling <a>UpdateDatasetEntries</a>.
        /// </p>
        /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location
        /// is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous
        /// and might take a while to complete. To find out the current status, Check the value of <code>Status</code>
        /// returned in a call to <a>DescribeDataset</a>.</p>
        pub fn dataset_source(mut self, inp: crate::model::DatasetSource) -> Self {
            self.inner = self.inner.dataset_source(inp);
            self
        }
        /// <p>The location of the manifest file that Amazon Lookout for Vision uses to create the dataset.</p>
        /// <p>If you don't specify <code>DatasetSource</code>, an empty dataset is created and the operation
        /// synchronously returns. Later, you can add JSON Lines by calling <a>UpdateDatasetEntries</a>.
        /// </p>
        /// <p>If you specify a value for <code>DataSource</code>, the manifest at the S3 location
        /// is validated and used to create the dataset. The call to <code>CreateDataset</code> is asynchronous
        /// and might take a while to complete. To find out the current status, Check the value of <code>Status</code>
        /// returned in a call to <a>DescribeDataset</a>.</p>
        pub fn set_dataset_source(
            mut self,
            input: std::option::Option<crate::model::DatasetSource>,
        ) -> Self {
            self.inner = self.inner.set_dataset_source(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>CreateDataset</code>.
        /// In this case, safely retry your call
        /// to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency
        /// token is active for 8 hours.
        /// </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateDataset</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>CreateDataset</code>.
        /// In this case, safely retry your call
        /// to <code>CreateDataset</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>CreateDataset</code>. An idempotency
        /// token is active for 8 hours.
        /// </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateModel`.
    ///
    /// <p>Creates a new version of a model within an an Amazon Lookout for Vision project.
    /// <code>CreateModel</code> is an asynchronous operation in which Amazon Lookout for Vision trains, tests,
    /// and evaluates a new version of a model. </p>
    /// <p>To get the current status, check the <code>Status</code> field returned
    /// in the response from <a>DescribeModel</a>.</p>
    /// <p>If the project has a single dataset, Amazon Lookout for Vision internally splits the dataset
    /// to create a training and a test dataset.  
    /// If the project has a training and a test dataset, Lookout for Vision uses the respective datasets to train and test
    /// the model. </p>
    /// <p>After training completes, the evaluation metrics are stored at the location specified in
    /// <code>OutputConfig</code>.  </p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:CreateModel</code> operation. If you want to tag your model, you also require
    /// permission to the <code>lookoutvision:TagResource</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_model_input::Builder,
    }
    impl<C, M, R> CreateModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateModelOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateModelInputOperationOutputAlias,
                crate::output::CreateModelOutput,
                crate::error::CreateModelError,
                crate::input::CreateModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project in which you want to create a model version.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project in which you want to create a model version.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>A description for the version of the model.</p>
        pub fn description(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.description(inp);
            self
        }
        /// <p>A description for the version of the model.</p>
        pub fn set_description(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_description(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>CreateModel</code>.
        /// In this case, safely retry your call
        /// to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>CreateModel</code>.
        /// In this case, safely retry your call
        /// to <code>CreateModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>CreateModel</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
        /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
        pub fn output_config(mut self, inp: crate::model::OutputConfig) -> Self {
            self.inner = self.inner.output_config(inp);
            self
        }
        /// <p>The location where Amazon Lookout for Vision saves the training results.</p>
        pub fn set_output_config(
            mut self,
            input: std::option::Option<crate::model::OutputConfig>,
        ) -> Self {
            self.inner = self.inner.set_output_config(input);
            self
        }
        /// <p>The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK).
        /// The key is used to encrypt training and test images copied into the service for model training. Your
        /// source images are unaffected.
        /// If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
        pub fn kms_key_id(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.kms_key_id(inp);
            self
        }
        /// <p>The identifier for your AWS Key Management Service (AWS KMS) customer master key (CMK).
        /// The key is used to encrypt training and test images copied into the service for model training. Your
        /// source images are unaffected.
        /// If this parameter is not specified, the copied images are encrypted by a key that AWS owns and manages.</p>
        pub fn set_kms_key_id(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_kms_key_id(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>A set of tags (key-value pairs) that you want to attach to the model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `CreateProject`.
    ///
    /// <p>Creates an empty Amazon Lookout for Vision project. After you create the project, add a dataset by calling
    /// <a>CreateDataset</a>.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:CreateProject</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct CreateProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::create_project_input::Builder,
    }
    impl<C, M, R> CreateProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `CreateProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::CreateProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::CreateProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::CreateProjectInputOperationOutputAlias,
                crate::output::CreateProjectOutput,
                crate::error::CreateProjectError,
                crate::input::CreateProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name for the project.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name for the project.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>CreateProject</code>.
        /// In this case, safely retry your call
        /// to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>CreateProject</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>CreateProject</code>.
        /// In this case, safely retry your call
        /// to <code>CreateProject</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>CreateProject</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteDataset`.
    ///
    /// <p>Deletes an existing Amazon Lookout for Vision <code>dataset</code>. </p>
    /// <p>If your the project has a single
    /// dataset, you must create a new dataset before you can create a model.</p>
    /// <p>If you project has a training dataset and a test dataset consider the following. </p>
    /// <ul>
    /// <li>
    /// <p>If you delete the test dataset, your project reverts to a single dataset project. If you then
    /// train the model, Amazon Lookout for Vision internally splits the remaining dataset into a training and test dataset.</p>
    /// </li>
    /// <li>
    /// <p>If you delete the training dataset, you must create a training dataset before you can create a model.</p>
    /// </li>
    /// </ul>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DeleteDataset</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_dataset_input::Builder,
    }
    impl<C, M, R> DeleteDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteDatasetInputOperationOutputAlias,
                crate::output::DeleteDatasetOutput,
                crate::error::DeleteDatasetError,
                crate::input::DeleteDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to delete.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the dataset that you want to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset.
        /// Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project,
        /// specify <code>train</code>.</p>
        pub fn dataset_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The type of the dataset to delete. Specify <code>train</code> to delete the training dataset.
        /// Specify <code>test</code> to delete the test dataset. To delete the dataset in a single dataset project,
        /// specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>DeleteDataset</code>.
        /// In this case, safely retry your call
        /// to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteDataset</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>DeleteDataset</code>.
        /// In this case, safely retry your call
        /// to <code>DeleteDataset</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>DeleteDataset</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteModel`.
    ///
    /// <p>Deletes an Amazon Lookout for Vision model. You can't delete a running model. To stop a running model,
    /// use the <a>StopModel</a> operation.</p>
    /// <p>It might take a few seconds to delete a model. To determine if a model has been deleted, call
    /// <a>ListProjects</a> and check if the version of the model (<code>ModelVersion</code>) is in the
    /// <code>Models</code> array. </p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DeleteModel</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_model_input::Builder,
    }
    impl<C, M, R> DeleteModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteModelInputOperationOutputAlias,
                crate::output::DeleteModelOutput,
                crate::error::DeleteModelError,
                crate::input::DeleteModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model that you want to delete.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the model that you want to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to delete.</p>
        pub fn model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(inp);
            self
        }
        /// <p>The version of the model that you want to delete.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>DeleteModel</code>.
        /// In this case, safely retry your call
        /// to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>DeleteModel</code>.
        /// In this case, safely retry your call
        /// to <code>DeleteModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>DeleteModel</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DeleteProject`.
    ///
    /// <p>Deletes an Amazon Lookout for Vision project.</p>
    /// <p>To delete a project, you must first delete each version of the model associated with
    /// the project. To delete a model use the <a>DeleteModel</a> operation.</p>
    /// <p>You also have to delete the dataset(s) associated with the model. For more information, see
    /// <a>DeleteDataset</a>.  The images referenced by the training and test datasets aren't deleted.
    /// </p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DeleteProject</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DeleteProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::delete_project_input::Builder,
    }
    impl<C, M, R> DeleteProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DeleteProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DeleteProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DeleteProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DeleteProjectInputOperationOutputAlias,
                crate::output::DeleteProjectOutput,
                crate::error::DeleteProjectError,
                crate::input::DeleteProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project to delete.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project to delete.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>DeleteProject</code>.
        /// In this case, safely retry your call
        /// to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>DeleteProject</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>DeleteProject</code>.
        /// In this case, safely retry your call
        /// to <code>DeleteProject</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>DeleteProject</code>. An idempotency
        /// token is active for 8 hours.</p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeDataset`.
    ///
    /// <p>Describe an Amazon Lookout for Vision dataset.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DescribeDataset</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeDataset<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_dataset_input::Builder,
    }
    impl<C, M, R> DescribeDataset<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeDataset`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeDatasetOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeDatasetError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeDatasetInputOperationOutputAlias,
                crate::output::DescribeDatasetOutput,
                crate::error::DescribeDatasetError,
                crate::input::DescribeDatasetInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to describe.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the dataset that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the
        /// training dataset. Specify <code>test</code> to describe the test dataset.
        /// If you have a single dataset project, specify <code>train</code>
        /// </p>
        pub fn dataset_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The type of the dataset to describe. Specify <code>train</code> to describe the
        /// training dataset. Specify <code>test</code> to describe the test dataset.
        /// If you have a single dataset project, specify <code>train</code>
        /// </p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeModel`.
    ///
    /// <p>Describes a version of an Amazon Lookout for Vision model.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DescribeModel</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_model_input::Builder,
    }
    impl<C, M, R> DescribeModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeModelOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeModelInputOperationOutputAlias,
                crate::output::DescribeModelOutput,
                crate::error::DescribeModelError,
                crate::input::DescribeModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The project that contains the version of a model that you want to describe.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The project that contains the version of a model that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to describe.</p>
        pub fn model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(inp);
            self
        }
        /// <p>The version of the model that you want to describe.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DescribeProject`.
    ///
    /// <p>Describes an Amazon Lookout for Vision project.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DescribeProject</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DescribeProject<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::describe_project_input::Builder,
    }
    impl<C, M, R> DescribeProject<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DescribeProject`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DescribeProjectOutput,
            aws_smithy_http::result::SdkError<crate::error::DescribeProjectError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DescribeProjectInputOperationOutputAlias,
                crate::output::DescribeProjectOutput,
                crate::error::DescribeProjectError,
                crate::input::DescribeProjectInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that you want to describe.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that you want to describe.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
    }
    /// Fluent builder constructing a request to `DetectAnomalies`.
    ///
    /// <p>Detects anomalies in an image that you supply. </p>
    /// <p>The response from <code>DetectAnomalies</code> includes a boolean prediction
    /// that the image contains one or more anomalies and a confidence value for the prediction.</p>
    /// <note>
    /// <p>Before calling <code>DetectAnomalies</code>, you must first start your model with the <a>StartModel</a> operation.
    /// You are charged for the amount of time, in minutes, that a model runs and for the number of anomaly detection units that your
    /// model uses. If you are not using a model, use the <a>StopModel</a> operation to stop your model. </p>
    /// </note>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:DetectAnomalies</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct DetectAnomalies<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::detect_anomalies_input::Builder,
    }
    impl<C, M, R> DetectAnomalies<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `DetectAnomalies`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::DetectAnomaliesOutput,
            aws_smithy_http::result::SdkError<crate::error::DetectAnomaliesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::DetectAnomaliesInputOperationOutputAlias,
                crate::output::DetectAnomaliesOutput,
                crate::error::DetectAnomaliesError,
                crate::input::DetectAnomaliesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model version that you want to use.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the model version that you want to use.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to use.</p>
        pub fn model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(inp);
            self
        }
        /// <p>The version of the model that you want to use.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>The unencrypted image bytes that you want to analyze. </p>
        pub fn body(mut self, inp: aws_smithy_http::byte_stream::ByteStream) -> Self {
            self.inner = self.inner.body(inp);
            self
        }
        /// <p>The unencrypted image bytes that you want to analyze. </p>
        pub fn set_body(
            mut self,
            input: std::option::Option<aws_smithy_http::byte_stream::ByteStream>,
        ) -> Self {
            self.inner = self.inner.set_body(input);
            self
        }
        /// <p>The type of the image passed in <code>Body</code>.
        /// Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
        pub fn content_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.content_type(inp);
            self
        }
        /// <p>The type of the image passed in <code>Body</code>.
        /// Valid values are <code>image/png</code> (PNG format images) and <code>image/jpeg</code> (JPG format images). </p>
        pub fn set_content_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_content_type(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListDatasetEntries`.
    ///
    /// <p>Lists the JSON Lines within a dataset. An Amazon Lookout for Vision JSON Line contains the anomaly
    /// information for a single image, including the image location and the assigned label.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:ListDatasetEntries</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListDatasetEntries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_dataset_entries_input::Builder,
    }
    impl<C, M, R> ListDatasetEntries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::ListDatasetEntriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListDatasetEntriesInputOperationOutputAlias,
                crate::output::ListDatasetEntriesOutput,
                crate::error::ListDatasetEntriesError,
                crate::input::ListDatasetEntriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to list.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the dataset that you want to list.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset that you want to list.  Specify <code>train</code> to list
        /// the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset
        /// project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The type of the dataset that you want to list.  Specify <code>train</code> to list
        /// the training dataset. Specify <code>test</code> to list the test dataset. If you have a single dataset
        /// project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you
        /// don't specify a value, Lookout for Vision returns all entries.</p>
        pub fn labeled(mut self, inp: bool) -> Self {
            self.inner = self.inner.labeled(inp);
            self
        }
        /// <p>Specify <code>true</code> to include labeled entries, otherwise specify <code>false</code>. If you
        /// don't specify a value, Lookout for Vision returns all entries.</p>
        pub fn set_labeled(mut self, input: std::option::Option<bool>) -> Self {
            self.inner = self.inner.set_labeled(input);
            self
        }
        /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include
        /// anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
        pub fn anomaly_class(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.anomaly_class(inp);
            self
        }
        /// <p>Specify <code>normal</code> to include only normal images. Specify <code>anomaly</code> to only include
        /// anomalous entries. If you don't specify a value, Amazon Lookout for Vision returns normal and anomalous images.</p>
        pub fn set_anomaly_class(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_anomaly_class(input);
            self
        }
        /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn before_creation_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.before_creation_date(inp);
            self
        }
        /// <p>Only includes entries before the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn set_before_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_before_creation_date(input);
            self
        }
        /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn after_creation_date(mut self, inp: aws_smithy_types::Instant) -> Self {
            self.inner = self.inner.after_creation_date(inp);
            self
        }
        /// <p>Only includes entries after the specified date in the response. For example, <code>2020-06-23T00:00:00</code>.</p>
        pub fn set_after_creation_date(
            mut self,
            input: std::option::Option<aws_smithy_types::Instant>,
        ) -> Self {
            self.inner = self.inner.set_after_creation_date(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of dataset entries.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of dataset entries.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
        /// <p>Perform a "contains" search on the  values of the <code>source-ref</code> key within the dataset.
        /// For example a value of "IMG_17"  returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
        pub fn source_ref_contains(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.source_ref_contains(inp);
            self
        }
        /// <p>Perform a "contains" search on the  values of the <code>source-ref</code> key within the dataset.
        /// For example a value of "IMG_17"  returns all JSON Lines where the <code>source-ref</code> key value matches <i>*IMG_17*</i>.</p>
        pub fn set_source_ref_contains(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_source_ref_contains(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListModels`.
    ///
    /// <p>Lists the versions of a model in an Amazon Lookout for Vision project.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:ListModels</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListModels<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_models_input::Builder,
    }
    impl<C, M, R> ListModels<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListModels`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListModelsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListModelsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListModelsInputOperationOutputAlias,
                crate::output::ListModelsOutput,
                crate::error::ListModelsError,
                crate::input::ListModelsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model versions that you want to list.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the model versions that you want to list.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of models.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of models.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListProjects`.
    ///
    /// <p>Lists the Amazon Lookout for Vision projects in your AWS account.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:ListProjects</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListProjects<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_projects_input::Builder,
    }
    impl<C, M, R> ListProjects<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListProjects`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListProjectsOutput,
            aws_smithy_http::result::SdkError<crate::error::ListProjectsError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListProjectsInputOperationOutputAlias,
                crate::output::ListProjectsOutput,
                crate::error::ListProjectsError,
                crate::input::ListProjectsInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of projects.</p>
        pub fn next_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.next_token(inp);
            self
        }
        /// <p>If the previous response was incomplete (because there is more data to retrieve),
        /// Amazon Lookout for Vision returns a pagination token in the response. You can use this pagination token to
        /// retrieve the next set of projects.</p>
        pub fn set_next_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_next_token(input);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100.</p>
        pub fn max_results(mut self, inp: i32) -> Self {
            self.inner = self.inner.max_results(inp);
            self
        }
        /// <p>The maximum number of results to return per paginated call. The largest value you can specify is 100.
        /// If you specify a value greater than 100, a ValidationException
        /// error occurs. The default value is 100.</p>
        pub fn set_max_results(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_max_results(input);
            self
        }
    }
    /// Fluent builder constructing a request to `ListTagsForResource`.
    ///
    /// <p>Returns a list of tags attached to the specified Amazon Lookout for Vision model.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:ListTagsForResource</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct ListTagsForResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::list_tags_for_resource_input::Builder,
    }
    impl<C, M, R> ListTagsForResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `ListTagsForResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::ListTagsForResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::ListTagsForResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::ListTagsForResourceInputOperationOutputAlias,
                crate::output::ListTagsForResourceOutput,
                crate::error::ListTagsForResourceError,
                crate::input::ListTagsForResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model for which you want to list tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StartModel`.
    ///
    /// <p>Starts the running of the version of an Amazon Lookout for Vision model. Starting a model takes a while
    /// to complete. To check the current state of the model, use <a>DescribeModel</a>.</p>
    /// <p>A model is ready to use when its status is <code>HOSTED</code>.</p>
    /// <p>Once the model is running, you can detect custom labels in new images by calling
    /// <a>DetectAnomalies</a>.</p>
    /// <note>
    /// <p>You are charged for the amount of time that the model is running. To stop a running
    /// model, call <a>StopModel</a>.</p>
    /// </note>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:StartModel</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct StartModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::start_model_input::Builder,
    }
    impl<C, M, R> StartModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StartModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StartModelOutput,
            aws_smithy_http::result::SdkError<crate::error::StartModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StartModelInputOperationOutputAlias,
                crate::output::StartModelOutput,
                crate::error::StartModelError,
                crate::input::StartModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model that you want to start.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the model that you want to start.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to start.</p>
        pub fn model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(inp);
            self
        }
        /// <p>The version of the model that you want to start.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>The minimum number of inference units to use. A single
        /// inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
        /// Use a higher number to increase the TPS throughput of your model. You are charged for the number
        /// of inference units that you use.
        /// </p>
        pub fn min_inference_units(mut self, inp: i32) -> Self {
            self.inner = self.inner.min_inference_units(inp);
            self
        }
        /// <p>The minimum number of inference units to use. A single
        /// inference unit represents 1 hour of processing and can support up to 5 Transaction Pers Second (TPS).
        /// Use a higher number to increase the TPS throughput of your model. You are charged for the number
        /// of inference units that you use.
        /// </p>
        pub fn set_min_inference_units(mut self, input: std::option::Option<i32>) -> Self {
            self.inner = self.inner.set_min_inference_units(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>StartModel</code>.
        /// In this case, safely retry your call
        /// to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency
        /// token is active for 8 hours.
        /// </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StartModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>StartModel</code>.
        /// In this case, safely retry your call
        /// to <code>StartModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>StartModel</code>. An idempotency
        /// token is active for 8 hours.
        /// </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `StopModel`.
    ///
    /// <p>Stops the hosting of a running model. The operation might take a while to complete. To
    /// check the current status, call <a>DescribeModel</a>. </p>
    /// <p>After the model hosting stops, the <code>Status</code> of the model is <code>TRAINED</code>.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:StopModel</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct StopModel<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::stop_model_input::Builder,
    }
    impl<C, M, R> StopModel<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `StopModel`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::StopModelOutput,
            aws_smithy_http::result::SdkError<crate::error::StopModelError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::StopModelInputOperationOutputAlias,
                crate::output::StopModelOutput,
                crate::error::StopModelError,
                crate::input::StopModelInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the model that you want to stop.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the model that you want to stop.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The version of the model that you want to stop.</p>
        pub fn model_version(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.model_version(inp);
            self
        }
        /// <p>The version of the model that you want to stop.</p>
        pub fn set_model_version(
            mut self,
            input: std::option::Option<std::string::String>,
        ) -> Self {
            self.inner = self.inner.set_model_version(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>StopModel</code>.
        /// In this case, safely retry your call
        /// to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency
        /// token is active for 8 hours.
        ///
        ///
        /// </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>StopModel</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>StopModel</code>.
        /// In this case, safely retry your call
        /// to <code>StopModel</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>StopModel</code>. An idempotency
        /// token is active for 8 hours.
        ///
        ///
        /// </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
    /// Fluent builder constructing a request to `TagResource`.
    ///
    /// <p>Adds one or more key-value tags to an Amazon Lookout for Vision model.
    /// For more information, see <i>Tagging a model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>. </p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:TagResource</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct TagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::tag_resource_input::Builder,
    }
    impl<C, M, R> TagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `TagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::TagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::TagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::TagResourceInputOperationOutputAlias,
                crate::output::TagResourceOutput,
                crate::error::TagResourceError,
                crate::input::TagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model to assign the tags.</p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `Tags`.
        ///
        /// To override the contents of this collection use [`set_tags`](Self::set_tags).
        ///
        /// <p>The key-value tags to assign to the model.</p>
        pub fn tags(mut self, inp: impl Into<crate::model::Tag>) -> Self {
            self.inner = self.inner.tags(inp);
            self
        }
        /// <p>The key-value tags to assign to the model.</p>
        pub fn set_tags(
            mut self,
            input: std::option::Option<std::vec::Vec<crate::model::Tag>>,
        ) -> Self {
            self.inner = self.inner.set_tags(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UntagResource`.
    ///
    /// <p>Removes one or more tags from an Amazon Lookout for Vision model. For more information, see
    /// <i>Tagging a model</i> in the <i>Amazon Lookout for Vision Developer Guide</i>. </p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:UntagResource</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UntagResource<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::untag_resource_input::Builder,
    }
    impl<C, M, R> UntagResource<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UntagResource`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UntagResourceOutput,
            aws_smithy_http::result::SdkError<crate::error::UntagResourceError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UntagResourceInputOperationOutputAlias,
                crate::output::UntagResourceOutput,
                crate::error::UntagResourceError,
                crate::input::UntagResourceInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
        pub fn resource_arn(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.resource_arn(inp);
            self
        }
        /// <p>The Amazon Resource Name (ARN) of the model from which you want to remove tags. </p>
        pub fn set_resource_arn(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_resource_arn(input);
            self
        }
        /// Appends an item to `TagKeys`.
        ///
        /// To override the contents of this collection use [`set_tag_keys`](Self::set_tag_keys).
        ///
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn tag_keys(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.tag_keys(inp);
            self
        }
        /// <p>A list of the keys of the tags that you want to remove.</p>
        pub fn set_tag_keys(
            mut self,
            input: std::option::Option<std::vec::Vec<std::string::String>>,
        ) -> Self {
            self.inner = self.inner.set_tag_keys(input);
            self
        }
    }
    /// Fluent builder constructing a request to `UpdateDatasetEntries`.
    ///
    /// <p>Adds one or more JSON Line entries to a dataset. A JSON Line includes information about an image
    /// used for training or testing an Amazon Lookout for Vision model. The following is an example JSON Line.</p>
    ///
    ///
    /// <p>Updating a dataset might take a while to complete. To check the current status, call <a>DescribeDataset</a> and
    /// check the <code>Status</code> field in the response.</p>
    /// <p>This operation requires permissions to perform the
    /// <code>lookoutvision:UpdateDatasetEntries</code> operation.</p>
    #[derive(std::fmt::Debug)]
    pub struct UpdateDatasetEntries<
        C = aws_smithy_client::erase::DynConnector,
        M = aws_hyper::AwsMiddleware,
        R = aws_smithy_client::retry::Standard,
    > {
        handle: std::sync::Arc<super::Handle<C, M, R>>,
        inner: crate::input::update_dataset_entries_input::Builder,
    }
    impl<C, M, R> UpdateDatasetEntries<C, M, R>
    where
        C: aws_smithy_client::bounds::SmithyConnector,
        M: aws_smithy_client::bounds::SmithyMiddleware<C>,
        R: aws_smithy_client::retry::NewRequestPolicy,
    {
        /// Creates a new `UpdateDatasetEntries`.
        pub(crate) fn new(handle: std::sync::Arc<super::Handle<C, M, R>>) -> Self {
            Self {
                handle,
                inner: Default::default(),
            }
        }

        /// Sends the request and returns the response.
        ///
        /// If an error occurs, an `SdkError` will be returned with additional details that
        /// can be matched against.
        ///
        /// By default, any retryable failures will be retried twice. Retry behavior
        /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
        /// set when configuring the client.
        pub async fn send(
            self,
        ) -> std::result::Result<
            crate::output::UpdateDatasetEntriesOutput,
            aws_smithy_http::result::SdkError<crate::error::UpdateDatasetEntriesError>,
        >
        where
            R::Policy: aws_smithy_client::bounds::SmithyRetryPolicy<
                crate::input::UpdateDatasetEntriesInputOperationOutputAlias,
                crate::output::UpdateDatasetEntriesOutput,
                crate::error::UpdateDatasetEntriesError,
                crate::input::UpdateDatasetEntriesInputOperationRetryAlias,
            >,
        {
            let input = self.inner.build().map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            let op = input.make_operation(&self.handle.conf).map_err(|err| {
                aws_smithy_http::result::SdkError::ConstructionFailure(err.into())
            })?;
            self.handle.client.call(op).await
        }
        /// <p>The name of the project that contains the dataset that you want to update.</p>
        pub fn project_name(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.project_name(inp);
            self
        }
        /// <p>The name of the project that contains the dataset that you want to update.</p>
        pub fn set_project_name(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_project_name(input);
            self
        }
        /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update
        /// the training dataset. Specify <code>test</code> to update the test dataset. If you
        /// have a single dataset project, specify <code>train</code>.</p>
        pub fn dataset_type(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.dataset_type(inp);
            self
        }
        /// <p>The type of the dataset that you want to update. Specify <code>train</code> to update
        /// the training dataset. Specify <code>test</code> to update the test dataset. If you
        /// have a single dataset project, specify <code>train</code>.</p>
        pub fn set_dataset_type(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_dataset_type(input);
            self
        }
        /// <p>The entries to add to the dataset.</p>
        pub fn changes(mut self, inp: aws_smithy_types::Blob) -> Self {
            self.inner = self.inner.changes(inp);
            self
        }
        /// <p>The entries to add to the dataset.</p>
        pub fn set_changes(mut self, input: std::option::Option<aws_smithy_types::Blob>) -> Self {
            self.inner = self.inner.set_changes(input);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>UpdateDatasetEntries</code>.
        /// In this case, safely retry your call
        /// to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency
        /// token is active for 8 hours.
        /// </p>
        pub fn client_token(mut self, inp: impl Into<std::string::String>) -> Self {
            self.inner = self.inner.client_token(inp);
            self
        }
        /// <p>ClientToken is an idempotency token that ensures a call to <code>UpdateDatasetEntries</code>
        /// completes only once.  You choose the value to pass. For example, An issue,
        /// such as an network outage, might prevent you from getting a response from <code>UpdateDatasetEntries</code>.
        /// In this case, safely retry your call
        /// to <code>UpdateDatasetEntries</code> by using the same <code>ClientToken</code> parameter value. An error occurs
        /// if the other input parameters are not the same as in the first request. Using a different  
        /// value for <code>ClientToken</code> is considered a new call to <code>UpdateDatasetEntries</code>. An idempotency
        /// token is active for 8 hours.
        /// </p>
        pub fn set_client_token(mut self, input: std::option::Option<std::string::String>) -> Self {
            self.inner = self.inner.set_client_token(input);
            self
        }
    }
}
impl<C> Client<C, aws_hyper::AwsMiddleware, aws_smithy_client::retry::Standard> {
    /// Creates a client with the given service config and connector override.
    pub fn from_conf_conn(conf: crate::Config, conn: C) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::new(conn).with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
impl
    Client<
        aws_smithy_client::erase::DynConnector,
        aws_hyper::AwsMiddleware,
        aws_smithy_client::retry::Standard,
    >
{
    /// Creates a new client from a shared config.
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn new(config: &aws_types::config::Config) -> Self {
        Self::from_conf(config.into())
    }

    /// Creates a new client from the service [`Config`](crate::Config).
    #[cfg(any(feature = "rustls", feature = "native-tls"))]
    pub fn from_conf(conf: crate::Config) -> Self {
        let retry_config = conf.retry_config.as_ref().cloned().unwrap_or_default();
        let client = aws_hyper::Client::https().with_retry_config(retry_config.into());
        Self {
            handle: std::sync::Arc::new(Handle { client, conf }),
        }
    }
}
